/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IParameterizable;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    public static final String NULL_VALUE = "null";

    public static Object[] createInstantiationParameters(Constructor ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, finder, parameterNames, new MethodParameters(params), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        return Parameters.createParameters(m, new MethodParameters(params, currentTestMeth, ctx), finder, xmlSuite, IConfiguration.class, "@Configuration");
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String[] optionalValues, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            ArrayList<Object> vResult = new ArrayList<Object>();
            Parameters.checkParameterTypes(methodName, parameterTypes, methodAnnotation, parameterNames);
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (Method.class.equals((Object)parameterTypes[i])) {
                    vResult.add(params.currentTestMethod);
                    continue;
                }
                if (ITestContext.class.equals((Object)parameterTypes[i])) {
                    vResult.add(params.context);
                    continue;
                }
                String p = parameterNames[j];
                String value = (String)params.xmlParameters.get(p);
                if (null == value) {
                    value = System.getProperty(p);
                }
                if (null == value) {
                    if (optionalValues != null) {
                        value = optionalValues[i];
                    }
                    if (null == value) {
                        throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on method " + methodName + "\nbut has not been marked @Optional or defined " + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                    }
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static void checkParameterTypes(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        if (parameterNames.length == parameterTypes.length) {
            return;
        }
        for (int i = parameterTypes.length - 1; i >= parameterNames.length; --i) {
            if (ITestContext.class.equals((Object)parameterTypes[i]) || Method.class.equals((Object)parameterTypes[i])) continue;
            throw new TestNGException("Method " + methodName + " requires " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
        }
    }

    public static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
            }
            return null;
        }
        if (type == String.class) {
            result = value;
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = new Integer(Integer.parseInt(value));
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = Boolean.valueOf(value);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = new Byte(Byte.parseByte(value));
        } else if (type == Character.TYPE || type == Character.class) {
            result = new Character(value.charAt(0));
        } else if (type == Double.TYPE || type == Double.class) {
            result = new Double(Double.parseDouble(value));
        } else if (type == Float.TYPE || type == Float.class) {
            result = new Float(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == Long.class) {
            result = new Long(Long.parseLong(value));
        } else if (type == Short.TYPE || type == Short.class) {
            result = new Short(Short.parseShort(value));
        } else assert (false) : "Unsupported type parameter : " + type;
        return result;
    }

    private static Method findDataProvider(Class clazz, Method m, IAnnotationFinder finder) {
        IFactory factory;
        Method result = null;
        String dataProviderName = null;
        Class<?> dataProviderClass = null;
        ITest annotation = AnnotationHelper.findTest(finder, m);
        if (annotation != null) {
            dataProviderName = annotation.getDataProvider();
            dataProviderClass = annotation.getDataProviderClass();
        }
        if (dataProviderName == null && (factory = AnnotationHelper.findFactory(finder, m)) != null) {
            dataProviderName = factory.getDataProvider();
            dataProviderClass = null;
        }
        if (null != dataProviderName && !"".equals(dataProviderName) && null == (result = Parameters.findDataProvider(clazz, finder, dataProviderName, dataProviderClass))) {
            throw new TestNGException("Method " + m + " requires a @DataProvider named : " + dataProviderName + (dataProviderClass != null ? " in class " + dataProviderClass.getName() : ""));
        }
        return result;
    }

    private static Method findDataProvider(Class cls, IAnnotationFinder finder, String name, Class dataProviderClass) {
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            IDataProvider dp = (IDataProvider)finder.findAnnotation(m, IDataProvider.class);
            if (null == dp || !name.equals(dp.getName()) && !name.equals(m.getName())) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                throw new TestNGException("DataProvider should be static: " + m);
            }
            return m;
        }
        return null;
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] extraParameters = new Object[]{};
        IParameters annotation = (IParameters)finder.findAnnotation(m, IParameters.class);
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            extraParameters = Parameters.createParameters(m.getName(), m.getParameterTypes(), finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a && a.getParameters().length > 0) {
                String[] parameterNames = a.getParameters();
                extraParameters = Parameters.createParameters(m.getName(), m.getParameterTypes(), finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
            } else {
                extraParameters = Parameters.createParameters(m.getName(), m.getParameterTypes(), finder.findOptionalValues(m), atName, finder, new String[0], params, xmlSuite);
            }
        }
        for (Object p : extraParameters) {
            result.add(p);
        }
        return result.toArray(new Object[result.size()]);
    }

    public static Iterator<Object[]> handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance) {
        Iterator<Object[]> result = null;
        Method dataProvider = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getMethod(), annotationFinder);
        if (null != dataProvider) {
            int parameterCount = testMethod.getMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            result = MethodHelper.invokeDataProvider(instance, dataProvider, testMethod, methodParams.context, fedInstance, annotationFinder);
        } else {
            allParameterNames.putAll(methodParams.xmlParameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getMethod(), methodParams, annotationFinder, xmlSuite, ITest.class, "@Test")};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            result = MethodHelper.createArrayIterator(allParameterValuesArray);
        }
        return result;
    }

    private static void ppp(String s) {
        System.out.println("[Parameters] " + s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;

        public MethodParameters(Map<String, String> params) {
            this(params, null, null);
        }

        public MethodParameters(Map<String, String> params, Method m) {
            this(params, m, null);
        }

        public MethodParameters(Map<String, String> params, Method m, ITestContext ctx) {
            this.xmlParameters = params;
            this.currentTestMethod = m;
            this.context = ctx;
        }
    }
}

