// HyperRogue patterns

// Copyright (C) 2011-2016 Zeno Rogue, see 'hyper.cpp' for details

// === EMERALD PATTERN ===

// rules for the emeraldvalues of heptagons.
int emerald_heptagon(int parent, int dir) {

  // no emeraldgen here
  if(parent == 0) return 0;

  #define RULE(t1,s1,d,t2,s2) \
    if(parent == t1*8+s1 && dir == d) return t2*8+s2;

  RULE(8,0,3,12,4)
  RULE(8,0,4,12,0)
  RULE(8,0,5,42,0)
  RULE(8,1,3,40,0)
  RULE(8,1,4,12,4)
  RULE(8,1,5,12,0)
  RULE(8,2,3,34,0)
  RULE(8,2,4,40,0)
  RULE(8,2,5,12,4)
  RULE(8,3,3,10,0)
  RULE(8,3,4,34,0)
  RULE(8,3,5,40,0)
  RULE(8,4,3,32,0)
  RULE(8,4,4,10,0)
  RULE(8,4,5,34,0)
  RULE(8,5,3,42,0)
  RULE(8,5,4,32,0)
  RULE(8,5,5,10,0)
  RULE(8,6,3,12,0)
  RULE(8,6,4,42,0)
  RULE(8,6,5,32,0)
  RULE(9,0,3,13,4)
  RULE(9,0,4,13,0)
  RULE(9,0,5,43,0)
  RULE(9,1,3,41,0)
  RULE(9,1,4,13,4)
  RULE(9,1,5,13,0)
  RULE(9,2,3,35,0)
  RULE(9,2,4,41,0)
  RULE(9,2,5,13,4)
  RULE(9,3,3,11,0)
  RULE(9,3,4,35,0)
  RULE(9,3,5,41,0)
  RULE(9,4,3,33,0)
  RULE(9,4,4,11,0)
  RULE(9,4,5,35,0)
  RULE(9,5,3,43,0)
  RULE(9,5,4,33,0)
  RULE(9,5,5,11,0)
  RULE(9,6,3,13,0)
  RULE(9,6,4,43,0)
  RULE(9,6,5,33,0)
  RULE(10,0,3,14,4)
  RULE(10,0,4,14,0)
  RULE(10,0,5,40,3)
  RULE(10,1,3,42,4)
  RULE(10,1,4,14,4)
  RULE(10,1,5,14,0)
  RULE(10,2,3,32,1)
  RULE(10,2,4,42,4)
  RULE(10,2,5,14,4)
  RULE(10,3,3,8,0)
  RULE(10,3,4,32,1)
  RULE(10,3,5,42,4)
  RULE(10,4,3,34,6)
  RULE(10,4,4,8,0)
  RULE(10,4,5,32,1)
  RULE(10,5,3,40,3)
  RULE(10,5,4,34,6)
  RULE(10,5,5,8,0)
  RULE(10,6,3,14,0)
  RULE(10,6,4,40,3)
  RULE(10,6,5,34,6)
  RULE(11,0,3,15,4)
  RULE(11,0,4,15,0)
  RULE(11,0,5,41,3)
  RULE(11,1,3,43,4)
  RULE(11,1,4,15,4)
  RULE(11,1,5,15,0)
  RULE(11,2,3,33,1)
  RULE(11,2,4,43,4)
  RULE(11,2,5,15,4)
  RULE(11,3,3,9,0)
  RULE(11,3,4,33,1)
  RULE(11,3,5,43,4)
  RULE(11,4,3,35,6)
  RULE(11,4,4,9,0)
  RULE(11,4,5,33,1)
  RULE(11,5,3,41,3)
  RULE(11,5,4,35,6)
  RULE(11,5,5,9,0)
  RULE(11,6,3,15,0)
  RULE(11,6,4,41,3)
  RULE(11,6,5,35,6)
  RULE(12,0,3,8,4)
  RULE(12,0,4,40,1)
  RULE(12,0,5,14,2)
  RULE(12,1,3,12,6)
  RULE(12,1,4,8,4)
  RULE(12,1,5,40,1)
  RULE(12,2,0,14,2)
  RULE(12,2,1,42,6)
  RULE(12,2,2,8,3)
  RULE(12,2,3,12,5)
  RULE(12,2,4,12,6)
  RULE(12,2,5,8,4)
  RULE(12,2,6,40,1)
  RULE(12,3,3,8,3)
  RULE(12,3,4,12,5)
  RULE(12,3,5,12,6)
  RULE(12,4,3,42,6)
  RULE(12,4,4,8,3)
  RULE(12,4,5,12,5)
  RULE(12,5,3,14,2)
  RULE(12,5,4,42,6)
  RULE(12,5,5,8,3)
  RULE(12,6,3,40,1)
  RULE(12,6,4,14,2)
  RULE(12,6,5,42,6)
  RULE(13,0,3,9,4)
  RULE(13,0,4,41,1)
  RULE(13,0,5,15,2)
  RULE(13,1,3,13,6)
  RULE(13,1,4,9,4)
  RULE(13,1,5,41,1)
  RULE(13,2,3,13,5)
  RULE(13,2,4,13,6)
  RULE(13,2,5,9,4)
  RULE(13,3,3,9,3)
  RULE(13,3,4,13,5)
  RULE(13,3,5,13,6)
  RULE(13,4,3,43,6)
  RULE(13,4,4,9,3)
  RULE(13,4,5,13,5)
  RULE(13,5,3,15,2)
  RULE(13,5,4,43,6)
  RULE(13,5,5,9,3)
  RULE(13,6,3,41,1)
  RULE(13,6,4,15,2)
  RULE(13,6,5,43,6)
  RULE(14,0,3,10,4)
  RULE(14,0,4,42,5)
  RULE(14,0,5,12,2)
  RULE(14,1,3,14,6)
  RULE(14,1,4,10,4)
  RULE(14,1,5,42,5)
  RULE(14,2,0,12,2)
  RULE(14,2,3,14,5)
  RULE(14,2,4,14,6)
  RULE(14,2,5,10,4)
  RULE(14,3,3,10,3)
  RULE(14,3,4,14,5)
  RULE(14,3,5,14,6)
  RULE(14,4,3,40,2)
  RULE(14,4,4,10,3)
  RULE(14,4,5,14,5)
  RULE(14,5,3,12,2)
  RULE(14,5,4,40,2)
  RULE(14,5,5,10,3)
  RULE(14,6,3,42,5)
  RULE(14,6,4,12,2)
  RULE(14,6,5,40,2)
  RULE(15,0,3,11,4)
  RULE(15,0,4,43,5)
  RULE(15,0,5,13,2)
  RULE(15,1,3,15,6)
  RULE(15,1,4,11,4)
  RULE(15,1,5,43,5)
  RULE(15,2,3,15,5)
  RULE(15,2,4,15,6)
  RULE(15,2,5,11,4)
  RULE(15,3,3,11,3)
  RULE(15,3,4,15,5)
  RULE(15,3,5,15,6)
  RULE(15,4,3,41,2)
  RULE(15,4,4,11,3)
  RULE(15,4,5,15,5)
  RULE(15,5,3,13,2)
  RULE(15,5,4,41,2)
  RULE(15,5,5,11,3)
  RULE(15,6,3,43,5)
  RULE(15,6,4,13,2)
  RULE(15,6,5,41,2)
  RULE(32,0,3,43,2)
  RULE(32,0,4,33,3)
  RULE(32,0,5,42,3)
  RULE(32,1,3,33,5)
  RULE(32,1,4,43,2)
  RULE(32,1,5,33,3)
  RULE(32,2,3,42,1)
  RULE(32,2,4,33,5)
  RULE(32,2,5,43,2)
  RULE(32,3,3,8,1)
  RULE(32,3,4,42,1)
  RULE(32,3,5,33,5)
  RULE(32,4,3,10,6)
  RULE(32,4,4,8,1)
  RULE(32,4,5,42,1)
  RULE(32,5,3,42,3)
  RULE(32,5,4,10,6)
  RULE(32,5,5,8,1)
  RULE(32,6,3,33,3)
  RULE(32,6,4,42,3)
  RULE(32,6,5,10,6)
  RULE(33,0,3,42,2)
  RULE(33,0,4,32,3)
  RULE(33,0,5,43,3)
  RULE(33,1,3,32,5)
  RULE(33,1,4,42,2)
  RULE(33,1,5,32,3)
  RULE(33,2,3,43,1)
  RULE(33,2,4,32,5)
  RULE(33,2,5,42,2)
  RULE(33,3,3,9,1)
  RULE(33,3,4,43,1)
  RULE(33,3,5,32,5)
  RULE(33,4,3,11,6)
  RULE(33,4,4,9,1)
  RULE(33,4,5,43,1)
  RULE(33,5,3,43,3)
  RULE(33,5,4,11,6)
  RULE(33,5,5,9,1)
  RULE(33,6,3,32,3)
  RULE(33,6,4,43,3)
  RULE(33,6,5,11,6)
  RULE(34,0,3,35,4)
  RULE(34,0,4,41,5)
  RULE(34,0,5,35,2)
  RULE(34,1,3,40,4)
  RULE(34,1,4,35,4)
  RULE(34,1,5,41,5)
  RULE(34,2,3,10,1)
  RULE(34,2,4,40,4)
  RULE(34,2,5,35,4)
  RULE(34,3,3,8,6)
  RULE(34,3,4,10,1)
  RULE(34,3,5,40,4)
  RULE(34,4,3,40,6)
  RULE(34,4,4,8,6)
  RULE(34,4,5,10,1)
  RULE(34,5,3,35,2)
  RULE(34,5,4,40,6)
  RULE(34,5,5,8,6)
  RULE(34,6,3,41,5)
  RULE(34,6,4,35,2)
  RULE(34,6,5,40,6)
  RULE(35,0,3,34,4)
  RULE(35,0,4,40,5)
  RULE(35,0,5,34,2)
  RULE(35,1,3,41,4)
  RULE(35,1,4,34,4)
  RULE(35,1,5,40,5)
  RULE(35,2,3,11,1)
  RULE(35,2,4,41,4)
  RULE(35,2,5,34,4)
  RULE(35,3,3,9,6)
  RULE(35,3,4,11,1)
  RULE(35,3,5,41,4)
  RULE(35,4,3,41,6)
  RULE(35,4,4,9,6)
  RULE(35,4,5,11,1)
  RULE(35,5,3,34,2)
  RULE(35,5,4,41,6)
  RULE(35,5,5,9,6)
  RULE(35,6,3,40,5)
  RULE(35,6,4,34,2)
  RULE(35,6,5,41,6)
  RULE(40,0,3,34,5)
  RULE(40,0,4,10,2)
  RULE(40,0,5,14,1)
  RULE(40,1,3,35,3)
  RULE(40,1,4,34,5)
  RULE(40,1,5,10,2)
  RULE(40,2,3,34,1)
  RULE(40,2,4,35,3)
  RULE(40,2,5,34,5)
  RULE(40,3,3,8,5)
  RULE(40,3,4,34,1)
  RULE(40,3,5,35,3)
  RULE(40,4,3,12,3)
  RULE(40,4,4,8,5)
  RULE(40,4,5,34,1)
  RULE(40,5,3,14,1)
  RULE(40,5,4,12,3)
  RULE(40,5,5,8,5)
  RULE(40,6,3,10,2)
  RULE(40,6,4,14,1)
  RULE(40,6,5,12,3)
  RULE(41,0,3,35,5)
  RULE(41,0,4,11,2)
  RULE(41,0,5,15,1)
  RULE(41,1,3,34,3)
  RULE(41,1,4,35,5)
  RULE(41,1,5,11,2)
  RULE(41,2,3,35,1)
  RULE(41,2,4,34,3)
  RULE(41,2,5,35,5)
  RULE(41,3,3,9,5)
  RULE(41,3,4,35,1)
  RULE(41,3,5,34,3)
  RULE(41,4,3,13,3)
  RULE(41,4,4,9,5)
  RULE(41,4,5,35,1)
  RULE(41,5,3,15,1)
  RULE(41,5,4,13,3)
  RULE(41,5,5,9,5)
  RULE(41,6,3,11,2)
  RULE(41,6,4,15,1)
  RULE(41,6,5,13,3)
  RULE(42,0,3,10,5)
  RULE(42,0,4,32,2)
  RULE(42,0,5,33,4)
  RULE(42,1,3,14,3)
  RULE(42,1,4,10,5)
  RULE(42,1,5,32,2)
  RULE(42,2,3,12,1)
  RULE(42,2,4,14,3)
  RULE(42,2,5,10,5)
  RULE(42,3,3,8,2)
  RULE(42,3,4,12,1)
  RULE(42,3,5,14,3)
  RULE(42,4,3,32,6)
  RULE(42,4,4,8,2)
  RULE(42,4,5,12,1)
  RULE(42,5,3,33,4)
  RULE(42,5,4,32,6)
  RULE(42,5,5,8,2)
  RULE(42,6,3,32,2)
  RULE(42,6,4,33,4)
  RULE(42,6,5,32,6)
  RULE(43,0,3,11,5)
  RULE(43,0,4,33,2)
  RULE(43,0,5,32,4)
  RULE(43,1,3,15,3)
  RULE(43,1,4,11,5)
  RULE(43,1,5,33,2)
  RULE(43,2,3,13,1)
  RULE(43,2,4,15,3)
  RULE(43,2,5,11,5)
  RULE(43,3,3,9,2)
  RULE(43,3,4,13,1)
  RULE(43,3,5,15,3)
  RULE(43,4,3,33,6)
  RULE(43,4,4,9,2)
  RULE(43,4,5,13,1)
  RULE(43,5,3,32,4)
  RULE(43,5,4,33,6)
  RULE(43,5,5,9,2)
  RULE(43,6,3,33,2)
  RULE(43,6,4,32,4)
  RULE(43,6,5,33,6)
  
  #undef RULE

  printf("HEPTAGONAL RULE MISSING for (%d,%d)\n", parent,dir);
  exit(1);
  }

// calculate the emeraldvalue of a hexagonal cell,
// based on the emeraldvalues of the neighbor heptacells.
int emerald_hexagon(int a, int b, int c) {
  // pick the lexicographically smallest representation of the cycle
  if(b <= a || c<a) { int t=a; a=b; b=c; c=t; }
  if(b <= a || c<a) { int t=a; a=b; b=c; c=t; }

  if(a==8 && b == 10 && c== 34) return 30; 
  if(a==8 && b == 12 && c== 12) return 4;  
  if(a==8 && b == 12 && c== 42) return 48; 
  if(a==8 && b == 32 && c== 10) return 28; 
  if(a==8 && b == 34 && c== 40) return 20; 
  if(a==8 && b == 40 && c== 12) return 16; 
  if(a==8 && b == 42 && c== 32) return 52; 
  if(a==9 && b == 11 && c== 35) return 31; 
  if(a==9 && b == 13 && c== 13) return 5;  
  if(a==9 && b == 13 && c== 43) return 49; 
  if(a==9 && b == 33 && c== 11) return 29; 
  if(a==9 && b == 35 && c== 41) return 21; 
  if(a==9 && b == 41 && c== 13) return 17; 
  if(a==9 && b == 43 && c== 33) return 53;
  if(a==10 && b == 14 && c== 14) return 6; 
  if(a==10 && b == 14 && c== 40) return 50;
  if(a==10 && b == 32 && c== 42) return 22;
  if(a==10 && b == 40 && c== 34) return 54;
  if(a==10 && b == 42 && c== 14) return 18;
  if(a==11 && b == 15 && c== 15) return 7; 
  if(a==11 && b == 15 && c== 41) return 51;
  if(a==11 && b == 33 && c== 43) return 23;
  if(a==11 && b == 41 && c== 35) return 55;
  if(a==11 && b == 43 && c== 15) return 19;
  if(a==12 && b == 12 && c== 12) return 44;
  if(a==12 && b == 14 && c== 42) return 38;
  if(a==12 && b == 40 && c== 14) return 36;
  if(a==13 && b == 13 && c== 13) return 45;
  if(a==13 && b == 15 && c== 43) return 39;
  if(a==13 && b == 41 && c== 15) return 37;
  if(a==14 && b == 14 && c== 14) return 46;
  if(a==15 && b == 15 && c== 15) return 47;
  if(a==32 && b == 33 && c== 42) return 26;
  if(a==32 && b == 33 && c== 43) return 57;
  if(a==32 && b == 42 && c== 33) return 56;
  if(a==32 && b == 43 && c== 33) return 27;
  if(a==34 && b == 35 && c== 40) return 24;
  if(a==34 && b == 35 && c== 41) return 59;
  if(a==34 && b == 40 && c== 35) return 58;
  if(a==34 && b == 41 && c== 35) return 25;
  printf("HEXAGONAL RULE MISSING for (%d,%d,%d)\n", a,b,c);
  return 0;
  // exit(1);
  }

int emeraldtable[100][7] = {
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {12,44,12,48,8,16,0,},
  {13,49,9,17,13,45,0,},
  {14,46,14,50,10,18,0,},
  {11,19,15,47,15,51,0,},
  {16,4,48,52,28,30,20,},
  {21,17,5,49,53,29,31,},
  {54,30,28,22,18,6,50,},
  {51,55,31,29,23,19,7,},
  {4,44,4,16,36,38,48,},
  {45,5,17,37,39,49,5,},
  {18,38,36,50,6,46,6,},
  {7,47,7,19,39,37,51,},
  {40,36,12,4,8,20,0,},
  {13,5,9,21,41,37,0,},
  {42,38,14,6,10,22,0,},
  {43,39,15,7,11,23,0,},
  {40,16,8,30,34,24,0,},
  {9,31,35,25,41,17,0,},
  {42,18,10,28,32,26,0,},
  {33,27,43,19,11,29,0,},
  {40,20,34,25,35,58,0,},
  {35,24,34,59,41,21,0,},
  {33,56,42,22,32,27,0,},
  {33,26,32,57,43,23,0,},
  {32,22,10,30,8,52,0,},
  {33,23,11,31,9,53,0,},
  {8,28,10,54,34,20,0,},
  {11,55,35,21,9,29,0,},
  {52,56,57,27,26,22,28,},
  {27,23,29,53,57,56,26,},
  {58,59,25,24,20,30,54,},
  {21,31,55,59,58,24,25,},
  {40,50,14,38,12,16,0,},
  {15,39,13,17,41,51,0,},
  {42,48,12,36,14,18,0,},
  {43,49,13,37,15,19,0,},
  {16,20,24,58,54,50,36,},
  {21,25,59,55,51,37,17,},
  {38,18,22,26,56,52,48,},
  {49,39,19,23,27,57,53,},
  {12,4,12,4,12,4,0,},
  {13,5,13,5,13,5,0,},
  {14,6,14,6,14,6,0,},
  {15,7,15,7,15,7,0,},
  {8,4,12,38,42,52,0,},
  {43,53,9,5,13,39,0,},
  {10,6,14,36,40,54,0,},
  {11,7,15,37,41,55,0,},
  {32,28,8,48,42,56,0,},
  {33,29,9,49,43,57,0,},
  {34,30,10,50,40,58,0,},
  {11,51,41,59,35,31,0,},
  {32,52,42,26,33,57,0,},
  {32,56,33,53,43,27,0,},
  {34,54,40,24,35,59,0,},
  {34,58,35,55,41,25,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  {0,0,0,0,0,0,0,},
  };

// == ELEMENTAL PATTERN ==

#define RULE50(a,b,c,d,e,f,g,h) {b,c,d,e,f,g,h},

int fiftytable[480][7] = {
RULE50(0x000, 0x020, 0x0e0, 0x0c0, 0x0a0, 0x080, 0x060, 0x040)
RULE50(0x001, 0x021, 0x0e1, 0x0c1, 0x0a1, 0x081, 0x061, 0x041)
RULE50(0x002, 0x022, 0x0e2, 0x0c2, 0x0a2, 0x082, 0x062, 0x042)
RULE50(0x003, 0x023, 0x0e3, 0x0c3, 0x0a3, 0x083, 0x063, 0x043)
RULE50(0x004, 0x024, 0x0e4, 0x0c4, 0x0a4, 0x084, 0x064, 0x044)
RULE50(0x005, 0x025, 0x0e5, 0x0c5, 0x0a5, 0x085, 0x065, 0x045)
RULE50(0x006, 0x026, 0x0e6, 0x0c6, 0x0a6, 0x086, 0x066, 0x046)
RULE50(0x007, 0x027, 0x0e7, 0x0c7, 0x0a7, 0x087, 0x067, 0x047)
RULE50(0x008, 0x028, 0x048, 0x068, 0x088, 0x0a8, 0x0c8, 0x0e8)
RULE50(0x009, 0x029, 0x049, 0x069, 0x089, 0x0a9, 0x0c9, 0x0e9)
RULE50(0x00a, 0x02a, 0x04a, 0x06a, 0x08a, 0x0aa, 0x0ca, 0x0ea)
RULE50(0x00b, 0x02b, 0x04b, 0x06b, 0x08b, 0x0ab, 0x0cb, 0x0eb)
RULE50(0x00c, 0x02c, 0x04c, 0x06c, 0x08c, 0x0ac, 0x0cc, 0x0ec)
RULE50(0x00d, 0x02d, 0x04d, 0x06d, 0x08d, 0x0ad, 0x0cd, 0x0ed)
RULE50(0x00e, 0x02e, 0x04e, 0x06e, 0x08e, 0x0ae, 0x0ce, 0x0ee)
RULE50(0x00f, 0x02f, 0x04f, 0x06f, 0x08f, 0x0af, 0x0cf, 0x0ef)
RULE50(0x010, 0x030, 0x0f0, 0x0d0, 0x0b0, 0x090, 0x070, 0x050)
RULE50(0x011, 0x031, 0x0f1, 0x0d1, 0x0b1, 0x091, 0x071, 0x051)
RULE50(0x012, 0x032, 0x0f2, 0x0d2, 0x0b2, 0x092, 0x072, 0x052)
RULE50(0x013, 0x033, 0x0f3, 0x0d3, 0x0b3, 0x093, 0x073, 0x053)
RULE50(0x014, 0x034, 0x0f4, 0x0d4, 0x0b4, 0x094, 0x074, 0x054)
RULE50(0x015, 0x035, 0x0f5, 0x0d5, 0x0b5, 0x095, 0x075, 0x055)
RULE50(0x016, 0x036, 0x0f6, 0x0d6, 0x0b6, 0x096, 0x076, 0x056)
RULE50(0x017, 0x037, 0x0f7, 0x0d7, 0x0b7, 0x097, 0x077, 0x057)
RULE50(0x018, 0x038, 0x058, 0x078, 0x098, 0x0b8, 0x0d8, 0x0f8)
RULE50(0x019, 0x039, 0x059, 0x079, 0x099, 0x0b9, 0x0d9, 0x0f9)
RULE50(0x01a, 0x03a, 0x05a, 0x07a, 0x09a, 0x0ba, 0x0da, 0x0fa)
RULE50(0x01b, 0x03b, 0x05b, 0x07b, 0x09b, 0x0bb, 0x0db, 0x0fb)
RULE50(0x01c, 0x03c, 0x05c, 0x07c, 0x09c, 0x0bc, 0x0dc, 0x0fc)
RULE50(0x01d, 0x03d, 0x05d, 0x07d, 0x09d, 0x0bd, 0x0dd, 0x0fd)
RULE50(0x01e, 0x03e, 0x05e, 0x07e, 0x09e, 0x0be, 0x0de, 0x0fe)
RULE50(0x01f, 0x03f, 0x05f, 0x07f, 0x09f, 0x0bf, 0x0df, 0x0ff)
RULE50(0x020, 0x000, 0x040, 0x120, 0x108, 0x11f, 0x100, 0x0e0)
RULE50(0x021, 0x001, 0x041, 0x121, 0x109, 0x11e, 0x101, 0x0e1)
RULE50(0x022, 0x002, 0x042, 0x122, 0x10a, 0x11d, 0x102, 0x0e2)
RULE50(0x023, 0x003, 0x043, 0x123, 0x10b, 0x11c, 0x103, 0x0e3)
RULE50(0x024, 0x004, 0x044, 0x124, 0x10c, 0x11b, 0x104, 0x0e4)
RULE50(0x025, 0x005, 0x045, 0x125, 0x10d, 0x11a, 0x105, 0x0e5)
RULE50(0x026, 0x006, 0x046, 0x126, 0x10e, 0x119, 0x106, 0x0e6)
RULE50(0x027, 0x007, 0x047, 0x127, 0x10f, 0x118, 0x107, 0x0e7)
RULE50(0x028, 0x008, 0x0e8, 0x1c8, 0x100, 0x117, 0x108, 0x048)
RULE50(0x029, 0x009, 0x0e9, 0x1c9, 0x101, 0x116, 0x109, 0x049)
RULE50(0x02a, 0x00a, 0x0ea, 0x1ca, 0x102, 0x115, 0x10a, 0x04a)
RULE50(0x02b, 0x00b, 0x0eb, 0x1cb, 0x103, 0x114, 0x10b, 0x04b)
RULE50(0x02c, 0x00c, 0x0ec, 0x1cc, 0x104, 0x113, 0x10c, 0x04c)
RULE50(0x02d, 0x00d, 0x0ed, 0x1cd, 0x105, 0x112, 0x10d, 0x04d)
RULE50(0x02e, 0x00e, 0x0ee, 0x1ce, 0x106, 0x111, 0x10e, 0x04e)
RULE50(0x02f, 0x00f, 0x0ef, 0x1cf, 0x107, 0x110, 0x10f, 0x04f)
RULE50(0x030, 0x010, 0x050, 0x110, 0x107, 0x118, 0x1d0, 0x0f0)
RULE50(0x031, 0x011, 0x051, 0x111, 0x106, 0x119, 0x1d1, 0x0f1)
RULE50(0x032, 0x012, 0x052, 0x112, 0x105, 0x11a, 0x1d2, 0x0f2)
RULE50(0x033, 0x013, 0x053, 0x113, 0x104, 0x11b, 0x1d3, 0x0f3)
RULE50(0x034, 0x014, 0x054, 0x114, 0x103, 0x11c, 0x1d4, 0x0f4)
RULE50(0x035, 0x015, 0x055, 0x115, 0x102, 0x11d, 0x1d5, 0x0f5)
RULE50(0x036, 0x016, 0x056, 0x116, 0x101, 0x11e, 0x1d6, 0x0f6)
RULE50(0x037, 0x017, 0x057, 0x117, 0x100, 0x11f, 0x1d7, 0x0f7)
RULE50(0x038, 0x018, 0x0f8, 0x118, 0x10f, 0x110, 0x138, 0x058)
RULE50(0x039, 0x019, 0x0f9, 0x119, 0x10e, 0x111, 0x139, 0x059)
RULE50(0x03a, 0x01a, 0x0fa, 0x11a, 0x10d, 0x112, 0x13a, 0x05a)
RULE50(0x03b, 0x01b, 0x0fb, 0x11b, 0x10c, 0x113, 0x13b, 0x05b)
RULE50(0x03c, 0x01c, 0x0fc, 0x11c, 0x10b, 0x114, 0x13c, 0x05c)
RULE50(0x03d, 0x01d, 0x0fd, 0x11d, 0x10a, 0x115, 0x13d, 0x05d)
RULE50(0x03e, 0x01e, 0x0fe, 0x11e, 0x109, 0x116, 0x13e, 0x05e)
RULE50(0x03f, 0x01f, 0x0ff, 0x11f, 0x108, 0x117, 0x13f, 0x05f)
RULE50(0x040, 0x000, 0x060, 0x140, 0x128, 0x159, 0x120, 0x020)
RULE50(0x041, 0x001, 0x061, 0x141, 0x129, 0x13f, 0x121, 0x021)
RULE50(0x042, 0x002, 0x062, 0x142, 0x12a, 0x13e, 0x122, 0x022)
RULE50(0x043, 0x003, 0x063, 0x143, 0x12b, 0x13d, 0x123, 0x023)
RULE50(0x044, 0x004, 0x064, 0x144, 0x12c, 0x15d, 0x124, 0x024)
RULE50(0x045, 0x005, 0x065, 0x145, 0x12d, 0x13b, 0x125, 0x025)
RULE50(0x046, 0x006, 0x066, 0x146, 0x12e, 0x13a, 0x126, 0x026)
RULE50(0x047, 0x007, 0x067, 0x147, 0x12f, 0x139, 0x127, 0x027)
RULE50(0x048, 0x008, 0x028, 0x108, 0x120, 0x151, 0x128, 0x068)
RULE50(0x049, 0x009, 0x029, 0x109, 0x121, 0x137, 0x129, 0x069)
RULE50(0x04a, 0x00a, 0x02a, 0x10a, 0x122, 0x136, 0x12a, 0x06a)
RULE50(0x04b, 0x00b, 0x02b, 0x10b, 0x123, 0x135, 0x12b, 0x06b)
RULE50(0x04c, 0x00c, 0x02c, 0x10c, 0x124, 0x155, 0x12c, 0x06c)
RULE50(0x04d, 0x00d, 0x02d, 0x10d, 0x125, 0x133, 0x12d, 0x06d)
RULE50(0x04e, 0x00e, 0x02e, 0x10e, 0x126, 0x132, 0x12e, 0x06e)
RULE50(0x04f, 0x00f, 0x02f, 0x10f, 0x127, 0x131, 0x12f, 0x06f)
RULE50(0x050, 0x010, 0x070, 0x130, 0x141, 0x138, 0x110, 0x030)
RULE50(0x051, 0x011, 0x071, 0x131, 0x127, 0x139, 0x111, 0x031)
RULE50(0x052, 0x012, 0x072, 0x132, 0x126, 0x13a, 0x112, 0x032)
RULE50(0x053, 0x013, 0x073, 0x133, 0x125, 0x13b, 0x113, 0x033)
RULE50(0x054, 0x014, 0x074, 0x134, 0x145, 0x13c, 0x114, 0x034)
RULE50(0x055, 0x015, 0x075, 0x135, 0x123, 0x13d, 0x115, 0x035)
RULE50(0x056, 0x016, 0x076, 0x136, 0x122, 0x13e, 0x116, 0x036)
RULE50(0x057, 0x017, 0x077, 0x137, 0x121, 0x13f, 0x117, 0x037)
RULE50(0x058, 0x018, 0x038, 0x138, 0x149, 0x130, 0x158, 0x078)
RULE50(0x059, 0x019, 0x039, 0x139, 0x12f, 0x131, 0x159, 0x079)
RULE50(0x05a, 0x01a, 0x03a, 0x13a, 0x12e, 0x132, 0x15a, 0x07a)
RULE50(0x05b, 0x01b, 0x03b, 0x13b, 0x12d, 0x133, 0x15b, 0x07b)
RULE50(0x05c, 0x01c, 0x03c, 0x13c, 0x14d, 0x134, 0x15c, 0x07c)
RULE50(0x05d, 0x01d, 0x03d, 0x13d, 0x12b, 0x135, 0x15d, 0x07d)
RULE50(0x05e, 0x01e, 0x03e, 0x13e, 0x12a, 0x136, 0x15e, 0x07e)
RULE50(0x05f, 0x01f, 0x03f, 0x13f, 0x129, 0x137, 0x15f, 0x07f)
RULE50(0x060, 0x000, 0x080, 0x160, 0x148, 0x17a, 0x140, 0x040)
RULE50(0x061, 0x001, 0x081, 0x161, 0x149, 0x138, 0x141, 0x041)
RULE50(0x062, 0x002, 0x082, 0x162, 0x14a, 0x15f, 0x142, 0x042)
RULE50(0x063, 0x003, 0x083, 0x163, 0x14b, 0x15e, 0x143, 0x043)
RULE50(0x064, 0x004, 0x084, 0x164, 0x14c, 0x17e, 0x144, 0x044)
RULE50(0x065, 0x005, 0x085, 0x165, 0x14d, 0x13c, 0x145, 0x045)
RULE50(0x066, 0x006, 0x086, 0x166, 0x14e, 0x15b, 0x146, 0x046)
RULE50(0x067, 0x007, 0x087, 0x167, 0x14f, 0x15a, 0x147, 0x047)
RULE50(0x068, 0x008, 0x048, 0x128, 0x140, 0x172, 0x148, 0x088)
RULE50(0x069, 0x009, 0x049, 0x129, 0x141, 0x130, 0x149, 0x089)
RULE50(0x06a, 0x00a, 0x04a, 0x12a, 0x142, 0x157, 0x14a, 0x08a)
RULE50(0x06b, 0x00b, 0x04b, 0x12b, 0x143, 0x156, 0x14b, 0x08b)
RULE50(0x06c, 0x00c, 0x04c, 0x12c, 0x144, 0x176, 0x14c, 0x08c)
RULE50(0x06d, 0x00d, 0x04d, 0x12d, 0x145, 0x134, 0x14d, 0x08d)
RULE50(0x06e, 0x00e, 0x04e, 0x12e, 0x146, 0x153, 0x14e, 0x08e)
RULE50(0x06f, 0x00f, 0x04f, 0x12f, 0x147, 0x152, 0x14f, 0x08f)
RULE50(0x070, 0x010, 0x090, 0x150, 0x162, 0x158, 0x130, 0x050)
RULE50(0x071, 0x011, 0x091, 0x151, 0x120, 0x159, 0x131, 0x051)
RULE50(0x072, 0x012, 0x092, 0x152, 0x147, 0x15a, 0x132, 0x052)
RULE50(0x073, 0x013, 0x093, 0x153, 0x146, 0x15b, 0x133, 0x053)
RULE50(0x074, 0x014, 0x094, 0x154, 0x166, 0x15c, 0x134, 0x054)
RULE50(0x075, 0x015, 0x095, 0x155, 0x124, 0x15d, 0x135, 0x055)
RULE50(0x076, 0x016, 0x096, 0x156, 0x143, 0x15e, 0x136, 0x056)
RULE50(0x077, 0x017, 0x097, 0x157, 0x142, 0x15f, 0x137, 0x057)
RULE50(0x078, 0x018, 0x058, 0x158, 0x16a, 0x150, 0x178, 0x098)
RULE50(0x079, 0x019, 0x059, 0x159, 0x128, 0x151, 0x179, 0x099)
RULE50(0x07a, 0x01a, 0x05a, 0x15a, 0x14f, 0x152, 0x17a, 0x09a)
RULE50(0x07b, 0x01b, 0x05b, 0x15b, 0x14e, 0x153, 0x17b, 0x09b)
RULE50(0x07c, 0x01c, 0x05c, 0x15c, 0x16e, 0x154, 0x17c, 0x09c)
RULE50(0x07d, 0x01d, 0x05d, 0x15d, 0x12c, 0x155, 0x17d, 0x09d)
RULE50(0x07e, 0x01e, 0x05e, 0x15e, 0x14b, 0x156, 0x17e, 0x09e)
RULE50(0x07f, 0x01f, 0x05f, 0x15f, 0x14a, 0x157, 0x17f, 0x09f)
RULE50(0x080, 0x000, 0x0a0, 0x180, 0x168, 0x19b, 0x160, 0x060)
RULE50(0x081, 0x001, 0x0a1, 0x181, 0x169, 0x19a, 0x161, 0x061)
RULE50(0x082, 0x002, 0x0a2, 0x182, 0x16a, 0x158, 0x162, 0x062)
RULE50(0x083, 0x003, 0x0a3, 0x183, 0x16b, 0x17f, 0x163, 0x063)
RULE50(0x084, 0x004, 0x0a4, 0x184, 0x16c, 0x19f, 0x164, 0x064)
RULE50(0x085, 0x005, 0x0a5, 0x185, 0x16d, 0x19e, 0x165, 0x065)
RULE50(0x086, 0x006, 0x0a6, 0x186, 0x16e, 0x15c, 0x166, 0x066)
RULE50(0x087, 0x007, 0x0a7, 0x187, 0x16f, 0x17b, 0x167, 0x067)
RULE50(0x088, 0x008, 0x068, 0x148, 0x160, 0x193, 0x168, 0x0a8)
RULE50(0x089, 0x009, 0x069, 0x149, 0x161, 0x192, 0x169, 0x0a9)
RULE50(0x08a, 0x00a, 0x06a, 0x14a, 0x162, 0x150, 0x16a, 0x0aa)
RULE50(0x08b, 0x00b, 0x06b, 0x14b, 0x163, 0x177, 0x16b, 0x0ab)
RULE50(0x08c, 0x00c, 0x06c, 0x14c, 0x164, 0x197, 0x16c, 0x0ac)
RULE50(0x08d, 0x00d, 0x06d, 0x14d, 0x165, 0x196, 0x16d, 0x0ad)
RULE50(0x08e, 0x00e, 0x06e, 0x14e, 0x166, 0x154, 0x16e, 0x0ae)
RULE50(0x08f, 0x00f, 0x06f, 0x14f, 0x167, 0x173, 0x16f, 0x0af)
RULE50(0x090, 0x010, 0x0b0, 0x170, 0x183, 0x178, 0x150, 0x070)
RULE50(0x091, 0x011, 0x0b1, 0x171, 0x182, 0x179, 0x151, 0x071)
RULE50(0x092, 0x012, 0x0b2, 0x172, 0x140, 0x17a, 0x152, 0x072)
RULE50(0x093, 0x013, 0x0b3, 0x173, 0x167, 0x17b, 0x153, 0x073)
RULE50(0x094, 0x014, 0x0b4, 0x174, 0x187, 0x17c, 0x154, 0x074)
RULE50(0x095, 0x015, 0x0b5, 0x175, 0x186, 0x17d, 0x155, 0x075)
RULE50(0x096, 0x016, 0x0b6, 0x176, 0x144, 0x17e, 0x156, 0x076)
RULE50(0x097, 0x017, 0x0b7, 0x177, 0x163, 0x17f, 0x157, 0x077)
RULE50(0x098, 0x018, 0x078, 0x178, 0x18b, 0x170, 0x198, 0x0b8)
RULE50(0x099, 0x019, 0x079, 0x179, 0x18a, 0x171, 0x199, 0x0b9)
RULE50(0x09a, 0x01a, 0x07a, 0x17a, 0x148, 0x172, 0x19a, 0x0ba)
RULE50(0x09b, 0x01b, 0x07b, 0x17b, 0x16f, 0x173, 0x19b, 0x0bb)
RULE50(0x09c, 0x01c, 0x07c, 0x17c, 0x18f, 0x174, 0x19c, 0x0bc)
RULE50(0x09d, 0x01d, 0x07d, 0x17d, 0x18e, 0x175, 0x19d, 0x0bd)
RULE50(0x09e, 0x01e, 0x07e, 0x17e, 0x14c, 0x176, 0x19e, 0x0be)
RULE50(0x09f, 0x01f, 0x07f, 0x17f, 0x16b, 0x177, 0x19f, 0x0bf)
RULE50(0x0a0, 0x000, 0x0c0, 0x1a0, 0x188, 0x19c, 0x180, 0x080)
RULE50(0x0a1, 0x001, 0x0c1, 0x1a1, 0x189, 0x1bb, 0x181, 0x081)
RULE50(0x0a2, 0x002, 0x0c2, 0x1a2, 0x18a, 0x179, 0x182, 0x082)
RULE50(0x0a3, 0x003, 0x0c3, 0x1a3, 0x18b, 0x178, 0x183, 0x083)
RULE50(0x0a4, 0x004, 0x0c4, 0x1a4, 0x18c, 0x198, 0x184, 0x084)
RULE50(0x0a5, 0x005, 0x0c5, 0x1a5, 0x18d, 0x1bf, 0x185, 0x085)
RULE50(0x0a6, 0x006, 0x0c6, 0x1a6, 0x18e, 0x17d, 0x186, 0x086)
RULE50(0x0a7, 0x007, 0x0c7, 0x1a7, 0x18f, 0x17c, 0x187, 0x087)
RULE50(0x0a8, 0x008, 0x088, 0x168, 0x180, 0x194, 0x188, 0x0c8)
RULE50(0x0a9, 0x009, 0x089, 0x169, 0x181, 0x1b3, 0x189, 0x0c9)
RULE50(0x0aa, 0x00a, 0x08a, 0x16a, 0x182, 0x171, 0x18a, 0x0ca)
RULE50(0x0ab, 0x00b, 0x08b, 0x16b, 0x183, 0x170, 0x18b, 0x0cb)
RULE50(0x0ac, 0x00c, 0x08c, 0x16c, 0x184, 0x190, 0x18c, 0x0cc)
RULE50(0x0ad, 0x00d, 0x08d, 0x16d, 0x185, 0x1b7, 0x18d, 0x0cd)
RULE50(0x0ae, 0x00e, 0x08e, 0x16e, 0x186, 0x175, 0x18e, 0x0ce)
RULE50(0x0af, 0x00f, 0x08f, 0x16f, 0x187, 0x174, 0x18f, 0x0cf)
RULE50(0x0b0, 0x010, 0x0d0, 0x190, 0x184, 0x198, 0x170, 0x090)
RULE50(0x0b1, 0x011, 0x0d1, 0x191, 0x1a3, 0x199, 0x171, 0x091)
RULE50(0x0b2, 0x012, 0x0d2, 0x192, 0x161, 0x19a, 0x172, 0x092)
RULE50(0x0b3, 0x013, 0x0d3, 0x193, 0x160, 0x19b, 0x173, 0x093)
RULE50(0x0b4, 0x014, 0x0d4, 0x194, 0x180, 0x19c, 0x174, 0x094)
RULE50(0x0b5, 0x015, 0x0d5, 0x195, 0x1a7, 0x19d, 0x175, 0x095)
RULE50(0x0b6, 0x016, 0x0d6, 0x196, 0x165, 0x19e, 0x176, 0x096)
RULE50(0x0b7, 0x017, 0x0d7, 0x197, 0x164, 0x19f, 0x177, 0x097)
RULE50(0x0b8, 0x018, 0x098, 0x198, 0x18c, 0x190, 0x1b8, 0x0d8)
RULE50(0x0b9, 0x019, 0x099, 0x199, 0x1ab, 0x191, 0x1b9, 0x0d9)
RULE50(0x0ba, 0x01a, 0x09a, 0x19a, 0x169, 0x192, 0x1ba, 0x0da)
RULE50(0x0bb, 0x01b, 0x09b, 0x19b, 0x168, 0x193, 0x1bb, 0x0db)
RULE50(0x0bc, 0x01c, 0x09c, 0x19c, 0x188, 0x194, 0x1bc, 0x0dc)
RULE50(0x0bd, 0x01d, 0x09d, 0x19d, 0x1af, 0x195, 0x1bd, 0x0dd)
RULE50(0x0be, 0x01e, 0x09e, 0x19e, 0x16d, 0x196, 0x1be, 0x0de)
RULE50(0x0bf, 0x01f, 0x09f, 0x19f, 0x16c, 0x197, 0x1bf, 0x0df)
RULE50(0x0c0, 0x000, 0x0e0, 0x1c0, 0x1a8, 0x1bd, 0x1a0, 0x0a0)
RULE50(0x0c1, 0x001, 0x0e1, 0x1c1, 0x1a9, 0x1bc, 0x1a1, 0x0a1)
RULE50(0x0c2, 0x002, 0x0e2, 0x1c2, 0x1aa, 0x1db, 0x1a2, 0x0a2)
RULE50(0x0c3, 0x003, 0x0e3, 0x1c3, 0x1ab, 0x199, 0x1a3, 0x0a3)
RULE50(0x0c4, 0x004, 0x0e4, 0x1c4, 0x1ac, 0x1b9, 0x1a4, 0x0a4)
RULE50(0x0c5, 0x005, 0x0e5, 0x1c5, 0x1ad, 0x1b8, 0x1a5, 0x0a5)
RULE50(0x0c6, 0x006, 0x0e6, 0x1c6, 0x1ae, 0x1df, 0x1a6, 0x0a6)
RULE50(0x0c7, 0x007, 0x0e7, 0x1c7, 0x1af, 0x19d, 0x1a7, 0x0a7)
RULE50(0x0c8, 0x008, 0x0a8, 0x188, 0x1a0, 0x1b5, 0x1a8, 0x0e8)
RULE50(0x0c9, 0x009, 0x0a9, 0x189, 0x1a1, 0x1b4, 0x1a9, 0x0e9)
RULE50(0x0ca, 0x00a, 0x0aa, 0x18a, 0x1a2, 0x1d3, 0x1aa, 0x0ea)
RULE50(0x0cb, 0x00b, 0x0ab, 0x18b, 0x1a3, 0x191, 0x1ab, 0x0eb)
RULE50(0x0cc, 0x00c, 0x0ac, 0x18c, 0x1a4, 0x1b1, 0x1ac, 0x0ec)
RULE50(0x0cd, 0x00d, 0x0ad, 0x18d, 0x1a5, 0x1b0, 0x1ad, 0x0ed)
RULE50(0x0ce, 0x00e, 0x0ae, 0x18e, 0x1a6, 0x1d7, 0x1ae, 0x0ee)
RULE50(0x0cf, 0x00f, 0x0af, 0x18f, 0x1a7, 0x195, 0x1af, 0x0ef)
RULE50(0x0d0, 0x010, 0x0f0, 0x1b0, 0x1a5, 0x1b8, 0x190, 0x0b0)
RULE50(0x0d1, 0x011, 0x0f1, 0x1b1, 0x1a4, 0x1b9, 0x191, 0x0b1)
RULE50(0x0d2, 0x012, 0x0f2, 0x1b2, 0x1c3, 0x1ba, 0x192, 0x0b2)
RULE50(0x0d3, 0x013, 0x0f3, 0x1b3, 0x181, 0x1bb, 0x193, 0x0b3)
RULE50(0x0d4, 0x014, 0x0f4, 0x1b4, 0x1a1, 0x1bc, 0x194, 0x0b4)
RULE50(0x0d5, 0x015, 0x0f5, 0x1b5, 0x1a0, 0x1bd, 0x195, 0x0b5)
RULE50(0x0d6, 0x016, 0x0f6, 0x1b6, 0x1c7, 0x1be, 0x196, 0x0b6)
RULE50(0x0d7, 0x017, 0x0f7, 0x1b7, 0x185, 0x1bf, 0x197, 0x0b7)
RULE50(0x0d8, 0x018, 0x0b8, 0x1b8, 0x1ad, 0x1b0, 0x1d8, 0x0f8)
RULE50(0x0d9, 0x019, 0x0b9, 0x1b9, 0x1ac, 0x1b1, 0x1d9, 0x0f9)
RULE50(0x0da, 0x01a, 0x0ba, 0x1ba, 0x1cb, 0x1b2, 0x1da, 0x0fa)
RULE50(0x0db, 0x01b, 0x0bb, 0x1bb, 0x189, 0x1b3, 0x1db, 0x0fb)
RULE50(0x0dc, 0x01c, 0x0bc, 0x1bc, 0x1a9, 0x1b4, 0x1dc, 0x0fc)
RULE50(0x0dd, 0x01d, 0x0bd, 0x1bd, 0x1a8, 0x1b5, 0x1dd, 0x0fd)
RULE50(0x0de, 0x01e, 0x0be, 0x1be, 0x1cf, 0x1b6, 0x1de, 0x0fe)
RULE50(0x0df, 0x01f, 0x0bf, 0x1bf, 0x18d, 0x1b7, 0x1df, 0x0ff)
RULE50(0x0e0, 0x000, 0x020, 0x100, 0x1c8, 0x1de, 0x1c0, 0x0c0)
RULE50(0x0e1, 0x001, 0x021, 0x101, 0x1c9, 0x1dd, 0x1c1, 0x0c1)
RULE50(0x0e2, 0x002, 0x022, 0x102, 0x1ca, 0x1dc, 0x1c2, 0x0c2)
RULE50(0x0e3, 0x003, 0x023, 0x103, 0x1cb, 0x1ba, 0x1c3, 0x0c3)
RULE50(0x0e4, 0x004, 0x024, 0x104, 0x1cc, 0x1da, 0x1c4, 0x0c4)
RULE50(0x0e5, 0x005, 0x025, 0x105, 0x1cd, 0x1d9, 0x1c5, 0x0c5)
RULE50(0x0e6, 0x006, 0x026, 0x106, 0x1ce, 0x1d8, 0x1c6, 0x0c6)
RULE50(0x0e7, 0x007, 0x027, 0x107, 0x1cf, 0x1be, 0x1c7, 0x0c7)
RULE50(0x0e8, 0x008, 0x0c8, 0x1a8, 0x1c0, 0x1d6, 0x1c8, 0x028)
RULE50(0x0e9, 0x009, 0x0c9, 0x1a9, 0x1c1, 0x1d5, 0x1c9, 0x029)
RULE50(0x0ea, 0x00a, 0x0ca, 0x1aa, 0x1c2, 0x1d4, 0x1ca, 0x02a)
RULE50(0x0eb, 0x00b, 0x0cb, 0x1ab, 0x1c3, 0x1b2, 0x1cb, 0x02b)
RULE50(0x0ec, 0x00c, 0x0cc, 0x1ac, 0x1c4, 0x1d2, 0x1cc, 0x02c)
RULE50(0x0ed, 0x00d, 0x0cd, 0x1ad, 0x1c5, 0x1d1, 0x1cd, 0x02d)
RULE50(0x0ee, 0x00e, 0x0ce, 0x1ae, 0x1c6, 0x1d0, 0x1ce, 0x02e)
RULE50(0x0ef, 0x00f, 0x0cf, 0x1af, 0x1c7, 0x1b6, 0x1cf, 0x02f)
RULE50(0x0f0, 0x010, 0x030, 0x1d0, 0x1c6, 0x1d8, 0x1b0, 0x0d0)
RULE50(0x0f1, 0x011, 0x031, 0x1d1, 0x1c5, 0x1d9, 0x1b1, 0x0d1)
RULE50(0x0f2, 0x012, 0x032, 0x1d2, 0x1c4, 0x1da, 0x1b2, 0x0d2)
RULE50(0x0f3, 0x013, 0x033, 0x1d3, 0x1a2, 0x1db, 0x1b3, 0x0d3)
RULE50(0x0f4, 0x014, 0x034, 0x1d4, 0x1c2, 0x1dc, 0x1b4, 0x0d4)
RULE50(0x0f5, 0x015, 0x035, 0x1d5, 0x1c1, 0x1dd, 0x1b5, 0x0d5)
RULE50(0x0f6, 0x016, 0x036, 0x1d6, 0x1c0, 0x1de, 0x1b6, 0x0d6)
RULE50(0x0f7, 0x017, 0x037, 0x1d7, 0x1a6, 0x1df, 0x1b7, 0x0d7)
RULE50(0x0f8, 0x018, 0x0d8, 0x1d8, 0x1ce, 0x1d0, 0x118, 0x038)
RULE50(0x0f9, 0x019, 0x0d9, 0x1d9, 0x1cd, 0x1d1, 0x119, 0x039)
RULE50(0x0fa, 0x01a, 0x0da, 0x1da, 0x1cc, 0x1d2, 0x11a, 0x03a)
RULE50(0x0fb, 0x01b, 0x0db, 0x1db, 0x1aa, 0x1d3, 0x11b, 0x03b)
RULE50(0x0fc, 0x01c, 0x0dc, 0x1dc, 0x1ca, 0x1d4, 0x11c, 0x03c)
RULE50(0x0fd, 0x01d, 0x0dd, 0x1dd, 0x1c9, 0x1d5, 0x11d, 0x03d)
RULE50(0x0fe, 0x01e, 0x0de, 0x1de, 0x1c8, 0x1d6, 0x11e, 0x03e)
RULE50(0x0ff, 0x01f, 0x0df, 0x1df, 0x1ae, 0x1d7, 0x11f, 0x03f)
RULE50(0x100, 0x020, 0x11f, 0x037, 0x117, 0x028, 0x1c8, 0x0e0)
RULE50(0x101, 0x021, 0x11e, 0x036, 0x116, 0x029, 0x1c9, 0x0e1)
RULE50(0x102, 0x022, 0x11d, 0x035, 0x115, 0x02a, 0x1ca, 0x0e2)
RULE50(0x103, 0x023, 0x11c, 0x034, 0x114, 0x02b, 0x1cb, 0x0e3)
RULE50(0x104, 0x024, 0x11b, 0x033, 0x113, 0x02c, 0x1cc, 0x0e4)
RULE50(0x105, 0x025, 0x11a, 0x032, 0x112, 0x02d, 0x1cd, 0x0e5)
RULE50(0x106, 0x026, 0x119, 0x031, 0x111, 0x02e, 0x1ce, 0x0e6)
RULE50(0x107, 0x027, 0x118, 0x030, 0x110, 0x02f, 0x1cf, 0x0e7)
RULE50(0x108, 0x020, 0x120, 0x048, 0x028, 0x117, 0x03f, 0x11f)
RULE50(0x109, 0x021, 0x121, 0x049, 0x029, 0x116, 0x03e, 0x11e)
RULE50(0x10a, 0x022, 0x122, 0x04a, 0x02a, 0x115, 0x03d, 0x11d)
RULE50(0x10b, 0x023, 0x123, 0x04b, 0x02b, 0x114, 0x03c, 0x11c)
RULE50(0x10c, 0x024, 0x124, 0x04c, 0x02c, 0x113, 0x03b, 0x11b)
RULE50(0x10d, 0x025, 0x125, 0x04d, 0x02d, 0x112, 0x03a, 0x11a)
RULE50(0x10e, 0x026, 0x126, 0x04e, 0x02e, 0x111, 0x039, 0x119)
RULE50(0x10f, 0x027, 0x127, 0x04f, 0x02f, 0x110, 0x038, 0x118)
RULE50(0x110, 0x02f, 0x107, 0x030, 0x050, 0x138, 0x038, 0x10f)
RULE50(0x111, 0x02e, 0x106, 0x031, 0x051, 0x139, 0x039, 0x10e)
RULE50(0x112, 0x02d, 0x105, 0x032, 0x052, 0x13a, 0x03a, 0x10d)
RULE50(0x113, 0x02c, 0x104, 0x033, 0x053, 0x13b, 0x03b, 0x10c)
RULE50(0x114, 0x02b, 0x103, 0x034, 0x054, 0x13c, 0x03c, 0x10b)
RULE50(0x115, 0x02a, 0x102, 0x035, 0x055, 0x13d, 0x03d, 0x10a)
RULE50(0x116, 0x029, 0x101, 0x036, 0x056, 0x13e, 0x03e, 0x109)
RULE50(0x117, 0x028, 0x100, 0x037, 0x057, 0x13f, 0x03f, 0x108)
RULE50(0x118, 0x027, 0x10f, 0x038, 0x0f8, 0x1d0, 0x030, 0x107)
RULE50(0x119, 0x026, 0x10e, 0x039, 0x0f9, 0x1d1, 0x031, 0x106)
RULE50(0x11a, 0x025, 0x10d, 0x03a, 0x0fa, 0x1d2, 0x032, 0x105)
RULE50(0x11b, 0x024, 0x10c, 0x03b, 0x0fb, 0x1d3, 0x033, 0x104)
RULE50(0x11c, 0x023, 0x10b, 0x03c, 0x0fc, 0x1d4, 0x034, 0x103)
RULE50(0x11d, 0x022, 0x10a, 0x03d, 0x0fd, 0x1d5, 0x035, 0x102)
RULE50(0x11e, 0x021, 0x109, 0x03e, 0x0fe, 0x1d6, 0x036, 0x101)
RULE50(0x11f, 0x020, 0x108, 0x03f, 0x0ff, 0x1d7, 0x037, 0x100)
RULE50(0x120, 0x020, 0x040, 0x159, 0x071, 0x151, 0x048, 0x108)
RULE50(0x121, 0x021, 0x041, 0x13f, 0x057, 0x137, 0x049, 0x109)
RULE50(0x122, 0x022, 0x042, 0x13e, 0x056, 0x136, 0x04a, 0x10a)
RULE50(0x123, 0x023, 0x043, 0x13d, 0x055, 0x135, 0x04b, 0x10b)
RULE50(0x124, 0x024, 0x044, 0x15d, 0x075, 0x155, 0x04c, 0x10c)
RULE50(0x125, 0x025, 0x045, 0x13b, 0x053, 0x133, 0x04d, 0x10d)
RULE50(0x126, 0x026, 0x046, 0x13a, 0x052, 0x132, 0x04e, 0x10e)
RULE50(0x127, 0x027, 0x047, 0x139, 0x051, 0x131, 0x04f, 0x10f)
RULE50(0x128, 0x040, 0x140, 0x068, 0x048, 0x151, 0x079, 0x159)
RULE50(0x129, 0x041, 0x141, 0x069, 0x049, 0x137, 0x05f, 0x13f)
RULE50(0x12a, 0x042, 0x142, 0x06a, 0x04a, 0x136, 0x05e, 0x13e)
RULE50(0x12b, 0x043, 0x143, 0x06b, 0x04b, 0x135, 0x05d, 0x13d)
RULE50(0x12c, 0x044, 0x144, 0x06c, 0x04c, 0x155, 0x07d, 0x15d)
RULE50(0x12d, 0x045, 0x145, 0x06d, 0x04d, 0x133, 0x05b, 0x13b)
RULE50(0x12e, 0x046, 0x146, 0x06e, 0x04e, 0x132, 0x05a, 0x13a)
RULE50(0x12f, 0x047, 0x147, 0x06f, 0x04f, 0x131, 0x059, 0x139)
RULE50(0x130, 0x050, 0x070, 0x158, 0x058, 0x149, 0x069, 0x141)
RULE50(0x131, 0x04f, 0x127, 0x051, 0x071, 0x159, 0x059, 0x12f)
RULE50(0x132, 0x04e, 0x126, 0x052, 0x072, 0x15a, 0x05a, 0x12e)
RULE50(0x133, 0x04d, 0x125, 0x053, 0x073, 0x15b, 0x05b, 0x12d)
RULE50(0x134, 0x054, 0x074, 0x15c, 0x05c, 0x14d, 0x06d, 0x145)
RULE50(0x135, 0x04b, 0x123, 0x055, 0x075, 0x15d, 0x05d, 0x12b)
RULE50(0x136, 0x04a, 0x122, 0x056, 0x076, 0x15e, 0x05e, 0x12a)
RULE50(0x137, 0x049, 0x121, 0x057, 0x077, 0x15f, 0x05f, 0x129)
RULE50(0x138, 0x038, 0x110, 0x050, 0x141, 0x061, 0x149, 0x058)
RULE50(0x139, 0x039, 0x111, 0x051, 0x127, 0x047, 0x12f, 0x059)
RULE50(0x13a, 0x03a, 0x112, 0x052, 0x126, 0x046, 0x12e, 0x05a)
RULE50(0x13b, 0x03b, 0x113, 0x053, 0x125, 0x045, 0x12d, 0x05b)
RULE50(0x13c, 0x03c, 0x114, 0x054, 0x145, 0x065, 0x14d, 0x05c)
RULE50(0x13d, 0x03d, 0x115, 0x055, 0x123, 0x043, 0x12b, 0x05d)
RULE50(0x13e, 0x03e, 0x116, 0x056, 0x122, 0x042, 0x12a, 0x05e)
RULE50(0x13f, 0x03f, 0x117, 0x057, 0x121, 0x041, 0x129, 0x05f)
RULE50(0x140, 0x040, 0x060, 0x17a, 0x092, 0x172, 0x068, 0x128)
RULE50(0x141, 0x041, 0x061, 0x138, 0x050, 0x130, 0x069, 0x129)
RULE50(0x142, 0x042, 0x062, 0x15f, 0x077, 0x157, 0x06a, 0x12a)
RULE50(0x143, 0x043, 0x063, 0x15e, 0x076, 0x156, 0x06b, 0x12b)
RULE50(0x144, 0x044, 0x064, 0x17e, 0x096, 0x176, 0x06c, 0x12c)
RULE50(0x145, 0x045, 0x065, 0x13c, 0x054, 0x134, 0x06d, 0x12d)
RULE50(0x146, 0x046, 0x066, 0x15b, 0x073, 0x153, 0x06e, 0x12e)
RULE50(0x147, 0x047, 0x067, 0x15a, 0x072, 0x152, 0x06f, 0x12f)
RULE50(0x148, 0x060, 0x160, 0x088, 0x068, 0x172, 0x09a, 0x17a)
RULE50(0x149, 0x058, 0x138, 0x061, 0x161, 0x089, 0x069, 0x130)
RULE50(0x14a, 0x062, 0x162, 0x08a, 0x06a, 0x157, 0x07f, 0x15f)
RULE50(0x14b, 0x063, 0x163, 0x08b, 0x06b, 0x156, 0x07e, 0x15e)
RULE50(0x14c, 0x064, 0x164, 0x08c, 0x06c, 0x176, 0x09e, 0x17e)
RULE50(0x14d, 0x05c, 0x13c, 0x065, 0x165, 0x08d, 0x06d, 0x134)
RULE50(0x14e, 0x066, 0x166, 0x08e, 0x06e, 0x153, 0x07b, 0x15b)
RULE50(0x14f, 0x067, 0x167, 0x08f, 0x06f, 0x152, 0x07a, 0x15a)
RULE50(0x150, 0x070, 0x090, 0x178, 0x078, 0x16a, 0x08a, 0x162)
RULE50(0x151, 0x048, 0x120, 0x071, 0x091, 0x179, 0x079, 0x128)
RULE50(0x152, 0x06f, 0x147, 0x072, 0x092, 0x17a, 0x07a, 0x14f)
RULE50(0x153, 0x06e, 0x146, 0x073, 0x093, 0x17b, 0x07b, 0x14e)
RULE50(0x154, 0x074, 0x094, 0x17c, 0x07c, 0x16e, 0x08e, 0x166)
RULE50(0x155, 0x04c, 0x124, 0x075, 0x095, 0x17d, 0x07d, 0x12c)
RULE50(0x156, 0x06b, 0x143, 0x076, 0x096, 0x17e, 0x07e, 0x14b)
RULE50(0x157, 0x06a, 0x142, 0x077, 0x097, 0x17f, 0x07f, 0x14a)
RULE50(0x158, 0x058, 0x130, 0x070, 0x162, 0x082, 0x16a, 0x078)
RULE50(0x159, 0x040, 0x128, 0x079, 0x059, 0x131, 0x071, 0x120)
RULE50(0x15a, 0x05a, 0x132, 0x072, 0x147, 0x067, 0x14f, 0x07a)
RULE50(0x15b, 0x05b, 0x133, 0x073, 0x146, 0x066, 0x14e, 0x07b)
RULE50(0x15c, 0x05c, 0x134, 0x074, 0x166, 0x086, 0x16e, 0x07c)
RULE50(0x15d, 0x044, 0x12c, 0x07d, 0x05d, 0x135, 0x075, 0x124)
RULE50(0x15e, 0x05e, 0x136, 0x076, 0x143, 0x063, 0x14b, 0x07e)
RULE50(0x15f, 0x05f, 0x137, 0x077, 0x142, 0x062, 0x14a, 0x07f)
RULE50(0x160, 0x060, 0x080, 0x19b, 0x0b3, 0x193, 0x088, 0x148)
RULE50(0x161, 0x061, 0x081, 0x19a, 0x0b2, 0x192, 0x089, 0x149)
RULE50(0x162, 0x062, 0x082, 0x158, 0x070, 0x150, 0x08a, 0x14a)
RULE50(0x163, 0x063, 0x083, 0x17f, 0x097, 0x177, 0x08b, 0x14b)
RULE50(0x164, 0x064, 0x084, 0x19f, 0x0b7, 0x197, 0x08c, 0x14c)
RULE50(0x165, 0x065, 0x085, 0x19e, 0x0b6, 0x196, 0x08d, 0x14d)
RULE50(0x166, 0x066, 0x086, 0x15c, 0x074, 0x154, 0x08e, 0x14e)
RULE50(0x167, 0x067, 0x087, 0x17b, 0x093, 0x173, 0x08f, 0x14f)
RULE50(0x168, 0x080, 0x180, 0x0a8, 0x088, 0x193, 0x0bb, 0x19b)
RULE50(0x169, 0x081, 0x181, 0x0a9, 0x089, 0x192, 0x0ba, 0x19a)
RULE50(0x16a, 0x078, 0x158, 0x082, 0x182, 0x0aa, 0x08a, 0x150)
RULE50(0x16b, 0x083, 0x183, 0x0ab, 0x08b, 0x177, 0x09f, 0x17f)
RULE50(0x16c, 0x084, 0x184, 0x0ac, 0x08c, 0x197, 0x0bf, 0x19f)
RULE50(0x16d, 0x085, 0x185, 0x0ad, 0x08d, 0x196, 0x0be, 0x19e)
RULE50(0x16e, 0x07c, 0x15c, 0x086, 0x186, 0x0ae, 0x08e, 0x154)
RULE50(0x16f, 0x087, 0x187, 0x0af, 0x08f, 0x173, 0x09b, 0x17b)
RULE50(0x170, 0x090, 0x0b0, 0x198, 0x098, 0x18b, 0x0ab, 0x183)
RULE50(0x171, 0x091, 0x0b1, 0x199, 0x099, 0x18a, 0x0aa, 0x182)
RULE50(0x172, 0x068, 0x140, 0x092, 0x0b2, 0x19a, 0x09a, 0x148)
RULE50(0x173, 0x08f, 0x167, 0x093, 0x0b3, 0x19b, 0x09b, 0x16f)
RULE50(0x174, 0x094, 0x0b4, 0x19c, 0x09c, 0x18f, 0x0af, 0x187)
RULE50(0x175, 0x095, 0x0b5, 0x19d, 0x09d, 0x18e, 0x0ae, 0x186)
RULE50(0x176, 0x06c, 0x144, 0x096, 0x0b6, 0x19e, 0x09e, 0x14c)
RULE50(0x177, 0x08b, 0x163, 0x097, 0x0b7, 0x19f, 0x09f, 0x16b)
RULE50(0x178, 0x078, 0x150, 0x090, 0x183, 0x0a3, 0x18b, 0x098)
RULE50(0x179, 0x079, 0x151, 0x091, 0x182, 0x0a2, 0x18a, 0x099)
RULE50(0x17a, 0x060, 0x148, 0x09a, 0x07a, 0x152, 0x092, 0x140)
RULE50(0x17b, 0x07b, 0x153, 0x093, 0x167, 0x087, 0x16f, 0x09b)
RULE50(0x17c, 0x07c, 0x154, 0x094, 0x187, 0x0a7, 0x18f, 0x09c)
RULE50(0x17d, 0x07d, 0x155, 0x095, 0x186, 0x0a6, 0x18e, 0x09d)
RULE50(0x17e, 0x064, 0x14c, 0x09e, 0x07e, 0x156, 0x096, 0x144)
RULE50(0x17f, 0x07f, 0x157, 0x097, 0x163, 0x083, 0x16b, 0x09f)
RULE50(0x180, 0x080, 0x0a0, 0x19c, 0x0b4, 0x194, 0x0a8, 0x168)
RULE50(0x181, 0x081, 0x0a1, 0x1bb, 0x0d3, 0x1b3, 0x0a9, 0x169)
RULE50(0x182, 0x082, 0x0a2, 0x179, 0x091, 0x171, 0x0aa, 0x16a)
RULE50(0x183, 0x083, 0x0a3, 0x178, 0x090, 0x170, 0x0ab, 0x16b)
RULE50(0x184, 0x084, 0x0a4, 0x198, 0x0b0, 0x190, 0x0ac, 0x16c)
RULE50(0x185, 0x085, 0x0a5, 0x1bf, 0x0d7, 0x1b7, 0x0ad, 0x16d)
RULE50(0x186, 0x086, 0x0a6, 0x17d, 0x095, 0x175, 0x0ae, 0x16e)
RULE50(0x187, 0x087, 0x0a7, 0x17c, 0x094, 0x174, 0x0af, 0x16f)
RULE50(0x188, 0x0a0, 0x1a0, 0x0c8, 0x0a8, 0x194, 0x0bc, 0x19c)
RULE50(0x189, 0x0a1, 0x1a1, 0x0c9, 0x0a9, 0x1b3, 0x0db, 0x1bb)
RULE50(0x18a, 0x099, 0x179, 0x0a2, 0x1a2, 0x0ca, 0x0aa, 0x171)
RULE50(0x18b, 0x098, 0x178, 0x0a3, 0x1a3, 0x0cb, 0x0ab, 0x170)
RULE50(0x18c, 0x0a4, 0x1a4, 0x0cc, 0x0ac, 0x190, 0x0b8, 0x198)
RULE50(0x18d, 0x0a5, 0x1a5, 0x0cd, 0x0ad, 0x1b7, 0x0df, 0x1bf)
RULE50(0x18e, 0x09d, 0x17d, 0x0a6, 0x1a6, 0x0ce, 0x0ae, 0x175)
RULE50(0x18f, 0x09c, 0x17c, 0x0a7, 0x1a7, 0x0cf, 0x0af, 0x174)
RULE50(0x190, 0x0ac, 0x184, 0x0b0, 0x0d0, 0x1b8, 0x0b8, 0x18c)
RULE50(0x191, 0x0b1, 0x0d1, 0x1b9, 0x0b9, 0x1ab, 0x0cb, 0x1a3)
RULE50(0x192, 0x089, 0x161, 0x0b2, 0x0d2, 0x1ba, 0x0ba, 0x169)
RULE50(0x193, 0x088, 0x160, 0x0b3, 0x0d3, 0x1bb, 0x0bb, 0x168)
RULE50(0x194, 0x0a8, 0x180, 0x0b4, 0x0d4, 0x1bc, 0x0bc, 0x188)
RULE50(0x195, 0x0b5, 0x0d5, 0x1bd, 0x0bd, 0x1af, 0x0cf, 0x1a7)
RULE50(0x196, 0x08d, 0x165, 0x0b6, 0x0d6, 0x1be, 0x0be, 0x16d)
RULE50(0x197, 0x08c, 0x164, 0x0b7, 0x0d7, 0x1bf, 0x0bf, 0x16c)
RULE50(0x198, 0x098, 0x170, 0x0b0, 0x184, 0x0a4, 0x18c, 0x0b8)
RULE50(0x199, 0x099, 0x171, 0x0b1, 0x1a3, 0x0c3, 0x1ab, 0x0b9)
RULE50(0x19a, 0x081, 0x169, 0x0ba, 0x09a, 0x172, 0x0b2, 0x161)
RULE50(0x19b, 0x080, 0x168, 0x0bb, 0x09b, 0x173, 0x0b3, 0x160)
RULE50(0x19c, 0x09c, 0x174, 0x0b4, 0x180, 0x0a0, 0x188, 0x0bc)
RULE50(0x19d, 0x09d, 0x175, 0x0b5, 0x1a7, 0x0c7, 0x1af, 0x0bd)
RULE50(0x19e, 0x085, 0x16d, 0x0be, 0x09e, 0x176, 0x0b6, 0x165)
RULE50(0x19f, 0x084, 0x16c, 0x0bf, 0x09f, 0x177, 0x0b7, 0x164)
RULE50(0x1a0, 0x0a0, 0x0c0, 0x1bd, 0x0d5, 0x1b5, 0x0c8, 0x188)
RULE50(0x1a1, 0x0a1, 0x0c1, 0x1bc, 0x0d4, 0x1b4, 0x0c9, 0x189)
RULE50(0x1a2, 0x0a2, 0x0c2, 0x1db, 0x0f3, 0x1d3, 0x0ca, 0x18a)
RULE50(0x1a3, 0x0a3, 0x0c3, 0x199, 0x0b1, 0x191, 0x0cb, 0x18b)
RULE50(0x1a4, 0x0a4, 0x0c4, 0x1b9, 0x0d1, 0x1b1, 0x0cc, 0x18c)
RULE50(0x1a5, 0x0a5, 0x0c5, 0x1b8, 0x0d0, 0x1b0, 0x0cd, 0x18d)
RULE50(0x1a6, 0x0a6, 0x0c6, 0x1df, 0x0f7, 0x1d7, 0x0ce, 0x18e)
RULE50(0x1a7, 0x0a7, 0x0c7, 0x19d, 0x0b5, 0x195, 0x0cf, 0x18f)
RULE50(0x1a8, 0x0c0, 0x1c0, 0x0e8, 0x0c8, 0x1b5, 0x0dd, 0x1bd)
RULE50(0x1a9, 0x0c1, 0x1c1, 0x0e9, 0x0c9, 0x1b4, 0x0dc, 0x1bc)
RULE50(0x1aa, 0x0c2, 0x1c2, 0x0ea, 0x0ca, 0x1d3, 0x0fb, 0x1db)
RULE50(0x1ab, 0x0b9, 0x199, 0x0c3, 0x1c3, 0x0eb, 0x0cb, 0x191)
RULE50(0x1ac, 0x0c4, 0x1c4, 0x0ec, 0x0cc, 0x1b1, 0x0d9, 0x1b9)
RULE50(0x1ad, 0x0c5, 0x1c5, 0x0ed, 0x0cd, 0x1b0, 0x0d8, 0x1b8)
RULE50(0x1ae, 0x0c6, 0x1c6, 0x0ee, 0x0ce, 0x1d7, 0x0ff, 0x1df)
RULE50(0x1af, 0x0bd, 0x19d, 0x0c7, 0x1c7, 0x0ef, 0x0cf, 0x195)
RULE50(0x1b0, 0x0cd, 0x1a5, 0x0d0, 0x0f0, 0x1d8, 0x0d8, 0x1ad)
RULE50(0x1b1, 0x0cc, 0x1a4, 0x0d1, 0x0f1, 0x1d9, 0x0d9, 0x1ac)
RULE50(0x1b2, 0x0d2, 0x0f2, 0x1da, 0x0da, 0x1cb, 0x0eb, 0x1c3)
RULE50(0x1b3, 0x0a9, 0x181, 0x0d3, 0x0f3, 0x1db, 0x0db, 0x189)
RULE50(0x1b4, 0x0c9, 0x1a1, 0x0d4, 0x0f4, 0x1dc, 0x0dc, 0x1a9)
RULE50(0x1b5, 0x0c8, 0x1a0, 0x0d5, 0x0f5, 0x1dd, 0x0dd, 0x1a8)
RULE50(0x1b6, 0x0d6, 0x0f6, 0x1de, 0x0de, 0x1cf, 0x0ef, 0x1c7)
RULE50(0x1b7, 0x0ad, 0x185, 0x0d7, 0x0f7, 0x1df, 0x0df, 0x18d)
RULE50(0x1b8, 0x0b8, 0x190, 0x0d0, 0x1a5, 0x0c5, 0x1ad, 0x0d8)
RULE50(0x1b9, 0x0b9, 0x191, 0x0d1, 0x1a4, 0x0c4, 0x1ac, 0x0d9)
RULE50(0x1ba, 0x0ba, 0x192, 0x0d2, 0x1c3, 0x0e3, 0x1cb, 0x0da)
RULE50(0x1bb, 0x0a1, 0x189, 0x0db, 0x0bb, 0x193, 0x0d3, 0x181)
RULE50(0x1bc, 0x0bc, 0x194, 0x0d4, 0x1a1, 0x0c1, 0x1a9, 0x0dc)
RULE50(0x1bd, 0x0bd, 0x195, 0x0d5, 0x1a0, 0x0c0, 0x1a8, 0x0dd)
RULE50(0x1be, 0x0be, 0x196, 0x0d6, 0x1c7, 0x0e7, 0x1cf, 0x0de)
RULE50(0x1bf, 0x0a5, 0x18d, 0x0df, 0x0bf, 0x197, 0x0d7, 0x185)
RULE50(0x1c0, 0x0c0, 0x0e0, 0x1de, 0x0f6, 0x1d6, 0x0e8, 0x1a8)
RULE50(0x1c1, 0x0c1, 0x0e1, 0x1dd, 0x0f5, 0x1d5, 0x0e9, 0x1a9)
RULE50(0x1c2, 0x0c2, 0x0e2, 0x1dc, 0x0f4, 0x1d4, 0x0ea, 0x1aa)
RULE50(0x1c3, 0x0c3, 0x0e3, 0x1ba, 0x0d2, 0x1b2, 0x0eb, 0x1ab)
RULE50(0x1c4, 0x0c4, 0x0e4, 0x1da, 0x0f2, 0x1d2, 0x0ec, 0x1ac)
RULE50(0x1c5, 0x0c5, 0x0e5, 0x1d9, 0x0f1, 0x1d1, 0x0ed, 0x1ad)
RULE50(0x1c6, 0x0c6, 0x0e6, 0x1d8, 0x0f0, 0x1d0, 0x0ee, 0x1ae)
RULE50(0x1c7, 0x0c7, 0x0e7, 0x1be, 0x0d6, 0x1b6, 0x0ef, 0x1af)
RULE50(0x1c8, 0x028, 0x0e8, 0x1d6, 0x0fe, 0x1de, 0x0e0, 0x100)
RULE50(0x1c9, 0x029, 0x0e9, 0x1d5, 0x0fd, 0x1dd, 0x0e1, 0x101)
RULE50(0x1ca, 0x02a, 0x0ea, 0x1d4, 0x0fc, 0x1dc, 0x0e2, 0x102)
RULE50(0x1cb, 0x02b, 0x0eb, 0x1b2, 0x0da, 0x1ba, 0x0e3, 0x103)
RULE50(0x1cc, 0x02c, 0x0ec, 0x1d2, 0x0fa, 0x1da, 0x0e4, 0x104)
RULE50(0x1cd, 0x02d, 0x0ed, 0x1d1, 0x0f9, 0x1d9, 0x0e5, 0x105)
RULE50(0x1ce, 0x02e, 0x0ee, 0x1d0, 0x0f8, 0x1d8, 0x0e6, 0x106)
RULE50(0x1cf, 0x02f, 0x0ef, 0x1b6, 0x0de, 0x1be, 0x0e7, 0x107)
RULE50(0x1d0, 0x030, 0x118, 0x0f8, 0x1ce, 0x0ee, 0x1c6, 0x0f0)
RULE50(0x1d1, 0x031, 0x119, 0x0f9, 0x1cd, 0x0ed, 0x1c5, 0x0f1)
RULE50(0x1d2, 0x032, 0x11a, 0x0fa, 0x1cc, 0x0ec, 0x1c4, 0x0f2)
RULE50(0x1d3, 0x033, 0x11b, 0x0fb, 0x1aa, 0x0ca, 0x1a2, 0x0f3)
RULE50(0x1d4, 0x034, 0x11c, 0x0fc, 0x1ca, 0x0ea, 0x1c2, 0x0f4)
RULE50(0x1d5, 0x035, 0x11d, 0x0fd, 0x1c9, 0x0e9, 0x1c1, 0x0f5)
RULE50(0x1d6, 0x036, 0x11e, 0x0fe, 0x1c8, 0x0e8, 0x1c0, 0x0f6)
RULE50(0x1d7, 0x037, 0x11f, 0x0ff, 0x1ae, 0x0ce, 0x1a6, 0x0f7)
RULE50(0x1d8, 0x0d8, 0x1b0, 0x0f0, 0x1c6, 0x0e6, 0x1ce, 0x0f8)
RULE50(0x1d9, 0x0d9, 0x1b1, 0x0f1, 0x1c5, 0x0e5, 0x1cd, 0x0f9)
RULE50(0x1da, 0x0da, 0x1b2, 0x0f2, 0x1c4, 0x0e4, 0x1cc, 0x0fa)
RULE50(0x1db, 0x0c2, 0x1aa, 0x0fb, 0x0db, 0x1b3, 0x0f3, 0x1a2)
RULE50(0x1dc, 0x0dc, 0x1b4, 0x0f4, 0x1c2, 0x0e2, 0x1ca, 0x0fc)
RULE50(0x1dd, 0x0dd, 0x1b5, 0x0f5, 0x1c1, 0x0e1, 0x1c9, 0x0fd)
RULE50(0x1de, 0x0de, 0x1b6, 0x0f6, 0x1c0, 0x0e0, 0x1c8, 0x0fe)
RULE50(0x1df, 0x0c6, 0x1ae, 0x0ff, 0x0df, 0x1b7, 0x0f7, 0x1a6)
};

#undef RULE50

int nextfiftyval(int par, int gpar, int d) {
  for(int i=0; i<7; i++) if(fiftytable[par][i] == gpar)
    return fiftytable[par][(i+d)%7];
  printf("fifty pattern error!\n");
  exit(1);
  }

int land50(int x) { return x&7; }

bool polara50(int x) { return x&8; }

bool polarb50(int x) { return x&16; }

int cdist50(int x) { 
  x /= 32;
  if(x == 0) return 0;
  if(x < 8) return 2;
  return 3;
  }

int zebratable[12][7] = {
  {50,  70,  60, 120,  80, 100,  64},
  {40,  65,  72, 130,  90, 110,  76},
  {45,  71,  56,  41, 101, 140, 126},
  {46,  51, 111, 150, 136,  55,  66},
  {43, 121, 145, 103,  93, 114, 106},
  {53, 131, 155, 113,  83, 104, 116},
  {42,  81, 115,  92,  84, 146,  63},
  {52,  91, 105,  82,  94, 156,  75},
  {44,  61, 141, 134, 152, 144,  86},
  {54,  73, 151, 124, 142, 154,  96},
  {62, 102,  85, 122, 153, 133, 125},
  {74, 112,  95, 132, 143, 123, 135}
  };

int zebratable6[28][3] = {
  {4,10,6}, {5,11,7}, {4,6,12}, {5,7,13},
  {8,14,10}, {9,15,11}, {4,8,10}, {5,9,11}, 
  {6,14,12}, {7,15,13}, {8,12,14}, {9,13,15},
  {4,7,6}, {5,6,7}, {4,6,5}, {4,5,7}, 
  {8,11,10}, {9,10,11}, {8,10,9}, {8,9,11},
  {12,15,14}, {13,14,15}, {12,14,13}, {12,13,15}, 
  {6,10,14}, {7,11,15}, {4,12,8}, {5,13,9}
  };

// rules for the emeraldvalues of heptagons.
int zebra_heptagon(int parent, int dir) {
  return zebratable[parent/10-4][(70+dir-(parent%10))%7];
  }

