/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _render_h
#define _render_h

#include "pm.h"

#ifdef render_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/** Outside view modes. */
typedef enum {
	render_VIEW_FORWARD,
	render_VIEW_UP,
	render_VIEW_DOWN,
	render_VIEW_LEFT,
	render_VIEW_RIGHT,
	render_VIEW_AFT,
	render_VIEW_CHASE
} render_ViewDirection;

typedef enum {render_GROUND_FLAT, render_GROUND_TILED} render_Ground;

/**
 * Set visibility range. Above that distance objects are not drawn and haze
 * effect is displayed instead. The default visibility range is 10 NM.
 * @param range Visibility range (m). The value is forced to the range
 * from 0.01 NM up to 50 NM (185 and 92650 m respectively).
 */
EXTERN void render_setVisibility(double range);

/**
 * Set ground depth mode.
 * @param mode The default depth mode is flat rendering.
 */
EXTERN void render_setGroundDepth(render_Ground mode);

/**
 * Set tick clouds layer range. No clouds if the top is less or equal to bottom.
 * @param base Clouds base altitude (m). Default: zero.
 * @param top Clouds top altitude (m). Default: zero.
 */
EXTERN void render_setClouds(double base, double top);

EXTERN void render_drawCockpitViews(void);
EXTERN void render_setOutsideView(craft * c, viewer *u, render_ViewDirection v);

#undef EXTERN
#endif
