// Generated by re2zig
// re2zig $INPUT -o $OUTPUT

const std = @import("std");

// Maximum number of capturing groups among all rules.
const yymaxnmatch = 4;

const none = std.math.maxInt(usize);

const SemVer = struct {
    major: u32,
    minor: u32,
    patch: u32,
};

fn s2n(str: []const u8) u32 { // convert pre-parsed string to a number
    var n: u32 = 0;
    for (str) |c| { n = n * 10 + (c - 48); }
    return n;
}

fn parse(yyinput: [:0]const u8) ?SemVer {
    var yycursor: usize = 0;
    var yymarker: usize = 0;

    // Allocate memory for capturing parentheses (twice the number of groups).
    var yynmatch: usize = 0;
    var yypmatch: [yymaxnmatch * 2]usize = undefined;

    // Intermediate tag variables used by the lexer (must be autogenerated).
    var yyt1: usize = none;var yyt2: usize = none;var yyt3: usize = none;var yyt4: usize = none;var yyt5: usize = none;

    
    var yych: u8 = 0;
    var yystate: u32 = 0;
    yyl: while (true) {
        switch (yystate) {
            0 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt1 = yycursor;
                        yycursor += 1;
                        yystate = 3;
                        continue :yyl;
                    },
                    else => {
                        yycursor += 1;
                        yystate = 1;
                        continue :yyl;
                    },
                }
            },
            1 => {
                yystate = 2;
                continue :yyl;
            },
            2 => { return null; },
            3 => {
                yymarker = yycursor;
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 2;
                        continue :yyl;
                    },
                }
            },
            4 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt2 = yycursor;
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            5 => {
                yycursor = yymarker;
                yystate = 2;
                continue :yyl;
            },
            6 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            7 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x00 => {
                        yyt3 = yycursor;
                        yyt4 = std.math.maxInt(usize);
                        yyt5 = std.math.maxInt(usize);
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x2E => {
                        yyt3 = yycursor;
                        yyt5 = yycursor;
                        yycursor += 1;
                        yystate = 9;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            8 => {
                yynmatch = 4;
                yypmatch[2] = yyt1;
                yypmatch[4] = yyt2;
                yypmatch[5] = yyt3;
                yypmatch[6] = yyt5;
                yypmatch[7] = yyt4;
                yypmatch[0] = yyt1;
                yypmatch[1] = yycursor;
                yypmatch[3] = yyt2;
                yypmatch[3] -= 1;
                
            // `yynmatch` is the number of capturing groups
            std.debug.assert(yynmatch == 4);

            // Even `yypmatch` values are for opening parentheses, odd values
            // are for closing parentheses, the first group is the whole match.
            return SemVer {
                .major = s2n(yyinput[yypmatch[2]..yypmatch[3]]),
                .minor = s2n(yyinput[yypmatch[4]..yypmatch[5]]),
                .patch = if (yypmatch[6] == none) 0 else s2n(yyinput[yypmatch[6] + 1..yypmatch[7]])
            };

            },
            9 => {
                yych = yyinput[yycursor];
                if (yych <= 0x00) {
                    yystate = 5;
                    continue :yyl;
                }
                yystate = 11;
                continue :yyl;
            },
            10 => {
                yych = yyinput[yycursor];
                yystate = 11;
                continue :yyl;
            },
            11 => {
                switch (yych) {
                    0x00 => {
                        yyt4 = yycursor;
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 10;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            else => { @panic("internal lexer error"); },
        }
    }

}

test {
    try std.testing.expectEqual(parse("23.34"), SemVer{.major = 23, .minor = 34, .patch = 0});
    try std.testing.expectEqual(parse("1.2.99999"), SemVer{.major = 1, .minor = 2, .patch = 99999});
    try std.testing.expectEqual(parse("1.a"), null);
}
