% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestRegistry.R
\name{HashCounter}
\alias{HashCounter}
\title{HashCounter}
\description{
hash with counter, to store requests, and count each time
it is used
}
\examples{
x <- HashCounter$new()
x$hash
z <- RequestSignature$new(method = "get", uri = "https:/httpbin.org/get")
x$put(z)
x$hash
x$get(z)
x$put(z)
x$get(z)
}
\seealso{
Other request-registry: 
\code{\link{RequestRegistry}},
\code{\link{request_registry}()}
}
\concept{request-registry}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hash}}{(list) a list for internal use only, with elements
\code{key}, \code{sig}, and \code{count}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-put}{\code{HashCounter$put()}}
\item \href{#method-get}{\code{HashCounter$get()}}
\item \href{#method-clone}{\code{HashCounter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
Register a request by it's key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashCounter$put(req_sig)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req_sig}}{an object of class \code{RequestSignature}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; registers request and iterates
internal counter
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Get a request by key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashCounter$get(req_sig)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req_sig}}{an object of class \code{RequestSignature}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(integer) the count of how many times the request has been made
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashCounter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
