% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_df_and_array.R
\name{array_df_ratetable_utils}
\alias{array_df_ratetable_utils}
\alias{long_df_to_array}
\alias{long_df_to_ratetable}
\alias{long_dt_to_array}
\alias{long_dt_to_ratetable}
\alias{array_to_long_df}
\alias{array_to_long_dt}
\alias{array_to_ratetable}
\alias{ratetable_to_array}
\alias{ratetable_to_long_df}
\alias{ratetable_to_long_dt}
\title{`array`s, `data.frame`s and `ratetable`s}
\usage{
long_df_to_array(x, stratum.col.nms, value.col.nm)

long_df_to_ratetable(
  x,
  stratum.col.nms,
  value.col.nm,
  dim.types,
  cut.points = NULL
)

long_dt_to_array(x, stratum.col.nms, value.col.nm)

long_dt_to_ratetable(
  x,
  stratum.col.nms,
  value.col.nm,
  dim.types,
  cut.points = NULL
)

array_to_long_df(x)

array_to_long_dt(x)

array_to_ratetable(x, dim.types, cut.points = NULL)

ratetable_to_array(x)

ratetable_to_long_df(x)

ratetable_to_long_dt(x)
}
\arguments{
\item{x}{`[data.frame, data.table, array, ratetable]` (mandatory, no default)

- `long_df_to_array`: a `data.frame`
- `long_df_to_ratetable`: a `data.frame`
- `long_dt_to_array`: a `data.table`
- `long_dt_to_ratetable`: a `data.table`
- `array_to_long_df`: an `array`
- `array_to_long_dt`: an `array`
- `array_to_ratetable`: an `array`
- `ratetable_to_array`: a [survival::ratetable]
- `ratetable_to_long_df`: a [survival::ratetable]
- `ratetable_to_long_dt`: a [survival::ratetable]}

\item{stratum.col.nms}{`[character]` (mandatory, no default)

a vector of column names in `x` by which values are stratified}

\item{value.col.nm}{`[character]` (mandatory, no default)

name of column in `x` containing values (these will be contents of the
array)}

\item{dim.types}{`[integer]` (mandatory, no default)

see `type` under **Details** in [survival::ratetable]}

\item{cut.points}{`[NULL, list]` (optional, default `NULL`)

see `cutpoints` under **Details** in [survival::ratetable] 

- `NULL`: automatically set using `dimnames(x)` and `dim.types`
- `list`: one element for each dimensions of `x`}
}
\value{
- `long_df_to_array`: an `array`
- `long_df_to_ratetable`: a [survival::ratetable]
- `long_dt_to_array`: an `array`
- `long_dt_to_ratetable`: a [survival::ratetable]
- `array_to_long_df`: an `data.frame`
- `array_to_long_dt`: an `data.table`
- `array_to_ratetable`: a [survival::ratetable]
- `ratetable_to_array`: an `array`
- `ratetable_to_long_df`: a `data.frame`
- `ratetable_to_long_dt`: a `data.table`
}
\description{
Utilities to transform objects between `array`, `data.frame`, and
[survival::ratetable].
}
\details{
- `long_df_to_array`: converts a long-format `data.frame` to an `array`
  with one or more dimensions

- `long_df_to_ratetable`: calls `long_df_to_array` and then 
  `array_to_ratetable`

- `long_dt_to_array`: simply asserts that `x` is a `data.table` and 
calls `long_df_to_array`

- `long_dt_to_ratetable`: calls `long_dt_to_array` and then 
  `array_to_ratetable`

- `array_to_long_df`: converts an array with one or more dimensions into
  a long-format `data.frame`; any [dimnames] are used to name and fill the 
  stratifying columns; for dimensions without a name, `".dX"` is used
  for stratifying column number `X`; for each `k`, if there are no contents
  in `dimnames(x)[[k]]`, the elements of `seq(dim(x)[k])` are used to fill 
  the corresponding stratifying column; the value column always has the name
  `"value"`

- `array_to_long_dt`: calls `array_to_long_df` and converts result to a 
  `data.table` for convenience

- `array_to_ratetable`: converts an array to a [survival::ratetable]

- `ratetable_to_array`: converts a [survival::ratetable] to an array

- `ratetable_to_long_df`: calls `ratetable_to_array` and then
  `array_to_long_df`

- `ratetable_to_long_dt`: calls `ratetable_to_array` and then
  `array_to_long_dt`
}
\examples{

long_dt <- popEpi::popmort
arr <- long_df_to_array(long_dt, c("agegroup", "year", "sex"), "haz") 
rt <- array_to_ratetable(arr, dim.types = c(2L, 4L, 1L))

arr2 <- ratetable_to_array(rt)
long_df2 <- array_to_long_df(arr2)

identical(sort(long_dt[["haz"]]), sort(long_df2[["value"]]))
}
