import os
import sipconfig
from PyQt4 import pyqtconfig

config = pyqtconfig.Configuration()

# The name of the SIP build file generated by SIP and used by the build
# system.
build_file = "pictureflow.sbf"
sip_files_dir = "sip"
output_dir = "pictureflow"

if not os.path.exists(output_dir):
    os.mkdir(output_dir)

# Build the pictureflow library.
os.system("cd lib; qmake; make")

# Run SIP to generate the code.
command = " ".join(
    [config.sip_bin, "-c", output_dir, "-b", os.path.join(output_dir, build_file),
     "-I"+config.pyqt_sip_dir,
     "-I"+config.qt_inc_dir, config.pyqt_sip_flags,
     os.path.join(sip_files_dir, "pictureflowmod.sip")]
    )

print command
os.system(command)

# Create the Makefile.
makefile = pyqtconfig.QtGuiModuleMakefile(
    config, build_file, dir=output_dir
    )
makefile.extra_include_dirs.append(os.path.abspath(os.pardir))
makefile.extra_lib_dirs.append(os.path.abspath(os.curdir))
makefile.extra_lib_dirs.append(os.path.abspath("lib"))
makefile.extra_libs.append("pictureflow")

# Generate the Makefile itself.
config.pyqt_modules = config.pyqt_modules.split()
makefile.generate()
del config.pyqt_modules

sipconfig.ParentMakefile(
    configuration = config,
    subdirs = [output_dir]
    ).generate()
