# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-virtualenclaves
# USAGE
    python community_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = VirtualEnclavesMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.community.begin_create_or_update(
        resource_group_name="rgopenapi",
        community_name="TestMyCommunity",
        resource={
            "identity": {
                "type": "SystemAssigned,UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {}
                },
            },
            "location": "westcentralus",
            "properties": {
                "addressSpace": "10.0.0.0/24",
                "approvalSettings": {
                    "connectionCreation": "Required",
                    "connectionDeletion": "NotRequired",
                    "connectionUpdate": "Required",
                    "enclaveCreation": "NotRequired",
                    "enclaveDeletion": "NotRequired",
                    "endpointCreation": "NotRequired",
                    "endpointDeletion": "NotRequired",
                    "endpointUpdate": "Required",
                    "maintenanceMode": "NotRequired",
                    "mandatoryApprovers": [{"approverEntraId": "00000000-0000-0000-0000-000000000000"}],
                    "minimumApproversRequired": 0,
                    "notificationOnApprovalAction": "NotRequired",
                    "notificationOnApprovalCreation": "NotRequired",
                    "notificationOnApprovalDeletion": "NotRequired",
                    "serviceCatalogDeployment": "NotRequired",
                },
                "communityRoleAssignments": [
                    {
                        "principals": [
                            {"id": "01234567-89ab-ef01-2345-0123456789ab", "type": "Group"},
                            {"id": "355a6bb0-abc0-4cba-000d-12a345b678c0", "type": "User"},
                        ],
                        "roleDefinitionId": "b24988ac-6180-42a0-ab88-20f7382dd24c",
                    },
                    {
                        "principals": [{"id": "355a6bb0-abc0-4cba-000d-12a345b678c9", "type": "User"}],
                        "roleDefinitionId": "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9",
                    },
                ],
                "dnsServers": ["azure.net"],
                "firewallSku": "Standard",
                "governedServiceList": [
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "AKS"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "AppService"},
                    {
                        "enforcement": "Enabled",
                        "option": "Allow",
                        "policyAction": "None",
                        "serviceId": "ContainerRegistry",
                    },
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "CosmosDB"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "KeyVault"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "MicrosoftSQL"},
                    {
                        "enforcement": "Enabled",
                        "option": "Not Applicable",
                        "policyAction": "None",
                        "serviceId": "Monitoring",
                    },
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "PostgreSQL"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "ServiceBus"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "Storage"},
                    {
                        "enforcement": "Enabled",
                        "option": "Allow",
                        "policyAction": "None",
                        "serviceId": "AzureFirewalls",
                    },
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "Insights"},
                    {"enforcement": "Enabled", "option": "Allow", "policyAction": "None", "serviceId": "Logic"},
                    {
                        "enforcement": "Enabled",
                        "option": "Allow",
                        "policyAction": "None",
                        "serviceId": "PrivateDNSZones",
                    },
                    {
                        "enforcement": "Enabled",
                        "option": "Allow",
                        "policyAction": "None",
                        "serviceId": "DataConnectors",
                    },
                ],
                "maintenanceModeConfiguration": {
                    "justification": "Off",
                    "mode": "Off",
                    "principals": [{"id": "355a6bb0-abc0-4cba-000d-12a345b678c9", "type": "User"}],
                },
            },
            "tags": {"sampletag": "samplevalue"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-05-01-preview/Community_CreateOrUpdate.json
if __name__ == "__main__":
    main()
