# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionPerformed(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the action performed by the approver."""

    APPROVED = "Approved"
    """Action was Approved"""
    REJECTED = "Rejected"
    """Action was Rejected"""


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ApprovalPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Approval Policy."""

    REQUIRED = "Required"
    """Approval will be required for the specified action."""
    NOT_REQUIRED = "NotRequired"
    """Approval will not be required for the specified action."""


class ApprovalStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Approval Status. It can be Approved, Rejected, Pending, Deleted or Expired."""

    APPROVED = "Approved"
    """ApprovalStatus Type Approved"""
    REJECTED = "Rejected"
    """ApprovalStatus Type Rejected"""
    PENDING = "Pending"
    """ApprovalStatus Type Pending"""
    DELETED = "Deleted"
    """ApprovalStatus Type Deleted"""
    EXPIRED = "Expired"
    """ApprovalStatus Type Expired"""


class CommunityEndpointProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Community Endpoint Protocol Enum."""

    ANY = "ANY"
    """CommunityEndpointProtocol Type ANY"""
    TCP = "TCP"
    """CommunityEndpointProtocol Type TCP"""
    UDP = "UDP"
    """CommunityEndpointProtocol Type UDP"""
    ICMP = "ICMP"
    """CommunityEndpointProtocol Type ICMP"""
    ESP = "ESP"
    """CommunityEndpointProtocol Type ESP"""
    AH = "AH"
    """CommunityEndpointProtocol Type AH"""
    HTTPS = "HTTPS"
    """CommunityEndpointProtocol Type HTTPS"""
    HTTP = "HTTP"
    """CommunityEndpointProtocol Type HTTP"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Destination Type Enum."""

    FQDN = "FQDN"
    """DestinationType Type FQDN"""
    FQDN_TAG = "FQDNTag"
    """DestinationType Type FQDNTag"""
    IP_ADDRESS = "IPAddress"
    """DestinationType Type IPAddress"""
    PRIVATE_NETWORK = "PrivateNetwork"
    """DestinationType Type PrivateNetwork"""


class DiagnosticDestination(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the destination of where to store diagnostic logs."""

    COMMUNITY_ONLY = "CommunityOnly"
    """DiagnosticDestination Type CommunityOnly"""
    ENCLAVE_ONLY = "EnclaveOnly"
    """DiagnosticDestination Type EnclaveOnly"""
    BOTH = "Both"
    """DiagnosticDestination Type Both"""


class EnclaveConnectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the state of the enclave connection."""

    PENDING_APPROVAL = "PendingApproval"
    """EnclaveConnectionState Type Pending Approval"""
    PENDING_UPDATE = "PendingUpdate"
    """EnclaveConnectionState Type Pending Update"""
    APPROVED = "Approved"
    """EnclaveConnectionState Type Approved"""
    ACTIVE = "Active"
    """EnclaveConnectionState Type Active"""
    FAILED = "Failed"
    """EnclaveConnectionState Type Failed"""
    CONNECTED = "Connected"
    """EnclaveConnectionState Type Connected"""
    DISCONNECTED = "Disconnected"
    """EnclaveConnectionState Type Disconnected"""


class EnclaveEndpointProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enclave Endpoint Protocol Enum."""

    ANY = "ANY"
    """EndpointProtocol Type ANY"""
    TCP = "TCP"
    """EndpointProtocol Type TCP"""
    UDP = "UDP"
    """EndpointProtocol Type UDP"""
    ICMP = "ICMP"
    """EndpointProtocol Type ICMP"""
    ESP = "ESP"
    """EndpointProtocol Type ESP"""
    AH = "AH"
    """EndpointProtocol Type AH"""


class FirewallSKU(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure Firewall SKU."""

    BASIC = "Basic"
    """FirewallSKU Basic"""
    STANDARD = "Standard"
    """FirwallSKU Standard"""
    PREMIUM = "Premium"
    """FirewallSKU Premium"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning status of the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    ACCEPTED = "Accepted"
    """Provisioning State Type Accepted"""
    CREATING = "Creating"
    """Provisioning State Type Creating"""
    DELETING = "Deleting"
    """Provisioning State Type Deleting"""
    NOT_SPECIFIED = "NotSpecified"
    """Provisioning State Type NotSpecified"""
    RUNNING = "Running"
    """Provisioning State Type Running"""
    UPDATING = "Updating"
    """Provisioning State Type Updating"""


class ServiceIdentifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifier for governed services."""

    AKS = "AKS"
    """Service identifier for AKS"""
    APP_SERVICE = "AppService"
    """Service identifier for App Service"""
    AZURE_FIREWALLS = "AzureFirewalls"
    """Service identifier for Azure Firewalls"""
    CONTAINER_REGISTRY = "ContainerRegistry"
    """Service identifier for Container Registry"""
    COSMOS_DB = "CosmosDB"
    """Service identifier for CosmosDB"""
    DATA_CONNECTORS = "DataConnectors"
    """Service identifier for Data Connectors"""
    INSIGHTS = "Insights"
    """Service identifier for Insights"""
    KEY_VAULT = "KeyVault"
    """Service identifier for Key Vault"""
    LOGIC = "Logic"
    """Service identifier for Logic"""
    MICROSOFT_SQL = "MicrosoftSQL"
    """Service identifier for Microsoft SQL"""
    MONITORING = "Monitoring"
    """Service identifier for Monitoring"""
    POSTGRE_SQL = "PostgreSQL"
    """Service identifier for PostgreSQL"""
    PRIVATE_DNS_ZONES = "PrivateDNSZones"
    """Service identifier for Private DNS Zones"""
    SERVICE_BUS = "ServiceBus"
    """Service identifier for Service Bus"""
    STORAGE = "Storage"
    """Service identifier for Storage"""


class TransitHubState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the state of the transitHub."""

    PENDING_APPROVAL = "PendingApproval"
    """TransitHubState Type PendingApproval"""
    APPROVED = "Approved"
    """TransitHubState Type Approved"""
    PENDING_UPDATE = "PendingUpdate"
    """TransitHubState Type PendingUpdate"""
    ACTIVE = "Active"
    """TransitHubState Type Active"""
    FAILED = "Failed"
    """TransitHubState Type Failed"""


class TransitOptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the transitOption."""

    EXPRESS_ROUTE = "ExpressRoute"
    """TransitOptionType ExpressRoute"""
    GATEWAY = "Gateway"
    """TransitOptionType Gateway"""
    PEERING = "Peering"
    """TransitOptionType Peering"""
