# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class DetectedLanguage(_Model):
    """An object describing the detected language.

    :ivar language: A string representing the code of the detected language. Required.
    :vartype language: str
    :ivar score: A float value indicating the confidence in the result.
     The score is between zero and one and a low score indicates a low confidence. Required.
    :vartype score: float
    """

    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string representing the code of the detected language. Required."""
    score: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A float value indicating the confidence in the result.
     The score is between zero and one and a low score indicates a low confidence. Required."""

    @overload
    def __init__(
        self,
        *,
        language: str,
        score: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorDetails(_Model):
    """Error details as returned by Translator Service.

    :ivar code: String identifier of the error. Required.
    :vartype code: str
    :ivar message: Human readable error description. Required.
    :vartype message: str
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """String identifier of the error. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human readable error description. Required."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Representation of the Error Response from Translator Service.

    :ivar error: Error details. Required.
    :vartype error: ~azure.ai.translation.text.models.ErrorDetails
    """

    error: "_models.ErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.ErrorDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GetSupportedLanguagesResult(_Model):
    """Response for the languages API.

    :ivar translation: Languages that support translate API.
    :vartype translation: dict[str, ~azure.ai.translation.text.models.TranslationLanguage]
    :ivar transliteration: Languages that support transliteration API.
    :vartype transliteration: dict[str, ~azure.ai.translation.text.models.TransliterationLanguage]
    :ivar models: LLM models supported.
    :vartype models: list[str]
    """

    translation: Optional[dict[str, "_models.TranslationLanguage"]] = rest_field(visibility=["read"])
    """Languages that support translate API."""
    transliteration: Optional[dict[str, "_models.TransliterationLanguage"]] = rest_field(visibility=["read"])
    """Languages that support transliteration API."""
    models: Optional[list[str]] = rest_field(visibility=["read"])
    """LLM models supported."""


class InputTextItem(_Model):
    """Element containing the text for translation.

    :ivar text: Text to translate. Required.
    :vartype text: str
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text to translate. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageScript(_Model):
    """Common properties of language script.

    :ivar code: Code identifying the script. Required.
    :vartype code: str
    :ivar name: Display name of the script in the locale requested via Accept-Language header.
     Required.
    :vartype name: str
    :ivar native_name: Display name of the language in the locale native for the language.
     Required.
    :vartype native_name: str
    :ivar dir: Directionality, which is rtl for right-to-left languages or ltr for left-to-right
     languages. Required. Known values are: "ltr" and "rtl".
    :vartype dir: str or ~azure.ai.translation.text.models.LanguageDirectionality
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Code identifying the script. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display name of the script in the locale requested via Accept-Language header. Required."""
    native_name: str = rest_field(name="nativeName", visibility=["read", "create", "update", "delete", "query"])
    """Display name of the language in the locale native for the language. Required."""
    dir: Union[str, "_models.LanguageDirectionality"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Directionality, which is rtl for right-to-left languages or ltr for left-to-right languages.
     Required. Known values are: \"ltr\" and \"rtl\"."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        name: str,
        native_name: str,
        dir: Union[str, "_models.LanguageDirectionality"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReferenceTextPair(_Model):
    """Reference text pair to generate adaptive customized translation.

    :ivar source: Source reference sentence. Required.
    :vartype source: str
    :ivar target: Target reference sentence. Required.
    :vartype target: str
    """

    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source reference sentence. Required."""
    target: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target reference sentence. Required."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        target: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslateBody(_Model):
    """Request data for translate.

    :ivar inputs: Array of the input text elements to translate. Required.
    :vartype inputs: list[~azure.ai.translation.text.models.TranslateInputItem]
    """

    inputs: list["_models.TranslateInputItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of the input text elements to translate. Required."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.TranslateInputItem"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslatedTextItem(_Model):
    """Element containing the translated text.

    :ivar detected_language: The detectedLanguage property is only present in the result object
     when language auto-detection is requested.
    :vartype detected_language: ~azure.ai.translation.text.models.DetectedLanguage
    :ivar translations: An array of translation results. The size of the array matches the number
     of target
     languages specified through the to query parameter. Required.
    :vartype translations: list[~azure.ai.translation.text.models.TranslationText]
    """

    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The detectedLanguage property is only present in the result object when language auto-detection
     is requested."""
    translations: list["_models.TranslationText"] = rest_field(visibility=["read"])
    """An array of translation results. The size of the array matches the number of target
     languages specified through the to query parameter. Required."""

    @overload
    def __init__(
        self,
        *,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslateInputItem(_Model):
    """Element containing the text for translation.

    :ivar text: Text to translate. Required.
    :vartype text: str
    :ivar script: Specifies the script of the input text.
    :vartype script: str
    :ivar language: Specifies the language of the input text. Find which languages are available to
     translate by
     looking up supported languages using the translation scope. If the language parameter isn't
     specified, automatic language detection is applied to determine the source language.

     You must use the language parameter rather than autodetection when using the dynamic dictionary
     feature.
     Note: the dynamic dictionary feature is case-sensitive.
    :vartype language: str
    :ivar text_type: Defines whether the text being translated is plain text or HTML text. Any HTML
     needs to be a well-formed,
     complete element. Possible values are: plain (default) or html. Known values are: "Plain" and
     "Html".
    :vartype text_type: str or ~azure.ai.translation.text.models.TextType
    :ivar targets: Translation target parameters. Required.
    :vartype targets: list[~azure.ai.translation.text.models.TranslationTarget]
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text to translate. Required."""
    script: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the script of the input text."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the language of the input text. Find which languages are available to translate by
     looking up supported languages using the translation scope. If the language parameter isn't
     specified, automatic language detection is applied to determine the source language.
     
     You must use the language parameter rather than autodetection when using the dynamic dictionary
     feature.
     Note: the dynamic dictionary feature is case-sensitive."""
    text_type: Optional[Union[str, "_models.TextType"]] = rest_field(
        name="textType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines whether the text being translated is plain text or HTML text. Any HTML needs to be a
     well-formed,
     complete element. Possible values are: plain (default) or html. Known values are: \"Plain\" and
     \"Html\"."""
    targets: list["_models.TranslationTarget"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Translation target parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        targets: list["_models.TranslationTarget"],
        script: Optional[str] = None,
        language: Optional[str] = None,
        text_type: Optional[Union[str, "_models.TextType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationLanguage(_Model):
    """The value of the translation property is a dictionary of (key, value) pairs. Each key is a BCP
    47 language tag.
    A key identifies a language for which text can be translated to or translated from.

    :ivar name: Display name of the language in the locale requested via Accept-Language header.
     Required.
    :vartype name: str
    :ivar native_name: Display name of the language in the locale native for this language.
     Required.
    :vartype native_name: str
    :ivar dir: Directionality, which is rtl for right-to-left languages or ltr for left-to-right
     languages. Required. Known values are: "ltr" and "rtl".
    :vartype dir: str or ~azure.ai.translation.text.models.LanguageDirectionality
    :ivar models: LLM models supported for translation. Required.
    :vartype models: list[str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display name of the language in the locale requested via Accept-Language header. Required."""
    native_name: str = rest_field(name="nativeName", visibility=["read", "create", "update", "delete", "query"])
    """Display name of the language in the locale native for this language. Required."""
    dir: Union[str, "_models.LanguageDirectionality"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Directionality, which is rtl for right-to-left languages or ltr for left-to-right languages.
     Required. Known values are: \"ltr\" and \"rtl\"."""
    models: list[str] = rest_field(visibility=["read"])
    """LLM models supported for translation. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        native_name: str,
        dir: Union[str, "_models.LanguageDirectionality"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationResult(_Model):
    """Response for the translation API.

    :ivar value: Array of the translated text elements. Required.
    :vartype value: list[~azure.ai.translation.text.models.TranslatedTextItem]
    """

    value: list["_models.TranslatedTextItem"] = rest_field(visibility=["read"])
    """Array of the translated text elements. Required."""


class TranslationTarget(_Model):
    """Target language and translation configuration parameters.

    :ivar language: Specifies the language of the output text. The target language must be one of
     the supported languages included
     in the translation scope. It's possible to translate to multiple languages simultaneously by
     including
     multiple string values in the targetsLanguage array. Required.
    :vartype language: str
    :ivar script: Specifies the script of the translated text.
    :vartype script: str
    :ivar profanity_action: Specifies how profanities should be treated in translations.
     Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
     "Marked", and "Deleted".
    :vartype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
    :ivar profanity_marker: Specifies how profanities should be marked in translations.
     Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
    :vartype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
    :ivar deployment_name: Default is 'general', which uses NMT system.
     'abc-inc-gpt-4o', and 'abc-inc-gpt-4o-mini' are examples of deployment names which use GPT-4o
     uses or
     GPT-4o-mini model. 'gpt-4o' uses GPT-4o model.

     '<custom model id>' uses the custom NMT model tuned by customer.
     'best' system determines which is the best model to use for the request. This intelligence
     could be introduced
     in future. Customer should have deployed it in their resource.
    :vartype deployment_name: str
    :ivar allow_fallback: In the case where a custom system is being used, specifies that the
     service is allowed to fall back to a
     general system when a custom system doesn't exist.
     In the case where a Large Language Model is being used, specifies that the service is allowed
     to fall
     back to a Small Language Model if an error occurs.
     Possible values are: true (default) or false.

     allowFallback=false specifies that the translation should only use systems trained for the
     category specified
     by the request. If a translation for language X to language Y requires chaining through a pivot
     language E,
     then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
     category.
     If no system is found with the specific category, the request will return a 400 status code.
     allowFallback=true
     specifies that the service is allowed to fall back to a general system when a custom system
     doesn't exist.
    :vartype allow_fallback: bool
    :ivar grade: Defines complexity of LLM prompts to provide high accuracy translation.
    :vartype grade: str
    :ivar tone: Desired tone of target translation.
    :vartype tone: str
    :ivar gender: Desired gender of target translation.
    :vartype gender: str
    :ivar adaptive_dataset_id: Reference dataset ID having sentence pair to generate adaptive
     customized translation.
    :vartype adaptive_dataset_id: str
    :ivar reference_text_pairs: Reference text pairs to generate adaptive customized translation.
    :vartype reference_text_pairs: list[~azure.ai.translation.text.models.ReferenceTextPair]
    """

    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the language of the output text. The target language must be one of the supported
     languages included
     in the translation scope. It's possible to translate to multiple languages simultaneously by
     including
     multiple string values in the targetsLanguage array. Required."""
    script: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the script of the translated text."""
    profanity_action: Optional[Union[str, "_models.ProfanityAction"]] = rest_field(
        name="profanityAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how profanities should be treated in translations.
     Possible values are: NoAction (default), Marked or Deleted. Known values are: \"NoAction\",
     \"Marked\", and \"Deleted\"."""
    profanity_marker: Optional[Union[str, "_models.ProfanityMarker"]] = rest_field(
        name="profanityMarker", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how profanities should be marked in translations.
     Possible values are: Asterisk (default) or Tag. Known values are: \"Asterisk\" and \"Tag\"."""
    deployment_name: Optional[str] = rest_field(
        name="deploymentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Default is 'general', which uses NMT system.
     'abc-inc-gpt-4o', and 'abc-inc-gpt-4o-mini' are examples of deployment names which use GPT-4o
     uses or
     GPT-4o-mini model. 'gpt-4o' uses GPT-4o model.
     
     '<custom model id>' uses the custom NMT model tuned by customer.
     'best' system determines which is the best model to use for the request. This intelligence
     could be introduced
     in future. Customer should have deployed it in their resource."""
    allow_fallback: Optional[bool] = rest_field(
        name="allowFallback", visibility=["read", "create", "update", "delete", "query"]
    )
    """In the case where a custom system is being used, specifies that the service is allowed to fall
     back to a
     general system when a custom system doesn't exist.
     In the case where a Large Language Model is being used, specifies that the service is allowed
     to fall
     back to a Small Language Model if an error occurs.
     Possible values are: true (default) or false.
     
     allowFallback=false specifies that the translation should only use systems trained for the
     category specified
     by the request. If a translation for language X to language Y requires chaining through a pivot
     language E,
     then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
     category.
     If no system is found with the specific category, the request will return a 400 status code.
     allowFallback=true
     specifies that the service is allowed to fall back to a general system when a custom system
     doesn't exist."""
    grade: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Defines complexity of LLM prompts to provide high accuracy translation."""
    tone: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Desired tone of target translation."""
    gender: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Desired gender of target translation."""
    adaptive_dataset_id: Optional[str] = rest_field(
        name="adaptiveDatasetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference dataset ID having sentence pair to generate adaptive customized translation."""
    reference_text_pairs: Optional[list["_models.ReferenceTextPair"]] = rest_field(
        name="referenceTextPairs", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference text pairs to generate adaptive customized translation."""

    @overload
    def __init__(
        self,
        *,
        language: str,
        script: Optional[str] = None,
        profanity_action: Optional[Union[str, "_models.ProfanityAction"]] = None,
        profanity_marker: Optional[Union[str, "_models.ProfanityMarker"]] = None,
        deployment_name: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        grade: Optional[str] = None,
        tone: Optional[str] = None,
        gender: Optional[str] = None,
        adaptive_dataset_id: Optional[str] = None,
        reference_text_pairs: Optional[list["_models.ReferenceTextPair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranslationText(_Model):
    """Translation result.

    :ivar language: A string representing the language code of the target language. Required.
    :vartype language: str
    :ivar source_characters: An integer indicating the number of characters in the source text
     string.
    :vartype source_characters: int
    :ivar instruction_tokens: An integer indicating the number of tokens used in generating the
     translated text.
    :vartype instruction_tokens: int
    :ivar source_tokens: An integer indicating the number of tokens used in the source sentence.
    :vartype source_tokens: int
    :ivar response_tokens: An integer indicating the number of tokens used in the translation
     response.
    :vartype response_tokens: int
    :ivar target_tokens: An integer indicating the number of tokens used in the target sentence.
    :vartype target_tokens: int
    :ivar text: A string giving the translated text. Required.
    :vartype text: str
    """

    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string representing the language code of the target language. Required."""
    source_characters: Optional[int] = rest_field(
        name="sourceCharacters", visibility=["read", "create", "update", "delete", "query"]
    )
    """An integer indicating the number of characters in the source text string."""
    instruction_tokens: Optional[int] = rest_field(
        name="instructionTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """An integer indicating the number of tokens used in generating the translated text."""
    source_tokens: Optional[int] = rest_field(
        name="sourceTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """An integer indicating the number of tokens used in the source sentence."""
    response_tokens: Optional[int] = rest_field(
        name="responseTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """An integer indicating the number of tokens used in the translation response."""
    target_tokens: Optional[int] = rest_field(
        name="targetTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """An integer indicating the number of tokens used in the target sentence."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string giving the translated text. Required."""

    @overload
    def __init__(
        self,
        *,
        language: str,
        text: str,
        source_characters: Optional[int] = None,
        instruction_tokens: Optional[int] = None,
        source_tokens: Optional[int] = None,
        response_tokens: Optional[int] = None,
        target_tokens: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransliterableScript(LanguageScript):
    """Script definition with list of script into which given script can be translitered.

    :ivar code: Code identifying the script. Required.
    :vartype code: str
    :ivar name: Display name of the script in the locale requested via Accept-Language header.
     Required.
    :vartype name: str
    :ivar native_name: Display name of the language in the locale native for the language.
     Required.
    :vartype native_name: str
    :ivar dir: Directionality, which is rtl for right-to-left languages or ltr for left-to-right
     languages. Required. Known values are: "ltr" and "rtl".
    :vartype dir: str or ~azure.ai.translation.text.models.LanguageDirectionality
    :ivar to_scripts: List of scripts available to convert text to. Required.
    :vartype to_scripts: list[~azure.ai.translation.text.models.LanguageScript]
    """

    to_scripts: list["_models.LanguageScript"] = rest_field(
        name="toScripts", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of scripts available to convert text to. Required."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        name: str,
        native_name: str,
        dir: Union[str, "_models.LanguageDirectionality"],
        to_scripts: list["_models.LanguageScript"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransliterateBody(_Model):
    """Request data for transliterate.

    :ivar inputs: Array of the input text elements to transliterate. Required.
    :vartype inputs: list[~azure.ai.translation.text.models.InputTextItem]
    """

    inputs: list["_models.InputTextItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of the input text elements to transliterate. Required."""

    @overload
    def __init__(
        self,
        *,
        inputs: list["_models.InputTextItem"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransliteratedText(_Model):
    """Transliterated text element.

    :ivar text: A string which is the result of converting the input string to the output script.
     Required.
    :vartype text: str
    :ivar script: A string specifying the script used in the output. Required.
    :vartype script: str
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string which is the result of converting the input string to the output script. Required."""
    script: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string specifying the script used in the output. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        script: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransliterateResult(_Model):
    """Response for the transliteration API.

    :ivar value: Array of transliterated texts. Required.
    :vartype value: list[~azure.ai.translation.text.models.TransliteratedText]
    """

    value: list["_models.TransliteratedText"] = rest_field(visibility=["read"])
    """Array of transliterated texts. Required."""


class TransliterationLanguage(_Model):
    """The value of the transliteration property is a dictionary of (key, value) pairs.
    Each key is a BCP 47 language tag. A key identifies a language for which text can be converted
    from one script
    to another script.

    :ivar name: Display name of the language in the locale requested via Accept-Language header.
     Required.
    :vartype name: str
    :ivar native_name: Display name of the language in the locale native for this language.
     Required.
    :vartype native_name: str
    :ivar scripts: List of scripts to convert from. Required.
    :vartype scripts: list[~azure.ai.translation.text.models.TransliterableScript]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display name of the language in the locale requested via Accept-Language header. Required."""
    native_name: str = rest_field(name="nativeName", visibility=["read", "create", "update", "delete", "query"])
    """Display name of the language in the locale native for this language. Required."""
    scripts: list["_models.TransliterableScript"] = rest_field(visibility=["read"])
    """List of scripts to convert from. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        native_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
