# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dataprotection import DataProtectionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataProtectionMgmtDppResourceGuardProxyOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataProtectionMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dpp_resource_guard_proxy_get(self, resource_group):
        response = self.client.dpp_resource_guard_proxy.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            resource_guard_proxy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dpp_resource_guard_proxy_create_or_update(self, resource_group):
        response = self.client.dpp_resource_guard_proxy.create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            resource_guard_proxy_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "description": "str",
                    "lastUpdatedTime": "str",
                    "resourceGuardOperationDetails": [
                        {"defaultResourceRequest": "str", "vaultCriticalOperation": "str"}
                    ],
                    "resourceGuardResourceId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dpp_resource_guard_proxy_delete(self, resource_group):
        response = self.client.dpp_resource_guard_proxy.delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            resource_guard_proxy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dpp_resource_guard_proxy_list(self, resource_group):
        response = self.client.dpp_resource_guard_proxy.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dpp_resource_guard_proxy_unlock_delete(self, resource_group):
        response = self.client.dpp_resource_guard_proxy.unlock_delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            resource_guard_proxy_name="str",
            parameters={"resourceGuardOperationRequests": ["str"], "resourceToBeDeleted": "str"},
        )

        # please add some check logic here by yourself
        # ...
