# Detect development libraries for Advantech I/O card.
# These variables are set:
#
#   ADVANTECH_FOUND
#   ADVANTECH_INCLUDE_DIR
#   ADVANTECH_LIBRARIES
#
# Only works on Windows

if (ADVANTECH_INCLUDE_DIR)
  # Already in cache, be silent
  set (Advantech_FIND_QUIETLY TRUE)
endif ()

FIND_PATH (ADVANTECH_INCLUDE_DIR "Driver.h"
  "C:/Program Files/Advantech/Adsapi/Include"
  DOC "Path to ADVANTECH include files.")

FIND_PATH (ADVANTECH_LIBRARY_PATH "ADSDEV.lib"
  "C:/Program Files/Advantech/Adsapi/Lib"
  DOC "Path to ADVANTECH libraries.")

FIND_LIBRARY(ADVANTECH_ADS841_LIB ADS841 ${ADVANTECH_LIBRARY_PATH})
FIND_LIBRARY(ADVANTECH_Adsapi32_LIB Adsapi32 ${ADVANTECH_LIBRARY_PATH})
FIND_LIBRARY(ADVANTECH_Adsapi32bcb_LIB Adsapi32bcb ${ADVANTECH_LIBRARY_PATH})
FIND_LIBRARY(ADVANTECH_Adscomm_LIB Adscomm ${ADVANTECH_LIBRARY_PATH})
FIND_LIBRARY(ADVANTECH_ADSDEV_LIB ADSDEV ${ADVANTECH_LIBRARY_PATH})
FIND_LIBRARY(ADVANTECH_adsdnet_LIB adsdnet ${ADVANTECH_LIBRARY_PATH})

if (ADVANTECH_Adscomm_LIB AND ADVANTECH_Adsapi32_LIB)
  set (ADVANTECH_LIBRARIES ${ADVANTECH_Adscomm_LIB} ${ADVANTECH_Adsapi32_LIB})
else ()
  set (ADVANTECH_LIBRARIES)
endif ()

INCLUDE (FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS (Advantech DEFAULT_MSG 
  ADVANTECH_LIBRARIES ADVANTECH_INCLUDE_DIR)

MARK_AS_ADVANCED (
  ADVANTECH_ADS841_LIB
  ADVANTECH_Adsapi32_LIB
  ADVANTECH_Adsapi32bcb_LIB
  ADVANTECH_Adscomm_LIB
  ADVANTECH_ADSDEV_LIB
  ADVANTECH_adsdnet_LIB)
