char volume_accumulateSamples_mip_tf_frag[] = "#version 110\n"
                                              "\n"
                                              "uniform sampler3D volumeTexture;\n"
                                              "\n"
                                              "uniform float TransparencyValue;\n"
                                              "uniform float AlphaFuncValue;\n"
                                              "uniform sampler1D tfTexture;\n"
                                              "uniform float tfScale;\n"
                                              "uniform float tfOffset;\n"
                                              "\n"
                                              "vec4 accumulateSamples(vec4 fragColor, vec3 ts, vec3 te, vec3 dt, float scale, float cutoff, int num_iterations)\n"
                                              "{\n"
                                              "    vec3 texcoord = te.xyz;\n"
                                              "\n"
                                              "    float max_a = 0.0;\n"
                                              "    while(num_iterations>0)\n"
                                              "    {\n"
                                              "        float a = texture3D( volumeTexture, texcoord).a;\n"
                                              "\n"
                                              "        if (a>max_a)\n"
                                              "        {\n"
                                              "            float v = a * tfScale + tfOffset;\n"
                                              "            vec4 color = texture1D( tfTexture, v);\n"
                                              "            if (color.a>AlphaFuncValue)\n"
                                              "            {\n"
                                              "                fragColor = color;\n"
                                              "                max_a = a;\n"
                                              "            }\n"
                                              "        }\n"
                                              "\n"
                                              "        texcoord += dt;\n"
                                              "\n"
                                              "        --num_iterations;\n"
                                              "    }\n"
                                              "\n"
                                              "    fragColor.a *= TransparencyValue;\n"
                                              "\n"
                                              "    return fragColor;\n"
                                              "}\n"
                                              "\n";
