/* basetransport.c generated by valac 0.16.1, the Vala compiler
 * generated from basetransport.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include <sys/time.h>
#include <time.h>


#define FSO_FRAMEWORK_TYPE_TRANSPORT (fso_framework_transport_get_type ())
#define FSO_FRAMEWORK_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransport))
#define FSO_FRAMEWORK_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))
#define FSO_FRAMEWORK_IS_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_IS_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_TRANSPORT))
#define FSO_FRAMEWORK_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_TRANSPORT, FsoFrameworkTransportClass))

typedef struct _FsoFrameworkTransport FsoFrameworkTransport;
typedef struct _FsoFrameworkTransportClass FsoFrameworkTransportClass;
typedef struct _FsoFrameworkTransportPrivate FsoFrameworkTransportPrivate;

#define FSO_FRAMEWORK_TYPE_BASE_TRANSPORT (fso_framework_base_transport_get_type ())
#define FSO_FRAMEWORK_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransport))
#define FSO_FRAMEWORK_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_IS_BASE_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT))
#define FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportClass))

typedef struct _FsoFrameworkBaseTransport FsoFrameworkBaseTransport;
typedef struct _FsoFrameworkBaseTransportClass FsoFrameworkBaseTransportClass;
typedef struct _FsoFrameworkBaseTransportPrivate FsoFrameworkBaseTransportPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_byte_array_free0(var) ((var == NULL) ? NULL : (var = (g_byte_array_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _fso_framework_base_transport_openAsyncData fso_framework_base_transport_openAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef void (*FsoFrameworkTransportFunc) (FsoFrameworkTransport* transport, void* user_data);
struct _FsoFrameworkTransport {
	GObject parent_instance;
	FsoFrameworkTransportPrivate * priv;
	FsoFrameworkLogger* logger;
};

struct _FsoFrameworkTransportClass {
	GObjectClass parent_class;
	gboolean (*isOpen) (FsoFrameworkTransport* self);
	void (*openAsync) (FsoFrameworkTransport* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*openAsync_finish) (FsoFrameworkTransport* self, GAsyncResult* _res_);
	gboolean (*open) (FsoFrameworkTransport* self);
	void (*close) (FsoFrameworkTransport* self);
	gchar* (*getName) (FsoFrameworkTransport* self);
	void (*setDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
	void (*getDelegates) (FsoFrameworkTransport* self, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify);
	void (*setPriorities) (FsoFrameworkTransport* self, gint rp, gint wp);
	void (*setBuffered) (FsoFrameworkTransport* self, gboolean on);
	gint (*writeAndRead) (FsoFrameworkTransport* self, void* wdata, gint wlength, void* rdata, gint rlength, gint maxWait);
	gint (*read) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*write) (FsoFrameworkTransport* self, void* data, gint length);
	gint (*freeze) (FsoFrameworkTransport* self);
	void (*thaw) (FsoFrameworkTransport* self);
	void (*drain) (FsoFrameworkTransport* self);
	void (*flush) (FsoFrameworkTransport* self);
	gboolean (*suspend) (FsoFrameworkTransport* self);
	void (*resume) (FsoFrameworkTransport* self);
};

struct _FsoFrameworkBaseTransport {
	FsoFrameworkTransport parent_instance;
	FsoFrameworkBaseTransportPrivate * priv;
	gchar* name;
	guint speed;
	gboolean raw;
	gboolean hard;
	gint fd;
	FsoFrameworkTransportFunc hupfunc;
	gpointer hupfunc_target;
	GDestroyNotify hupfunc_target_destroy_notify;
	FsoFrameworkTransportFunc readfunc;
	gpointer readfunc_target;
	GDestroyNotify readfunc_target_destroy_notify;
	GByteArray* buffer;
};

struct _FsoFrameworkBaseTransportClass {
	FsoFrameworkTransportClass parent_class;
	gssize (*_real_write) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
	void (*configure) (FsoFrameworkBaseTransport* self);
	gchar* (*repr) (FsoFrameworkBaseTransport* self);
	gssize (*_real_read) (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
};

struct _FsoFrameworkBaseTransportPrivate {
	gboolean buffered;
	GIOChannel* channel;
	guint readwatch;
	gint readpriority;
	guint writewatch;
	gint writepriority;
};

struct _fso_framework_base_transport_openAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoFrameworkBaseTransport* self;
	gboolean result;
	gboolean _tmp0_;
};


static gpointer fso_framework_base_transport_parent_class = NULL;

GType fso_framework_transport_get_type (void) G_GNUC_CONST;
GType fso_framework_base_transport_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_BASE_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, FsoFrameworkBaseTransportPrivate))
enum  {
	FSO_FRAMEWORK_BASE_TRANSPORT_DUMMY_PROPERTY
};
void fso_framework_base_transport_restartWriter (FsoFrameworkBaseTransport* self);
static gboolean fso_framework_base_transport_writeCallback (FsoFrameworkBaseTransport* self, GIOChannel* source, GIOCondition condition);
static gboolean _fso_framework_base_transport_writeCallback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean fso_framework_base_transport_actionCallback (FsoFrameworkBaseTransport* self, GIOChannel* source, GIOCondition condition);
gboolean fso_framework_transport_isOpen (FsoFrameworkTransport* self);
void fso_framework_transport_close (FsoFrameworkTransport* self);
gint _fso_framework_base_transport_write (FsoFrameworkBaseTransport* self, void* data, gint len);
gssize _fso_framework_base_transport_real_write (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
static gssize fso_framework_base_transport_real__real_write (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
speed_t fso_framework_base_transport_parse_speed (FsoFrameworkBaseTransport* self, guint speed);
void fso_framework_base_transport_configure (FsoFrameworkBaseTransport* self);
static void fso_framework_base_transport_real_configure (FsoFrameworkBaseTransport* self);
gchar* fso_framework_base_transport_repr (FsoFrameworkBaseTransport* self);
static gchar* fso_framework_base_transport_real_repr (FsoFrameworkBaseTransport* self);
FsoFrameworkBaseTransport* fso_framework_base_transport_new (const gchar* name, guint speed, gboolean raw, gboolean hard);
FsoFrameworkBaseTransport* fso_framework_base_transport_construct (GType object_type, const gchar* name, guint speed, gboolean raw, gboolean hard);
FsoFrameworkTransport* fso_framework_transport_construct (GType object_type);
static gchar* _fso_framework_base_transport_repr_repr_delegate (gpointer self);
static gchar* fso_framework_base_transport_real_getName (FsoFrameworkTransport* base);
static void fso_framework_base_transport_real_openAsync_data_free (gpointer _data);
static void fso_framework_base_transport_real_openAsync (FsoFrameworkTransport* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_framework_base_transport_real_openAsync_co (fso_framework_base_transport_openAsyncData* _data_);
gboolean fso_framework_transport_open (FsoFrameworkTransport* self);
static gboolean fso_framework_base_transport_real_open (FsoFrameworkTransport* base);
static gboolean _fso_framework_base_transport_actionCallback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void fso_framework_base_transport_real_close (FsoFrameworkTransport* base);
static gboolean fso_framework_base_transport_real_isOpen (FsoFrameworkTransport* base);
static void fso_framework_base_transport_real_setDelegates (FsoFrameworkTransport* base, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target);
static void fso_framework_base_transport_real_setPriorities (FsoFrameworkTransport* base, gint rp, gint wp);
static void fso_framework_base_transport_real_getDelegates (FsoFrameworkTransport* base, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify);
static gint fso_framework_base_transport_real_read (FsoFrameworkTransport* base, void* data, gint len);
gssize _fso_framework_base_transport_real_read (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
static gint fso_framework_base_transport_real_write (FsoFrameworkTransport* base, void* data, gint len);
static void fso_framework_base_transport_real_setBuffered (FsoFrameworkTransport* base, gboolean on);
static gint fso_framework_base_transport_real_writeAndRead (FsoFrameworkTransport* base, guchar* wdata, gint wlength, guchar* rdata, gint rlength, gint maxWait);
gsize _fso_framework_base_transport_read (FsoFrameworkBaseTransport* self, void* rdata, gint rlength, gint maxWait);
static gssize fso_framework_base_transport_real__real_read (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len);
static gint fso_framework_base_transport_real_freeze (FsoFrameworkTransport* base);
void fso_framework_transport_drain (FsoFrameworkTransport* self);
static void fso_framework_base_transport_real_thaw (FsoFrameworkTransport* base);
static void fso_framework_base_transport_real_drain (FsoFrameworkTransport* base);
static void fso_framework_base_transport_real_flush (FsoFrameworkTransport* base);
static gboolean fso_framework_base_transport_real_suspend (FsoFrameworkTransport* base);
static void fso_framework_base_transport_real_resume (FsoFrameworkTransport* base);
static void fso_framework_base_transport_finalize (GObject* obj);


static gboolean _fso_framework_base_transport_writeCallback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = fso_framework_base_transport_writeCallback (self, source, condition);
	return result;
}


void fso_framework_base_transport_restartWriter (FsoFrameworkBaseTransport* self) {
	GIOChannel* _tmp0_;
	gint _tmp1_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel;
	_tmp1_ = self->priv->writepriority;
	_tmp2_ = g_io_add_watch_full (_tmp0_, _tmp1_, G_IO_OUT, _fso_framework_base_transport_writeCallback_gio_func, g_object_ref (self), g_object_unref);
	self->priv->writewatch = _tmp2_;
}


static gboolean fso_framework_base_transport_actionCallback (FsoFrameworkBaseTransport* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GIOCondition _tmp2_;
	GIOCondition _tmp6_;
	FsoFrameworkLogger* _tmp9_;
	GIOCondition _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = fso_framework_transport_isOpen ((FsoFrameworkTransport*) self);
	if (!_tmp0_) {
		FsoFrameworkLogger* _tmp1_;
		_tmp1_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_warning (_tmp1_, "Ignoring actionCallback while transport is closed");
		result = FALSE;
		return result;
	}
	_tmp2_ = condition;
	if ((_tmp2_ & G_IO_HUP) == G_IO_HUP) {
		FsoFrameworkLogger* _tmp3_;
		FsoFrameworkTransportFunc _tmp4_;
		void* _tmp4__target;
		_tmp3_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp3_, "HUP => closing channel");
		fso_framework_transport_close ((FsoFrameworkTransport*) self);
		_tmp4_ = self->hupfunc;
		_tmp4__target = self->hupfunc_target;
		if (_tmp4_ != NULL) {
			FsoFrameworkTransportFunc _tmp5_;
			void* _tmp5__target;
			_tmp5_ = self->hupfunc;
			_tmp5__target = self->hupfunc_target;
			_tmp5_ ((FsoFrameworkTransport*) self, _tmp5__target);
		}
		result = FALSE;
		return result;
	}
	_tmp6_ = condition;
	if ((_tmp6_ & G_IO_IN) == G_IO_IN) {
		FsoFrameworkTransportFunc _tmp7_;
		void* _tmp7__target;
		_tmp7_ = self->readfunc;
		_tmp7__target = self->readfunc_target;
		if (_tmp7_ != NULL) {
			FsoFrameworkTransportFunc _tmp8_;
			void* _tmp8__target;
			_tmp8_ = self->readfunc;
			_tmp8__target = self->readfunc_target;
			_tmp8_ ((FsoFrameworkTransport*) self, _tmp8__target);
		}
		result = TRUE;
		return result;
	}
	_tmp9_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp10_ = condition;
	_tmp11_ = g_strdup_printf ("ActionCallback called with unknown condition %d", (gint) _tmp10_);
	_tmp12_ = _tmp11_;
	fso_framework_logger_critical (_tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	result = FALSE;
	return result;
}


static gboolean fso_framework_base_transport_writeCallback (FsoFrameworkBaseTransport* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	GByteArray* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GByteArray* _tmp6_;
	guint _tmp7_;
	gint len;
	GByteArray* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	gint byteswritten;
	FsoFrameworkLogger* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GByteArray* _tmp15_;
	GByteArray* _tmp16_;
	guint _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp1_ = self->buffer;
	_tmp2_ = _tmp1_->len;
	_tmp3_ = g_strdup_printf ("WriteCallback called with %u bytes in buffer", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = fso_framework_logger_debug (_tmp0_, _tmp4_);
	g_assert (_tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = self->buffer;
	_tmp7_ = _tmp6_->len;
	len = (gint) _tmp7_;
	_tmp8_ = self->buffer;
	_tmp9_ = _tmp8_->data;
	_tmp9__length1 = (gint) _tmp8_->len;
	_tmp10_ = _fso_framework_base_transport_write (self, _tmp9_, len);
	byteswritten = _tmp10_;
	_tmp11_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp12_ = g_strdup_printf ("WriteCallback wrote %d bytes", (gint) byteswritten);
	_tmp13_ = _tmp12_;
	_tmp14_ = fso_framework_logger_debug (_tmp11_, _tmp13_);
	g_assert (_tmp14_);
	_g_free0 (_tmp13_);
	_tmp15_ = self->buffer;
	g_byte_array_remove_range (_tmp15_, (guint) 0, (guint) ((gint) byteswritten));
	_tmp16_ = self->buffer;
	_tmp17_ = _tmp16_->len;
	result = _tmp17_ != ((guint) 0);
	return result;
}


static gssize fso_framework_base_transport_real__real_write (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len) {
	gssize result = 0L;
	gint _tmp0_;
	void* _tmp1_;
	gint _tmp2_;
	gssize _tmp3_ = 0L;
	_tmp0_ = fd;
	_tmp1_ = data;
	_tmp2_ = len;
	_tmp3_ = write (_tmp0_, _tmp1_, (gsize) _tmp2_);
	result = _tmp3_;
	return result;
}


gssize _fso_framework_base_transport_real_write (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len) {
	g_return_val_if_fail (self != NULL, 0L);
	return FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS (self)->_real_write (self, fd, data, len);
}


gint _fso_framework_base_transport_write (FsoFrameworkBaseTransport* self, void* data, gint len) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->fd;
	if (_tmp0_ != (-1)) {
		gint _tmp1_;
		void* _tmp2_;
		gint _tmp3_;
		gssize _tmp4_ = 0L;
		gssize byteswritten;
		gssize _tmp5_;
		_tmp1_ = self->fd;
		_tmp2_ = data;
		_tmp3_ = len;
		_tmp4_ = _fso_framework_base_transport_real_write (self, _tmp1_, _tmp2_, _tmp3_);
		byteswritten = _tmp4_;
		_tmp5_ = byteswritten;
		result = (gint) _tmp5_;
		return result;
	} else {
		FsoFrameworkLogger* _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp6_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp7_ = len;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Attempting to write ", _tmp9_, " bytes to an invalid transport; discarding data", NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_warning (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = 0;
		return result;
	}
}


speed_t fso_framework_base_transport_parse_speed (FsoFrameworkBaseTransport* self, guint speed) {
	speed_t result = {0};
	speed_t tspeed = {0};
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, result);
	_tmp0_ = speed;
	switch (_tmp0_) {
		case 0:
		{
			tspeed = B0;
			break;
		}
		case 50:
		{
			tspeed = B50;
			break;
		}
		case 75:
		{
			tspeed = B75;
			break;
		}
		case 110:
		{
			tspeed = B110;
			break;
		}
		case 134:
		{
			tspeed = B134;
			break;
		}
		case 150:
		{
			tspeed = B150;
			break;
		}
		case 200:
		{
			tspeed = B200;
			break;
		}
		case 300:
		{
			tspeed = B300;
			break;
		}
		case 600:
		{
			tspeed = B600;
			break;
		}
		case 1200:
		{
			tspeed = B1200;
			break;
		}
		case 1800:
		{
			tspeed = B1800;
			break;
		}
		case 2400:
		{
			tspeed = B2400;
			break;
		}
		case 4800:
		{
			tspeed = B4800;
			break;
		}
		case 9600:
		{
			tspeed = B9600;
			break;
		}
		case 19200:
		{
			tspeed = B19200;
			break;
		}
		case 38400:
		{
			tspeed = B38400;
			break;
		}
		case 57600:
		{
			tspeed = B57600;
			break;
		}
		case 115200:
		{
			tspeed = B115200;
			break;
		}
		case 230400:
		{
			tspeed = B230400;
			break;
		}
		case 460800:
		{
			tspeed = (speed_t) B460800;
			break;
		}
		case 500000:
		{
			tspeed = (speed_t) B500000;
			break;
		}
		case 576000:
		{
			tspeed = (speed_t) B576000;
			break;
		}
		case 921600:
		{
			tspeed = (speed_t) B921600;
			break;
		}
		case 1000000:
		{
			tspeed = (speed_t) B1000000;
			break;
		}
		case 1152000:
		{
			tspeed = (speed_t) B1152000;
			break;
		}
		case 1500000:
		{
			tspeed = (speed_t) B1500000;
			break;
		}
		case 2000000:
		{
			tspeed = (speed_t) B2000000;
			break;
		}
		default:
		{
			FsoFrameworkLogger* _tmp1_;
			guint _tmp2_;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp1_ = ((FsoFrameworkTransport*) self)->logger;
			_tmp2_ = speed;
			_tmp3_ = g_strdup_printf ("%u", _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strconcat ("Invalid speed ", _tmp4_, " selected. using 0", NULL);
			_tmp6_ = _tmp5_;
			fso_framework_logger_warning (_tmp1_, _tmp6_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
			tspeed = B0;
			break;
		}
	}
	result = tspeed;
	return result;
}


static void fso_framework_base_transport_real_configure (FsoFrameworkBaseTransport* self) {
	gint _tmp0_;
	struct termios _tmp1_ = {0};
	struct termios termios;
	gint _tmp2_;
	struct termios _tmp3_ = {0};
	guint _tmp4_;
	speed_t _tmp5_ = {0};
	speed_t tspeed;
	speed_t _tmp6_;
	speed_t _tmp7_;
	tcflag_t _tmp8_;
	tcflag_t _tmp9_;
	tcflag_t _tmp10_;
	tcflag_t _tmp11_;
	tcflag_t _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gint _tmp29_;
	struct termios _tmp30_;
	gint _tmp31_ = 0;
	gint ok;
	gint _tmp32_;
	gboolean _tmp39_;
	_tmp0_ = self->fd;
	fcntl (_tmp0_, F_SETFL, 0, NULL);
	termios = _tmp1_;
	_tmp2_ = self->fd;
	tcgetattr (_tmp2_, &_tmp3_);
	termios = _tmp3_;
	_tmp4_ = self->speed;
	_tmp5_ = fso_framework_base_transport_parse_speed (self, _tmp4_);
	tspeed = _tmp5_;
	_tmp6_ = tspeed;
	cfsetispeed (&termios, _tmp6_);
	_tmp7_ = tspeed;
	cfsetospeed (&termios, _tmp7_);
	_tmp8_ = termios.c_cflag;
	termios.c_cflag = _tmp8_ | (CLOCAL | CREAD);
	_tmp9_ = termios.c_cflag;
	termios.c_cflag = _tmp9_ & (~PARENB);
	_tmp10_ = termios.c_cflag;
	termios.c_cflag = _tmp10_ & (~CSTOPB);
	_tmp11_ = termios.c_cflag;
	termios.c_cflag = _tmp11_ & (~CSIZE);
	_tmp12_ = termios.c_cflag;
	termios.c_cflag = _tmp12_ | CS8;
	_tmp13_ = self->hard;
	if (_tmp13_) {
		tcflag_t _tmp14_;
		tcflag_t _tmp15_;
		_tmp14_ = termios.c_cflag;
		termios.c_cflag = _tmp14_ | CRTSCTS;
		_tmp15_ = termios.c_iflag;
		termios.c_iflag = _tmp15_ & (~((IXON | IXOFF) | IXANY));
	} else {
		tcflag_t _tmp16_;
		tcflag_t _tmp17_;
		_tmp16_ = termios.c_cflag;
		termios.c_cflag = _tmp16_ & CRTSCTS;
		_tmp17_ = termios.c_iflag;
		termios.c_iflag = _tmp17_ | (~((IXON | IXOFF) | IXANY));
	}
	_tmp18_ = self->raw;
	if (_tmp18_) {
		tcflag_t _tmp19_;
		tcflag_t _tmp20_;
		tcflag_t _tmp21_;
		cc_t _tmp22_;
		cc_t _tmp23_;
		cc_t _tmp24_;
		cc_t _tmp25_;
		cc_t _tmp26_;
		cc_t _tmp27_;
		cc_t _tmp28_;
		_tmp19_ = termios.c_lflag;
		termios.c_lflag = _tmp19_ & (~(((ICANON | ECHO) | ECHOE) | ISIG));
		_tmp20_ = termios.c_iflag;
		termios.c_iflag = _tmp20_ & (~((INLCR | ICRNL) | IGNCR));
		_tmp21_ = termios.c_oflag;
		termios.c_oflag = _tmp21_ & (~((((OPOST | OLCUC) | ONLRET) | ONOCR) | OCRNL));
		termios.c_cc[VMIN] = (cc_t) 1;
		_tmp22_ = termios.c_cc[VMIN];
		termios.c_cc[VTIME] = (cc_t) 0;
		_tmp23_ = termios.c_cc[VTIME];
		termios.c_cc[VINTR] = (cc_t) 0;
		_tmp24_ = termios.c_cc[VINTR];
		termios.c_cc[VQUIT] = (cc_t) 0;
		_tmp25_ = termios.c_cc[VQUIT];
		termios.c_cc[VSTART] = (cc_t) 0;
		_tmp26_ = termios.c_cc[VSTART];
		termios.c_cc[VSTOP] = (cc_t) 0;
		_tmp27_ = termios.c_cc[VSTOP];
		termios.c_cc[VSUSP] = (cc_t) 0;
		_tmp28_ = termios.c_cc[VSUSP];
	}
	_tmp29_ = self->fd;
	_tmp30_ = termios;
	_tmp31_ = tcsetattr (_tmp29_, TCSANOW, &_tmp30_);
	ok = _tmp31_;
	_tmp32_ = ok;
	if (_tmp32_ == (-1)) {
		FsoFrameworkLogger* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		_tmp33_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp34_ = self->fd;
		_tmp35_ = errno;
		_tmp36_ = strerror (_tmp35_);
		_tmp37_ = g_strdup_printf ("Could not configure fd %d: %s", _tmp34_, _tmp36_);
		_tmp38_ = _tmp37_;
		fso_framework_logger_error (_tmp33_, _tmp38_);
		_g_free0 (_tmp38_);
	}
	_tmp39_ = self->hard;
	if (_tmp39_) {
		gint v24;
		gint _tmp40_;
		v24 = TIOCM_DTR | TIOCM_RTS;
		_tmp40_ = self->fd;
		ioctl (_tmp40_, TIOCMBIS, &v24);
	}
}


void fso_framework_base_transport_configure (FsoFrameworkBaseTransport* self) {
	g_return_if_fail (self != NULL);
	FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS (self)->configure (self);
}


static gchar* fso_framework_base_transport_real_repr (FsoFrameworkBaseTransport* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	_tmp0_ = self->fd;
	_tmp1_ = g_strdup_printf ("<fd %d>", _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* fso_framework_base_transport_repr (FsoFrameworkBaseTransport* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS (self)->repr (self);
}


static gchar* _fso_framework_base_transport_repr_repr_delegate (gpointer self) {
	gchar* result;
	result = fso_framework_base_transport_repr (self);
	return result;
}


FsoFrameworkBaseTransport* fso_framework_base_transport_construct (GType object_type, const gchar* name, guint speed, gboolean raw, gboolean hard) {
	FsoFrameworkBaseTransport * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GByteArray* _tmp5_;
	FsoFrameworkLogger* _tmp6_ = NULL;
	FsoFrameworkLogger* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	self = (FsoFrameworkBaseTransport*) fso_framework_transport_construct (object_type);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = speed;
	self->speed = _tmp2_;
	_tmp3_ = raw;
	self->raw = _tmp3_;
	_tmp4_ = hard;
	self->hard = _tmp4_;
	_tmp5_ = g_byte_array_new ();
	_g_byte_array_free0 (self->buffer);
	self->buffer = _tmp5_;
	self->priv->buffered = TRUE;
	_tmp6_ = fso_framework_logger_createLogger ("libfsotransport", "libfsotransport");
	_g_object_unref0 (((FsoFrameworkTransport*) self)->logger);
	((FsoFrameworkTransport*) self)->logger = _tmp6_;
	_tmp7_ = ((FsoFrameworkTransport*) self)->logger;
	fso_framework_logger_setReprDelegate (_tmp7_, _fso_framework_base_transport_repr_repr_delegate, self);
	_tmp8_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp9_ = fso_framework_logger_debug (_tmp8_, "Created");
	g_assert (_tmp9_);
	return self;
}


FsoFrameworkBaseTransport* fso_framework_base_transport_new (const gchar* name, guint speed, gboolean raw, gboolean hard) {
	return fso_framework_base_transport_construct (FSO_FRAMEWORK_TYPE_BASE_TRANSPORT, name, speed, raw, hard);
}


static gchar* fso_framework_base_transport_real_getName (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void fso_framework_base_transport_real_openAsync_data_free (gpointer _data) {
	fso_framework_base_transport_openAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (fso_framework_base_transport_openAsyncData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void fso_framework_base_transport_real_openAsync (FsoFrameworkTransport* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoFrameworkBaseTransport * self;
	fso_framework_base_transport_openAsyncData* _data_;
	FsoFrameworkBaseTransport* _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_data_ = g_slice_new0 (fso_framework_base_transport_openAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_framework_base_transport_real_openAsync);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_framework_base_transport_real_openAsync_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_framework_base_transport_real_openAsync_co (_data_);
}


static gboolean fso_framework_base_transport_real_openAsync_finish (FsoFrameworkTransport* base, GAsyncResult* _res_) {
	gboolean result;
	fso_framework_base_transport_openAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean fso_framework_base_transport_real_openAsync_co (fso_framework_base_transport_openAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = fso_framework_transport_open ((FsoFrameworkTransport*) _data_->self);
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean _fso_framework_base_transport_actionCallback_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = fso_framework_base_transport_actionCallback (self, source, condition);
	return result;
}


static gboolean fso_framework_base_transport_real_open (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gboolean result = FALSE;
	gint _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	GIOChannel* _tmp4_;
	GIOChannel* _tmp12_;
	GIOChannel* _tmp13_;
	gint _tmp14_;
	guint _tmp15_ = 0U;
	GByteArray* _tmp16_;
	guint _tmp17_;
	FsoFrameworkLogger* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	g_assert (_tmp0_ != (-1));
	_tmp1_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp2_ = fso_framework_logger_debug (_tmp1_, "Opening...");
	g_assert (_tmp2_);
	_tmp3_ = self->fd;
	_tmp4_ = g_io_channel_unix_new (_tmp3_);
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->channel = _tmp4_;
	{
		GIOChannel* _tmp5_;
		_tmp5_ = self->priv->channel;
		g_io_channel_set_encoding (_tmp5_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch0_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_io_channel_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Can't set channel encoding to null: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_warning (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp12_ = self->priv->channel;
	g_io_channel_set_buffer_size (_tmp12_, (gsize) 32768);
	_tmp13_ = self->priv->channel;
	_tmp14_ = self->priv->readpriority;
	_tmp15_ = g_io_add_watch_full (_tmp13_, _tmp14_, G_IO_IN | G_IO_HUP, _fso_framework_base_transport_actionCallback_gio_func, g_object_ref (self), g_object_unref);
	self->priv->readwatch = _tmp15_;
	_tmp16_ = self->buffer;
	_tmp17_ = _tmp16_->len;
	if (_tmp17_ > ((guint) 0)) {
		fso_framework_base_transport_restartWriter (self);
	}
	_tmp18_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp19_ = fso_framework_logger_debug (_tmp18_, "Opened");
	g_assert (_tmp19_);
	result = TRUE;
	return result;
}


static void fso_framework_base_transport_real_close (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	gint _tmp4_;
	FsoFrameworkLogger* _tmp6_;
	gboolean _tmp7_ = FALSE;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Closing...");
	g_assert (_tmp1_);
	_tmp2_ = self->priv->readwatch;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_;
		_tmp3_ = self->priv->readwatch;
		g_source_remove (_tmp3_);
	}
	_g_io_channel_unref0 (self->priv->channel);
	self->priv->channel = NULL;
	_tmp4_ = self->fd;
	if (_tmp4_ != (-1)) {
		gint _tmp5_;
		_tmp5_ = self->fd;
		close (_tmp5_);
	}
	self->fd = -1;
	_tmp6_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp7_ = fso_framework_logger_debug (_tmp6_, "Closed");
	g_assert (_tmp7_);
}


static gboolean fso_framework_base_transport_real_isOpen (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	result = _tmp0_ != (-1);
	return result;
}


static void fso_framework_base_transport_real_setDelegates (FsoFrameworkTransport* base, FsoFrameworkTransportFunc readfunc, void* readfunc_target, FsoFrameworkTransportFunc hupfunc, void* hupfunc_target) {
	FsoFrameworkBaseTransport * self;
	FsoFrameworkTransportFunc _tmp0_;
	void* _tmp0__target;
	FsoFrameworkTransportFunc _tmp1_;
	void* _tmp1__target;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = readfunc;
	_tmp0__target = readfunc_target;
	(self->readfunc_target_destroy_notify == NULL) ? NULL : (self->readfunc_target_destroy_notify (self->readfunc_target), NULL);
	self->readfunc = NULL;
	self->readfunc_target = NULL;
	self->readfunc_target_destroy_notify = NULL;
	self->readfunc = _tmp0_;
	self->readfunc_target = _tmp0__target;
	self->readfunc_target_destroy_notify = NULL;
	_tmp1_ = hupfunc;
	_tmp1__target = hupfunc_target;
	(self->hupfunc_target_destroy_notify == NULL) ? NULL : (self->hupfunc_target_destroy_notify (self->hupfunc_target), NULL);
	self->hupfunc = NULL;
	self->hupfunc_target = NULL;
	self->hupfunc_target_destroy_notify = NULL;
	self->hupfunc = _tmp1_;
	self->hupfunc_target = _tmp1__target;
	self->hupfunc_target_destroy_notify = NULL;
}


static void fso_framework_base_transport_real_setPriorities (FsoFrameworkTransport* base, gint rp, gint wp) {
	FsoFrameworkBaseTransport * self;
	gint _tmp0_;
	gint _tmp1_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = rp;
	self->priv->readpriority = _tmp0_;
	_tmp1_ = wp;
	self->priv->writepriority = _tmp1_;
}


static void fso_framework_base_transport_real_getDelegates (FsoFrameworkTransport* base, FsoFrameworkTransportFunc* readfun, void** readfun_target, GDestroyNotify* readfun_target_destroy_notify, FsoFrameworkTransportFunc* hupfun, void** hupfun_target, GDestroyNotify* hupfun_target_destroy_notify) {
	FsoFrameworkBaseTransport * self;
	FsoFrameworkTransportFunc _vala_readfun = NULL;
	void * _vala_readfun_target = NULL;
	GDestroyNotify _vala_readfun_target_destroy_notify = NULL;
	FsoFrameworkTransportFunc _vala_hupfun = NULL;
	void * _vala_hupfun_target = NULL;
	GDestroyNotify _vala_hupfun_target_destroy_notify = NULL;
	FsoFrameworkTransportFunc _tmp0_;
	void* _tmp0__target;
	FsoFrameworkTransportFunc _tmp1_;
	void* _tmp1__target;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->readfunc;
	_tmp0__target = self->readfunc_target;
	(_vala_readfun_target_destroy_notify == NULL) ? NULL : (_vala_readfun_target_destroy_notify (_vala_readfun_target), NULL);
	_vala_readfun = NULL;
	_vala_readfun_target = NULL;
	_vala_readfun_target_destroy_notify = NULL;
	_vala_readfun = _tmp0_;
	_vala_readfun_target = _tmp0__target;
	_vala_readfun_target_destroy_notify = NULL;
	_tmp1_ = self->hupfunc;
	_tmp1__target = self->hupfunc_target;
	(_vala_hupfun_target_destroy_notify == NULL) ? NULL : (_vala_hupfun_target_destroy_notify (_vala_hupfun_target), NULL);
	_vala_hupfun = NULL;
	_vala_hupfun_target = NULL;
	_vala_hupfun_target_destroy_notify = NULL;
	_vala_hupfun = _tmp1_;
	_vala_hupfun_target = _tmp1__target;
	_vala_hupfun_target_destroy_notify = NULL;
	if (readfun) {
		*readfun = _vala_readfun;
		*readfun_target = _vala_readfun_target;
		*readfun_target_destroy_notify = _vala_readfun_target_destroy_notify;
	} else {
		(_vala_readfun_target_destroy_notify == NULL) ? NULL : (_vala_readfun_target_destroy_notify (_vala_readfun_target), NULL);
		_vala_readfun = NULL;
		_vala_readfun_target = NULL;
		_vala_readfun_target_destroy_notify = NULL;
	}
	if (hupfun) {
		*hupfun = _vala_hupfun;
		*hupfun_target = _vala_hupfun_target;
		*hupfun_target_destroy_notify = _vala_hupfun_target_destroy_notify;
	} else {
		(_vala_hupfun_target_destroy_notify == NULL) ? NULL : (_vala_hupfun_target_destroy_notify (_vala_hupfun_target), NULL);
		_vala_hupfun = NULL;
		_vala_hupfun_target = NULL;
		_vala_hupfun_target_destroy_notify = NULL;
	}
}


static gint fso_framework_base_transport_real_read (FsoFrameworkTransport* base, void* data, gint len) {
	FsoFrameworkBaseTransport * self;
	gint result = 0;
	gint _tmp0_;
	void* _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	gint _tmp4_;
	gssize _tmp5_ = 0L;
	gssize bytesread;
	gssize _tmp6_;
	gssize _tmp9_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	g_assert (_tmp0_ != (-1));
	_tmp1_ = data;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = self->fd;
	_tmp3_ = data;
	_tmp4_ = len;
	_tmp5_ = _fso_framework_base_transport_real_read (self, _tmp2_, _tmp3_, _tmp4_);
	bytesread = _tmp5_;
	_tmp6_ = bytesread;
	if (_tmp6_ == ((gssize) 0)) {
		FsoFrameworkLogger* _tmp7_;
		GIOChannel* _tmp8_;
		_tmp7_ = ((FsoFrameworkTransport*) self)->logger;
		fso_framework_logger_error (_tmp7_, "Read 0 bytes => synthesizing actionCallback w/ HUP.");
		_tmp8_ = self->priv->channel;
		fso_framework_base_transport_actionCallback (self, _tmp8_, G_IO_HUP);
	}
	_tmp9_ = bytesread;
	result = (gint) _tmp9_;
	return result;
}


static gint fso_framework_base_transport_real_write (FsoFrameworkTransport* base, void* data, gint len) {
	FsoFrameworkBaseTransport * self;
	gint result = 0;
	gboolean _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->priv->buffered;
	if (!_tmp0_) {
		void* _tmp1_;
		gint _tmp2_;
		gint _tmp3_ = 0;
		_tmp1_ = data;
		_tmp2_ = len;
		_tmp3_ = _fso_framework_base_transport_write (self, _tmp1_, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		void* _tmp4_;
		gint _tmp5_;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		gboolean _tmp16_;
		gboolean restart;
		gint _tmp17_;
		guint8* _tmp18_ = NULL;
		guint8* temp;
		gint temp_length1;
		gint _temp_size_;
		guint8* _tmp19_;
		gint _tmp19__length1;
		void* _tmp20_;
		gint _tmp21_;
		GByteArray* _tmp22_;
		guint8* _tmp23_;
		gint _tmp23__length1;
		gboolean _tmp24_;
		gint _tmp25_;
		_tmp4_ = data;
		g_assert (_tmp4_ != NULL);
		_tmp5_ = self->fd;
		if (_tmp5_ == (-1)) {
			FsoFrameworkLogger* _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp6_ = ((FsoFrameworkTransport*) self)->logger;
			_tmp7_ = len;
			_tmp8_ = g_strdup_printf ("%i", _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat ("Writing although transport still closed; buffering ", _tmp9_, " bytes.", NULL);
			_tmp11_ = _tmp10_;
			fso_framework_logger_warning (_tmp6_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		}
		_tmp13_ = self->fd;
		if (_tmp13_ != (-1)) {
			GByteArray* _tmp14_;
			guint _tmp15_;
			_tmp14_ = self->buffer;
			_tmp15_ = _tmp14_->len;
			_tmp12_ = _tmp15_ == ((guint) 0);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp16_ = _tmp12_;
		restart = _tmp16_;
		_tmp17_ = len;
		_tmp18_ = g_new0 (guint8, _tmp17_);
		temp = _tmp18_;
		temp_length1 = _tmp17_;
		_temp_size_ = temp_length1;
		_tmp19_ = temp;
		_tmp19__length1 = temp_length1;
		_tmp20_ = data;
		_tmp21_ = len;
		memcpy (_tmp19_, _tmp20_, (gsize) _tmp21_);
		_tmp22_ = self->buffer;
		_tmp23_ = temp;
		_tmp23__length1 = temp_length1;
		g_byte_array_append (_tmp22_, _tmp23_, _tmp23__length1);
		_tmp24_ = restart;
		if (_tmp24_) {
			fso_framework_base_transport_restartWriter (self);
		}
		_tmp25_ = len;
		result = _tmp25_;
		temp = (g_free (temp), NULL);
		return result;
	}
}


static void fso_framework_base_transport_real_setBuffered (FsoFrameworkTransport* base, gboolean on) {
	FsoFrameworkBaseTransport * self;
	gboolean _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = on;
	self->priv->buffered = _tmp0_;
}


static gint fso_framework_base_transport_real_writeAndRead (FsoFrameworkTransport* base, guchar* wdata, gint wlength, guchar* rdata, gint rlength, gint maxWait) {
	FsoFrameworkBaseTransport * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	guchar* _tmp2_;
	gint _tmp3_;
	gssize _tmp4_ = 0L;
	gssize byteswritten;
	gssize _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint fullRead;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	g_assert (_tmp0_ != (-1));
	_tmp1_ = self->fd;
	_tmp2_ = wdata;
	_tmp3_ = wlength;
	_tmp4_ = _fso_framework_base_transport_real_write (self, _tmp1_, _tmp2_, _tmp3_);
	byteswritten = _tmp4_;
	_tmp5_ = byteswritten;
	_tmp6_ = wlength;
	g_assert (_tmp5_ == ((gssize) _tmp6_));
	_tmp7_ = self->fd;
	tcdrain (_tmp7_);
	fullRead = 0;
	while (TRUE) {
		guchar* _tmp8_;
		gint _tmp9_;
		gsize _tmp10_ = 0UL;
		gsize bread;
		gsize _tmp11_;
		gint _tmp12_;
		gsize _tmp13_;
		guchar* _tmp14_;
		gsize _tmp15_;
		gint _tmp16_;
		gsize _tmp17_;
		_tmp8_ = rdata;
		_tmp9_ = rlength;
		_tmp10_ = _fso_framework_base_transport_read (self, _tmp8_, _tmp9_, 2000);
		bread = _tmp10_;
		_tmp11_ = bread;
		if (_tmp11_ == ((gsize) 0)) {
			break;
		}
		_tmp12_ = fullRead;
		_tmp13_ = bread;
		fullRead = _tmp12_ + ((gint) _tmp13_);
		_tmp14_ = rdata;
		_tmp15_ = bread;
		rdata = _tmp14_ + ((gint) _tmp15_);
		_tmp16_ = rlength;
		_tmp17_ = bread;
		rlength = _tmp16_ - ((gint) _tmp17_);
	}
	result = fullRead;
	return result;
}


static gssize fso_framework_base_transport_real__real_read (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len) {
	gssize result = 0L;
	gint _tmp0_;
	void* _tmp1_;
	gint _tmp2_;
	gssize _tmp3_ = 0L;
	_tmp0_ = fd;
	_tmp1_ = data;
	_tmp2_ = len;
	_tmp3_ = read (_tmp0_, _tmp1_, (gsize) _tmp2_);
	result = _tmp3_;
	return result;
}


gssize _fso_framework_base_transport_real_read (FsoFrameworkBaseTransport* self, gint fd, void* data, gint len) {
	g_return_val_if_fail (self != NULL, 0L);
	return FSO_FRAMEWORK_BASE_TRANSPORT_GET_CLASS (self)->_real_read (self, fd, data, len);
}


gsize _fso_framework_base_transport_read (FsoFrameworkBaseTransport* self, void* rdata, gint rlength, gint maxWait) {
	gsize result = 0UL;
	fd_set readfds = {0};
	fd_set writefds = {0};
	fd_set exceptfds = {0};
	gint _tmp0_;
	struct timeval t = {0};
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	struct timeval _tmp4_;
	gint _tmp5_ = 0;
	gint res;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gboolean _tmp11_;
	gint _tmp12_;
	void* _tmp13_;
	gint _tmp14_;
	gssize _tmp15_ = 0L;
	gssize bread;
	gssize _tmp16_;
	g_return_val_if_fail (self != NULL, 0UL);
	memset (&readfds, 0, sizeof (fd_set));
	memset (&writefds, 0, sizeof (fd_set));
	memset (&exceptfds, 0, sizeof (fd_set));
	_tmp0_ = self->fd;
	FD_SET (_tmp0_, &readfds);
	memset (&t, 0, sizeof (struct timeval));
	_tmp1_ = maxWait;
	t.tv_sec = (time_t) (_tmp1_ / 1000);
	_tmp2_ = maxWait;
	t.tv_usec = (glong) (_tmp2_ % 1000);
	_tmp3_ = self->fd;
	_tmp4_ = t;
	_tmp5_ = select (_tmp3_ + 1, &readfds, &writefds, &exceptfds, &_tmp4_);
	res = _tmp5_;
	_tmp7_ = res;
	if (_tmp7_ < 0) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp8_;
		fd_set _tmp9_;
		gint _tmp10_ = 0;
		_tmp8_ = self->fd;
		_tmp9_ = readfds;
		_tmp10_ = FD_ISSET (_tmp8_, &_tmp9_);
		_tmp6_ = _tmp10_ == 0;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		result = (gsize) 0;
		return result;
	}
	_tmp12_ = self->fd;
	_tmp13_ = rdata;
	_tmp14_ = rlength;
	_tmp15_ = _fso_framework_base_transport_real_read (self, _tmp12_, _tmp13_, _tmp14_);
	bread = _tmp15_;
	_tmp16_ = bread;
	if (_tmp16_ < ((gssize) 0)) {
		bread = (gssize) 0;
	}
	result = (gsize) bread;
	return result;
}


static gint fso_framework_base_transport_real_freeze (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gint result = 0;
	GByteArray* _tmp0_;
	guint _tmp1_;
	guint _tmp9_;
	guint _tmp11_;
	FsoFrameworkLogger* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	self = (FsoFrameworkBaseTransport*) base;
	fso_framework_transport_drain ((FsoFrameworkTransport*) self);
	_tmp0_ = self->buffer;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		FsoFrameworkLogger* _tmp2_;
		GByteArray* _tmp3_;
		guint _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp2_ = ((FsoFrameworkTransport*) self)->logger;
		_tmp3_ = self->buffer;
		_tmp4_ = _tmp3_->len;
		_tmp5_ = g_strdup_printf ("%u", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("freeze() called while buffer still contains ", _tmp6_, " bytes", NULL);
		_tmp8_ = _tmp7_;
		fso_framework_logger_warning (_tmp2_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	_tmp9_ = self->priv->readwatch;
	if (_tmp9_ != ((guint) 0)) {
		guint _tmp10_;
		_tmp10_ = self->priv->readwatch;
		g_source_remove (_tmp10_);
		self->priv->readwatch = (guint) 0;
	}
	_tmp11_ = self->priv->writewatch;
	if (_tmp11_ != ((guint) 0)) {
		guint _tmp12_;
		_tmp12_ = self->priv->writewatch;
		g_source_remove (_tmp12_);
		self->priv->writewatch = (guint) 0;
	}
	_tmp13_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp14_ = fso_framework_logger_debug (_tmp13_, "Frozen");
	g_assert (_tmp14_);
	_tmp15_ = self->fd;
	result = _tmp15_;
	return result;
}


static void fso_framework_base_transport_real_thaw (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	GIOChannel* _tmp0_;
	gint _tmp1_;
	guint _tmp2_ = 0U;
	GByteArray* _tmp3_;
	guint _tmp4_;
	FsoFrameworkLogger* _tmp5_;
	gboolean _tmp6_ = FALSE;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->priv->channel;
	_tmp1_ = self->priv->readpriority;
	_tmp2_ = g_io_add_watch_full (_tmp0_, _tmp1_, G_IO_IN | G_IO_HUP, _fso_framework_base_transport_actionCallback_gio_func, g_object_ref (self), g_object_unref);
	self->priv->readwatch = _tmp2_;
	_tmp3_ = self->buffer;
	_tmp4_ = _tmp3_->len;
	if (_tmp4_ > ((guint) 0)) {
		fso_framework_base_transport_restartWriter (self);
	}
	_tmp5_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp6_ = fso_framework_logger_debug (_tmp5_, "Thawn");
	g_assert (_tmp6_);
}


static void fso_framework_base_transport_real_drain (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gint _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	tcdrain (_tmp0_);
}


static void fso_framework_base_transport_real_flush (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gint _tmp0_;
	self = (FsoFrameworkBaseTransport*) base;
	_tmp0_ = self->fd;
	tcflush (_tmp0_, TCIOFLUSH);
}


static gboolean fso_framework_base_transport_real_suspend (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	gboolean result = FALSE;
	self = (FsoFrameworkBaseTransport*) base;
	result = TRUE;
	return result;
}


static void fso_framework_base_transport_real_resume (FsoFrameworkTransport* base) {
	FsoFrameworkBaseTransport * self;
	self = (FsoFrameworkBaseTransport*) base;
}


static void fso_framework_base_transport_class_init (FsoFrameworkBaseTransportClass * klass) {
	fso_framework_base_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkBaseTransportPrivate));
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->_real_write = fso_framework_base_transport_real__real_write;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->configure = fso_framework_base_transport_real_configure;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->repr = fso_framework_base_transport_real_repr;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->getName = fso_framework_base_transport_real_getName;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->openAsync = fso_framework_base_transport_real_openAsync;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->openAsync_finish = fso_framework_base_transport_real_openAsync_finish;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->open = fso_framework_base_transport_real_open;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->close = fso_framework_base_transport_real_close;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->isOpen = fso_framework_base_transport_real_isOpen;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->setDelegates = fso_framework_base_transport_real_setDelegates;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->setPriorities = fso_framework_base_transport_real_setPriorities;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->getDelegates = fso_framework_base_transport_real_getDelegates;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->read = fso_framework_base_transport_real_read;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->write = fso_framework_base_transport_real_write;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->setBuffered = fso_framework_base_transport_real_setBuffered;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->writeAndRead = fso_framework_base_transport_real_writeAndRead;
	FSO_FRAMEWORK_BASE_TRANSPORT_CLASS (klass)->_real_read = fso_framework_base_transport_real__real_read;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->freeze = fso_framework_base_transport_real_freeze;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->thaw = fso_framework_base_transport_real_thaw;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->drain = fso_framework_base_transport_real_drain;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->flush = fso_framework_base_transport_real_flush;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->suspend = fso_framework_base_transport_real_suspend;
	FSO_FRAMEWORK_TRANSPORT_CLASS (klass)->resume = fso_framework_base_transport_real_resume;
	G_OBJECT_CLASS (klass)->finalize = fso_framework_base_transport_finalize;
}


static void fso_framework_base_transport_instance_init (FsoFrameworkBaseTransport * self) {
	self->priv = FSO_FRAMEWORK_BASE_TRANSPORT_GET_PRIVATE (self);
	self->fd = -1;
}


static void fso_framework_base_transport_finalize (GObject* obj) {
	FsoFrameworkBaseTransport * self;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = FSO_FRAMEWORK_BASE_TRANSPORT (obj);
	_tmp0_ = ((FsoFrameworkTransport*) self)->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Destroyed");
	g_assert (_tmp1_);
	_g_free0 (self->name);
	_g_io_channel_unref0 (self->priv->channel);
	(self->hupfunc_target_destroy_notify == NULL) ? NULL : (self->hupfunc_target_destroy_notify (self->hupfunc_target), NULL);
	self->hupfunc = NULL;
	self->hupfunc_target = NULL;
	self->hupfunc_target_destroy_notify = NULL;
	(self->readfunc_target_destroy_notify == NULL) ? NULL : (self->readfunc_target_destroy_notify (self->readfunc_target), NULL);
	self->readfunc = NULL;
	self->readfunc_target = NULL;
	self->readfunc_target_destroy_notify = NULL;
	_g_byte_array_free0 (self->buffer);
	G_OBJECT_CLASS (fso_framework_base_transport_parent_class)->finalize (obj);
}


/**
 * @class FsoFramework.BaseTransport
 *
 * Base class for FsoFramework Transport Classes
 **/
GType fso_framework_base_transport_get_type (void) {
	static volatile gsize fso_framework_base_transport_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_base_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkBaseTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_base_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkBaseTransport), 0, (GInstanceInitFunc) fso_framework_base_transport_instance_init, NULL };
		GType fso_framework_base_transport_type_id;
		fso_framework_base_transport_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_TRANSPORT, "FsoFrameworkBaseTransport", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_base_transport_type_id__volatile, fso_framework_base_transport_type_id);
	}
	return fso_framework_base_transport_type_id__volatile;
}



