.\"
.\" $Id: rfio_fwrite.man,v 1.1 2005/03/31 13:13:02 baud Exp $
.\"
.\" @(#)$RCSfile: rfio_fwrite.man,v $ $Revision: 1.1 $ $Date: 2005/03/31 13:13:02 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2001 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH RFIO_FWRITE 3 "$Date: 2005/03/31 13:13:02 $" CASTOR "Rfio Library Functions"
.SH NAME
rfio_fwrite \- writes to a file
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_fwrite (const void *" ptr ", int " size ", int " items ", FILE *" fd ");"
.SH DESCRIPTION
.B rfio_fwrite
stores in a file the bytes starting at
.BI ptr
, a pointer to the memory location in which resides the information,
.BI items
times
.BI size
bytes, using the descriptor
.BI fd
generated by a previous
.BR rfio_fopen .
.SH RETURN VALUE
This routine returns -1 if the operation failed or the number of items actually writen. In case of failure, 
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I fd
is a NULL pointer.
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SETIMEDOUT
Timed out.
.TP
.B SEBADVERSION
Version ID mismatch.
.TP
.B SECONNDROP
Connection closed by remote end.
.TP
.B SECOMERR
Communication error.
.TP
.B SENORCODE
Host did not return error number.
.SH SEE ALSO
.BR rfio_fopen(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
