/* expressionparser.c generated by valac 0.22.1, the Vala compiler
 * generated from expressionparser.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EXPRESSION_TOKENIZER (expression_tokenizer_get_type ())
#define EXPRESSION_TOKENIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_TOKENIZER, ExpressionTokenizer))
#define EXPRESSION_TOKENIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_TOKENIZER, ExpressionTokenizerClass))
#define IS_EXPRESSION_TOKENIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_TOKENIZER))
#define IS_EXPRESSION_TOKENIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_TOKENIZER))
#define EXPRESSION_TOKENIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_TOKENIZER, ExpressionTokenizerClass))

typedef struct _ExpressionTokenizer ExpressionTokenizer;
typedef struct _ExpressionTokenizerClass ExpressionTokenizerClass;
typedef struct _ExpressionTokenizerPrivate ExpressionTokenizerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecExpressionTokenizer ParamSpecExpressionTokenizer;

#define TYPE_EXPRESSION_EVALUATOR (expression_evaluator_get_type ())
#define EXPRESSION_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_EVALUATOR, ExpressionEvaluator))
#define EXPRESSION_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_EVALUATOR, ExpressionEvaluatorClass))
#define IS_EXPRESSION_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_EVALUATOR))
#define IS_EXPRESSION_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_EVALUATOR))
#define EXPRESSION_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_EVALUATOR, ExpressionEvaluatorClass))

typedef struct _ExpressionEvaluator ExpressionEvaluator;
typedef struct _ExpressionEvaluatorClass ExpressionEvaluatorClass;
typedef struct _ExpressionEvaluatorPrivate ExpressionEvaluatorPrivate;

#define TYPE_PROVIDERS (providers_get_type ())
#define PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROVIDERS, Providers))
#define PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROVIDERS, ProvidersClass))
#define IS_PROVIDERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROVIDERS))
#define IS_PROVIDERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROVIDERS))
#define PROVIDERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROVIDERS, ProvidersClass))

typedef struct _Providers Providers;
typedef struct _ProvidersClass ProvidersClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecExpressionEvaluator ParamSpecExpressionEvaluator;

#define TYPE_EXPRESSION_CACHE (expression_cache_get_type ())
#define EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_CACHE, ExpressionCache))
#define EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))
#define IS_EXPRESSION_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_CACHE))
#define IS_EXPRESSION_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_CACHE))
#define EXPRESSION_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_CACHE, ExpressionCacheClass))

typedef struct _ExpressionCache ExpressionCache;
typedef struct _ExpressionCacheClass ExpressionCacheClass;
typedef struct _ExpressionCachePrivate ExpressionCachePrivate;
#define _expression_tokenizer_unref0(var) ((var == NULL) ? NULL : (var = (expression_tokenizer_unref (var), NULL)))
#define _expression_evaluator_unref0(var) ((var == NULL) ? NULL : (var = (expression_evaluator_unref (var), NULL)))

struct _ExpressionTokenizer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExpressionTokenizerPrivate * priv;
};

struct _ExpressionTokenizerClass {
	GTypeClass parent_class;
	void (*finalize) (ExpressionTokenizer *self);
};

struct _ExpressionTokenizerPrivate {
	gchar* last;
	gchar* current;
	gchar** result;
	gint result_length1;
	gint _result_size_;
};

struct _ParamSpecExpressionTokenizer {
	GParamSpec parent_instance;
};

struct _ExpressionEvaluator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExpressionEvaluatorPrivate * priv;
};

struct _ExpressionEvaluatorClass {
	GTypeClass parent_class;
	void (*finalize) (ExpressionEvaluator *self);
};

struct _ExpressionEvaluatorPrivate {
	Providers* providers;
	guint index;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean guide;
};

struct _ParamSpecExpressionEvaluator {
	GParamSpec parent_instance;
};

struct _ExpressionCache {
	GObject parent_instance;
	ExpressionCachePrivate * priv;
};

struct _ExpressionCacheClass {
	GObjectClass parent_class;
};

struct _ExpressionCachePrivate {
	Providers* _providers;
	gchar** _tokens;
	gint _tokens_length1;
	gint __tokens_size_;
	gchar* _label;
	gchar* _guide;
	gchar* _expression;
};


static gpointer expression_tokenizer_parent_class = NULL;
static gpointer expression_evaluator_parent_class = NULL;
static gpointer expression_cache_parent_class = NULL;

gpointer expression_tokenizer_ref (gpointer instance);
void expression_tokenizer_unref (gpointer instance);
GParamSpec* param_spec_expression_tokenizer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_expression_tokenizer (GValue* value, gpointer v_object);
void value_take_expression_tokenizer (GValue* value, gpointer v_object);
gpointer value_get_expression_tokenizer (const GValue* value);
GType expression_tokenizer_get_type (void) G_GNUC_CONST;
#define EXPRESSION_TOKENIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_TOKENIZER, ExpressionTokenizerPrivate))
enum  {
	EXPRESSION_TOKENIZER_DUMMY_PROPERTY
};
gchar** expression_tokenizer_tokenize (ExpressionTokenizer* self, const gchar* expression, int* result_length1);
static void expression_tokenizer_save (ExpressionTokenizer* self);
static void expression_tokenizer_addcurrent (ExpressionTokenizer* self);
static void expression_tokenizer_expand (ExpressionTokenizer* self);
static gboolean expression_tokenizer_isvariable (ExpressionTokenizer* self);
static void expression_tokenizer_add (ExpressionTokenizer* self, gchar what);
static void expression_tokenizer_savewithcurrent (ExpressionTokenizer* self);
static gboolean expression_tokenizer_isspace (ExpressionTokenizer* self);
static void expression_tokenizer_savewith (ExpressionTokenizer* self, gchar what);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
ExpressionTokenizer* expression_tokenizer_new (void);
ExpressionTokenizer* expression_tokenizer_construct (GType object_type);
static void expression_tokenizer_finalize (ExpressionTokenizer* obj);
gpointer expression_evaluator_ref (gpointer instance);
void expression_evaluator_unref (gpointer instance);
GParamSpec* param_spec_expression_evaluator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_expression_evaluator (GValue* value, gpointer v_object);
void value_take_expression_evaluator (GValue* value, gpointer v_object);
gpointer value_get_expression_evaluator (const GValue* value);
GType expression_evaluator_get_type (void) G_GNUC_CONST;
GType providers_get_type (void) G_GNUC_CONST;
#define EXPRESSION_EVALUATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_EVALUATOR, ExpressionEvaluatorPrivate))
enum  {
	EXPRESSION_EVALUATOR_DUMMY_PROPERTY
};
ExpressionEvaluator* expression_evaluator_new (Providers* providers);
ExpressionEvaluator* expression_evaluator_construct (GType object_type, Providers* providers);
static GError* expression_evaluator_error (guint index, const gchar* message);
static gchar* expression_evaluator_parens_or_identifier (ExpressionEvaluator* self, GError** error);
static gchar* expression_evaluator_parens (ExpressionEvaluator* self, GError** error);
static gchar* expression_evaluator_identifier (ExpressionEvaluator* self, GError** error);
static gchar* expression_evaluator_times (ExpressionEvaluator* self, GError** error);
static gchar* expression_evaluator_plus (ExpressionEvaluator* self, GError** error);
static gchar** expression_evaluator_params (ExpressionEvaluator* self, int* result_length1, GError** error);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
gchar* providers_call (Providers* self, const gchar* name, gchar** parameters, int parameters_length1, gboolean widest, gboolean* found, GError** error);
gdouble providers_value (Providers* self, const gchar* name, gboolean* found);
static gchar* expression_evaluator_text (ExpressionEvaluator* self, GError** error);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
gchar* expression_evaluator_evaluate (ExpressionEvaluator* self, gchar** tokens, int tokens_length1, gboolean guide);
static gchar** _vala_array_dup6 (gchar** self, int length);
static void expression_evaluator_finalize (ExpressionEvaluator* obj);
GType expression_cache_get_type (void) G_GNUC_CONST;
#define EXPRESSION_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_CACHE, ExpressionCachePrivate))
enum  {
	EXPRESSION_CACHE_DUMMY_PROPERTY,
	EXPRESSION_CACHE_PROVIDERS,
	EXPRESSION_CACHE_EXPRESSION
};
ExpressionCache* expression_cache_new (Providers* providers, const gchar* expression);
ExpressionCache* expression_cache_construct (GType object_type, Providers* providers, const gchar* expression);
void expression_cache_update (ExpressionCache* self);
gchar** expression_cache_tokens (ExpressionCache* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar* expression_cache_label (ExpressionCache* self);
Providers* expression_cache_get_providers (ExpressionCache* self);
gchar* expression_cache_guide (ExpressionCache* self);
static void expression_cache_set_providers (ExpressionCache* self, Providers* value);
const gchar* expression_cache_get_expression (ExpressionCache* self);
void expression_cache_set_expression (ExpressionCache* self, const gchar* value);
static void expression_cache_finalize (GObject* obj);
static void _vala_expression_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_expression_cache_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** expression_tokenizer_tokenize (ExpressionTokenizer* self, const gchar* expression, int* result_length1) {
	gchar** result = NULL;
	gint level = 0;
	gboolean inexpression = FALSE;
	gboolean instringsingle = FALSE;
	gboolean instringdouble = FALSE;
	gboolean _tmp27_ = FALSE;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	g_return_val_if_fail (IS_EXPRESSION_TOKENIZER (self), NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	self->priv->result = (_vala_array_free (self->priv->result, self->priv->result_length1, (GDestroyNotify) g_free), NULL);
	self->priv->result = NULL;
	self->priv->result_length1 = 0;
	self->priv->_result_size_ = self->priv->result_length1;
	self->priv->last = NULL;
	level = 0;
	inexpression = FALSE;
	instringsingle = FALSE;
	instringdouble = FALSE;
	{
		const gchar* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = expression;
		self->priv->current = (gchar*) _tmp0_;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gint _tmp7_ = 0;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp16_ = FALSE;
			gchar* _tmp18_ = NULL;
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gchar* _tmp3_ = NULL;
				_tmp3_ = self->priv->current;
				self->priv->current = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = self->priv->current;
			if (!((*_tmp4_) != '\0')) {
				break;
			}
			_tmp5_ = inexpression;
			if (!_tmp5_) {
				gchar* _tmp6_ = NULL;
				_tmp6_ = self->priv->current;
				if ((*_tmp6_) == '$') {
					expression_tokenizer_save (self);
					expression_tokenizer_addcurrent (self);
					inexpression = TRUE;
				} else {
					expression_tokenizer_expand (self);
				}
				continue;
			}
			_tmp7_ = level;
			if (_tmp7_ == 0) {
				gboolean _tmp8_ = FALSE;
				_tmp8_ = expression_tokenizer_isvariable (self);
				if (_tmp8_) {
					expression_tokenizer_expand (self);
				} else {
					gboolean _tmp9_ = FALSE;
					gchar* _tmp10_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp10_ = self->priv->last;
					if (_tmp10_ == NULL) {
						gchar* _tmp11_ = NULL;
						_tmp11_ = self->priv->current;
						_tmp9_ = (*_tmp11_) == '(';
					} else {
						_tmp9_ = FALSE;
					}
					_tmp12_ = _tmp9_;
					if (_tmp12_) {
						gint _tmp13_ = 0;
						expression_tokenizer_addcurrent (self);
						_tmp13_ = level;
						level = _tmp13_ + 1;
					} else {
						expression_tokenizer_add (self, '(');
						expression_tokenizer_save (self);
						expression_tokenizer_add (self, ')');
						expression_tokenizer_expand (self);
						inexpression = FALSE;
					}
				}
				continue;
			}
			_tmp14_ = instringsingle;
			if (_tmp14_) {
				gchar* _tmp15_ = NULL;
				expression_tokenizer_expand (self);
				_tmp15_ = self->priv->current;
				if ((*_tmp15_) == '\'') {
					expression_tokenizer_savewithcurrent (self);
					instringsingle = FALSE;
				}
				continue;
			}
			_tmp16_ = instringdouble;
			if (_tmp16_) {
				gchar* _tmp17_ = NULL;
				expression_tokenizer_expand (self);
				_tmp17_ = self->priv->current;
				if ((*_tmp17_) == '"') {
					expression_tokenizer_savewithcurrent (self);
					instringdouble = FALSE;
				}
				continue;
			}
			_tmp18_ = self->priv->current;
			if ((*_tmp18_) == '\'') {
				expression_tokenizer_save (self);
				expression_tokenizer_expand (self);
				instringsingle = TRUE;
			} else {
				gchar* _tmp19_ = NULL;
				_tmp19_ = self->priv->current;
				if ((*_tmp19_) == '"') {
					expression_tokenizer_save (self);
					expression_tokenizer_expand (self);
					instringdouble = TRUE;
				} else {
					gchar* _tmp20_ = NULL;
					_tmp20_ = self->priv->current;
					if ((*_tmp20_) == '(') {
						gint _tmp21_ = 0;
						expression_tokenizer_save (self);
						expression_tokenizer_addcurrent (self);
						_tmp21_ = level;
						level = _tmp21_ + 1;
					} else {
						gchar* _tmp22_ = NULL;
						_tmp22_ = self->priv->current;
						if ((*_tmp22_) == ')') {
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							expression_tokenizer_save (self);
							expression_tokenizer_addcurrent (self);
							_tmp23_ = level;
							level = _tmp23_ - 1;
							_tmp24_ = level;
							if (_tmp24_ == 0) {
								inexpression = FALSE;
							}
						} else {
							gboolean _tmp25_ = FALSE;
							_tmp25_ = expression_tokenizer_isspace (self);
							if (_tmp25_) {
								expression_tokenizer_save (self);
							} else {
								gboolean _tmp26_ = FALSE;
								_tmp26_ = expression_tokenizer_isvariable (self);
								if (!_tmp26_) {
									expression_tokenizer_save (self);
									expression_tokenizer_addcurrent (self);
								} else {
									expression_tokenizer_expand (self);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp27_ = instringdouble;
	if (_tmp27_) {
		expression_tokenizer_savewith (self, '"');
	} else {
		gboolean _tmp28_ = FALSE;
		_tmp28_ = instringsingle;
		if (_tmp28_) {
			expression_tokenizer_savewith (self, '\'');
		} else {
			expression_tokenizer_save (self);
		}
	}
	while (TRUE) {
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp29_ = level;
		if (!(_tmp29_ > 0)) {
			break;
		}
		expression_tokenizer_add (self, ')');
		_tmp30_ = level;
		level = _tmp30_ - 1;
	}
	_tmp31_ = self->priv->result;
	_tmp31__length1 = self->priv->result_length1;
	_tmp32_ = (_tmp31_ != NULL) ? _vala_array_dup5 (_tmp31_, _tmp31__length1) : ((gpointer) _tmp31_);
	_tmp32__length1 = _tmp31__length1;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	if (result_length1) {
		*result_length1 = _tmp33__length1;
	}
	result = _tmp33_;
	return result;
}


static void expression_tokenizer_expand (ExpressionTokenizer* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp0_ = self->priv->last;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->current;
		self->priv->last = _tmp1_;
	}
}


static void expression_tokenizer_addcurrent (ExpressionTokenizer* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp0_ = self->priv->current;
	expression_tokenizer_add (self, *_tmp0_);
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void expression_tokenizer_add (ExpressionTokenizer* self, gchar what) {
	gchar* token = NULL;
	gchar _tmp0_ = '\0';
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp0_ = what;
	_tmp1_ = g_strdup_printf ("%c", _tmp0_);
	token = _tmp1_;
	_tmp2_ = self->priv->result;
	_tmp2__length1 = self->priv->result_length1;
	_tmp3_ = g_strdup (token);
	_vala_array_add3 (&self->priv->result, &self->priv->result_length1, &self->priv->_result_size_, _tmp3_);
	_g_free0 (token);
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void expression_tokenizer_save (ExpressionTokenizer* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp0_ = self->priv->last;
	if (_tmp0_ != NULL) {
		gchar* token = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp1_ = self->priv->last;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->last;
		_tmp4_ = g_strndup (_tmp1_, _tmp2_ - _tmp3_);
		token = _tmp4_;
		_tmp5_ = self->priv->result;
		_tmp5__length1 = self->priv->result_length1;
		_tmp6_ = token;
		_tmp7_ = g_strdup (_tmp6_);
		_vala_array_add4 (&self->priv->result, &self->priv->result_length1, &self->priv->_result_size_, _tmp7_);
		self->priv->last = NULL;
		_g_free0 (token);
	} else {
	}
}


static void expression_tokenizer_savewithcurrent (ExpressionTokenizer* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp0_ = self->priv->current;
	expression_tokenizer_savewith (self, *_tmp0_);
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void expression_tokenizer_savewith (ExpressionTokenizer* self, gchar what) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* token = NULL;
	const gchar* _tmp7_ = NULL;
	gchar _tmp8_ = '\0';
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar* _tmp14_ = NULL;
	g_return_if_fail (IS_EXPRESSION_TOKENIZER (self));
	_tmp1_ = self->priv->last;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->last;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->last;
		_tmp5_ = g_strndup (_tmp2_, _tmp3_ - _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = _tmp0_;
	_tmp8_ = what;
	_tmp9_ = g_strdup_printf ("%c", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	token = _tmp12_;
	_tmp13_ = self->priv->result;
	_tmp13__length1 = self->priv->result_length1;
	_tmp14_ = g_strdup (token);
	_vala_array_add5 (&self->priv->result, &self->priv->result_length1, &self->priv->_result_size_, _tmp14_);
	self->priv->last = NULL;
	_g_free0 (token);
	_g_free0 (_tmp0_);
}


static gboolean expression_tokenizer_isspace (ExpressionTokenizer* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_TOKENIZER (self), FALSE);
	_tmp0_ = self->priv->current;
	result = (*_tmp0_) == ' ';
	return result;
}


static gboolean expression_tokenizer_isvariable (ExpressionTokenizer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (IS_EXPRESSION_TOKENIZER (self), FALSE);
	_tmp3_ = self->priv->current;
	if ((*_tmp3_) >= 'a') {
		gchar* _tmp4_ = NULL;
		_tmp4_ = self->priv->current;
		_tmp2_ = (*_tmp4_) <= 'z';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = self->priv->current;
		if ((*_tmp7_) >= '0') {
			gchar* _tmp8_ = NULL;
			_tmp8_ = self->priv->current;
			_tmp6_ = (*_tmp8_) <= '9';
		} else {
			_tmp6_ = FALSE;
		}
		_tmp9_ = _tmp6_;
		_tmp1_ = _tmp9_;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp11_ = NULL;
		_tmp11_ = self->priv->current;
		_tmp0_ = (*_tmp11_) == '.';
	}
	_tmp12_ = _tmp0_;
	result = _tmp12_;
	return result;
}


ExpressionTokenizer* expression_tokenizer_construct (GType object_type) {
	ExpressionTokenizer* self = NULL;
	self = (ExpressionTokenizer*) g_type_create_instance (object_type);
	return self;
}


ExpressionTokenizer* expression_tokenizer_new (void) {
	return expression_tokenizer_construct (TYPE_EXPRESSION_TOKENIZER);
}


static void value_expression_tokenizer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_expression_tokenizer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		expression_tokenizer_unref (value->data[0].v_pointer);
	}
}


static void value_expression_tokenizer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = expression_tokenizer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_expression_tokenizer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_expression_tokenizer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ExpressionTokenizer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = expression_tokenizer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_expression_tokenizer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ExpressionTokenizer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = expression_tokenizer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_expression_tokenizer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExpressionTokenizer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPRESSION_TOKENIZER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_expression_tokenizer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_TOKENIZER), NULL);
	return value->data[0].v_pointer;
}


void value_set_expression_tokenizer (GValue* value, gpointer v_object) {
	ExpressionTokenizer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_TOKENIZER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPRESSION_TOKENIZER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		expression_tokenizer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		expression_tokenizer_unref (old);
	}
}


void value_take_expression_tokenizer (GValue* value, gpointer v_object) {
	ExpressionTokenizer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_TOKENIZER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPRESSION_TOKENIZER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		expression_tokenizer_unref (old);
	}
}


static void expression_tokenizer_class_init (ExpressionTokenizerClass * klass) {
	expression_tokenizer_parent_class = g_type_class_peek_parent (klass);
	EXPRESSION_TOKENIZER_CLASS (klass)->finalize = expression_tokenizer_finalize;
	g_type_class_add_private (klass, sizeof (ExpressionTokenizerPrivate));
}


static void expression_tokenizer_instance_init (ExpressionTokenizer * self) {
	self->priv = EXPRESSION_TOKENIZER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void expression_tokenizer_finalize (ExpressionTokenizer* obj) {
	ExpressionTokenizer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_TOKENIZER, ExpressionTokenizer);
	self->priv->result = (_vala_array_free (self->priv->result, self->priv->result_length1, (GDestroyNotify) g_free), NULL);
}


/******************************************************************************
 * Copyright (C) 2011-2013  Michael Hofmann <mh21@mh21.de>                    *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public License as published by       *
 * the Free Software Foundation; either version 3 of the License, or          *
 * (at your option) any later version.                                        *
 *                                                                            *
 * This program is distributed in the hope that it will be useful,            *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 * GNU General Public License for more details.                               *
 *                                                                            *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.                *
 ******************************************************************************/
GType expression_tokenizer_get_type (void) {
	static volatile gsize expression_tokenizer_type_id__volatile = 0;
	if (g_once_init_enter (&expression_tokenizer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_expression_tokenizer_init, value_expression_tokenizer_free_value, value_expression_tokenizer_copy_value, value_expression_tokenizer_peek_pointer, "p", value_expression_tokenizer_collect_value, "p", value_expression_tokenizer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionTokenizerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_tokenizer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionTokenizer), 0, (GInstanceInitFunc) expression_tokenizer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType expression_tokenizer_type_id;
		expression_tokenizer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ExpressionTokenizer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&expression_tokenizer_type_id__volatile, expression_tokenizer_type_id);
	}
	return expression_tokenizer_type_id__volatile;
}


gpointer expression_tokenizer_ref (gpointer instance) {
	ExpressionTokenizer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void expression_tokenizer_unref (gpointer instance) {
	ExpressionTokenizer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPRESSION_TOKENIZER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ExpressionEvaluator* expression_evaluator_construct (GType object_type, Providers* providers) {
	ExpressionEvaluator* self = NULL;
	Providers* _tmp0_ = NULL;
	Providers* _tmp1_ = NULL;
	g_return_val_if_fail (IS_PROVIDERS (providers), NULL);
	self = (ExpressionEvaluator*) g_type_create_instance (object_type);
	_tmp0_ = providers;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->providers);
	self->priv->providers = _tmp1_;
	return self;
}


ExpressionEvaluator* expression_evaluator_new (Providers* providers) {
	return expression_evaluator_construct (TYPE_EXPRESSION_EVALUATOR, providers);
}


static GError* expression_evaluator_error (guint index, const gchar* message) {
	GError* result = NULL;
	GQuark _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = g_quark_from_string ("expression-error-quark");
	_tmp1_ = index;
	_tmp2_ = message;
	_tmp3_ = g_error_new (_tmp0_, (gint) _tmp1_, "%s", _tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* expression_evaluator_parens_or_identifier (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_tmp0_ = self->priv->index;
	_tmp1_ = self->priv->tokens;
	_tmp1__length1 = self->priv->tokens_length1;
	if (_tmp0_ >= ((guint) _tmp1__length1)) {
		guint _tmp2_ = 0U;
		GError* _tmp3_ = NULL;
		_tmp2_ = self->priv->index;
		_tmp3_ = expression_evaluator_error (_tmp2_, "empty expression");
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = self->priv->tokens;
	_tmp4__length1 = self->priv->tokens_length1;
	_tmp5_ = self->priv->index;
	_tmp6_ = _tmp4_[_tmp5_];
	if (g_strcmp0 (_tmp6_, "(") == 0) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp8_ = expression_evaluator_parens (self, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp7_;
		return result;
	}
	_tmp10_ = expression_evaluator_identifier (self, &_inner_error_);
	_tmp9_ = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp9_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


static gchar* expression_evaluator_times (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gboolean div = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_result_ = NULL;
	div = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			guint _tmp2_ = 0U;
			gchar** _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			gchar* value = NULL;
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			guint _tmp21_ = 0U;
			gchar** _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			guint _tmp24_ = 0U;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GQuark _tmp28_ = 0U;
			static GQuark _tmp27_label0 = 0;
			static GQuark _tmp27_label1 = 0;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->index;
			_tmp3_ = self->priv->tokens;
			_tmp3__length1 = self->priv->tokens_length1;
			if (_tmp2_ >= ((guint) _tmp3__length1)) {
				guint _tmp4_ = 0U;
				GError* _tmp5_ = NULL;
				_tmp4_ = self->priv->index;
				_tmp5_ = expression_evaluator_error (_tmp4_, "expression expected");
				_inner_error_ = _tmp5_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			}
			_tmp6_ = expression_evaluator_parens_or_identifier (self, &_inner_error_);
			value = _tmp6_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			}
			_tmp7_ = _result_;
			if (_tmp7_ == NULL) {
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				_tmp8_ = value;
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (_result_);
				_result_ = _tmp9_;
			} else {
				gboolean _tmp10_ = FALSE;
				_tmp10_ = div;
				if (!_tmp10_) {
					const gchar* _tmp11_ = NULL;
					gdouble _tmp12_ = 0.0;
					const gchar* _tmp13_ = NULL;
					gdouble _tmp14_ = 0.0;
					gchar* _tmp15_ = NULL;
					_tmp11_ = _result_;
					_tmp12_ = double_parse (_tmp11_);
					_tmp13_ = value;
					_tmp14_ = double_parse (_tmp13_);
					_tmp15_ = double_to_string (_tmp12_ * _tmp14_);
					_g_free0 (_result_);
					_result_ = _tmp15_;
				} else {
					const gchar* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					const gchar* _tmp18_ = NULL;
					gdouble _tmp19_ = 0.0;
					gchar* _tmp20_ = NULL;
					_tmp16_ = _result_;
					_tmp17_ = double_parse (_tmp16_);
					_tmp18_ = value;
					_tmp19_ = double_parse (_tmp18_);
					_tmp20_ = double_to_string (_tmp17_ / _tmp19_);
					_g_free0 (_result_);
					_result_ = _tmp20_;
				}
			}
			_tmp21_ = self->priv->index;
			_tmp22_ = self->priv->tokens;
			_tmp22__length1 = self->priv->tokens_length1;
			if (_tmp21_ >= ((guint) _tmp22__length1)) {
				result = _result_;
				_g_free0 (value);
				return result;
			}
			_tmp23_ = self->priv->tokens;
			_tmp23__length1 = self->priv->tokens_length1;
			_tmp24_ = self->priv->index;
			_tmp25_ = _tmp23_[_tmp24_];
			_tmp26_ = _tmp25_;
			_tmp28_ = (NULL == _tmp26_) ? 0 : g_quark_from_string (_tmp26_);
			if (_tmp28_ == ((0 != _tmp27_label0) ? _tmp27_label0 : (_tmp27_label0 = g_quark_from_static_string ("*")))) {
				switch (0) {
					default:
					{
						guint _tmp29_ = 0U;
						div = FALSE;
						_tmp29_ = self->priv->index;
						self->priv->index = _tmp29_ + 1;
						continue;
					}
				}
			} else if (_tmp28_ == ((0 != _tmp27_label1) ? _tmp27_label1 : (_tmp27_label1 = g_quark_from_static_string ("/")))) {
				switch (0) {
					default:
					{
						guint _tmp30_ = 0U;
						div = TRUE;
						_tmp30_ = self->priv->index;
						self->priv->index = _tmp30_ + 1;
						continue;
					}
				}
			} else {
				switch (0) {
					default:
					{
						result = _result_;
						_g_free0 (value);
						return result;
					}
				}
			}
			_g_free0 (value);
		}
	}
	_g_free0 (_result_);
}


static gchar* expression_evaluator_plus (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gboolean minus = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_result_ = NULL;
	minus = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			guint _tmp2_ = 0U;
			gchar** _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			gchar* value = NULL;
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			guint _tmp21_ = 0U;
			gchar** _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			guint _tmp24_ = 0U;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GQuark _tmp28_ = 0U;
			static GQuark _tmp27_label0 = 0;
			static GQuark _tmp27_label1 = 0;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->index;
			_tmp3_ = self->priv->tokens;
			_tmp3__length1 = self->priv->tokens_length1;
			if (_tmp2_ >= ((guint) _tmp3__length1)) {
				guint _tmp4_ = 0U;
				GError* _tmp5_ = NULL;
				_tmp4_ = self->priv->index;
				_tmp5_ = expression_evaluator_error (_tmp4_, "expression expected");
				_inner_error_ = _tmp5_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			}
			_tmp6_ = expression_evaluator_times (self, &_inner_error_);
			value = _tmp6_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			}
			_tmp7_ = _result_;
			if (_tmp7_ == NULL) {
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				_tmp8_ = value;
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (_result_);
				_result_ = _tmp9_;
			} else {
				gboolean _tmp10_ = FALSE;
				_tmp10_ = minus;
				if (!_tmp10_) {
					const gchar* _tmp11_ = NULL;
					gdouble _tmp12_ = 0.0;
					const gchar* _tmp13_ = NULL;
					gdouble _tmp14_ = 0.0;
					gchar* _tmp15_ = NULL;
					_tmp11_ = _result_;
					_tmp12_ = double_parse (_tmp11_);
					_tmp13_ = value;
					_tmp14_ = double_parse (_tmp13_);
					_tmp15_ = double_to_string (_tmp12_ + _tmp14_);
					_g_free0 (_result_);
					_result_ = _tmp15_;
				} else {
					const gchar* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					const gchar* _tmp18_ = NULL;
					gdouble _tmp19_ = 0.0;
					gchar* _tmp20_ = NULL;
					_tmp16_ = _result_;
					_tmp17_ = double_parse (_tmp16_);
					_tmp18_ = value;
					_tmp19_ = double_parse (_tmp18_);
					_tmp20_ = double_to_string (_tmp17_ - _tmp19_);
					_g_free0 (_result_);
					_result_ = _tmp20_;
				}
			}
			_tmp21_ = self->priv->index;
			_tmp22_ = self->priv->tokens;
			_tmp22__length1 = self->priv->tokens_length1;
			if (_tmp21_ >= ((guint) _tmp22__length1)) {
				result = _result_;
				_g_free0 (value);
				return result;
			}
			_tmp23_ = self->priv->tokens;
			_tmp23__length1 = self->priv->tokens_length1;
			_tmp24_ = self->priv->index;
			_tmp25_ = _tmp23_[_tmp24_];
			_tmp26_ = _tmp25_;
			_tmp28_ = (NULL == _tmp26_) ? 0 : g_quark_from_string (_tmp26_);
			if (_tmp28_ == ((0 != _tmp27_label0) ? _tmp27_label0 : (_tmp27_label0 = g_quark_from_static_string ("+")))) {
				switch (0) {
					default:
					{
						guint _tmp29_ = 0U;
						minus = FALSE;
						_tmp29_ = self->priv->index;
						self->priv->index = _tmp29_ + 1;
						continue;
					}
				}
			} else if (_tmp28_ == ((0 != _tmp27_label1) ? _tmp27_label1 : (_tmp27_label1 = g_quark_from_static_string ("-")))) {
				switch (0) {
					default:
					{
						guint _tmp30_ = 0U;
						minus = TRUE;
						_tmp30_ = self->priv->index;
						self->priv->index = _tmp30_ + 1;
						continue;
					}
				}
			} else {
				switch (0) {
					default:
					{
						result = _result_;
						_g_free0 (value);
						return result;
					}
				}
			}
			_g_free0 (value);
		}
	}
	_g_free0 (_result_);
}


static gchar* expression_evaluator_parens (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean _tmp6_ = FALSE;
	guint _tmp9_ = 0U;
	gchar* _result_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	guint _tmp12_ = 0U;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gboolean _tmp17_ = FALSE;
	guint _tmp20_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_tmp1_ = self->priv->index;
	_tmp2_ = self->priv->tokens;
	_tmp2__length1 = self->priv->tokens_length1;
	if (_tmp1_ >= ((guint) _tmp2__length1)) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		guint _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->tokens;
		_tmp3__length1 = self->priv->tokens_length1;
		_tmp4_ = self->priv->index;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp0_ = g_strcmp0 (_tmp5_, "(") != 0;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		guint _tmp7_ = 0U;
		GError* _tmp8_ = NULL;
		_tmp7_ = self->priv->index;
		_tmp8_ = expression_evaluator_error (_tmp7_, "'(' expected");
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp9_ = self->priv->index;
	self->priv->index = _tmp9_ + 1;
	_tmp10_ = expression_evaluator_plus (self, &_inner_error_);
	_result_ = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp12_ = self->priv->index;
	_tmp13_ = self->priv->tokens;
	_tmp13__length1 = self->priv->tokens_length1;
	if (_tmp12_ >= ((guint) _tmp13__length1)) {
		_tmp11_ = TRUE;
	} else {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		guint _tmp15_ = 0U;
		const gchar* _tmp16_ = NULL;
		_tmp14_ = self->priv->tokens;
		_tmp14__length1 = self->priv->tokens_length1;
		_tmp15_ = self->priv->index;
		_tmp16_ = _tmp14_[_tmp15_];
		_tmp11_ = g_strcmp0 (_tmp16_, ")") != 0;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		guint _tmp18_ = 0U;
		GError* _tmp19_ = NULL;
		_tmp18_ = self->priv->index;
		_tmp19_ = expression_evaluator_error (_tmp18_, "')' expected");
		_inner_error_ = _tmp19_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (_result_);
		return NULL;
	}
	_tmp20_ = self->priv->index;
	self->priv->index = _tmp20_ + 1;
	result = _result_;
	return result;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** expression_evaluator_params (ExpressionEvaluator* self, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean _tmp6_ = FALSE;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	guint _tmp15_ = 0U;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp30_ = FALSE;
	guint _tmp31_ = 0U;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	gboolean _tmp36_ = FALSE;
	guint _tmp39_ = 0U;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_result_ = NULL;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = self->priv->index;
	_tmp2_ = self->priv->tokens;
	_tmp2__length1 = self->priv->tokens_length1;
	if (_tmp1_ >= ((guint) _tmp2__length1)) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		guint _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->tokens;
		_tmp3__length1 = self->priv->tokens_length1;
		_tmp4_ = self->priv->index;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp0_ = g_strcmp0 (_tmp5_, "(") != 0;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		guint _tmp7_ = 0U;
		GError* _tmp8_ = NULL;
		_tmp7_ = self->priv->index;
		_tmp8_ = expression_evaluator_error (_tmp7_, "'(' expected");
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp9_ = self->priv->index;
	self->priv->index = _tmp9_ + 1;
	_tmp10_ = self->priv->index;
	_tmp11_ = self->priv->tokens;
	_tmp11__length1 = self->priv->tokens_length1;
	if (_tmp10_ >= ((guint) _tmp11__length1)) {
		guint _tmp12_ = 0U;
		GError* _tmp13_ = NULL;
		_tmp12_ = self->priv->index;
		_tmp13_ = expression_evaluator_error (_tmp12_, "parameters expected");
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp14_ = self->priv->tokens;
	_tmp14__length1 = self->priv->tokens_length1;
	_tmp15_ = self->priv->index;
	_tmp16_ = _tmp14_[_tmp15_];
	if (g_strcmp0 (_tmp16_, ")") != 0) {
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				guint _tmp22_ = 0U;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				guint _tmp27_ = 0U;
				const gchar* _tmp28_ = NULL;
				guint _tmp29_ = 0U;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
				}
				_tmp17_ = FALSE;
				_tmp20_ = expression_evaluator_plus (self, &_inner_error_);
				_tmp19_ = _tmp20_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
					return NULL;
				}
				_tmp21_ = _result_;
				_tmp21__length1 = _result__length1;
				_vala_array_add6 (&_result_, &_result__length1, &__result__size_, _tmp19_);
				_tmp22_ = self->priv->index;
				_tmp23_ = self->priv->tokens;
				_tmp23__length1 = self->priv->tokens_length1;
				if (_tmp22_ >= ((guint) _tmp23__length1)) {
					guint _tmp24_ = 0U;
					GError* _tmp25_ = NULL;
					_tmp24_ = self->priv->index;
					_tmp25_ = expression_evaluator_error (_tmp24_, "')' expected");
					_inner_error_ = _tmp25_;
					g_propagate_error (error, _inner_error_);
					_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
					return NULL;
				}
				_tmp26_ = self->priv->tokens;
				_tmp26__length1 = self->priv->tokens_length1;
				_tmp27_ = self->priv->index;
				_tmp28_ = _tmp26_[_tmp27_];
				if (g_strcmp0 (_tmp28_, ",") != 0) {
					break;
				}
				_tmp29_ = self->priv->index;
				self->priv->index = _tmp29_ + 1;
			}
		}
	}
	_tmp31_ = self->priv->index;
	_tmp32_ = self->priv->tokens;
	_tmp32__length1 = self->priv->tokens_length1;
	if (_tmp31_ >= ((guint) _tmp32__length1)) {
		_tmp30_ = TRUE;
	} else {
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		guint _tmp34_ = 0U;
		const gchar* _tmp35_ = NULL;
		_tmp33_ = self->priv->tokens;
		_tmp33__length1 = self->priv->tokens_length1;
		_tmp34_ = self->priv->index;
		_tmp35_ = _tmp33_[_tmp34_];
		_tmp30_ = g_strcmp0 (_tmp35_, ")") != 0;
	}
	_tmp36_ = _tmp30_;
	if (_tmp36_) {
		guint _tmp37_ = 0U;
		GError* _tmp38_ = NULL;
		_tmp37_ = self->priv->index;
		_tmp38_ = expression_evaluator_error (_tmp37_, "')' expected");
		_inner_error_ = _tmp38_;
		g_propagate_error (error, _inner_error_);
		_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp39_ = self->priv->index;
	self->priv->index = _tmp39_ + 1;
	_tmp40_ = _result_;
	_tmp40__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp40__length1;
	}
	result = _tmp40_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* expression_evaluator_identifier (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gdouble sign = 0.0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* token = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	guint _tmp21_ = 0U;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gboolean _tmp61_ = FALSE;
	gchar** varparts = NULL;
	const gchar* _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gchar** _tmp68_ = NULL;
	gint varparts_length1 = 0;
	gint _varparts_size_ = 0;
	guint nameindex = 0U;
	guint _tmp69_ = 0U;
	guint _tmp70_ = 0U;
	gchar** _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_tmp0_ = self->priv->index;
	_tmp1_ = self->priv->tokens;
	_tmp1__length1 = self->priv->tokens_length1;
	if (_tmp0_ >= ((guint) _tmp1__length1)) {
		guint _tmp2_ = 0U;
		GError* _tmp3_ = NULL;
		_tmp2_ = self->priv->index;
		_tmp3_ = expression_evaluator_error (_tmp2_, "identifier expected");
		_inner_error_ = _tmp3_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	sign = (gdouble) 1;
	_tmp4_ = self->priv->tokens;
	_tmp4__length1 = self->priv->tokens_length1;
	_tmp5_ = self->priv->index;
	_tmp6_ = _tmp4_[_tmp5_];
	if (g_strcmp0 (_tmp6_, "+") == 0) {
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp7_ = self->priv->index;
		self->priv->index = _tmp7_ + 1;
		_tmp8_ = self->priv->index;
		_tmp9_ = self->priv->tokens;
		_tmp9__length1 = self->priv->tokens_length1;
		if (_tmp8_ >= ((guint) _tmp9__length1)) {
			guint _tmp10_ = 0U;
			GError* _tmp11_ = NULL;
			_tmp10_ = self->priv->index;
			_tmp11_ = expression_evaluator_error (_tmp10_, "identifier expected");
			_inner_error_ = _tmp11_;
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		guint _tmp13_ = 0U;
		const gchar* _tmp14_ = NULL;
		_tmp12_ = self->priv->tokens;
		_tmp12__length1 = self->priv->tokens_length1;
		_tmp13_ = self->priv->index;
		_tmp14_ = _tmp12_[_tmp13_];
		if (g_strcmp0 (_tmp14_, "-") == 0) {
			guint _tmp15_ = 0U;
			guint _tmp16_ = 0U;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			sign = -1.0;
			_tmp15_ = self->priv->index;
			self->priv->index = _tmp15_ + 1;
			_tmp16_ = self->priv->index;
			_tmp17_ = self->priv->tokens;
			_tmp17__length1 = self->priv->tokens_length1;
			if (_tmp16_ >= ((guint) _tmp17__length1)) {
				guint _tmp18_ = 0U;
				GError* _tmp19_ = NULL;
				_tmp18_ = self->priv->index;
				_tmp19_ = expression_evaluator_error (_tmp18_, "identifier expected");
				_inner_error_ = _tmp19_;
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
	_tmp20_ = self->priv->tokens;
	_tmp20__length1 = self->priv->tokens_length1;
	_tmp21_ = self->priv->index;
	_tmp22_ = _tmp20_[_tmp21_];
	_tmp23_ = g_strdup (_tmp22_);
	token = _tmp23_;
	_tmp25_ = token;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ > 0) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_ = NULL;
		gchar _tmp30_ = '\0';
		gboolean _tmp33_ = FALSE;
		_tmp29_ = token;
		_tmp30_ = string_get (_tmp29_, (glong) 0);
		if (_tmp30_ == '\'') {
			_tmp28_ = TRUE;
		} else {
			const gchar* _tmp31_ = NULL;
			gchar _tmp32_ = '\0';
			_tmp31_ = token;
			_tmp32_ = string_get (_tmp31_, (glong) 0);
			_tmp28_ = _tmp32_ == '"';
		}
		_tmp33_ = _tmp28_;
		_tmp24_ = _tmp33_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp34_ = _tmp24_;
	if (_tmp34_) {
		guint _tmp35_ = 0U;
		const gchar* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		const gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		_tmp35_ = self->priv->index;
		self->priv->index = _tmp35_ + 1;
		_tmp37_ = sign;
		if (_tmp37_ == ((gdouble) (-1))) {
			_tmp36_ = "-";
		} else {
			_tmp36_ = "";
		}
		_tmp38_ = _tmp36_;
		_tmp39_ = token;
		_tmp40_ = token;
		_tmp41_ = strlen (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = string_slice (_tmp39_, (glong) 1, (glong) (_tmp42_ - 1));
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp38_, _tmp44_, NULL);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp44_);
		result = _tmp46_;
		_g_free0 (token);
		return result;
	}
	_tmp48_ = token;
	_tmp49_ = strlen (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ > 0) {
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_ = NULL;
		gchar _tmp54_ = '\0';
		gboolean _tmp57_ = FALSE;
		gboolean _tmp60_ = FALSE;
		_tmp53_ = token;
		_tmp54_ = string_get (_tmp53_, (glong) 0);
		if (_tmp54_ >= '0') {
			const gchar* _tmp55_ = NULL;
			gchar _tmp56_ = '\0';
			_tmp55_ = token;
			_tmp56_ = string_get (_tmp55_, (glong) 0);
			_tmp52_ = _tmp56_ <= '9';
		} else {
			_tmp52_ = FALSE;
		}
		_tmp57_ = _tmp52_;
		if (_tmp57_) {
			_tmp51_ = TRUE;
		} else {
			const gchar* _tmp58_ = NULL;
			gchar _tmp59_ = '\0';
			_tmp58_ = token;
			_tmp59_ = string_get (_tmp58_, (glong) 0);
			_tmp51_ = _tmp59_ == '.';
		}
		_tmp60_ = _tmp51_;
		_tmp47_ = _tmp60_;
	} else {
		_tmp47_ = FALSE;
	}
	_tmp61_ = _tmp47_;
	if (_tmp61_) {
		guint _tmp62_ = 0U;
		gdouble _tmp63_ = 0.0;
		_tmp62_ = self->priv->index;
		self->priv->index = _tmp62_ + 1;
		_tmp63_ = sign;
		if (_tmp63_ == ((gdouble) (-1))) {
			const gchar* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			_tmp64_ = token;
			_tmp65_ = g_strconcat ("-", _tmp64_, NULL);
			result = _tmp65_;
			_g_free0 (token);
			return result;
		}
		result = token;
		return result;
	}
	_tmp66_ = token;
	_tmp68_ = _tmp67_ = g_strsplit (_tmp66_, ".", 2);
	varparts = _tmp68_;
	varparts_length1 = _vala_array_length (_tmp67_);
	_varparts_size_ = varparts_length1;
	_tmp69_ = self->priv->index;
	nameindex = _tmp69_;
	_tmp70_ = self->priv->index;
	self->priv->index = _tmp70_ + 1;
	_tmp71_ = varparts;
	_tmp71__length1 = varparts_length1;
	switch (_tmp71__length1) {
		case 1:
		{
			gboolean found = FALSE;
			found = FALSE;
			{
				gchar** _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gchar** _tmp74_ = NULL;
				gint _tmp72__length1 = 0;
				gint __tmp72__size_ = 0;
				gchar* _result_ = NULL;
				Providers* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				gchar** _tmp77_ = NULL;
				gint _tmp77__length1 = 0;
				gboolean _tmp78_ = FALSE;
				gboolean _tmp79_ = FALSE;
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gboolean _tmp82_ = FALSE;
				const gchar* _tmp85_ = NULL;
				gdouble _tmp86_ = 0.0;
				const gchar* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				_tmp74_ = expression_evaluator_params (self, &_tmp73_, &_inner_error_);
				_tmp72_ = _tmp74_;
				_tmp72__length1 = _tmp73_;
				__tmp72__size_ = _tmp72__length1;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_tmp75_ = self->priv->providers;
				_tmp76_ = token;
				_tmp77_ = _tmp72_;
				_tmp77__length1 = _tmp72__length1;
				_tmp78_ = self->priv->guide;
				_tmp80_ = providers_call (_tmp75_, _tmp76_, _tmp77_, _tmp72__length1, _tmp78_, &_tmp79_, &_inner_error_);
				found = _tmp79_;
				_tmp81_ = _tmp80_;
				_tmp77_ = (_vala_array_free (_tmp77_, _tmp77__length1, (GDestroyNotify) g_free), NULL);
				_result_ = _tmp81_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_tmp82_ = found;
				if (!_tmp82_) {
					guint _tmp83_ = 0U;
					GError* _tmp84_ = NULL;
					_tmp83_ = nameindex;
					_tmp84_ = expression_evaluator_error (_tmp83_, "unknown function");
					_inner_error_ = _tmp84_;
					_g_free0 (_result_);
					goto __catch3_g_error;
				}
				_tmp86_ = sign;
				if (_tmp86_ == ((gdouble) (-1))) {
					_tmp85_ = "-";
				} else {
					_tmp85_ = "";
				}
				_tmp87_ = _tmp85_;
				_tmp88_ = _result_;
				_tmp89_ = g_strconcat (_tmp87_, _tmp88_, NULL);
				result = _tmp89_;
				_g_free0 (_result_);
				varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (token);
				return result;
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				guint _tmp90_ = 0U;
				GError* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				GError* _tmp93_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp90_ = nameindex;
				_tmp91_ = e;
				_tmp92_ = _tmp91_->message;
				_tmp93_ = expression_evaluator_error (_tmp90_, _tmp92_);
				_inner_error_ = _tmp93_;
				_g_error_free0 (e);
				goto __finally3;
			}
			__finally3:
			g_propagate_error (error, _inner_error_);
			varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (token);
			return NULL;
		}
		case 2:
		{
			gboolean found = FALSE;
			gchar* _result_ = NULL;
			gdouble _tmp94_ = 0.0;
			Providers* _tmp95_ = NULL;
			const gchar* _tmp96_ = NULL;
			gboolean _tmp97_ = FALSE;
			gdouble _tmp98_ = 0.0;
			gchar* _tmp99_ = NULL;
			gboolean _tmp100_ = FALSE;
			found = FALSE;
			_tmp94_ = sign;
			_tmp95_ = self->priv->providers;
			_tmp96_ = token;
			_tmp98_ = providers_value (_tmp95_, _tmp96_, &_tmp97_);
			found = _tmp97_;
			_tmp99_ = double_to_string (_tmp94_ * _tmp98_);
			_result_ = _tmp99_;
			_tmp100_ = found;
			if (!_tmp100_) {
				guint _tmp101_ = 0U;
				GError* _tmp102_ = NULL;
				_tmp101_ = nameindex;
				_tmp102_ = expression_evaluator_error (_tmp101_, "unknown variable");
				_inner_error_ = _tmp102_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (token);
				return NULL;
			}
			result = _result_;
			varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (token);
			return result;
		}
		default:
		{
			guint _tmp103_ = 0U;
			GError* _tmp104_ = NULL;
			_tmp103_ = nameindex;
			_tmp104_ = expression_evaluator_error (_tmp103_, "too many identifier parts");
			_inner_error_ = _tmp104_;
			g_propagate_error (error, _inner_error_);
			varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (token);
			return NULL;
		}
	}
	varparts = (_vala_array_free (varparts, varparts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (token);
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* expression_evaluator_text (ExpressionEvaluator* self, GError** error) {
	gchar* result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	while (TRUE) {
		guint _tmp1_ = 0U;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar* current = NULL;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		guint _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp1_ = self->priv->index;
		_tmp2_ = self->priv->tokens;
		_tmp2__length1 = self->priv->tokens_length1;
		if (!(_tmp1_ < ((guint) _tmp2__length1))) {
			break;
		}
		_tmp3_ = self->priv->tokens;
		_tmp3__length1 = self->priv->tokens_length1;
		_tmp4_ = self->priv->index;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp6_ = g_strdup (_tmp5_);
		current = _tmp6_;
		_tmp7_ = current;
		if (g_strcmp0 (_tmp7_, "$") == 0) {
			guint _tmp8_ = 0U;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp8_ = self->priv->index;
			self->priv->index = _tmp8_ + 1;
			_tmp10_ = expression_evaluator_parens_or_identifier (self, &_inner_error_);
			_tmp9_ = _tmp10_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (current);
				_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			}
			_tmp11_ = _result_;
			_tmp11__length1 = _result__length1;
			_vala_array_add7 (&_result_, &_result__length1, &__result__size_, _tmp9_);
		} else {
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			_tmp12_ = _result_;
			_tmp12__length1 = _result__length1;
			_tmp13_ = current;
			_tmp14_ = g_strdup (_tmp13_);
			_vala_array_add8 (&_result_, &_result__length1, &__result__size_, _tmp14_);
			_tmp15_ = self->priv->index;
			self->priv->index = _tmp15_ + 1;
		}
		_g_free0 (current);
	}
	_tmp16_ = _result_;
	_tmp16__length1 = _result__length1;
	_tmp17_ = g_strjoinv ("", _tmp16_);
	result = _tmp17_;
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar* expression_evaluator_evaluate (ExpressionEvaluator* self, gchar** tokens, int tokens_length1, gboolean guide) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_EVALUATOR (self), NULL);
	self->priv->index = (guint) 0;
	_tmp0_ = tokens;
	_tmp0__length1 = tokens_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->tokens = (_vala_array_free (self->priv->tokens, self->priv->tokens_length1, (GDestroyNotify) g_free), NULL);
	self->priv->tokens = _tmp1_;
	self->priv->tokens_length1 = _tmp1__length1;
	self->priv->_tokens_size_ = self->priv->tokens_length1;
	_tmp2_ = guide;
	self->priv->guide = _tmp2_;
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp4_ = expression_evaluator_text (self, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		result = _tmp3_;
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* errormessage = NULL;
		gchar* _tmp8_ = NULL;
		gint errorpos = 0;
		gint _tmp28_ = 0;
		FILE* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Expression error: %s\n", _tmp7_);
		_tmp8_ = g_strdup ("");
		errormessage = _tmp8_;
		errorpos = -1;
		{
			guint i = 0U;
			guint isize = 0U;
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			i = (guint) 0;
			_tmp9_ = self->priv->tokens;
			_tmp9__length1 = self->priv->tokens_length1;
			isize = (guint) _tmp9__length1;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gboolean _tmp11_ = FALSE;
					guint _tmp13_ = 0U;
					guint _tmp14_ = 0U;
					GError* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					guint _tmp17_ = 0U;
					const gchar* _tmp21_ = NULL;
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					guint _tmp23_ = 0U;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						guint _tmp12_ = 0U;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = isize;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = e;
					_tmp16_ = _tmp15_->code;
					_tmp17_ = i;
					if (((guint) _tmp16_) == _tmp17_) {
						const gchar* _tmp18_ = NULL;
						gint _tmp19_ = 0;
						gint _tmp20_ = 0;
						_tmp18_ = errormessage;
						_tmp19_ = strlen (_tmp18_);
						_tmp20_ = _tmp19_;
						errorpos = _tmp20_;
					}
					_tmp21_ = errormessage;
					_tmp22_ = self->priv->tokens;
					_tmp22__length1 = self->priv->tokens_length1;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = g_strconcat (" ", _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp21_, _tmp26_, NULL);
					_g_free0 (errormessage);
					errormessage = _tmp27_;
					_g_free0 (_tmp26_);
				}
			}
		}
		_tmp28_ = errorpos;
		if (_tmp28_ < 0) {
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			_tmp29_ = errormessage;
			_tmp30_ = strlen (_tmp29_);
			_tmp31_ = _tmp30_;
			errorpos = _tmp31_;
		}
		_tmp32_ = stderr;
		_tmp33_ = errormessage;
		_tmp34_ = errorpos;
		_tmp35_ = g_strnfill ((gsize) _tmp34_, '-');
		_tmp36_ = _tmp35_;
		fprintf (_tmp32_, "%s\n%s^\n", _tmp33_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = g_strdup ("");
		result = _tmp37_;
		_g_free0 (errormessage);
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void value_expression_evaluator_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_expression_evaluator_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		expression_evaluator_unref (value->data[0].v_pointer);
	}
}


static void value_expression_evaluator_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = expression_evaluator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_expression_evaluator_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_expression_evaluator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ExpressionEvaluator* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = expression_evaluator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_expression_evaluator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ExpressionEvaluator** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = expression_evaluator_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_expression_evaluator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExpressionEvaluator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPRESSION_EVALUATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_expression_evaluator (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_EVALUATOR), NULL);
	return value->data[0].v_pointer;
}


void value_set_expression_evaluator (GValue* value, gpointer v_object) {
	ExpressionEvaluator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_EVALUATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPRESSION_EVALUATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		expression_evaluator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		expression_evaluator_unref (old);
	}
}


void value_take_expression_evaluator (GValue* value, gpointer v_object) {
	ExpressionEvaluator* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPRESSION_EVALUATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPRESSION_EVALUATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		expression_evaluator_unref (old);
	}
}


static void expression_evaluator_class_init (ExpressionEvaluatorClass * klass) {
	expression_evaluator_parent_class = g_type_class_peek_parent (klass);
	EXPRESSION_EVALUATOR_CLASS (klass)->finalize = expression_evaluator_finalize;
	g_type_class_add_private (klass, sizeof (ExpressionEvaluatorPrivate));
}


static void expression_evaluator_instance_init (ExpressionEvaluator * self) {
	self->priv = EXPRESSION_EVALUATOR_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void expression_evaluator_finalize (ExpressionEvaluator* obj) {
	ExpressionEvaluator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_EVALUATOR, ExpressionEvaluator);
	_g_object_unref0 (self->priv->providers);
	self->priv->tokens = (_vala_array_free (self->priv->tokens, self->priv->tokens_length1, (GDestroyNotify) g_free), NULL);
}


GType expression_evaluator_get_type (void) {
	static volatile gsize expression_evaluator_type_id__volatile = 0;
	if (g_once_init_enter (&expression_evaluator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_expression_evaluator_init, value_expression_evaluator_free_value, value_expression_evaluator_copy_value, value_expression_evaluator_peek_pointer, "p", value_expression_evaluator_collect_value, "p", value_expression_evaluator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionEvaluatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_evaluator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionEvaluator), 0, (GInstanceInitFunc) expression_evaluator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType expression_evaluator_type_id;
		expression_evaluator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ExpressionEvaluator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&expression_evaluator_type_id__volatile, expression_evaluator_type_id);
	}
	return expression_evaluator_type_id__volatile;
}


gpointer expression_evaluator_ref (gpointer instance) {
	ExpressionEvaluator* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void expression_evaluator_unref (gpointer instance) {
	ExpressionEvaluator* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPRESSION_EVALUATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ExpressionCache* expression_cache_construct (GType object_type, Providers* providers, const gchar* expression) {
	ExpressionCache * self = NULL;
	Providers* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (IS_PROVIDERS (providers), NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = providers;
	_tmp1_ = expression;
	self = (ExpressionCache*) g_object_new (object_type, "providers", _tmp0_, "expression", _tmp1_, NULL);
	return self;
}


ExpressionCache* expression_cache_new (Providers* providers, const gchar* expression) {
	return expression_cache_construct (TYPE_EXPRESSION_CACHE, providers, expression);
}


void expression_cache_update (ExpressionCache* self) {
	g_return_if_fail (IS_EXPRESSION_CACHE (self));
	_g_free0 (self->priv->_label);
	self->priv->_label = NULL;
	_g_free0 (self->priv->_guide);
	self->priv->_guide = NULL;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** expression_cache_tokens (ExpressionCache* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (IS_EXPRESSION_CACHE (self), NULL);
	_tmp0_ = self->priv->_tokens;
	_tmp0__length1 = self->priv->_tokens_length1;
	if (_tmp0_ == NULL) {
		ExpressionTokenizer* _tmp1_ = NULL;
		ExpressionTokenizer* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		_tmp1_ = expression_tokenizer_new ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_expression;
		_tmp5_ = expression_tokenizer_tokenize (_tmp2_, _tmp3_, &_tmp4_);
		self->priv->_tokens = (_vala_array_free (self->priv->_tokens, self->priv->_tokens_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_tokens = _tmp5_;
		self->priv->_tokens_length1 = _tmp4_;
		self->priv->__tokens_size_ = self->priv->_tokens_length1;
		_expression_tokenizer_unref0 (_tmp2_);
	}
	_tmp6_ = self->priv->_tokens;
	_tmp6__length1 = self->priv->_tokens_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup7 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


gchar* expression_cache_label (ExpressionCache* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_CACHE (self), NULL);
	_tmp0_ = self->priv->_label;
	if (_tmp0_ == NULL) {
		Providers* _tmp1_ = NULL;
		ExpressionEvaluator* _tmp2_ = NULL;
		ExpressionEvaluator* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* _tmp7_ = NULL;
		_tmp1_ = self->priv->_providers;
		_tmp2_ = expression_evaluator_new (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp5_ = expression_cache_tokens (self, &_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp4_;
		_tmp7_ = expression_evaluator_evaluate (_tmp3_, _tmp6_, _tmp4_, FALSE);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp7_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		_expression_evaluator_unref0 (_tmp3_);
	}
	_tmp8_ = self->priv->_label;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	return result;
}


gchar* expression_cache_guide (ExpressionCache* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_CACHE (self), NULL);
	_tmp0_ = self->priv->_guide;
	if (_tmp0_ == NULL) {
		Providers* _tmp1_ = NULL;
		ExpressionEvaluator* _tmp2_ = NULL;
		ExpressionEvaluator* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* _tmp7_ = NULL;
		_tmp1_ = self->priv->_providers;
		_tmp2_ = expression_evaluator_new (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp5_ = expression_cache_tokens (self, &_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp4_;
		_tmp7_ = expression_evaluator_evaluate (_tmp3_, _tmp6_, _tmp4_, TRUE);
		_g_free0 (self->priv->_guide);
		self->priv->_guide = _tmp7_;
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		_expression_evaluator_unref0 (_tmp3_);
	}
	_tmp8_ = self->priv->_guide;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	return result;
}


Providers* expression_cache_get_providers (ExpressionCache* self) {
	Providers* result;
	Providers* _tmp0_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_CACHE (self), NULL);
	_tmp0_ = self->priv->_providers;
	result = _tmp0_;
	return result;
}


static void expression_cache_set_providers (ExpressionCache* self, Providers* value) {
	Providers* _tmp0_ = NULL;
	Providers* _tmp1_ = NULL;
	g_return_if_fail (IS_EXPRESSION_CACHE (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_providers);
	self->priv->_providers = _tmp1_;
	g_object_notify ((GObject *) self, "providers");
}


const gchar* expression_cache_get_expression (ExpressionCache* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_EXPRESSION_CACHE (self), NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


void expression_cache_set_expression (ExpressionCache* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_EXPRESSION_CACHE (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_expression);
	self->priv->_expression = _tmp1_;
	self->priv->_tokens = (_vala_array_free (self->priv->_tokens, self->priv->_tokens_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_tokens = NULL;
	self->priv->_tokens_length1 = 0;
	self->priv->__tokens_size_ = self->priv->_tokens_length1;
	_g_free0 (self->priv->_label);
	self->priv->_label = NULL;
	_g_free0 (self->priv->_guide);
	self->priv->_guide = NULL;
	g_object_notify ((GObject *) self, "expression");
}


static void expression_cache_class_init (ExpressionCacheClass * klass) {
	expression_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ExpressionCachePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_expression_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_expression_cache_set_property;
	G_OBJECT_CLASS (klass)->finalize = expression_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EXPRESSION_CACHE_PROVIDERS, g_param_spec_object ("providers", "providers", "providers", TYPE_PROVIDERS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), EXPRESSION_CACHE_EXPRESSION, g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void expression_cache_instance_init (ExpressionCache * self) {
	self->priv = EXPRESSION_CACHE_GET_PRIVATE (self);
}


static void expression_cache_finalize (GObject* obj) {
	ExpressionCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_CACHE, ExpressionCache);
	_g_object_unref0 (self->priv->_providers);
	self->priv->_tokens = (_vala_array_free (self->priv->_tokens, self->priv->_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_guide);
	_g_free0 (self->priv->_expression);
	G_OBJECT_CLASS (expression_cache_parent_class)->finalize (obj);
}


GType expression_cache_get_type (void) {
	static volatile gsize expression_cache_type_id__volatile = 0;
	if (g_once_init_enter (&expression_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionCache), 0, (GInstanceInitFunc) expression_cache_instance_init, NULL };
		GType expression_cache_type_id;
		expression_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "ExpressionCache", &g_define_type_info, 0);
		g_once_init_leave (&expression_cache_type_id__volatile, expression_cache_type_id);
	}
	return expression_cache_type_id__volatile;
}


static void _vala_expression_cache_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ExpressionCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EXPRESSION_CACHE, ExpressionCache);
	switch (property_id) {
		case EXPRESSION_CACHE_PROVIDERS:
		g_value_set_object (value, expression_cache_get_providers (self));
		break;
		case EXPRESSION_CACHE_EXPRESSION:
		g_value_set_string (value, expression_cache_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_expression_cache_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ExpressionCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EXPRESSION_CACHE, ExpressionCache);
	switch (property_id) {
		case EXPRESSION_CACHE_PROVIDERS:
		expression_cache_set_providers (self, g_value_get_object (value));
		break;
		case EXPRESSION_CACHE_EXPRESSION:
		expression_cache_set_expression (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



