typedef struct city
{
    char *name;
    int latdeg, latmin, longdeg, longmin;
    char *tz;
} city_t;

/*
 * Display invalid TZ using:
 *    grep -Eo '[_A-Za-z]+/[/_A-Za-z]+' cities.h |
 *      sort | uniq |
 *      while read -r f; do
 *        [ -f "/usr/share/zoneinfo/$f" ] || echo "$f"
 *      done
 *
 * Display coords not matching sign with:
 *    grep -o '{".*,\r\?$' cities.h |
 *      gawk -F', ' '{ if (($4 * $5 < 0) || ($2 * $3 < 0)) { print $0 } }'
 *
 * Manually verify names matching coords (rarely wrong):
 *    sed -n -e 's/^.*{"\(.*\)},.*$/\1/' -e 's/"//g' -e '/^[A-Z]/p' cities.h |
 *      gawk -F', ' '{
 *        lat=$2 + ($3 / 60.0)
 *        lon=-$4 - ($5 / 60.0)
 *        printf("\n%s\t%0.2f,%0.2f\n", $1, lat, lon)
 *        system(sprintf("curl -Ls https://www.google.com/maps/place/%0.2f,%0.2f | \
 *          sed -E -n '\''s/^.*<meta content=\"([^\"]*)\" itemprop=\"description\">.*$/\\1/p'\''",
 *          lat, lon))
 *        }'
 *
 * Manually check coord name and time zone (frequently wrong):
 *    sed -n -e 's/^.*{"\(.*\)},.*$/\1/' -e 's/"//g' -e '/^[A-Z]/p' cities.h |
 *      awk '{
 *        FS=", "
 *        printf "\n"
 *        print $0
 *        system(sprintf("curl -s \"https://api.teleport.org/api/locations/%0.2d,%0.2d/?embed=location:nearest-cities/location:nearest-city/city:timezone\" | \
 *          jq -r \".. | (.full_name? // .iana_name?) | select (. != null)\"",
 *          $2 + ($3 / 60.0), -$4 - ($5 / 60.0)))
 *      }'
 */
city_t cities[] =
{
    /* name, latdeg, latmin, longdeg, longmin, tz */
    {"Abuja", 9, 4, -7, -29, "Africa/Lagos"},
    {"Acre", 32, 56, -35, -5, "Asia/Jerusalem"},
    {"Adelaide", -34, -56, -138, -36, "Australia/Adelaide"},
    {"Akko", 32, 56, -35, -5, "Asia/Jerusalem"},
    {"Albany", 42, 39, 73, 45, "America/New_York"},
    {"Albuquerque", 35, 7, 106, 37, "America/Denver"},
    {"Almaty", 43, 17, -76, -54, "Asia/Almaty"},
    {"Amsterdam", 52, 22, -4, -53, "Europe/Amsterdam"},
    {"Anaheim", 33, 50, 117, 53, "America/Los_Angeles"},
    {"Anchorage", 61, 13, 149, 54, "America/Anchorage"},
    {"Antwerp", 51, 13, -4, -24, "Europe/Brussels"},
    {"Arad", 31, 15, -35, -13, "Asia/Jerusalem"},
    {"Arlington", 32, 42, 97, 7, "America/Chicago"},
    {"Ashdod", 31, 48, -34, -39, "Asia/Jerusalem"},
    {"Ashkelon", 31, 40, -34, -34, "Asia/Jerusalem"},
    {"Athens", 37, 59, -23, -43, "Europe/Athens"},
    {"Atlanta", 33, 45, 84, 23, "America/New_York"},
    {"Auckland", -36, -52, -174, -46, "Pacific/Auckland"},
    {"Aurora", 39, 43, 104, 49, "America/Denver"},
    {"Austin", 30, 16, 97, 45, "America/Chicago"},
    {"Baghdad", 33, 14, -44, -22, "Asia/Baghdad"},
    {"Bakersfield", 35, 22, 119, 1, "America/Los_Angeles"},
    {"Baku", 40, 23, -49, -54, "Asia/Baku"},
    {"Baltimore", 39, 17, 76, 36, "America/New_York"},
    {"Bangkok", 13, 45, -100, -30, "Asia/Bangkok"},
    {"Barcelona", 41, 23, -2, -10, "Europe/Madrid"},
    {"Basel", 47, 34, -7, -35, "Europe/Zurich"},
    {"Bat Yam", 32, 1, -34, -45, "Asia/Jerusalem"},
    {"Baton Rouge", 30, 27, 91, 11, "America/Chicago"},
    {"Be'er Sheva", 31, 15, -34, -47, "Asia/Jerusalem"},
    {"Beer Sheva", 31, 15, -34, -47, "Asia/Jerusalem"},
    {"Beersheba", 31, 15, -34, -47, "Asia/Jerusalem"},
    {"Beijing", 39, 54, -116, -24, "Asia/Shanghai"},
    {"Beit She'an", 32, 30, -35, -30, "Asia/Jerusalem"},
    {"Berlin", 52, 31, -13, -24, "Europe/Berlin"},
    {"Birmingham AL", 33, 31, 86, 48, "America/Chicago"},
    {"Birmingham", 52, 29, 1, 54, "Europe/London"},
    {"Birobidzhan", 48, 48, -132, -56, "Asia/Vladivostok"},
    {"Bnei Brak", 32, 5, -34, -50, "Asia/Jerusalem"},
    {"Bogota", 4, 36, 74, 5, "America/Bogota"},
    {"Boise", 43, 37, 116, 12, "America/Boise"},
    {"Bolzano", 46, 30, -11, -21, "Europe/Rome"},
    {"Boston", 42, 20, 71, 4, "America/New_York"},
    {"Bozen", 46, 30, -11, -21, "Europe/Rome"},
    {"Brisbane", -27, -28, -153, -2, "Australia/Brisbane"},
    {"Brussels", 50, 51, -4, -21, "Europe/Brussels"},
    {"Bucharest", 44, 26, -26, -6, "Europe/Bucharest"},
    {"Budapest", 47, 30, -19, -3, "Europe/Budapest"},
    {"Buenos Aires", -34, -37, 58, 24, "America/Argentina/Buenos_Aires"},
    {"Buffalo", 42, 53, 78, 52, "America/New_York"},
    {"Burlington", 44, 29, 73, 13, "America/New_York"},
    {"Cairo", 30, 2, -31, -14, "Africa/Cairo"},
    {"Calabria", 38, 55, -16, -36, "Europe/Rome"},
    {"Calgary", 51, 3, 114, 5, "America/Edmonton"},
    {"Cape Town", -33, -56, -18, -25, "Africa/Johannesburg"},
    {"Caracas", 10, 29, 66, 53, "America/Caracas"},
    {"Casablanca", 33, 32, 7, 35, "Africa/Casablanca"},
    {"Chandler", 33, 18, 111, 50, "America/Phoenix"},
    {"Chapel Hill", 35, 55, 79, 3, "America/New_York"},
    {"Charlotte", 35, 14, 80, 51, "America/New_York"},
    {"Chicago", 41, 50, 87, 45, "America/Chicago"},
    {"Chisinau", 47, 1, -28, -50, "Europe/Chisinau"},
    {"Chongqing", 29, 34, -106, -33, "Asia/Chongqing"},
    {"Chula Vista", 32, 38, 117, 3, "America/Los_Angeles"},
    {"Cincinnati", 39, 6, 84, 31, "America/New_York"},
    {"Cleveland", 41, 30, 81, 41, "America/New_York"},
    {"Cologne", 50, 56, -6, -48, "Europe/Berlin"},
    {"Colorado Springs", 38, 50, 104, 50, "America/Denver"},
    {"Columbus", 39, 58, 83, 0, "America/New_York"},
    {"Copenhagen", 55, 41, -12, -34, "Europe/Copenhagen"},
    {"Cordoba", -31, -25, 64, 11, "America/Argentina/Cordoba"},
    {"Corpus Christi", 27, 45, 97, 24, "America/Chicago"},
    {"Dallas", 32, 47, 96, 48, "America/Chicago"},
    {"Delhi", 28, 37, -77, -14, "Asia/Kolkata"},
    {"Denver", 39, 44, 104, 59, "America/Denver"},
    {"Des Moines", 41, 35, 93, 37, "America/Chicago"},
    {"Detroit", 42, 20, 83, 3, "America/New_York"},
    {"Dhaka", 23, 46, -90, -23, "Asia/Dhaka"},
    {"Dimona", 31, 4, -35, -2, "Asia/Jerusalem"},
    {"Dnipro", 48, 27, -35, -2, "Europe/Kiev"},
    {"Dollard-des-Ormeaux", 45, 30, 73, 49, "America/Toronto"},
    {"Dortmund", 51, 31, -7, -28, "Europe/Berlin"},
    {"Dresden", 51, 3, -13, -44, "Europe/Berlin"},
    {"Dubai", 25, 16, -55, -19, "Asia/Dubai"},
    {"Dublin", 53, 21, 6, 16, "Europe/Dublin"},
    {"Dundee", 56, 28, 2, 58, "Europe/London"},
    {"Durban", -29, -51, -31, -2, "Africa/Johannesburg"},
    {"Durham", 35, 59, 78, 54, "America/New_York"},
    {"Dusseldorf", 51, 14, -6, -47, "Europe/Berlin"},
    {"Edmonton", 53, 33, 113, 28, "America/Edmonton"},
    {"Eilat", 29, 33, -34, -57, "Asia/Jerusalem"},
    {"El Paso", 31, 46, 106, 29, "America/Denver"},
    {"Far Rockaway", 40, 36, 73, 45, "America/New_York"},
    {"Fort Wayne", 41, 5, 85, 8, "America/Indiana/Indianapolis"},
    {"Fort Worth", 32, 45, 97, 20, "America/Chicago"},
    {"Frankfurt", 50, 7, -8, -41, "Europe/Berlin"},
    {"Fremont", 37, 33, 121, 59, "America/Los_Angeles"},
    {"Fresno", 36, 45, 119, 46, "America/Los_Angeles"},
    {"Gibraltar", 36, 8, 5, 21, "Europe/Gibraltar"},
    {"Glasgow", 55, 52, 4, 15, "Europe/London"},
    {"Gomel", 52, 27, -30, -59, "Europe/Minsk"},
    {"Great Neck", 40, 48, 73, 44, "America/New_York"},
    {"Greenlawn", 40, 51, 73, 22, "America/New_York"},
    {"Greensboro", 36, 5, 79, 49, "America/New_York"},
    {"Grenoble", 45, 10, -5, -43, "Europe/Paris"},
    {"Guadalajara", 20, 41, 103, 21, "America/Mexico_City"},
    {"Guangzhou", 23, 8, -113, -16, "Asia/Shanghai"},
    {"Gyrmyzy Gasaba", 41, 22, -48, -31, "Asia/Baku"},
    {"Haifa", 32, 49, -34, -59, "Asia/Jerusalem"},
    {"Halifax", 44, 52, 63, 43, "America/Halifax"},
    {"Hamburg", 53, 55, -9, -59, "Europe/Berlin"},
    {"Hamilton", 43, 15, 79, 52, "America/Toronto"},
    {"Hartford", 41, 46, 72, 41, "America/New_York"},
    {"Hawaii", 19, 30, 155, 30, "Pacific/Honolulu"},
    {"Hebron", 31, 32, -35, -6, "Asia/Jerusalem"},
    {"Helsinki", 60, 10, 24, 55, "Europe/Helsinki"},
    {"Henderson", 36, 2, 115, 2, "America/Los_Angeles"},
    {"Herzliya", 32, 10, -34, -51, "Asia/Jerusalem"},
    {"Hong Kong", 22, 17, -114, -9, "Asia/Hong_Kong"},
    {"Honolulu", 21, 18, 157, 52, "Pacific/Honolulu"},
    {"Houston", 29, 46, 95, 22, "America/Chicago"},
    {"Indianapolis", 39, 46, 86, 9, "America/Indiana/Indianapolis"},
    {"Irkutsk", 52, 17, -104, -17, "Asia/Irkutsk"},
    {"Irvine", 33, 40, 117, 49, "America/Los_Angeles"},
    {"Irving", 32, 49, 96, 57, "America/Chicago"},
    {"Istanbul", 41, 1, -28, -57, "Europe/Istanbul"},
    {"Izmir", 38, 25, -27, -8, "Europe/Istanbul"},
    {"Jacksonville", 30, 20, 81, 39, "America/New_York"},
    {"Jersey City", 40, 43, 74, 4, "America/New_York"},
    {"Jerusalem", 31, 47, -35, -14, "Asia/Jerusalem"},
    {"Johannesburg", -26, -10, -28, -2, "Africa/Johannesburg"},
    {"Kaifeng", 34, 48, -114, -19, "Asia/Shanghai"},
    {"Kaliningrad", 54, 42, -20, -27, "Europe/Kaliningrad"},
    {"Kansas City", 38, 57, 94, 37, "America/Chicago"},
    {"Karachi", 24, 52, -67, -1, "Asia/Karachi"},
    {"Karmiel", 32, 55, -35, -18, "Asia/Jerusalem"},
    {"Kathmandu", 27, 43, -85, -19, "Asia/Kathmandu"},
    {"Kazan", 55, 48, -49, -7, "Europe/Moscow"},
    {"Kent", 51, 12, 0, -42, "Europe/London"},
    {"Kharkiv", 50, 0, -36, -14, "Europe/Kiev"},
    {"Kiev", 50, 28, -30, -29, "Europe/Kiev"},
    {"Kiryas Joel", 41, 21, 74, 10, "America/New_York"},
    {"Kiryat Arba", 31, 32, -35, -7, "Asia/Jerusalem"},
    {"Kiryat Ata", 32, 48, -35, -6, "Asia/Jerusalem"},
    {"Kiryat Gat", 31, 36, -34, -46, "Asia/Jerusalem"},
    {"Kiryat Shmona", 33, 12, -35, -34, "Asia/Jerusalem"},
    {"Kiryat Yam", 32, 50, -35, -4, "Asia/Jerusalem"},
    {"Kishinev", 47, 1, -28, -50, "Europe/Chisinau"},
    {"Kyiv", 50, 28, -30, -29, "Europe/Kiev"},
    {"Kyoto", 35, 1, -135, -46, "Asia/Tokyo"},
    {"La Paz", -16, -30, 68, 9, "America/La_Paz"},
    {"Lagos", 6, 27, -3, -23, "Africa/Lagos"},
    {"Lakewood",  40, 6, 74, 13, "America/New_York"},
    {"Las Vegas", 36, 10, 115, 8, "America/Los_Angeles"},
    {"Leeds", 53, 48, 1, 33, "Europe/London"},
    {"Leipzig", 51, 20, -12, -22, "Europe/Berlin"},
    {"Lexington", 38, 2, 84, 30, "America/New_York"},
    {"Lima", -12, -3, 77, 2, "America/Lima"},
    {"Lincoln", 40, 49, 96, 41, "America/Chicago"},
    {"Livingston", 40, 47, 74, 20, "America/New_York"},
    {"Llandudno", 53, 20, 3, 50, "Europe/London"},
    {"Lod", 31, 57, -34, -53, "Asia/Jerusalem"},
    {"London ON", 42, 58, 81, 14, "America/Toronto"},
    {"London", 51, 30, 0, 10, "Europe/London"},
    {"Long Beach", 33, 46, 118, 12, "America/Los_Angeles"},
    {"Los Angeles", 34, 4, 118, 15, "America/Los_Angeles"},
    {"Louisville", 38, 15, 85, 46, "America/New_York"},
    {"Lyon", 45, 45, -4, -51, "Europe/Paris"},
    {"Madison", 43, 4, 89, 24, "America/Chicago"},
    {"Madrid", 40, 25, 3, 42, "Europe/Madrid"},
    {"Manchester", 53, 29, 2, 14, "Europe/London"},
    {"Manila", 14, 36, -120, -59, "Asia/Manila"},
    {"Marseille", 43, 18, -5, -23, "Europe/Paris"},
    {"Marseilles", 43, 18, -5, -23, "Europe/Paris"},
    {"Medzhybizh", 49, 26, -27, -25, "Europe/Kiev"},
    {"Melbourne", -37, -52, -145, -8, "Australia/Melbourne"},
    {"Memphis", 35, 9, 90, 3, "America/Chicago"},
    {"Mercer Island", 47, 34, 122, 13, "America/Los_Angeles"},
    {"Mesa", 33, 25, 111, 49, "America/Phoenix"},
    {"Mexico City", 19, 24, 99, 9, "America/Mexico_City"},
    {"Miami", 25, 46, 80, 12, "America/New_York"},
    {"Milan", 45, 28, -9, -11, "Europe/Rome"},
    {"Milwaukee", 43, 2, 87, 54, "America/Chicago"},
    {"Minneapolis", 44, 58, 93, 15, "America/Chicago"},
    {"Minsk", 53, 54, -27, -34, "Europe/Minsk"},
    {"Mississauga", 43, 36, 79, 39, "America/Toronto"},
    {"Mitzpe Ramon", 30, 36, -34, -48, "Asia/Jerusalem"},
    {"Mogilev", 53, 55, -30, -21, "Europe/Minsk"},
    {"Montevideo", -34, -54, 56, 11, "America/Montevideo"},
    {"Montreal", 45, 30, 73, 36, "America/Montreal"},
    {"Moscow", 55, 45, -37, -42, "Europe/Moscow"},
    {"Mumbai", 19, 4, -72, -53, "Asia/Kolkata"},
    {"Munich", 48, 8, -11, -34, "Europe/Berlin"},
    {"Nahariya", 33, 0, -35, -6, "Asia/Jerusalem"},
    {"Nashville", 36, 10, 86, 47, "America/Chicago"},
    {"Netanya", 32, 20, -34, -52, "Asia/Jerusalem"},
    {"New Haven", 41, 18, 72, 56, "America/New_York"},
    {"New Orleans", 29, 57, 90, 5, "America/Chicago"},
    {"New York", 40, 43, 74, 0, "America/New_York"},
    {"Newark", 40, 43, 74, 10, "America/New_York"},
    {"Newton", 42, 20, 71, 13, "America/New_York"},
    {"Nice", 43, 42, -7, -16, "Europe/Paris"},
    {"Nof HaGalil", 32, 43, -35, -20, "Asia/Jerusalem"},
    {"Norfolk", 36, 55, 76, 12, "America/New_York"},
    {"Oakland", 37, 48, 122, 16, "America/Los_Angeles"},
    {"Odessa", 46, 29, -30, -45, "Europe/Kiev"},
    {"Oghuz", 41, 4, -47, -28, "Asia/Baku"},
    {"Oklahoma City", 35, 28, 97, 31, "America/Chicago"},
    {"Omaha", 41, 16, 95, 56, "America/Chicago"},
    {"Orlando", 28, 32, 81, 23, "America/New_York"},
    {"Osaka", 34, 42, -135, -30, "Asia/Tokyo"},
    {"Ottawa", 45, 42, 75, 71, "America/Toronto"},
    {"Paharganj", 28, 39, -77, -13, "Asia/Kolkata"},
    {"Panama City", 8, 58, 79, 32, "America/Panama"},
    {"Paris", 48, 52, -2, -20, "Europe/Paris"},
    {"Passaic", 40, 51, 74, 8, "America/New_York"},
    {"Pawtucket",  41, 52, 71, 23, "America/New_York"},
    {"Perth", -31, -57, -115, -52, "Australia/Perth"},
    {"Petach Tikvah", 32, 5, -34, -53, "Asia/Jerusalem"},
    {"Philadelphia", 39, 57, 75, 10, "America/New_York"},
    {"Phoenix", 33, 27, 112, 4, "America/Phoenix"},
    {"Pittsburgh", 40, 26, 80, 0, "America/New_York"},
    {"Plano", 33, 1, 96, 42, "America/Chicago"},
    {"Portland", 45, 31, 122, 41, "America/Los_Angeles"},
    {"Porto Alegre", -30, -2, 51, 14, "America/Sao_Paulo"},
    {"Poway", 32, 58, 117, 2, "America/Los_Angeles"},
    {"Prague", 50, 5, -14, -25, "Europe/Prague"},
    {"Princeton", 40, 21, 74, 40, "America/New_York"},
    {"Providence",  41, 50, 71, 23, "America/New_York"},
    {"Raleigh", 35, 46, 78, 38, "America/New_York"},
    {"Ramat Gan", 32, 5, -34, -49, "Asia/Jerusalem"},
    {"Ramla", 31, 56, -34, -52, "Asia/Jerusalem"},
    {"Regina", 50, 27, 104, 36, "America/Regina"},
    {"Rehovot", 31, 54, -34, -48, "Asia/Jerusalem"},
    {"Reno", 39, 32, 119, 49, "America/Los_Angeles"},
    {"Richmond BC", 49, 10, 123, 8, "America/Vancouver"},
    {"Richmond Hill", 43, 52, 79, 26, "America/Toronto"},
    {"Richmond", 37, 33, 77, 28, "America/New_York"},
    {"Riga", 56, 57, -24, -6, "Europe/Riga"},
    {"Rio de Janeiro", -22, -54, 43, 12, "America/Sao_Paulo"},
    {"Rishon LeZion", 31, 58, -34, -47, "Asia/Jerusalem"},
    {"Riverside", 33, 57, 117, 24, "America/Los_Angeles"},
    {"Rochester", 43, 9, 77, 37, "America/New_York"},
    {"Rome", 41, 54, -12, -31, "Europe/Rome"},
    {"Rosario", -32, -57, 60, 38, "America/Argentina/Cordoba"},
    {"Rostov-on-Don", 47, 14, -39, -42, "Europe/Moscow"},
    {"Rotterdam", 51, 55, -4, -30, "Europe/Amsterdam"},
    {"Sacramento", 38, 35, 121, 30, "America/Los_Angeles"},
    {"Safed", 32, 58, -35, -30, "Asia/Jerusalem"},
    {"Saint Louis", 38, 38, 90, 12, "America/Chicago"},
    {"Saint Paul", 44, 57, 93, 6, "America/Chicago"},
    {"Saint Petersburg FL", 27, 46, 82, 38, "America/New_York"},
    {"Saint Petersburg", 59, 53, -30, -15, "Europe/Moscow"},
    {"Salzburg", 47, 49, -13, -4, "Europe/Vienna"},
    {"San Antonio", 29, 25, 98, 30, "America/Chicago"},
    {"San Diego", 32, 43, 117, 9, "America/Los_Angeles"},
    {"San Francisco", 37, 47, 122, 25, "America/Los_Angeles"},
    {"San Jose", 37, 20, 121, 53, "America/Los_Angeles"},
    {"San Juan", 18, 24, 66, 4, "America/Puerto_Rico"},
    {"San Salvador", 13, 42, 89, 11, "America/El_Salvador"},
    {"Santa Ana", 33, 44, 117, 53, "America/Los_Angeles"},
    {"Santiago", -33, -27, 70, 40, "America/Santiago"},
    {"Sao Paulo", -23, -33, 46, 39, "America/Sao_Paulo"},
    {"Saskatoon", 52, 8, 106, 41, "America/Regina"},
    {"Scottsdale", 33, 30, 111, 56, "America/Phoenix"},
    {"Sderot", 31, 31, -34, -36, "Asia/Jerusalem"},
    {"Seattle", 47, 36, 122, 20, "America/Los_Angeles"},
    {"Shanghai", 31, 13, -121, -27, "Asia/Shanghai"},
    {"Shechem", 32, 13, -35, -16, "Asia/Jerusalem"},
    {"Shenzhen", 22, 32, -114, -4, "Asia/Shanghai"},
    {"Singapore", 1, 17, -103, -51, "Asia/Singapore"},
    {"Spokane", 47, 40, 117, 26, "America/Los_Angeles"},
    {"Stanford", 37, 25, 122, 10, "America/Los_Angeles"},
    {"Stockholm", 59, 20, -18, -4, "Europe/Stockholm"},
    {"Stockton", 37, 59, 121, 18, "America/Los_Angeles"},
    {"Strasbourg", 48, 35, -7, -45, "Europe/Paris"},
    {"Stuttgart", 48, 47, -9, -11, "Europe/Berlin"},
    {"Sudbury", 42, 23, 71, 25, "America/New_York"},
    {"Sydney", -33, -52, -151, -13, "Australia/Sydney"},
    {"Tacoma", 47, 14, 122, 28, "America/Los_Angeles"},
    {"Tampa", 27, 57, 82, 28, "America/New_York"},
    {"Tashkent", 41, 18, -69, -16, "Asia/Tashkent"},
    {"Teaneck", 40, 54, 74, 1, "America/New_York"},
    {"Tehran", 35, 42, -51, -25, "Asia/Tehran"},
    {"Tel Aviv", 32, 5, -34, -46, "Asia/Jerusalem"},
    {"The Hague", 52, 5, -4, -19, "Europe/Amsterdam"},
    {"Tianjin", 39, 8, -117, -12, "Asia/Shanghai"},
    {"Tiberias", 32, 48, -35, -32, "Asia/Jerusalem"},
    {"Tijuana", 32, 32, 117, 2, "America/Tijuana"},
    {"Tokyo", 35, 41, -139, -42, "Asia/Tokyo"},
    {"Toledo", 41, 40, 83, 35, "America/New_York"},
    {"Toronto", 43, 38, 79, 24, "America/Toronto"},
    {"Toulouse", 43, 36, -1, -27, "Europe/Paris"},
    {"Tsfat", 32, 58, -35, -30, "Asia/Jerusalem"},
    {"Tucson", 32, 13, 110, 56, "America/Phoenix"},
    {"Tulsa", 36, 8, 95, 56, "America/Chicago"},
    {"Tunis", 36, 48, -10, -11, "Africa/Tunis"},
    {"Tzfat", 32, 58, -35, -30, "Asia/Jerusalem"},
    {"Uman", 48, 45, -30, -13, "Europe/Kiev"},
    {"Valparaiso", -33, -3, 71, 37, "America/Santiago"},
    {"Vancouver", 49, 16, 123, 7, "America/Vancouver"},
    {"Vaughan", 43, 50, 79, 30, "America/Toronto"},
    {"Venice", 45, 26, -12, -20, "Europe/Rome"},
    {"Vienna", 48, 12, -16, -22, "Europe/Vienna"},
    {"Virginia Beach", 36, 51, 75, 59, "America/New_York"},
    {"Volgograd", 48, 43, -44, -31, "Europe/Volgograd"},
    {"Warsaw", 52, 14, -21, -1, "Europe/Warsaw"},
    {"Washington DC", 38, 55, 77, 0, "America/New_York"},
    {"Wellington", -41, -17, -174, -47, "Pacific/Auckland"},
    {"White Plains",  41, 2, 73, 45, "America/New_York"},
    {"Wichita", 37, 41, 97, 20, "America/Chicago"},
    {"Willemstad", 12, 7, 68, 56, "America/Curacao"},
    {"Windsor", 42, 17, 83, 0, "America/Toronto"},
    {"Winnipeg", 49, 53, 97, 9, "America/Winnipeg"},
    {"Winston Salem", 36, 7, 80, 16, "America/New_York"},
    {"Woodmere", 40, 38, 73, 43, "America/New_York"},
    {"Worcester",  42, 16, 71, 52, "America/New_York"},
    {"Zurich", 47, 22, -8, -33, "Europe/Zurich"},
    {0, 0, 0, 0, 0, 0}
};
