package css

import "github.com/tdewolff/parse/css"

var requiredDimension = map[string]bool{
	"s":    true,
	"ms":   true,
	"dpi":  true,
	"dpcm": true,
	"dppx": true,
	"hz":   true,
	"khz":  true,
}

// Uses http://www.w3.org/TR/2010/PR-css3-color-20101028/ for colors

// ShortenColorHex maps a color hexcode to its shorter name
var ShortenColorHex = map[string][]byte{
	"#000080": []byte("navy"),
	"#008000": []byte("green"),
	"#008080": []byte("teal"),
	"#4b0082": []byte("indigo"),
	"#800000": []byte("maroon"),
	"#800080": []byte("purple"),
	"#808000": []byte("olive"),
	"#808080": []byte("gray"),
	"#a0522d": []byte("sienna"),
	"#a52a2a": []byte("brown"),
	"#c0c0c0": []byte("silver"),
	"#cd853f": []byte("peru"),
	"#d2b48c": []byte("tan"),
	"#da70d6": []byte("orchid"),
	"#dda0dd": []byte("plum"),
	"#ee82ee": []byte("violet"),
	"#f0e68c": []byte("khaki"),
	"#f0ffff": []byte("azure"),
	"#f5deb3": []byte("wheat"),
	"#f5f5dc": []byte("beige"),
	"#fa8072": []byte("salmon"),
	"#faf0e6": []byte("linen"),
	"#ff6347": []byte("tomato"),
	"#ff7f50": []byte("coral"),
	"#ffa500": []byte("orange"),
	"#ffc0cb": []byte("pink"),
	"#ffd700": []byte("gold"),
	"#ffe4c4": []byte("bisque"),
	"#fffafa": []byte("snow"),
	"#fffff0": []byte("ivory"),
	"#ff0000": []byte("red"),
	"#f00":    []byte("red"),
}

// ShortenColorName maps a color name to its shorter hexcode
var ShortenColorName = map[css.Hash][]byte{
	css.Black:                []byte("#000"),
	css.Darkblue:             []byte("#00008b"),
	css.Mediumblue:           []byte("#0000cd"),
	css.Darkgreen:            []byte("#006400"),
	css.Darkcyan:             []byte("#008b8b"),
	css.Deepskyblue:          []byte("#00bfff"),
	css.Darkturquoise:        []byte("#00ced1"),
	css.Mediumspringgreen:    []byte("#00fa9a"),
	css.Springgreen:          []byte("#00ff7f"),
	css.Midnightblue:         []byte("#191970"),
	css.Dodgerblue:           []byte("#1e90ff"),
	css.Lightseagreen:        []byte("#20b2aa"),
	css.Forestgreen:          []byte("#228b22"),
	css.Seagreen:             []byte("#2e8b57"),
	css.Darkslategray:        []byte("#2f4f4f"),
	css.Limegreen:            []byte("#32cd32"),
	css.Mediumseagreen:       []byte("#3cb371"),
	css.Turquoise:            []byte("#40e0d0"),
	css.Royalblue:            []byte("#4169e1"),
	css.Steelblue:            []byte("#4682b4"),
	css.Darkslateblue:        []byte("#483d8b"),
	css.Mediumturquoise:      []byte("#48d1cc"),
	css.Darkolivegreen:       []byte("#556b2f"),
	css.Cadetblue:            []byte("#5f9ea0"),
	css.Cornflowerblue:       []byte("#6495ed"),
	css.Mediumaquamarine:     []byte("#66cdaa"),
	css.Slateblue:            []byte("#6a5acd"),
	css.Olivedrab:            []byte("#6b8e23"),
	css.Slategray:            []byte("#708090"),
	css.Lightslateblue:       []byte("#789"),
	css.Mediumslateblue:      []byte("#7b68ee"),
	css.Lawngreen:            []byte("#7cfc00"),
	css.Chartreuse:           []byte("#7fff00"),
	css.Aquamarine:           []byte("#7fffd4"),
	css.Lightskyblue:         []byte("#87cefa"),
	css.Blueviolet:           []byte("#8a2be2"),
	css.Darkmagenta:          []byte("#8b008b"),
	css.Saddlebrown:          []byte("#8b4513"),
	css.Darkseagreen:         []byte("#8fbc8f"),
	css.Lightgreen:           []byte("#90ee90"),
	css.Mediumpurple:         []byte("#9370db"),
	css.Darkviolet:           []byte("#9400d3"),
	css.Palegreen:            []byte("#98fb98"),
	css.Darkorchid:           []byte("#9932cc"),
	css.Yellowgreen:          []byte("#9acd32"),
	css.Darkgray:             []byte("#a9a9a9"),
	css.Lightblue:            []byte("#add8e6"),
	css.Greenyellow:          []byte("#adff2f"),
	css.Paleturquoise:        []byte("#afeeee"),
	css.Lightsteelblue:       []byte("#b0c4de"),
	css.Powderblue:           []byte("#b0e0e6"),
	css.Firebrick:            []byte("#b22222"),
	css.Darkgoldenrod:        []byte("#b8860b"),
	css.Mediumorchid:         []byte("#ba55d3"),
	css.Rosybrown:            []byte("#bc8f8f"),
	css.Darkkhaki:            []byte("#bdb76b"),
	css.Mediumvioletred:      []byte("#c71585"),
	css.Indianred:            []byte("#cd5c5c"),
	css.Chocolate:            []byte("#d2691e"),
	css.Lightgray:            []byte("#d3d3d3"),
	css.Goldenrod:            []byte("#daa520"),
	css.Palevioletred:        []byte("#db7093"),
	css.Gainsboro:            []byte("#dcdcdc"),
	css.Burlywood:            []byte("#deb887"),
	css.Lightcyan:            []byte("#e0ffff"),
	css.Lavender:             []byte("#e6e6fa"),
	css.Darksalmon:           []byte("#e9967a"),
	css.Palegoldenrod:        []byte("#eee8aa"),
	css.Lightcoral:           []byte("#f08080"),
	css.Aliceblue:            []byte("#f0f8ff"),
	css.Honeydew:             []byte("#f0fff0"),
	css.Sandybrown:           []byte("#f4a460"),
	css.Whitesmoke:           []byte("#f5f5f5"),
	css.Mintcream:            []byte("#f5fffa"),
	css.Ghostwhite:           []byte("#f8f8ff"),
	css.Antiquewhite:         []byte("#faebd7"),
	css.Lightgoldenrodyellow: []byte("#fafad2"),
	css.Fuchsia:              []byte("#f0f"),
	css.Magenta:              []byte("#f0f"),
	css.Deeppink:             []byte("#ff1493"),
	css.Orangered:            []byte("#ff4500"),
	css.Darkorange:           []byte("#ff8c00"),
	css.Lightsalmon:          []byte("#ffa07a"),
	css.Lightpink:            []byte("#ffb6c1"),
	css.Peachpuff:            []byte("#ffdab9"),
	css.Navajowhite:          []byte("#ffdead"),
	css.Moccasin:             []byte("#ffe4b5"),
	css.Mistyrose:            []byte("#ffe4e1"),
	css.Blanchedalmond:       []byte("#ffebcd"),
	css.Papayawhip:           []byte("#ffefd5"),
	css.Lavenderblush:        []byte("#fff0f5"),
	css.Seashell:             []byte("#fff5ee"),
	css.Cornsilk:             []byte("#fff8dc"),
	css.Lemonchiffon:         []byte("#fffacd"),
	css.Floralwhite:          []byte("#fffaf0"),
	css.Yellow:               []byte("#ff0"),
	css.Lightyellow:          []byte("#ffffe0"),
	css.White:                []byte("#fff"),
}
