.TH "sane\-genesys" "5" "4 Jul 2012" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-genesys
.SH "NAME"
sane\-genesys \- SANE backend for GL646, GL841, GL843, GL847 and GL124 based USB flatbed scanners
.SH "DESCRIPTION"
The
.B sane\-genesys
library implements a SANE (Scanner Access Now Easy) backend that provides
access to USB flatbed scanners based on the Genesys GL646, GL841, GL843, GL847 and GL124 chips.
At present, the following scanners are known to work with this backend:
.PP 
.RS
Canon LiDE 35/40/50/60/100/110/200/210/700
.br
Hewlett-Packard HP2300C/HP2400/HP3670/HP3690/G4010/G4050
.br
Medion MD5345/MD6228/MD6274
.br 
Panasonic KV-SS080
.br
Plustek OpticBook 3600
.br
Pentax DSmobile 600
.br
Syscan/Ambir DocketPORT 467/485/487/665/685
.br
Visioneer OneTouch 7100/Strobe XP100 (rev3)/XP200/XP300/Roadwarrior
.br
Xerox Travel Scanner 100, OneTouch 2400
.RE

.PP 
This is stable software for supported models. But if you test new or untested scanners, keep
your hand at the scanner's plug and unplug it, if the head bumps at the end of
the scan area.
.PP 
If you own a scanner other than the ones listed above that works with this
backend, please let me know this by sending the scanner's exact model name and
the USB vendor and device ids (e.g. from
.IR /proc/bus/usb/devices ,
.I sane\-find\-scanner
or syslog) to the sane\-devel mailing list. Even if the scanner's name is only
slightly different from the models mentioned above, please let me know.
.PP 
If you own a scanner that isn't detected by the genesys backend but has a GL646,
GL841, GL843, GL847 or GL124 chipset, you can try to add it to the backend. 
.PP 
.SH "CALIBRATION"
To give correct image quality, sheet fed scanners need to be calibrated using the
calibration sheet sold with the scanner. To do calibration, you must insert this target
in the feeder then start calibration either by passing the --calibrate option to scanimage
or by clicking on the available 'calibrate' button in the 'advanced options' in a graphical
frontend. The result of the calibration is stored in a file in the home directory of the user doing it.
If you plug the scanner in another machine or use it with another account, calibration
will have to be redone.

.SH EXTRAS SCAN OPTIONS

.B \-\-lamp\-off\-time number
.RS
        The lamp will be turned off after the given time (in minutes). A value of 0 means that the lamp won't be turned off.
.RE

.B \-\-threshold  percent
.RS
	0..100% (in steps of 1). Select minimum brightness to get a white point. Pixels
whith brightness below that value will be scanned as black.
.RE

.B \-\-disable-interpolation yes|no
.RS
        When using high resolutions where the horizontal resolution is smaller than vertical resolution,
data is expanded by software to preserve picture geometry. This can be disabled by this option to get
real scanned data.
.RE

.B \-\-disable-dynamic-lineart yes|no
.RS
        Disable use of a software adaptive algorithm to generate lineart and rely on hardware lineart.
.RE

.B \-\-color-filter None|Red|Green|Blue
.RS
        When using gray or lineart this option selects the used color. Using a color filter
will give a monochrome scan. CIS based scanners can to true gray when no filter (None value) is
selected.
.RE

.B \-\-lamp\-off\-scan
.RS
        The lamp will be turned off during the scan. Calibration is still done with lamp on.
.RE

.PP
Additionally, several 'software' options are exposed by the backend. These
are reimplementations of features provided natively by larger scanners, but
running on the host computer. This enables smaller machines to have similar
capabilities. Please note that these features are somewhat simplistic, and 
may not perform as well as the native implementations. Note also that these 
features all require that the driver cache the entire image in memory. This 
will almost certainly result in a reduction of scanning speed.
.PP
.B \-\-swcrop 
.RS
	Requests the driver to detect the extremities of the paper within the larger 
image, and crop the empty edges. 
.RE
.PP
.B \-\-swdeskew 
.RS
	Requests the driver to detect the rotation of the paper within the larger 
image, and counter the rotation.
.RE
.PP
.B \-\-swdespeck  \-\-despeck X
.RS
	Requests the driver to find and remove dots of X diameter or smaller from the 
image, and fill the space with the average surrounding color.
.RE
.PP
.B \-\-swskip 0..100% (in steps of 1) [0]
.RS
        Request driver to discard pages with low numbers of dark pixels.
.RE
.PP
.B \-\-swderotate[=(yes|no)] [no]
.RS
        Request driver to detect and correct 90 degree image rotation.

.PP
.SH "SYSTEM ISSUES"
This backend needs libusb-0.1.6 or later installed, and hasn't tested in other
configuration than a linux kernel 2.6.9 or higher. However, it should work any
system with libusb where the SANE package can be compiled. For
setting permissions and general USB information look at
.BR sane\-usb (5).


.SH "CONFIGURATION"
The contents of the
.I genesys.conf
file is a list of usb lines containing vendor and product ids that correspond
to USB scanners. The file can also contain option lines.  Empty lines and
lines starting with a hash mark (#) are ignored.  The scanners are
autodetected by
.B usb vendor_id product_id
statements which are already included into
.IR genesys.conf .
"vendor_id" and "product_id" are hexadecimal numbers that identify the
scanner. 
.PP 

.SH "FILES"
.TP 
.I @CONFIGDIR@/genesys.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP 
.I @LIBDIR@/libsane\-genesys.a
The static library implementing this backend.
.TP 
.I @LIBDIR@/libsane\-genesys.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH "ENVIRONMENT"
.TP 
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP 
.B SANE_DEBUG_GENESYS
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend.  Higher debug levels
increase the verbosity of the output. If the debug level is set to 1 or higher,
some debug options become available that are normally hidden. Handle them with
care. This will print messages related to core genesys functions.
.TP
.B SANE_DEBUG_GENESYS_LOW
This environment variable controls the debug level for low level functions
common to all genesys ASICs.
.TP 
.B SANE_DEBUG_GENESYS_GL646
This environment variable controls the debug level for the specific GL646 code
part.
.TP 
.B SANE_DEBUG_GENESYS_GL841
This environment variable controls the debug level for the specific GL841 code
part.
.TP 
.B SANE_DEBUG_GENESYS_GL843
This environment variable controls the debug level for the specific GL843 code
part.
.TP 
.B SANE_DEBUG_GENESYS_GL847
This environment variable controls the debug level for the specific GL847 code
part.
.TP 
.B SANE_DEBUG_GENESYS_GL124
This environment variable controls the debug level for the specific GL124 code
part.


Example (full and highly verbose output for gl646): 
.br
export SANE_DEBUG_GENESYS=255
.br
export SANE_DEBUG_GENESYS_LOW=255
.br
export SANE_DEBUG_GENESYS_GL646=255

.SH CREDITS
  
Jack McGill for donating several sheetfed and flatbed scanners, which made possible to add support
for them in the genesys backend:
.RS
Hewlett-Packard HP3670
.br 
Visioneer Strobe XP100 (rev3)/XP200/XP300/Roadwarrior
.br
Canon LiDE 200
.br
Pentax DSmobile 600
.br
Syscan/Ambir DocketPORT 467/485/487/665/685
.br
Xerox Travel Scanner 100, Onetouch 2400
.RE
.TP
cncsolutions (http://www.cncsolutions.com.br) sponsored and supported the work on the Panasonic KV-SS080.
.br
.TP
Brian Paavo from Benthic Science Limited for donating a Canoscan LiDE 700F.
.br

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-usb (5)
.br 


.SH "AUTHOR"
Oliver Rauch
.br 
Henning Meier-Geinitz <henning@meier\-geinitz.de>
.br 
Gerhard Jaeger <gerhard@gjaeger.de>
.br 
St\['e]phane Voltz <stef.dev@free.fr>
.br 
Philipp Schmid <philipp8288@web.de>
.br 
Pierre Willenbrock <pierre@pirsoft.dnsalias.org>
.br
Alexey Osipov <simba@lerlan.ru> for HP2400 final support

.SH "LIMITATIONS"

Powersaving isn't implemented for gl646 based scanner. Dynamic (emulated from gray data and with dithering) isn't enabled for gl646 scanners. Hardware lineart is limited up to 600 dpi for gl847 based scanners, due to the way image sensors are built.
.br
.TP
This backend will be much slower if not using libusb-1.0. So be sure that sane-backends is built with the --enable-libusb_1_0 option.
.br

.SH "BUGS"
For the LiDE 200, the scanned data at 4800 dpi is obtained "as is" from sensor. It seems the windows driver does some digital processing
to improve it, which is not implemented in the backend.
.PP 
