# 0.0.21

**Version:** 0.0.21
**Published:** 2023-09-03T16:12:44Z

## Release Notes

📦 Announcing Rust Coreutils version 0.0.21. This release showcases enhanced compatibility with the GNU test suite, particularly following our upgrade to GNU Coreutils 9.4. We've made technical improvements across various utilities, ensuring more robust and efficient operations. As always, we prioritize precision and performance in our updates. Dive into the detailed changelog for a comprehensive overview. 🛠️

We have a fancy new website powered by [`oranda`](https://opensource.axo.dev/oranda/)! Check it out here: https://uutils.github.io.

Supporting our development is as easy as sponsoring us on GitHub! Your contributions can help us afford a more robust Continuous Integration process through GitHub Actions. To sponsor, please visit https://github.com/sponsors/uutils.

## GNU test suite compatibility

The observed changes in the test results for the Rust Coreutils version 0.0.21 are attributed to our upgrade to use [GNU Coreutils 9.4](https://lists.gnu.org/archive/html/info-gnu/2023-08/msg00007.html) as a reference for comparison. This newer version of GNU Coreutils introduced differences that are reflected in our test outcomes. Additionally, we've actively contributed to the GNU Coreutils by reorganizing tests into a more optimal structure, significantly enhancing the results of the GNU test coverage. More details can be found in our [test coverage documentation](https://uutils.github.io/coreutils/book/test_coverage.html).

 Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.20 | 0.0.21 | change |
|--------|-------:|-------:|------:|
| pass   |    373 |    372 |   -1  |
| skip   |     49 |     49 |    0  |
| fail   |    178 |    181 |   +3  |
| error  |      2 |      2 |    0  |
| xpass  |      0 |      0 |    0  |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

## What's Changed
### cat
* cat: remove --t by @cakebaker in https://github.com/uutils/coreutils/pull/5089

### chown
* chown: remove some duplication in tests by @cakebaker in https://github.com/uutils/coreutils/pull/5168

### cp
* `cp`: re-export `uucore::{BackupMode, UpdateMode}` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5211
* `cp`: finish progress bar to make it always show up by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5235
* `cp`: make more types public and add more documentation (for nushell) by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5152

### csplit
* csplit: remove explicit "into_iter()" by @cakebaker in https://github.com/uutils/coreutils/pull/5109

### date
* date: fix panic when input will cause overflow by @tommady in https://github.com/uutils/coreutils/pull/5160

### dd
* parse_size,dd: turn instance fns to associated fns by @cakebaker in https://github.com/uutils/coreutils/pull/5207

### factor
* `factor`: short circuit on write error, but not on parse error by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5225
* factor: simplify loop in test by @cakebaker in https://github.com/uutils/coreutils/pull/5192

### fmt
* fmt: fix panic on width argument by @bluelief in https://github.com/uutils/coreutils/pull/5159
* fmt: implement Default for FmtOptions by @cakebaker in https://github.com/uutils/coreutils/pull/4747

### hashsum
* `hashsum`: change debug to display format with --tag by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5219

### mktemp
* Require = for --tmpdir in mktemp by @tmccombs in https://github.com/uutils/coreutils/pull/4342

### mknod
* mknod: remove unnecessary "not" in test by @cakebaker in https://github.com/uutils/coreutils/pull/5233

### mv
* mv: remove unnecessary OR in condition by @cakebaker in https://github.com/uutils/coreutils/pull/5143

### nl
* nl: allow negative values for --line-increment and --starting-line-number by @cakebaker in https://github.com/uutils/coreutils/pull/5078
* nl: fix calculation of line number lengths by @cakebaker in https://github.com/uutils/coreutils/pull/5091
* nl: fix zero padding of negative line numbers by @cakebaker in https://github.com/uutils/coreutils/pull/5098
* nl: show error if --join-blank-lines is zero by @cakebaker in https://github.com/uutils/coreutils/pull/5103
* nl: shorten variants of NumberingStyle enum by @cakebaker in https://github.com/uutils/coreutils/pull/5100
* nl: fix output of numbering styles by @cakebaker in https://github.com/uutils/coreutils/pull/5131
* nl: re-add handling for -p/--no-renumber by @cakebaker in https://github.com/uutils/coreutils/pull/5155
* nl: implement TryFrom<&str> for NumberingStyle by @cakebaker in https://github.com/uutils/coreutils/pull/5156
* nl: handle line number overflow by @cakebaker in https://github.com/uutils/coreutils/pull/5163

### rm
* rm: refactor prompt_file() by @cakebaker in https://github.com/uutils/coreutils/pull/5147
* Add benchmarking for `rm` by @Benjscho in https://github.com/uutils/coreutils/pull/5187

### seq
* seq: display -0 by @shinhs0506 in https://github.com/uutils/coreutils/pull/5136
* seq: remove unused param from write_value_float() by @cakebaker in https://github.com/uutils/coreutils/pull/5137

### sum
* Use `rotate_right` rather than an explicit expansion in `sum` by @resistor in https://github.com/uutils/coreutils/pull/5115
*
### split
* split: loop over chars and remove char_from_digit function by @shinhs0506 in https://github.com/uutils/coreutils/pull/5153
* split: better handle numeric and hex suffixes, short and long, with and without values by @zhitkoff in https://github.com/uutils/coreutils/pull/5198

### stat
* stat: Output error when - and -f are used together. by @Skryptonyte in https://github.com/uutils/coreutils/pull/5144

### stty
* stty: Implement printing assignment of control chars by @dezgeg in https://github.com/uutils/coreutils/pull/5060

### test
* Fuzz the test command by @sylvestre in https://github.com/uutils/coreutils/pull/4641

### touch
* `touch`: move from `time` to `chrono` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4600


### tsort
* tsort: use Iterator.all by @simon04 in https://github.com/uutils/coreutils/pull/5116

### website & documentation
* docs: fix broken Arch package link by @theoludwig in https://github.com/uutils/coreutils/pull/5084
* website: fix `path_prefix` in oranda by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5175
* docs: add missing "not" by @cakebaker in https://github.com/uutils/coreutils/pull/5178
* Docs platform support page by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5172
* docs: github repo link related to uutils/coreutils by @theoludwig in https://github.com/uutils/coreutils/pull/5085
* website: fix changelog config by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5215
* docs: add conda installer by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5185
* README: update links to docs by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5190
* docs(bin,has): add docstrings for macros bin and has by @nouritsu in https://github.com/uutils/coreutils/pull/5129
* Add the Perl Power Tools impl by @sylvestre in https://github.com/uutils/coreutils/pull/5105

### Build system & CI
* uucore: make deps of "sum" feature optional by @cakebaker in https://github.com/uutils/coreutils/pull/5227
* uucore: make "dunce" optional by @cakebaker in https://github.com/uutils/coreutils/pull/5229
* uucore: turn backup_control into a feature by @cakebaker in https://github.com/uutils/coreutils/pull/5231
* uucore: turn ranges into a feature by @cakebaker in https://github.com/uutils/coreutils/pull/5238
* uucore: turn update_control into a feature by @cakebaker in https://github.com/uutils/coreutils/pull/5232
* upgrade to GNU/coreutils 9.4 by @sylvestre in https://github.com/uutils/coreutils/pull/5221
* make: split the manpage / completions generation into their target by @sylvestre in https://github.com/uutils/coreutils/pull/5092
* make: uninstall man pages by @miles170 in https://github.com/uutils/coreutils/pull/5101
* Improve the coreutils manpage by @sylvestre in https://github.com/uutils/coreutils/pull/5093
* uucore: use "workspace=true" for some dependencies by @cakebaker in https://github.com/uutils/coreutils/pull/5110
* ci: add default_trait_access lint and fix its warnings by @cakebaker in https://github.com/uutils/coreutils/pull/5081
* ci: Add a new workflow to check and format shell scripts in `util` dir by @starccy in https://github.com/uutils/coreutils/pull/5077
* "style(util): fix/format scripts to meet the `shellcheck`/`shfmt` rules" by @starccy in https://github.com/uutils/coreutils/pull/5090
* `Cargo.toml`: add `feat_require_unix_hostid` to `feat_os_unix` by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5179
* only set SELINUX_ENABLED=1 on Linux by @sylvestre in https://github.com/uutils/coreutils/pull/5112
* build-gnu.sh: indent comment by @cakebaker in https://github.com/uutils/coreutils/pull/5118
* 0.0.20 => 0.0.21 by @sylvestre in https://github.com/uutils/coreutils/pull/5237

### Various improvements
* uucore: remove unnecessary heap allocation by @thechampagne in https://github.com/uutils/coreutils/pull/5228
* Fix clippy warnings with Rust 1.72.0 by @cakebaker in https://github.com/uutils/coreutils/pull/5204
* Fix some of the recent clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/5182
* uucore: don't show error for ambiguous value by @cakebaker in https://github.com/uutils/coreutils/pull/5127
* uucore: provide capacity for vectors by @shinhs0506 in https://github.com/uutils/coreutils/pull/5086
* use is_empty() in mv & rmdir by @shinhs0506 in https://github.com/uutils/coreutils/pull/5117
* Extract uucore::line_ending::LineEnding by @simon04 in https://github.com/uutils/coreutils/pull/5120
* uucore,comm: fix warnings from bool_to_int_with_if by @cakebaker in https://github.com/uutils/coreutils/pull/5206

### Dependencies
* chore(deps): update rust crate chrono to ^0.4.28 by @renovate in https://github.com/uutils/coreutils/pull/5226
* chore(deps): update rust crate regex to 1.9.5 by @renovate in https://github.com/uutils/coreutils/pull/5234
* Bump windows-targets from 0.48.0 to 0.48.2 by @cakebaker in https://github.com/uutils/coreutils/pull/5161
* Downgrade windows-targets from 0.48.2 to 0.48.0 by @cakebaker in https://github.com/uutils/coreutils/pull/5167
* Bump js-sys from 0.3.60 to 0.3.64 by @cakebaker in https://github.com/uutils/coreutils/pull/5154
* chore(deps): update rust crate rstest to 0.18.2 by @renovate in https://github.com/uutils/coreutils/pull/5157
* Bump cpp to remove aho-corasick from skip list in deny.toml by @cakebaker in https://github.com/uutils/coreutils/pull/5165
* chore(deps): update rust crate signal-hook to 0.3.17 by @renovate in https://github.com/uutils/coreutils/pull/5097
* chore(deps): update rust crate signal-hook to 0.3.16 by @renovate in https://github.com/uutils/coreutils/pull/5087
* chore(deps): update rust crate rlimit to 0.10.1 by @renovate in https://github.com/uutils/coreutils/pull/5099
* chore(deps): update rust crate num-traits to 0.2.16 by @renovate in https://github.com/uutils/coreutils/pull/5108
* chore(deps): update rust crate xattr to 1.0.1 by @renovate in https://github.com/uutils/coreutils/pull/5121
* chore(deps): update rust crate regex to 1.9.3 by @renovate in https://github.com/uutils/coreutils/pull/5132
* Bump fundu & fix two failing tests by @cakebaker in https://github.com/uutils/coreutils/pull/5139
* Bump rustix crates by @cakebaker in https://github.com/uutils/coreutils/pull/5141
* Bump aho-corasick crates by @cakebaker in https://github.com/uutils/coreutils/pull/5140
* Bump futures from 0.3.25 to 0.3.28 by @cakebaker in https://github.com/uutils/coreutils/pull/5145
* Bump cpp from 0.5.7 to 0.5.8 by @cakebaker in https://github.com/uutils/coreutils/pull/5146
* chore(deps): update rust crate regex to 1.9.4 by @renovate in https://github.com/uutils/coreutils/pull/5208
* chore(deps): update rust crate lscolors to 0.15.0 by @renovate in https://github.com/uutils/coreutils/pull/5111
* Bump unicode-linebreak from 0.1.4 to 0.1.5 by @cakebaker in https://github.com/uutils/coreutils/pull/5113
* chore(deps): update rust crate chrono to ^0.4.27 by @renovate in https://github.com/uutils/coreutils/pull/5220
* chore(deps): update davidanson/markdownlint-cli2-action action to v12 by @renovate in https://github.com/uutils/coreutils/pull/5223
* chore(deps): update rust crate tempfile to 3.8.0 by @renovate in https://github.com/uutils/coreutils/pull/5169
* deny.toml: add bitflags to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5134
* deny.toml: remove redox_syscall from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5135
* chore(deps): update rust crate crossterm to >=0.27.0 by @renovate in https://github.com/uutils/coreutils/pull/5133
* chore(deps): update rust crate num-bigint to 0.4.4 by @renovate in https://github.com/uutils/coreutils/pull/5196
* Some updates of deps by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5148
* chore(deps): update is-terminal and tempfile in Cargo.toml by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5151

### code header
* Add license headers on all files by @sylvestre in https://github.com/uutils/coreutils/pull/5183
* Remove the author copyright notices by @sylvestre in https://github.com/uutils/coreutils/pull/5184
* Remove the author copyright notices by @cakebaker in https://github.com/uutils/coreutils/pull/5197
* All: normalize license notice in all `*.rs` files by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5199
* Remove the author copyright notices by @cakebaker in https://github.com/uutils/coreutils/pull/5205

## New Contributors
* @theoludwig made their first contribution in https://github.com/uutils/coreutils/pull/5085
* @starccy made their first contribution in https://github.com/uutils/coreutils/pull/5077
* @simon04 made their first contribution in https://github.com/uutils/coreutils/pull/5116
* @nouritsu made their first contribution in https://github.com/uutils/coreutils/pull/5129
* @bluelief made their first contribution in https://github.com/uutils/coreutils/pull/5159
* @tommady made their first contribution in https://github.com/uutils/coreutils/pull/5160
* @Benjscho made their first contribution in https://github.com/uutils/coreutils/pull/5187
* @zhitkoff made their first contribution in https://github.com/uutils/coreutils/pull/5198
* @thechampagne made their first contribution in https://github.com/uutils/coreutils/pull/5228



**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.20...0.0.21
