/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-dpkg-available-application.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_DPKG_AVAILABLE_APPLICATION_H
#define __UNITY_WEBAPPS_DPKG_AVAILABLE_APPLICATION_H


#define UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION              (unity_webapps_dpkg_available_application_get_type())
#define UNITY_WEBAPPS_DPKG_AVAILABLE_APPLICATION(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION, UnityWebappsDpkgAvailableApplication))
#define UNITY_WEBAPPS_DPKG_AVAILABLE_APPLICATION_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION, UnityWebappsDpkgAvailableApplicationClass))
#define UNITY_WEBAPPS_IS_DPKG_AVAILABLE_APPLICATION(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_IS_DPKG_AVAILABLE_APPLICATION_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_DPKG_AVAILABLE_APPLICATION_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_DPKG_AVAILABLE_APPLICATION, UnityWebappsDpkgAvailableApplicationClass))

#include "unity-webapps-available-application.h"
#include "unity-webapps-package-mechanism.h"

typedef struct _UnityWebappsDpkgAvailableApplicationPrivate UnityWebappsDpkgAvailableApplicationPrivate;

typedef struct _UnityWebappsDpkgAvailableApplication UnityWebappsDpkgAvailableApplication;


struct _UnityWebappsDpkgAvailableApplication {
	UnityWebappsAvailableApplication app;

	UnityWebappsDpkgAvailableApplicationPrivate *priv;
};

typedef struct _UnityWebappsDpkgAvailableApplicationClass UnityWebappsDpkgAvailableApplicationClass;

struct _UnityWebappsDpkgAvailableApplicationClass
{
	UnityWebappsAvailableApplicationClass parent_class;
};

GType unity_webapps_dpkg_available_application_get_type (void) G_GNUC_CONST;

UnityWebappsAvailableApplication *unity_webapps_dpkg_available_application_new (const gchar *name, 
																				const gchar *application_name,
																				const gchar *application_domain,
																				UnityWebappsPackageMechanism *package_mechanism);

gboolean
unity_webapps_dpkg_available_application_install (UnityWebappsDpkgAvailableApplication *application,
						  UnityWebappsAvailableApplicationInstalledQueryCallback callback,
												  gpointer user_data);


#endif
