/*
 * Copyright (C) 2004-2024 ZNC, see the NOTICE file for details.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/***************************************************************************
 * This file is generated automatically using codegen.pl from functions.in *
 * Don't change it manually.                                               *
 ***************************************************************************/

namespace {
	template<class T>
	struct SvToPtr {
		CString m_sType;
		SvToPtr(const CString& sType) {
			m_sType = sType;
		}
		T* operator()(SV* sv) {
			T* result;
			int res = SWIG_ConvertPtr(sv, (void**)&result, SWIG_TypeQuery(m_sType.c_str()), 0);
			if (SWIG_IsOK(res)) {
				return result;
			}
			return nullptr;
		}
	};

	CModule::EModRet SvToEModRet(SV* sv) {
		return static_cast<CModule::EModRet>(SvUV(sv));
	}
}
#define PSTART_IDF(Func) PSTART; XPUSHs(GetPerlObj()); PUSH_STR(#Func)
#define PCALLMOD(Error, Success) PCALL("ZNC::Core::CallModFunc"); if (SvTRUE(ERRSV)) { DEBUG("Perl hook died with: " + PString(ERRSV)); Error; } else if (SvIV(ST(0))) { Success; } else { Error; } PEND

bool CPerlModule::OnBoot() {
	bool result{};
	PSTART_IDF(OnBoot);
	PCALLMOD(
		result = CModule::OnBoot();,
		result = SvIV(ST(1));
	);
	return result;
}

bool CPerlModule::WebRequiresLogin() {
	bool result{};
	PSTART_IDF(WebRequiresLogin);
	PCALLMOD(
		result = CModule::WebRequiresLogin();,
		result = SvIV(ST(1));
	);
	return result;
}

bool CPerlModule::WebRequiresAdmin() {
	bool result{};
	PSTART_IDF(WebRequiresAdmin);
	PCALLMOD(
		result = CModule::WebRequiresAdmin();,
		result = SvIV(ST(1));
	);
	return result;
}

CString CPerlModule::GetWebMenuTitle() {
	CString result{};
	PSTART_IDF(GetWebMenuTitle);
	PCALLMOD(
		result = CModule::GetWebMenuTitle();,
		result = PString(ST(1));
	);
	return result;
}

bool CPerlModule::OnWebPreRequest(CWebSock& WebSock, const CString& sPageName) {
	bool result{};
	PSTART_IDF(OnWebPreRequest);
	PUSH_PTR(CWebSock*, &WebSock);
	PUSH_STR(sPageName);
	PCALLMOD(
		result = CModule::OnWebPreRequest(WebSock, sPageName);,
		result = SvIV(ST(1));
	);
	return result;
}

bool CPerlModule::OnWebRequest(CWebSock& WebSock, const CString& sPageName, CTemplate& Tmpl) {
	bool result{};
	PSTART_IDF(OnWebRequest);
	PUSH_PTR(CWebSock*, &WebSock);
	PUSH_STR(sPageName);
	PUSH_PTR(CTemplate*, &Tmpl);
	PCALLMOD(
		result = CModule::OnWebRequest(WebSock, sPageName, Tmpl);,
		result = SvIV(ST(1));
	);
	return result;
}

bool CPerlModule::ValidateWebRequestCSRFCheck(CWebSock& WebSock, const CString& sPageName) {
	bool result{};
	PSTART_IDF(ValidateWebRequestCSRFCheck);
	PUSH_PTR(CWebSock*, &WebSock);
	PUSH_STR(sPageName);
	PCALLMOD(
		result = CModule::ValidateWebRequestCSRFCheck(WebSock, sPageName);,
		result = SvIV(ST(1));
	);
	return result;
}

VWebSubPages* CPerlModule::_GetSubPages() {
	VWebSubPages* result{};
	PSTART_IDF(_GetSubPages);
	PCALLMOD(
		result = nullptr;,
		result = SvToPtr<VWebSubPages>("VWebSubPages*")(ST(1));
	);
	return result;
}

void CPerlModule::OnPreRehash() {
	PSTART_IDF(OnPreRehash);
	PCALLMOD(
		CModule::OnPreRehash();,
	);
}

void CPerlModule::OnPostRehash() {
	PSTART_IDF(OnPostRehash);
	PCALLMOD(
		CModule::OnPostRehash();,
	);
}

void CPerlModule::OnIRCDisconnected() {
	PSTART_IDF(OnIRCDisconnected);
	PCALLMOD(
		CModule::OnIRCDisconnected();,
	);
}

void CPerlModule::OnIRCConnected() {
	PSTART_IDF(OnIRCConnected);
	PCALLMOD(
		CModule::OnIRCConnected();,
	);
}

CModule::EModRet CPerlModule::OnIRCConnecting(CIRCSock *pIRCSock) {
	CModule::EModRet result{};
	PSTART_IDF(OnIRCConnecting);
	PUSH_PTR(CIRCSock *, pIRCSock);
	PCALLMOD(
		result = CModule::OnIRCConnecting(pIRCSock);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

void CPerlModule::OnIRCConnectionError(CIRCSock *pIRCSock) {
	PSTART_IDF(OnIRCConnectionError);
	PUSH_PTR(CIRCSock *, pIRCSock);
	PCALLMOD(
		CModule::OnIRCConnectionError(pIRCSock);,
	);
}

CModule::EModRet CPerlModule::OnIRCRegistration(CString& sPass, CString& sNick, CString& sIdent, CString& sRealName) {
	CModule::EModRet result{};
	PSTART_IDF(OnIRCRegistration);
	PUSH_STR(sPass);
	PUSH_STR(sNick);
	PUSH_STR(sIdent);
	PUSH_STR(sRealName);
	PCALLMOD(
		result = CModule::OnIRCRegistration(sPass, sNick, sIdent, sRealName);,
		result = SvToEModRet(ST(1));
		sPass = PString(ST(2));
		sNick = PString(ST(3));
		sIdent = PString(ST(4));
		sRealName = PString(ST(5));
	);
	return result;
}

CModule::EModRet CPerlModule::OnBroadcast(CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnBroadcast);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnBroadcast(sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(2));
	);
	return result;
}

void CPerlModule::OnChanPermission2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, unsigned char uMode, bool bAdded, bool bNoChange) {
	PSTART_IDF(OnChanPermission2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHu(uMode);
	mXPUSHi(bAdded);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnChanPermission2(pOpNick, Nick, Channel, uMode, bAdded, bNoChange);,
	);
}

void CPerlModule::OnOp2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PSTART_IDF(OnOp2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnOp2(pOpNick, Nick, Channel, bNoChange);,
	);
}

void CPerlModule::OnDeop2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PSTART_IDF(OnDeop2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnDeop2(pOpNick, Nick, Channel, bNoChange);,
	);
}

void CPerlModule::OnVoice2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PSTART_IDF(OnVoice2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnVoice2(pOpNick, Nick, Channel, bNoChange);,
	);
}

void CPerlModule::OnDevoice2(const CNick* pOpNick, const CNick& Nick, CChan& Channel, bool bNoChange) {
	PSTART_IDF(OnDevoice2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnDevoice2(pOpNick, Nick, Channel, bNoChange);,
	);
}

void CPerlModule::OnMode2(const CNick* pOpNick, CChan& Channel, char uMode, const CString& sArg, bool bAdded, bool bNoChange) {
	PSTART_IDF(OnMode2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR(CChan*, &Channel);
	mXPUSHi(uMode);
	PUSH_STR(sArg);
	mXPUSHi(bAdded);
	mXPUSHi(bNoChange);
	PCALLMOD(
		CModule::OnMode2(pOpNick, Channel, uMode, sArg, bAdded, bNoChange);,
	);
}

void CPerlModule::OnRawMode2(const CNick* pOpNick, CChan& Channel, const CString& sModes, const CString& sArgs) {
	PSTART_IDF(OnRawMode2);
	PUSH_PTR( CNick*, pOpNick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sModes);
	PUSH_STR(sArgs);
	PCALLMOD(
		CModule::OnRawMode2(pOpNick, Channel, sModes, sArgs);,
	);
}

CModule::EModRet CPerlModule::OnRaw(CString& sLine) {
	CModule::EModRet result{};
	PSTART_IDF(OnRaw);
	PUSH_STR(sLine);
	PCALLMOD(
		result = CModule::OnRaw(sLine);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnStatusCommand(CString& sCommand) {
	CModule::EModRet result{};
	PSTART_IDF(OnStatusCommand);
	PUSH_STR(sCommand);
	PCALLMOD(
		result = CModule::OnStatusCommand(sCommand);,
		result = SvToEModRet(ST(1));
		sCommand = PString(ST(2));
	);
	return result;
}

void CPerlModule::OnModCommand(const CString& sCommand) {
	PSTART_IDF(OnModCommand);
	PUSH_STR(sCommand);
	PCALLMOD(
		CModule::OnModCommand(sCommand);,
	);
}

void CPerlModule::OnModNotice(const CString& sMessage) {
	PSTART_IDF(OnModNotice);
	PUSH_STR(sMessage);
	PCALLMOD(
		CModule::OnModNotice(sMessage);,
	);
}

void CPerlModule::OnModCTCP(const CString& sMessage) {
	PSTART_IDF(OnModCTCP);
	PUSH_STR(sMessage);
	PCALLMOD(
		CModule::OnModCTCP(sMessage);,
	);
}

void CPerlModule::OnQuit(const CNick& Nick, const CString& sMessage, const vector<CChan*>& vChans) {
	PSTART_IDF(OnQuit);
	PUSH_PTR( CNick*, &Nick);
	PUSH_STR(sMessage);
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PUSH_PTR(CChan*, *i);
	}
	PCALLMOD(
		CModule::OnQuit(Nick, sMessage, vChans);,
	);
}

void CPerlModule::OnNick(const CNick& Nick, const CString& sNewNick, const vector<CChan*>& vChans) {
	PSTART_IDF(OnNick);
	PUSH_PTR( CNick*, &Nick);
	PUSH_STR(sNewNick);
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PUSH_PTR(CChan*, *i);
	}
	PCALLMOD(
		CModule::OnNick(Nick, sNewNick, vChans);,
	);
}

void CPerlModule::OnKick(const CNick& OpNick, const CString& sKickedNick, CChan& Channel, const CString& sMessage) {
	PSTART_IDF(OnKick);
	PUSH_PTR( CNick*, &OpNick);
	PUSH_STR(sKickedNick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		CModule::OnKick(OpNick, sKickedNick, Channel, sMessage);,
	);
}

CModule::EModRet CPerlModule::OnJoining(CChan& Channel) {
	CModule::EModRet result{};
	PSTART_IDF(OnJoining);
	PUSH_PTR(CChan*, &Channel);
	PCALLMOD(
		result = CModule::OnJoining(Channel);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

void CPerlModule::OnJoin(const CNick& Nick, CChan& Channel) {
	PSTART_IDF(OnJoin);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PCALLMOD(
		CModule::OnJoin(Nick, Channel);,
	);
}

void CPerlModule::OnPart(const CNick& Nick, CChan& Channel, const CString& sMessage) {
	PSTART_IDF(OnPart);
	PUSH_PTR( CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		CModule::OnPart(Nick, Channel, sMessage);,
	);
}

CModule::EModRet CPerlModule::OnInvite(const CNick& Nick, const CString& sChan) {
	CModule::EModRet result{};
	PSTART_IDF(OnInvite);
	PUSH_PTR( CNick*, &Nick);
	PUSH_STR(sChan);
	PCALLMOD(
		result = CModule::OnInvite(Nick, sChan);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanBufferStarting(CChan& Chan, CClient& Client) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanBufferStarting);
	PUSH_PTR(CChan*, &Chan);
	PUSH_PTR(CClient*, &Client);
	PCALLMOD(
		result = CModule::OnChanBufferStarting(Chan, Client);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanBufferEnding(CChan& Chan, CClient& Client) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanBufferEnding);
	PUSH_PTR(CChan*, &Chan);
	PUSH_PTR(CClient*, &Client);
	PCALLMOD(
		result = CModule::OnChanBufferEnding(Chan, Client);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanBufferPlayLine(CChan& Chan, CClient& Client, CString& sLine) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanBufferPlayLine);
	PUSH_PTR(CChan*, &Chan);
	PUSH_PTR(CClient*, &Client);
	PUSH_STR(sLine);
	PCALLMOD(
		result = CModule::OnChanBufferPlayLine(Chan, Client, sLine);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(4));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivBufferPlayLine(CClient& Client, CString& sLine) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivBufferPlayLine);
	PUSH_PTR(CClient*, &Client);
	PUSH_STR(sLine);
	PCALLMOD(
		result = CModule::OnPrivBufferPlayLine(Client, sLine);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(3));
	);
	return result;
}

void CPerlModule::OnClientLogin() {
	PSTART_IDF(OnClientLogin);
	PCALLMOD(
		CModule::OnClientLogin();,
	);
}

void CPerlModule::OnClientDisconnect() {
	PSTART_IDF(OnClientDisconnect);
	PCALLMOD(
		CModule::OnClientDisconnect();,
	);
}

CModule::EModRet CPerlModule::OnUserRaw(CString& sLine) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserRaw);
	PUSH_STR(sLine);
	PCALLMOD(
		result = CModule::OnUserRaw(sLine);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserCTCPReply(CString& sTarget, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserCTCPReply);
	PUSH_STR(sTarget);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserCTCPReply(sTarget, sMessage);,
		result = SvToEModRet(ST(1));
		sTarget = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserCTCP(CString& sTarget, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserCTCP);
	PUSH_STR(sTarget);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserCTCP(sTarget, sMessage);,
		result = SvToEModRet(ST(1));
		sTarget = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserAction(CString& sTarget, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserAction);
	PUSH_STR(sTarget);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserAction(sTarget, sMessage);,
		result = SvToEModRet(ST(1));
		sTarget = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserMsg(CString& sTarget, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserMsg);
	PUSH_STR(sTarget);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserMsg(sTarget, sMessage);,
		result = SvToEModRet(ST(1));
		sTarget = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserNotice(CString& sTarget, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserNotice);
	PUSH_STR(sTarget);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserNotice(sTarget, sMessage);,
		result = SvToEModRet(ST(1));
		sTarget = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserJoin(CString& sChannel, CString& sKey) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserJoin);
	PUSH_STR(sChannel);
	PUSH_STR(sKey);
	PCALLMOD(
		result = CModule::OnUserJoin(sChannel, sKey);,
		result = SvToEModRet(ST(1));
		sChannel = PString(ST(2));
		sKey = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserPart(CString& sChannel, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserPart);
	PUSH_STR(sChannel);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserPart(sChannel, sMessage);,
		result = SvToEModRet(ST(1));
		sChannel = PString(ST(2));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserTopic(CString& sChannel, CString& sTopic) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserTopic);
	PUSH_STR(sChannel);
	PUSH_STR(sTopic);
	PCALLMOD(
		result = CModule::OnUserTopic(sChannel, sTopic);,
		result = SvToEModRet(ST(1));
		sChannel = PString(ST(2));
		sTopic = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserTopicRequest(CString& sChannel) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserTopicRequest);
	PUSH_STR(sChannel);
	PCALLMOD(
		result = CModule::OnUserTopicRequest(sChannel);,
		result = SvToEModRet(ST(1));
		sChannel = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserQuit(CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserQuit);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnUserQuit(sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnCTCPReply(CNick& Nick, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnCTCPReply);
	PUSH_PTR(CNick*, &Nick);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnCTCPReply(Nick, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivCTCP(CNick& Nick, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivCTCP);
	PUSH_PTR(CNick*, &Nick);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnPrivCTCP(Nick, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanCTCP(CNick& Nick, CChan& Channel, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanCTCP);
	PUSH_PTR(CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnChanCTCP(Nick, Channel, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(4));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivAction(CNick& Nick, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivAction);
	PUSH_PTR(CNick*, &Nick);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnPrivAction(Nick, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanAction(CNick& Nick, CChan& Channel, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanAction);
	PUSH_PTR(CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnChanAction(Nick, Channel, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(4));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivMsg(CNick& Nick, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivMsg);
	PUSH_PTR(CNick*, &Nick);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnPrivMsg(Nick, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanMsg(CNick& Nick, CChan& Channel, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanMsg);
	PUSH_PTR(CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnChanMsg(Nick, Channel, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(4));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivNotice(CNick& Nick, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivNotice);
	PUSH_PTR(CNick*, &Nick);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnPrivNotice(Nick, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanNotice(CNick& Nick, CChan& Channel, CString& sMessage) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanNotice);
	PUSH_PTR(CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sMessage);
	PCALLMOD(
		result = CModule::OnChanNotice(Nick, Channel, sMessage);,
		result = SvToEModRet(ST(1));
		sMessage = PString(ST(4));
	);
	return result;
}

CModule::EModRet CPerlModule::OnTopic(CNick& Nick, CChan& Channel, CString& sTopic) {
	CModule::EModRet result{};
	PSTART_IDF(OnTopic);
	PUSH_PTR(CNick*, &Nick);
	PUSH_PTR(CChan*, &Channel);
	PUSH_STR(sTopic);
	PCALLMOD(
		result = CModule::OnTopic(Nick, Channel, sTopic);,
		result = SvToEModRet(ST(1));
		sTopic = PString(ST(4));
	);
	return result;
}

bool CPerlModule::OnServerCapAvailable(const CString& sCap) {
	bool result{};
	PSTART_IDF(OnServerCapAvailable);
	PUSH_STR(sCap);
	PCALLMOD(
		result = CModule::OnServerCapAvailable(sCap);,
		result = SvIV(ST(1));
	);
	return result;
}

bool CPerlModule::OnServerCap302Available(const CString& sCap, const CString& sValue) {
	bool result{};
	PSTART_IDF(OnServerCap302Available);
	PUSH_STR(sCap);
	PUSH_STR(sValue);
	PCALLMOD(
		result = CModule::OnServerCap302Available(sCap, sValue);,
		result = SvIV(ST(1));
	);
	return result;
}

void CPerlModule::OnServerCapResult(const CString& sCap, bool bSuccess) {
	PSTART_IDF(OnServerCapResult);
	PUSH_STR(sCap);
	mXPUSHi(bSuccess);
	PCALLMOD(
		CModule::OnServerCapResult(sCap, bSuccess);,
	);
}

void CPerlModule::OnClientAttached() {
	PSTART_IDF(OnClientAttached);
	PCALLMOD(
		CModule::OnClientAttached();,
	);
}

void CPerlModule::OnClientDetached() {
	PSTART_IDF(OnClientDetached);
	PCALLMOD(
		CModule::OnClientDetached();,
	);
}

CModule::EModRet CPerlModule::OnTimerAutoJoin(CChan& Channel) {
	CModule::EModRet result{};
	PSTART_IDF(OnTimerAutoJoin);
	PUSH_PTR(CChan*, &Channel);
	PCALLMOD(
		result = CModule::OnTimerAutoJoin(Channel);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

bool CPerlModule::OnEmbeddedWebRequest(CWebSock& WebSock, const CString& sPageName, CTemplate& Tmpl) {
	bool result{};
	PSTART_IDF(OnEmbeddedWebRequest);
	PUSH_PTR(CWebSock*, &WebSock);
	PUSH_STR(sPageName);
	PUSH_PTR(CTemplate*, &Tmpl);
	PCALLMOD(
		result = CModule::OnEmbeddedWebRequest(WebSock, sPageName, Tmpl);,
		result = SvIV(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnAddNetwork(CIRCNetwork& Network, CString& sErrorRet) {
	CModule::EModRet result{};
	PSTART_IDF(OnAddNetwork);
	PUSH_PTR(CIRCNetwork*, &Network);
	PUSH_STR(sErrorRet);
	PCALLMOD(
		result = CModule::OnAddNetwork(Network, sErrorRet);,
		result = SvToEModRet(ST(1));
		sErrorRet = PString(ST(3));
	);
	return result;
}

CModule::EModRet CPerlModule::OnDeleteNetwork(CIRCNetwork& Network) {
	CModule::EModRet result{};
	PSTART_IDF(OnDeleteNetwork);
	PUSH_PTR(CIRCNetwork*, &Network);
	PCALLMOD(
		result = CModule::OnDeleteNetwork(Network);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnSendToClient(CString& sLine, CClient& Client) {
	CModule::EModRet result{};
	PSTART_IDF(OnSendToClient);
	PUSH_STR(sLine);
	PUSH_PTR(CClient*, &Client);
	PCALLMOD(
		result = CModule::OnSendToClient(sLine, Client);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnSendToIRC(CString& sLine) {
	CModule::EModRet result{};
	PSTART_IDF(OnSendToIRC);
	PUSH_STR(sLine);
	PCALLMOD(
		result = CModule::OnSendToIRC(sLine);,
		result = SvToEModRet(ST(1));
		sLine = PString(ST(2));
	);
	return result;
}

CModule::EModRet CPerlModule::OnRawMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnRawMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnRawMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnNumericMessage(CNumericMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnNumericMessage);
	PUSH_PTR(CNumericMessage*, &Message);
	PCALLMOD(
		result = CModule::OnNumericMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

void CPerlModule::OnQuitMessage(CQuitMessage& Message, const std::vector<CChan*>& vChans) {
	PSTART_IDF(OnQuitMessage);
	PUSH_PTR(CQuitMessage*, &Message);
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PUSH_PTR(CChan*, *i);
	}
	PCALLMOD(
		CModule::OnQuitMessage(Message, vChans);,
	);
}

void CPerlModule::OnNickMessage(CNickMessage& Message, const std::vector<CChan*>& vChans) {
	PSTART_IDF(OnNickMessage);
	PUSH_PTR(CNickMessage*, &Message);
	for (vector<CChan*>::const_iterator i = vChans.begin(); i != vChans.end(); ++i) {
		PUSH_PTR(CChan*, *i);
	}
	PCALLMOD(
		CModule::OnNickMessage(Message, vChans);,
	);
}

void CPerlModule::OnKickMessage(CKickMessage& Message) {
	PSTART_IDF(OnKickMessage);
	PUSH_PTR(CKickMessage*, &Message);
	PCALLMOD(
		CModule::OnKickMessage(Message);,
	);
}

void CPerlModule::OnJoinMessage(CJoinMessage& Message) {
	PSTART_IDF(OnJoinMessage);
	PUSH_PTR(CJoinMessage*, &Message);
	PCALLMOD(
		CModule::OnJoinMessage(Message);,
	);
}

void CPerlModule::OnPartMessage(CPartMessage& Message) {
	PSTART_IDF(OnPartMessage);
	PUSH_PTR(CPartMessage*, &Message);
	PCALLMOD(
		CModule::OnPartMessage(Message);,
	);
}

CModule::EModRet CPerlModule::OnChanBufferPlayMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanBufferPlayMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnChanBufferPlayMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivBufferPlayMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivBufferPlayMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnPrivBufferPlayMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserRawMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserRawMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserRawMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserCTCPReplyMessage(CCTCPMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserCTCPReplyMessage);
	PUSH_PTR(CCTCPMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserCTCPReplyMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserCTCPMessage(CCTCPMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserCTCPMessage);
	PUSH_PTR(CCTCPMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserCTCPMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserActionMessage(CActionMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserActionMessage);
	PUSH_PTR(CActionMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserActionMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserTextMessage(CTextMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserTextMessage);
	PUSH_PTR(CTextMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserTextMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserNoticeMessage(CNoticeMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserNoticeMessage);
	PUSH_PTR(CNoticeMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserNoticeMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserJoinMessage(CJoinMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserJoinMessage);
	PUSH_PTR(CJoinMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserJoinMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserPartMessage(CPartMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserPartMessage);
	PUSH_PTR(CPartMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserPartMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserTopicMessage(CTopicMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserTopicMessage);
	PUSH_PTR(CTopicMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserTopicMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnUserQuitMessage(CQuitMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnUserQuitMessage);
	PUSH_PTR(CQuitMessage*, &Message);
	PCALLMOD(
		result = CModule::OnUserQuitMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnCTCPReplyMessage(CCTCPMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnCTCPReplyMessage);
	PUSH_PTR(CCTCPMessage*, &Message);
	PCALLMOD(
		result = CModule::OnCTCPReplyMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivCTCPMessage(CCTCPMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivCTCPMessage);
	PUSH_PTR(CCTCPMessage*, &Message);
	PCALLMOD(
		result = CModule::OnPrivCTCPMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanCTCPMessage(CCTCPMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanCTCPMessage);
	PUSH_PTR(CCTCPMessage*, &Message);
	PCALLMOD(
		result = CModule::OnChanCTCPMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivActionMessage(CActionMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivActionMessage);
	PUSH_PTR(CActionMessage*, &Message);
	PCALLMOD(
		result = CModule::OnPrivActionMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanActionMessage(CActionMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanActionMessage);
	PUSH_PTR(CActionMessage*, &Message);
	PCALLMOD(
		result = CModule::OnChanActionMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivTextMessage(CTextMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivTextMessage);
	PUSH_PTR(CTextMessage*, &Message);
	PCALLMOD(
		result = CModule::OnPrivTextMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanTextMessage(CTextMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanTextMessage);
	PUSH_PTR(CTextMessage*, &Message);
	PCALLMOD(
		result = CModule::OnChanTextMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnPrivNoticeMessage(CNoticeMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnPrivNoticeMessage);
	PUSH_PTR(CNoticeMessage*, &Message);
	PCALLMOD(
		result = CModule::OnPrivNoticeMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnChanNoticeMessage(CNoticeMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnChanNoticeMessage);
	PUSH_PTR(CNoticeMessage*, &Message);
	PCALLMOD(
		result = CModule::OnChanNoticeMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnTopicMessage(CTopicMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnTopicMessage);
	PUSH_PTR(CTopicMessage*, &Message);
	PCALLMOD(
		result = CModule::OnTopicMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnSendToClientMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnSendToClientMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnSendToClientMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

CModule::EModRet CPerlModule::OnSendToIRCMessage(CMessage& Message) {
	CModule::EModRet result{};
	PSTART_IDF(OnSendToIRCMessage);
	PUSH_PTR(CMessage*, &Message);
	PCALLMOD(
		result = CModule::OnSendToIRCMessage(Message);,
		result = SvToEModRet(ST(1));
	);
	return result;
}

