/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PointonObject;

public class PointonObjectIntersectionObject
extends IntersectionObject {
    public double Eps = 1.0E-5;
    double x;
    double y;
    double x1;
    double y1;

    public PointonObjectIntersectionObject(Construction construction, ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        super(construction, constructionObject, constructionObject2);
    }

    public void validate(double d2, double d3) {
        this.setXY(d2, d3);
        this.validate();
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("first", this.P1.getName());
        xmlWriter.printArg("second", this.P2.getName());
        xmlWriter.printArg("x", "" + this.getX());
        xmlWriter.printArg("y", "" + this.getY());
        if (this.getAway() != null) {
            if (this.StayAway) {
                xmlWriter.printArg("awayfrom", this.getAway().getName());
            } else {
                xmlWriter.printArg("closeto", this.getAway().getName());
            }
        }
        this.printType(xmlWriter);
        if (!this.Restricted) {
            xmlWriter.printArg("valid", "true");
        }
    }

    public void validate() {
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        double d2 = this.projectOnce();
        if (!this.Valid) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            double d3 = this.projectOnce();
            if (d3 >= d2 && d3 < this.Eps) {
                return;
            }
            d2 = d3;
            double d4 = this.x1 - this.x;
            double d5 = this.y1 - this.y;
            double d6 = Math.max(Math.abs(d4), Math.abs(d5));
            if (Math.abs(d6) > 1.0E-13) {
                d4 /= d6;
            }
            d5 /= d6;
            double d7 = this.X - this.x1;
            double d8 = this.Y - this.y1;
            d6 = Math.max(Math.abs(d7), Math.abs(d8));
            if (Math.abs(d6) > 1.0E-13) {
                d7 /= d6;
            }
            double d9 = d4 * this.x1 + d5 * this.y1;
            double d10 = d7 * this.X + (d8 /= d6) * this.Y;
            double d11 = d4 * d8 - d7 * d5;
            if (!(Math.abs(d11) > 1.0E-13)) continue;
            double d12 = (d9 * d8 - d10 * d5) / d11;
            double d13 = (d4 * d10 - d7 * d9) / d11;
            double d14 = this.X;
            double d15 = this.Y;
            this.X = d12;
            this.Y = d13;
            double d16 = this.projectOnce();
            if (d16 > d3) {
                this.X = d14;
                this.Y = d15;
                continue;
            }
            d2 = d16;
        }
        this.Valid = false;
    }

    public double projectOnce() {
        this.x = this.X;
        this.y = this.Y;
        ((PointonObject)((Object)this.P1)).project(this);
        double d2 = Math.max(Math.abs(this.X - this.x), Math.abs(this.Y - this.y));
        this.x1 = this.X;
        this.y1 = this.Y;
        ((PointonObject)((Object)this.P2)).project(this);
        double d3 = Math.max(Math.abs(this.X - this.x1), Math.abs(this.Y - this.y1));
        return Math.max(d2, d3);
    }

    public boolean moveable() {
        return true;
    }
}

