/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class InvulGrid
extends JApplet
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    Font font;
    int fontsize;
    int xsize;
    int ysize;
    int xlines;
    int ylines;
    int xstep;
    int ystep;
    int linewidth;
    int pointsize;
    Color scribling_pencolor;
    Color bgcolor;
    Color pencolor;
    Color linecolor;
    Color markcolor;
    Color gridcolor;
    Color deletecolor;
    Color marked_color;
    Color exercisecolor;
    Color scribling_rowcolor;
    String[][] charArray;
    boolean[][] Marked;
    boolean[][] Editable;
    boolean[] EditableObject;
    int xindex = 0;
    int yindex = 0;
    int objcnt = 0;
    Graphics2D backg;
    BufferedImage bg;
    Vector objects = new Vector();
    Vector decimalpoints = new Vector();
    int pointcnt = 0;
    boolean showgrid;
    public String line_plus = "line + ";
    public String line_times = "line x";
    public String line_min = "line -";
    public String line_div = "line :";
    public String delete_line = "delete line";
    public String clear_all = "clear all";
    Container cp;
    int editablecnt = 0;
    int fontheight = 10;
    boolean check_segments = false;
    boolean reverse = false;
    boolean left_to_right = false;
    int scribling = 2;
    boolean right = true;
    int fontwidth = 10;
    public int[] ForbiddenKeys = new int[]{16, 17, 18, 19, 20, 27, 112, 113, 114, 115, 116, 117, 118, 119, 120, 145, 154, 155};

    public void init() {
        int n;
        this.scribling_pencolor = this.colorParam("scribling_pencolor", new Color(255, 0, 0));
        this.scribling = this.getBool("scribling_row", true) ? 2 : 1;
        this.getLanguage("language");
        this.getButtons();
        Dimension dimension = this.getSize();
        this.xsize = dimension.width;
        this.ysize = dimension.height;
        this.xlines = this.getInt("xlines", 10);
        this.ylines = this.getInt("ylines", 10);
        this.xstep = this.xsize / this.xlines;
        this.ystep = this.ysize / (this.ylines + 1);
        this.bg = new BufferedImage(this.xsize, this.ysize, 2);
        this.backg = (Graphics2D)this.bg.getGraphics();
        this.fontsize = this.getInt("fontsize", 28);
        this.font = this.FitFont(this.backg, "TimesRoman", this.fontsize);
        this.charArray = new String[this.xlines + 1][this.ylines + 1];
        this.Marked = new boolean[this.xlines + 1][this.ylines + 1];
        this.Editable = new boolean[this.xlines + 1][this.ylines + 1];
        this.EditableObject = new boolean[this.xlines * this.ylines];
        for (n = 0; n < this.xlines + 1; ++n) {
            for (int i = 0; i < this.ylines + 1; ++i) {
                this.charArray[n][i] = "";
                this.Marked[n][i] = false;
                this.Editable[n][i] = true;
            }
        }
        for (n = 0; n < this.xlines * this.ylines; ++n) {
            this.EditableObject[n] = true;
        }
        this.showgrid = this.getBool("showgrid", true);
        this.left_to_right = this.getBool("reverse", false);
        this.scribling_rowcolor = this.colorParam("scribling_rowcolor", new Color(0, 255, 0, 50));
        this.bgcolor = this.colorParam("bgcolor", Color.white);
        this.pencolor = this.colorParam("pencolor", Color.black);
        this.linecolor = this.colorParam("linecolor", Color.red);
        this.markcolor = this.colorParam("markcolor", Color.green);
        this.gridcolor = this.colorParam("gridcolor", Color.blue);
        this.exercisecolor = this.colorParam("exercisecolor", Color.black);
        this.linewidth = this.getInt("linewidth", 2);
        this.pointsize = this.getInt("pointsize", 5);
        this.deletecolor = new Color(255, 0, 0, 120);
        this.marked_color = this.markcolor;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.getSegments();
        this.ReadStringParam();
        this.prepaint();
        this.requestFocus();
    }

    public String ReadApplet(String string) {
        String[] stringArray = new String[this.ylines + 1];
        String[] stringArray2 = new String[this.ylines + 1];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = -1;
        for (int i = this.scribling; i <= this.ylines; ++i) {
            int n4;
            StringBuffer stringBuffer = new StringBuffer();
            bl2 = false;
            String string2 = "";
            n3 = -1;
            for (n4 = 0; n4 < this.objcnt; ++n4) {
                int n5;
                if (!(this.objects.elementAt(n4) instanceof GridLine) || !((GridLine)this.objects.elementAt(n4)).isSegment() || i != (n5 = ((GridLine)this.objects.elementAt(n4)).getY1() / this.ystep - 1)) continue;
                bl2 = true;
                string2 = ((GridLine)this.objects.elementAt(n4)).getText();
                n4 = this.objcnt;
            }
            n3 = this.findPoint(i);
            for (n4 = 0; n4 <= this.xlines; ++n4) {
                if (n4 == n3) {
                    stringBuffer.append(".");
                }
                stringBuffer.append(this.charArray[n4][i]);
            }
            if (stringBuffer.length() == 0) continue;
            if (stringBuffer.length() > n2) {
                n2 = stringBuffer.length();
            }
            bl = true;
            stringArray[n] = this.replace(stringBuffer.toString(), " ", "");
            if (bl2) {
                stringArray2[n] = string2;
            }
            ++n;
        }
        if (!bl) {
            return "error:empty answer";
        }
        if (string.equals("3")) {
            return this.makeLatex(stringArray, stringArray2);
        }
        if (string.equals("2")) {
            return this.makeHtml(stringArray, stringArray2);
        }
        if (string.equals("1")) {
            return this.makeJs(stringArray, stringArray2, n2);
        }
        if (string.equals("0")) {
            return this.Array2String(stringArray, ",");
        }
        return "error : usage is \n ReadApplet(0) ... wims itemlist\n ReadApplet(3) ... latex representation\n ReadApplet(2) ... html representation\n ReadApplet(1) ... javascript confirmbox";
    }

    public String Array2String(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuilder.append(string);
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String makeLatex(String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        int n3;
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        int n4 = 0;
        for (n3 = 0; !bl && n3 <= this.ylines; ++n3) {
            if (stringArray[n3] == null || stringArray[n3].indexOf("\\") == -1) continue;
            bl = true;
            n4 = n3;
        }
        if (bl) {
            n2 = stringArray[n4].indexOf("/");
            n = stringArray[n4].indexOf("\\");
            n3 = n - n2 - 1;
            if (n3 < 0) {
                n3 = stringArray[n4].length();
            }
            stringArray[n4] = this.replace(stringArray[n4], "\\", " & \\diagdown & ");
            stringArray[n4] = this.replace(stringArray[n4], "/", " & \\diagup & ");
            stringArray[n4] = stringArray[n4] + " \\\\ ";
            string = "\\begin{array}{cclcc}" + stringArray[n4];
            ++n4;
        } else {
            string = "\\begin{array}{rr}";
            n4 = 0;
        }
        for (n2 = n4; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) continue;
            if (stringArray2[n2] != null) {
                string2 = stringArray2[n2].equals("\u00d7") ? " \\times " : (stringArray2[n2].equals("\u00f7") ? " \\div " : stringArray2[n2]);
                if (!bl) {
                    if (this.right) {
                        string = string + " \\underline{" + stringArray[n2] + "} & " + stringArray2[n2] + " \\\\ ";
                        continue;
                    }
                    string = string + stringArray2[n2] + " & \\underline{" + stringArray[n2] + " } \\\\ ";
                    continue;
                }
                if (n3 > stringArray[n2].length()) {
                    for (n = 0; n < n3 - stringArray[n2].length(); ++n) {
                        string3 = string3 + " \\: ";
                    }
                }
                string = string + "&  & \\underline{" + string3 + stringArray[n2] + "} &  & \\\\ ";
                continue;
            }
            if (!bl) {
                if (this.right) {
                    string = string + " " + stringArray[n2] + " & " + " \\\\ ";
                    continue;
                }
                string = string + " & " + stringArray[n2] + " \\\\ ";
                continue;
            }
            if (n3 > stringArray[n2].length()) {
                for (n = 0; n < n3 - stringArray[n2].length(); ++n) {
                    string3 = string3 + " \\: ";
                }
            }
            string = string + "&  & " + string3 + stringArray[n2] + " &  &  \\\\ ";
        }
        string = string + " \\end{array}";
        return string;
    }

    public String makeHtml(String[] stringArray, String[] stringArray2) {
        String string = "<table style=\"margin-bottom:1px;margin-top:1px;\"><tr><td style=\"text-align:right\"><table style=\"margin-bottom:1px;margin-top:1px;width:100%\">";
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            string = this.right ? string + "<tr><td style=\"text-align:right\">" + stringArray[i] + "</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td></tr>" : string + "<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td style=\"text-align:right\">" + stringArray[i] + "</td></tr>";
            if (stringArray2[i] == null) continue;
            string2 = stringArray2[i].equals("\u00d7") ? "x" : (stringArray2[i].equals("\u00f7") ? ":" : stringArray2[i]);
            string = this.right ? string + "</table></td><tr><td><table style=\"margin-bottom:1px;margin-top:1px;width:100%\"><tr><td style=\"width:90%\"><hr></td><td>" + string2 + "</td></tr></table></td></tr><td><table style=\"margin-bottom:1px;margin-top:1px;width:100%\">" : string + "</table></td><tr><td><table style=\"margin-bottom:1px;margin-top:1px;width:100%\"><tr><td>" + string2 + "</td><td width=\"90%\"><hr></td></tr></table></td></tr><td><table style=\"margin-bottom:1px;margin-top:1px;width=:100%\">";
        }
        string = string + "</table></td></tr></table>";
        return string;
    }

    public String makeJs(String[] stringArray, String[] stringArray2, int n) {
        int n2;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (n2 = 0; n2 < n; ++n2) {
            string3 = string3 + "-";
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            int n3;
            if (stringArray[n2] == null) continue;
            if (stringArray2[n2] != null) {
                string2 = "";
                for (n3 = 0; n3 < n - stringArray[n2].length(); ++n3) {
                    string2 = string2 + " ";
                }
                if (this.right) {
                    string = string + string2 + stringArray[n2] + "\n" + string3 + " " + stringArray2[n2] + "\n";
                    continue;
                }
                string = string + string2 + stringArray[n2] + "\n" + stringArray2[n2] + "  " + string3 + "\n";
                continue;
            }
            string2 = "";
            for (n3 = 0; n3 < n - stringArray[n2].length(); ++n3) {
                string2 = string2 + " ";
            }
            string = string + string2 + stringArray[n2] + "\n";
        }
        return string;
    }

    public void getSegments() {
        String string = this.getParameter("segment1");
        if (string != null && string.length() > 3) {
            int n = 1;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            this.check_segments = true;
            while (string != null && string.length() > 3) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                n2 = stringTokenizer.countTokens();
                if (n2 != 4) {
                    System.out.println("Expecting 2 points for a linesegment");
                    return;
                }
                for (int i = 0; i < 4; ++i) {
                    if (i == 0) {
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    if (i == 1) {
                        n5 = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    if (i == 2) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    if (i != 3) continue;
                    n6 = Integer.parseInt(stringTokenizer.nextToken());
                }
                String string2 = "color" + n;
                this.EditableObject[this.editablecnt] = false;
                ++this.editablecnt;
                Color color = this.colorParam(string2, this.linecolor);
                this.drawLine(n3 * this.xstep, (n5 + 2) * this.ystep, n4 * this.xstep, (n6 + 2) * this.ystep, color, "", false, false);
                string = this.getParameter("segment" + ++n);
            }
        }
    }

    public void ReadStringParam() {
        String string = this.getParameter("exercise");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            boolean bl = false;
            boolean bl2 = false;
            if (n < this.ylines) {
                int n2;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    int n4;
                    string3 = stringTokenizer.nextToken();
                    if (string3.indexOf("/") != -1) {
                        bl = true;
                    }
                    if (string3.indexOf("---|") != -1) {
                        char[] cArray = string2.toCharArray();
                        n4 = 0;
                        int n5 = 0;
                        int n6 = cArray.length;
                        for (int i = 0; i < n6; ++i) {
                            if (cArray[i] == ' ' || n4 != 0) continue;
                            n5 = i;
                            n4 = 1;
                        }
                        if (this.right && bl2) {
                            --n6;
                        } else if (!this.right && bl2 && n5 > 0) {
                            --n5;
                            --n6;
                        }
                        if (string3.indexOf("---|+") != -1) {
                            this.drawLine(n5 * this.xstep, (n2 + 2) * this.ystep, n6 * this.xstep, (n2 + 2) * this.ystep, this.linecolor, "+", false, true);
                            this.EditableObject[this.editablecnt] = false;
                            ++this.editablecnt;
                            continue;
                        }
                        if (string3.indexOf("---|-") != -1) {
                            this.drawLine(n5 * this.xstep, (n2 + 2) * this.ystep, n6 * this.xstep, (n2 + 2) * this.ystep, this.linecolor, "-", false, true);
                            this.EditableObject[this.editablecnt] = false;
                            ++this.editablecnt;
                            continue;
                        }
                        if (string3.indexOf("---|x") != -1) {
                            this.drawLine(n5 * this.xstep, (n2 + 2) * this.ystep, n6 * this.xstep, (n2 + 2) * this.ystep, this.linecolor, "\u00d7", false, true);
                            this.EditableObject[this.editablecnt] = false;
                            ++this.editablecnt;
                            continue;
                        }
                        if (string3.indexOf("---|:") != -1) {
                            this.drawLine(n5 * this.xstep, (n2 + 2) * this.ystep, n6 * this.xstep, (n2 + 2) * this.ystep, this.linecolor, "\u00f7", false, true);
                            this.EditableObject[this.editablecnt] = false;
                            ++this.editablecnt;
                            continue;
                        }
                        System.out.println("unknown command : " + string3);
                        continue;
                    }
                    n3 = 0;
                    for (int i = 0; i < string3.length(); ++i) {
                        if (i <= this.xlines) {
                            string4 = Character.toString(string3.charAt(i));
                            if (string4.equals(".")) {
                                this.drawPoint(n3, n2 + 2, this.pointsize, false);
                                bl2 = true;
                                continue;
                            }
                            this.charArray[n3][n2 + 2] = string4;
                            string2 = string3;
                            if (bl) {
                                this.Editable[n3][n2 + 2] = false;
                            } else {
                                for (n4 = 0; n4 < this.xlines; ++n4) {
                                    this.Editable[n4][n2 + 2] = false;
                                }
                            }
                            ++n3;
                            continue;
                        }
                        System.out.println("ERROR : word " + string3 + " too large for " + this.xlines + " gridlines...\nin param \"execise\"");
                        return;
                    }
                }
                for (n2 = 0; n2 < this.xlines; ++n2) {
                    this.Editable[n2][1] = true;
                    this.charArray[n2][1] = "";
                }
            } else {
                System.out.println("ERROR : to many spaces in param \"exercise\"");
                return;
            }
        }
    }

    public void getLanguage(String string) {
        string = this.getParameter("language");
        if (string != null && string.length() == 2) {
            if (string.equalsIgnoreCase("nl")) {
                this.line_plus = "lijn + ";
                this.line_times = "lijn x";
                this.line_min = "lijn -";
                this.delete_line = "verwijder lijn";
                this.clear_all = "alles wissen";
                this.line_div = "line :";
                this.right = true;
                return;
            }
            if (string.equalsIgnoreCase("fr")) {
                this.line_plus = "+ \u00e0 droite ";
                this.line_times = "droite x";
                this.delete_line = "effacer droite";
                this.clear_all = "effacer";
                this.line_min = "droite -";
                this.line_div = "droite :";
                this.right = false;
                return;
            }
        }
    }

    public Font FitFont(Graphics graphics, String string, int n) {
        String string2 = "";
        for (int i = 0; i < this.xlines + 4; ++i) {
            string2 = string2 + "5";
        }
        this.font = new Font(string, 1, n);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        if (fontMetrics.stringWidth(string2) > this.xsize) {
            boolean bl = true;
            while (n > 4 && bl) {
                this.font = new Font(string, 1, --n);
                fontMetrics = graphics.getFontMetrics(this.font);
                if (fontMetrics.stringWidth(string2) >= this.xsize) continue;
                bl = false;
            }
            System.out.println("xsize (" + this.xsize + ") of applet too small...I've adjusted fontsize to " + n);
            this.font = new Font(string, 1, n);
            fontMetrics = graphics.getFontMetrics(this.font);
        }
        this.fontheight = (int)(0.6 * (double)fontMetrics.getHeight());
        if (this.fontheight > this.ystep) {
            System.out.println("I will decrease number of horizontal lines: fonts will overlap...\nuse more xlines to overcome this.");
            this.ystep = this.fontheight;
            this.ylines = this.ysize / this.fontheight;
            if (this.ylines < 2) {
                this.ylines = 2;
            }
        }
        this.fontwidth = fontMetrics.stringWidth("+");
        return this.font;
    }

    public int getInt(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null && string2.length() != 0) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.out.println(" can not parse parameter " + string);
            }
        }
        return n;
    }

    public boolean getBool(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            if (string2.equals("1") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true")) {
                return true;
            }
            if (string2.equals("0") || string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return bl;
    }

    public Color colorParam(String string, Color color) {
        String string2 = this.getParameter(string);
        if (string2 != null && string2.length() != 0) {
            string2 = this.replace(string2, ":", ",");
            if ((string2 = this.replace(string2, ";", ",")).indexOf(44) > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n = stringTokenizer.countTokens();
                if (n < 3 || n > 4) {
                    return color;
                }
                int[] nArray = new int[n + 1];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                    if (nArray[i] <= 255 && nArray[i] >= 0) continue;
                    nArray[i] = 0;
                }
                color = n == 3 ? new Color(nArray[0], nArray[1], nArray[2]) : new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else {
                try {
                    color = Color.decode(string2);
                }
                catch (Exception exception) {
                    System.out.println("could not parse " + string);
                }
                return color;
            }
        }
        return color;
    }

    public void prepaint() {
        int n;
        int n2;
        this.backg.setColor(this.bgcolor);
        this.backg.fillRect(0, 0, this.xsize, this.ysize);
        if (this.showgrid) {
            this.backg.setColor(this.gridcolor);
            this.backg.setStroke(new BasicStroke(1.0f));
            for (n2 = 0; n2 < this.xsize; n2 += this.xstep) {
                this.backg.drawLine(n2, this.ystep, n2, this.ysize);
            }
            for (n2 = this.ystep; n2 < this.ysize; n2 += this.ystep) {
                this.backg.drawLine(0, n2, this.xsize, n2);
            }
        }
        this.reverse = false;
        this.backg.setFont(this.font);
        for (n2 = 0; n2 < this.objcnt; ++n2) {
            if (!(this.objects.elementAt(n2) instanceof GridLine)) continue;
            this.backg.setStroke(new BasicStroke(this.linewidth));
            this.backg.setColor(((GridLine)this.objects.elementAt(n2)).getColor());
            this.backg.drawLine(((GridLine)this.objects.elementAt(n2)).getX1(), ((GridLine)this.objects.elementAt(n2)).getY1(), ((GridLine)this.objects.elementAt(n2)).getX2(), ((GridLine)this.objects.elementAt(n2)).getY2());
            if (this.right) {
                this.backg.drawString(((GridLine)this.objects.elementAt(n2)).getText(), ((GridLine)this.objects.elementAt(n2)).getX2() + this.linewidth, ((GridLine)this.objects.elementAt(n2)).getY2());
            } else {
                this.backg.drawString(((GridLine)this.objects.elementAt(n2)).getText(), ((GridLine)this.objects.elementAt(n2)).getX1() - this.linewidth - this.fontwidth, ((GridLine)this.objects.elementAt(n2)).getY2());
            }
            if (n2 != this.objcnt - 1) continue;
            this.reverse = ((GridLine)this.objects.elementAt(n2)).isSegment();
        }
        for (n2 = 0; n2 < this.pointcnt; ++n2) {
            if (!(this.decimalpoints.elementAt(n2) instanceof DecimalPoint)) continue;
            n = ((DecimalPoint)this.decimalpoints.elementAt(n2)).getD();
            this.backg.setStroke(new BasicStroke(n));
            this.backg.setColor(this.pencolor);
            this.backg.fillOval(this.xstep * ((DecimalPoint)this.decimalpoints.elementAt(n2)).getX() - this.pointsize, this.ystep * (1 + ((DecimalPoint)this.decimalpoints.elementAt(n2)).getY()) - this.pointsize, n, n);
        }
        this.backg.setColor(this.scribling_rowcolor);
        for (n2 = 0; n2 <= this.xlines; ++n2) {
            this.backg.fillRect(n2 * this.xstep, this.ystep, this.xstep, this.ystep);
        }
        this.backg.setColor(this.exercisecolor);
        for (n2 = 0; n2 <= this.xlines; ++n2) {
            for (n = 0; n <= this.ylines; ++n) {
                if (this.Editable[n2][n]) continue;
                this.backg.drawString(this.charArray[n2][n], n2 * this.xstep, (n + 1) * this.ystep);
            }
        }
    }

    public void update(Graphics graphics) {
        this.prepaint();
        this.paintComponent(graphics);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.bg, 0, 0, this);
        graphics2D.setFont(this.font);
        this.reverse = false;
        for (n2 = 0; n2 < this.objcnt; ++n2) {
            if (!(this.objects.elementAt(n2) instanceof GridLine)) continue;
            if (((GridLine)this.objects.elementAt(n2)).getEdit()) {
                this.backg.setStroke(new BasicStroke(this.linewidth));
                this.backg.setColor(((GridLine)this.objects.elementAt(n2)).getColor());
                this.backg.drawLine(((GridLine)this.objects.elementAt(n2)).getX1(), ((GridLine)this.objects.elementAt(n2)).getY1(), ((GridLine)this.objects.elementAt(n2)).getX2(), ((GridLine)this.objects.elementAt(n2)).getY2());
                if (this.right) {
                    this.backg.drawString(((GridLine)this.objects.elementAt(n2)).getText(), ((GridLine)this.objects.elementAt(n2)).getX2() + this.linewidth, ((GridLine)this.objects.elementAt(n2)).getY2());
                } else {
                    this.backg.drawString(((GridLine)this.objects.elementAt(n2)).getText(), ((GridLine)this.objects.elementAt(n2)).getX1() - this.linewidth - this.fontwidth, ((GridLine)this.objects.elementAt(n2)).getY2() + (this.fontheight - this.linewidth) / 2);
                }
            }
            if (n2 != this.objcnt - 1) continue;
            this.reverse = ((GridLine)this.objects.elementAt(n2)).isSegment();
        }
        for (n2 = 0; n2 < this.pointcnt; ++n2) {
            if (!(this.decimalpoints.elementAt(n2) instanceof DecimalPoint)) continue;
            n = ((DecimalPoint)this.decimalpoints.elementAt(n2)).getD();
            this.backg.setStroke(new BasicStroke(n));
            this.backg.setColor(this.pencolor);
            this.backg.fillOval(this.xstep * ((DecimalPoint)this.decimalpoints.elementAt(n2)).getX() - this.pointsize, this.ystep * (1 + ((DecimalPoint)this.decimalpoints.elementAt(n2)).getY()) - this.pointsize, n, n);
        }
        for (n2 = 1; n2 <= this.ylines; ++n2) {
            for (n = 0; n <= this.xlines; ++n) {
                if (this.Marked[n][n2]) {
                    graphics2D.setColor(this.marked_color);
                    graphics2D.fillRect(n * this.xstep, n2 * this.ystep, this.xstep, this.ystep);
                    this.Marked[n][n2] = false;
                }
                if (!this.Editable[n][n2]) continue;
                if (n2 == 1) {
                    graphics2D.setColor(this.scribling_pencolor);
                } else {
                    graphics2D.setColor(this.pencolor);
                }
                graphics2D.drawString(this.charArray[n][n2], n * this.xstep, (n2 + 1) * this.ystep);
            }
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < this.xsize; n += this.xstep) {
            if (n2 <= n || n2 >= n + this.xstep) continue;
            this.xindex = n2 / this.xstep;
            bl = true;
        }
        for (n = this.ystep; n < this.ysize; n += this.ystep) {
            if (n3 <= n || n3 >= n + this.ystep) continue;
            this.yindex = n3 / this.ystep;
            bl2 = true;
        }
        if (bl && bl2) {
            this.Marked[this.xindex][this.yindex] = true;
            this.repaint();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            --this.yindex;
            if (this.yindex < 1) {
                this.yindex = 1;
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else {
            ++this.yindex;
            if (this.yindex > this.ylines) {
                this.yindex = this.ylines;
            }
            this.Marked[this.xindex][this.yindex] = true;
        }
        this.repaint();
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.xstep;
        int n2 = mouseEvent.getY() / this.ystep;
        if (n >= 0 && n2 >= 1 && n <= this.xlines && n2 <= this.ylines && this.Editable[n][n2]) {
            this.Marked[n][n2] = true;
            this.charArray[n][n2] = "";
            this.deleteDecimalPoint(n, n2);
            this.marked_color = this.deletecolor;
            this.xindex = n;
            this.yindex = n2;
            this.repaint();
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.xstep;
        int n2 = mouseEvent.getY() / this.ystep;
        if (n >= 0 && n2 >= 0 && n <= this.xlines && n2 <= this.ylines && this.Editable[n][n2]) {
            this.xindex = n;
            this.yindex = n2;
            this.Marked[this.xindex][this.yindex] = true;
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < 18; ++i) {
            if (n != this.ForbiddenKeys[i]) continue;
            return;
        }
        this.ProcessKey(n, Character.toString(keyEvent.getKeyChar()));
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void ProcessKey(int n, String string) {
        if (n == 46 || n == 44) {
            if (this.Editable[this.xindex][this.yindex]) {
                if (this.reverse) {
                    this.drawPoint(this.xindex + 1, this.yindex, this.pointsize, true);
                } else {
                    this.drawPoint(this.xindex, this.yindex, this.pointsize, true);
                }
                this.Marked[this.xindex][this.yindex] = true;
            }
        } else if (n == 32) {
            ++this.xindex;
            if (this.xindex > this.xlines - 1) {
                this.xindex = 0;
                ++this.yindex;
                if (this.yindex > this.ylines) {
                    this.yindex = this.ylines;
                }
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 10) {
            int[] nArray = this.findLastWordLength();
            ++this.yindex;
            this.xindex = this.reverse && !this.left_to_right ? nArray[2] : nArray[1];
            if (this.yindex > this.ylines) {
                this.yindex = this.ylines;
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 37) {
            --this.xindex;
            if (this.xindex < 0) {
                this.xindex = this.xlines;
                --this.yindex;
                if (this.yindex < 1) {
                    this.yindex = 1;
                }
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 39) {
            ++this.xindex;
            if (this.xindex > this.xlines - 1) {
                this.xindex = 0;
                ++this.yindex;
                if (this.yindex > this.ylines) {
                    this.yindex = this.ylines;
                }
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 36) {
            this.yindex = 1;
            this.xindex = 1;
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 35) {
            this.yindex = this.ylines;
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 38 || n == 33) {
            --this.yindex;
            if (this.yindex < 1) {
                this.yindex = 1;
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 40 || n == 34) {
            ++this.yindex;
            if (this.yindex > this.ylines) {
                this.yindex = this.ylines;
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 8 && this.Editable[this.xindex][this.yindex]) {
            this.charArray[this.xindex][this.yindex] = "";
            this.deleteDecimalPoint(this.xindex, this.yindex);
            --this.xindex;
            if (this.xindex < 0) {
                this.xindex = this.xlines - 1;
                --this.yindex;
                if (this.yindex < 1) {
                    this.yindex = 1;
                }
            }
            this.Marked[this.xindex][this.yindex] = true;
        } else if (n == 127 && this.Editable[this.xindex][this.yindex]) {
            this.charArray[this.xindex][this.yindex] = "";
            this.Marked[this.xindex][this.yindex] = true;
            this.deleteDecimalPoint(this.xindex, this.yindex);
        } else if (this.Editable[this.xindex][this.yindex]) {
            this.charArray[this.xindex][this.yindex] = string;
            if (this.reverse && !this.left_to_right) {
                if (this.xindex < this.xlines) {
                    --this.xindex;
                    if (this.xindex < 0) {
                        int[] nArray = this.findLastWordLength();
                        this.xindex = nArray[2];
                        ++this.yindex;
                        if (this.yindex > this.ylines) {
                            this.yindex = this.ylines;
                        }
                    }
                }
            } else if (this.xindex < this.xlines) {
                ++this.xindex;
                if (this.xindex >= this.xlines) {
                    int[] nArray = this.findLastWordLength();
                    this.xindex = nArray[1];
                    ++this.yindex;
                    if (this.yindex > this.ylines) {
                        this.yindex = this.ylines;
                    }
                }
            }
            this.Marked[this.xindex][this.yindex] = true;
        }
        this.marked_color = this.markcolor;
    }

    public void Clear() {
        for (int i = 0; i < this.xlines + 1; ++i) {
            for (int j = 0; j < this.ylines + 1; ++j) {
                if (!this.Editable[i][j]) continue;
                this.charArray[i][j] = "";
                this.Marked[i][j] = false;
            }
        }
        this.repaint();
    }

    public int[] findLastWordLength() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[4];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.ylines; ++n3) {
            int n6 = 0;
            for (n2 = 0; n2 < this.xlines; ++n2) {
                if (this.charArray[n2][n3] == "") continue;
                ++n6;
            }
            if (n6 <= 0) continue;
            n4 = n3;
            if (n6 <= n5) continue;
            n5 = n6;
        }
        n3 = 0;
        n2 = this.xlines;
        for (n = 0; n < this.xlines; ++n) {
            if (this.charArray[n][n4] == "") continue;
            n3 = n;
            n = this.xlines;
        }
        for (n = this.xlines - 1; n >= 0; --n) {
            if (this.charArray[n][n4] == "") continue;
            n2 = n;
            n = -1;
        }
        nArray[0] = n4;
        nArray[1] = n3;
        nArray[2] = n2;
        nArray[3] = n5;
        return nArray;
    }

    public String replace(String string, String string2, String string3) {
        if (string != null && string2.length() != 0) {
            int n = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            return stringBuffer.toString();
        }
        return "";
    }

    public void deleteAllLines() {
        int n;
        for (int i = n = this.objcnt - 1; i >= 0; --i) {
            if (!this.EditableObject[i]) continue;
            this.objects.removeElementAt(i);
            --this.objcnt;
        }
        this.repaint();
    }

    public void deleteLine() {
        if (this.objcnt <= 0) {
            this.objcnt = 0;
            return;
        }
        if (this.EditableObject[this.objcnt - 1]) {
            try {
                --this.objcnt;
                this.objects.removeElementAt(this.objcnt);
                this.repaint();
            }
            catch (Exception exception) {
                System.out.println("can not remove line ... objcnt = " + this.objcnt + "\nerror : " + exception);
            }
        }
    }

    public void deleteAllPoints() {
        int n;
        for (int i = n = this.pointcnt - 1; i >= 0; --i) {
            if (!((DecimalPoint)this.decimalpoints.elementAt(i)).getEditable()) continue;
            this.decimalpoints.removeElementAt(i);
            --this.pointcnt;
        }
        this.repaint();
    }

    public int findPoint(int n) {
        for (int i = 0; i < this.pointcnt; ++i) {
            if ((DecimalPoint)this.decimalpoints.elementAt(i) == null || ((DecimalPoint)this.decimalpoints.elementAt(i)).getY() != n) continue;
            return ((DecimalPoint)this.decimalpoints.elementAt(i)).getX();
        }
        return -1;
    }

    public void deleteDecimalPoint(int n, int n2) {
        for (int i = 0; i < this.pointcnt; ++i) {
            if (((DecimalPoint)this.decimalpoints.elementAt(i)).getX() != n || ((DecimalPoint)this.decimalpoints.elementAt(i)).getY() != n2 || !((DecimalPoint)this.decimalpoints.elementAt(i)).getEditable()) continue;
            try {
                this.decimalpoints.removeElementAt(i);
                --this.pointcnt;
                this.repaint();
                return;
            }
            catch (Exception exception) {
                System.out.println("poincnt " + this.pointcnt + "\terror=" + exception);
            }
        }
    }

    public void destroy() {
    }

    public void start() {
    }

    public void drawPoint(int n, int n2, int n3, boolean bl) {
        try {
            this.decimalpoints.add(new DecimalPoint(n, n2, n3, bl));
            ++this.pointcnt;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4, Color color, String string, boolean bl, boolean bl2) {
        try {
            this.objects.add(new GridLine(n, n2, n3, n4, color, string, bl, bl2));
            ++this.objcnt;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.clear_all)) {
            this.Clear();
            this.deleteAllLines();
            this.deleteAllPoints();
        } else if (string.equals(this.line_plus)) {
            int[] nArray = this.findLastWordLength();
            if (nArray[0] > 1) {
                this.drawLine(nArray[1] * this.xstep, (nArray[0] + 1) * this.ystep, (nArray[2] + 1) * this.xstep, (nArray[0] + 1) * this.ystep, this.linecolor, "+", true, true);
            }
        } else if (string.equals(this.line_min)) {
            int[] nArray = this.findLastWordLength();
            if (nArray[0] > 1) {
                this.drawLine(nArray[1] * this.xstep, (nArray[0] + 1) * this.ystep, (nArray[2] + 1) * this.xstep, (nArray[0] + 1) * this.ystep, this.linecolor, "-", true, true);
            }
        } else if (string.equals(this.line_div)) {
            int[] nArray = this.findLastWordLength();
            if (nArray[0] > 1) {
                this.drawLine(nArray[1] * this.xstep, (nArray[0] + 1) * this.ystep, (nArray[2] + 1) * this.xstep, (nArray[0] + 1) * this.ystep, this.linecolor, "\u00f7", true, true);
            }
        } else if (string.equals(this.line_times)) {
            int[] nArray = this.findLastWordLength();
            if (nArray[0] > 1) {
                this.drawLine(nArray[1] * this.xstep, (nArray[0] + 1) * this.ystep, (nArray[2] + 1) * this.xstep, (nArray[0] + 1) * this.ystep, this.linecolor, "\u00d7", true, true);
            }
        } else if (string.equals(this.delete_line)) {
            this.deleteLine();
        }
        this.repaint();
    }

    public void getButtons() {
        String string = this.getParameter("buttons");
        Panel panel = string != null && string.length() > 0 ? this.InvulGridPanel(string) : this.InvulGridPanel("none");
        this.cp = this.getContentPane();
        this.cp.add(panel);
    }

    public Panel InvulGridPanel(String string) {
        Button button;
        Panel panel = new Panel();
        this.setLayout(new FlowLayout());
        if (!string.equals("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            String string2 = "";
            String string3 = "";
            for (int i = 0; i < n; ++i) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("+")) {
                    string3 = this.line_plus;
                } else if (string2.equals("-")) {
                    string3 = this.line_min;
                } else if (string2.equals(":")) {
                    string3 = this.line_div;
                } else if (string2.equals("x")) {
                    string3 = this.line_times;
                }
                button = new Button(string3);
                button.addActionListener(this);
                this.add(button);
            }
            button = new Button(this.delete_line);
            button.addActionListener(this);
            this.add(button);
        }
        button = new Button(this.clear_all);
        button.addActionListener(this);
        this.add(button);
        return panel;
    }

    public static void main(String[] stringArray) {
        InvulGrid.run(new InvulGrid(), 300, 300);
    }

    public static void run(JApplet jApplet, int n, int n2) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jApplet);
        jApplet.init();
        jApplet.start();
        jFrame.setVisible(true);
    }
}

