/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.model;

import fr.ove.openmath.jome.ctrl.linear.LinearParser;
import fr.ove.openmath.jome.ctrl.linear.events.LinearParserEvent;
import fr.ove.openmath.jome.ctrl.linear.events.LinearParserListener;
import fr.ove.openmath.jome.model.FormulaTreeStructure;
import fr.ove.openmath.jome.model.KaryOperator;
import fr.ove.openmath.jome.model.NaryOperator2;
import fr.ove.openmath.jome.model.events.ModelEvent;
import fr.ove.openmath.jome.model.processor.Processor;
import fr.ove.utils.Factory;
import java.util.Stack;

public class Formula
extends FormulaTreeStructure
implements LinearParserListener {
    public FormulaTreeStructure current;
    private Stack openingStack = new Stack();
    private boolean doProcessing = false;
    private Processor processor = null;

    public Formula() {
        this.setResourceIdentifier("FORMULA");
        this.setAsOperatorPriority(resourcesManager.getAsOperatorPriority("formulaPriorities"));
        this.setAsOperandPriority(resourcesManager.getAsOperandPriority("formulaPriorities"));
        this.current = this;
    }

    public boolean isOperator() {
        return false;
    }

    public FormulaTreeStructure insert(FormulaTreeStructure formulaTreeStructure) {
        return null;
    }

    public String createLinear(String string) {
        if (this.getNbChildren() > 0) {
            string = ((FormulaTreeStructure)this.getChild(0)).createLinear(string);
        }
        return string;
    }

    public void clear() {
        this.removeAll();
        this.current = this;
    }

    public String getLinear() {
        return this.createLinear("");
    }

    public String evaluate() {
        if (this.getNbChildren() > 0) {
            return ((FormulaTreeStructure)this.getChild(0)).evaluate();
        }
        return "";
    }

    public void consumeLinearParserEvent(LinearParserEvent linearParserEvent) {
        int n = linearParserEvent.getIdentifier();
        String string = linearParserEvent.getValue();
        switch (n) {
            case 26: {
                this.clear();
                this.openingStack.setSize(0);
                ModelEvent modelEvent = new ModelEvent(this);
                modelEvent.setAction(6, null);
                this.fireModelEvent(modelEvent);
                break;
            }
            case 27: {
                if (this.doProcessing && this.processor != null) {
                    this.processor.init();
                    this.processor.doProcess();
                }
                ModelEvent modelEvent = new ModelEvent(this);
                modelEvent.setAction(10, null);
                this.fireModelEvent(modelEvent);
                break;
            }
            default: {
                Integer n2;
                Object object;
                String string2 = linearParserEvent.getIdentifierAsString();
                String string3 = resourcesManager.getClassName(string2);
                FormulaTreeStructure formulaTreeStructure = null;
                if (string3.equals("null")) {
                    if (n == 16) {
                        this.current = this.current.goTo(resourcesManager.getAsOperatorPriority("slotPriorities"));
                        NaryOperator2 naryOperator2 = (NaryOperator2)this.current.getFather();
                        this.current = naryOperator2.addElement();
                        break;
                    }
                    if (this.openingStack.isEmpty()) break;
                    this.current = (FormulaTreeStructure)this.openingStack.pop();
                    this.current = (FormulaTreeStructure)this.current.getFather();
                    break;
                }
                if (string3.equals("refine")) {
                    object = resourcesManager.getResourceStrings(string);
                    string2 = ((String[])object).length != 0 ? string : (n == 23 ? "VARIABLE" : "defaultFunction");
                }
                formulaTreeStructure = (FormulaTreeStructure)Factory.getClassInstance(resourcesManager.getClassName(string2));
                formulaTreeStructure.setResourceIdentifier(string2);
                object = resourcesManager.getPrioritiesIdentifier(string2);
                formulaTreeStructure.setAsOperatorPriority(resourcesManager.getAsOperatorPriority((String)object));
                formulaTreeStructure.setAsOperandPriority(resourcesManager.getAsOperandPriority((String)object));
                if (string != null) {
                    formulaTreeStructure.setValue(string);
                }
                if ((n2 = resourcesManager.getArity(string2)) != null) {
                    ((KaryOperator)formulaTreeStructure).setOperatorArity(n2);
                }
                switch (n) {
                    case 15: 
                    case 17: 
                    case 19: 
                    case 21: {
                        this.openingStack.push(formulaTreeStructure);
                    }
                }
                this.current = formulaTreeStructure.insert(this.current);
            }
        }
    }

    public void setDoProcessing(boolean bl) {
        this.doProcessing = bl;
    }

    public boolean getDoProcessing() {
        return this.doProcessing;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void doProcess() {
        if (this.doProcessing && this.processor != null) {
            this.processor.doProcess();
        }
    }

    public static void main(String[] stringArray) {
        String string = "sum(i^n,0,sum(i^n,0,5))t";
        Formula formula = new Formula();
        LinearParser linearParser = new LinearParser();
        linearParser.addLinearParserListener(formula);
        linearParser.parse(string);
        System.out.println("la formule saisie est : \t\t" + string);
        System.out.println("la formule construite est : \t\t" + formula.getLinear());
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

