/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.web3d.vrml.export.compressors.FieldCompressor;
import org.web3d.vrml.export.compressors.FieldDecompressor;

public class BinaryFieldEncoder
implements FieldCompressor,
FieldDecompressor {
    private int len;

    public boolean canSupport(int n, int n2) {
        return true;
    }

    public int nextLength(DataInputStream dataInputStream) throws IOException {
        this.len = dataInputStream.readInt();
        return this.len;
    }

    public void compress(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        dataOutputStream.writeInt(n2);
    }

    public void compress(DataOutputStream dataOutputStream, int n, int[] nArray) throws IOException {
        dataOutputStream.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutputStream.writeInt(nArray[i]);
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
    }

    public void compress(DataOutputStream dataOutputStream, int n, boolean[] blArray) throws IOException {
        dataOutputStream.writeInt(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            dataOutputStream.writeBoolean(blArray[i]);
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, float f) throws IOException {
        dataOutputStream.writeFloat(f);
    }

    public void compress(DataOutputStream dataOutputStream, int n, float[] fArray) throws IOException {
        switch (n) {
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 6: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: {
                dataOutputStream.writeInt(fArray.length);
                break;
            }
            default: {
                System.out.println("Unhandled datatype in compress float[]: " + n);
            }
        }
        for (int i = 0; i < fArray.length; ++i) {
            dataOutputStream.writeFloat(fArray[i]);
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, float[][] fArray) throws IOException {
        dataOutputStream.writeInt(fArray.length * fArray[0].length);
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                dataOutputStream.writeFloat(fArray[i][j]);
            }
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, long l) throws IOException {
        dataOutputStream.writeLong(l);
    }

    public void compress(DataOutputStream dataOutputStream, int n, long[] lArray) throws IOException {
        dataOutputStream.writeInt(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            dataOutputStream.writeLong(lArray[i]);
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, double d) throws IOException {
        dataOutputStream.writeDouble(d);
    }

    public void compress(DataOutputStream dataOutputStream, int n, double[] dArray) throws IOException {
        dataOutputStream.writeInt(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            dataOutputStream.writeDouble(dArray[i]);
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, double[][] dArray) throws IOException {
        dataOutputStream.writeInt(dArray.length * dArray[0].length);
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dataOutputStream.writeDouble(dArray[i][j]);
            }
        }
    }

    public void compress(DataOutputStream dataOutputStream, int n, String string) throws IOException {
        dataOutputStream.writeUTF(string);
    }

    public void compress(DataOutputStream dataOutputStream, int n, String[] stringArray) throws IOException {
        dataOutputStream.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            dataOutputStream.writeUTF(stringArray[i]);
        }
    }

    public int decompressInt(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readInt();
    }

    public void decompressInt(DataInputStream dataInputStream, int n, int[] nArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
    }

    public boolean decompressBoolean(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readBoolean();
    }

    public void decompressBoolean(DataInputStream dataInputStream, int n, boolean[] blArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
    }

    public float decompressFloat(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readFloat();
    }

    public void decompressFloat(DataInputStream dataInputStream, int n, float[] fArray) throws IOException {
        switch (n) {
            case 15: 
            case 21: {
                this.len = 3;
                break;
            }
            case 19: 
            case 23: {
                this.len = 4;
                break;
            }
            case 13: {
                this.len = 2;
                break;
            }
            case 6: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            default: {
                System.out.println("Unhandled datatype in compress float[]: " + n);
            }
        }
        for (int i = 0; i < this.len; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
    }

    public void decompressFloat(DataInputStream dataInputStream, int n, float[][] fArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            fArray[0][i] = dataInputStream.readFloat();
        }
    }

    public long decompressLong(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readLong();
    }

    public void decompressLong(DataInputStream dataInputStream, int n, long[] lArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
    }

    public double decompressDouble(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readDouble();
    }

    public void decompressDouble(DataInputStream dataInputStream, int n, double[] dArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
    }

    public void decompressDouble(DataInputStream dataInputStream, int n, double[][] dArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            dArray[0][i] = dataInputStream.readDouble();
        }
    }

    public String decompressString(DataInputStream dataInputStream, int n) throws IOException {
        return dataInputStream.readUTF();
    }

    public void decompressString(DataInputStream dataInputStream, int n, String[] stringArray) throws IOException {
        for (int i = 0; i < this.len; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
    }
}

