/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rfb.Exception;
import rfb.PixelFormat;

public class PixelBuffer {
    public byte[] data;
    protected PixelFormat format;
    protected int width_;
    protected int height_;

    public PixelBuffer() {
        this.setPF(new PixelFormat());
    }

    public void setPF(PixelFormat pf) {
        if (pf.bpp != 8) {
            throw new Exception("Internal error: bpp must be 8 in PixelBuffer");
        }
        this.format = pf;
    }

    public PixelFormat getPF() {
        return this.format;
    }

    public final int width() {
        return this.width_;
    }

    public final int height() {
        return this.height_;
    }

    public final int area() {
        return this.width_ * this.height_;
    }

    public int getStride() {
        return this.width_;
    }

    public void fillRect(int x, int y, int w, int h, int pix) {
        int bytesPerPixel = this.getPF().bpp / 8;
        int bytesPerRow = bytesPerPixel * this.getStride();
        int ry = y;
        while (ry < y + h) {
            int rx = x;
            while (rx < x + w) {
                this.data[ry * bytesPerRow + rx] = (byte)pix;
                ++rx;
            }
            ++ry;
        }
    }

    public void imageRect(int x, int y, int w, int h, byte[] pix, int offset) {
        int bytesPerPixel = this.getPF().bpp / 8;
        int bytesPerDestRow = bytesPerPixel * this.getStride();
        int j = 0;
        while (j < h) {
            System.arraycopy(pix, offset + j * w, this.data, (y + j) * bytesPerDestRow + x, w);
            ++j;
        }
    }

    public void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        int dest = x + y * this.getStride();
        int src = srcX + srcY * this.getStride();
        int inc = this.getStride();
        if (y > srcY) {
            src += (h - 1) * inc;
            dest += (h - 1) * inc;
            inc = -inc;
        }
        int destEnd = dest + h * inc;
        while (dest != destEnd) {
            System.arraycopy(this.data, src, this.data, dest, w);
            src += inc;
            dest += inc;
        }
    }

    public void maskRect(int x, int y, int w, int h, byte[] pix, byte[] mask) {
        int maskBytesPerRow = (w + 7) / 8;
        int stride = this.getStride();
        int j = 0;
        while (j < h) {
            int cy = y + j;
            if (cy >= 0 && cy < this.height_) {
                int i = 0;
                while (i < w) {
                    int bit;
                    int byte_;
                    int cx = x + i;
                    if (cx >= 0 && cx < this.width_ && (mask[byte_ = j * maskBytesPerRow + i / 8] & 1 << (bit = 7 - i % 8)) != 0) {
                        this.data[cy * stride + cx] = pix[j * w + i];
                    }
                    ++i;
                }
            }
            ++j;
        }
    }
}

