# TensorFlow Lite converter

The TensorFlow Lite converter is used to convert TensorFlow models into an
optimized [FlatBuffer](https://google.github.io/flatbuffers/) format, so that
they can be used by the TensorFlow Lite interpreter.

Note: This page contains documentation on the converter API for TensorFlow 1.x.
The API for TensorFlow 2.0 is available
[here](https://www.tensorflow.org/lite/r2/convert/).

## FlatBuffers

FlatBuffer is an efficient open-source cross-platform serialization library. It
is similar to
[protocol buffers](https://developers.google.com/protocol-buffers), with the
distinction that FlatBuffers do not need a parsing/unpacking step to a secondary
representation before data can be accessed, avoiding per-object memory
allocation. The code footprint of FlatBuffers is an order of magnitude smaller
than protocol buffers.

## From model training to device deployment

The TensorFlow Lite converter generates a TensorFlow Lite
[FlatBuffer](https://google.github.io/flatbuffers/) file (`.tflite`) from a
TensorFlow model.

The converter supports the following input formats:

*   [SavedModels](https://www.tensorflow.org/guide/saved_model#using_savedmodel_with_estimators)
*   Frozen `GraphDef`: Models generated by
    [freeze_graph.py](https://www.tensorflow.org/code/tensorflow/python/tools/freeze_graph.py).
*   `tf.keras` HDF5 models.
*   Any model taken from a `tf.Session` (Python API only).

The TensorFlow Lite `FlatBuffer` file is then deployed to a client device, and
the TensorFlow Lite interpreter uses the compressed model for on-device
inference. This conversion process is shown in the diagram below:

![TFLite converter workflow](../images/convert/workflow.svg)

## Options

The TensorFlow Lite Converter can be used from either of these two options:

*   [Python](python_api.md) (**Preferred**): Using the Python API makes it
    easier to convert models as part of a model development pipeline, and helps
    mitigate [compatibility](../tf_ops_compatibility.md) issues early on.
*   [Command line](cmdline_examples.md)
