struct stbl;

struct ssym {
	uint8_t csm;		/* bits consumed */
	uint8_t	chr;		/* character */
	struct stbl *nxt;	/* next table */
};

struct stbl {
	int msk;
	struct ssym *syms;
};

static struct ssym byte3_pref0110_array[] = {
	/* idx   0 */ {1, 199, NULL},
	/* idx   1 */ {1, 207, NULL},
};

static struct stbl byte3_pref0110 = {
	1,
	byte3_pref0110_array
};

static struct ssym byte3_pref0111_array[] = {
	/* idx   0 */ {1, 234, NULL},
	/* idx   1 */ {1, 235, NULL},
};

static struct stbl byte3_pref0111 = {
	1,
	byte3_pref0111_array
};

static struct ssym byte3_pref1000_array[] = {
	/* idx   0 */ {2, 192, NULL},
	/* idx   1 */ {2, 193, NULL},
	/* idx   2 */ {2, 200, NULL},
	/* idx   3 */ {2, 201, NULL},
};

static struct stbl byte3_pref1000 = {
	2,
	byte3_pref1000_array
};

static struct ssym byte3_pref1001_array[] = {
	/* idx   0 */ {2, 202, NULL},
	/* idx   1 */ {2, 205, NULL},
	/* idx   2 */ {2, 210, NULL},
	/* idx   3 */ {2, 213, NULL},
};

static struct stbl byte3_pref1001 = {
	2,
	byte3_pref1001_array
};

static struct ssym byte3_pref1010_array[] = {
	/* idx   0 */ {2, 218, NULL},
	/* idx   1 */ {2, 219, NULL},
	/* idx   2 */ {2, 238, NULL},
	/* idx   3 */ {2, 240, NULL},
};

static struct stbl byte3_pref1010 = {
	2,
	byte3_pref1010_array
};

static struct ssym byte3_pref1011_array[] = {
	/* idx   0 */ {2, 242, NULL},
	/* idx   1 */ {2, 242, NULL},
	/* idx   2 */ {2, 243, NULL},
	/* idx   3 */ {2, 243, NULL},
	/* idx   4 */ {2, 255, NULL},
	/* idx   5 */ {2, 255, NULL},
	/* idx   6 */ {3, 203, NULL},
	/* idx   7 */ {3, 204, NULL},
};

static struct stbl byte3_pref1011 = {
	3,
	byte3_pref1011_array
};

static struct ssym byte3_pref1100_array[] = {
	/* idx   0 */ {3, 211, NULL},
	/* idx   1 */ {3, 212, NULL},
	/* idx   2 */ {3, 214, NULL},
	/* idx   3 */ {3, 221, NULL},
	/* idx   4 */ {3, 222, NULL},
	/* idx   5 */ {3, 223, NULL},
	/* idx   6 */ {3, 241, NULL},
	/* idx   7 */ {3, 244, NULL},
};

static struct stbl byte3_pref1100 = {
	3,
	byte3_pref1100_array
};

static struct ssym byte3_pref1101_array[] = {
	/* idx   0 */ {3, 245, NULL},
	/* idx   1 */ {3, 246, NULL},
	/* idx   2 */ {3, 247, NULL},
	/* idx   3 */ {3, 248, NULL},
	/* idx   4 */ {3, 250, NULL},
	/* idx   5 */ {3, 251, NULL},
	/* idx   6 */ {3, 252, NULL},
	/* idx   7 */ {3, 253, NULL},
};

static struct stbl byte3_pref1101 = {
	3,
	byte3_pref1101_array
};

static struct ssym byte3_pref1110_array[] = {
	/* idx   0 */ {3, 254, NULL},
	/* idx   1 */ {3, 254, NULL},
	/* idx   2 */ {4,   2, NULL},
	/* idx   3 */ {4,   3, NULL},
	/* idx   4 */ {4,   4, NULL},
	/* idx   5 */ {4,   5, NULL},
	/* idx   6 */ {4,   6, NULL},
	/* idx   7 */ {4,   7, NULL},
	/* idx   8 */ {4,   8, NULL},
	/* idx   9 */ {4,  11, NULL},
	/* idx  10 */ {4,  12, NULL},
	/* idx  11 */ {4,  14, NULL},
	/* idx  12 */ {4,  15, NULL},
	/* idx  13 */ {4,  16, NULL},
	/* idx  14 */ {4,  17, NULL},
	/* idx  15 */ {4,  18, NULL},
};

static struct stbl byte3_pref1110 = {
	4,
	byte3_pref1110_array
};

static struct ssym byte3_pref1111_array[] = {
	/* idx   0 */ {4,  19, NULL},
	/* idx   1 */ {4,  19, NULL},
	/* idx   2 */ {4,  19, NULL},
	/* idx   3 */ {4,  19, NULL},
	/* idx   4 */ {4,  20, NULL},
	/* idx   5 */ {4,  20, NULL},
	/* idx   6 */ {4,  20, NULL},
	/* idx   7 */ {4,  20, NULL},
	/* idx   8 */ {4,  21, NULL},
	/* idx   9 */ {4,  21, NULL},
	/* idx  10 */ {4,  21, NULL},
	/* idx  11 */ {4,  21, NULL},
	/* idx  12 */ {4,  23, NULL},
	/* idx  13 */ {4,  23, NULL},
	/* idx  14 */ {4,  23, NULL},
	/* idx  15 */ {4,  23, NULL},
	/* idx  16 */ {4,  24, NULL},
	/* idx  17 */ {4,  24, NULL},
	/* idx  18 */ {4,  24, NULL},
	/* idx  19 */ {4,  24, NULL},
	/* idx  20 */ {4,  25, NULL},
	/* idx  21 */ {4,  25, NULL},
	/* idx  22 */ {4,  25, NULL},
	/* idx  23 */ {4,  25, NULL},
	/* idx  24 */ {4,  26, NULL},
	/* idx  25 */ {4,  26, NULL},
	/* idx  26 */ {4,  26, NULL},
	/* idx  27 */ {4,  26, NULL},
	/* idx  28 */ {4,  27, NULL},
	/* idx  29 */ {4,  27, NULL},
	/* idx  30 */ {4,  27, NULL},
	/* idx  31 */ {4,  27, NULL},
	/* idx  32 */ {4,  28, NULL},
	/* idx  33 */ {4,  28, NULL},
	/* idx  34 */ {4,  28, NULL},
	/* idx  35 */ {4,  28, NULL},
	/* idx  36 */ {4,  29, NULL},
	/* idx  37 */ {4,  29, NULL},
	/* idx  38 */ {4,  29, NULL},
	/* idx  39 */ {4,  29, NULL},
	/* idx  40 */ {4,  30, NULL},
	/* idx  41 */ {4,  30, NULL},
	/* idx  42 */ {4,  30, NULL},
	/* idx  43 */ {4,  30, NULL},
	/* idx  44 */ {4,  31, NULL},
	/* idx  45 */ {4,  31, NULL},
	/* idx  46 */ {4,  31, NULL},
	/* idx  47 */ {4,  31, NULL},
	/* idx  48 */ {4, 127, NULL},
	/* idx  49 */ {4, 127, NULL},
	/* idx  50 */ {4, 127, NULL},
	/* idx  51 */ {4, 127, NULL},
	/* idx  52 */ {4, 220, NULL},
	/* idx  53 */ {4, 220, NULL},
	/* idx  54 */ {4, 220, NULL},
	/* idx  55 */ {4, 220, NULL},
	/* idx  56 */ {4, 249, NULL},
	/* idx  57 */ {4, 249, NULL},
	/* idx  58 */ {4, 249, NULL},
	/* idx  59 */ {4, 249, NULL},
	/* idx  60 */ {6,  10, NULL},
	/* idx  61 */ {6,  13, NULL},
	/* idx  62 */ {6,  22, NULL},
	/* idx  63 */ {0,   0, NULL}
};

static struct stbl byte3_pref1111 = {
	6,
	byte3_pref1111_array
};

static struct ssym byte2_pref0_array[] = {
	/* idx   0 */ {3,  92, NULL}, /* '\' */
	/* idx   1 */ {3,  92, NULL}, /* '\' */
	/* idx   2 */ {3,  92, NULL}, /* '\' */
	/* idx   3 */ {3,  92, NULL}, /* '\' */
	/* idx   4 */ {3, 195, NULL}, /* . */
	/* idx   5 */ {3, 195, NULL}, /* . */
	/* idx   6 */ {3, 195, NULL}, /* . */
	/* idx   7 */ {3, 195, NULL}, /* . */
	/* idx   8 */ {3, 208, NULL}, /* . */
	/* idx   9 */ {3, 208, NULL}, /* . */
	/* idx  10 */ {3, 208, NULL}, /* . */
	/* idx  11 */ {3, 208, NULL}, /* . */
	/* idx  12 */ {4, 128, NULL}, /* . */
	/* idx  13 */ {4, 128, NULL}, /* . */
	/* idx  14 */ {4, 130, NULL}, /* . */
	/* idx  15 */ {4, 130, NULL}, /* . */
	/* idx  16 */ {4, 131, NULL}, /* . */
	/* idx  17 */ {4, 131, NULL}, /* . */
	/* idx  18 */ {4, 162, NULL}, /* . */
	/* idx  19 */ {4, 162, NULL}, /* . */
	/* idx  20 */ {4, 184, NULL}, /* . */
	/* idx  21 */ {4, 184, NULL}, /* . */
	/* idx  22 */ {4, 194, NULL}, /* . */
	/* idx  23 */ {4, 194, NULL}, /* . */
	/* idx  24 */ {4, 224, NULL}, /* . */
	/* idx  25 */ {4, 224, NULL}, /* . */
	/* idx  26 */ {4, 226, NULL}, /* . */
	/* idx  27 */ {4, 226, NULL}, /* . */
	/* idx  28 */ {5, 153, NULL}, /* . */
	/* idx  29 */ {5, 161, NULL}, /* . */
	/* idx  30 */ {5, 167, NULL}, /* . */
	/* idx  31 */ {5, 172, NULL} /* . */
};

static struct stbl byte2_pref0 = {
	5,
	byte2_pref0_array
};

static struct ssym byte2_pref1_array[] = {
	/* idx   0 */ {5, 176, NULL}, /* . */
	/* idx   1 */ {5, 176, NULL}, /* . */
	/* idx   2 */ {5, 176, NULL}, /* . */
	/* idx   3 */ {5, 176, NULL}, /* . */
	/* idx   4 */ {5, 176, NULL}, /* . */
	/* idx   5 */ {5, 176, NULL}, /* . */
	/* idx   6 */ {5, 176, NULL}, /* . */
	/* idx   7 */ {5, 176, NULL}, /* . */
	/* idx   8 */ {5, 177, NULL}, /* . */
	/* idx   9 */ {5, 177, NULL}, /* . */
	/* idx  10 */ {5, 177, NULL}, /* . */
	/* idx  11 */ {5, 177, NULL}, /* . */
	/* idx  12 */ {5, 177, NULL}, /* . */
	/* idx  13 */ {5, 177, NULL}, /* . */
	/* idx  14 */ {5, 177, NULL}, /* . */
	/* idx  15 */ {5, 177, NULL}, /* . */
	/* idx  16 */ {5, 179, NULL}, /*  */
	/* idx  17 */ {5, 179, NULL}, /*  */
	/* idx  18 */ {5, 179, NULL}, /*  */
	/* idx  19 */ {5, 179, NULL}, /*  */
	/* idx  20 */ {5, 179, NULL}, /*  */
	/* idx  21 */ {5, 179, NULL}, /*  */
	/* idx  22 */ {5, 179, NULL}, /*  */
	/* idx  23 */ {5, 179, NULL}, /*  */
	/* idx  24 */ {5, 209, NULL}, /* . */
	/* idx  25 */ {5, 209, NULL}, /* . */
	/* idx  26 */ {5, 209, NULL}, /* . */
	/* idx  27 */ {5, 209, NULL}, /* . */
	/* idx  28 */ {5, 209, NULL}, /* . */
	/* idx  29 */ {5, 209, NULL}, /* . */
	/* idx  30 */ {5, 209, NULL}, /* . */
	/* idx  31 */ {5, 209, NULL}, /* . */
	/* idx  32 */ {5, 216, NULL}, /* . */
	/* idx  33 */ {5, 216, NULL}, /* . */
	/* idx  34 */ {5, 216, NULL}, /* . */
	/* idx  35 */ {5, 216, NULL}, /* . */
	/* idx  36 */ {5, 216, NULL}, /* . */
	/* idx  37 */ {5, 216, NULL}, /* . */
	/* idx  38 */ {5, 216, NULL}, /* . */
	/* idx  39 */ {5, 216, NULL}, /* . */
	/* idx  40 */ {5, 217, NULL}, /* . */
	/* idx  41 */ {5, 217, NULL}, /* . */
	/* idx  42 */ {5, 217, NULL}, /* . */
	/* idx  43 */ {5, 217, NULL}, /* . */
	/* idx  44 */ {5, 217, NULL}, /* . */
	/* idx  45 */ {5, 217, NULL}, /* . */
	/* idx  46 */ {5, 217, NULL}, /* . */
	/* idx  47 */ {5, 217, NULL}, /* . */
	/* idx  48 */ {5, 227, NULL}, /* . */
	/* idx  49 */ {5, 227, NULL}, /* . */
	/* idx  50 */ {5, 227, NULL}, /* . */
	/* idx  51 */ {5, 227, NULL}, /* . */
	/* idx  52 */ {5, 227, NULL}, /* . */
	/* idx  53 */ {5, 227, NULL}, /* . */
	/* idx  54 */ {5, 227, NULL}, /* . */
	/* idx  55 */ {5, 227, NULL}, /* . */
	/* idx  56 */ {5, 229, NULL}, /* . */
	/* idx  57 */ {5, 229, NULL}, /* . */
	/* idx  58 */ {5, 229, NULL}, /* . */
	/* idx  59 */ {5, 229, NULL}, /* . */
	/* idx  60 */ {5, 229, NULL}, /* . */
	/* idx  61 */ {5, 229, NULL}, /* . */
	/* idx  62 */ {5, 229, NULL}, /* . */
	/* idx  63 */ {5, 229, NULL}, /* . */
	/* idx  64 */ {5, 230, NULL}, /* . */
	/* idx  65 */ {5, 230, NULL}, /* . */
	/* idx  66 */ {5, 230, NULL}, /* . */
	/* idx  67 */ {5, 230, NULL}, /* . */
	/* idx  68 */ {5, 230, NULL}, /* . */
	/* idx  69 */ {5, 230, NULL}, /* . */
	/* idx  70 */ {5, 230, NULL}, /* . */
	/* idx  71 */ {5, 230, NULL}, /* . */
	/* idx  72 */ {6, 129, NULL}, /* . */
	/* idx  73 */ {6, 129, NULL}, /* . */
	/* idx  74 */ {6, 129, NULL}, /* . */
	/* idx  75 */ {6, 129, NULL}, /* . */
	/* idx  76 */ {6, 132, NULL}, /* . */
	/* idx  77 */ {6, 132, NULL}, /* . */
	/* idx  78 */ {6, 132, NULL}, /* . */
	/* idx  79 */ {6, 132, NULL}, /* . */
	/* idx  80 */ {6, 133, NULL}, /* . */
	/* idx  81 */ {6, 133, NULL}, /* . */
	/* idx  82 */ {6, 133, NULL}, /* . */
	/* idx  83 */ {6, 133, NULL}, /* . */
	/* idx  84 */ {6, 134, NULL}, /* . */
	/* idx  85 */ {6, 134, NULL}, /* . */
	/* idx  86 */ {6, 134, NULL}, /* . */
	/* idx  87 */ {6, 134, NULL}, /* . */
	/* idx  88 */ {6, 136, NULL}, /* . */
	/* idx  89 */ {6, 136, NULL}, /* . */
	/* idx  90 */ {6, 136, NULL}, /* . */
	/* idx  91 */ {6, 136, NULL}, /* . */
	/* idx  92 */ {6, 146, NULL}, /* . */
	/* idx  93 */ {6, 146, NULL}, /* . */
	/* idx  94 */ {6, 146, NULL}, /* . */
	/* idx  95 */ {6, 146, NULL}, /* . */
	/* idx  96 */ {6, 154, NULL}, /* . */
	/* idx  97 */ {6, 154, NULL}, /* . */
	/* idx  98 */ {6, 154, NULL}, /* . */
	/* idx  99 */ {6, 154, NULL}, /* . */
	/* idx 100 */ {6, 156, NULL}, /* . */
	/* idx 101 */ {6, 156, NULL}, /* . */
	/* idx 102 */ {6, 156, NULL}, /* . */
	/* idx 103 */ {6, 156, NULL}, /* . */
	/* idx 104 */ {6, 160, NULL}, /* . */
	/* idx 105 */ {6, 160, NULL}, /* . */
	/* idx 106 */ {6, 160, NULL}, /* . */
	/* idx 107 */ {6, 160, NULL}, /* . */
	/* idx 108 */ {6, 163, NULL}, /* . */
	/* idx 109 */ {6, 163, NULL}, /* . */
	/* idx 110 */ {6, 163, NULL}, /* . */
	/* idx 111 */ {6, 163, NULL}, /* . */
	/* idx 112 */ {6, 164, NULL}, /* . */
	/* idx 113 */ {6, 164, NULL}, /* . */
	/* idx 114 */ {6, 164, NULL}, /* . */
	/* idx 115 */ {6, 164, NULL}, /* . */
	/* idx 116 */ {6, 169, NULL}, /* . */
	/* idx 117 */ {6, 169, NULL}, /* . */
	/* idx 118 */ {6, 169, NULL}, /* . */
	/* idx 119 */ {6, 169, NULL}, /* . */
	/* idx 120 */ {6, 170, NULL}, /* . */
	/* idx 121 */ {6, 170, NULL}, /* . */
	/* idx 122 */ {6, 170, NULL}, /* . */
	/* idx 123 */ {6, 170, NULL}, /* . */
	/* idx 124 */ {6, 173, NULL}, /* . */
	/* idx 125 */ {6, 173, NULL}, /* . */
	/* idx 126 */ {6, 173, NULL}, /* . */
	/* idx 127 */ {6, 173, NULL}, /* . */
	/* idx 128 */ {6, 176, NULL}, /* . */
	/* idx 129 */ {6, 176, NULL}, /* . */
	/* idx 130 */ {6, 176, NULL}, /* . */
	/* idx 131 */ {6, 176, NULL}, /* . */
	/* idx 132 */ {6, 181, NULL}, /* . */
	/* idx 133 */ {6, 181, NULL}, /* . */
	/* idx 134 */ {6, 181, NULL}, /* . */
	/* idx 135 */ {6, 181, NULL}, /* . */
	/* idx 136 */ {6, 185, NULL}, /* . */
	/* idx 137 */ {6, 185, NULL}, /* . */
	/* idx 138 */ {6, 185, NULL}, /* . */
	/* idx 139 */ {6, 185, NULL}, /* . */
	/* idx 140 */ {6, 186, NULL}, /* . */
	/* idx 141 */ {6, 186, NULL}, /* . */
	/* idx 142 */ {6, 186, NULL}, /* . */
	/* idx 143 */ {6, 186, NULL}, /* . */
	/* idx 144 */ {6, 187, NULL}, /* . */
	/* idx 145 */ {6, 187, NULL}, /* . */
	/* idx 146 */ {6, 187, NULL}, /* . */
	/* idx 147 */ {6, 187, NULL}, /* . */
	/* idx 148 */ {6, 189, NULL}, /* . */
	/* idx 149 */ {6, 189, NULL}, /* . */
	/* idx 150 */ {6, 189, NULL}, /* . */
	/* idx 151 */ {6, 189, NULL}, /* . */
	/* idx 152 */ {6, 190, NULL}, /* . */
	/* idx 153 */ {6, 190, NULL}, /* . */
	/* idx 154 */ {6, 190, NULL}, /* . */
	/* idx 155 */ {6, 190, NULL}, /* . */
	/* idx 156 */ {6, 196, NULL}, /* . */
	/* idx 157 */ {6, 196, NULL}, /* . */
	/* idx 158 */ {6, 196, NULL}, /* . */
	/* idx 159 */ {6, 196, NULL}, /* . */
	/* idx 160 */ {6, 198, NULL}, /* . */
	/* idx 161 */ {6, 198, NULL}, /* . */
	/* idx 162 */ {6, 198, NULL}, /* . */
	/* idx 163 */ {6, 198, NULL}, /* . */
	/* idx 164 */ {6, 228, NULL}, /* . */
	/* idx 165 */ {6, 228, NULL}, /* . */
	/* idx 166 */ {6, 228, NULL}, /* . */
	/* idx 167 */ {6, 228, NULL}, /* . */
	/* idx 168 */ {6, 232, NULL}, /* . */
	/* idx 169 */ {6, 232, NULL}, /* . */
	/* idx 170 */ {6, 232, NULL}, /* . */
	/* idx 171 */ {6, 232, NULL}, /* . */
	/* idx 172 */ {6, 233, NULL}, /* . */
	/* idx 173 */ {6, 233, NULL}, /* . */
	/* idx 174 */ {6, 233, NULL}, /* . */
	/* idx 175 */ {6, 233, NULL}, /* . */
	/* idx 176 */ {7,   1, NULL},
	/* idx 177 */ {7,   1, NULL},
	/* idx 178 */ {7, 135, NULL},
	/* idx 179 */ {7, 135, NULL},
	/* idx 180 */ {7, 137, NULL},
	/* idx 181 */ {7, 137, NULL},
	/* idx 182 */ {7, 138, NULL},
	/* idx 183 */ {7, 138, NULL},
	/* idx 184 */ {7, 139, NULL},
	/* idx 185 */ {7, 139, NULL},
	/* idx 186 */ {7, 140, NULL},
	/* idx 187 */ {7, 140, NULL},
	/* idx 188 */ {7, 141, NULL},
	/* idx 189 */ {7, 141, NULL},
	/* idx 190 */ {7, 143, NULL},
	/* idx 191 */ {7, 143, NULL},
	/* idx 192 */ {7, 147, NULL},
	/* idx 193 */ {7, 147, NULL},
	/* idx 194 */ {7, 149, NULL},
	/* idx 195 */ {7, 149, NULL},
	/* idx 196 */ {7, 150, NULL},
	/* idx 197 */ {7, 150, NULL},
	/* idx 198 */ {7, 151, NULL},
	/* idx 199 */ {7, 151, NULL},
	/* idx 200 */ {7, 152, NULL},
	/* idx 201 */ {7, 152, NULL},
	/* idx 202 */ {7, 155, NULL},
	/* idx 203 */ {7, 155, NULL},
	/* idx 204 */ {7, 157, NULL},
	/* idx 205 */ {7, 157, NULL},
	/* idx 206 */ {7, 158, NULL},
	/* idx 207 */ {7, 158, NULL},
	/* idx 208 */ {7, 165, NULL},
	/* idx 209 */ {7, 165, NULL},
	/* idx 210 */ {7, 166, NULL},
	/* idx 211 */ {7, 166, NULL},
	/* idx 212 */ {7, 168, NULL},
	/* idx 213 */ {7, 168, NULL},
	/* idx 214 */ {7, 174, NULL},
	/* idx 215 */ {7, 174, NULL},
	/* idx 216 */ {7, 175, NULL},
	/* idx 217 */ {7, 175, NULL},
	/* idx 218 */ {7, 180, NULL},
	/* idx 219 */ {7, 180, NULL},
	/* idx 220 */ {7, 182, NULL},
	/* idx 221 */ {7, 182, NULL},
	/* idx 222 */ {7, 183, NULL},
	/* idx 223 */ {7, 183, NULL},
	/* idx 224 */ {7, 188, NULL},
	/* idx 225 */ {7, 188, NULL},
	/* idx 226 */ {7, 191, NULL},
	/* idx 227 */ {7, 191, NULL},
	/* idx 228 */ {7, 197, NULL},
	/* idx 229 */ {7, 197, NULL},
	/* idx 230 */ {7, 231, NULL},
	/* idx 231 */ {7, 231, NULL},
	/* idx 232 */ {7, 239, NULL},
	/* idx 233 */ {7, 239, NULL},
	/* idx 234 */ {8,   9, NULL}, /* tab */
	/* idx 235 */ {8, 142, NULL},
	/* idx 236 */ {8, 144, NULL},
	/* idx 237 */ {8, 145, NULL},
	/* idx 238 */ {8, 148, NULL},
	/* idx 239 */ {8, 159, NULL},
	/* idx 240 */ {8, 171, NULL},
	/* idx 241 */ {8, 206, NULL},
	/* idx 242 */ {8, 215, NULL},
	/* idx 243 */ {8, 225, NULL},
	/* idx 244 */ {8, 236, NULL},
	/* idx 245 */ {8, 237, NULL},
	/* idx 246 */ {8,   0, &byte3_pref0110 },
	/* idx 247 */ {8,   0, &byte3_pref0111 },
	/* idx 248 */ {8,   0, &byte3_pref1000 },
	/* idx 249 */ {8,   0, &byte3_pref1001 },
	/* idx 250 */ {8,   0, &byte3_pref1010 },
	/* idx 251 */ {8,   0, &byte3_pref1011 },
	/* idx 252 */ {8,   0, &byte3_pref1100 },
	/* idx 253 */ {8,   0, &byte3_pref1101 },
	/* idx 254 */ {8,   0, &byte3_pref1110 },
	/* idx 255 */ {8,   0, &byte3_pref1111 }
};

static struct stbl byte2_pref1 = {
	8,
	byte2_pref1_array
};

static struct ssym byte1_pref0_array[] = {
	/* idx   0 */ {2, 33, NULL}, /* '!' */
	/* idx   1 */ {2, 34, NULL}, /* '"' */
	/* idx   2 */ {2, 40, NULL}, /* '(' */
	/* idx   3 */ {2, 41, NULL}, /* ')' */
};

static struct stbl byte1_pref0 = {
	2,
	byte1_pref0_array
};

static struct ssym byte1_pref1_array[] = {
	/* idx   0 */ {2,  63, NULL}, /* '?' */
	/* idx   1 */ {2,  63, NULL}, /* '?' */
	/* idx   2 */ {2,  63, NULL}, /* '?' */
	/* idx   3 */ {2,  63, NULL}, /* '?' */
	/* idx   4 */ {2,  63, NULL}, /* '?' */
	/* idx   5 */ {2,  63, NULL}, /* '?' */
	/* idx   6 */ {2,  63, NULL}, /* '?' */
	/* idx   7 */ {2,  63, NULL}, /* '?' */
	/* idx   8 */ {2,  63, NULL}, /* '?' */
	/* idx   9 */ {2,  63, NULL}, /* '?' */
	/* idx  10 */ {2,  63, NULL}, /* '?' */
	/* idx  11 */ {2,  63, NULL}, /* '?' */
	/* idx  12 */ {2,  63, NULL}, /* '?' */
	/* idx  13 */ {2,  63, NULL}, /* '?' */
	/* idx  14 */ {2,  63, NULL}, /* '?' */
	/* idx  15 */ {2,  63, NULL}, /* '?' */
	/* idx  16 */ {2,  63, NULL}, /* '?' */
	/* idx  17 */ {2,  63, NULL}, /* '?' */
	/* idx  18 */ {2,  63, NULL}, /* '?' */
	/* idx  19 */ {2,  63, NULL}, /* '?' */
	/* idx  20 */ {2,  63, NULL}, /* '?' */
	/* idx  21 */ {2,  63, NULL}, /* '?' */
	/* idx  22 */ {2,  63, NULL}, /* '?' */
	/* idx  23 */ {2,  63, NULL}, /* '?' */
	/* idx  24 */ {2,  63, NULL}, /* '?' */
	/* idx  25 */ {2,  63, NULL}, /* '?' */
	/* idx  26 */ {2,  63, NULL}, /* '?' */
	/* idx  27 */ {2,  63, NULL}, /* '?' */
	/* idx  28 */ {2,  63, NULL}, /* '?' */
	/* idx  29 */ {2,  63, NULL}, /* '?' */
	/* idx  30 */ {2,  63, NULL}, /* '?' */
	/* idx  31 */ {2,  63, NULL}, /* '?' */
	/* idx  32 */ {2,  63, NULL}, /* '?' */
	/* idx  33 */ {2,  63, NULL}, /* '?' */
	/* idx  34 */ {2,  63, NULL}, /* '?' */
	/* idx  35 */ {2,  63, NULL}, /* '?' */
	/* idx  36 */ {2,  63, NULL}, /* '?' */
	/* idx  37 */ {2,  63, NULL}, /* '?' */
	/* idx  38 */ {2,  63, NULL}, /* '?' */
	/* idx  39 */ {2,  63, NULL}, /* '?' */
	/* idx  40 */ {2,  63, NULL}, /* '?' */
	/* idx  41 */ {2,  63, NULL}, /* '?' */
	/* idx  42 */ {2,  63, NULL}, /* '?' */
	/* idx  43 */ {2,  63, NULL}, /* '?' */
	/* idx  44 */ {2,  63, NULL}, /* '?' */
	/* idx  45 */ {2,  63, NULL}, /* '?' */
	/* idx  46 */ {2,  63, NULL}, /* '?' */
	/* idx  47 */ {2,  63, NULL}, /* '?' */
	/* idx  48 */ {2,  63, NULL}, /* '?' */
	/* idx  49 */ {2,  63, NULL}, /* '?' */
	/* idx  50 */ {2,  63, NULL}, /* '?' */
	/* idx  51 */ {2,  63, NULL}, /* '?' */
	/* idx  52 */ {2,  63, NULL}, /* '?' */
	/* idx  53 */ {2,  63, NULL}, /* '?' */
	/* idx  54 */ {2,  63, NULL}, /* '?' */
	/* idx  55 */ {2,  63, NULL}, /* '?' */
	/* idx  56 */ {2,  63, NULL}, /* '?' */
	/* idx  57 */ {2,  63, NULL}, /* '?' */
	/* idx  58 */ {2,  63, NULL}, /* '?' */
	/* idx  59 */ {2,  63, NULL}, /* '?' */
	/* idx  60 */ {2,  63, NULL}, /* '?' */
	/* idx  61 */ {2,  63, NULL}, /* '?' */
	/* idx  62 */ {2,  63, NULL}, /* '?' */
	/* idx  63 */ {2,  63, NULL}, /* '?' */
	/* idx  64 */ {3,  39, NULL}, /* ''' */
	/* idx  65 */ {3,  39, NULL}, /* ''' */
	/* idx  66 */ {3,  39, NULL}, /* ''' */
	/* idx  67 */ {3,  39, NULL}, /* ''' */
	/* idx  68 */ {3,  39, NULL}, /* ''' */
	/* idx  69 */ {3,  39, NULL}, /* ''' */
	/* idx  70 */ {3,  39, NULL}, /* ''' */
	/* idx  71 */ {3,  39, NULL}, /* ''' */
	/* idx  72 */ {3,  39, NULL}, /* ''' */
	/* idx  73 */ {3,  39, NULL}, /* ''' */
	/* idx  74 */ {3,  39, NULL}, /* ''' */
	/* idx  75 */ {3,  39, NULL}, /* ''' */
	/* idx  76 */ {3,  39, NULL}, /* ''' */
	/* idx  77 */ {3,  39, NULL}, /* ''' */
	/* idx  78 */ {3,  39, NULL}, /* ''' */
	/* idx  79 */ {3,  39, NULL}, /* ''' */
	/* idx  80 */ {3,  39, NULL}, /* ''' */
	/* idx  81 */ {3,  39, NULL}, /* ''' */
	/* idx  82 */ {3,  39, NULL}, /* ''' */
	/* idx  83 */ {3,  39, NULL}, /* ''' */
	/* idx  84 */ {3,  39, NULL}, /* ''' */
	/* idx  85 */ {3,  39, NULL}, /* ''' */
	/* idx  86 */ {3,  39, NULL}, /* ''' */
	/* idx  87 */ {3,  39, NULL}, /* ''' */
	/* idx  88 */ {3,  39, NULL}, /* ''' */
	/* idx  89 */ {3,  39, NULL}, /* ''' */
	/* idx  90 */ {3,  39, NULL}, /* ''' */
	/* idx  91 */ {3,  39, NULL}, /* ''' */
	/* idx  92 */ {3,  39, NULL}, /* ''' */
	/* idx  93 */ {3,  39, NULL}, /* ''' */
	/* idx  94 */ {3,  39, NULL}, /* ''' */
	/* idx  95 */ {3,  39, NULL}, /* ''' */
	/* idx  96 */ {3,  43, NULL}, /* '+' */
	/* idx  97 */ {3,  43, NULL}, /* '+' */
	/* idx  98 */ {3,  43, NULL}, /* '+' */
	/* idx  99 */ {3,  43, NULL}, /* '+' */
	/* idx 100 */ {3,  43, NULL}, /* '+' */
	/* idx 101 */ {3,  43, NULL}, /* '+' */
	/* idx 102 */ {3,  43, NULL}, /* '+' */
	/* idx 103 */ {3,  43, NULL}, /* '+' */
	/* idx 104 */ {3,  43, NULL}, /* '+' */
	/* idx 105 */ {3,  43, NULL}, /* '+' */
	/* idx 106 */ {3,  43, NULL}, /* '+' */
	/* idx 107 */ {3,  43, NULL}, /* '+' */
	/* idx 108 */ {3,  43, NULL}, /* '+' */
	/* idx 109 */ {3,  43, NULL}, /* '+' */
	/* idx 110 */ {3,  43, NULL}, /* '+' */
	/* idx 111 */ {3,  43, NULL}, /* '+' */
	/* idx 112 */ {3,  43, NULL}, /* '+' */
	/* idx 113 */ {3,  43, NULL}, /* '+' */
	/* idx 114 */ {3,  43, NULL}, /* '+' */
	/* idx 115 */ {3,  43, NULL}, /* '+' */
	/* idx 116 */ {3,  43, NULL}, /* '+' */
	/* idx 117 */ {3,  43, NULL}, /* '+' */
	/* idx 118 */ {3,  43, NULL}, /* '+' */
	/* idx 119 */ {3,  43, NULL}, /* '+' */
	/* idx 120 */ {3,  43, NULL}, /* '+' */
	/* idx 121 */ {3,  43, NULL}, /* '+' */
	/* idx 122 */ {3,  43, NULL}, /* '+' */
	/* idx 123 */ {3,  43, NULL}, /* '+' */
	/* idx 124 */ {3,  43, NULL}, /* '+' */
	/* idx 125 */ {3,  43, NULL}, /* '+' */
	/* idx 126 */ {3,  43, NULL}, /* '+' */
	/* idx 127 */ {3,  43, NULL}, /* '+' */
	/* idx 128 */ {3, 124, NULL}, /* '|' */
	/* idx 129 */ {3, 124, NULL}, /* '|' */
	/* idx 130 */ {3, 124, NULL}, /* '|' */
	/* idx 131 */ {3, 124, NULL}, /* '|' */
	/* idx 132 */ {3, 124, NULL}, /* '|' */
	/* idx 133 */ {3, 124, NULL}, /* '|' */
	/* idx 134 */ {3, 124, NULL}, /* '|' */
	/* idx 135 */ {3, 124, NULL}, /* '|' */
	/* idx 136 */ {3, 124, NULL}, /* '|' */
	/* idx 137 */ {3, 124, NULL}, /* '|' */
	/* idx 138 */ {3, 124, NULL}, /* '|' */
	/* idx 139 */ {3, 124, NULL}, /* '|' */
	/* idx 140 */ {3, 124, NULL}, /* '|' */
	/* idx 141 */ {3, 124, NULL}, /* '|' */
	/* idx 142 */ {3, 124, NULL}, /* '|' */
	/* idx 143 */ {3, 124, NULL}, /* '|' */
	/* idx 144 */ {3, 124, NULL}, /* '|' */
	/* idx 145 */ {3, 124, NULL}, /* '|' */
	/* idx 146 */ {3, 124, NULL}, /* '|' */
	/* idx 147 */ {3, 124, NULL}, /* '|' */
	/* idx 148 */ {3, 124, NULL}, /* '|' */
	/* idx 149 */ {3, 124, NULL}, /* '|' */
	/* idx 150 */ {3, 124, NULL}, /* '|' */
	/* idx 151 */ {3, 124, NULL}, /* '|' */
	/* idx 152 */ {3, 124, NULL}, /* '|' */
	/* idx 153 */ {3, 124, NULL}, /* '|' */
	/* idx 154 */ {3, 124, NULL}, /* '|' */
	/* idx 155 */ {3, 124, NULL}, /* '|' */
	/* idx 156 */ {3, 124, NULL}, /* '|' */
	/* idx 157 */ {3, 124, NULL}, /* '|' */
	/* idx 158 */ {3, 124, NULL}, /* '|' */
	/* idx 159 */ {3, 124, NULL}, /* '|' */
	/* idx 160 */ {4,  35, NULL}, /* '#' */
	/* idx 161 */ {4,  35, NULL}, /* '#' */
	/* idx 162 */ {4,  35, NULL}, /* '#' */
	/* idx 163 */ {4,  35, NULL}, /* '#' */
	/* idx 164 */ {4,  35, NULL}, /* '#' */
	/* idx 165 */ {4,  35, NULL}, /* '#' */
	/* idx 166 */ {4,  35, NULL}, /* '#' */
	/* idx 167 */ {4,  35, NULL}, /* '#' */
	/* idx 168 */ {4,  35, NULL}, /* '#' */
	/* idx 169 */ {4,  35, NULL}, /* '#' */
	/* idx 170 */ {4,  35, NULL}, /* '#' */
	/* idx 171 */ {4,  35, NULL}, /* '#' */
	/* idx 172 */ {4,  35, NULL}, /* '#' */
	/* idx 173 */ {4,  35, NULL}, /* '#' */
	/* idx 174 */ {4,  35, NULL}, /* '#' */
	/* idx 175 */ {4,  35, NULL}, /* '#' */
	/* idx 176 */ {4,  62, NULL}, /* '>' */
	/* idx 177 */ {4,  62, NULL}, /* '>' */
	/* idx 178 */ {4,  62, NULL}, /* '>' */
	/* idx 179 */ {4,  62, NULL}, /* '>' */
	/* idx 180 */ {4,  62, NULL}, /* '>' */
	/* idx 181 */ {4,  62, NULL}, /* '>' */
	/* idx 182 */ {4,  62, NULL}, /* '>' */
	/* idx 183 */ {4,  62, NULL}, /* '>' */
	/* idx 184 */ {4,  62, NULL}, /* '>' */
	/* idx 185 */ {4,  62, NULL}, /* '>' */
	/* idx 186 */ {4,  62, NULL}, /* '>' */
	/* idx 187 */ {4,  62, NULL}, /* '>' */
	/* idx 188 */ {4,  62, NULL}, /* '>' */
	/* idx 189 */ {4,  62, NULL}, /* '>' */
	/* idx 190 */ {4,  62, NULL}, /* '>' */
	/* idx 191 */ {4,  62, NULL}, /* '>' */
	/* idx 192 */ {5,   0, NULL}, /* . */
	/* idx 193 */ {5,   0, NULL}, /* . */
	/* idx 194 */ {5,   0, NULL}, /* . */
	/* idx 195 */ {5,   0, NULL}, /* . */
	/* idx 196 */ {5,   0, NULL}, /* . */
	/* idx 197 */ {5,   0, NULL}, /* . */
	/* idx 198 */ {5,   0, NULL}, /* . */
	/* idx 199 */ {5,   0, NULL}, /* . */
	/* idx 200 */ {5,  36, NULL}, /* $ */
	/* idx 201 */ {5,  36, NULL}, /* $ */
	/* idx 202 */ {5,  36, NULL}, /* $ */
	/* idx 203 */ {5,  36, NULL}, /* $ */
	/* idx 204 */ {5,  36, NULL}, /* $ */
	/* idx 205 */ {5,  36, NULL}, /* $ */
	/* idx 206 */ {5,  36, NULL}, /* $ */
	/* idx 207 */ {5,  36, NULL}, /* $ */
	/* idx 208 */ {5,  64, NULL}, /* '@' */
	/* idx 209 */ {5,  64, NULL}, /* '@' */
	/* idx 210 */ {5,  64, NULL}, /* '@' */
	/* idx 211 */ {5,  64, NULL}, /* '@' */
	/* idx 212 */ {5,  64, NULL}, /* '@' */
	/* idx 213 */ {5,  64, NULL}, /* '@' */
	/* idx 214 */ {5,  64, NULL}, /* '@' */
	/* idx 215 */ {5,  64, NULL}, /* '@' */
	/* idx 216 */ {5,  91, NULL}, /* '[' */
	/* idx 217 */ {5,  91, NULL}, /* '[' */
	/* idx 218 */ {5,  91, NULL}, /* '[' */
	/* idx 219 */ {5,  91, NULL}, /* '[' */
	/* idx 220 */ {5,  91, NULL}, /* '[' */
	/* idx 221 */ {5,  91, NULL}, /* '[' */
	/* idx 222 */ {5,  91, NULL}, /* '[' */
	/* idx 223 */ {5,  91, NULL}, /* '[' */
	/* idx 224 */ {5,  93, NULL}, /* ']' */
	/* idx 225 */ {5,  93, NULL}, /* ']' */
	/* idx 226 */ {5,  93, NULL}, /* ']' */
	/* idx 227 */ {5,  93, NULL}, /* ']' */
	/* idx 228 */ {5,  93, NULL}, /* ']' */
	/* idx 229 */ {5,  93, NULL}, /* ']' */
	/* idx 230 */ {5,  93, NULL}, /* ']' */
	/* idx 231 */ {5,  93, NULL}, /* ']' */
	/* idx 232 */ {5, 126, NULL}, /* '~' */
	/* idx 233 */ {5, 126, NULL}, /* '~' */
	/* idx 234 */ {5, 126, NULL}, /* '~' */
	/* idx 235 */ {5, 126, NULL}, /* '~' */
	/* idx 236 */ {5, 126, NULL}, /* '~' */
	/* idx 237 */ {5, 126, NULL}, /* '~' */
	/* idx 238 */ {5, 126, NULL}, /* '~' */
	/* idx 239 */ {5, 126, NULL}, /* '~' */
	/* idx 240 */ {6,  94, NULL}, /* '^' */
	/* idx 241 */ {6,  94, NULL}, /* '^' */
	/* idx 242 */ {6,  94, NULL}, /* '^' */
	/* idx 243 */ {6,  94, NULL}, /* '^' */
	/* idx 244 */ {6, 125, NULL}, /* '}' */
	/* idx 245 */ {6, 125, NULL}, /* '}' */
	/* idx 246 */ {6, 125, NULL}, /* '}' */
	/* idx 247 */ {6, 125, NULL}, /* '}' */
	/* idx 248 */ {7,  60, NULL}, /* '<' */
	/* idx 249 */ {7,  60, NULL}, /* '<' */
	/* idx 250 */ {7,  96, NULL}, /* '`' */
	/* idx 251 */ {7,  96, NULL}, /* '`' */
	/* idx 252 */ {7, 123, NULL}, /* '{' */
	/* idx 253 */ {7, 123, NULL}, /* '{' */
	/* idx 254 */ {8,   0, &byte2_pref0}, /* escape */
	/* idx 255 */ {8,   0, &byte2_pref1} /* escape */
};

static struct stbl byte1_pref1 = {
	8,
	byte1_pref1_array
};

static struct ssym byte0_array[] = {
	/* idx   0 */ {5,  48, NULL}, /* '0' */
	/* idx   1 */ {5,  48, NULL}, /* '0' */
	/* idx   2 */ {5,  48, NULL}, /* '0' */
	/* idx   3 */ {5,  48, NULL}, /* '0' */
	/* idx   4 */ {5,  48, NULL}, /* '0' */
	/* idx   5 */ {5,  48, NULL}, /* '0' */
	/* idx   6 */ {5,  48, NULL}, /* '0' */
	/* idx   7 */ {5,  48, NULL}, /* '0' */
	/* idx   8 */ {5,  49, NULL}, /* '1' */
	/* idx   9 */ {5,  49, NULL}, /* '1' */
	/* idx  10 */ {5,  49, NULL}, /* '1' */
	/* idx  11 */ {5,  49, NULL}, /* '1' */
	/* idx  12 */ {5,  49, NULL}, /* '1' */
	/* idx  13 */ {5,  49, NULL}, /* '1' */
	/* idx  14 */ {5,  49, NULL}, /* '1' */
	/* idx  15 */ {5,  49, NULL}, /* '1' */
	/* idx  16 */ {5,  50, NULL}, /* '2' */
	/* idx  17 */ {5,  50, NULL}, /* '2' */
	/* idx  18 */ {5,  50, NULL}, /* '2' */
	/* idx  19 */ {5,  50, NULL}, /* '2' */
	/* idx  20 */ {5,  50, NULL}, /* '2' */
	/* idx  21 */ {5,  50, NULL}, /* '2' */
	/* idx  22 */ {5,  50, NULL}, /* '2' */
	/* idx  23 */ {5,  50, NULL}, /* '2' */
	/* idx  24 */ {5,  97, NULL}, /* 'a' */
	/* idx  25 */ {5,  97, NULL}, /* 'a' */
	/* idx  26 */ {5,  97, NULL}, /* 'a' */
	/* idx  27 */ {5,  97, NULL}, /* 'a' */
	/* idx  28 */ {5,  97, NULL}, /* 'a' */
	/* idx  29 */ {5,  97, NULL}, /* 'a' */
	/* idx  30 */ {5,  97, NULL}, /* 'a' */
	/* idx  31 */ {5,  97, NULL}, /* 'a' */
	/* idx  32 */ {5,  99, NULL}, /* 'c' */
	/* idx  33 */ {5,  99, NULL}, /* 'c' */
	/* idx  34 */ {5,  99, NULL}, /* 'c' */
	/* idx  35 */ {5,  99, NULL}, /* 'c' */
	/* idx  36 */ {5,  99, NULL}, /* 'c' */
	/* idx  37 */ {5,  99, NULL}, /* 'c' */
	/* idx  38 */ {5,  99, NULL}, /* 'c' */
	/* idx  39 */ {5,  99, NULL}, /* 'c' */
	/* idx  40 */ {5, 101, NULL}, /* 'e' */
	/* idx  41 */ {5, 101, NULL}, /* 'e' */
	/* idx  42 */ {5, 101, NULL}, /* 'e' */
	/* idx  43 */ {5, 101, NULL}, /* 'e' */
	/* idx  44 */ {5, 101, NULL}, /* 'e' */
	/* idx  45 */ {5, 101, NULL}, /* 'e' */
	/* idx  46 */ {5, 101, NULL}, /* 'e' */
	/* idx  47 */ {5, 101, NULL}, /* 'e' */
	/* idx  48 */ {5, 105, NULL}, /* 'i' */
	/* idx  49 */ {5, 105, NULL}, /* 'i' */
	/* idx  50 */ {5, 105, NULL}, /* 'i' */
	/* idx  51 */ {5, 105, NULL}, /* 'i' */
	/* idx  52 */ {5, 105, NULL}, /* 'i' */
	/* idx  53 */ {5, 105, NULL}, /* 'i' */
	/* idx  54 */ {5, 105, NULL}, /* 'i' */
	/* idx  55 */ {5, 105, NULL}, /* 'i' */
	/* idx  56 */ {5, 111, NULL}, /* 'o' */
	/* idx  57 */ {5, 111, NULL}, /* 'o' */
	/* idx  58 */ {5, 111, NULL}, /* 'o' */
	/* idx  59 */ {5, 111, NULL}, /* 'o' */
	/* idx  60 */ {5, 111, NULL}, /* 'o' */
	/* idx  61 */ {5, 111, NULL}, /* 'o' */
	/* idx  62 */ {5, 111, NULL}, /* 'o' */
	/* idx  63 */ {5, 111, NULL}, /* 'o' */
	/* idx  64 */ {5, 115, NULL}, /* 's' */
	/* idx  65 */ {5, 115, NULL}, /* 's' */
	/* idx  66 */ {5, 115, NULL}, /* 's' */
	/* idx  67 */ {5, 115, NULL}, /* 's' */
	/* idx  68 */ {5, 115, NULL}, /* 's' */
	/* idx  69 */ {5, 115, NULL}, /* 's' */
	/* idx  70 */ {5, 115, NULL}, /* 's' */
	/* idx  71 */ {5, 115, NULL}, /* 's' */
	/* idx  72 */ {5, 116, NULL}, /* 't' */
	/* idx  73 */ {5, 116, NULL}, /* 't' */
	/* idx  74 */ {5, 116, NULL}, /* 't' */
	/* idx  75 */ {5, 116, NULL}, /* 't' */
	/* idx  76 */ {5, 116, NULL}, /* 't' */
	/* idx  77 */ {5, 116, NULL}, /* 't' */
	/* idx  78 */ {5, 116, NULL}, /* 't' */
	/* idx  79 */ {5, 116, NULL}, /* 't' */
	/* idx  80 */ {6,  32, NULL}, /* ' ' */
	/* idx  81 */ {6,  32, NULL}, /* ' ' */
	/* idx  82 */ {6,  32, NULL}, /* ' ' */
	/* idx  83 */ {6,  32, NULL}, /* ' ' */
	/* idx  84 */ {6,  37, NULL}, /* '%' */
	/* idx  85 */ {6,  37, NULL}, /* '%' */
	/* idx  86 */ {6,  37, NULL}, /* '%' */
	/* idx  87 */ {6,  37, NULL}, /* '%' */
	/* idx  88 */ {6,  45, NULL}, /* '-' */
	/* idx  89 */ {6,  45, NULL}, /* '-' */
	/* idx  90 */ {6,  45, NULL}, /* '-' */
	/* idx  91 */ {6,  45, NULL}, /* '-' */
	/* idx  92 */ {6,  46, NULL}, /* '.' */
	/* idx  93 */ {6,  46, NULL}, /* '.' */
	/* idx  94 */ {6,  46, NULL}, /* '.' */
	/* idx  95 */ {6,  46, NULL}, /* '.' */
	/* idx  96 */ {6,  47, NULL}, /* '/' */
	/* idx  97 */ {6,  47, NULL}, /* '/' */
	/* idx  98 */ {6,  47, NULL}, /* '/' */
	/* idx  99 */ {6,  47, NULL}, /* '/' */
	/* idx 100 */ {6,  51, NULL}, /* '3' */
	/* idx 101 */ {6,  51, NULL}, /* '3' */
	/* idx 102 */ {6,  51, NULL}, /* '3' */
	/* idx 103 */ {6,  51, NULL}, /* '3' */
	/* idx 104 */ {6,  52, NULL}, /* '4' */
	/* idx 105 */ {6,  52, NULL}, /* '4' */
	/* idx 106 */ {6,  52, NULL}, /* '4' */
	/* idx 107 */ {6,  52, NULL}, /* '4' */
	/* idx 108 */ {6,  53, NULL}, /* '5' */
	/* idx 109 */ {6,  53, NULL}, /* '5' */
	/* idx 110 */ {6,  53, NULL}, /* '5' */
	/* idx 111 */ {6,  53, NULL}, /* '5' */
	/* idx 112 */ {6,  54, NULL}, /* '6' */
	/* idx 113 */ {6,  54, NULL}, /* '6' */
	/* idx 114 */ {6,  54, NULL}, /* '6' */
	/* idx 115 */ {6,  54, NULL}, /* '6' */
	/* idx 116 */ {6,  55, NULL}, /* '7' */
	/* idx 117 */ {6,  55, NULL}, /* '7' */
	/* idx 118 */ {6,  55, NULL}, /* '7' */
	/* idx 119 */ {6,  55, NULL}, /* '7' */
	/* idx 120 */ {6,  56, NULL}, /* '8' */
	/* idx 121 */ {6,  56, NULL}, /* '8' */
	/* idx 122 */ {6,  56, NULL}, /* '8' */
	/* idx 123 */ {6,  56, NULL}, /* '8' */
	/* idx 124 */ {6,  57, NULL}, /* '9' */
	/* idx 125 */ {6,  57, NULL}, /* '9' */
	/* idx 126 */ {6,  57, NULL}, /* '9' */
	/* idx 127 */ {6,  57, NULL}, /* '9' */
	/* idx 128 */ {6,  61, NULL}, /* '=' */
	/* idx 129 */ {6,  61, NULL}, /* '=' */
	/* idx 130 */ {6,  61, NULL}, /* '=' */
	/* idx 131 */ {6,  61, NULL}, /* '=' */
	/* idx 132 */ {6,  65, NULL}, /* 'A' */
	/* idx 133 */ {6,  65, NULL}, /* 'A' */
	/* idx 134 */ {6,  65, NULL}, /* 'A' */
	/* idx 135 */ {6,  65, NULL}, /* 'A' */
	/* idx 136 */ {6,  95, NULL}, /* '_' */
	/* idx 137 */ {6,  95, NULL}, /* '_' */
	/* idx 138 */ {6,  95, NULL}, /* '_' */
	/* idx 139 */ {6,  95, NULL}, /* '_' */
	/* idx 140 */ {6,  98, NULL}, /* 'b' */
	/* idx 141 */ {6,  98, NULL}, /* 'b' */
	/* idx 142 */ {6,  98, NULL}, /* 'b' */
	/* idx 143 */ {6,  98, NULL}, /* 'b' */
	/* idx 144 */ {6, 100, NULL}, /* 'd' */
	/* idx 145 */ {6, 100, NULL}, /* 'd' */
	/* idx 146 */ {6, 100, NULL}, /* 'd' */
	/* idx 147 */ {6, 100, NULL}, /* 'd' */
	/* idx 148 */ {6, 102, NULL}, /* 'f' */
	/* idx 149 */ {6, 102, NULL}, /* 'f' */
	/* idx 150 */ {6, 102, NULL}, /* 'f' */
	/* idx 151 */ {6, 102, NULL}, /* 'f' */
	/* idx 152 */ {6, 103, NULL}, /* 'g' */
	/* idx 153 */ {6, 103, NULL}, /* 'g' */
	/* idx 154 */ {6, 103, NULL}, /* 'g' */
	/* idx 155 */ {6, 103, NULL}, /* 'g' */
	/* idx 156 */ {6, 104, NULL}, /* 'h' */
	/* idx 157 */ {6, 104, NULL}, /* 'h' */
	/* idx 158 */ {6, 104, NULL}, /* 'h' */
	/* idx 159 */ {6, 104, NULL}, /* 'h' */
	/* idx 160 */ {6, 108, NULL}, /* 'l' */
	/* idx 161 */ {6, 108, NULL}, /* 'l' */
	/* idx 162 */ {6, 108, NULL}, /* 'l' */
	/* idx 163 */ {6, 108, NULL}, /* 'l' */
	/* idx 164 */ {6, 109, NULL}, /* 'm' */
	/* idx 165 */ {6, 109, NULL}, /* 'm' */
	/* idx 166 */ {6, 109, NULL}, /* 'm' */
	/* idx 167 */ {6, 109, NULL}, /* 'm' */
	/* idx 168 */ {6, 110, NULL}, /* 'n' */
	/* idx 169 */ {6, 110, NULL}, /* 'n' */
	/* idx 170 */ {6, 110, NULL}, /* 'n' */
	/* idx 171 */ {6, 110, NULL}, /* 'n' */
	/* idx 172 */ {6, 112, NULL}, /* 'p' */
	/* idx 173 */ {6, 112, NULL}, /* 'p' */
	/* idx 174 */ {6, 112, NULL}, /* 'p' */
	/* idx 175 */ {6, 112, NULL}, /* 'p' */
	/* idx 176 */ {6, 114, NULL}, /* 'r' */
	/* idx 177 */ {6, 114, NULL}, /* 'r' */
	/* idx 178 */ {6, 114, NULL}, /* 'r' */
	/* idx 179 */ {6, 114, NULL}, /* 'r' */
	/* idx 180 */ {6, 117, NULL}, /* 'u' */
	/* idx 181 */ {6, 117, NULL}, /* 'u' */
	/* idx 182 */ {6, 117, NULL}, /* 'u' */
	/* idx 183 */ {6, 117, NULL}, /* 'u' */
	/* idx 184 */ {7,  58, NULL}, /* ':' */
	/* idx 185 */ {7,  58, NULL}, /* ':' */
	/* idx 186 */ {7,  66, NULL}, /* 'B' */
	/* idx 187 */ {7,  66, NULL}, /* 'B' */
	/* idx 188 */ {7,  67, NULL}, /* 'C' */
	/* idx 189 */ {7,  67, NULL}, /* 'C' */
	/* idx 190 */ {7,  68, NULL}, /* 'D' */
	/* idx 191 */ {7,  68, NULL}, /* 'D' */
	/* idx 192 */ {7,  69, NULL}, /* 'E' */
	/* idx 193 */ {7,  69, NULL}, /* 'E' */
	/* idx 194 */ {7,  70, NULL}, /* 'F' */
	/* idx 195 */ {7,  70, NULL}, /* 'F' */
	/* idx 196 */ {7,  71, NULL}, /* 'G' */
	/* idx 197 */ {7,  71, NULL}, /* 'G' */
	/* idx 198 */ {7,  72, NULL}, /* 'H' */
	/* idx 199 */ {7,  72, NULL}, /* 'H' */
	/* idx 200 */ {7,  73, NULL}, /* 'I' */
	/* idx 201 */ {7,  73, NULL}, /* 'I' */
	/* idx 202 */ {7,  74, NULL}, /* 'J' */
	/* idx 203 */ {7,  74, NULL}, /* 'J' */
	/* idx 204 */ {7,  75, NULL}, /* 'K' */
	/* idx 205 */ {7,  75, NULL}, /* 'K' */
	/* idx 206 */ {7,  76, NULL}, /* 'L' */
	/* idx 207 */ {7,  76, NULL}, /* 'L' */
	/* idx 208 */ {7,  77, NULL}, /* 'M' */
	/* idx 209 */ {7,  77, NULL}, /* 'M' */
	/* idx 210 */ {7,  78, NULL}, /* 'N' */
	/* idx 211 */ {7,  78, NULL}, /* 'N' */
	/* idx 212 */ {7,  79, NULL}, /* 'O' */
	/* idx 213 */ {7,  79, NULL}, /* 'O' */
	/* idx 214 */ {7,  80, NULL}, /* 'P' */
	/* idx 215 */ {7,  80, NULL}, /* 'P' */
	/* idx 216 */ {7,  81, NULL}, /* 'Q' */
	/* idx 217 */ {7,  81, NULL}, /* 'Q' */
	/* idx 218 */ {7,  82, NULL}, /* 'R' */
	/* idx 219 */ {7,  82, NULL}, /* 'R' */
	/* idx 220 */ {7,  83, NULL}, /* 'S' */
	/* idx 221 */ {7,  83, NULL}, /* 'S' */
	/* idx 222 */ {7,  84, NULL}, /* 'T' */
	/* idx 223 */ {7,  84, NULL}, /* 'T' */
	/* idx 224 */ {7,  85, NULL}, /* 'U' */
	/* idx 225 */ {7,  85, NULL}, /* 'U' */
	/* idx 226 */ {7,  86, NULL}, /* 'V' */
	/* idx 227 */ {7,  86, NULL}, /* 'V' */
	/* idx 228 */ {7,  87, NULL}, /* 'W' */
	/* idx 229 */ {7,  87, NULL}, /* 'W' */
	/* idx 230 */ {7,  89, NULL}, /* 'Y' */
	/* idx 231 */ {7,  89, NULL}, /* 'Y' */
	/* idx 232 */ {7, 106, NULL}, /* 'j' */
	/* idx 233 */ {7, 106, NULL}, /* 'j' */
	/* idx 234 */ {7, 107, NULL}, /* 'k' */
	/* idx 235 */ {7, 107, NULL}, /* 'k' */
	/* idx 236 */ {7, 113, NULL}, /* 'q' */
	/* idx 237 */ {7, 113, NULL}, /* 'q' */
	/* idx 238 */ {7, 118, NULL}, /* 'v' */
	/* idx 239 */ {7, 118, NULL}, /* 'v' */
	/* idx 240 */ {7, 119, NULL}, /* 'w' */
	/* idx 241 */ {7, 119, NULL}, /* 'w' */
	/* idx 242 */ {7, 120, NULL}, /* 'x' */
	/* idx 243 */ {7, 120, NULL}, /* 'x' */
	/* idx 244 */ {7, 121, NULL}, /* 'y' */
	/* idx 245 */ {7, 121, NULL}, /* 'y' */
	/* idx 246 */ {7, 122, NULL}, /* 'z' */
	/* idx 247 */ {7, 122, NULL}, /* 'z' */
	/* idx 248 */ {8,  38, NULL}, /* '&' */
	/* idx 249 */ {8,  42, NULL}, /* '*' */
	/* idx 250 */ {8,  44, NULL}, /* ',' */
	/* idx 251 */ {8,  59, NULL}, /* ';' */
	/* idx 252 */ {8,  88, NULL}, /* 'X' */
	/* idx 253 */ {8,  90, NULL}, /* 'Z' */
	/* idx 254 */ {8,   0, &byte1_pref0}, /* escape */
	/* idx 255 */ {8,   0, &byte1_pref1} /* escape */
};

static struct stbl byte0 = {
	8,
	byte0_array
};
