/* main.c generated by valac 0.16.0, the Vala compiler
 * generated from main.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    © 2010 Canonical Ltd
    Authors:
      Michael Terry <michael.terry@canonical.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <vala.h>
#include <valagee.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TYPE_VAPI_INFO (vapi_info_get_type ())
#define VAPI_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAPI_INFO, VapiInfo))
#define VAPI_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAPI_INFO, VapiInfoClass))
#define IS_VAPI_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAPI_INFO))
#define IS_VAPI_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAPI_INFO))
#define VAPI_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAPI_INFO, VapiInfoClass))

typedef struct _VapiInfo VapiInfo;
typedef struct _VapiInfoClass VapiInfoClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define TYPE_SYMBOL_CATCHER (symbol_catcher_get_type ())
#define SYMBOL_CATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOL_CATCHER, SymbolCatcher))
#define SYMBOL_CATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOL_CATCHER, SymbolCatcherClass))
#define IS_SYMBOL_CATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOL_CATCHER))
#define IS_SYMBOL_CATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOL_CATCHER))
#define SYMBOL_CATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOL_CATCHER, SymbolCatcherClass))

typedef struct _SymbolCatcher SymbolCatcher;
typedef struct _SymbolCatcherClass SymbolCatcherClass;
typedef struct _SymbolCatcherPrivate SymbolCatcherPrivate;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _VapiInfoPrivate VapiInfoPrivate;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _SymbolCatcher {
	ValaCodeVisitor parent_instance;
	SymbolCatcherPrivate * priv;
	ValaSet* packages;
};

struct _SymbolCatcherClass {
	ValaCodeVisitorClass parent_class;
};

struct _VapiInfo {
	GObject parent_instance;
	VapiInfoPrivate * priv;
};

struct _VapiInfoClass {
	GObjectClass parent_class;
};

struct _VapiInfoPrivate {
	ValaMap* symbols;
	ValaSet* namespaces;
};

struct _SymbolCatcherPrivate {
	ValaCodeContext* ctx;
	VapiInfo* vinfo;
};


extern gchar* mode;
gchar* mode = NULL;
extern gboolean show_version;
gboolean show_version = FALSE;
extern gboolean verbose;
gboolean verbose = FALSE;
extern gchar** forces;
extern gint forces_length1;
gchar** forces = NULL;
gint forces_length1 = 0;
static gint _forces_size_ = 0;
extern gchar** filenames;
extern gint filenames_length1;
gchar** filenames = NULL;
gint filenames_length1 = 0;
static gint _filenames_size_ = 0;
static gpointer vapi_info_parent_class = NULL;
static gpointer symbol_catcher_parent_class = NULL;

gint _vala_main (gchar** args, int args_length1);
VapiInfo* vapi_info_new (void);
VapiInfo* vapi_info_construct (GType object_type);
GType vapi_info_get_type (void) G_GNUC_CONST;
SymbolCatcher* symbol_catcher_new (void);
SymbolCatcher* symbol_catcher_construct (GType object_type);
GType symbol_catcher_get_type (void) G_GNUC_CONST;
void symbol_catcher_catch (SymbolCatcher* self, ValaCodeContext* ctx, VapiInfo* vinfo);
ValaSet* choose_best_pkgs (ValaSet* pkgs);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gint compare_pkgs (const gchar* one, const gchar* two);
#define VAPI_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VAPI_INFO, VapiInfoPrivate))
enum  {
	VAPI_INFO_DUMMY_PROPERTY
};
gboolean vapi_info_is_namespace (VapiInfo* self, const gchar* symbol);
ValaSet* vapi_info_pkgs_for_symbol (VapiInfo* self, const gchar* symbol, ValaSet* usings);
static void vapi_info_get_pkg_list_for_dir (VapiInfo* self, const gchar* vapidir, ValaSet** pkgs, const gchar* suffix);
static ValaSet* vapi_info_get_pkg_list (VapiInfo* self);
static gboolean vapi_info_is_symbol_from_pkg (VapiInfo* self, ValaSymbol* symbol, const gchar* pkg);
static void vapi_info_add_symbol (VapiInfo* self, ValaHashSet* symbols, ValaSymbol* symbol, const gchar* pkg);
static void vapi_info_process_pkg (VapiInfo* self, const gchar* pkg);
static void vapi_info_add_package (VapiInfo* self, ValaCodeContext* ctx, const gchar* pkg);
static GObject * vapi_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vapi_info_finalize (GObject* obj);
#define SYMBOL_CATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SYMBOL_CATCHER, SymbolCatcherPrivate))
enum  {
	SYMBOL_CATCHER_DUMMY_PROPERTY
};
static void symbol_catcher_descend (SymbolCatcher* self, ValaCodeNode* n);
static void symbol_catcher_add_symbol (SymbolCatcher* self, const gchar* name, const gchar* prev, ValaList* usings);
static void symbol_catcher_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type);
static void symbol_catcher_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void symbol_catcher_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void symbol_catcher_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void symbol_catcher_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e);
static void symbol_catcher_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static void symbol_catcher_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void symbol_catcher_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void symbol_catcher_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void symbol_catcher_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void symbol_catcher_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void symbol_catcher_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void symbol_catcher_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void symbol_catcher_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void symbol_catcher_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void symbol_catcher_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void symbol_catcher_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void symbol_catcher_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void symbol_catcher_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void symbol_catcher_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void symbol_catcher_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void symbol_catcher_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void symbol_catcher_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void symbol_catcher_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p);
static void symbol_catcher_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void symbol_catcher_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void symbol_catcher_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void symbol_catcher_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void symbol_catcher_real_visit_list_literal (ValaCodeVisitor* base, ValaListLiteral* lit);
static void symbol_catcher_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void symbol_catcher_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt);
static void symbol_catcher_real_visit_map_literal (ValaCodeVisitor* base, ValaMapLiteral* lit);
static void symbol_catcher_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void symbol_catcher_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
static void symbol_catcher_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void symbol_catcher_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void symbol_catcher_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void symbol_catcher_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void symbol_catcher_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void symbol_catcher_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void symbol_catcher_real_visit_set_literal (ValaCodeVisitor* base, ValaSetLiteral* lit);
static void symbol_catcher_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void symbol_catcher_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr);
static void symbol_catcher_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void symbol_catcher_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label);
static void symbol_catcher_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void symbol_catcher_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void symbol_catcher_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl);
static void symbol_catcher_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void symbol_catcher_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void symbol_catcher_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple);
static void symbol_catcher_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns);
static void symbol_catcher_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void symbol_catcher_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void symbol_catcher_finalize (ValaCodeVisitor* obj);

const GOptionEntry options[6] = {{"mode", (gchar) 0, 0, G_OPTION_ARG_STRING, &mode, "gir (default) or vapi", NULL}, {"verbose", (gchar) 0, 0, G_OPTION_ARG_NONE, &verbose, "Show verbose information", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &show_version, "Show version", NULL}, {"force-pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &forces, "Force the use of certain packages", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &filenames, NULL, NULL}, {NULL}};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GOptionContext* _tmp4_;
	GOptionContext* _tmp5_;
	GOptionContext* context;
	GOptionContext* _tmp6_;
	gboolean _tmp13_;
	const gchar* _tmp15_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp20_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	VapiInfo* _tmp24_;
	VapiInfo* vinfo;
	ValaCodeContext* _tmp25_;
	ValaCodeContext* ctx;
	ValaCodeContext* _tmp26_;
	ValaParser* _tmp40_;
	ValaParser* parser;
	ValaParser* _tmp41_;
	ValaCodeContext* _tmp42_;
	SymbolCatcher* _tmp43_;
	SymbolCatcher* catcher;
	SymbolCatcher* _tmp44_;
	ValaCodeContext* _tmp45_;
	VapiInfo* _tmp46_;
	SymbolCatcher* _tmp47_;
	ValaSet* _tmp48_;
	ValaSet* _tmp49_ = NULL;
	ValaSet* best_pkgs;
	ValaSet* _tmp50_;
	GList* pkg_list;
	GList* _tmp60_;
	GError * _inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = _ ("Vala Dependency Scanner");
	g_set_application_name (_tmp0_);
	_tmp1_ = _ ("FILES");
	_tmp2_ = g_strdup_printf ("[%s]", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_option_context_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	context = _tmp5_;
	_tmp6_ = context;
	g_option_context_add_main_entries (_tmp6_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp7_;
		_tmp7_ = context;
		g_option_context_parse (_tmp7_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GOptionContext* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = context;
		_tmp11_ = g_option_context_get_help (_tmp10_, TRUE, NULL);
		_tmp12_ = _tmp11_;
		g_printerr ("%s\n\n%s", _tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp13_ = show_version;
	if (_tmp13_) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp14_, VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp15_ = mode;
	if (_tmp15_ == NULL) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("vapi");
		_g_free0 (mode);
		mode = _tmp16_;
	}
	_tmp18_ = mode;
	if (g_strcmp0 (_tmp18_, "gir") != 0) {
		const gchar* _tmp19_;
		_tmp19_ = mode;
		_tmp17_ = g_strcmp0 (_tmp19_, "vapi") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp20_ = _tmp17_;
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		_tmp21_ = _ ("Mode must be either gir or vapi");
		g_printerr ("%s\n", _tmp21_);
		result = 1;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp22_ = filenames;
	_tmp22__length1 = filenames_length1;
	if (_tmp22_ == NULL) {
		const gchar* _tmp23_ = NULL;
		_tmp23_ = _ ("No filenames provided");
		g_printerr ("%s\n", _tmp23_);
		result = 1;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp24_ = vapi_info_new ();
	vinfo = _tmp24_;
	_tmp25_ = vala_code_context_new ();
	ctx = _tmp25_;
	_tmp26_ = ctx;
	vala_code_context_push (_tmp26_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp27_;
			_tmp27_ = TRUE;
			while (TRUE) {
				gboolean _tmp28_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				const gchar* _tmp32_;
				ValaCodeContext* _tmp33_;
				gchar** _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_;
				const gchar* _tmp36_;
				ValaSourceFile* _tmp37_;
				ValaSourceFile* file;
				ValaCodeContext* _tmp38_;
				ValaSourceFile* _tmp39_;
				_tmp28_ = _tmp27_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp30_ = filenames;
				_tmp30__length1 = filenames_length1;
				_tmp31_ = i;
				_tmp32_ = _tmp30_[_tmp31_];
				if (!(_tmp32_ != NULL)) {
					break;
				}
				_tmp33_ = ctx;
				_tmp34_ = filenames;
				_tmp34__length1 = filenames_length1;
				_tmp35_ = i;
				_tmp36_ = _tmp34_[_tmp35_];
				_tmp37_ = vala_source_file_new (_tmp33_, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp36_, NULL, TRUE);
				file = _tmp37_;
				_tmp38_ = ctx;
				_tmp39_ = file;
				vala_code_context_add_source_file (_tmp38_, _tmp39_);
				_vala_source_file_unref0 (file);
			}
		}
	}
	_tmp40_ = vala_parser_new ();
	parser = _tmp40_;
	_tmp41_ = parser;
	_tmp42_ = ctx;
	vala_parser_parse (_tmp41_, _tmp42_);
	_tmp43_ = symbol_catcher_new ();
	catcher = _tmp43_;
	_tmp44_ = catcher;
	_tmp45_ = ctx;
	_tmp46_ = vinfo;
	symbol_catcher_catch (_tmp44_, _tmp45_, _tmp46_);
	_tmp47_ = catcher;
	_tmp48_ = _tmp47_->packages;
	_tmp49_ = choose_best_pkgs (_tmp48_);
	best_pkgs = _tmp49_;
	_tmp50_ = best_pkgs;
	vala_collection_remove ((ValaCollection*) _tmp50_, "glib-2.0");
	pkg_list = NULL;
	{
		ValaSet* _tmp51_;
		ValaIterator* _tmp52_ = NULL;
		ValaIterator* _p_it;
		_tmp51_ = best_pkgs;
		_tmp52_ = vala_iterable_iterator ((ValaIterable*) _tmp51_);
		_p_it = _tmp52_;
		while (TRUE) {
			ValaIterator* _tmp53_;
			gboolean _tmp54_ = FALSE;
			ValaIterator* _tmp55_;
			gpointer _tmp56_ = NULL;
			gchar* p;
			const gchar* _tmp57_;
			gchar* _tmp58_;
			GCompareFunc _tmp59_;
			_tmp53_ = _p_it;
			_tmp54_ = vala_iterator_next (_tmp53_);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = _p_it;
			_tmp56_ = vala_iterator_get (_tmp55_);
			p = (gchar*) _tmp56_;
			_tmp57_ = p;
			_tmp58_ = g_strdup (_tmp57_);
			_tmp59_ = g_strcmp0;
			pkg_list = g_list_insert_sorted (pkg_list, _tmp58_, _tmp59_);
			_g_free0 (p);
		}
		_vala_iterator_unref0 (_p_it);
	}
	_tmp60_ = pkg_list;
	{
		GList* pkg_collection = NULL;
		GList* pkg_it = NULL;
		pkg_collection = _tmp60_;
		for (pkg_it = pkg_collection; pkg_it != NULL; pkg_it = pkg_it->next) {
			const gchar* pkg = NULL;
			pkg = (const gchar*) pkg_it->data;
			{
				const gchar* _tmp61_;
				_tmp61_ = pkg;
				g_print ("%s\n", _tmp61_);
			}
		}
	}
	result = 0;
	__g_list_free__g_free0_0 (pkg_list);
	_vala_iterable_unref0 (best_pkgs);
	_vala_code_visitor_unref0 (catcher);
	_vala_code_visitor_unref0 (parser);
	_vala_code_context_unref0 (ctx);
	_g_object_unref0 (vinfo);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gint compare_pkgs (const gchar* one, const gchar* two) {
	gint result = 0;
	gint i = 0;
	gchar* suffix1;
	gchar* suffix2;
	const gchar* _tmp18_;
	gint _tmp19_;
	gchar _tmp20_ = '\0';
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	gboolean _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	gboolean _tmp32_;
	const gchar* _tmp33_;
	gdouble _tmp34_ = 0.0;
	gdouble num1;
	const gchar* _tmp35_;
	gdouble _tmp36_ = 0.0;
	gdouble num2;
	gdouble _tmp37_;
	gdouble _tmp38_;
	g_return_val_if_fail (one != NULL, 0);
	g_return_val_if_fail (two != NULL, 0);
	suffix1 = NULL;
	suffix2 = NULL;
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			const gchar* _tmp3_;
			gint _tmp4_;
			gchar _tmp5_ = '\0';
			const gchar* _tmp6_;
			gint _tmp7_;
			gchar _tmp8_ = '\0';
			const gchar* _tmp9_;
			gint _tmp10_;
			gchar _tmp11_ = '\0';
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = one;
			_tmp4_ = i;
			_tmp5_ = string_get (_tmp3_, (glong) _tmp4_);
			if (!(((gint) _tmp5_) != 0)) {
				break;
			}
			_tmp6_ = one;
			_tmp7_ = i;
			_tmp8_ = string_get (_tmp6_, (glong) _tmp7_);
			_tmp9_ = two;
			_tmp10_ = i;
			_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
			if (_tmp8_ != _tmp11_) {
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_ = NULL;
				const gchar* _tmp15_;
				gint _tmp16_;
				gchar* _tmp17_ = NULL;
				_tmp12_ = one;
				_tmp13_ = i;
				_tmp14_ = string_substring (_tmp12_, (glong) _tmp13_, (glong) (-1));
				_g_free0 (suffix1);
				suffix1 = _tmp14_;
				_tmp15_ = two;
				_tmp16_ = i;
				_tmp17_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (-1));
				_g_free0 (suffix2);
				suffix2 = _tmp17_;
				break;
			}
		}
	}
	_tmp18_ = one;
	_tmp19_ = i;
	_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
	if (((gint) _tmp20_) == 0) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	_tmp22_ = suffix1;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		gchar _tmp24_ = '\0';
		gboolean _tmp25_ = FALSE;
		_tmp23_ = suffix1;
		_tmp24_ = string_get (_tmp23_, (glong) 0);
		_tmp25_ = g_ascii_isdigit (_tmp24_);
		_tmp21_ = !_tmp25_;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp26_ = _tmp21_;
	if (_tmp26_) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	_tmp28_ = suffix2;
	if (_tmp28_ != NULL) {
		const gchar* _tmp29_;
		gchar _tmp30_ = '\0';
		gboolean _tmp31_ = FALSE;
		_tmp29_ = suffix2;
		_tmp30_ = string_get (_tmp29_, (glong) 0);
		_tmp31_ = g_ascii_isdigit (_tmp30_);
		_tmp27_ = !_tmp31_;
	} else {
		_tmp27_ = FALSE;
	}
	_tmp32_ = _tmp27_;
	if (_tmp32_) {
		result = 0;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	}
	_tmp33_ = suffix1;
	_tmp34_ = double_parse (_tmp33_);
	num1 = _tmp34_;
	_tmp35_ = suffix2;
	_tmp36_ = double_parse (_tmp35_);
	num2 = _tmp36_;
	_tmp37_ = num1;
	_tmp38_ = num2;
	if (_tmp37_ < _tmp38_) {
		result = -1;
		_g_free0 (suffix2);
		_g_free0 (suffix1);
		return result;
	} else {
		gdouble _tmp39_;
		gdouble _tmp40_;
		_tmp39_ = num1;
		_tmp40_ = num2;
		if (_tmp39_ > _tmp40_) {
			result = 1;
			_g_free0 (suffix2);
			_g_free0 (suffix1);
			return result;
		} else {
			result = 0;
			_g_free0 (suffix2);
			_g_free0 (suffix1);
			return result;
		}
	}
	_g_free0 (suffix2);
	_g_free0 (suffix1);
}


ValaSet* choose_best_pkgs (ValaSet* pkgs) {
	ValaSet* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaHashSet* rv;
	gchar** _tmp25_;
	gint _tmp25__length1;
	g_return_val_if_fail (pkgs != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	rv = _tmp2_;
	{
		ValaSet* _tmp3_;
		ValaIterator* _tmp4_ = NULL;
		ValaIterator* _pkg_it;
		_tmp3_ = pkgs;
		_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
		_pkg_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			ValaIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			gchar* pkg;
			gboolean add;
			gboolean _tmp22_;
			_tmp5_ = _pkg_it;
			_tmp6_ = vala_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _pkg_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			pkg = (gchar*) _tmp8_;
			add = TRUE;
			{
				ValaHashSet* _tmp9_;
				ValaIterator* _tmp10_ = NULL;
				ValaIterator* _rvpkg_it;
				_tmp9_ = rv;
				_tmp10_ = vala_iterable_iterator ((ValaIterable*) _tmp9_);
				_rvpkg_it = _tmp10_;
				while (TRUE) {
					ValaIterator* _tmp11_;
					gboolean _tmp12_ = FALSE;
					ValaIterator* _tmp13_;
					gpointer _tmp14_ = NULL;
					gchar* rvpkg;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_ = 0;
					gint cmp;
					gint _tmp18_;
					_tmp11_ = _rvpkg_it;
					_tmp12_ = vala_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _rvpkg_it;
					_tmp14_ = vala_iterator_get (_tmp13_);
					rvpkg = (gchar*) _tmp14_;
					_tmp15_ = pkg;
					_tmp16_ = rvpkg;
					_tmp17_ = compare_pkgs (_tmp15_, _tmp16_);
					cmp = _tmp17_;
					_tmp18_ = cmp;
					if (_tmp18_ != 0) {
						gint _tmp19_;
						_tmp19_ = cmp;
						if (_tmp19_ < 0) {
							add = FALSE;
							_g_free0 (rvpkg);
							break;
						} else {
							ValaHashSet* _tmp20_;
							const gchar* _tmp21_;
							_tmp20_ = rv;
							_tmp21_ = rvpkg;
							vala_collection_remove ((ValaCollection*) _tmp20_, _tmp21_);
							_g_free0 (rvpkg);
							break;
						}
					}
					_g_free0 (rvpkg);
				}
				_vala_iterator_unref0 (_rvpkg_it);
			}
			_tmp22_ = add;
			if (_tmp22_) {
				ValaHashSet* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = rv;
				_tmp24_ = pkg;
				vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
			}
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_tmp25_ = forces;
	_tmp25__length1 = forces_length1;
	if (_tmp25_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp26_;
				_tmp26_ = TRUE;
				while (TRUE) {
					gboolean _tmp27_;
					gchar** _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_;
					const gchar* _tmp31_;
					gboolean add;
					gboolean _tmp50_;
					_tmp27_ = _tmp26_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = i;
						i = _tmp28_ + 1;
					}
					_tmp26_ = FALSE;
					_tmp29_ = forces;
					_tmp29__length1 = forces_length1;
					_tmp30_ = i;
					_tmp31_ = _tmp29_[_tmp30_];
					if (!(_tmp31_ != NULL)) {
						break;
					}
					add = TRUE;
					{
						ValaHashSet* _tmp32_;
						ValaIterator* _tmp33_ = NULL;
						ValaIterator* _rvpkg_it;
						_tmp32_ = rv;
						_tmp33_ = vala_iterable_iterator ((ValaIterable*) _tmp32_);
						_rvpkg_it = _tmp33_;
						while (TRUE) {
							ValaIterator* _tmp34_;
							gboolean _tmp35_ = FALSE;
							ValaIterator* _tmp36_;
							gpointer _tmp37_ = NULL;
							gchar* rvpkg;
							const gchar* _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							gint _tmp40_;
							const gchar* _tmp41_;
							gchar** _tmp42_;
							gint _tmp42__length1;
							gint _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gint _tmp46_ = 0;
							gint cmp;
							gint _tmp47_;
							_tmp34_ = _rvpkg_it;
							_tmp35_ = vala_iterator_next (_tmp34_);
							if (!_tmp35_) {
								break;
							}
							_tmp36_ = _rvpkg_it;
							_tmp37_ = vala_iterator_get (_tmp36_);
							rvpkg = (gchar*) _tmp37_;
							_tmp38_ = rvpkg;
							_tmp39_ = forces;
							_tmp39__length1 = forces_length1;
							_tmp40_ = i;
							_tmp41_ = _tmp39_[_tmp40_];
							if (g_strcmp0 (_tmp38_, _tmp41_) == 0) {
								add = FALSE;
								_g_free0 (rvpkg);
								break;
							}
							_tmp42_ = forces;
							_tmp42__length1 = forces_length1;
							_tmp43_ = i;
							_tmp44_ = _tmp42_[_tmp43_];
							_tmp45_ = rvpkg;
							_tmp46_ = compare_pkgs (_tmp44_, _tmp45_);
							cmp = _tmp46_;
							_tmp47_ = cmp;
							if (_tmp47_ != 0) {
								ValaHashSet* _tmp48_;
								const gchar* _tmp49_;
								_tmp48_ = rv;
								_tmp49_ = rvpkg;
								vala_collection_remove ((ValaCollection*) _tmp48_, _tmp49_);
								_g_free0 (rvpkg);
								break;
							}
							_g_free0 (rvpkg);
						}
						_vala_iterator_unref0 (_rvpkg_it);
					}
					_tmp50_ = add;
					if (_tmp50_) {
						ValaHashSet* _tmp51_;
						gchar** _tmp52_;
						gint _tmp52__length1;
						gint _tmp53_;
						const gchar* _tmp54_;
						_tmp51_ = rv;
						_tmp52_ = forces;
						_tmp52__length1 = forces_length1;
						_tmp53_ = i;
						_tmp54_ = _tmp52_[_tmp53_];
						vala_collection_add ((ValaCollection*) _tmp51_, _tmp54_);
					}
				}
			}
		}
	}
	result = (ValaSet*) rv;
	return result;
}


gboolean vapi_info_is_namespace (VapiInfo* self, const gchar* symbol) {
	gboolean result = FALSE;
	ValaSet* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = self->priv->namespaces;
	_tmp1_ = symbol;
	_tmp2_ = vala_collection_contains ((ValaCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


ValaSet* vapi_info_pkgs_for_symbol (VapiInfo* self, const gchar* symbol, ValaSet* usings) {
	ValaSet* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaHashSet* rv;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (usings != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	rv = _tmp2_;
	{
		ValaMap* _tmp3_;
		ValaSet* _tmp4_ = NULL;
		ValaSet* _tmp5_;
		ValaIterator* _tmp6_ = NULL;
		ValaIterator* _tmp7_;
		ValaIterator* _pkg_it;
		_tmp3_ = self->priv->symbols;
		_tmp4_ = vala_map_get_keys (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_vala_iterable_unref0 (_tmp5_);
		_pkg_it = _tmp7_;
		while (TRUE) {
			ValaIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* pkg;
			ValaMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			ValaMap* map;
			_tmp8_ = _pkg_it;
			_tmp9_ = vala_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _pkg_it;
			_tmp11_ = vala_iterator_get (_tmp10_);
			pkg = (gchar*) _tmp11_;
			_tmp12_ = self->priv->symbols;
			_tmp13_ = pkg;
			_tmp14_ = vala_map_get (_tmp12_, _tmp13_);
			map = (ValaMap*) _tmp14_;
			{
				ValaMap* _tmp15_;
				ValaSet* _tmp16_ = NULL;
				ValaSet* _tmp17_;
				ValaIterator* _tmp18_ = NULL;
				ValaIterator* _tmp19_;
				ValaIterator* _ns_it;
				_tmp15_ = map;
				_tmp16_ = vala_map_get_keys (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
				_tmp19_ = _tmp18_;
				_vala_iterable_unref0 (_tmp17_);
				_ns_it = _tmp19_;
				while (TRUE) {
					ValaIterator* _tmp20_;
					gboolean _tmp21_ = FALSE;
					ValaIterator* _tmp22_;
					gpointer _tmp23_ = NULL;
					gchar* ns;
					ValaSet* _tmp24_;
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					ValaMap* _tmp27_;
					const gchar* _tmp28_;
					gpointer _tmp29_ = NULL;
					ValaSet* syms;
					ValaSet* _tmp30_;
					const gchar* _tmp31_;
					gboolean _tmp32_ = FALSE;
					_tmp20_ = _ns_it;
					_tmp21_ = vala_iterator_next (_tmp20_);
					if (!_tmp21_) {
						break;
					}
					_tmp22_ = _ns_it;
					_tmp23_ = vala_iterator_get (_tmp22_);
					ns = (gchar*) _tmp23_;
					_tmp24_ = usings;
					_tmp25_ = ns;
					_tmp26_ = vala_collection_contains ((ValaCollection*) _tmp24_, _tmp25_);
					if (!_tmp26_) {
						_g_free0 (ns);
						continue;
					}
					_tmp27_ = map;
					_tmp28_ = ns;
					_tmp29_ = vala_map_get (_tmp27_, _tmp28_);
					syms = (ValaSet*) _tmp29_;
					_tmp30_ = syms;
					_tmp31_ = symbol;
					_tmp32_ = vala_collection_contains ((ValaCollection*) _tmp30_, _tmp31_);
					if (_tmp32_) {
						gboolean _tmp33_;
						ValaHashSet* _tmp37_;
						const gchar* _tmp38_;
						_tmp33_ = verbose;
						if (_tmp33_) {
							const gchar* _tmp34_ = NULL;
							const gchar* _tmp35_;
							const gchar* _tmp36_;
							_tmp34_ = _ ("Symbol '%s' found in package '%s'\n");
							_tmp35_ = symbol;
							_tmp36_ = pkg;
							g_printerr (_tmp34_, _tmp35_, _tmp36_);
						}
						_tmp37_ = rv;
						_tmp38_ = pkg;
						vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
						_vala_iterable_unref0 (syms);
						_g_free0 (ns);
						break;
					}
					_vala_iterable_unref0 (syms);
					_g_free0 (ns);
				}
				_vala_iterator_unref0 (_ns_it);
			}
			_vala_map_unref0 (map);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	result = (ValaSet*) rv;
	return result;
}


static void vapi_info_get_pkg_list_for_dir (VapiInfo* self, const gchar* vapidir, ValaSet** pkgs, const gchar* suffix) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vapidir != NULL);
	g_return_if_fail (*pkgs != NULL);
	g_return_if_fail (suffix != NULL);
	{
		gchar* name = NULL;
		const gchar* _tmp0_;
		GDir* _tmp1_ = NULL;
		GDir* dir;
		_tmp0_ = vapidir;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_free0 (name);
			goto __catch1_g_error;
		}
		while (TRUE) {
			GDir* _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			_tmp2_ = dir;
			_tmp3_ = g_dir_read_name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (name);
			name = _tmp4_;
			_tmp5_ = name;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = name;
			_tmp7_ = suffix;
			_tmp8_ = g_str_has_suffix (_tmp6_, _tmp7_);
			if (_tmp8_) {
				ValaSet* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				_tmp9_ = *pkgs;
				_tmp10_ = name;
				_tmp11_ = name;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = suffix;
				_tmp15_ = strlen (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = string_substring (_tmp10_, (glong) 0, (glong) (_tmp13_ - _tmp16_));
				_tmp18_ = _tmp17_;
				vala_collection_add ((ValaCollection*) _tmp9_, _tmp18_);
				_g_free0 (_tmp18_);
			}
		}
		_g_dir_close0 (dir);
		_g_free0 (name);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("main.vala:224: %s\n", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static ValaSet* vapi_info_get_pkg_list (VapiInfo* self) {
	ValaSet* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaSet* rv;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	rv = (ValaSet*) _tmp2_;
	_tmp3_ = mode;
	if (g_strcmp0 (_tmp3_, "vapi") == 0) {
		gchar* _tmp4_;
		gchar* specific;
		gchar* _tmp5_ = NULL;
		gchar* generic;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = g_strdup (VAPI_VER_DIR);
		specific = _tmp4_;
		_tmp5_ = g_build_filename (DATA_DIR, "vala", "vapi", NULL);
		generic = _tmp5_;
		_tmp6_ = specific;
		vapi_info_get_pkg_list_for_dir (self, _tmp6_, &rv, ".vapi");
		_tmp7_ = generic;
		vapi_info_get_pkg_list_for_dir (self, _tmp7_, &rv, ".vapi");
		_g_free0 (generic);
		_g_free0 (specific);
	} else {
		const gchar* _tmp8_;
		_tmp8_ = mode;
		if (g_strcmp0 (_tmp8_, "gir") == 0) {
			gchar* _tmp9_ = NULL;
			gchar* girdir;
			const gchar* _tmp10_;
			_tmp9_ = g_build_filename (DATA_DIR, "gir-1.0", NULL);
			girdir = _tmp9_;
			_tmp10_ = girdir;
			vapi_info_get_pkg_list_for_dir (self, _tmp10_, &rv, ".gir");
			_g_free0 (girdir);
		}
	}
	result = rv;
	return result;
}


static gboolean vapi_info_is_symbol_from_pkg (VapiInfo* self, ValaSymbol* symbol, const gchar* pkg) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = mode;
	if (g_strcmp0 (_tmp0_, "gir") == 0) {
		ValaSymbol* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceFile* _tmp11_;
		ValaSourceFile* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* sym_pkgname;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp1_ = symbol;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_gir_namespace (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = symbol;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_source_file_get_gir_version (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%s-%s", _tmp7_, _tmp14_);
		sym_pkgname = _tmp15_;
		_tmp16_ = sym_pkgname;
		_tmp17_ = pkg;
		result = g_strcmp0 (_tmp16_, _tmp17_) == 0;
		_g_free0 (sym_pkgname);
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


static void vapi_info_add_symbol (VapiInfo* self, ValaHashSet* symbols, ValaSymbol* symbol, const gchar* pkg) {
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = symbol;
	_tmp1_ = pkg;
	_tmp2_ = vapi_info_is_symbol_from_pkg (self, _tmp0_, _tmp1_);
	if (_tmp2_) {
		ValaHashSet* _tmp3_;
		ValaSymbol* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = symbols;
		_tmp4_ = symbol;
		_tmp5_ = vala_symbol_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		vala_collection_add ((ValaCollection*) _tmp3_, _tmp6_);
	}
}


static void vapi_info_process_pkg (VapiInfo* self, const gchar* pkg) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	ValaHashMap* pkgmap;
	ValaCodeContext* _tmp4_;
	ValaCodeContext* ctx;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaCodeContext* _tmp8_;
	ValaCodeContext* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaMap* _tmp182_;
	const gchar* _tmp183_;
	ValaHashMap* _tmp184_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	pkgmap = _tmp3_;
	_tmp4_ = vala_code_context_new ();
	ctx = _tmp4_;
	_tmp5_ = ctx;
	vala_code_context_push (_tmp5_);
	_tmp6_ = ctx;
	vala_code_context_set_profile (_tmp6_, VALA_PROFILE_GOBJECT);
	_tmp7_ = ctx;
	vala_code_context_add_external_package (_tmp7_, "glib-2.0");
	_tmp8_ = ctx;
	vala_code_context_add_external_package (_tmp8_, "gobject-2.0");
	_tmp9_ = ctx;
	_tmp10_ = pkg;
	vapi_info_add_package (self, _tmp9_, _tmp10_);
	_tmp11_ = mode;
	if (g_strcmp0 (_tmp11_, "vapi") == 0) {
		ValaParser* _tmp12_;
		ValaParser* parser;
		ValaParser* _tmp13_;
		ValaCodeContext* _tmp14_;
		_tmp12_ = vala_parser_new ();
		parser = _tmp12_;
		_tmp13_ = parser;
		_tmp14_ = ctx;
		vala_parser_parse (_tmp13_, _tmp14_);
		_vala_code_visitor_unref0 (parser);
	} else {
		const gchar* _tmp15_;
		_tmp15_ = mode;
		if (g_strcmp0 (_tmp15_, "gir") == 0) {
			ValaGirParser* _tmp16_;
			ValaGirParser* parser;
			ValaGirParser* _tmp17_;
			ValaCodeContext* _tmp18_;
			_tmp16_ = vala_gir_parser_new ();
			parser = _tmp16_;
			_tmp17_ = parser;
			_tmp18_ = ctx;
			vala_gir_parser_parse (_tmp17_, _tmp18_);
			_vala_code_visitor_unref0 (parser);
		}
	}
	{
		ValaCodeContext* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaList* _tmp22_ = NULL;
		ValaList* _ns_list;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _ns_size;
		gint _ns_index;
		_tmp19_ = ctx;
		_tmp20_ = vala_code_context_get_root (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_namespace_get_namespaces (_tmp21_);
		_ns_list = _tmp22_;
		_tmp23_ = _ns_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_ns_size = _tmp25_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			ValaList* _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_ = NULL;
			ValaNamespace* ns;
			GHashFunc _tmp32_;
			GEqualFunc _tmp33_;
			ValaHashSet* _tmp34_;
			ValaHashSet* symbolset;
			ValaSet* _tmp35_;
			ValaNamespace* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			ValaHashMap* _tmp39_;
			ValaNamespace* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			ValaHashSet* _tmp43_;
			gboolean _tmp44_;
			_tmp26_ = _ns_index;
			_ns_index = _tmp26_ + 1;
			_tmp27_ = _ns_index;
			_tmp28_ = _ns_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _ns_list;
			_tmp30_ = _ns_index;
			_tmp31_ = vala_list_get (_tmp29_, _tmp30_);
			ns = (ValaNamespace*) _tmp31_;
			_tmp32_ = g_str_hash;
			_tmp33_ = g_str_equal;
			_tmp34_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp32_, _tmp33_);
			symbolset = _tmp34_;
			_tmp35_ = self->priv->namespaces;
			_tmp36_ = ns;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_collection_add ((ValaCollection*) _tmp35_, _tmp38_);
			_tmp39_ = pkgmap;
			_tmp40_ = ns;
			_tmp41_ = vala_symbol_get_name ((ValaSymbol*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = symbolset;
			vala_map_set ((ValaMap*) _tmp39_, _tmp42_, (ValaSet*) _tmp43_);
			_tmp44_ = verbose;
			if (_tmp44_) {
				ValaNamespace* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				ValaNamespace* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaSourceFile* _tmp51_;
				ValaSourceFile* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp45_ = ns;
				_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = ns;
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_source_reference_get_file (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_source_file_get_gir_namespace (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = pkg;
				g_printerr ("Reading namespace %s %s in package %s\n", _tmp47_, _tmp54_, _tmp55_);
			}
			{
				ValaNamespace* _tmp56_;
				ValaList* _tmp57_ = NULL;
				ValaList* _c_list;
				ValaList* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gint _c_size;
				gint _c_index;
				_tmp56_ = ns;
				_tmp57_ = vala_namespace_get_classes (_tmp56_);
				_c_list = _tmp57_;
				_tmp58_ = _c_list;
				_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
				_tmp60_ = _tmp59_;
				_c_size = _tmp60_;
				_c_index = -1;
				while (TRUE) {
					gint _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					ValaList* _tmp64_;
					gint _tmp65_;
					gpointer _tmp66_ = NULL;
					ValaClass* c;
					ValaHashSet* _tmp67_;
					ValaClass* _tmp68_;
					const gchar* _tmp69_;
					_tmp61_ = _c_index;
					_c_index = _tmp61_ + 1;
					_tmp62_ = _c_index;
					_tmp63_ = _c_size;
					if (!(_tmp62_ < _tmp63_)) {
						break;
					}
					_tmp64_ = _c_list;
					_tmp65_ = _c_index;
					_tmp66_ = vala_list_get (_tmp64_, _tmp65_);
					c = (ValaClass*) _tmp66_;
					_tmp67_ = symbolset;
					_tmp68_ = c;
					_tmp69_ = pkg;
					vapi_info_add_symbol (self, _tmp67_, (ValaSymbol*) _tmp68_, _tmp69_);
					_vala_code_node_unref0 (c);
				}
				_vala_iterable_unref0 (_c_list);
			}
			{
				ValaNamespace* _tmp70_;
				ValaList* _tmp71_ = NULL;
				ValaList* _c_list;
				ValaList* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				gint _c_size;
				gint _c_index;
				_tmp70_ = ns;
				_tmp71_ = vala_namespace_get_constants (_tmp70_);
				_c_list = _tmp71_;
				_tmp72_ = _c_list;
				_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
				_tmp74_ = _tmp73_;
				_c_size = _tmp74_;
				_c_index = -1;
				while (TRUE) {
					gint _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					ValaList* _tmp78_;
					gint _tmp79_;
					gpointer _tmp80_ = NULL;
					ValaConstant* c;
					ValaHashSet* _tmp81_;
					ValaConstant* _tmp82_;
					const gchar* _tmp83_;
					_tmp75_ = _c_index;
					_c_index = _tmp75_ + 1;
					_tmp76_ = _c_index;
					_tmp77_ = _c_size;
					if (!(_tmp76_ < _tmp77_)) {
						break;
					}
					_tmp78_ = _c_list;
					_tmp79_ = _c_index;
					_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
					c = (ValaConstant*) _tmp80_;
					_tmp81_ = symbolset;
					_tmp82_ = c;
					_tmp83_ = pkg;
					vapi_info_add_symbol (self, _tmp81_, (ValaSymbol*) _tmp82_, _tmp83_);
					_vala_code_node_unref0 (c);
				}
				_vala_iterable_unref0 (_c_list);
			}
			{
				ValaNamespace* _tmp84_;
				ValaList* _tmp85_ = NULL;
				ValaList* _d_list;
				ValaList* _tmp86_;
				gint _tmp87_;
				gint _tmp88_;
				gint _d_size;
				gint _d_index;
				_tmp84_ = ns;
				_tmp85_ = vala_namespace_get_delegates (_tmp84_);
				_d_list = _tmp85_;
				_tmp86_ = _d_list;
				_tmp87_ = vala_collection_get_size ((ValaCollection*) _tmp86_);
				_tmp88_ = _tmp87_;
				_d_size = _tmp88_;
				_d_index = -1;
				while (TRUE) {
					gint _tmp89_;
					gint _tmp90_;
					gint _tmp91_;
					ValaList* _tmp92_;
					gint _tmp93_;
					gpointer _tmp94_ = NULL;
					ValaDelegate* d;
					ValaHashSet* _tmp95_;
					ValaDelegate* _tmp96_;
					const gchar* _tmp97_;
					_tmp89_ = _d_index;
					_d_index = _tmp89_ + 1;
					_tmp90_ = _d_index;
					_tmp91_ = _d_size;
					if (!(_tmp90_ < _tmp91_)) {
						break;
					}
					_tmp92_ = _d_list;
					_tmp93_ = _d_index;
					_tmp94_ = vala_list_get (_tmp92_, _tmp93_);
					d = (ValaDelegate*) _tmp94_;
					_tmp95_ = symbolset;
					_tmp96_ = d;
					_tmp97_ = pkg;
					vapi_info_add_symbol (self, _tmp95_, (ValaSymbol*) _tmp96_, _tmp97_);
					_vala_code_node_unref0 (d);
				}
				_vala_iterable_unref0 (_d_list);
			}
			{
				ValaNamespace* _tmp98_;
				ValaList* _tmp99_ = NULL;
				ValaList* _e_list;
				ValaList* _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				gint _e_size;
				gint _e_index;
				_tmp98_ = ns;
				_tmp99_ = vala_namespace_get_enums (_tmp98_);
				_e_list = _tmp99_;
				_tmp100_ = _e_list;
				_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
				_tmp102_ = _tmp101_;
				_e_size = _tmp102_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp103_;
					gint _tmp104_;
					gint _tmp105_;
					ValaList* _tmp106_;
					gint _tmp107_;
					gpointer _tmp108_ = NULL;
					ValaEnum* e;
					ValaHashSet* _tmp109_;
					ValaEnum* _tmp110_;
					const gchar* _tmp111_;
					_tmp103_ = _e_index;
					_e_index = _tmp103_ + 1;
					_tmp104_ = _e_index;
					_tmp105_ = _e_size;
					if (!(_tmp104_ < _tmp105_)) {
						break;
					}
					_tmp106_ = _e_list;
					_tmp107_ = _e_index;
					_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
					e = (ValaEnum*) _tmp108_;
					_tmp109_ = symbolset;
					_tmp110_ = e;
					_tmp111_ = pkg;
					vapi_info_add_symbol (self, _tmp109_, (ValaSymbol*) _tmp110_, _tmp111_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			{
				ValaNamespace* _tmp112_;
				ValaList* _tmp113_ = NULL;
				ValaList* _e_list;
				ValaList* _tmp114_;
				gint _tmp115_;
				gint _tmp116_;
				gint _e_size;
				gint _e_index;
				_tmp112_ = ns;
				_tmp113_ = vala_namespace_get_error_domains (_tmp112_);
				_e_list = _tmp113_;
				_tmp114_ = _e_list;
				_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
				_tmp116_ = _tmp115_;
				_e_size = _tmp116_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					ValaList* _tmp120_;
					gint _tmp121_;
					gpointer _tmp122_ = NULL;
					ValaErrorDomain* e;
					ValaHashSet* _tmp123_;
					ValaErrorDomain* _tmp124_;
					const gchar* _tmp125_;
					_tmp117_ = _e_index;
					_e_index = _tmp117_ + 1;
					_tmp118_ = _e_index;
					_tmp119_ = _e_size;
					if (!(_tmp118_ < _tmp119_)) {
						break;
					}
					_tmp120_ = _e_list;
					_tmp121_ = _e_index;
					_tmp122_ = vala_list_get (_tmp120_, _tmp121_);
					e = (ValaErrorDomain*) _tmp122_;
					_tmp123_ = symbolset;
					_tmp124_ = e;
					_tmp125_ = pkg;
					vapi_info_add_symbol (self, _tmp123_, (ValaSymbol*) _tmp124_, _tmp125_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			{
				ValaNamespace* _tmp126_;
				ValaList* _tmp127_ = NULL;
				ValaList* _f_list;
				ValaList* _tmp128_;
				gint _tmp129_;
				gint _tmp130_;
				gint _f_size;
				gint _f_index;
				_tmp126_ = ns;
				_tmp127_ = vala_namespace_get_fields (_tmp126_);
				_f_list = _tmp127_;
				_tmp128_ = _f_list;
				_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
				_tmp130_ = _tmp129_;
				_f_size = _tmp130_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp131_;
					gint _tmp132_;
					gint _tmp133_;
					ValaList* _tmp134_;
					gint _tmp135_;
					gpointer _tmp136_ = NULL;
					ValaField* f;
					ValaHashSet* _tmp137_;
					ValaField* _tmp138_;
					const gchar* _tmp139_;
					_tmp131_ = _f_index;
					_f_index = _tmp131_ + 1;
					_tmp132_ = _f_index;
					_tmp133_ = _f_size;
					if (!(_tmp132_ < _tmp133_)) {
						break;
					}
					_tmp134_ = _f_list;
					_tmp135_ = _f_index;
					_tmp136_ = vala_list_get (_tmp134_, _tmp135_);
					f = (ValaField*) _tmp136_;
					_tmp137_ = symbolset;
					_tmp138_ = f;
					_tmp139_ = pkg;
					vapi_info_add_symbol (self, _tmp137_, (ValaSymbol*) _tmp138_, _tmp139_);
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
			{
				ValaNamespace* _tmp140_;
				ValaList* _tmp141_ = NULL;
				ValaList* _i_list;
				ValaList* _tmp142_;
				gint _tmp143_;
				gint _tmp144_;
				gint _i_size;
				gint _i_index;
				_tmp140_ = ns;
				_tmp141_ = vala_namespace_get_interfaces (_tmp140_);
				_i_list = _tmp141_;
				_tmp142_ = _i_list;
				_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
				_tmp144_ = _tmp143_;
				_i_size = _tmp144_;
				_i_index = -1;
				while (TRUE) {
					gint _tmp145_;
					gint _tmp146_;
					gint _tmp147_;
					ValaList* _tmp148_;
					gint _tmp149_;
					gpointer _tmp150_ = NULL;
					ValaInterface* i;
					ValaHashSet* _tmp151_;
					ValaInterface* _tmp152_;
					const gchar* _tmp153_;
					_tmp145_ = _i_index;
					_i_index = _tmp145_ + 1;
					_tmp146_ = _i_index;
					_tmp147_ = _i_size;
					if (!(_tmp146_ < _tmp147_)) {
						break;
					}
					_tmp148_ = _i_list;
					_tmp149_ = _i_index;
					_tmp150_ = vala_list_get (_tmp148_, _tmp149_);
					i = (ValaInterface*) _tmp150_;
					_tmp151_ = symbolset;
					_tmp152_ = i;
					_tmp153_ = pkg;
					vapi_info_add_symbol (self, _tmp151_, (ValaSymbol*) _tmp152_, _tmp153_);
					_vala_code_node_unref0 (i);
				}
				_vala_iterable_unref0 (_i_list);
			}
			{
				ValaNamespace* _tmp154_;
				ValaList* _tmp155_ = NULL;
				ValaList* _m_list;
				ValaList* _tmp156_;
				gint _tmp157_;
				gint _tmp158_;
				gint _m_size;
				gint _m_index;
				_tmp154_ = ns;
				_tmp155_ = vala_namespace_get_methods (_tmp154_);
				_m_list = _tmp155_;
				_tmp156_ = _m_list;
				_tmp157_ = vala_collection_get_size ((ValaCollection*) _tmp156_);
				_tmp158_ = _tmp157_;
				_m_size = _tmp158_;
				_m_index = -1;
				while (TRUE) {
					gint _tmp159_;
					gint _tmp160_;
					gint _tmp161_;
					ValaList* _tmp162_;
					gint _tmp163_;
					gpointer _tmp164_ = NULL;
					ValaMethod* m;
					ValaHashSet* _tmp165_;
					ValaMethod* _tmp166_;
					const gchar* _tmp167_;
					_tmp159_ = _m_index;
					_m_index = _tmp159_ + 1;
					_tmp160_ = _m_index;
					_tmp161_ = _m_size;
					if (!(_tmp160_ < _tmp161_)) {
						break;
					}
					_tmp162_ = _m_list;
					_tmp163_ = _m_index;
					_tmp164_ = vala_list_get (_tmp162_, _tmp163_);
					m = (ValaMethod*) _tmp164_;
					_tmp165_ = symbolset;
					_tmp166_ = m;
					_tmp167_ = pkg;
					vapi_info_add_symbol (self, _tmp165_, (ValaSymbol*) _tmp166_, _tmp167_);
					_vala_code_node_unref0 (m);
				}
				_vala_iterable_unref0 (_m_list);
			}
			{
				ValaNamespace* _tmp168_;
				ValaList* _tmp169_ = NULL;
				ValaList* _s_list;
				ValaList* _tmp170_;
				gint _tmp171_;
				gint _tmp172_;
				gint _s_size;
				gint _s_index;
				_tmp168_ = ns;
				_tmp169_ = vala_namespace_get_structs (_tmp168_);
				_s_list = _tmp169_;
				_tmp170_ = _s_list;
				_tmp171_ = vala_collection_get_size ((ValaCollection*) _tmp170_);
				_tmp172_ = _tmp171_;
				_s_size = _tmp172_;
				_s_index = -1;
				while (TRUE) {
					gint _tmp173_;
					gint _tmp174_;
					gint _tmp175_;
					ValaList* _tmp176_;
					gint _tmp177_;
					gpointer _tmp178_ = NULL;
					ValaStruct* s;
					ValaHashSet* _tmp179_;
					ValaStruct* _tmp180_;
					const gchar* _tmp181_;
					_tmp173_ = _s_index;
					_s_index = _tmp173_ + 1;
					_tmp174_ = _s_index;
					_tmp175_ = _s_size;
					if (!(_tmp174_ < _tmp175_)) {
						break;
					}
					_tmp176_ = _s_list;
					_tmp177_ = _s_index;
					_tmp178_ = vala_list_get (_tmp176_, _tmp177_);
					s = (ValaStruct*) _tmp178_;
					_tmp179_ = symbolset;
					_tmp180_ = s;
					_tmp181_ = pkg;
					vapi_info_add_symbol (self, _tmp179_, (ValaSymbol*) _tmp180_, _tmp181_);
					_vala_code_node_unref0 (s);
				}
				_vala_iterable_unref0 (_s_list);
			}
			_vala_iterable_unref0 (symbolset);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp182_ = self->priv->symbols;
	_tmp183_ = pkg;
	_tmp184_ = pkgmap;
	vala_map_set (_tmp182_, _tmp183_, (ValaMap*) _tmp184_);
	vala_code_context_pop ();
	_vala_code_context_unref0 (ctx);
	_vala_map_unref0 (pkgmap);
}


static void vapi_info_add_package (VapiInfo* self, ValaCodeContext* ctx, const gchar* pkg) {
	ValaCodeContext* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	const gchar* _tmp4_;
	gchar* package_path;
	const gchar* _tmp5_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = ctx;
	_tmp1_ = pkg;
	_tmp2_ = vala_code_context_has_package (_tmp0_, _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ctx;
	_tmp4_ = pkg;
	vala_code_context_add_package (_tmp3_, _tmp4_);
	package_path = NULL;
	_tmp5_ = mode;
	if (g_strcmp0 (_tmp5_, "vapi") == 0) {
		ValaCodeContext* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp6_ = ctx;
		_tmp7_ = pkg;
		_tmp8_ = vala_code_context_get_vapi_path (_tmp6_, _tmp7_);
		_g_free0 (package_path);
		package_path = _tmp8_;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = mode;
		if (g_strcmp0 (_tmp9_, "gir") == 0) {
			ValaCodeContext* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp10_ = ctx;
			_tmp11_ = pkg;
			_tmp12_ = vala_code_context_get_gir_path (_tmp10_, _tmp11_);
			_g_free0 (package_path);
			package_path = _tmp12_;
		}
	}
	_tmp13_ = package_path;
	if (_tmp13_ != NULL) {
		ValaCodeContext* _tmp14_;
		ValaCodeContext* _tmp15_;
		const gchar* _tmp16_;
		ValaSourceFile* _tmp17_;
		ValaSourceFile* _tmp18_;
		_tmp14_ = ctx;
		_tmp15_ = ctx;
		_tmp16_ = package_path;
		_tmp17_ = vala_source_file_new (_tmp15_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp16_, NULL, FALSE);
		_tmp18_ = _tmp17_;
		vala_code_context_add_source_file (_tmp14_, _tmp18_);
		_vala_source_file_unref0 (_tmp18_);
	}
	_g_free0 (package_path);
}


VapiInfo* vapi_info_construct (GType object_type) {
	VapiInfo * self = NULL;
	self = (VapiInfo*) g_object_new (object_type, NULL);
	return self;
}


VapiInfo* vapi_info_new (void) {
	return vapi_info_construct (TYPE_VAPI_INFO);
}


static GObject * vapi_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VapiInfo * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	parent_class = G_OBJECT_CLASS (vapi_info_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VAPI_INFO (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_MAP, (GBoxedCopyFunc) vala_map_ref, vala_map_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->symbols);
	self->priv->symbols = (ValaMap*) _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->namespaces);
	self->priv->namespaces = (ValaSet*) _tmp6_;
	{
		ValaSet* _tmp7_ = NULL;
		ValaSet* _tmp8_;
		ValaIterator* _tmp9_ = NULL;
		ValaIterator* _tmp10_;
		ValaIterator* _pkg_it;
		_tmp7_ = vapi_info_get_pkg_list (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_iterable_iterator ((ValaIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_iterable_unref0 (_tmp8_);
		_pkg_it = _tmp10_;
		while (TRUE) {
			ValaIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			gchar* pkg;
			const gchar* _tmp15_;
			_tmp11_ = _pkg_it;
			_tmp12_ = vala_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _pkg_it;
			_tmp14_ = vala_iterator_get (_tmp13_);
			pkg = (gchar*) _tmp14_;
			_tmp15_ = pkg;
			vapi_info_process_pkg (self, _tmp15_);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	return obj;
}


static void vapi_info_class_init (VapiInfoClass * klass) {
	vapi_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VapiInfoPrivate));
	G_OBJECT_CLASS (klass)->constructor = vapi_info_constructor;
	G_OBJECT_CLASS (klass)->finalize = vapi_info_finalize;
}


static void vapi_info_instance_init (VapiInfo * self) {
	self->priv = VAPI_INFO_GET_PRIVATE (self);
}


static void vapi_info_finalize (GObject* obj) {
	VapiInfo * self;
	self = VAPI_INFO (obj);
	_vala_map_unref0 (self->priv->symbols);
	_vala_iterable_unref0 (self->priv->namespaces);
	G_OBJECT_CLASS (vapi_info_parent_class)->finalize (obj);
}


GType vapi_info_get_type (void) {
	static volatile gsize vapi_info_type_id__volatile = 0;
	if (g_once_init_enter (&vapi_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VapiInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vapi_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VapiInfo), 0, (GInstanceInitFunc) vapi_info_instance_init, NULL };
		GType vapi_info_type_id;
		vapi_info_type_id = g_type_register_static (G_TYPE_OBJECT, "VapiInfo", &g_define_type_info, 0);
		g_once_init_leave (&vapi_info_type_id__volatile, vapi_info_type_id);
	}
	return vapi_info_type_id__volatile;
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void symbol_catcher_catch (SymbolCatcher* self, ValaCodeContext* ctx, VapiInfo* vinfo) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	VapiInfo* _tmp5_;
	VapiInfo* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaNamespace* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (vinfo != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	_vala_iterable_unref0 (self->packages);
	self->packages = (ValaSet*) _tmp2_;
	_tmp3_ = ctx;
	_tmp4_ = _vala_code_context_ref0 (_tmp3_);
	_vala_code_context_unref0 (self->priv->ctx);
	self->priv->ctx = _tmp4_;
	_tmp5_ = vinfo;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->vinfo);
	self->priv->vinfo = _tmp6_;
	_tmp7_ = self->priv->ctx;
	_tmp8_ = vala_code_context_get_root (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_code_node_accept ((ValaCodeNode*) _tmp9_, (ValaCodeVisitor*) self);
}


static void symbol_catcher_descend (SymbolCatcher* self, ValaCodeNode* n) {
	ValaCodeNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = n;
	vala_code_node_accept_children (_tmp0_, (ValaCodeVisitor*) self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void symbol_catcher_add_symbol (SymbolCatcher* self, const gchar* name, const gchar* prev, ValaList* usings) {
	ValaSet* usings_set = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	VapiInfo* _tmp32_;
	const gchar* _tmp33_;
	ValaSet* _tmp34_;
	ValaSet* _tmp35_ = NULL;
	ValaSet* pkgs;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = prev;
	if (_tmp1_ != NULL) {
		VapiInfo* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->vinfo;
		_tmp3_ = name;
		_tmp4_ = vapi_info_is_namespace (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GHashFunc _tmp6_;
		GEqualFunc _tmp7_;
		ValaHashSet* _tmp8_;
		ValaSet* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = g_str_hash;
		_tmp7_ = g_str_equal;
		_tmp8_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp6_, _tmp7_);
		_vala_iterable_unref0 (usings_set);
		usings_set = (ValaSet*) _tmp8_;
		_tmp9_ = usings_set;
		_tmp10_ = name;
		vala_collection_add ((ValaCollection*) _tmp9_, _tmp10_);
		_tmp11_ = prev;
		name = _tmp11_;
	} else {
		GHashFunc _tmp12_;
		GEqualFunc _tmp13_;
		ValaHashSet* _tmp14_;
		_tmp12_ = g_str_hash;
		_tmp13_ = g_str_equal;
		_tmp14_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp12_, _tmp13_);
		_vala_iterable_unref0 (usings_set);
		usings_set = (ValaSet*) _tmp14_;
		{
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			ValaList* _u_list;
			ValaList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _u_size;
			gint _u_index;
			_tmp15_ = usings;
			_tmp16_ = _vala_iterable_ref0 (_tmp15_);
			_u_list = _tmp16_;
			_tmp17_ = _u_list;
			_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_u_size = _tmp19_;
			_u_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				ValaList* _tmp23_;
				gint _tmp24_;
				gpointer _tmp25_ = NULL;
				ValaUsingDirective* u;
				ValaSet* _tmp26_;
				ValaUsingDirective* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				_tmp20_ = _u_index;
				_u_index = _tmp20_ + 1;
				_tmp21_ = _u_index;
				_tmp22_ = _u_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _u_list;
				_tmp24_ = _u_index;
				_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
				u = (ValaUsingDirective*) _tmp25_;
				_tmp26_ = usings_set;
				_tmp27_ = u;
				_tmp28_ = vala_using_directive_get_namespace_symbol (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_symbol_get_name (_tmp29_);
				_tmp31_ = _tmp30_;
				vala_collection_add ((ValaCollection*) _tmp26_, _tmp31_);
				_vala_code_node_unref0 (u);
			}
			_vala_iterable_unref0 (_u_list);
		}
	}
	_tmp32_ = self->priv->vinfo;
	_tmp33_ = name;
	_tmp34_ = usings_set;
	_tmp35_ = vapi_info_pkgs_for_symbol (_tmp32_, _tmp33_, _tmp34_);
	pkgs = _tmp35_;
	{
		ValaSet* _tmp36_;
		ValaIterator* _tmp37_ = NULL;
		ValaIterator* _pkg_it;
		_tmp36_ = pkgs;
		_tmp37_ = vala_iterable_iterator ((ValaIterable*) _tmp36_);
		_pkg_it = _tmp37_;
		while (TRUE) {
			ValaIterator* _tmp38_;
			gboolean _tmp39_ = FALSE;
			ValaIterator* _tmp40_;
			gpointer _tmp41_ = NULL;
			gchar* pkg;
			ValaSet* _tmp42_;
			const gchar* _tmp43_;
			_tmp38_ = _pkg_it;
			_tmp39_ = vala_iterator_next (_tmp38_);
			if (!_tmp39_) {
				break;
			}
			_tmp40_ = _pkg_it;
			_tmp41_ = vala_iterator_get (_tmp40_);
			pkg = (gchar*) _tmp41_;
			_tmp42_ = self->packages;
			_tmp43_ = pkg;
			vala_collection_add ((ValaCollection*) _tmp42_, _tmp43_);
			_g_free0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_vala_iterable_unref0 (pkgs);
	_vala_iterable_unref0 (usings_set);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void symbol_catcher_real_visit_data_type (ValaCodeVisitor* base, ValaDataType* data_type) {
	SymbolCatcher * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp28_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (data_type != NULL);
	_tmp0_ = data_type;
	if (VALA_IS_UNRESOLVED_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaUnresolvedSymbol* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* unsymbol;
		ValaUnresolvedSymbol* prev;
		const gchar* _tmp14_ = NULL;
		ValaUnresolvedSymbol* _tmp15_;
		ValaUnresolvedSymbol* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaDataType* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		_tmp1_ = data_type;
		_tmp2_ = vala_unresolved_type_get_unresolved_symbol (VALA_IS_UNRESOLVED_TYPE (_tmp1_) ? ((ValaUnresolvedType*) _tmp1_) : NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		unsymbol = _tmp4_;
		prev = NULL;
		while (TRUE) {
			ValaUnresolvedSymbol* _tmp5_;
			ValaUnresolvedSymbol* _tmp6_;
			ValaUnresolvedSymbol* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			ValaUnresolvedSymbol* _tmp9_;
			ValaUnresolvedSymbol* _tmp10_;
			ValaUnresolvedSymbol* _tmp11_;
			ValaUnresolvedSymbol* _tmp12_;
			ValaUnresolvedSymbol* _tmp13_;
			_tmp5_ = unsymbol;
			_tmp6_ = vala_unresolved_symbol_get_inner (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = unsymbol;
			_tmp9_ = _vala_code_node_ref0 (_tmp8_);
			_vala_code_node_unref0 (prev);
			prev = _tmp9_;
			_tmp10_ = unsymbol;
			_tmp11_ = vala_unresolved_symbol_get_inner (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			_vala_code_node_unref0 (unsymbol);
			unsymbol = _tmp13_;
		}
		_tmp15_ = prev;
		if (_tmp15_ == NULL) {
			_tmp14_ = NULL;
		} else {
			ValaUnresolvedSymbol* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = prev;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_;
		}
		_tmp19_ = unsymbol;
		_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp14_;
		_tmp23_ = data_type;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_source_reference_get_using_directives (_tmp25_);
		_tmp27_ = _tmp26_;
		symbol_catcher_add_symbol (self, _tmp21_, _tmp22_, _tmp27_);
		_vala_code_node_unref0 (prev);
		_vala_code_node_unref0 (unsymbol);
	}
	_tmp28_ = data_type;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp28_);
}


static void symbol_catcher_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	SymbolCatcher * self;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* inner;
	ValaMemberAccess* prev;
	const gchar* _tmp16_ = NULL;
	ValaMemberAccess* _tmp17_;
	ValaMemberAccess* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	ValaMemberAccess* _tmp25_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaList* _tmp28_;
	ValaList* _tmp29_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	inner = _tmp1_;
	prev = NULL;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		ValaMemberAccess* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		gboolean _tmp9_;
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaMemberAccess* _tmp15_;
		_tmp3_ = inner;
		_tmp4_ = vala_member_access_get_inner (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaMemberAccess* _tmp6_;
			ValaExpression* _tmp7_;
			ValaExpression* _tmp8_;
			_tmp6_ = inner;
			_tmp7_ = vala_member_access_get_inner (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = VALA_IS_MEMBER_ACCESS (_tmp8_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp9_ = _tmp2_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = inner;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (prev);
		prev = _tmp11_;
		_tmp12_ = inner;
		_tmp13_ = vala_member_access_get_inner (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp14_) ? ((ValaMemberAccess*) _tmp14_) : NULL);
		_vala_code_node_unref0 (inner);
		inner = _tmp15_;
	}
	_tmp17_ = prev;
	if (_tmp17_ == NULL) {
		_tmp16_ = NULL;
	} else {
		ValaMemberAccess* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp18_ = prev;
		_tmp19_ = vala_member_access_get_member_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	}
	_tmp21_ = inner;
	_tmp22_ = vala_member_access_get_member_name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp16_;
	_tmp25_ = expr;
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_source_reference_get_using_directives (_tmp27_);
	_tmp29_ = _tmp28_;
	symbol_catcher_add_symbol (self, _tmp23_, _tmp24_, _tmp29_);
	_vala_code_node_unref0 (prev);
	_vala_code_node_unref0 (inner);
}


static void symbol_catcher_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
}


static void symbol_catcher_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	SymbolCatcher * self;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
}


static void symbol_catcher_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* e) {
	SymbolCatcher * self;
	ValaArrayCreationExpression* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	SymbolCatcher * self;
	ValaAssignment* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = a;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	SymbolCatcher * self;
	ValaBlock* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	SymbolCatcher * self;
	ValaCatchClause* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	SymbolCatcher * self;
	ValaClass* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	SymbolCatcher * self;
	ValaConstant* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	SymbolCatcher * self;
	ValaConstructor* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	SymbolCatcher * self;
	ValaCreationMethod* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	SymbolCatcher * self;
	ValaDeclarationStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	SymbolCatcher * self;
	ValaDelegate* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	SymbolCatcher * self;
	ValaDestructor* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	SymbolCatcher * self;
	ValaDoStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	SymbolCatcher * self;
	ValaElementAccess* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	SymbolCatcher * self;
	ValaEnum* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	SymbolCatcher * self;
	ValaErrorDomain* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = ed;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	SymbolCatcher * self;
	ValaExpressionStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	SymbolCatcher * self;
	ValaField* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	SymbolCatcher * self;
	ValaForStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	SymbolCatcher * self;
	ValaForeachStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_formal_parameter (ValaCodeVisitor* base, ValaParameter* p) {
	SymbolCatcher * self;
	ValaParameter* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	SymbolCatcher * self;
	ValaIfStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	SymbolCatcher * self;
	ValaInitializerList* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = list;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	SymbolCatcher * self;
	ValaInterface* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	SymbolCatcher * self;
	ValaLambdaExpression* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_list_literal (ValaCodeVisitor* base, ValaListLiteral* lit) {
	SymbolCatcher * self;
	ValaListLiteral* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = lit;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	SymbolCatcher * self;
	ValaLocalVariable* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = local;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_loop (ValaCodeVisitor* base, ValaLoop* stmt) {
	SymbolCatcher * self;
	ValaLoop* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_map_literal (ValaCodeVisitor* base, ValaMapLiteral* lit) {
	SymbolCatcher * self;
	ValaMapLiteral* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = lit;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	SymbolCatcher * self;
	ValaMethod* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	SymbolCatcher * self;
	ValaMethodCall* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	SymbolCatcher * self;
	ValaNamespace* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	SymbolCatcher * self;
	ValaObjectCreationExpression* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	SymbolCatcher * self;
	ValaProperty* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	SymbolCatcher * self;
	ValaPropertyAccessor* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = acc;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	SymbolCatcher * self;
	ValaReferenceTransferExpression* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	SymbolCatcher * self;
	ValaReturnStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_set_literal (ValaCodeVisitor* base, ValaSetLiteral* lit) {
	SymbolCatcher * self;
	ValaSetLiteral* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = lit;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	SymbolCatcher * self;
	ValaSignal* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr) {
	SymbolCatcher * self;
	ValaSliceExpression* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	SymbolCatcher * self;
	ValaStruct* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_switch_label (ValaCodeVisitor* base, ValaSwitchLabel* label) {
	SymbolCatcher * self;
	ValaSwitchLabel* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (label != NULL);
	_tmp0_ = label;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	SymbolCatcher * self;
	ValaSwitchSection* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	SymbolCatcher * self;
	ValaSwitchStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_template (ValaCodeVisitor* base, ValaTemplate* tmpl) {
	SymbolCatcher * self;
	ValaTemplate* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (tmpl != NULL);
	_tmp0_ = tmpl;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	SymbolCatcher * self;
	ValaThrowStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	SymbolCatcher * self;
	ValaTryStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_tuple (ValaCodeVisitor* base, ValaTuple* tuple) {
	SymbolCatcher * self;
	ValaTuple* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (tuple != NULL);
	_tmp0_ = tuple;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_using_directive (ValaCodeVisitor* base, ValaUsingDirective* ns) {
	SymbolCatcher * self;
	ValaUsingDirective* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	SymbolCatcher * self;
	ValaWhileStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


static void symbol_catcher_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	SymbolCatcher * self;
	ValaYieldStatement* _tmp0_;
	self = (SymbolCatcher*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	symbol_catcher_descend (self, (ValaCodeNode*) _tmp0_);
}


SymbolCatcher* symbol_catcher_construct (GType object_type) {
	SymbolCatcher* self = NULL;
	self = (SymbolCatcher*) vala_code_visitor_construct (object_type);
	return self;
}


SymbolCatcher* symbol_catcher_new (void) {
	return symbol_catcher_construct (TYPE_SYMBOL_CATCHER);
}


static void symbol_catcher_class_init (SymbolCatcherClass * klass) {
	symbol_catcher_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = symbol_catcher_finalize;
	g_type_class_add_private (klass, sizeof (SymbolCatcherPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_data_type = symbol_catcher_real_visit_data_type;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = symbol_catcher_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = symbol_catcher_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = symbol_catcher_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = symbol_catcher_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = symbol_catcher_real_visit_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = symbol_catcher_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = symbol_catcher_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = symbol_catcher_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = symbol_catcher_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = symbol_catcher_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = symbol_catcher_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = symbol_catcher_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = symbol_catcher_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = symbol_catcher_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = symbol_catcher_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = symbol_catcher_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = symbol_catcher_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = symbol_catcher_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = symbol_catcher_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = symbol_catcher_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = symbol_catcher_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = symbol_catcher_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = symbol_catcher_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = symbol_catcher_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = symbol_catcher_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = symbol_catcher_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = symbol_catcher_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_list_literal = symbol_catcher_real_visit_list_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = symbol_catcher_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_loop = symbol_catcher_real_visit_loop;
	VALA_CODE_VISITOR_CLASS (klass)->visit_map_literal = symbol_catcher_real_visit_map_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = symbol_catcher_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = symbol_catcher_real_visit_method_call;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = symbol_catcher_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = symbol_catcher_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = symbol_catcher_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = symbol_catcher_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = symbol_catcher_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = symbol_catcher_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_set_literal = symbol_catcher_real_visit_set_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = symbol_catcher_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_slice_expression = symbol_catcher_real_visit_slice_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = symbol_catcher_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_label = symbol_catcher_real_visit_switch_label;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = symbol_catcher_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = symbol_catcher_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_template = symbol_catcher_real_visit_template;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = symbol_catcher_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = symbol_catcher_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_tuple = symbol_catcher_real_visit_tuple;
	VALA_CODE_VISITOR_CLASS (klass)->visit_using_directive = symbol_catcher_real_visit_using_directive;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = symbol_catcher_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_yield_statement = symbol_catcher_real_visit_yield_statement;
}


static void symbol_catcher_instance_init (SymbolCatcher * self) {
	self->priv = SYMBOL_CATCHER_GET_PRIVATE (self);
}


static void symbol_catcher_finalize (ValaCodeVisitor* obj) {
	SymbolCatcher * self;
	self = SYMBOL_CATCHER (obj);
	_vala_iterable_unref0 (self->packages);
	_vala_code_context_unref0 (self->priv->ctx);
	_g_object_unref0 (self->priv->vinfo);
	VALA_CODE_VISITOR_CLASS (symbol_catcher_parent_class)->finalize (obj);
}


GType symbol_catcher_get_type (void) {
	static volatile gsize symbol_catcher_type_id__volatile = 0;
	if (g_once_init_enter (&symbol_catcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SymbolCatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbol_catcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SymbolCatcher), 0, (GInstanceInitFunc) symbol_catcher_instance_init, NULL };
		GType symbol_catcher_type_id;
		symbol_catcher_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "SymbolCatcher", &g_define_type_info, 0);
		g_once_init_leave (&symbol_catcher_type_id__volatile, symbol_catcher_type_id);
	}
	return symbol_catcher_type_id__volatile;
}



