/* 
   Copyright (C) 2004  Jeroen Dekkers <jeroen@dekkers.cx>
   Copyright (C) 2000-2002  Christian Scheurer (www.ChristianScheurer.ch)
   Copyright (C) 2000-2002  Johannes Winkelmann (jw@tks6.net)
   RAR decompression code:
   Copyright (c) 1993-2002  Eugene Roshal

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "unrarlib.h"
/*
#include "unrar29.h"
#include "unrar20.h"
#include "unrar15.h"
*/

int UnpackXX_fileoutput(FILE *outputfile,int rarmethod,FILE *inputfile,int DestUnpSize, int UnpPackedSize, int Flags) {
  int filepos,intfd;
  int retval=0;
/*  static unpack_data_t *unpack_data=NULL;

  filepos = ftell(inputfile);

  if (outputfile==NULL) {
    #ifdef _DEBUG_LOG
    fprintf(stderr,"Fatal! Cannot open output file!\n");
    #endif
    return (1==0);
  }
  
  if (unpack_data==NULL) {
    unpack_data = malloc(sizeof(unpack_data_t));
    ppm_constructor(&unpack_data->ppm_data);
  }
  unpack_data->rarvm_data.mem = NULL;
  unpack_data->old_filter_lengths = NULL;
  unpack_data->PrgStack.array = NULL;
  unpack_data->Filters.array = NULL;
  unpack_data->PrgStack.num_items = 0;
  unpack_data->Filters.num_items = 0;
  unpack_data->unp_crc = 0xffffffff;
  unpack_data->dest_unp_size = DestUnpSize;
  unpack_data->pack_size = UnpPackedSize;
  unpack_data->ofd = fileno(outputfile);
  intfd = fileno(inputfile);
  lseek(intfd,filepos,SEEK_SET);
  switch(rarmethod) {
  case 29:
    retval = rar_unpack29(intfd,Flags&LHD_SOLID, unpack_data);
    break;
  case 15:
    retval = rar_unpack15(intfd,Flags&LHD_SOLID, unpack_data);
    break;
  case 20:
  case 26:
    retval = rar_unpack20(intfd,Flags&LHD_SOLID, unpack_data);
    break;
  }

  fseek(inputfile,filepos+UnpPackedSize,SEEK_SET);
  fflush(outputfile);*/
  return retval;
}

int Unpack29_fileoutput(FILE *outputfile,FILE *inputfile,int DestUnpSize, int UnpPackedSize, int Flags) {
  return UnpackXX_fileoutput(outputfile,29,inputfile,DestUnpSize,UnpPackedSize,Flags);
}

void Unpack29(FILE *inputfile,int DestUnpSize, int UnpPackedSize, int Flags) {
  FILE *ofile;
  static int i=0;
  int c;
  char tmpfilename[100];
  extern unsigned char *temp_output_buffer;
  extern unsigned long *temp_output_buffer_offset;

  snprintf(tmpfilename,sizeof(tmpfilename)-1,"/tmp/unrar_tmpf_%06d",i);
  i++;
  #ifdef UNPACK29_KEEP_TEMP_FILE
  ofile = fopen(tmpfilename,"w+b");
  #else
  ofile = tmpfile();
  #endif
  
  
  if (ofile==NULL) {
    #ifdef _DEBUG_LOG
    fprintf(stderr,"Fatal! Cannot open tmp file!\n");
    #endif
    return;
  }
  
  Unpack29_fileoutput(ofile,inputfile,DestUnpSize,UnpPackedSize,Flags);
  if (temp_output_buffer != NULL) {
    fseek(ofile,0,SEEK_SET);
    while (!feof(ofile)) {
      if ((*temp_output_buffer_offset) > DestUnpSize) {
        #ifdef _DEBUG_LOG
        fprintf(stderr,"Fatal! Buffer overrun during compression!\n");
        #endif
        break;
      }
      c = fgetc(ofile);
      if (c==EOF) {
        break;
      }
      temp_output_buffer[(*temp_output_buffer_offset)] = c;
      (*temp_output_buffer_offset)++;
    }
  }
  fclose(ofile);
}
