package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCmsOrder invokes the cms.CreateCmsOrder API synchronously
func (client *Client) CreateCmsOrder(request *CreateCmsOrderRequest) (response *CreateCmsOrderResponse, err error) {
	response = CreateCreateCmsOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCmsOrderWithChan invokes the cms.CreateCmsOrder API asynchronously
func (client *Client) CreateCmsOrderWithChan(request *CreateCmsOrderRequest) (<-chan *CreateCmsOrderResponse, <-chan error) {
	responseChan := make(chan *CreateCmsOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCmsOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCmsOrderWithCallback invokes the cms.CreateCmsOrder API asynchronously
func (client *Client) CreateCmsOrderWithCallback(request *CreateCmsOrderRequest, callback func(response *CreateCmsOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCmsOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateCmsOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCmsOrderRequest is the request struct for api CreateCmsOrder
type CreateCmsOrderRequest struct {
	*requests.RpcRequest
	SmsCount         string           `position:"Query" name:"SmsCount"`
	AutoUseCoupon    requests.Boolean `position:"Query" name:"AutoUseCoupon"`
	LogMonitorStream string           `position:"Query" name:"LogMonitorStream"`
	CustomTimeSeries string           `position:"Query" name:"CustomTimeSeries"`
	ApiCount         string           `position:"Query" name:"ApiCount"`
	PhoneCount       string           `position:"Query" name:"PhoneCount"`
	AutoRenewPeriod  requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period           requests.Integer `position:"Query" name:"Period"`
	AutoPay          requests.Boolean `position:"Query" name:"AutoPay"`
	SuggestType      string           `position:"Query" name:"SuggestType"`
	EventStoreNum    string           `position:"Query" name:"EventStoreNum"`
	SiteTaskNum      string           `position:"Query" name:"SiteTaskNum"`
	PeriodUnit       string           `position:"Query" name:"PeriodUnit"`
	SiteOperatorNum  string           `position:"Query" name:"SiteOperatorNum"`
	SiteEcsNum       string           `position:"Query" name:"SiteEcsNum"`
	EventStoreTime   string           `position:"Query" name:"EventStoreTime"`
	PayType          string           `position:"Query" name:"PayType"`
}

// CreateCmsOrderResponse is the response struct for api CreateCmsOrder
type CreateCmsOrderResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCmsOrderRequest creates a request to invoke CreateCmsOrder API
func CreateCreateCmsOrderRequest() (request *CreateCmsOrderRequest) {
	request = &CreateCmsOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateCmsOrder", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCmsOrderResponse creates a response to parse from CreateCmsOrder response
func CreateCreateCmsOrderResponse() (response *CreateCmsOrderResponse) {
	response = &CreateCmsOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
