/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h> 
# include <math.h>

# include "f2c_syrthes.h"
# include "abs.h"
# include "const.h"
# include "tree.h"
# include "interfaces.h"

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | verif_coor_3d                                                        |
  |         Ce sousprogramme est charge de generer de faire des          |
  |         verifications un peu subtile lorsqu'on dispose d'un          |
  |         maillage implicite                                           |
  |======================================================================| */
void verif_coor_3d (int ndim,int nelray,int npoinr, int *nodray,
		   double *cooray,int nplasy,double *plasym,
		   int nperay,double *perray, int nblblr,double taille_seg)
{


  int *nfabor;
  int *nborglo,nnobor;


  nfabor  = (int *)malloc(3*nelray * sizeof(int));
  nborglo = (int *)malloc(npoinr   * sizeof(int));
  if (nfabor==NULL || nborglo==NULL) 
    {printf(" ERREUR verif_coor_3d : probleme d'allocation memoire\n");
     exit(0);}


  veri_fbor_3d(ndim,nelray,npoinr,nodray,nfabor);

  veri_nbor_3d(ndim,nelray,npoinr,nodray,nfabor,&nnobor,nborglo,nblblr);


  if (nplasy != 0) 
    veri_sym_3d(ndim,nnobor,npoinr,nborglo,cooray,nplasy,plasym,
		nblblr,taille_seg);

/*  if (nperay>0)
    veri_per_3d(ndim,nnobor,npoinr,nborglo,cooray,nperay,perray); 
    
*/
    
  free(nfabor); free(nborglo);
    
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | veri_fbor_3d                                                         |
  |         Ce sousprogramme est charge de generer de faire des          |
  |         verifications un peu subtile lorsqu'on dispose d'un          |
  |         maillage implicite                                           |
  |======================================================================| */
void veri_fbor_3d (int ndim,int nelray,int npoinr, int *nodray,int *nfabor)

{
  int i;
  int is1,is2,isad,js1,js2;
  int iso1,iso2,jso1,jso2;
  int nmemax,nelep1,ip,ip1;
  int ipmax,ipmin;
  int nel,neli,nelj;
  int ifac,ifaci,ifacj;
  int ifauxi,ifauxj;
  int somfac[6];
  int *iadr,*itrav;


  nmemax =  nelray * 3 + 2 * npoinr;
  nelep1 =  nelray + 1;
  ipmin  =  2 * npoinr+1;
  ip     =  2 * npoinr;
  

  somfac[0] = 0; somfac[1] = 1;
  somfac[2] = 1; somfac[3] = 2;
  somfac[4] = 2; somfac[5] = 0; 


  iadr  = (int *)malloc(nmemax * sizeof(int));
  itrav = (int *)malloc(nmemax * sizeof(int));
  if (iadr==NULL || itrav==NULL) 
    {printf(" ERREUR veri_fbor_3d : probleme d'allocation memoire\n");
     exit(0);}

  for (i=0; i < nmemax ; i++) *(iadr+i) = -1 ;
  for (i=0; i < nmemax ; i++) *(itrav+i) = 0 ;
  for (i=0; i < 3* nelray ; i++) *(nfabor+i) = 0 ;


  for ( ifac=0;ifac<3;ifac++)
    {
      for ( nel=0;nel<nelray;nel++)
	{
	  is1 = nodray[nel + nelray *somfac[2*ifac]];
	  is2 = nodray[nel + nelray *somfac[2*ifac+1]];

	  isad = is1+is2;

	  if(iadr[isad] == -1)
	    {
	      iadr[isad] = nel + ifac *nelep1 ;
	      itrav[isad]= isad;
	    }
	  else 
	    {
	      ip          = ip + 1;
	      iadr[ip]    = nel + ifac *nelep1;
	      itrav[ip]   = itrav[isad];
	      itrav[isad] = ip;
	    }
	}
    }

  ipmax = ip ;

  for ( i=ipmax;i>=ipmin;i-= 1)
    {
      ifauxi  = iadr[i];
      ifaci   = ifauxi/nelep1;
      neli    = ifauxi-ifaci*nelep1;


      /* On teste si les cases sont deja remplies */
      if (nfabor[neli + ifaci* nelray] != 0) continue;

      is1 = nodray[neli + nelray *somfac[2*ifaci]];
      is2 = nodray[neli + nelray *somfac[2*ifaci+1]];

      if ( is1<is2 )
	{ iso1 = is1 ; iso2 = is2 ; }
      else
	{ iso1 = is2 ; iso2 = is1 ; }


      ip1 = i;
      while ( ip1 >= ipmin )
	{
	  ip1     = itrav[ip1];
	  ifauxj  = iadr[ip1];
	  ifacj   = ifauxj/nelep1;
	  nelj    = ifauxj-ifacj*nelep1;

	  js1 = nodray[nelj + nelray *somfac[2*ifacj]];
	  js2 = nodray[nelj + nelray *somfac[2*ifacj+1]];

	  if ( js1<js2 )
	    { jso1 = js1 ; jso2 = js2 ; }
	  else
	    { jso1 = js2 ; jso2 = js1 ; }

	  if ( iso1 == jso1 &&  iso2 == jso2 )
	    {
	      nfabor[neli + ifaci* nelray] = nelj+1;
	      nfabor[nelj + ifacj* nelray] = neli+1;
	      continue ;
	    }
	}

    }


  free(iadr);
  free(itrav);
}


/*|======================================================================|
  | SYRTHEL 0.0                FEVR 95         COPYRIGHT EDF/SIMULOG 1995|
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | veri_nbor_3d.c                                                       |
  |         Codage des noeuds frontiere                                  |
  |                                                                      |
  |======================================================================| */
void veri_nbor_3d (int ndim,int nelray,int npoinr,int *nodray,int *nfabor,
		   int *nnobor, int *nborglo, int nblblr)

{
  int i,ifac,nel,ibor;
  int is1,is2;
  int *itrav;
  int somfac[6];

  somfac[0] = 0; somfac[1] = 1;
  somfac[2] = 1; somfac[3] = 2;
  somfac[4] = 2; somfac[5] = 0; 


  /* reservation dynamique des tailles memoires */
  itrav = (int *)malloc(npoinr * sizeof(int));
  if (itrav==NULL) 
    {printf(" ERREUR veri_nbor_3d : probleme d'allocation memoire\n");
     exit(0);}

  /* Initialisation */
  for (i=0; i < npoinr   ; i++) *(itrav+i)  = 0 ;

  *nnobor = 0;

  for (ifac=0;ifac<ndim;ifac++)
    {
      for (nel=0;nel<nelray;nel++)
	{
	  if ( nfabor[nel + ifac* nelray] == 0 )
	    {
	      is1 = nodray[nel + nelray *somfac[2*ifac]]-1;
	      is2 = nodray[nel + nelray *somfac[2*ifac+1]]-1;
	      itrav[is1]=itrav[is2]=1;

	    }
	}
    }


  for (i=0;i<npoinr;i++) if (itrav[i]>0) *nnobor += 1;

  printf("\n *** VERI_NBOR_3D : On compte %d noeuds de bord \n",*nnobor);

  ibor = 0;
  i = 0 ;
  while (i<npoinr)
    {
      if(itrav[i]==0)
	i+=1;
      else
	{
	  nborglo[ibor]=i;
	  ibor+=1;
	  i+=1;
	}
    }

  if(nblblr>10)
    for(i=0;i<*nnobor;i++) printf(" VERI_NBOR_3D : nborloc %d numglobal %d \n",i,nborglo[i]);

  free(itrav);
  
}


/*|======================================================================|
  | SYRTHEL 0.0                FEVR 95         COPYRIGHT EDF/SIMULOG 1995|
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | veri_nbor_3d.c                                                       |
  |         Codage des noeuds frontiere                                  |
  |                                                                      |
  |======================================================================| */
void veri_sym_3d (int ndim,int nnobor,int npoinr,int *nborglo,double *cooray,
		  int nplasy,double *plasym,int nblblr,double taille_seg)
{	
    int i,jc,jnc,n,ng;
    double a,b,c,d,e,t[4][4];
    double x,y,z,epssup,epsmin;
    double alfa,epsil;

    epssup = 0.001;
    epsmin = 0.00001;
    epsil =taille_seg*0.001;

    for (i=0;i<nplasy;i++)
      {
        a=plasym[i*4];
	b=plasym[i*4+1];
        c=plasym[i*4+2];
	d=plasym[i*4+3];
	e=-2./(a*a+b*b+c*c);
	t[0][0] = 1.+ a*a*e;
	t[1][1] = 1.+ b*b*e;
	t[2][2] = 1.+ c*c*e;
	t[0][1] = t[1][0] = a*b*e;
	t[0][2] = t[2][0] = a*c*e;
	t[1][2] = t[2][1] = b*c*e;
        t[0][3] = a*d*e; t[1][3] = b*d*e; t[2][3] = c*d*e;
	t[3][0]=t[3][1]=t[3][2]=0; t[3][3]=1;
	 
/*	for (n=0;n<nnobor;n++)
	  {	
	    ng = nborglo[n];
	    x  = cooray[ng];
	    y  = cooray[ng+ npoinr];
	    z  = cooray[ng+ npoinr*2];
	    xtr = t[0][0]*x+t[0][1]*y+t[0][2]*z + t[0][3]; 
	    ytr = t[1][0]*x+t[1][1]*y+t[1][2]*z + t[1][3]; 
	    ztr = t[2][0]*x+t[2][1]*y+t[2][2]*z + t[2][3];

	    tnor = abs((xtr-x)*(xtr-x)+(ytr-y)*(ytr-y)+(ztr-z)*(ztr-z));
	    if (tnor<epssup && tnor > epsmin)
	      {
		printf("\n VERI_SYM_3D : Probleme sur les coordonnees du maillage: noeud %d distance %f \n",ng+1,tnor);
		cooray[ng]          = (x+xtr)/2.;
		cooray[ng+npoinr]   = (y+ytr)/2.;
		cooray[ng+npoinr*2] = (z+ztr)/2.;  
	      }
	  } 
*/
/* nouvelle technique chris du 6/03/98 
par projection */
	
	for (n=0,jc=jnc=0;n<nnobor;n++)
	  {	
	    ng = nborglo[n];
	    x  = cooray[ng];
	    y  = cooray[ng+ npoinr];
	    z  = cooray[ng+ npoinr*2];

	    a=plasym[i*4];
	    b=plasym[i*4+1];
	    c=plasym[i*4+2];
	    d=plasym[i*4+3];

	    alfa = -(d+x*a+y*b+z*c)/(a*a+b*b+c*c);
	    if(abs(alfa)<1.e-8) jnc++;
	    else if(1.e-8<abs(alfa) && abs(alfa)<epsil) jc++;
	    if(abs(alfa) < epsil)
	      {
		cooray[ng] = x+alfa*a;
		cooray[ng+ npoinr] = y+alfa*b;
		cooray[ng+ npoinr*2] = z+alfa*c;
	      }
	    
	  }
	if (jc)
	  {
	    printf("\n *** VERI_SYM_3D : Attention les coordonnees de %d noeuds ",jc);
	    printf("du maillage rayonnement ont ete modifiees\n");
	    printf("                   car ces noeuds n'etaient qu'approximativement ");
	    printf("dans le plan de symetrie\n");
	    printf("                   %fx + %fy + %fz + %f = 0\n",a,b,c,d);
	  }
	if (!(jc+jnc))
	  {
	    printf("\n ERREUR VERI_SYM_3D : aucun noeud de bord du maillage de rayonnement\n");
	    printf("                      n'appartient au plan de symetrie\n");
	    printf("                      %fx + %fy + %fz + %f = 0\n",a,b,c,d);
	    exit(0);
	  }


      }

}



/*|======================================================================|
  | SYRTHEL 0.0                FEVR 95         COPYRIGHT EDF/SIMULOG 1995|
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | veri_per_3d.c                                                        |
  |         Verification pour la periodicite (uniquement)                |
  |                                                                      |
  |======================================================================| */
void veri_per_3d (int ndim,int nnobor,int npoinr,int *nborglo,double *cooray,
		  int nperay,double *perray) 

{
  int i,ng,n,nga;
  double t[4][4];
  double Pi;
  double phi,theta,c,s,c2,s2,an,aa,bb,cc,dd,ee,ff,gg,hh,ii;
  double px,py,pz,ax,ay,az,alfa,angle;
  double x,y,z,xa,ya,za,xtper,ytper,ztper,epssup,epsmin,tnorm;
  int ntest,nmodif,nincha;

  epssup = 0.001;
  epsmin = 0.00001;
  Pi = 3.141592653589793;  	
  nmodif = 0;
  nincha = 0;

  px = perray[0];
  py = perray[1];
  pz = perray[2];
  ax = perray[3];
  ay = perray[4];
  az = perray[5];
  alfa = perray[6]*2*Pi/360.;

  angle = alfa;
  if (abs(ax) >  eps)
    {
      an = sqrt(ax*ax+ay*ay);
      phi = atan2(ay,ax); theta = atan2(az,an) ;
      c = cos(phi) ; s   = sin(phi) ; c2 = cos(theta) ; s2 = sin(theta);
    }
  else if (abs(ay) >  eps)
    {
      an = sqrt(ax*ax+ay*ay);
      theta = atan2(az,an) ; c = 0. ; s = 1. ; c2 = cos(theta) ; s2 = sin(theta) ;
    }
  else
    {
      c =1 ; s = 0 ; c2 = 0 ; s2 = 1 ;
    }

  aa =  c2*c ;
  bb = -c2*s ;
  cc =  s2 ;
  dd =  cos(angle)*s+sin(angle)*s2*c ;
  ee =  cos(angle)*c-sin(angle)*s*s2 ;
  ff =  -sin(angle)*c2 ;
  gg =  sin(angle)*s-cos(angle)*s2*c ;
  hh =  sin(angle)*c+cos(angle)*s*s2 ;
  ii =  cos(angle)*c2 ;

  t[0][0] = aa*aa+s*dd-c*s2*gg;
  t[1][1] = -s*c2*bb+c*ee+s*s2*hh;
  t[2][2] = s2*cc+c2*ii;
  t[1][0] = -s*c2*aa+c*dd+s*s2*gg;
  t[0][1] = aa*bb+s*ee-c*s2*hh;
  t[2][0] = s2*aa+c2*gg;
  t[0][2] = aa*cc+s*ff-c*s2*ii;
  t[2][1] = s2*bb+c2*hh;
  t[1][2] = -s*c2*cc+c*ff+s*s2*ii;
  t[3][0] = t[3][1] = t[3][2] = 0.;
  t[0][3]= px ; t[1][3]= py ; t[2][3]= pz ; t[3][3]=1;
	
  for (n=0;n<nnobor;n++)
    if (nborglo[n]>= 0)
      {
	ng = nborglo[n];
	x  = *(cooray+ng);
	y  = *(cooray+ng+npoinr);
	z  = *(cooray+ng+npoinr*2);

	for (i=0;i<nnobor;i++)
	  if(nborglo[i]>=0)
	    {
	      nga = nborglo[i];
	      xa  = *(cooray+nga);
	      ya  = *(cooray+nga+npoinr);
	      za  = *(cooray+nga+npoinr*2);
	      xtper = t[0][0]*xa+t[0][1]*ya+t[0][2]*za + t[0][3]; 
	      ytper = t[1][0]*xa+t[1][1]*ya+t[1][2]*za + t[1][3];  
	      ztper = t[2][0]*xa+t[2][1]*ya+t[2][2]*za + t[2][3];
	      tnorm = sqrt((xtper-x)*(xtper-x)+(ytper-y)*(ytper-y)+(ztper-z)*(ztper-z));
	    
	      if (tnorm <= epsmin) 
		{
		  nborglo[n] = -nborglo[n];
		  if (i!= n)
		    {
		      nborglo[i] = -nborglo[i];
		      nincha +=2;
		      cooray[ng]          = xtper; 
		      cooray[ng+npoinr]   = ytper;  
		      cooray[ng+npoinr*2] = ztper;  		
		    }
		  else
		    nincha +=1 ;
		    

		}
		  
	      if(tnorm < epssup && tnorm > epsmin)
		{
		  cooray[ng]          = xtper;  
		  cooray[ng+npoinr]   = ytper;  
		  cooray[ng+npoinr*2] = ztper;  
		  nborglo[n] = -nborglo[n];
		  if (i!=n) nborglo[i] = -nborglo[i];
		  nmodif += 1;
		  printf(" Probleme maillage : noeud %d noeud %d distance en mm %f \n",
			 ng+1,nga+1,tnorm*1e3);
		}
	    }
      }

  printf("\n VERI_PER_3D :  Nombre de noeuds satisfaisant la transformation de  periodicite  %d \n",nincha);
  if (nmodif>0)
    printf("\n VERI_PER_3D : Nombre de noeuds modifies pour satisfaire la transformation %d \n",nmodif);
  
  ntest = 0;
  for (n=0;n<nnobor;n++)  if (nborglo[n]<=0)ntest+=1;
  if (ntest<nnobor)
    {
      printf("\n VERI_PER_3D : Erreur dans le maillage vraisemblable, verifier la transformation \n");
      printf("\n VERI_PER_3D : Les noeuds sur le bord du maillage ne sont pas periodiques \n");
      for (n=0;n<nnobor;n++) printf(" numloc %d numglob %d \n",n,nborglo[n]);
      exit(0);
    }
  
}                 
