C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                     SUBROUTINE MAFCLI
C                    ******************
C
C     ------------------------------------------------------
     *( NFECHS,VFECHS,NBFECH, 
     *  NFRESC,VFRESC,NELERC,
     *  NFRAYS,VFRAYS,NELERA,
     *  NFRAIS,VFRAIS,NBFRAI,
     *  NFCOUS,VFCOUS,NELESS,
     *  TMPSA,NODEUS,COORDS,SURFUS,
     *  NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     *  TRAVF,TRAVP,WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DE LA CONTRIBUTION DES TERMES ECHANGE      *
C                    DU A L'IMPLICITATION DES TERMES D'ECHANGE         *
C                                                                      *
C      On calcule les termes suivants                                  *
C            Termes de couplage avec le fluide                         *
C            Termes de coefficient d'echange avec l'exterieure         *
C            Terme de resistance de contact                            *
C            Terme de rayonnement                                      *
C                                                                      *
C      On calcul ici la contribution des faces que l'on assemble       *
C      et qu'on rajoute a la matrice de masse                          *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NFECHS  !  TE  ! D  ! No de facette echange ---> face glob     !
C   !   VFECHS  !  TR  ! D  ! Valeur des echan aux points de la face   !
C   !   NBFECH  !  E   ! D  ! Nombre de facette de type echange        ! 
C   !   NFRESC  !  TE  ! D  ! No de facette resistance ---> face glob  !
C   !   VFRESC  !  TR  ! D  ! Valeur des resista aux points de la face !
C   !   NELERC  !  E   ! D  ! Nombre de facette de type resistance     ! 
C   !   NFRAYS  !  TE  ! D  ! No de facette rayonnement ---> face glob !
C   !   VFRAYS  !  TR  ! D  ! Valeur du rayo aux points de la face     !
C   !   NELERA  !  E   ! D  ! Nombre de facette de type rayonnement    ! 
C   !   NFCOUS  !  TE  ! D  ! No de facette couplee ---> face glob     !
C   !   VFCOUS  !  TR  ! D  ! Valeur du couplage aux points de la face !
C   !   NELESS  !  E   ! D  ! Nombre de facette de type couplee        ! 
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEUS,OV
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : DIFSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIM,NELEUS,NDMASS
      INTEGER NBFECH,NELERC,NELERA,NBFRAI,NELESS
      INTEGER NFECHS(NBFECH),NFRESC(NELERC)
      INTEGER NFRAYS(NELERA),NFRAIS(NBFRAI),NFCOUS(NELESS)
      INTEGER NODEUS(NELEUS,NDMASS)
C
      DOUBLE PRECISION VFECHS(NBFECH,NDMASS,2)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      DOUBLE PRECISION VFRAYS(NELERA,NDMASS,2),VFRAIS(NBFRAI,NDMASS,2)
      DOUBLE PRECISION VFCOUS(NELESS,NDMASS,2)
      DOUBLE PRECISION TRAVP(NPOINS),TRAVF(NELEUS,NDMASS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),TMPSA(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMASS)
      DOUBLE PRECISION SURFUS(NELEUS)   
C
C..Variables internes
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION R1,R2
      DOUBLE PRECISION CL1,CL2,CL3,CL4,CL5,CL6
      INTEGER I,J,NF,INODE,NCA
      DOUBLE PRECISION S48,SV48,S12,SV12
      DOUBLE PRECISION HRAYI,HRAYT 
C    
C***********************************************************************
C
C     1- INITIALISATION
C     =================
C
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      S48 = 1.D0 / 48.D0
      S12  = 1.D0 / 12.D0
C
C
      CALL OV ('X=C     ',TRAVP,TRAVP,TRAVP,ZERO,NPOINS )         
      CALL OV ('X=C     ',TRAVF,TRAVF,TRAVF,ZERO,NELEUS*NDMASS )         
C
C      
C     2- PRISE EN COMPTE DES "COEFFICIENTS D'ECHANGE"
C     ==============================================
C 
C         2.1 Termes de couplage thermique avec le fluide
C         -------------------------------------------------
          DO 210 J=1,NDMASS
             DO 210 I=1,NELESS
                NF = NFCOUS(I)
                TRAVF(NF,J) = TRAVF(NF,J) + VFCOUS(I,J,2)
 210         CONTINUE
 211      CONTINUE
C        
C         2.2 Termes du au coefficient d'echange
C         -------------------------------------------------
          DO 221 J=1,NDMASS
             DO 220 I=1,NBFECH
                NF = NFECHS(I)
                TRAVF(NF,J) = TRAVF(NF,J) + VFECHS(I,J,2)
 220         CONTINUE
 221      CONTINUE
C              
C         2.3 Termes du aux resistances de contact
C         -------------------------------------------------
          DO 231 J=1,NDMASS
             DO 230 I=1,NELERC
                NF = NFRESC(I)
                TRAVF(NF,J) = TRAVF(NF,J) + VFRESC(I,J,2)
 230         CONTINUE
 231      CONTINUE
C                      
C         2.4 Termes du au rayonnement infini
C         ----------------------------------
          DO 241 J=1,NDMASS
             DO 240 I=1,NBFRAI
                NF = NFRAIS(I)
                INODE = NODEUS(NFRAIS(I),J)
                HRAYI = VFRAIS(I,J,2)*SIGMA*
     &                  (TMPSA(INODE)+VFRAIS(I,J,1)+2*TKEL)*
     &                  ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) + 
     &                  (VFRAIS(I,J,1)+TKEL) * (VFRAIS(I,J,1)+TKEL) )
                TRAVF(NF,J) = TRAVF(NF,J) + HRAYI
 240         CONTINUE
 241      CONTINUE
C        
C         2.5 Termes du au rayonnement
C         -----------------------------
          DO 251 J=1,NDMASS
             DO 250 I=1,NELERA
                NF = NFRAYS(I)
                INODE = NODEUS(NFRAYS(I),J)
                HRAYT = VFRAYS(I,J,2)*SIGMA*
     &                 (TMPSA(INODE)+VFRAYS(I,J,1)+2*TKEL)*
     &                 ((TMPSA(INODE)+TKEL)  * (TMPSA(INODE)+TKEL) +
     &                  (VFRAYS(I,J,1)+TKEL) * (VFRAYS(I,J,1)+TKEL) )
                TRAVF(NF,J) = TRAVF(NF,J) + HRAYT
 250         CONTINUE
 251      CONTINUE
C        
C               
C     3- CALCUL DE LA MATRICE ELEMENTAIRE 
C     ================================
C
C         3.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             3.1.1- Cas cartesien
C             --------------------
              IF  (IAXISY.EQ.0) THEN
C
                   DO 311 I=1,NELEUS
C
                     SV12 = S12 * SURFUS(I)      
C
                     CL1  = TRAVF(I,1) * SV12
                     CL2  = TRAVF(I,2) * SV12
                     CL3  = TRAVF(I,3) * SV12
C                  
                     WCT(I,1) = 2*CL1 + CL3
                     WCT(I,2) = 2*CL2 + CL3
                     WCT(I,3) = CL1 + CL2 + 4*CL3       
  311              CONTINUE
C
C             3.1.2- Cas axisymetrique
C             ------------------------
              ELSE
              
                   DO 312 I=1,NELEUS
C
C
                     SV48 = S48 * SURFUS(I)
C
                     R1 = ABS(COORDS(NODEUS(I,1),NCA))
                     R2 = ABS(COORDS(NODEUS(I,2),NCA))        
C
                     CL1  = TRAVF(I,1) * SV48
                     CL2  = TRAVF(I,2) * SV48
                     CL3  = TRAVF(I,3) * SV48
C                  
                     WCT(I,1) = R2*CL3+R2*CL1+3*R1*CL3+7*R1*CL1 
                     WCT(I,2) = 3*R2*CL3+7*R2*CL2+R1*CL3+R1*CL2 
                     WCT(I,3) = 8*R2*CL3+R2*CL1+8*R1*CL3+3*R1*CL1
     &                       +3*R2*CL2+R1*CL2 
C   
  312              CONTINUE
C              
              ENDIF
C                         
C         3.2- Cas 3D
C         -----------          
          ELSE
                   DO 320 I=1,NELEUS
C
                   SV48 = S48 * SURFUS(I)                      
C            
                   CL1  = TRAVF(I,1) * SV48
                   CL2  = TRAVF(I,2) * SV48
                   CL3  = TRAVF(I,3) * SV48
                   CL4  = TRAVF(I,4) * SV48
                   CL5  = TRAVF(I,5) * SV48
                   CL6  = TRAVF(I,6) * SV48
C
C
                   WCT(I,1) =  2*CL1 + CL4 + CL6
                   WCT(I,2) =  2*CL2 + CL4 + CL5
                   WCT(I,3) =  2*CL3 + CL5 + CL6
                   WCT(I,4) =  CL1 + CL2 + 6*CL4 + 2*(CL5+CL6)
                   WCT(I,5) =  CL2 + CL3 + 6*CL5 + 2*(CL4+CL6)
                   WCT(I,6) =  CL1 + CL3 + 6*CL6 + 2*(CL4+CL5)
C
  320 CONTINUE
C
          ENDIF
C
          CALL ASSEUS ( TRAVP,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,
     &                  NDIM,WCT)
C
C
C     4- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF ( NBLBLA .EQ. 11 ) THEN
        WRITE(NFECRA,4000)
        DO 400 I=1,NPOINS
          WRITE(NFECRA,4010) I,TRAVP(I)
  400   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
 4000 FORMAT(/,' *** MAFCLI : 1ER MEMBRE (PARTIE ECHANGE IMPLICITE)',/,
     &         '     NOEUD      MAT DE MASSE ')
 4010 FORMAT(7X,I6,5X,G10.4)
C                             
      END


