%define name    sweep
%define version 0.9.3
%define release 1
%define prefix  /usr

Summary: Sound wave editor

Name:           %{name}
Version:        %{version}
Release:        %{release}
Copyright:      GPL
Group:          Applications/Sound
URL:            http://sweep.sourceforge.net/

Source:         %{name}-%{version}.tar.gz
Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root
Docdir:         %{prefix}/doc
Prefix:         %{prefix}
Requires:       gtk+ >= 2.2.0

%description
Sweep is an editor for sound samples. It operates on files of various
formats such as .wav, .aiff and .au, and has multiple undo/redo levels
and filters. It supports audio filter plugins from the LADSPA project.

%package        devel
Summary:        Sweep plugin development kit
Group:          Applications/Sound
Requires:       %{name} = %{version}

%description    devel
The sweep-devel package contains header files and documentation for writing
plugins for Sweep, a sound wave editor.

Install sweep-devel if you're going to create plugins for Sweep. You will
also need to install sweep.

%prep
%setup -q -n %{name}-%{version}
if [ -f configure ]; then
        CFLAGS=$RPM_OPT_FLAGS \
        ./configure --prefix=%{prefix};
else
        CFLAGS=$RPM_OPT_FLAGS \
        ./autogen.sh --prefix=%{prefix};
fi

%build
LINGUAS="fr hu it de pl" CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
gmake

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip

%files

%defattr (0555, bin, bin)
%{prefix}/bin/sweep

%defattr (0444, bin, bin, 0555)
%{prefix}/lib/sweep/libladspameta*
%{prefix}/lib/sweep/libecho*
%{prefix}/lib/sweep/libnormalise*
%{prefix}/lib/sweep/libreverse*
%{prefix}/lib/sweep/libbyenergy*

%defattr (0555, bin, man)
%{prefix}/man/man1/sweep.1*
%doc ABOUT-NLS NEWS README ChangeLog
%doc README.Solaris README.ALSA
%doc doc/*.txt

%defattr (-, root, root)
%{prefix}/share/gnome/apps/Multimedia/sweep.desktop
%{prefix}/share/locale/*/*/*

%files devel
%doc doc/plugin_writers_guide.txt
%{prefix}/include/sweep/

%clean
rm -r $RPM_BUILD_ROOT

%changelog
* Sun Oct 08 2000 Conrad Parker <conrad@vergenet.net>
- updated for sweep version 0.1.0
- added devel package
- added packaging of plugins
- added documentation

* Tue Aug 09 2005 Peter Shorthose <kickback@users.sourceforge.net>
- use autoconf to generate the spec via sweep.spec.in
- insert the package version via the autoconf macro 
- remind the reader that the above changes are untested as of now

* Thur Aug 25 2005 Peter Shorthose <kickback@users.sourceforge.net>
- update Gtk requirements
