/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Revision.h"
#include "util/apr.h"


namespace svn
{

const char* RevisionStrings[] = 
{
  "unspecified",
  "number",
  "date",
  "committed",
  "previous",
  "base",
  "working",
  "head"
};


Revision::Revision( RevisionKind kind ) : _kind(kind)
{
}

Revision::~Revision()
{
}

RevisionKind Revision::getKind() const
{
  return _kind;
}

bool Revision::isLocal() const
{
  return _kind == Revision_Base
    ||   _kind == Revision_Working;
}

bool Revision::equals( const Revision* src ) const
{
  return _kind == src->_kind;
}

const Revision* Revision::dup() const
{
  return new Revision(*this);
}

sc::String Revision::toString() const
{
  return sc::String(RevisionStrings[_kind]);
}

///////////////////////////////////////////////////////////////////////

RevisionDate::RevisionDate( const Date& d ) : Revision(Revision_Date), _date(d)
{
}

const Date& RevisionDate::getDate() const
{
  return _date;
}

bool RevisionDate::equals( const Revision* src ) const
{
  return _kind == src->getKind()
    &&   _date == dynamic_cast<const RevisionDate*>(src)->_date;
}

const Revision* RevisionDate::dup() const
{
  return new RevisionDate(*this);
}

sc::String RevisionDate::toString() const
{
  char tmp[APR_RFC822_DATE_LEN] = {}; 
  apr_rfc822_date( tmp, _date ); 

  return sc::String(tmp);
}

///////////////////////////////////////////////////////////////////////

RevisionNumber::RevisionNumber( const Revnumber& r ) : Revision(Revision_Number), _rev(r)
{
}

const Revnumber& RevisionNumber::getNumber() const
{
  return _rev;
}

bool RevisionNumber::equals( const Revision* src ) const
{
  return _kind == src->getKind()
    &&   _rev  == dynamic_cast<const RevisionNumber*>(src)->_rev;
}

const Revision* RevisionNumber::dup() const
{
  return new RevisionNumber(*this);
}

sc::String RevisionNumber::toString() const
{
  apr_pool_t* pool = apr::createPool();
  sc::String result( "r" );
  result += sc::String( apr_ltoa(pool,_rev) );
  apr::destroyPool(pool);

  return result;
}


} // namespace

