/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PAINTER_SETUP_H
#define _PAINTER_SETUP_H

// qt
#include <QtCore/QRect>
#include <QtGui/QWidget>
#include <QtGui/QPixmap>
#include <QtGui/QPainter>


class PainterSetup
{
public:
  PainterSetup( QWidget* w, const QRect& pr, bool doubleBuffer = false )
    : _w(w), _pr(pr)
  {
    if( doubleBuffer )
    {
      //printf( "%s\n", (const char*)_w->font().toString().toAscii() );
  
      _pm.resize( _pr.width(), _pr.height() );
      _pp.begin(&_pm);
      _pp.setClipRect( 0, 0, _pr.width(), _pr.height() );

      // this lets us draw into the buffer with the same
      // coordinates  we use to draw into the window.
      _pp.translate( -_pr.x(), -_pr.y() );

      _pp.setFont(_w->font());

      //printf( "%s\n", (const char*)_pp.font().toString().toAscii() );
      //printf( "%s\n", (const char*)_pp.fontInfo().family().toAscii() );
    }
    else
    {
      _pp.begin(_w);
      _pp.setClipRect( 0, 0, _pr.width(), _pr.height() );
    }
  }

  ~PainterSetup()
  {
    if( _pm.isNull() )
    {
      return;
    }

    _pp.end();
    bitBlt( _w, _pr.topLeft(), &_pm );
  }

  QPainter& getPainter()
  {
    return _pp;
  }

private:
  QWidget*  _w;
  QRect     _pr;
  QPixmap   _pm;
  QPainter  _pp;
};


#endif // _PAINTER_SETUP_H

