/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LAYOUTSETTINGSHANDLER_TEST_H
#define _LAYOUTSETTINGSHANDLER_TEST_H

// sc
class TestConfig;
class ConfigData;

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>


class LayoutSettingsHandlerTest : public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( LayoutSettingsHandlerTest );
  CPPUNIT_TEST( getExistingQByteArray );
  CPPUNIT_TEST( getMissingQByteArray );
  CPPUNIT_TEST_SUITE_END(); 
  
public:
  void setUp();
  void tearDown();
  
  // Tests
  void getExistingQByteArray();
  void getMissingQByteArray();

private:
  TestConfig* _tconf;
  ConfigData* _cdata;
};

#endif // _LAYOUTSETTINGSHANDLER_TEST_H
