/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ExceptionEvent.h"
#include "util/Exception.h"
#include "util/ExceptionStack.h"

// qt
#include <QtGui/QApplication>


/**
 * \brief post an event to the applications main widget.
 *
 * \param e the event to post.
 */
void postEvent( QEvent* e )
{
  QApplication::postEvent( qApp->mainWidget(), e );
}

/**
 * \brief post an event to the given object.
 *
 * \param r the receiver of the event.
 * \param e the event to post.
 */

void postEvent( QObject* r, QEvent* e )
{
  QApplication::postEvent( r, e );
}

/**
 * \brief post an Exception to the applications main widget.
 *
 * \param exc the exception.
 */

void postException( const sc::Exception& exc )
{
  const sc::ExceptionStack* excs = dynamic_cast<const sc::ExceptionStack*>(&exc);

  if( excs )
  {
    ExceptionEvent* e = new ExceptionEvent( exc.getError(), excs->getStack() );
    QApplication::postEvent( qApp->mainWidget(), e );
  }
  else
  {
    Stackframes stack;
    ExceptionEvent* e = new ExceptionEvent( exc.getError(), stack );
    QApplication::postEvent( qApp->mainWidget(), e );
  }
}
