/*
  url -- filters url for characters that would confuse shell
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "url.h"
#include <stdio.h>

void url_filter (char * urlunf, char * urlfil) {

  int i;
  int j=0;
  unsigned char c;

  for (i=0; i<strlen(urlunf); i++)
    {
      c=urlunf[i];
      if ( (c=='$') ||
	   (c=='\'') ||
	   (c<0x20) )
	{
	  char ss[3];
	  sprintf(ss,"%02X",c);
	  urlfil[j++]='%';
	  urlfil[j++]=ss[0];
	  urlfil[j++]=ss[1];
	}
      else
	{
	  urlfil[j++]=c;
	}
    }
  urlfil[j]=0;
}
