/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_19 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4061, "epsg", 4061,
        "RGRDC 2005 / UTM zone 33S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 33S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",15],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"4061\"]]");
    p = add_epsg_def_ex (filter, first, last, 4062, "epsg", 4062,
        "RGRDC 2005 / UTM zone 34S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 34S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",21],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"4062\"]]");
    p = add_epsg_def_ex (filter, first, last, 4063, "epsg", 4063,
        "RGRDC 2005 / UTM zone 35S", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / UTM zone 35S\",GEOGCS[\"RGRDC 2005");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1033\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",27],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"4063\"]]");
    p = add_epsg_def_ex (filter, first, last, 4071, "epsg", 4071,
        "Chua / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Chua", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-143.87,2");
    add_proj4text (p, 1,
        "43.37,-33.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Chua / UTM zone 23S\",GEOGCS[\"Chua\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "hua\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7022\"]],TOWGS84[-143.87,243.37,-33.52,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6224\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4224\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4071\"]]");
    p = add_epsg_def_ex (filter, first, last, 4075, "epsg", 4075,
        "SREF98", 1, 1,
        "GRS 1980", "Greenwich",
        "Serbian_Reference_Network_1998", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SREF98\",DATUM[\"Serbian_Reference_Network_1998");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1034\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4075\"]]");
    p = add_epsg_def_ex (filter, first, last, 4081, "epsg", 4081,
        "REGCAN95", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"REGCAN95\",DATUM[\"Red_Geodesica_de_Canarias_19");
    add_srs_wkt (p, 1,
        "95\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"1035\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4081\"]]");
    p = add_epsg_def_ex (filter, first, last, 4082, "epsg", 4082,
        "REGCAN95 / UTM zone 27N", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / UTM zone 27N\",GEOGCS[\"REGCAN95\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-21],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"4082\"]]");
    p = add_epsg_def_ex (filter, first, last, 4083, "epsg", 4083,
        "REGCAN95 / UTM zone 28N", 0, 0,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_de_Canarias_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"REGCAN95 / UTM zone 28N\",GEOGCS[\"REGCAN95\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1035\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4081\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-15],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"4083\"]]");
    p = add_epsg_def_ex (filter, first, last, 4087, "epsg", 4087,
        "WGS 84 / World Equidistant Cylindrical", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Equirectangular", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +dat");
    add_proj4text (p, 1,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / World Equidistant Cylindrical\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",63781");
    add_srs_wkt (p, 2,
        "37,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Equirectangular\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"4087\"]]");
    p = add_epsg_def_ex (filter, first, last, 4088, "epsg", 4088,
        "World Equidistant Cylindrical (Sphere)", 0, 0,
        "GRS 1980 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_GRS_1980_Authalic_Sphere", "Equirectangular", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "371007 +b=6371007 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"World Equidistant Cylindrical (Sphere)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Unspecified datum based upon the GRS 1980 Authalic Sp");
    add_srs_wkt (p, 2,
        "here\",DATUM[\"Not_specified_based_on_GRS_1980_Authalic_");
    add_srs_wkt (p, 3,
        "Sphere\",SPHEROID[\"GRS 1980 Authalic Sphere\",6371007,0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"7048\"]],AUTHORITY[\"EPSG\",\"6047");
    add_srs_wkt (p, 5,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 6,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 8,
        "AST],AUTHORITY[\"EPSG\",\"4047\"]],PROJECTION[\"Equirect");
    add_srs_wkt (p, 9,
        "angular\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",0],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"4088\"]]");
    p = add_epsg_def_ex (filter, first, last, 4093, "epsg", 4093,
        "ETRS89 / DKTM1", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99998 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / DKTM1\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 1,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "98],PARAMETER[\"false_easting\",200000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"4093\"]]");
    p = add_epsg_def_ex (filter, first, last, 4094, "epsg", 4094,
        "ETRS89 / DKTM2", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10 +k=0.99998 +x_0=400000 +y");
    add_proj4text (p, 1,
        "_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / DKTM2\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 1,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",10],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "998],PARAMETER[\"false_easting\",400000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"4094\"]]");
    p = add_epsg_def_ex (filter, first, last, 4095, "epsg", 4095,
        "ETRS89 / DKTM3", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.75 +k=0.99998 +x_0=600000");
    add_proj4text (p, 1,
        " +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / DKTM3\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 1,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",11.75],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".99998],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4095\"]]");
    p = add_epsg_def_ex (filter, first, last, 4096, "epsg", 4096,
        "ETRS89 / DKTM4", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=800000 +y_0=-50");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / DKTM4\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 1,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",800000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"4096\"]]");
    p = add_epsg_def_ex (filter, first, last, 4097, "epsg", 4097,
        "ETRS89 / DKTM1", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99998 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / DKTM1 + DVR90 height\",PROJCS[\"ETRS");
    add_srs_wkt (p, 1,
        "89 / DKTM1\",GEOGCS[\"ETRS89\",DATUM[\"European_Terrestr");
    add_srs_wkt (p, 2,
        "ial_Reference_System_1989\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",9],PARAMETER[\"scale_factor\",0.99998],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",200000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"4093\"]],VERT_CS[\"DVR90 height\",VERT_DAT");
    add_srs_wkt (p, 15,
        "UM[\"Dansk Vertikal Reference 1990\",2005,AUTHORITY[\"EP");
    add_srs_wkt (p, 16,
        "SG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 17,
        "01\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]],AUT");
    add_srs_wkt (p, 18,
        "HORITY[\"EPSG\",\"4097\"]]");
    p = add_epsg_def_ex (filter, first, last, 4098, "epsg", 4098,
        "ETRS89 / DKTM2", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10 +k=0.99998 +x_0=400000 +y");
    add_proj4text (p, 1,
        "_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / DKTM2 + DVR90 height\",PROJCS[\"ETRS");
    add_srs_wkt (p, 1,
        "89 / DKTM2\",GEOGCS[\"ETRS89\",DATUM[\"European_Terrestr");
    add_srs_wkt (p, 2,
        "ial_Reference_System_1989\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",10],PARAMETER[\"scale_factor\",0.99998],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",400000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"4094\"]],VERT_CS[\"DVR90 height\",VERT_DA");
    add_srs_wkt (p, 15,
        "TUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORITY[\"E");
    add_srs_wkt (p, 16,
        "PSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 17,
        "001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"4098\"]]");
    p = add_epsg_def_ex (filter, first, last, 4099, "epsg", 4099,
        "ETRS89 / DKTM3", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.75 +k=0.99998 +x_0=600000");
    add_proj4text (p, 1,
        " +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / DKTM3 + DVR90 height\",PROJCS[\"ETRS");
    add_srs_wkt (p, 1,
        "89 / DKTM3\",GEOGCS[\"ETRS89\",DATUM[\"European_Terrestr");
    add_srs_wkt (p, 2,
        "ial_Reference_System_1989\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",11.75],PARAMETER[\"scale_factor\",0.99998],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",600000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"4095\"]],VERT_CS[\"DVR90 height\",VERT");
    add_srs_wkt (p, 15,
        "_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORITY[");
    add_srs_wkt (p, 16,
        "\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 17,
        "\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]]");
    add_srs_wkt (p, 18,
        ",AUTHORITY[\"EPSG\",\"4099\"]]");
    p = add_epsg_def_ex (filter, first, last, 4100, "epsg", 4100,
        "ETRS89 / DKTM4", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=800000 +y_0=-50");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vuni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / DKTM4 + DVR90 height\",PROJCS[\"ETRS");
    add_srs_wkt (p, 1,
        "89 / DKTM4\",GEOGCS[\"ETRS89\",DATUM[\"European_Terrestr");
    add_srs_wkt (p, 2,
        "ial_Reference_System_1989\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 5,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",800000],PARAMETER[\"false_northing\",-5000");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"4096\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"");
    add_srs_wkt (p, 15,
        "Dansk Vertikal Reference 1990\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 16,
        "\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 17,
        "],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]],AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"4100\"]]");
    p = add_epsg_def_ex (filter, first, last, 4120, "epsg", 4120,
        "Greek", 1, 1,
        "Bessel 1841", "Greenwich",
        "Greek", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Greek\",DATUM[\"Greek\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 1,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"6120\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 4,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 5,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4120\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4121, "epsg", 4121,
        "GGRS87", 1, 1,
        "GRS 1980", "Greenwich",
        "Greek_Geodetic_Reference_System_1987", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=-199.87,74.79,246.62");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GGRS87\",DATUM[\"Greek_Geodetic_Reference_Syste");
    add_srs_wkt (p, 1,
        "m_1987\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[-199.87,74.79,246.62,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6121\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4121\"]]");
    p = add_epsg_def_ex (filter, first, last, 4122, "epsg", 4122,
        "ATS77", 1, 1,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATS77\",DATUM[\"Average_Terrestrial_System_1977");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Average Terrestrial System 1977\",6378135,");
    add_srs_wkt (p, 2,
        "298.257,AUTHORITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6122\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4122\"]]");
    p = add_epsg_def_ex (filter, first, last, 4123, "epsg", 4123,
        "KKJ", 1, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-96.062,-82.428,-121.");
    add_proj4text (p, 1,
        "753,4.801,0.345,-1.376,1.496 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KKJ\",DATUM[\"Kartastokoordinaattijarjestelma_1");
    add_srs_wkt (p, 1,
        "966\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7022\"]],TOWGS84[-96.062,-82.428,-121.753");
    add_srs_wkt (p, 3,
        ",4.801,0.345,-1.376,1.496],AUTHORITY[\"EPSG\",\"6123\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4123\"]]");
    p = add_epsg_def_ex (filter, first, last, 4124, "epsg", 4124,
        "RT90", 1, 1,
        "Bessel 1841", "Greenwich",
        "Rikets_koordinatsystem_1990", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0");
    add_proj4text (p, 1,
        ".855,2.141,-7.023,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT90\",DATUM[\"Rikets_koordinatsystem_1990\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7004\"]],TOWGS84[414.1,41.3,603.1,-0.855,2.1");
    add_srs_wkt (p, 3,
        "41,-7.023,0],AUTHORITY[\"EPSG\",\"6124\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4124\"]]");
    p = add_epsg_def_ex (filter, first, last, 4125, "epsg", 4125,
        "Samboja", 1, 1,
        "Bessel 1841", "Greenwich",
        "Samboja", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-404.78,685.68,45.4");
    add_proj4text (p, 1,
        "7,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Samboja\",DATUM[\"Samboja\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-404.78,685.68,45.47,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6125\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4125\"]]");
    p = add_epsg_def_ex (filter, first, last, 4126, "epsg", 4126,
        "LKS94 (ETRS89)", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LKS94 (ETRS89)\",DATUM[\"Lithuania_1994_ETRS89\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6126\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4126\"]]");
    p = add_epsg_def_ex (filter, first, last, 4127, "epsg", 4127,
        "Tete", 1, 1,
        "Clarke 1866", "Greenwich",
        "Tete", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-73.472,-51.66,-112");
    add_proj4text (p, 1,
        ".482,0.953,4.6,-2.368,0.586 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tete\",DATUM[\"Tete\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 1,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6127\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"412");
    add_srs_wkt (p, 7,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 4128, "epsg", 4128,
        "Madzansua", 1, 1,
        "Clarke 1866", "Greenwich",
        "Madzansua", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Madzansua\",DATUM[\"Madzansua\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6128\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4128\"]]");
    p = add_epsg_def_ex (filter, first, last, 4129, "epsg", 4129,
        "Observatario", 1, 1,
        "Clarke 1866", "Greenwich",
        "Observatario", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Observatario\",DATUM[\"Observatario\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6129\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4129\"]]");
    p = add_epsg_def_ex (filter, first, last, 4130, "epsg", 4130,
        "Moznet", 1, 1,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Moznet\",DATUM[\"Moznet_ITRF94\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6130\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4130\"]]");
    p = add_epsg_def_ex (filter, first, last, 4131, "epsg", 4131,
        "Indian 1960", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1960", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.413140239 +towgs");
    add_proj4text (p, 1,
        "84=198,881,317,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Indian 1960\",DATUM[\"Indian_1960\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],TOWGS84[198,881,317,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6131\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4131");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4132, "epsg", 4132,
        "FD58", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Final_Datum_1958", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-241.54,-163.64,396");
    add_proj4text (p, 1,
        ".06,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"FD58\",DATUM[\"Final_Datum_1958\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],TOWGS84[-241.54,-163.64,396.06,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6132\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4132\"]]");
    p = add_epsg_def_ex (filter, first, last, 4133, "epsg", 4133,
        "EST92", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1992", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,");
    add_proj4text (p, 1,
        "0.0183,-0.0003,-0.007,-0.014 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"EST92\",DATUM[\"Estonia_1992\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 1,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.0");
    add_srs_wkt (p, 3,
        "14],AUTHORITY[\"EPSG\",\"6133\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "33\"]]");
    p = add_epsg_def_ex (filter, first, last, 4134, "epsg", 4134,
        "PSD93", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,1");
    add_proj4text (p, 1,
        "73.919,-0.81,-1.898,8.336,16.71006 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PSD93\",DATUM[\"PDO_Survey_Datum_1993\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],TOWGS84[-180.624,-225.516,173.919,-0.8");
    add_srs_wkt (p, 3,
        "1,-1.898,8.336,16.71006],AUTHORITY[\"EPSG\",\"6134\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4134\"]]");
    p = add_epsg_def_ex (filter, first, last, 4135, "epsg", 4135,
        "Old Hawaiian", 1, 1,
        "Clarke 1866", "Greenwich",
        "Old_Hawaiian", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Old Hawaiian\",DATUM[\"Old_Hawaiian\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7008\"]],TOWGS84[61,-285,-181,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6135\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4135\"]]");
    p = add_epsg_def_ex (filter, first, last, 4136, "epsg", 4136,
        "St. Lawrence Island", 1, 1,
        "Clarke 1866", "Greenwich",
        "St_Lawrence_Island", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Lawrence Island\",DATUM[\"St_Lawrence_Islan");
    add_srs_wkt (p, 1,
        "d\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6136");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4136\"]]");
    p = add_epsg_def_ex (filter, first, last, 4137, "epsg", 4137,
        "St. Paul Island", 1, 1,
        "Clarke 1866", "Greenwich",
        "St_Paul_Island", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Paul Island\",DATUM[\"St_Paul_Island\",SPHE");
    add_srs_wkt (p, 1,
        "ROID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6137\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4137\"]]");
    p = add_epsg_def_ex (filter, first, last, 4138, "epsg", 4138,
        "St. George Island", 1, 1,
        "Clarke 1866", "Greenwich",
        "St_George_Island", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. George Island\",DATUM[\"St_George_Island\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6138\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4138\"]]");
    p = add_epsg_def_ex (filter, first, last, 4139, "epsg", 4139,
        "Puerto Rico", 1, 1,
        "Clarke 1866", "Greenwich",
        "Puerto_Rico", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Puerto Rico\",DATUM[\"Puerto_Rico\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7008\"]],TOWGS84[11,72,-101,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6139\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4139\"]]");
    p = add_epsg_def_ex (filter, first, last, 4140, "epsg", 4140,
        "NAD83(CSRS98)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS98)\",DATUM[\"NAD83_Canadian_Spatial_");
    add_srs_wkt (p, 1,
        "Reference_System\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "40\"]]");
    p = add_epsg_def_ex (filter, first, last, 4141, "epsg", 4141,
        "Israel", 1, 1,
        "GRS 1980", "Greenwich",
        "Israel", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Israel\",DATUM[\"Israel\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[-48,55,52,0,0,0,0],AUTHORITY[\"EPSG\",\"6141\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4141\"]]");
    p = add_epsg_def_ex (filter, first, last, 4142, "epsg", 4142,
        "Locodjo 1965", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Locodjo_1965", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Locodjo 1965\",DATUM[\"Locodjo_1965\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-125,53,467,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6142\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4142\"]]");
    p = add_epsg_def_ex (filter, first, last, 4143, "epsg", 4143,
        "Abidjan 1987", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Abidjan_1987", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-124.76,53,466.79,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Abidjan 1987\",DATUM[\"Abidjan_1987\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],TOWGS84[-124.76,53,466.79,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6143\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4143\"]]");
    p = add_epsg_def_ex (filter, first, last, 4144, "epsg", 4144,
        "Kalianpur 1937", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.413140239 +towgs");
    add_proj4text (p, 1,
        "84=214,804,268,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kalianpur 1937\",DATUM[\"Kalianpur_1937\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Everest 1830 (1937 Adjustment)\",6377276.345,300.8");
    add_srs_wkt (p, 2,
        "017,AUTHORITY[\"EPSG\",\"7015\"]],TOWGS84[214,804,268,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4144\"]]");
    p = add_epsg_def_ex (filter, first, last, 4145, "epsg", 4145,
        "Kalianpur 1962", 1, 1,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377301.243 +b=6356100.230165385 +towgs");
    add_proj4text (p, 1,
        "84=283,682,231,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kalianpur 1962\",DATUM[\"Kalianpur_1962\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Everest 1830 (1962 Definition)\",6377301.243,300.8");
    add_srs_wkt (p, 2,
        "017255,AUTHORITY[\"EPSG\",\"7044\"]],TOWGS84[283,682,231");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4145\"]]");
    p = add_epsg_def_ex (filter, first, last, 4146, "epsg", 4146,
        "Kalianpur 1975", 1, 1,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.151 +b=6356098.145120132 +towgs");
    add_proj4text (p, 1,
        "84=295,736,257,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kalianpur 1975\",DATUM[\"Kalianpur_1975\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Everest 1830 (1975 Definition)\",6377299.151,300.8");
    add_srs_wkt (p, 2,
        "017255,AUTHORITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4146\"]]");
    p = add_epsg_def_ex (filter, first, last, 4147, "epsg", 4147,
        "Hanoi 1972", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Hanoi_1972", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=-17.51,-108.32,-62.3");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hanoi 1972\",DATUM[\"Hanoi_1972\",SPHEROID[\"Kr");
    add_srs_wkt (p, 1,
        "assowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[-17.51,-108.32,-62.39,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6147\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4147\"]]");
    p = add_epsg_def_ex (filter, first, last, 4148, "epsg", 4148,
        "Hartebeesthoek94", 1, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hartebeesthoek94\",DATUM[\"Hartebeesthoek94\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4148\"]]");
    p = add_epsg_def_ex (filter, first, last, 4149, "epsg", 4149,
        "CH1903", 1, 1,
        "Bessel 1841", "Greenwich",
        "CH1903", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CH1903\",DATUM[\"CH1903\",SPHEROID[\"Bessel 184");
    add_srs_wkt (p, 1,
        "1\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[674.4,15.1,405.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6149\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4149\"]]");
    p = add_epsg_def_ex (filter, first, last, 4150, "epsg", 4150,
        "CH1903+", 1, 1,
        "Bessel 1841", "Greenwich",
        "CH1903+", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.");
    add_proj4text (p, 1,
        "346,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CH1903+\",DATUM[\"CH1903+\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],TOWGS84[674.374,15.056,405.346,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6150\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 6,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4150\"]]");
    p = add_epsg_def_ex (filter, first, last, 4151, "epsg", 4151,
        "CHTRF95", 1, 1,
        "GRS 1980", "Greenwich",
        "Swiss_Terrestrial_Reference_Frame_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CHTRF95\",DATUM[\"Swiss_Terrestrial_Reference_F");
    add_srs_wkt (p, 1,
        "rame_1995\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6151\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4151\"]]");
    p = add_epsg_def_ex (filter, first, last, 4152, "epsg", 4152,
        "NAD83(HARN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 1,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 6,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4153, "epsg", 4153,
        "Rassadiran", 1, 1,
        "International 1924", "Greenwich",
        "Rassadiran", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-133.63,-157.5,-158.6");
    add_proj4text (p, 1,
        "2,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Rassadiran\",DATUM[\"Rassadiran\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],TOWGS84[-133.63,-157.5,-158.62,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6153\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4153\"]]");
    p = add_epsg_def_ex (filter, first, last, 4154, "epsg", 4154,
        "ED50(ED77)", 1, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950_1977", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-117,-132,-164,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED50(ED77)\",DATUM[\"European_Datum_1950_1977\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-117,-132,-164,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6154\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4154\"]]");
    p = add_epsg_def_ex (filter, first, last, 4155, "epsg", 4155,
        "Dabola 1981", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Dabola_1981", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83,37,12");
    add_proj4text (p, 1,
        "4,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dabola 1981\",DATUM[\"Dabola_1981\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7011\"]],TOWGS84[-83,37,124,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6155\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4155\"]]");
    p = add_epsg_def_ex (filter, first, last, 4156, "epsg", 4156,
        "S-JTSK", 1, 1,
        "Bessel 1841", "Greenwich",
        "System_Jednotne_Trigonometricke_Site_Katastralni", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK\",DATUM[\"System_Jednotne_Trigonometrick");
    add_srs_wkt (p, 1,
        "e_Site_Katastralni\",SPHEROID[\"Bessel 1841\",6377397.15");
    add_srs_wkt (p, 2,
        "5,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[589,");
    add_srs_wkt (p, 3,
        "76,480,0,0,0,0],AUTHORITY[\"EPSG\",\"6156\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4156\"]]");
    p = add_epsg_def_ex (filter, first, last, 4157, "epsg", 4157,
        "Mount Dillon", 1, 1,
        "Clarke 1858", "Greenwich",
        "Mount_Dillon", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mount Dillon\",DATUM[\"Mount_Dillon\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1858\",6378293.645208759,294.2606763692606,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6157\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4157\"]]");
    p = add_epsg_def_ex (filter, first, last, 4158, "epsg", 4158,
        "Naparima 1955", 1, 1,
        "International 1924", "Greenwich",
        "Naparima_1955", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-0.465,372.095,171.73");
    add_proj4text (p, 1,
        "6,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Naparima 1955\",DATUM[\"Naparima_1955\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],TOWGS84[-0.465,372.095,171.736,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6158\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4158\"]]");
    p = add_epsg_def_ex (filter, first, last, 4159, "epsg", 4159,
        "ELD79", 1, 1,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-115.8543,-99.0583,-1");
    add_proj4text (p, 1,
        "52.4616,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ELD79\",DATUM[\"European_Libyan_Datum_1979\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7022\"]],TOWGS84[-115.8543,-99.0583,-152.4616,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4159\"]]");
    p = add_epsg_def_ex (filter, first, last, 4160, "epsg", 4160,
        "Chos Malal 1914", 1, 1,
        "International 1924", "Greenwich",
        "Chos_Malal_1914", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chos Malal 1914\",DATUM[\"Chos_Malal_1914\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6160\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4160\"]]");
    p = add_epsg_def_ex (filter, first, last, 4161, "epsg", 4161,
        "Pampa del Castillo", 1, 1,
        "International 1924", "Greenwich",
        "Pampa_del_Castillo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pampa del Castillo\",DATUM[\"Pampa_del_Castillo");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],TOWGS84[27.5,14,186.4,0,0,0,0],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6161\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4161\"]]");
    p = add_epsg_def_ex (filter, first, last, 4162, "epsg", 4162,
        "Korean 1985", 1, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Korean 1985\",DATUM[\"Korean_Datum_1985\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4162\"]]");
    p = add_epsg_def_ex (filter, first, last, 4163, "epsg", 4163,
        "Yemen NGN96", 1, 1,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yemen NGN96\",DATUM[\"Yemen_National_Geodetic_N");
    add_srs_wkt (p, 1,
        "etwork_1996\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6163\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4163\"]]");
    p = add_epsg_def_ex (filter, first, last, 4164, "epsg", 4164,
        "South Yemen", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "South_Yemen", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=-76,-138,67,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"South Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 2,
        "4\"]],TOWGS84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6164\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4164\"]]");
    p = add_epsg_def_ex (filter, first, last, 4165, "epsg", 4165,
        "Bissau", 1, 1,
        "International 1924", "Greenwich",
        "Bissau", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-173,253,27,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bissau\",DATUM[\"Bissau\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 1,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[-173,253,27,0,0,0,0],AUTHORITY[\"EPSG\",\"6165\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4165\"]]");
    p = add_epsg_def_ex (filter, first, last, 4166, "epsg", 4166,
        "Korean 1995", 1, 1,
        "WGS 84", "Greenwich",
        "Korean_Datum_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Korean 1995\",DATUM[\"Korean_Datum_1995\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "166\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"4166\"]]");
    p = add_epsg_def_ex (filter, first, last, 4167, "epsg", 4167,
        "NZGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2");
    add_srs_wkt (p, 1,
        "000\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4167\"]]");
    p = add_epsg_def_ex (filter, first, last, 4168, "epsg", 4168,
        "Accra", 1, 1,
        "War Office", "Greenwich",
        "Accra", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300 +b=6356751.689189189 +towgs84=-");
    add_proj4text (p, 1,
        "199,32,322,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Accra\",DATUM[\"Accra\",SPHEROID[\"War Office\"");
    add_srs_wkt (p, 1,
        ",6378300,296,AUTHORITY[\"EPSG\",\"7029\"]],TOWGS84[-199,");
    add_srs_wkt (p, 2,
        "32,322,0,0,0,0],AUTHORITY[\"EPSG\",\"6168\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4168\"]]");
    p = add_epsg_def_ex (filter, first, last, 4169, "epsg", 4169,
        "American Samoa 1962", 1, 1,
        "Clarke 1866", "Greenwich",
        "American_Samoa_1962", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-115,118,426,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"American Samoa 1962\",DATUM[\"American_Samoa_19");
    add_srs_wkt (p, 1,
        "62\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898");
    add_srs_wkt (p, 2,
        "2,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS84[-115,118,426,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6169\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4169\"]]");
    p = add_epsg_def_ex (filter, first, last, 4170, "epsg", 4170,
        "SIRGAS 1995", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS 1995\",DATUM[\"Sistema_de_Referencia_Geo");
    add_srs_wkt (p, 1,
        "centrico_para_America_del_Sur_1995\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6170\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4170\"]]");
    p = add_epsg_def_ex (filter, first, last, 4171, "epsg", 4171,
        "RGF93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGF93\",DATUM[\"Reseau_Geodesique_Francais_1993");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6171\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4171\"]]");
    p = add_epsg_def_ex (filter, first, last, 4172, "epsg", 4172,
        "POSGAR", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR\",DATUM[\"Posiciones_Geodesicas_Argentin");
    add_srs_wkt (p, 1,
        "as\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6172\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 6,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4172\"]]");
    p = add_epsg_def_ex (filter, first, last, 4173, "epsg", 4173,
        "IRENET95", 1, 1,
        "GRS 1980", "Greenwich",
        "IRENET95", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IRENET95\",DATUM[\"IRENET95\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6173\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4173\"]]");
    p = add_epsg_def_ex (filter, first, last, 4174, "epsg", 4174,
        "Sierra Leone 1924", 1, 1,
        "War Office", "Greenwich",
        "Sierra_Leone_Colony_1924", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sierra Leone 1924\",DATUM[\"Sierra_Leone_Colony");
    add_srs_wkt (p, 1,
        "_1924\",SPHEROID[\"War Office\",6378300,296,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7029\"]],AUTHORITY[\"EPSG\",\"6174\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4174\"]]");
    p = add_epsg_def_ex (filter, first, last, 4175, "epsg", 4175,
        "Sierra Leone 1968", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Sierra_Leone_1968", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sierra Leone 1968\",DATUM[\"Sierra_Leone_1968\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7012\"]],TOWGS84[-88,4,101,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6175\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4175\"]]");
    p = add_epsg_def_ex (filter, first, last, 4176, "epsg", 4176,
        "Australian Antarctic", 1, 1,
        "GRS 1980", "Greenwich",
        "Australian_Antarctic_Datum_1998", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Australian Antarctic\",DATUM[\"Australian_Antar");
    add_srs_wkt (p, 1,
        "ctic_Datum_1998\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6176\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "76\"]]");
    p = add_epsg_def_ex (filter, first, last, 4178, "epsg", 4178,
        "Pulkovo 1942(83)", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=26,-121,-78,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]]");
    p = add_epsg_def_ex (filter, first, last, 4179, "epsg", 4179,
        "Pulkovo 1942(58)", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=33.4,-146.6,-76.3,-0");
    add_proj4text (p, 1,
        ".359,-0.053,0.844,-0.84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_srs_wkt (p, 3,
        ".844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4179\"]]");
    p = add_epsg_def_ex (filter, first, last, 4180, "epsg", 4180,
        "EST97", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1997", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"EST97\",DATUM[\"Estonia_1997\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 1,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6180\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4180\"]]");
    p = add_epsg_def_ex (filter, first, last, 4181, "epsg", 4181,
        "Luxembourg 1930", 1, 1,
        "International 1924", "Greenwich",
        "Luxembourg_1930", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189.6806,18.3463,-42");
    add_proj4text (p, 1,
        ".7695,-0.33746,-3.09264,2.53861,0.4598 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Luxembourg 1930\",DATUM[\"Luxembourg_1930\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-189.6806,18.3463,-42.7695,-0.337");
    add_srs_wkt (p, 3,
        "46,-3.09264,2.53861,0.4598],AUTHORITY[\"EPSG\",\"6181\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4181\"]]");
    p = add_epsg_def_ex (filter, first, last, 4182, "epsg", 4182,
        "Azores Occidental 1939", 1, 1,
        "International 1924", "Greenwich",
        "Azores_Occidental_Islands_1939", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-425,-169,81,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Occidental 1939\",DATUM[\"Azores_Occiden");
    add_srs_wkt (p, 1,
        "tal_Islands_1939\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 2,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-425,-169,8");
    add_srs_wkt (p, 3,
        "1,0,0,0,0],AUTHORITY[\"EPSG\",\"6182\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4182\"]]");
    p = add_epsg_def_ex (filter, first, last, 4183, "epsg", 4183,
        "Azores Central 1948", 1, 1,
        "International 1924", "Greenwich",
        "Azores_Central_Islands_1948", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104,167,-38,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Central 1948\",DATUM[\"Azores_Central_Is");
    add_srs_wkt (p, 1,
        "lands_1948\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-104,167,-38,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6183\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4183\"]]");
    p = add_epsg_def_ex (filter, first, last, 4184, "epsg", 4184,
        "Azores Oriental 1940", 1, 1,
        "International 1924", "Greenwich",
        "Azores_Oriental_Islands_1940", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-203,141,53,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Oriental 1940\",DATUM[\"Azores_Oriental_");
    add_srs_wkt (p, 1,
        "Islands_1940\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-203,141,53,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6184\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4184\"]]");
    p = add_epsg_def_ex (filter, first, last, 4185, "epsg", 4185,
        "Madeira 1936", 1, 1,
        "International 1924", "Greenwich",
        "Madeira_1936", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Madeira 1936\",DATUM[\"Madeira_1936\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6185\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4185\"]]");
    p = add_epsg_def_ex (filter, first, last, 4188, "epsg", 4188,
        "OSNI 1952", 1, 1,
        "Airy 1830", "Greenwich",
        "OSNI_1952", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +towgs84=482.5,-130.6,564.6,-1");
    add_proj4text (p, 1,
        ".042,-0.214,-0.631,8.15 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OSNI 1952\",DATUM[\"OSNI_1952\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],TOWGS84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.");
    add_srs_wkt (p, 3,
        "15],AUTHORITY[\"EPSG\",\"6188\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 7,
        "88\"]]");
    p = add_epsg_def_ex (filter, first, last, 4189, "epsg", 4189,
        "REGVEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"REGVEN\",DATUM[\"Red_Geodesica_Venezolana\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6189\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4189\"]]");
    p = add_epsg_def_ex (filter, first, last, 4190, "epsg", 4190,
        "POSGAR 98", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR 98\",DATUM[\"Posiciones_Geodesicas_Argen");
    add_srs_wkt (p, 1,
        "tinas_1998\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4190\"]");
    add_srs_wkt (p, 7,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4191, "epsg", 4191,
        "Albanian 1987", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Albanian_1987", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Albanian 1987\",DATUM[\"Albanian_1987\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7024\"]],AUTHORITY[\"EPSG\",\"6191\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4191\"]]");
    p = add_epsg_def_ex (filter, first, last, 4192, "epsg", 4192,
        "Douala 1948", 1, 1,
        "International 1924", "Greenwich",
        "Douala_1948", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-206.1,-174.7,-87.7,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Douala 1948\",DATUM[\"Douala_1948\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[-206.1,-174.7,-87.7,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6192\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4192\"]]");
    p = add_epsg_def_ex (filter, first, last, 4193, "epsg", 4193,
        "Manoca 1962", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Manoca_1962", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-70.9,-15");
    add_proj4text (p, 1,
        "1.8,-41.4,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Manoca 1962\",DATUM[\"Manoca_1962\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7011\"]],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6193\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"419");
    add_srs_wkt (p, 7,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 4194, "epsg", 4194,
        "Qornoq 1927", 1, 1,
        "International 1924", "Greenwich",
        "Qornoq_1927", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qornoq 1927\",DATUM[\"Qornoq_1927\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],TOWGS84[164,138,-189,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6194\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4194\"]]");
    p = add_epsg_def_ex (filter, first, last, 4195, "epsg", 4195,
        "Scoresbysund 1952", 1, 1,
        "International 1924", "Greenwich",
        "Scoresbysund_1952", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=105,326,-102.5,0,0,0.");
    add_proj4text (p, 1,
        "814,-0.6 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Scoresbysund 1952\",DATUM[\"Scoresbysund_1952\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[105,326,-102.5,0,0,0.814,-0.6]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6195\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4195");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4196, "epsg", 4196,
        "Ammassalik 1958", 1, 1,
        "International 1924", "Greenwich",
        "Ammassalik_1958", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-45,417,-3.5,0,0,0.81");
    add_proj4text (p, 1,
        "4,-0.6 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ammassalik 1958\",DATUM[\"Ammassalik_1958\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],TOWGS84[-45,417,-3.5,0,0,0.814,-0.6],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6196\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4196\"]]");
    p = add_epsg_def_ex (filter, first, last, 4197, "epsg", 4197,
        "Garoua", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Garoua", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Garoua\",DATUM[\"Garoua\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6197\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 6,
        "97\"]]");
    p = add_epsg_def_ex (filter, first, last, 4198, "epsg", 4198,
        "Kousseri", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kousseri", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kousseri\",DATUM[\"Kousseri\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],AUTHORITY[\"EPSG\",\"6198\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4198\"]]");
    p = add_epsg_def_ex (filter, first, last, 4199, "epsg", 4199,
        "Egypt 1930", 1, 1,
        "International 1924", "Greenwich",
        "Egypt_1930", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt 1930\",DATUM[\"Egypt_1930\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6199\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4199\"]]");
    p = add_epsg_def_ex (filter, first, last, 4200, "epsg", 4200,
        "Pulkovo 1995", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=24.47,-130.89,-81.56");
    add_proj4text (p, 1,
        ",0,0,0.13,-0.22 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    p = add_epsg_def_ex (filter, first, last, 4201, "epsg", 4201,
        "Adindan", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Adindan\",DATUM[\"Adindan\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 1,
        "880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 2,
        "2\"]],TOWGS84[-166,-15,204,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6201\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4201\"]]");
    p = add_epsg_def_ex (filter, first, last, 4202, "epsg", 4202,
        "AGD66", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-117.808,-51.536,1");
    add_proj4text (p, 1,
        "37.784,0.303,0.446,0.234,-0.29 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"AGD66\",DATUM[\"Australian_Geodetic_Datum_1966\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Australian National Spheroid\",6378160,298.2");
    add_srs_wkt (p, 2,
        "5,AUTHORITY[\"EPSG\",\"7003\"]],TOWGS84[-117.808,-51.536");
    add_srs_wkt (p, 3,
        ",137.784,0.303,0.446,0.234,-0.29],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "202\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4202\"]]");
    p = add_epsg_def_ex (filter, first, last, 4203, "epsg", 4203,
        "AGD84", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-134,-48,149,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"AGD84\",DATUM[\"Australian_Geodetic_Datum_1984\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Australian National Spheroid\",6378160,298.2");
    add_srs_wkt (p, 2,
        "5,AUTHORITY[\"EPSG\",\"7003\"]],TOWGS84[-134,-48,149,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4203\"]]");
    p = add_epsg_def_ex (filter, first, last, 4204, "epsg", 4204,
        "Ain el Abd", 1, 1,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ain el Abd\",DATUM[\"Ain_el_Abd_1970\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],TOWGS84[-143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6204\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4204\"]]");
    p = add_epsg_def_ex (filter, first, last, 4205, "epsg", 4205,
        "Afgooye", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=-43,-163,45,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Afgooye\",DATUM[\"Afgooye\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 1,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 2,
        "WGS84[-43,-163,45,0,0,0,0],AUTHORITY[\"EPSG\",\"6205\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4205\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

