/*++

Module Name:

    BiasTables.cpp

Abstract:

    Headers for the index builder for the SNAP sequencer

Authors:

    Bill Bolosky, August, 2011

Environment:
`
    User mode service.

Revision History:

    Adapted from Matei Zaharia's Scala implementation.

--*/

#include "stdafx.h"
#include "GenomeIndex.h"

static double hg19_biasTable16_4_large[] = {
0.254
};

static double hg19_biasTable17_4_large[] = {
0.865,0.479,0.287,0.142
};

static double hg19_biasTable18_4_large[] = {
1.651,1.163,0.790,1.059,0.782,0.624,0.464,0.514,0.628,0.079,
0.360,0.419,0.337,0.249,0.129,0.079
};


static double hg19_biasTable19_4_large[] = {
2.965,1.703,1.192,1.948,1.701,1.301,1.013,1.179,1.427,0.184,
0.779,1.106,1.361,1.205,0.831,1.467,1.226,0.947,0.563,0.741,
0.859,0.721,0.579,0.576,0.735,0.109,0.533,0.649,0.554,0.655,
0.424,0.632,0.793,0.788,0.536,0.686,0.076,0.090,0.070,0.088,
0.596,0.078,0.392,0.511,0.419,0.536,0.396,0.523,0.564,0.318,
0.262,0.430,0.371,0.286,0.207,0.273,0.247,0.021,0.144,0.190,
0.170,0.102,0.073,0.052
};

static double hg19_biasTable20_4_large[] = {
4.920,2.660,1.990,3.590,2.420,1.690,1.330,1.750,2.110,0.228,
1.050,1.630,2.550,2.060,1.320,2.460,2.630,1.860,1.150,1.590,
1.770,1.330,1.160,1.190,1.580,0.193,1.130,1.340,1.210,1.340,
0.934,1.440,1.690,1.570,1.150,1.620,0.173,0.185,0.149,0.239,
1.180,0.152,0.816,1.090,0.971,1.290,0.937,1.420,1.980,1.070,
0.950,1.870,1.500,1.170,0.940,1.450,1.240,0.123,0.829,1.280,
1.540,1.110,1.220,2.460,1.980,1.280,0.740,1.190,1.320,1.100,
0.744,0.808,0.940,0.129,0.523,0.742,0.799,0.887,0.500,0.910,
1.270,1.060,0.554,0.717,0.972,0.773,0.642,0.630,0.867,0.157,
0.627,0.784,0.559,0.748,0.457,0.650,0.813,0.930,0.550,0.725,
0.092,0.139,0.102,0.103,0.776,0.130,0.557,0.726,0.519,0.853,
0.560,0.750,0.746,0.513,0.370,0.662,0.768,0.720,0.490,0.713,
0.625,0.065,0.421,0.637,0.599,0.563,0.516,0.987,1.300,0.779,
0.539,0.769,1.030,0.845,0.705,0.740,0.927,0.137,0.526,0.690,
0.706,0.712,0.559,0.931,0.089,0.100,0.052,0.069,0.087,0.118,
0.092,0.071,0.084,0.032,0.088,0.085,0.074,0.123,0.070,0.095,
0.659,0.711,0.516,0.592,0.072,0.087,0.077,0.080,0.632,0.094,
0.398,0.516,0.411,0.606,0.505,0.600,0.552,0.376,0.334,0.498,
0.631,0.562,0.471,0.590,0.581,0.063,0.447,0.602,0.484,0.452,
0.514,0.780,0.998,0.452,0.346,0.651,0.453,0.292,0.250,0.326,
0.469,0.046,0.231,0.365,0.558,0.387,0.296,0.637,0.556,0.394,
0.252,0.352,0.371,0.314,0.237,0.262,0.315,0.031,0.221,0.301,
0.295,0.308,0.208,0.341,0.305,0.266,0.191,0.274,0.022,0.021,
0.016,0.025,0.225,0.020,0.150,0.212,0.194,0.209,0.173,0.242,
0.284,0.138,0.120,0.213,0.144,0.103,0.080,0.115,0.131,8.64e-3,
0.078,0.109,0.108,0.060,0.044,0.032
};

static double hg19_biasTable21_4_large[] = {
8.140,3.930,3.150,5.960,3.900,2.420,2.020,2.680,3.590,0.364,
1.660,2.610,4.940,3.720,2.260,4.110,3.870,2.360,1.610,2.200,
2.440,1.590,1.400,1.500,2.200,0.216,1.370,1.650,1.900,1.850,
1.370,2.060,2.780,2.020,1.560,2.360,0.242,0.199,0.168,0.310,
1.670,0.168,1.050,1.410,1.530,1.770,1.370,2.020,3.890,1.810,
1.660,3.340,2.660,1.800,1.530,2.470,2.050,0.182,1.260,1.920,
2.800,1.770,1.940,3.740,4.430,2.480,1.520,2.480,2.760,1.940,
1.390,1.560,2.010,0.254,1.000,1.440,1.790,1.850,1.020,1.850,
2.720,2.000,1.110,1.450,1.860,1.300,1.150,1.140,1.820,0.268,
1.170,1.510,1.200,1.460,0.923,1.280,1.870,1.860,1.180,1.530,
0.200,0.212,0.170,0.199,1.740,0.241,1.150,1.490,1.130,1.700,
1.190,1.460,1.670,1.120,0.779,1.370,1.710,1.410,0.996,1.390,
1.430,0.134,0.907,1.340,1.370,1.200,1.180,2.160,2.860,1.380,
1.090,1.680,2.170,1.470,1.300,1.510,2.170,0.273,0.928,1.350,
1.790,1.570,1.130,2.180,0.220,0.189,0.117,0.174,0.208,0.204,
0.164,0.173,0.202,0.048,0.167,0.186,0.219,0.321,0.167,0.264,
1.320,1.200,1.080,1.240,0.146,0.132,0.163,0.184,1.250,0.175,
0.856,1.040,0.902,1.250,1.060,1.220,1.240,0.789,0.748,1.200,
1.530,1.210,1.100,1.440,1.350,0.151,0.972,1.350,1.290,1.210,
1.280,2.060,3.430,1.370,1.120,2.350,1.490,0.894,0.849,1.150,
1.730,0.175,0.766,1.240,2.410,1.580,1.160,2.700,2.210,1.460,
1.020,1.480,1.510,1.150,0.985,1.130,1.430,0.140,0.952,1.320,
1.550,1.570,1.070,1.810,1.410,1.220,1.050,1.420,0.128,0.106,
0.115,0.154,1.200,0.119,0.859,1.190,1.110,1.360,1.200,1.590,
2.100,1.140,1.050,2.100,1.290,0.936,0.919,1.380,1.760,0.142,
1.190,1.910,2.470,1.930,2.050,3.910,3.010,1.830,1.270,2.100,
1.740,1.360,1.010,1.150,1.230,0.149,0.643,0.992,1.340,1.300,
0.812,1.440,1.910,1.480,0.923,1.150,1.410,1.160,1.030,0.929,
1.060,0.163,0.861,0.984,0.734,0.950,0.679,0.976,1.020,1.090,
0.754,0.967,0.118,0.152,0.111,0.141,0.726,0.102,0.580,0.712,
0.592,0.842,0.654,0.938,1.090,0.631,0.561,0.974,1.080,0.958,
0.669,0.898,0.728,0.083,0.503,0.731,0.885,0.685,0.752,1.440,
1.930,1.470,0.720,1.100,1.390,1.350,0.800,0.811,0.908,0.142,
0.498,0.705,0.712,0.891,0.481,0.858,1.330,1.260,0.641,0.754,
1.030,0.716,0.739,0.684,0.926,0.208,0.672,0.849,0.539,0.862,
0.529,0.679,0.872,1.190,0.652,0.791,0.122,0.229,0.145,0.131,
0.887,0.190,0.644,0.823,0.532,1.110,0.691,0.855,0.704,0.566,
0.377,0.600,0.844,0.954,0.548,0.674,0.672,0.082,0.448,0.657,
0.571,0.615,0.518,0.963,1.230,0.807,0.520,0.769,1.120,1.020,
0.836,0.787,0.902,0.151,0.527,0.686,0.676,0.789,0.577,0.952,
0.090,0.133,0.066,0.084,0.116,0.200,0.148,0.096,0.105,0.066,
0.137,0.112,0.070,0.172,0.088,0.100,0.778,0.917,0.716,0.736,
0.113,0.156,0.136,0.110,0.790,0.159,0.600,0.705,0.484,0.927,
0.753,0.789,0.637,0.446,0.421,0.611,0.877,0.953,0.765,0.839,
0.746,0.094,0.619,0.809,0.592,0.635,0.740,1.090,1.130,0.637,
0.478,0.812,0.683,0.501,0.410,0.501,0.627,0.065,0.330,0.497,
0.750,0.601,0.456,0.946,0.980,0.858,0.563,0.746,0.787,0.845,
0.625,0.684,0.659,0.100,0.539,0.714,0.611,0.955,0.561,0.850,
0.623,0.668,0.543,0.686,0.057,0.074,0.056,0.070,0.541,0.067,
0.465,0.612,0.471,0.676,0.630,0.802,0.779,0.475,0.438,0.720,
0.630,0.569,0.441,0.635,0.699,0.065,0.523,0.827,0.876,0.836,
0.868,1.510,1.910,1.220,0.849,1.420,1.010,0.821,0.569,0.772,
0.922,0.101,0.493,0.699,0.909,0.802,0.504,0.938,1.450,1.230,
0.652,0.894,1.090,0.918,0.755,0.727,1.040,0.147,0.832,0.883,
0.688,0.951,0.554,0.835,0.916,1.080,0.799,0.959,0.115,0.146,
0.117,0.170,0.764,0.126,0.552,0.685,0.522,0.905,0.572,0.842,
0.894,0.590,0.482,0.919,0.801,0.740,0.555,0.818,0.787,0.088,
0.558,0.847,0.827,0.686,0.766,1.570,0.115,0.102,0.058,0.086,
0.116,0.137,0.076,0.080,0.076,0.019,0.056,0.065,0.063,0.088,
0.049,0.081,0.104,0.127,0.057,0.066,0.130,0.163,0.109,0.085,
0.101,0.047,0.129,0.102,0.057,0.107,0.057,0.070,0.068,0.118,
0.075,0.073,0.019,0.045,0.043,0.021,0.094,0.039,0.110,0.103,
0.052,0.122,0.081,0.091,0.089,0.069,0.048,0.091,0.120,0.153,
0.099,0.125,0.085,0.017,0.077,0.107,0.078,0.083,0.080,0.146,
1.010,0.704,0.456,0.547,0.810,0.827,0.686,0.594,0.779,0.142,
0.588,0.629,0.522,0.643,0.533,0.741,0.079,0.110,0.052,0.054,
0.076,0.119,0.103,0.056,0.089,0.040,0.108,0.080,0.061,0.119,
0.073,0.075,0.651,0.837,0.549,0.553,0.082,0.121,0.097,0.082,
0.679,0.116,0.355,0.486,0.369,0.645,0.517,0.571,0.524,0.403,
0.333,0.433,0.643,0.717,0.552,0.599,0.687,0.094,0.632,0.704,
0.476,0.548,0.611,0.830,0.844,0.488,0.345,0.604,0.521,0.373,
0.284,0.355,0.524,0.058,0.324,0.473,0.556,0.463,0.339,0.699,
0.866,0.722,0.424,0.564,0.686,0.673,0.490,0.455,0.645,0.082,
0.541,0.645,0.555,0.707,0.477,0.673,0.625,0.663,0.459,0.607,
0.059,0.075,0.052,0.064,0.611,0.073,0.495,0.615,0.477,0.695,
0.557,0.715,0.644,0.407,0.358,0.564,0.521,0.472,0.369,0.483,
0.678,0.063,0.602,0.771,0.726,0.688,0.714,1.120,1.720,0.744,
0.560,1.190,0.632,0.387,0.323,0.501,0.601,0.055,0.276,0.492,
0.847,0.565,0.391,0.904,0.741,0.417,0.268,0.443,0.417,0.262,
0.224,0.301,0.407,0.033,0.230,0.348,0.370,0.312,0.228,0.428,
0.567,0.443,0.312,0.584,0.046,0.039,0.029,0.069,0.360,0.032,
0.206,0.345,0.350,0.367,0.269,0.505,0.765,0.380,0.358,0.813,
0.468,0.315,0.281,0.524,0.443,0.034,0.267,0.474,0.652,0.423,
0.455,1.130,0.888,0.519,0.324,0.572,0.556,0.430,0.297,0.361,
0.420,0.044,0.232,0.356,0.394,0.385,0.229,0.463,0.575,0.421,
0.214,0.327,0.448,0.359,0.239,0.279,0.363,0.040,0.248,0.338,
0.272,0.303,0.183,0.314,0.371,0.358,0.219,0.347,0.030,0.037,
0.026,0.037,0.329,0.036,0.216,0.328,0.267,0.356,0.235,0.389,
0.409,0.246,0.195,0.383,0.365,0.310,0.225,0.391,0.310,0.026,
0.200,0.336,0.332,0.292,0.266,0.550,0.490,0.260,0.196,0.298,
0.347,0.245,0.211,0.278,0.316,0.036,0.175,0.262,0.274,0.243,
0.212,0.385,0.028,0.023,0.014,0.022,0.022,0.026,0.018,0.021,
0.020,3.59e-3,0.018,0.024,0.022,0.027,0.018,0.030,0.259,0.244,
0.161,0.240,0.019,0.019,0.016,0.027,0.239,0.024,0.151,0.211,
0.179,0.218,0.191,0.270,0.256,0.166,0.146,0.227,0.250,0.191,
0.165,0.253,0.255,0.020,0.177,0.277,0.226,0.184,0.220,0.363,
0.524,0.202,0.156,0.307,0.196,0.120,0.102,0.145,0.206,0.018,
0.099,0.172,0.259,0.165,0.138,0.328,0.226,0.130,0.084,0.137,
0.136,0.101,0.077,0.102,0.118,8.24e-3,0.078,0.122,0.125,0.108,
0.082,0.161,0.173,0.131,0.089,0.153,9.87e-3,8.09e-3,5.22e-3,0.012,
0.125,8.63e-3,0.076,0.120,0.117,0.110,0.091,0.145,0.194,0.078,
0.070,0.136,0.084,0.057,0.044,0.070,0.078,3.97e-3,0.045,0.068,
0.069,0.031,0.026,0.019
};

static double hg19_biasTable22_4_large[] = {
15.4,5.960,4.400,9.020,6.010,3.350,2.840,3.940,5.930,0.553,
2.530,3.940,8.530,5.870,3.620,6.610,6.670,3.510,2.450,3.410,
3.650,2.210,1.940,2.040,3.540,0.290,1.940,2.440,3.070,2.670,
2.020,3.140,5.090,3.240,2.580,3.840,0.400,0.317,0.256,0.493,
2.760,0.257,1.590,2.140,2.620,2.850,2.090,3.060,7.650,3.180,
3.170,6.440,4.700,3.100,2.760,4.620,3.630,0.295,2.050,3.230,
5.140,2.990,3.110,5.640,7.070,3.300,2.100,3.450,3.580,2.340,
1.660,1.990,2.930,0.311,1.320,1.960,2.600,2.460,1.400,2.480,
4.050,2.520,1.450,1.940,2.340,1.550,1.270,1.290,2.360,0.253,
1.340,1.750,1.600,1.680,1.180,1.590,2.850,2.460,1.530,2.100,
0.253,0.225,0.170,0.228,2.290,0.242,1.320,1.720,1.480,2.020,
1.360,1.820,2.660,1.670,1.230,2.150,2.430,1.810,1.360,1.910,
2.230,0.180,1.270,1.880,2.130,1.710,1.610,2.920,4.980,2.040,
1.810,2.600,2.940,1.730,1.630,1.910,2.780,0.330,1.230,1.990,
2.560,2.160,1.650,3.220,0.342,0.242,0.155,0.234,0.246,0.211,
0.163,0.182,0.238,0.044,0.165,0.228,0.297,0.377,0.215,0.358,
2.030,1.610,1.450,1.680,0.188,0.149,0.144,0.196,1.680,0.194,
1.050,1.330,1.260,1.530,1.360,1.560,1.990,1.210,1.160,1.850,
2.230,1.620,1.390,1.920,2.020,0.196,1.380,1.990,1.820,1.700,
1.780,2.910,6.960,2.500,2.090,4.520,2.560,1.430,1.450,1.890,
3.030,0.286,1.280,2.150,4.050,2.630,2.080,4.950,4.100,2.480,
1.750,2.500,2.460,1.700,1.490,1.680,2.400,0.190,1.470,2.150,
2.660,2.430,1.830,3.120,2.480,1.950,1.630,2.270,0.202,0.154,
0.164,0.218,1.900,0.155,1.280,1.780,1.790,1.960,1.710,2.310,
3.880,2.030,1.860,3.740,2.090,1.460,1.420,2.210,2.880,0.201,
1.830,2.990,3.880,2.830,2.930,5.760,7.000,3.980,2.700,4.520,
3.410,2.490,1.930,2.240,2.580,0.287,1.260,2.040,2.830,2.600,
1.680,2.970,4.000,3.170,1.790,2.310,2.570,1.940,1.710,1.650,
2.060,0.264,1.450,1.850,1.470,1.710,1.250,1.890,2.240,2.350,
1.610,2.010,0.243,0.314,0.205,0.276,1.490,0.181,1.110,1.310,
1.190,1.670,1.230,1.760,2.490,1.370,1.280,2.140,2.330,1.950,
1.380,1.860,1.560,0.173,0.964,1.470,1.790,1.360,1.490,2.890,
4.230,3.120,1.470,2.270,2.700,2.460,1.480,1.530,1.880,0.257,
0.959,1.400,1.450,1.760,0.983,1.710,2.600,2.360,1.190,1.390,
1.800,1.100,1.240,1.110,1.690,0.269,1.180,1.520,0.991,1.440,
0.983,1.230,1.890,2.540,1.360,1.660,0.224,0.379,0.240,0.262,
1.730,0.327,1.210,1.500,1.040,2.290,1.250,1.570,1.570,1.210,
0.809,1.290,1.750,1.780,1.080,1.340,1.490,0.163,0.847,1.260,
1.170,1.240,0.990,1.850,2.770,1.820,1.200,1.770,2.270,1.930,
1.730,1.580,1.850,0.269,1.110,1.540,1.380,1.540,1.280,1.990,
0.196,0.284,0.134,0.181,0.187,0.284,0.220,0.157,0.186,0.077,
0.208,0.212,0.139,0.281,0.173,0.207,1.740,2.040,1.760,1.600,
0.231,0.307,0.236,0.205,1.630,0.269,1.280,1.480,0.997,1.900,
1.610,1.550,1.380,0.972,0.958,1.300,1.790,1.960,1.490,1.660,
1.580,0.182,1.340,1.740,1.130,1.240,1.490,2.060,2.560,1.380,
1.070,1.770,1.520,1.040,0.935,1.070,1.300,0.125,0.675,1.060,
1.520,1.160,0.944,1.950,2.180,1.900,1.230,1.600,1.560,1.550,
1.230,1.320,1.330,0.157,1.060,1.510,1.180,1.580,1.120,1.750,
1.470,1.500,1.260,1.550,0.127,0.154,0.110,0.147,1.210,0.133,
0.986,1.310,1.040,1.420,1.300,1.650,1.810,1.050,1.040,1.640,
1.380,1.190,0.925,1.370,1.620,0.146,1.170,1.870,1.940,1.820,
1.930,3.170,4.500,2.430,1.850,2.970,1.810,1.380,1.030,1.350,
1.910,0.199,0.915,1.380,2.000,1.760,1.040,2.030,3.100,2.420,
1.420,1.920,1.830,1.480,1.350,1.310,2.050,0.252,1.350,1.610,
1.490,1.860,1.080,1.670,2.100,2.280,2.360,2.210,0.231,0.283,
0.241,0.346,1.400,0.187,0.961,1.210,1.070,1.730,1.060,1.620,
2.210,1.370,1.360,2.380,1.760,1.590,1.260,1.790,1.650,0.174,
1.080,1.690,1.910,1.520,1.650,3.770,0.293,0.242,0.137,0.215,
0.229,0.245,0.137,0.153,0.179,0.038,0.108,0.142,0.159,0.222,
0.127,0.193,0.257,0.287,0.138,0.163,0.228,0.269,0.174,0.148,
0.223,0.064,0.183,0.190,0.145,0.258,0.127,0.167,0.172,0.263,
0.189,0.186,0.031,0.066,0.056,0.039,0.201,0.057,0.202,0.203,
0.126,0.275,0.155,0.186,0.260,0.191,0.150,0.277,0.320,0.380,
0.259,0.334,0.219,0.036,0.176,0.241,0.226,0.232,0.209,0.395,
1.980,1.300,0.925,1.130,1.390,1.280,1.120,1.010,1.700,0.323,
1.100,1.270,1.150,1.370,1.060,1.460,0.169,0.206,0.099,0.112,
0.126,0.177,0.134,0.092,0.224,0.123,0.168,0.150,0.147,0.297,
0.140,0.153,1.260,1.660,1.110,1.060,0.150,0.238,0.177,0.146,
1.390,0.240,0.840,1.010,0.772,1.350,1.030,1.060,1.120,0.843,
0.767,0.942,1.270,1.450,1.130,1.230,1.440,0.213,1.260,1.440,
0.980,1.200,1.180,1.590,1.930,1.020,0.752,1.350,1.130,0.748,
0.586,0.719,1.270,0.132,0.639,1.010,1.380,1.100,0.760,1.610,
2.150,1.690,1.000,1.360,1.490,1.410,0.999,0.984,1.700,0.228,
1.110,1.450,1.430,1.750,1.080,1.560,1.460,1.550,1.120,1.370,
0.147,0.194,0.123,0.146,1.450,0.177,1.010,1.340,1.090,1.620,
1.180,1.590,1.750,1.060,1.030,1.400,1.410,1.270,0.965,1.240,
1.740,0.174,1.390,1.910,1.920,1.820,1.730,2.900,5.500,2.490,
1.940,4.200,1.910,1.190,1.050,1.400,1.940,0.181,0.884,1.540,
3.090,1.980,1.390,3.180,2.320,1.300,0.907,1.550,1.240,0.756,
0.717,0.907,1.420,0.116,0.755,1.170,1.330,1.070,0.787,1.470,
2.050,1.540,1.270,2.210,0.175,0.149,0.116,0.261,1.230,0.110,
0.674,1.110,1.210,1.250,0.868,1.690,3.010,1.440,1.590,3.940,
1.830,1.250,1.200,2.140,1.710,0.134,1.070,1.800,2.630,1.700,
1.870,4.840,3.370,1.980,1.270,2.350,2.040,1.510,1.070,1.330,
1.690,0.178,0.870,1.410,1.610,1.590,0.987,1.850,2.260,1.630,
0.880,1.400,1.540,1.270,0.872,0.997,1.520,0.196,0.940,1.380,
1.190,1.410,0.767,1.300,1.650,1.510,0.994,1.590,0.128,0.151,
0.111,0.167,1.420,0.150,0.918,1.350,1.170,1.570,0.995,1.600,
2.040,1.160,1.010,2.060,1.790,1.510,1.170,1.890,1.570,0.129,
1.020,1.630,1.730,1.500,1.380,2.770,2.100,1.230,0.931,1.480,
1.590,1.070,0.984,1.270,1.670,0.217,0.990,1.420,1.400,1.300,
1.180,1.950,0.153,0.139,0.083,0.139,0.110,0.119,0.094,0.102,
0.143,0.033,0.122,0.179,0.141,0.189,0.118,0.180,1.300,1.290,
0.936,1.320,0.111,0.114,0.109,0.144,1.360,0.152,0.859,1.160,
0.985,1.300,1.130,1.440,1.340,0.906,0.861,1.400,1.500,1.230,
1.130,1.640,1.720,0.167,1.200,1.840,1.400,1.320,1.450,2.360,
3.490,1.510,1.250,2.410,1.540,0.990,0.963,1.170,1.830,0.159,
0.870,1.480,2.380,1.580,1.370,3.310,1.840,1.220,0.830,1.400,
1.170,0.860,0.792,0.976,1.320,0.108,0.882,1.460,1.450,1.360,
1.000,1.880,2.010,1.720,1.280,2.120,0.154,0.132,0.099,0.180,
1.790,0.143,1.130,1.770,1.760,1.950,1.630,2.400,3.330,1.650,
1.630,3.450,2.180,1.750,1.490,2.340,2.810,0.173,2.000,3.340,
4.360,2.900,3.160,5.700,4.380,2.660,2.060,3.370,2.730,1.810,
1.340,1.610,2.160,0.254,1.100,1.670,2.670,2.290,1.350,2.270,
2.620,1.900,1.170,1.440,1.940,1.420,1.110,1.070,1.540,0.185,
1.110,1.270,1.120,1.290,0.975,1.320,1.450,1.300,0.959,1.280,
0.153,0.144,0.122,0.182,1.000,0.126,0.690,0.802,0.857,1.120,
0.904,1.180,1.900,1.040,0.852,1.680,1.700,1.240,0.934,1.380,
1.220,0.135,0.788,1.160,1.470,1.100,1.190,2.110,3.050,2.010,
1.100,1.630,2.330,1.700,0.998,1.060,1.560,0.255,0.887,1.130,
1.180,1.480,0.769,1.300,2.050,1.760,0.875,1.080,1.580,1.260,
0.936,0.913,1.450,0.283,1.120,1.360,0.819,1.250,0.756,0.991,
1.170,1.400,0.782,0.894,0.172,0.195,0.153,0.133,1.360,0.242,
0.921,0.991,0.741,1.370,0.903,0.968,0.961,0.764,0.473,0.748,
1.200,1.050,0.708,0.869,0.999,0.115,0.688,0.935,0.846,0.888,
0.855,1.390,1.600,0.982,0.653,0.963,1.550,1.120,0.866,0.943,
1.320,0.194,0.658,0.898,0.930,0.976,0.721,1.300,0.131,0.150,
0.086,0.109,0.170,0.199,0.131,0.121,0.134,0.050,0.127,0.140,
0.102,0.205,0.114,0.150,0.767,0.863,0.659,0.679,0.101,0.107,
0.095,0.107,0.817,0.135,0.637,0.760,0.522,0.820,0.735,0.798,
0.724,0.519,0.464,0.669,0.968,0.877,0.671,0.865,0.908,0.123,
0.713,0.915,0.744,0.849,0.907,1.300,1.770,0.832,0.626,1.250,
0.920,0.582,0.456,0.619,0.987,0.116,0.467,0.728,1.110,0.850,
0.612,1.430,1.470,1.160,0.745,1.050,1.210,1.080,0.765,0.862,
0.911,0.118,0.702,0.993,0.791,1.060,0.703,1.110,0.781,0.736,
0.637,0.822,0.083,0.074,0.086,0.098,0.704,0.094,0.529,0.719,
0.577,0.823,0.693,0.890,1.120,0.678,0.637,1.120,0.754,0.652,
0.557,0.783,1.030,0.098,0.754,1.170,1.270,1.190,1.220,2.200,
2.770,1.900,1.270,1.910,1.960,1.740,1.150,1.180,1.160,0.158,
0.641,0.937,1.180,1.240,0.758,1.290,1.950,1.680,0.971,1.100,
1.710,1.570,1.290,1.060,1.080,0.206,0.918,1.060,0.661,1.050,
0.711,0.970,0.907,1.110,0.777,0.873,0.119,0.173,0.135,0.141,
0.678,0.113,0.593,0.628,0.564,0.819,0.644,0.853,0.916,0.575,
0.485,0.873,1.010,1.050,0.672,0.833,0.679,0.084,0.507,0.670,
0.884,0.665,0.711,1.300,1.930,1.690,0.759,1.030,1.580,1.840,
0.907,0.843,0.997,0.177,0.625,0.804,0.673,0.983,0.505,0.903,
1.390,1.370,0.706,0.741,0.933,0.566,0.739,0.680,0.953,0.286,
0.792,0.978,0.492,1.020,0.586,0.710,0.855,1.370,0.691,0.756,
0.147,0.329,0.187,0.146,0.887,0.234,0.710,0.872,0.485,1.270,
0.806,0.866,0.645,0.592,0.375,0.539,0.889,1.230,0.601,0.704,
0.702,0.107,0.560,0.763,0.537,0.686,0.573,0.976,1.260,0.961,
0.572,0.763,1.440,1.480,1.030,0.887,1.050,0.203,0.640,0.791,
0.675,0.956,0.656,0.980,0.111,0.191,0.093,0.100,0.184,0.369,
0.245,0.131,0.146,0.114,0.188,0.153,0.073,0.264,0.115,0.110,
0.856,1.170,0.789,0.763,0.167,0.259,0.194,0.140,0.864,0.195,
0.729,0.811,0.481,1.090,0.922,0.840,0.630,0.492,0.438,0.579,
1.070,1.380,1.010,0.970,0.898,0.133,0.795,0.933,0.627,0.759,
0.894,1.150,1.020,0.654,0.454,0.721,0.765,0.617,0.411,0.483,
0.636,0.072,0.352,0.490,0.653,0.572,0.416,0.822,0.977,1.030,
0.637,0.787,0.970,1.280,0.796,0.826,0.708,0.143,0.616,0.786,
0.492,0.950,0.572,0.769,0.612,0.797,0.606,0.676,0.067,0.105,
0.072,0.078,0.536,0.083,0.548,0.630,0.428,0.732,0.709,0.788,
0.714,0.480,0.412,0.657,0.625,0.690,0.500,0.645,0.672,0.070,
0.556,0.802,0.769,0.863,0.891,1.400,1.670,1.250,0.801,1.310,
1.070,0.860,0.572,0.759,0.876,0.111,0.481,0.662,0.846,0.883,
0.506,0.919,1.500,1.510,0.675,0.921,1.270,1.220,0.861,0.853,
1.190,0.218,0.983,1.040,0.676,1.200,0.578,0.856,0.810,1.150,
0.751,0.926,0.119,0.165,0.130,0.182,0.733,0.135,0.553,0.694,
0.479,0.920,0.574,0.842,0.791,0.574,0.439,0.895,0.820,0.836,
0.604,0.879,0.771,0.101,0.592,0.865,0.788,0.714,0.767,1.600,
0.115,0.114,0.056,0.081,0.158,0.184,0.108,0.093,0.095,0.031,
0.069,0.077,0.066,0.115,0.065,0.093,0.120,0.194,0.074,0.085,
0.194,0.313,0.184,0.131,0.148,0.123,0.178,0.155,0.066,0.173,
0.077,0.087,0.071,0.162,0.094,0.080,0.037,0.100,0.085,0.037,
0.126,0.080,0.179,0.143,0.058,0.173,0.115,0.101,0.074,0.072,
0.045,0.083,0.156,0.223,0.126,0.155,0.094,0.028,0.109,0.123,
0.072,0.092,0.092,0.146,1.060,0.955,0.525,0.644,0.966,1.170,
0.796,0.722,1.010,0.211,0.839,0.878,0.601,0.855,0.632,0.895,
0.100,0.215,0.078,0.073,0.115,0.245,0.163,0.092,0.132,0.086,
0.198,0.140,0.071,0.179,0.099,0.095,0.674,1.230,0.654,0.632,
0.111,0.252,0.158,0.115,0.894,0.227,0.581,0.743,0.436,1.020,
0.680,0.721,0.550,0.511,0.386,0.518,0.837,1.250,0.770,0.875,
0.998,0.188,0.975,1.010,0.563,0.787,0.804,1.040,0.897,0.624,
0.392,0.704,0.592,0.469,0.314,0.405,0.641,0.081,0.381,0.627,
0.635,0.605,0.380,0.860,1.090,1.210,0.579,0.728,1.060,1.280,
0.754,0.733,0.999,0.177,0.857,1.080,0.685,1.140,0.660,0.918,
0.718,0.980,0.630,0.714,0.077,0.128,0.086,0.085,0.818,0.144,
0.694,0.851,0.558,1.100,0.715,0.907,0.715,0.543,0.424,0.721,
0.690,0.710,0.503,0.656,0.911,0.106,0.896,1.120,0.910,1.030,
0.981,1.480,1.680,0.893,0.678,1.350,0.856,0.549,0.445,0.727,
0.790,0.077,0.379,0.693,0.959,0.714,0.531,1.120,1.040,0.732,
0.410,0.659,0.654,0.493,0.379,0.526,0.607,0.065,0.388,0.600,
0.529,0.508,0.370,0.653,0.694,0.624,0.435,0.745,0.059,0.056,
0.042,0.097,0.487,0.052,0.312,0.482,0.438,0.512,0.371,0.683,
0.900,0.499,0.483,1.110,0.627,0.469,0.404,0.866,0.631,0.054,
0.404,0.741,0.890,0.600,0.657,1.680,1.440,0.965,0.584,0.981,
1.110,0.958,0.753,0.764,0.882,0.117,0.538,0.800,0.751,0.882,
0.497,0.949,1.090,0.976,0.463,0.679,1.060,1.050,0.643,0.733,
0.912,0.165,0.655,0.919,0.640,0.922,0.504,0.802,0.641,0.812,
0.479,0.675,0.075,0.117,0.082,0.108,0.734,0.110,0.560,0.746,
0.552,0.922,0.570,0.826,0.688,0.505,0.411,0.811,0.854,0.887,
0.642,1.360,0.718,0.080,0.592,0.877,0.704,0.729,0.692,1.330,
0.918,0.617,0.414,0.618,0.810,0.708,0.543,0.651,0.834,0.118,
0.534,0.731,0.616,0.652,0.564,0.962,0.066,0.078,0.038,0.058,
0.063,0.107,0.068,0.061,0.062,0.021,0.069,0.077,0.055,0.092,
0.060,0.082,0.543,0.658,0.426,0.563,0.057,0.075,0.059,0.080,
0.672,0.105,0.506,0.655,0.445,0.728,0.591,0.745,0.541,0.429,
0.370,0.576,0.684,0.674,0.554,0.827,0.858,0.118,0.689,0.962,
0.636,0.675,0.792,1.180,1.190,0.646,0.483,0.892,0.613,0.466,
0.361,0.473,0.704,0.075,0.385,0.635,0.769,0.579,0.487,1.130,
0.901,0.659,0.396,0.621,0.653,0.633,0.456,0.554,0.605,0.062,
0.462,0.680,0.590,0.633,0.470,0.909,0.761,0.711,0.518,0.806,
0.065,0.061,0.044,0.078,0.710,0.074,0.540,0.784,0.677,0.879,
0.732,1.040,1.100,0.629,0.601,1.190,0.854,0.799,0.647,1.020,
1.070,0.087,0.937,1.420,1.510,1.270,1.390,2.010,2.760,1.550,
1.380,2.260,1.650,1.140,0.987,1.210,1.470,0.152,0.738,1.100,
1.770,1.470,0.918,1.580,1.480,1.030,0.722,0.937,1.090,0.742,
0.726,0.769,0.897,0.107,0.601,0.703,0.772,0.831,0.635,0.895,
1.180,0.917,0.669,1.000,0.103,0.086,0.076,0.139,0.708,0.075,
0.517,0.697,0.599,0.742,0.621,0.877,1.350,0.682,0.557,1.130,
0.992,0.708,0.594,0.908,0.761,0.066,0.493,0.719,0.980,0.600,
0.763,1.480,2.240,1.430,0.873,1.390,1.640,1.310,1.050,1.050,
1.130,0.155,0.586,0.811,0.956,1.100,0.588,1.030,1.550,1.350,
0.706,0.869,1.230,0.830,0.889,0.822,1.240,0.229,0.782,1.020,
0.711,1.010,0.557,0.756,1.130,1.270,0.805,0.990,0.136,0.160,
0.134,0.156,1.120,0.175,0.869,1.220,0.680,1.140,0.840,0.967,
0.944,0.647,0.434,0.764,1.110,0.990,0.697,0.960,0.805,0.083,
0.541,0.847,0.753,0.697,0.711,1.340,1.470,0.773,0.577,0.917,
1.390,1.020,0.950,0.996,1.760,0.217,0.649,0.823,1.070,1.030,
0.690,1.190,0.135,0.138,0.078,0.110,0.152,0.153,0.140,0.134,
0.170,0.043,0.147,0.135,0.147,0.267,0.121,0.178,0.781,0.768,
0.745,0.796,0.103,0.099,0.168,0.153,0.841,0.139,0.616,0.667,
0.517,0.868,0.684,0.732,0.664,0.441,0.408,0.615,0.985,0.840,
0.898,0.984,0.819,0.100,0.641,0.801,0.774,0.738,0.765,1.180,
1.450,0.643,0.511,1.020,0.760,0.502,0.491,0.616,0.898,0.095,
0.392,0.591,1.140,0.827,0.574,1.240,1.110,0.823,0.552,0.769,
0.871,0.686,0.649,0.707,0.853,0.098,0.593,0.759,0.832,0.948,
0.608,0.997,0.810,0.783,0.685,0.880,0.082,0.073,0.080,0.111,
0.767,0.084,0.599,0.802,0.668,0.916,0.847,1.040,1.080,0.624,
0.556,1.080,0.733,0.551,0.603,0.861,1.090,0.097,0.778,1.200,
1.490,1.200,1.330,2.440,0.151,0.112,0.089,0.112,0.119,0.111,
0.085,0.097,0.084,0.015,0.050,0.069,0.087,0.104,0.062,0.093,
0.139,0.130,0.117,0.100,0.141,0.138,0.154,0.119,0.094,0.031,
0.094,0.086,0.070,0.099,0.074,0.085,0.074,0.097,0.063,0.074,
0.015,0.022,0.020,0.018,0.063,0.016,0.065,0.071,0.043,0.077,
0.064,0.077,0.080,0.053,0.044,0.075,0.096,0.094,0.071,0.088,
0.066,0.011,0.051,0.070,0.072,0.060,0.072,0.124,0.133,0.134,
0.067,0.087,0.135,0.173,0.121,0.101,0.085,0.027,0.056,0.065,
0.056,0.090,0.052,0.068,0.148,0.207,0.090,0.085,0.182,0.180,
0.182,0.133,0.142,0.076,0.121,0.120,0.063,0.134,0.074,0.079,
0.086,0.151,0.085,0.082,0.028,0.078,0.054,0.028,0.152,0.070,
0.142,0.161,0.058,0.151,0.110,0.097,0.070,0.059,0.039,0.059,
0.107,0.135,0.089,0.090,0.075,0.016,0.063,0.079,0.054,0.065,
0.064,0.107,0.096,0.072,0.047,0.060,0.117,0.138,0.128,0.088,
0.122,0.034,0.091,0.073,0.062,0.096,0.065,0.083,0.014,0.029,
0.015,0.015,0.030,0.063,0.056,0.026,0.032,0.039,0.075,0.030,
0.011,0.038,0.023,0.017,0.076,0.112,0.102,0.089,0.023,0.047,
0.061,0.025,0.140,0.074,0.134,0.105,0.053,0.157,0.119,0.093,
0.061,0.047,0.045,0.059,0.107,0.138,0.132,0.112,0.094,0.026,
0.104,0.109,0.062,0.105,0.092,0.118,0.114,0.090,0.060,0.092,
0.079,0.069,0.058,0.066,0.080,0.011,0.045,0.059,0.095,0.087,
0.070,0.126,0.139,0.150,0.090,0.109,0.149,0.167,0.138,0.132,
0.129,0.031,0.127,0.119,0.101,0.176,0.106,0.137,0.072,0.094,
0.081,0.089,0.011,0.020,0.018,0.017,0.089,0.021,0.091,0.105,
0.066,0.115,0.135,0.121,0.095,0.068,0.056,0.093,0.081,0.085,
0.073,0.092,0.101,0.014,0.089,0.124,0.115,0.124,0.137,0.217,
1.370,0.969,0.679,1.090,0.885,0.781,0.520,0.670,0.716,0.083,
0.462,0.571,0.604,0.539,0.398,0.656,1.100,0.956,0.539,0.673,
1.010,0.858,0.818,0.674,0.916,0.136,0.947,0.848,0.499,0.745,
0.493,0.659,0.749,0.941,0.647,0.783,0.110,0.148,0.140,0.169,
0.822,0.171,0.667,0.716,0.442,0.875,0.545,0.711,0.659,0.450,
0.345,0.654,0.683,0.643,0.535,0.725,0.711,0.085,0.577,0.810,
0.623,0.552,0.635,1.200,0.098,0.097,0.048,0.073,0.117,0.170,
0.087,0.088,0.067,0.020,0.062,0.065,0.046,0.068,0.039,0.064,
0.090,0.111,0.054,0.054,0.133,0.145,0.128,0.087,0.096,0.042,
0.192,0.113,0.043,0.080,0.051,0.054,0.066,0.123,0.089,0.071,
0.019,0.049,0.067,0.024,0.101,0.050,0.142,0.123,0.045,0.114,
0.082,0.079,0.076,0.057,0.039,0.072,0.106,0.139,0.111,0.116,
0.080,0.017,0.080,0.125,0.058,0.064,0.066,0.117,1.010,0.688,
0.472,0.472,0.885,0.961,0.901,0.647,0.753,0.139,0.698,0.634,
0.433,0.569,0.562,0.663,0.083,0.125,0.069,0.056,0.093,0.153,
0.185,0.069,0.095,0.040,0.153,0.098,0.053,0.112,0.090,0.075,
0.712,0.813,0.634,0.591,0.101,0.121,0.141,0.106,0.654,0.119,
0.274,0.399,0.325,0.548,0.536,0.544,0.471,0.358,0.314,0.361,
0.663,0.714,0.647,0.625,0.646,0.097,0.699,0.696,0.412,0.506,
0.630,0.767,0.757,0.468,0.354,0.537,0.531,0.413,0.320,0.347,
0.479,0.059,0.361,0.451,0.442,0.404,0.322,0.577,0.815,0.757,
0.474,0.530,0.806,0.859,0.731,0.525,0.666,0.098,0.731,0.719,
0.502,0.726,0.549,0.634,0.676,0.803,0.570,0.700,0.078,0.115,
0.083,0.095,0.754,0.107,0.793,0.839,0.483,0.818,0.706,0.796,
0.602,0.417,0.345,0.555,0.597,0.586,0.457,0.569,0.734,0.078,
0.789,0.892,0.696,0.741,0.809,1.130,1.330,0.667,0.489,0.951,
0.654,0.439,0.354,0.516,0.573,0.059,0.285,0.461,0.711,0.529,
0.370,0.807,0.834,0.498,0.313,0.465,0.516,0.338,0.311,0.370,
0.432,0.038,0.298,0.396,0.363,0.344,0.270,0.457,0.630,0.532,
0.341,0.576,0.056,0.050,0.040,0.081,0.475,0.047,0.305,0.473,
0.414,0.474,0.381,0.616,0.765,0.418,0.347,0.707,0.545,0.387,
0.337,0.593,0.503,0.043,0.310,0.532,0.676,0.467,0.506,1.140,
1.300,0.860,0.504,0.884,0.936,0.827,0.582,0.658,0.649,0.076,
0.423,0.580,0.579,0.619,0.361,0.724,0.989,0.828,0.417,0.586,
0.909,0.724,0.611,0.618,0.666,0.082,0.603,0.694,0.427,0.541,
0.360,0.541,0.668,0.801,0.497,0.656,0.067,0.096,0.082,0.090,
0.692,0.094,0.570,0.812,0.481,0.782,0.549,0.788,0.763,0.503,
0.380,0.670,0.774,0.716,0.569,0.834,0.635,0.067,0.477,0.799,
0.589,0.575,0.539,1.030,1.020,0.592,0.418,0.586,0.777,0.649,
0.602,0.662,0.705,0.095,0.460,0.643,0.528,0.550,0.521,0.839,
0.077,0.069,0.041,0.055,0.067,0.093,0.078,0.067,0.056,0.014,
0.066,0.077,0.049,0.078,0.056,0.073,0.634,0.731,0.491,0.632,
0.063,0.073,0.072,0.095,0.744,0.107,0.525,0.690,0.440,0.685,
0.621,0.726,0.599,0.427,0.401,0.532,0.735,0.644,0.650,0.806,
0.689,0.073,0.644,0.921,0.571,0.562,0.732,1.030,1.030,0.486,
0.393,0.698,0.529,0.368,0.330,0.405,0.569,0.065,0.321,0.499,
0.601,0.443,0.393,0.851,0.734,0.498,0.336,0.501,0.554,0.481,
0.426,0.451,0.466,0.043,0.408,0.577,0.446,0.458,0.408,0.637,
0.716,0.695,0.505,0.776,0.058,0.063,0.045,0.080,0.751,0.072,
0.640,0.917,0.623,0.779,0.741,0.937,0.962,0.522,0.477,0.961,
0.738,0.640,0.557,0.810,0.875,0.067,0.765,1.180,1.090,0.859,
1.040,1.570,2.660,1.200,1.030,2.260,1.080,0.625,0.533,0.805,
1.040,0.090,0.415,0.754,1.710,1.180,0.642,1.390,1.030,0.542,
0.399,0.612,0.579,0.323,0.298,0.367,0.560,0.042,0.317,0.388,
0.599,0.528,0.337,0.591,0.777,0.524,0.404,0.740,0.063,0.043,
0.035,0.081,0.447,0.035,0.242,0.386,0.479,0.475,0.363,0.655,
1.290,0.571,0.526,1.100,0.758,0.464,0.398,0.697,0.616,0.045,
0.353,0.581,0.980,0.584,0.621,1.510,1.230,0.597,0.391,0.742,
0.642,0.382,0.284,0.394,0.478,0.045,0.211,0.356,0.568,0.458,
0.253,0.564,0.656,0.395,0.233,0.374,0.387,0.231,0.198,0.257,
0.386,0.034,0.193,0.296,0.358,0.307,0.201,0.351,0.513,0.392,
0.274,0.442,0.039,0.031,0.023,0.040,0.410,0.041,0.190,0.319,
0.358,0.397,0.269,0.419,0.520,0.313,0.217,0.441,0.411,0.291,
0.203,0.342,0.368,0.026,0.197,0.351,0.425,0.323,0.313,0.700,
0.959,0.411,0.336,0.607,0.638,0.369,0.329,0.491,0.649,0.066,
0.213,0.377,0.744,0.525,0.323,0.792,0.065,0.041,0.028,0.051,
0.049,0.035,0.031,0.045,0.049,5.89e-3,0.025,0.040,0.083,0.081,
0.038,0.081,0.421,0.315,0.295,0.410,0.035,0.025,0.026,0.044,
0.345,0.033,0.183,0.273,0.331,0.348,0.287,0.414,0.453,0.267,
0.258,0.466,0.466,0.316,0.284,0.446,0.422,0.043,0.242,0.409,
0.503,0.391,0.399,0.773,1.290,0.479,0.404,0.919,0.535,0.289,
0.289,0.435,0.681,0.057,0.273,0.458,1.230,0.650,0.433,1.110,
0.721,0.395,0.305,0.482,0.414,0.266,0.255,0.337,0.473,0.034,
0.252,0.397,0.638,0.534,0.330,0.652,0.513,0.396,0.340,0.520,
0.038,0.027,0.026,0.044,0.417,0.030,0.247,0.381,0.446,0.456,
0.400,0.613,0.891,0.444,0.419,0.913,0.525,0.339,0.327,0.530,
0.692,0.048,0.418,0.724,1.160,0.816,0.852,1.890,1.320,0.726,
0.545,1.010,0.727,0.497,0.374,0.506,0.546,0.056,0.259,0.437,
0.687,0.610,0.353,0.717,0.823,0.507,0.397,0.532,0.562,0.387,
0.391,0.393,0.435,0.047,0.357,0.390,0.361,0.392,0.287,0.452,
0.485,0.427,0.296,0.481,0.044,0.044,0.032,0.056,0.325,0.035,
0.221,0.341,0.293,0.361,0.289,0.485,0.547,0.303,0.264,0.486,
0.488,0.380,0.277,0.423,0.342,0.031,0.209,0.343,0.443,0.327,
0.353,0.755,0.881,0.554,0.303,0.542,0.586,0.479,0.296,0.360,
0.367,0.043,0.173,0.282,0.372,0.369,0.204,0.412,0.604,0.505,
0.251,0.362,0.509,0.358,0.280,0.320,0.373,0.051,0.231,0.316,
0.281,0.338,0.207,0.313,0.402,0.425,0.247,0.369,0.042,0.049,
0.032,0.043,0.390,0.051,0.230,0.351,0.281,0.407,0.281,0.432,
0.349,0.250,0.166,0.309,0.369,0.356,0.207,0.300,0.281,0.024,
0.169,0.284,0.295,0.269,0.247,0.498,0.582,0.306,0.214,0.361,
0.446,0.342,0.300,0.342,0.384,0.051,0.183,0.269,0.356,0.338,
0.229,0.474,0.032,0.032,0.018,0.030,0.035,0.043,0.033,0.033,
0.029,9.49e-3,0.033,0.031,0.032,0.052,0.027,0.040,0.348,0.330,
0.257,0.340,0.032,0.034,0.031,0.040,0.331,0.047,0.201,0.283,
0.242,0.359,0.292,0.391,0.335,0.210,0.190,0.334,0.387,0.344,
0.298,0.392,0.343,0.032,0.230,0.356,0.328,0.291,0.337,0.604,
0.610,0.313,0.238,0.452,0.310,0.213,0.186,0.251,0.340,0.031,
0.167,0.256,0.451,0.332,0.252,0.543,0.485,0.340,0.243,0.365,
0.344,0.304,0.255,0.316,0.319,0.035,0.228,0.320,0.362,0.494,
0.270,0.453,0.319,0.299,0.240,0.355,0.025,0.025,0.021,0.030,
0.272,0.025,0.203,0.302,0.260,0.320,0.336,0.448,0.437,0.250,
0.229,0.401,0.344,0.277,0.225,0.329,0.368,0.029,0.250,0.426,
0.509,0.428,0.458,0.883,0.772,0.432,0.316,0.559,0.360,0.281,
0.175,0.280,0.364,0.031,0.172,0.265,0.402,0.289,0.185,0.374,
0.521,0.368,0.199,0.316,0.344,0.254,0.188,0.214,0.323,0.033,
0.256,0.279,0.276,0.307,0.198,0.333,0.369,0.359,0.219,0.354,
0.041,0.038,0.025,0.050,0.266,0.030,0.160,0.256,0.215,0.309,
0.218,0.370,0.376,0.231,0.166,0.350,0.306,0.247,0.171,0.290,
0.315,0.029,0.192,0.336,0.356,0.269,0.301,0.642,0.040,0.029,
0.022,0.030,0.032,0.029,0.016,0.022,0.022,3.41e-3,0.016,0.019,
0.023,0.025,0.015,0.029,0.030,0.026,0.013,0.018,0.039,0.034,
0.018,0.020,0.024,5.32e-3,0.032,0.024,0.019,0.025,0.017,0.023,
0.022,0.025,0.015,0.021,3.58e-3,5.22e-3,4.09e-3,3.62e-3,0.024,5.08e-3,
0.020,0.028,0.018,0.031,0.027,0.045,0.030,0.020,0.013,0.030,
0.033,0.034,0.019,0.032,0.025,3.48e-3,0.018,0.033,0.027,0.025,
0.025,0.052,0.431,0.249,0.167,0.223,0.299,0.260,0.222,0.224,
0.255,0.037,0.176,0.212,0.216,0.233,0.203,0.321,0.026,0.024,
0.013,0.017,0.023,0.023,0.018,0.015,0.021,4.90e-3,0.033,0.021,
0.022,0.032,0.029,0.029,0.272,0.288,0.193,0.236,0.025,0.027,
0.023,0.026,0.268,0.031,0.133,0.195,0.163,0.239,0.200,0.255,
0.248,0.168,0.134,0.196,0.253,0.232,0.183,0.226,0.283,0.027,
0.233,0.281,0.230,0.218,0.260,0.388,0.410,0.212,0.146,0.271,
0.224,0.154,0.121,0.164,0.232,0.022,0.144,0.205,0.259,0.198,
0.151,0.320,0.363,0.250,0.153,0.235,0.247,0.204,0.148,0.162,
0.237,0.021,0.201,0.238,0.250,0.267,0.202,0.299,0.322,0.272,
0.182,0.287,0.024,0.022,0.015,0.023,0.262,0.022,0.184,0.253,
0.260,0.285,0.253,0.341,0.326,0.182,0.160,0.265,0.222,0.183,
0.143,0.202,0.310,0.023,0.248,0.330,0.351,0.296,0.322,0.525,
1.010,0.350,0.254,0.579,0.290,0.164,0.129,0.233,0.279,0.022,
0.117,0.224,0.397,0.254,0.168,0.432,0.336,0.166,0.101,0.181,
0.174,0.105,0.081,0.122,0.169,0.012,0.089,0.147,0.162,0.129,
0.093,0.195,0.267,0.187,0.120,0.262,0.018,0.015,9.84e-3,0.027,
0.157,0.012,0.079,0.156,0.166,0.161,0.117,0.245,0.379,0.176,
0.152,0.349,0.213,0.129,0.112,0.220,0.208,0.014,0.114,0.235,
0.328,0.206,0.220,0.593,0.368,0.179,0.119,0.226,0.185,0.122,
0.083,0.125,0.140,0.011,0.070,0.120,0.156,0.125,0.079,0.186,
0.215,0.132,0.071,0.123,0.146,0.109,0.062,0.094,0.120,8.67e-3,
0.071,0.112,0.107,0.099,0.064,0.133,0.156,0.115,0.069,0.139,
9.48e-3,8.34e-3,4.81e-3,0.011,0.128,9.50e-3,0.067,0.124,0.117,0.127,
0.085,0.172,0.176,0.095,0.077,0.160,0.141,0.097,0.069,0.132,
0.126,8.09e-3,0.068,0.137,0.153,0.120,0.113,0.271,0.287,0.132,
0.110,0.168,0.177,0.110,0.096,0.150,0.159,0.014,0.070,0.123,
0.158,0.124,0.101,0.221,0.014,9.76e-3,5.52e-3,9.83e-3,9.36e-3,8.28e-3,
5.78e-3,9.10e-3,7.83e-3,8.56e-4,5.04e-3,8.11e-3,0.012,0.011,7.82e-3,0.016,
0.150,0.124,0.083,0.143,8.61e-3,7.51e-3,5.62e-3,0.012,0.128,0.010,
0.073,0.108,0.110,0.115,0.101,0.165,0.162,0.101,0.084,0.136,
0.136,0.098,0.080,0.137,0.139,8.85e-3,0.088,0.145,0.140,0.103,
0.125,0.227,0.392,0.122,0.091,0.193,0.113,0.065,0.054,0.085,
0.120,8.27e-3,0.054,0.099,0.166,0.099,0.078,0.209,0.142,0.074,
0.046,0.078,0.078,0.057,0.040,0.058,0.069,3.99e-3,0.040,0.067,
0.079,0.062,0.046,0.103,0.107,0.074,0.049,0.093,4.56e-3,3.73e-3,
2.21e-3,5.56e-3,0.073,4.05e-3,0.042,0.071,0.075,0.062,0.055,0.098,
0.137,0.042,0.039,0.079,0.043,0.026,0.022,0.040,0.042,1.86e-3,
0.025,0.040,0.040,0.015,0.016,0.014
};

static double hg19_biasTable23_4_large[] = {
37.1,9.830,6.110,13.4,10.000,4.670,3.840,5.860,8.690,0.741,
3.350,5.200,13.3,8.090,5.580,10.1,11.2,4.990,3.510,4.980,
5.320,2.840,2.590,2.810,5.240,0.365,2.560,3.340,4.830,3.590,
2.820,4.730,9.250,5.190,3.890,5.940,0.655,0.468,0.350,0.751,
4.260,0.371,2.400,3.240,4.280,4.240,2.910,4.560,13.7,5.340,
5.260,10.7,7.430,4.800,4.090,7.480,6.060,0.462,3.120,5.050,
9.060,4.690,4.700,8.580,13.2,5.340,3.320,5.520,5.740,3.330,
2.350,2.820,4.730,0.444,1.830,2.930,4.270,3.700,2.010,3.790,
6.490,3.500,2.010,2.820,3.440,2.090,1.660,1.740,3.510,0.298,
1.730,2.300,2.410,2.160,1.450,2.210,4.920,3.780,2.300,3.310,
0.350,0.287,0.214,0.318,3.310,0.301,1.760,2.470,2.380,2.870,
1.830,2.780,4.450,2.590,1.920,3.470,3.560,2.490,1.990,2.770,
3.440,0.243,1.740,2.730,3.470,2.560,2.250,4.450,10.000,3.460,
3.000,4.470,4.940,2.690,2.470,3.010,4.790,0.495,1.910,3.240,
4.300,3.340,2.550,5.360,0.609,0.366,0.243,0.393,0.423,0.328,
0.237,0.288,0.382,0.053,0.239,0.355,0.500,0.552,0.328,0.601,
3.550,2.540,2.260,2.840,0.313,0.209,0.200,0.315,2.690,0.252,
1.490,2.040,2.080,2.290,1.870,2.410,3.490,2.010,1.930,3.220,
3.820,2.500,2.160,3.080,3.130,0.270,2.080,3.010,2.910,2.460,
2.590,4.410,14.4,4.790,3.870,8.400,4.730,2.470,2.420,3.260,
5.910,0.560,2.330,4.090,7.940,4.880,3.810,9.630,7.410,4.240,
2.970,4.400,4.410,2.850,2.410,2.890,4.430,0.303,2.510,3.910,
5.170,4.270,3.310,5.970,4.630,3.460,2.700,3.900,0.358,0.252,
0.223,0.355,3.260,0.232,1.890,2.920,3.170,3.260,2.740,3.880,
7.320,3.800,3.200,6.730,3.690,2.440,2.250,3.730,4.770,0.299,
2.800,4.700,6.340,4.200,4.220,8.230,12.3,6.010,3.930,6.740,
4.920,3.150,2.410,2.910,3.760,0.378,1.590,2.760,4.170,3.640,
2.160,4.010,5.650,3.690,2.180,3.020,3.380,2.180,1.890,2.010,
2.620,0.274,1.550,2.260,2.030,2.030,1.450,2.530,3.600,3.260,
2.070,2.960,0.334,0.340,0.222,0.356,2.050,0.209,1.380,1.750,
1.700,2.200,1.560,2.490,3.810,1.870,1.790,3.020,3.210,2.460,
1.730,2.520,2.280,0.229,1.200,1.960,2.560,1.770,1.840,3.840,
6.760,4.380,2.060,3.300,3.750,2.850,1.730,1.840,2.660,0.293,
1.110,1.790,2.140,2.290,1.200,2.210,3.660,2.650,1.370,1.790,
2.310,1.330,1.340,1.300,2.060,0.237,1.160,1.680,1.280,1.500,
0.995,1.410,2.800,3.160,1.510,2.070,0.257,0.369,0.183,0.216,
2.100,0.300,1.280,1.720,1.350,2.410,1.330,1.990,2.250,1.550,
0.988,1.660,2.190,2.020,1.130,1.490,2.100,0.178,0.931,1.560,
1.600,1.420,1.100,2.330,4.480,2.570,1.690,2.780,3.320,2.410,
2.050,2.140,2.540,0.308,1.240,2.080,2.050,2.000,1.550,2.890,
0.271,0.280,0.152,0.326,0.230,0.293,0.201,0.179,0.206,0.055,
0.178,0.244,0.186,0.292,0.173,0.266,2.480,2.610,1.990,2.160,
0.264,0.266,0.206,0.233,1.990,0.249,1.330,1.750,1.300,2.010,
1.650,1.990,1.900,1.210,1.150,1.730,2.360,2.120,1.660,2.020,
1.860,0.178,1.410,2.030,1.540,1.410,1.740,2.660,4.350,1.970,
1.640,2.800,2.410,1.490,1.340,1.520,2.100,0.186,0.951,1.690,
2.530,1.750,1.350,3.060,3.310,2.330,1.700,2.490,2.200,1.940,
1.480,1.670,1.750,0.175,1.290,2.300,1.700,2.010,1.450,2.550,
2.450,2.290,1.870,2.370,0.195,0.190,0.137,0.202,1.810,0.164,
1.270,1.890,1.550,1.930,1.670,2.420,2.920,1.580,1.560,2.530,
2.070,1.610,1.300,1.930,2.310,0.174,1.500,2.530,2.850,2.350,
2.420,4.210,8.600,3.620,3.440,4.820,2.880,1.880,1.500,2.000,
3.540,0.303,1.430,2.140,3.280,2.590,1.560,3.100,4.640,2.930,
1.850,2.530,2.400,1.600,1.440,1.530,2.790,0.264,1.540,1.980,
2.060,2.220,1.270,2.170,3.170,3.000,2.190,2.910,0.321,0.351,
0.236,0.423,1.970,0.234,1.100,1.660,1.670,2.450,1.370,2.540,
3.380,1.970,1.790,3.240,2.570,2.200,1.580,2.410,2.530,0.246,
1.440,2.460,2.900,2.090,2.320,5.730,0.493,0.332,0.214,0.337,
0.326,0.278,0.167,0.204,0.256,0.042,0.130,0.194,0.235,0.277,
0.157,0.272,0.354,0.282,0.161,0.196,0.271,0.249,0.168,0.161,
0.248,0.048,0.163,0.195,0.176,0.242,0.121,0.190,0.247,0.307,
0.177,0.224,0.035,0.058,0.042,0.038,0.232,0.053,0.163,0.215,
0.177,0.313,0.164,0.260,0.385,0.248,0.186,0.371,0.408,0.439,
0.278,0.394,0.304,0.037,0.205,0.316,0.325,0.277,0.269,0.568,
3.270,1.870,1.370,1.740,2.090,1.660,1.330,1.420,2.360,0.313,
1.360,1.840,1.760,1.640,1.380,2.010,0.252,0.246,0.111,0.149,
0.164,0.189,0.131,0.114,0.205,0.047,0.157,0.171,0.198,0.253,
0.147,0.189,1.930,2.130,1.320,1.440,0.191,0.269,0.151,0.178,
1.840,0.276,0.898,1.250,1.140,1.700,1.160,1.380,1.730,1.160,
0.962,1.270,1.720,1.720,1.250,1.520,1.950,0.230,1.460,1.930,
1.360,1.480,1.390,2.060,3.220,1.540,1.170,2.110,1.870,1.080,
0.833,1.110,1.940,0.184,0.979,1.600,2.250,1.600,1.140,2.480,
3.330,2.390,1.360,1.950,2.210,1.760,1.250,1.340,2.090,0.198,
1.350,1.960,2.070,2.140,1.380,2.140,2.330,2.190,1.520,2.090,
0.210,0.229,0.139,0.212,2.020,0.238,1.310,2.130,1.710,2.270,
1.610,2.430,2.560,1.430,1.430,1.920,2.050,1.690,1.340,1.760,
2.490,0.221,1.800,2.690,2.860,2.380,2.340,4.210,11.6,4.560,
3.690,8.830,3.570,1.980,1.850,2.690,3.670,0.328,1.570,2.900,
6.420,3.660,2.450,5.880,4.250,2.140,1.500,2.540,2.090,1.160,
1.090,1.440,2.390,0.175,1.280,2.020,2.260,1.720,1.230,2.440,
3.900,2.760,1.870,3.770,0.306,0.241,0.172,0.432,2.120,0.184,
0.992,1.890,2.210,2.160,1.360,2.980,5.260,2.440,2.500,6.310,
3.090,2.040,1.890,3.590,3.050,0.238,1.840,3.290,4.870,3.020,
3.250,9.040,6.400,3.400,2.260,4.550,3.670,2.350,1.660,2.330,
2.990,0.273,1.370,2.420,2.900,2.570,1.560,3.070,4.020,2.330,
1.400,2.270,2.470,1.720,1.220,1.500,2.380,0.262,1.320,2.080,
1.900,1.910,1.050,1.960,3.080,2.480,1.470,2.650,0.202,0.197,
0.127,0.239,2.300,0.213,1.280,2.150,2.040,2.410,1.470,2.750,
3.710,1.930,1.640,3.500,2.930,2.300,1.650,2.940,2.770,0.194,
1.650,2.770,3.140,2.320,2.280,4.910,3.690,2.080,1.600,2.740,
2.690,1.670,1.470,2.070,2.660,0.299,1.420,2.260,2.410,2.090,
1.670,3.030,0.263,0.202,0.127,0.222,0.176,0.162,0.129,0.152,
0.196,0.030,0.159,0.294,0.221,0.244,0.149,0.265,2.220,2.030,
1.360,2.020,0.169,0.144,0.117,0.195,2.320,0.200,1.120,1.610,
1.700,1.870,1.570,2.090,2.280,1.460,1.330,2.180,2.350,1.700,
1.520,2.360,2.590,0.224,1.570,2.610,2.180,1.860,1.930,3.380,
6.630,2.630,2.210,4.350,2.760,1.640,1.880,2.010,3.120,0.263,
1.550,2.590,4.420,2.770,2.330,5.660,3.110,1.870,1.320,2.190,
1.950,1.310,1.170,1.470,2.030,0.143,1.300,2.290,2.440,2.090,
1.500,2.940,3.510,2.860,1.980,3.250,0.241,0.183,0.133,0.254,
2.850,0.204,1.600,2.730,2.990,3.060,2.390,3.660,5.540,2.590,
2.440,5.190,3.390,2.550,2.090,3.410,4.210,0.230,2.720,4.680,
6.740,4.130,4.210,8.480,10.7,5.970,4.550,7.500,6.280,3.730,
2.780,3.410,4.770,0.518,2.200,3.460,5.960,4.830,2.820,4.770,
5.250,3.710,2.230,2.660,3.620,2.490,1.990,1.980,3.110,0.310,
2.020,2.390,2.270,2.400,1.790,2.610,3.120,2.770,1.930,2.680,
0.312,0.276,0.212,0.356,2.060,0.230,1.230,1.590,1.830,2.330,
1.680,2.430,4.040,2.160,1.720,3.520,3.430,2.510,1.770,2.830,
2.630,0.308,1.520,2.390,3.070,2.270,2.400,4.300,6.710,4.190,
2.110,3.250,5.730,3.340,1.890,2.050,3.250,0.481,1.520,2.130,
2.430,2.960,1.410,2.580,3.980,3.120,1.470,1.830,2.910,1.920,
1.490,1.520,2.580,0.388,1.770,2.200,1.540,2.070,1.210,1.830,
2.500,2.720,1.390,1.720,0.366,0.281,0.205,0.224,2.210,0.318,
1.510,1.820,1.470,2.520,1.580,1.920,2.040,1.500,0.873,1.500,
2.380,1.890,1.120,1.550,1.870,0.193,1.230,1.770,1.670,1.730,
1.550,2.700,3.580,2.120,1.330,2.070,3.520,2.420,1.670,1.920,
2.930,0.388,1.290,1.930,2.070,2.010,1.400,2.690,0.291,0.306,
0.163,0.222,0.397,0.425,0.230,0.238,0.263,0.072,0.223,0.269,
0.220,0.396,0.197,0.300,1.640,1.840,1.240,1.390,0.200,0.187,
0.142,0.198,1.580,0.223,1.160,1.560,1.070,1.560,1.200,1.460,
1.530,1.070,0.854,1.340,2.040,1.790,1.240,1.700,1.740,0.216,
1.340,1.750,1.470,1.600,1.610,2.430,3.930,1.880,1.410,2.900,
2.060,1.230,0.934,1.290,2.220,0.263,1.020,1.690,2.470,1.780,
1.310,3.140,3.180,2.510,1.560,2.210,2.530,2.150,1.550,1.690,
1.910,0.214,1.430,2.050,1.710,2.100,1.410,2.310,1.740,1.580,
1.320,1.740,0.193,0.141,0.179,0.206,1.370,0.149,0.995,1.390,
1.210,1.650,1.300,1.770,2.400,1.380,1.170,2.310,1.550,1.260,
1.110,1.590,2.090,0.180,1.450,2.320,2.650,2.360,2.350,4.350,
6.220,4.040,2.790,4.130,4.340,3.530,2.360,2.480,2.450,0.314,
1.250,1.940,2.490,2.530,1.500,2.670,3.860,3.190,1.810,2.100,
3.330,2.580,2.230,1.940,2.070,0.321,1.600,2.000,1.260,1.760,
1.220,2.010,1.930,2.290,1.560,1.830,0.235,0.298,0.230,0.271,
1.320,0.190,1.100,1.260,1.050,1.620,1.230,1.760,1.950,1.160,
0.982,1.760,2.060,2.000,1.320,1.700,1.420,0.180,0.964,1.370,
1.640,1.310,1.370,2.610,3.840,3.280,1.460,1.980,3.220,3.230,
1.590,1.540,1.940,0.294,1.120,1.470,1.330,1.840,0.937,1.540,
2.550,2.350,1.160,1.240,1.600,0.687,1.140,1.030,1.660,0.360,
1.290,1.720,0.845,1.560,0.944,1.180,1.640,2.590,1.210,1.400,
0.238,0.395,0.228,0.220,1.600,0.325,1.250,1.610,0.926,2.240,
1.370,1.620,1.250,1.110,0.651,0.982,1.620,2.010,0.955,1.220,
1.320,0.171,0.977,1.510,1.000,1.200,0.981,1.810,2.800,2.060,
1.180,1.660,3.270,3.180,2.000,1.860,2.160,0.408,1.230,1.720,
1.420,2.080,1.250,2.050,0.214,0.337,0.157,0.198,0.390,0.588,
0.347,0.224,0.255,0.145,0.316,0.263,0.145,0.560,0.187,0.205,
1.720,2.320,1.450,1.460,0.371,0.427,0.262,0.236,1.650,0.305,
1.320,1.580,0.914,1.990,1.580,1.560,1.250,1.000,0.840,1.110,
2.440,3.010,1.950,1.910,1.690,0.225,1.350,1.740,1.200,1.410,
1.550,2.140,2.280,1.420,0.988,1.610,1.690,1.330,0.833,1.010,
1.310,0.149,0.713,1.100,1.400,1.230,0.841,1.770,2.030,2.020,
1.290,1.710,1.970,2.370,1.440,1.450,1.360,0.248,1.190,1.600,
0.975,1.890,1.060,1.520,1.390,1.760,1.360,1.500,0.164,0.201,
0.134,0.155,1.030,0.139,1.000,1.230,0.862,1.430,1.240,1.540,
1.560,0.975,0.820,1.350,1.360,1.350,1.070,1.270,1.340,0.126,
0.991,1.510,1.570,1.650,1.600,2.690,3.850,2.720,1.840,2.830,
2.590,1.830,1.290,1.690,2.050,0.242,1.030,1.520,1.960,1.910,
1.230,2.150,3.100,2.940,1.310,1.840,2.460,2.180,1.550,1.630,
2.640,0.386,1.860,2.130,1.390,2.090,1.140,1.780,1.770,2.460,
1.360,1.890,0.226,0.302,0.210,0.345,1.560,0.260,1.090,1.580,
1.080,1.930,1.120,2.120,1.730,1.190,0.859,1.790,1.720,1.720,
1.120,1.710,1.760,0.208,1.260,1.940,1.700,1.390,1.580,3.410,
0.267,0.232,0.120,0.176,0.412,0.340,0.220,0.195,0.189,0.051,
0.132,0.167,0.147,0.228,0.179,0.241,0.215,0.283,0.116,0.138,
0.311,0.396,0.230,0.205,0.257,0.125,0.251,0.258,0.118,0.243,
0.126,0.153,0.146,0.300,0.148,0.153,0.051,0.117,0.090,0.052,
0.225,0.108,0.244,0.258,0.120,0.309,0.199,0.225,0.162,0.142,
0.086,0.165,0.285,0.386,0.203,0.263,0.195,0.042,0.201,0.256,
0.155,0.177,0.193,0.307,2.420,2.120,1.130,1.430,2.290,2.680,
1.650,1.600,2.320,0.469,2.360,2.280,1.350,1.820,1.400,1.930,
0.205,0.442,0.144,0.143,0.238,0.548,0.271,0.175,0.246,0.122,
0.319,0.263,0.141,0.327,0.176,0.176,1.400,2.610,1.280,1.310,
0.220,0.409,0.234,0.219,1.940,0.440,1.190,1.630,0.963,2.130,
1.360,1.500,1.140,1.140,0.750,0.994,1.790,2.910,1.460,1.630,
2.100,0.383,2.130,2.060,1.130,1.610,1.580,1.950,1.960,1.280,
0.854,1.530,1.350,1.020,0.668,0.901,1.380,0.173,0.862,1.510,
1.330,1.250,0.838,1.820,2.240,2.430,1.150,1.460,2.230,2.860,
1.390,1.450,1.960,0.317,1.650,2.080,1.390,2.230,1.280,1.770,
1.510,2.100,1.330,1.500,0.161,0.243,0.157,0.173,1.780,0.299,
1.460,1.850,1.210,2.300,1.510,1.970,1.390,1.030,0.808,1.320,
1.320,1.420,1.000,1.250,1.840,0.205,1.780,2.190,1.800,1.930,
1.840,2.740,3.880,1.950,1.510,3.020,1.890,1.130,0.964,1.620,
1.760,0.170,0.778,1.590,2.160,1.550,1.040,2.410,2.310,1.600,
0.857,1.420,1.370,0.974,0.772,1.130,1.340,0.131,0.827,1.580,
1.180,1.010,0.714,1.440,1.490,1.390,0.815,1.480,0.121,0.113,
0.076,0.185,0.971,0.102,0.571,1.070,0.952,1.100,0.734,1.500,
1.980,1.070,0.924,2.150,1.320,0.989,0.764,1.590,1.310,0.109,
0.772,1.600,1.830,1.230,1.380,3.480,3.310,2.070,1.300,2.140,
2.600,1.920,1.660,1.700,1.930,0.238,1.060,1.730,1.620,1.820,
1.150,2.050,2.260,1.840,0.883,1.340,2.020,1.770,1.130,1.370,
1.840,0.301,1.170,1.830,1.260,1.680,0.901,1.630,1.350,1.720,
0.850,1.240,0.138,0.193,0.117,0.169,1.390,0.206,1.050,1.630,
1.190,1.970,1.140,1.830,1.430,1.030,0.788,1.440,1.720,1.730,
1.070,1.840,1.450,0.145,1.140,1.790,1.490,1.460,1.440,2.730,
2.120,1.420,0.962,1.440,1.860,1.570,1.160,1.460,1.940,0.262,
1.160,1.710,1.420,1.450,1.240,2.160,0.144,0.156,0.080,0.125,
0.140,0.215,0.138,0.126,0.128,0.033,0.123,0.163,0.120,0.184,
0.116,0.170,1.280,1.490,0.872,1.230,0.128,0.144,0.101,0.158,
1.510,0.203,0.981,1.380,1.040,1.540,1.180,1.530,1.210,0.978,
0.779,1.230,1.550,1.470,1.040,1.630,1.760,0.227,1.370,1.900,
1.360,1.390,1.550,2.360,2.750,1.420,1.100,2.060,1.400,1.030,
0.784,1.030,1.610,0.171,0.882,1.520,1.730,1.260,1.110,2.550,
1.940,1.390,0.856,1.360,1.470,1.310,0.904,1.120,1.280,0.112,
0.904,1.460,1.360,1.320,1.020,1.840,1.910,1.720,1.160,1.760,
0.218,0.133,0.093,0.160,1.620,0.159,1.180,1.790,1.590,2.050,
1.600,2.330,2.480,1.430,1.300,2.600,2.160,1.810,1.400,2.000,
2.440,0.192,2.060,3.090,3.370,2.600,2.860,4.060,7.200,3.230,
3.220,4.840,3.440,2.160,1.920,2.320,3.740,0.335,1.430,2.060,
4.020,3.110,1.750,3.210,2.780,1.740,1.170,1.660,1.940,1.190,
1.160,1.310,1.750,0.188,1.040,1.250,1.450,1.430,1.020,1.590,
2.810,1.850,1.320,1.920,0.222,0.172,0.142,0.272,1.450,0.142,
0.920,1.240,1.280,1.490,1.140,1.700,2.970,1.500,1.210,2.460,
2.270,1.580,1.280,2.000,1.620,0.145,0.966,1.490,2.160,1.320,
1.600,3.160,5.050,2.760,1.820,2.940,3.330,2.320,2.040,2.190,
2.640,0.338,1.150,1.690,2.150,2.390,1.140,2.160,2.740,1.980,
1.150,1.540,2.010,1.190,1.350,1.470,2.420,0.500,1.240,1.600,
1.360,1.860,0.884,1.350,2.390,2.400,1.520,1.970,0.264,0.254,
0.220,0.278,2.050,0.260,1.360,1.800,1.360,2.020,1.380,1.730,
2.050,1.310,0.918,1.720,2.310,1.930,1.400,1.910,1.660,0.161,
1.010,1.550,1.510,1.370,1.370,2.540,3.640,1.580,1.270,2.040,
3.090,2.040,2.040,2.080,6.020,0.581,1.450,1.850,2.790,2.160,
1.420,2.650,0.299,0.246,0.149,0.234,0.322,0.289,0.253,0.279,
0.419,0.077,0.227,0.253,0.341,0.513,0.212,0.348,1.570,1.430,
1.260,1.410,0.190,0.172,0.170,0.226,1.540,0.233,0.963,1.130,
1.030,1.640,1.040,1.250,1.400,0.852,0.790,1.260,2.030,1.640,
1.430,1.880,1.640,0.182,1.070,1.410,1.550,1.390,1.370,2.270,
3.720,1.460,1.230,2.540,1.820,1.130,1.100,1.550,2.770,0.277,
0.987,1.530,3.280,2.050,1.280,3.140,2.590,1.590,1.180,1.740,
2.030,1.360,1.430,1.620,2.120,0.205,1.170,1.630,2.120,1.940,
1.180,2.090,1.790,1.570,1.430,1.880,0.181,0.141,0.147,0.233,
1.540,0.158,1.070,1.550,1.440,1.830,1.470,2.080,2.600,1.350,
1.230,2.520,1.700,1.230,1.240,1.930,2.370,0.196,1.570,2.560,
3.730,2.700,2.940,5.940,0.432,0.264,0.200,0.285,0.306,0.244,
0.190,0.235,0.236,0.035,0.114,0.161,0.239,0.261,0.140,0.228,
0.321,0.233,0.164,0.209,0.286,0.234,0.231,0.248,0.191,0.039,
0.162,0.168,0.131,0.178,0.128,0.187,0.196,0.215,0.142,0.178,
0.040,0.040,0.035,0.042,0.146,0.026,0.120,0.144,0.104,0.172,
0.123,0.173,0.208,0.131,0.107,0.193,0.257,0.235,0.178,0.229,
0.175,0.023,0.116,0.175,0.177,0.140,0.166,0.290,0.355,0.284,
0.155,0.241,0.315,0.329,0.240,0.286,0.222,0.052,0.116,0.168,
0.153,0.225,0.110,0.177,0.296,0.295,0.153,0.179,0.303,0.244,
0.267,0.288,0.257,0.076,0.176,0.211,0.121,0.210,0.120,0.160,
0.213,0.303,0.188,0.192,0.050,0.085,0.073,0.051,0.244,0.075,
0.199,0.217,0.115,0.265,0.182,0.197,0.184,0.143,0.097,0.161,
0.282,0.331,0.216,0.223,0.180,0.026,0.129,0.175,0.133,0.145,
0.144,0.255,0.262,0.165,0.111,0.155,0.294,0.297,0.263,0.211,
0.359,0.075,0.169,0.163,0.173,0.231,0.144,0.209,0.028,0.042,
0.025,0.029,0.054,0.086,0.077,0.050,0.059,0.046,0.070,0.048,
0.024,0.071,0.035,0.033,0.173,0.240,0.209,0.193,0.044,0.071,
0.070,0.048,0.283,0.116,0.205,0.197,0.126,0.364,0.191,0.177,
0.154,0.104,0.104,0.143,0.263,0.310,0.268,0.268,0.204,0.039,
0.181,0.197,0.145,0.176,0.181,0.254,0.356,0.244,0.174,0.268,
0.234,0.184,0.160,0.192,0.266,0.034,0.129,0.175,0.316,0.258,
0.186,0.369,0.395,0.337,0.250,0.300,0.415,0.392,0.370,0.362,
0.377,0.064,0.279,0.322,0.307,0.454,0.257,0.360,0.202,0.239,
0.208,0.232,0.029,0.043,0.034,0.042,0.224,0.040,0.196,0.243,
0.171,0.276,0.235,0.290,0.290,0.186,0.157,0.268,0.244,0.235,
0.196,0.258,0.278,0.030,0.217,0.316,0.349,0.317,0.337,0.586,
3.050,1.700,1.300,2.000,1.720,1.340,0.970,1.240,1.520,0.173,
0.926,1.090,1.320,1.160,0.811,1.300,1.970,1.520,0.921,1.180,
1.620,1.280,1.220,1.080,1.600,0.215,1.420,1.380,0.922,1.210,
0.827,1.140,1.710,1.980,1.570,1.680,0.248,0.275,0.444,0.353,
1.800,0.248,1.110,1.320,1.000,1.770,1.000,1.410,1.410,0.927,
0.779,1.570,1.450,1.250,1.370,1.570,1.550,0.165,1.070,1.510,
1.290,1.070,1.210,2.350,0.223,0.187,0.103,0.166,0.229,0.275,
0.160,0.172,0.140,0.033,0.101,0.121,0.103,0.139,0.078,0.132,
0.165,0.162,0.083,0.095,0.195,0.202,0.169,0.139,0.158,0.054,
0.175,0.160,0.082,0.122,0.076,0.095,0.165,0.251,0.311,0.168,
0.043,0.076,0.310,0.055,0.192,0.068,0.210,0.197,0.099,0.211,
0.143,0.152,0.179,0.123,0.100,0.187,0.239,0.283,0.400,0.274,
0.176,0.029,0.150,0.207,0.125,0.129,0.135,0.230,1.910,1.310,
0.889,1.010,1.850,1.950,1.630,1.350,1.650,0.289,1.270,1.280,
0.901,1.110,1.000,1.290,0.161,0.221,0.116,0.107,0.193,0.317,
0.332,0.141,0.185,0.071,0.271,0.188,0.106,0.199,0.143,0.135,
1.450,1.680,1.260,1.260,0.209,0.253,0.253,0.263,1.560,0.288,
0.629,0.913,0.713,1.270,1.030,1.080,0.990,0.709,0.618,0.807,
1.400,1.450,1.210,1.430,1.370,0.198,1.280,1.320,0.812,0.989,
1.100,1.380,1.630,0.968,0.749,1.200,1.160,0.874,0.617,0.752,
1.120,0.140,0.774,1.050,1.030,0.897,0.644,1.210,1.710,1.510,
0.902,1.030,1.670,1.740,1.440,1.070,1.480,0.217,1.400,1.480,
1.220,1.500,0.995,1.260,1.480,1.800,1.170,1.480,0.181,0.267,
0.178,0.251,1.660,0.272,1.500,1.650,1.060,1.770,1.380,1.610,
1.270,0.850,0.694,1.120,1.380,1.300,0.924,1.240,1.510,0.164,
1.400,1.670,1.410,1.430,1.450,2.110,3.180,1.460,1.110,2.140,
1.430,0.893,0.746,1.080,1.300,0.137,0.599,0.984,1.770,1.160,
0.804,1.720,1.820,1.040,0.683,1.020,1.000,0.682,0.596,0.750,
0.887,0.079,0.565,0.843,0.772,0.673,0.523,0.932,1.460,1.550,
0.825,1.330,0.128,0.123,0.101,0.188,1.000,0.104,0.561,0.914,
0.977,1.090,0.752,1.250,1.830,1.060,0.874,1.820,1.260,0.900,
0.867,1.480,1.160,0.099,0.665,1.140,1.670,1.050,1.190,2.580,
3.180,2.020,1.240,2.260,2.100,1.880,1.290,1.550,1.580,0.176,
0.903,1.370,1.460,1.470,0.850,1.750,2.130,1.630,0.893,1.340,
1.720,1.510,1.150,1.310,1.400,0.163,1.050,1.450,0.981,1.110,
0.753,1.180,1.690,2.010,1.480,1.600,0.154,0.208,0.328,0.208,
1.470,0.189,1.160,1.620,1.160,1.760,1.190,1.760,1.790,1.210,
1.020,1.740,1.830,1.730,1.560,1.940,1.510,0.139,1.070,1.640,
1.430,1.330,1.250,2.340,2.180,1.370,1.020,1.390,1.830,1.560,
1.360,1.530,1.670,0.229,1.040,1.550,1.240,1.260,1.110,1.940,
0.180,0.181,0.094,0.138,0.177,0.272,0.175,0.165,0.134,0.036,
0.151,0.176,0.122,0.184,0.120,0.166,1.440,1.970,1.090,1.490,
0.145,0.186,0.145,0.257,1.520,0.223,0.989,1.350,1.060,1.770,
1.210,1.470,1.340,1.000,0.853,1.230,1.700,1.530,1.420,1.970,
1.550,0.155,1.300,1.730,1.360,1.330,1.580,2.140,2.760,1.250,
1.110,1.910,1.390,0.969,0.873,1.050,1.610,0.210,0.861,1.460,
1.480,1.060,0.909,2.180,2.020,1.470,0.874,1.320,1.530,1.350,
1.080,1.170,1.260,0.120,1.060,1.500,1.250,1.170,0.981,1.610,
1.850,1.900,1.280,1.960,0.167,0.196,0.122,0.221,1.820,0.199,
1.450,2.120,1.630,2.050,1.750,2.260,2.590,1.380,1.250,2.520,
2.010,1.960,1.390,2.080,2.230,0.175,1.740,2.810,3.000,2.160,
2.470,4.100,8.040,3.800,3.350,7.290,3.630,2.000,1.790,2.600,
3.650,0.317,1.400,2.500,6.420,4.060,2.130,4.620,3.140,1.550,
1.180,1.820,1.810,0.986,0.893,1.110,1.870,0.133,1.010,1.220,
1.770,1.440,0.873,1.600,2.600,1.670,1.260,2.290,0.215,0.139,
0.114,0.260,1.460,0.114,0.767,1.220,1.580,1.520,1.070,2.050,
5.050,2.020,1.800,3.780,2.640,1.590,1.390,2.400,2.200,0.165,
1.250,2.030,3.520,2.030,2.110,5.260,3.930,1.800,1.230,2.350,
2.010,1.110,0.866,1.230,1.680,0.160,0.675,1.150,2.080,1.630,
0.798,1.850,2.020,1.140,0.700,1.150,1.110,0.591,0.565,0.779,
1.310,0.142,0.617,0.889,1.150,0.964,0.567,1.020,1.830,1.380,
0.981,1.520,0.147,0.100,0.082,0.136,1.330,0.107,0.617,0.966,
1.240,1.230,0.853,1.370,1.880,1.030,0.819,1.600,1.440,0.962,
0.742,1.160,1.280,0.085,0.660,1.140,1.460,1.090,1.010,2.410,
3.610,1.390,1.160,2.230,2.200,1.200,1.100,1.730,2.770,0.257,
0.811,1.350,3.070,1.950,1.130,2.910,0.259,0.141,0.104,0.203,
0.185,0.125,0.110,0.175,0.203,0.021,0.095,0.149,0.338,0.299,
0.130,0.298,1.440,1.070,1.020,1.430,0.124,0.081,0.082,0.154,
1.180,0.108,0.557,0.857,1.170,1.170,0.845,1.290,1.530,0.841,
0.897,1.620,1.550,0.997,0.933,1.560,1.340,0.109,0.763,1.270,
1.700,1.290,1.280,2.560,5.150,1.780,1.570,3.720,2.040,1.060,
1.020,1.710,3.190,0.263,1.160,1.920,6.660,3.050,1.850,5.060,
2.850,1.430,1.200,1.940,1.670,1.010,0.991,1.380,2.080,0.142,
1.030,1.570,2.910,2.160,1.260,2.550,2.030,1.470,1.350,2.010,
0.155,0.102,0.106,0.177,1.700,0.115,0.945,1.490,1.840,1.790,
1.370,2.250,3.710,1.750,1.640,3.570,2.090,1.360,1.270,2.150,
2.820,0.183,1.650,2.910,5.190,3.530,3.260,7.760,5.150,2.670,
1.970,3.830,2.860,1.790,1.420,1.920,2.290,0.234,0.960,1.640,
2.880,2.680,1.300,2.720,3.130,1.770,1.260,2.060,2.120,1.350,
1.220,1.410,1.570,0.163,1.310,1.390,1.330,1.390,0.970,1.690,
1.990,1.780,1.170,1.910,0.196,0.176,0.122,0.220,1.260,0.136,
0.827,1.300,1.220,1.500,1.050,1.860,2.210,1.230,1.070,1.970,
2.050,1.530,1.120,1.720,1.480,0.141,0.895,1.470,1.830,1.290,
1.410,2.920,3.550,2.060,1.210,2.300,2.320,1.680,1.140,1.450,
1.550,0.178,0.654,1.180,1.620,1.700,0.783,1.680,2.260,1.690,
0.897,1.380,1.780,1.170,0.993,1.210,1.410,0.171,0.801,1.160,
1.030,1.190,0.714,1.160,1.710,1.840,1.040,1.530,0.210,0.236,
0.155,0.198,1.480,0.190,0.851,1.240,1.160,1.650,1.040,1.680,
1.520,1.100,0.762,1.350,1.700,1.740,0.977,1.280,1.160,0.102,
0.667,1.160,1.210,1.060,0.938,2.040,2.800,1.330,0.942,1.680,
2.000,1.380,1.240,1.530,1.890,0.245,0.806,1.100,1.760,1.640,
1.010,2.100,0.149,0.134,0.082,0.146,0.154,0.168,0.135,0.153,
0.145,0.038,0.129,0.133,0.157,0.244,0.115,0.175,1.530,1.540,
1.180,1.490,0.148,0.155,0.128,0.173,1.460,0.216,0.819,1.160,
1.080,1.730,1.100,1.560,1.530,0.874,0.876,1.460,1.750,1.560,
1.330,1.720,1.500,0.134,0.940,1.420,1.460,1.230,1.350,2.410,
3.180,1.520,1.230,2.290,1.550,0.994,0.893,1.220,1.810,0.164,
0.860,1.270,2.610,1.790,1.250,2.890,2.420,1.640,1.290,1.880,
1.780,1.440,1.330,1.530,1.710,0.178,1.200,1.580,1.950,2.330,
1.340,2.210,1.640,1.530,1.270,1.830,0.134,0.128,0.097,0.157,
1.400,0.127,0.992,1.490,1.390,1.680,1.320,2.130,2.400,1.290,
1.180,2.090,1.830,1.430,1.170,1.600,1.950,0.145,1.270,2.140,
2.800,2.150,2.100,4.120,3.110,1.790,1.240,2.390,1.640,1.170,
0.803,1.270,1.630,0.151,0.750,1.210,1.870,1.410,0.929,1.750,
2.350,1.640,0.925,1.480,1.480,1.070,0.840,0.959,1.540,0.161,
0.985,1.270,1.280,1.430,0.865,1.490,1.780,1.850,1.230,1.860,
0.224,0.208,0.158,0.274,1.480,0.163,0.883,1.460,1.150,1.650,
1.000,1.940,1.770,1.140,0.906,1.850,1.510,1.280,0.950,1.520,
1.750,0.163,1.030,1.790,1.850,1.330,1.450,3.200,0.196,0.148,
0.089,0.184,0.174,0.154,0.090,0.129,0.126,0.020,0.073,0.109,
0.137,0.154,0.097,0.175,0.144,0.128,0.064,0.100,0.136,0.150,
0.091,0.098,0.123,0.024,0.106,0.119,0.096,0.124,0.073,0.114,
0.130,0.176,0.112,0.142,0.021,0.035,0.040,0.026,0.167,0.033,
0.119,0.169,0.114,0.193,0.123,0.299,0.167,0.120,0.086,0.185,
0.190,0.211,0.144,0.199,0.160,0.019,0.112,0.176,0.158,0.138,
0.133,0.286,2.000,1.230,0.829,1.190,1.530,1.390,1.060,1.220,
1.470,0.223,0.973,1.140,1.170,1.310,1.210,1.730,0.136,0.140,
0.069,0.100,0.115,0.147,0.103,0.087,0.127,0.031,0.168,0.118,
0.124,0.187,0.122,0.147,1.350,1.830,1.040,1.330,0.141,0.183,
0.128,0.157,1.510,0.192,0.742,1.020,0.883,1.430,1.040,1.340,
1.280,0.921,0.731,1.060,1.420,1.440,1.070,1.330,1.610,0.161,
1.350,1.460,1.200,1.260,1.380,1.980,2.040,1.070,0.794,1.520,
1.230,0.862,0.634,0.911,1.350,0.129,0.828,1.170,1.640,1.180,
1.030,1.870,2.140,1.510,0.986,1.460,1.490,1.380,0.996,1.050,
1.660,0.156,1.230,1.500,1.740,1.810,1.240,1.840,1.900,1.890,
1.270,1.940,0.164,0.235,0.127,0.182,1.740,0.172,1.240,1.670,
1.670,2.000,1.590,2.180,1.840,1.120,1.010,1.630,1.520,1.430,
1.010,1.390,2.010,0.159,1.580,2.020,2.220,2.000,2.000,3.260,
6.160,2.260,1.820,3.990,2.100,1.200,1.020,1.760,2.090,0.174,
0.947,1.760,3.110,1.930,1.330,3.340,2.520,1.330,0.854,1.490,
1.380,0.856,0.718,1.040,1.420,0.116,0.975,1.330,1.290,1.070,
0.834,1.560,2.090,2.120,1.050,2.190,0.156,0.154,0.093,0.232,
1.320,0.124,0.723,1.320,1.430,1.460,0.991,2.040,3.200,1.650,
1.450,3.360,1.870,1.230,1.110,2.150,1.880,0.139,1.180,2.310,
3.490,1.960,2.110,5.820,2.790,1.490,1.040,2.090,1.620,1.130,
0.856,1.240,1.320,0.116,0.642,1.210,1.500,1.270,0.835,2.040,
1.780,1.130,0.643,1.150,1.160,0.830,0.603,0.878,1.150,0.098,
0.756,1.160,1.000,0.985,0.693,1.280,1.500,1.360,0.878,1.520,
0.100,0.109,0.080,0.131,1.300,0.119,0.757,1.330,1.290,1.590,
0.998,2.040,1.850,1.090,0.953,1.930,1.620,1.230,0.932,1.650,
1.430,0.100,0.881,1.580,1.780,1.400,1.340,3.040,3.040,1.660,
1.390,2.050,2.130,1.490,1.330,1.980,2.150,0.228,1.070,1.760,
2.090,1.740,1.570,3.290,0.187,0.165,0.096,0.166,0.136,0.143,
0.110,0.140,0.130,0.019,0.105,0.144,0.173,0.191,0.126,0.241,
1.920,1.940,1.310,2.080,0.137,0.137,0.102,0.200,1.820,0.171,
1.020,1.570,1.530,1.870,1.490,2.300,2.260,1.510,1.340,2.060,
2.270,1.740,1.520,2.390,2.250,0.176,1.690,2.450,2.200,1.760,
2.170,3.600,5.840,2.160,1.820,3.760,2.230,1.450,1.210,1.810,
2.690,0.205,1.340,2.410,3.860,2.390,2.100,5.940,3.320,2.000,
1.310,2.180,2.240,1.930,1.260,1.670,2.330,0.152,1.360,2.210,
2.520,2.130,1.620,3.300,3.260,2.730,2.000,3.370,0.178,0.171,
0.114,0.235,2.780,0.195,1.920,3.110,3.090,3.150,2.820,4.430,
6.430,2.840,2.720,5.840,3.360,2.520,2.110,3.700,4.150,0.234,
2.990,5.340,6.910,3.980,4.430,8.120,6.850,3.650,2.620,4.760,
4.040,2.540,1.880,2.320,3.810,0.407,1.600,2.470,4.570,3.660,
1.970,3.300,4.660,2.800,1.570,2.050,2.750,1.850,1.370,1.360,
2.330,0.227,1.260,1.570,1.750,1.780,1.180,1.770,2.780,2.360,
1.520,2.060,0.264,0.268,0.187,0.304,1.810,0.214,1.060,1.300,
1.550,2.140,1.310,1.800,4.120,1.960,1.720,3.020,2.910,2.100,
1.700,2.550,2.190,0.209,1.200,1.840,2.630,1.830,1.760,2.960,
4.700,2.420,1.320,2.210,2.810,2.150,1.280,1.450,2.220,0.277,
0.893,1.340,1.640,1.790,0.843,1.460,3.240,2.290,1.030,1.360,
2.080,1.570,1.070,1.020,1.840,0.261,1.000,1.340,1.060,1.450,
0.779,1.030,1.820,2.080,1.000,1.290,0.185,0.243,0.146,0.162,
1.830,0.266,1.060,1.270,0.979,1.790,1.010,1.270,1.520,1.110,
0.702,1.150,1.670,1.490,0.889,1.170,1.600,0.163,0.930,1.270,
1.290,1.230,1.060,1.780,2.390,1.300,0.866,1.340,1.890,1.200,
1.040,1.130,1.700,0.240,0.739,1.190,1.310,1.290,0.911,1.690,
0.209,0.187,0.093,0.130,0.174,0.165,0.122,0.117,0.166,0.044,
0.119,0.160,0.154,0.257,0.127,0.196,1.160,1.150,0.911,0.878,
0.137,0.133,0.113,0.126,1.170,0.209,0.645,0.803,0.674,1.070,
0.743,0.800,1.120,0.768,0.637,0.912,1.410,1.150,0.868,1.140,
1.360,0.165,0.953,1.210,1.020,1.130,1.060,1.520,3.310,1.380,
0.977,2.040,1.500,0.885,0.790,1.030,1.560,0.156,0.624,1.110,
2.000,1.430,1.020,2.340,2.750,1.740,1.040,1.380,1.760,1.270,
0.999,1.030,1.480,0.146,0.874,1.240,1.380,1.580,0.995,1.650,
1.390,1.290,1.060,1.280,0.140,0.123,0.180,0.144,1.210,0.128,
0.763,1.060,1.030,1.370,1.040,1.270,1.970,1.150,0.994,1.820,
1.280,1.010,0.942,1.300,1.770,0.158,1.120,1.800,2.020,1.810,
1.710,3.020,4.520,3.150,1.840,2.840,2.670,2.310,1.520,1.610,
1.880,0.244,0.936,1.380,1.730,1.910,1.140,1.800,3.140,3.490,
1.360,1.590,2.250,1.920,1.440,1.300,1.490,0.242,1.010,1.280,
0.949,1.340,0.818,1.180,1.600,2.360,1.150,1.280,0.233,0.427,
0.190,0.213,1.300,0.201,1.020,1.030,0.858,1.460,1.030,1.230,
1.660,1.060,0.839,1.260,1.850,1.890,1.030,1.260,1.190,0.206,
0.719,1.010,1.280,1.090,1.010,1.900,3.110,2.690,1.060,1.470,
2.230,2.550,1.230,1.110,1.520,0.265,0.718,0.989,0.956,1.470,
0.724,1.130,2.100,2.460,0.901,0.985,1.750,1.210,1.190,0.931,
1.440,0.314,0.876,1.150,0.726,1.380,0.741,0.839,1.350,2.520,
0.961,1.040,0.222,0.534,0.213,0.175,1.680,0.450,1.050,1.290,
0.805,2.360,1.040,1.190,1.050,0.996,0.515,0.761,1.500,1.920,
0.773,0.897,1.300,0.196,0.666,0.923,0.894,1.190,0.714,1.280,
1.680,1.420,0.719,0.975,1.730,1.660,1.230,1.040,1.240,0.224,
0.766,0.940,0.738,1.050,0.794,1.060,0.158,0.330,0.104,0.114,
0.174,0.291,0.198,0.116,0.171,0.103,0.173,0.167,0.082,0.231,
0.118,0.119,1.220,1.620,1.830,1.050,0.269,0.300,0.236,0.170,
1.420,0.279,0.962,1.080,0.626,1.440,1.050,0.944,0.911,0.698,
0.609,0.794,1.480,1.700,1.160,1.180,1.260,0.174,0.974,1.180,
0.736,0.969,0.977,1.230,1.450,0.917,0.596,0.925,1.010,0.797,
0.723,0.640,0.849,0.091,0.396,0.584,0.817,0.726,0.529,0.961,
1.480,1.620,0.817,0.929,1.200,1.350,0.847,0.827,1.150,0.161,
0.676,0.896,0.700,1.240,0.682,0.961,0.953,1.260,0.882,0.928,
0.105,0.159,0.098,0.104,0.952,0.137,0.737,0.928,0.660,1.110,
0.980,1.050,1.120,0.777,0.602,0.897,1.030,1.040,0.638,0.905,
1.250,0.177,0.814,1.210,1.210,1.400,1.220,1.850,2.220,1.610,
0.928,1.600,1.270,1.100,0.684,0.860,1.080,0.141,0.549,0.833,
1.090,1.110,0.580,1.100,2.020,2.170,0.990,1.170,1.430,1.320,
0.908,0.867,1.340,0.222,0.872,1.030,0.833,1.320,0.685,0.968,
1.280,1.750,1.030,1.240,0.172,0.239,0.147,0.213,1.040,0.164,
0.636,0.814,0.681,1.280,0.670,0.991,1.190,0.801,0.661,1.090,
1.190,1.080,0.706,0.951,1.080,0.133,0.652,1.030,1.120,1.010,
0.962,2.180,0.162,0.172,0.074,0.120,0.165,0.227,0.104,0.107,
0.134,0.041,0.076,0.094,0.093,0.168,0.072,0.107,0.175,0.310,
0.100,0.115,0.209,0.326,0.155,0.127,0.170,0.073,0.139,0.141,
0.087,0.208,0.090,0.105,0.104,0.220,0.102,0.104,0.033,0.081,
0.053,0.030,0.158,0.068,0.141,0.133,0.081,0.240,0.113,0.120,
0.120,0.108,0.068,0.111,0.218,0.278,0.151,0.171,0.160,0.035,
0.115,0.145,0.124,0.149,0.118,0.215,1.060,0.864,0.527,0.667,
0.957,0.947,0.912,0.652,1.140,0.206,0.619,0.711,0.613,0.808,
0.592,0.741,0.105,0.175,0.070,0.068,0.099,0.153,0.112,0.064,
0.124,0.054,0.105,0.103,0.079,0.175,0.090,0.085,0.770,1.220,
0.686,0.637,0.114,0.186,0.138,0.100,1.050,0.230,0.562,0.743,
0.501,1.200,0.715,0.687,0.669,0.541,0.421,0.482,0.852,1.010,
0.732,0.705,1.120,0.211,0.760,0.883,0.613,0.987,0.717,0.929,
1.050,0.661,0.416,0.824,0.745,0.515,0.383,0.432,0.999,0.098,
0.341,0.565,0.808,0.650,0.410,0.851,1.300,1.220,0.646,0.770,
1.070,1.080,0.722,0.665,1.040,0.148,0.675,0.875,0.813,1.150,
0.670,0.871,0.928,1.200,0.751,0.818,0.118,0.170,0.103,0.103,
1.130,0.190,0.689,0.898,0.710,1.270,0.768,0.961,1.010,0.676,
0.596,0.721,0.958,0.973,0.706,0.797,1.290,0.151,0.951,1.270,
1.140,1.310,1.060,1.720,2.570,1.470,0.996,1.990,1.130,0.825,
0.582,0.760,1.070,0.122,0.480,0.861,1.520,1.200,0.717,1.620,
1.310,0.939,0.524,0.969,0.825,0.568,0.416,0.538,0.757,0.080,
0.384,0.630,0.658,0.681,0.405,0.754,1.130,1.070,0.624,1.100,
0.116,0.121,0.072,0.148,0.799,0.081,0.402,0.618,0.673,0.833,
0.523,0.898,1.440,0.784,0.689,1.520,1.040,0.785,0.595,0.984,
0.919,0.085,0.561,0.904,1.380,1.010,0.976,2.440,2.130,1.500,
0.808,1.450,1.570,1.410,0.743,0.938,1.290,0.175,0.592,0.970,
1.100,1.390,0.636,1.160,1.580,1.590,0.651,1.090,1.390,1.400,
0.760,0.831,1.190,0.203,0.687,1.050,0.802,1.240,0.560,0.923,
0.982,1.200,0.565,0.868,0.102,0.158,0.085,0.114,1.080,0.152,
0.686,0.901,0.769,1.380,0.765,1.030,0.999,0.724,0.507,0.918,
1.200,1.200,0.718,1.100,1.060,0.108,0.667,0.983,1.030,1.040,
0.843,1.610,1.120,0.832,0.474,0.781,0.971,0.731,0.585,0.703,
1.070,0.204,0.585,0.912,0.795,0.916,0.652,1.080,0.087,0.119,
0.050,0.086,0.074,0.098,0.065,0.064,0.111,0.045,0.087,0.155,
0.080,0.154,0.070,0.108,0.719,0.864,0.605,0.664,0.082,0.094,
0.125,0.090,0.853,0.125,0.492,0.712,0.533,0.909,0.741,0.801,
0.706,0.540,0.424,0.649,0.941,0.824,0.701,0.865,1.050,0.165,
0.652,0.988,0.756,0.889,0.771,1.240,1.890,0.886,0.608,1.190,
0.959,0.658,0.469,0.638,1.490,0.120,0.442,0.797,1.360,0.942,
0.705,1.620,1.040,0.774,0.457,0.782,0.839,0.650,0.517,0.637,
0.867,0.092,0.497,0.930,0.764,0.886,0.552,1.020,1.180,1.130,
0.702,1.080,0.107,0.103,0.072,0.108,1.200,0.115,0.685,1.080,
1.020,1.350,1.070,1.380,1.690,0.972,0.788,1.640,1.350,1.250,
0.886,1.280,1.720,0.128,1.110,1.900,2.200,1.760,1.720,3.270,
3.960,2.610,1.810,2.920,2.730,2.150,1.320,1.520,2.150,0.290,
1.070,1.650,2.310,2.280,1.160,1.990,2.900,2.350,1.220,1.490,
2.530,2.030,1.340,1.220,1.740,0.252,1.280,1.430,1.090,1.500,
0.977,1.260,1.310,1.380,0.901,1.130,0.152,0.177,0.137,0.178,
1.010,0.152,0.701,0.749,0.766,1.200,0.808,1.040,1.610,0.962,
0.783,1.400,1.500,1.320,0.951,1.250,1.150,0.145,0.746,1.060,
1.300,1.070,1.070,1.820,3.110,2.170,1.020,1.660,2.420,2.180,
1.080,1.120,1.640,0.291,0.904,1.120,1.110,1.550,0.668,1.120,
2.350,2.430,0.922,1.260,2.160,1.960,1.150,1.090,1.700,0.438,
1.390,1.710,0.874,1.690,0.753,0.972,1.080,1.650,0.777,0.828,
0.172,0.295,0.207,0.152,1.290,0.310,1.060,1.030,0.697,1.670,
0.953,0.979,0.806,0.733,0.467,0.638,1.170,1.320,0.935,0.863,
1.010,0.148,0.708,1.010,0.778,0.954,0.889,1.350,1.370,0.967,
0.562,0.812,1.480,1.250,0.860,0.890,1.390,0.230,0.668,0.867,
0.791,0.989,0.640,1.110,0.119,0.173,0.089,0.102,0.176,0.240,
0.152,0.123,0.155,0.079,0.155,0.158,0.091,0.241,0.111,0.137,
0.639,0.885,0.639,0.575,0.103,0.138,0.108,0.104,0.837,0.173,
0.667,0.730,0.436,0.876,0.614,0.616,0.643,0.510,0.522,0.559,
0.895,0.956,0.634,0.791,0.893,0.156,0.685,0.870,0.632,0.880,
0.822,1.100,1.520,0.732,0.494,1.010,0.837,0.570,0.382,0.525,
0.914,0.098,0.387,0.583,0.991,0.815,0.531,1.250,1.370,1.190,
0.677,0.883,1.360,1.290,0.773,0.825,0.954,0.145,0.679,0.948,
0.687,1.140,0.611,0.945,0.670,0.736,0.664,0.717,0.073,0.086,
0.099,0.088,0.689,0.102,0.577,0.699,0.502,0.838,0.630,0.754,
1.020,0.696,0.809,1.010,0.683,0.705,0.563,0.712,1.010,0.116,
0.712,1.050,1.090,1.220,1.080,1.880,2.780,2.060,1.200,1.810,
2.160,2.220,1.290,1.240,1.210,0.188,0.685,0.935,1.060,1.290,
0.671,1.120,2.110,2.110,1.090,1.150,2.190,2.440,1.860,1.320,
1.200,0.275,1.040,1.160,0.646,1.220,0.683,0.893,0.942,1.370,
0.838,0.875,0.139,0.242,0.174,0.161,0.834,0.167,0.774,0.744,
0.734,1.020,0.707,0.858,0.856,0.610,0.480,0.785,1.070,1.300,
0.750,0.844,0.676,0.099,0.562,0.683,1.160,0.759,0.692,1.210,
2.130,1.820,0.710,0.925,1.650,2.160,0.932,0.829,1.150,0.235,
0.660,0.782,0.662,1.100,0.456,0.759,1.290,1.260,0.580,0.645,
0.679,0.537,0.581,0.510,0.972,0.416,0.696,0.898,0.445,1.200,
0.518,0.604,0.769,1.630,0.681,0.700,0.166,0.556,0.246,0.166,
1.030,0.354,0.794,1.000,0.509,1.670,0.861,0.902,0.547,0.623,
0.361,0.449,0.949,1.710,0.664,0.724,0.764,0.159,0.636,0.810,
0.548,0.841,0.558,0.969,1.150,1.070,0.608,0.681,1.520,1.930,
1.150,0.945,1.080,0.243,0.707,0.795,0.583,1.050,0.655,0.854,
0.111,0.259,0.130,0.104,0.240,0.617,0.305,0.165,0.181,0.178,
0.234,0.182,0.075,0.344,0.133,0.111,0.727,1.330,0.821,0.716,
0.166,0.373,0.243,0.159,0.941,0.257,0.779,0.888,0.443,1.350,
0.931,0.822,0.536,0.511,0.406,0.494,1.100,1.770,1.150,1.040,
0.997,0.178,0.948,1.010,0.587,0.862,0.915,1.080,0.909,0.652,
0.401,0.629,0.776,0.747,0.396,0.450,0.687,0.083,0.330,0.430,
0.598,0.583,0.367,0.659,0.928,1.230,0.696,0.735,1.210,1.980,
0.881,0.858,0.834,0.193,0.635,0.792,0.479,1.190,0.578,0.714,
0.585,0.954,0.630,0.657,0.074,0.167,0.096,0.091,0.628,0.127,
0.736,0.762,0.422,0.930,0.860,0.860,0.633,0.541,0.379,0.587,
0.650,0.929,0.502,0.675,0.751,0.100,0.625,0.810,0.698,0.956,
0.954,1.370,1.710,1.390,0.752,1.220,1.270,1.120,0.605,0.863,
1.010,0.137,0.505,0.674,0.815,0.927,0.460,0.885,1.850,2.190,
0.773,1.060,1.940,1.890,1.190,1.120,1.440,0.310,1.190,1.230,
0.709,1.370,0.619,0.888,0.917,1.460,0.775,1.010,0.189,0.249,
0.142,0.208,0.929,0.199,0.622,0.791,0.551,1.220,0.596,0.818,
0.806,0.635,0.414,0.829,1.120,1.170,0.627,0.887,0.877,0.137,
0.652,0.949,0.803,0.845,0.770,1.540,0.145,0.151,0.061,0.091,
0.200,0.305,0.141,0.125,0.151,0.051,0.090,0.093,0.073,0.154,
0.070,0.105,0.166,0.353,0.100,0.137,0.338,0.639,0.332,0.218,
0.234,0.265,0.276,0.230,0.079,0.260,0.094,0.103,0.100,0.249,
0.113,0.094,0.077,0.199,0.117,0.050,0.175,0.138,0.224,0.183,
0.072,0.274,0.149,0.111,0.082,0.089,0.043,0.072,0.329,0.404,
0.151,0.168,0.120,0.048,0.139,0.146,0.077,0.116,0.098,0.148,
1.090,1.240,0.575,0.688,1.200,1.630,0.959,0.825,1.220,0.291,
0.815,0.845,0.599,0.996,0.633,0.865,0.135,0.418,0.115,0.095,
0.180,0.449,0.251,0.130,0.193,0.150,0.262,0.180,0.081,0.260,
0.120,0.107,0.693,1.450,0.687,0.653,0.145,0.313,0.184,0.132,
1.110,0.330,0.629,0.879,0.468,1.350,0.714,0.734,0.550,0.569,
0.355,0.506,0.999,1.560,0.839,0.942,1.190,0.254,1.150,1.160,
0.563,0.965,0.811,1.030,0.864,0.672,0.377,0.723,0.650,0.550,
0.329,0.407,0.719,0.096,0.376,0.590,0.591,0.606,0.344,0.812,
1.270,1.860,0.685,0.779,1.540,1.930,1.040,0.937,1.450,0.300,
1.120,1.300,0.751,1.500,0.739,0.953,0.797,1.290,0.833,0.802,
0.099,0.203,0.123,0.105,1.040,0.232,0.888,1.030,0.583,1.460,
0.810,0.938,0.741,0.640,0.443,0.742,0.765,0.968,0.584,0.728,
1.130,0.151,1.090,1.280,0.897,1.270,1.020,1.460,1.470,0.901,
0.585,1.150,0.882,0.658,0.415,0.674,0.760,0.087,0.368,0.645,
0.828,0.716,0.396,0.991,1.140,0.926,0.422,0.682,0.830,0.695,
0.435,0.585,0.638,0.085,0.380,0.586,0.482,0.578,0.308,0.609,
0.698,0.720,0.399,0.698,0.070,0.073,0.043,0.095,0.550,0.070,
0.312,0.480,0.424,0.587,0.350,0.599,0.793,0.508,0.380,0.897,
0.626,0.545,0.361,0.720,0.595,0.061,0.364,0.648,0.773,0.606,
0.553,1.390,1.440,1.080,0.530,0.898,1.260,1.360,0.749,0.824,
1.080,0.171,0.583,0.829,0.752,1.100,0.480,0.930,1.240,1.440,
0.510,0.780,1.610,1.880,0.919,0.961,1.240,0.305,0.810,1.120,
0.720,1.380,0.553,0.849,0.634,1.020,0.472,0.604,0.117,0.204,
0.103,0.114,0.864,0.165,0.653,0.777,0.555,1.170,0.656,0.771,
0.542,0.479,0.326,0.572,0.942,1.180,0.591,0.971,0.763,0.108,
0.600,0.818,0.616,0.747,0.621,1.120,0.883,0.725,0.386,0.548,
0.942,0.960,0.624,0.682,1.000,0.161,0.572,0.742,0.599,0.742,
0.522,0.869,0.069,0.123,0.042,0.059,0.082,0.175,0.090,0.074,
0.086,0.038,0.083,0.091,0.055,0.120,0.064,0.080,0.486,0.746,
0.417,0.499,0.067,0.105,0.075,0.082,0.790,0.158,0.576,0.745,
0.426,0.881,0.581,0.676,0.481,0.455,0.308,0.485,0.730,0.850,
0.568,0.777,0.962,0.207,0.745,0.953,0.578,0.828,0.709,1.020,
1.080,0.667,0.392,0.755,0.613,0.526,0.318,0.437,0.721,0.074,
0.371,0.552,0.706,0.577,0.428,0.965,0.855,0.770,0.367,0.558,
0.766,0.881,0.492,0.626,0.820,0.097,0.503,0.690,0.586,0.729,
0.472,0.837,0.743,0.761,0.493,0.691,0.070,0.078,0.050,0.080,
0.769,0.097,0.595,0.805,0.603,0.960,0.748,0.942,0.964,0.632,
0.502,1.000,0.864,0.989,0.640,0.961,1.130,0.115,0.920,1.360,
1.340,1.330,1.280,1.730,2.140,1.500,1.240,1.910,1.660,1.300,
1.010,1.110,1.380,0.164,0.655,1.030,1.580,1.420,0.808,1.390,
1.440,1.180,0.843,0.889,1.140,0.846,0.772,0.715,0.907,0.128,
0.599,0.715,0.692,0.874,0.661,0.879,1.030,1.000,0.635,0.937,
0.108,0.110,0.086,0.145,0.710,0.094,0.476,0.764,0.543,0.771,
0.549,0.826,1.190,0.676,0.529,0.996,1.070,0.881,0.658,0.910,
0.733,0.077,0.538,0.702,0.924,0.652,0.772,1.350,2.150,1.690,
0.894,1.320,1.910,1.800,1.270,1.120,1.200,0.197,0.583,0.738,
0.911,1.220,0.586,0.967,1.650,1.850,0.796,0.902,1.540,1.280,
1.170,0.919,1.400,0.314,0.814,1.020,0.729,1.350,0.630,0.793,
1.180,1.710,0.871,1.070,0.186,0.289,0.202,0.202,1.350,0.285,
1.060,1.350,0.680,1.530,0.965,1.040,0.879,0.699,0.415,0.709,
1.490,1.500,0.803,1.030,0.877,0.113,0.561,0.797,0.748,0.773,
0.709,1.280,1.190,0.774,0.505,0.813,1.420,1.160,0.994,1.010,
1.540,0.269,0.567,0.728,0.980,1.130,0.624,1.050,0.118,0.161,
0.077,0.130,0.153,0.189,0.154,0.145,0.207,0.076,0.129,0.135,
0.139,0.338,0.127,0.177,0.715,0.816,0.651,0.726,0.118,0.135,
0.135,0.147,0.881,0.206,0.561,0.614,0.516,1.060,0.602,0.674,
0.588,0.412,0.340,0.553,0.952,0.962,0.778,0.962,0.797,0.120,
0.736,0.708,0.724,0.749,0.704,1.230,1.210,0.615,0.449,0.892,
0.715,0.496,0.463,0.595,0.824,0.098,0.338,0.510,1.090,0.878,
0.513,1.160,1.050,1.010,0.539,0.774,0.894,0.826,0.715,0.794,
1.030,0.171,0.567,0.747,0.847,1.260,0.615,0.980,0.726,0.834,
0.670,0.838,0.086,0.094,0.094,0.121,0.797,0.113,0.637,0.828,
0.658,1.030,0.804,0.994,0.970,0.630,0.521,1.020,0.722,0.616,
0.622,0.862,1.070,0.116,0.820,1.110,1.440,1.330,1.370,2.320,
0.125,0.122,0.121,0.101,0.123,0.150,0.094,0.092,0.083,0.021,
0.052,0.063,0.074,0.103,0.059,0.081,0.153,0.191,0.203,0.112,
0.191,0.219,0.209,0.128,0.124,0.069,0.131,0.108,0.063,0.144,
0.087,0.087,0.079,0.167,0.077,0.077,0.022,0.044,0.033,0.025,
0.078,0.031,0.087,0.086,0.048,0.105,0.078,0.084,0.078,0.065,
0.050,0.075,0.117,0.143,0.096,0.102,0.079,0.018,0.074,0.084,
0.083,0.076,0.095,0.127,0.134,0.185,0.078,0.083,0.179,0.321,
0.184,0.110,0.104,0.051,0.074,0.069,0.055,0.120,0.078,0.068,
0.197,0.352,0.136,0.106,0.330,0.385,0.361,0.189,0.236,0.195,
0.176,0.161,0.085,0.258,0.110,0.094,0.103,0.263,0.119,0.100,
0.059,0.246,0.133,0.050,0.189,0.151,0.206,0.170,0.062,0.266,
0.173,0.126,0.072,0.080,0.046,0.060,0.161,0.266,0.136,0.115,
0.102,0.032,0.090,0.086,0.060,0.094,0.083,0.120,0.081,0.087,
0.048,0.074,0.137,0.210,0.168,0.113,0.157,0.073,0.096,0.077,
0.059,0.146,0.070,0.079,0.021,0.060,0.027,0.043,0.059,0.150,
0.124,0.050,0.078,0.128,0.096,0.057,0.016,0.088,0.040,0.025,
0.081,0.165,0.153,0.113,0.045,0.113,0.119,0.045,0.215,0.192,
0.192,0.142,0.065,0.295,0.151,0.106,0.063,0.057,0.050,0.065,
0.134,0.230,0.187,0.140,0.129,0.057,0.157,0.122,0.062,0.108,
0.109,0.130,0.087,0.088,0.051,0.075,0.074,0.078,0.060,0.062,
0.077,0.015,0.041,0.051,0.083,0.098,0.059,0.104,0.151,0.289,
0.104,0.134,0.181,0.253,0.191,0.180,0.199,0.083,0.124,0.133,
0.114,0.321,0.120,0.140,0.067,0.128,0.093,0.089,0.016,0.039,
0.031,0.022,0.118,0.048,0.135,0.140,0.068,0.169,0.139,0.125,
0.081,0.075,0.053,0.082,0.080,0.110,0.081,0.092,0.115,0.023,
0.111,0.128,0.106,0.143,0.144,0.192,1.370,1.070,0.736,1.090,
1.170,1.200,0.714,0.816,0.889,0.125,0.475,0.628,0.705,0.713,
0.452,0.746,1.190,1.240,0.695,0.795,1.390,1.270,1.340,0.917,
1.140,0.219,0.976,0.925,0.571,1.000,0.604,0.759,0.854,1.370,
0.821,1.010,0.155,0.258,0.186,0.252,1.400,0.534,0.768,0.920,
0.565,1.620,0.676,0.859,0.732,0.541,0.386,0.727,0.891,0.946,
0.674,0.958,0.837,0.142,0.643,0.962,0.745,0.788,0.757,1.380,
0.112,0.143,0.061,0.088,0.218,0.388,0.156,0.130,0.098,0.039,
0.084,0.093,0.057,0.103,0.052,0.082,0.121,0.189,0.084,0.076,
0.244,0.311,0.303,0.158,0.165,0.111,0.217,0.172,0.062,0.154,
0.082,0.078,0.086,0.229,0.114,0.098,0.043,0.141,0.110,0.050,
0.184,0.173,0.232,0.202,0.064,0.241,0.140,0.116,0.083,0.074,
0.045,0.079,0.164,0.248,0.141,0.163,0.108,0.037,0.117,0.137,
0.068,0.094,0.086,0.135,0.876,0.927,0.453,0.480,1.230,1.640,
1.380,0.830,0.926,0.235,0.764,0.703,0.472,0.776,0.614,0.711,
0.092,0.202,0.091,0.070,0.156,0.312,0.493,0.116,0.145,0.104,
0.244,0.137,0.071,0.187,0.115,0.096,0.755,1.280,0.818,0.711,
0.163,0.284,0.296,0.172,0.983,0.256,0.438,0.661,0.405,1.000,
0.834,0.734,0.515,0.478,0.349,0.407,0.925,1.280,1.040,0.884,
0.912,0.181,0.859,0.863,0.497,0.743,0.766,0.900,0.747,0.541,
0.361,0.556,0.659,0.606,0.403,0.419,0.575,0.086,0.391,0.513,
0.548,0.536,0.351,0.667,0.994,1.150,0.619,0.631,1.260,1.620,
1.510,0.821,0.989,0.206,0.969,0.964,0.819,1.190,0.730,0.851,
0.890,1.530,0.779,0.873,0.151,0.289,0.171,0.148,1.160,0.237,
1.280,1.280,0.651,1.380,0.984,1.030,0.675,0.566,0.400,0.627,
0.801,0.982,0.661,0.754,0.980,0.137,1.000,1.140,0.811,1.060,
0.979,1.350,1.330,0.784,0.542,1.000,0.803,0.629,0.461,0.646,
0.681,0.085,0.298,0.514,0.779,0.689,0.388,1.030,0.888,0.662,
0.370,0.503,0.695,0.463,0.401,0.429,0.487,0.058,0.311,0.430,
0.407,0.458,0.300,0.491,0.719,0.763,0.419,0.681,0.077,0.082,
0.058,0.109,0.592,0.084,0.339,0.525,0.498,0.705,0.583,0.776,
0.858,0.504,0.388,0.740,0.711,0.552,0.433,0.723,0.566,0.057,
0.353,0.570,0.821,0.641,0.597,1.330,1.500,1.240,0.640,1.080,
1.510,1.620,0.933,0.978,0.875,0.149,0.563,0.748,0.688,0.935,
0.457,0.874,1.390,1.600,0.616,0.802,1.860,1.490,1.140,1.010,
1.050,0.212,0.815,1.030,0.624,1.060,0.617,0.766,0.904,1.510,
0.689,0.913,0.138,0.256,0.150,0.170,1.100,0.235,0.910,1.190,
0.729,1.590,0.903,1.140,0.820,0.658,0.481,0.779,1.170,1.270,
0.887,1.310,0.908,0.115,0.684,0.979,0.753,0.868,0.732,1.320,
1.020,0.971,0.481,0.681,1.160,1.120,0.899,0.872,0.964,0.201,
0.588,0.853,0.572,0.804,0.583,0.930,0.079,0.119,0.049,0.069,
0.113,0.171,0.147,0.097,0.088,0.042,0.104,0.120,0.057,0.123,
0.074,0.091,0.729,1.100,0.653,0.786,0.113,0.175,0.146,0.148,
0.999,0.208,0.703,0.916,0.528,1.110,0.851,0.919,0.655,0.547,
0.423,0.603,1.050,1.120,1.040,1.250,0.913,0.135,0.805,1.050,
0.680,0.801,0.902,1.230,1.060,0.615,0.420,0.768,0.689,0.533,
0.435,0.512,0.683,0.084,0.358,0.578,0.735,0.626,0.478,1.040,
0.864,0.800,0.403,0.589,0.792,0.787,0.662,0.636,0.702,0.086,
0.506,0.777,0.565,0.718,0.527,0.840,0.870,1.120,0.666,0.990,
0.091,0.127,0.079,0.120,1.130,0.149,0.960,1.370,0.816,1.290,
1.070,1.270,1.130,0.731,0.587,1.210,1.030,1.080,0.844,1.180,
1.210,0.116,1.020,1.570,1.400,1.330,1.350,1.880,2.160,1.280,
1.100,2.300,1.250,0.812,0.626,0.917,1.230,0.120,0.478,0.886,
1.800,1.390,0.692,1.530,1.280,0.819,0.559,0.790,0.800,0.510,
0.413,0.484,0.727,0.072,0.428,0.508,0.798,0.838,0.499,0.842,
0.979,0.780,0.549,0.907,0.081,0.070,0.051,0.108,0.614,0.060,
0.326,0.515,0.647,0.763,0.494,0.916,1.360,0.686,0.592,1.200,
0.907,0.632,0.496,0.832,0.778,0.068,0.540,0.678,1.180,0.781,
0.786,1.760,1.590,0.909,0.523,1.030,1.060,0.698,0.450,0.603,
0.732,0.084,0.292,0.509,0.781,0.747,0.358,0.789,0.942,0.759,
0.358,0.549,0.649,0.531,0.351,0.423,0.641,0.078,0.301,0.470,
0.579,0.645,0.340,0.545,0.669,0.671,0.412,0.651,0.061,0.074,
0.047,0.071,0.642,0.085,0.342,0.512,0.576,0.971,0.461,0.660,
0.668,0.482,0.305,0.627,0.617,0.534,0.321,0.519,0.559,0.049,
0.337,0.494,0.628,0.562,0.492,1.010,1.070,0.567,0.421,0.765,
0.812,0.542,0.460,0.687,0.862,0.113,0.300,0.518,0.892,0.754,
0.419,0.974,0.071,0.064,0.035,0.067,0.061,0.057,0.043,0.060,
0.068,0.015,0.035,0.054,0.106,0.142,0.053,0.107,0.497,0.507,
0.393,0.536,0.051,0.050,0.042,0.062,0.520,0.069,0.292,0.382,
0.452,0.597,0.387,0.537,0.521,0.356,0.304,0.581,0.587,0.499,
0.377,0.587,0.563,0.061,0.352,0.513,0.654,0.557,0.529,1.010,
1.420,0.607,0.477,1.140,0.669,0.398,0.363,0.580,0.960,0.096,
0.333,0.591,1.690,0.992,0.550,1.440,0.884,0.619,0.399,0.657,
0.587,0.443,0.367,0.492,0.702,0.072,0.349,0.537,1.020,1.110,
0.526,1.010,0.661,0.635,0.495,0.742,0.055,0.047,0.045,0.068,
0.592,0.054,0.378,0.562,0.682,0.787,0.599,0.938,1.120,0.666,
0.569,1.220,0.685,0.517,0.464,0.739,0.953,0.079,0.610,1.010,
1.600,1.290,1.290,2.700,2.000,1.280,0.962,1.610,1.300,1.020,
0.687,0.891,0.976,0.123,0.500,0.744,1.090,1.120,0.571,1.150,
1.480,1.140,0.884,0.964,1.230,1.020,0.806,0.782,0.934,0.152,
1.020,0.826,0.629,1.040,0.599,0.842,0.893,1.080,0.630,0.953,
0.102,0.136,0.087,0.140,0.700,0.105,0.531,0.803,0.598,0.896,
0.643,1.040,0.948,0.613,0.500,0.925,1.000,0.968,0.622,0.941,
0.704,0.084,0.489,0.706,0.899,0.715,0.733,1.430,1.530,1.230,
0.575,0.981,1.260,1.260,0.696,0.744,0.791,0.132,0.372,0.553,
0.681,0.875,0.438,0.772,1.340,1.540,0.589,0.760,1.360,1.200,
0.826,0.853,1.000,0.229,0.587,0.764,0.621,1.160,0.515,0.722,
0.805,1.190,0.647,0.856,0.117,0.217,0.143,0.139,0.955,0.187,
0.636,0.841,0.625,1.240,0.831,1.010,0.718,0.640,0.390,0.699,
0.940,1.210,0.605,0.806,0.742,0.086,0.473,0.711,0.706,0.759,
0.606,1.150,0.924,0.632,0.363,0.641,0.911,0.895,0.647,0.771,
0.921,0.190,0.412,0.521,0.664,0.940,0.440,0.847,0.065,0.102,
0.048,0.084,0.091,0.157,0.102,0.098,0.114,0.074,0.086,0.083,
0.079,0.256,0.072,0.095,0.647,0.879,0.618,0.691,0.085,0.130,
0.101,0.109,0.871,0.205,0.502,0.677,0.513,1.110,0.664,0.779,
0.634,0.498,0.397,0.662,0.885,1.120,0.773,0.914,0.842,0.099,
0.564,0.777,0.668,0.717,0.704,1.190,0.964,0.613,0.432,0.764,
0.614,0.498,0.384,0.507,0.790,0.095,0.344,0.497,1.040,0.948,
0.483,1.030,1.000,1.090,0.615,0.834,0.893,1.000,0.740,0.858,
1.090,0.229,0.624,0.805,1.180,3.000,0.777,1.230,0.648,0.811,
0.593,0.790,0.065,0.093,0.066,0.085,0.753,0.106,0.609,0.870,
0.625,1.100,0.767,1.030,0.860,0.627,0.505,0.819,0.759,0.809,
0.556,0.780,0.944,0.096,0.680,1.080,1.140,1.230,1.090,1.930,
1.270,0.879,0.546,1.040,0.771,0.707,0.394,0.601,0.710,0.077,
0.333,0.545,0.713,0.631,0.373,0.773,1.090,0.977,0.478,0.721,
0.964,0.830,0.579,0.588,0.811,0.118,0.566,0.671,0.563,0.838,
0.486,0.727,0.794,0.992,0.660,0.922,0.102,0.134,0.090,0.156,
0.774,0.125,0.566,0.723,0.528,0.975,0.584,0.880,0.758,0.540,
0.388,0.800,0.741,0.724,0.467,0.735,0.793,0.096,0.527,0.854,
0.847,0.758,0.743,1.520,0.076,0.079,0.040,0.072,0.079,0.125,
0.045,0.062,0.054,0.013,0.036,0.048,0.049,0.072,0.036,0.068,
0.072,0.098,0.037,0.048,0.111,0.185,0.078,0.071,0.078,0.032,
0.079,0.078,0.046,0.096,0.048,0.058,0.051,0.091,0.048,0.055,
0.013,0.033,0.021,0.014,0.084,0.034,0.103,0.084,0.048,0.118,
0.069,0.080,0.060,0.056,0.033,0.067,0.089,0.127,0.062,0.088,
0.072,0.018,0.063,0.086,0.068,0.077,0.062,0.120,0.779,0.654,
0.342,0.452,0.713,0.817,0.577,0.564,0.689,0.136,0.404,0.498,
0.465,0.654,0.488,0.729,0.061,0.094,0.038,0.044,0.068,0.108,
0.079,0.050,0.071,0.033,0.071,0.063,0.055,0.125,0.067,0.079,
0.581,1.020,0.529,0.565,0.084,0.145,0.104,0.087,0.866,0.161,
0.413,0.605,0.419,0.917,0.607,0.676,0.539,0.491,0.325,0.447,
0.715,0.900,0.635,0.674,0.890,0.121,0.645,0.779,0.592,0.729,
0.696,0.987,0.786,0.477,0.326,0.597,0.542,0.439,0.319,0.421,
0.587,0.070,0.343,0.493,0.605,0.563,0.385,0.776,0.888,0.826,
0.456,0.616,0.765,0.818,0.593,0.552,0.795,0.116,0.577,0.723,
0.688,1.080,0.670,0.897,1.030,1.050,0.726,0.803,0.132,0.133,
0.144,0.095,0.944,0.122,0.731,0.945,0.822,1.140,0.856,1.060,
0.799,0.589,0.488,0.737,0.730,0.747,0.627,0.696,1.050,0.102,
0.866,1.160,1.040,1.100,1.030,1.620,1.960,0.863,0.655,1.390,
0.878,0.559,0.410,0.764,0.810,0.080,0.331,0.674,1.060,0.788,
0.464,1.220,0.978,0.615,0.330,0.558,0.655,0.454,0.332,0.472,
0.554,0.054,0.308,0.497,0.477,0.504,0.301,0.621,0.770,0.736,
0.426,0.845,0.070,0.074,0.046,0.109,0.605,0.063,0.319,0.560,
0.581,0.674,0.437,0.840,1.000,0.563,0.451,1.040,0.670,0.505,
0.405,0.756,0.694,0.058,0.402,0.798,1.090,0.772,0.712,1.950,
1.310,0.815,0.507,0.994,0.851,0.719,0.422,0.646,0.621,0.069,
0.313,0.558,0.622,0.664,0.354,0.845,0.944,0.807,0.334,0.557,
0.811,0.836,0.393,0.548,0.672,0.087,0.425,0.616,0.492,0.689,
0.359,0.708,0.623,0.694,0.345,0.608,0.050,0.077,0.038,0.064,
0.684,0.081,0.459,0.651,0.567,0.840,0.494,0.839,0.713,0.503,
0.372,0.732,0.709,0.647,0.399,0.738,0.678,0.063,0.421,0.720,
0.767,0.900,0.596,1.440,1.110,0.928,0.508,0.739,0.862,0.718,
0.558,0.768,0.861,0.127,0.423,0.704,0.746,0.765,0.620,1.180,
0.076,0.148,0.037,0.059,0.059,0.077,0.051,0.061,0.057,0.017,
0.045,0.065,0.065,0.102,0.052,0.106,0.700,0.874,0.494,0.739,
0.064,0.084,0.059,0.086,0.846,0.111,0.511,0.770,0.586,0.903,
0.705,0.991,0.804,0.660,0.458,0.770,0.914,0.886,0.682,1.020,
1.080,0.106,0.709,1.090,0.902,0.869,0.889,1.560,1.750,0.828,
0.604,1.240,0.832,0.583,0.456,0.673,0.991,0.090,0.469,0.854,
1.320,0.956,0.747,1.890,1.220,1.000,0.487,0.803,0.964,0.927,
0.582,0.765,0.931,0.087,0.575,1.010,0.903,1.050,0.658,1.630,
1.130,1.130,0.832,1.230,0.083,0.089,0.086,0.111,1.280,0.110,
0.879,1.520,1.170,1.440,1.250,1.860,2.080,1.090,0.936,2.020,
1.350,1.150,0.953,1.700,1.770,0.121,1.310,2.350,2.230,1.700,
1.740,2.580,4.170,2.090,1.960,3.300,2.210,1.330,1.320,1.490,
2.550,0.230,1.240,1.700,3.040,2.210,1.450,2.420,2.520,1.520,
1.180,1.460,1.590,1.040,1.030,0.921,1.590,0.151,1.060,1.170,
1.250,1.280,1.030,1.300,2.100,1.220,1.180,1.490,0.161,0.127,
0.122,0.197,1.220,0.111,0.745,0.926,1.090,1.190,0.974,1.200,
2.500,1.150,1.230,2.360,1.790,1.270,1.180,1.690,1.370,0.116,
0.930,1.270,1.830,1.150,1.320,2.140,2.390,1.390,0.933,1.340,
1.450,0.999,0.804,0.881,1.130,0.133,0.793,0.934,0.987,1.050,
0.759,1.070,1.650,1.190,0.746,0.866,0.981,0.678,0.677,0.618,
1.090,0.142,0.777,0.929,0.707,0.856,0.784,0.825,1.050,0.982,
0.687,0.837,0.108,0.100,0.091,0.114,0.882,0.101,0.628,0.750,
0.576,0.883,0.650,0.705,0.995,0.683,0.517,0.841,1.000,0.785,
0.647,0.865,0.902,0.078,0.661,0.869,0.840,0.722,0.791,1.230,
2.020,0.785,1.000,1.040,1.380,0.782,0.809,0.832,1.160,0.148,
0.606,0.872,1.050,0.966,0.782,1.250,0.141,0.107,0.075,0.093,
0.107,0.093,0.078,0.076,0.102,0.023,0.082,0.099,0.123,0.182,
0.108,0.142,0.853,0.691,0.647,0.670,0.079,0.065,0.074,0.082,
0.759,0.089,0.582,0.616,0.579,0.701,0.809,0.682,0.744,0.472,
0.483,0.713,0.874,0.679,0.622,0.803,0.857,0.088,0.658,0.917,
0.741,0.727,0.826,1.230,2.390,0.838,0.799,1.420,0.930,0.550,
0.624,0.651,0.954,0.094,0.494,0.720,1.230,0.909,0.761,1.590,
1.490,0.943,0.727,0.901,0.941,0.680,0.641,0.635,0.899,0.081,
0.646,0.790,0.920,0.965,0.738,1.080,0.906,0.745,0.616,0.819,
0.071,0.058,0.062,0.079,0.683,0.059,0.528,0.676,0.637,0.735,
0.693,0.824,1.320,0.681,0.682,1.270,0.673,0.464,0.530,0.748,
1.080,0.083,0.768,1.190,1.420,1.090,1.230,2.210,3.210,2.030,
1.510,2.330,1.820,1.430,1.240,1.300,1.380,0.167,0.783,1.200,
1.520,1.440,1.020,1.650,2.280,1.870,1.200,1.360,1.600,1.320,
1.300,1.070,1.480,0.233,1.200,1.330,0.924,1.240,0.949,1.170,
1.160,1.190,1.090,1.140,0.131,0.167,0.145,0.173,0.807,0.100,
0.689,0.752,0.626,0.947,0.743,0.957,1.300,0.687,0.729,1.150,
1.370,1.120,0.900,1.110,0.845,0.091,0.614,0.857,0.919,0.763,
0.937,1.590,2.220,1.850,0.926,1.290,1.700,1.660,1.070,1.090,
1.100,0.167,0.697,0.882,0.811,1.070,0.647,0.965,1.580,1.570,
0.905,0.915,1.060,0.634,0.909,0.769,1.190,0.209,1.030,1.170,
0.626,1.010,0.845,0.878,1.080,1.600,1.130,1.220,0.142,0.250,
0.250,0.282,1.060,0.208,0.916,1.020,0.629,1.670,0.893,0.977,
0.854,0.697,0.556,0.761,1.080,1.130,0.889,1.010,0.777,0.097,
0.610,0.790,0.613,0.734,0.673,1.090,1.590,1.130,0.808,1.070,
1.400,1.360,1.360,1.030,1.190,0.199,0.854,1.130,0.791,1.050,
0.932,1.230,0.129,0.206,0.107,0.115,0.129,0.213,0.192,0.115,
0.136,0.062,0.187,0.166,0.092,0.234,0.153,0.153,1.090,1.330,
1.080,1.040,0.135,0.197,0.198,0.148,1.120,0.203,1.060,1.080,
0.680,1.510,1.430,1.130,0.816,0.584,0.743,0.749,1.090,1.210,
1.130,1.090,1.000,0.131,1.060,1.210,0.644,0.837,1.100,1.320,
1.370,0.812,0.628,0.986,0.799,0.622,0.577,0.637,0.673,0.071,
0.429,0.614,0.757,0.687,0.584,1.080,1.380,1.300,0.838,1.020,
1.040,1.090,0.944,0.958,0.867,0.113,0.851,1.030,0.755,1.140,
0.844,1.180,0.769,0.851,0.756,0.907,0.070,0.094,0.077,0.095,
0.663,0.078,0.647,0.777,0.601,0.871,0.896,0.990,0.952,0.580,
0.628,0.891,0.763,0.667,0.583,0.803,0.877,0.079,0.782,1.170,
1.060,1.100,1.380,1.920,2.100,1.330,0.991,1.490,0.930,0.798,
0.621,0.708,0.957,0.111,0.540,0.725,1.010,0.960,0.617,1.070,
1.850,1.640,0.992,1.160,1.190,1.110,0.962,0.844,1.450,0.197,
1.080,1.140,0.886,1.300,0.753,1.020,1.300,1.540,2.530,1.410,
0.146,0.202,0.212,0.236,0.884,0.124,0.764,0.813,0.574,1.040,
0.748,0.899,1.170,0.810,0.887,1.310,0.988,1.070,0.901,1.080,
0.958,0.105,0.759,1.010,0.988,0.874,1.010,1.910,0.164,0.159,
0.097,0.126,0.161,0.174,0.109,0.104,0.114,0.025,0.084,0.093,
0.091,0.147,0.091,0.117,0.176,0.219,0.114,0.114,0.167,0.199,
0.146,0.108,0.187,0.055,0.173,0.154,0.098,0.215,0.110,0.119,
0.113,0.200,0.185,0.134,0.022,0.051,0.052,0.034,0.164,0.043,
0.200,0.175,0.080,0.212,0.126,0.120,0.158,0.130,0.113,0.170,
0.227,0.311,0.228,0.265,0.145,0.029,0.145,0.177,0.138,0.179,
0.157,0.243,1.150,0.820,0.600,0.632,0.824,0.894,0.805,0.599,
1.110,0.302,0.894,0.825,0.632,1.050,0.757,0.868,0.110,0.155,
0.077,0.075,0.090,0.144,0.111,0.064,0.237,0.175,0.162,0.119,
0.098,0.302,0.119,0.106,0.717,1.110,0.822,0.641,0.101,0.192,
0.158,0.102,0.917,0.165,0.698,0.692,0.434,0.820,0.747,0.638,
0.589,0.496,0.504,0.548,0.808,1.030,0.880,0.908,0.846,0.148,
0.940,0.921,0.531,0.728,0.793,0.913,1.010,0.568,0.438,0.692,
0.611,0.452,0.366,0.380,0.656,0.076,0.398,0.532,0.628,0.603,
0.458,0.838,1.340,1.100,0.694,0.865,0.985,1.070,0.733,0.650,
1.470,0.234,0.889,1.050,0.887,1.340,0.793,1.020,0.778,0.897,
0.746,0.774,0.089,0.119,0.089,0.089,0.915,0.100,0.723,0.796,
0.581,0.952,0.733,0.888,1.000,0.660,0.637,0.813,0.946,0.757,
0.596,0.724,0.972,0.109,0.912,1.130,1.050,1.150,1.040,1.510,
2.270,1.080,0.892,1.630,0.846,0.566,0.536,0.620,0.883,0.084,
0.437,0.677,1.220,0.864,0.675,1.370,1.150,0.700,0.524,0.743,
0.661,0.443,0.454,0.499,0.848,0.080,0.444,0.621,0.717,0.630,
0.438,0.730,0.950,0.730,0.756,1.080,0.089,0.077,0.073,0.132,
0.593,0.056,0.380,0.560,0.535,0.640,0.463,0.787,1.340,0.665,
0.813,1.760,0.911,0.684,0.686,1.070,0.874,0.069,0.558,0.855,
1.170,0.828,0.934,2.160,1.660,1.040,0.714,1.110,1.070,0.819,
0.757,0.692,0.874,0.097,0.554,0.750,0.775,0.822,0.603,0.987,
1.270,0.996,0.565,0.775,0.875,0.751,0.590,0.586,0.989,0.141,
0.676,0.868,0.691,0.936,0.510,0.740,0.863,0.854,0.695,0.902,
0.074,0.094,0.099,0.110,0.811,0.090,0.637,0.827,0.606,0.927,
0.615,0.863,1.070,0.621,0.606,1.050,1.010,0.894,0.793,1.070,
0.842,0.081,0.626,0.919,0.878,0.921,0.818,1.440,1.240,0.701,
0.596,0.813,0.976,0.708,0.703,0.793,1.070,0.141,0.759,0.903,
0.800,0.791,0.875,1.190,0.095,0.093,0.061,0.090,0.074,0.083,
0.074,0.072,0.101,0.025,0.100,0.109,0.096,0.140,0.097,0.122,
0.761,0.807,0.627,0.873,0.072,0.080,0.082,0.108,0.849,0.105,
0.652,0.811,0.574,0.865,0.813,0.953,0.768,0.548,0.559,0.872,
0.927,0.819,0.838,1.190,1.180,0.115,0.902,1.340,0.875,0.898,
1.010,1.490,1.780,0.791,0.681,1.190,0.807,0.564,0.541,0.633,
0.889,0.083,0.506,0.795,1.140,0.821,0.787,1.690,1.010,0.689,
0.510,0.790,0.663,0.496,0.509,0.587,0.860,0.071,0.616,0.917,
0.883,0.862,0.663,1.130,1.110,0.984,0.829,1.380,0.102,0.082,
0.072,0.126,1.050,0.088,0.805,1.120,1.000,1.180,1.080,1.510,
1.960,0.974,1.040,2.080,1.350,1.050,0.978,1.480,1.770,0.115,
1.400,2.180,2.740,1.830,2.140,3.290,0.205,0.140,0.120,0.163,
0.148,0.113,0.100,0.101,0.125,0.019,0.108,0.124,0.128,0.124,
0.094,0.117,0.160,0.131,0.098,0.098,0.132,0.112,0.113,0.085,
0.109,0.025,0.105,0.103,0.081,0.107,0.100,0.102,0.092,0.084,
0.077,0.083,0.014,0.016,0.016,0.016,0.064,0.012,0.065,0.060,
0.054,0.075,0.082,0.075,0.113,0.071,0.067,0.108,0.119,0.107,
0.085,0.104,0.083,0.012,0.076,0.085,0.087,0.074,0.092,0.132,
0.183,0.152,0.107,0.126,0.167,0.155,0.124,0.092,0.127,0.035,
0.206,0.180,0.082,0.132,0.155,0.129,0.175,0.200,0.109,0.096,
0.153,0.157,0.144,0.105,0.181,0.074,0.177,0.185,0.078,0.163,
0.124,0.111,0.084,0.128,0.080,0.074,0.024,0.041,0.040,0.019,
0.123,0.043,0.114,0.105,0.056,0.132,0.093,0.076,0.071,0.077,
0.047,0.061,0.109,0.110,0.086,0.091,0.089,0.017,0.098,0.101,
0.068,0.078,0.092,0.120,0.117,0.072,0.059,0.065,0.178,0.095,
0.094,0.079,0.097,0.020,0.072,0.074,0.061,0.079,0.070,0.090,
0.014,0.021,0.016,0.011,0.021,0.029,0.029,0.015,0.018,0.014,
0.028,0.020,0.011,0.028,0.019,0.016,0.060,0.071,0.067,0.054,
0.013,0.017,0.022,0.013,0.074,0.024,0.092,0.075,0.041,0.082,
0.090,0.069,0.050,0.036,0.038,0.048,0.077,0.078,0.078,0.079,
0.074,0.016,0.085,0.086,0.054,0.069,0.090,0.101,0.129,0.061,
0.051,0.086,0.074,0.047,0.047,0.054,0.069,0.010,0.045,0.056,
0.075,0.067,0.056,0.107,0.117,0.104,0.080,0.091,0.103,0.108,
0.090,0.083,0.085,0.017,0.085,0.101,0.069,0.103,0.079,0.107,
0.064,0.065,0.063,0.072,9.20e-3,0.010,0.012,0.010,0.063,0.012,
0.060,0.075,0.046,0.075,0.090,0.082,0.083,0.052,0.053,0.088,
0.063,0.055,0.054,0.070,0.086,0.011,0.087,0.122,0.099,0.099,
0.119,0.189,0.169,0.140,0.100,0.125,0.146,0.157,0.122,0.106,
0.093,0.020,0.067,0.082,0.085,0.101,0.076,0.096,0.160,0.170,
0.111,0.095,0.172,0.190,0.194,0.124,0.127,0.051,0.160,0.142,
0.065,0.115,0.140,0.115,0.071,0.103,0.090,0.070,0.016,0.037,
0.032,0.019,0.061,0.020,0.077,0.062,0.047,0.076,0.073,0.070,
0.066,0.045,0.044,0.064,0.091,0.108,0.080,0.079,0.078,0.013,
0.061,0.067,0.060,0.056,0.071,0.098,0.174,0.217,0.100,0.101,
0.203,0.348,0.174,0.116,0.119,0.041,0.107,0.099,0.062,0.118,
0.074,0.093,0.187,0.294,0.145,0.108,0.188,0.174,0.214,0.157,
0.178,0.122,0.226,0.212,0.069,0.186,0.137,0.156,0.094,0.232,
0.127,0.105,0.036,0.130,0.086,0.044,0.129,0.079,0.147,0.135,
0.053,0.199,0.132,0.104,0.066,0.072,0.052,0.060,0.111,0.199,
0.112,0.105,0.082,0.024,0.099,0.100,0.052,0.081,0.086,0.109,
0.116,0.098,0.065,0.070,0.149,0.191,0.182,0.098,0.114,0.033,
0.101,0.102,0.057,0.098,0.088,0.095,0.022,0.048,0.028,0.018,
0.043,0.111,0.138,0.033,0.037,0.058,0.077,0.048,0.011,0.047,
0.036,0.023,0.144,0.195,0.152,0.115,0.050,0.094,0.098,0.037,
0.158,0.073,0.196,0.147,0.095,0.191,0.219,0.135,0.083,0.049,
0.057,0.056,0.119,0.175,0.182,0.122,0.120,0.034,0.160,0.131,
0.055,0.086,0.133,0.121,0.093,0.065,0.051,0.073,0.067,0.064,
0.055,0.054,0.058,8.49e-3,0.046,0.051,0.055,0.057,0.049,0.082,
0.122,0.137,0.088,0.086,0.120,0.176,0.149,0.111,0.096,0.031,
0.116,0.119,0.055,0.121,0.092,0.102,0.060,0.088,0.078,0.071,
9.07e-3,0.021,0.019,0.012,0.066,0.017,0.088,0.080,0.045,0.082,
0.103,0.084,0.064,0.045,0.047,0.060,0.061,0.070,0.060,0.068,
0.070,0.011,0.082,0.101,0.071,0.093,0.121,0.150,0.118,0.102,
0.074,0.097,0.077,0.080,0.065,0.066,0.072,0.013,0.054,0.055,
0.059,0.072,0.049,0.064,0.130,0.166,0.095,0.086,0.139,0.164,
0.149,0.107,0.147,0.052,0.179,0.143,0.062,0.147,0.082,0.084,
0.077,0.132,0.147,0.094,0.016,0.034,0.045,0.028,0.105,0.030,
0.127,0.104,0.040,0.096,0.085,0.073,0.060,0.052,0.049,0.075,
0.078,0.092,0.100,0.103,0.081,0.016,0.081,0.091,0.061,0.069,
0.081,0.126,0.013,0.021,0.014,0.011,0.024,0.042,0.034,0.018,
0.015,0.011,0.023,0.015,7.31e-3,0.020,0.017,0.012,0.023,0.058,
0.026,0.016,0.049,0.097,0.076,0.034,0.036,0.063,0.082,0.049,
0.012,0.049,0.026,0.019,0.013,0.047,0.042,0.018,0.013,0.053,
0.065,0.019,0.050,0.047,0.128,0.065,0.011,0.049,0.043,0.020,
8.98e-3,0.012,0.010,0.010,0.024,0.046,0.044,0.034,0.019,0.012,
0.037,0.028,0.011,0.018,0.020,0.021,0.092,0.099,0.066,0.055,
0.089,0.152,0.146,0.078,0.111,0.041,0.146,0.116,0.052,0.114,
0.105,0.094,0.016,0.046,0.023,0.013,0.029,0.074,0.067,0.024,
0.038,0.053,0.115,0.045,0.012,0.042,0.034,0.018,0.078,0.239,
0.148,0.081,0.029,0.149,0.099,0.030,0.139,0.084,0.192,0.134,
0.043,0.151,0.139,0.089,0.051,0.054,0.056,0.068,0.108,0.228,
0.176,0.193,0.123,0.049,0.195,0.149,0.052,0.096,0.123,0.113,
0.076,0.064,0.044,0.066,0.055,0.052,0.042,0.040,0.063,0.012,
0.049,0.061,0.051,0.063,0.046,0.078,0.114,0.142,0.086,0.087,
0.132,0.184,0.139,0.099,0.150,0.049,0.165,0.165,0.074,0.159,
0.116,0.106,0.070,0.121,0.094,0.079,0.017,0.035,0.033,0.015,
0.113,0.037,0.134,0.124,0.053,0.143,0.108,0.108,0.075,0.056,
0.051,0.069,0.189,0.092,0.074,0.087,0.101,0.019,0.130,0.127,
0.085,0.122,0.118,0.147,0.161,0.098,0.077,0.126,0.110,0.070,
0.072,0.112,0.101,0.011,0.049,0.086,0.101,0.082,0.070,0.122,
0.111,0.083,0.058,0.073,0.082,0.066,0.065,0.072,0.083,0.012,
0.063,0.079,0.067,0.070,0.058,0.078,0.076,0.072,0.067,0.090,
8.69e-3,9.29e-3,9.75e-3,0.016,0.061,8.23e-3,0.050,0.063,0.045,0.063,
0.053,0.078,0.102,0.060,0.070,0.136,0.084,0.066,0.068,0.131,
0.098,9.28e-3,0.061,0.117,0.109,0.080,0.095,0.230,0.186,0.150,
0.112,0.133,0.158,0.147,0.247,0.123,0.125,0.024,0.111,0.126,
0.095,0.130,0.101,0.130,0.190,0.197,0.108,0.121,0.184,0.202,
0.168,0.140,0.169,0.043,0.174,0.196,0.103,0.198,0.115,0.130,
0.101,0.158,0.128,0.124,0.016,0.033,0.041,0.030,0.143,0.029,
0.165,0.164,0.076,0.164,0.116,0.124,0.111,0.084,0.082,0.125,
0.142,0.156,0.167,0.226,0.121,0.019,0.130,0.163,0.112,0.132,
0.134,0.200,0.102,0.072,0.057,0.070,0.097,0.098,0.105,0.089,
0.108,0.022,0.101,0.106,0.066,0.087,0.098,0.115,0.011,0.015,
9.49e-3,0.011,0.016,0.028,0.023,0.015,0.016,9.31e-3,0.025,0.022,
0.011,0.021,0.019,0.016,0.069,0.110,0.091,0.086,0.013,0.025,
0.027,0.020,0.108,0.032,0.119,0.116,0.055,0.127,0.127,0.113,
0.074,0.056,0.061,0.081,0.098,0.109,0.122,0.151,0.187,0.026,
0.152,0.213,0.092,0.103,0.141,0.168,0.137,0.085,0.066,0.103,
0.079,0.065,0.063,0.071,0.080,0.011,0.057,0.082,0.087,0.075,
0.073,0.143,0.103,0.084,0.058,0.079,0.086,0.088,0.079,0.083,
0.084,0.012,0.081,0.107,0.078,0.096,0.080,0.122,0.093,0.102,
0.086,0.117,0.011,0.013,0.012,0.015,0.102,0.016,0.103,0.129,
0.083,0.132,0.124,0.150,0.138,0.081,0.088,0.159,0.132,0.108,
0.106,0.151,0.155,0.015,0.167,0.220,0.205,0.179,0.227,0.284,
1.780,1.160,1.000,1.620,1.180,0.878,0.838,0.996,1.010,0.109,
0.722,0.913,1.260,1.090,0.818,1.210,1.240,0.907,0.619,0.819,
0.961,0.684,0.760,0.717,0.779,0.086,0.610,0.665,0.665,0.733,
0.602,0.753,0.791,0.719,0.602,0.776,0.077,0.070,0.073,0.112,
0.608,0.064,0.561,0.636,0.458,0.580,0.583,0.688,0.857,0.449,
0.393,0.773,0.638,0.479,0.438,0.614,0.576,0.050,0.434,0.572,
0.674,0.382,0.591,1.040,1.650,1.150,0.712,1.050,1.210,1.020,
0.839,0.783,0.838,0.113,0.564,0.720,0.684,0.814,0.507,0.763,
1.430,1.370,0.722,0.796,1.100,0.759,0.923,0.724,1.180,0.185,
0.947,1.220,0.633,0.915,0.579,0.692,0.872,1.090,0.815,0.832,
0.115,0.138,0.135,0.146,1.120,0.181,1.050,1.590,0.643,1.040,
0.881,0.873,0.653,0.491,0.356,0.533,0.845,0.784,0.612,0.765,
0.645,0.070,0.539,0.824,0.588,0.542,0.617,1.010,1.170,0.646,
0.505,0.737,1.140,0.899,0.882,0.858,1.050,0.144,0.714,0.752,
0.731,0.821,0.663,0.965,0.128,0.136,0.087,0.105,0.156,0.155,
0.160,0.131,0.140,0.038,0.235,0.152,0.123,0.264,0.138,0.174,
0.723,0.758,0.993,0.899,0.103,0.100,0.319,0.220,0.890,0.149,
0.888,0.791,0.460,0.807,0.866,0.736,0.540,0.412,0.400,0.498,
0.866,0.762,1.100,0.964,0.690,0.092,0.703,0.774,0.612,0.592,
0.758,0.960,1.060,0.468,0.392,0.717,0.552,0.408,0.397,0.436,
0.547,0.062,0.335,0.451,0.697,0.602,0.510,0.878,0.916,0.724,
0.503,0.647,0.749,0.633,0.599,0.579,0.671,0.079,0.712,0.741,
0.639,0.883,0.601,0.918,0.709,0.710,0.689,0.737,0.075,0.070,
0.092,0.102,0.760,0.085,0.696,0.824,0.570,0.837,0.999,0.953,
0.794,0.490,0.457,0.793,0.562,0.447,0.558,0.692,0.845,0.089,
0.742,1.050,1.070,0.930,1.110,1.860,0.122,0.101,0.073,0.097,
0.102,0.101,0.090,0.095,0.070,0.013,0.049,0.059,0.072,0.081,
0.062,0.082,0.130,0.139,0.103,0.109,0.151,0.153,0.228,0.144,
0.103,0.034,0.116,0.103,0.086,0.107,0.093,0.089,0.059,0.081,
0.063,0.063,0.013,0.022,0.023,0.018,0.063,0.018,0.085,0.078,
0.039,0.074,0.074,0.073,0.058,0.040,0.035,0.052,0.072,0.071,
0.061,0.065,0.048,8.81e-3,0.046,0.058,0.052,0.045,0.062,0.099,
0.110,0.127,0.065,0.071,0.112,0.141,0.118,0.079,0.076,0.023,
0.060,0.061,0.045,0.073,0.048,0.056,0.150,0.236,0.103,0.084,
0.157,0.149,0.189,0.109,0.158,0.081,0.164,0.148,0.061,0.136,
0.087,0.082,0.074,0.146,0.087,0.073,0.025,0.062,0.053,0.026,
0.233,0.099,0.226,0.278,0.075,0.168,0.124,0.099,0.052,0.047,
0.034,0.041,0.076,0.099,0.075,0.069,0.061,0.014,0.065,0.081,
0.040,0.051,0.058,0.077,0.090,0.073,0.054,0.056,0.117,0.147,
0.154,0.089,0.098,0.028,0.153,0.087,0.051,0.082,0.079,0.077,
0.015,0.031,0.019,0.014,0.033,0.066,0.070,0.027,0.029,0.036,
0.165,0.039,0.011,0.037,0.033,0.019,0.077,0.120,0.121,0.094,
0.026,0.053,0.096,0.029,0.143,0.078,0.223,0.130,0.051,0.154,
0.176,0.109,0.051,0.045,0.044,0.048,0.095,0.126,0.150,0.103,
0.082,0.025,0.127,0.101,0.048,0.074,0.100,0.100,0.091,0.077,
0.056,0.083,0.062,0.059,0.052,0.056,0.055,8.60e-3,0.044,0.051,
0.063,0.067,0.071,0.098,0.121,0.128,0.088,0.096,0.137,0.165,
0.138,0.115,0.106,0.026,0.198,0.122,0.079,0.152,0.121,0.135,
0.064,0.088,0.087,0.078,9.78e-3,0.021,0.023,0.015,0.085,0.024,
0.110,0.107,0.065,0.115,0.222,0.123,0.068,0.052,0.048,0.067,
0.060,0.065,0.065,0.071,0.074,0.012,0.085,0.109,0.084,0.094,
0.134,0.172,1.160,1.040,0.718,1.130,0.797,0.761,0.516,0.632,
0.686,0.078,0.531,0.585,0.505,0.451,0.371,0.561,1.150,1.090,
0.603,0.700,1.160,0.989,0.988,0.739,1.150,0.170,1.340,1.140,
0.519,0.854,0.561,0.670,0.707,0.936,0.647,0.684,0.109,0.155,
0.130,0.155,0.791,0.132,0.990,0.850,0.408,0.798,0.647,0.695,
0.556,0.393,0.296,0.502,0.596,0.596,0.472,0.586,0.688,0.084,
0.649,0.870,0.540,0.490,0.620,1.040,0.096,0.103,0.056,0.073,
0.121,0.161,0.099,0.103,0.079,0.023,0.103,0.083,0.045,0.070,
0.049,0.062,0.106,0.142,0.073,0.065,0.178,0.185,0.169,0.111,
0.137,0.058,0.455,0.191,0.047,0.101,0.073,0.063,0.078,0.144,
0.088,0.072,0.023,0.056,0.054,0.026,0.133,0.060,0.234,0.169,
0.051,0.134,0.112,0.091,0.070,0.055,0.035,0.059,0.103,0.137,
0.097,0.110,0.083,0.020,0.103,0.163,0.056,0.064,0.071,0.116,
1.230,0.668,0.563,0.432,0.829,0.928,0.874,0.633,0.775,0.150,
0.981,0.693,0.403,0.585,0.727,0.642,0.097,0.143,0.106,0.068,
0.099,0.172,0.146,0.070,0.128,0.056,0.256,0.133,0.057,0.141,
0.152,0.087,0.750,0.706,0.697,0.520,0.112,0.114,0.171,0.091,
0.505,0.111,0.263,0.243,0.250,0.399,0.510,0.448,0.404,0.314,
0.334,0.281,0.533,0.594,0.659,0.486,0.586,0.100,0.845,0.667,
0.341,0.452,0.677,0.706,0.692,0.421,0.336,0.454,0.461,0.368,
0.293,0.300,0.420,0.052,0.393,0.409,0.330,0.334,0.327,0.464,
0.802,0.789,0.531,0.528,0.786,0.898,0.672,0.515,0.736,0.116,
0.938,0.812,0.445,0.784,0.706,0.601,0.618,0.726,0.599,0.613,
0.076,0.117,0.096,0.088,0.768,0.114,1.030,0.877,0.430,0.824,
0.795,0.749,0.508,0.369,0.322,0.459,0.556,0.543,0.460,0.497,
0.677,0.080,0.919,0.901,0.607,0.681,0.842,1.000,1.150,0.636,
0.453,0.856,0.593,0.439,0.350,0.487,0.545,0.058,0.328,0.473,
0.600,0.492,0.363,0.684,0.849,0.544,0.328,0.453,0.563,0.379,
0.378,0.390,0.515,0.046,0.354,0.432,0.346,0.365,0.282,0.421,
0.550,0.509,0.334,0.508,0.056,0.054,0.044,0.080,0.469,0.050,
0.395,0.547,0.367,0.470,0.406,0.581,0.637,0.368,0.284,0.542,
0.474,0.370,0.298,0.491,0.450,0.041,0.303,0.524,0.534,0.412,
0.466,0.949,1.180,0.869,0.525,0.791,0.926,0.831,0.673,0.675,
0.664,0.081,0.572,0.649,0.514,0.588,0.375,0.656,1.120,1.010,
0.554,0.665,1.060,0.911,0.923,0.768,0.934,0.121,1.140,0.983,
0.460,0.673,0.456,0.588,0.652,0.916,0.527,0.612,0.077,0.125,
0.091,0.105,0.809,0.126,0.863,1.080,0.452,0.893,0.689,0.809,
0.784,0.539,0.353,0.561,0.771,0.789,0.602,0.802,0.622,0.080,
0.585,0.975,0.528,0.565,0.555,0.960,1.070,0.669,0.478,0.594,
0.842,0.786,0.828,0.831,0.836,0.115,0.680,0.733,0.557,0.637,
0.712,0.882,0.091,0.095,0.069,0.069,0.093,0.134,0.139,0.103,
0.086,0.024,0.123,0.107,0.061,0.119,0.099,0.093,0.758,0.929,
0.706,0.708,0.090,0.107,0.141,0.117,1.210,0.211,0.922,1.040,
0.536,0.976,0.990,0.912,0.584,0.479,0.436,0.508,0.803,0.791,
0.895,0.883,0.795,0.099,0.928,1.110,0.565,0.637,0.907,1.080,
0.934,0.489,0.383,0.623,0.509,0.399,0.362,0.399,0.533,0.058,
0.367,0.466,0.592,0.444,0.449,0.764,0.800,0.592,0.435,0.542,
0.628,0.604,0.570,0.534,0.552,0.057,0.565,0.686,0.489,0.558,
0.561,0.689,0.756,0.789,0.602,0.790,0.069,0.077,0.070,0.091,
0.920,0.099,0.959,1.180,0.657,0.913,0.973,1.060,0.907,0.535,
0.503,0.879,0.770,0.689,0.684,0.836,0.905,0.079,0.998,1.320,
1.050,0.869,1.190,1.500,1.840,0.971,0.898,1.720,0.910,0.581,
0.518,0.695,0.834,0.075,0.399,0.668,1.190,0.916,0.589,1.130,
1.000,0.580,0.445,0.601,0.608,0.372,0.381,0.405,0.577,0.048,
0.372,0.435,0.564,0.578,0.385,0.585,0.676,0.519,0.443,0.673,
0.064,0.048,0.045,0.084,0.422,0.035,0.295,0.397,0.388,0.434,
0.408,0.611,0.952,0.464,0.532,0.920,0.689,0.443,0.401,0.621,
0.550,0.045,0.361,0.571,0.788,0.502,0.602,1.430,1.300,0.718,
0.501,0.829,0.719,0.477,0.362,0.450,0.507,0.049,0.282,0.438,
0.523,0.467,0.310,0.601,0.774,0.512,0.321,0.441,0.485,0.299,
0.284,0.301,0.485,0.043,0.294,0.429,0.408,0.383,0.273,0.424,
0.504,0.421,0.339,0.437,0.039,0.039,0.030,0.044,0.454,0.040,
0.265,0.434,0.381,0.428,0.343,0.451,0.474,0.301,0.228,0.410,
0.424,0.349,0.242,0.369,0.383,0.029,0.258,0.441,0.423,0.337,
0.371,0.733,1.090,0.477,0.394,0.596,0.757,0.473,0.418,0.547,
0.635,0.071,0.265,0.452,0.639,0.526,0.389,0.770,0.079,0.054,
0.038,0.057,0.063,0.049,0.043,0.051,0.059,9.67e-3,0.043,0.056,
0.083,0.103,0.055,0.092,0.528,0.405,0.426,0.522,0.048,0.038,
0.046,0.060,0.469,0.053,0.304,0.412,0.401,0.479,0.477,0.556,
0.531,0.330,0.324,0.512,0.562,0.430,0.410,0.555,0.583,0.093,
0.376,0.593,0.552,0.524,0.555,0.922,1.300,0.478,0.412,0.874,
0.555,0.332,0.330,0.470,0.581,0.051,0.291,0.467,0.904,0.564,
0.443,0.975,0.824,0.503,0.365,0.543,0.495,0.356,0.330,0.388,
0.514,0.042,0.339,0.497,0.625,0.651,0.411,0.738,0.557,0.441,
0.405,0.573,0.042,0.035,0.039,0.053,0.438,0.034,0.315,0.437,
0.484,0.495,0.535,0.666,0.873,0.457,0.451,0.943,0.530,0.370,
0.389,0.606,0.704,0.058,0.500,0.831,1.020,0.788,0.955,1.880,
1.830,1.100,0.853,1.450,1.090,0.835,0.709,0.846,0.786,0.086,
0.438,0.723,0.957,0.866,0.611,1.130,1.310,0.895,0.699,0.893,
0.943,0.705,0.987,0.809,0.813,0.097,0.694,0.790,0.623,0.699,
0.587,0.792,0.713,0.631,0.528,0.711,0.066,0.073,0.066,0.095,
0.552,0.065,0.460,0.624,0.404,0.577,0.560,0.810,0.786,0.430,
0.422,0.677,0.757,0.598,0.490,0.662,0.492,0.047,0.363,0.591,
0.624,0.500,0.607,1.210,1.400,1.010,0.594,0.900,1.040,0.913,
0.639,0.706,0.672,0.086,0.395,0.560,0.620,0.649,0.412,0.729,
1.150,1.010,0.586,0.743,1.010,0.654,0.688,0.628,0.941,0.159,
0.649,0.820,0.576,0.778,0.514,0.645,0.653,0.758,0.527,0.649,
0.073,0.097,0.069,0.078,0.863,0.134,0.633,0.914,0.496,0.858,
0.639,0.860,0.511,0.387,0.299,0.469,0.608,0.599,0.403,0.531,
0.479,0.052,0.386,0.686,0.451,0.451,0.482,0.840,0.981,0.596,
0.448,0.643,0.927,0.813,0.771,0.749,0.745,0.114,0.531,0.703,
0.579,0.629,0.539,0.888,0.068,0.082,0.048,0.069,0.087,0.118,
0.103,0.083,0.073,0.028,0.150,0.094,0.064,0.125,0.080,0.095,
0.642,0.705,0.629,0.722,0.074,0.097,0.100,0.099,0.742,0.136,
0.638,0.798,0.490,0.906,0.903,0.951,0.555,0.389,0.388,0.618,
0.757,0.765,0.778,0.873,0.680,0.085,0.649,0.893,0.563,0.620,
0.839,1.220,1.040,0.593,0.486,0.904,0.569,0.443,0.423,0.578,
0.587,0.057,0.369,0.552,0.667,0.557,0.527,0.979,1.000,0.801,
0.564,0.776,0.748,0.745,0.665,0.733,0.705,0.086,0.722,0.878,
0.673,0.953,0.724,1.000,0.573,0.597,0.586,0.717,0.051,0.062,
0.066,0.072,0.555,0.063,0.561,0.731,0.495,0.712,1.050,1.020,
0.709,0.461,0.452,0.709,0.612,0.541,0.479,0.667,0.640,0.058,
0.598,0.959,0.827,0.753,1.020,1.640,1.650,0.869,0.718,1.040,
0.699,0.586,0.429,0.571,0.696,0.065,0.416,0.546,0.750,0.530,
0.386,0.694,1.120,0.872,0.478,0.653,0.850,0.657,0.552,0.539,
0.839,0.097,0.852,0.776,0.597,0.731,0.529,0.746,0.680,0.809,
0.537,0.689,0.079,0.100,0.079,0.111,0.630,0.087,0.502,0.621,
0.458,0.816,0.665,0.758,0.659,0.450,0.350,0.630,0.639,0.576,
0.434,0.609,0.654,0.069,0.514,0.856,0.699,0.574,0.752,1.360,
0.097,0.075,0.107,0.078,0.075,0.079,0.057,0.060,0.054,9.71e-3,
0.063,0.056,0.051,0.061,0.047,0.066,0.083,0.092,0.047,0.051,
0.132,0.110,0.080,0.069,0.085,0.025,0.149,0.099,0.052,0.088,
0.065,0.066,0.046,0.074,0.049,0.050,0.010,0.020,0.018,0.011,
0.074,0.021,0.086,0.087,0.045,0.109,0.116,0.085,0.059,0.047,
0.034,0.058,0.088,0.094,0.068,0.082,0.062,0.012,0.063,0.103,
0.059,0.061,0.073,0.111,1.020,0.638,0.481,0.494,0.802,0.781,
0.889,0.601,0.662,0.123,0.664,0.612,0.488,0.628,0.696,0.752,
0.074,0.087,0.051,0.048,0.079,0.092,0.079,0.050,0.075,0.026,
0.158,0.081,0.062,0.116,0.134,0.082,0.752,0.840,0.754,0.636,
0.093,0.119,0.124,0.088,0.852,0.141,0.478,0.671,0.435,0.792,
0.814,0.738,0.544,0.440,0.395,0.457,0.712,0.769,0.745,0.649,
0.709,0.103,0.869,0.908,0.518,0.627,0.818,1.010,0.914,0.535,
0.374,0.593,0.532,0.424,0.368,0.393,0.577,0.063,0.442,0.566,
0.523,0.477,0.421,0.735,0.957,0.806,0.505,0.651,0.743,0.755,
0.564,0.518,0.770,0.090,0.896,0.899,0.649,0.930,0.796,0.852,
0.693,0.747,0.572,0.694,0.061,0.083,0.068,0.073,0.805,0.088,
0.764,0.918,0.605,1.010,1.140,1.050,0.773,0.485,0.449,0.620,
0.607,0.586,0.535,0.592,0.850,0.079,0.928,1.140,0.867,0.868,
1.070,1.460,1.800,0.787,0.556,1.110,0.653,0.428,0.335,0.520,
0.651,0.062,0.340,0.543,0.826,0.586,0.422,0.950,0.885,0.506,
0.285,0.468,0.527,0.333,0.277,0.362,0.546,0.044,0.327,0.456,
0.433,0.391,0.308,0.512,0.670,0.558,0.368,0.698,0.065,0.059,
0.040,0.096,0.460,0.044,0.293,0.497,0.455,0.514,0.402,0.640,
0.848,0.415,0.370,0.789,0.538,0.361,0.315,0.568,0.537,0.040,
0.346,0.659,0.757,0.511,0.638,1.520,1.100,0.652,0.534,0.738,
0.649,0.511,0.404,0.480,0.497,0.049,0.353,0.492,0.513,0.474,
0.344,0.684,0.827,0.592,0.339,0.490,0.674,0.502,0.397,0.441,
0.609,0.060,0.494,0.609,0.433,0.496,0.344,0.551,0.521,0.518,
0.330,0.511,0.040,0.049,0.035,0.051,0.527,0.055,0.422,0.622,
0.442,0.623,0.522,0.754,0.606,0.393,0.316,0.562,0.541,0.445,
0.351,0.541,0.534,0.047,0.390,0.701,0.569,0.469,0.539,1.040,
1.180,0.647,0.484,0.680,0.849,0.663,0.591,0.758,0.828,0.098,
0.495,0.696,0.730,0.688,0.652,1.100,0.077,0.067,0.041,0.060,
0.067,0.073,0.054,0.061,0.060,0.010,0.061,0.067,0.071,0.091,
0.067,0.096,0.811,0.846,0.608,0.771,0.064,0.074,0.069,0.089,
0.948,0.112,0.687,0.939,0.648,0.948,0.937,1.180,0.795,0.608,
0.485,0.724,0.829,0.729,0.733,0.938,0.934,0.085,0.810,1.230,
0.759,0.735,0.890,1.470,1.720,0.711,0.507,0.979,0.682,0.480,
0.408,0.552,0.783,0.068,0.436,0.694,1.060,0.725,0.661,1.470,
1.090,0.718,0.471,0.710,0.786,0.743,0.487,0.582,0.790,0.061,
0.621,0.860,0.816,0.787,0.660,1.080,0.990,0.869,0.637,1.000,
0.066,0.066,0.048,0.084,1.000,0.078,0.796,1.200,0.933,1.110,
1.140,1.610,1.610,0.755,0.672,1.420,0.976,0.755,0.682,1.050,
1.250,0.079,1.070,1.740,1.690,1.110,1.420,2.300,3.720,1.910,
1.570,3.740,1.650,0.971,0.878,1.350,1.900,0.157,0.782,1.410,
3.340,2.150,1.190,2.620,1.760,0.880,0.680,1.030,0.944,0.529,
0.459,0.559,0.958,0.060,0.465,0.681,0.980,0.737,0.560,0.997,
1.370,0.799,0.703,1.280,0.098,0.068,0.055,0.137,0.695,0.052,
0.354,0.577,0.800,0.734,0.552,0.959,2.690,0.947,0.989,2.350,
1.540,0.894,0.809,1.520,1.040,0.071,0.542,0.969,1.760,0.975,
0.942,2.110,1.830,0.791,0.567,1.020,0.815,0.492,0.390,0.536,
0.741,0.062,0.319,0.521,0.765,0.622,0.381,0.770,0.992,0.523,
0.336,0.510,0.488,0.274,0.252,0.294,0.516,0.034,0.251,0.379,
0.442,0.347,0.273,0.437,0.763,0.521,0.381,0.601,0.049,0.037,
0.028,0.050,0.572,0.045,0.252,0.394,0.408,0.405,0.289,0.476,
0.898,0.475,0.370,0.697,0.731,0.492,0.368,0.569,0.560,0.036,
0.277,0.480,0.616,0.451,0.415,0.886,1.260,0.566,0.490,0.844,
0.753,0.411,0.414,0.552,0.749,0.073,0.307,0.536,0.866,0.605,
0.506,1.080,0.087,0.058,0.037,0.067,0.052,0.042,0.034,0.045,
0.055,5.88e-3,0.030,0.049,0.090,0.086,0.053,0.102,0.559,0.382,
0.360,0.486,0.042,0.026,0.026,0.046,0.412,0.033,0.224,0.316,
0.376,0.356,0.347,0.465,0.615,0.352,0.342,0.592,0.623,0.412,
0.366,0.532,0.599,0.047,0.329,0.548,0.611,0.504,0.530,1.030,
2.120,0.732,0.685,1.710,0.761,0.411,0.478,0.639,1.010,0.077,
0.385,0.674,1.440,0.807,0.664,1.660,1.120,0.642,0.478,0.780,
0.603,0.396,0.364,0.466,0.638,0.040,0.358,0.572,0.798,0.623,
0.485,0.909,0.735,0.518,0.464,0.723,0.051,0.035,0.035,0.060,
0.546,0.035,0.357,0.532,0.573,0.536,0.485,0.756,1.350,0.620,
0.629,1.360,0.688,0.466,0.451,0.750,0.960,0.055,0.542,0.989,
1.540,1.040,1.060,2.580,1.960,0.948,0.715,1.400,0.848,0.531,
0.438,0.603,0.695,0.057,0.287,0.566,0.954,0.705,0.459,0.982,
1.010,0.573,0.401,0.610,0.532,0.342,0.313,0.356,0.455,0.040,
0.265,0.394,0.413,0.401,0.293,0.514,0.585,0.426,0.354,0.553,
0.047,0.040,0.030,0.056,0.337,0.029,0.186,0.276,0.347,0.370,
0.267,0.458,0.740,0.405,0.375,0.727,0.588,0.401,0.325,0.499,
0.392,0.030,0.221,0.380,0.575,0.385,0.430,0.929,1.070,0.638,
0.328,0.633,0.558,0.413,0.271,0.355,0.404,0.036,0.187,0.335,
0.432,0.395,0.224,0.503,0.593,0.419,0.221,0.328,0.349,0.179,
0.191,0.225,0.312,0.027,0.186,0.277,0.263,0.274,0.183,0.315,
0.494,0.405,0.267,0.395,0.034,0.033,0.022,0.035,0.314,0.034,
0.164,0.264,0.268,0.367,0.215,0.363,0.476,0.305,0.226,0.425,
0.388,0.312,0.223,0.325,0.326,0.024,0.169,0.317,0.337,0.303,
0.244,0.552,0.780,0.460,0.314,0.543,0.502,0.334,0.332,0.388,
0.496,0.050,0.235,0.381,0.489,0.390,0.321,0.623,0.045,0.052,
0.023,0.041,0.030,0.034,0.026,0.030,0.031,6.63e-3,0.024,0.034,
0.039,0.047,0.029,0.047,0.458,0.379,0.310,0.415,0.030,0.036,
0.022,0.034,0.293,0.027,0.183,0.258,0.272,0.317,0.293,0.363,
0.425,0.286,0.276,0.449,0.400,0.376,0.285,0.402,0.383,0.029,
0.276,0.419,0.359,0.311,0.374,0.646,0.781,0.411,0.320,0.590,
0.409,0.257,0.242,0.327,0.396,0.030,0.184,0.324,0.542,0.338,
0.294,0.681,0.550,0.430,0.275,0.436,0.327,0.292,0.241,0.324,
0.281,0.024,0.221,0.341,0.329,0.329,0.263,0.466,0.416,0.301,
0.305,0.443,0.025,0.022,0.018,0.032,0.294,0.023,0.200,0.288,
0.317,0.316,0.303,0.455,0.554,0.275,0.313,0.555,0.370,0.284,
0.241,0.402,0.467,0.032,0.292,0.550,0.644,0.548,0.566,1.110,
1.460,0.759,0.517,1.100,0.526,0.370,0.276,0.441,0.579,0.054,
0.270,0.472,0.756,0.621,0.344,0.770,0.943,0.583,0.361,0.643,
0.464,0.321,0.352,0.381,0.540,0.050,0.310,0.415,0.555,0.583,
0.334,0.582,0.644,0.556,0.556,0.756,0.057,0.053,0.044,0.094,
0.347,0.033,0.194,0.284,0.343,0.444,0.288,0.478,0.883,0.474,
0.514,1.060,0.579,0.434,0.382,0.682,0.489,0.042,0.281,0.507,
0.742,0.534,0.571,1.440,0.092,0.063,0.035,0.070,0.051,0.044,
0.027,0.039,0.047,6.77e-3,0.023,0.038,0.056,0.061,0.033,0.066,
0.072,0.053,0.027,0.044,0.046,0.038,0.027,0.032,0.046,6.29e-3,
0.029,0.038,0.050,0.055,0.030,0.052,0.050,0.051,0.036,0.055,
4.51e-3,6.19e-3,5.07e-3,6.24e-3,0.037,5.24e-3,0.025,0.032,0.036,0.048,
0.029,0.048,0.098,0.061,0.050,0.111,0.084,0.079,0.056,0.096,
0.052,5.71e-3,0.033,0.062,0.078,0.071,0.057,0.132,0.695,0.384,
0.268,0.389,0.385,0.305,0.266,0.304,0.515,0.063,0.279,0.374,
0.463,0.422,0.310,0.541,0.049,0.042,0.021,0.033,0.029,0.030,
0.023,0.023,0.040,7.70e-3,0.027,0.031,0.050,0.057,0.031,0.047,
0.391,0.393,0.280,0.334,0.036,0.034,0.029,0.033,0.322,0.035,
0.165,0.228,0.241,0.307,0.245,0.324,0.417,0.293,0.268,0.382,
0.401,0.362,0.283,0.380,0.426,0.040,0.312,0.415,0.375,0.343,
0.367,0.605,0.728,0.355,0.258,0.497,0.370,0.241,0.208,0.257,
0.448,0.044,0.213,0.376,0.585,0.453,0.283,0.668,0.693,0.475,
0.278,0.463,0.400,0.345,0.243,0.283,0.425,0.037,0.273,0.403,
0.522,0.497,0.312,0.544,0.480,0.435,0.282,0.454,0.038,0.049,
0.024,0.037,0.380,0.032,0.234,0.346,0.359,0.435,0.335,0.522,
0.667,0.389,0.357,0.583,0.455,0.377,0.280,0.426,0.570,0.045,
0.401,0.630,0.749,0.613,0.603,1.190,2.080,0.907,0.725,1.600,
0.668,0.404,0.361,0.499,0.710,0.054,0.325,0.565,1.220,0.703,
0.547,1.310,0.830,0.402,0.312,0.589,0.407,0.222,0.242,0.312,
0.507,0.031,0.246,0.390,0.523,0.360,0.310,0.589,0.767,0.487,
0.519,0.948,0.055,0.039,0.037,0.092,0.438,0.031,0.248,0.407,
0.474,0.412,0.324,0.673,1.430,0.604,0.770,2.200,0.739,0.433,
0.485,0.946,0.652,0.042,0.393,0.672,1.130,0.656,0.757,2.030,
1.140,0.584,0.394,0.784,0.546,0.370,0.271,0.384,0.519,0.040,
0.251,0.437,0.563,0.464,0.318,0.668,0.692,0.398,0.227,0.395,
0.390,0.264,0.199,0.264,0.399,0.030,0.231,0.357,0.406,0.330,
0.223,0.416,0.564,0.428,0.305,0.580,0.033,0.031,0.023,0.046,
0.418,0.029,0.216,0.364,0.405,0.396,0.264,0.519,0.818,0.416,
0.404,0.917,0.601,0.433,0.389,0.729,0.504,0.035,0.292,0.529,
0.656,0.564,0.478,1.030,0.806,0.408,0.316,0.554,0.518,0.319,
0.295,0.437,0.564,0.056,0.307,0.474,0.537,0.422,0.414,0.763,
0.049,0.038,0.023,0.045,0.030,0.027,0.023,0.029,0.038,4.16e-3,
0.027,0.039,0.047,0.046,0.033,0.056,0.454,0.376,0.297,0.476,
0.029,0.023,0.023,0.041,0.389,0.032,0.257,0.360,0.342,0.364,
0.332,0.520,0.540,0.325,0.339,0.599,0.532,0.376,0.360,0.591,
0.621,0.040,0.397,0.627,0.564,0.447,0.559,0.967,1.430,0.614,
0.519,1.090,0.591,0.356,0.345,0.482,0.713,0.058,0.342,0.624,
1.050,0.653,0.595,1.590,0.773,0.513,0.321,0.596,0.418,0.295,
0.273,0.365,0.478,0.032,0.307,0.516,0.589,0.512,0.383,0.766,
0.780,0.612,0.486,0.874,0.048,0.041,0.029,0.063,0.695,0.044,
0.383,0.631,0.715,0.686,0.573,0.969,1.550,0.699,0.750,1.680,
0.928,0.684,0.612,1.050,1.240,0.063,0.799,1.460,2.170,1.350,
1.470,2.820,1.830,1.060,0.958,1.590,1.060,0.638,0.552,0.710,
0.889,0.091,0.511,0.766,1.320,1.010,0.660,1.160,1.100,0.677,
0.507,0.676,0.714,0.448,0.402,0.435,0.571,0.052,0.413,0.492,
0.516,0.505,0.423,0.614,0.672,0.498,0.410,0.615,0.062,0.047,
0.042,0.076,0.426,0.048,0.279,0.353,0.426,0.451,0.389,0.547,
0.977,0.499,0.418,0.878,0.882,0.530,0.415,0.672,0.525,0.044,
0.345,0.522,0.752,0.498,0.560,1.090,1.280,0.742,0.529,0.754,
0.734,0.506,0.377,0.448,0.618,0.084,0.445,0.557,0.555,0.606,
0.400,0.668,0.846,0.549,0.369,0.484,0.515,0.363,0.329,0.359,
0.551,0.059,0.422,0.532,0.352,0.397,0.331,0.443,0.518,0.486,
0.320,0.409,0.057,0.052,0.039,0.047,0.791,0.121,0.331,0.401,
0.381,0.527,0.348,0.401,0.484,0.350,0.224,0.384,0.539,0.395,
0.274,0.409,0.460,0.043,0.279,0.399,0.411,0.375,0.380,0.666,
0.800,0.398,0.314,0.479,0.632,0.369,0.359,0.420,0.505,0.063,
0.269,0.371,0.455,0.424,0.347,0.675,0.056,0.046,0.030,0.047,
0.048,0.050,0.037,0.043,0.043,9.32e-3,0.033,0.044,0.043,0.066,
0.044,0.066,0.369,0.306,0.281,0.317,0.037,0.030,0.031,0.041,
0.345,0.039,0.227,0.284,0.262,0.322,0.337,0.401,0.363,0.234,
0.222,0.359,0.437,0.341,0.301,0.400,0.426,0.041,0.298,0.416,
0.389,0.385,0.461,0.706,0.908,0.384,0.311,0.601,0.422,0.252,
0.227,0.317,0.460,0.049,0.220,0.345,0.549,0.396,0.299,0.712,
0.666,0.446,0.323,0.505,0.458,0.386,0.292,0.399,0.381,0.039,
0.282,0.428,0.373,0.425,0.330,0.554,0.378,0.311,0.268,0.409,
0.032,0.025,0.026,0.041,0.315,0.034,0.210,0.316,0.284,0.342,
0.324,0.463,0.572,0.315,0.298,0.598,0.379,0.294,0.257,0.398,
0.484,0.038,0.354,0.575,0.668,0.550,0.621,1.230,1.270,0.765,
0.564,0.913,0.764,0.576,0.417,0.482,0.519,0.052,0.251,0.401,
0.654,0.538,0.367,0.660,0.870,0.615,0.387,0.505,0.612,0.479,
0.398,0.404,0.421,0.053,0.322,0.411,0.317,0.418,0.306,0.436,
0.395,0.368,0.301,0.384,0.038,0.044,0.034,0.049,0.252,0.028,
0.183,0.230,0.248,0.287,0.248,0.373,0.459,0.271,0.230,0.476,
0.447,0.419,0.266,0.377,0.302,0.027,0.202,0.292,0.413,0.297,
0.332,0.650,0.879,0.678,0.335,0.519,0.632,0.664,0.345,0.378,
0.384,0.049,0.235,0.343,0.338,0.395,0.228,0.486,0.704,0.621,
0.326,0.398,0.499,0.278,0.317,0.359,0.387,0.062,0.294,0.391,
0.259,0.404,0.246,0.352,0.434,0.463,0.272,0.346,0.054,0.063,
0.038,0.048,0.345,0.053,0.232,0.317,0.224,0.419,0.290,0.365,
0.377,0.283,0.186,0.312,0.405,0.444,0.249,0.321,0.309,0.030,
0.207,0.298,0.267,0.292,0.251,0.476,0.637,0.378,0.250,0.385,
0.550,0.451,0.364,0.363,0.459,0.075,0.238,0.307,0.356,0.378,
0.294,0.494,0.063,0.056,0.027,0.045,0.049,0.071,0.047,0.039,
0.050,0.026,0.041,0.041,0.030,0.074,0.035,0.042,0.453,0.415,
0.313,0.359,0.049,0.053,0.043,0.046,0.342,0.046,0.250,0.296,
0.244,0.375,0.385,0.390,0.349,0.224,0.222,0.341,0.426,0.429,
0.358,0.396,0.389,0.040,0.307,0.396,0.326,0.325,0.429,0.592,
0.533,0.299,0.220,0.366,0.341,0.237,0.187,0.240,0.300,0.029,
0.165,0.233,0.343,0.258,0.226,0.436,0.518,0.395,0.260,0.372,
0.376,0.406,0.306,0.389,0.293,0.049,0.244,0.324,0.238,0.342,
0.264,0.370,0.289,0.294,0.235,0.302,0.022,0.025,0.020,0.029,
0.229,0.022,0.196,0.247,0.215,0.281,0.343,0.383,0.393,0.222,
0.216,0.364,0.299,0.269,0.218,0.312,0.315,0.026,0.252,0.400,
0.409,0.413,0.448,0.747,0.785,0.545,0.369,0.684,0.397,0.313,
0.219,0.309,0.360,0.037,0.202,0.295,0.422,0.381,0.249,0.450,
0.633,0.498,0.275,0.408,0.408,0.376,0.282,0.310,0.421,0.053,
0.371,0.380,0.316,0.467,0.257,0.392,0.358,0.415,0.343,0.456,
0.039,0.047,0.052,0.077,0.265,0.035,0.205,0.247,0.198,0.322,
0.320,0.333,0.418,0.274,0.237,0.505,0.344,0.303,0.288,0.445,
0.313,0.031,0.235,0.363,0.396,0.335,0.400,0.870,0.039,0.037,
0.020,0.035,0.038,0.041,0.025,0.027,0.026,5.39e-3,0.020,0.026,
0.028,0.036,0.021,0.036,0.043,0.044,0.021,0.027,0.047,0.059,
0.034,0.033,0.039,0.011,0.040,0.037,0.028,0.046,0.024,0.034,
0.024,0.037,0.032,0.030,5.50e-3,0.011,0.015,8.40e-3,0.034,9.55e-3,
0.045,0.039,0.021,0.040,0.034,0.034,0.037,0.029,0.021,0.044,
0.047,0.056,0.050,0.069,0.031,5.44e-3,0.030,0.042,0.032,0.035,
0.035,0.066,0.505,0.371,0.237,0.301,0.354,0.389,0.284,0.285,
0.388,0.060,0.265,0.340,0.288,0.358,0.278,0.445,0.036,0.043,
0.022,0.028,0.029,0.047,0.035,0.026,0.034,9.25e-3,0.040,0.038,
0.030,0.053,0.033,0.041,0.321,0.442,0.277,0.287,0.034,0.069,
0.051,0.040,0.313,0.049,0.198,0.252,0.184,0.334,0.285,0.322,
0.295,0.236,0.203,0.277,0.355,0.446,0.322,0.384,0.412,0.051,
0.341,0.425,0.297,0.326,0.388,0.571,0.477,0.313,0.194,0.361,
0.271,0.220,0.146,0.193,0.303,0.033,0.170,0.282,0.360,0.318,
0.199,0.478,0.508,0.426,0.242,0.361,0.376,0.427,0.270,0.300,
0.363,0.045,0.324,0.463,0.336,0.468,0.291,0.462,0.357,0.378,
0.258,0.350,0.029,0.036,0.026,0.034,0.312,0.036,0.244,0.323,
0.274,0.414,0.304,0.432,0.403,0.278,0.226,0.429,0.364,0.294,
0.229,0.335,0.424,0.038,0.390,0.554,0.524,0.521,0.533,0.930,
0.926,0.451,0.381,0.760,0.429,0.250,0.227,0.373,0.399,0.033,
0.203,0.357,0.543,0.354,0.320,0.628,0.485,0.274,0.192,0.317,
0.279,0.192,0.163,0.236,0.284,0.022,0.194,0.278,0.272,0.216,
0.196,0.336,0.365,0.282,0.245,0.439,0.026,0.022,0.021,0.052,
0.239,0.020,0.181,0.244,0.229,0.230,0.217,0.376,0.515,0.260,
0.299,0.691,0.342,0.218,0.233,0.528,0.338,0.024,0.230,0.405,
0.522,0.319,0.387,1.010,0.733,0.435,0.297,0.545,0.444,0.352,
0.298,0.338,0.376,0.037,0.248,0.379,0.407,0.379,0.242,0.489,
0.522,0.351,0.205,0.318,0.403,0.331,0.227,0.299,0.364,0.035,
0.274,0.379,0.344,0.319,0.236,0.378,0.345,0.341,0.253,0.395,
0.027,0.033,0.035,0.053,0.333,0.033,0.233,0.342,0.287,0.358,
0.254,0.419,0.420,0.264,0.243,0.539,0.423,0.359,0.355,0.954,
0.352,0.028,0.276,0.460,0.399,0.373,0.362,0.761,0.493,0.267,
0.212,0.334,0.373,0.270,0.232,0.311,0.356,0.042,0.233,0.339,
0.318,0.299,0.278,0.519,0.031,0.025,0.015,0.025,0.022,0.030,
0.020,0.023,0.021,4.04e-3,0.024,0.028,0.025,0.032,0.023,0.038,
0.280,0.270,0.211,0.294,0.021,0.024,0.021,0.034,0.283,0.031,
0.221,0.296,0.220,0.297,0.284,0.394,0.305,0.206,0.210,0.321,
0.326,0.280,0.265,0.422,0.474,0.039,0.336,0.546,0.368,0.318,
0.439,0.692,0.670,0.334,0.263,0.489,0.325,0.222,0.190,0.253,
0.364,0.037,0.195,0.332,0.431,0.301,0.262,0.644,0.501,0.304,
0.205,0.327,0.304,0.258,0.214,0.272,0.261,0.021,0.224,0.339,
0.298,0.300,0.226,0.497,0.397,0.327,0.269,0.469,0.026,0.025,
0.019,0.039,0.343,0.027,0.250,0.381,0.369,0.396,0.374,0.578,
0.653,0.331,0.350,0.710,0.441,0.368,0.340,0.604,0.574,0.038,
0.481,0.776,0.911,0.716,0.797,1.260,1.120,0.590,0.510,0.942,
0.593,0.374,0.300,0.431,0.483,0.047,0.231,0.426,0.695,0.555,
0.340,0.639,0.559,0.330,0.235,0.355,0.374,0.232,0.195,0.264,
0.279,0.027,0.173,0.225,0.293,0.284,0.216,0.346,0.486,0.327,
0.226,0.449,0.035,0.024,0.019,0.047,0.235,0.019,0.152,0.245,
0.226,0.257,0.231,0.345,0.676,0.276,0.219,0.479,0.390,0.236,
0.190,0.337,0.291,0.020,0.157,0.264,0.395,0.221,0.280,0.609,
0.828,0.457,0.285,0.525,0.533,0.359,0.280,0.333,0.330,0.032,
0.164,0.269,0.344,0.327,0.196,0.393,0.527,0.376,0.200,0.294,
0.373,0.215,0.203,0.243,0.292,0.027,0.188,0.264,0.224,0.225,
0.158,0.254,0.407,0.345,0.217,0.334,0.034,0.032,0.024,0.039,
0.303,0.030,0.204,0.377,0.213,0.294,0.241,0.340,0.431,0.250,
0.151,0.299,0.392,0.308,0.207,0.336,0.288,0.022,0.169,0.305,
0.299,0.250,0.256,0.534,0.539,0.296,0.211,0.384,0.459,0.311,
0.278,0.351,0.429,0.047,0.172,0.264,0.376,0.369,0.235,0.463,
0.044,0.048,0.022,0.036,0.041,0.037,0.034,0.039,0.036,5.45e-3,
0.027,0.034,0.045,0.066,0.034,0.057,0.295,0.247,0.217,0.284,
0.029,0.022,0.027,0.036,0.255,0.026,0.150,0.210,0.192,0.267,
0.222,0.279,0.284,0.183,0.154,0.256,0.372,0.273,0.272,0.344,
0.311,0.029,0.193,0.323,0.326,0.293,0.286,0.492,0.578,0.273,
0.202,0.425,0.294,0.190,0.200,0.236,0.289,0.028,0.137,0.217,
0.404,0.303,0.226,0.487,0.419,0.311,0.201,0.296,0.298,0.222,
0.209,0.251,0.251,0.022,0.176,0.252,0.294,0.291,0.234,0.380,
0.348,0.307,0.234,0.364,0.032,0.022,0.024,0.037,0.277,0.024,
0.191,0.290,0.270,0.332,0.339,0.428,0.477,0.276,0.223,0.458,
0.303,0.200,0.224,0.340,0.475,0.033,0.271,0.476,0.621,0.475,
0.518,1.010,0.057,0.035,0.025,0.039,0.035,0.028,0.020,0.028,
0.025,3.11e-3,0.013,0.025,0.030,0.034,0.021,0.035,0.040,0.029,
0.028,0.028,0.032,0.027,0.026,0.026,0.021,3.25e-3,0.017,0.019,
0.019,0.023,0.019,0.029,0.025,0.023,0.016,0.026,2.88e-3,3.16e-3,
2.87e-3,3.90e-3,0.016,2.15e-3,0.013,0.019,0.014,0.019,0.017,0.025,
0.033,0.017,0.015,0.029,0.030,0.026,0.018,0.028,0.020,2.28e-3,
0.013,0.022,0.025,0.020,0.023,0.049,0.041,0.030,0.016,0.025,
0.034,0.036,0.022,0.021,0.019,3.15e-3,0.011,0.016,0.017,0.020,
0.013,0.022,0.037,0.042,0.018,0.022,0.042,0.041,0.026,0.028,
0.025,6.10e-3,0.019,0.022,0.018,0.024,0.016,0.021,0.025,0.029,
0.017,0.022,3.93e-3,7.38e-3,5.03e-3,4.30e-3,0.028,6.68e-3,0.023,0.038,
0.015,0.027,0.024,0.028,0.027,0.018,0.011,0.021,0.028,0.029,
0.019,0.025,0.021,2.68e-3,0.015,0.026,0.018,0.019,0.019,0.037,
0.032,0.019,0.013,0.020,0.028,0.025,0.024,0.022,0.022,3.58e-3,
0.014,0.018,0.018,0.021,0.016,0.026,3.11e-3,4.32e-3,2.04e-3,2.71e-3,
4.34e-3,6.58e-3,4.98e-3,3.67e-3,3.03e-3,2.05e-3,6.38e-3,4.23e-3,1.85e-3,4.24e-3,
3.04e-3,3.87e-3,0.025,0.024,0.021,0.028,3.72e-3,4.94e-3,6.10e-3,4.37e-3,
0.025,5.87e-3,0.020,0.023,0.015,0.027,0.025,0.027,0.021,0.014,
0.014,0.022,0.031,0.030,0.027,0.031,0.027,4.37e-3,0.022,0.044,
0.023,0.042,0.026,0.043,0.037,0.028,0.019,0.030,0.024,0.019,
0.019,0.020,0.022,2.32e-3,0.012,0.018,0.029,0.027,0.024,0.042,
0.039,0.032,0.021,0.032,0.035,0.036,0.028,0.035,0.024,3.23e-3,
0.022,0.026,0.026,0.034,0.028,0.041,0.024,0.025,0.021,0.030,
2.76e-3,3.37e-3,3.50e-3,4.22e-3,0.021,3.08e-3,0.020,0.026,0.021,0.028,
0.047,0.041,0.033,0.023,0.018,0.034,0.026,0.023,0.021,0.031,
0.033,3.20e-3,0.023,0.040,0.039,0.041,0.044,0.083,0.619,0.371,
0.272,0.477,0.327,0.243,0.166,0.255,0.268,0.025,0.157,0.225,
0.249,0.206,0.157,0.283,0.470,0.304,0.179,0.262,0.340,0.244,
0.219,0.225,0.285,0.031,0.321,0.273,0.192,0.245,0.177,0.269,
0.283,0.282,0.182,0.291,0.034,0.038,0.028,0.053,0.226,0.028,
0.212,0.245,0.156,0.246,0.194,0.294,0.292,0.178,0.132,0.270,
0.263,0.218,0.172,0.288,0.286,0.027,0.218,0.348,0.271,0.220,
0.266,0.584,0.036,0.028,0.015,0.024,0.027,0.029,0.018,0.022,
0.017,3.37e-3,0.013,0.018,0.015,0.019,0.011,0.022,0.029,0.026,
0.014,0.016,0.029,0.025,0.019,0.019,0.019,4.78e-3,0.028,0.021,
0.012,0.018,0.012,0.017,0.020,0.026,0.015,0.021,3.11e-3,6.06e-3,
5.46e-3,4.29e-3,0.022,6.46e-3,0.045,0.044,0.013,0.025,0.021,0.024,
0.031,0.020,0.012,0.028,0.033,0.037,0.022,0.036,0.027,4.27e-3,
0.025,0.070,0.022,0.021,0.023,0.052,0.420,0.257,0.180,0.206,
0.316,0.288,0.286,0.229,0.261,0.036,0.215,0.239,0.181,0.209,
0.210,0.305,0.029,0.035,0.016,0.019,0.026,0.034,0.028,0.019,
0.025,6.14e-3,0.031,0.027,0.018,0.030,0.028,0.027,0.301,0.286,
0.228,0.259,0.031,0.028,0.035,0.030,0.247,0.032,0.104,0.167,
0.144,0.188,0.203,0.236,0.216,0.144,0.130,0.168,0.277,0.241,
0.208,0.232,0.245,0.028,0.249,0.297,0.191,0.196,0.270,0.368,
0.359,0.215,0.156,0.250,0.230,0.170,0.138,0.146,0.198,0.020,
0.139,0.187,0.205,0.172,0.144,0.278,0.331,0.268,0.165,0.227,
0.291,0.263,0.190,0.185,0.217,0.023,0.237,0.255,0.190,0.243,
0.205,0.266,0.305,0.276,0.224,0.320,0.025,0.028,0.023,0.030,
0.280,0.029,0.287,0.340,0.206,0.291,0.272,0.356,0.298,0.190,
0.156,0.278,0.254,0.216,0.174,0.238,0.327,0.028,0.322,0.394,
0.338,0.335,0.365,0.575,0.691,0.296,0.226,0.458,0.298,0.174,
0.153,0.233,0.249,0.022,0.120,0.201,0.320,0.226,0.175,0.372,
0.384,0.192,0.131,0.206,0.212,0.130,0.118,0.160,0.182,0.013,
0.131,0.178,0.166,0.143,0.125,0.224,0.324,0.202,0.132,0.260,
0.023,0.016,0.012,0.032,0.220,0.016,0.132,0.218,0.190,0.181,
0.166,0.300,0.365,0.182,0.149,0.325,0.245,0.152,0.135,0.253,
0.232,0.016,0.132,0.257,0.305,0.201,0.230,0.569,0.592,0.317,
0.190,0.364,0.335,0.236,0.187,0.233,0.252,0.021,0.142,0.219,
0.255,0.244,0.144,0.314,0.380,0.255,0.135,0.218,0.273,0.199,
0.161,0.198,0.226,0.016,0.165,0.226,0.158,0.162,0.121,0.216,
0.290,0.257,0.150,0.261,0.020,0.022,0.014,0.027,0.267,0.024,
0.200,0.323,0.191,0.242,0.198,0.331,0.356,0.203,0.151,0.301,
0.312,0.251,0.194,0.326,0.259,0.022,0.184,0.385,0.270,0.236,
0.232,0.495,0.595,0.230,0.180,0.282,0.340,0.233,0.221,0.283,
0.287,0.032,0.169,0.283,0.244,0.232,0.225,0.409,0.035,0.020,
0.013,0.020,0.022,0.025,0.020,0.021,0.017,2.75e-3,0.017,0.025,
0.018,0.025,0.019,0.029,0.302,0.258,0.189,0.283,0.021,0.019,
0.017,0.029,0.258,0.026,0.188,0.276,0.189,0.243,0.231,0.337,
0.329,0.192,0.246,0.277,0.330,0.244,0.236,0.326,0.297,0.027,
0.268,0.458,0.276,0.242,0.325,0.518,0.528,0.224,0.183,0.338,
0.248,0.154,0.144,0.184,0.259,0.026,0.141,0.227,0.282,0.198,
0.180,0.408,0.327,0.186,0.130,0.219,0.227,0.172,0.148,0.183,
0.178,0.013,0.160,0.232,0.183,0.177,0.171,0.285,0.351,0.282,
0.218,0.372,0.023,0.020,0.015,0.032,0.319,0.023,0.259,0.408,
0.282,0.302,0.304,0.450,0.482,0.243,0.223,0.463,0.334,0.261,
0.228,0.372,0.415,0.027,0.334,0.551,0.508,0.402,0.478,0.806,
1.770,0.640,0.507,1.220,0.499,0.280,0.228,0.394,0.470,0.037,
0.177,0.341,0.788,0.580,0.294,0.705,0.482,0.238,0.163,0.285,
0.244,0.134,0.112,0.164,0.226,0.014,0.126,0.167,0.275,0.235,
0.151,0.280,0.374,0.229,0.168,0.348,0.025,0.016,0.013,0.035,
0.195,0.013,0.097,0.170,0.207,0.199,0.165,0.314,0.597,0.264,
0.223,0.524,0.336,0.194,0.167,0.323,0.258,0.017,0.143,0.251,
0.444,0.258,0.277,0.728,0.581,0.253,0.166,0.339,0.252,0.141,
0.109,0.162,0.182,0.014,0.075,0.142,0.223,0.165,0.103,0.253,
0.284,0.150,0.089,0.162,0.158,0.087,0.068,0.102,0.142,8.06e-3,
0.069,0.111,0.144,0.106,0.083,0.157,0.222,0.150,0.106,0.191,
0.013,9.53e-3,7.63e-3,0.015,0.155,0.010,0.065,0.119,0.143,0.134,
0.110,0.186,0.237,0.130,0.089,0.191,0.175,0.117,0.081,0.145,
0.153,9.26e-3,0.079,0.148,0.182,0.134,0.136,0.333,0.439,0.178,
0.145,0.298,0.271,0.144,0.128,0.216,0.223,0.022,0.078,0.167,
0.313,0.230,0.138,0.390,0.025,0.016,0.010,0.022,0.019,0.012,
0.011,0.018,0.016,1.26e-3,7.38e-3,0.016,0.033,0.030,0.014,0.036,
0.193,0.128,0.118,0.182,0.014,8.48e-3,8.22e-3,0.017,0.131,9.75e-3,
0.062,0.110,0.143,0.135,0.117,0.203,0.219,0.119,0.110,0.225,
0.210,0.124,0.112,0.197,0.176,0.013,0.094,0.189,0.234,0.169,
0.175,0.389,0.624,0.232,0.192,0.456,0.243,0.128,0.137,0.202,
0.265,0.020,0.119,0.209,0.469,0.263,0.200,0.508,0.315,0.162,
0.126,0.218,0.173,0.106,0.104,0.143,0.177,0.011,0.101,0.172,
0.263,0.202,0.146,0.295,0.247,0.189,0.145,0.248,0.016,0.011,
9.85e-3,0.018,0.177,0.011,0.104,0.176,0.206,0.200,0.198,0.317,
0.439,0.212,0.201,0.470,0.260,0.154,0.151,0.258,0.330,0.019,
0.190,0.346,0.572,0.370,0.434,1.020,0.589,0.286,0.195,0.421,
0.263,0.163,0.113,0.177,0.195,0.016,0.084,0.161,0.271,0.221,
0.132,0.299,0.296,0.159,0.119,0.184,0.178,0.113,0.103,0.122,
0.134,9.52e-3,0.081,0.112,0.130,0.118,0.088,0.168,0.188,0.127,
0.089,0.167,0.012,9.43e-3,7.11e-3,0.016,0.108,8.03e-3,0.061,0.101,
0.109,0.108,0.092,0.174,0.232,0.115,0.096,0.204,0.173,0.113,
0.086,0.149,0.122,8.83e-3,0.068,0.122,0.176,0.132,0.133,0.336,
0.373,0.196,0.103,0.205,0.196,0.139,0.080,0.111,0.118,9.70e-3,
0.049,0.094,0.141,0.118,0.072,0.164,0.207,0.150,0.068,0.118,
0.158,0.114,0.068,0.098,0.102,8.87e-3,0.051,0.083,0.101,0.097,
0.061,0.113,0.154,0.121,0.073,0.131,0.010,9.30e-3,5.54e-3,0.010,
0.119,9.72e-3,0.056,0.100,0.098,0.112,0.091,0.152,0.148,0.088,
0.058,0.123,0.125,0.103,0.063,0.105,0.100,6.79e-3,0.051,0.094,
0.120,0.103,0.096,0.212,0.260,0.114,0.085,0.167,0.153,0.098,
0.086,0.124,0.121,0.012,0.054,0.105,0.144,0.117,0.086,0.204,
0.011,8.11e-3,4.57e-3,0.010,8.50e-3,9.61e-3,6.24e-3,8.64e-3,6.17e-3,8.93e-4,
4.80e-3,8.12e-3,0.011,0.012,6.44e-3,0.013,0.159,0.115,0.084,0.143,
0.011,7.65e-3,7.16e-3,0.013,0.107,8.93e-3,0.054,0.091,0.102,0.115,
0.096,0.167,0.155,0.085,0.075,0.152,0.153,0.105,0.093,0.151,
0.126,9.47e-3,0.077,0.141,0.149,0.128,0.136,0.294,0.277,0.125,
0.098,0.202,0.128,0.080,0.070,0.102,0.132,0.010,0.068,0.107,
0.189,0.134,0.121,0.242,0.188,0.117,0.083,0.138,0.117,0.097,
0.072,0.107,0.096,7.15e-3,0.066,0.105,0.131,0.133,0.097,0.178,
0.151,0.136,0.086,0.152,9.24e-3,8.29e-3,5.73e-3,0.011,0.095,7.73e-3,
0.072,0.110,0.109,0.115,0.138,0.200,0.200,0.106,0.098,0.188,
0.160,0.106,0.090,0.152,0.157,0.010,0.107,0.182,0.232,0.195,
0.211,0.481,0.454,0.238,0.162,0.314,0.184,0.123,0.079,0.145,
0.209,0.015,0.087,0.138,0.214,0.148,0.089,0.200,0.277,0.162,
0.091,0.161,0.161,0.104,0.079,0.103,0.145,0.011,0.104,0.124,
0.143,0.145,0.093,0.183,0.215,0.163,0.092,0.179,0.016,0.013,
8.62e-3,0.021,0.113,9.78e-3,0.062,0.108,0.100,0.131,0.087,0.169,
0.241,0.122,0.086,0.198,0.157,0.110,0.082,0.155,0.155,0.011,
0.085,0.160,0.191,0.145,0.162,0.367,0.020,0.013,6.86e-3,0.013,
0.013,9.39e-3,5.33e-3,9.34e-3,9.63e-3,8.93e-4,4.78e-3,7.67e-3,0.011,9.67e-3,
5.55e-3,0.014,0.013,9.70e-3,4.56e-3,7.75e-3,0.014,9.34e-3,4.84e-3,7.67e-3,
8.19e-3,1.01e-3,6.93e-3,7.69e-3,9.00e-3,9.37e-3,5.59e-3,0.011,0.011,8.67e-3,
4.63e-3,8.99e-3,9.30e-4,1.01e-3,7.00e-4,1.01e-3,8.38e-3,9.71e-4,7.28e-3,9.87e-3,
6.98e-3,9.20e-3,6.62e-3,0.011,0.017,9.59e-3,5.59e-3,0.015,0.014,0.012,
6.85e-3,0.014,0.011,1.10e-3,6.13e-3,0.015,0.013,0.012,0.011,0.026,
0.252,0.130,0.086,0.137,0.162,0.120,0.091,0.128,0.127,0.015,
0.075,0.113,0.125,0.124,0.097,0.201,0.012,8.86e-3,4.71e-3,8.31e-3,
9.93e-3,8.18e-3,5.46e-3,7.10e-3,8.01e-3,1.00e-3,6.08e-3,7.44e-3,0.011,0.012,
9.96e-3,0.014,0.147,0.125,0.092,0.144,9.72e-3,9.23e-3,7.92e-3,0.012,
0.124,0.011,0.069,0.096,0.089,0.110,0.095,0.140,0.145,0.089,
0.075,0.123,0.136,0.111,0.084,0.121,0.149,0.011,0.103,0.149,
0.139,0.115,0.145,0.248,0.267,0.128,0.087,0.172,0.146,0.092,
0.066,0.105,0.130,0.011,0.079,0.119,0.149,0.111,0.083,0.203,
0.201,0.124,0.074,0.130,0.146,0.098,0.066,0.085,0.111,7.66e-3,
0.085,0.115,0.132,0.127,0.095,0.174,0.170,0.136,0.094,0.168,
9.53e-3,8.49e-3,5.79e-3,0.011,0.130,9.26e-3,0.097,0.132,0.130,0.142,
0.123,0.193,0.198,0.105,0.092,0.166,0.120,0.095,0.072,0.110,
0.172,0.011,0.133,0.178,0.204,0.160,0.188,0.339,0.811,0.249,
0.163,0.391,0.177,0.094,0.075,0.139,0.163,0.012,0.068,0.127,
0.240,0.155,0.099,0.264,0.198,0.092,0.052,0.104,0.097,0.060,
0.040,0.066,0.086,5.38e-3,0.046,0.076,0.093,0.070,0.050,0.114,
0.161,0.098,0.066,0.154,8.62e-3,6.35e-3,4.20e-3,0.014,0.086,5.81e-3,
0.044,0.086,0.094,0.086,0.068,0.148,0.243,0.109,0.093,0.227,
0.125,0.074,0.065,0.136,0.117,7.08e-3,0.062,0.127,0.201,0.130,
0.134,0.375,0.245,0.109,0.063,0.132,0.108,0.068,0.042,0.070,
0.077,5.03e-3,0.036,0.066,0.090,0.069,0.042,0.105,0.128,0.074,
0.034,0.070,0.080,0.067,0.028,0.052,0.061,3.56e-3,0.034,0.057,
0.063,0.052,0.033,0.079,0.096,0.061,0.038,0.087,4.65e-3,3.76e-3,
2.02e-3,5.65e-3,0.071,4.04e-3,0.031,0.065,0.070,0.063,0.045,0.101,
0.114,0.057,0.043,0.107,0.076,0.055,0.036,0.082,0.074,4.20e-3,
0.036,0.075,0.105,0.073,0.064,0.180,0.194,0.076,0.061,0.102,
0.103,0.058,0.048,0.091,0.081,6.61e-3,0.037,0.070,0.092,0.072,
0.056,0.139,6.52e-3,3.97e-3,2.16e-3,4.88e-3,3.98e-3,3.60e-3,2.36e-3,4.44e-3,
3.10e-3,2.56e-4,1.90e-3,3.48e-3,5.23e-3,5.33e-3,3.44e-3,8.02e-3,0.092,0.065,
0.047,0.090,4.27e-3,3.10e-3,2.48e-3,6.16e-3,0.066,4.26e-3,0.044,0.058,
0.065,0.059,0.059,0.102,0.104,0.059,0.055,0.090,0.077,0.052,
0.043,0.082,0.078,4.40e-3,0.051,0.088,0.091,0.060,0.081,0.152,
0.305,0.081,0.056,0.125,0.066,0.035,0.029,0.049,0.063,4.47e-3,
0.032,0.058,0.092,0.056,0.043,0.126,0.074,0.036,0.022,0.040,
0.035,0.022,0.019,0.032,0.032,1.71e-3,0.020,0.034,0.041,0.031,
0.024,0.060,0.060,0.035,0.026,0.051,1.99e-3,1.44e-3,1.01e-3,2.81e-3,
0.037,1.73e-3,0.024,0.039,0.042,0.031,0.032,0.059,0.090,0.020,
0.019,0.039,0.019,0.012,0.011,0.021,0.022,9.19e-4,0.015,0.025,
0.024,8.94e-3,0.012,0.014
};

static double hg19_biasTable24_4_large[] = {
104.0,21.4,11.5,25.3,18.4,7.330,5.470,9.110,12.2,0.939,
4.920,6.880,19.1,11.1,8.610,16.2,20.7,7.780,5.250,7.480,
8.020,3.640,3.370,3.840,7.260,0.467,3.370,4.410,7.510,5.030,
4.120,7.030,15.0,7.220,5.530,7.890,0.951,0.597,0.448,0.986,
5.260,0.457,3.470,4.390,6.010,5.440,3.660,5.940,22.9,8.220,
8.410,15.3,10.6,6.210,5.560,10.4,9.830,0.645,4.600,7.490,
15.6,6.990,6.600,12.0,24.3,8.000,4.840,8.830,8.530,4.520,
3.100,4.050,7.140,0.550,2.380,4.130,6.660,5.080,2.820,5.560,
10.2,4.760,2.630,3.930,4.650,2.670,1.940,2.170,5.050,0.332,
2.100,3.010,3.610,2.820,1.810,3.060,7.750,5.260,3.190,4.940,
0.464,0.336,0.236,0.434,4.510,0.367,2.200,3.230,3.470,3.660,
2.400,3.960,7.440,3.930,2.850,5.280,4.990,3.280,2.300,3.880,
5.050,0.307,2.210,3.780,5.670,3.750,3.030,6.680,19.4,5.770,
5.170,7.800,8.100,4.090,3.760,5.040,7.470,0.681,2.720,4.830,
6.920,5.080,3.730,8.240,1.070,0.569,0.378,0.613,0.657,0.457,
0.331,0.435,0.556,0.060,0.299,0.489,0.822,0.798,0.466,0.929,
5.850,3.740,3.540,4.140,0.457,0.291,0.285,0.462,4.160,0.342,
2.140,3.120,3.420,3.320,2.620,3.730,5.900,3.240,3.160,5.090,
5.780,3.680,3.060,4.610,4.700,0.347,2.560,4.160,4.680,3.580,
3.630,6.530,26.7,8.040,6.500,14.9,8.160,3.940,3.930,5.550,
10.4,0.891,3.650,6.520,13.7,7.980,6.040,15.8,12.1,6.600,
4.430,6.870,6.820,4.490,3.620,4.470,6.840,0.414,3.480,5.770,
8.670,6.850,5.020,9.630,8.140,5.690,4.440,6.310,0.583,0.378,
0.349,0.555,5.060,0.335,2.800,4.430,5.160,5.020,4.090,6.070,
13.6,7.280,5.230,11.3,6.000,3.730,3.320,5.890,7.620,0.439,
3.960,6.980,10.1,6.030,6.020,12.6,25.0,11.1,6.550,11.6,
8.380,4.880,3.680,4.740,6.170,0.570,2.310,4.370,7.020,5.760,
3.220,6.300,9.550,5.830,3.250,4.650,4.940,2.980,2.560,2.950,
3.770,0.334,2.120,3.250,3.180,2.730,1.900,3.550,6.230,4.740,
3.320,4.900,0.503,0.452,0.296,0.535,2.890,0.267,1.740,2.500,
2.720,3.200,2.090,3.820,6.560,2.860,2.960,4.870,5.030,3.360,
2.570,3.940,3.390,0.260,1.590,2.910,4.200,2.590,2.590,5.920,
11.6,6.400,3.030,5.300,5.600,3.720,2.180,2.600,3.880,0.352,
1.400,2.520,3.330,3.010,1.710,3.350,5.800,3.640,1.860,2.590,
3.260,1.820,1.660,1.700,2.780,0.257,1.440,2.210,1.920,1.870,
1.270,1.940,4.530,4.210,2.140,3.270,0.327,0.370,0.212,0.292,
2.810,0.340,1.610,2.250,1.960,2.840,1.660,2.810,3.560,2.180,
1.430,2.500,2.980,2.340,1.390,1.970,2.550,0.194,1.080,2.020,
2.400,1.800,1.350,3.360,8.100,4.410,2.740,4.640,5.130,3.560,
3.060,3.480,3.940,0.414,1.750,3.140,3.390,2.960,2.320,4.650,
0.445,0.427,0.200,0.338,0.298,0.372,0.242,0.242,0.264,0.053,
0.204,0.342,0.297,0.350,0.224,0.401,3.900,3.610,2.630,3.190,
0.320,0.323,0.249,0.318,2.730,0.292,1.640,2.410,2.080,2.720,
2.130,3.030,3.130,1.890,1.790,2.790,3.470,2.830,2.270,3.000,
2.630,0.216,1.730,2.800,2.490,1.970,2.500,4.230,7.570,3.220,
2.500,4.660,3.970,2.210,1.840,2.390,3.420,0.272,1.410,2.620,
4.360,2.740,2.070,4.830,5.140,3.440,2.340,3.430,3.060,2.630,
1.980,2.370,2.420,0.219,1.720,3.770,2.600,2.810,1.980,3.800,
4.110,3.270,2.800,3.690,0.278,0.232,0.177,0.288,2.560,0.208,
1.640,2.600,2.440,2.730,2.340,3.510,5.100,2.470,2.370,4.060,
3.300,2.310,1.810,2.900,3.300,0.220,1.940,3.590,4.660,3.510,
3.440,6.380,19.1,6.090,7.640,8.590,4.900,3.020,2.570,3.440,
5.570,0.460,2.520,3.720,5.600,4.270,2.780,5.430,8.250,4.360,
3.230,4.140,3.860,2.360,2.240,2.390,4.250,0.345,2.310,3.040,
3.470,3.200,1.990,3.440,5.770,4.610,4.030,4.940,0.516,0.468,
0.349,0.656,3.120,0.362,1.610,2.590,2.830,3.970,2.190,4.080,
5.870,2.950,3.160,5.360,4.100,3.010,2.460,3.840,3.960,0.348,
2.170,3.790,4.990,3.350,3.750,9.560,0.953,0.554,0.365,0.575,
0.495,0.416,0.236,0.320,0.404,0.056,0.203,0.313,0.393,0.433,
0.279,0.477,0.626,0.479,0.281,0.318,0.440,0.387,0.244,0.247,
0.378,0.057,0.240,0.279,0.304,0.355,0.193,0.306,0.436,0.451,
0.287,0.362,0.047,0.064,0.046,0.053,0.356,0.071,0.221,0.315,
0.289,0.469,0.253,0.413,0.674,0.392,0.309,0.633,0.621,0.588,
0.370,0.639,0.475,0.052,0.302,0.486,0.570,0.432,0.437,0.970,
6.140,3.130,2.260,2.830,3.410,2.480,2.040,2.290,4.040,0.455,
1.980,2.680,3.430,2.610,2.190,3.230,0.444,0.405,0.176,0.232,
0.253,0.239,0.175,0.173,0.314,0.056,0.204,0.238,0.364,0.367,
0.229,0.305,3.280,3.130,2.150,2.320,0.275,0.284,0.191,0.267,
2.930,0.465,1.060,1.670,1.880,2.600,1.690,2.140,2.840,1.870,
1.570,2.110,2.680,2.300,1.900,2.370,2.940,0.299,1.720,2.650,
2.220,2.100,2.070,3.350,5.860,2.770,1.960,3.500,3.210,1.740,
1.380,1.800,3.350,0.290,1.640,2.550,4.030,2.710,2.030,4.270,
5.730,4.420,2.220,3.070,3.640,2.530,1.890,2.050,3.260,0.269,
2.060,3.140,3.360,3.130,2.330,3.610,3.770,3.310,2.290,3.260,
0.306,0.295,0.181,0.306,3.080,0.425,1.810,3.300,2.650,3.330,
2.410,3.790,4.220,2.320,2.270,2.960,3.070,2.370,1.850,2.630,
3.750,0.313,2.480,3.900,4.500,3.360,3.550,6.390,25.1,8.590,
7.030,18.6,6.870,3.690,3.500,5.260,6.600,0.564,2.930,5.560,
11.3,6.630,4.650,11.5,8.120,3.740,2.750,4.500,3.650,1.970,
1.900,2.430,3.950,0.260,2.180,3.390,3.960,2.780,2.110,4.310,
8.190,5.080,3.590,7.240,0.616,0.449,0.322,0.866,3.890,0.334,
1.760,3.470,4.170,4.030,2.520,5.780,10.4,4.440,4.790,12.7,
5.760,3.550,3.400,6.950,5.520,0.382,3.230,6.230,9.300,5.450,
5.890,18.4,12.3,6.080,3.860,7.680,6.390,4.060,2.660,3.970,
5.180,0.411,2.350,4.010,5.200,4.290,2.830,5.450,7.480,4.030,
2.530,3.800,4.200,2.860,2.060,2.400,4.060,0.310,2.170,3.190,
3.540,3.040,1.800,3.340,6.040,4.320,2.630,4.880,0.332,0.294,
0.186,0.404,4.030,0.326,2.170,3.580,3.820,4.150,2.710,5.100,
7.340,3.570,3.120,6.860,5.240,3.960,2.730,5.320,5.100,0.306,
3.000,4.960,6.280,4.090,4.300,9.440,6.950,3.870,2.910,5.110,
4.730,2.890,2.520,3.850,4.500,0.439,2.260,3.670,4.300,3.410,
2.760,5.260,0.471,0.371,0.224,0.375,0.296,0.255,0.202,0.258,
0.295,0.038,0.224,0.344,0.384,0.374,0.234,0.432,4.130,3.350,
2.280,3.370,0.269,0.198,0.160,0.306,3.300,0.280,1.580,2.500,
2.870,3.110,2.310,3.510,4.180,2.530,2.280,3.790,4.070,2.730,
2.410,3.910,4.300,0.287,2.390,4.080,3.850,2.950,3.090,5.720,
13.0,4.880,4.140,7.800,4.950,2.820,4.240,3.730,5.240,0.411,
2.830,4.460,8.110,4.830,4.210,10.1,5.570,3.380,2.260,3.720,
3.370,2.170,1.930,2.410,3.230,0.203,2.100,3.530,4.200,3.410,
2.530,4.920,6.100,4.600,3.260,5.310,0.355,0.260,0.197,0.391,
4.380,0.289,2.380,4.290,4.890,4.740,3.580,5.760,9.770,4.190,
3.770,8.020,5.190,3.740,2.970,5.040,6.230,0.302,3.870,6.600,
10.5,5.790,5.890,11.1,20.5,10.1,7.320,12.3,10.5,5.360,
3.840,4.800,7.090,0.695,2.950,5.140,9.210,6.850,4.090,7.120,
8.250,4.970,3.080,3.660,4.800,2.980,2.470,2.490,3.950,0.341,
2.440,3.000,3.170,2.900,2.280,3.430,4.970,3.770,2.600,3.870,
0.452,0.327,0.261,0.483,2.670,0.259,1.470,2.020,2.620,2.970,
2.220,3.350,6.280,2.950,2.490,5.080,5.120,3.130,2.430,4.010,
3.530,0.346,1.870,2.990,4.400,2.920,3.090,5.800,10.000,5.410,
2.750,4.650,6.610,3.630,2.080,2.640,4.050,0.441,1.650,2.680,
3.370,3.480,1.850,3.510,5.660,3.780,1.780,2.430,3.450,2.020,
1.600,1.730,3.080,0.355,1.770,2.410,2.100,2.360,1.400,2.280,
3.430,3.080,1.680,2.380,0.407,0.255,0.188,0.266,2.510,0.287,
1.490,1.960,2.000,2.730,1.860,2.510,2.940,1.880,1.180,2.160,
2.920,2.080,1.200,2.010,2.360,0.196,1.300,1.980,2.390,2.110,
2.010,3.700,6.070,3.160,2.010,3.370,4.870,3.050,2.300,2.950,
3.940,0.445,1.520,2.480,3.310,2.790,1.900,4.000,0.433,0.367,
0.235,0.307,0.417,0.386,0.274,0.297,0.305,0.058,0.225,0.306,
0.325,0.451,0.243,0.414,2.390,2.440,1.610,1.960,0.237,0.194,
0.159,0.256,2.010,0.233,1.370,2.060,1.600,1.950,1.510,2.050,
2.240,1.440,1.210,1.960,2.920,2.090,1.580,2.310,2.330,0.244,
1.620,2.200,2.270,2.180,2.170,3.430,6.400,2.620,2.040,4.340,
2.750,1.600,1.300,1.880,3.240,0.351,1.310,2.340,3.570,2.410,
1.750,4.460,4.700,3.170,2.100,2.980,3.240,2.360,2.110,2.250,
2.450,0.228,1.700,2.600,2.490,2.580,1.860,3.230,2.780,2.250,
1.880,2.420,0.236,0.168,0.254,0.281,1.770,0.169,1.180,1.720,
1.770,2.190,1.700,2.270,3.650,1.900,1.550,3.250,2.150,1.520,
1.410,2.080,2.650,0.203,1.740,2.800,3.740,2.950,3.020,5.800,
10.4,6.240,4.080,6.710,6.350,5.180,2.920,3.350,3.560,0.415,
1.560,2.780,3.780,3.620,2.080,3.840,5.700,4.150,2.350,2.960,
3.990,2.990,2.330,2.230,2.560,0.316,1.720,2.400,1.700,1.940,
1.460,2.300,2.900,2.920,2.100,2.830,0.279,0.314,0.236,0.348,
1.600,0.199,1.170,1.500,1.410,1.930,1.510,2.380,2.940,1.590,
1.420,2.680,2.840,2.360,1.720,2.320,1.830,0.191,1.130,1.720,
2.200,1.570,1.720,3.460,5.690,4.250,1.970,2.900,3.900,3.340,
1.610,1.860,2.350,0.283,1.130,1.760,1.830,2.120,1.240,2.070,
3.670,2.720,1.340,1.610,2.140,0.844,1.200,1.190,1.930,0.321,
1.300,1.850,1.110,1.630,1.060,1.440,2.220,2.770,1.410,1.890,
0.235,0.318,0.176,0.221,1.730,0.278,1.140,1.550,1.180,2.190,
1.460,1.950,1.670,1.330,0.817,1.340,1.850,1.910,0.940,1.350,
1.520,0.154,0.922,1.420,1.300,1.270,1.060,2.070,4.390,2.920,
1.560,2.440,4.190,3.790,2.380,2.440,2.520,0.359,1.270,1.910,
1.970,2.060,1.560,2.760,0.298,0.358,0.160,0.223,0.346,0.606,
0.331,0.232,0.200,0.081,0.216,0.238,0.151,0.308,0.178,0.232,
2.210,2.590,1.760,1.920,0.335,0.382,0.232,0.266,1.780,0.266,
1.290,1.820,1.190,2.060,1.620,2.060,1.690,1.140,1.090,1.510,
2.790,2.660,2.080,2.240,1.900,0.205,1.290,1.950,1.630,1.600,
1.880,2.920,3.470,1.940,1.350,2.290,2.280,1.610,1.020,1.310,
1.720,0.164,0.794,1.280,1.870,1.450,1.070,2.290,2.910,2.310,
1.560,2.040,2.270,2.530,1.640,1.730,1.370,0.184,1.220,1.780,
1.220,1.630,1.240,1.890,2.080,2.150,2.110,2.130,0.177,0.204,
0.148,0.188,1.190,0.138,1.050,1.370,1.160,1.640,1.510,2.020,
2.290,1.240,1.070,1.850,1.680,1.460,1.120,1.500,1.560,0.130,
0.992,1.740,2.110,1.900,1.910,3.490,6.660,3.990,2.870,4.600,
3.540,2.420,1.930,2.480,2.860,0.311,1.430,2.220,2.910,2.720,
2.160,3.480,4.840,3.930,1.830,2.770,3.270,2.500,1.890,2.040,
3.170,0.367,2.120,2.630,2.000,2.480,1.600,2.560,2.670,3.080,
1.790,2.680,0.283,0.307,0.224,0.421,1.850,0.265,1.100,1.760,
1.550,2.520,1.490,2.800,2.620,1.640,1.310,2.670,2.360,1.960,
1.460,2.290,2.210,0.232,1.450,2.330,2.410,1.900,2.380,4.990,
0.375,0.304,0.154,0.252,0.386,0.327,0.195,0.221,0.218,0.042,
0.143,0.204,0.201,0.265,0.395,0.484,0.295,0.328,0.135,0.173,
0.353,0.381,0.219,0.228,0.258,0.089,0.223,0.243,0.150,0.232,
0.144,0.194,0.189,0.301,0.146,0.191,0.040,0.078,0.056,0.046,
0.216,0.080,0.189,0.229,0.157,0.327,0.226,0.274,0.228,0.169,
0.113,0.235,0.342,0.352,0.199,0.297,0.212,0.037,0.186,0.255,
0.202,0.212,0.258,0.396,3.610,2.890,1.490,2.060,3.200,3.050,
2.050,2.260,3.000,0.482,2.040,2.470,1.890,2.240,1.840,2.750,
0.265,0.468,0.174,0.177,0.247,0.402,0.239,0.184,0.246,0.097,
0.242,0.241,0.184,0.325,0.198,0.227,1.890,2.930,1.470,1.710,
0.220,0.327,0.197,0.251,2.130,0.378,1.140,1.710,1.260,2.260,
1.570,1.930,1.590,1.300,0.961,1.350,2.060,2.500,1.560,1.960,
2.380,0.316,1.790,2.150,1.500,1.760,2.020,2.690,2.880,1.780,
1.060,1.930,1.800,1.150,0.808,1.110,1.850,0.194,0.996,1.590,
1.820,1.580,1.180,2.400,3.170,3.060,1.450,1.920,2.860,2.500,
1.510,1.690,2.300,0.280,1.740,2.360,1.820,2.330,1.590,2.360,
1.950,2.320,1.360,1.830,0.179,0.210,0.138,0.184,1.950,0.338,
1.460,1.950,1.490,2.470,1.740,2.470,1.940,1.340,1.030,1.860,
1.580,1.480,1.080,1.520,2.290,0.231,1.960,2.540,2.350,2.290,
2.370,3.700,7.160,3.040,2.410,4.950,2.710,1.640,1.350,2.220,
2.630,0.240,1.160,2.550,3.320,2.310,1.690,3.970,3.960,2.170,
1.340,2.250,2.060,1.310,1.110,1.540,1.880,0.150,1.130,2.450,
1.720,1.300,0.996,2.120,2.610,2.110,1.340,2.420,0.185,0.162,
0.114,0.284,1.450,0.140,0.776,1.490,1.560,1.700,1.130,2.430,
3.530,1.640,1.570,3.500,2.030,1.360,1.170,2.450,1.910,0.145,
1.090,2.290,2.900,1.840,2.030,5.600,5.500,2.990,1.710,3.120,
3.420,2.400,1.560,2.070,2.770,0.279,1.370,2.440,2.440,2.390,
2.140,3.230,3.480,2.360,1.200,1.890,2.750,2.070,1.380,1.690,
2.310,0.223,1.360,2.100,1.820,1.780,1.170,2.030,2.020,2.110,
1.140,1.800,0.167,0.207,0.121,0.211,1.870,0.245,1.180,1.890,
1.940,3.010,1.700,2.790,2.180,1.370,1.190,2.140,2.290,2.020,
1.330,2.500,1.970,0.171,1.450,2.240,2.210,2.050,2.170,3.900,
3.750,2.310,1.500,2.320,2.940,2.330,1.700,2.270,3.010,0.352,
1.560,2.580,2.250,2.060,1.840,3.350,0.246,0.233,0.122,0.187,
0.180,0.239,0.176,0.166,0.165,0.031,0.142,0.210,0.178,0.223,
0.154,0.252,2.230,2.080,1.230,1.750,0.172,0.162,0.121,0.203,
1.890,0.225,1.200,1.840,1.610,2.100,1.570,2.340,1.950,1.340,
1.150,1.790,2.310,1.810,1.440,2.240,2.380,0.227,1.700,2.430,
2.130,1.830,2.230,3.550,4.970,2.130,1.640,3.070,2.150,1.420,
1.210,1.570,2.450,0.230,1.250,2.300,2.760,1.830,1.650,3.900,
3.170,1.980,1.250,1.980,2.140,1.610,1.200,1.530,1.900,0.139,
1.190,2.020,2.010,1.710,1.400,2.640,2.860,2.340,1.610,2.490,
0.224,0.158,0.114,0.210,2.110,0.187,1.480,2.260,2.270,2.650,
2.110,3.220,3.850,2.000,1.800,3.840,2.860,2.190,1.770,2.670,
3.200,0.214,2.480,3.870,4.810,3.300,3.620,5.340,14.5,5.370,
6.920,8.490,5.220,3.050,2.920,3.460,7.930,0.537,2.440,3.320,
6.600,4.950,2.730,5.220,4.450,2.680,1.930,2.590,2.710,1.550,
1.550,1.750,2.690,0.217,1.400,1.770,2.280,1.930,1.460,2.420,
6.610,3.040,2.020,2.950,0.373,0.239,0.202,0.401,2.280,0.208,
1.480,1.820,2.040,2.190,1.750,2.660,5.050,2.340,1.960,3.930,
3.430,2.130,1.880,2.980,2.370,0.199,1.530,2.200,3.400,2.000,
2.350,4.790,7.920,3.790,2.650,4.430,4.170,2.620,2.420,2.700,
3.370,0.333,1.400,2.410,2.900,2.870,1.460,2.980,3.880,2.370,
1.390,2.030,2.360,1.170,1.370,1.540,2.500,0.248,1.300,1.770,
1.740,1.780,0.987,1.690,3.510,3.020,1.860,2.900,0.296,0.243,
0.204,0.323,2.370,0.252,1.470,2.100,1.720,2.300,1.620,2.320,
2.910,1.700,1.240,2.440,2.770,2.070,1.670,2.420,1.960,0.159,
1.160,1.860,2.010,1.660,1.630,3.440,5.420,2.340,1.890,3.180,
4.090,2.640,2.510,2.930,4.650,0.475,1.500,2.240,3.230,2.760,
1.910,3.850,0.440,0.326,0.201,0.326,0.402,0.334,0.298,0.390,
0.370,0.059,0.232,0.289,0.408,0.555,0.265,0.475,2.350,1.900,
1.660,2.040,0.245,0.186,0.210,0.308,1.760,0.208,1.070,1.410,
1.510,1.950,1.400,1.860,2.250,1.320,1.180,1.980,3.060,2.200,
1.970,2.690,2.140,0.207,1.290,1.880,2.510,2.070,2.040,3.640,
5.710,2.210,1.860,3.900,2.540,1.590,1.620,2.340,3.390,0.390,
1.350,2.170,3.960,2.850,1.860,4.480,3.870,2.280,1.670,2.550,
2.850,1.780,1.960,2.370,2.540,0.237,1.440,2.150,2.800,2.250,
1.620,3.070,2.810,2.330,2.200,2.930,0.265,0.187,0.201,0.339,
2.100,0.197,1.420,2.080,2.150,2.550,2.090,3.130,4.080,2.050,
1.800,3.770,2.480,1.640,1.630,2.650,3.480,0.267,2.130,3.520,
5.980,4.010,4.200,8.980,0.725,0.422,0.352,0.486,0.435,0.326,
0.247,0.321,0.392,0.057,0.158,0.249,0.384,0.417,0.207,0.347,
0.442,0.317,0.260,0.299,0.347,0.250,0.260,0.257,0.253,0.039,
0.170,0.213,0.191,0.224,0.157,0.246,0.323,0.273,0.182,0.253,
0.045,0.040,0.034,0.048,0.190,0.027,0.134,0.175,0.154,0.217,
0.157,0.252,0.323,0.181,0.158,0.279,0.336,0.261,0.217,0.300,
0.231,0.025,0.160,0.218,0.259,0.186,0.233,0.415,0.513,0.351,
0.206,0.353,0.348,0.318,0.215,0.254,0.248,0.039,0.116,0.246,
0.202,0.235,0.125,0.225,0.389,0.314,0.163,0.222,0.327,0.210,
0.226,0.240,0.258,0.048,0.158,0.210,0.155,0.192,0.125,0.176,
0.259,0.303,0.187,0.247,0.041,0.058,0.050,0.046,0.231,0.054,
0.164,0.206,0.140,0.241,0.174,0.225,0.232,0.158,0.113,0.205,
0.275,0.263,0.200,0.232,0.175,0.021,0.116,0.175,0.164,0.156,
0.151,0.289,0.386,0.226,0.154,0.230,0.359,0.329,0.279,0.266,
0.306,0.051,0.170,0.181,0.204,0.242,0.173,0.280,0.036,0.046,
0.027,0.033,0.051,0.074,0.063,0.047,0.042,0.026,0.058,0.043,
0.028,0.054,0.035,0.037,0.228,0.262,0.210,0.232,0.043,0.057,
0.060,0.052,0.226,0.054,0.179,0.194,0.148,0.289,0.208,0.228,
0.228,0.137,0.132,0.209,0.333,0.316,0.289,0.316,0.226,0.032,
0.176,0.223,0.215,0.222,0.234,0.377,0.544,0.353,0.237,0.413,
0.310,0.229,0.196,0.262,0.325,0.040,0.151,0.232,0.377,0.333,
0.258,0.524,0.556,0.394,0.288,0.403,0.498,0.429,0.403,0.443,
0.415,0.053,0.267,0.385,0.375,0.449,0.291,0.470,0.306,0.311,
0.267,0.336,0.034,0.037,0.030,0.047,0.277,0.042,0.215,0.289,
0.244,0.337,0.291,0.400,0.447,0.261,0.208,0.388,0.320,0.261,
0.217,0.310,0.376,0.035,0.261,0.405,0.536,0.441,0.450,0.856,
5.150,2.640,2.270,3.200,2.660,1.870,1.290,1.720,2.220,0.234,
1.470,1.630,2.020,1.710,1.310,1.980,3.190,2.120,1.330,1.750,
2.310,1.570,1.440,1.380,1.950,0.223,1.510,1.690,1.380,1.560,
1.130,1.640,2.760,2.770,1.690,2.310,0.318,0.307,0.232,0.400,
2.340,0.367,1.250,1.590,1.550,2.600,1.280,2.010,2.220,1.320,
1.040,2.510,1.980,1.520,1.210,1.870,2.220,0.198,1.350,1.880,
1.850,1.450,1.620,3.200,0.356,0.257,0.146,0.250,0.314,0.328,
0.159,0.190,0.170,0.032,0.105,0.141,0.144,0.165,0.103,0.185,
0.239,0.193,0.102,0.123,0.235,0.206,0.172,0.152,0.172,0.042,
0.158,0.161,0.113,0.127,0.091,0.128,0.210,0.270,0.152,0.194,
0.040,0.057,0.049,0.044,0.201,0.057,0.183,0.194,0.121,0.228,
0.142,0.195,0.260,0.156,0.112,0.264,0.279,0.278,0.177,0.269,
0.207,0.026,0.141,0.218,0.164,0.148,0.159,0.290,3.180,1.880,
1.240,1.500,2.600,2.640,1.720,1.670,2.200,0.325,1.250,1.550,
1.340,1.450,1.260,1.750,0.227,0.272,0.130,0.145,0.244,0.500,
0.206,0.165,0.191,0.064,0.178,0.174,0.141,0.227,0.177,0.173,
2.080,2.090,1.480,1.840,0.233,0.269,0.227,0.415,1.710,0.274,
0.631,1.010,0.945,1.600,1.150,1.380,1.540,0.996,0.848,1.210,
1.900,1.760,1.420,1.840,1.710,0.195,1.280,1.490,1.150,1.260,
1.340,1.830,2.670,1.470,1.080,1.780,1.720,1.210,0.773,0.967,
1.560,0.186,0.879,1.250,1.380,1.240,0.851,1.640,2.490,1.850,
1.170,1.410,2.150,2.220,1.390,1.240,1.830,0.220,1.360,1.660,
1.500,1.750,1.220,1.650,2.130,2.350,1.470,1.960,0.234,0.266,
0.173,0.267,2.190,0.496,1.560,1.830,1.450,2.450,1.810,2.180,
1.860,1.130,0.945,1.490,1.870,1.540,1.130,1.480,1.940,0.194,
1.570,1.890,1.910,1.760,1.870,2.760,5.370,2.390,1.850,3.410,
2.240,1.370,1.080,1.520,2.040,0.202,0.916,1.560,2.810,1.790,
1.190,2.750,3.280,1.560,1.080,1.620,1.560,0.914,0.805,1.060,
1.280,0.099,0.794,1.200,1.280,0.967,0.756,1.460,2.530,2.130,
1.150,2.070,0.197,0.160,0.115,0.268,1.650,0.150,0.813,1.380,
1.540,1.670,1.190,2.050,3.200,1.680,1.380,2.860,2.010,1.300,
1.140,1.980,1.780,0.142,1.000,1.670,2.550,1.570,1.780,4.070,
5.300,3.050,1.810,3.250,3.100,3.030,1.520,2.020,2.290,0.208,
1.160,1.810,2.190,1.950,1.210,2.480,3.500,2.180,1.260,1.940,
2.370,1.690,1.360,1.680,1.850,0.157,1.220,1.810,1.470,1.330,
0.959,1.630,2.450,2.400,1.380,2.190,0.198,0.208,0.147,0.238,
1.920,0.201,1.310,2.000,1.610,2.220,1.530,2.520,2.850,1.660,
1.350,2.430,2.620,2.060,1.500,2.360,2.070,0.155,1.290,2.020,
2.020,1.660,1.710,3.230,3.670,2.100,1.560,2.180,2.740,2.170,
1.760,2.220,2.290,0.280,1.290,2.270,1.920,1.860,1.610,3.090,
0.276,0.234,0.137,0.203,0.227,0.290,0.199,0.211,0.159,0.037,
0.159,0.202,0.182,0.260,0.179,0.243,2.200,2.400,1.440,2.170,
0.199,0.228,0.194,0.365,2.040,0.318,1.210,1.740,1.720,3.240,
1.650,2.210,2.200,1.470,1.310,1.910,2.520,2.060,1.920,2.680,
2.270,0.193,1.710,2.320,2.250,1.990,2.320,3.270,4.420,1.760,
1.490,2.740,1.960,1.200,1.140,1.480,2.370,0.275,1.150,2.000,
1.990,1.460,1.240,3.070,3.080,1.880,1.310,1.990,2.200,1.640,
1.410,1.580,1.730,0.143,1.480,2.060,1.800,1.570,1.410,2.340,
2.820,2.710,1.710,2.790,0.221,0.217,0.153,0.296,2.490,0.260,
1.830,2.710,2.370,2.890,2.360,3.240,3.910,1.990,1.800,3.780,
2.710,2.210,1.800,2.870,3.070,0.210,2.320,3.790,4.520,2.990,
3.490,6.010,18.2,7.560,6.540,15.1,6.570,3.590,3.400,4.860,
7.000,0.604,2.600,4.710,14.7,8.480,4.070,8.930,5.820,2.870,
2.250,3.470,2.950,1.540,1.560,1.930,3.420,0.212,1.740,2.140,
3.490,2.600,1.660,3.100,5.200,3.200,2.280,4.180,0.397,0.242,
0.207,0.475,2.720,0.199,1.340,2.070,3.090,2.800,1.950,3.860,
11.8,4.080,3.490,7.000,4.940,2.820,2.650,4.400,4.010,0.286,
2.060,3.560,6.640,3.750,3.770,9.620,7.540,3.200,2.160,4.310,
3.500,1.770,1.390,1.980,2.860,0.234,1.040,1.930,3.260,2.590,
1.300,3.080,3.550,1.840,1.100,1.940,1.820,0.887,0.836,1.160,
2.010,0.130,0.904,1.370,1.890,1.410,0.871,1.610,3.270,2.150,
1.560,2.650,0.214,0.140,0.128,0.224,2.500,0.191,0.975,1.570,
2.310,2.190,1.360,2.350,3.390,1.680,1.410,2.690,2.230,1.440,
1.380,1.940,2.020,0.125,0.997,1.810,2.450,1.820,1.630,3.960,
7.350,2.490,2.040,4.070,3.910,2.110,1.910,3.220,3.800,0.361,
1.200,2.200,4.860,3.240,1.900,5.170,0.479,0.234,0.175,0.344,
0.297,0.192,0.183,0.297,0.292,0.026,0.138,0.237,0.550,0.451,
0.215,0.515,2.560,1.770,1.720,2.530,0.208,0.127,0.139,0.268,
1.750,0.158,0.795,1.310,2.140,1.970,1.300,2.210,2.830,1.530,
1.620,2.980,2.690,1.660,1.620,2.730,2.150,0.168,1.180,1.990,
3.100,2.290,2.150,4.440,9.220,3.140,2.600,6.330,3.400,1.790,
1.720,2.940,4.770,0.377,1.780,3.180,9.530,4.680,2.990,8.550,
4.820,2.390,2.000,3.250,2.710,1.600,1.640,2.280,3.200,0.198,
1.600,2.590,4.700,3.310,2.090,4.360,3.690,2.620,2.460,3.510,
0.276,0.170,0.200,0.314,3.030,0.196,1.650,2.570,3.330,3.270,
2.430,4.190,7.080,3.220,2.910,6.430,3.850,2.320,2.190,3.810,
4.950,0.308,2.880,4.950,9.690,6.770,5.760,14.3,9.930,4.920,
3.630,7.400,4.990,2.980,2.350,3.370,4.250,0.416,1.510,2.920,
5.550,5.600,2.310,4.930,5.580,3.030,2.220,4.010,3.360,1.930,
1.880,2.290,2.670,0.237,1.570,2.280,2.440,2.340,1.530,3.100,
3.710,3.070,1.920,3.330,0.313,0.250,0.181,0.352,2.170,0.203,
1.200,1.980,2.260,2.520,1.690,3.270,4.240,2.170,1.920,3.430,
3.390,2.300,1.850,2.820,2.460,0.204,1.350,2.320,3.170,2.070,
2.170,4.950,6.470,3.360,1.980,4.510,3.570,2.210,1.520,2.080,
2.400,0.216,0.945,2.140,2.740,2.390,1.240,2.830,3.820,2.540,
1.280,2.390,2.750,1.420,1.250,1.550,2.140,0.186,1.000,1.620,
1.770,1.580,0.986,1.740,2.820,2.620,1.560,2.610,0.260,0.246,
0.232,0.343,2.230,0.228,1.100,1.790,1.970,2.280,1.460,2.690,
2.580,1.730,1.230,2.200,2.400,2.020,1.500,1.860,1.650,0.121,
0.878,1.570,2.030,1.570,1.350,3.000,5.290,2.370,1.650,3.210,
3.370,2.120,1.880,2.640,2.720,0.311,1.110,1.770,2.890,2.490,
1.610,3.640,0.254,0.202,0.121,0.234,0.212,0.209,0.166,0.204,
0.174,0.032,0.129,0.178,0.252,0.280,0.150,0.272,2.570,2.330,
1.840,2.510,0.215,0.196,0.183,0.261,2.090,0.217,1.120,1.720,
1.930,2.480,1.650,2.620,2.660,1.450,1.500,2.620,2.830,2.250,
2.040,2.600,2.300,0.187,1.320,2.130,2.630,2.030,2.210,4.250,
6.170,2.680,1.960,4.190,2.650,1.610,1.420,2.100,2.970,0.246,
1.250,2.160,4.250,2.790,2.020,5.070,4.130,2.500,1.970,3.250,
2.740,2.110,1.980,2.490,2.500,0.206,1.510,2.440,3.120,3.010,
2.000,3.720,3.030,2.620,2.180,3.270,0.209,0.176,0.140,0.251,
2.460,0.189,1.540,2.470,2.520,2.790,2.150,3.720,4.560,2.290,
2.020,3.760,3.030,2.150,1.690,2.450,3.340,0.226,1.970,3.660,
5.120,3.800,3.590,7.350,5.420,3.040,2.220,4.270,2.970,1.970,
1.330,2.130,2.810,0.242,1.310,2.080,3.550,2.590,1.820,3.080,
4.290,2.580,1.520,2.450,2.400,1.550,1.270,1.500,2.360,0.217,
1.450,1.940,2.300,2.200,1.360,2.440,3.030,2.900,1.790,3.060,
0.297,0.309,0.194,0.406,2.110,0.222,1.210,2.210,1.830,2.560,
1.510,3.230,3.140,1.960,1.630,3.150,2.410,2.130,1.470,2.490,
2.510,0.219,1.450,2.570,2.840,2.070,2.270,5.060,0.340,0.234,
0.147,0.334,0.259,0.223,0.132,0.199,0.205,0.023,0.105,0.174,
0.230,0.224,0.153,0.284,0.255,0.189,0.098,0.166,0.200,0.185,
0.122,0.146,0.180,0.027,0.140,0.171,0.159,0.169,0.102,0.180,
0.199,0.248,0.133,0.213,0.023,0.035,0.029,0.035,0.242,0.036,
0.135,0.228,0.170,0.266,0.170,0.614,0.270,0.186,0.135,0.299,
0.254,0.264,0.172,0.292,0.213,0.022,0.138,0.225,0.228,0.197,
0.194,0.447,3.540,2.020,1.390,2.090,2.460,2.160,1.650,1.950,
2.250,0.288,1.250,1.690,1.900,1.910,1.630,2.720,0.224,0.208,
0.097,0.155,0.155,0.194,0.115,0.117,0.155,0.030,0.147,0.138,
0.192,0.230,0.147,0.212,2.310,3.400,1.660,2.210,0.184,0.246,
0.150,0.230,2.090,0.232,0.892,1.330,1.320,1.940,1.300,1.950,
2.250,1.630,1.220,1.800,2.100,2.010,1.510,1.960,2.390,0.196,
1.810,2.000,1.850,1.690,1.870,3.020,3.530,1.830,1.300,2.570,
2.040,1.390,1.000,1.440,2.160,0.191,1.180,1.820,2.570,1.820,
1.400,2.970,3.560,2.200,1.470,2.270,2.190,1.870,1.360,1.450,
2.330,0.183,1.550,2.080,2.570,2.420,1.720,2.810,2.730,2.950,
1.840,2.990,0.209,0.321,0.169,0.240,2.370,0.233,1.550,2.220,
2.190,2.830,2.230,3.270,2.960,1.770,1.540,2.520,2.210,1.960,
1.410,1.980,2.840,0.206,2.080,2.640,3.220,2.860,2.800,4.730,
12.2,4.010,3.430,7.300,3.790,2.120,1.730,2.940,3.770,0.295,
1.740,3.110,5.380,3.580,2.310,6.280,4.750,2.230,1.490,2.650,
2.290,1.310,1.260,1.740,2.420,0.210,2.630,2.830,2.340,1.770,
1.340,2.690,3.790,3.090,1.820,3.890,0.260,0.233,0.157,0.403,
2.320,0.197,1.420,2.410,2.520,2.490,1.720,3.720,6.030,2.910,
2.700,6.250,3.310,2.080,1.920,3.800,3.150,0.217,2.030,4.030,
5.580,3.350,3.540,10.4,4.890,2.480,1.700,3.450,2.670,1.850,
1.200,1.810,2.270,0.159,1.000,1.890,2.520,1.930,1.310,3.030,
3.160,1.810,1.020,1.880,1.830,1.240,0.899,1.310,1.780,0.115,
1.110,1.750,1.700,1.380,0.953,1.900,2.510,1.930,1.230,2.480,
0.145,0.142,0.088,0.196,2.000,0.161,1.120,1.990,2.040,2.320,
1.520,3.430,3.190,1.750,1.590,3.320,2.470,1.810,1.420,2.690,
2.180,0.133,1.360,2.350,2.790,2.050,2.130,4.880,5.410,2.890,
2.390,3.500,3.630,2.390,2.150,3.330,3.320,0.318,1.640,2.710,
3.440,2.670,2.280,4.720,0.300,0.272,0.154,0.244,0.199,0.185,
0.153,0.201,0.174,0.021,0.144,0.199,0.273,0.253,0.162,0.327,
3.260,3.050,2.070,3.150,0.201,0.202,0.138,0.282,2.620,0.221,
1.390,2.250,2.490,2.840,2.180,3.540,3.900,2.480,2.260,3.450,
3.590,2.620,2.370,3.750,3.480,0.240,2.420,3.540,3.580,2.600,
3.200,5.460,10.3,3.430,2.840,5.820,3.590,2.150,1.880,2.830,
4.230,0.283,1.980,3.420,6.160,3.520,3.110,8.260,5.220,3.030,
1.980,3.390,3.340,2.740,1.840,2.400,3.310,0.191,1.920,3.060,
3.720,2.930,2.270,4.820,5.060,4.160,2.800,4.910,0.247,0.217,
0.148,0.314,3.880,0.241,2.600,4.240,4.410,4.360,3.750,6.300,
10.3,4.460,3.760,8.670,4.900,3.440,2.910,5.460,5.700,0.305,
3.880,7.090,10.2,5.770,5.750,13.1,17.4,9.010,6.020,11.2,
9.620,5.540,4.070,5.030,8.490,0.842,3.580,5.440,10.6,7.970,
4.410,7.380,11.5,6.270,3.400,4.480,5.830,3.730,2.710,2.820,
4.930,0.443,2.550,3.270,3.910,3.670,2.440,3.780,6.270,5.230,
3.310,4.470,0.562,0.532,0.374,0.628,3.740,0.390,2.070,2.690,
3.280,4.350,2.660,3.750,9.390,4.480,3.820,6.500,6.210,4.350,
3.660,5.390,4.700,0.411,2.420,3.890,5.730,3.820,3.640,6.150,
10.3,4.330,2.330,4.370,5.780,4.020,2.390,2.800,4.480,0.485,
1.580,2.490,3.400,3.170,1.530,2.650,6.570,3.930,1.740,2.430,
3.810,2.620,1.820,1.750,3.580,0.426,1.690,2.370,2.170,2.650,
1.340,1.830,3.850,4.180,1.930,2.550,0.336,0.381,0.236,0.292,
3.550,0.422,1.840,2.310,1.990,3.320,1.880,2.400,3.240,2.280,
1.350,2.270,3.250,2.700,1.540,2.230,3.050,0.266,1.610,2.350,
2.700,2.320,2.030,3.530,5.240,2.760,1.740,2.860,3.980,2.420,
2.260,2.540,3.450,0.450,1.400,2.440,2.710,2.650,1.770,3.590,
0.422,0.391,0.181,0.268,0.336,0.298,0.237,0.238,0.297,0.063,
0.199,0.289,0.320,0.483,0.235,0.393,2.380,2.320,1.830,1.810,
0.246,0.219,0.204,0.256,2.060,0.255,1.100,1.550,1.380,1.990,
1.390,1.650,2.400,1.630,1.420,1.930,2.940,2.280,1.760,2.440,
2.660,0.273,1.470,2.380,2.230,2.200,2.130,3.260,7.020,2.890,
2.050,4.350,3.150,1.780,1.660,2.180,3.210,0.300,1.230,2.200,
4.320,2.980,2.070,4.830,5.200,3.610,2.120,2.960,3.360,2.430,
2.190,2.210,2.820,0.252,1.680,2.390,2.920,3.150,2.050,3.370,
2.990,2.650,2.470,2.610,0.273,0.232,0.519,0.302,2.350,0.222,
1.480,2.070,2.170,2.780,2.150,2.610,4.170,2.450,2.080,3.730,
2.610,2.000,2.040,2.610,3.620,0.295,2.180,3.600,4.240,3.540,
3.530,6.110,10.2,7.120,3.770,6.030,5.920,4.660,2.980,3.360,
3.770,0.438,1.680,2.600,3.780,3.750,2.060,3.550,7.560,9.470,
3.030,3.590,4.560,3.750,2.620,2.650,2.950,0.429,1.780,2.460,
2.050,2.560,1.440,2.270,3.490,4.950,2.300,2.620,0.469,0.852,
0.322,0.408,2.340,0.319,1.600,1.880,1.730,2.830,1.720,2.330,
3.460,2.260,1.640,2.540,3.850,3.780,2.010,2.530,2.210,0.273,
1.290,1.960,2.600,2.150,1.950,3.740,6.280,5.040,1.910,2.800,
4.440,4.120,2.040,1.960,2.710,0.386,1.160,1.680,1.800,2.450,
1.230,1.950,4.140,4.340,1.550,1.700,2.930,1.610,1.770,1.430,
2.460,0.419,1.340,1.780,1.370,2.130,1.210,1.440,2.650,4.180,
1.620,1.950,0.348,0.606,0.318,0.301,2.820,0.564,1.630,2.100,
1.480,3.730,1.650,2.040,2.110,1.800,0.928,1.380,2.690,2.870,
1.280,1.550,2.070,0.251,1.060,1.510,1.840,2.130,1.270,2.400,
3.560,3.210,1.360,2.040,3.410,3.110,2.300,2.150,2.320,0.374,
1.230,1.670,1.470,1.940,1.410,2.060,0.360,0.799,0.172,0.207,
0.259,0.403,0.272,0.193,0.238,0.115,0.219,0.251,0.155,0.348,
0.180,0.214,2.340,3.050,1.810,1.730,0.298,0.424,0.292,0.262,
2.280,0.381,1.480,1.930,1.220,2.540,1.730,1.820,1.850,1.440,
1.100,1.530,2.730,3.090,2.060,2.250,2.230,0.277,1.610,2.210,
1.500,1.840,1.870,2.510,3.130,2.000,1.190,1.920,2.170,1.520,
1.150,1.260,1.590,0.159,0.675,1.080,1.700,1.430,0.997,1.920,
3.040,3.360,1.510,1.810,2.200,2.320,1.530,1.570,1.690,0.208,
1.060,1.560,1.320,2.020,1.150,1.770,1.990,2.300,1.540,1.710,
0.181,0.246,0.165,0.187,1.750,0.208,1.280,1.680,1.340,2.030,
1.840,1.980,2.350,1.480,1.150,1.750,2.070,1.930,1.210,1.790,
2.210,0.221,1.480,2.310,2.500,2.480,2.350,3.630,5.190,3.520,
2.090,3.590,2.860,2.450,1.480,1.790,2.250,0.286,1.140,1.680,
2.410,2.350,1.260,2.350,4.740,4.670,2.410,2.600,3.170,3.060,
1.890,1.790,2.740,0.401,1.640,1.930,1.850,2.580,1.410,1.930,
2.990,3.640,2.500,2.760,0.362,0.476,0.300,0.429,2.150,0.336,
1.160,1.560,1.480,2.810,1.380,2.060,2.670,1.740,1.580,2.330,
2.520,2.200,1.500,1.930,2.150,0.239,1.240,1.970,2.390,2.060,
1.950,4.470,0.364,0.387,0.154,0.269,0.370,0.456,0.201,0.212,
0.266,0.063,0.143,0.182,0.201,0.325,0.150,0.219,0.401,0.827,
0.198,0.249,0.435,0.765,0.297,0.269,0.330,0.108,0.244,0.250,
0.190,0.389,0.177,0.208,0.230,0.410,0.203,0.213,0.051,0.115,
0.075,0.050,0.305,0.100,0.244,0.241,0.168,0.456,0.220,0.235,
0.277,0.227,0.141,0.238,0.475,0.501,0.290,0.342,0.277,0.052,
0.193,0.269,0.264,0.277,0.236,0.434,2.280,1.810,1.100,1.480,
1.950,1.870,2.260,1.420,2.130,0.372,1.170,1.310,1.280,1.580,
1.240,1.500,0.217,0.366,0.123,0.130,0.185,0.267,0.186,0.119,
0.206,0.066,0.146,0.153,0.158,0.311,0.161,0.164,1.540,2.310,
1.280,1.230,0.199,0.301,0.218,0.186,2.080,0.399,0.991,1.270,
1.100,2.640,1.340,1.320,1.400,1.090,0.873,0.967,1.700,1.910,
1.340,1.360,1.940,0.282,1.140,1.490,1.170,1.640,1.300,1.760,
2.230,1.410,0.882,1.650,1.580,1.040,0.809,0.865,1.610,0.170,
0.641,1.030,1.520,1.270,0.862,1.710,2.840,2.670,1.290,1.520,
2.310,2.250,1.400,1.310,1.930,0.255,1.240,1.580,1.590,2.130,
1.380,1.720,1.910,2.280,1.300,1.510,0.210,0.297,0.176,0.190,
2.270,0.452,1.180,1.640,1.390,2.540,1.390,1.810,2.110,1.310,
1.130,1.380,1.880,1.820,1.240,1.530,2.410,0.263,1.550,2.280,
2.260,2.300,1.960,3.220,5.820,3.180,2.240,4.560,2.620,1.920,
1.320,1.670,2.380,0.264,1.090,1.950,3.480,2.640,1.710,3.900,
2.810,2.030,1.150,2.440,1.760,1.270,0.858,1.100,1.570,0.164,
0.762,1.300,1.490,1.340,0.840,1.560,2.590,2.410,1.490,2.470,
0.267,0.277,0.161,0.352,1.790,0.175,0.840,1.350,1.600,1.890,
1.210,2.100,3.190,1.760,1.590,3.450,2.160,1.600,1.270,2.170,
1.990,0.164,1.130,1.990,2.990,2.040,2.120,5.570,4.660,3.380,
1.700,3.110,3.580,3.160,1.510,1.910,2.760,0.333,1.220,1.970,
2.410,2.600,1.450,2.490,3.440,3.510,1.250,2.140,2.830,2.890,
1.430,1.600,2.500,0.392,1.400,2.000,1.760,2.250,1.120,1.740,
2.160,2.440,1.200,1.850,0.197,0.280,0.156,0.226,2.340,0.281,
1.350,1.770,1.670,2.740,1.660,2.140,2.250,1.530,1.100,2.010,
2.520,2.330,1.430,2.220,2.200,0.187,1.320,1.970,2.230,1.960,
1.780,3.350,2.390,1.910,1.060,1.720,2.060,1.530,1.270,1.520,
2.230,0.437,1.110,1.730,1.610,1.910,1.350,2.180,0.195,0.323,
0.107,0.168,0.145,0.191,0.115,0.116,0.265,0.132,0.144,0.232,
0.166,0.346,0.129,0.202,1.490,1.650,1.060,1.280,0.150,0.159,
0.135,0.156,1.630,0.214,0.860,1.340,1.090,1.810,1.160,1.570,
1.530,1.140,0.899,1.320,1.990,1.710,1.250,1.700,2.010,0.248,
1.120,1.910,1.560,1.610,1.460,2.520,3.980,1.880,1.320,2.480,
1.990,1.290,0.979,1.330,2.260,0.195,0.830,1.500,2.680,1.860,
1.450,3.290,2.230,1.690,0.889,1.450,1.690,1.300,0.954,1.140,
1.700,0.208,0.932,1.700,1.540,1.740,1.120,2.010,2.540,2.270,
1.400,2.210,0.197,0.196,0.122,0.209,2.230,0.222,1.300,2.130,
2.060,2.760,1.960,2.660,3.600,2.030,1.610,3.400,2.700,2.620,
1.620,2.540,3.370,0.230,2.090,3.750,4.510,3.390,3.400,6.250,
9.150,5.800,3.930,6.300,6.110,4.450,2.730,3.100,4.750,0.583,
2.180,3.670,5.210,4.710,2.510,4.240,6.720,5.130,2.570,3.110,
5.630,3.900,2.490,2.330,3.680,0.480,2.480,2.890,2.430,3.040,
1.950,2.600,2.900,2.830,1.840,2.300,0.323,0.324,0.269,0.349,
1.980,0.273,1.260,1.490,1.600,2.460,1.630,2.150,3.590,2.010,
1.560,2.840,3.280,2.540,1.890,2.500,2.240,0.272,1.440,2.120,
2.610,2.130,2.230,3.850,6.340,3.980,1.890,3.520,4.840,3.910,
1.970,2.170,3.180,0.481,1.550,2.110,2.230,2.790,1.330,2.170,
4.830,4.670,1.630,2.420,3.770,2.960,1.880,1.830,3.250,0.730,
2.150,3.030,1.770,3.010,1.380,1.720,2.250,3.040,1.430,1.630,
0.296,0.434,0.289,0.274,2.380,0.471,1.750,1.810,1.390,3.040,
1.790,1.840,1.690,1.370,0.760,1.240,2.210,2.240,1.150,1.530,
1.850,0.231,1.220,1.620,1.590,1.780,2.090,2.800,2.960,1.980,
1.120,1.740,3.030,2.520,1.770,1.910,2.800,0.423,1.310,1.770,
1.690,2.060,1.290,2.340,0.242,0.340,0.169,0.203,0.303,0.382,
0.271,0.235,0.290,0.105,0.245,0.283,0.186,0.431,0.200,0.271,
1.290,1.720,1.190,1.120,0.185,0.215,0.174,0.193,1.600,0.273,
1.180,1.380,0.943,1.700,1.170,1.250,1.230,1.020,0.883,1.120,
1.860,1.830,1.280,1.590,1.790,0.250,1.250,1.660,1.370,1.770,
1.660,2.310,3.170,1.490,1.010,2.200,1.650,1.110,0.805,1.120,
1.880,0.190,0.734,1.150,2.030,1.610,1.030,2.430,2.740,2.390,
1.390,1.810,2.460,2.250,1.610,1.750,1.930,0.252,1.280,1.800,
1.450,2.230,1.200,1.930,1.480,1.480,1.530,1.430,0.149,0.150,
0.297,0.186,1.360,0.170,1.080,1.300,1.050,1.650,1.320,1.540,
2.200,1.290,1.290,1.940,1.360,1.250,1.330,1.470,1.940,0.199,
1.390,2.000,2.230,2.350,2.190,3.850,5.400,4.120,2.320,3.650,
4.350,4.310,2.310,2.320,2.480,0.337,1.240,1.810,2.110,2.400,
1.280,2.200,4.320,4.370,2.110,2.230,3.980,4.420,2.610,2.150,
2.250,0.422,1.720,2.040,1.240,2.110,1.210,1.650,1.870,2.660,
1.540,1.740,0.238,0.392,0.262,0.291,1.520,0.263,1.350,1.380,
1.040,1.880,1.300,1.700,1.680,1.220,0.909,1.550,2.070,2.350,
1.410,1.600,1.230,0.163,1.090,1.290,1.410,1.310,1.280,2.210,
3.900,3.340,1.320,1.750,3.010,3.570,1.520,1.410,2.020,0.352,
1.040,1.260,1.120,1.800,0.781,1.280,2.340,2.140,0.924,1.100,
0.965,0.408,0.743,0.656,1.580,0.544,1.040,1.420,0.711,1.650,
0.798,0.964,1.440,2.800,1.180,1.260,0.251,0.631,0.304,0.261,
1.860,0.500,1.300,1.560,0.947,2.870,1.470,1.610,0.992,1.070,
0.595,0.767,1.640,2.430,1.020,1.210,1.320,0.221,1.050,1.230,
0.963,1.360,0.978,1.470,2.210,2.070,0.967,1.380,2.930,3.590,
2.040,1.900,1.910,0.362,1.160,1.430,1.090,1.690,1.190,1.640,
0.192,0.444,0.160,0.175,0.309,0.665,0.379,0.238,0.232,0.156,
0.275,0.251,0.116,0.393,0.192,0.183,1.360,2.390,1.390,1.290,
0.247,0.500,0.306,0.253,1.700,0.370,1.310,1.610,0.893,2.370,
1.540,1.650,1.030,0.955,0.753,0.977,2.050,3.010,1.990,1.940,
1.780,0.261,1.570,1.870,1.150,1.530,1.670,2.120,1.780,1.280,
0.748,1.220,1.500,1.360,0.714,0.886,1.230,0.133,0.541,0.719,
1.030,1.010,0.686,1.220,1.780,2.280,1.200,1.330,2.100,2.950,
1.520,1.530,1.320,0.244,0.981,1.280,0.858,1.750,0.987,1.310,
1.170,1.760,1.180,1.220,0.124,0.243,0.154,0.167,1.130,0.194,
1.240,1.350,0.853,1.730,1.780,1.800,1.250,0.995,0.679,1.090,
1.180,1.540,0.910,1.220,1.270,0.152,1.050,1.430,1.280,1.630,
1.850,2.630,3.780,3.130,1.630,2.700,2.930,2.350,1.290,1.770,
2.040,0.267,1.000,1.390,1.790,1.920,1.080,1.920,4.300,4.950,
1.750,2.380,4.570,3.560,2.590,2.360,2.920,0.528,2.230,2.410,
1.590,2.650,1.360,1.880,1.940,3.070,1.660,2.010,0.384,0.479,
0.334,0.466,1.800,0.376,1.250,1.510,1.220,2.700,1.300,1.730,
1.770,1.330,0.937,1.670,2.820,2.420,1.500,1.910,1.780,0.250,
1.260,1.740,1.690,1.770,1.670,3.160,0.239,0.325,0.117,0.186,
0.384,0.494,0.245,0.233,0.235,0.068,0.149,0.160,0.146,0.275,
0.173,0.212,0.343,0.826,0.189,0.295,0.655,0.759,0.579,0.449,
0.382,0.257,0.401,0.361,0.160,0.394,0.165,0.184,0.156,0.427,
0.238,0.205,0.095,0.234,0.158,0.101,0.279,0.173,0.450,0.366,
0.128,0.449,0.273,0.211,0.198,0.167,0.088,0.142,1.000,0.742,
0.338,0.365,0.220,0.065,0.228,0.240,0.155,0.203,0.197,0.276,
2.140,2.850,1.030,1.300,2.420,3.370,1.880,1.670,2.360,0.530,
1.420,1.550,1.180,1.870,1.180,1.670,0.293,1.120,0.206,0.175,
0.356,0.774,0.365,0.239,0.302,0.170,0.332,0.250,0.148,0.415,
0.196,0.192,1.320,2.870,1.270,1.170,0.247,0.491,0.258,0.223,
2.160,0.551,1.090,1.530,0.958,2.620,1.350,1.390,1.010,1.150,
0.654,0.898,1.970,2.910,1.520,1.630,2.210,0.390,1.860,1.980,
1.060,1.700,1.550,1.940,1.760,1.500,0.698,1.210,1.490,1.110,
0.607,0.816,1.530,0.183,0.663,1.020,1.210,1.170,0.660,1.430,
2.940,4.770,1.410,1.650,4.000,3.880,2.000,2.340,3.180,0.516,
1.990,2.310,1.620,2.790,1.420,1.890,1.680,2.570,1.270,1.360,
0.193,0.328,0.189,0.190,1.870,0.377,1.440,1.750,1.130,2.720,
1.410,1.720,1.480,1.260,0.807,1.320,1.520,1.750,1.050,1.330,
2.010,0.248,1.790,2.160,1.700,2.300,1.920,2.700,3.280,2.040,
1.330,2.480,1.970,1.400,0.914,1.410,1.660,0.180,0.759,1.380,
1.850,1.520,0.924,2.270,2.440,1.920,0.945,1.520,1.820,1.330,
0.914,1.300,1.300,0.151,0.734,1.180,1.070,1.080,0.655,1.270,
1.470,1.540,0.863,1.370,0.143,0.147,0.098,0.204,1.120,0.139,
0.639,0.982,1.010,1.280,0.837,1.340,1.750,1.060,0.868,1.890,
1.410,1.120,0.839,1.570,1.230,0.114,0.709,1.300,1.700,1.220,
1.210,3.070,2.880,2.360,1.100,1.810,2.560,2.540,1.450,1.600,
2.120,0.297,1.160,1.640,1.590,2.090,1.410,2.110,2.540,2.890,
1.020,1.570,3.200,2.860,1.800,1.800,2.130,0.380,1.450,1.880,
1.370,2.000,1.050,1.460,1.210,1.900,1.060,1.290,0.193,0.339,
0.218,0.250,1.700,0.288,1.310,1.490,1.190,2.230,1.480,1.600,
1.170,0.921,0.676,1.160,2.320,2.210,1.290,1.940,1.510,0.173,
1.070,1.500,1.280,1.350,1.300,2.240,1.950,1.750,0.800,1.130,
2.060,2.110,1.310,1.420,2.420,0.340,1.160,1.550,1.400,1.620,
1.150,1.840,0.159,0.341,0.088,0.121,0.168,0.309,0.164,0.141,
0.182,0.057,0.141,0.160,0.118,0.218,0.124,0.158,0.978,1.420,
0.804,0.940,0.119,0.165,0.122,0.148,1.440,0.249,0.994,1.360,
0.868,1.640,1.080,1.350,1.020,0.910,0.615,0.929,1.480,1.610,
1.120,1.510,1.750,0.233,1.280,1.760,1.280,1.370,1.450,2.120,
2.390,1.550,0.814,1.520,1.300,1.060,0.632,0.890,1.490,0.144,
0.667,1.010,1.510,1.170,0.884,1.860,1.830,1.790,0.764,1.190,
1.640,1.600,0.955,1.220,2.090,0.228,0.905,1.310,1.240,1.390,
0.934,1.580,1.620,1.530,0.958,1.430,0.128,0.136,0.091,0.153,
1.350,0.164,1.060,1.440,1.190,1.780,1.360,1.760,2.080,1.270,
0.981,2.050,1.670,1.810,1.190,1.980,2.100,0.189,1.590,2.500,
2.630,2.350,2.450,3.460,4.910,3.450,2.960,4.270,3.700,2.730,
2.170,2.360,3.300,0.366,1.490,2.280,3.530,3.140,1.750,2.960,
3.420,2.700,2.400,2.060,2.460,1.770,1.650,1.490,2.180,0.255,
1.280,1.490,1.580,1.860,1.480,1.940,2.440,2.280,1.510,2.180,
0.242,0.234,0.188,0.318,1.620,0.199,1.060,1.340,1.270,1.750,
1.270,1.840,2.810,1.620,1.240,2.280,2.380,1.850,1.490,2.030,
1.730,0.172,1.520,1.670,2.140,1.490,2.020,3.140,4.670,3.350,
1.780,2.710,4.000,3.310,2.330,2.230,2.410,0.340,1.070,1.440,
1.840,2.360,1.200,1.990,3.390,3.290,1.510,1.710,2.870,2.140,
2.040,1.660,2.620,0.419,1.400,1.820,1.480,2.390,1.190,1.550,
2.610,3.810,1.860,2.400,0.339,0.488,0.335,0.398,2.730,0.502,
2.000,2.300,1.470,3.090,1.910,2.150,1.850,1.420,0.856,1.480,
2.490,2.430,1.480,2.110,1.770,0.190,1.110,1.530,1.610,1.500,
1.470,2.700,2.670,1.630,1.040,1.820,3.010,2.440,2.100,2.370,
2.530,0.404,1.070,1.460,1.890,2.030,1.350,2.310,0.247,0.291,
0.149,0.221,0.295,0.352,0.278,0.288,0.299,0.082,0.215,0.248,
0.260,0.520,0.243,0.363,1.580,1.720,1.310,1.670,0.239,0.242,
0.255,0.308,1.710,0.290,1.120,1.250,1.360,2.040,1.350,1.600,
1.370,0.924,0.741,1.330,2.120,1.980,1.590,2.110,1.670,0.213,
1.120,1.500,1.900,1.680,1.640,3.490,2.640,1.290,0.980,2.050,
1.470,1.010,0.983,1.340,1.540,0.181,0.678,1.050,2.050,1.680,
1.070,2.400,2.270,1.920,1.130,1.630,1.870,1.740,1.540,1.770,
1.760,0.231,1.080,1.470,1.610,2.100,1.200,1.980,1.680,1.850,
1.580,1.940,0.187,0.191,0.201,0.260,1.720,0.221,1.380,1.750,
1.540,2.220,1.770,2.290,2.150,1.350,1.110,2.220,1.440,1.190,
1.240,1.750,2.180,0.220,1.660,2.270,3.220,2.800,2.850,4.940,
0.291,0.271,0.294,0.232,0.268,0.278,0.188,0.194,0.193,0.038,
0.107,0.138,0.174,0.221,0.130,0.184,0.349,0.404,0.690,0.283,
0.360,0.379,0.377,0.245,0.264,0.119,0.276,0.240,0.135,0.278,
0.187,0.187,0.160,0.292,0.168,0.168,0.036,0.069,0.055,0.046,
0.158,0.050,0.165,0.160,0.097,0.213,0.174,0.189,0.176,0.131,
0.118,0.166,0.241,0.275,0.196,0.212,0.168,0.035,0.319,0.219,
0.169,0.161,0.375,0.298,0.264,0.302,0.134,0.160,0.329,0.406,
0.242,0.169,0.175,0.059,0.110,0.122,0.104,0.190,0.129,0.130,
0.341,0.519,0.212,0.176,0.515,0.396,0.404,0.250,0.329,0.163,
0.218,0.221,0.152,0.350,0.165,0.161,0.195,0.436,0.206,0.197,
0.073,0.224,0.140,0.068,0.301,0.168,0.286,0.247,0.114,0.424,
0.282,0.219,0.134,0.141,0.083,0.112,0.243,0.349,0.198,0.187,
0.173,0.039,0.147,0.145,0.112,0.153,0.152,0.205,0.177,0.180,
0.092,0.140,0.262,0.358,0.319,0.269,0.222,0.076,0.157,0.136,
0.108,0.198,0.143,0.167,0.037,0.090,0.041,0.041,0.077,0.165,
0.158,0.070,0.076,0.104,0.115,0.065,0.024,0.088,0.057,0.040,
0.165,0.304,0.239,0.196,0.066,0.144,0.159,0.068,0.281,0.151,
0.300,0.241,0.128,0.388,0.304,0.213,0.140,0.115,0.097,0.135,
0.265,0.404,0.313,0.265,0.237,0.071,0.249,0.237,0.149,0.209,
0.229,0.313,0.198,0.173,0.108,0.169,0.156,0.153,0.118,0.139,
0.146,0.024,0.075,0.102,0.154,0.172,0.124,0.219,0.305,0.413,
0.205,0.242,0.355,0.469,0.366,0.359,0.288,0.080,0.208,0.243,
0.183,0.403,0.211,0.266,0.152,0.252,0.186,0.192,0.029,0.055,
0.046,0.038,0.226,0.065,0.246,0.268,0.151,0.322,0.291,0.269,
0.181,0.153,0.111,0.174,0.165,0.210,0.154,0.185,0.239,0.037,
0.218,0.270,0.233,0.283,0.307,0.411,3.170,2.380,1.900,2.420,
2.970,2.340,1.520,1.720,1.950,0.261,0.974,1.340,1.530,1.570,
1.060,1.650,2.840,2.810,1.720,1.740,3.120,2.600,2.730,1.940,
2.400,0.433,1.960,1.880,1.270,2.150,1.380,1.680,1.960,3.270,
1.810,2.260,0.364,0.604,0.374,0.539,4.460,2.530,1.650,1.990,
1.410,4.950,1.510,1.890,1.800,1.210,0.854,1.570,2.030,1.970,
1.440,1.940,1.930,0.350,1.440,1.930,1.640,1.650,1.780,2.780,
0.258,0.260,0.124,0.179,0.770,0.526,0.284,0.238,0.193,0.053,
0.145,0.187,0.124,0.188,0.105,0.164,0.246,0.353,0.163,0.143,
0.487,0.509,0.571,0.309,0.297,0.153,0.334,0.305,0.116,0.278,
0.155,0.147,0.169,0.434,0.198,0.184,0.077,0.193,0.135,0.080,
0.339,0.232,0.366,0.348,0.127,0.457,0.258,0.221,0.181,0.144,
0.086,0.155,0.361,0.409,0.245,0.301,0.207,0.056,0.203,0.236,
0.135,0.166,0.169,0.241,1.920,1.830,0.897,0.981,2.710,3.590,
2.400,1.730,1.900,0.456,1.370,1.400,0.996,1.570,1.190,1.480,
0.192,0.408,0.159,0.129,0.303,0.643,0.463,0.198,0.255,0.146,
0.315,0.215,0.127,0.346,0.207,0.189,1.670,2.860,1.740,1.530,
0.337,0.558,0.536,0.351,2.120,0.487,0.828,1.350,0.952,2.230,
1.790,1.600,1.150,1.100,0.750,0.874,1.970,2.700,2.120,1.820,
1.890,0.341,1.610,1.650,1.050,1.500,1.570,1.900,1.610,1.130,
0.752,1.120,1.440,1.490,0.803,0.838,1.140,0.168,0.734,1.000,
0.972,1.070,0.682,1.290,2.140,2.540,1.300,1.260,2.850,4.830,
2.600,1.670,2.010,0.392,1.660,1.780,1.270,2.310,1.350,1.620,
2.080,3.080,1.620,1.810,0.413,0.541,0.343,0.297,2.720,0.523,
2.920,2.760,1.380,2.860,2.010,2.100,1.420,1.110,0.802,1.210,
1.800,1.960,1.330,1.460,1.980,0.255,1.970,2.180,1.560,1.960,
1.870,2.470,2.940,1.720,1.210,2.040,1.760,1.230,0.958,1.200,
1.560,0.167,0.621,1.100,1.710,1.420,0.851,2.280,2.060,1.400,
0.860,1.080,1.590,0.868,0.742,0.815,1.080,0.108,0.573,0.934,
0.978,0.937,0.652,1.060,1.570,1.640,0.893,1.460,0.181,0.166,
0.125,0.229,1.410,0.227,0.743,1.140,1.150,1.570,1.640,1.930,
1.870,1.090,0.813,1.550,1.690,1.110,0.895,1.430,1.270,0.118,
0.746,1.240,1.830,1.310,1.340,2.860,3.250,2.440,1.330,2.020,
3.450,2.720,1.820,1.850,1.810,0.244,1.060,1.500,1.420,1.760,
0.948,1.760,3.090,2.980,1.260,1.540,4.410,2.650,2.230,1.960,
1.990,0.329,1.440,1.850,1.340,1.870,1.160,1.520,1.860,2.950,
1.330,1.780,0.280,0.421,0.250,0.316,2.190,0.407,1.760,2.300,
1.420,2.840,1.840,2.290,1.800,1.340,0.935,1.510,2.500,2.390,
1.680,2.500,1.830,0.200,1.310,1.810,1.570,1.550,1.430,2.580,
2.130,1.810,0.928,1.300,2.450,2.350,1.880,1.810,1.930,0.331,
1.130,1.930,1.220,1.550,1.230,2.010,0.177,0.238,0.098,0.134,
0.228,0.303,0.259,0.184,0.168,0.064,0.177,0.217,0.120,0.230,
0.152,0.188,1.610,2.350,1.480,1.760,0.229,0.322,0.364,0.301,
2.230,0.393,1.430,1.910,1.240,2.360,1.850,2.050,1.450,1.180,
0.944,1.280,2.240,2.280,2.290,2.480,1.950,0.247,1.650,2.270,
1.600,1.630,1.970,2.730,2.160,1.160,0.801,1.470,1.330,0.969,
0.853,1.000,1.370,0.143,0.649,1.090,1.380,1.100,0.904,1.910,
1.790,1.490,0.825,1.210,1.650,1.640,1.230,1.210,1.540,0.160,
0.950,1.440,1.070,1.330,1.060,1.560,1.830,2.230,1.320,2.050,
0.194,0.229,0.157,0.246,2.360,0.285,1.920,2.700,1.690,2.570,
2.070,2.560,2.220,1.400,1.140,2.430,1.960,1.920,1.600,2.280,
2.320,0.200,1.900,2.980,2.710,2.340,2.530,3.490,5.220,2.970,
2.450,5.000,2.790,1.780,1.370,1.900,2.880,0.270,1.030,1.870,
4.210,3.200,1.530,3.290,2.820,1.770,1.290,1.700,1.650,1.030,
0.830,1.000,1.690,0.154,0.930,1.140,1.800,1.870,1.100,1.830,
2.170,1.780,1.170,1.990,0.183,0.153,0.110,0.232,1.360,0.129,
0.660,1.010,1.460,1.770,1.090,2.100,3.230,1.580,1.310,2.610,
2.010,1.410,1.090,1.730,1.710,0.142,0.968,1.440,2.550,1.730,
1.700,3.820,3.720,2.010,1.130,2.420,2.750,1.470,0.903,1.330,
1.600,0.166,0.577,1.100,1.680,1.580,0.762,1.710,2.080,1.530,
0.710,1.170,1.370,1.020,0.665,0.857,1.410,0.146,0.606,0.987,
1.280,1.440,0.734,1.130,1.540,1.540,0.887,1.430,0.135,0.153,
0.094,0.147,1.480,0.212,0.664,0.984,1.440,2.980,0.955,1.410,
1.530,1.140,0.666,1.390,1.270,1.080,0.649,1.070,1.190,0.094,
0.626,0.965,1.410,1.280,1.020,2.120,2.330,1.180,0.842,1.690,
1.820,1.180,0.977,1.770,1.580,0.193,0.517,0.998,1.690,1.410,
0.823,2.000,0.150,0.126,0.072,0.138,0.130,0.110,0.086,0.139,
0.122,0.021,0.061,0.102,0.195,0.232,0.100,0.211,1.050,1.010,
0.763,1.130,0.106,0.098,0.083,0.129,1.010,0.122,0.481,0.691,
1.080,1.320,0.744,1.120,1.140,0.764,0.655,1.290,1.310,1.080,
0.808,1.240,1.160,0.112,0.647,1.020,1.490,1.190,1.110,2.210,
3.120,1.250,1.010,2.650,1.390,0.816,0.776,1.340,1.760,0.164,
0.623,1.210,2.920,1.770,1.100,2.900,1.880,1.200,0.836,1.430,
1.240,0.888,0.796,1.060,1.270,0.108,0.660,1.040,1.740,1.710,
0.996,1.930,1.400,1.270,1.050,1.560,0.111,0.096,0.098,0.141,
1.170,0.104,0.739,1.090,1.430,1.740,1.250,2.000,2.420,1.310,
1.170,2.490,1.430,1.070,0.949,1.500,1.950,0.155,1.430,2.050,
3.300,2.780,2.610,5.390,4.640,2.910,2.150,3.650,2.790,2.120,
1.470,1.940,2.300,0.261,1.040,1.650,2.420,2.450,1.230,2.510,
3.330,2.400,2.490,2.290,2.500,1.970,1.620,1.620,2.100,0.322,
2.370,2.290,1.390,2.170,1.300,2.010,1.960,2.380,1.410,2.070,
0.211,0.267,0.194,0.292,1.500,0.207,1.070,1.530,1.330,1.940,
1.380,2.300,2.070,1.320,1.120,1.990,2.140,1.930,1.340,1.960,
1.460,0.167,1.470,1.640,1.850,1.520,1.780,3.130,3.310,2.420,
1.130,2.240,2.540,2.140,1.260,1.470,1.550,0.215,0.697,1.100,
1.380,1.570,0.912,1.560,2.700,2.740,1.110,1.590,2.570,1.700,
1.410,1.430,1.860,0.312,1.030,1.400,1.260,1.920,0.979,1.400,
1.700,2.410,1.490,1.890,0.221,0.322,0.388,0.334,1.780,0.309,
1.130,1.490,1.310,2.400,1.730,2.060,1.520,1.310,0.822,1.410,
1.950,2.070,1.330,1.530,1.370,0.138,0.880,1.240,1.500,1.510,
1.320,2.260,1.930,1.290,0.741,1.680,1.900,1.720,1.350,2.650,
1.520,0.247,0.695,1.010,1.170,1.400,0.809,1.620,0.127,0.192,
0.089,0.160,0.162,0.256,0.172,0.238,0.148,0.060,0.132,0.137,
0.126,0.277,0.116,0.163,1.350,1.700,1.140,1.390,0.180,0.251,
0.192,0.232,1.580,0.275,0.968,1.370,1.240,2.200,1.250,1.640,
1.390,1.090,0.842,1.470,1.990,2.650,1.560,1.910,1.700,0.185,
1.080,1.560,1.610,1.490,1.500,2.650,2.130,1.220,0.849,1.630,
1.300,0.959,0.793,1.190,1.500,0.151,0.611,0.975,1.660,1.400,
0.887,1.930,2.070,1.960,1.180,1.760,1.790,1.850,1.500,1.810,
1.640,0.235,1.020,1.440,1.570,2.720,1.210,1.990,1.360,1.670,
1.180,1.600,0.131,0.169,0.125,0.168,1.530,0.182,1.140,1.680,
1.340,2.210,1.460,2.090,1.880,1.300,1.080,1.720,1.600,1.740,
1.070,1.540,1.930,0.178,1.370,2.260,2.380,2.360,2.330,3.940,
2.900,1.990,1.340,2.350,1.910,1.540,0.950,1.360,1.710,0.176,
0.747,1.210,1.720,1.500,0.904,1.720,2.580,2.130,1.190,1.570,
2.090,1.750,1.230,1.260,1.740,0.236,1.250,1.480,1.290,1.830,
1.150,1.600,1.850,2.290,1.500,2.210,0.220,0.283,0.194,0.356,
1.770,0.309,1.110,1.560,1.250,2.250,1.340,2.120,1.770,1.220,
0.937,1.810,1.640,1.500,1.080,1.610,1.770,0.199,1.200,1.840,
1.930,1.670,1.790,3.380,0.172,0.165,0.081,0.162,0.208,0.212,
0.096,0.134,0.119,0.022,0.071,0.108,0.111,0.149,0.086,0.160,
0.161,0.214,0.080,0.103,0.215,0.313,0.154,0.144,0.150,0.049,
0.176,0.179,0.098,0.183,0.100,0.123,0.106,0.193,0.097,0.120,
0.021,0.049,0.035,0.027,0.153,0.053,0.138,0.148,0.098,0.244,
0.133,0.184,0.140,0.120,0.074,0.146,0.203,0.226,0.130,0.182,
0.149,0.028,0.118,0.167,0.141,0.147,0.137,0.261,1.850,1.560,
0.760,1.020,1.640,1.830,1.260,1.290,1.410,0.264,0.778,1.050,
1.050,1.310,0.940,1.720,0.145,0.216,0.075,0.098,0.130,0.215,
0.132,0.097,0.127,0.048,0.114,0.116,0.114,0.222,0.126,0.184,
1.300,2.440,1.170,1.240,0.163,0.272,0.205,0.174,1.730,0.301,
0.769,1.170,0.925,1.930,1.200,1.500,1.230,1.220,0.748,1.000,
1.550,1.940,1.350,1.420,1.750,0.221,1.290,1.530,1.240,1.470,
1.400,2.050,1.720,1.120,0.732,1.320,1.240,1.000,0.730,0.944,
1.210,0.144,0.717,1.070,1.230,1.190,0.837,1.700,2.060,1.880,
1.010,1.340,1.670,1.890,1.240,1.110,1.560,0.194,1.050,1.370,
1.350,2.010,1.290,1.940,1.800,2.280,1.560,1.730,0.221,0.266,
0.387,0.200,1.910,0.238,1.510,1.910,1.420,2.320,1.730,2.240,
1.710,1.230,1.040,1.500,1.550,1.560,1.360,1.340,2.070,0.197,
1.740,2.230,2.080,2.160,2.130,3.230,4.620,1.920,1.540,3.040,
2.030,1.240,0.904,1.570,1.960,0.183,0.771,1.490,2.550,1.830,
1.090,2.820,2.240,1.360,0.753,1.230,1.450,0.958,0.709,0.988,
1.220,0.107,0.749,1.100,1.070,1.070,0.618,1.380,1.820,1.720,
1.010,1.920,0.164,0.165,0.106,0.252,1.400,0.137,0.755,1.320,
1.370,1.570,1.090,2.190,2.300,1.240,1.040,2.350,1.490,1.050,
0.892,1.650,1.570,0.127,0.936,1.830,2.410,1.690,1.630,4.590,
2.930,1.810,1.110,1.960,1.920,1.480,0.878,1.330,1.430,0.137,
0.679,1.180,1.380,1.370,0.836,1.880,2.170,1.770,0.720,1.210,
1.720,1.520,0.830,1.140,1.340,0.145,0.866,1.260,1.060,1.280,
0.756,1.420,1.440,1.570,0.766,1.350,0.103,0.134,0.075,0.131,
1.350,0.146,0.820,1.310,1.190,1.690,1.100,1.890,1.710,1.140,
0.872,1.690,1.550,1.260,0.911,1.570,1.480,0.112,0.973,1.530,
1.630,1.410,1.370,2.960,2.660,2.280,1.160,1.650,2.050,1.680,
1.340,1.870,1.920,0.262,0.922,1.530,1.630,1.650,1.270,2.510,
0.201,0.503,0.096,0.132,0.133,0.160,0.110,0.127,0.121,0.032,
0.091,0.131,0.134,0.193,0.102,0.208,1.650,2.070,1.160,1.630,
0.135,0.183,0.128,0.186,1.880,0.221,1.070,1.670,1.330,1.970,
1.580,2.280,1.910,1.660,1.100,1.760,2.090,2.180,1.630,2.350,
2.280,0.214,1.570,2.340,2.040,1.800,1.990,3.480,3.970,1.880,
1.340,2.730,1.920,1.300,1.020,1.510,2.250,0.188,1.030,1.790,
2.850,1.980,1.600,4.060,2.960,2.680,1.160,1.860,2.310,2.120,
1.270,1.590,2.020,0.173,1.230,2.160,1.860,2.010,1.360,2.760,
2.590,2.720,1.770,2.750,0.177,0.187,0.177,0.230,2.740,0.228,
1.980,3.460,2.520,3.080,2.710,4.210,4.510,2.510,2.080,4.470,
2.930,2.330,2.040,3.200,3.720,0.226,2.740,4.840,4.690,3.170,
3.570,5.120,11.1,4.830,5.360,8.450,4.680,2.680,2.660,3.040,
6.770,0.501,2.530,3.440,6.790,4.610,2.980,5.330,5.480,2.950,
2.350,3.130,3.100,1.910,1.820,1.810,3.220,0.299,1.930,2.330,
2.650,2.280,1.810,2.620,6.510,2.590,2.810,3.520,0.378,0.266,
0.252,0.444,2.280,0.199,1.410,1.990,2.130,2.140,1.700,2.370,
5.710,2.440,2.840,5.280,3.910,2.700,2.330,3.530,2.780,0.216,
1.620,2.460,3.940,2.230,2.480,4.330,4.680,2.350,1.730,2.490,
2.460,1.570,1.410,1.590,2.120,0.213,1.000,1.390,1.850,1.790,
1.230,1.850,2.980,1.880,1.310,1.560,1.640,1.020,1.050,1.050,
1.900,0.194,1.160,1.450,1.340,1.350,1.270,1.350,2.230,1.720,
1.330,1.780,0.178,0.159,0.170,0.259,1.670,0.160,1.040,1.300,
1.080,1.430,1.150,1.340,2.010,1.180,0.949,1.680,1.770,1.330,
1.070,1.600,1.630,0.120,0.938,1.440,1.690,1.220,1.300,2.210,
4.930,1.310,3.100,2.210,2.680,1.500,1.650,1.680,2.480,0.301,
0.988,1.530,2.170,2.010,1.260,2.270,0.317,0.201,0.166,0.205,
0.214,0.170,0.146,0.153,0.206,0.037,0.150,0.178,0.279,0.360,
0.184,0.276,1.730,1.410,1.370,1.410,0.152,0.126,0.129,0.168,
1.450,0.143,0.948,1.150,1.200,1.270,1.210,1.280,1.600,0.978,
1.030,1.540,1.770,1.360,1.220,1.620,1.710,0.156,1.070,1.670,
1.560,1.400,1.470,2.410,5.080,1.760,1.860,3.340,1.990,1.160,
1.510,1.460,2.160,0.204,1.010,1.510,2.870,2.030,1.570,3.490,
3.370,2.100,1.590,2.040,2.130,1.430,1.380,1.390,1.970,0.168,
1.340,1.680,2.220,2.070,1.490,2.360,1.890,1.440,1.380,1.930,
0.153,0.115,0.141,0.184,1.410,0.110,1.010,1.370,1.430,1.480,
1.400,1.750,2.770,1.490,1.530,2.920,1.510,1.020,1.160,1.630,
2.450,0.175,1.460,2.410,3.210,2.360,2.390,4.810,7.610,4.340,
3.230,5.140,3.690,2.580,2.270,2.540,3.100,0.353,1.510,2.410,
3.410,3.030,1.980,3.490,4.670,3.660,2.440,2.750,2.950,2.260,
2.170,1.980,3.180,0.581,2.150,2.490,2.010,2.610,1.970,2.480,
2.730,2.580,2.690,2.720,0.299,0.337,0.313,0.425,1.690,0.199,
1.280,1.480,1.520,1.880,1.440,1.970,2.970,1.450,1.680,2.580,
3.140,2.300,1.900,2.410,1.720,0.165,1.110,1.620,2.050,1.550,
1.840,3.320,4.120,3.080,1.550,2.270,2.630,2.220,1.560,1.640,
1.950,0.253,0.996,1.420,1.480,1.780,1.180,1.810,2.640,2.440,
1.440,1.560,1.560,0.769,1.260,1.200,1.930,0.295,1.440,1.780,
1.080,1.600,1.690,1.730,2.160,2.590,2.310,3.020,0.258,0.326,
0.651,0.957,1.760,0.284,1.370,1.600,1.050,2.140,1.470,1.760,
1.700,1.200,1.020,1.580,1.890,1.710,1.800,2.310,1.310,0.137,
0.868,1.260,1.160,1.180,1.110,1.990,3.450,2.360,1.720,2.120,
2.730,2.400,2.540,2.040,2.390,0.371,1.500,1.850,1.690,2.280,
1.670,2.340,0.259,0.385,0.193,0.219,0.217,0.311,0.284,0.198,
0.228,0.079,0.318,0.254,0.191,0.397,0.249,0.285,2.190,2.300,
1.910,1.900,0.226,0.288,0.276,0.257,1.800,0.290,1.570,1.780,
1.140,2.240,1.950,1.880,1.710,1.200,1.110,1.450,2.040,2.170,
1.910,2.030,1.890,0.213,1.570,2.050,1.280,1.520,1.740,2.450,
2.990,1.750,1.410,2.140,1.630,1.240,1.150,1.310,1.490,0.155,
0.854,1.210,1.810,1.570,1.210,2.420,2.850,2.520,1.700,2.060,
2.000,1.920,1.900,1.840,1.710,0.208,1.710,2.010,1.700,2.150,
1.600,2.350,1.650,1.550,1.570,1.950,0.139,0.158,0.147,0.205,
1.260,0.133,1.190,1.460,1.210,1.550,1.570,1.910,2.030,0.997,
1.190,1.800,1.530,1.270,1.090,1.600,1.790,0.148,1.400,2.280,
2.250,2.170,2.200,3.700,5.390,3.010,2.640,3.810,1.960,1.530,
1.320,1.560,2.190,0.242,1.110,1.580,2.310,2.120,1.360,2.500,
4.070,3.470,2.370,2.580,2.490,2.080,1.920,1.750,3.110,0.398,
2.230,2.440,2.120,2.550,1.570,2.090,4.060,3.850,12.7,5.000,
0.400,0.452,0.750,0.760,2.080,0.282,1.770,1.750,1.340,2.210,
1.810,2.110,2.800,1.810,2.950,3.860,2.110,2.050,2.350,2.300,
2.080,0.214,1.440,2.040,2.270,1.800,2.180,4.420,0.380,0.322,
0.207,0.299,0.283,0.301,0.188,0.221,0.229,0.044,0.140,0.180,
0.194,0.289,0.191,0.264,0.367,0.421,0.248,0.250,0.319,0.362,
0.268,0.213,0.340,0.085,0.298,0.288,0.221,0.418,0.217,0.240,
0.273,0.411,0.635,0.387,0.039,0.080,0.110,0.085,0.272,0.064,
0.274,0.286,0.160,0.348,0.253,0.246,0.346,0.259,0.304,0.480,
0.423,0.556,0.502,0.599,0.269,0.043,0.230,0.306,0.290,0.285,
0.285,0.528,2.420,1.560,1.140,1.280,1.520,1.570,1.450,1.230,
2.000,0.343,1.350,1.460,1.220,1.570,1.290,1.640,0.215,0.267,
0.138,0.146,0.153,0.254,0.172,0.117,0.237,0.071,0.203,0.176,
0.175,0.322,0.207,0.199,1.300,2.040,1.570,1.280,0.170,0.353,
0.220,0.197,1.480,0.239,1.020,1.150,0.778,1.370,1.260,1.140,
1.140,0.944,0.998,1.120,1.400,1.930,1.510,1.890,1.370,0.193,
1.280,1.390,0.997,1.220,1.260,1.600,2.140,1.150,0.953,1.440,
1.150,0.820,0.702,0.778,1.270,0.136,0.739,1.050,1.360,1.160,
0.867,1.700,2.780,2.180,1.430,1.790,1.920,2.040,1.420,1.260,
1.980,0.240,1.520,2.020,1.780,2.130,1.540,2.070,1.650,1.750,
1.650,1.570,0.163,0.213,0.174,0.178,1.540,0.170,1.230,1.400,
1.100,1.580,1.310,1.690,2.130,1.290,1.280,1.570,1.520,1.460,
1.130,1.490,1.860,0.204,1.510,2.000,2.110,2.120,1.910,3.030,
5.880,2.590,2.280,4.240,1.980,1.220,1.200,1.450,2.130,0.211,
0.994,1.600,3.090,2.190,1.560,3.440,2.750,1.530,1.230,1.830,
1.510,0.944,0.952,1.170,1.930,0.202,0.949,1.360,2.000,1.550,
0.983,1.710,2.820,1.960,2.870,3.610,0.260,0.197,0.221,0.430,
1.520,0.139,0.944,1.420,1.420,1.510,1.150,2.050,3.510,1.630,
2.490,5.740,2.240,1.480,1.700,2.830,1.850,0.142,1.170,1.960,
2.960,1.870,2.160,5.690,3.980,2.220,1.600,2.630,2.210,1.540,
1.280,1.460,1.910,0.200,1.050,1.580,1.750,1.720,1.310,2.210,
2.930,2.000,1.300,1.880,1.750,1.390,1.120,1.240,2.250,0.327,
1.370,1.830,1.670,2.110,1.100,1.600,2.210,1.920,2.020,2.420,
0.165,0.198,0.194,0.269,1.710,0.171,1.170,1.610,1.380,1.800,
1.350,1.910,2.560,1.400,1.630,2.930,2.070,1.800,1.760,2.230,
1.710,0.141,1.140,1.720,1.940,1.620,1.710,3.110,2.820,1.520,
1.230,1.720,1.990,1.360,1.360,1.620,2.430,0.273,1.270,1.850,
1.910,1.700,1.540,2.480,0.218,0.191,0.120,0.194,0.143,0.153,
0.132,0.141,0.195,0.037,0.159,0.196,0.223,0.279,0.172,0.255,
1.620,1.630,1.280,1.640,0.137,0.155,0.144,0.192,1.580,0.183,
1.080,1.440,1.210,1.610,1.480,1.860,1.660,1.120,1.200,1.820,
1.880,1.630,1.610,2.260,2.050,0.173,1.490,2.230,1.880,1.580,
1.840,3.080,4.380,1.790,1.560,2.790,1.750,1.170,1.180,1.350,
2.050,0.185,1.050,1.670,2.770,1.910,1.640,3.820,2.380,1.520,
1.130,1.850,1.490,1.170,1.080,1.260,1.730,0.135,1.230,1.880,
2.110,1.810,1.370,2.500,2.650,2.200,1.860,2.730,0.205,0.170,
0.147,0.259,2.240,0.180,1.670,2.250,2.310,2.510,2.180,3.280,
4.990,2.320,2.480,5.220,3.010,2.360,2.130,3.320,4.000,0.239,
2.900,4.720,6.740,4.220,5.020,8.100,0.602,0.365,0.336,0.458,
0.360,0.247,0.221,0.234,0.338,0.040,0.188,0.244,0.343,0.308,
0.207,0.289,0.427,0.310,0.240,0.254,0.307,0.239,0.239,0.195,
0.262,0.041,0.226,0.241,0.207,0.234,0.249,0.260,0.295,0.216,
0.203,0.236,0.039,0.032,0.033,0.039,0.157,0.022,0.142,0.148,
0.138,0.166,0.160,0.182,0.318,0.165,0.183,0.286,0.331,0.240,
0.208,0.261,0.196,0.022,0.154,0.195,0.219,0.168,0.207,0.330,
0.434,0.298,0.269,0.315,0.313,0.240,0.200,0.179,0.243,0.043,
0.172,0.212,0.182,0.228,0.221,0.221,0.377,0.338,0.216,0.206,
0.274,0.228,0.229,0.195,0.296,0.072,0.274,0.292,0.171,0.257,
0.347,0.250,0.203,0.227,0.158,0.172,0.036,0.041,0.044,0.033,
0.252,0.045,0.162,0.184,0.115,0.224,0.173,0.159,0.172,0.123,
0.095,0.138,0.219,0.180,0.137,0.178,0.180,0.022,0.133,0.177,
0.169,0.151,0.179,0.252,0.285,0.162,0.165,0.173,0.282,0.206,
0.195,0.177,0.225,0.044,0.139,0.162,0.150,0.196,0.145,0.225,
0.037,0.045,0.044,0.032,0.038,0.046,0.047,0.030,0.036,0.018,
0.052,0.035,0.026,0.058,0.043,0.042,0.139,0.168,0.157,0.139,
0.023,0.027,0.032,0.026,0.148,0.033,0.144,0.152,0.094,0.161,
0.164,0.157,0.122,0.082,0.094,0.122,0.172,0.162,0.162,0.194,
0.164,0.025,0.144,0.167,0.130,0.146,0.183,0.234,0.329,0.141,
0.135,0.237,0.162,0.110,0.122,0.136,0.176,0.023,0.098,0.136,
0.200,0.173,0.133,0.283,0.321,0.254,0.210,0.255,0.250,0.242,
0.236,0.215,0.218,0.036,0.215,0.248,0.191,0.247,0.202,0.292,
0.182,0.161,0.184,0.227,0.020,0.020,0.028,0.030,0.154,0.023,
0.126,0.172,0.121,0.179,0.260,0.228,0.213,0.121,0.136,0.240,
0.143,0.109,0.136,0.173,0.212,0.022,0.179,0.257,0.245,0.227,
0.268,0.442,0.467,0.346,0.255,0.349,0.336,0.305,0.249,0.245,
0.244,0.043,0.145,0.191,0.242,0.258,0.209,0.259,0.409,0.367,
0.256,0.245,0.356,0.349,0.359,0.269,0.296,0.078,0.304,0.296,
0.154,0.254,0.455,0.346,0.194,0.257,0.231,0.204,0.035,0.069,
0.060,0.046,0.153,0.032,0.142,0.141,0.153,0.176,0.166,0.175,
0.191,0.115,0.121,0.177,0.254,0.257,0.195,0.199,0.152,0.021,
0.120,0.143,0.148,0.133,0.175,0.254,0.392,0.368,0.200,0.231,
0.337,0.408,0.242,0.206,0.225,0.055,0.154,0.173,0.141,0.215,
0.146,0.222,0.347,0.425,0.235,0.213,0.280,0.167,0.281,0.252,
0.308,0.131,0.296,0.343,0.143,0.313,0.280,0.479,0.202,0.354,
0.237,0.233,0.046,0.100,0.085,0.070,0.221,0.074,0.199,0.209,
0.106,0.296,0.221,0.222,0.138,0.118,0.101,0.126,0.199,0.251,
0.184,0.205,0.148,0.028,0.136,0.167,0.109,0.150,0.149,0.240,
0.294,0.214,0.159,0.171,0.310,0.334,0.348,0.217,0.252,0.061,
0.227,0.216,0.135,0.209,0.195,0.232,0.047,0.073,0.045,0.034,
0.053,0.113,0.128,0.046,0.056,0.048,0.122,0.065,0.022,0.073,
0.061,0.050,0.201,0.304,0.269,0.207,0.051,0.102,0.098,0.052,
0.226,0.076,0.269,0.229,0.104,0.258,0.274,0.223,0.135,0.101,
0.106,0.121,0.223,0.298,0.301,0.244,0.259,0.043,0.240,0.235,
0.125,0.166,0.246,0.261,0.251,0.167,0.135,0.186,0.166,0.139,
0.138,0.134,0.145,0.019,0.102,0.124,0.151,0.148,0.125,0.231,
0.355,0.317,0.230,0.230,0.279,0.334,0.437,0.296,0.229,0.056,
0.293,0.290,0.153,0.262,0.225,0.271,0.152,0.195,0.195,0.185,
0.016,0.032,0.030,0.025,0.140,0.028,0.175,0.175,0.105,0.174,
0.220,0.208,0.163,0.105,0.107,0.152,0.140,0.145,0.130,0.162,
0.168,0.021,0.160,0.232,0.187,0.218,0.262,0.368,0.321,0.252,
0.194,0.291,0.186,0.175,0.140,0.160,0.172,0.028,0.113,0.129,
0.158,0.169,0.128,0.174,0.346,0.379,0.237,0.223,0.332,0.321,
0.311,0.237,0.323,0.080,0.353,0.306,0.164,0.285,0.194,0.208,
0.215,0.327,0.597,0.318,0.039,0.066,0.119,0.077,0.209,0.049,
0.188,0.210,0.095,0.210,0.169,0.175,0.161,0.128,0.166,0.235,
0.193,0.204,0.262,0.261,0.182,0.029,0.161,0.200,0.160,0.156,
0.195,0.331,0.028,0.038,0.023,0.026,0.037,0.059,0.043,0.032,
0.025,0.015,0.030,0.026,0.017,0.037,0.037,0.029,0.048,0.088,
0.043,0.034,0.084,0.113,0.097,0.054,0.062,0.063,0.107,0.078,
0.026,0.084,0.046,0.042,0.027,0.079,0.086,0.048,0.018,0.055,
0.084,0.029,0.057,0.045,0.086,0.077,0.018,0.076,0.059,0.039,
0.022,0.021,0.022,0.030,0.050,0.074,0.075,0.077,0.032,0.014,
0.050,0.043,0.021,0.031,0.036,0.044,0.203,0.223,0.143,0.135,
0.187,0.299,0.281,0.186,0.240,0.072,0.254,0.312,0.112,0.205,
0.221,0.269,0.032,0.083,0.040,0.025,0.047,0.107,0.090,0.040,
0.056,0.054,0.108,0.064,0.023,0.070,0.063,0.037,0.156,0.528,
0.280,0.189,0.049,0.258,0.100,0.061,0.231,0.100,0.254,0.241,
0.090,0.275,0.238,0.185,0.108,0.117,0.117,0.180,0.207,0.515,
0.290,0.518,0.196,0.057,0.270,0.262,0.106,0.166,0.216,0.230,
0.196,0.159,0.108,0.162,0.123,0.111,0.090,0.094,0.150,0.025,
0.111,0.141,0.127,0.142,0.112,0.191,0.294,0.352,0.218,0.216,
0.316,0.393,0.311,0.230,0.305,0.078,0.332,0.375,0.187,0.332,
0.291,0.268,0.168,0.256,0.215,0.190,0.024,0.057,0.044,0.031,
0.207,0.054,0.227,0.242,0.115,0.251,0.208,0.219,0.158,0.129,
0.125,0.177,0.165,0.183,0.156,0.213,0.204,0.032,0.241,0.255,
0.191,0.237,0.255,0.342,0.517,0.291,0.228,0.399,0.318,0.183,
0.171,0.308,0.293,0.032,0.132,0.243,0.294,0.237,0.183,0.361,
0.331,0.225,0.165,0.222,0.222,0.157,0.167,0.199,0.229,0.030,
0.159,0.219,0.205,0.192,0.149,0.222,0.265,0.226,0.253,0.319,
0.027,0.025,0.027,0.054,0.175,0.021,0.138,0.182,0.142,0.180,
0.147,0.236,0.316,0.171,0.252,0.523,0.238,0.171,0.194,0.403,
0.250,0.023,0.158,0.304,0.325,0.218,0.255,0.694,0.538,0.406,
0.277,0.381,0.381,0.350,0.377,0.295,0.334,0.062,0.266,0.344,
0.258,0.346,0.266,0.357,0.532,0.486,0.294,0.344,0.449,0.418,
0.365,0.347,0.450,0.092,0.436,0.505,0.299,0.508,0.288,0.349,
0.309,0.434,0.390,0.383,0.038,0.066,0.074,0.075,0.350,0.061,
0.296,0.379,0.214,0.408,0.308,0.349,0.319,0.221,0.251,0.430,
0.358,0.362,0.414,0.653,0.327,0.040,0.288,0.370,0.283,0.303,
0.340,0.524,0.274,0.202,0.149,0.187,0.238,0.242,0.246,0.230,
0.289,0.056,0.220,0.272,0.187,0.220,0.224,0.303,0.029,0.035,
0.023,0.027,0.033,0.054,0.050,0.034,0.036,0.015,0.045,0.043,
0.032,0.052,0.041,0.042,0.179,0.272,0.226,0.218,0.026,0.047,
0.048,0.043,0.240,0.057,0.235,0.255,0.144,0.279,0.265,0.292,
0.179,0.138,0.158,0.214,0.234,0.245,0.272,0.360,0.284,0.036,
0.281,0.347,0.235,0.207,0.309,0.416,0.431,0.245,0.193,0.303,
0.218,0.171,0.171,0.188,0.231,0.028,0.152,0.217,0.258,0.216,
0.191,0.405,0.327,0.242,0.169,0.233,0.232,0.237,0.252,0.229,
0.248,0.030,0.230,0.284,0.233,0.258,0.219,0.328,0.277,0.275,
0.246,0.322,0.026,0.030,0.028,0.039,0.270,0.037,0.255,0.304,
0.228,0.335,0.317,0.389,0.430,0.236,0.261,0.489,0.314,0.264,
0.279,0.408,0.393,0.033,0.386,0.535,0.581,0.458,0.583,0.749,
4.560,2.320,2.300,3.320,2.270,1.550,1.460,1.590,2.170,0.213,
1.280,1.570,2.440,2.030,1.380,2.170,2.520,1.680,1.180,1.580,
1.750,1.170,1.300,1.170,1.510,0.161,1.130,1.160,1.220,1.350,
1.060,1.390,1.760,1.520,1.200,1.690,0.178,0.150,0.142,0.233,
1.380,0.132,0.953,1.280,0.920,1.160,1.020,1.290,1.890,0.943,
0.859,1.640,1.460,1.060,0.858,1.260,1.280,0.107,0.805,1.050,
1.390,0.785,1.130,1.940,3.050,1.960,1.170,1.800,2.010,1.620,
1.240,1.260,1.540,0.180,0.848,1.130,1.230,1.400,0.878,1.290,
2.370,1.860,1.090,1.220,1.740,1.070,1.320,1.060,1.810,0.254,
1.430,1.620,1.060,1.350,0.951,1.080,1.680,1.920,1.300,1.510,
0.196,0.215,0.208,0.248,1.660,0.243,1.430,2.470,1.020,1.730,
1.390,1.440,1.270,0.836,0.660,0.981,1.490,1.210,0.953,1.260,
1.220,0.109,0.821,1.200,1.100,0.909,0.962,1.650,2.630,1.330,
1.100,1.840,2.360,1.970,1.780,1.870,2.250,0.297,2.090,1.700,
1.580,1.670,1.420,2.150,0.287,0.275,0.193,0.242,0.291,0.278,
0.294,0.245,0.275,0.069,1.100,0.329,0.254,0.494,0.313,0.390,
1.570,1.530,2.380,2.020,0.191,0.172,0.341,0.309,1.490,0.215,
1.350,1.380,0.934,1.510,1.470,1.430,1.180,0.795,0.925,1.150,
1.780,1.460,2.050,1.870,1.290,0.144,1.160,1.390,1.220,1.130,
1.400,1.920,2.350,0.984,0.828,1.550,1.120,0.835,0.875,0.920,
1.210,0.137,0.790,1.010,1.610,1.370,1.340,2.020,1.890,1.460,
1.080,1.420,1.490,1.180,1.250,1.140,1.340,0.162,2.410,1.660,
1.360,1.790,1.270,2.150,1.400,1.450,1.650,1.770,0.152,0.133,
0.171,0.216,1.330,0.153,1.240,1.620,1.150,1.580,1.600,1.850,
1.610,0.941,0.930,1.700,1.080,0.799,1.060,1.380,1.580,0.136,
1.220,1.960,2.150,1.730,1.950,3.550,0.292,0.216,0.170,0.223,
0.218,0.188,0.166,0.179,0.161,0.026,0.103,0.125,0.159,0.182,
0.137,0.182,0.266,0.254,0.194,0.212,0.271,0.253,0.368,0.224,
0.200,0.056,0.215,0.181,0.134,0.203,0.180,0.187,0.126,0.170,
0.126,0.140,0.025,0.040,0.036,0.034,0.119,0.031,0.122,0.134,
0.077,0.146,0.123,0.139,0.129,0.087,0.077,0.119,0.157,0.145,
0.115,0.139,0.106,0.016,0.081,0.104,0.112,0.092,0.118,0.209,
0.212,0.219,0.104,0.127,0.179,0.191,0.163,0.119,0.122,0.030,
0.088,0.095,0.081,0.119,0.083,0.104,0.233,0.274,0.149,0.131,
0.238,0.171,0.261,0.150,0.228,0.091,0.221,0.195,0.106,0.194,
0.146,0.150,0.125,0.223,0.142,0.141,0.034,0.068,0.072,0.045,
0.194,0.081,0.203,0.231,0.090,0.226,0.176,0.155,0.101,0.079,
0.068,0.081,0.125,0.135,0.114,0.118,0.096,0.018,0.089,0.107,
0.076,0.083,0.092,0.136,0.197,0.151,0.128,0.137,0.231,0.274,
0.303,0.185,0.213,0.055,0.720,0.230,0.120,0.191,0.191,0.177,
0.033,0.059,0.042,0.028,0.055,0.095,0.112,0.043,0.056,0.052,
0.992,0.080,0.021,0.071,0.087,0.042,0.144,0.210,0.240,0.188,
0.040,0.069,0.120,0.046,0.210,0.086,0.329,0.211,0.097,0.252,
0.248,0.186,0.106,0.092,0.091,0.108,0.178,0.216,0.257,0.193,
0.152,0.034,0.213,0.170,0.099,0.147,0.169,0.194,0.219,0.179,
0.128,0.183,0.139,0.125,0.115,0.115,0.134,0.019,0.123,0.127,
0.155,0.169,0.171,0.257,0.270,0.270,0.198,0.216,0.285,0.315,
0.301,0.243,0.230,0.058,0.985,0.287,0.182,0.323,0.282,0.368,
0.139,0.184,0.191,0.193,0.019,0.033,0.035,0.029,0.164,0.038,
0.192,0.211,0.127,0.212,0.261,0.243,0.151,0.109,0.097,0.146,
0.121,0.126,0.119,0.147,0.158,0.021,0.150,0.209,0.176,0.179,
0.219,0.339,2.290,1.920,1.380,2.190,1.660,1.380,1.030,1.240,
1.380,0.157,0.904,1.120,1.110,0.963,0.787,1.180,2.510,2.120,
1.280,1.480,2.540,1.770,2.230,1.540,2.150,0.299,2.390,1.920,
1.150,1.610,1.320,1.460,1.530,2.060,1.500,1.530,0.239,0.305,
0.267,0.337,1.520,0.269,1.690,1.610,0.885,1.650,1.250,1.380,
1.140,0.799,0.630,1.060,1.220,1.110,0.906,1.200,1.320,0.153,
1.140,1.440,1.190,0.918,1.190,1.920,0.194,0.195,0.104,0.150,
0.268,0.281,0.182,0.177,0.137,0.036,0.153,0.141,0.088,0.125,
0.091,0.128,0.245,0.263,0.144,0.129,0.528,0.308,0.304,0.196,
0.247,0.097,0.754,0.346,0.104,0.192,0.158,0.127,0.141,0.276,
0.176,0.147,0.049,0.095,0.090,0.051,0.238,0.097,0.343,0.375,
0.099,0.257,0.210,0.185,0.139,0.102,0.070,0.115,0.200,0.231,
0.159,0.202,0.154,0.031,0.160,0.230,0.113,0.109,0.124,0.194,
2.450,1.380,1.070,0.956,1.810,1.900,1.800,1.250,1.660,0.314,
1.750,1.350,0.879,1.190,1.710,1.350,0.203,0.291,0.203,0.145,
0.223,0.346,0.306,0.147,0.234,0.108,0.442,0.232,0.132,0.299,
0.460,0.203,1.660,1.640,1.700,1.330,0.260,0.278,0.389,0.239,
1.130,0.243,0.568,0.585,0.577,0.964,1.150,0.959,0.846,0.677,
0.706,0.649,1.220,1.340,1.450,1.130,1.200,0.194,1.510,1.240,
0.717,0.915,1.360,1.380,1.490,0.854,0.705,0.944,0.952,0.731,
0.578,0.603,0.894,0.113,0.694,0.802,0.741,0.766,0.759,1.010,
1.700,1.620,1.170,1.110,1.620,1.840,1.410,1.010,1.480,0.235,
1.680,1.500,0.987,1.660,1.990,1.330,1.330,1.570,1.310,1.330,
0.164,0.235,0.200,0.192,1.570,0.239,1.720,1.610,0.851,1.600,
1.480,1.410,1.020,0.713,0.644,0.890,1.070,1.030,0.877,1.000,
1.320,0.143,1.470,1.510,1.140,1.230,1.480,1.680,2.540,1.290,
0.950,1.870,1.280,0.859,0.709,1.060,1.270,0.133,0.647,0.963,
1.420,1.090,0.807,1.520,1.870,1.110,0.659,1.050,1.280,0.692,
0.784,0.866,1.050,0.088,0.602,0.775,0.797,0.760,0.592,0.888,
1.310,1.200,0.802,1.210,0.147,0.125,0.104,0.195,1.060,0.123,
0.742,1.210,0.976,1.150,0.863,1.270,1.460,0.809,0.626,1.250,
1.130,0.775,0.641,1.100,0.977,0.083,0.578,0.988,1.210,0.865,
0.913,1.940,2.500,1.750,1.050,1.600,1.860,1.660,1.270,1.280,
1.310,0.158,0.988,1.190,1.030,1.110,0.705,1.300,2.350,1.960,
1.060,1.380,2.310,1.690,1.630,1.520,1.730,0.230,2.150,1.880,
0.951,1.290,0.929,1.140,1.410,1.910,1.270,1.360,0.174,0.263,
0.202,0.228,1.600,0.267,1.640,2.060,0.967,1.860,1.460,1.670,
1.800,1.150,0.803,1.240,1.670,1.510,1.180,1.650,1.280,0.135,
1.060,1.550,1.100,1.070,1.080,1.870,2.340,1.590,0.991,1.270,
1.890,1.950,2.060,1.700,1.740,0.241,1.310,1.500,1.250,1.430,
1.420,1.940,0.213,0.216,0.150,0.159,0.216,0.300,0.391,0.215,
0.176,0.057,0.275,0.218,0.154,0.429,0.249,0.217,1.630,1.870,
1.720,1.550,0.195,0.222,0.492,0.267,2.410,0.419,1.600,1.870,
1.180,2.070,1.860,1.790,1.240,0.963,0.956,1.090,1.670,1.590,
2.110,1.860,1.670,0.190,1.640,2.220,1.250,1.290,1.770,2.310,
2.040,1.020,0.789,1.330,1.100,0.839,0.758,0.795,1.120,0.117,
0.670,0.918,1.210,0.894,0.832,1.570,1.900,1.360,0.974,1.290,
1.460,1.490,1.350,1.110,1.200,0.129,1.090,1.340,1.090,1.290,
1.220,1.440,1.570,1.600,1.280,1.610,0.149,0.160,0.161,0.187,
1.790,0.200,1.660,2.010,1.270,1.760,1.800,1.970,1.850,1.030,
0.985,1.760,1.480,1.280,1.300,1.670,1.740,0.143,1.660,2.340,
2.050,1.640,2.090,2.760,5.010,2.260,1.990,3.750,2.090,1.260,
1.080,1.440,1.960,0.182,0.851,1.480,2.740,2.130,1.240,2.520,
2.200,1.190,1.040,1.290,1.260,0.738,0.780,0.812,1.260,0.099,
0.732,0.931,1.200,1.150,0.777,1.270,1.570,1.160,1.000,1.470,
0.154,0.111,0.103,0.185,0.941,0.080,0.567,0.821,0.840,0.959,
0.848,1.300,2.330,1.060,1.600,2.070,1.570,0.947,0.860,1.320,
1.220,0.092,0.755,1.190,1.730,1.050,1.250,2.940,3.030,1.520,
0.992,1.800,1.510,1.020,0.692,0.948,1.150,0.107,0.559,0.934,
1.170,1.050,0.648,1.260,1.560,0.931,0.608,0.895,0.996,0.594,
0.544,0.607,0.981,0.087,0.561,0.804,0.855,0.784,0.567,0.814,
1.140,0.870,0.608,0.922,0.087,0.078,0.060,0.095,0.936,0.104,
0.479,0.792,0.833,1.030,0.645,0.911,1.090,0.602,0.506,0.885,
0.873,0.623,0.462,0.750,0.824,0.056,0.458,0.768,0.933,0.678,
0.712,1.430,2.470,1.160,0.860,1.380,1.800,2.100,1.050,1.380,
1.480,0.176,0.623,1.100,1.490,1.250,0.845,1.810,0.174,0.118,
0.083,0.132,0.139,0.141,0.095,0.115,0.137,0.021,0.122,0.129,
0.195,0.229,0.119,0.220,1.080,0.852,0.934,1.210,0.102,0.095,
0.090,0.135,0.880,0.093,0.507,0.767,0.831,1.010,0.799,1.070,
1.160,0.722,0.834,1.190,1.300,0.962,0.881,1.250,1.160,0.113,
0.646,1.110,1.170,0.967,1.030,1.880,3.220,1.140,0.948,2.070,
1.270,0.993,0.824,1.260,1.470,0.133,0.686,1.260,2.370,1.460,
1.030,2.500,1.890,1.090,0.817,1.280,1.130,0.846,0.739,0.903,
1.310,0.103,0.859,1.260,1.580,1.630,0.935,1.960,1.300,0.973,
1.000,1.440,0.096,0.078,0.095,0.131,0.941,0.078,0.660,1.000,
0.965,1.130,1.050,1.510,2.120,1.030,1.110,2.450,1.230,0.808,
0.843,1.370,1.740,0.120,1.110,1.900,2.380,1.790,2.000,4.290,
4.660,2.630,2.080,3.530,2.620,1.880,1.640,2.010,1.990,0.218,
1.010,1.800,2.420,2.240,1.540,2.940,2.960,1.930,1.570,2.040,
2.090,1.550,2.360,1.710,1.940,0.212,1.410,1.720,1.470,1.600,
1.340,1.890,1.760,1.580,1.220,1.800,0.162,0.176,0.147,0.223,
1.270,0.148,0.908,1.310,1.010,1.410,1.210,1.880,1.940,1.070,
1.130,1.720,1.860,1.400,1.110,1.580,1.210,0.110,0.768,1.340,
1.510,1.190,1.350,3.020,3.190,2.200,1.230,1.980,2.140,1.700,
1.230,1.520,1.440,0.170,0.782,1.230,1.450,1.360,0.934,1.700,
2.400,1.900,1.160,1.520,2.180,1.270,1.430,1.240,1.770,0.260,
1.180,1.610,1.420,1.540,1.070,1.420,1.500,1.560,1.010,1.550,
0.147,0.177,0.140,0.186,1.510,0.223,1.020,1.530,1.080,1.710,
1.240,1.830,1.250,0.841,0.708,1.120,1.310,1.150,0.791,1.170,
1.020,0.094,0.715,1.220,1.070,0.960,0.952,1.800,2.360,1.410,
1.350,1.600,2.130,1.840,2.060,1.890,1.720,0.279,1.810,2.290,
1.410,1.610,1.270,2.220,0.157,0.180,0.116,0.153,0.190,0.243,
0.212,0.182,0.169,0.056,0.806,0.255,0.152,0.271,0.196,0.222,
1.520,1.490,1.340,1.550,0.158,0.194,0.192,0.208,1.500,0.249,
1.230,1.630,1.070,1.860,1.570,1.950,1.350,0.901,0.896,1.460,
1.790,1.730,1.610,1.920,1.510,0.169,1.280,1.880,1.310,1.410,
1.610,2.740,2.540,1.470,1.200,1.990,1.390,1.090,1.100,1.340,
1.500,0.146,0.947,1.580,1.780,1.480,1.210,2.610,2.330,1.900,
1.290,1.860,1.780,1.760,1.610,1.810,1.620,0.198,2.260,2.170,
1.640,2.260,1.620,2.420,1.490,1.450,1.370,1.790,0.119,0.136,
0.137,0.171,1.280,0.140,1.200,1.660,1.140,1.470,1.740,2.320,
1.810,1.100,1.090,1.720,1.470,1.300,1.030,1.550,1.520,0.133,
1.230,2.170,1.950,1.620,2.050,3.840,3.130,1.940,1.410,2.340,
1.770,1.330,1.090,1.390,1.790,0.165,0.861,1.270,1.830,1.290,
0.886,1.580,2.650,2.010,1.110,1.540,2.270,1.510,1.330,1.280,
1.990,0.225,1.590,1.710,1.510,1.720,1.240,1.680,1.540,1.980,
1.500,1.720,0.187,0.242,0.201,0.274,1.440,0.227,1.130,1.400,
1.180,1.930,1.600,1.680,1.530,1.040,0.902,1.540,1.420,1.270,
0.988,1.380,1.530,0.148,1.140,1.670,1.650,1.280,1.860,3.120,
0.209,0.188,0.123,0.208,0.220,0.203,0.145,0.162,0.132,0.023,
0.097,0.126,0.128,0.153,0.099,0.169,0.224,0.242,0.110,0.133,
0.492,0.290,0.199,0.178,0.200,0.055,0.244,0.218,0.141,0.216,
0.156,0.157,0.113,0.182,0.113,0.127,0.026,0.046,0.043,0.029,
0.169,0.049,0.187,0.198,0.105,0.234,0.188,0.185,0.143,0.114,
0.082,0.149,0.199,0.208,0.130,0.200,0.159,0.024,0.119,0.182,
0.139,0.131,0.152,0.245,2.200,1.410,1.090,1.130,1.930,1.860,
2.780,1.540,1.510,0.270,1.280,1.360,1.100,1.400,1.850,1.780,
0.173,0.191,0.111,0.112,0.217,0.227,0.196,0.117,0.158,0.054,
0.221,0.154,0.154,0.262,0.474,0.207,1.500,1.820,1.470,1.430,
0.229,0.267,0.217,0.197,1.650,0.252,0.851,1.220,0.895,1.570,
1.450,1.480,1.250,1.110,0.879,1.080,2.120,2.280,1.460,1.490,
1.550,0.211,1.470,1.660,1.140,1.290,1.500,2.000,2.020,1.200,
0.829,1.360,1.200,1.000,0.938,0.926,1.210,0.140,0.913,1.180,
1.190,1.170,0.984,1.620,2.250,1.840,1.180,1.530,1.770,1.870,
1.340,1.200,1.740,0.207,1.820,1.940,1.580,2.220,2.270,2.090,
1.640,1.770,1.280,1.620,0.137,0.184,0.150,0.168,1.740,0.185,
1.440,1.850,1.260,1.880,1.800,2.060,1.830,1.180,1.070,1.430,
1.430,1.440,1.130,1.420,1.940,0.175,1.870,2.360,1.810,1.760,
2.130,2.940,5.000,2.020,1.440,2.830,1.760,1.060,0.879,1.340,
1.900,0.196,0.939,1.400,2.280,1.660,1.190,2.480,2.370,1.290,
0.718,1.230,1.420,0.863,0.687,1.010,1.490,0.115,0.792,1.100,
1.210,1.030,0.704,1.250,1.900,1.610,1.040,1.940,0.225,0.199,
0.128,0.297,1.330,0.130,0.772,1.250,1.520,1.580,1.080,1.770,
2.120,0.934,0.918,2.000,1.360,0.834,0.747,1.360,1.310,0.094,
0.808,1.450,2.010,1.300,1.590,4.010,2.970,1.770,1.360,1.930,
1.760,1.520,1.230,1.330,1.290,0.133,0.831,1.240,1.380,1.200,
0.921,1.770,2.330,1.650,0.863,1.320,1.960,1.380,0.972,1.200,
1.530,0.149,1.120,1.540,1.160,1.310,0.846,1.390,1.390,1.370,
0.878,1.370,0.108,0.132,0.088,0.146,1.340,0.148,1.240,1.530,
1.170,1.630,1.290,1.970,1.630,0.995,0.884,1.550,1.360,1.070,
0.863,1.410,1.360,0.098,0.992,1.520,1.530,1.090,1.290,2.620,
3.030,1.640,1.230,1.650,2.260,1.760,1.670,1.960,2.060,0.234,
1.170,1.760,1.870,1.690,1.550,2.780,0.213,0.193,0.104,0.157,
0.201,0.270,0.159,0.170,0.161,0.028,0.133,0.172,0.198,0.254,
0.182,0.257,2.030,2.060,1.410,1.830,0.168,0.218,0.188,0.230,
2.270,0.270,1.410,1.990,1.670,2.280,2.070,2.620,2.070,1.510,
1.190,1.820,2.220,1.970,1.770,2.350,2.400,0.197,1.720,2.810,
1.990,1.750,1.910,3.500,4.760,1.910,1.280,2.510,1.850,1.350,
1.010,1.360,2.150,0.182,1.080,1.700,2.820,1.890,1.590,3.860,
2.960,2.180,1.130,1.820,2.310,3.090,1.270,1.510,2.050,0.175,
1.370,2.070,2.150,1.990,1.600,2.710,2.590,2.290,1.590,2.500,
0.166,0.205,0.122,0.214,2.420,0.194,1.820,2.620,2.430,2.750,
2.560,3.620,4.500,2.040,1.780,3.880,2.420,1.920,1.720,2.680,
3.190,0.200,2.470,4.070,4.700,2.910,3.270,5.870,10.1,5.900,
4.980,11.8,5.260,3.100,2.800,4.160,6.210,0.499,2.560,4.400,
11.4,6.700,3.750,7.860,6.060,2.840,2.310,3.390,3.050,1.770,
1.470,1.790,3.250,0.208,1.550,2.350,3.160,2.360,1.800,3.200,
4.870,2.800,2.550,4.410,0.341,0.248,0.199,0.476,2.340,0.173,
1.240,1.890,2.600,2.410,1.860,3.120,11.0,3.300,3.650,8.360,
5.260,3.180,2.810,5.200,3.510,0.233,1.770,3.080,5.890,3.100,
3.160,6.450,5.570,2.340,1.690,3.130,2.360,1.340,1.110,1.450,
2.250,0.174,0.894,1.450,2.290,1.770,1.130,2.160,3.120,1.560,
1.080,1.540,1.480,0.864,0.754,0.865,1.650,0.106,0.783,1.130,
1.360,1.060,0.856,1.240,2.530,1.640,1.270,2.080,0.157,0.111,
0.091,0.179,1.950,0.129,0.814,1.200,1.230,1.180,0.927,1.490,
2.700,1.340,1.030,2.030,2.080,1.360,0.940,1.510,1.560,0.094,
0.661,1.170,1.780,1.210,1.140,2.290,4.220,1.810,1.650,2.830,
2.370,1.280,1.370,1.710,2.280,0.220,0.939,1.610,2.710,1.890,
1.460,3.210,0.304,0.194,0.133,0.229,0.168,0.130,0.115,0.143,
0.173,0.019,0.104,0.161,0.284,0.269,0.166,0.319,1.850,1.310,
1.200,1.560,0.139,0.090,0.083,0.147,1.310,0.101,0.679,0.975,
1.260,1.150,1.030,1.470,2.140,1.150,1.120,1.970,2.020,1.300,
1.140,1.690,1.740,0.128,0.929,1.520,1.940,1.620,1.590,3.090,
8.110,2.450,2.520,7.600,2.620,1.370,1.820,2.390,3.310,0.260,
1.370,2.300,5.140,2.690,2.130,5.440,3.910,2.160,1.740,2.850,
2.040,1.280,1.420,1.640,2.180,0.134,1.280,2.050,2.820,2.090,
1.700,3.090,2.640,1.830,1.740,2.690,0.180,0.121,0.142,0.229,
1.880,0.119,1.310,1.690,1.990,1.830,1.740,2.520,4.610,2.170,
2.240,5.170,2.420,1.570,1.570,2.660,3.310,0.182,1.820,3.190,
5.620,3.590,3.640,8.450,6.310,2.930,2.290,4.430,2.580,1.570,
1.280,1.840,2.190,0.183,0.877,1.690,2.930,2.170,1.390,2.960,
3.140,1.800,1.320,1.920,1.560,0.965,0.894,1.040,1.410,0.134,
0.779,1.200,1.290,1.190,0.903,1.580,2.060,1.410,1.330,1.980,
0.166,0.147,0.119,0.212,1.170,0.101,0.589,0.864,1.140,1.220,
0.836,1.440,2.670,1.680,1.390,2.680,2.170,1.470,1.190,1.770,
1.320,0.102,0.648,1.170,1.930,1.240,1.340,2.950,3.270,1.930,
1.030,1.960,1.650,1.140,0.760,1.080,1.210,0.107,0.542,0.939,
1.280,1.130,0.694,1.510,1.680,1.200,0.620,0.962,0.883,0.382,
0.489,0.610,0.906,0.081,0.526,0.791,0.754,0.766,0.648,1.010,
1.540,1.240,0.954,1.570,0.110,0.099,0.134,0.248,1.010,0.126,
0.514,0.840,0.799,1.020,0.663,1.090,1.550,0.987,0.713,1.370,
1.170,0.909,0.702,1.100,0.945,0.066,0.448,0.830,1.010,0.829,
0.688,1.600,2.700,1.640,1.210,1.900,1.690,1.130,1.350,1.420,
1.580,0.163,0.844,1.330,1.550,1.330,1.120,2.110,0.169,0.203,
0.086,0.140,0.096,0.107,0.093,0.102,0.106,0.018,0.100,0.122,
0.128,0.151,0.100,0.166,1.700,1.230,1.090,1.410,0.115,0.125,
0.079,0.117,0.936,0.089,0.596,0.855,0.923,0.982,0.868,1.170,
1.570,0.959,0.951,1.500,1.390,1.330,0.981,1.330,1.400,0.104,
0.804,1.290,1.230,1.070,1.180,2.090,2.760,1.510,1.210,2.170,
1.320,0.942,0.860,1.120,1.320,0.108,0.718,1.160,1.930,1.190,
1.010,2.450,1.920,1.540,0.950,1.480,1.060,0.867,0.855,1.110,
0.925,0.079,0.812,1.260,1.150,1.080,0.897,1.580,1.510,0.956,
1.150,1.580,0.088,0.073,0.066,0.116,0.893,0.067,0.690,0.933,
1.060,0.985,1.020,1.480,1.970,0.853,1.110,1.900,1.250,0.981,
0.810,1.370,1.470,0.099,0.904,1.630,2.260,1.950,1.910,3.720,
5.870,2.620,1.900,4.140,1.800,1.250,0.937,1.560,2.010,0.187,
0.902,1.590,2.740,2.200,1.190,2.840,3.380,1.980,1.270,2.210,
1.590,1.040,0.977,1.220,1.900,0.151,0.996,1.390,2.100,1.730,
1.160,1.980,2.640,2.070,3.170,3.360,0.222,0.186,0.202,0.408,
1.390,0.123,0.744,1.050,1.260,1.540,0.935,1.700,3.360,1.760,
2.490,4.880,2.050,1.440,1.570,2.730,1.740,0.145,0.972,1.750,
2.690,1.850,1.950,5.280,0.388,0.234,0.133,0.275,0.179,0.152,
0.091,0.146,0.173,0.022,0.080,0.136,0.214,0.217,0.123,0.249,
0.274,0.200,0.103,0.168,0.161,0.139,0.094,0.111,0.175,0.021,
0.106,0.140,0.199,0.185,0.116,0.204,0.207,0.191,0.169,0.242,
0.017,0.020,0.017,0.028,0.149,0.018,0.090,0.119,0.137,0.175,
0.102,0.185,0.380,0.223,0.213,0.521,0.296,0.269,0.209,0.411,
0.191,0.019,0.114,0.199,0.285,0.232,0.199,0.478,2.340,1.290,
0.895,1.360,1.280,0.999,0.942,1.060,1.790,0.203,0.899,1.290,
1.560,1.300,1.100,1.880,0.168,0.140,0.073,0.118,0.090,0.092,
0.073,0.074,0.136,0.018,0.079,0.100,0.180,0.171,0.105,0.167,
1.320,1.390,0.914,1.150,0.126,0.115,0.085,0.118,1.010,0.105,
0.460,0.672,0.761,0.927,0.716,1.070,1.460,1.110,0.927,1.340,
1.320,1.210,0.943,1.390,1.340,0.121,0.839,1.170,1.200,1.070,
1.110,1.870,2.360,1.160,0.919,1.730,1.160,0.722,0.686,0.848,
1.530,0.141,0.717,1.240,2.070,1.420,0.912,2.200,2.260,1.440,
0.946,1.560,1.290,0.999,0.843,0.920,1.420,0.108,0.906,1.330,
1.880,1.510,1.040,1.920,1.610,1.330,0.969,1.490,0.121,0.113,
0.079,0.127,1.170,0.094,0.745,1.070,1.150,1.290,0.987,1.660,
2.310,1.300,1.280,1.960,1.500,1.190,0.991,1.500,1.870,0.151,
1.240,1.900,2.570,2.000,1.940,3.790,8.140,3.410,2.820,6.580,
2.470,1.440,1.340,1.910,2.790,0.210,1.230,2.140,4.990,2.830,
2.050,5.180,3.170,1.540,1.210,2.380,1.480,0.799,0.826,1.180,
1.750,0.113,0.871,1.370,2.190,1.340,1.140,2.230,3.440,2.100,
2.850,4.630,0.238,0.165,0.173,0.457,1.880,0.131,1.170,1.680,
2.020,1.690,1.300,2.720,6.900,2.890,4.220,14.0,3.240,1.880,
2.220,4.930,2.740,0.181,1.640,2.930,5.170,2.740,3.190,9.450,
4.590,2.210,1.490,3.160,2.050,1.320,0.932,1.460,2.050,0.147,
0.941,1.630,2.260,1.710,1.220,2.540,2.790,1.450,0.896,1.620,
1.410,0.951,0.735,1.000,1.610,0.116,0.873,1.390,1.680,1.340,
0.894,1.680,2.460,1.710,1.460,2.690,0.134,0.122,0.092,0.208,
1.760,0.114,0.864,1.420,1.620,1.570,1.040,2.090,3.470,1.700,
1.840,4.580,2.280,1.670,1.480,3.070,1.990,0.114,1.030,1.920,
2.640,1.940,1.750,3.960,3.150,1.640,1.260,2.210,2.000,1.190,
1.100,1.650,2.340,0.203,1.150,1.820,2.180,1.580,1.530,2.820,
0.198,0.144,0.093,0.182,0.109,0.101,0.094,0.111,0.170,0.018,
0.097,0.148,0.193,0.180,0.120,0.219,1.950,1.680,1.250,1.960,
0.117,0.100,0.085,0.163,1.500,0.132,0.866,1.360,1.320,1.430,
1.210,2.060,2.180,1.350,1.370,2.470,2.120,1.480,1.420,2.290,
2.100,0.134,1.270,2.110,2.100,1.620,2.010,3.470,5.750,2.390,
2.210,4.610,2.350,1.370,1.430,1.880,2.830,0.212,1.290,2.320,
4.410,2.460,2.140,5.530,2.960,1.720,1.310,2.440,1.690,1.140,
1.200,1.480,1.870,0.112,1.200,1.950,2.410,1.840,1.480,3.020,
3.270,2.430,2.070,3.550,0.198,0.149,0.127,0.257,2.630,0.160,
1.470,2.380,2.890,2.730,2.230,3.770,6.750,3.080,3.350,7.550,
3.970,2.820,2.800,4.600,4.770,0.236,2.900,5.230,9.220,5.490,
5.980,10.8,7.150,4.180,3.620,6.210,3.970,2.300,1.990,2.530,
3.430,0.329,1.660,2.620,5.150,3.700,2.450,4.190,4.550,2.520,
1.940,2.570,2.590,1.600,1.470,1.580,2.230,0.202,1.530,1.890,
2.080,1.800,1.640,2.290,2.880,1.970,1.670,2.530,0.277,0.189,
0.167,0.297,1.630,0.145,0.907,1.260,1.610,1.590,1.390,1.980,
4.270,1.890,1.740,3.540,4.220,2.280,1.700,2.570,2.080,0.166,
1.200,1.920,3.010,1.800,2.080,4.140,5.080,2.660,2.060,2.970,
2.640,1.670,1.250,1.580,2.120,0.231,1.130,1.660,2.320,2.030,
1.460,2.530,3.500,1.900,1.380,1.820,1.840,1.130,1.180,1.270,
1.830,0.186,1.290,1.650,1.430,1.350,1.330,1.600,1.950,1.630,
1.090,1.560,0.195,0.147,0.132,0.176,3.190,0.271,0.928,1.210,
1.330,1.580,1.200,1.450,1.910,1.140,0.815,1.450,2.010,1.290,
0.902,1.410,1.630,0.117,0.842,1.280,1.650,1.240,1.390,2.460,
3.160,1.590,1.320,2.000,2.460,1.550,1.470,1.730,2.000,0.251,
1.020,1.440,1.880,1.710,1.380,2.680,0.238,0.201,0.137,0.217,
0.186,0.184,0.155,0.184,0.161,0.033,0.133,0.171,0.182,0.260,
0.175,0.267,1.480,1.230,1.100,1.310,0.145,0.114,0.116,0.172,
1.360,0.136,0.771,1.040,1.070,1.240,1.240,1.630,1.570,0.913,
0.905,1.530,1.800,1.320,1.210,1.750,1.630,0.150,1.050,1.440,
1.590,1.480,1.670,2.740,3.810,1.370,1.220,2.660,1.730,0.959,
0.971,1.350,1.830,0.196,0.869,1.400,2.350,1.630,1.200,2.810,
2.810,1.750,1.390,2.420,1.840,1.400,1.320,1.710,1.520,0.150,
1.160,1.730,1.630,1.690,1.350,2.310,1.710,1.290,1.240,1.900,
0.142,0.102,0.146,0.203,1.440,0.162,0.832,1.220,1.230,1.470,
1.470,1.810,2.400,1.200,1.200,2.540,1.460,1.010,1.080,1.640,
1.990,0.149,1.410,2.150,2.760,2.120,2.480,4.570,5.140,3.090,
2.300,3.800,2.880,2.080,1.580,1.820,2.080,0.221,1.050,1.540,
2.720,2.300,1.700,2.640,3.520,2.340,1.530,2.030,2.170,1.640,
1.510,1.500,1.610,0.201,1.200,1.630,1.270,1.460,1.510,1.810,
1.690,1.520,1.330,1.680,0.170,0.190,0.143,0.206,1.020,0.116,
0.669,0.828,1.170,1.160,0.993,1.390,2.110,1.190,1.050,1.950,
2.100,2.030,1.120,1.540,1.220,0.111,0.722,1.100,1.760,1.200,
1.320,2.570,3.370,2.390,1.330,2.080,2.310,2.080,1.180,1.410,
1.440,0.178,0.834,1.170,1.320,1.490,0.961,1.850,2.570,2.030,
1.130,1.490,1.610,0.744,1.110,1.280,1.410,0.215,1.030,1.380,
0.984,1.370,1.050,1.600,1.580,1.610,1.050,1.420,0.153,0.206,
0.137,0.184,1.270,0.186,0.760,1.010,0.832,1.450,1.020,1.360,
1.280,0.939,0.774,1.130,1.310,1.400,0.857,1.160,1.080,0.099,
0.665,1.020,1.000,1.000,0.886,1.770,2.730,1.510,1.140,1.560,
2.480,1.790,1.720,1.520,1.700,0.276,1.040,1.230,1.410,1.530,
1.220,2.050,0.294,0.239,0.132,0.197,0.221,0.278,0.279,0.193,
0.184,0.084,0.218,0.179,0.130,0.339,0.163,0.192,1.650,1.600,
1.260,1.430,0.184,0.226,0.171,0.193,1.240,0.176,0.921,1.090,
0.851,1.360,1.280,1.470,1.470,0.927,0.943,1.350,1.780,1.770,
1.590,1.670,1.600,0.155,1.130,1.420,1.360,1.400,1.690,2.370,
2.320,1.280,1.030,1.650,1.510,0.951,0.947,1.110,1.270,0.122,
0.710,1.020,1.520,1.120,0.934,1.950,2.410,1.650,1.260,1.730,
1.720,1.540,2.020,2.050,1.220,0.177,1.150,1.500,1.120,1.410,
1.100,1.610,1.220,1.180,0.991,1.280,0.093,0.099,0.088,0.126,
0.879,0.087,0.773,0.941,0.867,1.080,1.180,1.430,1.630,0.874,
0.882,1.450,1.140,0.991,0.864,1.220,1.270,0.101,0.931,1.500,
1.720,1.710,1.840,3.000,3.750,2.370,1.720,3.620,1.720,1.300,
0.957,1.370,1.590,0.171,0.843,1.220,1.880,1.700,1.130,2.050,
2.900,2.070,1.230,1.880,1.680,1.400,1.180,1.310,1.740,0.213,
1.490,1.600,1.430,1.890,1.140,1.740,1.640,1.810,2.040,2.130,
0.177,0.200,0.238,0.355,1.190,0.145,0.808,1.070,0.840,1.310,
0.890,1.390,1.880,1.210,1.280,2.630,1.580,1.290,1.480,2.160,
1.400,0.141,0.989,1.520,1.860,1.400,1.640,3.630,0.184,0.169,
0.093,0.160,0.151,0.169,0.099,0.121,0.116,0.023,0.085,0.108,
0.132,0.168,0.119,0.174,0.199,0.194,0.098,0.127,0.182,0.207,
0.146,0.142,0.163,0.045,0.174,0.165,0.135,0.213,0.116,0.158,
0.115,0.176,0.149,0.144,0.021,0.042,0.047,0.039,0.169,0.040,
0.122,0.154,0.090,0.170,0.125,0.147,0.166,0.124,0.102,0.226,
0.202,0.225,0.202,0.314,0.145,0.022,0.124,0.171,0.144,0.139,
0.151,0.265,2.100,1.620,1.060,1.410,1.570,1.720,1.380,1.420,
1.710,0.268,1.220,1.600,1.240,1.450,1.260,2.050,0.159,0.214,
0.099,0.133,0.125,0.210,0.160,0.128,0.149,0.039,0.161,0.169,
0.138,0.220,0.148,0.188,1.250,2.070,1.200,1.400,0.142,0.363,
0.167,0.203,1.270,0.203,0.779,1.050,0.753,1.360,1.080,1.440,
1.170,0.993,0.897,1.380,1.500,2.140,1.360,2.170,1.500,0.193,
1.260,1.580,1.170,1.250,1.530,2.350,2.120,1.420,0.939,1.740,
1.140,0.870,0.658,0.845,1.410,0.150,0.787,1.230,1.500,1.320,
1.010,2.040,2.260,2.010,1.150,1.700,1.730,1.810,1.420,1.390,
1.640,0.201,1.460,2.090,1.510,1.910,1.360,2.150,1.650,1.660,
1.200,1.590,0.120,0.148,0.119,0.158,1.270,0.147,1.030,1.330,
1.020,1.580,1.270,1.780,1.710,1.190,1.050,1.960,1.290,1.210,
0.997,1.520,1.680,0.150,1.600,2.090,2.070,1.940,2.150,3.520,
4.810,2.250,1.910,4.130,2.130,1.150,1.080,1.800,2.100,0.173,
1.000,1.700,2.740,1.860,1.480,3.160,2.430,1.280,0.966,1.620,
1.250,0.819,0.817,1.110,1.340,0.104,0.873,1.270,1.370,1.030,
0.925,1.600,2.030,1.460,1.370,2.330,0.143,0.114,0.107,0.277,
1.290,0.104,0.921,1.150,1.170,1.150,0.946,1.810,2.840,1.400,
1.840,4.290,1.730,1.110,1.240,2.960,1.810,0.129,1.100,1.950,
2.890,1.680,1.910,5.170,3.580,2.230,1.430,2.600,2.090,1.700,
1.310,1.600,1.930,0.197,1.220,1.930,2.020,1.920,1.280,2.460,
2.670,1.750,1.060,1.670,1.780,1.450,1.140,1.420,1.860,0.186,
1.410,1.980,1.700,1.630,1.190,1.790,1.790,1.740,1.320,2.060,
0.133,0.158,0.136,0.264,1.990,0.177,1.040,1.600,1.400,1.760,
1.230,2.030,2.110,1.310,1.320,2.950,1.970,1.700,1.620,3.750,
1.870,0.143,1.250,2.120,1.970,1.660,1.760,3.530,2.420,1.410,
1.100,1.720,1.820,1.370,1.270,1.650,1.910,0.222,1.210,1.760,
1.690,1.540,1.510,2.620,0.163,0.141,0.087,0.147,0.110,0.141,
0.138,0.130,0.112,0.020,0.120,0.139,0.136,0.175,0.128,0.193,
1.400,1.480,1.170,1.680,0.104,0.123,0.104,0.183,1.370,0.153,
1.050,1.410,1.090,1.450,1.370,2.130,1.560,1.070,1.120,1.870,
1.620,1.440,1.420,2.290,1.710,0.142,1.430,2.060,1.780,1.390,
2.120,3.420,3.580,1.800,1.550,2.840,1.620,1.100,1.140,1.340,
1.850,0.184,1.050,1.680,2.310,1.580,1.420,3.190,2.740,1.600,
1.170,1.830,1.550,1.260,1.540,1.510,1.420,0.121,1.420,1.740,
1.650,1.460,1.260,2.110,2.170,1.730,1.550,2.620,0.148,0.119,
0.110,0.215,1.760,0.141,1.300,1.830,1.850,1.960,1.990,2.850,
3.600,1.850,1.920,4.050,2.230,1.720,1.800,2.950,2.650,0.171,
2.170,3.470,4.470,3.060,3.910,5.400,3.840,2.470,2.280,3.970,
2.520,1.540,1.340,1.770,2.060,0.205,1.010,1.740,2.960,2.320,
1.520,2.770,2.550,1.450,1.140,1.590,1.590,0.966,0.979,1.240,
1.350,0.125,0.800,1.070,1.340,1.270,0.976,1.570,2.080,1.590,
1.100,1.890,0.175,0.125,0.100,0.219,1.140,0.104,0.726,1.080,
1.070,1.250,1.050,1.510,2.790,1.340,1.110,2.380,1.890,1.220,
0.961,1.720,1.650,0.109,0.767,1.210,1.890,1.170,1.310,2.750,
3.790,1.970,1.300,2.430,2.400,1.490,1.270,1.510,1.620,0.154,
0.742,1.210,1.630,1.450,1.050,1.830,2.400,1.480,0.884,1.280,
1.570,0.794,0.921,1.080,1.390,0.122,0.834,1.090,1.060,0.998,
0.713,1.100,1.840,1.690,1.090,1.620,0.179,0.157,0.130,0.198,
1.500,0.198,0.907,1.460,0.985,1.540,1.120,1.470,1.890,1.160,
0.752,1.490,1.870,1.440,0.989,1.600,1.410,0.104,0.730,1.260,
1.430,1.320,1.150,2.250,2.760,1.600,1.110,1.820,2.320,1.760,
1.650,1.780,2.190,0.257,1.120,1.550,1.880,1.800,1.420,2.570,
0.247,0.350,0.144,0.192,0.215,0.212,0.227,0.201,0.193,0.036,
0.280,0.210,0.238,0.357,0.214,0.314,1.570,1.350,1.480,1.690,
0.163,0.137,0.157,0.211,1.440,0.196,0.944,1.130,1.120,1.900,
1.440,1.560,1.480,0.926,0.876,1.400,1.920,1.500,1.420,1.830,
1.450,0.174,1.020,1.470,1.650,2.280,1.630,2.510,2.860,1.270,
1.030,2.060,1.430,0.915,1.100,1.190,1.530,0.154,0.792,1.260,
2.140,1.550,1.280,2.540,2.150,1.540,1.030,1.480,1.450,1.210,
1.280,1.310,1.290,0.118,1.200,1.390,1.490,1.450,1.310,1.970,
1.750,1.560,1.520,2.330,0.177,0.123,0.141,0.225,1.430,0.134,
1.130,1.530,1.480,1.740,1.850,2.220,2.340,1.380,1.240,2.600,
1.480,0.984,1.170,1.740,2.010,0.153,1.400,2.390,3.010,2.400,
2.680,4.870,0.258,0.184,0.144,0.213,0.184,0.150,0.114,0.147,
0.139,0.022,0.076,0.116,0.174,0.237,0.130,0.195,0.214,0.159,
0.225,0.164,0.173,0.142,0.166,0.148,0.135,0.025,0.109,0.118,
0.112,0.142,0.113,0.160,0.137,0.131,0.102,0.143,0.021,0.020,
0.018,0.025,0.103,0.018,0.076,0.105,0.080,0.121,0.098,0.142,
0.172,0.112,0.095,0.174,0.179,0.155,0.119,0.178,0.142,0.022,
0.092,0.133,0.147,0.149,0.143,0.268,0.200,0.152,0.089,0.142,
0.153,0.146,0.108,0.109,0.101,0.016,0.056,0.083,0.087,0.106,
0.085,0.125,0.175,0.169,0.098,0.109,0.178,0.156,0.141,0.136,
0.134,0.028,0.105,0.112,0.091,0.115,0.085,0.113,0.129,0.145,
0.097,0.129,0.020,0.030,0.025,0.024,0.148,0.041,0.107,0.144,
0.074,0.150,0.118,0.135,0.127,0.089,0.061,0.111,0.136,0.141,
0.099,0.130,0.110,0.013,0.070,0.104,0.093,0.113,0.093,0.169,
0.187,0.136,0.090,0.118,0.176,0.193,0.197,0.145,0.152,0.030,
0.209,0.141,0.114,0.160,0.134,0.180,0.019,0.032,0.020,0.020,
0.027,0.044,0.048,0.026,0.027,0.015,0.147,0.036,0.014,0.039,
0.033,0.025,0.163,0.159,0.179,0.192,0.027,0.035,0.042,0.031,
0.173,0.039,0.140,0.145,0.110,0.234,0.176,0.170,0.137,0.098,
0.096,0.132,0.194,0.218,0.176,0.192,0.159,0.038,0.140,0.164,
0.174,0.679,0.192,0.257,0.215,0.171,0.114,0.174,0.137,0.117,
0.117,0.119,0.131,0.017,0.097,0.119,0.181,0.177,0.145,0.262,
0.251,0.193,0.142,0.185,0.212,0.210,0.219,0.217,0.164,0.027,
0.285,0.194,0.165,0.227,0.186,0.251,0.149,0.148,0.149,0.205,
0.016,0.019,0.018,0.028,0.135,0.021,0.135,0.167,0.119,0.174,
0.194,0.225,0.189,0.131,0.111,0.204,0.142,0.128,0.115,0.175,
0.172,0.018,0.136,0.216,0.220,0.276,0.245,0.427,2.730,1.700,
1.430,2.280,1.630,1.170,0.907,1.270,1.360,0.123,0.767,1.090,
1.230,1.020,0.986,1.480,2.280,1.560,0.984,1.360,1.840,1.240,
1.330,1.310,1.640,0.170,1.300,1.320,1.040,1.310,1.050,1.480,
1.450,1.640,1.200,1.630,0.196,0.210,0.179,0.324,1.240,0.173,
1.310,1.300,0.794,1.350,1.060,1.400,1.460,0.909,0.824,1.530,
1.480,1.170,1.000,1.790,1.540,0.143,1.570,1.720,1.400,1.140,
1.730,2.740,0.182,0.146,0.083,0.135,0.165,0.168,0.118,0.128,
0.096,0.020,0.072,0.089,0.084,0.107,0.078,0.132,0.158,0.143,
0.071,0.091,0.199,0.147,0.137,0.118,0.120,0.030,0.150,0.124,
0.072,0.105,0.078,0.094,0.114,0.169,0.107,0.123,0.024,0.040,
0.032,0.032,0.135,0.045,0.280,0.228,0.069,0.149,0.122,0.130,
0.163,0.106,0.076,0.154,0.194,0.210,0.135,0.223,0.137,0.020,
0.145,0.195,0.114,0.118,0.133,0.228,2.020,1.270,1.040,1.110,
1.870,1.790,2.460,1.400,1.460,0.232,1.160,1.410,1.010,1.190,
1.300,1.890,0.161,0.187,0.107,0.108,0.168,0.226,0.223,0.120,
0.155,0.043,0.185,0.152,0.108,0.190,0.174,0.170,1.580,1.700,
1.360,1.480,0.173,0.195,0.216,0.194,1.290,0.186,0.609,0.909,
0.691,1.120,1.090,1.210,1.100,0.821,0.724,0.919,1.560,1.520,
1.370,1.390,1.290,0.167,1.400,1.370,0.998,1.170,1.480,1.870,
1.910,1.120,0.871,1.270,1.170,0.874,0.878,0.801,1.090,0.117,
0.744,1.000,1.030,0.941,0.812,1.480,1.880,1.520,1.060,1.240,
1.700,1.640,1.420,1.090,1.350,0.161,1.390,1.410,1.090,1.440,
1.320,1.540,1.590,1.660,1.460,1.700,0.142,0.168,0.156,0.183,
1.530,0.183,1.900,1.950,0.993,1.520,1.610,1.780,1.530,0.987,
0.897,1.400,1.370,1.190,1.110,1.390,1.770,0.156,1.720,1.930,
1.700,1.740,1.930,2.670,3.300,1.480,1.190,2.310,1.520,0.857,
0.771,1.150,1.350,0.122,0.650,1.060,1.680,1.250,1.060,2.050,
2.070,1.070,0.704,1.140,1.170,0.684,0.708,0.963,1.030,0.074,
0.620,0.882,0.909,0.829,0.724,1.200,1.730,1.260,0.848,1.560,
0.137,0.105,0.084,0.200,1.200,0.101,0.827,1.270,1.030,1.110,
0.982,1.640,2.270,1.160,0.973,2.150,1.460,0.925,0.817,1.580,
1.370,0.104,0.920,1.820,1.790,1.270,1.390,3.150,3.440,1.900,
1.200,2.130,2.030,1.460,1.170,1.430,1.580,0.145,0.892,1.320,
1.530,1.460,0.984,1.890,2.290,1.560,0.867,1.350,1.760,1.330,
1.220,1.380,1.400,0.118,1.110,1.420,1.000,1.100,0.841,1.320,
2.030,1.770,1.120,1.790,0.154,0.166,0.117,0.195,1.550,0.182,
1.350,1.900,1.120,1.670,1.300,2.010,2.610,1.430,1.100,1.990,
2.110,1.690,1.320,2.160,1.650,0.137,1.210,2.020,1.620,1.530,
1.480,2.900,3.540,1.520,1.160,1.740,2.220,1.670,2.010,1.850,
1.940,0.244,1.160,1.910,1.550,1.720,1.630,3.020,0.253,0.157,
0.124,0.153,0.167,0.193,0.443,0.184,0.124,0.030,0.157,0.222,
0.132,0.233,0.153,0.224,1.920,1.860,1.420,1.920,0.151,0.150,
0.197,0.217,1.800,0.224,1.280,1.790,1.220,1.870,1.580,2.150,
2.020,1.320,1.630,1.800,2.090,1.720,1.940,2.290,1.870,0.179,
1.690,2.640,1.730,1.730,2.200,3.220,3.010,1.350,1.160,1.950,
1.510,0.958,0.942,1.110,1.670,0.177,0.879,1.400,1.700,1.240,
1.100,2.560,2.290,1.380,0.986,1.510,1.680,1.320,1.490,1.350,
1.310,0.106,1.110,1.640,1.300,1.300,1.180,1.910,2.220,1.920,
1.580,2.360,0.162,0.142,0.125,0.215,2.000,0.170,1.810,2.450,
1.680,1.960,2.040,2.510,2.940,1.520,1.480,2.980,2.140,1.640,
1.750,2.540,2.470,0.162,2.140,3.340,3.120,2.480,3.090,4.630,
10.5,3.870,3.310,7.410,3.320,1.890,1.500,2.350,3.340,0.266,
1.360,2.410,5.480,3.910,2.120,4.690,3.560,1.770,1.210,1.990,
1.770,0.981,0.893,1.210,1.860,0.121,0.945,1.260,2.160,1.760,
1.160,2.080,2.670,1.740,1.320,2.670,0.196,0.134,0.108,0.264,
1.670,0.144,0.795,1.240,1.720,1.690,1.470,2.280,4.430,2.050,
1.790,4.300,2.610,1.490,1.330,2.410,2.100,0.139,1.160,1.970,
3.740,2.030,2.350,5.530,4.360,1.940,1.280,2.590,2.010,1.220,
0.886,1.260,1.520,0.141,0.653,1.160,1.770,1.380,0.901,2.000,
2.280,1.240,0.768,1.270,1.280,0.684,0.646,0.856,1.250,0.102,
0.638,0.930,1.230,0.933,0.729,1.260,1.840,1.390,0.886,1.670,
0.137,0.131,0.077,0.146,2.220,0.633,0.680,1.080,1.310,2.110,
0.928,1.450,1.850,1.050,0.769,1.580,1.470,0.997,0.736,1.230,
1.390,0.133,0.684,1.170,1.540,1.190,1.230,2.430,3.480,1.640,
1.160,2.200,2.440,3.330,1.260,1.880,1.990,0.227,0.700,1.390,
2.600,1.910,1.230,3.190,0.219,0.143,0.087,0.173,0.165,0.185,
0.106,0.166,0.145,0.015,0.084,0.143,0.265,0.244,0.124,0.306,
1.550,1.140,1.050,1.590,0.130,0.122,0.085,0.163,1.250,0.125,
0.579,0.996,1.240,1.320,1.130,1.670,1.840,1.000,0.985,1.960,
1.830,1.240,1.050,1.770,1.530,0.113,0.828,1.510,2.000,1.520,
1.540,3.210,5.410,1.950,1.650,3.950,2.130,1.600,1.250,1.810,
2.500,0.202,1.130,2.060,4.710,2.470,1.860,4.660,2.970,1.490,
1.160,1.970,1.560,1.090,0.956,1.340,1.730,0.107,0.997,1.700,
2.540,1.950,1.410,2.820,2.180,1.620,1.420,2.450,0.148,0.110,
0.100,0.200,1.720,0.140,1.120,1.810,1.990,2.120,2.120,3.100,
4.260,2.020,2.090,6.000,2.330,1.440,1.460,2.620,3.190,0.193,
1.900,3.390,5.460,3.740,4.450,10.000,4.220,2.230,1.590,3.310,
2.170,1.380,1.010,1.480,1.820,0.154,0.808,1.410,2.430,1.960,
1.420,2.700,2.450,1.440,1.070,1.690,1.480,1.010,1.020,1.100,
1.530,0.114,0.812,1.090,1.320,1.260,0.905,1.620,1.700,1.240,
0.861,1.600,0.123,0.111,0.077,0.162,1.030,0.091,0.568,0.924,
1.090,1.180,0.963,1.700,2.010,1.140,0.950,1.960,1.640,1.260,
0.846,1.450,1.240,0.108,0.717,1.300,1.810,1.560,1.470,3.470,
2.810,1.680,0.941,1.780,1.620,1.180,0.740,1.040,1.140,0.099,
0.491,0.893,1.250,1.100,0.753,1.620,1.750,1.200,0.611,1.060,
1.130,0.781,0.603,0.850,1.010,0.090,0.568,0.817,1.010,0.874,
0.621,1.130,1.440,1.170,0.708,1.330,0.104,0.101,0.071,0.119,
1.350,0.171,0.599,1.040,0.984,1.280,0.960,1.520,1.300,0.856,
0.647,1.220,1.230,1.020,0.656,1.080,1.030,0.080,0.567,1.090,
1.190,1.060,1.000,1.950,2.360,1.160,0.933,1.600,1.610,1.280,
1.150,1.490,1.330,0.161,0.796,1.380,1.480,1.400,1.000,2.340,
0.125,0.097,0.063,0.112,0.099,0.122,0.093,0.125,0.084,0.016,
0.164,0.117,0.118,0.161,0.093,0.165,1.600,1.220,1.010,1.460,
0.120,0.114,0.094,0.149,1.210,0.119,0.678,1.100,1.090,1.360,
1.100,1.750,1.620,0.953,0.890,1.660,1.720,1.600,1.220,1.770,
1.370,0.132,0.908,1.550,1.630,1.950,1.600,3.180,2.840,1.440,
1.090,2.150,1.420,0.975,0.880,1.180,1.560,0.139,0.817,1.360,
2.180,1.650,1.210,2.900,2.430,1.390,1.000,1.670,1.370,1.140,
0.953,1.520,1.260,0.114,1.050,1.470,1.620,1.720,1.190,2.250,
1.570,1.320,1.100,1.800,0.101,0.091,0.073,0.143,1.170,0.096,
0.904,1.370,1.280,1.380,1.380,2.360,2.370,1.220,1.180,2.370,
1.660,1.260,1.030,1.720,1.820,0.127,1.260,2.180,2.720,2.090,
2.440,5.190,4.250,2.520,1.940,3.670,2.270,1.580,1.120,1.760,
2.650,0.192,1.090,1.650,2.490,1.820,1.270,2.680,3.180,2.120,
1.250,2.070,2.100,1.420,1.140,1.420,2.150,0.174,1.430,1.670,
2.060,2.060,1.460,2.400,2.480,2.260,1.460,2.500,0.228,0.209,
0.156,0.335,1.680,0.161,0.997,1.450,1.450,1.930,1.540,2.270,
2.670,1.560,1.290,2.880,2.210,1.510,1.250,2.270,2.190,0.175,
1.600,2.360,2.670,2.060,3.550,5.330,0.235,0.181,0.116,0.223,
0.201,0.175,0.104,0.184,0.152,0.018,0.080,0.133,0.150,0.171,
0.103,0.252,0.183,0.159,0.079,0.129,0.192,0.164,0.101,0.131,
0.140,0.020,0.142,0.149,0.135,0.154,0.103,0.187,0.141,0.147,
0.083,0.147,0.017,0.022,0.016,0.023,0.145,0.028,0.109,0.146,
0.107,0.174,0.124,0.188,0.208,0.142,0.095,0.243,0.213,0.196,
0.121,0.245,0.163,0.019,0.116,0.202,0.197,0.184,0.211,0.395,
3.050,1.780,1.250,1.770,2.330,2.040,1.750,1.760,2.000,0.269,
1.150,1.930,1.750,1.950,1.570,3.500,0.168,0.157,0.085,0.134,
0.176,0.155,0.112,0.111,0.136,0.024,0.119,0.133,0.174,0.227,
0.168,0.264,1.800,2.070,1.580,1.940,0.164,0.187,0.147,0.204,
1.640,0.186,0.884,1.380,1.170,1.620,1.480,2.090,1.870,1.450,
1.140,1.770,2.110,2.100,1.490,1.890,2.010,0.195,1.620,2.160,
1.840,1.770,2.260,3.620,3.390,1.920,1.340,2.470,2.060,1.440,
1.080,1.520,1.970,0.177,1.310,1.920,2.140,1.720,1.350,3.130,
3.100,2.240,1.400,2.280,2.400,1.840,1.300,1.520,2.120,0.171,
1.710,2.130,2.310,2.440,1.850,3.130,2.420,2.310,1.710,2.630,
0.165,0.170,0.138,0.248,2.260,0.185,1.830,2.600,1.940,2.380,
2.350,3.220,2.850,1.770,1.570,2.680,1.960,1.690,1.430,2.010,
2.770,0.201,2.490,3.310,3.120,2.750,3.330,5.450,11.3,3.700,
2.610,6.080,3.120,1.770,1.380,2.460,3.110,0.230,1.450,2.430,
4.390,2.910,2.320,5.310,3.790,1.960,1.140,2.160,2.070,1.340,
0.957,1.580,2.040,0.128,1.070,1.620,1.990,1.630,1.210,2.420,
3.340,2.320,1.540,3.750,0.206,0.168,0.113,0.333,2.080,0.163,
1.190,1.960,2.250,2.340,1.700,3.430,5.100,2.600,2.130,5.720,
2.810,1.860,1.570,3.400,2.980,0.216,1.900,3.390,5.190,4.080,
3.880,11.3,5.270,2.700,1.880,3.540,2.780,1.940,1.320,2.000,
2.070,0.151,1.070,1.870,2.340,1.940,1.360,3.140,3.570,2.330,
1.110,2.090,2.490,2.370,1.120,1.880,1.910,0.134,1.210,1.880,
1.710,1.680,1.130,2.280,2.860,2.080,1.250,3.100,0.152,0.140,
0.083,0.230,2.040,0.171,1.200,2.050,1.940,2.240,1.570,3.160,
3.350,1.910,1.430,3.500,2.380,1.880,1.330,2.970,2.370,0.149,
1.450,2.640,3.030,2.650,2.300,5.550,5.460,2.600,2.040,3.160,
3.680,2.350,2.000,3.020,3.220,0.296,1.660,2.980,3.300,2.670,
2.450,5.370,0.238,0.196,0.106,0.194,0.186,0.173,0.144,0.187,
0.142,0.017,0.121,0.186,0.224,0.223,0.155,0.347,3.230,2.740,
1.980,3.350,0.192,0.171,0.139,0.289,2.810,0.229,1.960,2.800,
2.460,2.820,2.790,4.650,3.970,2.540,2.170,3.800,3.510,2.770,
2.440,4.170,3.810,0.242,2.820,4.450,3.940,3.010,4.160,7.300,
12.2,4.160,2.990,6.720,4.050,2.490,1.920,3.060,4.660,0.316,
2.110,3.840,6.520,4.120,3.270,9.840,5.250,3.180,1.840,3.550,
3.340,2.470,1.730,2.720,3.150,0.183,1.980,3.250,3.910,3.120,
2.440,5.680,4.970,3.840,2.750,5.220,0.232,0.204,0.148,0.361,
4.170,0.246,2.920,4.670,4.740,4.460,4.510,7.840,11.6,4.290,
3.400,9.190,4.060,2.930,2.940,6.250,5.610,0.296,3.990,7.880,
8.630,4.870,5.370,14.7,14.4,5.030,2.740,5.850,6.320,3.030,
2.370,3.080,5.210,0.491,1.840,3.070,6.970,4.760,2.890,4.550,
7.200,3.650,2.300,3.150,3.900,2.400,1.970,1.900,3.390,0.284,
1.690,2.160,2.650,2.300,1.700,2.680,5.150,3.860,2.490,3.880,
0.451,0.394,0.264,0.516,2.780,0.281,1.450,2.060,2.640,3.000,
1.760,2.720,6.880,2.990,2.820,5.830,4.630,3.130,2.490,4.370,
3.270,0.292,1.680,2.780,4.210,2.490,2.460,4.240,9.200,4.090,
2.180,3.580,4.660,2.850,1.820,2.010,2.980,0.332,1.230,1.880,
2.440,2.400,1.320,2.220,4.740,2.920,1.420,1.960,2.800,1.950,
1.330,1.370,2.390,0.261,1.220,1.620,1.480,1.570,0.977,1.460,
3.000,2.810,1.450,2.070,0.259,0.251,0.168,0.232,2.080,0.233,
1.150,1.610,1.350,1.940,1.200,1.770,2.500,1.620,1.050,1.830,
2.460,1.830,1.200,1.650,1.990,0.165,1.030,1.580,1.770,1.460,
1.390,2.510,4.770,2.170,1.690,2.510,3.650,2.130,1.760,1.880,
2.710,0.324,1.170,1.980,2.130,1.900,1.470,2.720,0.379,0.275,
0.156,0.238,0.351,0.326,0.189,0.200,0.267,0.051,0.186,0.259,
0.278,0.378,0.216,0.339,2.250,1.950,1.490,1.770,0.275,0.193,
0.179,0.229,1.650,0.205,1.190,1.460,1.120,1.530,1.260,1.400,
2.040,1.280,1.120,1.820,3.230,1.950,1.550,1.900,1.960,0.193,
1.320,1.870,1.710,1.560,1.590,2.380,7.210,2.820,2.100,4.520,
3.060,1.620,1.380,1.790,3.180,0.347,1.270,2.170,3.560,2.490,
1.900,4.310,4.530,2.750,1.820,2.590,3.010,2.160,1.540,1.690,
2.900,0.224,1.500,2.290,2.740,2.610,1.880,3.070,2.630,2.240,
1.610,2.290,0.254,0.194,0.166,0.231,1.890,0.161,1.110,1.760,
1.720,2.040,1.550,2.150,3.830,1.900,1.580,3.290,2.440,1.570,
1.320,1.980,2.730,0.194,1.520,2.720,3.270,2.460,2.230,4.040,
7.470,4.420,2.660,4.380,3.710,2.620,1.680,1.760,2.280,0.275,
1.020,1.710,2.390,2.510,1.500,2.460,4.210,3.230,1.760,2.180,
3.180,2.230,1.670,1.570,2.020,0.252,1.210,1.690,1.360,1.620,
1.100,1.720,2.470,2.820,1.520,2.180,0.291,0.328,0.208,0.282,
1.300,0.162,0.902,1.180,1.050,1.590,1.030,1.650,2.330,1.260,
1.130,1.940,2.330,1.960,1.260,1.610,1.340,0.145,0.740,1.170,
1.500,1.080,1.170,2.170,5.090,4.280,1.570,2.330,3.330,2.960,
1.550,1.420,1.850,0.272,0.825,1.200,1.370,1.810,0.865,1.420,
3.100,2.690,1.200,1.430,2.340,1.390,1.390,1.220,1.670,0.262,
1.000,1.350,0.944,1.340,0.776,1.000,2.030,2.790,1.140,1.480,
0.255,0.399,0.203,0.196,1.500,0.294,0.913,1.290,0.853,1.950,
1.000,1.490,1.460,1.170,0.643,1.030,1.830,1.910,0.955,1.090,
1.300,0.148,0.644,1.030,0.929,1.010,0.776,1.450,2.670,1.850,
1.120,1.580,2.790,2.320,1.760,1.470,1.670,0.237,0.838,1.280,
1.160,1.360,1.030,1.690,0.194,0.249,0.121,0.161,0.248,0.365,
0.220,0.154,0.178,0.063,0.154,0.197,0.116,0.224,0.133,0.178,
1.820,2.460,1.430,1.580,0.274,0.322,0.235,0.223,1.590,0.234,
1.110,1.350,0.831,1.600,1.300,1.400,1.240,0.913,0.749,1.080,
2.060,2.100,1.510,1.500,1.450,0.163,0.993,1.450,1.080,1.090,
1.280,1.770,2.420,1.200,0.935,1.500,1.640,1.140,0.793,0.891,
1.250,0.125,0.535,0.934,1.280,1.040,0.744,1.570,2.090,1.820,
1.190,1.500,1.730,1.850,1.140,1.190,1.250,0.144,0.840,1.340,
0.952,1.360,0.939,1.470,1.640,1.980,1.240,1.530,0.173,0.198,
0.116,0.159,1.400,0.140,0.890,1.330,0.971,1.470,1.120,1.540,
1.700,1.060,0.927,1.400,1.420,1.280,0.960,1.210,1.560,0.162,
0.947,1.650,1.680,1.640,1.570,2.400,3.460,2.270,1.420,2.330,
1.830,1.300,0.857,1.160,1.480,0.173,0.681,1.150,1.490,1.480,
0.794,1.640,2.750,2.050,1.260,1.490,1.620,1.240,0.972,0.967,
1.760,0.208,0.998,1.210,1.070,1.490,0.739,1.260,1.680,2.170,
1.270,1.710,0.215,0.276,0.182,0.300,1.150,0.153,0.645,1.050,
0.897,1.510,0.826,1.600,1.660,1.060,0.949,1.590,1.450,1.370,
1.000,1.430,1.360,0.153,0.791,1.370,1.390,1.090,1.420,2.980,
0.254,0.218,0.139,0.205,0.261,0.223,0.121,0.136,0.139,0.030,
0.082,0.117,0.115,0.170,0.091,0.152,0.224,0.205,0.119,0.130,
0.203,0.212,0.134,0.112,0.167,0.050,0.124,0.146,0.099,0.184,
0.079,0.117,0.140,0.251,0.123,0.143,0.033,0.066,0.043,0.032,
0.155,0.046,0.113,0.162,0.103,0.229,0.116,0.189,0.196,0.133,
0.102,0.182,0.260,0.320,0.205,0.239,0.174,0.027,0.127,0.181,
0.161,0.157,0.173,0.301,1.640,1.160,0.735,1.000,1.420,1.350,
0.878,0.838,1.320,0.214,0.914,1.190,0.760,0.971,0.702,0.993,
0.158,0.187,0.079,0.088,0.134,0.190,0.116,0.082,0.140,0.045,
0.125,0.136,0.102,0.182,0.093,0.112,1.100,1.940,0.851,0.834,
0.166,0.414,0.134,0.133,1.050,0.205,0.545,0.793,0.586,1.170,
0.726,0.784,0.879,0.704,0.503,0.620,1.130,1.480,0.815,0.929,
1.090,0.148,0.771,0.980,0.646,0.872,0.767,0.915,1.750,0.936,
0.637,1.220,1.210,0.742,0.464,0.626,1.160,0.123,0.557,0.850,
1.030,0.864,0.572,1.190,2.110,1.580,0.859,1.090,1.520,1.390,
0.843,0.837,1.270,0.163,0.876,1.210,1.110,1.480,0.799,1.170,
1.420,1.690,1.050,1.300,0.157,0.233,0.116,0.158,1.200,0.162,
0.869,1.700,0.914,1.480,1.050,1.440,1.520,0.847,0.811,1.010,
1.360,1.280,0.822,1.040,1.440,0.152,1.150,1.520,1.420,1.440,
1.350,1.970,4.960,2.540,1.820,3.890,2.010,1.180,0.938,1.390,
1.680,0.182,0.732,1.360,2.610,1.950,1.170,2.630,2.360,1.390,
0.933,1.360,1.310,0.826,0.661,0.789,1.270,0.121,0.704,1.140,
1.150,1.160,0.666,1.260,1.810,1.650,0.983,1.790,0.166,0.145,
0.099,0.216,1.030,0.100,0.487,0.944,1.230,1.150,0.708,1.450,
2.570,1.320,1.290,2.830,1.710,1.240,1.020,1.800,1.480,0.123,
0.897,1.600,2.350,1.480,1.680,3.950,3.620,2.340,1.430,3.450,
2.510,1.740,1.110,1.630,1.680,0.193,0.808,1.520,1.460,1.590,
0.875,1.700,2.490,1.720,0.957,1.650,1.810,1.410,0.840,1.020,
1.460,0.251,0.857,1.530,1.050,1.380,0.652,1.190,1.650,1.730,
0.875,1.480,0.137,0.167,0.099,0.161,1.310,0.150,0.742,1.280,
1.040,1.470,0.863,1.630,1.970,1.070,0.851,1.690,1.830,1.650,
1.060,1.750,1.520,0.126,0.886,1.470,1.490,1.280,1.410,2.470,
1.980,1.170,0.913,1.420,1.800,1.200,0.914,1.210,1.550,0.217,
0.993,1.670,1.270,1.300,1.010,1.600,0.177,0.137,0.079,0.139,
0.135,0.149,0.100,0.108,0.131,0.031,0.150,0.482,0.127,0.174,
0.099,0.186,1.260,1.540,0.877,1.160,0.127,0.153,0.092,0.144,
1.280,0.146,0.666,1.040,0.913,1.300,0.915,1.190,1.330,0.890,
0.815,1.180,1.590,1.310,1.130,1.520,1.540,0.141,0.928,1.520,
1.140,1.130,1.140,1.690,3.190,1.460,1.120,2.230,1.680,1.030,
0.811,1.080,1.860,0.167,0.784,1.350,2.060,1.450,1.190,2.660,
1.900,1.230,0.764,1.200,1.320,1.040,0.764,0.935,1.240,0.104,
0.839,1.710,1.430,1.340,0.897,1.650,2.040,1.990,1.200,1.830,
0.198,0.162,0.095,0.170,1.700,0.139,1.020,1.680,1.720,1.950,
1.440,2.090,2.710,1.510,1.250,2.620,2.240,1.810,1.250,1.950,
2.490,0.160,1.600,2.640,3.450,2.410,2.350,4.070,6.550,4.160,
2.840,4.770,5.070,3.240,2.020,2.390,3.180,0.398,1.560,2.320,
3.600,3.270,1.800,2.890,3.750,3.320,1.740,2.060,3.300,2.620,
1.720,1.650,2.420,0.311,1.610,1.770,1.510,1.890,1.300,1.790,
2.070,2.350,1.470,1.850,0.250,0.276,0.190,0.276,1.540,0.199,
0.933,1.110,1.160,1.670,1.190,1.560,2.460,1.420,1.070,2.060,
2.500,2.090,1.240,1.890,1.800,0.373,0.992,1.510,1.850,1.540,
1.460,2.480,5.250,3.560,1.510,2.430,7.600,3.390,1.610,1.710,
2.480,0.364,1.150,1.550,1.550,2.170,0.972,1.770,3.190,3.050,
1.230,1.590,2.930,2.080,1.350,1.370,2.060,0.388,1.540,1.780,
1.110,1.760,0.943,1.430,1.620,2.150,0.992,1.170,0.290,0.279,
0.205,0.186,1.570,0.278,1.020,1.170,0.917,1.850,1.090,1.280,
1.300,1.090,0.531,0.891,1.800,1.640,0.789,1.120,1.250,0.155,
0.784,1.080,1.000,1.110,1.010,1.690,2.450,1.790,0.916,1.370,
3.840,2.900,1.420,1.590,2.090,0.329,0.976,1.260,1.220,1.390,
0.936,1.630,0.262,0.360,0.133,0.192,0.639,0.700,0.230,0.244,
0.236,0.086,0.204,0.240,0.159,0.323,0.154,0.219,1.290,2.160,
1.080,1.170,0.232,0.233,0.153,0.205,1.320,0.237,1.120,1.510,
0.730,1.320,0.991,1.110,0.974,0.898,0.673,0.944,1.790,1.720,
1.000,1.340,1.350,0.213,1.230,1.430,1.000,1.210,1.120,1.600,
2.510,1.370,0.923,2.020,1.600,1.160,0.661,0.887,1.420,0.197,
0.754,1.060,1.420,1.110,0.844,1.800,2.420,2.200,1.170,1.740,
2.570,2.590,1.230,1.360,1.440,0.205,1.070,1.460,1.070,1.540,
0.950,1.500,1.210,1.360,1.030,1.340,0.236,0.153,0.240,0.226,
0.998,0.147,0.700,1.060,0.780,1.340,0.827,1.190,1.580,1.020,
0.919,1.530,1.210,1.080,0.890,1.140,1.400,0.151,0.960,1.560,
1.680,1.850,1.490,2.700,4.310,3.230,2.120,2.820,3.800,3.340,
1.870,1.880,1.700,0.265,0.906,1.370,1.490,1.710,1.040,1.660,
2.990,3.020,1.490,1.560,3.650,3.020,1.980,1.710,1.710,0.352,
1.350,1.600,0.875,1.420,0.920,1.230,1.420,2.080,1.320,1.340,
0.249,0.332,0.248,0.243,0.963,0.177,0.840,0.886,0.657,1.260,
0.915,1.160,1.260,0.807,0.670,1.120,1.690,1.800,1.070,1.320,
1.120,0.183,0.678,0.871,1.160,0.924,0.893,1.570,3.000,2.960,
1.120,1.430,3.360,3.870,1.490,1.350,1.520,0.288,0.859,1.030,
0.886,1.430,0.662,0.994,2.270,2.610,1.150,1.080,1.680,0.892,
1.270,1.060,1.550,0.464,1.240,1.540,0.643,1.460,0.779,0.879,
1.260,2.450,0.970,1.060,0.256,0.507,0.274,0.215,1.170,0.308,
0.920,1.140,0.595,1.730,1.100,1.170,0.884,0.929,0.455,0.642,
1.450,2.110,0.889,1.070,0.964,0.164,0.777,1.060,0.657,0.887,
0.706,1.160,1.900,1.690,0.796,1.090,3.320,3.730,1.840,1.500,
1.530,0.312,0.894,1.070,0.838,1.250,0.921,1.240,0.206,0.395,
0.144,0.170,0.648,0.947,0.440,0.243,0.209,0.148,0.262,0.248,
0.096,0.306,0.157,0.153,1.690,2.580,1.300,1.240,0.627,0.563,
0.333,0.252,1.470,0.326,1.140,1.230,0.673,1.730,1.550,1.170,
0.938,0.829,0.668,0.784,2.790,2.920,2.030,1.680,1.440,0.217,
1.120,1.290,0.902,1.120,1.230,1.440,1.470,1.050,0.638,1.080,
1.400,1.310,0.616,0.685,0.868,0.110,0.477,0.638,0.797,0.797,
0.537,0.948,1.590,1.970,1.080,1.370,2.090,3.050,1.380,1.290,
0.938,0.197,0.874,1.120,0.576,1.220,0.781,1.020,1.140,1.920,
1.050,1.150,0.203,0.261,0.147,0.140,0.810,0.135,0.779,0.934,
0.559,1.110,0.956,1.060,1.120,0.815,0.629,0.880,1.160,1.290,
1.200,0.995,0.929,0.107,0.745,1.050,1.090,1.200,1.180,1.660,
2.260,1.900,1.020,1.530,2.240,1.460,0.864,1.130,1.140,0.161,
0.590,0.899,1.000,1.150,0.620,1.130,2.180,2.490,0.952,1.240,
2.030,2.050,1.240,1.300,1.660,0.351,1.370,1.530,0.817,1.550,
0.707,1.110,1.000,1.870,0.935,1.140,0.171,0.277,0.181,0.266,
0.940,0.196,0.727,1.150,0.567,1.290,0.682,1.220,0.886,0.703,
0.456,0.902,1.070,1.280,0.778,1.110,1.000,0.144,0.777,1.260,
0.848,0.785,0.860,1.860,0.254,0.180,0.084,0.119,0.617,0.350,
0.221,0.167,0.145,0.044,0.099,0.116,0.092,0.159,0.089,0.120,
0.172,0.282,0.103,0.114,0.318,0.431,0.237,0.190,0.196,0.140,
0.240,0.221,0.078,0.206,0.090,0.105,0.105,0.292,0.130,0.115,
0.065,0.163,0.130,0.054,0.169,0.113,0.192,0.225,0.081,0.247,
0.164,0.178,0.087,0.096,0.051,0.089,0.201,0.337,0.171,0.202,
0.121,0.038,0.135,0.173,0.085,0.109,0.114,0.179,1.530,1.590,
0.690,0.880,1.720,2.230,1.300,1.110,1.610,0.426,3.460,2.520,
0.728,1.260,0.970,1.120,0.168,0.488,0.118,0.116,0.235,0.505,
0.289,0.157,0.210,0.138,0.330,0.252,0.092,0.276,0.142,0.127,
1.040,2.730,1.070,0.941,0.220,0.453,0.254,0.193,1.380,0.401,
0.871,1.160,0.584,1.670,1.010,1.040,0.664,0.799,0.442,0.568,
1.300,2.160,1.110,1.210,1.470,0.280,1.240,1.250,0.648,1.030,
0.955,1.110,1.410,0.915,0.500,0.861,0.987,0.780,0.443,0.554,
0.860,0.128,0.649,0.801,0.737,0.851,0.501,0.977,1.740,2.150,
0.872,1.050,1.890,2.490,1.240,1.200,1.420,0.313,1.370,1.540,
0.876,1.690,0.915,1.150,1.140,1.910,0.975,1.070,0.153,0.246,
0.147,0.147,1.230,0.249,1.050,1.320,0.735,1.690,1.020,1.260,
0.826,0.723,0.567,0.813,0.945,1.170,0.817,0.898,1.190,0.158,
1.190,1.380,1.020,1.250,1.120,1.560,2.080,1.240,0.830,1.620,
1.340,0.834,0.565,0.932,0.949,0.106,0.412,0.897,1.130,0.861,
0.517,1.210,1.540,1.080,0.543,0.916,1.030,0.880,0.543,0.745,
0.819,0.104,0.535,1.450,0.673,0.679,0.409,0.838,0.849,1.010,
0.506,0.829,0.086,0.090,0.056,0.119,0.512,0.067,0.337,0.648,
0.502,0.640,0.401,0.772,1.030,0.617,0.479,1.080,0.794,0.679,
0.457,0.919,0.691,0.071,0.420,0.887,0.878,0.656,0.683,1.660,
2.100,1.490,0.807,1.420,2.430,1.690,1.110,1.290,1.270,0.180,
0.711,1.090,0.886,1.180,0.597,1.080,1.570,1.530,0.660,0.970,
1.650,1.760,0.961,1.070,1.160,0.204,0.854,1.220,0.745,1.220,
0.589,0.934,0.874,1.620,0.568,0.770,0.118,0.211,0.111,0.135,
0.845,0.157,0.650,0.984,0.612,1.210,0.668,1.050,0.801,0.675,
0.442,0.754,1.200,1.450,0.798,1.330,0.855,0.108,0.681,1.030,
0.768,0.853,0.789,1.470,1.350,1.010,0.584,0.876,1.580,1.460,
0.902,1.060,1.260,0.205,0.883,1.150,0.800,0.936,0.771,1.180,
0.105,0.140,0.056,0.089,0.151,0.253,0.126,0.106,0.100,0.036,
0.103,0.148,0.076,0.141,0.084,0.109,0.869,1.380,0.668,0.858,
0.135,0.165,0.104,0.136,1.070,0.191,0.747,1.000,0.632,1.210,
0.850,1.030,0.745,0.672,0.478,0.699,1.200,1.230,0.806,1.150,
1.320,0.259,0.909,1.240,0.788,1.000,0.963,1.300,1.680,0.971,
0.655,1.380,1.030,0.847,0.509,0.699,0.956,0.116,0.492,0.856,
0.891,0.755,0.597,1.340,1.440,1.160,0.582,0.962,1.250,1.330,
0.719,0.847,0.848,0.095,0.617,0.995,0.816,0.920,0.657,1.140,
1.590,1.390,0.800,1.170,0.358,0.130,0.087,0.129,1.130,0.134,
0.819,1.160,0.954,1.400,1.010,1.430,1.490,0.978,0.771,1.520,
1.790,1.430,0.966,1.290,1.580,0.185,1.180,1.880,1.890,1.690,
1.610,2.220,3.250,1.890,1.490,2.540,2.350,1.620,1.220,1.470,
1.640,0.211,0.824,1.140,2.060,1.860,0.966,1.690,1.840,1.450,
0.784,1.130,1.560,1.010,0.860,1.070,1.060,0.136,0.735,0.861,
0.828,0.980,0.691,1.030,1.200,1.240,0.785,1.170,0.148,0.136,
0.100,0.183,0.830,0.099,0.545,0.732,0.697,0.996,0.674,1.000,
1.580,0.822,0.671,1.330,1.430,1.080,0.769,1.160,0.869,0.094,
0.525,0.843,1.080,0.756,0.868,1.710,3.190,1.990,1.170,1.850,
2.820,2.040,1.950,2.210,1.910,0.259,0.779,1.070,1.240,1.520,
0.753,1.290,1.990,1.750,0.858,1.250,1.690,1.000,1.120,1.700,
1.530,0.270,0.863,1.110,0.806,1.200,0.643,0.907,1.430,1.750,
0.997,1.270,0.221,0.235,0.185,0.252,1.270,0.199,0.908,1.120,
0.716,1.390,0.897,1.120,1.160,0.778,0.503,0.928,1.610,1.430,
0.896,1.340,0.971,0.112,0.628,1.040,0.780,0.820,0.766,1.560,
2.110,1.100,0.730,1.190,2.460,1.710,1.510,1.400,2.240,0.301,
0.749,0.973,1.440,1.370,0.848,1.470,0.208,0.206,0.101,0.179,
0.268,0.272,0.188,0.216,0.233,0.060,0.150,0.167,0.179,0.350,
0.146,0.209,1.160,1.240,0.844,0.992,0.171,0.157,0.150,0.191,
0.971,0.166,0.667,0.777,0.581,1.100,0.748,0.878,0.891,0.587,
0.460,0.796,1.510,1.340,0.994,1.300,1.050,0.139,0.665,0.844,
0.864,0.932,0.864,1.300,1.980,0.865,0.625,1.320,1.130,0.700,
0.594,0.780,1.210,0.143,0.507,0.763,1.310,0.987,0.652,1.480,
1.660,1.210,0.729,1.210,1.350,1.020,0.823,0.991,1.120,0.135,
0.683,0.928,0.962,1.100,0.675,1.130,1.100,1.150,0.891,1.170,
0.134,0.115,0.111,0.167,0.966,0.111,0.630,0.905,0.830,1.200,
0.899,1.210,1.480,0.842,0.740,1.440,1.130,0.903,0.795,1.170,
1.330,0.133,0.903,1.480,2.040,1.800,1.750,3.200,0.213,0.167,
0.113,0.154,0.210,0.185,0.130,0.170,0.118,0.024,0.066,0.084,
0.125,0.166,0.078,0.118,0.210,0.198,0.118,0.149,0.272,0.223,
0.202,0.233,0.139,0.042,0.119,0.126,0.081,0.134,0.092,0.134,
0.125,0.198,0.098,0.128,0.049,0.047,0.033,0.037,0.100,0.024,
0.084,0.098,0.062,0.123,0.086,0.111,0.120,0.082,0.063,0.111,
0.195,0.197,0.122,0.148,0.102,0.016,0.073,0.096,0.099,0.080,
0.094,0.156,0.222,0.222,0.097,0.168,0.268,0.327,0.224,0.494,
0.162,0.060,0.078,0.111,0.088,0.182,0.079,0.118,0.237,0.300,
0.135,0.177,0.310,0.280,0.295,0.499,0.222,0.097,0.147,0.184,
0.081,0.202,0.101,0.152,0.142,0.263,0.136,0.141,0.055,0.108,
0.073,0.061,0.177,0.078,0.149,0.156,0.073,0.213,0.141,0.148,
0.111,0.094,0.056,0.090,0.208,0.265,0.162,0.186,0.122,0.024,
0.095,0.128,0.079,0.102,0.088,0.159,0.151,0.116,0.064,0.094,
0.240,0.270,0.208,0.152,0.176,0.052,0.097,0.095,0.085,0.141,
0.093,0.112,0.026,0.048,0.024,0.034,0.065,0.111,0.092,0.053,
0.054,0.055,0.063,0.047,0.014,0.052,0.033,0.026,0.134,0.212,
0.142,0.146,0.055,0.087,0.083,0.050,0.177,0.082,0.172,0.150,
0.070,0.221,0.149,0.127,0.096,0.077,0.063,0.089,0.226,0.287,
0.234,0.207,0.148,0.036,0.141,0.134,0.089,0.123,0.122,0.149,
0.165,0.124,0.075,0.118,0.136,0.113,0.079,0.102,0.114,0.018,
0.057,0.079,0.108,0.111,0.083,0.152,0.245,0.285,0.150,0.200,
0.289,0.314,0.229,0.232,0.208,0.052,0.160,0.189,0.130,0.245,
0.145,0.183,0.134,0.205,0.148,0.154,0.026,0.043,0.032,0.037,
0.147,0.033,0.129,0.150,0.097,0.182,0.143,0.161,0.156,0.114,
0.086,0.141,0.151,0.156,0.130,0.146,0.155,0.023,0.127,0.172,
0.181,0.192,0.195,0.300,1.510,1.030,0.668,1.110,1.100,1.010,
0.597,0.788,0.833,0.122,0.537,0.608,0.822,0.782,0.464,0.698,
1.220,1.160,0.613,0.767,1.180,0.998,0.897,0.781,1.060,0.192,
1.630,0.977,0.531,0.865,0.560,0.674,0.964,1.710,0.847,1.050,
0.179,0.227,0.167,0.245,0.863,0.148,0.684,0.806,0.499,1.010,
0.571,0.810,0.718,0.564,0.400,0.786,0.874,0.854,0.581,0.911,
0.763,0.105,0.685,0.848,0.626,0.567,0.615,1.190,0.126,0.127,
0.063,0.101,0.177,0.264,0.120,0.144,0.086,0.029,0.076,0.082,
0.060,0.093,0.046,0.075,0.115,0.139,0.060,0.074,0.161,0.170,
0.142,0.129,0.117,0.053,0.161,0.131,0.050,0.092,0.053,0.063,
0.088,0.196,0.100,0.103,0.035,0.077,0.057,0.041,0.115,0.051,
0.126,0.124,0.066,0.151,0.087,0.106,0.096,0.076,0.046,0.097,
0.166,0.220,0.127,0.180,0.099,0.022,0.105,0.132,0.065,0.076,
0.073,0.129,1.130,0.875,0.512,0.573,1.380,1.490,1.080,0.908,
1.020,0.216,0.768,0.758,0.512,0.731,0.606,0.688,0.117,0.180,
0.077,0.077,0.165,0.265,0.189,0.118,0.141,0.075,0.204,0.130,
0.060,0.153,0.098,0.089,0.976,1.430,0.866,0.966,0.190,0.266,
0.230,0.242,0.980,0.251,0.417,0.610,0.450,1.040,0.719,0.779,
0.601,0.469,0.375,0.573,1.130,1.270,0.965,1.520,0.928,0.182,
0.878,0.890,0.508,0.712,0.713,0.851,0.980,0.599,0.422,0.687,
0.729,0.565,0.384,0.482,0.627,0.087,0.398,0.564,0.507,0.492,
0.330,0.591,1.180,1.050,0.552,0.636,1.170,1.310,0.850,0.762,
0.923,0.165,0.954,0.919,0.578,0.957,0.623,0.675,1.050,1.540,
0.807,1.170,0.143,0.231,0.141,0.359,0.969,0.164,0.855,0.964,
0.609,1.160,0.825,0.926,0.743,0.570,0.409,0.678,1.010,1.100,
0.636,1.060,0.930,0.130,0.847,0.940,0.807,0.977,0.870,1.120,
1.540,0.915,0.575,1.180,1.000,0.628,0.421,0.615,0.780,0.090,
0.313,0.489,1.300,0.710,0.400,0.904,1.100,0.765,0.418,0.652,
0.693,0.515,0.368,0.487,0.532,0.063,0.451,0.513,0.435,0.469,
0.310,0.518,0.877,1.870,0.480,0.823,0.089,0.124,0.056,0.122,
0.513,0.076,0.290,0.485,0.534,0.667,0.399,0.678,1.020,0.820,
0.450,0.953,0.760,0.634,0.431,0.782,0.591,0.060,0.374,0.613,
0.836,0.585,0.611,1.350,1.810,1.290,0.709,1.360,1.480,1.460,
0.866,1.060,0.984,0.136,0.563,0.896,0.790,0.902,0.467,0.958,
1.380,1.300,0.591,0.978,1.280,1.160,0.842,1.060,0.970,0.147,
0.762,1.070,0.582,0.833,0.490,0.785,0.974,1.480,0.682,0.990,
0.115,0.190,0.114,0.161,0.842,0.135,0.676,1.000,0.619,1.110,
0.676,1.120,1.030,0.756,0.536,0.947,1.230,1.290,0.813,1.240,
0.890,0.096,0.677,1.040,0.746,0.801,0.681,1.300,1.440,1.060,
0.581,0.821,1.470,1.250,1.020,1.110,1.190,0.193,0.677,0.980,
0.721,0.833,0.666,1.060,0.148,0.144,0.066,0.101,0.161,0.228,
0.151,0.150,0.106,0.035,0.123,0.149,0.077,0.139,0.084,0.108,
1.110,1.440,0.824,1.280,0.139,0.174,0.141,0.352,1.050,0.174,
0.651,0.905,0.634,1.140,0.852,0.994,0.883,0.674,0.550,0.747,
1.320,1.230,1.070,1.550,1.030,0.124,0.865,1.030,0.778,0.886,
0.981,1.190,1.610,0.784,0.603,1.040,0.917,0.651,0.510,0.631,
0.954,0.137,0.475,0.816,0.701,0.585,0.477,1.120,1.400,1.030,
0.571,0.848,1.180,1.100,0.775,0.852,0.871,0.101,0.822,1.110,
0.747,0.804,0.653,0.970,1.400,1.520,0.883,1.370,0.142,0.163,
0.102,0.202,1.290,0.150,0.993,1.370,1.020,1.460,1.200,1.450,
1.560,0.889,0.712,1.430,1.410,1.440,0.982,1.370,1.400,0.120,
1.090,1.650,1.650,1.380,1.510,2.410,3.500,2.050,1.600,3.270,
2.310,1.340,0.992,1.380,1.860,0.183,0.742,1.280,2.740,2.170,
1.120,2.300,1.830,1.060,0.675,1.020,1.310,0.798,0.580,0.697,
1.040,0.086,0.536,0.683,0.914,0.857,0.491,0.856,1.240,1.080,
0.704,1.260,0.135,0.111,0.083,0.156,0.769,0.073,0.408,0.680,
0.832,0.947,0.599,1.110,2.280,1.090,0.912,1.840,1.570,1.100,
0.815,1.330,1.100,0.100,0.624,1.060,1.670,1.090,1.130,2.680,
2.160,1.110,0.691,1.260,1.460,0.848,0.639,0.846,0.958,0.105,
0.420,0.665,1.510,1.070,0.478,1.020,1.320,0.832,0.448,0.747,
0.832,0.468,0.412,0.629,0.713,0.072,0.356,0.528,0.649,0.598,
0.338,0.591,0.877,0.768,0.537,0.838,0.085,0.071,0.059,0.091,
0.640,0.058,0.317,0.497,0.583,0.695,0.465,0.784,0.946,0.522,
0.406,0.751,0.912,0.648,0.420,0.693,0.612,0.048,0.337,0.634,
0.669,0.607,0.535,1.260,1.850,0.883,0.625,1.170,1.600,0.931,
0.750,1.010,1.290,0.144,0.416,0.691,1.350,1.100,0.612,1.400,
0.159,0.105,0.068,0.133,0.158,0.118,0.083,0.130,0.115,0.016,
0.064,0.092,0.159,0.184,0.080,0.172,0.940,0.776,0.664,0.862,
0.091,0.069,0.061,0.102,0.680,0.071,0.338,0.530,0.560,0.722,
0.487,0.705,0.845,0.537,0.502,0.865,1.050,0.755,0.601,0.940,
0.829,0.083,0.473,0.719,0.828,0.794,0.688,1.300,2.400,0.915,
0.734,1.680,1.220,0.630,0.519,0.797,1.270,0.115,0.554,0.841,
2.180,1.260,0.826,2.020,1.500,0.891,0.662,1.110,1.070,0.728,
0.553,0.818,0.964,0.081,0.532,0.807,1.100,1.050,0.651,1.230,
1.030,0.861,0.733,1.040,0.096,0.074,0.066,0.104,0.875,0.067,
0.474,0.748,0.861,0.992,0.678,1.090,1.880,1.060,0.890,1.750,
1.250,0.914,0.712,1.170,1.420,0.114,0.879,1.460,2.380,1.980,
1.720,3.700,3.050,1.840,1.230,2.360,2.190,1.440,1.060,1.330,
1.390,0.175,0.613,0.994,1.680,1.800,0.852,1.610,2.440,1.470,
0.911,1.490,2.130,1.280,1.060,1.220,1.130,0.147,0.709,0.991,
0.919,1.090,0.684,1.130,1.360,1.540,0.849,1.420,0.191,0.185,
0.118,0.190,0.823,0.113,0.543,0.872,0.776,1.080,0.764,1.260,
1.480,0.912,0.685,1.310,1.830,1.420,0.888,1.260,0.931,0.094,
0.587,0.978,1.120,0.824,0.951,1.790,2.380,1.680,0.792,1.450,
2.070,1.730,1.070,1.580,1.200,0.185,0.462,0.759,1.140,1.710,
0.600,1.210,1.920,1.720,0.789,1.230,1.850,1.350,1.060,1.520,
1.220,0.204,0.676,0.964,0.764,1.170,0.608,0.934,1.180,1.580,
0.811,1.150,0.178,0.252,0.168,0.195,1.040,0.185,0.623,0.904,
0.765,1.330,0.838,1.310,0.982,0.794,0.471,0.887,1.380,1.510,
0.847,1.060,0.819,0.095,0.498,0.965,0.828,0.886,0.688,1.460,
1.590,0.945,0.534,0.948,1.580,1.230,0.950,1.060,1.020,0.170,
0.473,0.626,0.868,0.963,0.606,1.110,0.114,0.116,0.063,0.122,
0.162,0.193,0.134,0.141,0.107,0.039,0.092,0.111,0.091,0.177,
0.090,0.118,1.110,1.320,0.851,1.050,0.147,0.167,0.130,0.158,
1.070,0.165,0.635,0.854,0.628,1.180,0.812,1.020,0.970,0.635,
0.569,0.942,1.500,1.560,1.160,1.310,1.230,0.122,0.744,1.040,
0.886,0.872,0.939,1.460,1.490,0.813,0.597,1.110,0.974,0.723,
0.535,0.679,0.876,0.094,0.426,0.624,1.030,0.842,0.600,1.270,
1.540,1.260,0.786,1.280,1.470,1.300,0.959,1.090,1.030,0.144,
0.676,1.010,0.971,1.460,0.795,1.270,1.020,1.180,0.856,1.150,
0.107,0.121,0.082,0.113,0.923,0.099,0.642,0.920,0.762,1.110,
0.832,1.200,1.370,0.865,0.718,1.180,1.240,1.100,0.754,0.938,
1.220,0.113,0.815,1.240,1.490,1.390,1.310,2.250,1.430,1.090,
0.654,1.360,1.010,0.849,0.501,0.847,0.771,0.095,0.376,0.635,
0.921,0.816,0.444,0.928,1.290,1.120,0.517,0.917,1.010,0.808,
0.544,0.593,0.832,0.112,0.677,0.742,0.608,0.903,0.460,0.834,
1.010,1.350,0.819,1.130,0.252,0.183,0.150,0.214,0.739,0.110,
0.493,1.050,0.569,1.020,0.604,1.580,0.930,0.768,0.499,1.090,
1.000,0.998,0.667,1.050,0.875,0.101,0.582,1.050,0.947,0.774,
0.829,1.820,0.106,0.088,0.050,0.105,0.171,0.128,0.065,0.085,
0.068,0.015,0.045,0.066,0.078,0.094,0.064,0.111,0.088,0.094,
0.039,0.069,0.106,0.137,0.072,0.074,0.073,0.021,0.085,0.081,
0.049,0.084,0.046,0.073,0.075,0.123,0.105,0.098,0.023,0.037,
0.063,0.025,0.103,0.028,0.079,0.139,0.067,0.139,0.088,0.354,
0.086,0.077,0.049,0.102,0.127,0.168,0.134,0.145,0.088,0.013,
0.075,0.107,0.082,0.084,0.078,0.189,1.030,0.749,0.453,0.658,
0.970,0.992,0.703,0.750,0.781,0.147,0.866,0.703,0.528,0.707,
0.596,0.818,0.084,0.106,0.053,0.075,0.091,0.125,0.088,0.068,
0.091,0.036,0.295,0.107,0.063,0.123,0.091,0.086,0.766,1.180,
0.660,0.807,0.108,0.160,0.114,0.118,0.823,0.143,0.430,0.591,
0.466,0.928,0.618,0.861,0.662,0.528,0.396,0.574,0.949,1.040,
0.711,0.933,0.878,0.111,1.200,0.890,0.623,0.735,0.817,1.050,
1.020,0.607,0.413,0.786,0.730,0.575,0.384,0.511,0.629,0.072,
0.454,0.564,0.711,0.588,0.436,0.835,1.230,1.020,0.590,0.920,
0.971,1.050,0.650,0.685,0.859,0.116,0.970,0.888,0.737,1.040,
0.738,0.932,1.000,1.350,0.839,1.200,0.150,0.321,0.127,0.176,
0.904,0.129,0.656,0.964,0.789,1.160,0.857,1.200,0.920,0.702,
0.534,0.882,0.947,1.150,0.661,0.905,1.030,0.110,0.908,1.040,
1.050,1.150,1.120,1.630,3.000,1.420,0.914,2.350,1.230,0.781,
0.531,1.040,1.060,0.101,0.428,0.837,1.450,1.100,0.639,1.580,
1.410,0.967,0.486,0.936,0.912,0.652,0.419,0.641,0.745,0.072,
0.401,0.643,0.638,0.757,0.388,0.778,1.340,2.980,0.631,1.290,
0.103,0.167,0.056,0.141,0.648,0.099,0.344,0.676,0.681,0.836,
0.495,1.120,1.740,1.330,0.727,1.710,1.090,0.886,0.592,1.200,
0.927,0.082,0.625,1.230,1.540,1.010,1.070,2.900,1.540,0.912,
0.549,1.160,1.050,0.790,0.485,0.714,0.730,0.076,0.334,0.679,
0.766,0.753,0.429,1.230,1.180,0.887,0.431,0.853,0.837,0.709,
0.430,0.628,0.745,0.081,0.477,0.791,0.562,0.715,0.429,0.883,
0.868,1.060,0.536,0.924,0.068,0.090,0.078,0.095,0.679,0.078,
0.422,0.786,0.647,0.983,0.591,1.520,1.010,0.641,0.479,0.949,
1.010,0.849,0.602,0.981,0.769,0.064,0.505,0.876,0.859,0.799,
0.720,1.750,1.750,1.100,0.734,1.230,1.430,1.060,0.805,1.210,
1.140,0.146,0.647,0.932,1.020,0.998,0.854,1.540,0.132,0.118,
0.060,0.114,0.109,0.124,0.077,0.103,0.082,0.018,0.095,0.101,
0.088,0.137,0.077,0.136,1.240,1.390,0.864,1.420,0.110,0.111,
0.083,0.164,1.060,0.128,0.633,0.952,0.841,1.210,0.970,1.340,
1.350,0.903,0.802,1.130,1.650,1.280,1.020,1.480,1.440,0.151,
1.330,1.430,1.200,1.090,1.370,1.890,2.870,1.210,0.887,1.850,
1.320,0.968,0.680,0.963,1.310,0.117,0.644,1.130,1.780,1.270,
1.020,2.600,2.020,1.320,0.750,1.320,1.520,1.670,0.848,1.060,
1.360,0.110,0.860,1.280,1.250,1.270,0.887,1.710,1.950,1.890,
1.160,2.000,0.134,0.148,0.089,0.156,1.550,0.129,1.050,1.740,
1.650,1.900,1.620,2.490,3.130,1.600,1.290,2.850,2.040,1.650,
1.220,2.070,2.270,0.156,1.620,2.850,3.520,2.440,2.470,4.780,
6.680,3.210,2.290,3.920,3.780,2.730,1.890,2.160,3.430,0.394,
1.370,2.220,3.880,3.390,1.700,2.800,4.380,3.020,1.600,2.000,
3.250,2.410,1.590,1.430,2.240,0.269,1.280,1.510,1.530,1.790,
1.130,1.670,2.700,2.550,1.520,1.940,0.287,0.337,0.218,0.322,
1.770,0.258,0.989,1.220,1.440,2.470,1.180,1.730,3.480,1.800,
1.550,2.510,2.790,2.290,1.700,2.340,1.870,0.207,1.040,1.540,
2.270,1.650,1.530,2.560,4.910,3.130,1.470,2.340,3.370,2.930,
1.550,1.630,2.290,0.335,0.938,1.390,1.540,1.980,0.898,1.470,
4.190,3.320,1.250,1.600,2.970,2.500,1.430,1.300,2.140,0.392,
1.210,1.580,1.090,1.780,0.852,1.110,1.940,2.550,1.100,1.400,
0.229,0.376,0.203,0.198,2.010,0.374,1.250,1.380,0.995,2.160,
1.140,1.350,1.480,1.190,0.672,1.040,1.930,1.940,0.975,1.200,
1.590,0.195,0.998,1.140,1.180,1.250,1.060,1.590,2.090,1.230,
0.793,1.170,2.020,1.390,1.100,1.040,1.630,0.247,0.688,1.110,
1.140,1.180,0.808,1.370,0.197,0.196,0.091,0.129,0.208,0.226,
0.142,0.120,0.185,0.062,0.128,0.180,0.139,0.266,0.126,0.177,
1.230,1.270,0.847,0.817,0.151,0.177,0.143,0.129,1.110,0.203,
0.683,0.854,0.570,1.080,0.745,0.684,0.954,0.740,0.601,0.779,
1.460,1.350,0.925,1.050,1.250,0.166,0.790,1.100,0.963,1.060,
0.923,1.250,2.820,1.260,0.809,1.720,1.420,0.887,0.684,0.892,
1.480,0.150,0.542,1.080,1.630,1.200,0.861,1.970,2.270,1.690,
0.895,1.230,1.900,1.510,0.935,0.962,1.580,0.171,0.807,1.230,
1.190,1.490,0.877,1.420,1.350,1.280,0.919,1.150,0.169,0.147,
0.148,0.140,1.120,0.133,0.722,1.010,0.897,1.310,0.916,1.130,
1.660,1.080,0.955,1.490,1.230,1.110,0.896,1.100,1.630,0.180,
0.985,1.540,1.780,1.730,1.400,2.430,4.530,3.310,1.830,2.780,
2.820,2.800,1.630,1.520,1.660,0.268,0.884,1.280,1.520,2.070,
1.380,1.770,3.280,3.550,1.430,1.590,2.920,2.720,1.740,1.420,
1.620,0.309,1.080,1.320,0.919,1.500,0.881,1.190,1.530,2.590,
1.190,1.330,0.248,0.454,0.243,0.236,1.250,0.252,1.040,0.980,
0.749,1.570,0.932,1.190,1.590,1.060,0.761,1.090,1.890,2.100,
1.050,1.220,1.020,0.222,0.639,0.832,1.070,1.010,0.872,1.600,
3.310,3.510,1.120,1.530,2.880,4.040,1.580,1.290,1.520,0.353,
0.737,0.998,0.904,1.730,1.000,1.190,2.670,3.820,1.140,1.180,
2.690,2.170,1.760,1.300,1.780,0.508,0.980,1.280,0.780,1.840,
0.831,0.880,1.450,3.310,1.030,1.100,0.323,0.957,0.320,0.231,
2.040,0.829,1.170,1.390,0.854,3.370,1.120,1.240,1.180,1.180,
0.506,0.708,2.020,2.870,1.010,1.070,1.270,0.286,0.660,0.840,
0.829,1.550,0.697,1.110,1.490,1.340,0.606,0.874,1.940,2.200,
1.430,1.050,1.280,0.259,0.736,0.874,0.661,1.040,0.731,0.913,
0.146,0.311,0.101,0.127,0.238,0.493,0.287,0.146,0.249,0.159,
0.213,0.206,0.086,0.266,0.138,0.123,1.140,1.910,1.130,0.996,
0.250,0.465,0.320,0.199,1.530,0.376,1.130,1.190,0.562,1.630,
1.070,0.877,0.926,0.735,0.533,0.678,1.680,2.340,1.420,1.250,
1.390,0.231,1.000,1.170,0.812,1.110,0.934,1.150,1.210,0.847,
0.474,0.744,0.986,0.895,0.569,0.528,0.977,0.105,0.318,0.507,
0.682,0.657,0.451,0.807,1.350,1.660,0.755,0.896,1.460,1.910,
0.940,0.884,2.010,0.250,0.629,0.870,0.723,1.270,0.646,0.863,
0.918,1.490,0.790,0.862,0.123,0.238,0.121,0.113,0.975,0.183,
0.757,0.905,0.602,1.240,1.130,1.060,0.970,0.850,0.554,0.755,
1.020,1.320,0.672,0.834,1.510,0.384,0.783,1.050,1.120,1.740,
1.200,1.610,1.780,1.460,0.796,1.350,1.200,1.130,0.663,0.823,
0.911,0.129,0.442,0.761,0.827,0.961,0.497,0.933,1.810,2.090,
0.907,1.070,1.550,1.550,1.000,0.878,1.280,0.261,0.882,1.000,
0.682,1.360,0.655,0.860,1.270,2.140,1.020,1.140,0.188,0.311,
0.180,0.233,1.020,0.189,0.687,0.775,0.605,1.280,0.659,0.931,
1.020,0.764,0.535,0.865,1.160,1.230,0.674,0.888,0.909,0.133,
0.610,0.891,0.974,0.873,0.824,1.850,0.127,0.164,0.070,0.106,
0.172,0.295,0.115,0.103,0.137,0.048,0.081,0.093,0.075,0.157,
0.069,0.094,0.164,0.285,0.119,0.123,0.241,0.396,0.188,0.130,
0.181,0.101,0.163,0.161,0.072,0.231,0.096,0.097,0.106,0.285,
0.121,0.108,0.045,0.141,0.087,0.043,0.173,0.103,0.175,0.158,
0.076,0.288,0.124,0.125,0.102,0.107,0.059,0.096,0.220,0.387,
0.179,0.178,0.143,0.040,0.124,0.135,0.105,0.154,0.112,0.191,
0.847,0.781,0.396,0.520,1.040,1.110,0.777,0.583,1.240,0.217,
0.568,0.699,0.498,0.750,0.481,0.600,0.096,0.182,0.071,0.062,
0.121,0.217,0.139,0.072,0.137,0.075,0.113,0.121,0.066,0.182,
0.089,0.080,0.708,1.340,0.692,0.564,0.132,0.259,0.178,0.109,
1.020,0.263,0.567,0.804,0.421,1.140,0.732,0.619,0.526,0.484,
0.346,0.373,0.855,1.150,0.794,0.671,0.915,0.168,0.644,0.755,
0.472,0.755,0.568,0.664,0.896,0.631,0.347,0.749,0.769,0.564,
0.328,0.370,1.650,0.123,0.289,0.516,0.767,0.584,0.326,0.676,
1.160,1.220,0.575,0.632,1.150,1.280,0.748,0.646,1.040,0.174,
0.612,0.862,0.646,1.170,0.592,0.790,0.880,1.280,0.715,0.698,
0.165,0.227,0.123,0.104,1.040,0.174,0.681,0.865,0.613,1.310,
0.720,0.847,0.831,0.647,0.556,0.546,0.996,1.150,0.700,0.705,
1.180,0.162,0.907,1.110,0.923,1.300,0.901,1.320,2.080,1.350,
0.861,1.680,0.997,0.774,0.483,0.647,0.851,0.106,0.364,0.716,
1.200,1.000,0.574,1.330,1.150,0.903,0.463,0.795,0.819,0.611,
0.386,0.458,0.626,0.076,0.341,0.559,0.522,0.599,0.352,0.649,
1.090,1.070,0.531,0.935,0.100,0.106,0.061,0.123,0.627,0.075,
0.366,0.517,0.522,0.682,0.420,0.698,1.270,0.766,0.597,1.280,
1.020,0.824,0.530,0.877,0.772,0.080,0.549,0.763,1.260,0.902,
0.833,2.010,1.790,1.470,0.752,1.400,1.510,1.570,0.727,0.946,
1.170,0.170,0.543,0.909,0.878,1.210,0.534,0.965,1.540,1.810,
0.656,1.310,1.540,1.830,0.840,0.901,1.140,0.219,0.687,1.130,
0.670,1.260,0.572,0.878,0.956,1.420,0.563,0.818,0.112,0.223,
0.107,0.125,0.988,0.178,0.724,0.883,0.668,1.420,0.720,0.937,
0.825,0.697,0.438,0.751,1.220,1.520,0.730,1.060,0.891,0.113,
0.620,0.855,0.823,0.952,0.712,1.330,1.010,0.734,0.410,0.660,
0.980,0.847,0.566,0.634,1.090,0.266,0.700,1.240,0.677,0.870,
0.551,0.933,0.078,0.096,0.045,0.082,0.084,0.134,0.070,0.070,
0.100,0.040,0.108,0.311,0.066,0.131,0.066,0.118,0.667,0.946,
0.549,0.604,0.089,0.126,0.099,0.095,0.868,0.156,0.530,0.834,
0.477,0.958,0.680,0.736,0.597,0.524,0.374,0.510,0.933,0.932,
0.700,0.794,0.933,0.126,0.602,0.900,0.618,0.781,0.652,0.957,
1.890,0.871,0.501,1.010,1.020,0.771,0.407,0.595,2.890,0.187,
0.411,0.755,1.460,0.893,0.580,1.340,0.957,0.755,0.391,0.643,
0.926,0.820,0.497,0.631,0.915,0.091,0.476,1.140,0.663,0.808,
0.471,1.020,1.190,1.170,0.665,0.953,0.138,0.128,0.076,0.114,
1.120,0.118,0.670,1.000,0.852,1.280,0.898,1.180,1.410,0.916,
0.660,1.350,1.470,1.360,0.811,1.140,1.570,0.138,0.990,1.620,
1.890,1.650,1.460,2.700,4.090,2.660,1.690,2.790,2.830,2.610,
1.330,1.560,1.940,0.306,1.020,1.570,2.020,2.340,1.070,1.850,
2.990,2.750,1.310,1.660,2.970,3.020,1.570,1.410,1.840,0.329,
1.490,1.550,1.030,1.680,1.020,1.260,1.310,1.570,0.980,1.170,
0.163,0.236,0.158,0.205,1.000,0.188,0.800,0.789,0.697,1.240,
0.806,0.994,1.430,0.916,0.727,1.240,1.480,1.500,0.930,1.290,
0.960,0.140,0.680,0.918,1.080,0.969,0.944,1.530,3.310,2.610,
1.010,1.710,3.020,3.000,1.210,1.240,1.770,0.353,1.030,1.250,
1.090,1.740,0.658,1.110,2.760,3.190,1.140,1.820,3.370,3.460,
1.540,1.460,2.190,0.711,2.230,2.480,0.996,2.280,0.911,1.080,
1.090,2.000,0.842,0.894,0.217,0.446,0.252,0.184,1.460,0.412,
1.220,1.070,0.745,1.830,1.020,0.986,0.772,0.787,0.430,0.616,
1.350,1.810,0.758,0.938,0.987,0.179,0.698,0.855,0.743,0.953,
0.778,1.140,1.380,1.040,0.608,0.833,1.850,1.690,1.010,0.997,
1.590,0.273,0.708,0.901,0.762,1.040,0.636,1.080,0.127,0.207,
0.105,0.121,0.230,0.385,0.190,0.157,0.195,0.122,0.195,0.198,
0.096,0.279,0.125,0.147,0.687,1.120,0.869,0.675,0.137,0.219,
0.162,0.141,1.070,0.268,0.886,0.922,0.463,1.140,0.726,0.685,
0.565,0.577,1.030,0.689,1.030,1.270,0.798,0.963,0.983,0.199,
0.767,0.923,0.607,0.998,0.821,1.030,1.330,0.703,0.480,0.984,
0.861,0.674,0.379,0.519,0.941,0.104,0.361,0.565,0.853,0.747,
0.469,1.150,1.310,1.320,0.709,0.952,1.510,1.890,0.861,0.937,
1.080,0.190,0.751,1.070,0.632,1.220,0.596,0.944,0.612,0.819,
0.597,0.663,0.084,0.119,0.094,0.095,0.779,0.135,0.617,0.755,
0.505,0.936,0.606,0.728,0.920,0.791,1.720,1.170,0.693,0.885,
0.638,0.743,0.971,0.135,0.710,0.997,1.010,1.230,1.010,1.700,
3.270,2.290,1.260,1.830,2.270,2.650,1.290,1.190,1.130,0.198,
0.620,0.837,0.875,1.230,0.618,0.975,2.120,2.370,1.040,1.160,
2.360,3.450,1.700,1.340,1.250,0.348,1.030,1.130,0.583,1.300,
0.640,0.819,0.977,1.740,1.040,0.950,0.165,0.358,0.229,0.194,
0.809,0.216,0.880,0.741,0.495,1.100,0.724,0.816,0.826,0.642,
0.480,0.743,1.100,1.670,0.774,0.868,0.607,0.105,0.510,0.599,
0.760,0.682,0.597,1.000,2.140,1.730,0.600,0.796,1.370,2.210,
0.784,0.706,0.962,0.232,0.516,0.598,0.530,1.050,0.386,0.611,
0.931,0.875,0.424,0.524,0.447,0.869,0.409,0.451,0.740,0.437,
0.514,0.625,0.280,0.976,0.380,0.420,0.714,1.790,0.702,0.673,
0.197,0.903,0.347,0.211,0.903,0.383,0.697,0.816,0.414,1.610,
0.791,0.763,0.493,0.618,0.339,0.384,0.966,2.280,0.740,0.784,
0.669,0.178,0.554,0.702,0.477,0.853,0.477,0.654,1.020,1.040,
0.454,0.610,1.680,2.520,1.310,1.010,1.070,0.252,0.693,0.761,
0.512,0.947,0.616,0.770,0.114,0.314,0.114,0.123,0.321,1.210,
0.439,0.252,0.215,0.256,0.285,0.236,0.067,0.336,0.155,0.122,
0.818,1.660,0.926,0.790,0.239,0.595,0.362,0.216,1.080,0.342,
0.831,0.964,0.473,1.710,1.020,0.843,0.519,0.575,0.461,0.496,
1.360,2.510,1.530,1.240,1.090,0.225,1.050,1.030,0.597,0.962,
0.970,1.040,0.772,0.632,0.315,0.499,0.759,0.938,0.368,0.404,
0.712,0.093,0.295,0.367,0.460,0.529,0.298,0.531,0.900,1.480,
0.644,0.781,1.420,3.230,1.040,1.060,0.926,0.250,0.664,0.841,
0.428,1.240,0.602,0.689,0.564,1.220,0.644,0.633,0.100,0.279,
0.142,0.111,0.709,0.179,0.856,0.838,0.402,1.050,0.944,0.864,
0.584,0.620,0.422,0.537,0.680,1.340,0.582,0.717,0.738,0.125,
0.640,0.742,0.605,0.948,1.150,1.250,1.450,1.370,0.631,1.060,
1.270,1.370,0.621,0.996,1.170,0.149,0.443,0.620,0.659,0.890,
0.407,0.752,1.670,2.420,0.805,1.160,2.130,2.890,1.360,1.340,
1.480,0.400,1.360,1.340,0.644,1.640,0.648,0.857,0.830,1.760,
0.810,0.873,0.170,0.395,0.174,0.227,0.960,0.260,0.711,0.855,
0.501,1.340,0.595,0.742,0.641,0.661,0.347,0.690,0.988,1.700,
0.638,0.909,0.809,0.162,0.682,0.909,0.656,0.804,0.672,1.310,
0.117,0.163,0.061,0.092,0.235,0.459,0.182,0.157,0.256,0.067,
0.105,0.108,0.073,0.168,0.075,0.093,0.167,0.421,0.124,0.227,
0.441,1.290,0.465,0.278,0.261,0.315,0.360,0.281,0.081,0.349,
0.117,0.118,0.091,0.385,0.141,0.099,0.077,0.373,0.191,0.070,
0.202,0.209,0.279,0.241,0.075,0.359,0.172,0.117,0.063,0.130,
0.044,0.071,0.243,0.783,0.186,0.215,0.129,0.070,0.164,0.161,
0.071,0.141,0.098,0.138,0.883,1.060,0.443,0.530,1.300,2.070,
1.040,0.811,1.240,0.325,0.871,0.845,0.532,1.010,0.582,0.742,
0.114,0.355,0.112,0.091,0.226,0.752,0.333,0.164,0.237,0.215,
0.301,0.215,0.078,0.311,0.133,0.111,0.675,1.680,0.745,0.623,
0.173,0.445,0.247,0.157,1.140,0.384,0.659,0.907,0.462,1.550,
0.766,0.726,0.445,0.567,0.348,0.438,1.120,2.080,1.020,1.160,
1.220,0.297,1.070,1.110,0.513,1.010,0.770,0.934,0.748,0.610,
0.292,0.548,0.659,0.684,0.303,0.369,0.699,0.106,0.354,0.496,
0.475,0.580,0.299,0.645,1.200,1.870,0.707,0.751,1.760,2.900,
1.300,1.080,1.480,0.415,1.300,1.460,0.674,1.720,0.802,0.968,
0.969,1.630,0.768,0.707,0.124,0.312,0.154,0.121,1.190,0.313,
1.080,1.170,0.572,1.700,0.867,0.953,0.650,0.654,0.420,0.633,
0.755,1.280,0.648,0.763,1.100,0.186,1.140,1.210,0.789,1.300,
0.968,1.290,1.250,0.856,0.492,1.010,0.842,0.766,0.379,0.617,
0.648,0.084,0.311,0.558,0.664,0.646,0.323,0.855,1.050,1.010,
0.397,0.650,0.896,1.070,0.452,0.571,0.559,0.089,0.365,0.548,
0.406,0.584,0.270,0.514,0.719,0.839,0.430,0.733,0.071,0.103,
0.050,0.103,0.471,0.071,0.319,0.437,0.339,0.521,0.310,0.488,
0.666,0.498,0.331,0.870,0.604,0.685,0.334,0.693,0.508,0.058,
0.322,0.560,0.592,0.522,0.440,1.070,1.190,1.140,0.498,0.853,
1.370,1.850,0.830,0.917,1.230,0.198,0.620,0.815,0.664,1.080,
0.444,0.792,1.260,1.920,0.596,1.050,1.980,3.510,1.240,1.300,
1.180,0.324,0.919,1.150,0.646,1.430,0.612,0.811,0.624,1.440,
0.528,0.621,0.114,0.362,0.139,0.141,0.841,0.209,0.703,0.783,
0.500,1.310,0.660,0.703,0.465,0.556,0.337,0.533,0.985,1.860,
0.670,1.190,0.742,0.139,0.619,0.770,0.546,0.800,0.554,0.989,
0.855,0.721,0.371,0.505,1.100,1.290,0.750,0.723,0.988,0.193,
0.610,0.782,0.558,0.784,0.498,0.786,0.070,0.120,0.048,0.064,
0.112,0.333,0.132,0.094,0.097,0.061,0.109,0.122,0.055,0.146,
0.073,0.087,0.507,0.940,0.498,0.524,0.096,0.181,0.120,0.105,
0.938,0.242,0.816,0.946,0.468,1.140,0.708,0.751,0.437,0.482,
0.322,0.430,0.862,1.180,0.746,0.902,1.100,0.198,0.892,1.050,
0.578,0.934,0.747,1.000,0.970,0.620,0.334,0.661,0.659,0.693,
0.319,0.428,0.726,0.078,0.303,0.473,0.609,0.535,0.370,0.862,
0.851,0.814,0.364,0.563,0.936,1.460,0.595,0.686,0.714,0.106,
0.498,0.736,0.513,0.780,0.468,0.923,0.909,0.899,0.527,0.660,
0.106,0.119,0.070,0.100,0.804,0.123,0.702,0.831,0.561,1.010,
0.769,0.927,0.795,0.614,0.451,0.881,0.950,1.190,0.639,0.946,
1.200,0.139,0.882,1.310,1.180,1.300,1.200,1.820,2.170,1.610,
1.300,1.860,1.880,1.580,1.090,1.120,1.270,0.172,0.616,0.943,
1.420,1.360,0.793,1.310,1.710,1.670,0.833,0.976,1.520,1.190,
0.960,0.850,0.946,0.168,0.645,0.718,0.691,1.030,0.794,1.040,
1.100,1.340,0.710,1.090,0.133,0.146,0.110,0.166,0.761,0.115,
0.487,0.629,0.513,0.848,0.554,0.787,1.130,0.671,0.537,0.963,
1.100,0.974,0.699,0.935,0.670,0.078,0.431,0.612,0.854,0.625,
0.730,1.330,2.490,2.410,1.040,1.520,2.600,2.980,1.860,1.500,
1.430,0.270,0.627,0.777,0.946,1.410,0.752,1.040,2.350,3.340,
1.130,1.220,2.250,2.210,1.800,1.310,2.060,0.558,1.090,1.250,
0.875,1.970,0.831,0.914,1.260,2.290,1.040,1.230,0.236,0.452,
0.286,0.267,1.590,0.388,1.310,1.440,0.690,1.890,1.210,1.150,
0.884,0.800,0.455,0.749,1.470,1.830,0.995,1.190,0.914,0.139,
0.579,0.840,0.718,0.832,0.769,1.300,1.290,0.990,0.492,0.948,
1.890,1.560,1.150,1.150,1.680,0.358,0.550,0.739,1.140,1.410,
0.659,1.020,0.151,0.281,0.095,0.256,0.211,0.290,0.193,0.209,
0.276,0.116,0.131,0.149,0.160,0.457,0.155,0.176,0.858,1.160,
0.760,0.939,0.171,0.215,0.193,0.206,1.030,0.281,0.619,0.700,
0.524,1.330,0.737,0.776,0.662,0.497,0.364,0.636,1.190,1.360,
0.991,1.200,0.969,0.161,0.565,0.702,0.717,0.815,0.708,1.050,
1.240,0.718,0.413,0.843,0.811,0.578,0.470,0.584,0.799,0.110,
0.308,0.468,0.996,0.837,0.489,1.040,1.210,1.670,0.595,1.020,
1.110,1.130,0.851,1.060,1.200,0.260,0.556,0.757,0.789,1.400,
0.670,0.933,0.764,1.020,0.779,0.930,0.108,0.134,0.127,0.157,
0.917,0.151,0.694,0.874,0.672,1.240,0.902,1.030,0.949,0.692,
0.545,0.990,0.829,0.793,0.710,0.944,1.080,0.141,0.769,1.090,
1.370,1.440,1.290,2.090,0.137,0.161,0.181,0.116,0.147,0.231,
0.125,0.106,0.089,0.030,0.056,0.066,0.069,0.120,0.074,0.090,
0.197,0.302,0.169,0.140,0.302,0.390,0.321,0.191,0.180,0.111,
0.159,0.136,0.077,0.215,0.118,0.106,0.115,0.362,0.108,0.101,
0.039,0.082,0.054,0.035,0.100,0.051,0.112,0.100,0.047,0.141,
0.093,0.095,0.086,0.084,0.053,0.074,0.155,0.208,0.132,0.121,
0.092,0.024,0.074,0.083,0.085,0.084,0.107,0.142,0.163,0.307,
0.102,0.100,0.271,0.680,0.329,0.179,0.142,0.091,0.086,0.084,
0.062,0.181,0.159,0.082,0.317,0.689,0.219,0.165,0.562,0.904,
0.738,0.351,0.474,0.456,0.270,0.242,0.131,0.515,0.169,0.120,
0.140,0.482,0.181,0.141,0.117,0.618,0.249,0.089,0.287,0.277,
0.299,0.240,0.076,0.426,0.261,0.165,0.086,0.108,0.058,0.065,
0.204,0.447,0.221,0.160,0.129,0.052,0.106,0.100,0.068,0.128,
0.104,0.130,0.093,0.118,0.055,0.149,0.194,0.337,0.227,0.169,
0.218,0.125,0.112,0.092,0.074,0.223,0.083,0.081,0.035,0.107,
0.043,0.134,0.106,0.314,0.209,0.100,0.120,0.190,0.117,0.086,
0.024,0.132,0.052,0.034,0.110,0.248,0.181,0.181,0.079,0.213,
0.189,0.075,0.300,0.267,0.273,0.196,0.091,0.450,0.209,0.140,
0.073,0.073,0.059,0.085,0.194,0.389,0.293,0.201,0.188,0.091,
0.187,0.144,0.070,0.141,0.127,0.126,0.083,0.118,0.045,0.075,
0.076,0.102,0.062,0.065,0.080,0.020,0.038,0.044,0.066,0.093,
0.052,0.086,0.225,0.714,0.131,0.258,0.246,0.413,0.267,0.327,
0.286,0.130,0.131,0.148,0.112,0.369,0.129,0.140,0.073,0.180,
0.112,0.104,0.025,0.071,0.048,0.034,0.156,0.083,0.173,0.167,
0.072,0.227,0.169,0.139,0.078,0.090,0.055,0.079,0.094,0.150,
0.098,0.099,0.123,0.036,0.115,0.126,0.097,0.166,0.156,0.178,
1.370,1.260,0.677,1.070,1.390,1.970,0.836,0.918,0.985,0.170,
0.490,0.657,0.771,0.813,0.444,0.771,1.430,1.710,0.772,0.946,
1.930,1.860,1.900,1.160,1.340,0.322,1.190,1.050,0.597,1.270,
0.660,0.808,0.901,1.770,1.040,1.140,0.197,0.364,0.270,0.330,
1.120,0.276,0.860,1.000,0.490,1.330,0.726,0.857,0.710,0.576,
0.415,0.704,0.981,1.200,0.790,1.020,0.778,0.151,0.631,0.999,
0.702,0.741,0.714,1.340,0.137,0.234,0.076,0.109,0.325,0.973,
0.248,0.198,0.139,0.067,0.115,0.134,0.068,0.144,0.068,0.100,
0.172,0.320,0.124,0.113,0.367,0.600,0.546,0.250,0.248,0.206,
0.329,0.244,0.075,0.239,0.115,0.102,0.101,0.354,0.169,0.138,
0.069,0.264,0.187,0.079,0.239,0.212,0.330,0.272,0.072,0.309,
0.192,0.145,0.086,0.096,0.055,0.085,0.203,0.391,0.211,0.218,
0.126,0.051,0.143,0.163,0.071,0.110,0.098,0.148,0.876,1.020,
0.451,0.481,1.560,2.070,1.390,0.887,1.040,0.292,0.784,0.710,
0.480,0.892,0.604,0.664,0.114,0.282,0.099,0.090,0.223,0.494,
0.392,0.142,0.191,0.163,0.237,0.152,0.069,0.242,0.123,0.104,
0.867,1.650,1.040,0.823,0.223,0.444,0.437,0.216,1.080,0.311,
0.445,0.687,0.431,1.260,0.984,0.824,0.556,0.513,0.383,0.413,
1.200,1.810,1.370,1.060,0.988,0.229,0.858,0.880,0.472,0.788,
0.808,0.873,0.761,0.547,0.348,0.553,0.759,0.738,0.408,0.422,
0.549,0.096,0.347,0.451,0.492,0.535,0.342,0.641,1.150,1.510,
0.668,0.691,1.600,2.130,1.540,0.969,1.120,0.292,1.040,0.995,
0.684,1.410,0.851,0.930,1.010,1.850,0.984,1.010,0.181,0.393,
0.241,0.198,1.350,0.308,1.650,1.400,0.677,1.660,1.180,1.100,
0.665,0.594,0.397,0.590,0.940,1.280,0.799,0.831,0.992,0.177,
1.030,1.080,0.761,1.190,0.975,1.210,1.240,0.851,0.485,0.948,
0.833,0.839,0.459,0.627,0.632,0.102,0.279,0.519,0.704,0.684,
0.345,1.320,0.934,0.859,0.367,0.505,0.744,0.621,0.464,0.428,
0.469,0.075,0.410,0.402,0.342,0.512,0.321,0.488,0.716,1.070,
0.470,0.707,0.087,0.121,0.069,0.116,0.585,0.090,0.338,0.496,
0.480,0.729,0.456,0.694,0.753,0.536,0.386,0.659,0.683,0.642,
0.438,0.671,0.505,0.061,0.309,0.504,0.764,0.621,0.535,1.260,
1.600,1.750,0.728,1.220,1.990,3.290,1.280,1.250,0.999,0.229,
0.664,0.882,0.658,1.070,0.517,0.921,1.770,2.780,0.841,1.030,
2.180,2.560,1.690,1.330,1.380,0.357,1.100,1.360,0.643,1.400,
0.950,0.929,1.100,2.640,0.978,1.200,0.189,0.499,0.252,0.252,
1.390,0.363,1.230,1.500,0.743,2.040,1.100,1.330,0.823,0.859,
0.604,0.764,1.410,1.940,1.170,1.530,0.997,0.155,0.789,1.080,
0.714,0.973,0.766,1.360,1.170,1.660,0.504,0.660,1.670,1.660,
1.140,0.989,1.330,0.411,0.712,1.120,0.644,1.170,0.606,0.921,
0.102,0.181,0.058,0.092,0.169,0.298,0.220,0.134,0.128,0.078,
0.138,0.164,0.065,0.181,0.088,0.104,0.874,1.560,0.842,0.903,
0.172,0.317,0.231,0.210,1.270,0.336,0.897,1.100,0.578,1.490,
1.060,1.020,0.661,0.640,0.469,0.574,1.380,1.620,1.450,1.420,
1.060,0.189,0.898,1.110,0.656,0.905,0.941,1.220,1.140,0.732,
0.430,0.733,0.836,0.726,0.488,0.535,0.746,0.116,0.358,0.572,
0.711,0.713,0.465,1.030,0.961,1.040,0.440,0.630,1.040,1.150,
0.848,0.786,0.825,0.122,0.606,0.859,0.594,0.869,0.594,0.872,
1.030,1.510,0.868,1.140,0.124,0.197,0.123,0.158,1.310,0.213,
1.280,1.590,0.842,1.550,1.270,1.410,1.090,0.796,0.592,1.100,
1.260,1.430,1.040,1.290,1.240,0.138,1.120,1.600,1.350,1.340,
1.360,1.800,1.840,1.210,0.949,1.890,1.270,0.932,0.605,0.856,
1.080,0.119,0.399,0.739,1.560,1.230,0.597,1.290,1.330,0.963,
0.520,0.747,0.951,0.717,0.469,0.514,0.719,0.093,0.382,0.468,
0.713,0.854,0.451,0.731,0.848,0.862,0.512,0.865,0.087,0.093,
0.060,0.117,0.607,0.068,0.294,0.462,0.585,0.772,0.452,0.809,
1.170,0.633,0.515,1.020,0.911,0.717,0.507,0.795,0.641,0.062,
0.348,0.547,1.020,0.683,0.698,1.640,1.690,1.140,0.558,1.080,
1.270,1.050,0.600,0.712,0.758,0.104,0.300,0.516,0.829,0.808,
0.394,0.755,1.160,1.150,0.418,0.623,0.899,0.876,0.469,0.528,
0.757,0.123,0.343,0.527,0.664,0.787,0.352,0.546,0.646,0.810,
0.439,0.666,0.072,0.112,0.071,0.092,0.609,0.084,0.346,0.461,
0.486,0.824,0.503,0.639,0.617,0.476,0.276,0.576,0.680,0.690,
0.360,0.571,0.497,0.051,0.261,0.431,0.563,0.525,0.508,0.959,
1.090,0.598,0.369,0.722,0.932,0.697,0.522,0.681,0.829,0.129,
0.259,0.439,0.792,0.784,0.373,0.795,0.076,0.081,0.037,0.087,
0.072,0.086,0.052,0.066,0.077,0.024,0.037,0.052,0.094,0.154,
0.052,0.091,0.555,0.686,0.414,0.550,0.064,0.083,0.055,0.073,
0.544,0.095,0.263,0.366,0.398,0.663,0.387,0.484,0.475,0.394,
0.296,0.598,0.629,0.717,0.411,0.610,0.601,0.081,0.279,0.450,
0.559,0.559,0.450,0.838,1.280,0.561,0.391,0.922,0.696,0.437,
0.353,0.499,0.774,0.082,0.261,0.433,1.360,0.796,0.457,1.090,
0.852,0.704,0.359,0.637,0.630,0.571,0.381,0.501,0.643,0.083,
0.311,0.471,0.745,0.931,0.480,0.802,0.592,0.710,0.480,0.677,
0.066,0.061,0.050,0.069,0.587,0.064,0.323,0.489,0.574,0.768,
0.532,0.771,0.965,0.633,0.517,1.050,0.685,0.590,0.466,0.691,
0.818,0.078,0.498,0.837,1.330,1.180,1.110,2.160,1.820,1.380,
1.140,1.470,1.360,1.320,0.792,0.927,0.886,0.139,0.431,0.670,
0.897,1.120,0.548,1.050,1.670,1.610,0.834,0.991,1.700,1.710,
1.070,0.989,1.080,0.231,0.858,0.858,0.646,1.250,0.631,0.821,
1.000,1.680,0.757,1.070,0.145,0.235,0.136,0.182,0.786,0.146,
0.578,0.816,0.574,1.020,0.705,1.010,0.961,0.703,0.491,0.873,
1.250,1.450,0.773,0.969,0.687,0.091,0.487,0.667,0.854,0.693,
0.757,1.340,1.630,1.720,0.624,0.957,1.640,2.200,1.020,0.976,
0.877,0.202,0.398,0.554,0.644,1.090,0.574,0.767,1.920,2.830,
0.837,0.998,2.190,2.590,1.410,1.350,1.490,0.500,0.810,0.986,
0.747,1.840,0.644,0.785,0.928,1.940,1.030,1.160,0.185,0.516,
0.316,0.248,1.130,0.307,0.812,0.996,0.609,1.600,1.240,1.180,
0.781,0.847,0.466,0.744,1.280,2.120,1.010,1.090,0.808,0.129,
0.525,0.818,0.706,0.902,0.679,1.170,0.863,0.699,0.327,0.677,
1.050,1.210,0.814,0.814,0.989,0.250,0.432,0.487,0.566,0.950,
0.415,0.703,0.085,0.150,0.061,0.187,0.138,0.295,0.155,0.152,
0.167,0.109,0.101,0.105,0.077,0.283,0.082,0.103,0.760,1.150,
0.698,0.837,0.124,0.226,0.154,0.149,1.070,0.291,0.603,0.763,
0.485,1.300,0.718,0.765,0.634,0.543,0.395,0.666,1.100,1.650,
0.944,1.020,1.060,0.142,0.615,0.799,0.629,0.759,0.678,1.030,
0.759,0.564,0.320,0.575,0.559,0.522,0.336,0.415,0.665,0.086,
0.265,0.358,0.670,0.624,0.345,0.698,1.000,1.520,0.550,0.914,
1.060,1.380,0.832,1.010,1.060,0.248,0.530,0.726,0.773,1.880,
0.643,0.920,0.630,1.040,0.626,0.796,0.089,0.144,0.091,0.096,
0.772,0.141,0.617,0.848,0.506,1.160,0.749,0.890,0.745,0.606,
0.431,0.688,0.768,0.964,0.553,0.663,0.878,0.114,0.603,0.884,
0.911,1.150,0.938,1.530,1.080,0.988,0.507,0.996,0.895,0.998,
0.437,0.664,0.653,0.084,0.296,0.499,0.597,0.611,0.303,0.657,
1.220,1.320,0.528,0.761,1.480,1.260,0.810,0.720,0.949,0.175,
0.657,0.732,0.538,0.977,0.487,0.715,0.804,1.250,0.943,1.020,
0.135,0.192,0.132,0.195,0.790,0.146,0.581,0.769,0.480,1.080,
0.606,0.832,0.713,0.571,0.388,0.778,0.875,0.913,0.527,0.767,
0.710,0.106,0.471,0.781,0.743,0.718,0.671,1.370,0.070,0.098,
0.041,0.072,0.108,0.260,0.057,0.074,0.061,0.018,0.040,0.051,
0.045,0.084,0.038,0.064,0.085,0.141,0.047,0.059,0.176,0.338,
0.118,0.102,0.100,0.058,0.105,0.096,0.049,0.122,0.065,0.063,
0.056,0.148,0.070,0.067,0.023,0.067,0.039,0.022,0.097,0.049,
0.093,0.097,0.048,0.145,0.080,0.092,0.056,0.067,0.035,0.065,
0.110,0.190,0.086,0.100,0.072,0.022,0.067,0.090,0.061,0.080,
0.066,0.115,0.648,0.640,0.305,0.396,0.805,1.020,0.628,0.567,
0.676,0.154,0.392,0.451,0.383,0.652,0.398,0.566,0.064,0.117,
0.043,0.045,0.098,0.171,0.097,0.061,0.092,0.054,0.083,0.071,
0.049,0.150,0.064,0.068,0.640,1.250,0.656,0.620,0.125,0.236,
0.156,0.108,0.985,0.233,0.441,0.649,0.417,1.200,0.699,0.659,
0.486,0.499,0.320,0.416,0.867,1.210,0.762,0.701,0.854,0.143,
0.623,0.723,0.502,0.733,0.660,0.789,0.661,0.460,0.294,0.530,
0.594,0.528,0.321,0.394,0.509,0.071,0.278,0.382,0.487,0.509,
0.311,0.586,0.897,1.000,0.463,0.579,1.000,1.140,0.689,0.588,
0.853,0.162,0.577,0.680,0.597,1.130,0.618,0.777,1.060,1.200,
1.040,0.818,0.340,0.198,0.221,0.119,1.070,0.168,0.817,0.992,
0.683,1.290,0.885,0.958,0.690,0.574,0.485,0.631,1.000,0.931,
0.865,0.699,0.961,0.122,0.785,0.976,0.851,1.110,0.951,1.260,
1.680,0.844,0.573,1.290,0.924,0.669,0.396,0.802,0.670,0.077,
0.260,0.557,0.872,0.724,0.377,1.070,0.911,0.697,0.321,0.523,
0.738,0.626,0.352,0.471,0.512,0.065,0.277,0.424,0.420,0.518,
0.261,0.551,0.723,0.950,0.433,0.784,0.067,0.084,0.044,0.099,
0.628,0.071,0.290,0.517,0.508,0.639,0.356,0.704,0.889,0.580,
0.407,0.916,0.663,0.567,0.391,0.712,0.626,0.058,0.340,0.719,
0.924,0.680,0.603,1.700,1.180,0.869,0.487,0.907,0.942,1.080,
0.437,0.633,0.587,0.081,0.288,0.509,0.530,0.641,0.307,0.751,
1.030,1.070,0.381,0.599,0.967,1.450,0.497,0.641,0.741,0.121,
0.450,0.653,0.505,0.782,0.395,0.869,0.734,1.440,0.473,0.648,
0.067,0.181,0.056,0.080,0.829,0.129,0.404,0.692,0.538,0.936,
0.475,0.823,0.647,0.603,0.398,0.666,0.759,0.901,0.471,0.770,
0.706,0.072,0.395,0.738,0.706,0.780,0.551,1.360,1.040,1.200,
0.501,0.669,0.963,0.873,0.573,0.739,0.858,0.189,0.414,0.643,
0.619,0.787,0.604,0.934,0.078,0.128,0.036,0.063,0.071,0.114,
0.062,0.070,0.064,0.028,0.052,0.070,0.059,0.123,0.056,0.096,
0.748,1.060,0.548,0.775,0.084,0.125,0.082,0.102,0.944,0.155,
0.546,0.787,0.570,1.040,0.749,0.911,0.705,0.663,0.414,0.649,
0.990,1.070,0.791,1.000,1.140,0.120,0.732,1.020,0.798,0.890,
0.808,1.260,1.480,0.785,0.553,1.100,0.841,0.659,0.444,0.617,
0.872,0.091,0.378,0.686,1.050,0.845,0.613,1.540,1.190,0.992,
0.469,0.790,1.120,1.260,0.711,0.872,0.927,0.105,0.564,0.962,
0.822,1.040,0.652,1.380,1.130,1.280,1.180,1.220,0.112,0.124,
0.162,0.129,1.270,0.133,0.911,1.410,1.060,1.520,1.250,1.660,
1.730,1.040,0.850,1.790,1.430,1.310,1.070,1.570,1.610,0.131,
1.180,2.140,1.880,1.550,1.420,2.300,2.630,1.820,1.590,2.790,
2.140,1.360,1.280,1.380,1.980,0.226,1.180,1.670,2.470,2.060,
1.210,2.010,2.330,1.580,1.240,1.480,1.710,1.250,1.240,1.000,
1.590,0.170,1.110,1.200,1.110,1.240,0.954,1.190,1.650,1.280,
1.130,1.460,0.161,0.148,0.138,0.208,1.120,0.115,0.636,0.821,
1.070,1.120,0.873,1.100,2.150,1.010,1.090,2.210,1.720,1.280,
1.170,1.590,1.380,0.120,0.784,1.080,1.730,1.040,1.100,1.800,
2.210,1.440,0.912,1.300,1.830,1.220,0.855,0.897,1.100,0.157,
1.020,1.220,0.893,1.070,0.662,0.979,1.630,1.290,0.776,0.941,
1.110,0.861,0.743,0.659,1.140,0.169,0.831,0.997,0.662,0.892,
0.593,0.755,1.020,1.060,0.696,0.818,0.117,0.135,0.119,0.118,
0.921,0.125,0.593,0.706,0.543,0.918,0.708,0.657,0.892,0.606,
0.481,0.773,1.030,0.896,0.692,0.844,1.020,0.094,0.657,0.818,
0.916,0.728,0.715,1.100,1.650,0.858,0.808,0.915,1.730,0.881,
0.841,0.816,1.110,0.158,0.554,0.771,0.983,0.985,0.700,1.110,
0.137,0.125,0.076,0.095,0.130,0.118,0.100,0.088,0.111,0.032,
0.088,0.110,0.112,0.206,0.120,0.140,0.785,0.708,0.719,0.660,
0.090,0.083,0.109,0.094,0.677,0.095,0.530,0.591,0.506,0.706,
1.260,0.689,0.653,0.447,0.444,0.624,0.882,0.764,0.678,0.780,
0.743,0.094,0.578,0.769,0.664,0.735,0.824,1.050,2.130,0.816,
0.697,1.260,0.971,0.558,0.567,0.630,0.873,0.090,0.481,0.689,
1.100,0.856,0.636,1.400,1.540,1.050,0.737,0.938,1.020,0.823,
0.790,0.744,0.987,0.105,0.681,0.860,0.835,1.050,0.684,1.020,
0.819,0.781,0.608,0.789,0.077,0.070,0.072,0.089,0.646,0.069,
0.620,0.796,0.576,0.745,0.716,0.770,1.190,0.695,0.662,1.170,
0.694,0.539,0.601,0.795,0.984,0.087,0.811,1.210,1.270,1.140,
1.100,1.890,2.870,2.100,1.480,2.200,2.120,1.920,1.460,1.390,
1.290,0.191,0.824,1.210,1.350,1.430,0.958,1.590,2.470,2.250,
1.420,1.590,2.000,1.930,1.760,1.440,1.610,0.282,1.530,1.670,
0.907,1.380,0.982,1.240,1.110,1.480,1.130,1.170,0.158,0.237,
0.198,0.198,0.738,0.111,0.718,0.780,0.505,0.896,0.698,0.897,
1.170,0.702,0.694,1.120,1.430,1.370,1.010,1.190,0.887,0.107,
0.629,0.817,0.844,0.745,0.933,1.460,2.190,2.220,1.030,1.260,
2.540,2.530,1.420,1.160,1.180,0.234,0.786,0.973,0.811,1.190,
0.633,0.969,1.770,2.170,1.150,1.090,1.530,1.140,1.360,1.090,
1.550,0.373,1.390,1.510,0.668,1.320,0.845,0.899,1.150,2.230,
1.190,1.140,0.210,0.483,0.333,0.242,1.080,0.271,0.930,1.000,
0.543,1.670,0.925,0.973,0.835,0.811,0.544,0.729,1.300,1.770,
1.200,1.130,0.865,0.136,0.700,0.864,0.606,0.815,0.673,1.110,
1.500,1.250,0.905,1.020,1.720,1.910,2.010,1.240,1.280,0.251,
0.901,1.080,0.777,1.170,1.010,1.340,0.139,0.279,0.140,0.137,
0.191,0.384,0.369,0.176,0.195,0.124,0.270,0.217,0.101,0.325,
0.200,0.183,1.130,1.740,1.370,1.270,0.189,0.357,0.363,0.220,
1.280,0.306,1.320,1.280,0.631,1.760,1.850,1.310,0.742,0.638,
0.617,0.756,1.320,1.850,1.600,1.360,1.120,0.185,1.210,1.300,
0.658,0.925,1.230,1.360,1.180,0.806,0.581,0.864,0.808,0.692,
0.620,0.637,0.633,0.076,0.399,0.571,0.677,0.660,0.529,1.030,
1.420,1.910,0.950,1.050,1.180,1.540,1.480,1.260,1.030,0.171,
0.911,1.070,0.728,1.380,0.828,1.210,0.748,1.040,0.805,0.908,
0.083,0.145,0.104,0.108,0.653,0.101,0.651,0.777,0.532,0.937,
0.822,0.895,0.876,0.645,0.598,0.829,0.752,0.832,0.646,0.844,
0.849,0.104,0.772,1.120,0.964,1.200,1.260,1.720,1.600,1.230,
0.792,1.160,0.936,0.842,0.669,0.673,0.804,0.113,0.456,0.648,
0.820,0.900,0.556,0.919,1.730,1.870,0.941,1.060,1.320,1.340,
1.120,0.895,1.490,0.242,1.140,1.170,0.841,1.550,0.700,0.930,
1.050,1.630,1.970,1.350,0.153,0.254,0.332,0.307,0.784,0.131,
0.604,0.742,0.483,0.993,0.674,0.793,0.991,0.844,0.781,1.140,
0.941,1.090,1.130,1.280,0.876,0.108,0.661,0.901,0.884,0.831,
0.899,1.600,0.130,0.149,0.087,0.100,0.211,0.199,0.157,0.099,
0.095,0.027,0.082,0.092,0.077,0.147,0.119,0.106,0.153,0.239,
0.113,0.107,0.197,0.263,0.188,0.119,0.175,0.074,0.200,0.169,
0.094,0.265,0.103,0.106,0.107,0.239,0.299,0.162,0.031,0.081,
0.126,0.054,0.152,0.055,0.153,0.155,0.072,0.218,0.135,0.112,
0.135,0.133,0.123,0.154,0.229,0.361,0.370,0.343,0.140,0.036,
0.153,0.182,0.124,0.191,0.170,0.217,0.923,0.825,0.586,0.546,
0.787,1.050,0.865,0.580,0.833,0.220,0.770,0.833,0.493,0.886,
0.689,0.865,0.104,0.192,0.092,0.078,0.100,0.202,0.164,0.081,
0.146,0.084,0.181,0.127,0.083,0.261,0.130,0.117,0.688,1.340,
0.899,0.674,0.115,0.359,0.242,0.133,0.823,0.181,0.620,0.628,
0.349,0.867,0.714,0.554,0.536,0.539,0.581,0.533,0.747,1.360,
1.170,1.110,0.720,0.153,0.790,0.777,0.441,0.754,0.749,0.795,
0.894,0.535,0.378,0.574,0.540,0.471,0.324,0.333,0.572,0.071,
0.309,0.442,0.522,0.576,0.360,0.831,1.180,1.180,0.682,0.775,
0.986,1.300,0.849,0.677,1.080,0.174,0.874,0.994,0.747,1.440,
0.732,1.030,0.781,0.977,0.737,0.658,0.099,0.161,0.118,0.096,
1.540,0.136,0.638,0.706,0.577,0.954,0.622,0.699,0.880,0.708,
0.666,0.674,0.768,0.877,0.646,0.721,0.940,0.153,0.813,0.963,
0.988,1.810,0.942,1.310,1.820,0.982,0.765,1.330,0.811,0.574,
0.587,0.574,0.751,0.081,0.387,0.631,1.060,0.826,0.536,1.200,
1.040,0.712,0.448,0.649,0.649,0.466,0.422,0.456,0.752,0.079,
0.433,0.611,0.722,0.670,0.375,0.668,0.853,0.709,0.684,0.976,
0.082,0.084,0.082,0.132,0.502,0.050,0.305,0.498,0.449,0.533,
0.394,0.680,1.230,0.698,0.749,1.610,0.902,0.760,0.704,1.120,
0.759,0.068,0.476,0.783,1.090,0.764,0.857,1.950,1.440,1.010,
0.751,1.010,1.200,0.943,1.470,0.784,0.785,0.105,0.525,0.766,
0.678,0.828,0.584,0.929,1.140,1.100,0.552,0.772,0.978,0.978,
0.746,0.646,0.999,0.167,0.754,0.981,0.730,1.220,0.497,0.746,
0.850,0.987,1.010,1.110,0.095,0.134,0.245,0.177,0.791,0.100,
0.547,0.805,0.565,0.903,0.636,0.846,0.976,0.653,0.611,1.080,
1.100,1.100,1.140,1.520,0.838,0.086,0.599,0.918,0.815,0.814,
0.848,1.420,1.080,0.665,0.550,0.689,1.000,0.828,0.795,0.794,
0.996,0.166,0.712,0.911,0.717,0.816,0.757,1.130,0.093,0.099,
0.063,0.092,0.084,0.114,0.101,0.081,0.104,0.031,0.119,0.133,
0.091,0.168,0.099,0.129,0.780,0.936,0.675,0.815,0.091,0.118,
0.113,0.131,0.911,0.141,0.659,0.876,0.551,0.972,0.854,0.959,
0.697,0.595,0.579,0.848,0.981,1.000,0.978,1.230,1.080,0.123,
0.862,1.210,0.787,0.841,0.986,1.400,1.560,0.761,0.605,1.070,
0.817,0.625,0.519,0.625,0.863,0.086,0.468,0.738,1.010,0.801,
0.706,1.640,1.020,0.741,0.492,0.730,0.698,0.622,0.550,0.596,
0.841,0.085,0.634,0.981,0.782,0.950,0.620,1.130,1.110,1.070,
0.799,1.210,0.118,0.109,0.088,0.137,1.190,0.102,0.808,1.170,
0.924,1.160,0.981,1.380,1.770,1.070,1.000,1.940,1.460,1.270,
1.070,1.500,1.730,0.137,1.510,2.340,2.420,1.910,1.980,3.050,
0.147,0.124,0.108,0.135,0.166,0.136,0.108,0.101,0.110,0.024,
0.175,0.200,0.105,0.116,0.084,0.103,0.147,0.150,0.105,0.103,
0.159,0.167,0.149,0.108,0.108,0.036,0.124,0.114,0.071,0.116,
0.090,0.097,0.079,0.095,0.083,0.085,0.017,0.024,0.025,0.021,
0.063,0.018,0.069,0.061,0.048,0.074,0.069,0.068,0.090,0.062,
0.056,0.101,0.114,0.105,0.089,0.105,0.091,0.016,0.068,0.078,
0.078,0.070,0.078,0.116,0.188,0.191,0.119,0.123,0.254,0.235,
0.172,0.123,0.146,0.049,0.280,0.405,0.071,0.139,0.124,0.126,
0.198,0.287,0.152,0.133,0.222,0.275,0.229,0.152,0.219,0.114,
0.249,0.264,0.081,0.203,0.119,0.116,0.096,0.192,0.113,0.093,
0.053,0.097,0.089,0.032,0.197,0.087,0.143,0.121,0.064,0.184,
0.117,0.083,0.066,0.072,0.051,0.060,0.149,0.175,0.123,0.121,
0.103,0.027,0.112,0.111,0.066,0.086,0.091,0.107,0.128,0.102,
0.059,0.061,0.442,0.158,0.137,0.116,0.126,0.031,0.085,0.091,
0.062,0.087,0.073,0.091,0.018,0.036,0.023,0.014,0.042,0.058,
0.058,0.026,0.027,0.030,0.042,0.034,0.012,0.042,0.026,0.019,
0.067,0.100,0.092,0.067,0.022,0.036,0.045,0.022,0.087,0.041,
0.122,0.097,0.040,0.108,0.116,0.083,0.045,0.041,0.051,0.050,
0.097,0.113,0.113,0.102,0.084,0.028,0.102,0.097,0.051,0.089,
0.094,0.103,0.122,0.070,0.053,0.082,0.105,0.058,0.050,0.070,
0.073,0.013,0.054,0.067,0.069,0.071,0.056,0.112,0.134,0.138,
0.095,0.108,0.146,0.174,0.136,0.119,0.106,0.031,0.113,0.135,
0.066,0.135,0.092,0.126,0.065,0.087,0.080,0.092,0.014,0.020,
0.022,0.017,0.081,0.025,0.078,0.140,0.044,0.099,0.113,0.103,
0.080,0.061,0.080,0.099,0.064,0.075,0.074,0.089,0.088,0.016,
0.107,0.205,0.091,0.115,0.124,0.182,0.155,0.160,0.107,0.116,
0.188,0.255,0.165,0.127,0.099,0.030,0.084,0.093,0.069,0.105,
0.073,0.090,0.188,0.246,0.153,0.126,0.262,0.356,0.343,0.239,
0.158,0.105,0.237,0.223,0.060,0.145,0.128,0.114,0.075,0.150,
0.114,0.080,0.028,0.071,0.070,0.031,0.071,0.036,0.113,0.082,
0.036,0.092,0.081,0.073,0.063,0.049,0.044,0.064,0.110,0.161,
0.110,0.097,0.198,0.027,0.083,0.087,0.057,0.061,0.074,0.092,
0.205,0.316,0.147,0.116,0.337,0.626,0.315,0.161,0.162,0.080,
0.158,0.146,0.067,0.157,0.094,0.093,0.291,0.596,0.274,0.175,
0.345,0.448,0.460,0.295,0.321,0.340,0.448,0.382,0.087,0.338,
0.195,0.156,0.125,0.478,0.215,0.128,0.084,0.390,0.237,0.072,
0.175,0.155,0.219,0.169,0.054,0.276,0.189,0.122,0.077,0.124,
0.070,0.065,0.186,0.468,0.217,0.155,0.115,0.048,0.148,0.140,
0.055,0.114,0.100,0.114,0.119,0.134,0.080,0.074,0.239,0.357,
0.335,0.142,0.155,0.061,0.143,0.134,0.055,0.126,0.110,0.119,
0.035,0.108,0.064,0.032,0.107,0.328,0.483,0.086,0.085,0.172,
0.171,0.113,0.016,0.089,0.067,0.039,0.126,0.284,0.218,0.133,
0.079,0.225,0.243,0.070,0.190,0.149,0.298,0.195,0.053,0.234,
0.255,0.136,0.060,0.061,0.069,0.059,0.178,0.338,0.356,0.188,
0.188,0.068,0.255,0.185,0.064,0.113,0.175,0.144,0.087,0.076,
0.057,0.073,0.084,0.097,0.076,0.061,0.069,0.014,0.052,0.056,
0.054,0.061,0.050,0.089,0.130,0.229,0.125,0.116,0.183,0.356,
0.314,0.185,0.150,0.073,0.167,0.172,0.059,0.178,0.113,0.140,
0.069,0.138,0.106,0.085,0.017,0.049,0.041,0.022,0.087,0.033,
0.126,0.105,0.043,0.104,0.110,0.089,0.063,0.054,0.060,0.060,
0.071,0.113,0.097,0.086,0.084,0.020,0.108,0.122,0.067,0.108,
0.146,0.169,0.091,0.099,0.069,0.070,0.087,0.104,0.092,0.070,
0.063,0.018,0.051,0.054,0.049,0.084,0.074,0.055,0.133,0.218,
0.107,0.093,0.193,0.268,0.245,0.151,0.166,0.105,0.243,0.170,
0.070,0.240,0.097,0.089,0.076,0.175,0.253,0.108,0.027,0.075,
0.125,0.052,0.101,0.053,0.116,0.109,0.037,0.127,0.088,0.068,
0.049,0.052,0.058,0.067,0.089,0.124,0.215,0.133,0.080,0.022,
0.089,0.092,0.055,0.075,0.082,0.107,0.015,0.033,0.023,0.013,
0.042,0.085,0.089,0.033,0.020,0.021,0.036,0.025,8.96e-3,0.032,
0.064,0.016,0.034,0.123,0.052,0.025,0.100,0.253,0.188,0.068,
0.063,0.165,0.173,0.093,0.019,0.106,0.045,0.027,0.024,0.110,
0.130,0.037,0.036,0.157,0.230,0.060,0.057,0.102,0.146,0.078,
0.016,0.091,0.090,0.032,0.010,0.019,0.020,0.012,0.038,0.088,
0.126,0.075,0.025,0.024,0.064,0.042,0.011,0.026,0.032,0.026,
0.077,0.120,0.071,0.055,0.111,0.248,0.208,0.099,0.120,0.066,
0.204,0.235,0.045,0.129,0.135,0.133,0.023,0.092,0.042,0.018,
0.058,0.194,0.157,0.050,0.067,0.138,0.189,0.090,0.016,0.074,
0.054,0.033,0.092,0.457,0.248,0.105,0.061,0.448,0.250,0.059,
0.167,0.158,0.265,0.177,0.047,0.221,0.199,0.103,0.047,0.072,
0.074,0.081,0.127,0.482,0.327,0.327,0.130,0.074,0.234,0.185,
0.050,0.112,0.149,0.120,0.073,0.073,0.048,0.059,0.062,0.073,
0.049,0.044,0.064,0.018,0.057,0.062,0.049,0.069,0.052,0.080,
0.119,0.207,0.112,0.100,0.179,0.348,0.243,0.147,0.179,0.113,
0.238,0.220,0.074,0.224,0.142,0.125,0.086,0.193,0.143,0.093,
0.026,0.090,0.080,0.029,0.187,0.079,0.194,0.172,0.058,0.183,
0.145,0.109,0.061,0.066,0.061,0.065,0.086,0.134,0.108,0.106,
0.104,0.034,0.163,0.140,0.083,0.181,0.127,0.138,0.114,0.081,
0.068,0.092,0.098,0.073,0.118,0.096,0.078,0.011,0.043,0.073,
0.076,0.071,0.050,0.095,0.094,0.086,0.057,0.063,0.092,0.084,
0.072,0.071,0.073,0.017,0.068,0.081,0.066,0.082,0.046,0.067,
0.063,0.075,0.077,0.082,0.010,0.014,0.017,0.018,0.050,9.46e-3,
0.044,0.057,0.034,0.056,0.047,0.067,0.083,0.056,0.061,0.118,
0.080,0.076,0.079,0.138,0.082,0.010,0.054,0.095,0.086,0.068,
0.084,0.182,0.161,0.160,0.192,0.124,0.214,0.214,0.844,0.192,
0.122,0.032,0.136,0.134,0.076,0.146,0.136,0.118,0.177,0.269,
0.139,0.137,0.233,0.334,0.273,0.184,0.199,0.083,0.253,0.252,
0.107,0.351,0.135,0.132,0.102,0.219,0.250,0.174,0.028,0.075,
0.130,0.071,0.136,0.043,0.147,0.162,0.065,0.195,0.140,0.127,
0.103,0.095,0.100,0.133,0.180,0.247,0.325,0.425,0.121,0.028,
0.150,0.172,0.090,0.130,0.142,0.196,0.086,0.075,0.060,0.060,
0.117,0.146,0.164,0.104,0.108,0.034,0.112,0.127,0.057,0.098,
0.098,0.109,0.014,0.024,0.015,0.014,0.026,0.060,0.048,0.026,
0.023,0.025,0.045,0.040,0.011,0.033,0.025,0.020,0.075,0.168,
0.132,0.100,0.026,0.064,0.070,0.036,0.147,0.070,0.178,0.157,
0.062,0.189,0.182,0.135,0.064,0.065,0.070,0.080,0.121,0.182,
0.188,0.195,0.146,0.038,0.186,0.189,0.077,0.114,0.153,0.159,
0.107,0.080,0.059,0.086,0.081,0.078,0.077,0.077,0.075,0.012,
0.053,0.074,0.067,0.070,0.068,0.123,0.099,0.095,0.064,0.077,
0.099,0.125,0.110,0.096,0.084,0.021,0.097,0.124,0.068,0.108,
0.078,0.119,0.105,0.132,0.101,0.118,0.020,0.025,0.025,0.022,
0.127,0.027,0.127,0.159,0.078,0.152,0.141,0.145,0.114,0.088,
0.087,0.137,0.135,0.142,0.127,0.161,0.149,0.022,0.182,0.222,
0.162,0.181,0.204,0.236,1.830,1.240,0.973,1.510,1.310,1.040,
0.995,0.989,1.030,0.130,0.841,0.911,1.190,1.170,0.746,1.190,
1.560,1.220,0.829,1.160,1.440,1.080,1.310,1.120,1.110,0.180,
0.841,0.857,0.723,1.040,0.686,0.897,0.900,0.937,0.729,1.060,
0.109,0.112,0.120,0.168,0.661,0.086,0.542,0.635,0.476,0.745,
0.596,0.736,0.939,0.529,0.431,0.941,0.848,0.712,0.577,0.759,
0.698,0.071,0.433,0.614,0.755,0.469,0.608,1.140,1.730,1.310,
0.764,1.070,1.510,1.420,1.100,0.999,1.120,0.197,0.687,0.888,
0.777,1.060,0.574,0.871,1.740,1.940,0.963,1.120,1.550,1.220,
1.370,1.050,2.350,0.624,1.520,1.880,0.861,1.690,0.727,0.858,
0.995,1.500,0.977,1.070,0.177,0.243,0.237,0.218,1.260,0.255,
1.130,1.330,0.564,1.290,0.977,0.899,0.712,0.600,0.410,0.640,
1.060,1.120,0.861,1.020,0.839,0.116,0.644,0.889,0.653,0.669,
0.665,1.100,1.300,0.840,0.562,0.769,1.600,1.370,1.340,1.200,
1.360,0.236,0.775,0.970,0.881,1.230,0.795,1.230,0.159,0.204,
0.121,0.154,0.233,0.272,0.311,0.224,0.219,0.084,0.237,0.237,
0.161,0.457,0.185,0.247,0.923,1.130,2.180,1.880,0.185,0.186,
1.310,0.762,1.040,0.206,0.902,0.922,0.534,1.150,1.060,0.951,
0.635,0.488,0.552,0.677,1.210,1.110,2.690,1.930,0.853,0.143,
0.781,0.943,0.705,0.796,0.883,1.120,1.310,0.543,0.449,0.769,
0.662,0.499,0.469,0.516,0.598,0.080,0.360,0.525,0.745,0.774,
0.468,0.998,1.100,0.988,0.616,0.903,1.010,0.995,0.912,0.835,
0.893,0.147,0.765,1.010,0.737,1.360,0.677,1.220,0.747,0.904,
0.812,0.928,0.109,0.119,0.170,0.175,0.795,0.114,0.730,0.979,
0.633,1.130,0.907,1.240,0.909,0.578,0.521,1.050,0.718,0.646,
0.867,0.960,0.934,0.108,0.766,1.330,1.170,1.210,1.180,2.040,
0.127,0.127,0.083,0.111,0.133,0.146,0.152,0.125,0.085,0.024,
0.058,0.076,0.076,0.107,0.068,0.105,0.191,0.239,0.182,0.289,
0.289,0.309,0.591,0.342,0.198,0.108,0.205,0.180,0.089,0.217,
0.132,0.125,0.073,0.137,0.093,0.097,0.025,0.045,0.048,0.035,
0.086,0.035,0.110,0.107,0.050,0.124,0.098,0.109,0.067,0.053,
0.041,0.067,0.100,0.118,0.099,0.093,0.067,0.016,0.058,0.073,
0.059,0.067,0.080,0.123,0.131,0.182,0.084,0.087,0.179,0.250,
0.219,0.123,0.136,0.074,0.092,0.091,0.058,0.140,0.067,0.072,
0.238,0.410,0.205,0.175,0.312,0.353,0.403,0.222,0.564,0.435,
0.388,0.333,0.127,0.455,0.154,0.124,0.111,0.281,0.146,0.114,
0.059,0.175,0.142,0.058,0.231,0.169,0.270,0.227,0.072,0.278,
0.210,0.140,0.073,0.075,0.047,0.054,0.131,0.208,0.152,0.117,
0.105,0.039,0.110,0.119,0.052,0.089,0.087,0.100,0.103,0.103,
0.063,0.071,0.193,0.271,0.294,0.145,0.151,0.059,0.138,0.111,
0.068,0.131,0.104,0.102,0.028,0.070,0.043,0.032,0.084,0.192,
0.214,0.071,0.076,0.116,0.163,0.098,0.020,0.087,0.066,0.038,
0.112,0.231,0.227,0.189,0.069,0.155,0.387,0.087,0.231,0.171,
0.325,0.220,0.073,0.279,0.286,0.182,0.068,0.062,0.066,0.069,
0.169,0.253,0.354,0.198,0.137,0.060,0.209,0.159,0.065,0.115,
0.154,0.134,0.104,0.088,0.068,0.080,0.077,0.081,0.070,0.065,
0.063,0.014,0.048,0.056,0.063,0.082,0.067,0.111,0.158,0.214,
0.126,0.144,0.211,0.306,0.251,0.186,0.176,0.069,0.172,0.181,
0.099,0.263,0.147,0.182,0.076,0.139,0.113,0.107,0.019,0.050,
0.049,0.029,0.125,0.044,0.146,0.157,0.068,0.172,0.163,0.150,
0.076,0.064,0.054,0.084,0.076,0.102,0.100,0.096,0.093,0.019,
0.104,0.137,0.093,0.130,0.140,0.186,0.911,1.060,0.629,0.959,
1.100,1.210,0.748,0.744,0.660,0.097,0.507,0.562,0.504,0.503,
0.375,0.561,1.460,1.650,0.869,0.939,2.270,1.720,2.080,1.180,
1.550,0.333,2.510,1.590,0.585,1.240,0.728,0.804,0.730,1.310,
0.797,0.837,0.174,0.283,0.239,0.242,0.849,0.190,0.992,1.010,
0.383,1.030,0.730,0.765,0.578,0.454,0.311,0.539,0.768,0.870,
0.672,0.755,0.822,0.114,0.690,0.850,0.536,0.582,0.670,1.150,
0.098,0.131,0.063,0.080,0.187,0.303,0.182,0.138,0.097,0.044,
0.136,0.103,0.048,0.098,0.058,0.074,0.155,0.257,0.127,0.103,
0.361,0.393,0.375,0.201,0.303,0.190,1.390,0.464,0.066,0.208,
0.132,0.098,0.088,0.252,0.135,0.105,0.054,0.153,0.147,0.058,
0.191,0.136,0.330,0.263,0.058,0.213,0.159,0.113,0.096,0.080,
0.043,0.068,0.151,0.247,0.162,0.172,0.112,0.038,0.147,0.158,
0.066,0.092,0.095,0.135,1.170,0.876,0.569,0.457,1.210,1.630,
1.400,0.936,0.987,0.262,1.210,0.898,0.453,0.839,0.825,0.743,
0.140,0.274,0.147,0.097,0.213,0.439,0.363,0.145,0.238,0.183,
0.539,0.245,0.080,0.279,0.204,0.126,0.923,1.280,1.070,0.739,
0.197,0.288,0.371,0.172,0.798,0.237,0.314,0.424,0.352,0.794,
0.866,0.662,0.482,0.420,0.428,0.350,0.859,1.170,1.210,0.825,
0.888,0.213,1.290,1.000,0.422,0.681,0.967,0.882,0.743,0.502,
0.369,0.482,0.609,0.561,0.405,0.374,0.480,0.077,0.418,0.430,
0.360,0.424,0.337,0.503,1.030,1.280,0.702,0.669,1.330,1.780,
1.240,0.844,1.180,0.272,1.520,1.280,0.565,1.350,0.842,0.792,
0.787,1.140,0.818,0.817,0.124,0.255,0.183,0.149,1.000,0.194,
1.130,1.060,0.491,1.170,0.930,0.874,0.582,0.481,0.378,0.555,
0.732,0.910,0.646,0.684,0.855,0.128,1.070,1.050,0.711,0.979,
0.946,1.030,1.110,0.684,0.429,0.799,0.690,0.571,0.412,0.508,
0.602,0.074,0.316,0.478,0.623,0.545,0.352,0.758,1.010,0.705,
0.404,0.531,0.861,0.559,0.632,0.524,0.681,0.083,0.462,0.500,
0.406,0.524,0.304,0.474,0.609,0.677,0.385,0.624,0.077,0.087,
0.069,0.114,0.557,0.071,0.373,0.577,0.415,0.575,0.432,0.684,
0.819,0.493,0.298,0.617,0.591,0.543,0.381,0.637,0.510,0.056,
0.326,0.533,0.593,0.500,0.523,1.120,1.370,1.150,0.638,0.914,
1.340,1.310,1.090,0.912,0.921,0.137,0.720,0.802,0.580,0.789,
0.431,0.764,1.620,1.690,0.886,0.963,1.840,1.690,1.860,1.410,
1.910,0.366,2.610,1.890,0.687,1.290,0.706,0.832,0.873,1.530,
0.735,0.836,0.144,0.275,0.207,0.191,1.090,0.229,1.080,1.430,
0.550,1.330,0.900,1.060,1.390,0.927,0.465,0.710,1.150,1.400,
0.984,1.220,0.892,0.176,0.802,1.100,0.687,0.845,0.718,1.280,
1.430,1.160,0.748,0.787,1.370,1.500,1.930,1.630,1.080,0.200,
0.904,1.020,0.673,0.892,0.817,1.100,0.190,0.178,0.193,0.129,
0.195,0.321,0.454,0.237,0.163,0.072,0.242,0.232,0.091,0.216,
0.145,0.148,1.090,1.670,1.020,1.030,0.190,0.255,0.309,0.233,
2.200,0.539,1.210,1.510,0.769,1.840,1.340,1.270,0.769,0.701,
0.597,0.641,1.270,1.400,1.550,1.370,1.160,0.196,1.250,1.460,
0.702,0.936,1.160,1.350,1.090,0.602,0.435,0.691,0.650,0.566,
0.536,0.543,0.612,0.078,0.401,0.531,0.630,0.545,0.455,0.909,
1.100,0.858,0.662,0.709,0.954,1.090,1.070,0.852,0.802,0.110,
0.790,1.020,0.637,0.856,0.658,0.916,0.947,1.200,0.753,1.020,
0.116,0.157,0.125,0.147,1.210,0.181,1.200,1.440,0.766,1.310,
1.230,1.360,1.060,0.676,0.551,1.000,1.040,1.110,0.980,1.130,
1.100,0.119,1.230,1.550,1.230,1.170,1.410,1.700,1.760,1.040,
0.888,1.660,1.030,0.768,0.625,0.761,0.956,0.099,0.427,0.718,
1.230,1.040,0.615,1.170,1.160,0.769,0.539,0.748,0.828,0.584,
0.583,0.563,0.734,0.081,0.470,0.559,0.668,0.847,0.448,0.688,
0.719,0.626,0.504,0.844,0.082,0.074,0.065,0.113,0.452,0.048,
0.287,0.405,0.442,0.550,0.422,0.699,1.020,0.512,0.477,1.040,
0.855,0.617,0.506,0.797,0.592,0.057,0.351,0.607,0.933,0.616,
0.631,2.170,1.300,0.795,0.535,0.871,0.915,0.672,0.465,0.609,
0.565,0.068,0.314,0.536,0.551,0.537,0.330,0.625,0.876,0.675,
0.549,0.690,0.616,0.445,0.395,0.405,0.693,0.107,0.374,0.551,
0.447,0.554,0.321,0.467,0.536,0.554,0.353,0.500,0.056,0.070,
0.045,0.060,0.493,0.057,0.264,0.401,0.407,0.518,0.351,0.463,
0.515,0.324,0.241,0.472,0.528,0.503,0.309,0.471,0.433,0.046,
0.284,0.533,0.461,0.381,0.374,0.780,1.160,0.582,0.483,0.704,
0.991,0.674,0.583,0.780,0.756,0.109,0.310,0.541,0.717,0.696,
0.452,0.864,0.094,0.079,0.056,0.083,0.092,0.089,0.072,0.076,
0.086,0.024,0.054,0.078,0.100,0.164,0.063,0.116,0.566,0.561,
0.554,0.678,0.067,0.069,0.100,0.104,0.523,0.080,0.311,0.436,
0.405,0.649,0.479,0.575,0.570,0.424,0.373,0.642,0.742,0.673,
0.650,0.788,0.972,0.296,0.483,0.710,0.663,0.905,0.618,1.030,
1.570,0.553,0.534,0.965,0.648,0.410,0.402,0.564,0.635,0.063,
0.347,0.534,0.908,0.616,0.447,1.040,1.040,0.649,0.457,0.748,
0.671,0.552,0.453,0.548,0.657,0.068,0.421,0.649,0.701,0.883,
0.478,0.960,0.619,0.541,0.454,0.679,0.056,0.052,0.048,0.080,
0.448,0.045,0.424,0.497,0.471,0.621,0.502,0.714,1.010,0.538,
0.564,1.270,0.673,0.518,0.537,0.984,0.815,0.092,0.573,0.967,
1.210,1.040,1.060,2.140,2.000,1.400,0.957,1.640,1.420,1.270,
1.060,1.220,0.977,0.140,0.541,0.915,1.130,1.170,0.733,1.340,
1.900,1.560,1.200,1.540,1.630,1.410,2.130,1.570,1.310,0.252,
1.080,1.260,0.842,1.290,0.875,1.040,0.847,1.010,0.717,0.945,
0.111,0.164,0.140,0.167,0.688,0.118,0.635,0.831,0.476,0.908,
0.714,0.998,0.900,0.571,0.473,0.783,1.040,1.040,0.742,0.931,
0.593,0.077,0.466,0.796,0.728,0.715,0.738,1.410,1.760,1.520,
0.873,1.300,1.830,1.860,1.220,1.560,0.978,0.219,0.585,0.827,
0.739,1.040,0.595,0.950,1.930,1.960,1.640,2.050,1.890,1.510,
1.450,1.260,1.940,0.624,1.280,1.600,0.847,1.760,0.897,0.999,
0.942,1.420,0.816,0.994,0.166,0.298,0.184,0.176,1.070,0.264,
0.863,1.200,0.573,1.490,0.951,1.190,0.699,0.599,0.464,0.688,
1.100,1.340,0.802,0.971,0.760,0.124,0.649,1.520,0.606,0.736,
0.717,1.190,1.220,0.863,0.571,0.916,1.530,1.590,1.380,1.380,
1.050,0.214,0.690,0.852,0.782,0.960,0.763,1.130,0.114,0.174,
0.109,0.145,0.195,0.344,0.288,0.193,0.155,0.101,0.183,0.192,
0.102,0.281,0.149,0.158,0.933,1.310,1.010,1.200,0.161,0.272,
0.277,0.225,1.200,0.289,1.010,1.190,0.631,1.550,1.290,1.290,
0.781,0.563,0.565,1.010,1.350,1.660,1.730,1.660,1.060,0.185,
1.060,1.380,0.767,0.950,1.270,1.700,1.130,0.716,0.615,0.910,
0.719,0.643,0.567,0.670,0.740,0.084,0.477,0.617,0.723,0.686,
0.619,1.090,1.390,1.310,0.843,1.150,1.210,1.510,1.200,1.150,
1.190,0.222,0.977,1.310,0.918,1.820,1.110,1.420,0.737,1.050,
0.860,1.010,0.083,0.139,0.111,0.126,0.800,0.124,0.789,1.030,
0.589,1.090,1.040,1.240,0.889,0.622,0.579,0.956,0.842,0.945,
0.730,1.040,0.828,0.100,0.803,1.310,1.020,1.130,1.280,2.050,
1.320,1.030,0.688,1.090,0.937,0.953,1.070,1.040,0.840,0.101,
0.418,0.600,0.894,0.699,0.445,0.736,1.440,1.540,0.665,0.872,
1.380,1.280,1.100,0.895,1.200,0.211,1.120,1.150,0.774,1.230,
0.656,0.851,0.773,1.250,0.826,0.885,0.120,0.230,0.212,0.192,
0.808,0.224,0.623,0.826,0.622,2.020,0.790,0.875,0.691,0.532,
0.372,0.653,0.767,0.906,0.723,0.793,0.789,0.109,0.575,0.875,
0.807,0.839,0.815,1.410,0.083,0.092,0.069,0.078,0.108,0.140,
0.107,0.098,0.066,0.017,0.055,0.061,0.057,0.086,0.051,0.075,
0.107,0.179,0.075,0.087,0.181,0.234,0.174,0.122,0.144,0.083,
0.226,0.175,0.064,0.166,0.083,0.085,0.057,0.137,0.077,0.068,
0.020,0.064,0.056,0.025,0.104,0.056,0.127,0.127,0.056,0.221,
0.142,0.108,0.064,0.061,0.039,0.064,0.100,0.161,0.108,0.115,
0.081,0.023,0.088,0.119,0.075,0.088,0.088,0.127,1.040,0.853,
0.520,0.562,1.100,1.380,1.170,0.831,0.876,0.219,0.894,0.794,
0.546,0.920,0.834,0.862,0.106,0.189,0.083,0.074,0.151,0.266,
0.195,0.104,0.139,0.093,0.277,0.141,0.083,0.249,0.154,0.115,
0.858,1.390,0.921,0.768,0.150,0.296,0.239,0.150,1.120,0.271,
0.587,0.843,0.497,1.310,1.010,0.850,0.621,0.566,0.443,0.508,
1.030,1.380,1.130,0.956,1.020,0.198,1.140,1.120,0.629,0.895,
1.050,1.120,0.944,0.647,0.422,0.634,0.678,0.638,0.444,0.466,
0.582,0.086,0.518,0.566,0.528,0.584,0.493,0.785,1.270,1.350,
0.720,0.866,1.230,1.520,0.955,0.808,1.240,0.227,1.500,1.390,
0.826,1.660,1.210,1.230,0.854,1.200,0.739,0.851,0.105,0.195,
0.126,0.124,1.030,0.165,0.931,1.100,0.655,1.420,1.080,1.110,
0.899,0.617,0.534,0.733,0.790,0.944,0.724,0.877,1.040,0.127,
1.130,1.350,1.010,1.170,1.250,1.570,1.840,0.864,0.569,1.110,
0.780,0.579,0.479,0.639,0.722,0.078,0.336,0.584,0.968,0.708,
0.436,1.050,1.100,0.734,0.358,0.565,0.791,0.549,0.417,0.499,
0.727,0.078,0.400,0.630,0.531,0.593,0.341,0.599,0.745,0.745,
0.423,0.797,0.077,0.081,0.056,0.112,0.523,0.067,0.314,0.561,
0.530,0.755,0.438,0.756,0.973,0.569,0.441,0.957,0.710,0.568,
0.445,0.777,0.682,0.061,0.436,0.790,0.976,0.706,0.736,1.820,
1.180,0.817,0.671,0.832,0.861,0.799,0.760,0.664,0.588,0.074,
0.382,0.608,0.592,0.635,0.401,0.786,1.060,0.973,0.484,0.678,
0.971,0.913,0.652,0.684,0.966,0.145,0.726,0.949,0.551,0.858,
0.459,0.729,0.669,0.886,0.476,0.673,0.065,0.114,0.072,0.086,
0.650,0.098,0.499,0.753,0.524,0.948,0.631,1.030,0.734,0.538,
0.364,0.648,0.720,0.760,0.546,0.801,0.681,0.075,0.534,0.888,
0.746,0.665,0.649,1.410,1.350,0.898,0.630,0.777,1.280,1.150,
0.979,1.130,0.993,0.162,0.682,0.934,0.873,0.975,0.838,1.320,
0.105,0.120,0.070,0.085,0.116,0.160,0.138,0.110,0.090,0.029,
0.103,0.113,0.095,0.159,0.096,0.135,1.140,1.450,0.874,1.100,
0.120,0.180,0.139,0.161,1.410,0.249,0.996,1.350,0.889,1.750,
1.320,1.560,0.988,0.840,0.637,0.903,1.260,1.310,1.210,1.460,
1.360,0.167,1.200,1.670,1.000,1.120,1.190,1.860,1.970,0.891,
0.606,1.120,0.947,0.737,0.555,0.735,0.971,0.100,0.524,0.860,
1.290,0.973,0.783,1.850,1.490,1.110,0.667,0.967,1.260,1.370,
0.876,0.959,1.200,0.125,0.915,1.310,1.080,1.270,0.888,1.580,
1.340,1.320,0.862,1.350,0.110,0.127,0.087,0.140,1.330,0.136,
1.060,1.560,1.170,1.680,1.460,2.000,1.950,1.050,0.884,1.820,
1.400,1.250,1.020,1.590,1.590,0.124,1.470,2.250,2.050,1.490,
1.700,2.500,2.680,1.730,1.390,3.000,1.780,1.130,0.931,1.340,
1.930,0.202,0.849,1.490,3.140,2.670,1.170,2.420,1.960,1.080,
0.792,1.190,1.180,0.794,0.577,0.700,1.130,0.094,0.556,0.790,
1.020,1.040,0.626,1.110,1.520,1.110,0.873,1.470,0.124,0.106,
0.085,0.180,0.802,0.077,0.401,0.641,0.931,0.997,0.643,1.060,
2.440,1.060,1.140,2.540,1.700,1.190,0.971,1.750,1.100,0.090,
0.576,1.030,1.910,1.190,1.030,2.170,2.130,1.070,0.728,1.300,
1.190,0.790,0.559,0.785,0.925,0.103,0.509,0.746,0.905,0.882,
0.475,0.958,1.250,0.789,0.482,0.720,0.730,0.498,0.383,0.441,
0.699,0.065,0.373,0.548,0.537,0.531,0.353,0.581,0.871,0.755,
0.530,0.778,0.074,0.075,0.055,0.084,0.844,0.099,0.353,0.501,
0.496,0.594,0.403,0.584,1.030,0.654,0.548,0.922,0.996,0.869,
0.620,0.875,0.787,0.063,0.446,0.675,0.829,0.672,0.614,1.250,
1.610,0.714,0.606,0.985,1.120,0.645,0.592,0.775,0.979,0.105,
0.397,0.708,0.988,0.816,0.623,1.230,0.109,0.082,0.051,0.087,
0.082,0.079,0.051,0.066,0.076,0.013,0.046,0.071,0.103,0.133,
0.070,0.121,0.772,0.547,0.560,0.635,0.069,0.052,0.053,0.070,
0.518,0.055,0.324,0.402,0.438,0.501,0.519,0.582,0.823,0.476,
0.488,0.800,0.949,0.713,0.570,0.778,0.750,0.070,0.443,0.697,
0.784,0.768,0.720,1.280,2.230,0.857,0.773,1.700,0.912,0.537,
0.572,0.775,1.060,0.096,0.455,0.786,1.490,0.921,0.752,1.760,
1.300,0.852,0.582,0.955,0.821,0.647,0.474,0.632,0.770,0.065,
0.458,0.725,0.844,0.835,0.599,1.060,0.957,0.675,0.606,0.849,
0.072,0.054,0.061,0.087,0.642,0.055,0.858,0.664,0.631,0.638,
0.615,0.815,1.560,0.790,0.767,1.560,0.900,0.651,0.618,0.982,
1.120,0.077,0.728,1.230,1.770,1.320,1.200,2.740,2.370,1.390,
0.934,1.770,1.250,0.924,0.657,0.856,0.862,0.090,0.393,0.752,
1.160,1.070,0.663,1.350,1.470,0.995,0.783,1.010,0.907,0.707,
0.557,0.615,0.668,0.072,0.444,0.622,0.573,0.665,0.458,0.773,
0.794,0.797,0.563,0.829,0.079,0.092,0.063,0.106,0.442,0.051,
0.275,0.389,0.435,0.575,0.392,0.659,1.000,0.574,0.547,1.020,
0.922,0.750,0.532,0.837,0.528,0.049,0.308,0.558,0.749,0.574,
0.613,1.280,1.450,1.040,0.482,0.864,1.030,0.982,0.477,0.621,
0.585,0.072,0.301,0.488,0.558,0.640,0.322,0.724,0.913,0.805,
0.401,0.528,0.723,0.519,0.423,0.477,0.525,0.071,0.353,0.482,
0.396,0.561,0.306,0.501,0.706,0.814,0.477,0.647,0.067,0.108,
0.064,0.081,0.472,0.078,0.269,0.397,0.387,0.630,0.340,0.549,
0.696,0.586,0.388,0.667,0.691,0.760,0.482,0.667,0.513,0.050,
0.278,0.543,0.480,0.538,0.378,0.845,0.956,0.609,0.421,0.710,
0.825,0.668,0.571,0.622,0.672,0.088,0.340,0.539,0.610,0.629,
0.473,0.896,0.062,0.074,0.039,0.064,0.060,0.098,0.059,0.059,
0.061,0.020,0.046,0.061,0.058,0.099,0.047,0.076,0.654,0.682,
0.576,0.682,0.070,0.096,0.061,0.069,0.503,0.059,0.348,0.439,
0.395,0.557,0.536,0.601,0.591,0.531,0.426,0.676,0.796,1.330,
0.561,0.714,0.630,0.062,0.427,0.652,0.540,0.568,0.568,0.983,
0.968,0.583,0.415,0.754,0.596,0.435,0.362,0.572,0.515,0.047,
0.248,0.424,0.732,0.494,0.406,1.000,0.726,0.677,0.393,0.627,
0.529,0.603,0.421,0.580,0.424,0.053,0.307,0.476,0.455,0.600,
0.358,0.676,0.588,0.564,0.464,0.632,0.045,0.050,0.036,0.058,
0.401,0.038,0.453,0.433,0.401,0.463,0.437,0.621,0.786,0.460,
0.482,0.770,0.564,0.552,0.429,0.647,0.648,0.057,0.447,0.867,
0.894,0.878,0.828,1.620,1.590,0.948,0.589,1.170,0.688,0.547,
0.366,0.607,0.720,0.081,0.346,0.576,0.864,0.846,0.406,0.960,
1.140,0.847,0.460,0.803,0.694,0.552,0.411,0.546,0.721,0.088,
0.483,0.605,0.741,0.976,0.426,0.787,0.759,0.819,0.748,0.996,
0.085,0.094,0.087,0.167,0.463,0.051,0.296,0.399,0.417,0.612,
0.386,0.669,0.953,0.607,0.637,1.320,0.740,0.620,0.555,1.040,
0.602,0.062,0.388,0.660,0.831,0.679,0.701,1.720,0.094,0.075,
0.040,0.076,0.074,0.076,0.042,0.055,0.055,0.011,0.031,0.048,
0.060,0.080,0.039,0.079,0.079,0.078,0.035,0.055,0.067,0.073,
0.042,0.047,0.060,0.014,0.047,0.055,0.061,0.091,0.037,0.064,
0.053,0.074,0.057,0.072,8.04e-3,0.016,0.016,0.013,0.051,0.011,
0.035,0.045,0.042,0.068,0.041,0.061,0.108,0.079,0.073,0.143,
0.118,0.131,0.103,0.173,0.072,9.63e-3,0.049,0.084,0.091,0.088,
0.080,0.166,0.734,0.502,0.312,0.477,0.538,0.561,0.420,0.433,
0.643,0.092,0.360,0.485,0.505,0.564,0.376,0.674,0.060,0.066,
0.032,0.045,0.049,0.066,0.043,0.040,0.057,0.015,0.045,0.051,
0.059,0.088,0.043,0.061,0.514,0.629,0.445,0.489,0.057,0.091,
0.064,0.061,0.508,0.065,0.269,0.358,0.317,0.468,0.345,0.443,
0.511,0.431,0.421,0.501,0.565,0.748,0.485,0.622,0.583,0.066,
0.392,0.532,0.448,0.504,0.481,0.754,0.781,0.456,0.294,0.578,
0.483,0.384,0.235,0.334,0.535,0.061,0.233,0.430,0.659,0.613,
0.313,0.812,0.804,0.629,0.362,0.575,0.602,0.607,0.369,0.435,
0.528,0.059,0.370,0.542,0.614,0.707,0.387,0.706,0.634,0.618,
0.431,0.562,0.059,0.077,0.045,0.060,0.610,0.049,0.317,0.439,
0.440,0.583,0.402,0.638,0.843,0.545,0.550,0.703,0.606,0.600,
0.427,0.593,0.771,0.074,0.534,0.791,0.933,0.921,0.763,1.430,
2.250,1.030,0.792,1.720,0.828,0.544,0.446,0.620,0.806,0.074,
0.381,0.692,1.490,0.885,0.606,1.630,1.050,0.553,0.390,0.714,
0.563,0.353,0.286,0.411,0.603,0.048,0.339,0.507,0.690,0.542,
0.368,0.755,0.929,0.692,0.719,1.370,0.078,0.064,0.057,0.154,
0.499,0.042,0.304,0.547,0.547,0.531,0.401,0.864,1.630,0.776,
1.090,2.940,0.963,0.660,0.680,1.500,0.760,0.058,0.516,0.878,
1.360,0.832,1.020,2.540,1.330,0.754,0.489,0.982,0.814,0.613,
0.453,0.600,0.622,0.063,0.353,0.603,0.695,0.628,0.410,0.932,
0.875,0.632,0.324,0.574,0.566,0.504,0.301,0.407,0.549,0.060,
0.374,0.538,0.565,0.571,0.315,0.579,0.701,0.606,0.483,0.890,
0.053,0.058,0.051,0.096,0.545,0.048,0.292,0.533,0.493,0.558,
0.360,0.714,1.050,0.612,0.610,1.600,0.953,0.790,0.696,1.700,
0.695,0.056,0.444,0.882,0.880,0.758,0.756,1.650,1.010,0.535,
0.422,0.757,0.772,0.565,0.471,0.748,0.801,0.088,0.447,0.719,
0.744,0.614,0.549,1.090,0.071,0.054,0.035,0.069,0.048,0.054,
0.039,0.051,0.057,7.40e-3,0.047,0.079,0.066,0.072,0.048,0.088,
0.598,0.569,0.460,0.700,0.049,0.049,0.042,0.074,0.593,0.057,
0.402,0.557,0.451,0.585,0.512,0.759,0.767,0.502,0.551,0.902,
0.808,0.721,0.640,1.030,0.898,0.069,0.598,0.918,0.793,0.700,
0.852,1.460,1.680,0.819,0.686,1.350,0.830,0.612,0.451,0.768,
0.990,0.086,0.460,0.822,1.400,0.873,0.740,1.970,0.955,0.652,
0.432,0.814,0.626,0.518,0.400,0.554,0.631,0.051,0.471,0.762,
0.760,0.718,0.522,1.080,1.040,0.851,0.670,1.170,0.079,0.070,
0.049,0.106,1.070,0.076,0.558,0.909,0.926,1.040,0.782,1.300,
1.900,0.975,1.090,2.330,1.350,1.130,0.945,1.660,1.700,0.106,
1.240,2.240,2.780,1.970,2.020,3.990,2.720,1.730,1.360,2.360,
1.890,1.280,0.934,1.190,1.360,0.182,1.090,1.330,2.040,1.740,
1.020,1.750,1.890,1.320,0.905,1.270,1.380,1.080,0.785,0.886,
1.020,0.128,0.761,0.872,0.850,1.080,0.739,1.000,1.080,0.986,
0.773,1.120,0.120,0.116,0.097,0.161,0.856,0.130,0.501,0.594,
0.666,0.862,0.651,0.906,1.500,0.837,0.684,1.520,1.440,1.030,
0.759,1.250,0.846,0.086,0.554,0.837,1.220,0.839,0.958,1.790,
2.130,1.460,1.020,1.380,1.690,1.300,0.797,0.912,1.130,0.193,
1.180,1.280,0.916,1.210,0.713,1.150,1.620,1.410,0.872,1.150,
1.240,1.130,0.851,0.886,1.090,0.187,0.907,1.070,0.667,1.030,
0.661,0.854,0.980,1.210,0.700,0.862,0.162,0.197,0.130,0.136,
3.070,0.574,0.735,0.803,0.903,1.450,0.723,0.751,0.776,0.637,
0.421,0.683,1.300,1.100,0.684,1.000,1.010,0.127,0.563,0.748,
0.762,0.783,0.787,1.180,1.370,0.842,0.626,0.875,1.900,1.030,
0.869,0.962,1.090,0.165,0.560,0.761,0.837,0.930,0.710,1.320,
0.115,0.123,0.071,0.114,0.151,0.171,0.111,0.130,0.114,0.038,
0.092,0.116,0.094,0.198,0.112,0.152,0.719,0.797,0.631,0.686,
0.106,0.100,0.097,0.120,0.800,0.125,0.515,0.659,0.492,0.832,
0.722,1.020,0.690,0.513,0.474,0.795,1.000,0.914,0.728,0.968,
0.931,0.111,0.612,0.870,0.779,0.951,0.920,1.430,1.510,0.763,
0.570,1.090,0.893,0.559,0.443,0.675,0.841,0.107,0.431,0.682,
0.998,0.823,0.573,1.460,1.340,1.030,0.677,1.150,1.150,1.110,
0.720,1.110,0.799,0.122,0.632,0.997,0.711,1.160,0.707,1.270,
0.709,0.710,0.543,0.798,0.076,0.072,0.072,0.101,0.735,0.129,
0.469,0.759,0.519,0.814,0.645,0.906,1.080,0.652,0.620,1.150,
0.736,0.660,0.561,0.822,0.925,0.090,0.701,1.240,1.200,1.150,
1.180,2.250,2.090,1.550,0.964,1.560,1.570,1.550,0.869,0.962,
0.885,0.123,0.495,0.774,1.040,1.100,0.673,1.250,1.710,1.450,
0.835,1.030,1.450,1.470,0.991,1.080,0.905,0.163,0.797,0.957,
0.588,1.020,0.667,0.837,0.732,0.937,0.684,0.838,0.104,0.162,
0.117,0.139,0.504,0.080,0.441,0.501,0.388,0.640,0.507,0.695,
0.809,0.527,0.446,0.902,0.929,1.090,0.633,0.821,0.707,0.077,
0.445,0.630,0.715,0.591,0.693,1.250,1.770,1.750,0.760,1.100,
1.770,2.550,1.000,1.040,0.873,0.156,0.607,0.760,0.621,0.984,
0.528,0.975,1.620,2.020,0.951,0.970,1.410,1.170,1.090,1.180,
1.070,0.285,0.957,1.090,0.564,1.420,0.686,0.855,0.856,1.540,
0.749,0.860,0.157,0.379,0.177,0.180,0.849,0.200,0.631,0.771,
0.435,1.130,0.728,0.806,0.690,0.716,0.435,0.638,1.030,1.720,
0.790,0.997,0.700,0.093,0.531,0.740,0.538,0.740,0.590,1.110,
1.150,0.861,0.496,0.773,1.440,1.480,1.010,0.922,1.150,0.274,
0.603,0.726,0.721,1.050,0.667,1.120,0.110,0.172,0.074,0.126,
0.145,0.332,0.208,0.151,0.212,0.134,0.150,0.152,0.080,0.298,
0.106,0.121,0.882,1.190,0.892,0.881,0.154,0.231,0.185,0.165,
0.895,0.168,0.693,0.772,0.463,1.050,0.906,0.900,0.698,0.581,
0.568,0.733,1.170,1.500,1.170,1.140,1.230,0.146,0.806,0.986,
0.829,0.880,0.999,1.360,1.030,0.695,0.453,0.761,0.857,0.693,
0.481,0.614,0.753,0.094,0.361,0.494,0.812,0.676,0.489,1.020,
1.070,1.120,0.657,1.010,1.030,1.460,1.090,1.470,0.876,0.225,
0.639,0.815,0.576,1.230,0.618,0.943,0.653,0.935,0.618,0.739,
0.065,0.104,0.073,0.094,0.596,0.083,0.596,0.661,0.442,0.757,
0.753,0.832,0.828,0.553,0.607,0.814,0.676,0.778,0.731,0.830,
0.733,0.073,0.627,1.050,0.882,1.050,1.080,1.800,1.200,1.020,
0.587,0.963,0.736,0.689,0.454,0.584,0.565,0.095,0.355,0.475,
0.680,0.973,0.429,0.733,1.150,1.230,0.566,0.773,0.955,1.140,
0.718,0.848,0.866,0.222,0.820,0.819,0.675,2.010,0.523,0.787,
0.643,0.989,0.926,0.919,0.096,0.155,0.195,0.228,0.546,0.105,
0.414,0.539,0.343,0.758,0.444,0.600,0.644,0.506,0.471,0.966,
0.689,0.757,0.798,1.170,0.569,0.074,0.439,0.666,0.645,0.668,
0.724,1.410,0.072,0.083,0.045,0.060,0.108,0.135,0.092,0.075,
0.058,0.019,0.056,0.060,0.052,0.105,0.071,0.072,0.093,0.141,
0.063,0.074,0.143,0.236,0.133,0.114,0.105,0.062,0.133,0.116,
0.068,0.238,0.072,0.083,0.057,0.130,0.133,0.095,0.027,0.063,
0.110,0.050,0.104,0.047,0.098,0.102,0.046,0.132,0.085,0.075,
0.066,0.067,0.056,0.104,0.127,0.204,0.220,0.317,0.076,0.018,
0.084,0.105,0.061,0.083,0.089,0.147,0.790,0.866,0.434,0.526,
0.844,1.290,0.765,0.629,0.821,0.172,0.680,0.791,0.515,0.834,
0.593,0.841,0.075,0.140,0.065,0.067,0.090,0.213,0.135,0.090,
0.107,0.050,0.127,0.111,0.067,0.201,0.092,0.102,0.649,1.430,
0.786,0.686,0.113,0.387,0.206,0.144,0.756,0.169,0.495,0.620,
0.389,0.961,0.657,0.748,0.519,0.579,0.499,0.620,0.850,1.690,
0.969,1.250,0.979,0.155,0.741,0.881,0.567,0.761,0.774,1.080,
0.868,0.758,0.374,0.649,0.629,0.680,0.335,0.397,0.621,0.085,
0.350,0.548,0.675,0.731,0.387,0.885,1.020,1.210,0.588,0.770,
1.050,1.720,0.868,0.832,0.871,0.174,0.809,1.120,0.669,1.350,
0.706,1.010,0.865,1.120,0.677,0.721,0.076,0.137,0.096,0.095,
0.779,0.123,0.610,0.780,0.537,1.040,0.673,0.874,0.762,0.672,
0.526,0.821,0.658,0.851,0.584,0.793,0.888,0.104,0.841,1.090,
0.958,1.200,1.020,1.650,1.380,0.778,0.628,1.190,0.793,0.556,
0.457,0.684,0.659,0.071,0.376,0.644,0.867,0.698,0.488,1.060,
0.854,0.615,0.424,0.602,0.586,0.518,0.361,0.513,0.550,0.068,
0.390,0.537,0.547,0.655,0.357,0.622,0.708,0.657,0.667,0.954,
0.061,0.065,0.064,0.146,0.458,0.055,0.336,0.493,0.390,0.488,
0.381,0.710,0.947,0.553,0.659,1.760,0.713,0.575,0.562,1.610,
0.635,0.057,0.426,0.815,0.943,0.618,0.756,1.860,1.340,0.991,
0.705,1.050,1.220,1.090,1.290,0.978,0.835,0.125,0.787,0.927,
0.774,0.975,0.634,1.030,1.080,1.110,0.595,0.840,1.070,1.240,
0.766,0.940,0.952,0.174,0.859,1.110,0.735,1.280,0.627,0.913,
0.780,1.060,0.919,1.320,0.100,0.159,0.210,0.297,0.890,0.132,
0.614,0.859,0.578,1.030,0.658,0.930,0.939,0.792,0.704,1.980,
1.440,1.550,1.560,6.820,0.839,0.104,0.768,1.350,0.837,0.983,
0.912,2.100,0.921,0.640,0.471,0.645,0.984,0.898,0.674,0.797,
0.829,0.135,0.585,0.831,0.670,0.794,0.634,1.060,0.079,0.080,
0.044,0.072,0.072,0.138,0.083,0.081,0.065,0.022,0.078,0.100,
0.059,0.121,0.068,0.096,0.663,0.906,0.654,0.851,0.078,0.125,
0.095,0.136,0.809,0.135,0.733,0.833,0.536,0.985,0.901,1.090,
0.647,0.573,0.548,0.853,0.963,1.120,0.945,1.600,0.974,0.111,
0.855,1.200,0.777,0.817,1.040,1.600,1.240,0.794,0.547,0.977,
0.763,0.651,0.483,0.631,0.811,0.096,0.432,0.716,0.849,0.681,
0.539,1.250,1.030,0.842,0.500,0.764,0.847,0.987,0.657,0.765,
0.647,0.083,0.602,0.888,0.679,0.913,0.575,1.050,0.970,0.956,
0.728,1.130,0.087,0.092,0.068,0.120,0.920,0.097,0.698,1.000,
0.831,1.150,0.973,1.310,1.320,0.826,0.822,1.610,1.110,1.140,
0.956,1.590,1.290,0.112,1.210,1.840,1.840,1.660,1.760,2.610,
1.710,1.050,0.845,1.490,1.230,0.834,0.641,0.787,0.847,0.100,
0.432,0.735,1.200,1.120,0.613,1.160,1.120,0.819,0.485,0.729,
0.920,0.645,0.561,0.664,0.604,0.071,0.382,0.513,0.568,0.649,
0.454,0.719,0.824,0.734,0.491,0.831,0.081,0.067,0.054,0.108,
0.506,0.053,0.308,0.467,0.443,0.622,0.441,0.669,1.000,0.530,
0.421,0.942,0.812,0.584,0.435,0.739,0.595,0.048,0.313,0.514,
0.810,0.490,0.572,1.210,1.610,1.090,0.596,1.100,1.330,1.050,
0.737,0.826,0.788,0.102,0.411,0.620,0.707,0.801,0.444,0.832,
1.330,1.390,0.523,0.767,1.140,0.786,0.686,0.776,0.920,0.155,
0.543,0.814,0.558,0.756,0.414,0.642,0.860,1.040,0.571,0.791,
0.117,0.133,0.098,0.136,0.860,0.127,0.541,0.798,0.477,0.876,
0.610,0.772,0.740,0.563,0.346,0.646,0.946,0.933,0.594,0.901,
0.732,0.070,0.442,0.726,0.636,0.609,0.622,1.150,1.220,0.709,
0.468,0.763,1.300,0.984,0.824,0.861,1.380,0.172,0.464,0.723,
0.947,1.110,0.593,1.120,0.122,0.134,0.060,0.097,0.128,0.153,
0.120,0.121,0.135,0.031,0.091,0.119,0.129,0.252,0.105,0.158,
0.780,0.819,0.687,0.823,0.114,0.102,0.135,0.150,1.100,0.125,
0.491,0.681,0.549,0.880,0.707,0.796,0.679,0.454,0.395,0.640,
1.040,0.909,0.917,1.060,0.916,0.102,0.534,0.827,0.823,0.812,
0.838,1.200,1.240,0.575,0.415,0.849,0.685,0.495,0.449,0.529,
0.679,0.076,0.308,0.498,0.902,0.752,0.501,1.090,1.010,0.847,
0.444,0.706,0.801,0.780,0.565,0.674,0.709,0.082,0.461,0.670,
0.665,0.884,0.548,0.918,0.800,0.840,0.624,0.892,0.089,0.088,
0.081,0.122,0.759,0.079,0.531,0.769,0.662,0.917,0.804,1.060,
1.090,0.682,0.535,1.140,0.803,0.686,0.639,0.942,1.090,0.095,
0.669,1.170,1.440,1.300,1.300,2.260,0.097,0.081,0.051,0.079,
0.087,0.085,0.063,0.068,0.054,9.90e-3,0.032,0.050,0.069,0.093,
0.050,0.088,0.092,0.094,0.065,0.073,0.103,0.112,0.128,0.098,
0.065,0.017,0.049,0.058,0.050,0.080,0.052,0.072,0.052,0.068,
0.043,0.062,9.40e-3,0.014,0.012,0.013,0.049,9.07e-3,0.036,0.053,
0.031,0.059,0.042,0.066,0.059,0.043,0.034,0.064,0.076,0.086,
0.052,0.074,0.052,6.62e-3,0.034,0.057,0.057,0.052,0.057,0.117,
0.091,0.090,0.042,0.062,0.100,0.140,0.079,0.074,0.059,0.018,
0.038,0.044,0.038,0.065,0.034,0.053,0.118,0.202,0.063,0.072,
0.201,0.273,0.144,0.141,0.127,0.068,0.081,0.095,0.055,0.129,
0.055,0.068,0.067,0.120,0.059,0.066,0.020,0.049,0.034,0.024,
0.111,0.045,0.077,0.101,0.043,0.114,0.076,0.088,0.058,0.051,
0.029,0.048,0.089,0.125,0.074,0.083,0.068,0.015,0.049,0.066,
0.043,0.056,0.053,0.090,0.080,0.052,0.030,0.045,0.086,0.107,
0.097,0.072,0.083,0.019,0.049,0.055,0.046,0.072,0.046,0.068,
0.015,0.019,9.69e-3,0.013,0.022,0.047,0.036,0.021,0.021,0.018,
0.031,0.025,7.21e-3,0.024,0.016,0.013,0.072,0.099,0.071,0.081,
0.023,0.036,0.048,0.024,0.231,0.042,0.082,0.085,0.058,0.115,
0.087,0.080,0.052,0.040,0.042,0.057,0.099,0.126,0.115,0.112,
0.099,0.018,0.068,0.094,0.058,0.092,0.079,0.099,0.082,0.064,
0.040,0.062,0.061,0.060,0.051,0.051,0.055,7.62e-3,0.030,0.042,
0.064,0.065,0.049,0.094,0.103,0.111,0.058,0.088,0.108,0.169,
0.093,0.109,0.087,0.021,0.072,0.088,0.063,0.127,0.072,0.107,
0.058,0.081,0.063,0.087,0.012,0.021,0.016,0.022,0.087,0.017,
0.069,0.088,0.051,0.095,0.088,0.117,0.082,0.059,0.047,0.085,
0.070,0.081,0.066,0.096,0.082,0.011,0.066,0.100,0.093,0.110,
0.107,0.189,1.030,0.805,0.494,0.829,0.830,0.733,0.453,0.579,
0.553,0.066,0.338,0.427,0.513,0.434,0.326,0.551,0.963,0.868,
0.424,0.603,1.050,0.863,0.811,0.665,0.731,0.121,0.779,0.732,
0.433,0.752,0.439,0.645,0.577,0.860,0.581,0.699,0.096,0.147,
0.113,0.171,0.531,0.083,0.449,0.536,0.315,0.647,0.451,0.617,
0.571,0.427,0.324,0.588,0.637,0.655,0.474,0.738,0.742,0.076,
0.493,0.676,0.556,0.520,0.655,1.270,0.079,0.077,0.035,0.056,
0.092,0.139,0.071,0.074,0.049,0.015,0.041,0.047,0.034,0.055,
0.029,0.051,0.081,0.115,0.042,0.047,0.129,0.137,0.104,0.085,
0.076,0.036,0.129,0.100,0.034,0.074,0.043,0.052,0.049,0.113,
0.058,0.061,0.018,0.049,0.040,0.025,0.068,0.031,0.085,0.086,
0.032,0.089,0.066,0.064,0.064,0.055,0.034,0.068,0.102,0.158,
0.087,0.129,0.073,0.016,0.075,0.104,0.052,0.063,0.077,0.133,
0.837,0.670,0.434,0.428,0.977,1.110,1.320,0.720,0.760,0.145,
0.649,0.640,0.459,0.624,0.556,0.662,0.090,0.139,0.060,0.062,
0.123,0.214,0.169,0.084,0.106,0.050,0.148,0.118,0.056,0.132,
0.088,0.081,0.793,1.130,0.843,0.703,0.129,0.182,0.202,0.134,
0.744,0.142,0.310,0.487,0.358,0.723,0.711,0.631,0.514,0.422,
0.386,0.408,0.934,1.050,0.973,0.842,0.720,0.115,0.769,0.791,
0.470,0.611,0.813,0.903,0.740,0.502,0.391,0.552,0.611,0.524,
0.493,0.391,0.493,0.064,0.337,0.421,0.453,0.438,0.328,0.580,
0.881,0.930,0.478,0.585,1.030,1.210,0.791,0.654,0.745,0.127,
0.829,0.853,0.488,0.932,0.593,0.718,0.798,1.010,0.819,0.888,
0.092,0.155,0.115,0.124,0.795,0.122,0.780,0.863,0.495,0.954,
0.788,0.876,0.687,0.531,0.439,0.732,0.746,0.820,0.638,0.772,
0.942,0.106,0.859,0.929,0.825,1.100,0.937,1.250,1.280,0.630,
0.442,0.868,0.642,0.465,0.338,0.473,0.532,0.059,0.273,0.449,
0.694,0.539,0.371,0.806,0.858,0.540,0.318,0.496,0.572,0.441,
0.362,0.416,0.484,0.049,0.312,0.467,0.388,0.455,0.312,0.545,
0.639,0.590,0.405,0.660,0.063,0.066,0.048,0.101,0.490,0.050,
0.311,0.527,0.425,0.502,0.385,0.691,0.796,0.463,0.363,0.792,
0.609,0.525,0.372,0.743,0.594,0.053,0.364,0.621,0.708,0.504,
0.592,1.340,1.380,0.880,0.480,0.918,1.040,0.914,0.617,0.708,
0.681,0.081,0.439,0.684,0.578,0.699,0.385,0.810,1.130,0.977,
0.423,0.679,0.994,0.924,0.722,0.767,0.815,0.106,0.648,0.986,
0.457,0.693,0.415,0.689,0.785,1.040,0.528,0.795,0.091,0.145,
0.084,0.136,0.714,0.104,0.580,0.909,0.483,0.885,0.636,0.911,
0.908,0.641,0.435,0.813,1.020,1.100,0.752,1.310,0.766,0.095,
0.657,1.250,0.679,0.744,0.749,1.530,2.650,0.811,0.543,0.761,
1.220,1.110,1.010,0.988,0.919,0.148,0.650,1.380,0.685,0.753,
0.647,1.180,0.399,0.110,0.068,0.114,0.111,0.174,0.141,0.115,
0.094,0.027,0.121,0.399,0.065,0.112,0.079,0.144,1.090,1.100,
0.754,0.959,0.104,0.126,0.123,0.146,1.120,0.176,0.716,1.090,
0.628,1.090,0.942,1.130,1.070,0.601,0.920,0.887,1.140,1.040,
1.120,1.290,0.987,0.119,0.928,1.460,0.839,0.824,1.120,1.520,
1.320,0.615,0.493,0.850,0.731,0.549,0.471,0.604,0.759,0.095,
0.411,0.735,0.717,0.600,0.506,1.170,1.290,0.697,0.446,0.762,
0.827,0.869,0.656,0.719,0.640,0.073,0.632,1.310,0.535,0.706,
0.552,1.060,1.060,1.080,0.791,1.250,0.092,0.104,0.080,0.136,
1.090,0.115,0.903,1.330,0.869,1.240,1.140,1.420,1.300,0.759,
0.680,1.510,1.110,1.020,0.938,1.320,1.220,0.103,1.100,1.700,
1.450,1.380,1.490,2.330,3.100,1.360,1.050,2.450,1.220,0.793,
0.594,0.868,1.170,0.117,0.475,0.834,1.860,1.420,0.726,1.630,
1.340,0.834,0.517,0.854,0.802,0.533,0.397,0.513,0.694,0.061,
0.371,0.485,0.864,0.879,0.490,0.831,0.965,0.763,0.534,1.050,
0.082,0.069,0.052,0.119,0.541,0.049,0.275,0.474,0.666,0.690,
0.484,0.878,1.460,0.726,0.631,1.480,0.987,0.711,0.527,0.959,
0.716,0.061,0.397,0.752,1.210,0.784,0.839,2.130,1.580,0.831,
0.520,1.010,0.879,0.605,0.421,0.542,0.562,0.061,0.266,0.457,
0.647,0.589,0.331,0.716,0.995,0.676,0.358,0.597,0.631,0.439,
0.317,0.456,0.545,0.053,0.276,0.445,0.501,0.488,0.325,0.557,
0.661,0.595,0.358,0.638,0.056,0.057,0.041,0.066,0.620,0.087,
0.237,0.413,0.478,0.619,0.366,0.558,0.636,0.405,0.277,0.590,
0.599,0.507,0.322,0.573,0.450,0.039,0.267,0.499,0.615,0.485,
0.473,0.996,1.250,0.589,0.452,0.823,0.976,0.632,0.625,0.779,
0.836,0.100,0.271,0.517,0.996,0.900,0.459,1.090,0.091,0.069,
0.040,0.079,0.081,0.070,0.065,0.080,0.074,9.23e-3,0.037,0.065,
0.118,0.140,0.054,0.129,0.645,0.639,0.453,0.674,0.063,0.055,
0.048,0.079,0.557,0.057,0.246,0.420,0.509,0.613,0.446,0.683,
0.702,0.430,0.385,0.772,0.780,0.588,0.507,0.808,0.678,0.072,
0.356,0.652,0.871,0.691,0.693,1.250,1.680,0.664,0.541,1.170,
0.738,0.452,0.523,0.616,0.787,0.072,0.349,0.608,1.400,0.833,
0.571,1.420,0.973,0.604,0.403,0.690,0.599,0.484,0.426,0.524,
0.636,0.051,0.340,0.584,0.810,0.781,0.468,0.991,0.775,0.687,
0.531,0.805,0.060,0.051,0.045,0.079,0.588,0.047,0.380,0.566,
0.707,0.777,0.657,1.010,1.400,0.730,0.677,1.580,0.854,0.653,
0.584,1.050,1.050,0.077,0.630,1.120,1.900,1.380,1.480,3.200,
1.930,1.130,0.748,1.580,1.110,0.792,0.585,0.769,0.834,0.086,
0.439,0.686,1.210,1.090,0.589,1.310,1.310,0.836,0.502,0.783,
0.880,0.735,0.597,0.620,0.730,0.073,0.441,0.557,0.678,0.750,
0.457,0.848,0.716,0.672,0.446,0.754,0.066,0.072,0.049,0.091,
0.484,0.056,0.289,0.463,0.472,0.643,0.443,0.790,0.823,0.527,
0.389,0.796,0.796,0.716,0.448,0.737,0.504,0.048,0.311,0.563,
0.738,0.669,0.719,1.510,1.410,0.947,0.463,0.847,1.060,1.000,
0.486,0.641,0.589,0.071,0.267,0.448,0.575,0.642,0.333,0.730,
1.040,0.979,0.388,0.632,1.110,1.080,0.517,0.685,0.675,0.120,
0.366,0.519,0.532,0.721,0.375,0.644,0.777,0.839,0.403,0.718,
0.082,0.113,0.062,0.089,0.746,0.106,0.333,0.578,0.468,0.814,
0.481,0.782,0.628,0.479,0.277,0.580,0.782,0.809,0.454,0.685,
0.545,0.051,0.303,0.623,0.578,0.697,0.575,1.120,0.944,0.540,
0.339,0.666,0.806,0.689,0.520,0.816,0.633,0.082,0.262,0.438,
0.601,0.619,0.403,0.885,0.059,0.052,0.028,0.053,0.061,0.114,
0.054,0.069,0.055,0.017,0.041,0.052,0.054,0.095,0.044,0.079,
0.705,0.818,0.472,0.732,0.073,0.080,0.061,0.093,0.936,0.092,
0.338,0.507,0.546,0.776,0.545,0.781,0.676,0.432,0.386,0.775,
0.840,0.805,0.732,0.989,0.746,0.064,0.440,0.722,0.742,0.664,
0.799,1.340,1.060,0.606,0.419,0.778,0.630,0.495,0.414,0.525,
0.653,0.059,0.302,0.475,0.811,0.638,0.470,1.050,0.899,0.726,
0.417,0.703,0.664,0.830,0.461,0.642,0.606,0.076,0.385,0.584,
0.624,0.901,0.509,0.968,0.655,0.696,0.554,0.830,0.054,0.060,
0.046,0.091,0.585,0.056,0.443,0.603,0.543,0.751,0.630,0.985,
0.948,0.571,0.527,1.010,0.811,0.717,0.632,1.510,0.848,0.069,
0.601,0.945,1.280,1.120,1.220,2.470,1.420,1.030,0.699,1.350,
1.080,0.904,0.758,0.933,0.873,0.085,0.433,0.675,0.896,0.704,
0.432,0.949,1.180,0.989,0.459,0.808,0.904,0.819,0.579,0.660,
0.822,0.098,0.576,0.762,0.723,0.962,0.513,0.954,0.837,1.010,
0.628,0.956,0.099,0.126,0.120,0.164,0.625,0.088,0.375,0.599,
0.515,1.010,0.555,0.881,0.917,0.635,0.439,0.949,0.848,0.795,
0.569,0.927,0.880,0.085,0.561,0.917,0.954,0.888,1.010,1.890,
0.087,0.077,0.052,0.079,0.179,0.135,0.066,0.076,0.055,9.32e-3,
0.032,0.048,0.056,0.063,0.036,0.078,0.072,0.080,0.033,0.052,
0.089,0.108,0.055,0.066,0.063,0.016,0.056,0.070,0.055,0.079,
0.046,0.077,0.051,0.073,0.042,0.059,9.46e-3,0.021,0.019,0.013,
0.057,0.016,0.044,0.058,0.041,0.090,0.053,0.080,0.078,0.058,
0.036,0.083,0.087,0.125,0.069,0.112,0.065,0.011,0.046,0.082,
0.083,0.088,0.093,0.172,1.020,0.751,0.468,0.632,0.998,1.060,
0.777,0.739,0.803,0.131,0.485,0.633,0.633,0.756,0.604,1.000,
0.071,0.088,0.039,0.056,0.088,0.121,0.070,0.063,0.075,0.022,
0.078,0.073,0.066,0.117,0.066,0.098,0.821,1.030,0.685,0.792,
0.091,0.135,0.111,0.107,0.805,0.123,0.416,0.629,0.497,0.899,
0.708,0.873,0.749,0.544,0.438,0.632,0.933,1.050,0.839,0.888,
0.996,0.111,0.767,0.954,0.788,0.871,1.020,1.400,1.150,0.786,
0.483,0.851,0.914,0.742,0.483,0.621,0.693,0.075,0.438,0.642,
0.784,0.687,0.501,1.110,1.200,1.040,0.549,0.847,1.220,1.090,
0.669,0.716,0.990,0.107,0.773,0.959,0.860,1.190,0.774,1.320,
1.150,1.150,1.010,1.180,0.094,0.117,0.098,0.124,1.020,0.104,
0.728,0.963,0.819,1.270,0.956,1.300,1.160,0.750,0.657,1.040,
0.896,0.932,0.721,0.959,1.220,0.105,1.010,1.200,1.420,1.440,
1.380,2.160,3.140,1.240,0.817,1.930,1.120,0.726,0.602,0.949,
1.020,0.097,0.476,0.934,1.420,1.070,0.692,1.980,1.320,0.796,
0.421,0.841,0.822,0.615,0.379,0.590,0.758,0.062,0.391,0.697,
0.675,0.672,0.427,0.977,1.130,0.958,0.593,1.290,0.080,0.080,
0.053,0.134,0.692,0.069,0.407,0.766,0.738,0.858,0.600,1.220,
1.750,0.950,0.716,1.780,1.040,0.807,0.617,1.310,1.060,0.085,
0.721,1.230,1.670,1.280,1.300,3.340,1.860,1.050,0.653,1.300,
1.370,1.020,0.578,0.850,0.751,0.077,0.409,0.743,0.833,0.819,
0.469,1.190,1.440,1.070,0.463,0.921,1.200,1.210,0.531,0.826,
0.873,0.085,0.525,0.916,0.717,0.829,0.479,1.170,1.040,1.020,
0.534,1.100,0.073,0.094,0.056,0.107,0.855,0.090,0.470,0.878,
0.826,1.150,0.689,1.440,1.130,0.741,0.504,1.190,0.994,0.982,
0.609,1.430,0.928,0.077,0.576,1.130,1.200,1.130,0.947,3.440,
1.900,0.999,0.733,1.100,1.430,1.100,0.850,1.300,1.170,0.147,
0.944,1.260,1.150,1.070,0.922,1.880,0.127,0.089,0.048,0.095,
0.089,0.105,0.068,0.104,0.070,0.014,0.139,0.176,0.092,0.119,
0.079,0.177,1.500,1.400,0.886,1.440,0.105,0.107,0.088,0.149,
1.280,0.137,0.957,1.200,1.080,1.440,1.540,1.950,1.530,0.979,
0.852,1.420,1.580,1.300,1.140,1.840,1.710,0.131,1.270,1.910,
1.580,1.310,1.780,2.940,3.610,1.570,0.976,2.220,1.450,1.030,
0.731,1.170,1.530,0.132,0.746,1.390,2.270,1.540,1.150,3.280,
1.980,1.340,0.786,1.570,1.350,1.160,0.819,1.380,1.260,0.100,
0.958,1.650,1.440,1.440,1.020,3.220,2.010,1.700,1.170,2.200,
0.110,0.109,0.085,0.182,1.770,0.137,1.250,2.020,1.890,2.160,
1.960,3.300,3.500,1.400,1.170,2.980,1.620,1.230,1.180,2.640,
2.150,0.131,1.620,3.010,2.380,1.920,1.770,4.570,7.920,2.880,
2.510,4.260,3.220,1.670,1.580,2.090,4.020,0.326,1.490,2.130,
4.670,2.850,2.030,3.460,3.990,1.880,1.460,1.860,2.060,1.120,
1.130,1.090,2.470,0.170,1.180,1.440,1.770,1.390,1.120,1.650,
4.370,2.140,1.660,2.270,0.276,0.187,0.159,0.298,2.100,0.174,
1.160,1.410,1.750,1.810,1.360,1.790,4.630,1.950,1.940,3.880,
2.760,1.880,1.660,2.660,2.340,0.191,1.270,1.900,3.120,1.800,
1.830,3.050,4.470,2.250,1.480,2.130,2.380,1.500,1.150,1.200,
2.130,0.214,0.981,1.360,1.700,1.650,0.939,1.590,2.660,1.560,
1.010,1.230,1.570,0.962,0.904,0.819,1.780,0.171,1.070,1.180,
1.010,1.070,0.781,0.960,2.200,1.670,1.140,1.390,0.200,0.155,
0.148,0.149,1.720,0.167,0.999,1.260,1.060,1.430,0.901,1.200,
1.720,1.040,0.859,1.340,1.640,1.150,1.420,1.320,1.700,0.127,
0.975,1.310,1.380,1.140,1.030,1.750,4.570,1.310,1.180,1.500,
1.750,1.030,1.070,1.040,2.250,0.235,0.920,1.410,1.610,1.300,
1.080,2.120,0.240,0.146,0.102,0.146,0.159,0.127,0.114,0.109,
0.179,0.026,0.123,0.159,0.189,0.233,0.143,0.234,1.490,1.020,
0.982,1.340,0.129,0.087,0.087,0.136,1.300,0.121,0.704,0.888,
0.843,1.060,0.840,0.979,1.340,0.753,0.755,1.270,1.430,1.000,
1.020,1.270,1.430,0.130,1.090,1.340,1.100,0.986,1.120,1.700,
4.200,1.650,1.410,2.710,1.570,0.893,0.965,1.130,2.170,0.212,
0.953,1.640,2.680,1.750,1.510,3.720,2.660,1.630,1.220,1.580,
1.750,1.080,1.100,1.080,1.820,0.137,1.210,1.670,1.780,1.590,
1.430,2.130,1.710,1.240,1.030,1.370,0.136,0.097,0.090,0.130,
1.460,0.103,0.869,1.240,1.210,1.280,1.150,1.430,2.410,1.230,
1.130,2.260,1.290,0.920,0.920,1.390,2.030,0.126,1.230,1.930,
2.300,1.610,1.690,2.900,3.720,2.040,1.450,2.270,1.850,1.320,
1.120,1.190,1.580,0.166,0.745,1.130,1.530,1.380,0.891,1.430,
2.230,1.550,0.912,1.150,1.390,0.913,0.904,0.821,1.260,0.190,
0.778,0.985,0.807,1.010,0.694,1.000,1.330,1.310,0.824,0.985,
0.131,0.147,0.105,0.127,1.100,0.120,0.963,0.814,0.711,1.090,
0.963,0.968,1.390,0.793,0.693,1.100,1.300,1.210,0.736,0.956,
1.200,0.198,0.686,0.933,1.030,0.918,0.848,1.540,2.520,1.760,
0.976,1.330,1.640,1.350,0.939,0.859,1.320,0.153,0.601,0.882,
0.887,1.130,0.549,0.903,1.490,1.150,0.629,0.731,0.973,0.567,
0.648,0.557,1.110,0.136,0.627,0.884,0.567,0.789,0.528,0.644,
1.200,1.480,0.738,0.845,0.124,0.220,0.092,0.096,1.210,0.183,
0.768,0.901,0.681,1.510,0.700,0.881,0.938,0.679,0.458,0.687,
1.050,1.040,0.602,0.681,1.480,0.115,0.569,0.936,0.824,0.851,
0.571,1.090,1.580,1.000,0.608,0.989,1.300,0.963,0.869,0.794,
1.140,0.155,0.579,0.905,0.753,0.872,0.644,1.070,0.104,0.118,
0.063,0.147,0.105,0.121,0.100,0.071,0.111,0.034,0.092,0.113,
0.073,0.171,0.084,0.107,0.961,0.997,0.797,0.812,0.098,0.106,
0.086,0.085,0.935,0.126,0.665,0.808,0.498,0.954,0.751,0.779,
0.713,0.467,0.484,0.613,0.934,0.905,0.722,0.838,0.874,0.091,
0.790,0.993,0.556,0.642,0.718,0.951,1.500,0.796,0.681,1.010,
0.909,0.623,0.857,0.612,0.855,0.082,0.443,0.718,0.903,0.697,
0.603,1.240,1.260,0.992,0.714,1.020,0.973,0.848,0.706,0.660,
0.877,0.097,0.628,0.973,0.700,0.977,0.702,1.100,0.927,0.909,
0.795,0.891,0.075,0.088,0.064,0.079,0.854,0.087,0.702,0.916,
0.657,0.904,0.801,1.040,1.100,0.651,0.630,0.973,0.860,0.709,
0.567,0.790,1.140,0.088,0.760,1.210,1.140,1.030,1.050,1.700,
3.310,1.610,1.200,2.040,1.240,0.783,0.616,0.735,2.530,0.163,
0.662,0.852,1.330,1.060,0.607,1.120,2.020,1.770,0.794,1.130,
1.090,0.809,0.651,0.666,1.440,0.154,0.763,0.884,0.843,1.080,
0.553,0.853,1.280,1.410,0.926,1.100,0.152,0.211,0.114,0.175,
0.987,0.117,0.609,0.749,0.676,1.070,0.614,1.110,1.370,1.180,
0.726,1.280,1.300,1.570,0.709,0.969,1.260,0.134,0.706,1.020,
1.150,0.893,0.921,2.020,0.201,0.147,0.086,0.133,0.163,0.122,
0.089,0.089,0.133,0.022,0.062,0.087,0.095,0.121,0.062,0.103,
0.163,0.135,0.065,0.081,0.119,0.105,0.081,0.070,0.131,0.031,
0.079,0.093,0.071,0.116,0.053,0.073,0.107,0.136,0.077,0.088,
0.018,0.032,0.024,0.017,0.112,0.027,0.090,0.099,0.072,0.143,
0.072,0.108,0.159,0.128,0.081,0.147,0.212,0.280,0.162,0.163,
0.152,0.020,0.115,0.149,0.130,0.127,0.110,0.213,1.270,0.753,
0.619,0.711,0.873,0.661,0.610,0.589,1.050,0.152,0.632,0.818,
0.632,0.703,0.561,0.819,0.101,0.095,0.049,0.066,0.071,0.072,
0.065,0.051,0.102,0.026,0.091,0.085,0.075,0.114,0.064,0.078,
0.899,0.901,0.612,0.613,0.089,0.100,0.075,0.078,0.972,0.132,
0.582,0.701,0.511,0.787,0.582,0.598,0.854,0.545,0.451,0.522,
0.765,0.791,0.625,0.666,1.000,0.141,1.170,1.120,0.569,0.727,
0.681,0.833,1.170,0.573,0.456,0.797,0.713,0.402,0.340,0.432,
0.790,0.078,0.393,0.738,0.871,0.622,0.432,0.960,1.220,0.845,
0.558,0.817,0.907,0.698,0.552,0.553,0.953,0.092,0.613,0.821,
0.888,0.927,0.570,0.831,1.030,0.914,0.613,0.770,0.097,0.103,
0.060,0.080,1.020,0.105,0.649,0.905,0.814,1.080,0.719,1.010,
1.020,0.577,0.577,0.745,0.867,0.759,0.571,0.682,1.150,0.102,
0.895,1.200,1.190,1.050,0.976,1.690,3.630,1.590,1.340,3.050,
1.230,0.682,0.674,0.854,1.500,0.130,0.568,0.989,1.980,1.200,
0.826,1.830,1.530,0.804,0.560,0.933,0.800,0.472,0.451,0.551,
1.020,0.084,0.498,0.756,0.752,0.647,0.435,0.786,1.180,0.851,
0.580,1.120,0.099,0.087,0.059,0.134,0.825,0.069,0.409,0.640,
0.727,0.745,0.502,0.935,1.630,0.833,0.779,1.800,1.130,0.826,
0.673,1.130,1.180,0.101,0.743,1.100,1.600,1.120,1.090,2.690,
2.330,1.200,0.875,1.460,1.560,0.874,0.791,0.823,1.290,0.131,
0.572,0.979,1.050,0.991,0.591,1.090,1.710,0.912,0.538,0.796,
1.010,0.689,0.505,0.567,1.150,0.208,0.581,0.916,0.707,0.875,
0.411,0.737,1.160,0.900,0.587,0.882,0.091,0.086,0.059,0.089,
0.950,0.092,0.570,0.881,0.711,0.925,0.553,0.937,1.260,0.699,
0.590,1.120,1.210,0.936,0.685,1.030,1.110,0.087,0.695,1.080,
1.080,0.936,0.785,1.650,1.300,0.787,0.598,1.080,1.020,0.619,
0.615,0.733,1.060,0.143,0.517,0.852,0.873,0.897,0.604,1.080,
0.086,0.070,0.046,0.083,0.065,0.057,0.057,0.055,0.086,0.014,
0.062,0.096,0.079,0.105,0.059,0.090,0.817,0.737,0.560,0.714,
0.063,0.056,0.068,0.074,0.939,0.083,0.514,0.697,0.695,0.721,
0.848,0.799,0.815,0.518,0.479,0.727,0.874,0.626,0.627,0.838,
0.992,0.104,0.681,1.050,0.786,0.734,0.760,1.170,2.350,0.896,
0.725,1.390,0.979,0.588,0.562,0.652,1.180,0.105,0.523,0.951,
1.510,0.988,0.828,1.950,0.958,0.562,0.418,0.720,0.611,0.368,
0.391,0.477,0.803,0.059,0.489,0.841,0.808,0.738,0.537,0.998,
1.370,1.040,0.745,1.110,0.103,0.073,0.059,0.093,1.200,0.098,
0.699,1.100,1.180,1.260,1.140,1.450,1.920,0.939,0.968,1.810,
1.260,1.030,0.820,1.220,1.700,0.096,1.170,1.910,2.460,1.630,
1.680,3.210,4.650,2.850,2.290,3.490,2.910,1.980,1.650,1.880,
2.600,0.286,1.350,1.880,3.200,2.510,1.540,2.420,2.840,2.070,
1.260,1.420,2.070,1.400,1.250,1.140,1.890,0.195,1.310,1.520,
1.270,1.450,1.080,1.470,1.640,1.500,1.100,1.360,0.191,0.159,
0.129,0.204,1.230,0.147,0.792,0.971,1.030,1.360,0.993,1.420,
2.050,1.270,0.971,1.890,1.820,1.420,1.020,1.530,1.510,0.143,
0.988,1.550,1.650,1.270,1.400,2.370,3.680,2.660,1.310,1.790,
2.970,2.400,1.370,1.270,2.060,0.290,1.120,1.420,1.400,1.820,
0.904,1.500,2.360,2.050,0.989,1.110,1.930,1.310,1.100,1.020,
1.810,0.298,1.340,1.650,0.927,1.430,0.846,1.220,1.950,2.010,
1.000,1.070,0.434,0.228,0.159,0.151,1.700,0.268,1.300,1.470,
0.953,1.920,1.160,1.260,1.300,0.945,0.536,0.847,1.970,1.310,
0.817,0.960,1.250,0.142,0.960,1.500,0.992,1.180,0.999,1.710,
1.780,1.150,0.759,1.000,1.720,1.220,0.965,0.939,1.980,0.264,
0.914,1.310,1.090,1.200,0.834,1.470,0.145,0.169,0.096,0.113,
0.177,0.203,0.143,0.127,0.175,0.054,0.156,0.180,0.117,0.261,
0.122,0.167,0.853,0.954,0.751,0.723,0.102,0.105,0.085,0.101,
0.976,0.149,0.751,0.941,0.558,0.923,0.731,0.802,0.850,0.538,
0.426,0.631,1.020,1.000,0.738,0.880,1.010,0.132,0.884,1.090,
0.723,0.853,0.972,1.310,2.000,1.090,0.753,1.440,0.960,0.632,
0.518,0.683,1.210,0.148,0.595,1.010,1.240,0.997,0.724,1.710,
1.760,1.680,0.937,1.190,1.390,1.190,0.945,0.947,1.220,0.146,
0.953,1.340,0.928,1.350,0.866,1.320,0.865,0.841,0.799,0.904,
0.095,0.077,0.082,0.096,0.819,0.091,0.679,0.863,0.627,0.902,
0.826,1.020,1.180,0.745,0.571,1.130,0.816,0.739,0.611,0.845,
1.330,0.110,0.969,1.480,1.370,1.280,1.400,2.350,3.100,2.190,
1.580,2.080,2.370,1.990,1.650,1.460,1.420,0.192,0.848,1.160,
1.290,1.470,0.887,1.440,2.610,2.010,1.200,1.230,2.180,1.570,
1.750,1.250,1.470,0.237,1.220,1.350,0.766,1.260,0.813,1.310,
1.080,1.420,0.936,0.932,0.144,0.197,0.157,0.160,0.941,0.137,
0.845,0.875,0.606,1.090,0.820,1.060,1.060,0.686,0.601,0.928,
1.170,1.240,0.822,0.949,0.850,0.102,0.701,0.989,0.842,0.769,
0.865,1.540,2.120,2.090,0.962,1.150,1.990,2.170,1.280,1.010,
1.390,0.227,0.929,1.100,0.780,1.310,0.628,0.960,1.370,1.410,
0.762,0.733,0.869,0.332,0.751,0.616,1.150,0.256,0.975,1.270,
0.505,1.100,0.709,0.800,1.050,1.840,0.891,0.893,0.189,0.298,
0.174,0.154,1.320,0.289,1.090,1.390,0.639,1.910,1.040,1.120,
0.760,0.683,0.412,0.577,1.110,1.390,0.702,0.787,1.000,0.136,
0.797,1.480,0.638,0.891,0.703,1.400,1.510,1.240,0.692,0.905,
2.020,1.920,1.400,1.160,1.620,0.357,0.945,1.370,0.875,1.750,
0.844,1.270,0.127,0.221,0.098,0.113,0.260,0.314,0.236,0.148,
0.236,0.143,0.243,0.202,0.108,0.604,0.139,0.141,0.902,1.360,
0.937,0.838,0.160,0.249,0.174,0.141,1.190,0.233,1.060,1.160,
0.540,1.490,1.080,0.975,0.678,0.572,0.470,0.583,1.280,1.980,
1.250,1.190,1.070,0.161,1.090,1.280,0.657,0.935,0.995,1.260,
1.150,0.835,0.562,0.842,0.935,0.735,0.567,0.598,0.793,0.104,
0.509,0.790,0.712,0.792,0.506,1.040,1.150,1.350,0.790,1.060,
1.290,1.350,0.957,0.883,1.120,0.239,0.889,1.140,0.626,1.630,
0.736,0.958,0.645,0.919,0.729,0.758,0.076,0.115,0.080,0.092,
0.688,0.098,0.787,0.854,0.486,0.947,0.820,0.908,0.742,0.528,
0.433,0.691,0.734,0.811,0.538,0.705,0.861,0.082,0.749,1.040,
0.814,1.020,0.981,1.500,2.150,1.640,1.170,1.540,1.610,1.210,
0.824,1.020,1.440,0.175,0.712,0.960,1.160,1.180,0.667,1.150,
1.880,1.890,0.860,1.120,1.700,1.540,1.150,1.110,2.190,0.330,
1.530,1.550,0.859,1.500,0.759,1.090,1.080,1.690,0.936,1.120,
0.162,0.241,0.164,0.233,1.260,0.217,0.910,1.140,0.761,1.370,
0.837,1.830,0.928,0.764,0.495,0.955,1.170,1.390,0.749,1.030,
1.280,0.159,0.993,1.350,1.090,0.915,0.971,2.040,0.160,0.162,
0.088,0.114,0.285,0.266,0.202,0.145,0.147,0.044,0.110,0.136,
0.092,0.169,0.083,0.124,0.145,0.196,0.086,0.097,0.225,0.285,
0.191,0.151,0.237,0.126,0.215,0.234,0.080,0.209,0.096,0.111,
0.099,0.222,0.121,0.103,0.043,0.096,0.068,0.041,0.198,0.097,
0.233,0.213,0.086,0.256,0.151,0.175,0.101,0.100,0.059,0.100,
0.234,0.340,0.165,0.192,0.166,0.039,0.198,0.227,0.111,0.143,
0.146,0.230,1.510,1.250,0.791,0.883,1.410,1.620,1.230,1.020,
1.620,0.342,1.180,1.350,0.906,1.320,0.910,1.140,0.137,0.217,
0.105,0.095,0.157,0.284,0.215,0.126,0.207,0.098,0.298,0.218,
0.100,0.249,0.132,0.116,0.951,1.700,0.941,0.878,0.167,0.292,
0.190,0.156,1.610,0.387,1.030,1.380,0.705,1.700,1.030,1.010,
0.750,0.750,0.540,0.643,1.300,2.240,1.180,1.170,1.800,0.407,
2.580,1.890,0.784,1.330,1.270,1.280,1.040,0.720,0.562,1.120,
0.737,0.550,0.436,0.641,0.878,0.132,0.602,1.600,0.733,0.742,
0.478,1.080,1.320,1.410,0.768,0.911,1.330,1.510,0.990,0.971,
1.480,0.230,1.290,1.600,0.869,1.580,0.875,1.080,0.895,1.400,
0.868,0.880,0.104,0.180,0.119,0.116,1.460,0.234,1.180,1.440,
0.833,1.800,1.100,1.260,0.797,0.612,0.475,0.699,0.844,0.983,
0.735,0.788,1.330,0.163,1.500,1.610,1.090,1.320,1.230,1.600,
1.930,1.060,0.852,1.620,1.110,0.666,0.659,0.969,1.100,0.108,
0.465,0.880,1.180,0.943,0.617,1.290,1.190,0.857,0.488,0.746,
0.791,0.584,0.479,0.696,0.914,0.096,0.532,0.798,0.657,0.693,
0.461,0.807,0.763,0.731,0.435,0.726,0.070,0.067,0.044,0.100,
0.611,0.070,0.366,0.620,0.548,0.636,0.450,0.857,0.946,0.544,
0.459,1.040,0.779,0.620,0.439,0.874,0.816,0.070,0.492,0.961,
1.020,0.725,0.759,1.920,2.010,1.310,0.960,1.270,1.720,1.320,
1.750,1.200,1.300,0.173,0.824,1.210,0.995,1.250,0.692,1.320,
1.470,1.240,0.616,0.837,1.370,1.200,0.875,0.963,1.480,0.305,
0.936,1.580,0.823,1.360,0.687,1.260,0.902,1.120,0.635,0.794,
0.105,0.136,0.090,0.112,1.010,0.155,0.890,1.240,0.743,1.320,
0.826,1.220,0.917,0.693,0.503,0.861,1.240,1.310,0.769,1.160,
1.030,0.111,0.894,1.350,0.984,1.080,1.000,1.910,1.020,0.785,
0.579,0.763,0.997,0.840,0.726,0.813,1.150,0.171,0.720,1.020,
0.798,0.923,0.763,1.230,0.077,0.085,0.052,0.074,0.084,0.111,
0.094,0.079,0.086,0.024,0.090,0.107,0.071,0.129,0.079,0.101,
0.659,0.835,0.537,0.672,0.070,0.085,0.067,0.091,0.891,0.134,
0.694,0.894,0.585,0.989,0.826,0.875,0.639,0.565,0.470,0.680,
0.871,0.883,0.654,0.956,1.130,0.155,1.080,1.320,0.754,0.875,
1.010,1.380,1.390,0.766,0.625,1.070,0.740,0.572,0.437,0.561,
0.922,0.105,0.563,0.946,0.903,0.725,0.664,1.390,0.969,0.765,
0.509,0.751,0.748,0.663,0.569,0.651,0.771,0.070,0.597,0.909,
0.738,0.811,0.654,1.020,0.920,0.967,0.655,0.908,0.076,0.080,
0.054,0.085,1.040,0.110,0.806,1.200,0.965,1.430,1.070,1.390,
1.250,0.802,0.795,1.370,1.130,1.210,0.854,1.100,1.500,0.117,
1.760,2.140,1.880,1.610,1.950,2.400,3.030,1.750,1.460,2.290,
1.840,1.230,1.120,1.250,1.860,0.190,0.828,1.190,1.970,1.540,
0.959,1.520,1.450,0.894,0.645,0.852,1.070,0.701,0.737,0.770,
1.040,0.110,0.655,0.732,0.748,0.779,0.565,0.762,1.170,0.985,
0.794,0.960,0.113,0.093,0.089,0.153,0.838,0.083,0.546,0.720,
0.665,0.816,0.633,0.843,1.520,0.921,0.629,1.180,1.170,0.834,
0.739,1.020,0.977,0.087,0.557,0.843,1.110,0.700,0.886,1.590,
2.850,1.760,1.170,1.660,2.180,1.670,1.490,1.400,1.830,0.228,
0.891,1.120,1.320,1.530,0.778,1.230,1.670,1.330,0.871,0.941,
1.430,0.916,1.140,0.981,1.600,0.245,1.000,1.200,0.870,1.210,
0.647,0.824,1.700,1.690,1.200,1.190,0.223,0.195,0.190,0.184,
1.670,0.221,1.120,1.340,1.060,1.600,1.030,1.080,1.210,0.844,
0.580,0.900,1.580,1.300,1.050,1.170,1.130,0.112,0.756,1.040,
0.901,0.872,0.995,1.430,2.440,0.961,0.829,1.160,2.100,1.380,
1.450,1.350,8.260,0.724,1.390,1.560,2.310,1.570,1.010,1.510,
0.190,0.163,0.105,0.138,0.232,0.209,0.204,0.183,0.490,0.084,
0.196,0.203,0.274,0.426,0.152,0.214,0.865,0.943,0.969,0.797,
0.120,0.144,0.122,0.134,1.280,0.221,0.806,0.800,0.667,1.330,
0.710,0.718,0.722,0.474,0.502,0.631,1.140,1.090,0.978,1.090,
1.250,0.142,0.797,0.953,0.829,0.823,0.840,1.240,1.920,0.776,
0.698,1.300,1.070,0.655,0.701,0.974,2.090,0.180,0.652,0.916,
2.040,1.160,0.734,1.610,1.440,0.892,0.765,0.925,1.370,0.892,
1.130,1.070,1.710,0.162,0.841,1.080,1.330,1.330,0.700,1.100,
0.985,0.897,0.948,1.000,0.101,0.091,0.095,0.132,1.030,0.114,
0.772,1.030,0.806,1.160,0.920,1.160,1.310,0.708,0.702,1.230,
0.905,0.741,0.775,1.080,1.420,0.118,0.977,1.550,1.790,1.360,
1.600,3.000,0.226,0.157,0.122,0.150,0.191,0.163,0.137,0.150,
0.153,0.023,0.093,0.101,0.135,0.152,0.094,0.123,0.268,0.159,
0.111,0.152,0.193,0.176,0.180,0.237,0.141,0.029,0.144,0.119,
0.088,0.122,0.092,0.112,0.110,0.134,0.112,0.109,0.022,0.027,
0.028,0.029,0.108,0.020,0.097,0.102,0.065,0.126,0.087,0.103,
0.121,0.088,0.066,0.112,0.162,0.150,0.133,0.146,0.133,0.019,
0.083,0.125,0.105,0.094,0.107,0.164,0.221,0.206,0.117,0.147,
0.246,0.268,0.214,0.153,0.183,0.048,0.109,0.115,0.106,0.181,
0.080,0.111,0.208,0.227,0.119,0.115,0.230,0.192,0.226,0.177,
0.205,0.052,0.156,0.171,0.087,0.161,0.096,0.102,0.167,0.243,
0.183,0.130,0.046,0.070,0.071,0.036,0.227,0.073,0.190,0.189,
0.090,0.239,0.156,0.142,0.122,0.099,0.073,0.097,0.267,0.265,
0.192,0.161,0.148,0.023,0.112,0.145,0.088,0.107,0.114,0.170,
0.167,0.117,0.080,0.096,0.223,0.237,0.213,0.148,0.453,0.096,
0.152,0.141,0.142,0.208,0.106,0.131,0.020,0.031,0.018,0.018,
0.041,0.064,0.062,0.036,0.066,0.050,0.057,0.040,0.021,0.074,
0.027,0.024,0.114,0.190,0.221,0.151,0.028,0.054,0.057,0.034,
0.297,0.136,0.181,0.168,0.108,0.415,0.153,0.126,0.089,0.070,
0.083,0.082,0.173,0.241,0.214,0.197,0.172,0.035,0.156,0.159,
0.087,0.130,0.128,0.150,0.200,0.149,0.115,0.153,0.156,0.129,
0.123,0.130,0.214,0.027,0.104,0.121,0.214,0.164,0.123,0.211,
0.260,0.238,0.206,0.191,0.340,0.326,0.342,0.271,0.363,0.064,
0.247,0.253,0.244,0.400,0.201,0.249,0.117,0.160,0.154,0.143,
0.020,0.036,0.029,0.031,0.172,0.034,0.160,0.196,0.113,0.212,
0.184,0.207,0.162,0.123,0.110,0.156,0.167,0.219,0.156,0.190,
0.199,0.024,0.165,0.241,0.198,0.203,0.223,0.340,1.710,1.010,
0.731,1.080,1.020,0.860,0.693,0.745,1.020,0.118,0.601,0.667,
0.719,0.663,0.466,0.669,1.150,0.935,0.593,0.645,1.040,0.953,
0.934,0.685,1.210,0.163,0.981,0.925,0.545,0.797,0.525,0.599,
0.937,1.120,1.450,0.929,0.163,0.214,0.625,0.252,1.470,0.195,
0.890,0.912,0.639,1.360,0.703,0.787,0.742,0.553,0.515,0.765,
0.950,0.913,1.460,1.010,1.070,0.128,0.763,1.010,0.766,0.733,
0.773,1.320,0.135,0.129,0.070,0.097,0.153,0.208,0.145,0.121,
0.106,0.026,0.083,0.089,0.063,0.098,0.052,0.079,0.104,0.118,
0.063,0.060,0.149,0.185,0.154,0.098,0.119,0.043,0.148,0.127,
0.059,0.093,0.055,0.057,0.107,0.197,0.458,0.125,0.034,0.071,
0.524,0.053,0.173,0.065,0.214,0.165,0.072,0.185,0.129,0.099,
0.105,0.083,0.088,0.102,0.181,0.238,0.579,0.214,0.140,0.025,
0.136,0.174,0.086,0.102,0.102,0.148,0.979,0.788,0.576,0.520,
1.100,1.380,1.400,0.836,1.180,0.220,1.080,0.909,0.526,0.718,
0.659,0.712,0.096,0.146,0.095,0.061,0.127,0.201,0.423,0.098,
0.151,0.057,0.274,0.158,0.085,0.147,0.114,0.087,0.910,1.140,
1.000,0.712,0.143,0.177,0.214,0.147,1.280,0.241,0.573,0.709,
0.477,0.849,0.772,0.691,0.535,0.425,0.390,0.402,0.773,0.933,
0.855,0.785,0.960,0.149,1.050,0.935,0.462,0.612,0.706,0.776,
0.795,0.518,0.414,0.573,0.621,0.512,0.400,0.432,0.723,0.092,
0.519,0.707,0.654,0.522,0.365,0.642,0.934,0.969,0.578,0.563,
1.060,1.110,1.310,0.691,1.120,0.171,1.150,1.100,1.170,1.080,
0.698,0.796,0.812,1.260,0.785,0.754,0.119,0.256,0.148,0.127,
1.160,0.166,1.190,1.220,0.691,1.130,0.934,0.968,0.665,0.514,
0.400,0.572,0.789,0.890,0.620,0.673,0.958,0.110,0.995,1.130,
0.774,0.839,0.864,1.130,1.530,0.748,0.610,1.090,0.723,0.493,
0.459,0.599,0.742,0.085,0.379,0.574,0.769,0.631,0.504,0.855,
0.889,0.560,0.416,0.522,0.569,0.425,0.415,0.424,0.551,0.051,
0.381,0.501,0.384,0.380,0.311,0.454,0.680,0.673,0.562,0.619,
0.065,0.065,0.081,0.096,0.607,0.064,0.372,0.517,0.475,0.657,
0.415,0.588,0.766,0.465,0.454,0.776,0.615,0.490,0.546,0.744,
0.764,0.065,0.393,0.623,0.824,0.582,0.632,1.200,1.830,1.310,
0.848,1.350,1.330,1.180,0.975,0.990,1.060,0.131,0.684,0.920,
0.856,1.010,0.587,1.040,1.280,1.160,0.653,0.801,1.240,1.300,
0.959,0.875,0.963,0.125,0.842,1.030,0.611,0.819,0.539,0.723,
1.140,1.510,1.850,1.080,0.107,0.167,0.493,0.157,1.130,0.162,
1.020,1.210,0.827,1.410,0.948,1.120,1.000,0.756,0.768,0.957,
1.170,1.270,1.520,1.290,1.090,0.119,0.845,1.160,0.901,1.000,
0.858,1.390,1.080,0.757,0.586,0.742,0.962,0.893,0.892,0.850,
1.160,0.157,0.758,1.030,0.745,0.738,0.637,1.010,0.087,0.109,
0.058,0.077,0.101,0.154,0.135,0.101,0.097,0.026,0.121,0.127,
0.077,0.114,0.074,0.094,0.797,1.820,0.735,0.784,0.083,0.133,
0.092,0.119,1.050,0.153,0.745,0.923,0.645,0.994,0.786,0.810,
0.649,0.643,0.491,0.629,0.895,0.986,0.883,1.140,0.980,0.106,
0.860,1.080,0.717,0.770,0.916,1.140,1.500,0.712,0.661,1.030,
0.781,0.606,0.568,0.598,0.972,0.134,0.571,0.933,0.939,0.617,
0.541,1.170,1.060,0.874,0.499,0.684,0.848,0.796,0.701,0.678,
0.793,0.078,0.648,0.900,0.775,0.702,0.572,0.841,0.926,1.120,
0.821,0.977,0.098,0.169,0.080,0.115,1.130,0.137,0.982,1.340,
0.967,1.260,1.070,1.210,1.340,0.801,0.767,1.260,1.220,1.800,
0.858,1.110,1.330,0.130,1.090,1.630,1.520,1.190,1.340,1.990,
3.070,1.570,1.440,2.870,1.560,0.867,0.796,1.130,1.640,0.143,
0.662,1.120,2.280,1.560,0.917,1.760,1.400,0.677,0.536,0.788,
0.859,0.455,0.447,0.514,0.892,0.067,0.579,0.576,0.736,0.656,
0.401,0.674,1.230,0.726,0.598,1.030,0.108,0.062,0.055,0.126,
0.697,0.057,0.388,0.586,0.661,0.682,0.493,0.857,1.800,0.853,
0.746,1.510,1.200,0.704,0.630,1.100,1.040,0.080,0.619,0.914,
1.470,0.874,0.971,2.200,1.830,0.895,0.628,1.110,0.989,0.598,
0.499,0.680,0.905,0.092,0.440,0.657,0.943,0.870,0.427,0.893,
1.030,0.611,0.396,0.600,0.631,0.315,0.365,0.463,0.716,0.063,
0.414,0.547,0.605,0.535,0.335,0.562,1.130,0.788,0.604,0.791,
0.140,0.064,0.052,0.077,0.746,0.064,0.388,0.559,0.628,0.687,
0.504,0.717,0.955,0.578,0.449,0.767,0.987,0.528,0.401,0.599,
0.685,0.047,0.374,0.618,0.703,0.542,0.546,1.190,1.610,0.643,
0.568,1.050,1.030,0.561,0.552,0.834,1.940,0.166,0.456,0.742,
1.680,1.000,0.594,1.330,0.132,0.073,0.052,0.099,0.099,0.063,
0.066,0.089,0.136,0.014,0.055,0.087,0.177,0.178,0.072,0.152,
0.686,0.501,0.532,0.664,0.065,0.043,0.043,0.074,0.641,0.070,
0.338,0.468,0.544,0.653,0.483,0.625,0.689,0.366,0.423,0.668,
0.793,0.509,0.504,0.742,0.710,0.060,0.419,0.665,0.780,0.594,
0.656,1.180,2.200,0.791,0.735,1.600,0.920,0.487,0.502,0.817,
1.710,0.142,0.569,0.914,2.920,1.490,0.882,2.210,1.490,0.698,
0.611,0.898,0.945,0.518,0.606,0.730,1.230,0.085,0.559,0.829,
1.410,1.120,0.653,1.280,1.020,0.746,0.714,0.974,0.078,0.054,
0.053,0.088,0.855,0.061,0.488,0.734,0.854,0.845,0.672,1.010,
1.590,0.763,0.758,1.520,0.942,0.702,0.648,1.010,1.400,0.088,
0.786,1.430,2.260,1.510,1.550,3.410,2.460,1.320,1.000,1.740,
1.390,0.930,0.788,0.948,1.180,0.122,0.610,0.855,1.330,1.200,
0.686,1.280,1.640,0.914,0.725,1.090,1.050,0.777,0.719,0.773,
0.908,0.102,1.360,0.824,0.658,0.737,0.591,0.834,0.974,0.864,
0.678,0.951,0.106,0.095,0.074,0.118,0.745,0.082,0.562,0.797,
0.604,0.847,0.586,0.930,1.040,0.607,0.520,0.924,0.996,0.792,
0.608,0.876,0.906,0.097,0.565,0.843,0.938,0.729,0.792,1.480,
1.840,1.180,0.713,1.190,1.350,1.030,0.771,0.799,0.944,0.122,
0.456,0.660,0.907,1.130,0.464,0.903,1.240,0.984,0.543,0.695,
0.989,0.679,0.643,0.671,0.879,0.114,0.578,0.726,0.576,0.753,
0.457,0.633,1.130,1.200,0.718,0.855,0.218,0.174,0.104,0.104,
1.040,0.141,0.633,0.858,0.682,1.170,0.697,0.946,0.867,0.629,
0.462,0.694,1.290,1.190,0.623,0.765,0.760,0.068,0.464,0.729,
0.672,0.625,0.598,1.100,1.390,0.714,0.513,0.848,1.080,0.802,
0.710,0.828,1.490,0.200,0.544,0.692,1.010,1.090,0.572,1.120,
0.081,0.083,0.052,0.078,0.097,0.102,0.091,0.089,0.122,0.036,
0.099,0.085,0.095,0.186,0.072,0.100,0.789,0.836,0.806,0.802,
0.081,0.094,0.079,0.096,1.030,0.206,0.534,0.725,0.638,1.340,
0.675,0.854,0.759,0.455,0.493,0.696,0.918,0.895,0.778,1.030,
0.924,0.088,0.608,0.865,0.747,0.702,0.791,1.240,1.500,0.796,
0.702,1.170,0.806,0.525,0.520,0.662,1.050,0.097,0.586,0.709,
1.280,0.925,0.722,1.460,1.300,0.938,0.817,0.949,1.060,0.826,
0.894,0.847,1.160,0.124,0.830,0.931,1.020,1.350,0.773,1.160,
0.831,0.786,0.734,0.991,0.079,0.086,0.061,0.098,0.772,0.079,
0.602,0.896,0.714,0.941,0.780,1.140,1.130,0.652,0.645,1.030,
1.000,1.010,0.766,0.992,1.100,0.090,0.749,1.300,1.380,1.110,
1.120,2.080,1.910,1.050,0.701,1.260,0.922,0.695,0.488,0.678,
1.110,0.108,0.495,0.739,1.000,0.842,0.507,0.901,1.400,1.060,
0.585,0.817,0.904,0.721,0.573,0.587,1.120,0.127,0.736,0.849,
0.758,0.981,0.559,0.840,1.100,1.170,0.865,1.080,0.124,0.141,
0.126,0.171,1.140,0.125,0.663,0.915,0.725,1.090,0.651,1.020,
1.010,0.675,0.503,0.953,0.886,0.781,0.635,0.853,1.340,0.133,
0.758,1.160,1.120,0.816,0.943,1.820,0.127,0.102,0.055,0.106,
0.105,0.114,0.064,0.085,0.094,0.020,0.060,0.076,0.081,0.123,
0.060,0.100,0.094,0.090,0.046,0.060,0.093,0.108,0.071,0.065,
0.097,0.021,0.086,0.083,0.063,0.099,0.053,0.071,0.091,0.121,
0.092,0.089,0.015,0.030,0.034,0.018,0.138,0.028,0.100,0.124,
0.083,0.148,0.086,0.114,0.114,0.083,0.059,0.113,0.140,0.161,
0.117,0.137,0.132,0.018,0.094,0.138,0.109,0.099,0.099,0.176,
1.140,0.739,0.523,0.668,0.918,0.913,0.727,0.720,0.999,0.173,
0.639,0.725,0.713,0.966,0.815,1.000,0.089,0.094,0.049,0.057,
0.077,0.101,0.088,0.059,0.102,0.025,0.108,0.085,0.087,0.155,
0.087,0.098,0.837,1.090,0.707,0.798,0.098,0.127,0.093,0.100,
1.090,0.152,0.610,0.759,0.589,1.060,0.724,0.843,0.761,0.551,
0.452,0.592,0.910,0.962,0.737,0.833,1.150,0.130,1.050,1.070,
0.752,0.877,0.965,1.190,1.160,0.607,0.472,0.832,0.697,0.511,
0.392,0.563,0.896,0.091,0.518,0.755,0.995,0.768,0.593,1.100,
1.280,0.975,0.666,0.815,0.978,0.887,0.712,0.702,1.280,0.120,
0.869,1.080,1.330,1.290,0.830,1.180,1.530,1.290,0.863,1.120,
0.124,0.168,0.083,0.110,1.310,0.129,0.949,1.160,1.440,1.430,
1.110,1.410,1.180,0.687,0.672,0.936,1.030,0.979,0.692,0.876,
1.410,0.115,1.140,1.350,1.460,1.310,1.290,1.940,3.170,1.120,
0.938,1.930,1.080,0.612,0.547,0.934,1.140,0.100,0.514,0.968,
1.410,0.942,0.729,1.650,1.280,0.689,0.480,0.764,0.782,0.479,
0.412,0.576,0.844,0.067,0.491,0.705,0.662,0.588,0.480,0.798,
0.994,0.795,0.581,1.070,0.081,0.072,0.059,0.126,0.763,0.067,
0.426,0.716,0.728,0.855,0.539,1.020,1.490,0.724,0.732,1.570,
0.934,0.630,0.670,1.110,1.120,0.084,0.720,1.260,1.690,1.000,
1.200,2.810,1.510,0.819,0.596,1.160,0.901,0.666,0.510,0.727,
0.799,0.080,0.445,0.757,0.814,0.775,0.542,1.150,0.967,0.654,
0.379,0.613,0.682,0.442,0.368,0.533,0.698,0.069,0.534,0.736,
0.564,0.624,0.481,0.774,0.887,0.842,0.737,0.895,0.064,0.070,
0.068,0.078,0.930,0.089,0.559,0.892,0.811,1.050,0.671,1.140,
1.060,0.650,0.632,1.100,0.957,0.758,0.625,0.971,0.940,0.073,
0.608,1.030,1.040,0.894,0.887,1.730,1.700,0.920,0.832,1.140,
1.180,0.876,0.819,1.190,1.380,0.158,0.689,1.130,1.200,1.110,
1.030,2.270,0.111,0.103,0.063,0.103,0.086,0.087,0.071,0.088,
0.092,0.014,0.072,0.097,0.110,0.130,0.095,0.167,1.050,1.220,
0.796,1.130,0.084,0.086,0.069,0.114,1.290,0.123,0.734,1.040,
0.933,1.230,0.955,1.380,1.300,0.893,0.830,1.120,1.370,1.060,
0.955,1.360,1.470,0.119,1.210,1.600,1.310,1.110,1.510,2.240,
3.330,1.270,1.110,2.290,1.270,0.850,0.747,1.100,1.740,0.136,
0.832,1.530,2.280,1.440,1.320,3.540,1.900,1.210,0.802,1.250,
1.330,1.130,0.778,1.030,1.470,0.101,0.885,1.450,1.570,1.330,
1.060,2.040,1.990,1.650,1.320,1.950,0.114,0.115,0.075,0.144,
1.870,0.138,1.390,2.080,2.030,2.060,1.910,2.690,3.830,1.680,
2.020,3.470,2.010,1.700,1.390,2.120,2.730,0.157,2.050,3.410,
3.890,2.280,2.750,4.300,0.315,0.174,0.135,0.216,0.199,0.128,
0.113,0.121,0.215,0.027,0.106,0.131,0.197,0.175,0.116,0.154,
0.243,0.169,0.096,0.102,0.165,0.108,0.102,0.083,0.164,0.023,
0.104,0.102,0.101,0.115,0.083,0.096,0.160,0.125,0.098,0.107,
0.018,0.019,0.018,0.018,0.128,0.019,0.130,0.095,0.088,0.122,
0.174,0.104,0.190,0.093,0.092,0.145,0.153,0.112,0.099,0.130,
0.131,0.023,0.090,0.111,0.126,0.100,0.108,0.137,0.250,0.168,
0.100,0.131,0.172,0.151,0.112,0.103,0.155,0.029,0.093,0.108,
0.095,0.133,0.073,0.100,0.189,0.166,0.088,0.093,0.149,0.125,
0.105,0.079,0.151,0.040,0.123,0.126,0.069,0.117,0.081,0.081,
0.116,0.143,0.083,0.088,0.019,0.037,0.024,0.016,0.137,0.039,
0.120,0.116,0.065,0.154,0.091,0.103,0.097,0.073,0.057,0.085,
0.122,0.118,0.092,0.102,0.131,0.020,0.100,0.142,0.090,0.095,
0.089,0.146,0.152,0.077,0.062,0.080,0.111,0.080,0.076,0.071,
0.133,0.025,0.071,0.089,0.079,0.086,0.073,0.108,0.021,0.017,
9.30e-3,0.010,0.020,0.017,0.015,0.011,0.019,0.010,0.019,0.017,
0.012,0.024,0.014,0.016,0.070,0.068,0.062,0.057,0.011,0.013,
0.013,0.010,0.116,0.030,0.072,0.068,0.049,0.084,0.066,0.059,
0.067,0.043,0.038,0.054,0.081,0.078,0.065,0.075,0.093,0.018,
0.139,0.092,0.060,0.074,0.084,0.095,0.177,0.083,0.066,0.115,
0.093,0.060,0.069,0.063,0.116,0.012,0.052,0.083,0.119,0.091,
0.078,0.149,0.185,0.121,0.080,0.087,0.177,0.094,0.086,0.073,
0.129,0.017,0.089,0.108,0.098,0.121,0.083,0.121,0.088,0.086,
0.083,0.083,0.012,0.012,0.014,0.012,0.112,0.017,0.081,0.094,
0.074,0.098,0.085,0.088,0.114,0.067,0.060,0.101,0.084,0.066,
0.063,0.095,0.127,0.013,0.094,0.143,0.117,0.112,0.114,0.190,
0.243,0.200,0.124,0.155,0.190,0.172,0.145,0.110,0.170,0.032,
0.093,0.140,0.109,0.136,0.125,0.124,0.200,0.251,0.112,0.105,
0.189,0.160,0.171,0.104,0.152,0.052,0.148,0.129,0.068,0.129,
0.088,0.083,0.109,0.167,0.109,0.086,0.023,0.049,0.034,0.020,
0.264,0.042,0.220,0.127,0.088,0.199,0.327,0.122,0.104,0.089,
0.065,0.081,0.141,0.180,0.098,0.091,0.233,0.136,0.114,0.135,
0.102,0.187,0.109,0.137,0.229,0.234,0.108,0.122,0.204,0.301,
0.179,0.122,0.160,0.049,0.104,0.114,0.072,0.144,0.070,0.091,
0.176,0.237,0.104,0.093,0.185,0.151,0.185,0.107,0.178,0.078,
0.157,0.173,0.066,0.167,0.108,0.086,0.126,0.319,0.122,0.109,
0.040,0.162,0.057,0.028,0.207,0.097,0.187,0.185,0.093,0.382,
0.161,0.139,0.089,0.091,0.053,0.068,0.150,0.266,0.112,0.097,
0.180,0.040,0.105,0.140,0.082,0.138,0.081,0.160,0.117,0.104,
0.055,0.068,0.142,0.150,0.142,0.083,0.118,0.035,0.091,0.097,
0.053,0.111,0.076,0.081,0.022,0.049,0.015,0.013,0.037,0.057,
0.051,0.016,0.037,0.046,0.052,0.035,8.94e-3,0.049,0.020,0.014,
0.081,0.136,0.160,0.078,0.027,0.055,0.047,0.020,0.144,0.058,
0.129,0.116,0.047,0.155,0.126,0.085,0.059,0.047,0.051,0.050,
0.109,0.152,0.130,0.102,0.108,0.029,0.122,0.120,0.046,0.085,
0.096,0.092,0.098,0.069,0.060,0.069,0.080,0.068,0.198,0.059,
0.073,0.012,0.052,0.058,0.058,0.064,0.052,0.078,0.124,0.151,
0.080,0.079,0.135,0.131,0.107,0.074,0.101,0.036,0.100,0.104,
0.062,0.160,0.082,0.092,0.071,0.108,0.089,0.081,0.011,0.024,
0.019,0.012,0.110,0.025,0.113,0.111,0.059,0.115,0.116,0.098,
0.096,0.065,0.056,0.069,0.090,0.089,0.065,0.080,0.122,0.026,
0.098,0.126,0.095,0.126,0.115,0.152,0.155,0.147,0.071,0.095,
0.123,0.085,0.059,0.057,0.107,0.017,0.053,0.061,0.069,0.083,
0.042,0.064,0.164,0.458,0.094,0.089,0.113,0.120,0.089,0.068,
0.130,0.042,0.103,0.104,0.057,0.132,0.059,0.069,0.080,0.149,
0.082,0.081,0.016,0.028,0.019,0.020,0.093,0.023,0.084,0.082,
0.050,0.103,0.071,0.077,0.073,0.065,0.047,0.066,0.099,0.110,
0.060,0.074,0.099,0.020,0.069,0.087,0.075,0.078,0.075,0.132,
0.018,0.021,9.05e-3,0.011,0.024,0.032,0.021,0.015,0.020,0.016,
0.015,0.015,8.40e-3,0.021,8.17e-3,0.010,0.021,0.042,0.014,0.012,
0.028,0.042,0.030,0.017,0.029,0.030,0.034,0.027,9.32e-3,0.028,
0.013,0.011,0.012,0.031,0.014,0.012,7.33e-3,0.024,0.018,6.54e-3,
0.026,0.021,0.037,0.024,9.21e-3,0.034,0.021,0.016,0.011,0.012,
7.62e-3,0.011,0.026,0.042,0.023,0.022,0.021,9.15e-3,0.023,0.024,
0.012,0.017,0.015,0.023,0.077,0.073,0.042,0.051,0.074,0.083,
0.090,0.051,0.102,0.029,0.077,0.066,0.044,0.070,0.057,0.055,
0.011,0.026,0.011,8.00e-3,0.014,0.023,0.025,8.59e-3,0.021,0.018,
0.028,0.018,8.15e-3,0.023,0.013,8.46e-3,0.062,0.111,0.071,0.054,
0.016,0.034,0.031,0.013,0.125,0.052,0.099,0.096,0.041,0.111,
0.091,0.063,0.051,0.042,0.037,0.035,0.071,0.100,0.086,0.066,
0.121,0.031,0.135,0.107,0.049,0.086,0.077,0.075,0.069,0.044,
0.031,0.067,0.049,0.036,0.034,0.030,0.072,0.011,0.033,0.048,
0.056,0.049,0.032,0.058,0.093,0.103,0.058,0.059,0.088,0.096,
0.076,0.056,0.107,0.026,0.084,0.090,0.081,0.107,0.064,0.070,
0.074,0.102,0.073,0.061,0.011,0.028,0.017,0.010,0.113,0.030,
0.097,0.099,0.065,0.117,0.086,0.080,0.071,0.048,0.045,0.049,
0.071,0.085,0.062,0.059,0.118,0.019,0.107,0.116,0.086,0.102,
0.092,0.124,0.177,0.112,0.075,0.134,0.081,0.061,0.049,0.052,
0.089,0.012,0.041,0.068,0.107,0.088,0.056,0.103,0.097,0.097,
0.045,0.066,0.061,0.047,0.043,0.046,0.072,9.05e-3,0.042,0.060,
0.050,0.063,0.040,0.059,0.070,0.073,0.049,0.076,9.30e-3,0.011,
7.79e-3,0.013,0.072,8.42e-3,0.040,0.053,0.048,0.066,0.053,0.066,
0.091,0.052,0.050,0.102,0.082,0.065,0.052,0.077,0.083,0.012,
0.052,0.074,0.103,0.091,0.078,0.164,0.169,0.125,0.073,0.106,
0.137,0.125,0.084,0.084,0.130,0.027,0.074,0.098,0.090,0.149,
0.065,0.094,0.143,0.141,0.067,0.087,0.132,0.135,0.087,0.082,
0.132,0.037,0.100,0.142,0.067,0.138,0.061,0.083,0.085,0.112,
0.059,0.076,0.014,0.025,0.015,0.014,0.113,0.026,0.094,0.104,
0.071,0.144,0.087,0.099,0.085,0.062,0.048,0.074,0.113,0.119,
0.077,0.105,0.109,0.015,0.085,0.108,0.092,0.116,0.086,0.150,
0.087,0.079,0.041,0.066,0.078,0.065,0.062,0.057,0.108,0.025,
0.063,0.080,0.079,0.094,0.066,0.096,7.88e-3,0.012,6.20e-3,0.012,
9.11e-3,0.013,0.012,7.81e-3,0.012,7.25e-3,0.016,0.017,9.02e-3,0.016,
0.011,0.012,0.057,0.078,0.092,0.063,0.010,0.014,0.030,0.012,
0.084,0.020,0.068,0.074,0.052,0.086,0.203,0.090,0.053,0.042,
0.040,0.051,0.080,0.075,0.101,0.078,0.121,0.036,0.096,0.102,
0.066,0.095,0.098,0.104,0.136,0.068,0.049,0.085,0.070,0.052,
0.044,0.048,0.114,0.011,0.043,0.073,0.098,0.078,0.071,0.133,
0.077,0.056,0.039,0.059,0.061,0.047,0.051,0.055,0.079,0.010,
0.054,0.084,0.068,0.080,0.058,0.091,0.090,0.094,0.074,0.089,
0.013,0.012,0.012,0.010,0.129,0.018,0.086,0.131,0.093,0.129,
0.255,0.158,0.127,0.071,0.069,0.119,0.108,0.101,0.088,0.103,
0.158,0.015,0.123,0.177,0.185,0.152,0.182,0.265,0.230,0.175,
0.128,0.168,0.178,0.159,0.116,0.112,0.155,0.032,0.102,0.122,
0.148,0.158,0.090,0.121,0.200,0.179,0.107,0.105,0.206,0.166,
0.160,0.111,0.154,0.043,0.148,0.139,0.084,0.143,0.095,0.107,
0.097,0.116,0.084,0.083,0.016,0.025,0.021,0.018,0.088,0.025,
0.081,0.074,0.057,0.101,0.078,0.089,0.104,0.073,0.067,0.099,
0.116,0.113,0.083,0.097,0.102,0.017,0.079,0.113,0.089,0.082,
0.086,0.132,0.230,0.209,0.101,0.131,0.209,0.239,0.141,0.108,
0.158,0.048,0.125,0.124,0.080,0.150,0.093,0.105,0.201,0.272,
0.115,0.113,0.230,0.231,0.171,0.133,0.198,0.106,0.202,0.222,
0.073,0.185,0.103,0.145,0.112,0.212,0.100,0.082,0.040,0.081,
0.061,0.028,0.167,0.095,0.203,0.172,0.067,0.233,0.137,0.128,
0.069,0.072,0.045,0.056,0.134,0.137,0.116,0.093,0.111,0.032,
0.112,0.302,0.065,0.098,0.097,0.236,0.101,0.081,0.048,0.060,
0.137,0.116,0.096,0.078,0.159,0.041,0.088,0.089,0.061,0.103,
0.063,0.084,0.015,0.026,0.014,0.012,0.042,0.056,0.034,0.020,
0.032,0.032,0.044,0.030,0.011,0.051,0.018,0.016,0.056,0.083,
0.067,0.047,0.016,0.026,0.023,0.013,0.085,0.038,0.101,0.089,
0.039,0.088,0.072,0.059,0.072,0.039,0.031,0.037,0.073,0.092,
0.072,0.067,0.086,0.026,0.099,0.097,0.047,0.075,0.079,0.092,
0.105,0.059,0.042,0.075,0.062,0.044,0.033,0.042,0.073,0.011,
0.042,0.052,0.069,0.068,0.043,0.090,0.116,0.113,0.068,0.075,
0.141,0.122,0.086,0.081,0.100,0.027,0.089,0.108,0.059,0.128,
0.066,0.085,0.059,0.070,0.164,0.092,8.42e-3,0.015,0.018,0.012,
0.068,0.021,0.083,0.075,0.038,0.083,0.074,0.070,0.070,0.050,
0.044,0.065,0.054,0.063,0.050,0.056,0.098,0.015,0.079,0.106,
0.077,0.091,0.092,0.139,0.214,0.208,0.135,0.145,0.231,0.274,
0.210,0.143,0.140,0.038,0.112,0.115,0.088,0.142,0.083,0.100,
0.264,0.265,0.163,0.124,0.386,0.354,0.465,0.198,0.189,0.094,
0.235,0.190,0.071,0.186,0.108,0.109,0.100,0.170,0.115,0.086,
0.025,0.059,0.051,0.027,0.112,0.045,0.151,0.112,0.074,0.137,
0.112,0.099,0.073,0.057,0.053,0.071,0.116,0.152,0.101,0.091,
0.081,0.026,0.091,0.098,0.110,0.083,0.082,0.142,0.228,0.292,
0.115,0.114,0.301,0.507,0.240,0.142,0.193,0.081,0.161,0.154,
0.074,0.175,0.085,0.102,0.203,0.309,0.134,0.111,0.188,0.163,
0.210,0.144,0.217,0.207,0.214,0.232,0.078,0.294,0.151,0.131,
0.113,0.332,0.139,0.111,0.056,0.258,0.121,0.048,0.214,0.175,
0.230,0.284,0.079,0.390,0.207,0.177,0.072,0.090,0.057,0.059,
0.152,0.331,0.136,0.124,0.132,0.059,0.156,0.206,0.068,0.140,
0.107,0.351,0.121,0.133,0.066,0.066,0.296,0.306,0.224,0.129,
0.207,0.098,0.152,0.134,0.082,0.301,0.100,0.102,0.029,0.075,
0.030,0.019,0.139,0.201,0.141,0.043,0.096,0.142,0.118,0.066,
0.030,0.216,0.046,0.026,0.087,0.195,0.133,0.092,0.044,0.132,
0.096,0.034,0.154,0.098,0.185,0.160,0.052,0.231,0.171,0.112,
0.062,0.053,0.045,0.045,0.140,0.260,0.204,0.134,0.137,0.056,
0.197,0.159,0.065,0.129,0.122,0.124,0.078,0.070,0.045,0.069,
0.096,0.089,0.059,0.049,0.082,0.018,0.059,0.062,0.058,0.090,
0.044,0.075,0.112,0.162,0.087,0.088,0.266,0.270,0.148,0.110,
0.159,0.082,0.135,0.132,0.072,0.285,0.093,0.094,0.056,0.112,
0.095,0.070,0.013,0.041,0.026,0.016,0.086,0.037,0.149,0.118,
0.044,0.132,0.121,0.094,0.057,0.051,0.040,0.054,0.077,0.107,
0.063,0.071,0.116,0.023,0.110,0.113,0.069,0.108,0.110,0.148,
0.154,0.133,0.081,0.101,0.123,0.117,0.075,0.086,0.104,0.023,
0.069,0.073,0.068,0.090,0.047,0.075,0.174,0.245,0.088,0.106,
0.216,0.235,0.177,0.139,0.220,0.096,0.233,0.192,0.068,0.166,
0.081,0.088,0.090,0.170,0.100,0.101,0.027,0.047,0.028,0.030,
0.125,0.045,0.120,0.122,0.060,0.146,0.104,0.120,0.063,0.060,
0.038,0.062,0.104,0.137,0.071,0.088,0.105,0.025,0.107,0.121,
0.077,0.083,0.086,0.144,0.029,0.033,0.014,0.015,0.044,0.079,
0.045,0.027,0.031,0.026,0.031,0.025,0.010,0.030,0.016,0.016,
0.033,0.085,0.027,0.025,0.088,0.188,0.118,0.052,0.088,0.252,
0.131,0.100,0.015,0.073,0.028,0.024,0.021,0.074,0.032,0.019,
0.028,0.113,0.065,0.020,0.053,0.082,0.108,0.070,0.016,0.090,
0.057,0.030,0.010,0.015,8.04e-3,9.36e-3,0.039,0.085,0.035,0.030,
0.026,0.022,0.055,0.045,0.012,0.024,0.022,0.035,0.165,0.176,
0.113,0.128,0.182,0.267,0.213,0.131,0.199,0.075,0.196,0.152,
0.086,0.158,0.132,0.111,0.038,0.089,0.043,0.029,0.063,0.150,
0.116,0.041,0.075,0.096,0.153,0.074,0.019,0.073,0.041,0.025,
0.116,0.250,0.142,0.119,0.048,0.124,0.085,0.035,0.238,0.146,
0.204,0.215,0.075,0.244,0.154,0.120,0.106,0.090,0.075,0.110,
0.159,0.261,0.177,0.167,0.236,0.092,0.455,0.264,0.094,0.159,
0.163,0.152,0.077,0.063,0.049,0.202,0.058,0.051,0.039,0.048,
0.074,0.018,0.054,0.100,0.050,0.060,0.036,0.084,0.122,0.172,
0.093,0.099,0.176,0.235,0.165,0.112,0.207,0.088,0.219,0.219,
0.093,0.200,0.107,0.106,0.079,0.162,0.164,0.104,0.018,0.058,
0.039,0.019,0.165,0.083,0.203,0.185,0.068,0.212,0.130,0.116,
0.063,0.057,0.044,0.063,0.082,0.108,0.079,0.078,0.151,0.034,
0.209,0.173,0.087,0.138,0.124,0.145,0.129,0.083,0.060,0.095,
0.081,0.063,0.048,0.071,0.085,0.013,0.045,0.069,0.075,0.074,
0.057,0.093,0.092,0.080,0.041,0.057,0.081,0.066,0.054,0.063,
0.075,0.018,0.058,0.085,0.046,0.066,0.045,0.063,0.058,0.069,
0.042,0.060,7.62e-3,0.010,6.71e-3,0.011,0.058,0.013,0.043,0.063,
0.040,0.061,0.041,0.063,0.063,0.042,0.034,0.069,0.062,0.055,
0.036,0.067,0.064,7.75e-3,0.046,0.077,0.073,0.061,0.059,0.146,
0.212,0.124,0.070,0.092,0.152,0.170,0.133,0.126,0.133,0.034,
0.095,0.129,0.073,0.133,0.062,0.101,0.146,0.178,0.072,0.094,
0.193,0.248,0.148,0.135,0.201,0.093,0.167,0.343,0.080,0.211,
0.087,0.129,0.084,0.153,0.075,0.076,0.022,0.053,0.030,0.022,
0.128,0.046,0.147,0.152,0.070,0.192,0.109,0.115,0.063,0.056,
0.038,0.057,0.117,0.163,0.088,0.114,0.103,0.023,0.112,0.143,
0.073,0.104,0.090,0.161,0.075,0.068,0.046,0.055,0.093,0.105,
0.088,0.074,0.110,0.028,0.088,0.096,0.057,0.086,0.069,0.088,
8.71e-3,0.013,6.68e-3,8.54e-3,0.016,0.030,0.023,0.014,0.016,0.015,
0.026,0.021,7.67e-3,0.025,0.013,0.012,0.050,0.092,0.057,0.059,
0.012,0.024,0.020,0.015,0.102,0.041,0.114,0.111,0.044,0.116,
0.092,0.082,0.047,0.043,0.036,0.048,0.077,0.089,0.072,0.088,
0.130,0.033,0.138,0.134,0.058,0.090,0.089,0.102,0.085,0.057,
0.040,0.074,0.054,0.049,0.036,0.041,0.071,9.32e-3,0.048,0.065,
0.059,0.057,0.048,0.088,0.072,0.067,0.039,0.052,0.073,0.079,
0.058,0.064,0.082,0.015,0.071,0.091,0.057,0.084,0.056,0.084,
0.063,0.080,0.065,0.072,8.08e-3,0.013,0.010,0.010,0.094,0.024,
0.100,0.121,0.062,0.136,0.106,0.108,0.082,0.057,0.054,0.086,
0.083,0.106,0.084,0.091,0.126,0.016,0.163,0.169,0.131,0.145,
0.159,0.177,0.156,0.115,0.091,0.118,0.118,0.108,0.094,0.091,
0.115,0.019,0.070,0.090,0.106,0.108,0.073,0.091,0.096,0.088,
0.062,0.061,0.093,0.077,0.085,0.068,0.087,0.026,0.078,0.075,
0.056,0.076,0.060,0.063,0.077,0.076,0.064,0.069,0.011,0.011,
0.015,0.016,0.060,0.014,0.063,0.123,0.038,0.067,0.057,0.064,
0.089,0.052,0.040,0.059,0.075,0.064,0.058,0.067,0.064,9.65e-3,
0.050,0.070,0.069,0.051,0.059,0.085,0.166,0.163,0.096,0.103,
0.173,0.199,0.183,0.115,0.148,0.037,0.113,0.093,0.079,0.127,
0.069,0.077,0.159,0.224,0.106,0.091,0.181,0.161,0.197,0.121,
0.174,0.082,0.169,0.180,0.076,0.170,0.093,0.086,0.122,0.204,
0.136,0.106,0.032,0.068,0.069,0.035,0.188,0.081,0.224,0.226,
0.080,0.212,0.163,0.116,0.074,0.066,0.045,0.054,0.132,0.165,
0.112,0.110,0.100,0.023,0.094,0.113,0.065,0.077,0.092,0.112,
0.108,0.076,0.062,0.067,0.136,0.142,0.153,0.098,0.386,0.071,
0.123,0.106,0.106,0.135,0.081,0.091,0.015,0.022,0.016,0.012,
0.029,0.039,0.045,0.025,0.069,0.039,0.047,0.032,0.019,0.059,
0.024,0.023,0.071,0.102,0.162,0.091,0.020,0.031,0.041,0.028,
0.171,0.095,0.125,0.101,0.051,0.220,0.092,0.071,0.041,0.035,
0.042,0.041,0.080,0.099,0.115,0.098,0.098,0.027,0.135,0.089,
0.052,0.075,0.078,0.095,0.088,0.048,0.041,0.062,0.057,0.046,
0.048,0.051,0.102,0.013,0.044,0.052,0.101,0.079,0.048,0.090,
0.092,0.084,0.061,0.065,0.095,0.086,0.099,0.076,0.154,0.046,
0.098,0.103,0.097,0.147,0.074,0.116,0.066,0.084,0.091,0.078,
0.011,0.016,0.018,0.017,0.090,0.023,0.100,0.106,0.053,0.116,
0.107,0.091,0.070,0.051,0.049,0.070,0.062,0.058,0.067,0.080,
0.104,0.014,0.098,0.113,0.102,0.106,0.123,0.170,0.013,0.016,
0.013,9.59e-3,0.018,0.029,0.022,0.014,0.015,7.52e-3,0.016,0.012,
7.42e-3,0.015,0.010,8.92e-3,0.025,0.032,0.024,0.015,0.036,0.049,
0.055,0.028,0.026,0.028,0.057,0.027,0.011,0.028,0.019,0.013,
9.94e-3,0.021,0.016,9.63e-3,6.77e-3,0.015,0.015,6.56e-3,0.018,0.013,
0.033,0.021,6.85e-3,0.022,0.019,0.012,8.79e-3,7.69e-3,5.85e-3,7.37e-3,
0.017,0.025,0.022,0.014,0.015,7.92e-3,0.017,0.026,8.98e-3,0.014,
0.012,0.014,0.023,0.039,0.020,0.013,0.044,0.087,0.073,0.028,
0.028,0.023,0.036,0.021,8.34e-3,0.025,0.017,0.013,0.042,0.094,
0.041,0.021,0.091,0.102,0.143,0.054,0.058,0.093,0.088,0.061,
0.016,0.059,0.038,0.025,0.019,0.065,0.036,0.019,0.026,0.109,
0.088,0.023,0.064,0.091,0.103,0.063,0.017,0.086,0.063,0.032,
0.012,0.017,0.011,7.96e-3,0.043,0.077,0.050,0.027,0.025,0.016,
0.036,0.026,0.011,0.020,0.021,0.027,0.014,0.018,0.013,7.73e-3,
0.035,0.068,0.064,0.025,0.069,0.039,0.047,0.025,0.011,0.040,
0.018,0.014,7.69e-3,0.026,0.012,6.54e-3,0.031,0.081,0.074,0.020,
0.055,0.109,0.076,0.038,6.87e-3,0.048,0.021,9.69e-3,0.019,0.053,
0.094,0.043,0.020,0.064,0.083,0.020,0.124,0.197,0.104,0.059,
0.018,0.155,0.057,0.029,9.15e-3,0.012,0.014,8.82e-3,0.029,0.063,
0.068,0.033,0.034,0.033,0.070,0.041,9.38e-3,0.023,0.028,0.021,
8.98e-3,0.010,7.08e-3,8.61e-3,0.011,0.014,0.014,9.65e-3,0.014,4.16e-3,
0.011,9.82e-3,0.012,0.013,8.77e-3,0.011,0.020,0.032,0.021,0.016,
0.037,0.056,0.048,0.028,0.052,0.038,0.043,0.032,0.024,0.072,
0.030,0.024,9.07e-3,0.024,0.025,0.016,4.66e-3,0.018,0.017,7.10e-3,
0.030,0.024,0.053,0.041,0.011,0.040,0.040,0.022,9.92e-3,0.011,
8.65e-3,9.94e-3,0.012,0.022,0.020,0.016,0.019,7.62e-3,0.029,0.025,
0.014,0.021,0.024,0.022,0.116,0.100,0.067,0.080,0.101,0.130,
0.099,0.079,0.095,0.020,0.075,0.067,0.056,0.071,0.047,0.051,
0.094,0.127,0.079,0.061,0.139,0.164,0.210,0.104,0.163,0.056,
0.213,0.143,0.061,0.118,0.079,0.069,0.080,0.143,0.128,0.092,
0.023,0.050,0.057,0.038,0.189,0.071,0.170,0.146,0.072,0.309,
0.105,0.091,0.057,0.049,0.039,0.057,0.114,0.122,0.115,0.120,
0.112,0.029,0.115,0.158,0.072,0.151,0.094,0.119,0.015,0.025,
0.013,0.011,0.034,0.078,0.054,0.026,0.021,0.017,0.031,0.021,
8.15e-3,0.020,0.011,0.012,0.024,0.048,0.025,0.015,0.064,0.096,
0.109,0.039,0.043,0.060,0.103,0.059,0.018,0.040,0.023,0.016,
0.017,0.069,0.042,0.021,0.022,0.084,0.086,0.025,0.075,0.160,
0.132,0.085,0.015,0.091,0.056,0.031,0.012,0.014,9.82e-3,9.99e-3,
0.030,0.059,0.045,0.033,0.025,0.022,0.047,0.044,0.011,0.023,
0.021,0.025,0.090,0.114,0.076,0.048,0.145,0.308,0.547,0.129,
0.146,0.059,0.227,0.123,0.053,0.102,0.104,0.074,0.019,0.052,
0.041,0.012,0.048,0.108,0.527,0.042,0.054,0.067,0.169,0.053,
0.026,0.042,0.040,0.018,0.094,0.192,0.175,0.099,0.044,0.101,
0.151,0.050,0.236,0.132,0.203,0.196,0.057,0.174,0.194,0.116,
0.045,0.049,0.045,0.037,0.106,0.187,0.220,0.120,0.126,0.055,
0.226,0.160,0.051,0.095,0.117,0.096,0.061,0.056,0.039,0.052,
0.057,0.071,0.063,0.044,0.075,0.016,0.066,0.066,0.127,0.061,
0.041,0.058,0.100,0.140,0.093,0.063,0.155,0.205,0.553,0.117,
0.184,0.068,0.241,0.164,0.423,0.197,0.129,0.105,0.104,0.268,
0.124,0.090,0.029,0.129,0.056,0.029,0.175,0.076,0.267,0.238,
0.096,0.214,0.165,0.131,0.057,0.068,0.044,0.053,0.080,0.175,
0.093,0.082,0.116,0.032,0.180,0.158,0.087,0.124,0.120,0.122,
0.104,0.073,0.051,0.077,0.071,0.065,0.057,0.063,0.066,0.012,
0.043,0.052,0.062,0.068,0.046,0.088,0.070,0.064,0.040,0.041,
0.064,0.054,0.054,0.043,0.056,0.011,0.051,0.051,0.036,0.048,
0.036,0.044,0.072,0.070,0.051,0.057,0.010,0.012,0.012,0.013,
0.063,0.015,0.050,0.064,0.049,0.081,0.060,0.063,0.060,0.042,
0.037,0.057,0.065,0.057,0.052,0.074,0.065,8.84e-3,0.046,0.066,
0.070,0.066,0.059,0.105,0.141,0.141,0.081,0.101,0.151,0.191,
0.153,0.114,0.113,0.030,0.107,0.107,0.069,0.122,0.064,0.093,
0.142,0.197,0.094,0.089,0.221,0.222,0.209,0.135,0.151,0.059,
0.183,0.185,0.072,0.159,0.092,0.090,0.104,0.214,0.156,0.110,
0.026,0.072,0.064,0.034,0.169,0.074,0.203,0.211,0.095,0.273,
0.174,0.144,0.082,0.076,0.062,0.078,0.132,0.176,0.154,0.169,
0.141,0.034,0.141,0.176,0.078,0.120,0.101,0.137,0.088,0.088,
0.053,0.059,0.111,0.142,0.157,0.097,0.120,0.034,0.115,0.115,
0.057,0.088,0.080,0.091,0.013,0.021,0.010,0.013,0.024,0.044,
0.058,0.022,0.023,0.021,0.044,0.041,9.46e-3,0.022,0.017,0.013,
0.080,0.177,0.106,0.094,0.026,0.048,0.047,0.029,0.148,0.068,
0.163,0.159,0.062,0.165,0.149,0.113,0.055,0.054,0.048,0.060,
0.108,0.141,0.156,0.191,0.113,0.033,0.147,0.157,0.062,0.103,
0.117,0.121,0.088,0.059,0.044,0.064,0.059,0.057,0.051,0.049,
0.071,0.012,0.055,0.070,0.073,0.063,0.050,0.089,0.139,0.127,
0.052,0.058,0.078,0.092,0.107,0.078,0.080,0.018,0.082,0.105,
0.098,0.089,0.069,0.088,0.077,0.127,0.084,0.095,0.014,0.032,
0.019,0.017,0.129,0.032,0.154,0.191,0.078,0.149,0.148,0.132,
0.092,0.069,0.065,0.101,0.121,0.154,0.106,0.123,0.128,0.020,
0.144,0.176,0.120,0.128,0.150,0.169,0.194,0.131,0.116,0.206,
0.129,0.088,0.076,0.101,0.130,0.015,0.065,0.095,0.155,0.136,
0.077,0.134,0.153,0.107,0.078,0.103,0.099,0.063,0.060,0.062,
0.095,0.012,0.114,0.067,0.112,0.130,0.088,0.119,0.127,0.099,
0.077,0.110,0.012,9.76e-3,7.92e-3,0.015,0.071,9.36e-3,0.048,0.070,
0.079,0.093,0.070,0.101,0.133,0.080,0.072,0.123,0.108,0.070,
0.060,0.099,0.088,9.59e-3,0.067,0.079,0.123,0.091,0.097,0.174,
0.158,0.104,0.067,0.104,0.109,0.082,0.067,0.075,0.096,0.014,
0.052,0.073,0.083,0.094,0.047,0.085,0.108,0.097,0.052,0.067,
0.081,0.063,0.059,0.063,0.089,0.016,0.062,0.078,0.073,0.088,
0.051,0.076,0.089,0.088,0.064,0.080,0.013,0.015,0.012,0.011,
0.089,0.017,0.064,0.082,0.062,0.111,0.072,0.083,0.079,0.062,
0.043,0.072,0.090,0.070,0.048,0.066,0.073,9.73e-3,0.053,0.078,
0.068,0.065,0.065,0.117,0.113,0.064,0.052,0.083,0.096,0.065,
0.062,0.076,0.145,0.021,0.053,0.073,0.113,0.093,0.059,0.113,
9.73e-3,0.011,6.31e-3,9.00e-3,9.78e-3,9.63e-3,9.90e-3,9.11e-3,0.014,4.22e-3,
9.82e-3,0.010,0.018,0.024,0.010,0.017,0.053,0.057,0.065,0.063,
6.75e-3,7.90e-3,8.77e-3,9.36e-3,0.074,0.016,0.057,0.057,0.051,0.084,
0.060,0.066,0.053,0.035,0.036,0.057,0.069,0.055,0.054,0.069,
0.072,0.011,0.060,0.069,0.070,0.066,0.071,0.110,0.147,0.072,
0.060,0.119,0.072,0.046,0.048,0.069,0.142,0.016,0.055,0.081,
0.236,0.134,0.072,0.168,0.120,0.077,0.058,0.082,0.081,0.057,
0.057,0.067,0.110,0.012,0.060,0.081,0.146,0.160,0.089,0.165,
0.101,0.098,0.084,0.105,9.59e-3,8.75e-3,8.04e-3,0.011,0.083,9.88e-3,
0.062,0.082,0.103,0.117,0.107,0.139,0.130,0.084,0.075,0.139,
0.087,0.070,0.064,0.096,0.134,0.012,0.088,0.139,0.205,0.172,
0.198,0.354,0.259,0.172,0.134,0.185,0.185,0.154,0.124,0.125,
0.153,0.026,0.158,0.120,0.136,0.165,0.091,0.138,0.215,0.154,
0.150,0.138,0.175,0.143,0.156,0.120,0.168,0.041,0.798,0.190,
0.090,0.155,0.146,0.116,0.119,0.148,0.105,0.126,0.018,0.027,
0.023,0.026,0.127,0.027,0.124,0.150,0.083,0.152,0.117,0.147,
0.119,0.093,0.066,0.105,0.143,0.148,0.106,0.131,0.135,0.028,
0.111,0.132,0.119,0.119,0.114,0.175,0.246,0.221,0.115,0.152,
0.238,0.244,0.169,0.142,0.167,0.041,0.104,0.121,0.114,0.189,
0.082,0.122,0.214,0.264,0.116,0.124,0.240,0.202,0.191,0.174,
0.222,0.068,0.183,0.190,0.099,0.220,0.118,0.130,0.148,0.227,
0.142,0.147,0.037,0.063,0.042,0.032,0.227,0.065,0.176,0.214,
0.121,0.289,0.199,0.189,0.112,0.107,0.070,0.102,0.215,0.300,
0.140,0.154,0.150,0.025,0.114,0.154,0.103,0.129,0.114,0.184,
0.144,0.106,0.063,0.089,0.164,0.182,0.147,0.124,0.237,0.055,
0.116,0.112,0.108,0.194,0.092,0.138,0.012,0.022,0.013,0.014,
0.026,0.041,0.036,0.024,0.043,0.037,0.047,0.027,0.018,0.075,
0.023,0.020,0.092,0.149,0.191,0.134,0.017,0.035,0.033,0.028,
0.243,0.119,0.130,0.148,0.086,0.319,0.144,0.136,0.080,0.065,
0.067,0.082,0.131,0.186,0.158,0.157,0.151,0.028,0.134,0.153,
0.089,0.120,0.126,0.167,0.137,0.094,0.077,0.125,0.090,0.079,
0.072,0.087,0.141,0.018,0.082,0.093,0.159,0.140,0.086,0.154,
0.155,0.161,0.116,0.121,0.153,0.165,0.153,0.133,0.253,0.060,
0.175,0.175,0.181,0.473,0.152,0.190,0.111,0.128,0.121,0.139,
0.013,0.024,0.018,0.021,0.150,0.033,0.138,0.175,0.105,0.196,
0.172,0.170,0.123,0.103,0.079,0.112,0.121,0.154,0.116,0.149,
0.166,0.023,0.138,0.207,0.164,0.189,0.178,0.263,0.145,0.100,
0.063,0.096,0.083,0.083,0.056,0.075,0.095,0.013,0.055,0.068,
0.078,0.078,0.050,0.074,0.118,0.121,0.063,0.083,0.112,0.112,
0.089,0.085,0.133,0.029,0.155,0.110,0.067,0.123,0.075,0.086,
0.098,0.129,0.095,0.109,0.016,0.027,0.020,0.030,0.133,0.028,
0.106,0.121,0.073,0.149,0.095,0.113,0.075,0.063,0.046,0.076,
0.091,0.097,0.070,0.093,0.130,0.022,0.092,0.136,0.096,0.101,
0.102,0.162,0.013,0.016,7.69e-3,0.011,0.014,0.024,0.012,0.012,
0.012,4.60e-3,0.012,9.69e-3,8.40e-3,0.017,9.61e-3,9.84e-3,0.019,0.024,
0.011,9.61e-3,0.026,0.048,0.027,0.017,0.023,0.018,0.034,0.022,
0.011,0.025,0.014,0.013,0.013,0.025,0.014,0.011,5.08e-3,0.016,
0.012,6.14e-3,0.025,0.021,0.031,0.026,0.013,0.034,0.024,0.016,
0.011,0.012,7.33e-3,0.011,0.018,0.029,0.017,0.018,0.021,0.011,
0.022,0.024,0.013,0.017,0.015,0.022,0.095,0.081,0.053,0.055,
0.097,0.145,0.137,0.082,0.125,0.037,0.115,0.094,0.059,0.113,
0.095,0.091,0.012,0.022,0.012,7.67e-3,0.018,0.038,0.042,0.013,
0.024,0.019,0.041,0.023,0.013,0.033,0.023,0.015,0.094,0.159,
0.104,0.085,0.023,0.047,0.038,0.022,0.170,0.058,0.119,0.134,
0.066,0.172,0.129,0.107,0.067,0.059,0.048,0.054,0.108,0.155,
0.138,0.109,0.160,0.041,0.183,0.155,0.079,0.117,0.133,0.137,
0.120,0.064,0.047,0.073,0.066,0.060,0.047,0.053,0.094,0.013,
0.065,0.078,0.090,0.082,0.059,0.094,0.122,0.115,0.074,0.080,
0.110,0.130,0.117,0.087,0.164,0.032,0.145,0.142,0.160,0.186,
0.125,0.129,0.391,0.193,0.119,0.117,0.030,0.043,0.023,0.017,
0.210,0.038,0.167,0.183,0.294,0.212,0.167,0.166,0.116,0.076,
0.086,0.088,0.102,0.122,0.090,0.097,0.174,0.022,0.174,0.200,
0.154,0.165,0.161,0.205,0.222,0.103,0.082,0.142,0.102,0.068,
0.059,0.105,0.106,0.013,0.051,0.092,0.113,0.094,0.064,0.129,
0.115,0.080,0.049,0.070,0.088,0.059,0.053,0.068,0.087,0.010,
0.074,0.078,0.065,0.076,0.052,0.082,0.084,0.082,0.055,0.096,
9.78e-3,0.011,8.29e-3,0.015,0.078,0.011,0.051,0.081,0.068,0.093,
0.062,0.101,0.108,0.064,0.060,0.110,0.083,0.063,0.061,0.101,
0.100,0.010,0.069,0.118,0.138,0.103,0.106,0.230,0.143,0.099,
0.066,0.111,0.101,0.092,0.067,0.088,0.086,0.013,0.055,0.084,
0.074,0.092,0.061,0.102,0.119,0.100,0.051,0.068,0.122,0.103,
0.065,0.079,0.100,0.020,0.098,0.109,0.067,0.107,0.066,0.099,
0.080,0.097,0.069,0.085,9.13e-3,0.017,0.011,0.012,0.110,0.021,
0.083,0.113,0.080,0.140,0.088,0.120,0.092,0.064,0.059,0.093,
0.097,0.093,0.070,0.104,0.107,0.014,0.077,0.123,0.103,0.120,
0.097,0.176,0.130,0.113,0.067,0.086,0.109,0.105,0.096,0.114,
0.134,0.026,0.083,0.111,0.098,0.111,0.100,0.170,0.011,0.018,
6.33e-3,9.25e-3,0.012,0.016,0.015,0.011,0.012,6.46e-3,0.015,0.016,
0.011,0.019,0.012,0.021,0.090,0.128,0.086,0.104,0.012,0.017,
0.017,0.016,0.145,0.030,0.105,0.135,0.084,0.153,0.134,0.152,
0.096,0.078,0.069,0.091,0.127,0.128,0.118,0.146,0.162,0.024,
0.143,0.176,0.117,0.125,0.152,0.210,0.213,0.106,0.087,0.145,
0.096,0.073,0.068,0.091,0.141,0.014,0.076,0.127,0.164,0.134,
0.105,0.257,0.159,0.130,0.071,0.105,0.123,0.118,0.084,0.101,
0.139,0.018,0.106,0.160,0.132,0.154,0.114,0.210,0.165,0.160,
0.121,0.164,0.014,0.018,0.012,0.017,0.205,0.027,0.167,0.253,
0.181,0.223,0.214,0.264,0.263,0.143,0.152,0.254,0.182,0.163,
0.139,0.218,0.269,0.022,0.223,0.357,0.295,0.242,0.266,0.337,
2.690,1.450,1.190,1.990,1.520,1.020,1.050,1.060,1.720,0.164,
1.010,1.250,2.040,1.640,1.150,1.690,1.810,1.190,0.890,0.995,
1.180,0.797,0.841,0.684,1.310,0.130,0.986,0.969,0.905,1.170,
0.945,0.976,1.200,0.950,0.946,0.994,0.105,0.094,0.098,0.133,
1.210,0.105,0.755,0.782,0.791,1.050,0.859,0.920,1.740,0.893,
0.923,1.610,1.230,0.931,0.937,1.250,1.070,0.097,0.880,1.120,
1.240,0.914,1.140,1.620,1.860,1.260,0.857,1.120,1.140,0.932,
0.747,0.797,0.976,0.127,0.667,0.808,0.798,0.948,0.835,0.952,
1.400,1.160,0.693,0.719,0.868,0.638,0.679,0.537,1.090,0.192,
0.865,0.930,0.574,0.854,0.825,0.724,0.824,0.924,0.689,0.656,
0.080,0.096,0.082,0.086,0.817,0.100,0.736,0.758,0.494,0.939,
0.660,0.619,0.777,0.667,0.459,0.662,0.841,0.723,0.595,0.741,
0.798,0.076,0.716,0.832,0.644,0.651,0.748,1.030,1.220,0.606,
0.610,0.760,0.878,0.636,0.671,0.635,0.933,0.128,0.633,0.870,
0.669,0.793,0.701,0.993,0.101,0.086,0.064,0.070,0.074,0.081,
0.067,0.060,0.090,0.025,0.085,0.095,0.083,0.160,0.092,0.111,
0.739,0.597,0.558,0.529,0.063,0.054,0.066,0.067,0.722,0.090,
0.746,0.637,0.483,0.677,0.671,0.588,0.549,0.377,0.423,0.551,
0.636,0.530,0.544,0.622,0.734,0.076,0.733,0.852,0.551,0.568,
0.735,0.943,1.400,0.556,0.569,0.900,0.562,0.383,0.385,0.405,
0.634,0.065,0.382,0.522,0.748,0.634,0.599,1.060,0.851,0.624,
0.540,0.569,0.590,0.493,0.452,0.405,0.609,0.060,0.513,0.581,
0.553,0.676,0.581,0.714,0.639,0.652,0.489,0.542,0.050,0.049,
0.049,0.051,0.565,0.052,0.527,0.553,0.454,0.596,0.600,0.619,
0.947,0.480,0.477,0.833,0.390,0.302,0.358,0.490,0.767,0.059,
0.660,0.900,0.968,0.734,0.939,1.530,2.150,1.560,1.140,1.710,
1.310,1.140,1.060,1.040,1.030,0.127,0.693,1.050,1.090,1.080,
0.812,1.170,1.640,1.440,0.889,0.959,1.200,1.020,1.090,0.816,
1.130,0.150,1.050,1.050,0.661,0.942,0.741,0.847,0.809,0.898,
0.887,0.804,0.088,0.137,0.116,0.114,0.695,0.090,0.739,0.689,
0.469,0.909,0.706,0.751,0.876,0.537,0.566,0.790,0.910,0.851,
0.692,0.814,0.642,0.084,0.582,0.762,0.611,0.592,0.751,1.180,
1.840,1.780,0.926,1.280,1.440,1.680,1.150,1.320,1.050,0.169,
0.780,0.919,0.674,1.030,0.624,0.843,1.380,1.440,0.874,0.859,
0.928,0.547,0.904,0.694,1.150,0.196,1.170,1.220,0.522,0.961,
0.765,0.721,0.939,1.610,1.230,1.060,0.122,0.239,0.189,0.180,
1.200,0.259,1.230,1.240,0.783,2.580,1.070,1.010,0.736,0.676,
0.567,0.620,1.020,1.060,0.771,0.837,0.777,0.099,0.711,0.822,
0.520,0.761,0.698,0.944,1.110,0.885,0.656,0.951,1.140,1.200,
1.190,0.852,1.110,0.203,0.950,1.270,0.577,0.893,0.846,0.973,
0.106,0.179,0.101,0.100,0.116,0.185,0.163,0.098,0.136,0.060,
0.198,0.169,0.071,0.231,0.143,0.124,1.080,1.380,1.100,0.952,
0.152,0.207,0.204,0.137,1.330,0.239,1.330,1.260,0.813,2.120,
1.480,1.120,0.786,0.513,1.030,0.650,0.953,1.080,1.120,0.967,
0.972,0.134,1.250,1.260,0.504,0.766,1.080,1.130,0.872,0.565,
0.467,0.753,0.581,0.471,0.446,0.479,0.496,0.056,0.412,0.513,
0.485,0.498,0.449,0.720,1.020,0.943,0.674,0.791,0.842,0.891,
0.717,0.703,0.738,0.099,0.778,0.883,0.547,0.974,0.714,0.900,
0.585,0.743,0.652,0.676,0.057,0.079,0.066,0.073,0.634,0.081,
0.707,0.755,0.537,0.892,0.966,0.859,0.724,0.542,0.535,0.650,
0.573,0.539,0.492,0.606,0.716,0.063,0.781,0.973,0.791,0.853,
1.120,1.490,1.680,1.120,0.843,1.150,0.747,0.697,0.575,0.550,
0.800,0.095,0.560,0.588,0.738,0.818,0.510,0.799,1.520,1.390,
0.894,0.957,1.000,1.010,0.940,0.705,1.230,0.195,1.140,1.030,
0.675,1.190,0.724,0.813,0.861,1.170,1.090,0.867,0.102,0.163,
0.139,0.156,0.788,0.125,1.000,0.886,0.471,1.020,0.757,0.761,
0.833,0.608,0.588,0.912,0.794,0.941,0.723,0.893,0.816,0.100,
0.864,0.977,0.740,0.749,0.896,1.500,0.154,0.166,0.106,0.114,
0.137,0.191,0.118,0.104,0.123,0.030,0.105,0.097,0.079,0.157,
0.094,0.109,0.176,0.241,0.125,0.116,0.159,0.205,0.158,0.107,
0.195,0.071,0.213,0.169,0.083,0.220,0.117,0.109,0.102,0.203,
0.134,0.104,0.022,0.058,0.045,0.029,0.159,0.057,0.387,0.263,
0.080,0.275,0.148,0.126,0.138,0.126,0.095,0.137,0.233,0.356,
0.219,0.256,0.143,0.035,0.188,0.198,0.130,0.226,0.162,0.224,
1.050,0.766,0.603,0.584,0.813,0.880,0.856,0.541,1.460,0.599,
1.290,0.886,0.617,1.550,0.844,0.828,0.103,0.160,0.083,0.073,
0.090,0.138,0.118,0.057,0.440,0.482,0.238,0.153,0.102,0.572,
0.128,0.102,0.755,1.050,0.979,0.620,0.108,0.152,0.192,0.095,
1.260,0.241,1.140,0.919,0.492,0.976,0.923,0.698,0.505,0.419,
0.483,0.460,0.695,0.888,0.922,0.716,1.060,0.209,1.370,1.100,
0.510,0.765,0.878,0.847,0.822,0.466,0.384,0.548,0.584,0.441,
0.360,0.313,0.583,0.087,0.428,0.518,0.487,0.570,0.383,0.640,
1.100,0.963,0.657,0.751,0.866,0.964,0.700,0.564,1.720,0.455,
1.040,1.100,0.773,1.570,0.753,0.828,0.621,0.790,0.675,0.621,
0.071,0.117,0.087,0.076,0.840,0.105,0.906,0.910,0.535,0.954,
0.782,0.804,0.745,0.500,0.575,0.678,0.650,0.660,0.539,0.585,
0.876,0.098,1.010,1.120,0.851,0.913,0.954,1.230,1.630,0.792,
0.681,1.120,0.603,0.411,0.421,0.419,0.683,0.061,0.373,0.499,
0.796,0.619,0.588,0.932,0.801,0.524,0.424,0.511,0.506,0.338,
0.448,0.374,0.660,0.060,0.403,0.492,0.446,0.458,0.375,0.516,
0.591,0.485,0.443,0.587,0.059,0.055,0.049,0.079,0.445,0.048,
0.371,0.459,0.382,0.552,0.386,0.549,0.838,0.450,0.539,0.999,
0.670,0.522,0.527,0.711,0.798,0.061,0.496,0.705,0.799,0.707,
0.720,1.420,1.330,0.904,0.641,0.854,0.855,0.767,0.633,0.596,
0.788,0.089,0.561,0.678,0.598,0.739,0.606,0.837,1.100,0.870,
0.510,0.635,0.776,0.672,0.586,0.528,0.860,0.121,0.698,0.834,
0.514,0.769,0.482,0.615,0.709,0.772,0.522,0.638,0.066,0.094,
0.067,0.084,0.750,0.100,0.917,0.951,0.531,1.060,0.627,0.757,
0.864,0.534,0.460,0.732,0.992,0.911,0.725,0.907,0.747,0.096,
0.667,0.923,0.768,1.240,0.761,1.220,0.942,0.588,0.595,0.742,
0.827,0.623,0.682,0.690,1.000,0.150,0.921,0.856,0.632,0.721,
0.822,0.966,0.078,0.085,0.063,0.077,0.068,0.077,0.073,0.068,
0.108,0.037,0.116,0.114,0.082,0.142,0.094,0.101,0.651,0.736,
0.650,0.879,0.068,0.077,0.085,0.104,0.891,0.115,0.857,0.913,
0.546,0.906,0.870,0.900,0.622,0.458,0.494,0.698,0.802,0.753,
0.824,1.030,1.410,0.142,1.080,1.640,0.758,0.974,0.989,1.240,
1.290,0.593,0.546,0.822,0.634,0.449,0.427,0.457,0.667,0.065,
0.450,0.678,0.802,0.629,0.649,1.190,0.718,0.508,0.419,0.580,
0.503,0.371,0.447,0.458,0.751,0.073,0.585,0.795,0.709,0.767,
0.571,0.845,0.804,0.776,0.726,1.110,0.111,0.070,0.067,0.109,
0.918,0.081,0.793,1.030,0.845,1.060,1.040,1.180,1.290,0.674,
0.850,1.500,0.997,0.838,0.781,1.160,1.420,0.096,1.250,1.780,
2.210,1.460,1.690,2.360,0.149,0.119,0.099,0.124,0.122,0.100,
0.099,0.094,0.106,0.018,0.084,0.095,0.104,0.109,0.103,0.104,
0.134,0.120,0.085,0.079,0.118,0.096,0.110,0.075,0.112,0.032,
0.113,0.100,0.073,0.114,0.094,0.092,0.067,0.073,0.073,0.061,
0.011,0.013,0.015,0.014,0.058,0.012,0.066,0.059,0.042,0.065,
0.065,0.064,0.089,0.071,0.056,0.083,0.086,0.077,0.071,0.081,
0.071,0.011,0.081,0.085,0.067,0.063,0.095,0.107,0.165,0.161,
0.100,0.104,0.162,0.184,0.147,0.094,0.134,0.044,0.136,0.145,
0.090,0.172,0.298,0.191,0.179,0.231,0.121,0.090,0.161,0.172,
0.170,0.110,0.280,0.138,0.230,0.234,0.086,0.248,0.143,0.110,
0.082,0.145,0.091,0.066,0.022,0.043,0.044,0.020,0.112,0.051,
0.159,0.130,0.061,0.156,0.115,0.079,0.067,0.118,0.048,0.055,
0.112,0.120,0.094,0.092,0.099,0.023,0.120,0.130,0.063,0.082,
0.106,0.123,0.081,0.060,0.047,0.051,0.094,0.087,0.095,0.063,
0.089,0.022,0.079,0.076,0.046,0.076,0.074,0.077,0.011,0.018,
0.014,9.19e-3,0.018,0.032,0.029,0.013,0.018,0.015,0.034,0.022,
9.63e-3,0.030,0.020,0.015,0.057,0.073,0.069,0.047,0.015,0.019,
0.024,0.012,0.085,0.029,0.137,0.093,0.043,0.089,0.107,0.072,
0.051,0.034,0.034,0.037,0.068,0.075,0.080,0.067,0.080,0.018,
0.110,0.099,0.047,0.064,0.098,0.087,0.086,0.048,0.039,0.062,
0.050,0.037,0.035,0.036,0.050,8.52e-3,0.039,0.046,0.049,0.048,
0.049,0.077,0.078,0.082,0.063,0.063,0.074,0.082,0.074,0.059,
0.067,0.017,0.076,0.084,0.046,0.081,0.064,0.074,0.044,0.050,
0.053,0.048,6.31e-3,8.50e-3,0.011,8.08e-3,0.048,0.011,0.065,0.058,
0.035,0.060,0.072,0.066,0.061,0.042,0.038,0.062,0.042,0.047,
0.042,0.050,0.076,0.011,0.079,0.094,0.076,0.078,0.103,0.150,
0.129,0.121,0.090,0.100,0.125,0.150,0.130,0.104,0.083,0.018,
0.070,0.087,0.063,0.084,0.064,0.072,0.136,0.147,0.096,0.074,
0.147,0.151,0.168,0.097,0.121,0.048,0.174,0.129,0.062,0.110,
0.090,0.079,0.058,0.088,0.091,0.057,0.014,0.033,0.033,0.016,
0.059,0.021,0.093,0.062,0.035,0.072,0.076,0.061,0.053,0.036,
0.037,0.050,0.067,0.084,0.070,0.067,0.053,0.012,0.065,0.063,
0.042,0.047,0.064,0.076,0.153,0.245,0.104,0.100,0.204,0.436,
0.203,0.130,0.129,0.048,0.129,0.109,0.053,0.126,0.083,0.087,
0.160,0.247,0.141,0.098,0.151,0.129,0.192,0.120,0.176,0.106,
0.267,0.218,0.057,0.166,0.127,0.096,0.092,0.225,0.149,0.117,
0.036,0.116,0.095,0.058,0.162,0.104,0.208,0.185,0.069,0.272,
0.165,0.111,0.065,0.065,0.052,0.051,0.110,0.174,0.124,0.109,
0.090,0.027,0.122,0.113,0.049,0.080,0.109,0.107,0.092,0.086,
0.059,0.063,0.136,0.188,0.183,0.089,0.120,0.036,0.110,0.107,
0.051,0.106,0.085,0.078,0.020,0.046,0.024,0.015,0.043,0.092,
0.086,0.027,0.039,0.052,0.084,0.048,0.011,0.056,0.033,0.018,
0.284,0.295,0.208,0.151,0.096,0.125,0.124,0.051,0.277,0.102,
0.312,0.232,0.224,0.330,0.325,0.211,0.156,0.051,0.072,0.056,
0.140,0.192,0.198,0.121,0.119,0.037,0.203,0.153,0.055,0.087,
0.140,0.114,0.058,0.048,0.043,0.063,0.051,0.053,0.044,0.047,
0.045,7.44e-3,0.054,0.043,0.034,0.042,0.040,0.052,0.073,0.105,
0.069,0.063,0.096,0.135,0.102,0.073,0.082,0.029,0.104,0.098,
0.039,0.114,0.075,0.070,0.045,0.073,0.065,0.055,8.19e-3,0.019,
0.018,0.010,0.067,0.019,0.100,0.079,0.041,0.085,0.122,0.078,
0.048,0.037,0.035,0.043,0.044,0.053,0.049,0.054,0.060,9.78e-3,
0.081,0.083,0.050,0.068,0.089,0.107,0.111,0.101,0.074,0.077,
0.072,0.086,0.072,0.062,0.076,0.015,0.076,0.057,0.052,0.070,
0.047,0.055,0.123,0.172,0.100,0.080,0.140,0.176,0.166,0.109,
0.159,0.061,0.245,0.167,0.056,0.151,0.093,0.076,0.068,0.137,
0.102,0.078,0.015,0.035,0.036,0.025,0.097,0.036,0.263,0.171,
0.039,0.106,0.129,0.082,0.054,0.051,0.037,0.058,0.068,0.093,
0.077,0.089,0.083,0.022,0.110,0.112,0.052,0.067,0.085,0.110,
0.013,0.025,0.014,9.94e-3,0.023,0.053,0.035,0.018,0.016,0.014,
0.033,0.020,6.79e-3,0.025,0.018,0.013,0.026,0.064,0.029,0.017,
0.052,0.098,0.084,0.035,0.043,0.074,0.107,0.063,0.013,0.051,
0.030,0.018,0.012,0.049,0.032,0.016,0.013,0.056,0.059,0.016,
0.046,0.065,0.327,0.141,0.011,0.060,0.057,0.024,9.11e-3,0.014,
9.23e-3,8.63e-3,0.024,0.056,0.040,0.029,0.021,0.016,0.057,0.043,
0.014,0.022,0.024,0.022,0.094,0.098,0.070,0.051,0.092,0.154,
0.163,0.075,0.127,0.052,0.214,0.116,0.052,0.148,0.117,0.088,
0.018,0.052,0.027,0.014,0.030,0.079,0.076,0.023,0.052,0.070,
0.213,0.066,0.011,0.051,0.039,0.018,0.088,0.186,0.178,0.082,
0.035,0.091,0.125,0.029,0.214,0.136,0.359,0.202,0.052,0.186,
0.185,0.101,0.051,0.051,0.057,0.046,0.101,0.180,0.200,0.118,
0.185,0.081,0.338,0.201,0.057,0.128,0.156,0.122,0.062,0.055,
0.039,0.060,0.048,0.052,0.045,0.036,0.054,0.013,0.056,0.064,
0.040,0.059,0.038,0.059,0.095,0.128,0.080,0.075,0.112,0.165,
0.134,0.089,0.156,0.054,0.206,0.184,0.063,0.161,0.105,0.086,
0.057,0.112,0.088,0.063,0.013,0.034,0.034,0.014,0.121,0.048,
0.186,0.147,0.050,0.144,0.114,0.089,0.051,0.044,0.043,0.051,
0.083,0.084,0.069,0.065,0.100,0.024,0.162,0.139,0.069,0.109,
0.116,0.119,0.124,0.081,0.065,0.093,0.091,0.064,0.056,0.096,
0.093,9.51e-3,0.047,0.077,0.081,0.071,0.086,0.103,0.083,0.068,
0.052,0.055,0.067,0.057,0.065,0.057,0.069,0.011,0.066,0.073,
0.047,0.056,0.066,0.063,0.052,0.056,0.047,0.059,6.35e-3,7.83e-3,
7.69e-3,0.011,0.046,8.38e-3,0.056,0.060,0.036,0.054,0.055,0.063,
0.068,0.047,0.049,0.085,0.070,0.054,0.053,0.090,0.098,9.69e-3,
0.060,0.121,0.084,0.073,0.079,0.174,0.156,0.137,0.093,0.109,
0.128,0.146,0.141,0.108,0.118,0.024,0.112,0.123,0.082,0.130,
0.109,0.127,0.171,0.187,0.103,0.105,0.170,0.187,0.175,0.134,
0.151,0.043,0.184,0.215,0.081,0.167,0.113,0.114,0.086,0.144,
0.099,0.094,0.015,0.033,0.033,0.024,0.124,0.034,0.316,0.247,
0.072,0.179,0.128,0.113,0.091,0.075,0.063,0.086,0.138,0.157,
0.144,0.162,0.119,0.022,0.154,0.201,0.134,0.170,0.140,0.182,
0.088,0.062,0.053,0.060,0.086,0.086,0.100,0.078,0.103,0.022,
0.124,0.111,0.054,0.082,0.097,0.099,9.61e-3,0.013,8.90e-3,8.54e-3,
0.017,0.028,0.024,0.015,0.019,0.010,0.033,0.025,8.46e-3,0.021,
0.020,0.014,0.061,0.097,0.091,0.080,0.012,0.024,0.025,0.021,
0.113,0.037,0.162,0.135,0.052,0.131,0.139,0.109,0.083,0.052,
0.059,0.070,0.089,0.104,0.126,0.137,0.362,0.043,0.214,0.370,
0.091,0.113,0.153,0.163,0.095,0.060,0.051,0.072,0.061,0.050,
0.047,0.053,0.060,9.40e-3,0.053,0.070,0.058,0.054,0.062,0.100,
0.068,0.060,0.047,0.058,0.065,0.064,0.064,0.063,0.069,0.010,
0.078,0.093,0.057,0.079,0.068,0.089,0.063,0.075,0.072,0.087,
9.80e-3,0.011,0.011,0.011,0.087,0.016,0.107,0.121,0.068,0.116,
0.126,0.119,0.096,0.059,0.070,0.112,0.092,0.088,0.092,0.111,
0.144,0.014,0.183,0.216,0.163,0.137,0.206,0.219,1.200,1.090,
0.998,1.450,1.140,0.919,0.926,1.230,0.978,0.110,0.830,0.982,
1.210,1.090,1.040,1.220,1.030,0.901,0.610,0.693,0.878,0.673,
0.737,0.700,0.722,0.082,0.661,0.680,0.724,0.671,0.622,0.658,
0.673,0.654,0.675,0.634,0.064,0.062,0.073,0.097,0.586,0.066,
0.786,0.641,0.444,0.541,0.683,0.639,0.705,0.371,0.357,0.597,
0.458,0.362,0.407,0.520,0.450,0.040,0.448,0.554,0.537,0.290,
0.566,0.869,1.650,1.310,0.841,1.070,1.300,1.170,1.030,0.870,
0.879,0.141,0.666,0.829,0.678,0.851,0.592,0.748,1.540,1.840,
0.871,0.843,1.210,0.872,1.140,0.836,1.200,0.197,1.150,1.780,
0.670,0.986,0.670,0.746,0.961,1.250,1.220,0.862,0.137,0.169,
0.180,0.154,1.640,0.276,1.680,2.010,1.030,1.320,1.170,0.921,
0.673,0.540,0.393,0.490,0.905,0.895,0.746,0.822,0.682,0.078,
0.665,1.020,0.589,0.540,0.694,0.973,1.060,0.641,0.580,0.624,
1.090,0.909,0.951,0.813,1.050,0.143,0.745,0.759,0.608,0.709,
0.653,0.799,0.120,0.149,0.104,0.096,0.170,0.172,0.172,0.134,
0.150,0.042,0.182,0.171,0.113,0.251,0.135,0.151,0.741,0.826,
0.879,0.676,0.103,0.114,0.174,0.127,1.150,0.186,1.590,1.070,
0.472,0.891,1.200,0.784,0.470,0.424,0.403,0.402,0.774,0.792,
0.895,0.790,0.727,0.095,0.957,0.900,0.540,0.542,0.848,0.923,
0.811,0.407,0.376,0.631,0.469,0.369,0.356,0.391,0.454,0.051,
0.321,0.389,0.527,0.442,0.413,0.641,0.778,0.647,0.502,0.547,
0.697,0.618,0.598,0.527,0.615,0.070,0.608,0.695,0.514,0.716,
0.535,0.689,0.705,0.698,0.737,0.628,0.071,0.073,0.101,0.089,
0.755,0.090,0.957,0.845,0.511,0.854,1.380,0.858,0.671,0.454,
0.448,0.624,0.479,0.427,0.499,0.589,0.778,0.073,0.787,1.010,
0.882,0.747,1.090,1.670,0.111,0.105,0.083,0.091,0.102,0.113,
0.101,0.109,0.073,0.016,0.066,0.064,0.079,0.082,0.070,0.072,
0.135,0.168,0.120,0.088,0.161,0.172,0.196,0.132,0.117,0.036,
0.152,0.112,0.171,0.116,0.111,0.097,0.064,0.093,0.086,0.064,
0.015,0.026,0.029,0.020,0.092,0.024,0.156,0.118,0.053,0.085,
0.112,0.086,0.053,0.041,0.039,0.047,0.068,0.073,0.066,0.062,
0.048,0.012,0.065,0.073,0.047,0.042,0.068,0.091,0.121,0.170,
0.094,0.079,0.132,0.188,0.159,0.094,0.091,0.033,0.087,0.084,
0.050,0.089,0.060,0.064,0.200,0.425,0.141,0.103,0.195,0.193,
0.246,0.137,0.182,0.088,0.219,0.208,0.073,0.153,0.110,0.106,
0.103,0.203,0.136,0.091,0.037,0.081,0.077,0.035,0.594,0.228,
0.537,0.696,0.180,0.291,0.197,0.142,0.054,0.056,0.043,0.041,
0.091,0.119,0.101,0.085,0.081,0.019,0.096,0.115,0.047,0.056,
0.072,0.081,0.103,0.088,0.073,0.060,0.131,0.179,0.184,0.101,
0.111,0.034,0.133,0.095,0.048,0.084,0.087,0.077,0.017,0.041,
0.023,0.016,0.036,0.078,0.080,0.032,0.033,0.046,0.096,0.044,
0.013,0.042,0.034,0.020,0.108,0.155,0.174,0.107,0.034,0.070,
0.110,0.033,0.198,0.105,0.444,0.200,0.061,0.193,0.267,0.144,
0.060,0.049,0.060,0.045,0.103,0.150,0.177,0.117,0.099,0.031,
0.196,0.138,0.050,0.073,0.132,0.118,0.070,0.068,0.053,0.096,
0.055,0.058,0.053,0.065,0.049,8.52e-3,0.045,0.047,0.050,0.052,
0.066,0.073,0.113,0.130,0.094,0.088,0.133,0.169,0.147,0.113,
0.108,0.028,0.137,0.132,0.074,0.149,0.124,0.116,0.060,0.095,
0.103,0.076,0.010,0.025,0.027,0.016,0.092,0.030,0.165,0.129,
0.067,0.134,0.354,0.133,0.060,0.056,0.052,0.059,0.053,0.070,
0.065,0.067,0.072,0.011,0.101,0.113,0.072,0.086,0.166,0.161,
1.540,1.050,0.906,1.320,0.730,0.729,0.551,0.603,0.709,0.086,
0.801,0.654,0.450,0.411,0.393,0.507,1.040,1.060,0.598,0.623,
1.030,1.020,0.964,0.687,1.020,0.171,1.320,1.020,0.509,0.916,
0.564,0.621,0.745,0.889,0.770,0.643,0.111,0.163,0.163,0.161,
0.938,0.169,1.660,1.060,0.397,0.853,0.809,0.725,0.517,0.355,
0.303,0.450,0.577,0.609,0.528,0.571,0.695,0.098,0.891,1.270,
0.462,0.460,0.648,0.985,0.117,0.118,0.071,0.082,0.134,0.193,
0.124,0.106,0.111,0.033,0.168,0.120,0.055,0.086,0.065,0.067,
0.109,0.172,0.079,0.062,0.172,0.229,0.191,0.108,0.127,0.061,
0.248,0.166,0.048,0.108,0.068,0.060,0.115,0.182,0.131,0.081,
0.031,0.075,0.083,0.034,0.211,0.099,0.470,0.234,0.070,0.178,
0.164,0.118,0.066,0.057,0.042,0.064,0.119,0.170,0.132,0.135,
0.109,0.028,0.162,0.337,0.059,0.071,0.089,0.137,1.370,0.605,
0.679,0.396,0.676,0.818,0.830,0.515,0.758,0.149,1.310,0.648,
0.348,0.570,0.663,0.509,0.102,0.146,0.149,0.070,0.087,0.159,
0.154,0.061,0.136,0.058,0.370,0.130,0.049,0.131,0.119,0.070,
0.646,0.463,0.669,0.324,0.100,0.089,0.204,0.060,0.403,0.107,
0.429,0.141,0.130,0.210,0.381,0.276,0.318,0.229,0.311,0.175,
0.357,0.414,0.563,0.305,0.502,0.092,0.937,0.560,0.265,0.359,
0.581,0.590,0.610,0.367,0.301,0.356,0.403,0.327,0.282,0.258,
0.401,0.053,0.479,0.420,0.255,0.276,0.261,0.340,0.660,0.659,
0.453,0.362,0.639,0.760,0.598,0.410,0.696,0.113,1.050,0.785,
0.367,0.670,0.476,0.429,0.560,0.648,0.642,0.501,0.074,0.128,
0.117,0.083,0.821,0.131,1.420,0.979,0.391,0.811,0.849,0.679,
0.416,0.312,0.293,0.357,0.454,0.507,0.472,0.421,0.645,0.083,
1.120,0.933,0.515,0.583,0.878,0.921,0.966,0.594,0.452,0.727,
0.511,0.410,0.343,0.403,0.442,0.052,0.373,0.449,0.476,0.441,
0.349,0.542,0.692,0.531,0.312,0.344,0.474,0.382,0.340,0.304,
0.416,0.042,0.384,0.370,0.291,0.325,0.278,0.347,0.477,0.452,
0.331,0.396,0.047,0.049,0.044,0.063,0.409,0.049,0.551,0.545,
0.292,0.431,0.426,0.490,0.435,0.276,0.230,0.392,0.382,0.300,
0.260,0.370,0.359,0.038,0.324,0.591,0.383,0.344,0.411,0.727,
1.080,0.904,0.571,0.736,0.919,0.891,0.748,0.650,0.652,0.090,
0.677,0.733,0.472,0.631,0.416,0.591,1.020,1.090,0.555,0.592,
1.050,1.030,0.941,0.702,0.802,0.117,0.909,0.954,0.391,0.683,
0.466,0.543,0.666,1.030,0.643,0.600,0.083,0.150,0.119,0.114,
0.953,0.163,1.320,1.270,0.470,1.030,0.863,0.844,0.559,0.468,
0.333,0.487,0.773,0.861,0.692,0.793,0.614,0.092,0.733,1.530,
0.439,0.566,0.573,0.870,0.882,0.605,0.477,0.491,0.733,0.744,
0.758,0.651,0.760,0.117,0.833,0.732,0.439,0.654,0.618,0.705,
0.076,0.102,0.065,0.061,0.095,0.150,0.132,0.094,0.094,0.030,
0.155,0.118,0.053,0.125,0.092,0.083,0.724,0.936,0.815,0.665,
0.087,0.110,0.144,0.112,1.170,0.209,1.480,1.350,0.472,0.940,
1.180,0.927,0.478,0.449,0.414,0.415,0.733,0.804,0.934,0.832,
0.765,0.099,1.150,1.240,0.465,0.589,0.951,0.959,0.732,0.434,
0.354,0.497,0.431,0.367,0.340,0.326,0.431,0.055,0.402,0.426,
0.482,0.385,0.425,0.594,0.679,0.563,0.397,0.434,0.566,0.592,
0.548,0.484,0.513,0.060,0.618,0.674,0.396,0.511,0.506,0.578,
0.651,0.704,0.650,0.709,0.065,0.078,0.083,0.090,0.933,0.108,
1.280,1.330,0.598,0.904,1.120,1.000,0.754,0.467,0.499,0.749,
0.693,0.657,0.679,0.731,0.840,0.076,1.130,1.340,0.879,0.742,
1.190,1.240,1.340,0.874,0.890,1.530,0.823,0.554,0.518,0.656,
0.706,0.069,0.428,0.606,0.985,0.825,0.583,0.949,0.902,0.569,
0.408,0.525,0.596,0.385,0.375,0.398,0.566,0.055,0.420,0.409,
0.528,0.576,0.380,0.483,0.603,0.488,0.466,0.585,0.059,0.045,
0.046,0.077,0.427,0.039,0.390,0.429,0.365,0.437,0.466,0.555,
0.787,0.406,0.446,0.753,0.622,0.404,0.380,0.553,0.521,0.046,
0.392,0.529,0.676,0.430,0.558,1.100,1.220,0.792,0.592,0.834,
0.733,0.545,0.447,0.487,0.507,0.056,0.326,0.446,0.459,0.470,
0.326,0.577,0.875,0.674,0.370,0.452,0.517,0.332,0.354,0.329,
0.557,0.066,0.390,0.565,0.414,0.423,0.297,0.421,0.516,0.469,
0.485,0.445,0.042,0.046,0.041,0.047,0.509,0.045,0.380,0.468,
0.397,0.436,0.402,0.433,0.427,0.300,0.244,0.363,0.429,0.362,
0.280,0.355,0.376,0.029,0.301,0.446,0.371,0.306,0.375,0.644,
0.859,0.452,0.402,0.550,0.688,0.448,0.423,0.532,0.592,0.070,
0.305,0.413,0.508,0.467,0.395,0.653,0.075,0.062,0.041,0.058,
0.064,0.055,0.050,0.056,0.058,0.011,0.058,0.061,0.077,0.106,
0.060,0.088,0.522,0.414,0.462,0.457,0.052,0.041,0.050,0.059,
0.525,0.063,0.478,0.515,0.414,0.518,0.657,0.598,0.409,0.293,
0.301,0.473,0.509,0.403,0.413,0.536,0.524,0.058,0.451,0.603,
0.475,0.456,0.596,0.815,0.950,0.410,0.374,0.833,0.448,0.292,
0.287,0.464,0.453,0.044,0.266,0.371,0.638,0.436,0.371,0.742,
0.688,0.489,0.335,0.462,0.459,0.355,0.316,0.355,0.431,0.039,
0.333,0.435,0.489,0.568,0.387,0.603,0.480,0.432,0.389,0.467,
0.038,0.037,0.036,0.047,0.394,0.034,0.360,0.423,0.388,0.460,
0.675,0.607,0.667,0.414,0.368,0.676,0.426,0.346,0.336,0.498,
0.602,0.053,0.477,0.735,0.841,0.654,0.867,1.500,1.530,1.050,
0.903,1.290,1.030,0.894,0.761,0.817,0.762,0.091,0.520,0.732,
0.840,0.817,0.609,0.960,1.250,0.962,0.764,0.843,0.948,0.770,
0.965,0.875,0.898,0.116,0.906,0.899,0.695,0.735,0.639,0.810,
0.669,0.623,0.604,0.674,0.068,0.077,0.075,0.100,0.658,0.081,
0.648,0.798,0.435,0.618,0.680,0.865,0.664,0.388,0.424,0.566,
0.694,0.572,0.488,0.581,0.459,0.051,0.414,0.566,0.535,0.441,
0.590,1.080,1.480,1.230,0.802,1.030,1.200,1.210,0.888,0.798,
0.861,0.122,0.563,0.716,0.588,0.809,0.498,0.822,1.370,1.510,
0.738,0.833,1.180,0.840,0.956,0.795,1.470,0.282,0.991,1.200,
0.614,1.090,0.676,0.778,0.745,1.020,0.879,0.814,0.107,0.141,
0.113,0.108,1.610,0.275,1.240,1.720,0.765,1.270,0.969,1.060,
0.499,0.439,0.368,0.471,0.702,0.757,0.559,0.606,0.590,0.064,
0.527,0.709,0.461,0.492,0.582,0.862,0.902,0.649,0.463,0.629,
1.030,1.020,0.895,0.784,0.837,0.144,0.594,0.685,0.490,0.635,
0.587,0.810,0.075,0.107,0.061,0.085,0.112,0.160,0.137,0.106,
0.100,0.043,0.130,0.117,0.066,0.160,0.101,0.109,0.722,0.871,
0.810,0.743,0.099,0.137,0.141,0.119,1.000,0.188,1.090,1.190,
0.530,1.200,1.370,1.160,0.514,0.392,0.416,0.504,0.789,0.923,
0.914,0.917,0.745,0.100,0.908,1.070,0.506,0.613,0.964,1.190,
0.844,0.559,0.507,1.340,0.515,0.448,0.439,0.836,0.537,0.055,
0.397,0.511,0.517,0.464,0.509,0.826,0.956,0.851,0.617,0.792,
0.787,0.849,0.754,0.821,0.725,0.104,0.757,0.965,0.607,0.973,
0.788,0.973,0.509,0.626,0.635,0.680,0.055,0.091,0.082,0.085,
0.607,0.079,0.785,0.879,0.483,0.825,1.670,1.080,0.600,0.481,
0.425,0.587,0.546,0.589,0.499,0.620,0.599,0.060,0.677,0.913,
0.696,0.723,1.060,1.430,1.540,0.948,0.806,1.070,0.714,0.722,
0.566,0.737,0.718,0.075,0.665,0.640,0.664,0.552,0.449,0.719,
1.160,1.010,0.593,0.701,0.907,0.818,0.746,0.730,1.000,0.139,
1.630,1.040,0.581,0.861,0.712,0.982,0.872,0.965,0.656,0.792,
0.097,0.121,0.096,0.138,0.869,0.113,0.849,0.896,0.481,0.892,
0.747,0.821,0.710,0.513,0.377,0.630,0.738,0.699,0.490,0.652,
0.745,0.088,0.748,1.210,0.685,0.588,0.808,1.400,0.106,0.102,
0.117,0.088,0.089,0.126,0.081,0.084,0.079,0.017,0.158,0.095,
0.055,0.085,0.065,0.082,0.110,0.145,0.079,0.070,0.140,0.174,
0.141,0.102,0.132,0.046,0.358,0.162,0.062,0.137,0.105,0.100,
0.076,0.123,0.075,0.075,0.017,0.036,0.030,0.017,0.129,0.042,
0.182,0.154,0.059,0.163,0.128,0.102,0.072,0.064,0.045,0.067,
0.121,0.151,0.094,0.116,0.087,0.020,0.121,0.186,0.069,0.082,
0.095,0.141,1.180,0.764,0.614,0.555,1.060,1.050,0.998,0.682,
0.847,0.175,1.220,0.825,0.526,0.772,0.804,0.779,0.109,0.131,
0.084,0.061,0.118,0.136,0.112,0.069,0.124,0.049,0.394,0.148,
0.076,0.165,0.144,0.099,1.590,1.300,1.460,0.880,0.286,0.218,
0.254,0.139,1.460,0.279,0.965,1.150,0.632,1.250,1.360,1.020,
0.698,0.518,0.557,0.502,1.050,1.060,1.140,0.828,1.010,0.162,
1.620,1.340,0.602,0.807,1.150,1.180,0.817,0.581,0.408,0.600,
0.591,0.495,0.400,0.433,0.536,0.071,0.599,0.599,0.454,0.498,
0.431,0.678,1.010,0.958,0.627,0.671,0.858,0.954,0.731,0.617,
0.934,0.133,1.500,1.220,0.680,1.100,0.877,0.894,0.856,0.906,
0.746,0.739,0.095,0.121,0.101,0.087,1.090,0.139,1.270,1.270,
0.727,1.450,1.310,1.180,0.761,0.529,0.474,0.589,0.663,0.703,
0.641,0.622,0.964,0.097,1.300,1.370,0.886,0.969,1.240,1.510,
1.530,0.752,0.538,0.999,0.638,0.462,0.369,0.497,0.582,0.058,
0.383,0.542,0.682,0.517,0.414,0.864,0.800,0.528,0.300,0.417,
0.545,0.376,0.326,0.379,0.554,0.052,0.458,0.497,0.370,0.382,
0.320,0.497,0.623,0.517,0.382,0.568,0.055,0.055,0.041,0.080,
0.470,0.047,0.379,0.560,0.375,0.473,0.407,0.599,0.860,0.421,
0.381,0.680,0.541,0.374,0.328,0.517,0.569,0.047,0.413,0.776,
0.659,0.479,0.602,1.320,1.200,0.778,0.608,0.785,0.747,0.669,
0.489,0.547,0.587,0.064,0.578,0.628,0.503,0.544,0.423,0.712,
0.879,0.740,0.429,0.523,0.784,0.640,0.581,0.533,0.732,0.089,
0.847,0.787,0.429,0.598,0.452,0.621,0.576,0.651,0.429,0.554,
0.051,0.067,0.051,0.062,0.678,0.079,0.645,0.842,0.484,0.794,
0.639,0.818,0.635,0.448,0.345,0.560,0.630,0.573,0.440,0.599,
0.639,0.062,0.536,1.040,0.565,0.530,0.632,1.070,1.160,0.719,
0.516,0.685,0.929,0.819,0.688,0.775,0.891,0.123,0.705,0.821,
0.670,0.757,0.704,1.080,0.082,0.084,0.048,0.064,0.079,0.091,
0.069,0.070,0.081,0.018,0.115,0.092,0.071,0.111,0.083,0.102,
0.964,1.050,0.832,0.865,0.096,0.101,0.100,0.105,1.220,0.166,
1.140,1.390,0.705,1.210,1.300,1.530,0.782,0.643,0.546,0.699,
0.904,0.862,0.888,0.978,1.100,0.109,1.210,1.570,0.753,0.837,
1.140,1.530,1.530,0.722,0.529,0.946,0.647,0.504,0.475,0.560,
0.728,0.070,0.512,0.718,0.917,0.691,0.679,1.340,1.090,0.772,
0.513,0.707,0.810,0.775,0.564,0.624,0.880,0.076,0.825,1.020,
0.770,0.835,0.795,1.090,0.953,0.898,0.745,1.010,0.077,0.078,
0.061,0.093,1.180,0.104,1.150,1.550,0.958,1.270,1.390,1.740,
1.470,0.739,0.710,1.360,0.908,0.785,0.719,1.030,1.280,0.088,
1.300,1.970,1.460,1.080,1.440,2.160,2.410,1.310,1.150,2.570,
1.300,0.794,0.769,1.060,1.490,0.133,0.713,1.290,2.290,1.560,
1.020,2.110,1.450,0.826,0.583,0.836,0.877,0.495,0.458,0.497,
0.851,0.058,0.480,0.653,0.739,0.644,0.535,0.845,1.050,0.672,
0.622,1.040,0.079,0.056,0.055,0.115,0.623,0.048,0.357,0.536,
0.647,0.646,0.549,0.810,1.790,0.720,0.731,1.680,1.170,0.667,
0.734,1.170,0.860,0.063,0.553,0.897,1.270,0.776,0.867,1.700,
1.650,0.830,0.602,1.020,0.801,0.561,0.439,0.564,0.795,0.067,
0.378,0.574,0.673,0.610,0.450,0.758,0.977,0.593,0.372,0.519,
0.546,0.309,0.302,0.330,0.579,0.047,0.341,0.470,0.411,0.385,
0.354,0.464,0.755,0.570,0.424,0.590,0.059,0.043,0.034,0.055,
0.545,0.044,0.341,0.485,0.416,0.466,0.358,0.532,0.793,0.461,
0.365,0.654,0.810,0.478,0.423,0.595,0.567,0.039,0.355,0.560,
0.551,0.443,0.449,0.909,1.050,0.528,0.442,0.710,0.670,0.457,
0.440,0.543,0.809,0.087,0.363,0.593,0.725,0.561,0.547,0.991,
0.079,0.065,0.040,0.070,0.053,0.055,0.039,0.048,0.067,8.82e-3,
0.041,0.059,0.084,0.095,0.064,0.103,0.504,0.379,0.348,0.436,
0.041,0.029,0.029,0.045,0.449,0.038,0.307,0.379,0.361,0.386,
0.388,0.456,0.467,0.365,0.315,0.439,0.510,0.424,0.387,0.448,
0.614,0.051,0.423,0.599,0.528,0.468,0.562,0.937,1.550,0.634,
0.542,1.140,0.612,0.392,0.375,0.498,1.110,0.079,0.400,0.606,
1.070,0.674,0.654,1.380,0.947,0.624,0.453,0.724,0.571,0.435,
0.352,0.434,0.619,0.043,0.391,0.581,0.661,0.598,0.475,0.818,
0.615,0.522,0.420,0.606,0.047,0.041,0.033,0.053,0.538,0.037,
0.371,0.517,0.554,0.540,0.502,0.720,1.080,0.553,0.523,1.060,
0.541,0.421,0.404,0.656,0.845,0.055,0.570,0.985,1.280,0.925,
1.000,2.730,1.910,1.020,0.763,1.470,0.952,0.648,0.586,0.697,
0.763,0.070,0.384,0.729,0.987,0.766,0.520,1.010,1.070,0.696,
0.442,0.687,0.644,0.445,0.445,0.437,0.551,0.048,0.383,0.506,
0.461,0.525,0.368,0.571,0.537,0.496,0.402,0.547,0.046,0.052,
0.036,0.057,0.389,0.036,0.278,0.357,0.397,0.444,0.364,0.508,
0.645,0.388,0.363,0.677,0.579,0.455,0.368,0.500,0.420,0.040,
0.316,0.459,0.596,0.405,0.473,0.977,1.140,0.760,0.407,0.824,
0.644,0.542,0.390,0.482,0.485,0.048,0.280,0.512,0.438,0.483,
0.282,0.587,0.673,0.511,0.292,0.416,0.436,0.214,0.260,0.287,
0.408,0.037,0.287,0.426,0.289,0.337,0.242,0.361,0.568,0.530,
0.385,0.476,0.045,0.052,0.033,0.042,0.411,0.051,0.286,0.424,
0.350,0.615,0.332,0.484,0.492,0.336,0.278,0.529,0.476,0.390,
0.312,0.402,0.395,0.032,0.261,0.431,0.378,0.390,0.324,0.697,
0.728,0.463,0.304,0.518,0.549,0.390,0.347,0.400,0.608,0.062,
0.294,0.465,0.446,0.400,0.345,0.580,0.041,0.046,0.025,0.042,
0.038,0.045,0.034,0.040,0.037,8.11e-3,0.033,0.043,0.036,0.056,
0.037,0.050,0.465,0.479,0.355,0.448,0.034,0.036,0.029,0.040,
0.379,0.039,0.267,0.343,0.301,0.449,0.391,0.409,0.435,0.378,
0.352,0.438,0.407,0.375,0.343,0.451,0.436,0.038,0.365,0.536,
0.350,0.338,0.461,0.674,0.689,0.410,0.301,0.536,0.384,0.272,
0.259,0.303,0.402,0.030,0.218,0.326,0.449,0.319,0.312,0.601,
0.539,0.443,0.304,0.444,0.388,0.385,0.280,0.342,0.318,0.029,
0.266,0.383,0.319,0.379,0.306,0.500,0.399,0.378,0.325,0.431,
0.027,0.032,0.023,0.034,0.360,0.027,0.269,0.372,0.370,0.391,
0.451,0.536,0.528,0.349,0.309,0.534,0.369,0.322,0.260,0.409,
0.513,0.035,0.405,0.655,0.656,0.554,0.665,1.190,1.730,0.851,
0.570,1.070,0.586,0.459,0.350,0.451,0.641,0.065,0.366,0.533,
0.690,0.639,0.369,0.724,1.070,0.740,0.460,0.707,0.561,0.434,
0.500,0.465,0.612,0.068,0.485,0.548,0.547,0.716,0.401,0.621,
0.630,0.639,0.493,0.663,0.061,0.072,0.050,0.090,0.387,0.043,
0.275,0.349,0.380,0.523,0.390,0.511,0.786,0.469,0.443,0.843,
0.577,0.495,0.408,0.615,0.537,0.050,0.385,0.603,0.687,0.539,
0.570,1.340,0.111,0.080,0.045,0.078,0.063,0.068,0.038,0.047,
0.059,0.011,0.037,0.050,0.058,0.072,0.043,0.075,0.088,0.071,
0.036,0.053,0.063,0.057,0.041,0.039,0.058,0.011,0.048,0.053,
0.049,0.066,0.037,0.056,0.059,0.076,0.041,0.057,6.87e-3,0.016,
8.13e-3,7.96e-3,0.049,9.59e-3,0.047,0.051,0.043,0.072,0.043,0.060,
0.107,0.069,0.053,0.101,0.109,0.116,0.078,0.108,0.068,9.07e-3,
0.053,0.089,0.082,0.100,0.065,0.141,0.831,0.474,0.359,0.457,
0.486,0.402,0.350,0.358,0.675,0.110,0.467,0.521,0.547,0.578,
0.417,0.686,0.057,0.056,0.030,0.041,0.038,0.050,0.037,0.029,
0.067,0.020,0.049,0.049,0.061,0.089,0.043,0.058,0.476,0.509,
0.400,0.395,0.048,0.056,0.050,0.044,0.495,0.062,0.285,0.372,
0.335,0.448,0.408,0.433,0.444,0.334,0.353,0.431,0.507,0.528,
0.410,0.457,0.650,0.067,0.544,0.652,0.466,0.464,0.520,0.745,
0.974,0.413,0.281,0.544,0.490,0.347,0.220,0.279,0.523,0.059,
0.282,0.509,0.603,0.582,0.307,0.694,0.811,0.564,0.355,0.544,
0.496,0.552,0.325,0.348,0.591,0.066,0.402,0.560,0.597,0.708,
0.391,0.623,0.623,0.848,0.380,0.515,0.077,0.223,0.041,0.051,
0.569,0.073,0.375,0.519,0.491,0.676,0.524,0.676,0.719,0.472,
0.403,0.615,0.576,0.720,0.348,0.495,0.724,0.066,0.587,0.874,
0.857,0.757,0.761,1.370,2.010,0.936,0.753,1.430,0.631,0.423,
0.394,0.439,0.698,0.058,0.356,0.560,1.020,0.649,0.616,1.190,
0.811,0.438,0.341,0.593,0.447,0.252,0.310,0.346,0.526,0.037,
0.320,0.469,0.483,0.389,0.407,0.614,0.675,0.467,0.424,0.726,
0.052,0.040,0.036,0.076,0.454,0.034,0.261,0.421,0.471,0.427,
0.343,0.633,1.070,0.513,0.571,1.400,0.631,0.392,0.460,0.710,
0.607,0.044,0.427,0.675,0.965,0.641,0.711,1.660,1.220,0.714,
0.491,0.853,0.634,0.489,0.359,0.450,0.571,0.054,0.341,0.536,
0.578,0.574,0.451,0.794,0.781,0.494,0.278,0.456,0.515,0.339,
0.274,0.345,0.473,0.039,0.321,0.472,0.411,0.397,0.280,0.481,
0.599,0.560,0.336,0.568,0.040,0.043,0.029,0.051,0.493,0.041,
0.320,0.483,0.469,0.534,0.355,0.612,0.819,0.454,0.429,0.802,
0.710,0.519,0.567,0.759,0.562,0.054,0.419,0.658,0.700,0.904,
0.557,1.080,0.839,0.432,0.362,0.614,0.566,0.366,0.358,0.474,
0.649,0.086,0.394,0.545,0.575,0.512,0.489,0.842,0.050,0.040,
0.029,0.053,0.036,0.035,0.030,0.036,0.057,6.96e-3,0.040,0.049,
0.055,0.065,0.039,0.065,0.454,0.393,0.313,0.507,0.034,0.030,
0.027,0.044,0.449,0.039,0.324,0.450,0.395,0.430,0.396,0.559,
0.512,0.355,0.352,0.696,0.522,0.441,0.398,0.576,0.753,0.056,
0.527,0.867,0.588,0.531,0.614,0.990,1.410,0.599,0.504,1.070,
0.624,0.399,0.338,0.477,0.744,0.072,0.379,0.690,1.040,0.724,
0.645,1.620,0.742,0.482,0.343,0.635,0.443,0.323,0.301,0.390,
0.565,0.043,0.359,0.617,0.645,0.698,0.423,0.858,0.786,0.713,
0.517,0.864,0.059,0.074,0.033,0.065,0.761,0.053,0.457,0.744,
0.788,0.790,0.689,1.030,1.370,0.640,0.676,1.440,0.865,0.718,
0.589,0.980,1.260,0.071,0.913,1.650,2.050,1.350,1.500,2.790,
2.480,1.490,1.370,2.190,1.540,0.952,0.910,1.110,1.300,0.132,
0.775,1.300,1.720,1.430,1.060,1.740,1.580,1.050,0.794,0.995,
1.170,0.714,0.758,0.731,0.977,0.091,0.785,0.918,0.756,0.864,
0.788,1.040,0.899,0.731,0.642,0.830,0.088,0.068,0.073,0.116,
0.628,0.065,0.468,0.598,0.619,0.730,0.705,0.873,1.330,0.777,
0.585,1.200,1.110,0.735,0.647,0.980,0.829,0.076,0.633,0.883,
1.070,0.785,1.020,1.670,1.940,1.300,0.837,1.190,1.160,0.932,
0.765,0.795,1.030,0.132,0.705,0.995,0.824,1.050,0.821,1.170,
1.290,0.983,0.675,0.806,0.886,0.629,0.648,0.640,1.200,0.149,
0.979,1.240,0.561,0.781,0.802,0.881,0.845,0.900,0.642,0.702,
0.098,0.096,0.090,0.087,0.912,0.123,0.758,0.898,0.578,1.000,
0.795,0.784,0.765,0.656,0.375,0.598,0.879,0.677,0.518,0.683,
0.782,0.070,0.611,0.824,0.647,0.637,0.727,1.140,1.130,0.595,
0.482,0.704,0.792,0.551,0.622,0.636,0.877,0.105,0.533,0.671,
0.665,0.644,0.609,1.000,0.076,0.069,0.049,0.066,0.076,0.084,
0.072,0.069,0.077,0.017,0.072,0.087,0.063,0.110,0.091,0.107,
0.567,0.511,0.541,0.513,0.061,0.055,0.063,0.069,0.626,0.076,
0.545,0.603,0.449,0.596,0.770,0.694,0.492,0.353,0.335,0.427,
0.642,0.545,0.548,0.587,0.752,0.078,0.674,0.809,0.611,0.624,
0.924,1.100,1.250,0.611,0.484,0.836,0.595,0.393,0.335,0.439,
0.710,0.078,0.390,0.535,0.732,0.548,0.471,1.010,0.968,0.735,
0.526,0.722,0.729,0.635,0.497,0.572,0.635,0.065,0.524,0.741,
0.553,0.702,0.582,0.836,0.501,0.449,0.434,0.582,0.044,0.042,
0.043,0.059,0.470,0.045,0.407,0.528,0.436,0.557,0.605,0.824,
0.771,0.471,0.408,0.823,0.535,0.529,0.407,0.573,0.821,0.064,
0.636,0.988,1.040,0.872,1.120,1.990,1.940,1.280,0.973,1.410,
1.290,1.070,0.880,0.885,0.914,0.099,0.537,0.775,0.937,0.981,
0.684,1.100,1.440,1.160,0.773,0.886,1.180,0.929,0.991,0.766,
0.892,0.136,0.793,0.869,0.650,1.250,0.662,0.823,0.646,0.654,
0.582,0.659,0.071,0.088,0.077,0.095,0.512,0.065,0.452,0.490,
0.404,0.576,0.581,0.709,0.721,0.417,0.380,0.786,0.717,0.663,
0.505,0.657,0.540,0.057,0.460,0.587,0.661,0.514,0.667,1.150,
1.520,1.370,0.684,0.972,1.220,1.390,0.794,0.719,0.822,0.114,
0.579,0.846,0.607,0.835,0.505,1.090,1.250,1.230,0.733,0.786,
0.887,0.430,0.687,0.613,0.841,0.136,0.781,0.962,0.448,0.813,
0.579,0.666,1.010,1.010,0.693,0.764,0.171,0.148,0.114,0.130,
0.818,0.144,0.691,0.889,0.485,1.090,0.861,0.863,0.755,0.515,
0.359,0.596,0.936,0.891,0.589,0.673,0.670,0.073,0.561,0.757,
0.495,0.576,0.632,0.947,0.948,0.640,0.454,0.578,0.938,0.873,
0.711,0.609,1.130,0.140,0.544,0.651,0.687,0.741,0.608,0.829,
0.069,0.104,0.056,0.062,0.091,0.138,0.101,0.069,0.083,0.039,
0.087,0.090,0.054,0.152,0.080,0.079,0.970,0.950,0.695,0.681,
0.132,0.142,0.121,0.104,0.886,0.138,0.725,0.804,0.631,1.020,
1.120,0.928,0.684,0.425,0.399,0.504,0.800,0.913,0.797,0.785,
0.765,0.095,0.799,0.965,0.595,0.670,1.020,1.130,0.730,0.465,
0.358,0.547,0.527,0.403,0.314,0.352,0.540,0.048,0.368,0.396,
0.522,0.408,0.397,0.639,0.728,0.723,0.480,0.572,0.646,0.781,
0.552,0.573,0.515,0.077,0.501,0.598,0.385,0.665,0.554,0.628,
0.444,0.496,0.449,0.506,0.042,0.053,0.045,0.056,0.477,0.052,
0.476,0.564,0.413,0.600,0.952,0.832,0.567,0.350,0.318,0.565,
0.469,0.476,0.366,0.535,0.590,0.048,0.563,0.784,0.680,0.680,
0.858,1.220,1.300,1.040,0.665,1.000,0.695,0.641,0.482,0.567,
0.662,0.083,0.592,0.607,0.690,0.778,0.479,0.717,1.270,1.140,
0.635,0.769,0.921,0.937,0.763,0.694,0.984,0.171,1.120,0.967,
0.653,1.440,0.645,0.808,0.632,0.897,0.624,0.840,0.076,0.114,
0.106,0.159,0.593,0.098,0.761,0.720,0.423,0.792,1.110,0.750,
0.675,0.519,0.375,0.751,0.625,0.630,0.510,0.733,0.636,0.076,
0.642,0.835,0.686,0.625,0.863,1.460,0.075,0.087,0.043,0.065,
0.078,0.115,0.065,0.063,0.061,0.016,0.057,0.064,0.054,0.094,
0.055,0.077,0.100,0.120,0.059,0.068,0.121,0.152,0.107,0.090,
0.102,0.040,0.127,0.118,0.059,0.142,0.073,0.079,0.052,0.097,
0.059,0.065,0.015,0.034,0.031,0.020,0.083,0.035,0.240,0.172,
0.050,0.123,0.119,0.090,0.073,0.066,0.041,0.075,0.107,0.147,
0.098,0.128,0.082,0.017,0.102,0.124,0.069,0.084,0.098,0.138,
0.890,0.675,0.473,0.525,0.685,0.818,0.678,0.588,0.856,0.159,
0.774,0.793,0.570,0.864,0.669,0.865,0.077,0.107,0.055,0.056,
0.075,0.128,0.109,0.069,0.097,0.036,0.150,0.116,0.067,0.158,
0.092,0.090,0.651,0.946,0.717,0.601,0.093,0.156,0.140,0.101,
0.911,0.179,0.686,0.808,0.472,1.000,0.924,0.816,0.549,0.471,
0.445,0.510,0.805,1.060,0.905,0.825,1.160,0.176,1.250,1.270,
0.657,0.840,1.090,1.260,0.796,0.520,0.357,0.612,0.486,0.419,
0.301,0.347,0.561,0.069,0.391,0.574,0.660,0.620,0.375,0.786,
0.973,0.877,0.527,0.696,0.792,0.955,0.655,0.642,0.851,0.129,
0.912,1.240,0.697,1.120,0.707,0.958,0.663,0.843,0.573,0.640,
0.063,0.111,0.070,0.074,0.816,0.117,0.788,0.936,0.661,1.100,
0.858,0.969,0.672,0.497,0.411,0.686,0.690,0.672,0.499,0.621,
0.921,0.098,1.040,1.380,0.972,1.040,1.240,1.650,1.560,0.826,
0.656,1.150,0.755,0.473,0.434,0.677,0.767,0.063,0.429,0.680,
0.861,0.646,0.793,1.090,0.812,0.522,0.379,0.575,0.554,0.380,
0.386,0.486,0.567,0.054,0.506,0.623,0.487,0.514,0.566,0.688,
0.615,0.571,0.433,0.700,0.048,0.046,0.040,0.087,0.501,0.047,
0.421,0.555,0.478,0.495,0.547,0.736,0.774,0.447,0.464,0.941,
0.596,0.399,0.405,0.777,0.664,0.053,0.516,0.848,0.887,0.588,
0.752,1.740,1.380,0.939,0.650,1.030,0.916,0.827,0.670,0.730,
0.788,0.091,0.627,0.853,0.772,0.860,0.623,1.030,1.030,0.776,
0.500,0.703,0.920,0.741,0.635,0.745,0.803,0.092,0.777,1.040,
0.634,0.747,0.664,0.895,0.676,0.852,0.538,0.739,0.063,0.095,
0.068,0.101,0.790,0.102,0.845,1.060,0.674,1.000,0.759,1.020,
0.785,0.568,0.488,0.830,0.907,0.846,0.782,1.200,0.846,0.088,
0.866,1.180,0.816,0.912,0.930,1.500,0.836,0.488,0.409,0.578,
0.668,0.541,0.523,0.606,0.762,0.103,0.667,0.804,0.593,0.618,
0.661,1.050,0.057,0.055,0.034,0.050,0.052,0.078,0.058,0.055,
0.059,0.013,0.091,0.084,0.052,0.085,0.067,0.082,0.526,0.581,
0.479,0.583,0.046,0.059,0.055,0.080,0.683,0.094,0.682,0.820,
0.480,0.786,0.796,0.906,0.544,0.447,0.443,0.568,0.647,0.622,
0.667,0.868,1.480,0.129,1.100,1.760,0.764,0.764,1.180,1.460,
1.060,0.577,0.470,0.799,0.587,0.446,0.346,0.450,0.651,0.075,
0.420,0.666,0.692,0.533,0.528,1.150,0.806,0.582,0.415,0.641,
0.601,0.531,0.454,0.531,0.549,0.052,0.530,0.762,0.586,0.656,
0.533,0.976,0.654,0.618,0.531,0.788,0.051,0.056,0.044,0.073,
0.747,0.068,0.645,0.916,0.729,0.866,0.935,1.180,0.989,0.556,
0.632,1.130,0.739,0.693,0.691,0.925,1.150,0.083,1.150,1.740,
1.530,1.260,1.770,2.210,3.060,1.150,1.050,1.800,1.230,0.783,
0.648,0.912,0.966,0.098,0.531,1.020,1.230,1.010,0.700,1.190,
1.090,0.659,0.436,0.685,0.810,0.507,0.452,0.551,0.624,0.071,
0.474,0.510,0.546,0.594,0.478,0.651,0.973,0.600,0.490,0.803,
0.069,0.047,0.046,0.096,0.472,0.043,0.383,0.575,0.436,0.519,
0.541,0.673,1.420,0.479,0.415,0.823,0.679,0.416,0.394,0.609,
0.499,0.039,0.368,0.584,0.683,0.377,0.580,1.170,1.770,1.070,
0.681,1.120,1.190,0.925,0.741,0.758,0.693,0.086,0.460,0.658,
0.678,0.720,0.478,0.787,1.210,0.952,0.531,0.682,0.900,0.541,
0.608,0.604,0.731,0.083,0.616,0.795,0.522,0.610,0.427,0.597,
0.952,0.869,0.638,0.792,0.090,0.096,0.083,0.106,0.836,0.102,
0.714,1.240,0.546,0.860,0.794,0.920,0.966,0.506,0.362,0.616,
0.874,0.726,0.562,0.784,0.652,0.063,0.531,0.891,0.593,0.535,
0.659,1.390,0.976,0.576,0.480,0.745,0.948,0.749,0.684,0.874,
0.995,0.122,0.514,0.666,0.693,0.741,0.535,0.883,0.085,0.106,
0.059,0.083,0.097,0.098,0.093,0.101,0.097,0.018,0.101,0.106,
0.091,0.153,0.087,0.125,0.617,0.620,0.568,0.623,0.071,0.070,
0.093,0.099,0.685,0.088,0.555,0.674,0.432,0.728,0.686,0.671,
0.553,0.401,0.383,0.557,0.784,0.687,0.891,0.859,0.877,0.089,
0.664,1.080,0.643,0.594,0.746,1.080,1.030,0.528,0.400,0.742,
0.586,0.437,0.368,0.470,0.575,0.056,0.312,0.451,0.703,0.525,
0.444,0.872,0.828,0.669,0.485,0.651,0.685,0.524,0.496,0.582,
0.569,0.055,0.495,0.645,0.560,0.601,0.518,0.784,0.666,0.641,
0.562,0.738,0.062,0.059,0.063,0.088,0.678,0.066,0.545,0.759,
0.652,0.999,0.966,1.020,0.912,0.549,0.503,0.874,0.599,0.472,
0.514,0.722,1.010,0.079,0.737,1.230,1.260,1.000,1.200,2.160,
0.153,0.083,0.059,0.089,0.092,0.078,0.061,0.073,0.062,8.73e-3,
0.047,0.101,0.066,0.077,0.052,0.079,0.101,0.080,0.057,0.066,
0.089,0.084,0.080,0.076,0.063,0.012,0.079,0.066,0.063,0.070,
0.058,0.070,0.055,0.055,0.047,0.057,6.56e-3,9.94e-3,9.28e-3,9.90e-3,
0.041,6.89e-3,0.045,0.075,0.035,0.052,0.055,0.064,0.078,0.037,
0.032,0.059,0.068,0.064,0.046,0.065,0.045,6.66e-3,0.038,0.075,
0.055,0.043,0.055,0.112,0.108,0.096,0.052,0.066,0.104,0.120,
0.088,0.067,0.057,0.013,0.047,0.056,0.044,0.062,0.042,0.060,
0.122,0.177,0.067,0.068,0.129,0.113,0.112,0.092,0.091,0.027,
0.098,0.098,0.054,0.082,0.060,0.068,0.076,0.102,0.063,0.071,
0.016,0.033,0.027,0.018,0.118,0.037,0.110,0.193,0.054,0.112,
0.116,0.098,0.070,0.047,0.033,0.051,0.091,0.101,0.076,0.083,
0.071,0.013,0.063,0.106,0.051,0.054,0.064,0.117,0.063,0.047,
0.030,0.043,0.076,0.083,0.074,0.066,0.071,0.015,0.047,0.061,
0.040,0.056,0.044,0.064,7.48e-3,0.016,7.71e-3,9.13e-3,0.015,0.025,
0.021,0.014,0.015,0.011,0.021,0.020,5.60e-3,0.016,0.013,0.011,
0.063,0.085,0.071,0.072,0.012,0.023,0.029,0.017,0.095,0.030,
0.094,0.109,0.045,0.103,0.105,0.086,0.051,0.038,0.039,0.054,
0.085,0.106,0.108,0.118,0.095,0.021,0.108,0.249,0.051,0.074,
0.086,0.124,0.071,0.061,0.042,0.061,0.053,0.050,0.040,0.045,
0.048,7.00e-3,0.034,0.043,0.052,0.050,0.050,0.079,0.086,0.098,
0.063,0.096,0.095,0.102,0.086,0.091,0.070,0.011,0.082,0.091,
0.063,0.093,0.081,0.101,0.057,0.060,0.059,0.071,7.75e-3,0.013,
0.013,0.012,0.066,0.012,0.071,0.090,0.054,0.090,0.162,0.109,
0.069,0.050,0.045,0.071,0.059,0.060,0.058,0.068,0.081,9.05e-3,
0.078,0.130,0.084,0.085,0.112,0.175,1.420,0.915,0.626,1.050,
0.754,0.655,0.484,0.623,0.620,0.068,0.531,0.619,0.495,0.457,
0.405,0.621,1.070,0.909,0.530,0.620,0.916,0.791,0.744,0.644,
0.842,0.128,1.540,0.961,0.456,0.711,0.569,0.685,0.659,0.725,
0.538,0.687,0.093,0.124,0.104,0.151,0.696,0.100,0.760,0.836,
0.407,0.738,0.593,0.715,0.644,0.438,0.311,0.572,0.683,0.592,
0.495,0.691,0.705,0.086,0.795,1.240,0.583,0.504,0.675,1.260,
0.095,0.089,0.045,0.064,0.086,0.111,0.080,0.072,0.052,0.014,
0.053,0.065,0.038,0.058,0.035,0.059,0.085,0.104,0.055,0.050,
0.104,0.104,0.090,0.070,0.068,0.023,0.118,0.089,0.034,0.061,
0.046,0.052,0.058,0.104,0.061,0.064,0.015,0.034,0.032,0.020,
0.087,0.031,0.120,0.166,0.041,0.097,0.080,0.081,0.078,0.061,
0.037,0.075,0.107,0.149,0.095,0.125,0.101,0.022,0.103,0.337,
0.058,0.068,0.068,0.149,1.180,0.771,0.533,0.515,0.818,0.943,
0.847,0.633,0.798,0.140,0.975,0.818,0.449,0.602,0.649,0.764,
0.093,0.158,0.073,0.055,0.094,0.161,0.139,0.071,0.097,0.035,
0.186,0.129,0.056,0.113,0.093,0.084,0.799,1.040,0.885,0.702,
0.122,0.128,0.194,0.114,0.857,0.148,0.334,0.581,0.469,0.695,
0.794,0.748,0.542,0.426,0.384,0.428,0.746,0.827,0.817,0.724,
0.825,0.115,1.170,1.150,0.490,0.614,0.883,1.000,0.753,0.494,
0.368,0.533,0.537,0.492,0.325,0.344,0.495,0.062,0.463,0.520,
0.434,0.412,0.361,0.623,0.813,0.847,0.562,0.553,0.807,0.967,
0.724,0.577,0.695,0.100,1.050,0.912,0.491,0.716,0.599,0.703,
0.658,0.781,0.628,0.697,0.081,0.119,0.096,0.094,0.948,0.124,
1.090,1.180,0.558,0.992,1.000,1.040,0.646,0.459,0.376,0.588,
0.653,0.675,0.543,0.606,0.869,0.089,1.150,1.130,0.784,0.852,
1.040,1.360,1.520,0.681,0.505,0.941,0.714,0.462,0.395,0.535,
0.559,0.058,0.344,0.490,0.654,0.512,0.429,0.777,0.795,0.520,
0.313,0.483,0.553,0.414,0.350,0.420,0.454,0.040,0.469,0.494,
0.369,0.359,0.337,0.499,0.920,0.506,0.334,0.550,0.070,0.050,
0.038,0.081,0.617,0.052,0.437,0.631,0.597,0.513,0.449,0.702,
0.726,0.398,0.308,0.649,0.559,0.385,0.348,0.558,0.562,0.055,
0.401,0.671,0.656,0.464,0.544,1.200,1.430,0.959,0.574,0.927,
1.010,0.819,0.742,0.718,0.724,0.078,0.553,0.692,0.616,0.723,
0.465,0.834,1.020,0.866,0.472,0.615,1.000,0.780,0.708,0.691,
0.652,0.070,0.674,0.854,0.426,0.540,0.437,0.640,0.784,0.955,
0.568,0.766,0.073,0.107,0.076,0.106,1.080,0.125,0.885,1.360,
0.640,1.000,0.851,1.140,0.864,0.597,0.425,0.763,0.946,0.901,
0.800,1.100,1.030,0.172,0.799,1.540,0.705,0.866,0.752,1.310,
1.110,0.609,0.480,0.645,0.835,0.708,0.711,0.705,0.759,0.096,
0.659,0.777,0.561,0.602,0.598,0.956,0.074,0.073,0.039,0.056,
0.072,0.096,0.084,0.074,0.063,0.013,0.091,0.102,0.052,0.085,
0.065,0.086,0.793,0.938,0.655,0.807,0.073,0.084,0.081,0.101,
0.952,0.127,0.833,1.160,0.610,0.954,0.990,1.120,0.682,0.561,
0.507,0.633,0.961,0.914,0.862,1.060,1.090,0.132,1.200,2.310,
0.709,0.792,1.120,1.540,1.200,0.572,0.492,0.786,0.627,0.450,
0.407,0.447,0.637,0.076,0.444,0.620,0.594,0.475,0.485,0.961,
0.799,0.583,0.401,0.567,0.631,0.609,0.525,0.559,0.548,0.053,
0.627,0.804,0.490,0.540,0.540,0.774,0.922,0.828,0.661,0.957,
0.070,0.073,0.056,0.098,1.050,0.097,1.020,1.480,0.859,1.100,
1.190,1.430,1.130,0.630,0.556,1.070,0.879,0.792,0.711,0.978,
1.190,0.096,1.180,1.810,1.240,1.060,1.400,2.100,2.760,1.230,
1.040,2.160,1.070,0.663,0.527,0.886,0.941,0.083,0.404,0.741,
1.390,1.020,0.623,1.300,1.040,0.590,0.381,0.620,0.624,0.370,
0.325,0.411,0.545,0.041,0.361,0.421,0.578,0.531,0.378,0.611,
0.826,0.558,0.449,0.796,0.071,0.047,0.039,0.096,0.504,0.037,
0.281,0.481,0.506,0.510,0.444,0.692,1.240,0.570,0.510,1.070,
0.777,0.479,0.398,0.714,0.595,0.046,0.396,0.645,0.921,0.573,
0.684,1.640,1.400,0.749,0.483,0.906,0.761,0.469,0.359,0.494,
0.453,0.044,0.234,0.416,0.522,0.446,0.290,0.637,0.831,0.482,
0.283,0.473,0.510,0.282,0.254,0.327,0.432,0.033,0.248,0.383,
0.392,0.333,0.263,0.458,0.640,0.466,0.394,0.567,0.045,0.039,
0.032,0.052,0.466,0.042,0.262,0.437,0.394,0.453,0.406,0.562,
0.604,0.349,0.264,0.482,0.513,0.360,0.272,0.425,0.413,0.030,
0.302,0.504,0.431,0.363,0.409,0.885,1.030,0.500,0.411,0.752,
0.753,0.462,0.402,0.653,0.649,0.071,0.251,0.455,0.742,0.644,
0.393,0.969,0.090,0.056,0.036,0.074,0.075,0.052,0.046,0.070,
0.058,6.89e-3,0.033,0.057,0.099,0.109,0.055,0.118,0.512,0.402,
0.377,0.509,0.044,0.032,0.033,0.059,0.433,0.042,0.259,0.408,
0.425,0.498,0.433,0.619,0.547,0.366,0.327,0.605,0.606,0.411,
0.405,0.629,0.517,0.045,0.364,0.650,0.576,0.482,0.521,1.030,
1.350,0.639,0.432,0.949,0.538,0.340,0.312,0.479,0.609,0.055,
0.293,0.477,0.951,0.594,0.477,1.140,0.808,0.465,0.339,0.555,
0.463,0.316,0.283,0.380,0.460,0.034,0.298,0.462,0.598,0.532,
0.403,0.750,0.605,0.524,0.430,0.582,0.040,0.035,0.033,0.051,
0.504,0.039,0.317,0.508,0.570,0.659,0.615,0.856,1.000,0.537,
0.496,1.010,0.606,0.409,0.402,0.640,0.851,0.055,0.580,1.010,
1.420,1.020,1.210,2.580,1.670,0.901,0.638,1.260,0.923,0.637,
0.483,0.637,0.690,0.067,0.489,0.675,0.837,0.689,0.514,0.982,
0.968,0.586,0.431,0.637,0.687,0.493,0.548,0.567,0.571,0.053,
0.729,0.594,0.527,0.493,0.449,0.675,0.567,0.443,0.360,0.592,
0.047,0.044,0.035,0.070,0.411,0.042,0.306,0.505,0.390,0.487,
0.428,0.694,0.708,0.371,0.316,0.662,0.596,0.448,0.327,0.533,
0.455,0.041,0.314,0.528,0.644,0.477,0.514,1.180,1.250,0.800,
0.463,0.795,0.836,0.634,0.431,0.524,0.496,0.051,0.282,0.456,
0.527,0.521,0.328,0.653,0.879,0.716,0.355,0.513,0.718,0.455,
0.393,0.473,0.602,0.064,0.392,0.524,0.447,0.486,0.337,0.540,
0.629,0.598,0.432,0.612,0.060,0.061,0.042,0.063,0.649,0.075,
0.405,0.683,0.476,0.664,0.553,0.767,0.555,0.374,0.259,0.486,
0.586,0.514,0.360,0.509,0.475,0.043,0.310,0.531,0.518,0.451,
0.445,0.915,0.803,0.430,0.331,0.513,0.636,0.494,0.408,0.507,
0.554,0.065,0.273,0.406,0.491,0.455,0.414,0.779,0.042,0.041,
0.026,0.051,0.048,0.061,0.043,0.049,0.040,9.02e-3,0.036,0.047,
0.044,0.063,0.040,0.065,0.581,0.509,0.407,0.539,0.050,0.048,
0.053,0.062,0.618,0.066,0.385,0.569,0.454,0.645,0.571,0.804,
0.545,0.357,0.309,0.557,0.653,0.555,0.534,0.731,0.626,0.058,
0.520,0.856,0.566,0.532,0.702,1.270,0.838,0.503,0.352,0.640,
0.464,0.354,0.302,0.395,0.498,0.042,0.298,0.413,0.569,0.428,
0.449,0.827,0.683,0.500,0.367,0.579,0.491,0.454,0.384,0.445,
0.460,0.043,0.386,0.533,0.469,0.552,0.451,0.731,0.567,0.486,
0.423,0.603,0.042,0.039,0.046,0.050,0.500,0.045,0.401,0.578,
0.480,0.617,0.792,0.922,0.722,0.420,0.378,0.677,0.612,0.439,
0.418,0.441,0.685,0.047,0.549,0.862,0.879,0.754,0.907,1.720,
1.700,1.020,0.665,1.250,0.799,0.656,0.421,0.676,0.801,0.070,
0.430,0.657,0.796,0.606,0.418,0.850,1.230,0.917,0.490,0.793,
0.859,0.674,0.543,0.613,0.817,0.087,0.771,0.777,0.657,0.844,
0.544,0.928,0.854,0.889,0.512,0.919,0.081,0.095,0.066,0.135,
0.654,0.072,0.461,0.737,0.494,0.789,0.591,0.922,0.945,0.614,
0.410,0.891,0.792,0.667,0.485,0.784,0.779,0.076,0.630,1.040,
0.888,0.718,0.924,1.840,0.103,0.081,0.047,0.078,0.084,0.079,
0.044,0.064,0.061,0.010,0.046,0.055,0.054,0.063,0.038,0.073,
0.092,0.078,0.037,0.058,0.143,0.085,0.052,0.062,0.067,0.013,
0.084,0.073,0.053,0.072,0.047,0.071,0.058,0.073,0.037,0.059,
7.08e-3,0.016,9.23e-3,0.010,0.065,0.014,0.054,0.086,0.044,0.083,
0.058,0.085,0.086,0.063,0.038,0.090,0.094,0.106,0.062,0.101,
0.076,0.011,0.062,0.125,0.078,0.079,0.076,0.160,1.290,0.786,
0.536,0.739,0.985,0.869,0.732,0.807,0.827,0.126,0.699,0.794,
0.638,0.733,0.650,1.040,0.077,0.082,0.042,0.057,0.078,0.092,
0.071,0.065,0.078,0.017,0.108,0.083,0.072,0.108,0.073,0.096,
0.932,1.090,0.812,0.874,0.092,0.123,0.109,0.107,1.070,0.141,
0.620,0.937,0.637,1.070,0.924,1.120,0.818,0.620,0.500,0.710,
0.951,1.030,0.860,0.970,1.090,0.121,1.190,1.400,0.845,0.912,
1.320,1.720,1.160,0.704,0.477,0.850,0.763,0.588,0.448,0.572,
0.636,0.070,0.520,0.683,0.692,0.610,0.502,1.050,1.100,0.877,
0.542,0.767,0.861,0.833,0.591,0.629,0.856,0.085,0.901,0.987,
0.784,0.980,0.736,1.110,0.970,1.010,0.686,0.992,0.072,0.095,
0.068,0.091,1.060,0.100,0.927,1.120,0.912,1.380,1.180,1.490,
0.979,0.637,0.534,0.914,0.773,0.773,0.613,0.801,1.100,0.096,
1.170,1.170,1.220,1.260,1.430,2.200,3.260,1.160,0.788,1.720,
1.020,0.607,0.476,0.773,0.834,0.073,0.412,0.696,1.140,0.783,
0.594,1.360,1.100,0.612,0.351,0.627,0.755,0.472,0.346,0.492,
0.581,0.046,0.407,0.582,0.539,0.475,0.393,0.762,0.933,0.690,
0.443,0.969,0.068,0.061,0.040,0.104,0.591,0.055,0.383,0.679,
0.587,0.658,0.545,0.943,1.420,0.748,0.580,1.360,0.857,0.583,
0.487,0.933,0.933,0.070,0.596,1.030,1.320,0.939,1.050,2.550,
1.830,0.953,0.584,1.060,1.110,0.703,0.481,0.691,0.719,0.064,
0.482,0.687,0.720,0.670,0.466,0.993,1.330,0.794,0.421,0.677,
1.760,0.791,0.488,0.683,0.678,0.057,0.525,0.734,0.568,0.578,
0.413,0.809,0.901,0.814,0.479,0.875,0.073,0.067,0.038,0.079,
0.829,0.076,0.579,0.998,0.677,0.872,0.693,1.160,1.100,0.670,
0.480,0.982,0.908,0.714,0.532,0.966,0.962,0.079,0.592,1.110,
0.941,0.867,0.879,1.740,1.610,0.836,0.653,0.949,1.100,0.745,
0.672,0.953,0.969,0.107,0.628,0.996,0.938,0.856,0.757,1.540,
0.085,0.064,0.041,0.068,0.101,0.069,0.057,0.070,0.055,7.71e-3,
0.056,0.076,0.074,0.087,0.062,0.115,1.080,0.989,0.731,1.100,
0.071,0.072,0.059,0.104,1.100,0.114,0.850,1.170,0.870,1.150,
1.130,1.640,1.190,0.819,0.695,1.070,1.150,0.961,0.867,1.350,
1.340,0.110,1.210,1.970,1.200,1.080,1.590,2.640,3.000,1.080,
0.782,1.650,0.981,0.642,0.556,0.847,1.020,0.089,0.587,1.040,
1.500,1.050,0.935,2.370,1.370,0.848,0.554,0.981,0.937,0.717,
0.565,0.776,0.899,0.063,0.676,1.070,0.995,0.948,0.763,1.550,
1.410,1.090,0.839,1.500,0.075,0.074,0.051,0.113,1.330,0.095,
1.050,1.720,1.390,1.510,1.600,2.490,2.740,0.934,0.863,2.120,
1.150,0.905,0.791,1.540,1.610,0.099,1.300,2.580,1.900,1.420,
1.880,4.210,6.330,2.230,1.760,4.850,2.790,1.360,1.340,2.200,
3.040,0.244,1.100,2.030,5.960,3.160,1.990,4.030,2.820,1.300,
1.030,1.570,1.530,0.752,0.762,0.878,1.640,0.097,0.744,1.080,
1.740,1.150,0.859,1.690,2.750,1.480,1.210,2.190,0.177,0.116,
0.091,0.236,1.390,0.100,0.639,0.995,1.600,1.360,0.979,1.700,
5.260,1.860,1.930,4.430,2.590,1.670,1.430,2.820,1.940,0.140,
0.953,1.690,3.350,1.680,1.750,3.700,3.390,1.350,1.010,1.580,
1.440,0.767,0.604,0.776,1.390,0.115,0.502,0.893,1.370,1.090,
0.550,1.200,1.700,0.819,0.539,0.793,0.855,0.441,0.402,0.452,
0.856,0.060,0.391,0.570,0.715,0.545,0.386,0.656,1.410,0.922,
0.602,0.943,0.077,0.049,0.040,0.074,0.793,0.057,0.366,0.612,
0.704,0.734,0.459,0.779,1.360,0.748,0.591,1.230,0.999,0.629,
0.526,0.816,0.947,0.062,0.433,0.845,1.100,0.795,0.664,1.540,
2.460,0.901,0.829,1.320,1.230,0.587,0.581,0.797,1.360,0.123,
0.478,0.913,1.560,1.010,0.758,1.800,0.146,0.080,0.056,0.097,
0.090,0.058,0.049,0.068,0.088,9.57e-3,0.045,0.083,0.162,0.133,
0.083,0.177,0.957,0.596,0.513,0.732,0.063,0.037,0.036,0.068,
0.671,0.057,0.297,0.447,0.605,0.538,0.528,0.679,1.040,0.590,
0.542,1.020,0.942,0.583,0.527,0.875,0.863,0.067,0.506,0.866,
0.912,0.709,0.769,1.470,5.410,1.470,1.260,2.740,1.340,0.671,
0.718,0.963,1.880,0.157,0.680,1.280,3.170,1.680,1.220,3.430,
2.480,1.230,0.902,1.370,1.270,0.718,0.687,0.869,1.290,0.077,
0.721,1.210,1.840,1.290,0.982,2.040,1.290,0.882,0.699,1.190,
0.083,0.056,0.047,0.092,0.881,0.055,0.473,0.775,1.030,0.867,
0.774,1.190,2.330,1.170,1.040,2.420,1.120,0.762,0.693,1.250,
1.470,0.086,0.853,1.520,2.350,1.450,1.490,3.200,2.990,1.290,
1.050,1.930,1.110,0.654,0.586,0.801,1.010,0.086,0.419,0.783,
1.300,0.947,0.595,1.270,1.300,0.723,0.506,0.755,0.720,0.415,
0.398,0.468,0.618,0.051,0.340,0.589,0.567,0.498,0.360,0.729,
0.890,0.698,0.490,0.796,0.062,0.057,0.037,0.079,0.446,0.041,
0.323,0.456,0.480,0.506,0.396,0.726,1.060,0.498,0.516,0.943,
0.761,0.535,0.410,0.676,0.585,0.043,0.315,0.523,0.788,0.483,
0.515,1.210,1.690,0.887,0.519,0.854,0.818,0.504,0.348,0.449,
0.640,0.052,0.238,0.438,0.625,0.544,0.279,0.632,0.780,0.476,
0.284,0.434,0.418,0.222,0.223,0.263,0.425,0.033,0.213,0.357,
0.325,0.319,0.210,0.350,0.636,0.613,0.306,0.478,0.038,0.041,
0.020,0.034,0.412,0.043,0.220,0.348,0.333,0.465,0.256,0.457,
0.600,0.379,0.263,0.505,0.459,0.359,0.211,0.342,0.482,0.032,
0.203,0.371,0.460,0.367,0.268,0.658,1.290,0.567,0.441,0.719,
0.740,0.426,0.406,0.500,0.648,0.065,0.311,0.594,0.650,0.515,
0.418,0.875,0.070,0.048,0.031,0.052,0.039,0.041,0.032,0.035,
0.038,5.91e-3,0.029,0.048,0.050,0.058,0.036,0.067,0.607,0.482,
0.538,0.525,0.043,0.029,0.027,0.040,0.440,0.042,0.255,0.366,
0.335,0.410,0.423,0.498,0.519,0.284,0.299,0.484,0.497,0.336,
0.304,0.433,0.402,0.030,0.325,0.474,0.420,0.333,0.481,0.757,
1.510,0.547,0.537,0.930,0.671,0.386,0.378,0.470,0.687,0.053,
0.300,0.557,0.906,0.532,0.408,1.060,1.230,0.574,0.483,0.679,
0.598,0.477,0.419,0.490,0.492,0.037,0.365,0.698,0.602,0.530,
0.409,0.817,0.636,0.486,0.418,0.641,0.040,0.031,0.024,0.044,
0.408,0.030,0.256,0.450,0.414,0.426,0.405,0.674,0.833,0.419,
0.429,0.794,0.563,0.376,0.340,0.576,0.616,0.040,0.443,0.803,
0.858,0.656,0.719,1.420,1.990,0.974,0.782,1.450,0.787,0.482,
0.401,0.617,0.915,0.080,0.366,0.623,1.180,0.792,0.422,0.980,
1.220,0.731,0.428,0.720,0.589,0.344,0.325,0.406,0.753,0.059,
0.348,0.517,0.633,0.607,0.345,0.640,0.867,0.751,0.477,0.859,
0.077,0.097,0.043,0.104,0.513,0.050,0.266,0.414,0.502,0.634,
0.354,0.690,1.120,0.593,0.513,1.160,0.750,0.578,0.420,0.733,
0.813,0.065,0.383,0.727,0.983,0.663,0.662,1.890,0.132,0.081,
0.052,0.088,0.084,0.060,0.039,0.053,0.072,8.96e-3,0.028,0.051,
0.081,0.082,0.037,0.075,0.081,0.056,0.030,0.049,0.056,0.043,
0.032,0.039,0.058,6.31e-3,0.029,0.042,0.050,0.055,0.026,0.051,
0.061,0.060,0.034,0.059,6.89e-3,8.92e-3,4.45e-3,6.94e-3,0.047,6.62e-3,
0.028,0.041,0.046,0.061,0.035,0.058,0.112,0.069,0.050,0.117,
0.099,0.090,0.057,0.099,0.082,7.92e-3,0.046,0.083,0.096,0.075,
0.066,0.167,0.943,0.492,0.335,0.515,0.509,0.336,0.316,0.398,
0.606,0.067,0.301,0.481,0.519,0.430,0.396,0.655,0.063,0.047,
0.024,0.038,0.030,0.028,0.024,0.026,0.040,5.37e-3,0.025,0.032,
0.052,0.052,0.030,0.049,0.500,0.426,0.284,0.392,0.037,0.031,
0.023,0.035,0.414,0.036,0.192,0.274,0.294,0.342,0.257,0.374,
0.518,0.313,0.266,0.407,0.446,0.333,0.274,0.386,0.518,0.048,
0.323,0.488,0.431,0.418,0.361,0.653,1.030,0.421,0.361,0.698,
0.532,0.281,0.260,0.362,0.590,0.048,0.266,0.496,0.826,0.482,
0.321,0.814,1.010,0.532,0.377,0.617,0.541,0.410,0.338,0.399,
0.557,0.039,0.322,0.519,0.655,0.546,0.338,0.615,0.666,0.533,
0.406,0.713,0.052,0.043,0.029,0.062,0.505,0.037,0.299,0.483,
0.496,0.541,0.401,0.698,0.818,0.431,0.456,0.719,0.599,0.429,
0.441,0.589,0.756,0.055,0.509,0.826,0.995,0.754,0.729,1.580,
3.570,1.360,1.080,2.510,1.010,0.540,0.538,0.799,1.240,0.099,
0.476,0.887,2.960,1.250,0.789,1.990,1.260,0.604,0.441,0.790,
0.612,0.289,0.318,0.455,0.771,0.046,0.401,0.618,0.816,0.529,
0.391,0.787,1.190,0.825,0.577,1.270,0.080,0.061,0.045,0.122,
0.645,0.051,0.285,0.561,0.707,0.636,0.401,0.924,1.790,0.789,
0.807,2.310,0.929,0.566,0.581,1.130,0.977,0.068,0.580,0.997,
1.650,0.964,1.010,2.840,1.860,0.876,0.603,1.200,0.986,0.550,
0.433,0.608,0.882,0.072,0.348,0.688,1.010,0.800,0.436,0.946,
1.050,0.541,0.330,0.608,0.593,0.340,0.280,0.414,0.614,0.047,
0.317,0.531,0.559,0.509,0.268,0.571,0.805,0.568,0.356,0.760,
0.044,0.036,0.026,0.054,0.591,0.044,0.293,0.527,0.582,0.602,
0.362,0.730,1.080,0.547,0.451,1.080,0.745,0.507,0.427,0.780,
0.762,0.050,0.441,0.786,0.930,0.661,0.597,1.480,1.170,0.583,
0.422,0.794,0.732,0.413,0.391,0.563,0.812,0.075,0.389,0.624,
0.817,0.625,0.556,1.050,0.069,0.045,0.031,0.058,0.041,0.033,
0.030,0.039,0.055,5.03e-3,0.037,0.053,0.067,0.064,0.044,0.079,
0.659,0.529,0.379,0.624,0.044,0.028,0.036,0.048,0.882,0.056,
0.344,0.422,0.535,0.452,0.517,0.640,0.718,0.429,0.405,0.726,
0.649,0.387,0.407,0.694,0.783,0.046,0.454,0.772,0.767,0.535,
0.618,1.170,2.330,0.853,0.719,1.640,0.857,0.497,0.542,0.653,
1.070,0.082,0.466,0.869,1.720,0.957,0.794,2.130,1.050,0.556,
0.444,0.777,0.621,0.378,0.380,0.506,0.679,0.044,0.411,0.721,
0.871,0.665,0.475,1.040,1.110,0.827,0.643,1.170,0.062,0.043,
0.036,0.078,0.893,0.051,0.457,0.791,1.000,0.914,0.763,1.290,
2.150,0.931,0.938,2.210,1.190,0.816,0.847,1.420,1.540,0.071,
0.953,1.740,2.880,1.630,1.720,4.320,2.850,1.480,1.330,2.420,
1.390,0.809,0.668,0.986,1.300,0.114,0.541,0.941,1.940,1.410,
0.795,1.540,1.380,0.853,0.544,0.746,0.846,0.476,0.402,0.475,
0.753,0.052,0.395,0.571,0.693,0.632,0.446,0.740,0.873,0.740,
0.478,0.848,0.066,0.052,0.036,0.087,0.500,0.041,0.255,0.393,
0.637,0.615,0.411,0.738,1.300,0.720,0.558,1.290,0.893,0.672,
0.477,0.856,0.778,0.059,0.379,0.672,1.070,0.719,0.716,1.470,
1.800,0.941,0.529,0.878,0.996,0.623,0.350,0.496,0.799,0.104,
0.326,0.508,0.749,0.772,0.335,0.711,0.892,0.565,0.292,0.409,
0.551,0.315,0.244,0.305,0.511,0.054,0.284,0.427,0.380,0.407,
0.241,0.425,0.627,0.576,0.277,0.411,0.066,0.037,0.024,0.038,
0.438,0.041,0.241,0.337,0.397,0.487,0.286,0.448,0.562,0.401,
0.234,0.458,0.560,0.412,0.242,0.371,0.485,0.036,0.254,0.411,
0.503,0.483,0.366,0.770,0.965,0.454,0.323,0.560,0.679,0.364,
0.290,0.426,0.679,0.068,0.239,0.453,0.631,0.479,0.347,0.780,
0.065,0.048,0.027,0.046,0.052,0.041,0.030,0.043,0.048,6.23e-3,
0.026,0.045,0.055,0.071,0.038,0.070,0.448,0.332,0.257,0.356,
0.033,0.022,0.023,0.037,0.280,0.026,0.178,0.271,0.291,0.274,
0.236,0.331,0.440,0.283,0.218,0.423,0.452,0.339,0.262,0.436,
0.385,0.037,0.260,0.423,0.407,0.367,0.389,0.689,1.210,0.541,
0.425,0.872,0.777,0.310,0.247,0.364,0.723,0.068,0.267,0.496,
1.010,0.585,0.404,1.080,0.842,0.594,0.371,0.596,0.563,0.370,
0.304,0.390,0.532,0.037,0.293,0.532,0.545,0.512,0.351,0.676,
0.476,0.354,0.287,0.493,0.036,0.021,0.022,0.040,0.328,0.025,
0.222,0.324,0.374,0.364,0.312,0.496,0.758,0.430,0.333,0.778,
0.450,0.322,0.283,0.497,0.682,0.044,0.380,0.660,0.893,0.689,
0.713,1.500,1.640,0.879,0.655,1.100,0.950,0.588,0.467,0.601,
0.561,0.056,0.271,0.466,0.811,0.636,0.370,0.819,0.856,0.587,
0.369,0.477,0.639,0.378,0.409,0.384,0.400,0.041,0.255,0.400,
0.368,0.401,0.256,0.479,0.459,0.427,0.291,0.437,0.038,0.033,
0.026,0.046,0.293,0.026,0.184,0.264,0.397,0.361,0.249,0.495,
0.563,0.323,0.269,0.533,0.474,0.402,0.268,0.412,0.336,0.028,
0.201,0.324,0.602,0.375,0.358,0.821,0.941,0.612,0.293,0.483,
0.681,0.510,0.257,0.319,0.384,0.039,0.181,0.294,0.376,0.388,
0.185,0.417,0.548,0.400,0.193,0.256,0.306,0.094,0.169,0.183,
0.269,0.033,0.166,0.279,0.202,0.291,0.148,0.256,0.345,0.428,
0.192,0.279,0.030,0.034,0.017,0.025,0.270,0.035,0.178,0.266,
0.226,0.406,0.207,0.342,0.349,0.266,0.178,0.266,0.353,0.346,
0.154,0.236,0.270,0.025,0.160,0.294,0.289,0.300,0.201,0.485,
0.797,0.416,0.282,0.464,0.628,0.389,0.298,0.383,0.449,0.060,
0.208,0.440,0.414,0.447,0.277,0.592,0.040,0.039,0.022,0.037,
0.049,0.039,0.029,0.029,0.033,0.012,0.024,0.035,0.030,0.078,
0.025,0.038,0.338,0.315,0.245,0.323,0.032,0.030,0.020,0.031,
0.243,0.025,0.169,0.251,0.208,0.285,0.312,0.326,0.324,0.207,
0.193,0.308,0.399,0.342,0.254,0.354,0.297,0.026,0.209,0.341,
0.324,0.270,0.322,0.540,0.722,0.373,0.275,0.507,0.469,0.303,
0.203,0.292,0.389,0.035,0.182,0.366,0.575,0.368,0.257,0.691,
0.503,0.374,0.272,0.404,0.402,0.343,0.253,0.303,0.298,0.031,
0.213,0.448,0.290,0.400,0.232,0.426,0.350,0.326,0.255,0.409,
0.027,0.024,0.018,0.033,0.250,0.025,0.168,0.270,0.261,0.321,
0.278,0.432,0.450,0.257,0.219,0.456,0.402,0.289,0.259,0.401,
0.375,0.026,0.227,0.407,0.501,0.453,0.430,0.912,1.160,0.709,
0.547,0.870,0.784,0.398,0.274,0.421,0.589,0.054,0.251,0.392,
0.696,0.572,0.285,0.633,0.785,0.597,0.275,0.438,0.470,0.332,
0.262,0.319,0.626,0.059,0.345,0.448,0.414,0.510,0.253,0.460,
0.546,0.637,0.317,0.588,0.054,0.051,0.028,0.071,0.369,0.041,
0.210,0.354,0.349,0.446,0.247,0.565,0.591,0.391,0.263,0.647,
0.456,0.390,0.272,0.479,0.480,0.043,0.280,0.495,0.582,0.411,
0.426,1.070,0.077,0.046,0.026,0.042,0.114,0.049,0.023,0.034,
0.040,6.89e-3,0.019,0.029,0.046,0.049,0.022,0.048,0.042,0.036,
0.017,0.023,0.044,0.045,0.023,0.029,0.041,8.34e-3,0.024,0.035,
0.030,0.043,0.021,0.032,0.035,0.040,0.020,0.034,8.90e-3,6.56e-3,
4.24e-3,5.08e-3,0.034,6.94e-3,0.024,0.031,0.029,0.042,0.027,0.041,
0.047,0.033,0.021,0.049,0.055,0.052,0.029,0.048,0.039,4.76e-3,
0.027,0.044,0.042,0.036,0.038,0.076,0.792,0.484,0.266,0.396,
0.514,0.436,0.257,0.343,0.520,0.068,0.250,0.367,0.394,0.403,
0.290,0.543,0.043,0.041,0.020,0.031,0.030,0.061,0.024,0.022,
0.031,7.00e-3,0.024,0.029,0.031,0.045,0.024,0.034,0.317,0.397,
0.206,0.297,0.029,0.032,0.019,0.032,0.329,0.037,0.151,0.237,
0.210,0.305,0.211,0.306,0.328,0.255,0.192,0.292,0.347,0.360,
0.224,0.326,0.411,0.046,0.341,0.392,0.309,0.319,0.310,0.493,
0.640,0.349,0.269,0.517,0.427,0.249,0.194,0.274,0.423,0.037,
0.206,0.393,0.531,0.368,0.251,0.668,0.563,0.451,0.246,0.372,
0.439,0.599,0.239,0.298,0.413,0.040,0.265,0.416,0.407,0.481,
0.267,0.465,0.399,0.420,0.318,0.479,0.031,0.029,0.022,0.036,
0.374,0.035,0.265,0.376,0.344,0.458,0.327,0.538,0.475,0.303,
0.233,0.450,0.406,0.292,0.237,0.348,0.498,0.037,0.397,0.566,
0.608,0.525,0.510,0.901,1.170,0.555,0.431,0.941,0.567,0.295,
0.254,0.516,0.541,0.044,0.226,0.457,0.802,0.481,0.304,0.783,
0.624,0.466,0.228,0.396,0.337,0.205,0.190,0.314,0.373,0.030,
0.229,0.360,0.408,0.290,0.202,0.433,0.448,0.369,0.214,0.479,
0.029,0.023,0.016,0.049,0.267,0.022,0.155,0.298,0.297,0.305,
0.196,0.449,0.627,0.345,0.289,0.785,0.382,0.245,0.216,0.497,
0.411,0.028,0.221,0.487,0.635,0.391,0.438,1.150,0.914,0.464,
0.285,0.546,0.763,0.372,0.257,0.361,0.457,0.045,0.203,0.397,
0.511,0.481,0.218,0.541,0.521,0.360,0.165,0.292,0.430,0.293,
0.171,0.283,0.403,0.059,0.196,0.408,0.338,0.386,0.188,0.441,
0.338,0.314,0.161,0.309,0.030,0.025,0.012,0.028,0.306,0.031,
0.197,0.337,0.309,0.367,0.211,0.429,0.404,0.272,0.192,0.434,
0.397,0.313,0.208,0.399,0.377,0.027,0.241,0.418,0.427,0.354,
0.333,0.745,0.644,0.356,0.254,0.438,0.401,0.298,0.227,0.344,
0.481,0.049,0.278,0.409,0.431,0.367,0.342,0.665,0.032,0.027,
0.016,0.029,0.023,0.032,0.021,0.024,0.024,3.15e-3,0.017,0.028,
0.031,0.036,0.021,0.041,0.323,0.300,0.185,0.409,0.021,0.018,
0.015,0.052,0.381,0.027,0.169,0.277,0.256,0.289,0.248,0.364,
0.360,0.268,0.214,0.402,0.357,0.263,0.226,0.463,0.427,0.037,
0.280,0.456,0.394,0.328,0.386,0.671,0.795,0.443,0.370,0.690,
0.373,0.250,0.206,0.284,0.490,0.047,0.252,0.458,0.625,0.397,
0.359,0.897,0.532,0.337,0.221,0.383,0.350,0.287,0.208,0.293,
0.335,0.022,0.215,0.372,0.420,0.350,0.260,0.542,0.501,0.425,
0.300,0.579,0.030,0.025,0.018,0.045,0.405,0.029,0.261,0.451,
0.497,0.523,0.408,0.714,0.838,0.439,0.415,0.898,0.616,0.476,
0.447,0.653,0.755,0.044,0.575,0.921,1.210,0.825,0.950,1.530,
2.320,1.040,0.880,1.770,1.090,0.638,0.571,0.832,0.972,0.093,
0.402,0.668,1.560,1.170,0.580,1.210,0.892,0.475,0.315,0.546,
0.553,0.310,0.335,0.401,0.512,0.063,0.262,0.353,0.515,0.503,
0.316,0.544,0.722,0.521,0.384,0.726,0.055,0.039,0.032,0.086,
0.436,0.036,0.216,0.420,0.478,0.467,0.372,0.618,1.160,0.571,
0.440,0.976,0.725,0.498,0.399,0.764,0.549,0.042,0.295,0.489,
0.871,0.479,0.570,1.230,1.650,0.777,0.540,0.979,0.889,0.557,
0.429,0.585,0.749,0.106,0.276,0.453,0.857,0.980,0.334,0.787,
0.769,0.490,0.272,0.439,0.485,0.274,0.270,0.343,0.924,0.311,
0.281,0.407,0.484,0.764,0.231,0.434,0.703,0.610,0.346,0.585,
0.057,0.040,0.030,0.059,0.519,0.052,0.254,0.537,0.432,0.492,
0.347,0.535,0.806,0.449,0.319,0.691,0.657,0.475,0.327,0.585,
0.558,0.049,0.259,0.483,0.598,0.501,0.450,0.933,1.150,0.445,
0.360,0.667,0.796,0.454,0.435,0.565,1.630,0.139,0.363,0.511,
1.140,0.733,0.422,0.951,0.080,0.052,0.032,0.062,0.066,0.051,
0.044,0.058,0.103,0.015,0.036,0.053,0.123,0.143,0.050,0.106,
0.446,0.276,0.254,0.366,0.036,0.022,0.023,0.044,0.332,0.031,
0.165,0.243,0.301,0.311,0.215,0.324,0.485,0.242,0.240,0.413,
0.525,0.335,0.331,0.502,0.427,0.035,0.301,0.393,0.513,0.362,
0.364,0.686,1.540,0.530,0.445,1.020,0.673,0.351,0.343,0.535,
1.210,0.099,0.332,0.556,1.810,0.896,0.477,1.400,0.930,0.478,
0.377,0.581,0.569,0.351,0.378,0.456,0.733,0.059,0.310,0.502,
0.904,0.745,0.398,0.794,0.580,0.408,0.362,0.599,0.045,0.027,
0.030,0.060,0.413,0.031,0.254,0.425,0.486,0.468,0.402,0.655,
1.000,0.464,0.444,1.020,0.557,0.342,0.415,0.707,0.819,0.061,
0.605,0.896,1.420,0.905,1.060,2.350,0.148,0.073,0.053,0.094,
0.092,0.058,0.047,0.073,0.066,6.33e-3,0.026,0.043,0.084,0.075,
0.039,0.080,0.081,0.049,0.036,0.050,0.057,0.041,0.043,0.053,
0.040,5.06e-3,0.028,0.038,0.039,0.041,0.030,0.048,0.053,0.044,
0.032,0.055,6.31e-3,5.56e-3,4.53e-3,9.55e-3,0.032,4.22e-3,0.021,0.035,
0.034,0.039,0.029,0.049,0.072,0.042,0.036,0.073,0.066,0.055,
0.042,0.072,0.048,4.87e-3,0.024,0.044,0.065,0.043,0.047,0.102,
0.110,0.068,0.042,0.070,0.077,0.057,0.039,0.054,0.051,6.94e-3,
0.019,0.033,0.051,0.057,0.024,0.054,0.068,0.051,0.031,0.041,
0.051,0.033,0.034,0.049,0.055,0.014,0.024,0.037,0.033,0.048,
0.021,0.037,0.055,0.059,0.032,0.048,5.91e-3,6.31e-3,5.06e-3,5.29e-3,
0.044,7.31e-3,0.026,0.042,0.030,0.050,0.029,0.047,0.065,0.041,
0.030,0.062,0.063,0.051,0.034,0.052,0.046,4.37e-3,0.026,0.045,
0.046,0.040,0.038,0.091,0.081,0.040,0.029,0.045,0.061,0.050,
0.046,0.048,0.080,0.010,0.028,0.037,0.064,0.059,0.037,0.075,
5.16e-3,5.52e-3,3.63e-3,4.24e-3,5.58e-3,9.69e-3,6.71e-3,4.64e-3,6.25e-3,3.30e-3,
5.58e-3,5.43e-3,5.89e-3,9.36e-3,4.12e-3,6.75e-3,0.040,0.035,0.031,0.038,
4.37e-3,5.39e-3,4.49e-3,5.68e-3,0.038,6.89e-3,0.020,0.030,0.027,0.039,
0.029,0.036,0.049,0.024,0.026,0.043,0.051,0.042,0.042,0.053,
0.040,3.99e-3,0.031,0.043,0.043,0.037,0.041,0.076,0.145,0.082,
0.061,0.104,0.078,0.051,0.047,0.062,0.101,0.010,0.040,0.059,
0.175,0.102,0.067,0.156,0.127,0.079,0.066,0.084,0.095,0.075,
0.074,0.079,0.089,9.69e-3,0.054,0.077,0.110,0.129,0.064,0.108,
0.057,0.047,0.045,0.063,4.78e-3,5.77e-3,4.68e-3,7.12e-3,0.046,4.78e-3,
0.033,0.050,0.050,0.057,0.059,0.082,0.100,0.055,0.052,0.098,
0.070,0.052,0.064,0.088,0.080,6.43e-3,0.059,0.093,0.116,0.092,
0.101,0.212,1.190,0.527,0.392,0.690,0.537,0.328,0.267,0.397,
0.439,0.041,0.220,0.333,0.478,0.362,0.223,0.506,0.593,0.399,
0.232,0.367,0.409,0.289,0.269,0.290,0.400,0.040,0.257,0.384,
0.309,0.327,0.218,0.402,0.616,0.508,0.373,0.595,0.061,0.052,
0.053,0.088,0.456,0.042,0.235,0.368,0.330,0.458,0.267,0.479,
0.573,0.329,0.283,0.604,0.457,0.336,0.339,0.532,0.441,0.037,
0.257,0.478,0.487,0.349,0.380,0.948,0.069,0.045,0.026,0.049,
0.051,0.044,0.028,0.041,0.035,5.66e-3,0.018,0.029,0.038,0.040,
0.019,0.044,0.040,0.032,0.016,0.024,0.038,0.032,0.024,0.027,
0.035,8.94e-3,0.021,0.028,0.026,0.029,0.017,0.026,0.040,0.042,
0.036,0.043,4.66e-3,6.31e-3,0.011,5.74e-3,0.033,6.43e-3,0.025,0.036,
0.025,0.038,0.024,0.037,0.065,0.037,0.031,0.068,0.057,0.052,
0.044,0.066,0.041,4.51e-3,0.027,0.050,0.042,0.034,0.034,0.075,
0.624,0.388,0.264,0.340,0.453,0.373,0.327,0.405,0.446,0.058,
0.271,0.343,0.307,0.299,0.294,0.480,0.043,0.054,0.026,0.029,
0.034,0.042,0.038,0.026,0.033,7.06e-3,0.035,0.036,0.030,0.042,
0.027,0.040,0.415,0.331,0.242,0.306,0.039,0.031,0.027,0.038,
0.344,0.038,0.103,0.184,0.193,0.239,0.202,0.271,0.344,0.214,
0.172,0.243,0.367,0.282,0.240,0.309,0.355,0.034,0.270,0.345,
0.267,0.265,0.299,0.470,0.594,0.322,0.261,0.486,0.382,0.250,
0.194,0.264,0.399,0.040,0.274,0.364,0.436,0.321,0.250,0.514,
0.547,0.438,0.300,0.378,0.447,0.383,0.352,0.310,0.372,0.037,
0.305,0.389,0.393,0.407,0.279,0.433,0.515,0.412,0.330,0.522,
0.041,0.043,0.030,0.050,0.402,0.036,0.335,0.443,0.340,0.431,
0.352,0.511,0.508,0.287,0.255,0.463,0.403,0.308,0.266,0.389,
0.481,0.037,0.393,0.562,0.553,0.465,0.501,0.876,1.320,0.482,
0.366,0.804,0.474,0.273,0.244,0.414,0.444,0.041,0.184,0.346,
0.645,0.403,0.269,0.699,0.623,0.323,0.207,0.346,0.311,0.222,
0.186,0.267,0.300,0.022,0.155,0.340,0.285,0.213,0.172,0.378,
0.561,0.391,0.273,0.524,0.041,0.030,0.027,0.072,0.312,0.026,
0.157,0.314,0.394,0.345,0.245,0.477,0.738,0.349,0.349,0.820,
0.466,0.283,0.328,0.687,0.407,0.030,0.212,0.451,0.728,0.383,
0.423,1.060,1.050,0.556,0.367,0.779,0.607,0.417,0.348,0.480,
0.463,0.040,0.219,0.388,0.573,0.465,0.242,0.625,0.630,0.397,
0.219,0.383,0.469,0.356,0.260,0.362,0.397,0.036,0.211,0.363,
0.341,0.298,0.183,0.369,0.489,0.438,0.330,0.513,0.034,0.035,
0.032,0.048,0.375,0.035,0.228,0.414,0.376,0.420,0.276,0.512,
0.640,0.380,0.369,0.735,0.560,0.422,0.360,0.643,0.449,0.032,
0.254,0.505,0.531,0.406,0.376,0.850,0.735,0.435,0.337,0.488,
0.519,0.510,0.379,0.451,0.475,0.053,0.248,0.391,0.450,0.372,
0.346,0.655,0.049,0.059,0.023,0.036,0.056,0.165,0.037,0.042,
0.032,7.71e-3,0.025,0.034,0.039,0.045,0.026,0.047,0.405,0.464,
0.253,0.420,0.030,0.045,0.021,0.043,0.373,0.032,0.203,0.324,
0.293,0.332,0.296,0.419,0.456,0.304,0.253,0.430,0.487,0.375,
0.342,0.550,0.448,0.033,0.329,0.574,0.472,0.373,0.469,0.767,
1.030,0.457,0.408,0.778,0.492,0.345,0.296,0.382,0.582,0.067,
0.283,0.507,0.653,0.413,0.352,0.911,0.664,0.415,0.267,0.453,
0.459,0.493,0.313,0.370,0.405,0.029,0.267,0.441,0.452,0.373,
0.303,0.578,0.630,0.532,0.391,0.735,0.043,0.045,0.028,0.063,
0.532,0.041,0.359,0.645,0.568,0.599,0.509,0.771,1.050,0.480,
0.446,1.030,0.693,0.521,0.447,0.787,0.803,0.051,0.569,1.020,
1.260,0.834,0.928,1.740,2.790,1.310,1.310,2.860,1.330,0.684,
0.644,1.010,1.390,0.100,0.501,0.935,2.410,1.430,0.784,1.820,
1.140,0.498,0.388,0.663,0.653,0.310,0.315,0.428,0.668,0.046,
0.320,0.424,0.658,0.525,0.282,0.560,0.942,0.541,0.440,0.923,
0.065,0.037,0.031,0.087,0.520,0.035,0.254,0.469,0.609,0.507,
0.357,0.783,1.830,0.749,0.716,1.700,0.938,0.518,0.471,0.917,
0.879,0.057,0.461,0.783,1.510,0.785,0.777,2.210,1.420,0.597,
0.457,0.850,0.670,0.331,0.255,0.401,0.626,0.056,0.253,0.397,
0.906,0.668,0.302,0.735,0.681,0.353,0.244,0.390,0.335,0.162,
0.171,0.247,0.502,0.080,0.195,0.290,0.431,0.370,0.192,0.373,
0.706,0.549,0.330,0.551,0.045,0.025,0.018,0.038,0.454,0.030,
0.182,0.351,0.466,0.387,0.274,0.499,0.742,0.390,0.307,0.679,
0.492,0.281,0.215,0.401,0.559,0.032,0.227,0.428,0.634,0.413,
0.376,1.010,1.320,0.502,0.458,0.869,0.711,0.346,0.353,0.610,
1.310,0.105,0.340,0.552,1.540,0.789,0.440,1.210,0.081,0.044,
0.034,0.064,0.051,0.032,0.030,0.054,0.076,7.06e-3,0.028,0.046,
0.152,0.110,0.042,0.101,0.520,0.347,0.332,0.517,0.035,0.020,
0.021,0.047,0.448,0.028,0.184,0.292,0.464,0.359,0.314,0.486,
0.614,0.313,0.373,0.655,0.521,0.284,0.305,0.536,0.513,0.034,
0.269,0.484,0.713,0.448,0.490,1.060,2.530,0.770,0.747,1.850,
0.909,0.413,0.427,0.769,1.740,0.134,0.551,0.887,4.580,1.640,
0.875,2.570,1.250,0.582,0.486,0.785,0.603,0.333,0.348,0.537,
0.926,0.059,0.397,0.628,1.490,0.985,0.496,1.070,0.806,0.520,
0.462,0.804,0.053,0.030,0.030,0.058,0.648,0.036,0.318,0.533,
0.756,0.608,0.510,0.853,1.570,0.673,0.706,1.610,0.772,0.452,
0.511,0.835,1.190,0.069,0.654,1.210,2.250,1.320,1.300,3.350,
1.760,0.803,0.640,1.330,0.874,0.493,0.434,0.622,0.759,0.058,
0.278,0.501,1.030,0.735,0.406,0.976,0.877,0.466,0.360,0.561,
0.537,0.301,0.328,0.394,0.414,0.031,0.292,0.366,0.406,0.379,
0.274,0.509,0.609,0.445,0.344,0.629,0.042,0.034,0.024,0.056,
0.367,0.030,0.221,0.402,0.403,0.406,0.301,0.594,0.722,0.377,
0.365,0.734,0.561,0.391,0.318,0.566,0.499,0.039,0.249,0.442,
0.676,0.415,0.442,1.050,1.140,0.565,0.396,0.677,0.629,0.410,
0.256,0.360,0.420,0.035,0.159,0.305,0.534,0.436,0.213,0.510,
0.603,0.375,0.251,0.364,0.376,0.221,0.202,0.284,0.320,0.027,
0.163,0.264,0.288,0.275,0.177,0.334,0.500,0.471,0.250,0.427,
0.040,0.032,0.016,0.032,0.367,0.035,0.181,0.306,0.375,0.402,
0.246,0.467,0.515,0.320,0.229,0.489,0.435,0.331,0.197,0.337,
0.363,0.023,0.168,0.331,0.411,0.296,0.274,0.720,0.983,0.398,
0.307,0.564,0.548,0.324,0.379,0.446,0.630,0.062,0.240,0.347,
0.740,0.547,0.354,0.790,0.044,0.032,0.021,0.038,0.031,0.031,
0.031,0.036,0.032,4.62e-3,0.021,0.028,0.052,0.063,0.027,0.052,
0.483,0.395,0.291,0.439,0.030,0.024,0.021,0.037,0.360,0.030,
0.174,0.285,0.333,0.370,0.290,0.477,0.545,0.274,0.274,0.489,
0.461,0.310,0.319,0.456,0.427,0.027,0.233,0.396,0.517,0.353,
0.406,0.822,1.320,0.563,0.478,0.917,0.572,0.320,0.318,0.440,
0.768,0.060,0.360,0.480,1.350,0.815,0.511,1.220,0.909,0.514,
0.422,0.621,0.531,0.378,0.375,0.475,0.610,0.050,0.401,0.515,
0.834,0.913,0.470,0.789,0.555,0.419,0.370,0.611,0.035,0.027,
0.026,0.042,0.429,0.029,0.258,0.431,0.490,0.464,0.405,0.753,
0.881,0.426,0.442,0.813,0.609,0.407,0.524,0.601,0.692,0.039,
0.408,0.730,1.080,0.729,0.732,1.590,1.330,0.611,0.458,0.925,
0.560,0.354,0.281,0.462,0.607,0.045,0.244,0.425,0.800,0.486,
0.314,0.725,0.796,0.480,0.312,0.554,0.458,0.288,0.245,0.300,
0.483,0.040,0.258,0.384,0.488,0.455,0.298,0.559,0.681,0.558,
0.359,0.671,0.075,0.049,0.031,0.075,0.482,0.039,0.239,0.426,
0.446,0.507,0.311,0.632,0.690,0.393,0.315,0.730,0.547,0.360,
0.276,0.516,0.604,0.047,0.335,0.629,0.762,0.476,0.499,1.300,
0.070,0.042,0.034,0.055,0.049,0.036,0.024,0.038,0.041,4.51e-3,
0.019,0.030,0.054,0.048,0.028,0.061,0.043,0.030,0.017,0.029,
0.036,0.032,0.020,0.024,0.030,3.78e-3,0.020,0.026,0.031,0.031,
0.018,0.037,0.044,0.040,0.024,0.041,5.06e-3,3.86e-3,2.51e-3,4.32e-3,
0.039,3.97e-3,0.023,0.038,0.037,0.044,0.032,0.058,0.061,0.036,
0.027,0.065,0.064,0.047,0.028,0.051,0.047,3.86e-3,0.025,0.049,
0.056,0.041,0.038,0.092,0.825,0.402,0.282,0.440,0.515,0.354,
0.299,0.450,0.509,0.058,0.268,0.409,0.470,0.431,0.388,0.786,
0.043,0.034,0.018,0.029,0.028,0.028,0.021,0.023,0.032,4.32e-3,
0.028,0.026,0.041,0.050,0.029,0.055,0.436,0.454,0.263,0.412,
0.035,0.031,0.021,0.037,0.488,0.040,0.183,0.280,0.313,0.414,
0.291,0.463,0.526,0.285,0.238,0.380,0.455,0.354,0.281,0.396,
0.532,0.038,0.341,0.449,0.482,0.432,0.460,0.768,0.880,0.377,
0.311,0.629,0.459,0.272,0.232,0.346,0.559,0.044,0.317,0.457,
0.728,0.454,0.460,0.812,0.795,0.487,0.350,0.576,0.474,0.386,
0.315,0.351,0.568,0.039,0.349,0.480,0.654,0.592,0.396,0.674,
0.742,0.558,0.422,0.777,0.046,0.044,0.027,0.051,0.596,0.040,
0.364,0.541,0.653,0.636,0.502,0.793,0.785,0.403,0.401,0.701,
0.545,0.409,0.339,0.499,0.774,0.048,0.529,0.792,0.957,0.758,
0.767,1.420,2.500,0.877,0.703,1.660,0.850,0.438,0.406,0.716,
0.882,0.065,0.358,0.753,1.610,0.770,0.540,1.400,1.030,0.465,
0.343,0.574,0.529,0.285,0.251,0.395,0.539,0.034,0.264,0.496,
0.560,0.383,0.351,0.684,0.888,0.570,0.395,0.928,0.062,0.043,
0.031,0.089,0.516,0.037,0.254,0.505,0.648,0.535,0.399,0.832,
1.430,0.618,0.598,1.520,0.816,0.439,0.438,0.890,0.814,0.050,
0.462,0.942,1.850,0.816,0.879,2.600,1.180,0.562,0.422,0.849,
0.661,0.405,0.354,0.519,0.521,0.040,0.230,0.475,0.712,0.509,
0.317,0.876,0.686,0.372,0.236,0.409,0.432,0.264,0.210,0.325,
0.419,0.028,0.228,0.398,0.396,0.348,0.231,0.485,0.593,0.434,
0.288,0.586,0.040,0.029,0.017,0.041,0.472,0.034,0.229,0.462,
0.519,0.527,0.325,0.694,0.781,0.402,0.373,0.841,0.764,0.412,
0.301,0.596,0.558,0.033,0.286,0.608,0.790,0.550,0.484,1.230,
1.270,0.592,0.547,0.816,0.767,0.519,0.530,0.716,0.973,0.079,
0.354,0.652,1.000,0.672,0.580,1.350,0.068,0.046,0.030,0.053,
0.044,0.054,0.040,0.045,0.048,4.09e-3,0.026,0.044,0.072,0.062,
0.037,0.090,0.720,0.592,0.425,0.807,0.041,0.035,0.026,0.060,
0.656,0.045,0.305,0.533,0.581,0.567,0.479,0.838,0.940,0.600,
0.500,0.848,0.800,0.563,0.495,0.869,0.824,0.054,0.535,0.937,
0.940,0.676,0.801,1.500,2.660,0.935,0.802,1.760,0.956,0.574,
0.511,0.773,1.250,0.083,0.579,1.080,1.940,1.090,0.890,2.920,
1.490,0.773,0.535,0.920,0.913,0.688,0.481,0.674,1.050,0.053,
0.530,0.895,1.210,0.903,0.660,1.450,1.460,1.030,0.806,1.520,
0.065,0.052,0.036,0.088,1.140,0.066,0.686,1.240,1.360,1.220,
1.150,1.950,3.210,1.270,1.250,2.950,1.590,1.040,0.910,1.710,
1.990,0.095,1.330,2.460,3.640,1.830,2.180,3.800,2.620,1.420,
1.170,2.280,1.610,0.943,0.748,1.050,1.730,0.172,0.718,1.220,
2.200,1.690,0.905,1.640,1.820,1.010,0.654,0.895,1.010,0.581,
0.501,0.538,0.975,0.075,0.489,0.682,0.800,0.733,0.516,0.810,
1.220,0.854,0.603,0.927,0.100,0.078,0.062,0.118,0.775,0.083,
0.538,0.598,0.767,0.840,0.638,0.860,2.070,0.863,0.827,1.600,
1.310,0.822,0.690,1.200,1.020,0.090,0.548,0.909,1.310,0.886,
0.852,1.560,2.040,0.948,0.614,1.060,1.020,0.702,0.465,0.597,
0.948,0.106,0.396,0.612,0.787,0.844,0.392,0.751,1.180,0.760,
0.437,0.608,0.680,0.443,0.366,0.390,0.670,0.065,0.351,0.534,
0.453,0.514,0.325,0.472,0.750,0.684,0.381,0.542,0.059,0.063,
0.038,0.057,0.703,0.092,0.371,0.549,0.425,0.678,0.373,0.561,
0.696,0.455,0.323,0.591,0.652,0.512,0.344,0.511,0.703,0.059,
0.363,0.583,0.604,0.561,0.463,0.872,1.140,0.527,0.407,0.632,
0.754,0.415,0.355,0.446,0.758,0.100,0.328,0.527,0.659,0.575,
0.449,0.816,0.098,0.065,0.037,0.055,0.063,0.045,0.036,0.042,
0.068,0.015,0.041,0.061,0.069,0.100,0.053,0.091,0.510,0.454,
0.407,0.412,0.051,0.049,0.035,0.045,0.664,0.172,0.273,0.331,
0.380,0.557,0.324,0.393,0.588,0.343,0.272,0.456,0.585,0.420,
0.321,0.477,0.642,0.082,0.416,0.543,0.492,0.554,0.484,0.762,
1.720,0.631,0.483,1.010,0.698,0.381,0.354,0.467,0.759,0.074,
0.307,0.546,1.040,0.733,0.519,1.230,1.650,0.792,0.508,0.651,
0.829,0.509,0.387,0.441,0.674,0.057,0.387,0.579,0.656,0.711,
0.459,0.839,0.632,0.542,0.406,0.595,0.053,0.043,0.037,0.057,
0.594,0.064,0.324,0.492,0.533,0.605,0.466,0.619,1.070,0.536,
0.477,0.981,0.606,0.439,0.402,0.674,0.860,0.066,0.532,0.936,
1.030,0.908,0.873,1.670,1.900,1.110,0.794,1.280,1.030,0.747,
0.596,0.679,0.843,0.089,0.451,0.683,0.811,0.824,0.496,0.893,
1.050,0.864,0.460,0.591,0.746,0.503,0.524,0.465,0.532,0.061,
0.383,0.518,0.393,0.502,0.349,0.522,0.607,0.694,0.468,0.543,
0.072,0.094,0.061,0.074,0.560,0.070,0.625,0.523,0.472,0.632,
0.639,0.651,0.759,0.410,0.431,0.652,0.765,0.612,0.416,0.548,
0.544,0.069,0.373,0.478,0.693,0.493,0.506,0.974,1.350,0.914,
0.447,0.655,0.722,0.713,0.422,0.442,0.664,0.082,0.307,0.447,
0.481,0.626,0.269,0.555,0.718,0.657,0.328,0.419,0.512,0.316,
0.343,0.332,0.508,0.064,0.329,0.473,0.306,0.484,0.276,0.363,
0.519,0.783,0.371,0.427,0.055,0.115,0.041,0.049,0.624,0.096,
0.380,0.607,0.342,0.786,0.400,0.533,0.418,0.372,0.221,0.401,
0.479,0.577,0.252,0.345,0.560,0.058,0.281,0.439,0.401,0.456,
0.313,0.619,0.805,0.486,0.320,0.431,0.639,0.489,0.407,0.395,
0.524,0.079,0.375,0.453,0.362,0.459,0.393,0.523,0.055,0.075,
0.040,0.043,0.054,0.058,0.047,0.037,0.050,0.015,0.052,0.055,
0.033,0.079,0.043,0.048,0.500,0.528,1.450,0.520,0.096,0.066,
0.081,0.054,0.694,0.103,0.358,0.406,0.300,0.578,0.470,0.410,
0.394,0.269,0.315,0.373,0.563,0.509,0.397,0.442,0.531,0.056,
0.427,0.507,0.313,0.395,0.434,0.560,0.740,0.378,0.293,0.483,
0.434,0.327,0.365,0.315,0.375,0.037,0.224,0.311,0.435,0.346,
0.283,0.512,0.750,0.632,0.378,0.428,0.474,0.432,0.330,0.343,
0.367,0.044,0.330,0.424,0.317,0.529,0.333,0.485,0.421,0.482,
0.433,0.451,0.036,0.041,0.029,0.038,0.422,0.047,0.287,0.415,
0.302,0.452,0.387,0.487,0.570,0.342,0.294,0.472,0.493,0.374,
0.268,0.418,0.582,0.050,0.393,0.622,0.590,0.623,0.584,0.984,
1.140,0.817,0.434,0.807,0.549,0.425,0.269,0.402,0.535,0.060,
0.255,0.406,0.580,0.533,0.267,0.553,0.879,1.130,0.356,0.545,
0.503,0.381,0.293,0.350,0.593,0.077,0.349,0.456,0.393,0.565,
0.287,0.475,0.531,0.635,0.365,0.634,0.069,0.069,0.041,0.088,
0.455,0.050,0.257,0.363,0.332,0.487,0.276,0.446,0.600,0.366,
0.296,0.616,0.595,0.423,0.292,0.466,0.554,0.057,0.291,0.527,
0.580,0.494,0.476,1.140,0.089,0.063,0.029,0.052,0.059,0.062,
0.034,0.053,0.052,0.012,0.025,0.038,0.048,0.076,0.029,0.052,
0.064,0.085,0.033,0.045,0.062,0.060,0.041,0.047,0.058,0.014,
0.039,0.047,0.036,0.071,0.028,0.044,0.041,0.059,0.030,0.041,
0.013,0.012,7.60e-3,7.60e-3,0.052,0.012,0.033,0.044,0.034,0.071,
0.032,0.046,0.053,0.041,0.028,0.055,0.086,0.080,0.046,0.068,
0.067,0.010,0.041,0.060,0.058,0.064,0.049,0.101,0.556,0.378,
0.239,0.319,0.368,0.331,0.288,0.270,0.511,0.077,0.257,0.328,
0.315,0.365,0.262,0.374,0.043,0.056,0.025,0.033,0.029,0.037,
0.031,0.023,0.043,0.010,0.035,0.038,0.036,0.064,0.033,0.037,
0.351,0.446,0.308,0.310,0.036,0.043,0.043,0.034,0.395,0.060,
0.201,0.292,0.215,0.399,0.283,0.308,0.336,0.253,0.195,0.252,
0.359,0.358,0.283,0.310,0.528,0.071,0.347,0.425,0.316,0.472,
0.356,0.512,0.543,0.293,0.198,0.420,0.326,0.215,0.173,0.220,
0.382,0.038,0.170,0.293,0.451,0.330,0.209,0.473,0.603,0.461,
0.304,0.411,0.412,0.361,0.282,0.307,0.453,0.046,0.295,0.403,
0.428,0.488,0.288,0.433,0.443,0.497,0.377,0.464,0.043,0.048,
0.034,0.045,0.493,0.050,0.282,0.410,0.373,0.497,0.347,0.493,
0.539,0.330,0.305,0.423,0.449,0.384,0.341,0.407,0.667,0.059,
0.514,0.686,0.639,0.647,0.594,1.030,1.370,0.712,0.479,0.991,
0.500,0.337,0.263,0.370,0.524,0.053,0.227,0.408,0.749,0.592,
0.326,0.761,0.650,0.425,0.248,0.442,0.370,0.213,0.187,0.269,
0.393,0.036,0.187,0.318,0.321,0.360,0.192,0.407,0.519,0.436,
0.283,0.604,0.054,0.049,0.034,0.072,0.416,0.034,0.177,0.299,
0.324,0.380,0.233,0.446,0.743,0.354,0.325,0.784,0.539,0.349,
0.284,0.483,0.459,0.038,0.266,0.458,0.681,0.513,0.471,1.230,
1.160,0.617,0.370,0.692,0.648,0.488,0.311,0.413,0.594,0.078,
0.252,0.436,0.573,0.766,0.287,0.561,0.709,0.536,0.317,0.515,
0.565,0.414,0.327,0.383,0.512,0.083,0.255,0.443,0.373,0.594,
0.227,0.439,0.438,0.423,0.233,0.410,0.045,0.044,0.030,0.047,
0.446,0.049,0.241,0.386,0.355,0.564,0.290,0.474,0.498,0.336,
0.228,0.463,0.523,0.435,0.295,0.540,0.512,0.045,0.292,0.489,
0.522,0.496,0.393,0.819,0.558,0.337,0.221,0.385,0.412,0.270,
0.243,0.319,0.449,0.059,0.246,0.345,0.401,0.409,0.355,0.577,
0.038,0.033,0.024,0.038,0.027,0.027,0.029,0.026,0.034,5.16e-3,
0.041,0.039,0.035,0.055,0.035,0.049,0.347,0.353,0.437,0.346,
0.034,0.031,0.150,0.049,0.369,0.040,0.220,0.276,0.260,0.351,
0.462,0.401,0.355,0.243,0.222,0.340,0.415,0.313,0.418,0.419,
0.501,0.055,0.301,0.456,0.393,0.438,0.433,0.702,0.944,0.409,
0.298,0.632,0.423,0.270,0.228,0.302,0.507,0.042,0.224,0.414,
0.681,0.479,0.393,0.914,0.511,0.314,0.240,0.443,0.366,0.233,
0.242,0.317,0.373,0.030,0.249,0.420,0.393,0.422,0.278,0.527,
0.536,0.485,0.357,0.581,0.042,0.035,0.043,0.050,0.613,0.043,
0.300,0.516,0.552,0.597,0.538,0.736,0.928,0.487,0.412,0.894,
0.638,0.519,0.468,0.673,0.887,0.055,0.565,0.994,1.230,0.909,
0.931,1.980,1.750,1.100,0.876,1.470,1.140,0.800,0.544,0.688,
0.967,0.112,0.461,0.741,1.160,1.040,0.544,1.020,1.150,0.823,
0.486,0.634,0.903,0.578,0.464,0.485,0.665,0.062,0.436,0.575,
0.485,0.557,0.405,0.575,0.591,0.613,0.381,0.576,0.057,0.063,
0.038,0.070,0.455,0.050,0.265,0.312,0.415,0.502,0.328,0.502,
0.831,0.506,0.512,0.855,0.688,0.687,0.430,0.601,0.619,0.076,
0.340,0.516,0.757,0.590,0.517,0.957,1.550,0.891,0.481,0.750,
0.953,0.763,0.397,0.476,0.680,0.094,0.359,0.468,0.541,0.682,
0.304,0.586,0.901,0.767,0.360,0.456,0.695,0.520,0.375,0.416,
0.593,0.089,0.417,0.589,0.345,0.575,0.293,0.456,0.472,0.586,
0.303,0.362,0.063,0.068,0.046,0.046,0.520,0.078,0.355,0.390,
0.311,0.633,0.336,0.432,0.404,0.335,0.235,0.320,0.515,0.512,
0.381,0.356,0.497,0.055,0.295,0.444,0.383,0.438,0.344,0.645,
0.625,0.366,0.240,0.350,0.549,0.359,0.280,0.338,0.536,0.074,
0.243,0.344,0.367,0.386,0.295,0.501,0.049,0.048,0.028,0.036,
0.069,0.051,0.037,0.039,0.044,0.013,0.037,0.046,0.036,0.074,
0.037,0.053,0.288,0.296,0.218,0.246,0.031,0.031,0.025,0.031,
0.288,0.042,0.197,0.240,0.197,0.285,0.221,0.238,0.358,0.215,
0.157,0.247,0.356,0.320,0.209,0.301,0.364,0.064,0.260,0.356,
0.294,0.336,0.357,0.535,0.821,0.337,0.243,0.488,0.442,0.239,
0.170,0.247,0.429,0.043,0.181,0.287,0.555,0.415,0.292,0.646,
0.692,0.475,0.298,0.403,0.735,0.450,0.282,0.343,0.390,0.043,
0.256,0.408,0.322,0.465,0.294,0.450,0.353,0.313,0.321,0.382,
0.032,0.029,0.026,0.036,0.289,0.031,0.233,0.301,0.243,0.337,
0.272,0.358,0.599,0.347,0.258,0.521,0.355,0.331,0.218,0.343,
0.538,0.050,0.323,0.517,0.579,0.592,0.532,1.000,1.260,0.863,
0.564,0.867,0.978,0.793,0.522,0.562,0.545,0.072,0.304,0.451,
0.618,0.662,0.321,0.599,0.973,0.747,0.425,0.503,1.160,0.770,
0.700,0.546,0.481,0.068,0.381,0.528,0.339,0.514,0.288,0.423,
0.428,0.444,0.299,0.376,0.062,0.055,0.040,0.051,0.434,0.048,
0.277,0.301,0.661,0.430,0.293,0.394,0.444,0.275,0.255,0.417,
0.504,0.486,0.294,0.371,0.362,0.038,0.257,0.319,1.000,0.416,
0.358,0.651,1.140,0.844,0.342,0.481,0.846,0.902,0.411,0.415,
0.559,0.080,0.300,0.383,0.401,0.548,0.228,0.457,0.745,0.633,
0.301,0.341,0.427,0.216,0.273,0.260,0.471,0.111,0.291,0.417,
0.272,0.592,0.235,0.324,0.365,0.604,0.259,0.313,0.055,0.105,
0.043,0.043,0.447,0.082,0.289,0.417,0.267,0.626,0.319,0.415,
0.297,0.312,0.183,0.252,0.449,0.691,0.250,0.304,0.361,0.053,
0.255,0.363,0.315,0.392,0.254,0.531,0.608,0.422,0.338,0.328,
0.663,0.580,0.392,0.380,0.462,0.083,0.286,0.352,0.301,0.456,
0.308,0.426,0.049,0.065,0.070,0.038,0.120,0.104,0.059,0.042,
0.054,0.026,0.050,0.049,0.030,0.110,0.040,0.039,0.303,0.410,
0.321,0.308,0.045,0.064,0.045,0.043,0.351,0.056,0.272,0.321,
0.188,0.430,0.370,0.326,0.272,0.211,0.170,0.228,0.424,0.513,
0.358,0.376,0.414,0.049,0.359,0.411,0.279,0.346,0.380,0.491,
0.522,0.294,0.215,0.371,0.396,0.294,0.191,0.238,0.343,0.034,
0.165,0.231,0.413,0.297,0.220,0.383,0.469,0.436,0.349,0.349,
0.612,0.622,0.328,0.341,0.371,0.053,0.261,0.347,0.239,0.491,
0.253,0.338,0.292,0.351,0.272,0.321,0.029,0.039,0.023,0.030,
0.270,0.032,0.269,0.305,0.208,0.352,0.331,0.380,0.361,0.251,
0.186,0.326,0.364,0.356,0.221,0.331,0.394,0.037,0.284,0.404,
0.404,0.497,0.427,0.735,1.030,0.617,0.381,0.619,0.572,0.454,
0.233,0.353,0.451,0.053,0.218,0.312,0.448,0.435,0.208,0.468,
0.806,0.769,0.276,0.427,0.609,0.507,0.335,0.372,0.567,0.074,
0.417,0.460,0.310,0.515,0.235,0.399,0.499,0.574,0.376,0.680,
0.118,0.070,0.043,0.091,0.404,0.056,0.220,0.324,0.272,0.421,
0.229,0.381,0.443,0.306,0.222,0.511,0.497,0.427,0.265,0.430,
0.429,0.052,0.279,0.463,0.446,0.399,0.367,0.832,0.157,0.052,
0.025,0.040,0.090,0.093,0.035,0.039,0.047,0.010,0.026,0.033,
0.035,0.061,0.031,0.063,0.064,0.061,0.025,0.030,0.080,0.105,
0.052,0.048,0.064,0.031,0.053,0.053,0.026,0.070,0.026,0.036,
0.080,0.061,0.034,0.042,0.069,0.029,0.012,0.011,0.067,0.019,
0.043,0.042,0.037,0.066,0.035,0.037,0.041,0.029,0.018,0.036,
0.130,0.101,0.042,0.054,0.046,9.69e-3,0.040,0.049,0.036,0.042,
0.036,0.065,0.599,0.468,0.291,0.358,0.496,0.545,0.318,0.344,
0.508,0.092,0.300,0.358,0.309,0.427,0.277,0.438,0.048,0.073,
0.037,0.036,0.047,0.080,0.051,0.037,0.051,0.020,0.058,0.050,
0.033,0.078,0.036,0.040,0.331,0.495,0.281,0.328,0.048,0.063,
0.040,0.045,0.415,0.071,0.204,0.336,0.196,0.435,0.253,0.312,
0.304,0.243,0.166,0.277,0.400,0.484,0.296,0.407,0.552,0.075,
0.438,0.510,0.294,0.416,0.335,0.504,0.497,0.287,0.205,0.415,
0.312,0.220,0.150,0.217,0.337,0.037,0.193,0.326,0.347,0.294,
0.189,0.520,0.549,0.501,0.281,0.348,0.525,0.514,0.336,0.338,
0.490,0.065,0.409,0.515,0.323,0.535,0.292,0.432,0.368,0.478,
0.525,0.529,0.042,0.046,0.042,0.052,0.432,0.056,0.342,0.429,
0.288,0.524,0.341,0.447,0.409,0.289,0.251,0.446,0.402,0.372,
0.272,0.399,0.616,0.056,0.521,0.662,0.523,0.610,0.526,0.847,
0.844,0.421,0.282,0.599,0.417,0.277,0.179,0.332,0.372,0.035,
0.162,0.319,0.450,0.350,0.186,0.523,0.545,0.361,0.178,0.327,
0.343,0.226,0.161,0.254,0.303,0.029,0.164,0.272,0.238,0.276,
0.138,0.338,0.347,0.294,0.181,0.386,0.037,0.024,0.014,0.041,
0.263,0.023,0.126,0.232,0.218,0.255,0.140,0.303,0.431,0.245,
0.192,0.473,0.326,0.228,0.170,0.350,0.316,0.027,0.196,0.345,
0.427,0.330,0.299,0.783,1.030,0.468,0.244,0.457,0.607,0.539,
0.251,0.329,0.451,0.060,0.223,0.344,0.395,0.532,0.203,0.453,
0.568,0.466,0.181,0.279,0.591,0.507,0.249,0.316,0.519,0.094,
0.278,0.432,0.348,0.646,0.224,0.420,0.351,0.353,0.180,0.289,
0.091,0.051,0.024,0.040,0.379,0.047,0.226,0.319,0.271,0.433,
0.234,0.343,0.295,0.215,0.158,0.281,0.432,0.398,0.220,0.379,
0.364,0.039,0.272,0.385,0.320,0.354,0.293,0.556,0.417,0.266,
0.178,0.276,0.371,0.321,0.216,0.291,0.358,0.049,0.224,0.308,
0.271,0.300,0.229,0.437,0.025,0.025,0.015,0.022,0.024,0.035,
0.019,0.023,0.024,5.87e-3,0.022,0.028,0.021,0.038,0.021,0.033,
0.233,0.282,0.164,0.243,0.021,0.025,0.016,0.032,0.299,0.038,
0.180,0.265,0.180,0.303,0.212,0.278,0.246,0.213,0.138,0.235,
0.304,0.315,0.197,0.326,0.439,0.101,0.291,0.413,0.281,0.402,
0.303,0.494,0.564,0.312,0.209,0.407,0.287,0.210,0.155,0.217,
0.323,0.031,0.206,0.294,0.376,0.292,0.239,0.540,0.408,0.275,
0.168,0.265,0.314,0.274,0.187,0.286,0.284,0.025,0.236,0.312,
0.276,0.306,0.216,0.400,0.342,0.323,0.254,0.381,0.027,0.025,
0.017,0.033,0.362,0.032,0.246,0.374,0.304,0.420,0.361,0.490,
0.539,0.323,0.273,0.543,0.438,0.481,0.309,0.464,0.569,0.053,
0.486,0.725,0.792,0.765,0.687,0.892,1.060,0.657,0.545,0.996,
0.750,0.557,0.419,0.549,0.637,0.067,0.292,0.512,0.864,0.717,
0.394,0.740,0.595,0.379,0.272,0.404,0.443,0.283,0.292,0.312,
0.334,0.035,0.226,0.294,0.318,0.332,0.240,0.358,0.506,0.352,
0.244,0.415,0.040,0.032,0.026,0.058,0.302,0.029,0.190,0.406,
0.256,0.316,0.241,0.391,0.617,0.311,0.250,0.511,0.474,0.348,
0.276,0.432,0.341,0.033,0.216,0.339,0.461,0.314,0.329,0.654,
0.967,0.597,0.389,0.620,0.699,0.539,0.405,0.418,0.503,0.066,
0.227,0.329,0.461,0.560,0.228,0.440,0.586,0.474,0.277,0.379,
0.538,0.369,0.353,0.324,0.441,0.062,0.259,0.379,0.286,0.434,
0.218,0.324,0.547,0.498,0.344,0.432,0.055,0.059,0.052,0.059,
0.538,0.073,0.366,0.642,0.304,0.540,0.330,0.423,0.424,0.292,
0.191,0.343,0.571,0.511,0.293,0.411,0.387,0.039,0.235,0.361,
0.359,0.353,0.300,0.586,0.558,0.307,0.270,0.365,0.541,0.402,
0.359,0.371,0.839,0.127,0.268,0.344,0.519,0.595,0.283,0.512,
0.044,0.042,0.028,0.040,0.049,0.050,0.045,0.045,0.088,0.021,
0.049,0.052,0.066,0.144,0.045,0.072,0.313,0.255,0.236,0.260,
0.033,0.032,0.031,0.041,0.343,0.063,0.206,0.225,0.205,0.366,
0.202,0.235,0.259,0.166,0.147,0.218,0.347,0.301,0.277,0.347,
0.319,0.043,0.499,0.322,0.296,0.306,0.293,0.432,0.637,0.278,
0.240,0.480,0.346,0.224,0.209,0.275,0.481,0.049,0.177,0.274,
0.645,0.487,0.271,0.650,0.479,0.332,0.246,0.337,0.376,0.288,
0.268,0.281,0.512,0.058,0.266,0.357,0.468,0.594,0.285,0.495,
0.339,0.328,0.245,0.370,0.029,0.026,0.027,0.044,0.318,0.035,
0.235,0.348,0.284,0.389,0.328,0.421,0.511,0.292,0.261,0.544,
0.335,0.255,0.291,0.429,0.521,0.048,0.429,0.556,0.732,0.629,
0.708,1.260,0.050,0.039,0.030,0.040,0.048,0.044,0.028,0.035,
0.032,5.06e-3,0.017,0.025,0.036,0.039,0.021,0.033,0.048,0.041,
0.041,0.031,0.051,0.044,0.041,0.034,0.030,7.88e-3,0.034,0.029,
0.021,0.035,0.023,0.030,0.030,0.031,0.021,0.026,4.14e-3,6.23e-3,
4.95e-3,5.91e-3,0.025,4.47e-3,0.023,0.031,0.019,0.030,0.025,0.030,
0.033,0.024,0.021,0.034,0.040,0.039,0.028,0.039,0.027,3.59e-3,
0.020,0.031,0.034,0.028,0.029,0.050,0.056,0.054,0.027,0.036,
0.055,0.067,0.038,0.032,0.035,9.30e-3,0.023,0.023,0.025,0.042,
0.020,0.029,0.054,0.067,0.033,0.032,0.078,0.067,0.055,0.043,
0.048,0.018,0.035,0.039,0.024,0.053,0.027,0.031,0.036,0.055,
0.036,0.031,8.67e-3,0.018,0.013,7.58e-3,0.055,0.019,0.043,0.047,
0.022,0.060,0.039,0.039,0.032,0.028,0.018,0.027,0.052,0.072,
0.034,0.039,0.036,7.31e-3,0.027,0.033,0.025,0.035,0.029,0.060,
0.033,0.027,0.017,0.020,0.040,0.047,0.035,0.030,0.053,0.017,
0.026,0.026,0.025,0.050,0.022,0.035,4.05e-3,7.65e-3,4.22e-3,4.14e-3,
7.50e-3,0.014,0.013,6.39e-3,0.018,0.018,0.013,9.57e-3,3.89e-3,0.021,
6.87e-3,5.91e-3,0.024,0.037,0.046,0.028,5.56e-3,0.012,0.012,6.98e-3,
0.064,0.038,0.033,0.033,0.017,0.073,0.033,0.029,0.024,0.019,
0.017,0.022,0.036,0.047,0.040,0.037,0.036,8.92e-3,0.047,0.038,
0.023,0.033,0.033,0.052,0.044,0.035,0.025,0.038,0.032,0.028,
0.022,0.026,0.036,5.64e-3,0.018,0.023,0.048,0.049,0.029,0.056,
0.053,0.052,0.035,0.040,0.056,0.062,0.049,0.047,0.071,0.018,
0.044,0.051,0.052,0.126,0.046,0.064,0.026,0.037,0.029,0.034,
3.63e-3,6.02e-3,5.35e-3,5.60e-3,0.036,8.46e-3,0.032,0.043,0.026,0.050,
0.048,0.047,0.039,0.030,0.023,0.039,0.033,0.035,0.030,0.038,
0.047,6.20e-3,0.040,0.051,0.053,0.059,0.058,0.090,0.699,0.444,
0.296,0.550,0.498,0.410,0.259,0.354,0.429,0.042,0.210,0.287,
0.361,0.317,0.196,0.366,0.471,0.415,0.233,0.330,0.453,0.419,
0.408,0.336,0.430,0.054,0.322,0.352,0.257,0.370,0.226,0.340,
0.408,0.452,0.287,0.440,0.054,0.064,0.044,0.084,0.436,0.066,
0.258,0.345,0.260,0.590,0.254,0.392,0.363,0.252,0.175,0.379,
0.375,0.355,0.259,0.435,0.375,0.048,0.256,0.439,0.389,0.394,
0.330,0.764,0.049,0.046,0.021,0.034,0.053,0.071,0.034,0.039,
0.033,8.82e-3,0.023,0.025,0.026,0.040,0.018,0.032,0.035,0.040,
0.020,0.024,0.054,0.057,0.050,0.037,0.044,0.012,0.043,0.041,
0.021,0.039,0.022,0.027,0.035,0.054,0.028,0.036,8.27e-3,0.015,
0.011,9.48e-3,0.048,0.018,0.045,0.050,0.026,0.067,0.033,0.038,
0.041,0.029,0.018,0.038,0.056,0.067,0.037,0.057,0.041,7.83e-3,
0.035,0.052,0.033,0.040,0.033,0.070,0.442,0.473,0.211,0.246,
0.445,0.539,0.546,0.333,0.384,0.077,0.297,0.301,0.226,0.327,
0.270,0.333,0.033,0.057,0.030,0.028,0.041,0.064,0.179,0.038,
0.040,0.015,0.062,0.044,0.029,0.059,0.035,0.035,0.319,0.408,
0.267,0.275,0.043,0.056,0.057,0.048,0.350,0.057,0.151,0.241,
0.159,0.310,0.275,0.287,0.249,0.208,0.146,0.188,0.335,0.383,
0.326,0.334,0.379,0.052,0.351,0.385,0.264,0.317,0.325,0.431,
0.396,0.274,0.181,0.304,0.295,0.223,0.189,0.202,0.320,0.037,
0.195,0.267,0.310,0.277,0.177,0.367,0.446,0.421,0.274,0.318,
0.482,0.454,0.655,0.334,0.397,0.054,0.394,0.425,0.433,0.486,
0.300,0.404,0.435,0.664,0.311,0.409,0.047,0.087,0.041,0.052,
0.436,0.059,0.387,0.480,0.326,0.538,0.381,0.480,0.375,0.292,
0.214,0.368,0.344,0.380,0.276,0.372,0.487,0.053,0.450,0.584,
0.460,0.536,0.509,0.810,0.737,0.373,0.261,0.553,0.402,0.276,
0.212,0.353,0.342,0.034,0.150,0.258,0.422,0.349,0.199,0.469,
0.406,0.274,0.162,0.257,0.287,0.209,0.185,0.239,0.234,0.021,
0.135,0.219,0.194,0.205,0.134,0.246,0.408,0.320,0.188,0.350,
0.035,0.030,0.020,0.048,0.275,0.028,0.141,0.254,0.248,0.335,
0.194,0.341,0.486,0.259,0.199,0.416,0.374,0.265,0.214,0.383,
0.293,0.026,0.179,0.297,0.451,0.350,0.310,0.721,0.772,0.520,
0.280,0.566,0.584,0.525,0.325,0.420,0.401,0.053,0.232,0.319,
0.393,0.443,0.204,0.420,0.526,0.484,0.221,0.343,0.618,0.458,
0.351,0.385,0.412,0.055,0.275,0.384,0.272,0.421,0.212,0.318,
0.415,0.476,0.252,0.417,0.046,0.057,0.034,0.055,0.466,0.069,
0.302,0.485,0.412,0.697,0.330,0.512,0.435,0.289,0.217,0.421,
0.525,0.463,0.342,0.566,0.422,0.041,0.283,0.460,0.407,0.435,
0.383,0.673,0.523,0.366,0.273,0.417,0.435,0.381,0.333,0.381,
0.404,0.053,0.238,0.334,0.293,0.322,0.282,0.462,0.031,0.036,
0.020,0.029,0.033,0.056,0.038,0.033,0.026,6.79e-3,0.029,0.037,
0.026,0.043,0.025,0.036,0.322,0.383,0.229,0.329,0.036,0.040,
0.028,0.044,0.364,0.050,0.235,0.349,0.227,0.418,0.290,0.381,
0.340,0.251,0.190,0.312,0.437,0.389,0.352,0.487,0.396,0.044,
0.337,0.465,0.341,0.369,0.402,0.590,0.584,0.311,0.232,0.461,
0.360,0.254,0.212,0.268,0.352,0.038,0.189,0.317,0.447,0.345,
0.265,0.613,0.419,0.343,0.190,0.319,0.329,0.310,0.271,0.294,
0.283,0.029,0.220,0.376,0.295,0.342,0.237,0.443,0.452,0.504,
0.290,0.489,0.036,0.044,0.022,0.049,0.518,0.052,0.367,0.626,
0.439,0.651,0.487,0.645,0.689,0.396,0.325,0.689,0.543,0.509,
0.404,0.606,0.669,0.059,0.543,0.859,0.856,0.888,0.773,1.170,
1.190,0.642,0.611,1.350,0.653,0.380,0.309,0.515,0.659,0.056,
0.278,0.527,1.010,0.752,0.387,0.901,0.651,0.358,0.265,0.434,
0.384,0.201,0.196,0.245,0.350,0.027,0.231,0.271,0.404,0.385,
0.252,0.451,0.517,0.356,0.266,0.479,0.035,0.028,0.021,0.051,
0.318,0.025,0.182,0.297,0.341,0.351,0.248,0.492,0.758,0.372,
0.331,0.713,0.462,0.304,0.250,0.463,0.433,0.036,0.328,0.400,
0.664,0.437,0.425,0.993,0.798,0.386,0.255,0.500,0.419,0.250,
0.180,0.267,0.362,0.035,0.150,0.259,0.401,0.365,0.169,0.424,
0.419,0.275,0.169,0.260,0.276,0.181,0.144,0.187,0.272,0.023,
0.140,0.217,0.261,0.244,0.150,0.288,0.354,0.282,0.194,0.323,
0.027,0.020,0.015,0.029,0.307,0.025,0.165,0.297,0.269,0.295,
0.203,0.357,0.370,0.224,0.153,0.323,0.285,0.208,0.135,0.240,
0.297,0.022,0.187,0.270,0.326,0.260,0.233,0.538,0.565,0.278,
0.264,0.419,0.374,0.228,0.224,0.329,0.491,0.055,0.199,0.323,
0.533,0.413,0.239,0.608,0.035,0.025,0.017,0.030,0.026,0.020,
0.017,0.028,0.032,4.51e-3,0.018,0.027,0.058,0.070,0.027,0.060,
0.266,0.222,0.195,0.269,0.020,0.016,0.017,0.027,0.286,0.027,
0.205,0.233,0.232,0.259,0.201,0.288,0.303,0.182,0.158,0.287,
0.275,0.200,0.174,0.291,0.284,0.027,0.224,0.293,0.354,0.284,
0.295,0.564,0.797,0.314,0.285,0.640,0.352,0.189,0.189,0.309,
0.617,0.054,0.207,0.364,1.100,0.598,0.317,0.892,0.470,0.278,
0.211,0.344,0.281,0.184,0.168,0.242,0.404,0.033,0.197,0.307,
0.658,0.634,0.292,0.593,0.381,0.315,0.255,0.415,0.026,0.020,
0.020,0.034,0.326,0.024,0.227,0.322,0.397,0.377,0.317,0.517,
0.658,0.365,0.335,0.728,0.364,0.252,0.256,0.410,0.550,0.041,
0.341,0.625,0.945,0.714,0.742,1.660,1.050,0.591,0.426,0.871,
0.615,0.437,0.279,0.430,0.492,0.054,0.255,0.399,0.642,0.577,
0.300,0.651,0.658,0.417,0.324,0.463,0.484,0.312,0.281,0.319,
0.368,0.041,0.515,0.373,0.291,0.384,0.274,0.413,0.429,0.369,
0.260,0.455,0.036,0.036,0.025,0.054,0.327,0.035,0.246,0.476,
0.312,0.386,0.291,0.558,0.512,0.293,0.253,0.504,0.453,0.384,
0.253,0.472,0.355,0.034,0.227,0.386,0.479,0.347,0.354,0.785,
0.763,0.494,0.271,0.507,0.496,0.412,0.243,0.303,0.368,0.045,
0.165,0.274,0.357,0.388,0.183,0.420,0.540,0.464,0.226,0.317,
0.458,0.317,0.242,0.300,0.354,0.046,0.214,0.294,0.267,0.398,
0.200,0.337,0.388,0.410,0.237,0.364,0.041,0.041,0.025,0.038,
0.426,0.050,0.251,0.382,0.316,0.468,0.292,0.456,0.394,0.276,
0.182,0.362,0.382,0.394,0.189,0.328,0.362,0.031,0.217,0.336,
0.347,0.327,0.284,0.603,0.531,0.314,0.206,0.333,0.411,0.360,
0.259,0.313,0.450,0.075,0.197,0.283,0.393,0.479,0.223,0.552,
0.027,0.033,0.018,0.027,0.032,0.039,0.029,0.032,0.038,0.019,
0.029,0.034,0.039,0.103,0.029,0.049,0.312,0.374,0.274,0.325,
0.028,0.035,0.028,0.038,0.375,0.064,0.194,0.291,0.236,0.443,
0.300,0.383,0.340,0.261,0.187,0.318,0.363,0.375,0.295,0.384,
0.364,0.035,0.246,0.371,0.338,0.331,0.350,0.658,0.572,0.329,
0.253,0.480,0.329,0.240,0.191,0.263,0.442,0.046,0.194,0.295,
0.691,0.576,0.294,0.664,0.514,0.423,0.298,0.412,0.393,0.376,
0.293,0.363,0.522,0.087,0.312,0.414,0.750,2.000,0.412,0.740,
0.349,0.356,0.277,0.408,0.026,0.030,0.023,0.035,0.359,0.037,
0.269,0.429,0.374,0.516,0.397,0.557,0.483,0.320,0.276,0.458,
0.393,0.355,0.312,0.414,0.485,0.039,0.343,0.570,0.675,0.654,
0.597,1.160,0.789,0.433,0.280,0.565,0.369,0.305,0.165,0.283,
0.397,0.036,0.164,0.307,0.436,0.327,0.197,0.499,0.518,0.403,
0.207,0.397,0.346,0.298,0.203,0.245,0.360,0.039,0.236,0.305,
0.297,0.364,0.218,0.383,0.395,0.404,0.244,0.432,0.046,0.049,
0.026,0.058,0.353,0.042,0.215,0.333,0.283,0.425,0.261,0.455,
0.410,0.268,0.186,0.436,0.370,0.343,0.200,0.364,0.410,0.044,
0.239,0.442,0.476,0.399,0.364,0.899,0.047,0.036,0.026,0.034,
0.032,0.041,0.017,0.025,0.024,4.28e-3,0.014,0.022,0.027,0.032,
0.016,0.037,0.028,0.029,0.013,0.021,0.034,0.052,0.018,0.021,
0.029,6.00e-3,0.024,0.025,0.020,0.033,0.015,0.024,0.025,0.028,
0.015,0.021,5.77e-3,6.25e-3,3.51e-3,3.55e-3,0.030,6.77e-3,0.028,0.033,
0.026,0.043,0.027,0.033,0.032,0.024,0.015,0.033,0.042,0.052,
0.020,0.039,0.031,5.62e-3,0.022,0.038,0.036,0.036,0.026,0.061,
0.455,0.327,0.169,0.239,0.309,0.311,0.229,0.256,0.345,0.054,
0.183,0.255,0.258,0.324,0.259,0.408,0.025,0.029,0.014,0.019,
0.022,0.029,0.025,0.019,0.027,6.77e-3,0.025,0.024,0.028,0.049,
0.027,0.037,0.286,0.380,0.213,0.268,0.029,0.038,0.028,0.033,
0.398,0.048,0.196,0.302,0.220,0.366,0.276,0.348,0.307,0.219,
0.157,0.240,0.315,0.331,0.242,0.317,0.455,0.046,0.295,0.400,
0.352,0.377,0.357,0.572,0.491,0.240,0.166,0.328,0.256,0.198,
0.148,0.216,0.353,0.035,0.189,0.282,0.371,0.296,0.200,0.446,
0.448,0.328,0.218,0.318,0.324,0.298,0.261,0.273,0.400,0.041,
0.291,0.379,0.389,0.489,0.336,0.463,0.816,0.516,0.318,0.442,
0.059,0.044,0.027,0.038,0.515,0.045,0.325,0.463,0.690,0.541,
0.434,0.600,0.502,0.321,0.266,0.443,0.363,0.327,0.244,0.389,
0.606,0.046,0.461,0.664,0.678,0.608,0.563,1.010,1.140,0.463,
0.347,0.804,0.464,0.261,0.214,0.428,0.464,0.040,0.188,0.402,
0.635,0.438,0.263,0.721,0.541,0.295,0.166,0.312,0.323,0.192,
0.157,0.266,0.297,0.023,0.157,0.294,0.265,0.245,0.160,0.342,
0.430,0.366,0.228,0.474,0.038,0.035,0.023,0.056,0.298,0.028,
0.145,0.307,0.323,0.346,0.214,0.449,0.586,0.305,0.255,0.607,
0.388,0.263,0.226,0.422,0.379,0.030,0.206,0.445,0.638,0.434,
0.386,1.120,0.752,0.402,0.263,0.579,0.434,0.314,0.208,0.344,
0.334,0.032,0.165,0.305,0.378,0.358,0.176,0.469,0.472,0.359,
0.157,0.285,0.375,0.310,0.162,0.261,0.321,0.032,0.198,0.310,
0.249,0.312,0.160,0.339,0.319,0.288,0.151,0.321,0.025,0.028,
0.013,0.029,0.327,0.029,0.203,0.329,0.314,0.411,0.221,0.432,
0.398,0.249,0.185,0.394,0.430,0.319,0.172,0.367,0.334,0.031,
0.189,0.357,0.427,0.569,0.293,0.797,0.609,0.362,0.289,0.441,
0.400,0.291,0.260,0.388,0.485,0.050,0.211,0.401,0.486,0.406,
0.358,0.743,0.034,0.029,0.015,0.029,0.024,0.026,0.019,0.032,
0.026,3.80e-3,0.017,0.029,0.038,0.045,0.025,0.056,0.359,0.396,
0.221,0.401,0.026,0.028,0.019,0.037,0.396,0.040,0.225,0.358,
0.308,0.412,0.307,0.491,0.467,0.339,0.233,0.444,0.446,0.387,
0.288,0.503,0.555,0.049,0.341,0.578,0.518,0.492,0.453,0.890,
1.060,0.434,0.347,0.735,0.436,0.286,0.258,0.375,0.577,0.046,
0.274,0.525,0.843,0.535,0.425,1.140,0.654,0.394,0.237,0.430,
0.443,0.371,0.260,0.420,0.480,0.035,0.296,0.565,0.528,0.534,
0.331,1.040,0.672,0.551,0.362,0.686,0.041,0.036,0.021,0.055,
0.729,0.048,0.398,0.773,0.697,0.737,0.613,1.030,1.310,0.589,
0.533,1.210,0.760,0.584,0.475,1.050,1.040,0.066,0.774,1.380,
1.410,1.080,1.070,1.640,1.960,0.831,0.746,1.220,0.834,0.470,
0.467,0.576,0.885,0.078,0.455,0.669,1.320,0.854,0.572,1.020,
1.000,0.527,0.420,0.524,0.558,0.321,0.308,0.319,0.513,0.036,
0.316,0.382,0.481,0.401,0.355,0.492,0.657,0.404,0.339,0.524,
0.049,0.039,0.033,0.062,0.373,0.031,0.229,0.296,0.426,0.397,
0.347,0.467,1.010,0.455,0.435,0.912,0.659,0.442,0.422,0.647,
0.502,0.041,0.348,0.484,0.725,0.445,0.514,0.904,1.010,0.507,
0.326,0.492,0.504,0.290,0.228,0.285,0.411,0.037,0.259,0.306,
0.401,0.368,0.225,0.408,0.614,0.385,0.231,0.308,0.336,0.185,
0.190,0.202,0.318,0.025,0.195,0.266,0.259,0.249,0.242,0.307,
0.364,0.308,0.184,0.279,0.034,0.022,0.016,0.027,0.277,0.024,
0.158,0.251,0.207,0.263,0.181,0.251,0.398,0.245,0.185,0.333,
0.355,0.234,0.188,0.297,0.318,0.023,0.230,0.319,0.321,0.267,
0.288,0.493,0.928,0.312,0.293,0.409,0.480,0.249,0.252,0.299,
0.369,0.042,0.222,0.285,0.427,0.346,0.401,0.561,0.055,0.030,
0.020,0.032,0.034,0.021,0.018,0.025,0.027,4.03e-3,0.019,0.027,
0.046,0.052,0.039,0.054,0.304,0.203,0.180,0.231,0.024,0.015,
0.016,0.024,0.246,0.025,0.143,0.188,0.235,0.212,0.241,0.255,
0.300,0.171,0.163,0.275,0.341,0.215,0.191,0.299,0.320,0.026,
0.236,0.379,0.302,0.262,0.311,0.538,1.250,0.349,0.342,0.606,
0.381,0.201,0.221,0.251,0.370,0.033,0.192,0.279,0.512,0.340,
0.335,0.709,0.612,0.304,0.254,0.338,0.327,0.189,0.200,0.220,
0.295,0.022,0.192,0.255,0.348,0.313,0.272,0.437,0.396,0.246,
0.200,0.295,0.023,0.016,0.014,0.024,0.240,0.017,0.150,0.236,
0.244,0.249,0.235,0.336,0.583,0.251,0.250,0.515,0.268,0.148,
0.181,0.280,0.397,0.026,0.278,0.450,0.580,0.394,0.519,0.974,
1.290,0.702,0.531,0.856,0.615,0.417,0.357,0.432,0.467,0.047,
0.241,0.396,0.615,0.537,0.384,0.660,0.816,0.554,0.351,0.463,
0.493,0.353,0.332,0.319,0.412,0.042,0.291,0.376,0.321,0.338,
0.281,0.413,0.409,0.307,0.259,0.339,0.033,0.033,0.025,0.039,
0.242,0.026,0.169,0.226,0.211,0.282,0.230,0.352,0.506,0.232,
0.235,0.445,0.438,0.302,0.249,0.349,0.286,0.027,0.193,0.308,
0.358,0.273,0.356,0.645,0.882,0.565,0.284,0.439,0.482,0.374,
0.246,0.306,0.351,0.036,0.194,0.263,0.347,0.354,0.200,0.352,
0.561,0.411,0.243,0.283,0.295,0.142,0.201,0.199,0.298,0.032,
0.214,0.290,0.238,0.259,0.205,0.292,0.333,0.353,0.219,0.283,
0.027,0.031,0.021,0.027,0.271,0.034,0.196,0.278,0.202,0.420,
0.212,0.296,0.300,0.213,0.164,0.256,0.298,0.237,0.162,0.222,
0.240,0.022,0.169,0.241,0.242,0.227,0.215,0.392,0.745,0.344,
0.243,0.348,0.450,0.326,0.308,0.298,0.336,0.039,0.211,0.286,
0.286,0.292,0.310,0.455,0.043,0.041,0.022,0.032,0.033,0.035,
0.030,0.027,0.027,6.56e-3,0.029,0.036,0.027,0.048,0.037,0.047,
0.311,0.305,0.271,0.307,0.028,0.031,0.029,0.030,0.279,0.037,
0.225,0.269,0.220,0.366,0.404,0.372,0.269,0.164,0.187,0.255,
0.349,0.285,0.265,0.322,0.316,0.028,0.297,0.393,0.252,0.271,
0.383,0.516,0.705,0.320,0.264,0.430,0.326,0.212,0.196,0.240,
0.244,0.022,0.141,0.213,0.299,0.249,0.236,0.452,0.567,0.366,
0.276,0.380,0.370,0.288,0.268,0.322,0.283,0.023,0.232,0.346,
0.292,0.342,0.299,0.482,0.296,0.287,0.240,0.331,0.023,0.023,
0.019,0.025,0.234,0.020,0.187,0.274,0.240,0.292,0.349,0.433,
0.404,0.210,0.247,0.385,0.327,0.212,0.214,0.308,0.343,0.025,
0.299,0.458,0.462,0.405,0.693,0.896,0.784,0.487,0.338,0.552,
0.381,0.307,0.189,0.270,0.359,0.036,0.174,0.286,0.447,0.361,
0.249,0.445,0.674,0.500,0.289,0.418,0.402,0.349,0.265,0.279,
0.444,0.041,0.283,0.350,0.311,0.369,0.253,0.390,0.423,0.482,
0.345,0.392,0.045,0.054,0.035,0.055,0.274,0.030,0.181,0.251,
0.221,0.348,0.226,0.319,0.494,0.310,0.260,0.464,0.419,0.425,
0.257,0.366,0.353,0.033,0.238,0.367,0.415,0.357,0.360,0.758,
0.060,0.048,0.033,0.045,0.064,0.047,0.024,0.033,0.036,5.10e-3,
0.022,0.029,0.039,0.042,0.027,0.041,0.056,0.053,0.028,0.034,
0.045,0.048,0.029,0.028,0.046,7.10e-3,0.032,0.040,0.031,0.049,
0.028,0.039,0.038,0.048,0.027,0.036,4.97e-3,6.56e-3,5.52e-3,5.29e-3,
0.042,6.89e-3,0.030,0.039,0.026,0.056,0.031,0.036,0.062,0.043,
0.031,0.053,0.084,0.078,0.046,0.063,0.045,7.33e-3,0.040,0.056,
0.051,0.058,0.048,0.086,0.462,0.288,0.197,0.245,0.301,0.250,
0.229,0.210,0.324,0.051,0.236,0.260,0.262,0.301,0.260,0.336,
0.038,0.038,0.018,0.024,0.029,0.026,0.022,0.018,0.043,0.011,
0.029,0.026,0.032,0.051,0.031,0.033,0.256,0.326,0.203,0.214,
0.036,0.028,0.025,0.024,0.254,0.032,0.152,0.193,0.164,0.232,
0.209,0.222,0.267,0.177,0.155,0.216,0.421,0.287,0.226,0.288,
0.278,0.035,0.273,0.349,0.228,0.264,0.273,0.389,0.442,0.232,
0.171,0.348,0.266,0.162,0.141,0.171,0.258,0.025,0.154,0.204,
0.283,0.240,0.226,0.362,0.549,0.370,0.230,0.353,0.371,0.301,
0.224,0.249,0.500,0.037,0.263,0.334,0.342,0.404,0.281,0.381,
0.311,0.327,0.262,0.378,0.041,0.030,0.024,0.032,0.271,0.027,
0.216,0.289,0.235,0.363,0.274,0.375,0.453,0.268,0.236,0.396,
0.590,0.265,0.220,0.297,0.391,0.036,0.336,0.473,0.488,0.416,
0.447,0.706,0.900,0.430,0.326,0.638,0.350,0.241,0.192,0.275,
0.331,0.030,0.162,0.269,0.523,0.335,0.263,0.570,0.473,0.264,
0.185,0.288,0.266,0.192,0.152,0.213,0.316,0.022,0.152,0.254,
0.249,0.202,0.163,0.297,0.330,0.247,0.195,0.356,0.027,0.025,
0.020,0.042,0.205,0.019,0.124,0.208,0.197,0.242,0.168,0.309,
0.510,0.248,0.265,0.590,0.336,0.255,0.228,0.402,0.338,0.025,
0.230,0.358,0.464,0.322,0.363,0.858,0.655,0.390,0.238,0.429,
0.422,0.312,0.188,0.256,0.335,0.033,0.197,0.274,0.339,0.297,
0.208,0.380,0.465,0.350,0.182,0.258,0.302,0.249,0.160,0.195,
0.298,0.030,0.183,0.262,0.246,0.262,0.174,0.275,0.314,0.257,
0.170,0.300,0.023,0.022,0.017,0.028,0.261,0.023,0.170,0.276,
0.230,0.299,0.195,0.326,0.411,0.219,0.193,0.379,0.357,0.261,
0.215,0.355,0.325,0.027,0.271,0.389,0.357,0.341,0.303,0.576,
0.541,0.276,0.212,0.326,0.417,0.276,0.226,0.314,0.370,0.042,
0.248,0.314,0.322,0.291,0.392,0.519,0.038,0.029,0.018,0.028,
0.025,0.025,0.019,0.024,0.028,3.86e-3,0.025,0.033,0.034,0.039,
0.033,0.048,0.294,0.266,0.196,0.329,0.023,0.019,0.018,0.035,
0.281,0.025,0.207,0.286,0.215,0.272,0.275,0.390,0.326,0.210,
0.207,0.386,0.383,0.275,0.281,0.541,0.439,0.036,0.319,0.577,
0.354,0.335,0.402,0.671,0.778,0.332,0.276,0.539,0.366,0.255,
0.227,0.308,0.366,0.033,0.213,0.332,0.495,0.337,0.345,0.741,
0.417,0.257,0.195,0.322,0.258,0.162,0.176,0.232,0.320,0.021,
0.219,0.341,0.353,0.308,0.266,0.483,0.460,0.383,0.326,0.684,
0.034,0.026,0.022,0.052,0.393,0.029,0.274,0.456,0.395,0.436,
0.416,0.691,0.819,0.386,0.414,0.882,0.558,0.383,0.408,0.658,
0.721,0.041,0.521,0.886,1.160,0.738,0.884,1.460,0.088,0.044,
0.042,0.056,0.049,0.036,0.029,0.031,0.038,4.51e-3,0.028,0.034,
0.049,0.042,0.029,0.043,0.051,0.037,0.029,0.029,0.039,0.026,
0.026,0.024,0.029,3.22e-3,0.024,0.026,0.027,0.029,0.026,0.032,
0.028,0.024,0.020,0.030,2.78e-3,5.47e-3,3.20e-3,4.09e-3,0.019,2.13e-3,
0.021,0.017,0.018,0.022,0.025,0.028,0.041,0.029,0.022,0.040,
0.043,0.064,0.028,0.040,0.029,4.57e-3,0.028,0.031,0.033,0.030,
0.030,0.052,0.060,0.038,0.028,0.035,0.040,0.029,0.022,0.022,
0.030,5.10e-3,0.059,0.035,0.028,0.032,0.021,0.031,0.044,0.038,
0.022,0.024,0.035,0.027,0.025,0.022,0.035,5.91e-3,0.028,0.034,
0.022,0.028,0.023,0.028,0.023,0.025,0.015,0.020,3.11e-3,3.51e-3,
3.03e-3,2.67e-3,0.023,3.41e-3,0.019,0.032,0.014,0.026,0.018,0.021,
0.024,0.020,0.013,0.022,0.030,0.026,0.018,0.025,0.023,2.76e-3,
0.024,0.028,0.023,0.025,0.023,0.040,0.046,0.019,0.016,0.021,
0.034,0.019,0.018,0.020,0.023,3.26e-3,0.018,0.018,0.020,0.020,
0.025,0.031,3.32e-3,2.99e-3,2.19e-3,2.47e-3,3.66e-3,3.61e-3,3.09e-3,2.51e-3,
3.22e-3,8.98e-4,3.43e-3,3.51e-3,2.82e-3,4.66e-3,3.41e-3,3.80e-3,0.019,0.015,
0.016,0.015,2.38e-3,1.82e-3,1.82e-3,2.13e-3,0.017,2.69e-3,0.014,0.014,
0.013,0.017,0.020,0.020,0.016,0.011,0.011,0.016,0.024,0.018,
0.016,0.021,0.021,2.97e-3,0.020,0.027,0.020,0.020,0.026,0.035,
0.055,0.021,0.018,0.033,0.027,0.015,0.014,0.017,0.024,2.88e-3,
0.013,0.017,0.030,0.022,0.020,0.041,0.039,0.027,0.022,0.029,
0.032,0.024,0.021,0.021,0.027,3.63e-3,0.019,0.025,0.025,0.029,
0.024,0.036,0.024,0.018,0.019,0.023,3.18e-3,2.05e-3,2.03e-3,2.69e-3,
0.018,1.78e-3,0.013,0.019,0.017,0.021,0.025,0.027,0.034,0.019,
0.017,0.032,0.026,0.017,0.017,0.025,0.029,2.53e-3,0.026,0.037,
0.039,0.034,0.041,0.080,0.059,0.038,0.029,0.040,0.038,0.032,
0.025,0.026,0.025,3.95e-3,0.017,0.020,0.027,0.029,0.020,0.029,
0.046,0.036,0.024,0.025,0.042,0.036,0.032,0.025,0.026,6.12e-3,
0.026,0.029,0.016,0.023,0.020,0.025,0.021,0.019,0.017,0.017,
2.32e-3,3.78e-3,3.61e-3,2.88e-3,0.014,2.74e-3,0.013,0.014,9.61e-3,0.016,
0.016,0.021,0.022,0.014,0.013,0.021,0.024,0.023,0.017,0.022,
0.018,2.72e-3,0.016,0.019,0.019,0.018,0.020,0.034,0.056,0.048,
0.023,0.028,0.044,0.058,0.029,0.026,0.028,4.95e-3,0.020,0.021,
0.022,0.028,0.016,0.026,0.049,0.057,0.026,0.027,0.050,0.037,
0.034,0.035,0.035,0.011,0.028,0.034,0.021,0.038,0.024,0.027,
0.022,0.033,0.021,0.020,3.24e-3,8.23e-3,5.37e-3,4.45e-3,0.024,7.79e-3,
0.021,0.029,0.012,0.035,0.024,0.024,0.021,0.017,0.012,0.022,
0.025,0.032,0.018,0.020,0.020,3.38e-3,0.022,0.023,0.017,0.021,
0.019,0.030,0.041,0.023,0.017,0.020,0.038,0.031,0.027,0.024,
0.026,3.57e-3,0.018,0.021,0.017,0.021,0.022,0.028,3.91e-3,5.41e-3,
3.76e-3,3.47e-3,6.25e-3,9.61e-3,9.07e-3,3.91e-3,3.93e-3,2.82e-3,6.83e-3,5.14e-3,
1.88e-3,5.24e-3,4.62e-3,4.24e-3,0.026,0.030,0.027,0.028,5.06e-3,7.62e-3,
6.62e-3,4.66e-3,0.025,6.94e-3,0.026,0.024,0.016,0.033,0.051,0.030,
0.018,0.012,0.014,0.016,0.026,0.029,0.028,0.026,0.031,4.20e-3,
0.030,0.031,0.016,0.022,0.036,0.036,0.038,0.021,0.016,0.026,
0.020,0.016,0.014,0.017,0.018,1.69e-3,0.011,0.013,0.020,0.017,
0.016,0.032,0.034,0.028,0.022,0.024,0.032,0.032,0.026,0.026,
0.021,3.55e-3,0.021,0.028,0.018,0.027,0.024,0.032,0.019,0.022,
0.021,0.021,2.26e-3,3.26e-3,2.76e-3,2.36e-3,0.018,2.80e-3,0.017,0.020,
0.016,0.022,0.040,0.029,0.022,0.015,0.016,0.023,0.024,0.019,
0.018,0.021,0.023,2.09e-3,0.023,0.032,0.028,0.031,0.044,0.060,
0.045,0.029,0.023,0.030,0.024,0.019,0.014,0.016,0.020,2.36e-3,
0.011,0.016,0.021,0.019,0.014,0.025,0.036,0.033,0.019,0.024,
0.028,0.030,0.023,0.022,0.034,6.31e-3,0.029,0.032,0.018,0.026,
0.019,0.025,0.024,0.027,0.021,0.024,3.95e-3,3.89e-3,5.08e-3,4.89e-3,
0.022,3.28e-3,0.017,0.019,0.013,0.021,0.024,0.020,0.024,0.016,
0.013,0.024,0.027,0.023,0.020,0.025,0.022,2.84e-3,0.018,0.024,
0.024,0.021,0.024,0.044,4.09e-3,3.74e-3,3.78e-3,2.95e-3,5.91e-3,4.03e-3,
3.38e-3,3.07e-3,2.82e-3,9.82e-4,3.18e-3,2.34e-3,2.47e-3,3.59e-3,2.05e-3,2.92e-3,
5.66e-3,6.12e-3,3.30e-3,2.59e-3,6.29e-3,9.23e-3,5.95e-3,3.55e-3,4.28e-3,3.74e-3,
6.10e-3,5.03e-3,2.30e-3,5.79e-3,3.80e-3,3.41e-3,3.11e-3,4.51e-3,3.61e-3,2.57e-3,
1.63e-3,2.38e-3,3.43e-3,1.15e-3,8.84e-3,3.43e-3,8.77e-3,6.46e-3,2.09e-3,5.74e-3,
5.97e-3,3.45e-3,2.17e-3,2.21e-3,1.52e-3,2.65e-3,6.98e-3,5.77e-3,4.83e-3,4.41e-3,
3.05e-3,1.32e-3,4.64e-3,4.76e-3,2.47e-3,3.86e-3,3.30e-3,5.47e-3,0.034,0.030,
0.017,0.017,0.025,0.028,0.025,0.020,0.027,6.54e-3,0.026,0.024,
0.017,0.029,0.024,0.031,3.26e-3,5.72e-3,2.67e-3,2.63e-3,3.99e-3,6.81e-3,
6.68e-3,3.09e-3,4.97e-3,3.74e-3,9.36e-3,5.33e-3,2.38e-3,5.62e-3,5.03e-3,3.30e-3,
0.024,0.040,0.024,0.020,4.76e-3,7.62e-3,8.02e-3,3.80e-3,0.027,7.98e-3,
0.022,0.023,0.012,0.028,0.026,0.023,0.023,0.015,0.012,0.017,
0.045,0.030,0.028,0.026,0.030,6.10e-3,0.034,0.038,0.018,0.024,
0.029,0.036,0.029,0.019,0.015,0.026,0.020,0.013,0.011,0.015,
0.023,2.26e-3,0.013,0.019,0.020,0.021,0.017,0.032,0.039,0.034,
0.019,0.029,0.039,0.034,0.026,0.024,0.038,5.74e-3,0.032,0.036,
0.024,0.039,0.027,0.031,0.024,0.032,0.023,0.028,7.10e-3,4.20e-3,
4.68e-3,3.34e-3,0.026,5.72e-3,0.025,0.029,0.019,0.043,0.032,0.040,
0.037,0.018,0.015,0.027,0.152,0.025,0.022,0.027,0.039,4.14e-3,
0.032,0.042,0.037,0.038,0.037,0.060,0.053,0.030,0.024,0.040,
0.036,0.022,0.018,0.039,0.031,2.80e-3,0.013,0.026,0.036,0.027,
0.019,0.040,0.035,0.024,0.016,0.023,0.024,0.019,0.015,0.024,
0.025,2.61e-3,0.016,0.025,0.019,0.019,0.015,0.025,0.023,0.018,
0.017,0.029,2.42e-3,2.21e-3,1.65e-3,3.74e-3,0.015,1.80e-3,0.013,0.019,
0.014,0.018,0.016,0.025,0.035,0.020,0.021,0.042,0.029,0.020,
0.020,0.041,0.032,2.11e-3,0.018,0.041,0.038,0.027,0.032,0.081,
0.061,0.043,0.025,0.038,0.048,0.033,0.025,0.028,0.032,4.70e-3,
0.023,0.030,0.035,0.035,0.026,0.039,0.051,0.043,0.023,0.030,
0.043,0.041,0.027,0.030,0.035,5.01e-3,0.027,0.037,0.029,0.040,
0.029,0.039,0.028,0.028,0.020,0.030,3.86e-3,3.09e-3,4.05e-3,3.82e-3,
0.032,3.49e-3,0.025,0.034,0.021,0.036,0.025,0.034,0.035,0.022,
0.020,0.035,0.040,0.030,0.029,0.045,0.033,3.45e-3,0.034,0.046,
0.034,0.036,0.038,0.064,0.037,0.021,0.016,0.023,0.032,0.024,
0.020,0.024,0.030,4.03e-3,0.022,0.029,0.022,0.025,0.032,0.043,
2.97e-3,2.57e-3,1.94e-3,2.82e-3,3.01e-3,4.12e-3,3.15e-3,3.05e-3,2.99e-3,9.40e-4,
3.97e-3,3.82e-3,2.42e-3,4.03e-3,4.66e-3,4.99e-3,0.020,0.024,0.017,0.023,
2.76e-3,2.86e-3,2.86e-3,3.93e-3,0.025,3.57e-3,0.024,0.030,0.016,0.027,
0.030,0.031,0.026,0.016,0.016,0.026,0.031,0.022,0.025,0.043,
0.053,5.33e-3,0.039,0.091,0.028,0.030,0.042,0.062,0.048,0.029,
0.022,0.038,0.028,0.022,0.019,0.025,0.026,3.34e-3,0.017,0.028,
0.033,0.027,0.026,0.056,0.034,0.024,0.017,0.026,0.025,0.021,
0.019,0.024,0.023,2.34e-3,0.022,0.031,0.026,0.028,0.027,0.047,
0.031,0.030,0.025,0.042,2.99e-3,2.99e-3,2.13e-3,4.53e-3,0.029,3.18e-3,
0.026,0.038,0.027,0.036,0.037,0.057,0.049,0.025,0.029,0.057,
0.055,0.034,0.034,0.057,0.054,3.99e-3,0.049,0.076,0.077,0.067,
0.083,0.121,0.816,0.492,0.415,0.806,0.465,0.333,0.289,0.391,
0.401,0.040,0.246,0.408,0.574,0.473,0.319,0.555,0.486,0.292,
0.202,0.307,0.313,0.192,0.191,0.240,0.252,0.021,0.178,0.229,
0.249,0.246,0.225,0.309,0.350,0.253,0.191,0.311,0.025,0.020,
0.017,0.039,0.206,0.019,0.161,0.293,0.202,0.206,0.216,0.304,
0.370,0.173,0.142,0.317,0.241,0.163,0.146,0.248,0.231,0.017,
0.152,0.240,0.317,0.162,0.233,0.457,0.698,0.410,0.293,0.491,
0.444,0.303,0.243,0.262,0.297,0.029,0.176,0.276,0.283,0.291,
0.170,0.322,0.528,0.364,0.240,0.296,0.354,0.203,0.231,0.218,
0.338,0.030,0.224,0.332,0.229,0.262,0.184,0.255,0.334,0.302,
0.215,0.322,0.030,0.031,0.025,0.056,0.349,0.049,0.317,1.040,
0.199,0.305,0.264,0.393,0.265,0.173,0.117,0.217,0.304,0.245,
0.169,0.270,0.230,0.021,0.182,0.359,0.249,0.209,0.229,0.436,
0.445,0.210,0.157,0.278,0.355,0.245,0.228,0.267,0.319,0.035,
0.166,0.227,0.277,0.267,0.236,0.363,0.042,0.032,0.021,0.031,
0.045,0.035,0.032,0.034,0.035,6.10e-3,0.028,0.036,0.042,0.069,
0.039,0.061,0.251,0.198,0.183,0.236,0.025,0.022,0.025,0.030,
0.261,0.042,0.202,0.252,0.157,0.236,0.245,0.250,0.208,0.144,
0.121,0.170,0.305,0.224,0.217,0.252,0.237,0.026,0.221,0.275,
0.270,0.217,0.280,0.371,0.472,0.183,0.158,0.314,0.224,0.141,
0.146,0.180,0.218,0.021,0.120,0.179,0.289,0.233,0.192,0.384,
0.375,0.244,0.176,0.247,0.269,0.188,0.183,0.204,0.239,0.021,
0.181,0.238,0.270,0.300,0.234,0.411,0.392,0.272,0.210,0.275,
0.032,0.021,0.024,0.031,0.293,0.025,0.224,0.326,0.241,0.289,
0.508,0.391,0.379,0.202,0.179,0.329,0.248,0.153,0.194,0.261,
0.369,0.036,0.287,0.445,0.570,0.420,0.502,0.861,0.047,0.034,
0.023,0.039,0.033,0.029,0.021,0.028,0.025,3.66e-3,0.012,0.019,
0.025,0.026,0.019,0.027,0.037,0.029,0.019,0.022,0.033,0.029,
0.030,0.025,0.021,4.64e-3,0.022,0.026,0.016,0.022,0.021,0.025,
0.021,0.017,0.014,0.017,2.69e-3,3.74e-3,3.03e-3,3.45e-3,0.014,2.92e-3,
0.014,0.019,0.010,0.018,0.021,0.020,0.023,0.012,0.011,0.017,
0.023,0.018,0.016,0.020,0.014,1.90e-3,0.013,0.018,0.021,0.015,
0.020,0.036,0.040,0.032,0.018,0.028,0.032,0.030,0.021,0.021,
0.027,4.16e-3,0.013,0.016,0.017,0.019,0.012,0.018,0.039,0.038,
0.020,0.022,0.032,0.024,0.027,0.021,0.025,6.12e-3,0.022,0.025,
0.016,0.024,0.018,0.020,0.018,0.026,0.015,0.019,3.68e-3,6.73e-3,
6.10e-3,4.05e-3,0.033,9.46e-3,0.030,0.068,0.013,0.029,0.023,0.027,
0.017,0.012,8.82e-3,0.014,0.020,0.021,0.014,0.018,0.016,2.26e-3,
0.015,0.026,0.014,0.014,0.016,0.027,0.028,0.018,0.013,0.016,
0.029,0.028,0.027,0.021,0.022,4.22e-3,0.018,0.017,0.014,0.020,
0.020,0.024,3.41e-3,4.49e-3,2.80e-3,2.74e-3,5.64e-3,7.08e-3,7.88e-3,4.18e-3,
3.59e-3,3.28e-3,6.71e-3,5.01e-3,2.09e-3,5.97e-3,4.91e-3,4.26e-3,0.018,0.021,
0.020,0.020,3.63e-3,6.08e-3,7.56e-3,3.86e-3,0.034,0.017,0.032,0.025,
0.014,0.039,0.050,0.027,0.015,0.012,0.011,0.014,0.022,0.024,
0.025,0.023,0.021,5.08e-3,0.025,0.025,0.016,0.019,0.028,0.031,
0.040,0.029,0.020,0.030,0.023,0.018,0.016,0.018,0.018,2.24e-3,
0.012,0.016,0.023,0.024,0.029,0.039,0.042,0.033,0.024,0.034,
0.044,0.037,0.032,0.033,0.026,4.49e-3,0.025,0.030,0.027,0.038,
0.038,0.047,0.032,0.025,0.026,0.025,3.53e-3,3.91e-3,6.37e-3,3.78e-3,
0.024,5.52e-3,0.033,0.031,0.033,0.036,0.178,0.055,0.028,0.018,
0.017,0.026,0.024,0.018,0.021,0.025,0.028,3.45e-3,0.027,0.044,
0.041,0.037,0.061,0.080,0.476,0.433,0.290,0.460,0.312,0.249,
0.170,0.248,0.278,0.026,0.170,0.231,0.234,0.194,0.147,0.255,
0.462,0.349,0.211,0.267,0.366,0.286,0.263,0.243,0.415,0.046,
0.324,0.421,0.194,0.271,0.185,0.261,0.270,0.292,0.188,0.243,
0.034,0.037,0.029,0.044,0.265,0.033,0.263,0.308,0.191,0.288,
0.232,0.312,0.239,0.154,0.112,0.210,0.237,0.203,0.166,0.225,
0.257,0.026,0.218,0.358,0.289,0.219,0.266,0.493,0.035,0.035,
0.018,0.027,0.034,0.035,0.021,0.037,0.022,4.49e-3,0.019,0.023,
0.015,0.021,0.014,0.023,0.035,0.033,0.018,0.021,0.039,0.038,
0.033,0.027,0.031,8.71e-3,0.045,0.036,0.016,0.023,0.017,0.019,
0.027,0.031,0.018,0.021,4.51e-3,8.36e-3,7.33e-3,5.45e-3,0.029,9.73e-3,
0.038,0.060,0.016,0.033,0.029,0.030,0.025,0.018,0.011,0.023,
0.033,0.033,0.023,0.033,0.026,4.64e-3,0.025,0.062,0.025,0.021,
0.023,0.055,0.525,0.265,0.204,0.181,0.296,0.280,0.263,0.241,
0.276,0.043,0.337,0.269,0.169,0.201,0.257,0.289,0.032,0.038,
0.028,0.022,0.027,0.037,0.030,0.020,0.037,9.71e-3,0.053,0.040,
0.018,0.036,0.034,0.028,0.331,0.241,0.224,0.209,0.034,0.026,
0.038,0.025,0.204,0.031,0.074,0.101,0.117,0.143,0.192,0.203,
0.188,0.130,0.131,0.126,0.211,0.184,0.198,0.171,0.230,0.028,
0.305,0.282,0.157,0.174,0.264,0.321,0.322,0.186,0.137,0.226,
0.184,0.135,0.104,0.128,0.178,0.017,0.162,0.173,0.155,0.142,
0.144,0.221,0.346,0.291,0.198,0.259,0.284,0.277,0.200,0.191,
0.246,0.030,0.290,0.282,0.184,0.262,0.226,0.245,0.271,0.258,
0.206,0.267,0.027,0.029,0.025,0.027,0.293,0.034,0.341,0.351,
0.198,0.332,0.327,0.356,0.246,0.162,0.140,0.223,0.257,0.190,
0.170,0.199,0.310,0.029,0.385,0.416,0.311,0.306,0.373,0.500,
0.549,0.280,0.202,0.397,0.266,0.186,0.150,0.224,0.228,0.022,
0.135,0.205,0.267,0.210,0.162,0.316,0.395,0.207,0.138,0.207,
0.224,0.148,0.132,0.185,0.196,0.015,0.136,0.209,0.135,0.138,
0.116,0.192,0.248,0.197,0.124,0.212,0.021,0.017,0.013,0.030,
0.179,0.016,0.137,0.224,0.148,0.186,0.162,0.261,0.278,0.154,
0.134,0.243,0.199,0.143,0.124,0.211,0.196,0.015,0.126,0.245,
0.261,0.183,0.210,0.460,0.503,0.328,0.196,0.340,0.346,0.282,
0.200,0.260,0.238,0.023,0.190,0.240,0.224,0.231,0.144,0.292,
0.441,0.322,0.201,0.269,0.339,0.263,0.243,0.246,0.274,0.024,
0.225,0.286,0.170,0.202,0.146,0.222,0.254,0.262,0.149,0.219,
0.021,0.028,0.018,0.029,0.276,0.031,0.240,0.426,0.177,0.295,
0.226,0.319,0.265,0.173,0.127,0.224,0.272,0.238,0.185,0.287,
0.228,0.019,0.200,0.402,0.234,0.210,0.219,0.418,0.479,0.251,
0.189,0.248,0.311,0.243,0.249,0.279,0.336,0.036,0.246,0.288,
0.243,0.240,0.377,0.410,0.030,0.032,0.021,0.023,0.027,0.035,
0.027,0.027,0.024,4.76e-3,0.028,0.030,0.021,0.034,0.032,0.032,
0.306,0.304,0.212,0.268,0.026,0.024,0.025,0.031,0.377,0.049,
0.275,0.344,0.203,0.328,0.364,0.369,0.249,0.181,0.163,0.219,
0.305,0.252,0.265,0.326,0.296,0.029,0.344,0.438,0.252,0.253,
0.383,0.486,0.468,0.221,0.187,0.310,0.234,0.169,0.154,0.180,
0.246,0.025,0.168,0.219,0.307,0.209,0.241,0.375,0.354,0.226,
0.169,0.247,0.250,0.205,0.187,0.212,0.211,0.016,0.226,0.275,
0.216,0.208,0.249,0.308,0.362,0.329,0.238,0.353,0.026,0.025,
0.020,0.032,0.385,0.033,0.354,0.541,0.312,0.402,0.412,0.508,
0.455,0.251,0.226,0.431,0.362,0.288,0.271,0.376,0.430,0.033,
0.418,0.614,0.538,0.425,0.592,0.814,1.000,0.457,0.438,0.970,
0.406,0.236,0.215,0.352,0.399,0.030,0.173,0.313,0.616,0.413,
0.267,0.561,0.466,0.237,0.183,0.286,0.243,0.133,0.130,0.172,
0.243,0.015,0.144,0.182,0.260,0.220,0.164,0.265,0.320,0.212,
0.179,0.302,0.024,0.017,0.016,0.035,0.184,0.013,0.119,0.185,
0.176,0.173,0.173,0.281,0.455,0.204,0.201,0.436,0.291,0.187,
0.162,0.282,0.250,0.018,0.155,0.263,0.364,0.225,0.271,0.616,
0.586,0.309,0.219,0.390,0.287,0.171,0.133,0.175,0.228,0.018,
0.110,0.181,0.261,0.196,0.127,0.273,0.338,0.186,0.132,0.186,
0.194,0.111,0.102,0.120,0.199,0.011,0.110,0.158,0.186,0.147,
0.113,0.189,0.228,0.170,0.135,0.193,0.013,0.013,8.34e-3,0.018,
0.221,0.015,0.116,0.298,0.165,0.170,0.144,0.234,0.227,0.138,
0.099,0.190,0.186,0.152,0.091,0.159,0.182,0.011,0.115,0.209,
0.209,0.156,0.173,0.355,0.599,0.203,0.168,0.272,0.303,0.149,
0.142,0.205,0.244,0.023,0.095,0.175,0.285,0.213,0.164,0.360,
0.036,0.018,0.013,0.022,0.022,0.013,0.014,0.017,0.020,1.86e-3,
0.011,0.018,0.034,0.034,0.019,0.037,0.293,0.164,0.179,0.231,
0.018,0.011,0.013,0.020,0.202,0.017,0.113,0.181,0.178,0.179,
0.209,0.271,0.301,0.133,0.138,0.207,0.227,0.147,0.145,0.210,
0.214,0.017,0.155,0.277,0.264,0.201,0.263,0.452,0.638,0.215,
0.181,0.401,0.270,0.133,0.137,0.191,0.259,0.021,0.126,0.196,
0.401,0.251,0.193,0.446,0.362,0.196,0.157,0.236,0.195,0.122,
0.145,0.153,0.204,0.013,0.127,0.187,0.276,0.257,0.173,0.302,
0.292,0.200,0.177,0.254,0.018,0.012,0.017,0.020,0.201,0.013,
0.132,0.197,0.241,0.196,0.264,0.315,0.429,0.213,0.195,0.390,
0.238,0.152,0.171,0.242,0.310,0.020,0.216,0.382,0.491,0.353,
0.453,0.948,0.891,0.447,0.355,0.686,0.432,0.297,0.227,0.319,
0.328,0.029,0.161,0.278,0.452,0.362,0.243,0.486,0.537,0.286,
0.229,0.321,0.315,0.192,0.227,0.234,0.264,0.020,0.229,0.268,
0.218,0.218,0.200,0.311,0.337,0.214,0.196,0.277,0.022,0.019,
0.017,0.028,0.199,0.018,0.149,0.230,0.153,0.191,0.214,0.332,
0.407,0.175,0.176,0.303,0.296,0.210,0.189,0.266,0.208,0.016,
0.142,0.263,0.288,0.201,0.260,0.542,0.595,0.357,0.211,0.374,
0.339,0.248,0.171,0.215,0.262,0.021,0.119,0.186,0.262,0.219,
0.138,0.292,0.394,0.270,0.173,0.234,0.289,0.161,0.162,0.179,
0.251,0.022,0.169,0.226,0.192,0.208,0.160,0.235,0.247,0.227,
0.162,0.225,0.016,0.018,0.012,0.018,0.266,0.025,0.172,0.282,
0.175,0.242,0.200,0.353,0.208,0.142,0.099,0.177,0.201,0.174,
0.110,0.163,0.175,0.014,0.132,0.202,0.183,0.166,0.185,0.353,
0.454,0.236,0.163,0.255,0.320,0.242,0.213,0.247,0.253,0.030,
0.130,0.197,0.236,0.226,0.200,0.378,0.025,0.020,0.012,0.020,
0.023,0.024,0.021,0.021,0.017,3.32e-3,0.016,0.019,0.021,0.031,
0.021,0.032,0.253,0.222,0.230,0.284,0.019,0.020,0.021,0.026,
0.245,0.038,0.179,0.252,0.204,0.300,0.335,0.393,0.232,0.155,
0.150,0.231,0.248,0.214,0.214,0.277,0.252,0.020,0.211,0.324,
0.250,0.240,0.335,0.515,0.571,0.267,0.211,0.373,0.252,0.176,
0.166,0.216,0.245,0.021,0.139,0.218,0.303,0.248,0.236,0.439,
0.436,0.275,0.215,0.311,0.278,0.223,0.223,0.254,0.250,0.021,
0.218,0.294,0.282,0.348,0.279,0.409,0.269,0.223,0.259,0.304,
0.019,0.018,0.039,0.026,0.213,0.019,0.216,0.284,0.230,0.285,
0.626,0.488,0.330,0.204,0.206,0.329,0.265,0.205,0.232,0.271,
0.296,0.022,0.257,0.404,0.414,0.345,0.497,0.798,1.290,0.408,
0.429,0.534,0.314,0.235,0.153,0.232,0.321,0.024,0.160,0.241,
0.381,0.233,0.174,0.357,0.506,0.315,0.199,0.286,0.308,0.220,
0.175,0.202,0.333,0.028,0.264,0.290,0.244,0.263,0.192,0.320,
0.330,0.322,0.207,0.300,0.038,0.028,0.021,0.042,0.239,0.024,
0.162,0.243,0.204,0.276,0.313,0.426,0.324,0.201,0.156,0.293,
0.309,0.212,0.161,0.266,0.272,0.025,0.193,0.378,0.340,0.258,
0.328,0.666,0.065,0.030,0.077,0.038,0.025,0.021,0.017,0.019,
0.020,2.40e-3,0.014,0.017,0.021,0.019,0.017,0.026,0.029,0.024,
0.016,0.017,0.032,0.029,0.016,0.019,0.024,3.59e-3,0.025,0.026,
0.017,0.023,0.016,0.021,0.017,0.021,0.013,0.017,3.36e-3,3.22e-3,
2.61e-3,2.51e-3,0.022,3.63e-3,0.017,0.028,0.018,0.026,0.042,0.032,
0.025,0.017,0.013,0.021,0.035,0.027,0.018,0.027,0.020,2.49e-3,
0.016,0.038,0.025,0.021,0.027,0.046,0.527,0.276,0.195,0.230,
0.310,0.266,0.236,0.230,0.270,0.038,0.205,0.246,0.227,0.244,
0.243,0.348,0.029,0.024,0.013,0.017,0.021,0.021,0.016,0.015,
0.022,3.84e-3,0.029,0.022,0.024,0.033,0.026,0.028,0.307,0.265,
0.246,0.257,0.026,0.025,0.026,0.025,0.307,0.036,0.155,0.253,
0.194,0.260,0.304,0.326,0.243,0.163,0.150,0.205,0.263,0.240,
0.226,0.247,0.263,0.027,0.291,0.384,0.243,0.250,0.328,0.482,
0.573,0.259,0.180,0.318,0.244,0.176,0.151,0.189,0.392,0.031,
0.226,0.351,0.294,0.221,0.186,0.390,0.442,0.323,0.196,0.306,
0.285,0.261,0.197,0.209,0.299,0.024,0.288,0.343,0.295,0.344,
0.272,0.359,0.342,0.326,0.260,0.351,0.025,0.026,0.025,0.034,
0.343,0.029,0.291,0.407,0.306,0.406,0.638,0.541,0.415,0.217,
0.213,0.312,0.284,0.230,0.236,0.254,0.404,0.030,0.389,0.534,
0.455,0.405,0.517,0.757,0.941,0.375,0.276,0.551,0.303,0.186,
0.145,0.249,0.309,0.026,0.155,0.262,0.390,0.270,0.196,0.473,
0.428,0.216,0.137,0.223,0.219,0.131,0.109,0.165,0.230,0.014,
0.128,0.221,0.181,0.154,0.135,0.259,0.319,0.245,0.170,0.334,
0.025,0.023,0.016,0.044,0.203,0.017,0.119,0.229,0.193,0.215,
0.184,0.303,0.385,0.187,0.176,0.365,0.244,0.149,0.143,0.256,
0.242,0.018,0.155,0.312,0.344,0.232,0.307,0.749,0.512,0.264,
0.268,0.336,0.256,0.168,0.133,0.193,0.204,0.015,0.123,0.201,
0.225,0.188,0.133,0.315,0.334,0.209,0.170,0.215,0.240,0.163,
0.130,0.166,0.226,0.015,0.151,0.228,0.176,0.168,0.137,0.235,
0.221,0.177,0.116,0.208,0.014,0.013,9.80e-3,0.016,0.215,0.017,
0.142,0.263,0.191,0.236,0.212,0.320,0.247,0.149,0.124,0.234,
0.240,0.163,0.138,0.210,0.218,0.016,0.145,0.297,0.241,0.190,
0.271,0.469,0.567,0.266,0.221,0.349,0.357,0.242,0.207,0.314,
0.392,0.036,0.183,0.293,0.348,0.299,0.315,0.523,0.032,0.020,
0.014,0.024,0.022,0.020,0.016,0.022,0.022,2.44e-3,0.015,0.022,
0.029,0.033,0.022,0.039,0.354,0.308,0.233,0.327,0.022,0.020,
0.018,0.029,0.362,0.030,0.247,0.372,0.280,0.342,0.371,0.524,
0.357,0.239,0.200,0.315,0.346,0.265,0.256,0.376,0.378,0.027,
0.306,0.530,0.338,0.302,0.383,0.686,0.876,0.316,0.241,0.486,
0.307,0.210,0.179,0.267,0.367,0.030,0.196,0.332,0.521,0.336,
0.309,0.688,0.486,0.275,0.214,0.327,0.323,0.246,0.189,0.261,
0.333,0.019,0.254,0.360,0.371,0.350,0.276,0.483,0.465,0.372,
0.282,0.481,0.028,0.024,0.018,0.033,0.441,0.028,0.331,0.553,
0.427,0.475,0.520,0.808,0.770,0.318,0.299,0.635,0.489,0.330,
0.296,0.481,0.612,0.035,0.476,0.825,0.821,0.524,0.730,1.260,
2.830,1.160,0.913,2.330,0.883,0.484,0.437,0.747,0.945,0.069,
0.337,0.687,1.740,1.080,0.583,1.440,0.856,0.410,0.307,0.487,
0.445,0.229,0.203,0.261,0.415,0.021,0.189,0.299,0.523,0.334,
0.244,0.492,0.694,0.353,0.280,0.589,0.044,0.025,0.020,0.058,
0.306,0.020,0.135,0.247,0.366,0.300,0.235,0.461,1.200,0.441,
0.437,1.090,0.779,0.376,0.364,0.736,0.477,0.029,0.233,0.445,
0.861,0.439,0.434,1.110,0.923,0.359,0.257,0.461,0.361,0.203,
0.157,0.243,0.308,0.023,0.117,0.216,0.354,0.277,0.149,0.352,
0.436,0.210,0.135,0.214,0.207,0.106,0.103,0.126,0.207,0.010,
0.097,0.153,0.207,0.137,0.109,0.195,0.332,0.201,0.136,0.248,
0.019,0.011,8.69e-3,0.018,0.210,0.012,0.085,0.156,0.178,0.166,
0.107,0.209,0.421,0.209,0.164,0.337,0.352,0.194,0.152,0.268,
0.253,0.014,0.118,0.220,0.293,0.204,0.201,0.428,0.636,0.245,
0.232,0.389,0.315,0.167,0.171,0.252,0.305,0.027,0.127,0.227,
0.384,0.263,0.244,0.538,0.037,0.021,0.014,0.027,0.022,0.016,
0.012,0.020,0.022,1.59e-3,0.010,0.021,0.040,0.033,0.021,0.048,
0.248,0.154,0.137,0.223,0.017,8.71e-3,7.48e-3,0.018,0.179,0.011,
0.080,0.136,0.163,0.140,0.141,0.230,0.268,0.148,0.139,0.268,
0.266,0.154,0.140,0.240,0.272,0.018,0.144,0.261,0.275,0.215,
0.233,0.538,1.010,0.345,0.317,0.691,0.370,0.189,0.221,0.295,
0.421,0.030,0.161,0.301,0.668,0.377,0.336,0.825,0.542,0.272,
0.214,0.335,0.272,0.169,0.152,0.209,0.284,0.015,0.147,0.250,
0.383,0.277,0.222,0.441,0.321,0.214,0.189,0.317,0.021,0.012,
0.012,0.025,0.236,0.014,0.126,0.259,0.254,0.239,0.208,0.371,
0.675,0.269,0.284,0.604,0.318,0.201,0.196,0.329,0.443,0.024,
0.230,0.454,0.696,0.450,0.487,1.270,0.956,0.417,0.320,0.644,
0.364,0.202,0.173,0.271,0.306,0.021,0.111,0.224,0.416,0.302,
0.200,0.442,0.435,0.207,0.150,0.254,0.212,0.124,0.110,0.146,
0.185,0.010,0.093,0.157,0.175,0.138,0.116,0.229,0.234,0.162,
0.116,0.219,0.015,0.011,7.94e-3,0.020,0.123,9.44e-3,0.065,0.103,
0.134,0.134,0.105,0.205,0.311,0.141,0.139,0.310,0.224,0.131,
0.111,0.200,0.165,0.011,0.089,0.154,0.233,0.149,0.172,0.423,
0.504,0.258,0.135,0.272,0.224,0.142,0.094,0.133,0.167,0.012,
0.063,0.120,0.199,0.167,0.085,0.215,0.270,0.152,0.084,0.136,
0.140,0.064,0.065,0.084,0.119,7.54e-3,0.062,0.098,0.123,0.102,
0.071,0.139,0.200,0.139,0.088,0.139,0.012,7.67e-3,4.62e-3,8.77e-3,
0.127,9.21e-3,0.053,0.091,0.113,0.122,0.080,0.152,0.215,0.113,
0.085,0.175,0.149,0.101,0.072,0.111,0.140,8.00e-3,0.063,0.117,
0.151,0.117,0.101,0.247,0.370,0.174,0.127,0.225,0.200,0.117,
0.113,0.155,0.183,0.015,0.088,0.134,0.205,0.150,0.133,0.269,
0.017,0.014,8.13e-3,0.016,9.63e-3,9.57e-3,7.94e-3,0.010,0.010,1.42e-3,
7.40e-3,0.011,0.015,0.014,0.010,0.020,0.180,0.156,0.111,0.167,
0.010,0.015,6.20e-3,0.012,0.105,7.88e-3,0.065,0.091,0.103,0.110,
0.107,0.154,0.174,0.111,0.101,0.184,0.157,0.120,0.103,0.151,
0.154,0.011,0.159,0.177,0.153,0.125,0.165,0.302,0.379,0.167,
0.144,0.265,0.196,0.102,0.099,0.137,0.161,0.010,0.066,0.121,
0.232,0.145,0.134,0.283,0.257,0.154,0.116,0.185,0.139,0.107,
0.105,0.135,0.118,7.08e-3,0.083,0.130,0.156,0.129,0.112,0.203,
0.169,0.117,0.108,0.188,9.86e-3,8.13e-3,6.29e-3,0.012,0.137,0.011,
0.066,0.118,0.141,0.147,0.124,0.216,0.243,0.110,0.129,0.253,
0.167,0.110,0.103,0.172,0.206,0.012,0.125,0.228,0.285,0.221,
0.256,0.544,0.664,0.339,0.234,0.514,0.238,0.158,0.112,0.202,
0.254,0.021,0.114,0.228,0.387,0.259,0.181,0.355,0.426,0.237,
0.151,0.293,0.191,0.124,0.142,0.157,0.230,0.016,0.122,0.174,
0.231,0.199,0.151,0.277,0.270,0.225,0.152,0.304,0.022,0.020,
0.012,0.033,0.129,0.012,0.064,0.116,0.144,0.198,0.127,0.211,
0.419,0.211,0.184,0.435,0.271,0.204,0.149,0.280,0.211,0.017,
0.114,0.223,0.362,0.248,0.268,0.698,0.037,0.027,0.015,0.028,
0.021,0.016,9.02e-3,0.016,0.018,1.73e-3,8.34e-3,0.016,0.024,0.023,
0.013,0.027,0.029,0.020,9.53e-3,0.018,0.017,0.013,9.13e-3,0.012,
0.019,1.50e-3,0.010,0.015,0.021,0.018,0.014,0.023,0.018,0.018,
0.010,0.022,1.46e-3,1.48e-3,8.36e-4,1.84e-3,0.012,1.42e-3,6.64e-3,0.011,
0.016,0.018,0.011,0.020,0.041,0.025,0.018,0.046,0.034,0.030,
0.018,0.035,0.019,1.65e-3,0.012,0.025,0.034,0.029,0.024,0.059,
0.332,0.172,0.112,0.176,0.161,0.112,0.100,0.135,0.232,0.020,
0.102,0.150,0.203,0.159,0.132,0.238,0.021,0.015,8.21e-3,0.014,
9.48e-3,0.011,6.75e-3,8.86e-3,0.014,1.61e-3,8.21e-3,0.011,0.020,0.019,
0.014,0.019,0.170,0.142,0.094,0.137,0.011,8.56e-3,7.65e-3,0.012,
0.119,0.010,0.057,0.081,0.100,0.114,0.097,0.138,0.194,0.109,
0.102,0.177,0.163,0.125,0.101,0.156,0.169,0.015,0.127,0.178,
0.174,0.152,0.162,0.303,0.359,0.167,0.120,0.253,0.171,0.105,
0.101,0.130,0.199,0.016,0.099,0.169,0.271,0.183,0.166,0.341,
0.330,0.215,0.115,0.212,0.168,0.152,0.100,0.129,0.183,0.013,
0.108,0.165,0.229,0.208,0.141,0.243,0.227,0.174,0.109,0.229,
0.014,0.013,7.25e-3,0.015,0.150,0.011,0.090,0.154,0.167,0.191,
0.153,0.250,0.338,0.168,0.156,0.307,0.210,0.152,0.122,0.204,
0.248,0.017,0.169,0.291,0.361,0.278,0.294,0.643,0.997,0.408,
0.333,0.735,0.315,0.180,0.162,0.237,0.332,0.023,0.148,0.262,
0.593,0.322,0.256,0.614,0.399,0.175,0.140,0.261,0.184,0.096,
0.103,0.140,0.261,0.011,0.112,0.182,0.237,0.145,0.136,0.283,
0.332,0.199,0.163,0.361,0.021,0.015,0.012,0.033,0.193,0.012,
0.097,0.190,0.204,0.181,0.148,0.316,0.620,0.249,0.279,0.750,
0.328,0.178,0.194,0.362,0.303,0.017,0.174,0.316,0.509,0.300,
0.338,0.923,0.527,0.251,0.183,0.334,0.229,0.145,0.107,0.160,
0.223,0.015,0.102,0.186,0.265,0.203,0.126,0.296,0.285,0.161,
0.087,0.156,0.156,0.100,0.071,0.106,0.170,9.11e-3,0.087,0.142,
0.186,0.131,0.094,0.186,0.240,0.185,0.100,0.233,0.012,0.013,
6.33e-3,0.015,0.170,0.011,0.084,0.145,0.178,0.164,0.114,0.229,
0.371,0.176,0.154,0.367,0.248,0.166,0.140,0.266,0.223,0.013,
0.119,0.236,0.300,0.227,0.197,0.482,0.394,0.177,0.137,0.252,
0.246,0.142,0.119,0.196,0.246,0.021,0.124,0.200,0.237,0.177,
0.194,0.362,0.021,0.014,8.38e-3,0.017,0.012,0.010,6.87e-3,0.012,
0.014,1.44e-3,9.80e-3,0.014,0.019,0.018,0.014,0.024,0.208,0.150,
0.116,0.208,0.013,7.75e-3,7.52e-3,0.016,0.176,0.012,0.120,0.145,
0.161,0.151,0.157,0.247,0.268,0.141,0.147,0.268,0.248,0.153,
0.148,0.273,0.302,0.017,0.195,0.300,0.277,0.211,0.274,0.517,
0.736,0.292,0.237,0.513,0.291,0.171,0.164,0.239,0.330,0.024,
0.160,0.306,0.511,0.305,0.290,0.856,0.402,0.249,0.144,0.272,
0.195,0.136,0.116,0.182,0.231,0.014,0.143,0.237,0.294,0.232,
0.178,0.378,0.375,0.284,0.212,0.453,0.020,0.018,0.011,0.029,
0.298,0.017,0.182,0.309,0.336,0.299,0.274,0.502,0.816,0.336,
0.347,0.844,0.438,0.319,0.282,0.511,0.649,0.028,0.397,0.717,
1.130,0.677,0.754,1.600,0.799,0.433,0.440,0.705,0.409,0.220,
0.206,0.293,0.328,0.028,0.155,0.264,0.574,0.398,0.237,0.503,
0.412,0.250,0.189,0.250,0.246,0.140,0.127,0.147,0.185,0.012,
0.122,0.148,0.206,0.160,0.136,0.232,0.252,0.179,0.132,0.234,
0.017,0.011,0.011,0.025,0.135,0.011,0.087,0.117,0.155,0.148,
0.124,0.216,0.387,0.216,0.166,0.369,0.289,0.158,0.148,0.277,
0.193,0.014,0.121,0.194,0.303,0.205,0.204,0.463,0.496,0.254,
0.203,0.282,0.233,0.140,0.112,0.148,0.180,0.018,0.128,0.153,
0.211,0.211,0.110,0.235,0.280,0.155,0.123,0.155,0.158,0.097,
0.092,0.109,0.148,0.010,0.147,0.137,0.136,0.116,0.106,0.159,
0.169,0.127,0.097,0.139,0.011,7.92e-3,6.29e-3,0.011,0.143,9.30e-3,
0.088,0.107,0.109,0.121,0.096,0.131,0.196,0.123,0.086,0.163,
0.164,0.107,0.085,0.138,0.141,9.09e-3,0.085,0.133,0.152,0.134,
0.120,0.262,0.309,0.135,0.104,0.191,0.177,0.097,0.092,0.145,
0.148,0.015,0.067,0.116,0.177,0.134,0.112,0.261,0.016,0.011,
7.73e-3,0.013,0.012,8.92e-3,7.46e-3,0.011,0.010,9.19e-4,6.81e-3,9.94e-3,
0.015,0.017,0.012,0.021,0.136,0.082,0.084,0.111,0.010,5.24e-3,
6.18e-3,0.011,0.096,7.71e-3,0.053,0.079,0.095,0.085,0.091,0.132,
0.136,0.083,0.076,0.141,0.140,0.092,0.080,0.134,0.129,9.23e-3,
0.082,0.147,0.144,0.120,0.141,0.282,0.395,0.155,0.121,0.246,
0.170,0.090,0.082,0.135,0.175,0.017,0.070,0.127,0.257,0.162,
0.122,0.303,0.256,0.143,0.109,0.170,0.157,0.105,0.087,0.125,
0.135,9.90e-3,0.082,0.130,0.152,0.138,0.118,0.203,0.146,0.102,
0.089,0.154,0.010,6.96e-3,5.79e-3,0.013,0.100,6.48e-3,0.057,0.105,
0.112,0.108,0.098,0.169,0.235,0.117,0.118,0.249,0.161,0.103,
0.095,0.167,0.181,0.012,0.121,0.216,0.279,0.222,0.237,0.567,
0.544,0.280,0.237,0.386,0.286,0.173,0.133,0.183,0.168,0.014,
0.076,0.144,0.237,0.188,0.129,0.267,0.303,0.185,0.130,0.181,
0.195,0.132,0.108,0.136,0.121,0.011,0.080,0.114,0.108,0.112,
0.093,0.156,0.141,0.116,0.082,0.137,9.23e-3,8.90e-3,6.46e-3,0.014,
0.079,6.37e-3,0.046,0.069,0.077,0.084,0.068,0.141,0.195,0.097,
0.083,0.214,0.140,0.100,0.079,0.143,0.099,6.39e-3,0.069,0.103,
0.151,0.108,0.114,0.264,0.342,0.206,0.105,0.186,0.195,0.179,
0.085,0.113,0.119,0.010,0.056,0.087,0.131,0.122,0.068,0.156,
0.245,0.162,0.093,0.143,0.178,0.095,0.084,0.112,0.108,0.011,
0.068,0.101,0.103,0.121,0.071,0.128,0.132,0.112,0.060,0.104,
9.36e-3,9.53e-3,4.30e-3,7.96e-3,0.085,8.13e-3,0.048,0.076,0.065,0.092,
0.066,0.111,0.179,0.099,0.060,0.140,0.117,0.108,0.055,0.089,
0.104,6.75e-3,0.055,0.090,0.101,0.099,0.077,0.179,0.246,0.127,
0.087,0.166,0.161,0.111,0.094,0.157,0.127,0.011,0.058,0.092,
0.131,0.106,0.099,0.196,0.013,0.010,7.17e-3,0.012,8.42e-3,0.013,
7.44e-3,0.011,7.12e-3,1.44e-3,5.35e-3,7.23e-3,9.09e-3,0.011,7.98e-3,0.013,
0.170,0.112,0.088,0.122,9.84e-3,8.38e-3,7.21e-3,0.011,0.086,7.02e-3,
0.059,0.076,0.075,0.089,0.103,0.130,0.125,0.073,0.074,0.133,
0.129,0.103,0.091,0.126,0.115,7.52e-3,0.097,0.129,0.119,0.102,
0.143,0.230,0.236,0.116,0.087,0.161,0.126,0.079,0.066,0.101,
0.099,7.50e-3,0.053,0.076,0.142,0.097,0.097,0.181,0.174,0.118,
0.088,0.135,0.116,0.109,0.085,0.118,0.088,7.56e-3,0.066,0.096,
0.092,0.099,0.092,0.148,0.114,0.097,0.077,0.117,7.42e-3,5.54e-3,
6.23e-3,7.90e-3,0.076,5.54e-3,0.051,0.080,0.078,0.090,0.095,0.135,
0.167,0.084,0.079,0.155,0.141,0.098,0.084,0.124,0.119,8.11e-3,
0.098,0.149,0.180,0.164,0.174,0.333,0.356,0.203,0.161,0.287,
0.157,0.099,0.074,0.121,0.152,0.012,0.075,0.134,0.192,0.142,
0.106,0.206,0.235,0.148,0.090,0.159,0.136,0.103,0.081,0.095,
0.162,0.013,0.117,0.121,0.132,0.144,0.084,0.157,0.144,0.127,
0.082,0.153,0.012,0.010,8.29e-3,0.019,0.092,7.56e-3,0.046,0.071,
0.075,0.103,0.090,0.121,0.208,0.106,0.082,0.206,0.138,0.095,
0.084,0.158,0.116,9.78e-3,0.079,0.133,0.178,0.139,0.148,0.377,
0.016,0.011,5.95e-3,0.012,0.011,8.84e-3,5.31e-3,6.62e-3,7.08e-3,1.13e-3,
5.03e-3,7.25e-3,0.012,9.82e-3,6.46e-3,0.013,0.014,9.51e-3,5.33e-3,7.79e-3,
0.015,0.017,6.20e-3,8.38e-3,0.016,1.75e-3,7.94e-3,8.38e-3,0.010,0.011,
5.79e-3,0.011,7.50e-3,7.65e-3,4.03e-3,7.08e-3,8.36e-4,1.07e-3,7.73e-4,9.82e-4,
7.75e-3,1.07e-3,4.95e-3,5.97e-3,6.94e-3,7.75e-3,6.56e-3,0.011,0.015,8.67e-3,
5.74e-3,0.017,0.014,0.011,7.83e-3,0.014,8.15e-3,1.23e-3,5.91e-3,0.012,
0.012,0.011,9.28e-3,0.023,0.233,0.145,0.093,0.137,0.133,0.114,
0.080,0.109,0.145,0.016,0.070,0.109,0.120,0.118,0.095,0.201,
0.013,0.011,6.12e-3,8.96e-3,8.46e-3,9.07e-3,6.06e-3,7.02e-3,9.00e-3,1.34e-3,
7.54e-3,9.11e-3,0.011,0.014,8.31e-3,0.014,0.140,0.120,0.070,0.100,
9.30e-3,8.79e-3,6.58e-3,9.69e-3,0.096,8.96e-3,0.050,0.071,0.069,0.091,
0.082,0.113,0.133,0.078,0.069,0.115,0.125,0.104,0.081,0.122,
0.132,0.011,0.099,0.148,0.129,0.119,0.141,0.257,0.224,0.122,
0.082,0.166,0.123,0.077,0.060,0.084,0.126,0.012,0.063,0.108,
0.166,0.130,0.084,0.238,0.225,0.150,0.088,0.139,0.134,0.116,
0.080,0.101,0.143,0.013,0.096,0.143,0.149,0.178,0.100,0.192,
0.152,0.122,0.086,0.144,0.011,8.23e-3,6.16e-3,0.011,0.115,8.90e-3,
0.072,0.121,0.117,0.144,0.109,0.186,0.192,0.108,0.094,0.200,
0.154,0.098,0.088,0.139,0.177,0.013,0.142,0.226,0.264,0.227,
0.231,0.470,0.415,0.188,0.162,0.319,0.170,0.096,0.084,0.147,
0.160,0.012,0.073,0.143,0.244,0.144,0.114,0.270,0.213,0.105,
0.071,0.127,0.115,0.069,0.058,0.092,0.116,6.68e-3,0.064,0.101,
0.116,0.081,0.065,0.144,0.151,0.103,0.086,0.178,9.76e-3,6.31e-3,
5.93e-3,0.018,0.095,6.33e-3,0.065,0.094,0.091,0.091,0.076,0.158,
0.235,0.110,0.114,0.281,0.160,0.083,0.091,0.193,0.139,8.77e-3,
0.097,0.172,0.231,0.137,0.156,0.436,0.308,0.151,0.101,0.202,
0.157,0.109,0.071,0.105,0.133,0.011,0.068,0.119,0.168,0.130,
0.081,0.189,0.195,0.113,0.061,0.107,0.132,0.104,0.058,0.090,
0.119,7.88e-3,0.069,0.101,0.142,0.105,0.071,0.143,0.120,0.095,
0.061,0.120,6.50e-3,6.98e-3,4.05e-3,0.010,0.099,7.33e-3,0.055,0.100,
0.104,0.107,0.071,0.150,0.168,0.091,0.081,0.186,0.141,0.098,
0.084,0.203,0.122,8.27e-3,0.086,0.162,0.166,0.121,0.127,0.307,
0.233,0.109,0.081,0.163,0.187,0.102,0.076,0.128,0.134,0.013,
0.076,0.123,0.139,0.112,0.108,0.232,0.012,8.44e-3,4.76e-3,0.011,
8.42e-3,8.19e-3,5.20e-3,7.25e-3,7.27e-3,5.22e-4,5.33e-3,8.36e-3,9.38e-3,9.99e-3,
7.46e-3,0.016,0.117,0.088,0.068,0.109,8.06e-3,5.29e-3,4.32e-3,0.011,
0.105,8.11e-3,0.071,0.100,0.087,0.095,0.092,0.149,0.142,0.077,
0.080,0.147,0.133,0.090,0.084,0.162,0.197,0.014,0.121,0.243,
0.160,0.138,0.174,0.324,0.336,0.144,0.108,0.223,0.145,0.088,
0.079,0.107,0.155,0.013,0.076,0.142,0.210,0.134,0.107,0.306,
0.270,0.143,0.085,0.147,0.127,0.097,0.073,0.104,0.109,7.27e-3,
0.085,0.135,0.133,0.124,0.084,0.283,0.179,0.133,0.114,0.224,
9.21e-3,7.42e-3,6.20e-3,0.016,0.146,9.84e-3,0.093,0.162,0.157,0.157,
0.146,0.266,0.319,0.154,0.160,0.345,0.186,0.150,0.144,0.302,
0.275,0.017,0.204,0.364,0.450,0.384,0.384,0.745,0.604,0.332,
0.290,0.621,0.324,0.196,0.162,0.259,0.279,0.025,0.122,0.228,
0.414,0.336,0.189,0.399,0.289,0.161,0.130,0.202,0.184,0.111,
0.092,0.132,0.128,0.010,0.079,0.108,0.158,0.130,0.111,0.194,
0.277,0.153,0.123,0.290,0.015,0.010,8.13e-3,0.024,0.128,7.94e-3,
0.067,0.119,0.122,0.116,0.110,0.198,0.369,0.131,0.113,0.267,
0.193,0.102,0.094,0.181,0.139,9.25e-3,0.074,0.132,0.219,0.109,
0.147,0.338,0.459,0.214,0.139,0.284,0.250,0.146,0.115,0.160,
0.159,0.011,0.069,0.125,0.188,0.162,0.098,0.220,0.245,0.136,
0.091,0.140,0.163,0.087,0.085,0.108,0.121,7.92e-3,0.069,0.106,
0.109,0.092,0.073,0.132,0.226,0.139,0.089,0.168,0.015,9.17e-3,
6.58e-3,0.015,0.133,9.57e-3,0.071,0.168,0.104,0.117,0.099,0.167,
0.258,0.117,0.077,0.162,0.201,0.130,0.091,0.163,0.134,9.15e-3,
0.075,0.142,0.169,0.120,0.126,0.298,0.296,0.138,0.110,0.267,
0.218,0.132,0.112,0.165,0.180,0.019,0.077,0.119,0.196,0.186,
0.114,0.253,0.020,0.014,0.010,0.019,0.017,0.012,0.011,0.015,
0.013,1.25e-3,7.54e-3,0.013,0.021,0.027,0.014,0.028,0.155,0.094,
0.084,0.135,0.011,6.96e-3,6.87e-3,0.013,0.097,8.29e-3,0.049,0.078,
0.090,0.092,0.086,0.136,0.144,0.077,0.067,0.130,0.169,0.108,
0.097,0.153,0.137,0.010,0.081,0.137,0.187,0.120,0.131,0.259,
0.343,0.147,0.124,0.321,0.160,0.093,0.096,0.132,0.149,0.014,
0.078,0.122,0.237,0.162,0.121,0.290,0.227,0.128,0.110,0.189,
0.146,0.093,0.087,0.122,0.121,8.56e-3,0.081,0.129,0.162,0.138,
0.118,0.222,0.216,0.156,0.106,0.183,0.013,8.88e-3,8.25e-3,0.017,
0.135,9.69e-3,0.075,0.129,0.131,0.147,0.155,0.221,0.270,0.134,
0.120,0.266,0.166,0.095,0.120,0.192,0.272,0.016,0.139,0.240,
0.370,0.243,0.280,0.590,0.027,0.017,0.013,0.021,0.017,0.010,
7.35e-3,0.014,0.011,1.15e-3,5.24e-3,9.38e-3,0.015,0.015,8.54e-3,0.019,
0.019,0.011,0.018,0.013,0.011,8.50e-3,9.25e-3,0.010,7.12e-3,7.73e-4,
6.37e-3,7.81e-3,8.31e-3,7.75e-3,7.73e-3,0.014,0.012,8.04e-3,6.12e-3,0.012,
9.61e-4,8.98e-4,7.94e-4,1.25e-3,6.48e-3,6.27e-4,4.09e-3,6.79e-3,5.54e-3,6.60e-3,
6.29e-3,0.011,0.016,6.89e-3,6.37e-3,0.014,0.012,8.21e-3,6.81e-3,0.012,
8.34e-3,6.68e-4,4.87e-3,8.31e-3,0.011,8.50e-3,9.71e-3,0.023,0.021,0.011,
6.31e-3,0.012,0.014,0.011,6.31e-3,8.08e-3,7.79e-3,8.77e-4,4.22e-3,6.08e-3,
8.38e-3,7.98e-3,5.49e-3,0.011,0.015,0.013,6.50e-3,7.67e-3,0.013,0.010,
7.37e-3,8.90e-3,7.48e-3,1.21e-3,4.60e-3,6.25e-3,7.29e-3,8.38e-3,5.39e-3,9.48e-3,
0.010,9.23e-3,4.91e-3,8.82e-3,1.04e-3,1.25e-3,3.97e-4,1.04e-3,9.65e-3,1.21e-3,
5.06e-3,0.010,6.04e-3,8.04e-3,7.90e-3,0.010,0.015,7.17e-3,4.87e-3,9.82e-3,
0.010,8.92e-3,6.39e-3,0.011,8.86e-3,6.48e-4,4.93e-3,8.71e-3,9.36e-3,8.08e-3,
8.25e-3,0.019,0.016,6.79e-3,7.81e-3,0.012,0.011,6.98e-3,7.33e-3,8.63e-3,
7.96e-3,9.40e-4,4.87e-3,5.87e-3,8.31e-3,8.65e-3,6.37e-3,0.013,1.07e-3,8.36e-4,
7.31e-4,7.73e-4,8.98e-4,1.00e-3,9.19e-4,1.27e-3,5.64e-4,1.25e-4,9.40e-4,1.04e-3,
7.73e-4,1.15e-3,7.73e-4,1.65e-3,9.73e-3,7.71e-3,5.70e-3,0.011,9.82e-4,9.40e-4,
9.19e-4,1.00e-3,7.54e-3,1.67e-3,4.76e-3,6.00e-3,5.18e-3,7.50e-3,7.35e-3,0.012,
8.44e-3,5.43e-3,5.08e-3,8.79e-3,0.011,8.21e-3,7.56e-3,9.96e-3,8.25e-3,8.36e-4,
6.52e-3,0.012,9.21e-3,9.09e-3,9.78e-3,0.020,0.021,0.014,0.010,0.021,
0.012,8.02e-3,7.25e-3,0.011,9.21e-3,8.98e-4,5.74e-3,7.94e-3,0.016,0.013,
0.012,0.022,0.018,0.011,9.05e-3,0.017,0.013,0.011,9.90e-3,0.015,
0.010,8.56e-4,7.23e-3,0.011,0.012,0.013,0.011,0.020,0.013,0.012,
8.11e-3,0.014,9.82e-4,1.02e-3,9.82e-4,1.21e-3,7.90e-3,1.00e-3,6.46e-3,0.010,
9.17e-3,0.010,0.026,0.018,0.017,9.92e-3,8.27e-3,0.017,0.014,0.010,
9.65e-3,0.016,0.015,1.36e-3,9.69e-3,0.018,0.020,0.021,0.023,0.048,
0.375,0.210,0.182,0.286,0.169,0.116,0.084,0.142,0.141,0.013,
0.086,0.132,0.158,0.123,0.085,0.182,0.269,0.143,0.095,0.151,
0.161,0.103,0.097,0.120,0.122,0.010,0.124,0.127,0.114,0.113,
0.085,0.161,0.157,0.128,0.079,0.152,0.015,0.013,0.011,0.023,
0.103,0.010,0.072,0.110,0.083,0.119,0.088,0.181,0.170,0.093,
0.072,0.158,0.136,0.102,0.108,0.163,0.123,0.010,0.087,0.169,
0.167,0.121,0.143,0.400,0.017,0.012,6.89e-3,0.012,0.011,9.36e-3,
4.97e-3,9.44e-3,7.42e-3,1.11e-3,4.70e-3,6.60e-3,8.23e-3,8.27e-3,5.43e-3,0.011,
0.014,9.13e-3,6.23e-3,7.92e-3,0.011,8.50e-3,6.04e-3,7.90e-3,7.00e-3,1.23e-3,
7.71e-3,7.65e-3,6.06e-3,7.17e-3,5.14e-3,9.48e-3,0.010,9.25e-3,5.12e-3,9.13e-3,
8.36e-4,1.34e-3,1.07e-3,1.17e-3,7.83e-3,1.30e-3,8.38e-3,0.012,5.97e-3,8.04e-3,
6.62e-3,0.011,0.017,8.44e-3,5.39e-3,0.015,0.015,0.013,8.40e-3,0.016,
9.94e-3,1.36e-3,7.12e-3,0.025,0.012,9.48e-3,9.59e-3,0.028,0.231,0.131,
0.092,0.119,0.151,0.115,0.107,0.115,0.122,0.013,0.091,0.111,
0.100,0.099,0.097,0.176,0.013,0.011,6.46e-3,8.25e-3,9.36e-3,9.59e-3,
8.21e-3,7.96e-3,9.23e-3,1.34e-3,8.79e-3,8.73e-3,9.40e-3,0.011,8.46e-3,0.014,
0.164,0.120,0.091,0.127,0.011,8.69e-3,0.011,0.013,0.132,0.012,
0.052,0.087,0.079,0.085,0.090,0.130,0.121,0.077,0.063,0.093,
0.127,0.098,0.080,0.107,0.120,0.010,0.109,0.145,0.113,0.098,
0.132,0.216,0.219,0.115,0.086,0.158,0.127,0.089,0.062,0.084,
0.104,9.44e-3,0.073,0.110,0.125,0.094,0.080,0.173,0.184,0.127,
0.082,0.135,0.138,0.114,0.081,0.094,0.101,8.69e-3,0.100,0.127,
0.107,0.117,0.092,0.152,0.223,0.146,0.101,0.197,0.013,0.011,
8.25e-3,0.014,0.146,0.012,0.119,0.170,0.123,0.147,0.135,0.209,
0.195,0.111,0.089,0.176,0.139,0.104,0.086,0.127,0.177,0.012,
0.164,0.236,0.214,0.185,0.215,0.382,0.444,0.184,0.146,0.310,
0.182,0.097,0.086,0.146,0.152,0.012,0.073,0.120,0.203,0.137,
0.096,0.235,0.258,0.106,0.084,0.127,0.125,0.066,0.067,0.102,
0.098,6.02e-3,0.078,0.102,0.101,0.076,0.068,0.140,0.211,0.102,
0.073,0.152,0.013,6.79e-3,5.56e-3,0.018,0.141,7.65e-3,0.064,0.122,
0.106,0.097,0.089,0.189,0.225,0.098,0.089,0.189,0.147,0.080,
0.082,0.150,0.133,7.06e-3,0.069,0.133,0.186,0.114,0.135,0.382,
0.340,0.163,0.099,0.202,0.176,0.104,0.082,0.124,0.119,8.52e-3,
0.067,0.106,0.140,0.132,0.070,0.180,0.206,0.119,0.068,0.119,
0.129,0.082,0.066,0.103,0.093,5.52e-3,0.071,0.098,0.082,0.079,
0.059,0.120,0.147,0.108,0.068,0.136,7.48e-3,7.14e-3,4.87e-3,0.011,
0.127,8.48e-3,0.074,0.147,0.098,0.107,0.086,0.178,0.212,0.104,
0.076,0.167,0.158,0.112,0.086,0.167,0.128,8.11e-3,0.080,0.182,
0.150,0.123,0.122,0.308,0.288,0.121,0.101,0.159,0.175,0.102,
0.108,0.146,0.145,0.014,0.087,0.140,0.137,0.120,0.121,0.240,
0.013,7.71e-3,5.47e-3,9.46e-3,8.67e-3,8.36e-3,6.62e-3,9.17e-3,7.14e-3,8.98e-4,
6.79e-3,8.86e-3,9.32e-3,0.010,8.13e-3,0.014,0.170,0.118,0.088,0.151,
9.88e-3,7.10e-3,5.85e-3,0.013,0.135,0.011,0.090,0.136,0.102,0.113,
0.107,0.182,0.179,0.104,0.104,0.146,0.188,0.113,0.109,0.166,
0.150,0.010,0.126,0.215,0.157,0.128,0.172,0.314,0.331,0.130,
0.104,0.212,0.148,0.083,0.090,0.110,0.144,0.013,0.083,0.131,
0.175,0.112,0.106,0.249,0.180,0.094,0.070,0.129,0.114,0.078,
0.078,0.104,0.088,5.56e-3,0.083,0.118,0.098,0.090,0.095,0.160,
0.207,0.156,0.128,0.223,0.012,9.76e-3,6.27e-3,0.017,0.181,0.011,
0.129,0.224,0.157,0.156,0.156,0.265,0.305,0.139,0.130,0.275,
0.209,0.145,0.122,0.215,0.239,0.013,0.188,0.333,0.317,0.231,
0.290,0.568,1.550,0.489,0.367,0.932,0.358,0.177,0.165,0.296,
0.295,0.022,0.115,0.215,0.523,0.367,0.191,0.501,0.299,0.136,
0.092,0.181,0.149,0.072,0.060,0.100,0.124,6.35e-3,0.067,0.098,
0.164,0.131,0.089,0.171,0.229,0.124,0.090,0.209,0.014,8.31e-3,
6.31e-3,0.020,0.108,6.18e-3,0.052,0.103,0.110,0.104,0.084,0.199,
0.365,0.147,0.126,0.312,0.195,0.109,0.097,0.207,0.149,9.07e-3,
0.083,0.151,0.270,0.152,0.165,0.458,0.351,0.144,0.094,0.194,
0.142,0.073,0.056,0.087,0.094,6.33e-3,0.037,0.072,0.143,0.091,
0.060,0.145,0.154,0.075,0.047,0.087,0.086,0.047,0.035,0.054,
0.069,3.41e-3,0.031,0.055,0.081,0.056,0.042,0.087,0.130,0.076,
0.049,0.100,6.77e-3,4.26e-3,2.84e-3,6.71e-3,0.084,3.86e-3,0.031,0.064,
0.084,0.069,0.063,0.106,0.147,0.072,0.047,0.105,0.096,0.062,
0.041,0.080,0.080,4.39e-3,0.037,0.077,0.115,0.074,0.075,0.196,
0.278,0.102,0.091,0.195,0.149,0.064,0.062,0.120,0.115,9.94e-3,
0.044,0.085,0.180,0.118,0.077,0.233,0.012,7.21e-3,5.20e-3,0.011,
7.79e-3,4.74e-3,4.60e-3,8.31e-3,6.68e-3,5.43e-4,3.45e-3,7.12e-3,0.016,0.013,
6.75e-3,0.018,0.122,0.066,0.067,0.104,7.71e-3,3.82e-3,3.36e-3,9.02e-3,
0.071,3.89e-3,0.034,0.058,0.083,0.065,0.064,0.117,0.126,0.065,
0.063,0.128,0.112,0.063,0.059,0.108,0.094,5.68e-3,0.051,0.108,
0.147,0.091,0.106,0.242,0.392,0.146,0.130,0.324,0.151,0.073,
0.084,0.131,0.152,0.011,0.072,0.125,0.288,0.159,0.121,0.327,
0.186,0.090,0.079,0.146,0.099,0.056,0.056,0.083,0.098,5.83e-3,
0.056,0.097,0.160,0.114,0.085,0.183,0.148,0.120,0.086,0.157,
8.92e-3,6.12e-3,5.16e-3,0.011,0.090,5.08e-3,0.050,0.097,0.109,0.106,
0.104,0.191,0.272,0.122,0.123,0.282,0.166,0.100,0.096,0.161,
0.193,9.48e-3,0.115,0.211,0.372,0.220,0.268,0.684,0.393,0.164,
0.119,0.285,0.157,0.083,0.060,0.109,0.110,8.59e-3,0.043,0.088,
0.156,0.126,0.073,0.182,0.163,0.084,0.078,0.105,0.092,0.054,
0.045,0.063,0.065,4.05e-3,0.037,0.058,0.072,0.061,0.048,0.093,
0.108,0.065,0.047,0.094,5.49e-3,4.05e-3,2.80e-3,7.88e-3,0.057,2.95e-3,
0.032,0.056,0.059,0.051,0.050,0.097,0.131,0.059,0.047,0.116,
0.091,0.054,0.043,0.080,0.065,3.95e-3,0.035,0.063,0.095,0.061,
0.070,0.183,0.228,0.104,0.053,0.115,0.107,0.071,0.037,0.058,
0.061,4.05e-3,0.023,0.047,0.083,0.066,0.045,0.096,0.115,0.074,
0.038,0.063,0.090,0.071,0.036,0.053,0.047,3.68e-3,0.022,0.039,
0.053,0.063,0.034,0.062,0.084,0.060,0.031,0.067,4.49e-3,3.72e-3,
1.82e-3,4.18e-3,0.059,4.07e-3,0.027,0.048,0.051,0.053,0.046,0.082,
0.088,0.049,0.029,0.068,0.066,0.051,0.029,0.056,0.053,2.80e-3,
0.026,0.048,0.070,0.055,0.056,0.139,0.193,0.071,0.059,0.124,
0.087,0.048,0.043,0.069,0.066,5.31e-3,0.033,0.048,0.090,0.061,
0.050,0.125,7.06e-3,3.74e-3,2.13e-3,5.95e-3,4.24e-3,3.76e-3,2.90e-3,4.35e-3,
2.55e-3,3.76e-4,2.07e-3,2.63e-3,6.43e-3,5.06e-3,3.28e-3,6.66e-3,0.105,0.059,
0.048,0.089,4.97e-3,2.84e-3,2.57e-3,6.33e-3,0.051,3.70e-3,0.025,0.044,
0.061,0.051,0.049,0.093,0.093,0.050,0.040,0.083,0.083,0.045,
0.044,0.074,0.066,4.30e-3,0.038,0.069,0.086,0.060,0.072,0.174,
0.183,0.072,0.067,0.157,0.076,0.042,0.040,0.066,0.067,4.91e-3,
0.038,0.057,0.107,0.074,0.059,0.145,0.108,0.058,0.047,0.083,
0.062,0.048,0.037,0.057,0.049,2.74e-3,0.034,0.055,0.079,0.077,
0.054,0.105,0.095,0.068,0.045,0.089,5.93e-3,3.20e-3,2.55e-3,4.85e-3,
0.049,3.24e-3,0.033,0.055,0.058,0.054,0.077,0.117,0.122,0.057,
0.060,0.115,0.091,0.052,0.047,0.089,0.085,4.28e-3,0.058,0.104,
0.146,0.123,0.130,0.336,0.314,0.142,0.096,0.203,0.104,0.063,
0.045,0.090,0.120,7.81e-3,0.053,0.084,0.133,0.085,0.054,0.122,
0.159,0.088,0.055,0.097,0.079,0.049,0.041,0.057,0.074,4.80e-3,
0.044,0.068,0.080,0.077,0.046,0.116,0.102,0.081,0.050,0.101,
7.42e-3,6.06e-3,3.99e-3,0.010,0.056,4.05e-3,0.029,0.058,0.056,0.067,
0.046,0.100,0.129,0.064,0.050,0.117,0.086,0.058,0.049,0.089,
0.085,5.41e-3,0.041,0.087,0.120,0.078,0.088,0.238,0.011,6.66e-3,
3.78e-3,6.50e-3,5.33e-3,3.70e-3,2.17e-3,4.18e-3,3.97e-3,2.72e-4,1.82e-3,3.99e-3,
5.33e-3,4.30e-3,2.49e-3,7.58e-3,5.91e-3,4.26e-3,2.03e-3,3.28e-3,4.47e-3,3.55e-3,
1.92e-3,2.82e-3,3.24e-3,2.51e-4,1.80e-3,3.45e-3,3.97e-3,4.37e-3,2.47e-3,6.00e-3,
3.82e-3,3.70e-3,2.26e-3,3.68e-3,1.67e-4,3.13e-4,8.36e-5,3.55e-4,3.13e-3,1.67e-4,
1.55e-3,3.05e-3,3.11e-3,3.49e-3,2.63e-3,5.31e-3,7.90e-3,4.16e-3,2.95e-3,7.08e-3,
6.56e-3,5.35e-3,2.72e-3,6.62e-3,4.72e-3,3.97e-4,2.21e-3,6.43e-3,6.87e-3,5.95e-3,
4.76e-3,0.014,0.163,0.074,0.049,0.081,0.082,0.055,0.039,0.067,
0.066,6.87e-3,0.037,0.063,0.075,0.064,0.054,0.129,6.50e-3,3.89e-3,
2.34e-3,4.20e-3,4.16e-3,3.11e-3,2.13e-3,3.49e-3,3.45e-3,3.13e-4,2.19e-3,3.68e-3,
6.10e-3,5.39e-3,3.34e-3,7.21e-3,0.085,0.067,0.047,0.081,4.35e-3,3.95e-3,
3.57e-3,5.54e-3,0.072,4.60e-3,0.043,0.060,0.051,0.052,0.050,0.084,
0.088,0.053,0.043,0.075,0.073,0.058,0.040,0.066,0.084,5.74e-3,
0.056,0.089,0.088,0.064,0.085,0.162,0.176,0.075,0.052,0.114,
0.075,0.047,0.037,0.065,0.082,5.45e-3,0.046,0.079,0.098,0.067,
0.049,0.131,0.113,0.063,0.044,0.077,0.069,0.046,0.034,0.048,
0.059,3.41e-3,0.042,0.064,0.082,0.069,0.052,0.108,0.105,0.068,
0.049,0.105,4.83e-3,3.63e-3,2.86e-3,6.18e-3,0.074,3.99e-3,0.051,0.080,
0.079,0.076,0.070,0.123,0.134,0.060,0.054,0.107,0.070,0.051,
0.039,0.067,0.113,6.20e-3,0.078,0.127,0.141,0.095,0.126,0.250,
0.639,0.177,0.111,0.286,0.108,0.055,0.046,0.101,0.094,7.21e-3,
0.043,0.075,0.147,0.103,0.058,0.174,0.118,0.051,0.030,0.060,
0.051,0.029,0.020,0.037,0.044,2.55e-3,0.025,0.047,0.051,0.039,
0.027,0.070,0.088,0.051,0.036,0.083,4.24e-3,2.99e-3,2.05e-3,7.69e-3,
0.051,3.20e-3,0.023,0.048,0.050,0.047,0.035,0.091,0.138,0.058,
0.053,0.125,0.069,0.041,0.035,0.079,0.063,3.41e-3,0.033,0.072,
0.118,0.070,0.079,0.234,0.134,0.060,0.037,0.067,0.054,0.033,
0.021,0.037,0.039,2.59e-3,0.016,0.033,0.046,0.036,0.020,0.056,
0.061,0.031,0.016,0.032,0.027,0.027,0.011,0.020,0.029,1.38e-3,
0.015,0.026,0.033,0.028,0.016,0.044,0.045,0.028,0.020,0.040,
2.09e-3,1.36e-3,6.27e-4,2.38e-3,0.041,1.88e-3,0.016,0.031,0.032,0.029,
0.022,0.053,0.058,0.029,0.020,0.051,0.040,0.026,0.018,0.043,
0.038,1.92e-3,0.019,0.042,0.053,0.039,0.035,0.119,0.108,0.040,
0.037,0.057,0.050,0.025,0.023,0.044,0.043,2.82e-3,0.020,0.037,
0.049,0.036,0.031,0.080,3.53e-3,1.73e-3,1.02e-3,2.13e-3,1.38e-3,1.36e-3,
1.11e-3,2.03e-3,1.21e-3,8.36e-5,7.31e-4,1.42e-3,2.84e-3,2.44e-3,2.26e-3,4.35e-3,
0.050,0.032,0.023,0.044,1.78e-3,1.19e-3,1.15e-3,2.82e-3,0.033,1.92e-3,
0.027,0.033,0.034,0.031,0.032,0.059,0.061,0.034,0.027,0.050,
0.038,0.025,0.021,0.042,0.041,2.03e-3,0.029,0.053,0.051,0.034,
0.047,0.100,0.216,0.045,0.033,0.073,0.029,0.014,0.013,0.024,
0.030,1.80e-3,0.016,0.028,0.042,0.025,0.021,0.066,0.033,0.018,
9.92e-3,0.015,0.014,7.04e-3,8.63e-3,0.016,0.014,7.10e-4,0.011,0.017,
0.021,0.014,0.014,0.035,0.030,0.017,0.017,0.026,6.48e-4,7.73e-4,
5.85e-4,1.23e-3,0.020,1.00e-3,0.015,0.025,0.022,0.017,0.021,0.040,
0.060,0.010,0.011,0.018,0.010,7.17e-3,6.54e-3,0.013,0.014,5.85e-4,
0.014,0.021,0.023,8.90e-3,0.014,0.016
};

static double hg19_biasTable25_4_large[] = {
325.0,55.2,24.9,50.8,42.4,15.2,10.9,19.2,22.1,1.560,
10.9,12.7,29.7,19.3,20.6,34.0,42.0,13.3,8.500,12.1,
13.1,5.310,5.170,6.000,10.4,0.673,5.030,5.990,11.6,7.460,
6.580,11.1,23.8,9.570,7.880,9.020,1.310,0.781,0.573,1.110,
6.820,0.576,6.300,6.210,8.290,6.820,4.700,7.980,35.2,12.2,
12.1,18.8,14.9,8.400,7.810,13.8,15.2,0.945,7.280,11.3,
26.1,11.0,10.3,18.9,48.8,13.2,8.200,15.2,14.1,6.610,
4.640,6.260,11.1,0.778,3.320,6.010,10.4,7.260,4.010,8.460,
16.8,6.730,3.650,5.370,6.030,3.550,2.350,2.700,6.760,0.418,
2.600,3.840,5.050,3.650,2.370,4.370,11.4,6.780,4.310,6.800,
0.616,0.435,0.267,0.556,6.050,0.510,2.830,4.180,4.740,4.560,
3.060,5.440,11.9,6.020,4.330,8.040,7.210,4.680,3.020,5.320,
7.650,0.431,3.020,5.510,8.840,5.260,4.260,10.000,34.4,8.630,
8.140,10.7,11.7,5.560,4.970,6.840,11.3,0.916,3.780,6.360,
9.580,6.800,4.710,10.7,1.700,0.767,0.529,0.834,0.835,0.588,
0.408,0.567,0.765,0.066,0.350,0.622,1.160,1.020,0.558,1.230,
7.700,4.280,4.360,4.970,0.583,0.354,0.338,0.564,6.140,0.433,
2.870,4.620,4.650,4.460,3.400,5.170,8.540,4.870,4.330,6.750,
7.530,4.770,3.690,5.940,5.920,0.420,3.050,5.390,6.180,4.670,
4.590,8.490,48.6,12.6,10.1,23.0,13.3,5.750,6.010,8.200,
18.6,1.360,5.270,9.450,20.6,11.0,7.950,22.1,18.1,8.920,
6.160,9.420,8.990,5.550,4.640,5.930,9.750,0.519,4.510,7.660,
12.5,8.900,6.590,13.7,13.8,9.230,7.230,9.620,0.845,0.517,
0.451,0.784,7.320,0.462,4.160,6.630,7.860,7.230,5.860,9.160,
24.0,15.4,8.570,17.8,9.090,5.580,4.740,8.870,10.6,0.629,
5.570,9.810,14.6,7.700,7.850,18.4,51.5,18.8,10.8,19.0,
13.6,6.870,5.010,7.010,9.640,0.841,3.290,5.790,11.6,9.570,
4.950,9.590,14.7,8.990,4.590,6.260,6.810,3.960,3.460,4.010,
5.240,0.426,2.940,3.910,4.820,3.970,2.690,4.830,10.3,6.490,
4.840,7.260,0.671,0.513,0.355,0.668,4.000,0.339,2.190,3.090,
4.230,4.620,2.750,5.040,10.7,4.210,4.670,7.330,6.940,4.340,
3.720,5.420,4.960,0.347,2.250,3.820,6.560,4.000,3.680,8.180,
19.2,9.390,4.740,8.050,7.770,4.960,2.890,3.540,5.280,0.443,
1.750,3.140,4.780,4.220,2.300,4.560,8.370,4.750,2.420,3.210,
4.100,2.700,1.910,2.030,3.430,0.276,1.650,2.460,2.460,2.320,
1.560,2.390,7.200,5.520,2.910,4.700,0.397,0.417,0.206,0.313,
3.720,0.442,1.690,2.660,2.810,3.590,1.980,3.730,5.480,3.110,
2.180,3.760,3.970,3.060,1.820,2.500,3.300,0.233,1.290,2.460,
3.510,2.540,1.710,4.590,13.5,6.550,4.220,7.030,7.550,4.690,
4.210,4.750,5.970,0.546,2.360,3.980,5.270,4.390,3.380,6.880,
0.679,0.489,0.266,0.434,0.371,0.427,0.263,0.289,0.347,0.057,
0.216,0.328,0.446,0.460,0.273,0.565,5.700,4.630,3.420,4.430,
0.389,0.392,0.306,0.392,3.600,0.329,2.010,2.950,2.860,3.380,
2.680,4.070,4.800,2.700,2.540,3.940,4.760,3.520,2.700,3.780,
3.540,0.266,2.300,3.540,3.680,2.710,3.470,6.100,13.4,4.860,
4.000,7.750,6.290,3.180,2.810,3.540,5.530,0.391,1.970,3.580,
6.650,4.120,3.070,7.380,7.750,4.440,3.180,4.700,4.230,3.450,
2.480,3.110,3.250,0.236,2.040,3.750,3.790,3.910,2.710,5.280,
6.580,4.620,3.750,5.390,0.369,0.289,0.204,0.370,3.450,0.253,
1.980,3.220,3.510,3.770,3.030,4.910,8.900,3.970,3.650,6.450,
5.170,3.330,2.490,4.140,4.640,0.304,2.530,4.720,7.230,5.340,
4.780,9.610,42.2,11.2,12.6,14.2,8.430,4.850,4.240,5.740,
10.4,0.755,3.980,5.930,9.740,7.270,4.800,9.670,13.7,6.830,
5.610,6.550,5.910,3.380,3.480,3.670,6.780,0.484,3.420,4.470,
6.130,5.220,3.220,5.750,10.1,6.940,5.810,7.350,0.778,0.606,
0.450,0.899,4.680,0.447,2.270,3.560,4.370,5.750,3.210,6.130,
9.870,4.690,5.000,8.320,6.440,4.410,3.710,5.850,6.070,0.475,
3.050,5.410,8.310,5.210,5.550,14.2,1.870,0.920,0.619,0.914,
0.788,0.633,0.366,0.497,0.675,0.080,0.292,0.470,0.647,0.684,
0.377,0.751,0.996,0.655,0.522,0.463,0.620,0.522,0.360,0.335,
0.559,0.077,0.325,0.373,0.480,0.520,0.276,0.468,0.695,0.614,
0.403,0.525,0.059,0.066,0.047,0.067,0.487,0.075,0.268,0.374,
0.419,0.616,0.338,0.591,1.100,0.628,0.500,1.070,0.928,0.855,
0.511,0.917,0.715,0.070,0.405,0.679,0.929,0.661,0.645,1.490,
11.1,4.840,3.580,4.260,5.320,3.410,3.020,3.350,6.890,0.677,
2.850,3.940,4.570,3.880,3.350,4.920,0.718,0.519,0.261,0.337,
0.376,0.288,0.258,0.249,0.505,0.068,0.265,0.323,0.552,0.520,
0.335,0.451,5.550,4.310,3.400,3.530,0.420,0.322,0.244,0.393,
4.690,0.544,1.390,2.130,3.110,3.660,2.610,3.300,4.720,3.100,
2.540,3.460,4.150,3.190,2.530,3.530,4.240,0.376,2.350,3.600,
3.560,3.150,3.160,5.150,10.5,4.440,3.280,5.560,5.330,2.540,
2.440,2.850,5.980,0.438,2.530,3.840,6.690,4.050,3.050,6.750,
9.240,5.960,3.400,4.690,5.590,3.380,2.900,3.010,4.840,0.331,
2.800,4.370,5.300,4.350,3.490,5.430,6.000,4.750,3.410,4.780,
0.429,0.353,0.226,0.385,4.260,0.517,2.230,3.380,3.820,4.360,
3.350,5.320,6.850,3.850,3.580,4.690,4.540,3.340,2.630,3.890,
5.570,0.412,3.520,5.130,6.950,4.810,5.060,9.530,53.1,15.5,
12.0,29.1,11.8,5.980,5.760,8.840,11.5,0.891,4.710,9.160,
20.8,11.3,7.940,20.2,14.3,6.450,4.780,7.470,5.690,3.060,
3.230,3.870,6.420,0.409,3.630,5.470,6.880,4.590,3.490,7.380,
16.8,8.480,5.990,11.6,1.080,0.676,0.488,1.350,6.230,0.494,
2.640,5.420,6.810,6.320,3.940,9.250,18.1,7.510,8.100,21.8,
9.550,5.780,5.530,11.2,9.110,0.593,4.870,9.780,15.7,8.770,
9.580,29.8,20.9,9.860,6.350,11.5,9.820,6.470,4.200,6.090,
7.990,0.578,3.390,5.820,8.420,6.660,4.110,8.440,11.4,6.130,
4.290,5.630,6.430,4.650,3.470,3.570,6.360,0.509,3.160,4.620,
5.570,4.620,2.630,5.290,9.580,6.510,4.020,7.460,0.462,0.410,
0.240,0.550,5.800,0.439,2.820,4.930,5.750,6.090,4.010,7.480,
12.1,6.030,5.210,11.6,8.250,6.870,4.210,8.360,8.020,0.457,
4.280,7.470,10.4,6.450,6.770,15.1,12.2,6.490,5.390,8.870,
7.760,4.420,4.420,6.460,7.610,0.673,3.650,5.950,7.040,5.460,
4.380,8.470,0.784,0.562,0.390,0.607,0.451,0.372,0.311,0.392,
0.475,0.053,0.321,0.559,0.639,0.565,0.357,0.661,6.740,4.940,
3.460,5.230,0.408,0.258,0.227,0.456,4.920,0.365,2.330,3.690,
4.580,4.320,3.540,5.430,6.810,4.200,3.700,6.080,6.490,4.000,
3.560,6.140,6.460,0.397,3.610,6.030,6.210,4.440,4.860,8.900,
25.2,8.520,7.910,13.4,8.440,4.680,11.4,6.450,9.060,0.643,
4.430,6.990,13.8,7.800,6.980,16.9,9.070,5.340,3.830,5.980,
5.110,3.250,3.090,3.650,4.930,0.284,3.040,5.140,6.830,5.070,
3.890,7.900,10.1,7.020,5.260,8.370,0.527,0.354,0.328,0.562,
6.540,0.400,3.290,5.720,7.630,6.740,5.160,8.510,16.7,6.540,
5.880,11.9,7.580,5.080,4.450,7.170,9.310,0.421,5.550,8.920,
16.4,8.060,8.510,18.1,46.1,21.1,13.2,22.5,22.6,9.170,
6.260,7.710,12.3,1.160,4.990,8.000,16.0,11.7,7.120,12.1,
14.6,7.920,5.400,6.160,7.950,4.520,3.650,3.650,6.080,0.443,
3.970,4.350,5.260,4.490,3.670,5.700,8.840,5.800,4.120,6.180,
0.748,0.464,0.367,0.713,4.140,0.350,2.050,2.780,4.490,4.480,
3.370,5.330,11.2,4.770,4.150,8.230,8.820,4.670,3.680,6.070,
5.400,0.428,2.750,4.400,7.160,4.580,4.870,8.820,17.8,8.770,
4.490,7.440,12.0,5.130,2.970,3.650,6.190,0.584,2.420,3.940,
5.480,5.110,2.680,5.450,8.680,5.270,2.520,3.460,5.000,2.690,
2.010,2.310,4.230,0.380,2.450,3.270,3.160,3.010,1.910,3.830,
5.030,4.150,2.410,3.600,0.510,0.284,0.214,0.341,3.340,0.352,
2.120,2.780,2.930,3.570,2.670,3.940,4.780,2.800,1.830,3.370,
4.030,2.620,1.570,2.760,3.130,0.240,1.640,2.630,3.530,2.950,
2.650,5.150,11.5,5.050,3.350,5.280,7.440,4.280,3.210,4.210,
6.720,0.693,2.310,3.710,5.670,4.650,3.060,6.500,0.697,0.515,
0.351,0.457,0.560,0.542,0.334,0.390,0.447,0.065,0.282,0.395,
0.531,0.632,0.343,0.648,3.800,2.760,2.250,2.860,0.328,0.231,
0.184,0.329,2.720,0.288,1.610,2.440,2.440,2.740,1.950,2.950,
3.730,2.130,1.940,3.130,4.560,2.910,2.100,3.290,3.250,0.310,
2.060,2.820,3.810,3.360,3.160,5.120,11.4,4.500,3.470,7.000,
4.240,2.410,1.990,2.880,5.520,0.563,2.110,3.770,5.800,3.870,
2.860,7.120,7.660,4.800,3.230,4.540,4.530,3.330,2.650,3.030,
3.660,0.292,2.470,3.930,3.980,3.750,2.890,5.240,4.290,3.410,
2.550,3.490,0.317,0.216,0.209,0.307,2.410,0.205,1.560,2.250,
2.740,3.030,2.530,3.420,6.170,3.160,2.460,5.140,3.270,2.290,
1.900,2.960,3.810,0.276,2.420,3.890,5.910,4.360,4.690,8.900,
19.2,10.4,6.400,11.1,10.2,6.790,4.040,4.890,5.650,0.618,
2.240,3.700,6.460,5.940,3.160,5.860,8.760,5.960,3.410,4.410,
5.480,3.760,2.890,2.820,3.430,0.361,2.120,2.850,2.560,2.660,
2.030,3.220,4.460,3.980,2.870,4.440,0.364,0.344,0.257,0.452,
2.150,0.233,1.360,1.890,2.170,2.550,2.000,3.450,4.680,2.340,
2.240,4.190,4.000,2.960,2.100,3.030,2.790,0.250,1.530,2.330,
3.500,2.310,2.540,5.180,9.500,6.230,3.120,4.600,5.790,4.210,
2.140,2.530,3.330,0.348,1.480,2.330,2.870,3.010,1.630,2.940,
5.450,3.650,1.770,2.310,3.030,1.270,1.510,1.520,2.500,0.332,
1.650,2.220,1.550,2.000,1.400,1.920,3.240,3.350,1.810,2.800,
0.279,0.320,0.176,0.258,2.330,0.327,1.320,1.870,1.720,2.660,
1.780,2.750,2.560,1.780,1.250,2.110,2.420,2.240,1.130,1.710,
1.980,0.189,1.070,1.870,1.990,1.660,1.330,2.830,7.560,4.280,
2.540,3.870,5.960,4.360,3.140,3.480,3.820,0.496,1.690,2.590,
3.360,3.130,2.390,4.340,0.388,0.412,0.207,0.300,0.360,0.515,
0.338,0.277,0.247,0.087,0.245,0.270,0.233,0.411,0.211,0.319,
3.140,3.230,2.210,2.750,0.365,0.443,0.242,0.326,2.150,0.291,
1.680,2.370,1.680,2.530,1.980,2.880,2.630,1.500,1.540,2.210,
3.550,3.000,2.150,2.750,2.400,0.234,1.580,2.450,2.480,2.120,
2.420,4.310,5.850,2.870,2.090,3.470,3.370,2.040,1.450,1.890,
2.680,0.222,1.090,1.760,2.940,2.090,1.560,3.460,4.230,2.910,
2.080,2.730,2.850,2.640,1.830,2.100,1.790,0.195,1.460,2.170,
1.700,2.120,1.510,2.580,2.870,2.630,2.140,2.620,0.209,0.228,
0.140,0.205,1.470,0.147,1.140,1.590,1.730,2.040,1.720,2.640,
3.710,1.790,1.490,2.660,2.240,1.890,1.320,1.850,1.990,0.150,
1.170,2.120,3.380,2.640,2.490,5.030,12.7,6.890,5.100,8.070,
6.280,3.920,3.260,4.360,4.840,0.485,2.260,3.430,5.100,4.570,
3.240,5.810,7.700,5.590,2.960,4.400,4.860,3.620,2.830,3.060,
4.800,0.496,3.310,3.750,3.390,3.960,2.400,4.320,4.550,4.660,
2.620,4.040,0.403,0.400,0.276,0.580,2.800,0.335,1.500,2.410,
2.400,3.650,2.170,4.420,4.520,2.620,2.170,4.320,3.580,2.700,
2.150,3.450,3.450,0.325,2.140,3.410,4.040,2.930,3.800,7.970,
0.674,0.474,0.241,0.404,0.713,0.439,0.264,0.319,0.319,0.050,
0.174,0.260,0.308,0.365,0.262,0.428,0.419,0.383,0.172,0.221,
0.450,0.488,0.275,0.287,0.327,0.086,0.272,0.290,0.216,0.298,
0.179,0.279,0.261,0.369,0.171,0.258,0.041,0.074,0.052,0.048,
0.273,0.076,0.209,0.261,0.228,0.478,0.308,0.375,0.371,0.255,
0.177,0.392,0.375,0.400,0.241,0.390,0.291,0.043,0.223,0.338,
0.322,0.311,0.376,0.599,6.170,4.000,2.320,3.210,4.580,3.910,
2.890,3.160,4.620,0.621,2.260,3.060,2.990,3.170,2.570,4.150,
0.376,0.459,0.211,0.237,0.306,0.486,0.276,0.232,0.325,0.116,
0.269,0.295,0.282,0.401,0.262,0.332,2.760,3.730,1.980,2.530,
0.272,0.338,0.219,0.341,2.700,0.409,1.360,2.110,1.790,2.940,
2.100,2.860,2.740,1.880,1.550,2.220,2.980,3.110,2.070,2.780,
3.050,0.362,2.300,2.870,2.340,2.500,3.010,4.300,5.000,2.660,
1.810,3.100,2.890,1.650,1.330,1.750,3.130,0.274,1.430,2.380,
3.110,2.340,1.820,3.920,5.150,3.900,2.080,2.830,4.080,3.090,
1.990,2.290,3.220,0.308,2.310,3.320,2.860,3.080,2.330,3.800,
2.910,3.110,1.860,2.690,0.220,0.238,0.164,0.241,2.430,0.285,
1.860,2.410,2.170,3.140,2.350,3.570,3.260,2.010,1.640,3.120,
2.350,1.940,1.500,2.130,3.340,0.278,2.790,3.720,3.880,3.400,
3.750,5.970,13.4,5.100,4.010,8.040,4.550,2.620,2.210,3.590,
4.270,0.358,1.810,3.600,5.720,3.850,2.610,6.580,6.760,3.270,
2.210,3.780,3.010,1.930,1.670,2.280,2.770,0.191,1.840,2.690,
2.740,1.960,1.540,3.360,4.600,3.320,2.120,3.780,0.281,0.234,
0.162,0.410,2.260,0.196,1.110,2.100,2.440,2.700,1.630,3.780,
6.710,2.700,2.680,5.710,3.270,2.110,1.820,3.800,3.050,0.217,
1.680,3.390,4.740,2.930,3.140,8.600,8.650,4.650,2.700,4.700,
5.270,3.400,2.180,3.050,3.940,0.365,1.860,3.250,3.690,3.460,
2.200,4.450,4.890,3.120,1.700,2.610,3.510,2.800,2.080,2.270,
3.050,0.260,1.820,2.860,2.600,2.360,1.540,3.110,2.880,2.780,
1.560,2.540,0.216,0.262,0.138,0.269,2.580,0.372,1.450,2.530,
3.130,6.020,2.280,4.270,3.390,2.050,1.770,3.310,3.140,2.820,
1.760,3.670,2.870,0.223,1.820,3.050,3.390,3.180,2.970,5.800,
6.490,3.690,2.630,3.790,4.260,3.110,2.450,3.330,4.820,0.507,
2.320,3.590,3.650,3.210,2.840,5.160,0.362,0.292,0.175,0.289,
0.221,0.281,0.212,0.216,0.227,0.035,0.172,0.277,0.270,0.309,
0.214,0.361,3.080,2.820,1.760,2.690,0.208,0.201,0.145,0.282,
2.430,0.260,1.530,2.380,2.250,2.780,2.100,3.350,3.120,2.000,
1.800,2.890,3.280,2.420,1.930,3.360,3.440,0.314,2.410,3.290,
3.300,2.600,3.160,5.050,9.040,3.570,2.910,5.050,3.320,2.050,
2.240,2.420,4.050,0.355,1.870,3.250,4.620,2.990,2.560,6.160,
5.440,2.890,1.850,3.110,3.240,2.180,1.690,2.190,2.830,0.173,
1.610,2.700,3.110,2.490,2.010,4.060,4.070,3.220,2.240,3.740,
0.261,0.196,0.144,0.283,2.930,0.211,1.880,2.780,3.370,3.750,
2.840,4.520,6.650,3.120,2.850,6.160,4.380,3.150,2.650,3.970,
4.920,0.294,3.350,5.290,7.740,4.660,5.190,8.160,35.5,10.1,
17.6,15.6,8.980,5.000,4.970,5.640,20.9,1.000,4.490,5.770,
11.9,8.600,5.090,9.230,7.880,4.110,3.270,4.460,4.420,2.350,
2.460,2.920,4.840,0.319,2.340,2.880,3.930,3.060,2.580,4.250,
9.260,5.330,3.460,4.840,0.553,0.371,0.313,0.608,4.060,0.333,
2.750,3.120,3.490,3.600,3.180,4.710,8.590,3.990,3.550,6.460,
5.700,3.490,3.150,4.860,4.170,0.321,2.870,3.910,5.870,3.500,
4.230,8.320,14.6,6.530,4.790,7.360,6.630,4.030,3.210,3.700,
5.950,0.516,2.380,4.230,4.690,4.430,2.480,5.040,6.490,3.610,
2.130,3.290,3.620,1.520,1.910,2.450,3.970,0.301,1.980,2.810,
2.760,2.490,1.540,2.800,5.500,4.320,2.720,4.600,0.397,0.286,
0.254,0.450,3.600,0.363,2.160,3.210,2.680,3.390,2.480,3.700,
4.950,2.710,2.060,4.260,4.090,2.830,2.340,3.620,3.000,0.239,
1.790,3.030,3.120,2.650,2.610,5.470,10.6,4.040,3.420,5.260,
6.720,3.940,3.630,4.250,9.290,0.798,2.510,3.790,5.700,4.440,
3.240,6.530,0.768,0.488,0.315,0.496,0.574,0.439,0.398,0.465,
0.603,0.076,0.296,0.426,0.685,0.771,0.423,0.749,3.860,2.860,
2.660,3.240,0.376,0.256,0.359,0.485,2.690,0.287,1.430,2.100,
2.390,2.850,2.300,2.890,3.930,2.210,2.020,3.240,5.060,3.360,
3.190,4.410,3.420,0.310,2.000,3.100,3.970,3.270,3.380,5.790,
10.4,3.850,3.160,6.230,4.170,2.460,2.190,3.110,6.310,0.642,
2.230,3.630,6.740,4.460,3.030,7.430,6.520,3.480,2.620,3.850,
4.090,2.550,2.530,2.950,4.130,0.302,2.140,3.320,4.660,3.050,
2.630,5.110,4.550,3.720,3.280,4.410,0.379,0.257,0.281,0.483,
3.290,0.268,2.060,3.140,3.420,3.820,3.140,4.830,7.240,3.550,
3.090,6.280,4.120,2.600,2.650,4.120,5.980,0.399,3.330,5.410,
10.4,6.520,6.790,14.9,1.520,0.759,0.712,0.850,0.755,0.539,
0.398,0.531,0.738,0.084,0.244,0.406,0.666,0.687,0.363,0.596,
0.708,0.476,0.337,0.463,0.523,0.360,0.374,0.410,0.366,0.047,
0.241,0.296,0.306,0.324,0.249,0.404,0.513,0.422,0.281,0.408,
0.066,0.051,0.043,0.066,0.309,0.034,0.210,0.262,0.247,0.332,
0.251,0.424,0.546,0.287,0.274,0.470,0.527,0.387,0.342,0.480,
0.394,0.041,0.325,0.372,0.453,0.324,0.456,0.689,0.968,0.604,
0.344,0.599,0.593,0.557,0.319,0.462,0.418,0.061,0.196,0.455,
0.327,0.362,0.210,0.375,0.660,0.488,0.247,0.380,0.503,0.307,
0.317,0.434,0.388,0.056,0.224,0.315,0.232,0.272,0.196,0.291,
0.423,0.435,0.282,0.377,0.052,0.060,0.064,0.056,0.368,0.073,
0.239,0.286,0.207,0.330,0.248,0.336,0.395,0.256,0.198,0.368,
0.411,0.356,0.307,0.354,0.279,0.032,0.179,0.286,0.276,0.243,
0.236,0.471,0.746,0.368,0.264,0.373,0.569,0.447,0.403,0.389,
0.530,0.077,0.272,0.277,0.346,0.369,0.284,0.447,0.054,0.057,
0.033,0.043,0.060,0.070,0.070,0.058,0.055,0.028,0.054,0.049,
0.046,0.070,0.045,0.054,0.369,0.366,0.316,0.383,0.054,0.072,
0.074,0.088,0.332,0.062,0.223,0.271,0.229,0.398,0.295,0.344,
0.385,0.217,0.222,0.336,0.521,0.462,0.411,0.492,0.353,0.046,
0.275,0.338,0.346,0.353,0.365,0.592,0.990,0.606,0.405,0.699,
0.514,0.362,0.296,0.398,0.560,0.065,0.244,0.378,0.649,0.563,
0.419,0.910,0.894,0.579,0.414,0.603,0.676,0.557,0.517,0.605,
0.569,0.061,0.338,0.514,0.614,0.724,0.450,0.782,0.517,0.475,
0.390,0.525,0.049,0.051,0.039,0.070,0.435,0.048,0.320,0.410,
0.399,0.497,0.431,0.622,0.819,0.441,0.358,0.675,0.521,0.401,
0.338,0.470,0.633,0.056,0.422,0.640,0.948,0.750,0.748,1.450,
9.880,4.660,4.640,5.730,4.400,3.170,2.240,2.810,3.940,0.371,
2.250,2.570,3.390,2.850,1.960,3.240,5.370,3.270,2.310,2.730,
3.630,2.170,2.110,2.100,3.070,0.309,2.450,2.440,2.370,2.470,
1.790,2.610,5.220,4.560,2.780,3.890,0.496,0.425,0.310,0.602,
3.350,0.372,1.910,2.400,2.200,3.560,1.920,3.160,4.010,2.400,
1.950,5.500,3.190,2.400,1.940,3.000,3.540,0.301,2.150,2.930,
3.030,2.260,2.700,5.040,0.623,0.449,0.264,0.445,0.466,0.619,
0.237,0.305,0.285,0.042,0.158,0.221,0.228,0.260,0.153,0.288,
0.390,0.271,0.167,0.190,0.324,0.229,0.198,0.208,0.258,0.046,
0.202,0.206,0.185,0.178,0.141,0.197,0.371,0.377,0.209,0.318,
0.045,0.062,0.050,0.067,0.269,0.056,0.242,0.262,0.173,0.286,
0.210,0.290,0.463,0.263,0.194,0.542,0.405,0.399,0.246,0.428,
0.338,0.036,0.207,0.347,0.278,0.226,0.252,0.468,5.730,2.990,
2.180,2.330,3.900,3.450,2.700,2.550,3.880,0.477,1.910,2.400,
2.300,2.230,2.090,2.760,0.363,0.339,0.189,0.217,0.287,0.374,
0.256,0.230,0.268,0.064,0.220,0.218,0.227,0.304,0.292,0.259,
3.500,2.790,2.320,3.430,0.322,0.288,0.311,1.070,2.090,0.303,
0.725,1.170,1.320,2.000,1.490,1.940,2.620,1.570,1.440,2.040,
2.780,2.390,2.080,3.380,2.560,0.260,1.820,2.160,1.860,1.800,
2.130,2.810,4.660,2.350,1.760,2.690,2.910,1.950,1.210,1.500,
2.680,0.283,1.380,2.000,2.360,2.010,1.370,2.770,4.180,2.670,
1.850,2.090,3.060,2.450,2.020,1.720,3.190,0.276,1.940,2.350,
2.550,2.510,1.840,2.660,3.350,3.330,2.170,3.040,0.282,0.287,
0.207,0.443,2.570,0.332,1.820,2.220,2.110,2.920,2.250,3.480,
3.060,1.810,1.640,2.420,2.570,2.040,1.610,2.260,3.090,0.250,
2.350,2.640,3.270,2.760,3.000,4.450,10.000,4.290,3.550,5.820,
4.030,2.500,1.960,2.660,3.760,0.325,1.500,2.340,4.820,2.990,
1.980,4.320,5.890,2.460,1.940,2.680,2.540,1.340,1.350,1.770,
2.100,0.143,1.500,1.910,2.160,1.510,1.220,2.370,4.670,3.520,
1.990,3.390,0.316,0.248,0.185,0.416,2.770,0.226,1.390,2.280,
2.500,2.580,1.870,3.350,6.030,2.870,2.630,4.800,3.440,2.300,
2.050,3.150,3.280,0.274,1.780,2.880,4.350,2.650,3.270,6.970,
9.190,5.440,3.090,5.360,5.320,6.780,2.370,3.430,3.920,0.320,
1.850,2.830,3.510,3.090,1.860,3.870,5.980,3.290,2.180,3.300,
3.350,2.360,1.880,2.620,2.930,0.206,1.820,2.680,2.350,1.920,
1.410,2.560,3.950,3.610,2.130,3.470,0.280,0.275,0.184,0.342,
3.060,0.285,1.970,3.010,2.570,3.470,2.580,4.100,4.790,2.630,
2.200,3.890,3.920,3.130,2.100,3.470,3.670,0.260,2.040,3.420,
3.430,2.680,2.940,5.460,5.830,3.290,2.630,3.400,4.230,3.070,
2.570,3.440,3.600,0.399,1.920,3.310,3.150,2.950,2.490,4.530,
0.405,0.317,0.209,0.296,0.292,0.322,0.259,0.314,0.221,0.036,
0.204,0.265,0.289,0.386,0.216,0.341,3.370,3.290,2.220,3.690,
0.302,0.326,0.350,0.845,2.790,0.461,1.690,2.400,2.660,5.350,
2.320,3.400,3.460,2.270,2.060,2.880,3.690,2.970,2.700,4.170,
3.500,0.273,2.510,3.430,3.560,3.080,3.640,5.040,7.150,2.970,
2.580,4.340,3.130,1.870,1.990,2.390,3.960,0.433,1.790,3.020,
3.110,2.330,1.860,4.620,4.840,2.770,1.890,2.810,3.170,2.170,
1.930,2.240,2.610,0.181,1.890,2.770,2.890,2.340,1.920,3.440,
4.340,4.070,2.560,4.130,0.308,0.281,0.228,0.448,3.520,0.297,
2.560,3.620,3.620,4.270,3.230,4.670,6.420,3.120,2.800,5.780,
3.880,2.990,2.610,4.040,4.770,0.302,3.540,5.650,6.990,4.460,
5.080,9.200,41.1,15.4,13.4,33.1,12.3,6.700,6.400,9.220,
13.3,1.060,5.150,8.870,34.9,15.6,8.160,18.0,11.2,5.240,
4.460,6.750,5.430,2.690,3.020,3.740,6.290,0.355,3.550,4.000,
6.920,4.630,3.280,6.300,9.070,5.610,4.240,7.700,0.690,0.384,
0.356,0.833,5.030,0.357,2.560,3.850,5.940,5.090,3.710,7.660,
19.7,6.770,6.570,12.8,8.940,4.830,4.800,8.120,7.380,0.508,
3.900,6.960,12.7,7.210,7.300,19.2,15.0,5.910,4.110,7.810,
6.230,3.060,2.430,3.350,5.170,0.394,2.010,3.510,5.770,4.300,
2.460,5.610,6.510,2.990,1.920,3.280,3.140,1.400,1.400,2.010,
3.500,0.191,1.650,2.350,3.160,2.210,1.500,2.870,5.420,3.430,
2.570,4.470,0.331,0.198,0.172,0.342,4.100,0.375,1.660,2.710,
3.740,3.720,2.340,3.960,5.970,2.800,2.440,4.710,3.680,2.200,
2.120,3.200,3.440,0.213,1.690,3.120,4.230,3.250,2.860,6.960,
17.8,4.810,3.920,7.380,7.660,3.660,3.370,5.800,7.630,0.685,
2.170,4.010,9.920,6.020,3.570,9.720,1.070,0.444,0.341,0.629,
0.577,0.344,0.344,0.534,0.563,0.047,0.251,0.432,1.160,0.869,
0.424,1.020,4.790,3.060,3.220,4.710,0.389,0.214,0.257,0.489,
3.190,0.279,1.340,2.280,4.140,3.470,2.330,4.090,5.510,3.080,
2.990,5.260,5.100,3.080,3.040,5.030,4.040,0.313,2.140,3.630,
6.160,4.540,4.100,8.470,19.0,6.230,5.070,11.6,6.480,3.240,
3.040,5.040,9.540,0.701,3.300,5.840,20.2,8.920,5.750,16.7,
9.280,4.490,3.710,5.660,4.830,2.830,2.850,3.810,5.870,0.327,
2.900,4.580,9.400,6.210,4.010,8.400,7.010,4.840,4.400,5.970,
0.476,0.281,0.290,0.486,5.460,0.324,2.850,4.410,6.300,6.120,
4.550,8.110,13.9,6.390,5.600,11.6,7.070,4.200,4.080,6.590,
9.420,0.576,4.930,8.760,20.1,14.2,11.4,29.0,19.9,9.270,
6.690,13.7,9.300,5.250,4.040,5.860,7.350,0.642,2.600,4.950,
9.620,8.520,4.030,8.790,9.870,5.130,3.690,6.970,5.950,3.110,
3.210,4.050,4.400,0.327,2.440,3.570,4.190,3.630,2.590,5.570,
6.680,5.240,3.350,5.650,0.524,0.346,0.256,0.525,3.960,0.325,
2.040,3.160,3.710,4.020,2.780,5.600,7.590,3.740,3.600,6.050,
5.730,3.630,3.220,4.690,4.480,0.338,2.580,4.000,5.730,3.670,
3.860,8.690,13.0,6.150,3.400,7.660,6.490,3.670,2.510,3.550,
4.400,0.349,1.740,3.760,4.570,3.730,2.210,4.810,6.700,4.060,
2.150,4.070,4.750,2.200,2.020,2.580,3.880,0.265,1.650,2.580,
2.740,2.410,1.640,2.880,5.100,4.380,2.590,4.270,0.369,0.311,
0.235,0.334,4.050,0.366,1.760,2.650,3.010,3.400,2.230,4.220,
4.800,3.060,2.390,4.070,3.880,2.830,2.710,2.930,2.950,0.193,
1.520,2.560,3.620,2.570,2.280,5.000,11.6,4.290,3.050,5.590,
6.470,3.480,3.090,4.330,5.120,0.533,1.920,2.990,5.570,4.350,
2.970,6.740,0.470,0.307,0.195,0.358,0.339,0.279,0.240,0.319,
0.278,0.043,0.166,0.254,0.471,0.440,0.240,0.468,4.710,3.870,
3.210,4.430,0.359,0.293,0.248,0.410,3.860,0.334,1.870,2.700,
3.370,3.780,2.740,4.530,5.300,2.700,2.880,4.540,5.210,3.980,
3.220,4.370,4.580,0.331,2.410,3.590,5.080,3.760,3.920,7.850,
12.8,5.190,3.740,7.810,5.010,2.880,2.590,3.850,5.800,0.440,
2.390,3.960,8.410,5.260,3.830,10.1,7.660,4.370,3.400,5.630,
4.650,3.440,3.400,4.530,4.310,0.323,2.380,3.940,5.730,5.290,
3.470,6.910,5.970,4.770,3.980,5.740,0.359,0.268,0.214,0.386,
5.080,0.325,2.750,3.970,4.830,4.730,3.830,6.650,9.520,4.580,
4.010,7.150,5.480,3.860,3.040,4.080,6.670,0.418,3.560,6.720,
10.3,7.430,6.660,13.6,10.4,5.720,4.240,7.800,5.610,3.790,
2.490,3.740,5.320,0.421,2.230,3.800,6.890,4.890,3.020,5.820,
7.570,4.490,2.690,4.300,4.280,2.570,2.100,2.700,3.980,0.336,
2.710,3.260,4.610,3.930,2.450,4.510,5.460,4.520,3.050,5.110,
0.460,0.371,0.296,0.634,3.450,0.327,2.090,3.290,3.110,4.070,
2.500,5.080,5.660,3.190,2.960,5.610,4.060,2.870,2.510,4.290,
4.060,0.320,2.400,4.300,4.950,3.580,4.020,8.640,0.658,0.439,
0.256,0.535,0.491,0.428,0.245,0.341,0.382,0.041,0.187,0.291,
0.406,0.389,0.238,0.464,0.443,0.296,0.166,0.283,0.321,0.272,
0.191,0.246,0.299,0.030,0.223,0.270,0.300,0.267,0.172,0.292,
0.328,0.319,0.212,0.326,0.029,0.035,0.048,0.043,0.339,0.043,
0.211,0.310,0.259,0.361,0.244,0.533,0.490,0.294,0.228,0.534,
0.395,0.363,0.280,0.463,0.341,0.032,0.213,0.354,0.390,0.326,
0.337,0.679,7.060,3.560,2.540,3.520,4.270,3.290,2.780,3.200,
4.080,0.477,1.900,2.730,3.470,3.190,2.590,4.310,0.400,0.292,
0.153,0.236,0.231,0.227,0.163,0.177,0.237,0.037,0.173,0.195,
0.342,0.353,0.215,0.314,3.670,3.890,2.480,3.300,0.268,0.274,
0.201,0.394,2.770,0.294,1.300,1.980,2.050,2.850,2.030,3.120,
3.970,2.560,2.100,2.960,3.490,3.150,2.480,3.440,3.550,0.286,
2.320,3.130,3.160,2.800,3.080,5.060,6.760,3.380,2.410,4.280,
3.690,2.430,1.730,2.370,3.670,0.330,2.050,3.160,4.430,3.140,
2.370,5.270,6.540,3.630,2.490,3.750,3.680,2.740,2.260,2.330,
3.690,0.268,2.400,3.370,4.280,3.860,2.790,4.800,4.760,4.510,
3.000,5.190,0.302,0.287,0.198,0.372,3.780,0.282,2.430,3.190,
3.580,4.220,3.490,5.150,5.470,3.040,2.800,4.170,3.650,2.870,
2.270,3.140,4.820,0.325,3.340,3.950,5.640,5.060,4.710,7.610,
25.2,7.570,6.360,13.7,7.270,3.910,3.130,5.310,6.940,0.507,
3.560,5.810,9.890,6.320,4.240,11.0,8.650,3.780,2.760,4.750,
3.850,2.110,2.360,3.080,4.280,0.454,7.870,6.670,4.380,3.030,
2.670,5.130,6.700,4.790,3.090,6.540,0.415,0.339,0.250,0.645,
4.140,0.321,3.070,4.130,4.300,3.950,3.070,6.630,11.1,5.150,
5.070,11.4,5.860,3.510,3.340,6.690,5.600,0.374,3.880,7.180,
9.610,5.770,6.360,18.9,9.150,4.580,2.920,5.790,4.950,3.520,
1.990,3.120,4.180,0.261,1.770,2.920,4.560,3.220,2.210,4.980,
5.680,2.950,1.830,3.160,2.990,2.030,1.520,2.200,3.040,0.174,
2.010,2.660,3.080,2.150,1.470,2.990,4.070,2.980,1.960,3.970,
0.212,0.182,0.139,0.285,3.270,0.260,1.900,3.040,3.290,3.550,
2.380,5.010,5.510,2.950,2.680,5.790,4.090,2.970,2.290,4.340,
3.780,0.223,2.300,3.870,4.750,3.380,3.570,8.130,9.960,4.890,
4.140,5.600,6.130,3.850,3.310,5.210,5.690,0.513,2.650,4.290,
6.270,4.490,3.540,7.180,0.491,0.359,0.221,0.355,0.308,0.253,
0.196,0.287,0.261,0.027,0.229,0.287,0.490,0.394,0.226,0.463,
5.300,4.500,3.100,4.720,0.294,0.255,0.192,0.427,3.860,0.321,
2.040,3.350,4.110,4.520,3.240,5.490,6.580,4.190,3.640,5.300,
5.750,4.160,3.520,5.700,5.430,0.347,3.360,5.290,5.890,4.110,
4.910,8.360,19.3,6.020,4.970,9.190,5.860,3.360,3.190,4.500,
6.390,0.406,3.210,5.290,9.530,5.410,4.620,12.9,8.320,4.560,
3.000,5.010,5.110,3.850,2.620,3.480,4.780,0.269,2.740,4.280,
5.680,4.390,3.200,7.080,7.990,6.130,4.080,6.870,0.345,0.277,
0.182,0.412,5.780,0.343,3.930,5.630,6.530,6.400,5.130,8.560,
17.5,6.750,5.680,12.6,7.060,4.820,4.050,7.400,8.210,0.425,
5.350,9.770,13.7,7.240,7.230,17.2,38.0,17.1,10.2,18.5,
19.0,8.410,6.280,7.580,14.3,1.360,5.450,8.470,17.7,13.4,
7.140,11.8,23.2,9.210,4.620,6.340,9.100,5.100,3.660,3.870,
7.040,0.574,3.370,4.420,5.680,5.130,3.320,5.210,10.1,7.270,
4.560,6.650,0.834,0.649,0.456,0.851,5.260,0.498,2.640,3.490,
5.170,6.530,3.670,5.390,14.9,6.620,5.870,9.810,9.200,6.040,
4.940,7.510,6.970,0.577,3.410,5.530,8.950,5.860,5.160,8.770,
17.2,7.220,3.190,5.960,8.120,5.190,3.130,3.590,6.670,0.609,
2.020,3.220,5.200,4.130,1.960,3.480,9.640,4.700,2.110,3.010,
4.850,3.050,2.060,2.060,4.570,0.432,2.070,2.880,2.980,3.140,
1.630,2.300,5.330,4.820,2.320,3.400,0.416,0.384,0.234,0.335,
4.700,0.461,2.000,2.690,2.760,3.890,2.280,3.090,4.780,2.960,
1.830,3.160,4.130,3.070,1.820,2.650,4.100,0.334,1.850,2.920,
3.710,2.980,2.510,4.620,9.240,4.140,2.560,4.120,5.760,3.190,
2.980,3.220,4.840,0.580,1.810,3.240,4.120,3.870,2.480,5.140,
0.738,0.482,0.233,0.369,0.418,0.339,0.274,0.278,0.384,0.065,
0.235,0.363,0.467,0.628,0.296,0.549,3.400,2.900,2.140,2.330,
0.313,0.235,0.206,0.288,2.490,0.276,1.270,1.880,1.880,2.460,
1.600,2.200,3.670,2.310,1.870,2.720,3.970,2.770,2.180,3.040,
3.570,0.344,1.830,3.200,3.190,3.090,2.780,4.450,11.6,4.360,
3.010,6.320,4.350,2.360,2.240,2.870,4.850,0.415,1.710,3.040,
6.180,4.320,2.910,6.960,8.660,5.060,2.930,4.120,4.400,2.940,
2.600,2.670,4.000,0.321,2.240,3.220,4.240,4.320,2.760,4.890,
4.520,3.520,2.850,3.380,0.345,0.273,0.462,0.350,2.930,0.258,
1.690,2.620,2.710,3.390,2.460,3.480,6.200,3.420,2.770,5.330,
3.580,2.640,2.370,3.260,4.830,0.376,2.710,4.550,5.860,4.820,
4.460,8.240,16.4,10.2,5.120,8.740,8.210,5.740,3.660,4.140,
5.110,0.547,2.020,3.400,5.600,5.270,2.910,5.020,10.000,9.460,
3.320,4.160,5.450,3.910,2.680,2.650,3.420,0.421,1.880,2.680,
2.730,3.120,1.850,2.950,4.940,5.150,2.730,3.510,0.468,0.566,
0.299,0.439,2.610,0.306,1.700,2.030,2.310,3.420,1.970,3.100,
4.860,2.810,2.230,3.590,4.590,3.930,2.380,3.100,2.840,0.358,
1.800,2.490,3.730,2.820,2.520,5.130,9.390,7.040,2.540,3.870,
5.510,5.030,2.330,2.350,3.340,0.424,1.360,2.040,2.600,2.990,
1.600,2.630,5.390,4.710,1.720,2.070,3.170,1.760,1.700,1.470,
2.650,0.376,1.480,1.920,1.720,2.280,1.290,1.690,3.620,4.490,
1.860,2.420,0.370,0.529,0.255,0.276,2.960,0.505,1.600,2.100,
1.760,3.710,1.700,2.550,2.990,2.310,1.170,1.940,3.290,3.160,
1.360,1.720,2.410,0.270,1.280,1.690,2.220,2.150,1.450,3.430,
5.790,3.600,1.790,2.720,4.250,3.260,2.440,2.420,2.970,0.412,
1.350,2.020,2.130,2.710,1.820,2.920,0.689,0.587,0.179,0.236,
0.267,0.336,0.226,0.191,0.231,0.076,0.197,0.248,0.211,0.382,
0.199,0.273,2.860,3.080,1.970,2.170,0.290,0.350,0.248,0.264,
2.280,0.364,1.380,2.000,1.450,2.680,1.660,2.100,2.780,1.680,
1.400,2.180,3.130,3.130,2.070,2.640,2.680,0.297,1.790,2.740,
2.070,2.250,2.310,3.470,4.800,2.610,1.640,2.760,2.840,1.810,
1.290,1.610,2.240,0.210,0.872,1.440,2.480,2.030,1.340,2.810,
4.390,3.440,1.760,2.240,2.580,2.410,1.580,1.790,1.740,0.189,
1.170,1.740,1.740,2.440,1.390,2.580,2.850,2.600,1.810,2.180,
0.207,0.225,0.156,0.198,1.950,0.216,1.230,1.820,1.640,2.330,
1.690,2.320,3.580,1.910,1.570,2.530,2.610,2.260,1.450,2.160,
3.000,0.355,1.800,2.970,3.530,3.540,2.790,5.090,9.200,5.870,
3.440,6.030,4.380,3.480,2.220,2.640,3.480,0.411,1.710,2.530,
3.810,3.810,2.040,3.990,7.170,5.520,3.240,3.720,4.210,3.200,
2.510,2.370,3.910,0.457,2.190,2.700,2.920,3.810,2.070,3.120,
4.470,4.670,2.810,4.030,0.454,0.486,0.316,0.540,2.680,0.337,
1.270,1.850,2.080,3.380,1.720,2.830,4.340,2.670,2.830,3.510,
3.650,3.000,2.060,2.580,3.010,0.299,1.670,2.660,3.710,2.840,
2.880,6.680,0.612,0.534,0.214,0.375,0.462,0.484,0.260,0.268,
0.389,0.086,0.197,0.275,0.288,0.433,0.194,0.322,0.550,0.629,
0.216,0.291,0.453,0.531,0.301,0.278,0.413,0.090,0.299,0.305,
0.263,0.454,0.213,0.270,0.321,0.425,0.205,0.273,0.048,0.086,
0.053,0.045,0.344,0.087,0.227,0.244,0.220,0.482,0.232,0.291,
0.429,0.302,0.217,0.355,0.539,0.528,0.354,0.403,0.360,0.056,
0.233,0.325,0.388,0.330,0.330,0.613,3.630,2.490,1.640,1.880,
2.620,2.120,3.380,1.840,2.790,0.466,1.560,1.680,1.670,2.230,
1.780,2.200,0.303,0.335,0.145,0.166,0.204,0.242,0.211,0.123,
0.252,0.057,0.155,0.176,0.208,0.382,0.212,0.229,2.300,2.730,
1.490,1.610,0.233,0.270,0.233,0.206,2.620,0.436,1.130,1.410,
1.610,3.540,1.610,1.760,2.320,1.570,1.160,1.390,2.410,2.250,
1.530,1.680,2.520,0.325,1.320,1.920,1.700,2.290,1.720,2.550,
3.700,1.960,1.220,2.140,2.180,1.300,1.120,1.180,2.320,0.235,
0.918,1.420,2.180,1.800,1.290,2.590,4.410,3.240,1.880,2.210,
2.770,2.380,1.670,1.570,2.570,0.283,1.490,2.010,2.170,2.690,
1.940,2.520,2.870,2.910,1.560,2.010,0.256,0.318,0.183,0.225,
2.980,0.629,1.260,1.850,1.800,3.230,1.620,2.330,3.580,1.940,
1.650,2.020,2.760,2.390,1.550,2.110,3.400,0.352,2.040,2.940,
3.200,3.170,2.790,4.630,9.960,4.970,3.500,7.300,3.650,2.540,
1.890,2.410,3.560,0.368,1.490,2.790,5.150,3.980,2.450,5.940,
4.190,2.620,1.610,2.650,2.270,1.480,1.200,1.440,2.220,0.209,
1.060,1.770,2.160,1.880,1.240,2.290,4.110,3.460,1.990,3.480,
0.380,0.357,0.210,0.461,2.300,0.212,1.010,1.770,2.220,2.450,
1.680,3.030,4.790,2.370,2.430,4.770,3.000,2.220,1.730,2.800,
2.700,0.210,1.550,2.610,4.120,2.650,3.190,8.090,7.380,4.730,
2.420,4.430,4.650,3.610,1.950,2.550,3.710,0.403,1.610,2.720,
3.300,3.510,1.820,3.390,4.850,4.030,1.550,2.740,3.250,2.820,
1.590,1.830,3.480,0.564,1.840,2.700,2.460,2.980,1.440,2.280,
2.960,2.940,1.450,2.490,0.238,0.273,0.158,0.242,2.880,0.300,
1.550,2.100,2.250,3.100,2.200,2.900,3.360,2.140,1.580,2.930,
3.200,2.780,1.790,2.660,3.040,0.220,1.750,2.480,3.280,2.450,
2.560,4.720,3.960,3.130,1.690,2.500,3.240,2.070,1.690,2.190,
3.340,0.551,1.370,2.450,2.330,2.610,1.790,3.090,0.280,0.318,
0.139,0.222,0.183,0.209,0.133,0.153,0.395,0.182,0.168,0.350,
0.235,0.491,0.154,0.281,2.120,2.080,1.270,1.660,0.181,0.167,
0.143,0.187,1.900,0.227,1.040,1.610,1.410,2.120,1.350,2.060,
2.380,1.720,1.240,1.850,2.800,2.300,1.540,2.250,2.670,0.288,
1.340,2.600,2.040,2.040,1.780,3.270,6.400,2.760,1.890,3.640,
2.800,1.680,1.420,1.760,2.910,0.250,1.080,2.030,3.890,2.620,
1.930,4.630,3.260,2.170,1.200,2.020,2.050,1.500,1.130,1.440,
2.110,0.263,1.170,2.270,2.020,2.180,1.390,2.790,3.230,2.810,
1.700,2.880,0.227,0.202,0.131,0.246,2.790,0.250,1.480,2.480,
2.550,3.190,2.120,3.410,5.300,2.770,2.240,4.740,3.590,3.000,
1.960,3.240,4.440,0.273,2.620,4.820,6.130,4.170,4.420,8.580,
16.1,9.460,6.270,10.1,10.3,6.640,3.850,4.510,7.350,0.821,
3.080,5.200,8.920,7.240,4.040,6.940,10.8,7.040,3.550,4.290,
9.800,5.250,3.140,3.070,4.760,0.514,2.940,3.510,3.460,3.890,
2.490,3.630,4.530,3.800,2.590,3.440,0.481,0.387,0.344,0.457,
2.730,0.293,1.480,1.790,2.450,3.190,2.280,3.250,5.590,2.870,
2.390,4.400,5.140,3.380,2.650,3.500,3.160,0.337,1.950,2.930,
3.930,3.030,3.050,5.480,10.000,6.010,2.640,4.270,6.830,4.800,
2.360,2.750,4.280,0.550,1.910,2.720,3.390,3.650,1.630,3.260,
6.490,5.330,1.820,2.500,4.900,3.200,1.990,2.010,3.710,0.556,
2.230,2.900,2.280,3.160,1.440,2.100,2.930,3.480,1.670,2.210,
0.326,0.390,0.246,0.302,2.750,0.437,1.770,1.970,1.830,3.230,
2.090,2.510,2.390,1.710,0.971,1.760,2.570,2.300,1.160,1.770,
2.290,0.237,1.360,2.000,2.090,2.060,1.790,3.320,4.890,2.760,
1.530,2.490,4.150,3.010,2.110,2.490,3.770,0.534,1.750,2.500,
2.670,3.240,1.950,3.780,0.340,0.357,0.181,0.242,0.366,0.377,
0.261,0.254,0.315,0.080,0.240,0.313,0.261,0.531,0.249,0.383,
1.710,1.920,1.300,1.490,0.209,0.211,0.158,0.219,1.760,0.246,
1.180,1.540,1.200,1.890,1.290,1.680,1.850,1.320,0.930,1.560,
2.390,2.020,1.400,1.960,2.250,0.278,1.480,2.100,1.990,2.320,
2.010,3.260,4.950,2.250,1.430,3.220,2.360,1.400,1.070,1.570,
2.720,0.267,1.080,1.670,3.050,2.440,1.540,3.750,4.050,3.160,
1.810,2.400,3.160,2.560,1.730,2.040,2.510,0.270,1.780,2.350,
2.000,2.880,1.610,2.780,2.060,1.860,1.600,1.880,0.174,0.159,
0.233,0.205,1.590,0.177,1.130,1.640,1.450,1.990,1.420,2.070,
3.100,1.700,1.320,2.720,1.780,1.480,1.370,1.740,2.450,0.232,
1.690,2.580,3.170,2.970,2.590,5.170,8.550,5.880,3.080,5.400,
5.940,5.450,2.870,2.970,3.480,0.425,1.610,2.450,3.210,3.410,
1.750,3.320,5.770,4.990,2.170,2.740,4.440,4.440,2.420,2.220,
2.410,0.355,1.640,2.060,1.610,2.420,1.350,2.090,2.460,2.980,
1.660,2.330,0.258,0.338,0.219,0.318,1.580,0.233,1.240,1.480,
1.350,1.960,1.380,2.340,2.280,1.550,1.230,2.300,2.500,2.600,
1.480,1.960,1.610,0.195,1.550,1.650,1.920,1.680,1.640,3.080,
6.000,4.700,1.710,2.390,3.710,3.900,1.660,1.700,2.330,0.357,
1.180,1.510,1.640,2.180,0.962,1.720,3.620,2.600,1.040,1.400,
1.270,0.672,0.738,0.708,1.790,0.434,1.080,1.530,0.918,1.750,
0.895,1.230,1.940,2.980,1.250,1.610,0.253,0.554,0.226,0.255,
2.060,0.415,1.250,1.540,1.210,2.710,1.490,2.060,1.380,1.320,
0.712,1.060,1.830,2.460,0.982,1.290,1.560,0.221,1.130,1.350,
1.280,1.520,1.060,1.960,3.370,2.590,1.170,1.790,3.450,3.580,
2.070,2.060,2.310,0.378,1.230,1.750,1.550,2.100,1.540,2.440,
0.238,0.376,0.146,0.185,0.260,0.531,0.277,0.210,0.197,0.093,
0.205,0.213,0.134,0.371,0.174,0.206,1.700,2.490,1.340,1.460,
0.230,0.418,0.241,0.236,1.590,0.292,1.150,1.540,0.995,2.080,
1.400,1.750,1.470,1.120,0.878,1.290,2.280,2.830,1.730,2.010,
1.990,0.247,1.580,2.060,1.540,1.750,1.780,2.780,2.550,1.680,
0.925,1.550,1.850,1.500,0.807,1.170,1.630,0.158,0.625,0.888,
1.490,1.350,0.853,1.730,2.310,2.450,1.210,1.480,2.100,2.760,
1.340,1.480,1.340,0.203,0.957,1.280,1.030,1.860,0.995,1.570,
1.680,1.890,1.120,1.380,0.130,0.204,0.123,0.162,1.200,0.150,
1.060,1.300,1.010,1.670,1.300,1.740,1.890,1.160,0.792,1.370,
1.410,1.580,0.883,1.240,1.420,0.149,1.150,1.530,1.680,1.860,
1.690,3.110,6.200,4.800,2.460,4.240,4.130,3.350,1.780,2.500,
2.700,0.342,1.300,1.940,2.610,2.730,1.560,2.910,5.900,5.680,
2.320,3.080,5.390,3.960,3.170,2.920,3.620,0.525,2.550,2.890,
2.170,3.320,1.740,2.600,2.560,3.480,1.670,2.420,0.357,0.378,
0.245,0.468,2.150,0.318,1.100,1.540,1.490,2.670,1.320,2.190,
2.530,1.700,1.350,2.350,2.570,2.190,1.430,2.140,2.230,0.270,
1.560,2.170,2.300,2.140,2.200,4.440,0.373,0.447,0.148,0.231,
0.430,0.495,0.247,0.265,0.252,0.066,0.144,0.179,0.188,0.309,
0.148,0.246,0.388,0.608,0.189,0.227,0.662,0.683,0.633,0.535,
0.435,0.189,0.368,0.346,0.173,0.381,0.163,0.222,0.162,0.326,
0.150,0.164,0.054,0.129,0.086,0.055,0.261,0.115,0.242,0.244,
0.144,0.377,0.209,0.220,0.186,0.152,0.091,0.171,0.364,0.401,
0.212,0.267,0.216,0.054,0.199,0.242,0.175,0.211,0.203,0.337,
2.880,3.050,1.300,1.690,2.870,3.510,2.110,1.990,3.040,0.585,
1.630,1.820,1.630,2.380,1.480,2.260,0.280,0.730,0.184,0.181,
0.303,0.709,0.311,0.235,0.301,0.112,0.277,0.240,0.187,0.439,
0.210,0.234,1.620,2.830,1.300,1.370,0.246,0.397,0.209,0.216,
2.240,0.445,1.040,1.480,1.260,2.890,1.440,1.740,1.420,1.400,
0.804,1.140,2.260,2.830,1.470,1.730,2.260,0.364,1.750,2.130,
1.470,2.140,1.910,2.760,2.530,1.750,0.912,1.610,1.680,1.230,
0.715,0.960,2.100,0.220,0.806,1.310,1.650,1.530,0.892,1.980,
3.590,4.280,1.600,1.930,3.200,3.560,1.930,2.070,3.690,0.437,
2.010,2.410,1.910,3.050,1.620,2.430,1.850,2.780,1.340,1.600,
0.187,0.288,0.161,0.186,1.910,0.313,1.270,1.690,1.400,2.850,
1.490,2.090,2.020,1.600,1.070,1.810,1.800,1.930,1.160,1.530,
2.500,0.276,2.160,2.620,2.400,2.900,2.610,3.830,5.300,2.980,
1.930,3.740,2.740,1.840,1.210,1.950,2.370,0.237,0.987,1.860,
2.710,2.120,1.210,3.170,3.570,2.370,1.250,1.960,2.220,1.550,
1.140,1.520,1.660,0.159,0.882,1.380,1.420,1.350,0.836,1.660,
2.070,2.070,1.030,1.760,0.166,0.161,0.100,0.229,1.330,0.140,
0.642,1.080,1.170,1.380,0.883,1.720,2.500,1.400,1.200,2.400,
1.700,1.270,0.977,1.870,1.610,0.140,0.897,1.620,2.160,1.530,
1.520,4.000,4.380,3.390,1.510,2.430,3.090,2.760,1.530,1.890,
2.640,0.316,1.310,2.030,2.130,2.460,1.210,2.420,3.350,3.020,
1.130,1.650,3.440,2.920,1.940,2.030,2.540,0.372,1.570,2.150,
1.740,2.210,1.200,1.880,1.460,1.860,0.890,1.310,0.155,0.244,
0.139,0.202,2.070,0.260,1.110,1.440,1.470,2.390,1.400,1.910,
1.540,1.070,0.836,1.420,1.850,1.840,1.020,1.810,1.980,0.197,
1.130,1.630,1.680,1.700,1.400,2.780,2.990,2.440,1.240,1.680,
2.700,2.550,1.600,1.840,4.280,0.487,1.600,2.160,2.150,2.250,
1.600,2.590,0.193,0.282,0.104,0.140,0.183,0.325,0.157,0.158,
0.216,0.054,0.146,0.179,0.156,0.264,0.137,0.197,1.230,1.550,
0.857,1.150,0.129,0.151,0.118,0.157,1.610,0.214,0.957,1.440,
1.050,1.670,1.090,1.650,1.530,1.170,0.780,1.200,1.850,1.780,
1.200,1.760,2.260,0.292,1.400,2.170,1.650,1.830,1.830,2.810,
3.640,2.120,1.190,2.280,1.700,1.260,0.812,1.180,2.000,0.180,
0.795,1.330,2.150,1.580,1.100,2.610,2.370,2.050,0.913,1.420,
1.690,1.850,1.000,1.350,2.010,0.172,0.951,1.490,1.480,1.590,
0.995,1.960,1.710,1.690,1.040,1.840,0.128,0.130,0.090,0.171,
1.430,0.145,0.970,1.450,1.450,1.980,1.420,2.150,2.870,1.600,
1.290,2.750,2.030,1.960,1.380,2.260,2.610,0.217,1.820,3.060,
3.520,2.880,2.990,4.680,9.450,5.570,4.980,6.970,5.540,3.870,
3.170,3.430,5.790,0.543,2.100,3.150,5.890,5.030,2.800,4.800,
5.140,3.680,2.600,2.890,3.490,2.170,2.050,2.040,3.600,0.306,
1.760,2.140,2.360,2.420,2.240,2.980,3.560,3.110,1.960,2.890,
0.332,0.286,0.221,0.404,2.320,0.230,1.440,1.800,1.910,2.440,
1.760,2.830,4.140,2.250,1.890,3.400,3.400,2.650,2.050,2.870,
2.730,0.275,3.120,2.960,3.400,2.420,3.550,4.900,7.670,5.210,
2.570,4.070,5.830,4.430,2.660,2.920,3.500,0.427,1.450,1.990,
2.880,3.410,1.770,3.120,4.820,4.330,1.810,2.300,3.570,2.400,
2.100,2.030,3.420,0.441,1.590,2.200,2.000,2.760,1.430,2.020,
3.660,4.310,1.980,2.790,0.368,0.430,0.284,0.394,3.500,0.491,
2.040,2.520,2.030,3.660,2.130,2.770,2.740,1.850,1.200,2.230,
2.990,2.670,1.720,2.600,2.460,0.237,1.640,2.200,2.340,2.080,
2.020,3.870,4.300,2.470,1.420,2.590,4.170,3.070,2.350,2.810,
3.580,0.501,1.220,1.880,2.740,2.880,1.820,3.330,0.342,0.364,
0.165,0.268,0.327,0.321,0.265,0.320,0.371,0.075,0.196,0.256,
0.351,0.612,0.284,0.441,2.000,2.000,1.460,1.960,0.267,0.231,
0.240,0.325,1.800,0.268,1.050,1.310,1.630,2.160,1.400,1.900,
2.090,1.300,0.984,1.850,2.890,2.540,1.890,2.840,2.440,0.256,
1.360,1.940,2.880,2.240,2.070,4.100,4.230,2.000,1.430,2.880,
2.130,1.360,1.310,1.760,2.480,0.272,0.979,1.520,3.030,2.600,
1.520,3.620,3.220,2.730,1.480,2.140,2.250,1.780,1.780,2.070,
2.390,0.271,1.320,1.870,2.230,2.710,1.530,2.710,2.300,2.350,
1.770,2.430,0.217,0.208,0.198,0.307,2.160,0.230,1.420,2.010,
1.950,2.570,1.960,2.870,3.190,1.860,1.520,3.120,2.030,1.560,
1.640,2.400,3.450,0.308,2.530,3.400,5.050,4.050,3.940,7.070,
0.472,0.408,0.297,0.338,0.363,0.358,0.236,0.266,0.262,0.044,
0.135,0.177,0.258,0.294,0.189,0.270,0.433,0.423,0.440,0.277,
0.367,0.349,0.330,0.266,0.287,0.072,0.233,0.202,0.165,0.278,
0.227,0.223,0.205,0.284,0.176,0.202,0.030,0.053,0.043,0.042,
0.164,0.041,0.193,0.184,0.123,0.228,0.203,0.270,0.245,0.160,
0.177,0.228,0.288,0.276,0.243,0.261,0.248,0.054,1.010,0.472,
0.263,0.250,1.130,0.496,0.392,0.424,0.158,0.215,0.362,0.505,
0.256,0.201,0.204,0.055,0.135,0.149,0.143,0.230,0.155,0.172,
0.409,0.610,0.210,0.197,0.524,0.410,0.343,0.254,0.355,0.135,
0.188,0.205,0.182,0.401,0.160,0.177,0.236,0.413,0.184,0.200,
0.062,0.149,0.093,0.052,0.301,0.128,0.235,0.235,0.124,0.399,
0.222,0.232,0.181,0.167,0.101,0.155,0.260,0.317,0.165,0.190,
0.190,0.036,0.183,0.175,0.136,0.174,0.192,0.277,0.257,0.243,
0.103,0.156,0.294,0.347,0.294,0.279,0.255,0.073,0.127,0.132,
0.146,0.236,0.165,0.218,0.037,0.067,0.030,0.029,0.053,0.104,
0.096,0.060,0.060,0.061,0.058,0.044,0.024,0.079,0.042,0.038,
0.181,0.257,0.220,0.195,0.051,0.101,0.114,0.056,0.249,0.102,
0.209,0.201,0.132,0.334,0.239,0.221,0.193,0.148,0.115,0.172,
0.298,0.460,0.282,0.283,0.287,0.065,0.288,0.270,0.205,0.264,
0.273,0.359,0.290,0.259,0.146,0.222,0.196,0.172,0.134,0.176,
0.208,0.029,0.087,0.130,0.214,0.238,0.168,0.323,0.358,0.637,
0.198,0.256,0.320,0.379,0.318,0.394,0.309,0.071,0.180,0.239,
0.219,0.439,0.209,0.327,0.186,0.261,0.186,0.218,0.027,0.047,
0.038,0.035,0.239,0.048,0.202,0.254,0.172,0.328,0.240,0.289,
0.251,0.190,0.135,0.230,0.205,0.245,0.173,0.230,0.318,0.047,
0.322,0.352,0.324,0.355,0.362,0.549,5.040,3.560,2.380,3.600,
3.780,3.480,2.070,2.350,2.560,0.318,1.260,1.860,2.210,2.200,
1.530,2.450,4.300,3.620,2.490,2.480,3.870,2.900,3.170,2.370,
3.160,0.441,2.270,2.390,1.860,2.820,2.050,2.380,2.800,4.120,
2.190,2.960,0.406,0.568,0.380,0.593,3.600,0.947,1.820,2.190,
1.810,4.010,1.730,2.500,2.420,1.660,1.210,2.310,2.600,2.300,
1.710,2.410,2.560,0.346,2.040,2.610,2.360,2.190,2.480,4.100,
0.341,0.364,0.145,0.217,0.599,0.760,0.291,0.268,0.226,0.054,
0.161,0.257,0.145,0.227,0.129,0.210,0.300,0.368,0.169,0.159,
0.428,0.432,0.458,0.292,0.288,0.113,0.280,0.283,0.137,0.273,
0.165,0.161,0.193,0.431,0.175,0.192,0.056,0.177,0.091,0.069,
0.281,0.120,0.272,0.307,0.142,0.378,0.214,0.232,0.239,0.176,
0.106,0.216,0.364,0.400,0.233,0.311,0.228,0.052,0.237,0.280,
0.188,0.196,0.205,0.321,2.730,2.340,1.190,1.350,3.320,3.760,
2.710,2.040,2.230,0.484,1.490,1.710,1.330,1.930,1.590,2.010,
0.225,0.361,0.153,0.143,0.278,0.456,0.395,0.192,0.240,0.098,
0.237,0.213,0.164,0.369,0.241,0.238,2.070,2.900,1.810,1.820,
0.293,0.423,0.459,0.370,2.030,0.376,0.815,1.370,1.070,2.150,
1.750,1.930,1.700,1.250,0.950,1.180,2.240,2.720,2.050,2.090,
2.180,0.335,1.840,1.970,1.440,1.790,1.900,2.620,2.410,1.420,
1.030,1.540,1.800,1.440,0.916,1.070,1.500,0.193,0.824,1.350,
1.370,1.400,0.870,1.800,2.760,2.590,1.410,1.520,2.810,3.270,
2.350,1.700,2.260,0.321,1.650,2.040,1.750,2.540,1.550,2.050,
2.360,3.410,1.700,2.130,0.279,0.423,0.271,0.301,2.530,0.370,
1.970,2.380,1.560,2.720,1.880,2.480,1.930,1.390,1.090,1.610,
1.900,2.100,1.410,1.700,2.520,0.287,2.500,2.790,2.270,2.570,
2.520,3.470,4.470,2.410,1.750,2.970,2.440,1.730,1.280,1.690,
1.920,0.199,0.777,1.380,2.200,1.810,1.140,2.630,3.010,1.850,
1.050,1.370,1.690,0.973,0.930,1.020,1.410,0.118,0.707,1.050,
1.150,1.070,0.861,1.380,2.160,2.300,1.120,1.890,0.204,0.192,
0.131,0.252,1.690,0.186,0.846,1.350,1.390,1.740,1.210,2.060,
2.570,1.570,1.130,2.070,2.070,1.410,1.120,1.750,1.710,0.150,
1.170,1.780,2.330,1.740,1.750,3.830,4.810,3.510,1.750,2.730,
4.110,4.040,2.030,2.260,2.310,0.287,1.250,1.970,1.980,2.160,
1.230,2.360,4.190,4.030,1.490,1.920,3.380,2.570,2.070,2.060,
2.180,0.303,1.560,2.040,1.490,2.020,1.490,1.870,2.280,3.510,
1.470,2.040,0.232,0.383,0.221,0.295,2.480,0.369,1.730,2.410,
1.900,2.970,1.860,2.750,2.380,1.750,1.220,1.990,2.620,2.380,
1.770,2.570,2.330,0.230,1.570,2.260,2.190,1.960,1.790,3.540,
2.840,2.070,1.260,1.750,3.030,2.380,1.870,2.080,2.140,0.312,
1.150,1.850,1.550,1.780,1.520,2.490,0.221,0.239,0.111,0.154,
0.196,0.251,0.222,0.176,0.161,0.044,0.155,0.192,0.138,0.232,
0.158,0.211,1.940,2.270,1.620,2.100,0.223,0.256,0.599,0.342,
2.110,0.312,1.440,2.030,1.420,2.270,1.740,2.430,1.860,1.410,
1.110,1.610,2.580,2.350,2.320,2.720,2.200,0.256,1.820,2.770,
1.990,1.910,2.280,3.780,3.070,1.570,1.110,2.060,1.820,1.200,
0.988,1.380,1.810,0.185,0.801,1.360,1.970,1.540,1.300,2.690,
2.220,1.770,0.946,1.420,1.820,1.560,1.250,1.320,1.550,0.150,
0.986,1.620,1.340,1.580,1.240,1.940,2.350,2.700,1.530,2.640,
0.208,0.226,0.181,0.315,2.830,0.278,1.870,2.900,2.140,2.950,
2.110,3.040,3.060,1.840,1.460,3.060,2.420,2.200,1.850,2.690,
3.100,0.242,2.370,3.810,3.780,2.990,3.220,4.940,10.1,5.300,
4.340,9.190,4.330,2.820,2.180,2.900,4.640,0.407,1.610,3.000,
7.010,4.850,2.460,5.600,4.160,2.450,1.690,2.550,2.440,1.410,
1.200,1.500,2.450,0.184,1.210,1.590,2.500,2.220,1.480,2.720,
3.300,2.520,1.710,3.040,0.278,0.200,0.144,0.336,1.980,0.177,
0.972,1.540,2.260,2.670,1.630,3.790,4.850,2.260,2.100,4.150,
3.090,2.000,1.610,2.600,2.580,0.219,1.610,2.460,4.060,2.900,
2.600,6.510,6.590,3.430,1.910,4.020,3.520,2.080,1.280,1.830,
2.500,0.231,0.921,1.700,2.670,2.330,1.200,2.890,3.240,2.240,
1.030,1.750,1.910,1.290,0.901,1.160,2.030,0.176,0.887,1.380,
1.860,1.750,0.942,1.620,2.350,2.160,1.110,1.950,0.159,0.185,
0.093,0.171,2.080,0.347,0.849,1.320,2.190,5.000,1.230,2.100,
2.370,1.530,0.963,2.040,1.740,1.310,0.787,1.390,1.720,0.131,
0.782,1.380,2.070,1.890,1.360,3.240,4.470,2.060,1.310,2.670,
2.960,1.750,1.380,2.360,2.690,0.301,0.773,1.630,2.790,2.250,
1.300,3.400,0.257,0.182,0.100,0.201,0.195,0.148,0.118,0.186,
0.189,0.028,0.082,0.158,0.332,0.327,0.146,0.325,1.610,1.400,
1.190,1.650,0.154,0.124,0.110,0.174,1.350,0.142,0.629,0.977,
1.530,1.730,1.020,1.720,1.980,1.230,1.020,2.050,2.150,1.650,
1.170,1.930,1.930,0.170,0.878,1.540,2.580,1.880,1.690,3.590,
5.690,2.100,1.650,4.910,2.260,1.260,1.180,1.870,3.140,0.274,
0.970,1.960,4.750,2.890,1.680,4.760,2.970,1.860,1.220,2.090,
1.720,1.180,1.090,1.450,1.980,0.148,0.996,1.560,2.750,2.540,
1.490,3.050,2.260,1.820,1.400,2.180,0.156,0.126,0.111,0.184,
1.720,0.142,0.964,1.550,2.020,2.490,1.690,2.990,4.060,2.000,
1.740,3.870,2.250,1.580,1.370,2.200,3.100,0.221,1.840,3.020,
5.540,4.410,3.880,8.730,8.040,4.960,3.020,6.200,4.150,3.050,
2.020,2.830,3.140,0.331,1.240,2.190,3.560,3.340,1.750,3.890,
4.970,3.290,2.380,3.080,3.270,2.270,1.950,2.150,2.520,0.271,
1.630,1.910,1.840,2.250,1.570,2.640,2.950,3.200,1.840,3.080,
0.269,0.299,0.199,0.351,1.960,0.241,1.360,1.950,1.880,2.510,
1.780,3.670,3.080,1.950,1.730,3.020,2.850,2.460,1.790,2.520,
2.250,0.281,3.740,2.950,2.880,2.190,3.220,4.930,5.250,3.720,
1.590,3.440,3.370,2.740,1.550,1.810,2.160,0.261,1.000,1.420,
2.070,2.010,1.300,2.250,3.630,3.950,1.380,2.250,3.070,2.000,
1.560,1.690,2.500,0.354,1.140,1.610,1.630,2.170,1.240,1.780,
2.450,3.210,1.390,2.260,0.223,0.272,0.172,0.231,2.250,0.338,
1.210,1.670,1.620,2.860,1.550,2.500,2.270,1.950,1.060,2.070,
2.280,2.210,1.110,1.560,1.820,0.164,1.130,1.570,1.870,1.840,
1.440,3.020,3.160,1.910,0.980,2.060,2.510,2.120,1.480,2.410,
2.270,0.319,0.788,1.220,1.790,1.910,1.120,2.390,0.179,0.224,
0.094,0.172,0.184,0.264,0.168,0.217,0.175,0.055,0.114,0.141,
0.178,0.321,0.136,0.211,1.930,2.200,1.470,1.910,0.239,0.323,
0.190,0.247,1.910,0.280,1.030,1.500,1.620,2.440,1.380,2.160,
2.310,1.970,1.280,2.310,3.190,5.190,1.730,2.510,2.920,0.293,
1.470,2.140,2.760,2.200,2.050,4.230,3.340,1.860,1.170,2.380,
1.790,1.270,0.985,1.470,2.490,0.216,0.820,1.340,2.480,1.970,
1.210,2.950,2.890,2.740,1.380,2.230,2.080,2.100,1.660,2.270,
2.230,0.264,1.140,1.720,2.270,3.420,1.550,2.870,2.090,2.240,
1.440,2.120,0.168,0.205,0.121,0.191,2.280,0.229,1.330,2.000,
1.820,2.800,1.660,2.730,2.910,1.940,1.490,2.540,2.350,2.640,
1.350,1.960,3.160,0.267,2.060,3.280,3.600,3.360,3.060,5.670,
5.310,3.400,2.350,4.110,3.080,2.580,1.500,2.160,2.720,0.264,
1.120,1.880,2.790,2.390,1.380,2.740,4.200,3.220,1.830,2.540,
3.240,2.340,1.740,2.110,2.580,0.330,1.710,2.210,2.140,2.690,
1.650,2.630,2.950,3.350,2.320,3.490,0.302,0.337,0.244,0.532,
2.390,0.313,1.430,2.180,1.900,3.030,1.810,3.600,2.870,1.850,
1.510,2.820,2.420,1.950,1.500,2.410,2.620,0.286,1.760,2.730,
2.970,2.490,2.610,5.390,0.307,0.265,0.135,0.277,0.268,0.356,
0.133,0.185,0.191,0.029,0.098,0.158,0.167,0.210,0.124,0.248,
0.234,0.244,0.099,0.146,0.262,0.342,0.167,0.193,0.195,0.050,
0.213,0.251,0.143,0.227,0.123,0.169,0.150,0.236,0.113,0.163,
0.019,0.047,0.031,0.028,0.185,0.051,0.150,0.187,0.129,0.304,
0.145,0.266,0.224,0.160,0.098,0.230,0.249,0.257,0.156,0.229,
0.201,0.033,0.149,0.235,0.218,0.204,0.182,0.408,3.370,2.790,
1.180,1.680,2.430,2.510,1.660,1.740,2.070,0.357,1.010,1.510,
1.540,1.840,1.290,2.370,0.226,0.249,0.096,0.130,0.162,0.227,
0.138,0.121,0.159,0.042,0.122,0.156,0.166,0.269,0.160,0.212,
1.840,2.510,1.520,1.680,0.195,0.265,0.227,0.211,2.120,0.298,
0.933,1.520,1.290,2.330,1.470,2.310,2.080,1.810,1.070,1.530,
2.230,2.590,1.680,1.940,2.340,0.279,1.590,2.100,1.990,2.170,
2.000,3.240,2.990,1.730,1.110,2.000,1.840,1.350,0.951,1.200,
1.830,0.201,0.991,1.570,1.800,1.660,1.120,2.580,3.410,2.560,
1.390,1.930,2.230,2.170,1.430,1.430,2.210,0.230,1.330,2.000,
2.000,2.560,1.650,2.760,2.510,2.850,1.790,2.420,0.187,0.234,
0.275,0.216,2.490,0.253,1.780,2.340,1.880,2.790,2.030,3.030,
2.920,1.850,1.510,2.300,2.140,1.910,1.560,1.750,3.090,0.277,
2.470,3.110,3.420,3.400,2.960,4.550,8.750,3.280,2.720,5.240,
2.920,1.920,1.370,2.310,2.880,0.252,1.170,2.260,3.690,2.660,
1.640,4.330,3.540,2.050,1.140,1.900,1.960,1.260,0.998,1.470,
1.780,0.145,1.310,1.740,1.650,1.500,0.956,2.220,2.890,2.600,
1.490,2.880,0.221,0.211,0.138,0.349,1.960,0.179,1.080,1.850,
1.950,2.160,1.500,3.640,3.660,2.000,1.690,3.740,2.160,1.490,
1.280,2.430,2.290,0.180,1.450,2.710,3.500,2.460,2.460,7.260,
5.200,2.880,1.690,3.020,2.730,2.230,1.190,1.790,2.300,0.193,
0.912,1.610,2.090,1.880,1.200,2.800,3.350,2.480,1.070,1.740,
2.060,1.870,1.050,1.470,1.830,0.176,1.150,1.680,1.500,1.650,
0.984,2.020,2.260,2.590,1.000,1.890,0.130,0.181,0.086,0.162,
1.800,0.197,1.090,1.710,1.680,2.290,1.360,2.810,2.540,1.720,
1.260,2.580,2.060,1.640,1.150,2.030,2.120,0.158,1.260,2.110,
2.370,1.950,1.850,4.450,4.350,3.200,1.610,2.390,3.030,2.330,
1.670,2.370,2.750,0.350,1.230,2.130,2.450,2.350,1.770,3.450,
0.272,0.380,0.108,0.163,0.168,0.186,0.127,0.147,0.152,0.034,
0.105,0.164,0.199,0.239,0.134,0.270,2.400,2.500,1.500,2.140,
0.163,0.220,0.152,0.219,2.310,0.244,1.300,2.150,1.760,2.330,
1.900,3.110,2.770,2.420,1.530,2.470,2.920,3.070,1.910,2.860,
3.060,0.286,2.020,3.100,2.990,2.430,2.700,4.900,6.580,2.850,
1.940,4.110,2.830,1.800,1.350,2.040,3.050,0.268,1.430,2.520,
4.230,2.930,2.170,6.110,4.200,3.390,1.440,2.460,2.890,2.480,
1.480,1.980,2.520,0.206,1.580,2.750,2.560,2.680,1.760,3.730,
3.720,3.610,2.100,3.490,0.213,0.223,0.165,0.263,3.550,0.283,
2.170,4.030,3.360,3.930,3.180,5.150,6.950,3.480,2.730,6.180,
3.830,3.140,2.410,3.960,4.970,0.301,3.260,6.050,6.250,4.170,
4.280,6.920,24.8,8.900,12.2,13.3,7.790,4.280,4.810,4.860,
16.6,0.940,5.060,6.130,12.4,7.940,5.050,8.860,8.540,4.290,
3.570,4.720,4.390,2.660,2.630,2.630,5.020,0.459,2.790,3.610,
4.090,3.430,2.510,3.970,18.8,4.460,4.150,5.820,0.731,0.401,
0.356,0.676,3.970,0.307,2.300,3.470,3.740,3.310,2.550,3.800,
9.750,3.880,4.520,8.610,6.530,4.300,3.620,5.600,4.340,0.331,
2.500,3.890,6.750,3.570,3.840,7.010,7.640,3.680,2.780,3.850,
3.770,2.260,2.330,2.520,3.620,0.310,1.710,2.210,3.100,2.650,
1.830,2.870,4.270,2.550,1.760,2.310,2.190,1.330,1.350,1.340,
2.680,0.237,1.450,1.900,1.990,1.830,1.430,1.810,4.020,2.510,
1.780,2.580,0.241,0.196,0.172,0.267,2.230,0.196,1.470,1.770,
1.630,1.880,1.670,1.940,3.300,1.780,1.400,2.690,2.510,1.780,
1.320,2.180,2.330,0.165,1.260,2.150,2.680,1.780,1.960,3.330,
11.8,2.180,9.660,3.880,5.030,2.170,2.700,2.550,4.150,0.437,
1.320,2.320,3.500,3.110,1.830,3.470,0.555,0.302,0.313,0.328,
0.318,0.228,0.198,0.217,0.319,0.046,0.179,0.274,0.450,0.498,
0.245,0.419,2.930,2.370,1.900,2.030,0.231,0.189,0.176,0.240,
2.460,0.211,1.450,1.910,2.000,1.930,1.480,1.950,2.590,1.580,
1.520,2.500,2.670,2.040,1.710,2.380,2.610,0.217,1.610,2.620,
2.470,2.180,2.170,3.880,8.340,2.830,3.420,5.770,3.450,1.700,
2.090,2.260,3.590,0.310,1.550,2.490,4.540,3.180,2.470,5.700,
5.300,3.040,2.390,3.110,2.880,1.900,1.860,1.950,2.900,0.228,
1.890,2.580,3.450,2.920,2.100,3.600,2.920,2.190,1.870,2.580,
0.221,0.159,0.176,0.240,2.240,0.166,1.450,2.330,2.150,2.190,
1.790,2.720,4.200,2.490,2.390,4.630,2.350,1.580,1.640,2.490,
3.410,0.235,2.170,3.700,4.870,3.580,3.480,7.380,12.6,6.290,
5.110,7.970,5.200,3.290,3.110,3.590,4.700,0.493,2.230,3.310,
5.780,4.470,2.760,4.950,5.990,4.200,3.040,3.610,3.320,2.390,
2.580,2.270,4.070,0.781,2.340,2.800,2.800,3.540,1.950,2.810,
4.170,2.700,3.250,3.530,0.345,0.291,0.299,0.403,2.240,0.206,
1.420,1.770,2.940,2.250,1.770,2.760,4.120,1.640,2.300,3.580,
3.590,2.550,2.440,2.980,2.240,0.209,1.340,2.060,2.940,2.060,
2.310,4.680,6.150,4.090,2.150,3.220,3.340,2.480,1.750,1.970,
2.400,0.277,1.190,1.730,2.110,2.260,1.390,2.410,3.330,2.580,
1.650,1.960,1.610,0.754,1.160,1.170,2.030,0.286,1.380,1.830,
1.330,1.770,1.480,1.690,3.010,2.870,1.860,2.420,0.232,0.244,
0.228,0.299,2.050,0.296,1.410,1.540,1.390,2.200,1.520,2.040,
2.350,1.450,1.190,2.010,2.150,1.800,1.390,1.810,1.490,0.146,
0.937,1.380,1.560,1.410,1.260,2.550,5.270,3.150,2.710,3.030,
3.940,2.690,3.020,2.530,3.140,0.491,1.770,2.140,2.580,3.700,
2.250,3.280,0.332,0.354,0.226,0.275,0.259,0.260,0.247,0.212,
0.251,0.068,0.248,0.259,0.280,0.463,0.246,0.325,2.640,2.620,
2.030,2.240,0.231,0.274,0.243,0.255,1.980,0.266,1.610,2.030,
1.490,2.540,2.050,2.400,2.190,1.310,1.380,1.950,2.400,2.360,
2.090,2.380,2.080,0.224,1.750,2.460,1.760,1.940,2.170,3.530,
4.260,2.320,2.040,3.050,2.310,1.420,1.390,1.680,2.010,0.219,
1.210,1.580,2.510,2.450,1.670,3.270,3.710,2.740,2.030,2.680,
2.330,1.950,1.850,2.200,2.040,0.223,2.030,2.530,2.490,2.630,
1.930,3.130,2.150,1.780,1.710,2.230,0.162,0.143,0.135,0.195,
1.450,0.143,1.350,1.710,1.440,1.820,1.760,2.450,2.820,1.150,
1.600,2.480,1.880,1.500,1.320,1.960,2.160,0.179,1.620,2.600,
3.030,3.070,2.810,5.040,8.220,4.580,3.570,5.630,3.020,2.180,
1.930,2.300,3.380,0.339,1.570,2.330,3.630,3.240,2.060,3.870,
5.810,4.240,2.770,3.660,3.450,2.540,2.390,2.290,4.130,0.535,
2.620,2.930,3.030,3.890,2.030,2.920,4.340,3.820,6.370,4.390,
0.408,0.424,0.465,0.602,2.280,0.261,1.580,1.920,1.730,2.590,
1.830,2.840,3.840,2.330,2.790,4.030,3.190,2.900,2.310,2.760,
2.780,0.269,1.840,2.780,3.420,2.520,2.910,6.650,0.578,0.471,
0.277,0.438,0.390,0.387,0.232,0.298,0.318,0.060,0.177,0.252,
0.282,0.434,0.221,0.374,0.498,0.496,0.259,0.368,0.421,0.380,
0.284,0.266,0.458,0.123,0.297,0.345,0.319,0.751,0.227,0.316,
0.339,0.426,0.362,0.349,0.041,0.071,0.061,0.058,0.293,0.060,
0.295,0.274,0.205,0.384,0.251,0.316,0.495,0.332,0.279,0.529,
0.553,0.691,0.421,0.562,0.334,0.049,0.287,0.390,0.408,0.390,
0.359,0.746,3.730,2.330,1.600,1.850,2.190,1.940,1.880,1.620,
2.690,0.446,1.830,1.780,1.740,2.150,1.870,2.520,0.301,0.315,
0.172,0.193,0.199,0.230,0.180,0.138,0.347,0.073,0.224,0.213,
0.263,0.412,0.280,0.285,1.790,2.060,1.640,1.540,0.200,0.220,
0.215,0.194,1.770,0.223,1.090,1.230,1.080,1.590,1.480,1.540,
1.730,1.350,1.440,1.510,1.970,2.160,1.750,1.950,1.740,0.221,
1.710,1.970,1.480,1.770,1.800,2.450,3.400,1.760,1.520,2.350,
1.870,1.200,1.040,1.210,1.880,0.210,1.050,1.600,2.060,1.860,
1.310,2.760,4.340,3.060,2.100,2.820,2.760,2.490,1.820,1.780,
2.830,0.306,1.970,2.840,2.720,2.930,2.020,3.160,2.370,2.280,
1.860,2.110,0.210,0.225,0.178,0.218,1.870,0.190,1.360,1.760,
1.490,2.010,1.590,2.510,3.380,2.090,2.030,2.610,2.420,2.130,
1.590,2.270,2.810,0.323,2.180,2.960,3.400,3.750,2.930,4.860,
9.430,3.930,3.290,6.360,3.070,1.830,1.820,2.170,3.240,0.349,
1.450,2.470,4.660,3.540,2.310,5.240,3.940,2.180,1.560,2.650,
2.160,1.490,1.300,1.510,3.140,0.486,1.280,1.810,2.840,3.140,
1.330,2.370,4.250,2.690,2.780,4.070,0.435,0.284,0.283,0.579,
2.230,0.184,1.110,1.920,2.040,2.110,1.570,2.990,4.940,2.160,
2.750,6.170,3.640,2.130,2.300,3.460,2.690,0.203,1.740,2.800,
4.180,2.620,3.110,8.080,6.070,3.350,2.200,4.010,3.330,2.090,
1.640,2.170,2.800,0.331,1.400,2.190,2.630,2.810,1.660,3.220,
4.040,2.840,1.580,3.180,2.410,1.770,1.420,1.680,3.500,0.789,
1.580,2.310,2.550,3.920,1.330,2.160,3.010,2.520,1.820,2.840,
0.225,0.282,0.160,0.280,2.190,0.221,1.440,1.910,1.920,2.350,
1.730,2.650,3.660,1.900,1.900,3.750,2.660,2.220,1.780,2.380,
2.370,0.190,1.560,2.410,2.960,2.240,2.310,4.830,4.320,2.330,
2.020,2.660,3.160,1.930,1.950,2.370,3.870,0.411,1.830,2.910,
3.140,2.560,2.250,3.940,0.321,0.261,0.178,0.312,0.214,0.188,
0.162,0.188,0.288,0.047,0.202,0.284,0.358,0.401,0.221,0.385,
2.370,2.150,1.610,2.280,0.183,0.175,0.194,0.242,2.070,0.217,
1.400,2.030,1.780,2.050,1.770,2.730,2.490,1.710,1.760,2.680,
2.730,2.220,2.160,3.120,2.810,0.239,2.130,3.260,2.840,2.350,
2.540,4.840,6.810,2.770,2.450,4.390,2.640,1.700,1.940,2.020,
2.970,0.284,1.480,2.490,4.000,3.000,2.320,5.870,3.510,2.180,
1.600,2.760,2.060,1.490,1.390,1.720,2.310,0.177,1.540,2.560,
2.890,2.440,1.810,3.550,4.040,3.440,2.510,3.990,0.288,0.232,
0.189,0.357,3.330,0.234,2.010,2.980,3.250,3.330,2.910,4.700,
7.960,3.550,4.070,8.480,4.590,3.330,3.200,5.020,5.750,0.336,
4.080,6.630,10.000,6.280,7.230,12.6,1.020,0.613,0.603,0.677,
0.603,0.371,0.360,0.363,0.646,0.067,0.286,0.422,0.628,0.506,
0.351,0.471,0.618,0.435,0.343,0.354,0.445,0.301,0.319,0.245,
0.357,0.048,0.283,0.304,0.316,0.330,0.290,0.354,0.631,0.309,
0.282,0.363,0.081,0.042,0.046,0.059,0.234,0.026,0.169,0.211,
0.272,0.240,0.216,0.274,0.537,0.251,0.309,0.443,0.622,0.352,
0.318,0.386,0.294,0.031,0.236,0.282,0.371,0.253,0.314,0.456,
0.679,0.431,0.315,0.353,0.456,0.304,0.259,0.249,0.381,0.052,
0.271,0.369,0.322,0.323,0.253,0.304,0.490,0.400,0.247,0.259,
0.323,0.241,0.231,0.211,0.365,0.062,0.286,0.338,0.236,0.293,
0.253,0.253,0.315,0.281,0.185,0.235,0.047,0.040,0.039,0.033,
0.241,0.049,0.187,0.204,0.166,0.266,0.205,0.211,0.268,0.161,
0.130,0.207,0.303,0.224,0.155,0.223,0.231,0.024,0.155,0.222,
0.247,0.197,0.213,0.329,0.492,0.230,0.315,0.265,0.383,0.245,
0.240,0.235,0.308,0.051,0.170,0.205,0.223,0.275,0.196,0.321,
0.048,0.048,0.048,0.037,0.041,0.041,0.045,0.032,0.043,0.017,
0.038,0.039,0.034,0.063,0.042,0.053,0.209,0.184,0.182,0.188,
0.026,0.024,0.031,0.027,0.173,0.029,0.157,0.180,0.131,0.194,
0.179,0.195,0.188,0.116,0.129,0.180,0.240,0.200,0.194,0.237,
0.206,0.028,0.175,0.223,0.202,0.217,0.249,0.343,0.514,0.209,
0.207,0.367,0.244,0.130,0.172,0.185,0.267,0.032,0.137,0.198,
0.290,0.251,0.195,0.392,0.433,0.330,0.264,0.321,0.298,0.254,
0.248,0.248,0.288,0.035,0.237,0.316,0.263,0.315,0.243,0.390,
0.241,0.234,0.198,0.260,0.023,0.020,0.026,0.032,0.193,0.024,
0.149,0.294,0.164,0.233,0.213,0.267,0.329,0.180,0.197,0.329,
0.205,0.147,0.169,0.228,0.263,0.031,0.235,0.433,0.367,0.322,
0.366,0.615,0.696,0.485,0.365,0.505,0.430,0.344,0.312,0.323,
0.356,0.060,0.180,0.237,0.383,0.406,0.273,0.362,0.449,0.375,
0.273,0.299,0.329,0.304,0.384,0.260,0.291,0.065,0.250,0.262,
0.191,0.279,0.287,0.273,0.270,0.260,0.226,0.239,0.037,0.040,
0.042,0.041,0.172,0.028,0.128,0.137,0.393,0.189,0.185,0.215,
0.282,0.137,0.160,0.234,0.289,0.233,0.204,0.219,0.180,0.022,
0.141,0.161,0.224,0.169,0.207,0.303,0.547,0.445,0.238,0.336,
0.399,0.386,0.241,0.238,0.256,0.045,0.162,0.192,0.203,0.254,
0.166,0.273,0.421,0.418,0.223,0.263,0.260,0.145,0.234,0.205,
0.273,0.084,0.254,0.301,0.154,0.281,0.227,0.315,0.283,0.339,
0.201,0.223,0.037,0.061,0.052,0.044,0.229,0.059,0.173,0.176,
0.140,0.271,0.193,0.240,0.186,0.138,0.134,0.167,0.204,0.220,
0.160,0.187,0.164,0.026,0.137,0.171,0.148,0.160,0.149,0.250,
0.379,0.255,0.189,0.220,0.346,0.303,0.323,0.242,0.290,0.071,
0.185,0.202,0.184,0.290,0.222,0.293,0.037,0.057,0.037,0.034,
0.040,0.073,0.079,0.039,0.060,0.038,0.058,0.047,0.025,0.082,
0.040,0.039,0.230,0.263,0.222,0.212,0.036,0.074,0.067,0.039,
0.196,0.047,0.227,0.201,0.127,0.226,0.246,0.225,0.175,0.104,
0.128,0.152,0.219,0.257,0.258,0.232,0.215,0.038,0.219,0.230,
0.154,0.187,0.254,0.314,0.323,0.196,0.169,0.236,0.204,0.132,
0.139,0.153,0.182,0.023,0.118,0.130,0.188,0.193,0.149,0.290,
0.333,0.309,0.209,0.252,0.251,0.261,0.272,0.270,0.238,0.049,
0.226,0.295,0.177,0.276,0.209,0.286,0.179,0.181,0.162,0.184,
0.016,0.024,0.022,0.022,0.131,0.021,0.155,0.161,0.120,0.174,
0.184,0.222,0.220,0.119,0.125,0.191,0.164,0.148,0.139,0.176,
0.184,0.019,0.157,0.246,0.235,0.241,0.279,0.415,0.485,0.368,
0.272,0.430,0.266,0.233,0.196,0.214,0.251,0.038,0.151,0.178,
0.227,0.256,0.183,0.256,0.464,0.432,0.261,0.288,0.396,0.323,
0.330,0.272,0.365,0.080,0.341,0.334,0.215,0.375,0.218,0.265,
0.271,0.335,0.338,0.293,0.037,0.048,0.056,0.063,0.263,0.044,
0.178,0.194,0.122,0.231,0.167,0.208,0.226,0.162,0.165,0.268,
0.246,0.222,0.234,0.272,0.229,0.032,0.188,0.242,0.231,0.201,
0.241,0.445,0.036,0.049,0.028,0.031,0.044,0.059,0.045,0.037,
0.029,0.015,0.031,0.032,0.022,0.044,0.031,0.034,0.054,0.080,
0.036,0.034,0.088,0.087,0.077,0.048,0.057,0.046,0.082,0.066,
0.029,0.088,0.037,0.036,0.027,0.064,0.045,0.033,0.013,0.034,
0.041,0.016,0.053,0.034,0.082,0.060,0.018,0.066,0.046,0.038,
0.030,0.026,0.021,0.034,0.046,0.062,0.051,0.058,0.035,0.010,
0.050,0.046,0.026,0.034,0.038,0.051,0.287,0.284,0.178,0.171,
0.231,0.308,0.307,0.206,0.298,0.072,0.242,0.231,0.147,0.243,
0.281,0.264,0.038,0.074,0.037,0.025,0.044,0.082,0.069,0.033,
0.063,0.041,0.084,0.054,0.027,0.072,0.074,0.038,0.177,0.303,
0.223,0.196,0.037,0.073,0.062,0.041,0.221,0.068,0.222,0.202,
0.101,0.249,0.224,0.203,0.153,0.142,0.147,0.148,0.287,0.351,
0.258,0.279,0.220,0.054,0.275,0.283,0.153,0.198,0.255,0.303,
0.292,0.211,0.154,0.249,0.165,0.138,0.116,0.131,0.200,0.028,
0.127,0.175,0.188,0.206,0.172,0.273,0.394,0.394,0.273,0.284,
0.330,0.384,0.302,0.264,0.361,0.071,0.335,0.397,0.241,0.396,
0.307,0.322,0.215,0.258,0.208,0.227,0.026,0.039,0.035,0.029,
0.222,0.045,0.217,0.227,0.148,0.260,0.220,0.267,0.234,0.185,
0.180,0.264,0.257,0.212,0.187,0.243,0.283,0.038,0.289,0.332,
0.292,0.359,0.356,0.522,0.829,0.427,0.334,0.610,0.459,0.257,
0.248,0.457,0.392,0.045,0.174,0.341,0.440,0.390,0.284,0.543,
0.440,0.297,0.197,0.316,0.271,0.191,0.208,0.253,0.313,0.041,
0.187,0.250,0.278,0.316,0.180,0.282,0.386,0.307,0.257,0.364,
0.036,0.029,0.030,0.063,0.229,0.022,0.139,0.214,0.197,0.241,
0.179,0.321,0.459,0.250,0.281,0.527,0.365,0.237,0.255,0.475,
0.352,0.029,0.232,0.419,0.455,0.307,0.373,0.971,0.782,0.551,
0.356,0.545,0.486,0.373,0.363,0.365,0.412,0.067,0.281,0.396,
0.379,0.477,0.279,0.483,0.650,0.578,0.314,0.466,0.498,0.430,
0.406,0.405,0.573,0.121,0.416,0.529,0.431,0.674,0.307,0.409,
0.380,0.544,0.319,0.425,0.039,0.059,0.050,0.062,0.345,0.057,
0.301,0.360,0.281,0.491,0.340,0.433,0.431,0.289,0.277,0.497,
0.406,0.383,0.390,0.625,0.368,0.038,0.331,0.428,0.399,0.367,
0.411,0.706,0.418,0.295,0.232,0.283,0.339,0.310,0.295,0.311,
0.405,0.062,0.257,0.351,0.291,0.311,0.298,0.443,0.033,0.042,
0.028,0.033,0.032,0.046,0.039,0.032,0.038,0.012,0.035,0.038,
0.040,0.053,0.043,0.052,0.250,0.312,0.256,0.292,0.025,0.040,
0.064,0.044,0.266,0.049,0.248,0.305,0.186,0.301,0.293,0.368,
0.264,0.201,0.214,0.297,0.305,0.294,0.349,0.411,0.334,0.042,
0.349,0.441,0.305,0.289,0.405,0.597,0.656,0.371,0.300,0.468,
0.310,0.222,0.250,0.268,0.312,0.038,0.189,0.292,0.364,0.325,
0.268,0.596,0.446,0.309,0.220,0.315,0.278,0.248,0.252,0.270,
0.282,0.029,0.226,0.333,0.288,0.299,0.241,0.413,0.393,0.378,
0.300,0.438,0.033,0.033,0.030,0.045,0.342,0.040,0.286,0.379,
0.319,0.409,0.379,0.525,0.693,0.357,0.375,0.718,0.466,0.354,
0.387,0.555,0.543,0.043,0.491,0.710,0.866,0.656,0.803,1.100,
8.070,3.810,3.940,5.160,3.640,2.250,2.290,2.460,3.980,0.343,
2.350,2.490,4.070,3.080,2.220,3.360,3.930,2.440,1.750,2.630,
2.600,1.470,1.800,1.640,2.060,0.198,1.320,1.550,1.770,1.790,
1.380,1.950,2.960,2.110,1.630,2.250,0.271,0.185,0.182,0.304,
2.440,0.188,1.560,1.760,1.390,1.660,1.460,1.970,2.870,1.530,
1.310,2.420,2.290,1.470,1.230,1.880,2.150,0.164,1.320,1.630,
2.160,1.220,1.650,2.880,5.270,2.840,1.830,2.900,2.910,2.050,
1.750,1.820,2.350,0.235,1.160,1.590,1.820,1.870,1.390,1.930,
3.630,2.450,1.470,1.790,2.290,1.250,1.500,1.280,2.290,0.295,
1.410,1.830,1.470,1.640,1.090,1.360,2.240,2.250,1.540,1.820,
0.227,0.211,0.209,0.246,2.000,0.242,1.620,2.220,1.370,1.920,
1.670,1.810,2.000,1.170,0.886,1.490,1.940,1.460,1.190,1.650,
1.640,0.135,1.170,1.620,1.580,1.230,1.350,2.430,4.330,2.060,
1.650,3.210,3.600,2.480,2.440,2.670,2.990,0.353,1.490,1.960,
2.210,2.380,1.900,2.790,0.412,0.340,0.208,0.326,0.358,0.282,
0.302,0.287,0.298,0.056,0.306,0.275,0.333,0.564,0.308,0.409,
2.120,1.850,2.670,2.910,0.236,0.195,0.559,0.497,1.820,0.224,
1.460,1.520,1.220,1.760,1.610,1.810,2.030,1.150,1.210,1.900,
2.810,2.080,2.720,2.890,1.780,0.186,1.330,1.860,1.780,1.610,
1.780,2.930,3.860,1.500,1.290,2.330,1.570,1.010,1.380,1.310,
1.790,0.191,0.933,1.290,2.210,1.970,3.250,2.680,2.780,2.010,
1.360,1.810,1.900,1.350,1.470,1.410,1.700,0.153,1.360,1.680,
1.790,2.070,1.530,2.150,1.920,2.240,2.480,2.390,0.170,0.159,
0.208,0.259,1.640,0.179,1.650,2.010,1.410,2.110,1.810,2.200,
2.420,1.380,1.290,2.340,1.510,1.010,1.370,1.970,2.240,0.175,
1.570,2.560,2.970,2.390,2.600,4.920,0.469,0.327,0.280,0.351,
0.308,0.240,0.231,0.251,0.236,0.035,0.142,0.171,0.255,0.254,
0.219,0.270,0.340,0.295,0.240,0.405,0.319,0.249,0.473,0.276,
0.218,0.050,0.169,0.198,0.149,0.222,0.180,0.212,0.176,0.194,
0.141,0.170,0.026,0.035,0.032,0.032,0.138,0.025,0.124,0.132,
0.103,0.157,0.136,0.168,0.178,0.117,0.110,0.168,0.201,0.154,
0.133,0.171,0.143,0.020,0.108,0.145,0.163,0.125,0.173,0.283,
0.324,0.292,0.160,0.185,0.232,0.211,0.181,0.145,0.153,0.034,
0.111,0.115,0.110,0.144,0.107,0.133,0.283,0.330,0.169,0.164,
0.269,0.172,0.244,0.148,0.255,0.097,0.169,0.186,0.125,0.223,
0.131,0.140,0.158,0.236,0.155,0.138,0.033,0.057,0.051,0.029,
0.199,0.071,0.177,0.193,0.109,0.213,0.166,0.158,0.141,0.093,
0.107,0.113,0.149,0.135,0.102,0.124,0.112,0.021,0.109,0.123,
0.112,0.106,0.112,0.181,0.287,0.192,0.141,0.233,0.292,0.273,
0.302,0.218,0.234,0.050,0.170,0.157,0.148,0.206,0.216,0.210,
0.040,0.056,0.031,0.034,0.049,0.069,0.075,0.034,0.041,0.031,
0.085,0.040,0.022,0.061,0.061,0.035,0.173,0.196,0.220,0.217,
0.036,0.059,0.095,0.042,0.193,0.063,0.285,0.187,0.115,0.233,
0.225,0.204,0.143,0.105,0.098,0.141,0.209,0.232,0.263,0.211,
0.181,0.033,0.174,0.182,0.136,0.209,0.187,0.258,0.336,0.257,
0.186,0.260,0.182,0.144,0.142,0.154,0.181,0.024,0.100,0.142,
0.199,0.234,0.314,0.315,0.340,0.311,0.198,0.261,0.311,0.280,
0.267,0.255,0.221,0.040,0.214,0.229,0.214,0.317,0.254,0.309,
0.184,0.223,0.209,0.219,0.017,0.028,0.030,0.031,0.160,0.029,
0.172,0.206,0.141,0.218,0.248,0.263,0.206,0.144,0.122,0.189,
0.146,0.134,0.133,0.180,0.211,0.024,0.166,0.235,0.234,0.230,
0.267,0.429,3.950,2.910,2.320,3.680,2.370,1.820,1.450,1.910,
1.940,0.207,1.260,1.560,1.580,1.410,1.180,1.890,3.890,2.730,
1.670,2.100,4.140,2.130,2.430,2.120,2.660,0.315,1.930,2.060,
1.470,2.030,1.470,1.770,2.330,2.930,1.650,1.950,0.315,0.347,
0.254,0.387,1.800,0.269,1.490,1.530,1.070,2.000,1.470,1.730,
1.760,1.230,0.900,1.490,1.690,1.480,1.120,1.550,1.840,0.199,
1.220,1.850,1.580,1.260,1.510,2.710,0.297,0.259,0.140,0.214,
0.368,0.314,0.192,0.226,0.169,0.039,0.162,0.152,0.117,0.151,
0.129,0.183,0.362,0.314,0.154,0.156,1.230,0.358,0.313,0.237,
0.260,0.080,0.269,0.227,0.152,0.219,0.165,0.135,0.166,0.275,
0.164,0.156,0.059,0.081,0.071,0.045,0.197,0.061,0.240,0.218,
0.098,0.236,0.195,0.170,0.181,0.130,0.091,0.161,0.248,0.255,
0.167,0.242,0.206,0.031,0.153,0.311,0.147,0.135,0.143,0.268,
3.680,1.910,1.410,1.390,2.280,2.280,2.230,1.640,2.190,0.355,
1.820,1.620,1.260,1.580,2.800,2.000,0.254,0.311,0.214,0.157,
0.282,0.357,0.287,0.162,0.229,0.085,0.380,0.219,0.191,0.352,
0.949,0.291,2.130,1.770,1.580,1.440,0.267,0.246,0.342,0.265,
1.180,0.206,0.523,0.638,0.678,1.020,1.210,1.180,1.230,0.881,
0.832,0.860,1.700,1.740,1.690,1.370,1.450,0.196,1.510,1.470,
1.080,1.120,1.620,1.820,2.380,1.250,1.130,1.460,1.340,1.020,
0.827,0.830,1.360,0.152,0.858,1.050,1.150,1.240,1.080,1.460,
2.440,2.060,1.690,1.470,2.150,2.020,1.640,1.280,1.810,0.230,
1.850,1.820,1.430,2.070,2.410,1.660,1.830,1.860,1.490,1.690,
0.168,0.205,0.187,0.219,1.680,0.198,1.610,1.640,1.040,1.720,
1.590,1.630,1.480,0.991,0.911,1.240,1.320,1.290,1.130,1.340,
1.750,0.169,1.650,1.840,1.690,1.640,1.840,2.190,4.180,2.010,
1.480,3.150,1.930,1.160,1.050,1.770,1.790,0.175,0.929,1.450,
2.250,1.500,1.230,2.200,2.660,1.600,0.941,1.780,1.720,0.873,
1.100,1.220,1.320,0.105,0.710,0.982,1.030,0.971,0.739,1.140,
1.810,1.740,1.100,1.630,0.191,0.152,0.143,0.259,1.380,0.138,
0.780,1.240,1.060,1.340,1.020,1.590,1.910,1.150,0.887,1.590,
1.530,1.130,0.934,1.380,1.290,0.103,0.726,1.260,1.540,1.130,
1.210,2.720,3.720,2.370,1.550,2.400,2.440,1.850,1.460,1.690,
1.810,0.186,1.200,1.510,1.450,1.480,0.942,1.810,3.080,2.380,
1.380,1.840,3.310,1.780,2.200,1.910,1.960,0.228,1.590,1.850,
1.170,1.470,0.987,1.350,1.710,2.060,1.830,1.750,0.196,0.236,
0.215,0.235,1.720,0.229,1.570,1.960,1.100,1.960,1.620,1.960,
1.890,1.230,1.190,1.720,2.090,1.650,1.340,1.910,1.530,0.133,
1.170,2.050,1.410,1.280,1.350,2.590,3.450,1.900,1.470,1.860,
2.630,2.260,2.350,2.400,2.180,0.286,1.520,1.920,1.620,1.840,
1.920,2.550,0.309,0.235,0.208,0.204,0.245,0.263,0.346,0.239,
0.182,0.043,0.243,0.230,0.182,0.326,0.333,0.246,2.160,2.150,
2.760,2.080,0.274,0.236,1.330,0.421,2.360,0.382,1.630,1.970,
1.300,2.240,1.850,2.030,1.740,1.280,1.350,1.500,2.190,1.930,
3.740,2.440,1.940,0.216,1.920,3.250,1.610,1.580,2.140,3.580,
3.070,1.370,1.120,1.980,1.480,1.030,0.981,1.100,1.550,0.154,
0.863,1.230,1.580,1.250,1.080,2.070,2.900,1.740,1.310,1.620,
1.830,1.500,1.530,1.380,1.570,0.130,1.200,1.640,1.420,1.430,
1.390,1.730,2.110,2.090,1.590,2.020,0.163,0.168,0.244,0.217,
2.100,0.201,1.790,2.200,1.480,2.050,1.840,2.200,2.540,1.490,
1.280,2.340,1.860,1.500,1.620,2.070,2.210,0.175,1.970,3.040,
2.720,2.110,2.490,3.750,8.070,3.910,3.540,6.200,3.520,1.960,
1.850,2.300,3.260,0.279,1.370,2.520,4.380,3.320,1.900,4.110,
3.450,1.830,1.640,2.070,1.860,1.020,1.350,1.280,1.770,0.127,
1.000,1.440,1.680,1.450,1.080,1.910,2.590,1.670,1.580,2.400,
0.227,0.155,0.154,0.269,1.430,0.115,0.869,1.280,1.330,1.480,
1.310,2.150,3.920,1.750,2.370,3.250,2.490,1.420,1.350,1.980,
1.790,0.131,1.040,1.800,2.780,1.600,1.860,4.870,6.050,2.530,
1.680,3.000,2.440,1.390,1.030,1.410,1.900,0.158,0.897,1.390,
1.920,1.540,1.030,2.010,2.600,1.360,0.952,1.340,1.320,0.771,
0.741,0.833,1.370,0.103,0.721,1.040,1.310,1.020,0.754,1.140,
1.640,1.230,0.883,1.370,0.114,0.092,0.072,0.119,1.410,0.215,
0.659,0.958,1.140,1.490,0.869,1.340,1.920,0.943,0.827,1.420,
1.290,0.844,0.637,1.100,1.190,0.086,0.657,1.080,1.480,1.030,
1.110,2.250,4.650,1.760,1.440,2.390,2.860,2.180,1.470,2.120,
2.150,0.236,0.779,1.450,2.330,1.960,1.300,2.750,0.295,0.162,
0.121,0.210,0.204,0.152,0.127,0.162,0.189,0.024,0.096,0.156,
0.298,0.314,0.166,0.280,1.900,1.290,1.320,2.230,0.158,0.106,
0.117,0.218,1.360,0.125,0.700,1.080,1.370,1.460,1.110,1.620,
1.990,1.180,1.180,1.890,2.200,1.420,1.250,1.890,1.930,0.214,
0.949,1.760,1.960,1.620,1.550,3.140,5.990,1.910,1.570,3.450,
2.080,1.330,1.290,2.080,2.400,0.208,1.050,1.910,3.550,2.330,
1.790,3.850,3.070,1.690,1.260,2.040,1.740,1.080,1.100,1.330,
1.880,0.127,1.010,1.550,2.250,1.980,1.310,2.340,2.160,1.480,
1.430,2.120,0.143,0.100,0.161,0.175,1.430,0.113,0.951,1.540,
1.370,1.680,1.430,2.210,3.540,1.710,1.610,3.400,2.010,1.220,
1.240,1.900,2.470,0.171,1.720,2.820,3.710,2.810,3.050,6.790,
7.780,4.270,3.670,5.690,4.010,2.710,2.590,2.950,2.980,0.298,
1.420,2.590,3.480,3.060,2.230,4.320,4.150,2.660,2.530,3.140,
2.750,1.930,4.870,2.710,2.270,0.218,1.540,2.070,1.880,1.900,
1.820,2.510,2.770,2.150,1.650,2.610,0.208,0.185,0.168,0.272,
1.740,0.173,1.110,1.650,1.430,1.700,1.560,2.600,3.070,1.590,
1.660,2.490,2.650,1.710,1.430,2.060,1.780,0.145,1.080,1.880,
2.300,1.670,1.780,4.280,5.480,3.410,2.110,3.100,2.960,2.270,
1.570,1.950,2.060,0.225,1.190,1.650,2.220,1.900,1.390,2.410,
3.140,2.470,1.760,2.200,2.350,1.430,1.540,1.480,2.130,0.307,
1.260,1.780,1.770,2.020,1.240,1.770,2.150,1.960,1.330,1.970,
0.161,0.160,0.125,0.181,1.810,0.256,1.180,1.680,1.580,1.950,
1.490,2.300,2.000,1.200,1.040,1.630,1.730,1.320,0.888,1.390,
1.350,0.115,0.898,1.470,1.600,1.310,1.210,2.430,3.880,2.150,
1.550,2.250,3.070,2.210,2.100,2.260,2.320,0.349,1.160,1.750,
2.050,2.180,1.650,2.950,0.221,0.238,0.137,0.193,0.215,0.233,
0.192,0.197,0.198,0.048,0.166,0.179,0.206,0.301,0.190,0.262,
2.320,1.860,1.560,2.030,0.199,0.196,0.184,0.228,1.840,0.247,
1.410,1.760,1.510,2.210,1.790,2.490,2.090,1.250,1.190,1.930,
2.540,2.210,1.850,2.320,2.080,0.206,1.510,2.500,2.000,1.990,
2.150,4.050,4.320,2.330,1.780,2.970,2.010,1.430,1.340,1.880,
2.350,0.199,1.110,1.810,2.560,2.020,1.670,3.590,3.330,2.950,
1.670,2.540,2.240,1.950,1.830,2.290,2.050,0.202,1.540,2.240,
2.150,2.630,1.860,2.870,2.330,1.960,1.690,2.360,0.151,0.146,
0.139,0.190,1.660,0.151,1.390,1.950,1.480,1.740,1.910,2.990,
2.740,1.590,1.490,2.260,1.940,1.580,1.250,1.870,2.200,0.176,
1.720,2.780,2.800,2.190,2.740,5.280,5.480,3.210,2.360,3.830,
2.840,1.940,1.560,2.170,2.850,0.236,1.240,1.930,2.780,1.990,
1.410,2.570,4.120,2.920,1.590,2.360,3.010,2.010,1.840,1.920,
2.570,0.265,1.910,2.340,2.170,2.550,1.700,2.480,2.340,2.760,
1.750,2.330,0.262,0.286,0.225,0.353,1.940,0.241,1.310,1.690,
1.720,2.730,2.230,2.580,2.400,1.720,1.330,2.260,2.180,1.890,
1.360,2.080,2.370,0.214,1.560,2.330,2.640,1.960,2.710,5.170,
0.339,0.301,0.173,0.294,0.297,0.257,0.166,0.222,0.207,0.031,
0.142,0.170,0.181,0.225,0.146,0.263,0.297,0.290,0.141,0.183,
0.446,0.294,0.235,0.202,0.229,0.054,0.251,0.268,0.181,0.280,
0.186,0.206,0.152,0.207,0.120,0.155,0.027,0.046,0.049,0.029,
0.199,0.044,0.195,0.198,0.132,0.262,0.200,0.215,0.223,0.170,
0.109,0.224,0.340,0.292,0.159,0.269,0.292,0.029,0.147,0.248,
0.211,0.176,0.205,0.375,3.530,2.180,1.480,1.670,2.830,2.600,
2.310,1.980,2.090,0.353,1.610,1.740,1.630,2.060,2.670,2.550,
0.267,0.235,0.153,0.150,0.309,0.286,0.188,0.148,0.200,0.057,
0.336,0.194,0.229,0.342,0.707,0.272,2.250,2.360,1.740,1.930,
0.482,0.401,0.210,0.247,2.090,0.268,1.030,1.490,1.250,1.990,
1.730,2.020,2.140,1.940,1.350,1.620,5.110,5.120,1.890,2.080,
2.250,0.311,1.850,2.240,1.890,2.030,2.020,2.990,3.420,1.940,
1.290,2.160,1.890,1.490,1.160,1.370,2.000,0.214,1.330,1.750,
1.980,1.880,1.420,2.450,3.510,2.590,1.740,2.280,2.590,2.380,
1.680,1.640,2.350,0.258,2.480,2.630,2.400,3.160,2.630,2.720,
2.640,2.490,1.640,2.390,0.202,0.218,0.154,0.197,2.550,0.225,
1.770,2.350,1.780,2.580,2.170,2.800,3.050,2.060,1.710,2.240,
2.380,2.300,1.510,1.950,3.040,0.266,2.640,3.370,2.970,2.820,
3.080,4.270,8.170,3.380,2.170,4.280,2.480,1.470,1.220,1.910,
2.450,0.247,1.250,2.040,3.050,2.260,1.810,3.850,3.250,1.770,
0.995,1.860,1.650,1.020,0.901,1.260,1.750,0.143,1.190,1.560,
1.560,1.530,0.968,1.900,3.020,2.320,1.430,2.760,0.305,0.260,
0.155,0.387,1.760,0.164,1.040,1.650,1.890,2.020,1.500,2.610,
2.830,1.320,1.250,2.600,1.850,1.180,0.973,1.850,1.760,0.125,
1.120,1.940,2.600,1.690,2.220,5.810,4.620,2.820,1.830,3.020,
2.510,1.790,1.390,1.860,1.940,0.186,1.220,1.920,2.070,1.780,
1.310,2.820,3.350,2.260,1.240,1.980,2.150,1.620,1.330,1.500,
1.990,0.187,1.410,2.120,1.570,1.770,1.080,1.950,1.940,1.880,
1.150,1.940,0.135,0.148,0.108,0.181,1.850,0.184,1.890,2.120,
1.560,2.130,1.740,2.880,2.290,1.370,1.260,2.280,1.870,1.400,
1.100,1.910,1.910,0.135,1.430,2.190,2.220,1.480,1.820,3.920,
4.670,2.440,1.760,2.460,3.400,2.450,2.180,2.870,2.750,0.315,
1.470,2.350,2.710,2.410,2.150,4.010,0.302,0.232,0.141,0.215,
0.244,0.241,0.174,0.216,0.198,0.032,0.158,0.230,0.292,0.317,
0.228,0.343,2.900,2.790,1.860,2.520,0.230,0.253,0.298,0.285,
2.830,0.304,1.770,2.530,2.210,2.820,2.440,3.450,3.070,2.220,
1.700,2.580,3.210,2.830,2.550,3.150,3.090,0.260,2.250,3.930,
2.800,2.490,2.580,5.190,7.240,2.780,1.820,3.850,2.720,1.750,
1.450,2.070,2.940,0.252,1.480,2.590,4.140,2.830,2.280,6.020,
4.200,2.550,1.540,2.600,2.870,2.580,1.540,1.980,2.570,0.179,
1.730,2.780,3.110,2.580,2.080,3.780,3.640,3.140,2.110,3.410,
0.213,0.209,0.152,0.267,3.390,0.251,2.400,3.440,3.430,3.760,
3.310,4.800,6.800,2.970,2.550,5.900,3.420,2.610,2.300,3.730,
4.610,0.285,3.440,5.720,6.650,4.380,4.500,8.890,25.4,12.5,
10.6,25.8,10.4,5.990,5.710,8.430,12.1,0.919,4.880,8.590,
25.6,12.6,7.530,15.8,10.6,5.160,4.420,6.330,5.320,3.110,
2.760,3.280,5.800,0.370,2.910,4.700,5.880,4.210,3.410,6.100,
9.830,5.110,4.720,8.570,0.676,0.452,0.350,0.952,4.250,0.309,
2.290,3.610,5.070,4.350,3.480,6.050,30.6,6.670,7.640,16.1,
11.5,6.290,5.640,10.8,6.640,0.439,3.370,5.970,11.6,5.840,
5.950,12.7,10.7,3.920,3.090,5.740,4.390,2.320,2.100,2.730,
4.410,0.313,1.690,2.660,4.690,3.200,2.090,3.970,5.140,2.450,
1.680,2.570,2.370,1.270,1.160,1.370,2.920,0.164,1.310,1.920,
2.400,1.710,1.550,2.090,4.750,2.810,2.410,3.810,0.269,0.166,
0.145,0.274,3.360,0.253,1.380,2.060,2.290,2.070,1.610,2.620,
5.600,2.480,2.060,3.880,3.800,2.230,1.720,2.760,2.940,0.167,
1.210,2.370,3.580,2.270,2.270,4.360,8.380,3.560,3.410,5.680,
4.700,2.260,2.620,3.310,4.100,0.391,1.740,2.920,4.730,3.430,
2.630,6.000,0.580,0.354,0.245,0.420,0.292,0.221,0.209,0.246,
0.306,0.031,0.191,0.300,0.544,0.476,0.292,0.592,3.620,2.500,
2.070,2.800,0.246,0.158,0.142,0.254,2.300,0.172,1.140,1.770,
2.140,1.990,1.650,2.530,4.380,2.170,2.150,3.700,3.700,2.350,
2.070,3.090,3.160,0.236,1.730,2.760,3.680,3.190,2.950,5.720,
17.7,4.930,5.580,20.4,5.160,2.500,3.640,5.150,6.340,0.484,
2.700,4.520,8.810,4.840,3.990,10.6,7.360,3.910,3.300,5.320,
3.480,2.180,2.720,2.980,3.990,0.230,2.410,4.120,5.210,3.700,
3.020,5.800,4.950,3.390,3.140,4.700,0.325,0.205,0.232,0.383,
3.350,0.209,1.890,2.840,3.580,3.440,2.860,4.430,8.780,4.110,
4.270,9.580,4.560,2.780,2.860,4.880,6.040,0.318,3.180,5.620,
10.2,6.460,6.510,15.5,12.7,5.230,4.250,8.140,4.610,2.660,
2.270,3.320,3.890,0.319,1.520,2.970,5.630,4.010,2.470,5.240,
5.680,2.730,2.220,3.250,2.540,1.460,1.450,1.640,2.280,0.202,
1.220,1.910,2.190,1.940,1.400,2.430,3.930,1.930,2.290,3.440,
0.244,0.193,0.186,0.315,1.780,0.144,0.936,1.330,2.050,1.820,
1.380,2.520,4.870,1.890,2.300,4.060,3.270,2.090,2.140,2.950,
2.170,0.155,1.040,1.890,3.300,2.000,2.050,5.030,5.910,3.230,
1.820,3.370,2.780,1.650,1.140,1.830,1.930,0.153,0.833,1.490,
2.300,1.830,1.120,2.540,2.900,1.840,0.995,1.560,1.380,0.592,
0.713,0.870,1.360,0.105,0.763,1.150,1.180,1.180,0.917,1.470,
2.850,1.830,1.310,2.090,0.160,0.112,0.089,0.157,1.540,0.225,
0.780,1.140,1.340,1.520,0.957,1.740,2.650,1.580,1.220,2.150,
1.840,1.280,0.997,1.500,1.440,0.100,0.682,1.260,1.660,1.220,
1.060,2.570,5.370,2.550,2.060,3.220,2.930,1.690,1.840,2.170,
2.630,0.278,1.380,2.000,2.640,2.360,2.000,3.670,0.286,0.207,
0.139,0.225,0.144,0.153,0.121,0.143,0.165,0.030,0.128,0.193,
0.220,0.259,0.156,0.265,3.700,2.140,1.860,2.480,0.208,0.273,
0.112,0.184,1.470,0.133,0.953,1.360,1.520,1.480,1.380,1.910,
3.180,1.650,1.770,2.620,2.430,2.610,1.620,2.250,1.970,0.153,
1.270,2.090,2.080,1.790,1.970,3.580,4.910,2.320,2.220,4.140,
2.140,1.280,1.410,1.900,2.190,0.165,1.330,1.960,2.970,1.960,
1.760,4.140,3.130,1.870,1.530,2.420,1.630,1.290,1.200,1.710,
1.550,0.124,1.460,2.520,1.900,1.720,1.510,2.720,2.660,1.310,
1.680,2.480,0.137,0.102,0.094,0.168,1.420,0.102,1.040,1.420,
1.670,1.510,1.620,2.430,3.440,1.160,1.940,3.250,2.100,1.500,
1.380,2.330,2.380,0.151,1.450,2.540,3.670,2.920,3.260,6.120,
14.4,4.860,3.570,7.580,3.370,2.160,1.710,2.780,3.580,0.309,
1.500,2.810,5.170,3.820,2.200,5.220,6.110,3.470,2.220,3.890,
2.800,1.740,1.880,2.160,3.330,0.256,1.690,2.410,4.030,3.190,
2.140,3.590,4.230,3.200,3.180,4.720,0.366,0.274,0.243,0.562,
2.050,0.172,1.020,1.590,2.080,2.380,1.460,2.900,6.310,2.930,
3.370,6.970,3.810,2.480,2.380,4.340,2.970,0.237,1.520,2.910,
4.810,3.100,3.290,9.580,0.808,0.411,0.244,0.467,0.298,0.231,
0.161,0.245,0.292,0.037,0.126,0.240,0.362,0.373,0.199,0.441,
0.443,0.310,0.163,0.276,0.256,0.187,0.152,0.173,0.311,0.034,
0.166,0.222,0.365,0.327,0.187,0.317,0.332,0.277,0.197,0.358,
0.023,0.025,0.019,0.034,0.222,0.028,0.128,0.172,0.225,0.255,
0.160,0.307,0.718,0.382,0.325,0.773,0.511,0.422,0.309,0.555,
0.322,0.027,0.178,0.337,0.494,0.376,0.341,0.841,4.140,2.300,
1.580,2.400,2.160,1.560,1.660,1.780,2.990,0.340,1.510,2.090,
2.570,2.140,2.010,3.540,0.284,0.220,0.128,0.202,0.147,0.128,
0.115,0.116,0.255,0.028,0.118,0.158,0.331,0.281,0.172,0.295,
2.080,1.900,1.320,1.710,0.204,0.141,0.122,0.165,1.490,0.138,
0.639,0.952,1.160,1.380,1.060,1.670,2.790,2.110,1.700,2.180,
2.400,1.980,1.490,2.080,1.910,0.184,1.310,1.840,2.000,1.760,
1.910,3.180,4.320,2.120,1.760,3.230,2.080,1.220,1.380,1.560,
2.660,0.272,1.260,2.360,3.440,2.790,1.730,4.180,3.970,2.420,
1.690,2.730,2.100,1.570,1.490,1.570,2.620,0.178,1.480,2.240,
3.370,2.580,1.770,3.220,2.660,2.070,1.440,2.440,0.195,0.150,
0.122,0.202,1.910,0.141,1.110,1.600,1.800,2.030,1.510,2.660,
4.210,2.460,2.350,3.480,2.730,1.980,1.800,2.700,3.200,0.263,
2.110,3.100,4.370,3.490,3.400,6.560,15.0,5.810,4.950,11.5,
4.400,2.390,2.460,3.350,4.520,0.343,1.950,3.640,8.100,4.800,
3.520,9.040,5.410,2.560,2.010,3.700,2.480,1.310,1.490,1.930,
3.000,0.205,1.440,2.280,3.640,2.400,1.980,3.790,6.090,3.400,
3.220,6.620,0.400,0.248,0.234,0.631,3.020,0.187,1.430,2.540,
3.380,2.750,2.070,4.590,12.0,4.480,5.920,16.8,5.430,2.930,
3.480,7.000,4.640,0.293,2.540,4.590,8.670,4.750,5.420,15.6,
7.770,3.710,2.600,5.330,3.470,2.010,1.630,2.500,3.390,0.231,
1.550,2.840,3.770,2.970,1.930,4.380,4.440,2.340,1.480,2.670,
2.260,1.450,1.190,1.550,2.850,0.231,1.360,2.170,2.970,2.310,
1.380,2.540,3.990,2.630,1.980,4.200,0.212,0.178,0.118,0.284,
2.720,0.175,1.310,2.210,2.690,2.460,1.770,3.470,6.120,2.900,
3.020,6.850,3.850,2.690,2.380,4.360,3.430,0.180,1.720,3.090,
4.560,3.060,3.010,6.810,5.580,3.010,2.370,3.900,3.640,2.030,
1.990,2.880,4.380,0.368,2.010,3.180,3.680,2.740,2.730,4.980,
0.353,0.254,0.176,0.321,0.187,0.169,0.152,0.182,0.373,0.029,
0.158,0.249,0.349,0.326,0.205,0.379,3.560,3.070,2.090,3.310,
0.198,0.175,0.148,0.258,2.520,0.207,1.410,2.550,2.280,2.380,
2.040,3.590,4.040,2.550,2.540,4.240,3.840,2.720,2.540,4.070,
3.610,0.226,2.300,3.730,3.810,2.830,3.810,6.330,10.8,4.460,
4.420,8.830,4.250,2.370,2.950,3.410,4.820,0.365,2.320,4.190,
7.290,4.470,3.810,10.4,5.390,3.110,2.480,4.550,2.790,1.920,
2.120,2.590,3.340,0.185,1.970,3.340,4.160,3.170,2.580,5.490,
5.840,4.350,3.530,6.140,0.333,0.245,0.220,0.435,5.040,0.280,
2.360,3.940,5.130,4.510,3.730,6.490,12.6,5.510,6.660,14.2,
7.510,4.880,5.880,9.090,8.730,0.406,5.040,9.020,16.9,9.600,
11.2,19.7,13.6,7.910,7.070,11.6,7.540,4.080,3.660,4.570,
6.490,0.594,2.910,4.770,10.4,6.890,4.620,7.970,7.860,4.410,
3.430,4.390,4.570,2.540,2.370,2.550,3.720,0.305,2.400,2.990,
3.810,3.040,2.670,4.020,5.940,3.420,2.970,4.700,0.584,0.303,
0.271,0.509,2.490,0.228,1.380,2.000,3.240,2.720,2.340,3.420,
9.260,3.350,3.420,6.320,10.6,4.120,3.240,4.710,3.870,0.279,
2.060,3.160,6.050,3.270,3.660,6.840,9.210,4.710,3.420,5.140,
4.690,2.760,2.080,2.620,3.740,0.374,2.030,2.840,5.250,3.720,
2.570,4.350,5.560,3.090,2.070,2.890,2.790,1.710,1.530,1.750,
2.950,0.270,1.830,2.510,2.550,2.170,1.920,2.540,3.530,2.620,
1.830,2.760,0.305,0.204,0.186,0.255,2.800,0.459,1.320,1.760,
2.300,2.550,1.880,2.430,3.680,1.970,1.510,2.650,3.690,2.030,
1.460,2.240,2.590,0.192,1.300,2.040,3.540,2.270,2.350,4.210,
5.960,2.960,2.380,3.690,4.390,2.630,2.450,2.960,3.300,0.405,
1.660,2.370,3.340,2.930,2.340,4.760,0.379,0.345,0.209,0.334,
0.287,0.249,0.208,0.259,0.249,0.048,0.178,0.248,0.306,0.425,
0.250,0.435,2.670,2.000,1.800,2.290,0.229,0.155,0.164,0.263,
1.880,0.185,1.120,1.600,1.650,1.870,1.870,2.480,3.030,1.590,
1.680,2.670,3.260,2.110,2.030,2.690,2.590,0.230,1.690,2.260,
2.890,2.600,2.880,4.750,7.190,2.490,2.290,5.090,3.110,1.570,
1.740,2.280,3.330,0.348,1.570,2.440,3.970,2.790,2.080,4.940,
4.740,3.000,2.280,3.650,2.830,1.980,1.870,2.610,2.570,0.220,
1.780,2.880,2.720,2.610,2.150,3.870,3.060,2.190,1.880,2.830,
0.212,0.145,0.204,0.264,2.010,0.210,1.240,2.030,1.990,2.270,
2.100,2.930,4.460,2.000,2.110,4.080,2.570,1.590,1.730,2.420,
3.060,0.225,2.080,3.390,4.790,3.470,3.960,7.670,9.620,5.530,
4.100,6.840,4.870,3.100,2.530,3.020,3.750,0.377,1.570,2.350,
5.460,4.600,3.320,5.000,5.380,3.440,2.250,3.310,2.920,1.990,
2.000,1.970,2.270,0.244,1.480,2.110,2.000,2.080,1.820,2.510,
3.150,2.180,1.820,2.560,0.244,0.194,0.165,0.269,1.550,0.148,
0.899,1.190,2.830,1.740,1.680,2.360,4.470,1.810,1.780,3.100,
3.290,2.420,1.660,2.290,2.040,0.165,1.110,1.670,3.300,1.950,
2.080,4.100,5.910,3.770,2.020,3.740,3.880,2.630,1.620,2.180,
2.110,0.224,1.130,1.720,2.350,2.290,1.570,3.460,4.110,2.900,
1.570,2.640,2.100,0.896,1.230,1.530,1.830,0.225,1.220,1.790,
1.420,1.670,1.210,2.050,3.030,2.140,1.400,2.130,0.203,0.200,
0.144,0.202,1.630,0.224,0.933,1.250,1.370,1.810,1.360,1.960,
2.290,1.440,1.470,1.970,1.950,1.660,1.180,1.590,1.540,0.125,
0.903,1.380,1.770,1.410,1.240,2.580,4.600,2.370,1.770,2.700,
3.730,2.430,2.160,2.280,2.590,0.472,1.450,1.780,2.380,2.630,
1.980,3.540,0.292,0.296,0.153,0.309,0.241,0.302,0.233,0.215,
0.320,0.196,0.218,0.219,0.210,0.760,0.190,0.265,2.950,2.110,
1.700,2.320,0.223,0.261,0.185,0.247,1.590,0.205,1.180,1.440,
1.360,1.750,1.830,2.140,2.760,1.240,1.590,2.330,2.650,2.180,
2.010,2.390,2.140,0.204,1.550,2.000,2.290,2.150,2.580,3.850,
4.000,1.910,1.660,2.790,2.410,1.300,1.390,1.740,2.090,0.193,
1.170,1.490,2.280,1.680,1.530,3.350,3.290,2.250,1.600,2.530,
2.160,1.810,1.750,2.450,1.960,0.308,1.480,2.390,1.560,2.070,
1.450,2.440,1.970,1.570,1.260,1.840,0.131,0.110,0.093,0.149,
1.180,0.102,0.966,1.250,1.280,1.410,1.490,2.050,3.060,1.300,
1.440,2.320,1.910,1.270,1.310,1.810,1.870,0.135,1.310,2.130,
2.760,2.280,2.630,4.440,7.250,4.240,3.220,6.970,3.150,2.230,
1.750,2.470,2.860,0.307,1.440,2.100,3.580,3.290,2.230,3.900,
4.850,3.320,2.020,3.450,2.620,2.030,1.860,2.070,2.720,0.305,
2.120,2.430,2.450,3.490,1.850,2.910,2.760,2.810,2.410,3.180,
0.274,0.250,0.262,0.469,1.780,0.199,1.030,1.450,1.420,2.000,
1.400,2.290,3.450,1.990,1.990,4.230,2.790,1.950,2.120,3.180,
2.330,0.229,1.510,2.410,3.300,2.380,2.690,6.240,0.327,0.265,
0.155,0.281,0.248,0.217,0.160,0.191,0.177,0.031,0.115,0.164,
0.241,0.247,0.167,0.274,0.290,0.256,0.127,0.183,0.241,0.239,
0.181,0.186,0.218,0.045,0.190,0.214,0.201,0.272,0.140,0.205,
0.180,0.197,0.143,0.187,0.025,0.034,0.034,0.037,0.177,0.038,
0.145,0.154,0.130,0.211,0.164,0.209,0.313,0.189,0.150,0.357,
0.287,0.268,0.226,0.344,0.189,0.028,0.158,0.226,0.238,0.217,
0.223,0.411,3.580,2.620,1.780,2.390,2.520,2.390,2.230,2.240,
2.770,0.396,1.830,2.410,2.120,2.300,2.150,3.510,0.243,0.272,
0.142,0.207,0.168,0.253,0.207,0.160,0.251,0.047,0.205,0.236,
0.219,0.328,0.212,0.284,1.920,2.430,1.700,2.330,0.185,0.238,
0.191,0.248,1.790,0.226,1.120,1.400,1.170,1.780,1.560,2.320,
2.110,1.750,1.690,2.190,2.490,2.950,1.960,2.580,2.110,0.278,
1.850,2.420,2.020,2.030,2.520,3.940,3.820,2.190,1.670,3.050,
1.910,1.310,1.170,1.480,2.340,0.242,1.300,2.170,2.590,2.330,
2.090,3.650,3.800,2.990,1.880,2.820,2.480,2.570,2.040,2.130,
2.740,0.261,2.100,3.180,2.370,2.850,2.040,3.150,2.660,2.340,
1.760,2.530,0.184,0.176,0.172,0.223,1.910,0.182,1.460,1.790,
1.660,2.250,1.900,2.760,3.130,2.070,1.930,3.440,2.310,1.880,
1.630,2.410,2.790,0.229,2.540,3.390,3.700,3.390,3.730,6.170,
9.550,3.950,3.770,8.040,3.700,1.920,2.100,3.140,3.340,0.277,
1.530,2.750,4.910,3.480,2.750,5.730,4.050,2.190,1.640,2.790,
2.000,1.280,1.370,1.820,2.230,0.162,1.330,1.960,2.370,1.830,
1.550,2.680,3.700,2.470,2.090,3.720,0.251,0.166,0.161,0.409,
2.070,0.155,1.050,1.730,2.020,1.910,1.490,3.230,5.360,2.480,
2.940,6.390,3.190,1.800,2.070,4.140,3.040,0.205,1.810,3.080,
5.090,3.030,3.410,8.900,6.280,3.510,2.400,4.470,3.360,2.310,
1.980,2.500,2.990,0.269,1.820,2.910,3.720,3.220,1.970,4.200,
4.220,2.710,1.600,2.560,2.660,2.090,1.690,2.080,3.050,0.255,
1.870,2.830,3.260,2.420,1.720,2.710,2.800,2.480,1.680,3.080,
0.177,0.188,0.149,0.312,2.270,0.212,1.400,2.120,2.200,2.600,
1.820,3.150,3.760,2.160,2.090,4.540,3.040,2.390,2.200,4.500,
2.750,0.202,2.020,3.040,3.450,2.690,2.800,5.980,4.330,2.570,
2.090,3.260,3.090,2.280,2.200,2.940,3.260,0.362,2.080,2.960,
3.060,2.720,2.630,4.670,0.250,0.208,0.139,0.244,0.157,0.192,
0.177,0.183,0.187,0.026,0.147,0.203,0.231,0.272,0.187,0.303,
2.400,2.450,1.840,3.170,0.145,0.162,0.150,0.294,2.040,0.203,
1.640,2.320,1.850,2.180,2.160,3.520,2.790,1.900,1.970,3.450,
2.730,2.430,2.320,3.720,2.640,0.222,2.540,3.270,3.090,2.340,
3.670,5.740,6.730,3.240,3.020,5.390,2.820,1.740,2.150,2.470,
3.120,0.310,1.800,2.870,4.010,2.800,2.490,5.860,4.460,2.560,
2.010,3.150,2.500,1.900,2.090,2.290,2.320,0.162,1.680,2.640,
2.550,2.240,1.790,3.250,3.710,2.780,2.570,4.420,0.235,0.171,
0.162,0.338,2.900,0.208,2.030,2.800,3.410,3.380,3.110,4.780,
6.800,3.130,3.520,7.150,3.980,2.860,3.290,5.220,4.600,0.279,
3.690,5.790,8.140,5.230,6.750,9.360,5.840,4.760,4.690,6.860,
4.250,2.520,2.410,3.040,3.690,0.356,1.880,3.030,5.270,3.970,
2.900,5.000,4.570,2.440,2.010,2.980,2.610,1.450,1.590,2.220,
2.150,0.170,1.220,1.780,2.220,1.930,1.610,2.770,3.850,2.580,
1.840,3.110,0.274,0.175,0.150,0.365,1.950,0.163,1.200,2.040,
1.780,2.090,1.840,2.660,5.500,2.430,2.110,4.270,3.530,1.960,
1.730,3.190,3.550,0.210,1.400,2.190,3.380,2.170,2.240,4.630,
7.040,3.410,2.300,4.450,3.730,2.250,2.020,2.370,2.730,0.253,
1.210,1.930,2.730,2.310,1.640,3.130,3.970,2.230,1.370,2.110,
2.210,1.110,1.330,1.570,2.190,0.167,1.190,1.600,1.740,1.490,
1.090,1.760,2.990,2.420,1.670,2.460,0.254,0.188,0.180,0.256,
2.460,0.371,1.210,1.870,1.570,2.420,1.580,2.240,3.450,1.990,
1.240,2.640,2.870,1.970,1.490,2.480,2.200,0.170,1.100,1.980,
2.300,2.220,1.740,3.550,4.690,2.620,1.820,3.090,3.710,2.490,
2.720,2.780,3.270,0.356,1.430,2.170,3.060,2.800,2.380,4.170,
0.369,0.341,0.202,0.287,0.302,0.285,0.372,0.300,0.269,0.041,
0.218,0.252,0.381,0.479,0.295,0.471,2.500,1.830,1.870,2.310,
0.228,0.175,0.200,0.290,1.930,0.257,1.160,1.500,1.710,2.780,
2.220,2.290,2.490,1.440,1.280,2.180,3.060,2.290,2.070,2.830,
2.230,0.259,1.410,2.150,2.790,3.890,2.490,4.070,5.010,2.200,
1.850,3.600,2.460,1.470,2.010,2.010,3.040,0.264,1.360,1.970,
3.630,2.510,2.270,4.330,3.450,2.310,1.660,2.340,2.220,2.030,
2.330,2.190,2.120,0.171,1.640,2.050,2.530,2.230,2.130,3.100,
2.700,2.400,2.080,2.920,0.255,0.162,0.177,0.283,2.000,0.179,
1.560,2.100,2.110,2.570,2.450,3.180,3.830,2.100,1.870,3.610,
2.350,1.450,1.870,2.650,3.220,0.224,2.070,3.640,4.870,3.790,
4.090,7.590,0.437,0.325,0.252,0.359,0.293,0.221,0.183,0.241,
0.238,0.041,0.132,0.185,0.311,0.452,0.243,0.353,0.340,0.235,
0.218,0.250,0.246,0.179,0.237,0.225,0.187,0.035,0.129,0.181,
0.169,0.203,0.168,0.257,0.242,0.182,0.172,0.227,0.024,0.019,
0.017,0.033,0.156,0.018,0.105,0.150,0.130,0.175,0.159,0.235,
0.311,0.176,0.158,0.275,0.265,0.193,0.173,0.269,0.249,0.027,
0.148,0.195,0.244,0.238,0.235,0.431,0.354,0.260,0.148,0.255,
0.228,0.203,0.159,0.170,0.156,0.023,0.082,0.130,0.145,0.166,
0.137,0.220,0.270,0.242,0.133,0.164,0.226,0.176,0.163,0.175,
0.193,0.033,0.121,0.148,0.130,0.160,0.133,0.175,0.198,0.185,
0.145,0.191,0.023,0.032,0.026,0.024,0.204,0.050,0.134,0.179,
0.118,0.206,0.165,0.199,0.210,0.138,0.103,0.183,0.190,0.167,
0.132,0.182,0.154,0.018,0.096,0.141,0.152,0.179,0.133,0.259,
0.290,0.178,0.139,0.187,0.249,0.226,0.320,0.210,0.201,0.034,
0.153,0.149,0.168,0.239,0.179,0.273,0.023,0.027,0.018,0.025,
0.026,0.038,0.049,0.030,0.025,0.012,0.055,0.026,0.018,0.059,
0.031,0.034,0.241,0.195,0.286,0.263,0.031,0.037,0.044,0.034,
0.182,0.035,0.157,0.167,0.158,0.311,0.220,0.234,0.213,0.148,
0.125,0.195,0.271,0.322,0.221,0.258,0.222,0.069,0.177,0.219,
0.314,1.640,0.311,0.407,0.343,0.257,0.188,0.292,0.211,0.163,
0.189,0.183,0.222,0.027,0.125,0.168,0.272,0.261,0.231,0.431,
0.324,0.244,0.188,0.262,0.263,0.242,0.275,0.288,0.209,0.026,
0.218,0.243,0.239,0.316,0.253,0.361,0.216,0.197,0.186,0.251,
0.021,0.020,0.019,0.027,0.164,0.022,0.166,0.202,0.154,0.213,
0.225,0.300,0.285,0.182,0.159,0.285,0.210,0.170,0.169,0.240,
0.261,0.027,0.182,0.314,0.340,0.449,0.351,0.666,4.960,2.980,
2.420,3.880,2.650,1.850,1.590,2.070,2.350,0.203,1.220,1.820,
2.270,1.880,1.630,2.690,3.590,2.470,1.590,2.210,2.990,1.750,
2.030,2.000,2.570,0.229,1.900,2.010,1.750,2.110,1.660,2.340,
2.390,2.500,1.780,2.450,0.279,0.253,0.217,0.414,1.730,0.196,
1.500,1.710,1.180,1.980,1.460,2.140,2.420,1.590,1.320,2.350,
2.360,1.660,1.500,2.300,2.270,0.190,1.660,2.520,2.300,1.780,
2.530,4.410,0.319,0.217,0.140,0.223,0.232,0.220,0.205,0.187,
0.132,0.024,0.095,0.131,0.137,0.155,0.115,0.219,0.218,0.181,
0.091,0.129,0.317,0.168,0.165,0.142,0.144,0.030,0.144,0.147,
0.105,0.133,0.104,0.131,0.151,0.190,0.120,0.160,0.023,0.036,
0.029,0.030,0.138,0.037,0.221,0.204,0.083,0.176,0.128,0.163,
0.249,0.165,0.111,0.240,0.255,0.245,0.167,0.269,0.170,0.019,
0.135,0.273,0.170,0.163,0.181,0.336,3.310,1.950,2.170,1.980,
2.920,2.540,6.370,2.610,2.100,0.315,1.770,2.560,1.600,1.750,
2.210,3.490,0.213,0.222,0.160,0.145,0.212,0.244,0.379,0.170,
0.164,0.038,0.202,0.200,0.165,0.238,0.276,0.260,2.440,2.180,
1.860,2.010,0.205,0.208,0.276,0.247,1.560,0.194,0.747,1.110,
0.952,1.440,1.370,1.620,1.690,1.130,1.060,1.440,2.130,1.900,
1.910,1.860,1.680,0.183,1.540,1.830,1.570,1.700,2.030,2.680,
3.510,1.850,1.650,2.110,1.950,1.380,1.960,1.410,1.720,0.185,
1.290,1.760,1.740,1.650,1.390,2.510,2.840,2.090,1.740,1.790,
2.280,2.010,2.240,1.590,1.870,0.173,2.000,2.070,1.670,2.020,
1.910,2.330,2.650,2.220,2.350,2.450,0.191,0.183,0.194,0.226,
1.960,0.211,2.670,2.690,1.430,1.990,2.130,2.470,2.410,1.430,
1.500,2.080,1.850,1.590,1.550,1.820,2.360,0.193,2.320,2.650,
2.690,2.630,2.890,3.970,5.800,2.460,2.020,3.970,2.610,1.420,
1.340,1.990,2.260,0.202,1.040,1.680,2.840,2.240,1.870,3.380,
3.290,1.840,1.210,1.900,1.800,0.998,1.240,1.570,1.560,0.105,
0.971,1.370,1.420,1.290,1.130,1.940,2.850,2.090,1.300,2.440,
0.210,0.144,0.118,0.303,1.850,0.133,1.080,1.730,1.460,1.610,
1.560,2.640,3.720,2.040,1.580,3.010,2.280,1.420,1.330,2.300,
2.070,0.149,1.320,2.130,2.750,1.830,2.230,5.090,5.800,2.900,
2.010,3.660,2.980,2.020,1.680,2.160,2.280,0.196,1.350,2.030,
2.310,2.210,1.490,3.070,3.310,2.200,1.270,2.030,2.310,1.650,
1.660,1.950,1.910,0.139,1.450,1.960,1.400,1.450,1.100,1.860,
2.720,2.290,1.530,2.860,0.202,0.174,0.125,0.239,2.060,0.206,
1.620,2.390,1.550,2.200,1.670,2.840,3.350,2.230,1.740,3.060,
2.910,2.160,1.770,2.910,2.350,0.173,1.580,2.810,2.390,2.140,
2.210,4.520,4.360,2.180,1.910,2.610,3.360,2.370,3.490,2.880,
2.650,0.321,1.690,2.790,2.330,2.780,2.790,4.310,0.269,0.189,
0.175,0.209,0.199,0.219,0.718,0.246,0.144,0.030,0.178,0.341,
0.185,0.281,0.215,0.290,2.730,2.400,1.860,2.560,0.186,0.168,
0.331,0.276,2.190,0.239,1.500,2.290,1.620,2.440,1.890,3.010,
2.740,1.880,1.720,2.450,2.950,2.420,2.910,3.150,2.570,0.236,
2.320,3.900,2.600,2.590,3.210,4.900,4.980,2.140,1.810,3.000,
2.330,1.470,1.600,1.740,2.390,0.268,1.400,2.160,2.530,2.040,
1.730,3.820,3.350,1.980,1.460,2.130,2.160,1.720,2.210,1.900,
1.780,0.121,1.480,2.280,1.850,1.750,1.690,2.690,3.180,2.620,
2.310,3.300,0.203,0.179,0.172,0.276,2.690,0.201,2.350,3.190,
2.250,2.620,2.500,3.150,4.380,2.230,2.200,4.110,3.040,2.190,
2.730,3.560,3.510,0.223,2.870,4.640,4.580,3.560,4.160,6.750,
21.5,7.470,6.920,14.1,5.910,3.160,2.870,4.180,6.030,0.456,
2.680,4.750,9.640,6.620,3.960,9.270,6.350,2.980,2.300,3.610,
2.970,1.600,1.700,2.300,3.050,0.174,1.520,2.220,3.400,2.640,
2.020,3.750,5.000,2.810,2.480,4.940,0.332,0.215,0.179,0.454,
3.140,0.327,1.320,2.230,2.860,3.040,2.530,4.130,8.120,3.280,
3.140,7.140,5.000,2.550,2.430,4.400,3.780,0.242,1.860,3.350,
7.680,3.710,3.950,10.1,8.590,3.500,2.320,4.620,3.400,1.930,
1.510,2.080,2.650,0.267,1.120,1.980,3.260,2.450,1.640,3.380,
3.910,1.950,1.270,2.080,1.950,1.040,1.010,1.270,2.270,0.199,
1.110,1.550,2.120,1.570,1.260,2.090,3.140,2.350,1.490,2.810,
0.239,0.294,0.111,0.219,6.160,2.430,1.230,1.990,2.420,5.710,
1.490,2.540,3.380,1.810,1.500,2.730,2.470,1.610,1.160,1.930,
2.320,0.332,1.010,1.780,2.650,2.270,2.030,3.920,6.580,2.680,
2.070,3.940,3.980,3.290,2.040,3.210,3.370,0.336,1.220,2.380,
4.520,3.310,2.280,5.630,0.378,0.221,0.150,0.294,0.267,0.210,
0.179,0.280,0.245,0.024,0.122,0.231,0.461,0.410,0.221,0.522,
2.910,1.860,1.770,2.810,0.224,0.151,0.132,0.270,2.580,0.259,
0.965,1.700,2.240,2.330,2.150,2.950,3.410,1.780,1.680,3.210,
3.230,1.970,1.710,2.970,2.620,0.199,1.420,2.600,3.720,2.750,
2.770,5.780,10.1,3.520,3.170,7.400,3.830,2.300,2.250,3.320,
4.640,0.347,2.190,3.790,8.390,4.540,3.600,8.810,5.160,2.600,
2.110,3.420,2.590,1.780,1.680,2.310,3.010,0.166,1.720,2.840,
4.470,3.280,2.560,4.990,3.880,2.810,2.280,3.700,0.246,0.170,
0.148,0.301,3.200,0.296,1.740,2.940,3.390,3.940,3.420,5.470,
7.480,3.370,3.300,8.250,4.220,2.450,2.420,4.240,5.190,0.303,
3.140,5.630,9.720,6.840,7.650,17.8,7.590,3.750,2.790,5.620,
3.670,2.150,1.700,2.440,2.930,0.235,1.320,2.400,3.810,2.960,
2.470,4.730,3.950,2.240,1.710,2.790,2.300,1.450,1.820,1.850,
1.960,0.133,1.090,1.610,1.860,1.600,1.340,2.490,3.210,1.880,
1.410,2.680,0.177,0.129,0.101,0.227,1.670,0.132,0.898,1.370,
1.680,1.660,1.680,2.610,3.550,1.870,1.580,3.150,2.540,1.650,
1.320,2.240,2.040,0.156,1.130,1.960,2.790,2.080,2.070,5.310,
5.240,2.780,1.640,3.110,2.640,1.750,1.160,1.700,1.690,0.136,
0.808,1.510,2.120,1.660,1.190,2.690,2.770,1.840,1.010,1.730,
1.640,1.120,0.941,1.260,1.510,0.114,0.789,1.220,1.370,1.230,
0.922,1.820,2.360,1.680,1.080,2.030,0.135,0.110,0.074,0.142,
1.980,0.283,0.848,1.410,1.470,1.800,1.540,2.300,2.170,1.330,
1.310,2.020,1.740,1.340,0.910,1.520,1.440,0.111,0.789,1.460,
1.810,1.520,1.380,2.920,4.140,1.880,1.550,2.550,2.480,1.660,
1.530,2.110,2.110,0.227,0.957,1.660,2.440,2.190,1.550,3.770,
0.194,0.131,0.088,0.168,0.131,0.143,0.103,0.198,0.110,0.018,
0.102,0.125,0.182,0.237,0.123,0.242,2.580,1.760,1.550,2.200,
0.168,0.166,0.109,0.202,1.710,0.150,0.943,1.600,1.770,1.930,
1.530,2.710,2.740,1.550,1.430,2.440,2.620,2.620,1.650,2.470,
2.140,0.211,1.340,2.400,2.720,3.510,2.430,5.250,4.760,2.240,
1.900,3.990,2.280,1.420,1.430,1.930,2.860,0.216,1.270,2.090,
3.780,2.620,2.030,5.000,3.590,2.090,1.590,2.660,2.050,1.600,
1.380,2.250,1.980,0.154,1.350,2.250,2.590,2.620,2.010,3.640,
2.560,1.950,1.590,2.670,0.142,0.116,0.088,0.185,1.830,0.128,
1.420,2.050,1.970,1.940,1.950,3.580,3.840,1.890,1.860,3.540,
2.540,1.860,1.520,2.290,3.020,0.185,1.930,3.450,4.350,3.220,
3.670,8.560,7.750,4.290,3.290,6.420,4.270,2.580,1.930,2.950,
4.650,0.313,1.850,2.790,4.120,3.140,2.130,4.720,5.510,3.530,
2.090,3.440,3.320,2.150,1.870,2.260,3.500,0.266,2.090,2.720,
3.350,3.540,2.410,4.140,3.760,3.270,2.280,4.050,0.313,0.277,
0.208,0.481,2.740,0.229,1.490,2.180,2.200,2.930,2.140,3.650,
4.170,2.640,2.150,4.930,3.200,2.220,1.870,3.490,3.420,0.248,
2.080,3.340,4.130,3.030,4.000,7.950,0.401,0.292,0.173,0.335,
0.441,0.282,0.155,0.242,0.258,0.023,0.119,0.215,0.236,0.234,
0.165,0.346,0.269,0.217,0.113,0.195,0.244,0.207,0.134,0.162,
0.200,0.025,0.164,0.234,0.201,0.224,0.140,0.258,0.199,0.180,
0.107,0.216,0.021,0.021,0.016,0.024,0.227,0.049,0.127,0.183,
0.145,0.248,0.151,0.254,0.318,0.208,0.149,0.412,0.286,0.256,
0.161,0.317,0.225,0.022,0.140,0.264,0.285,0.248,0.245,0.527,
5.140,2.930,2.170,2.910,3.800,2.870,2.840,2.830,2.990,0.378,
1.780,3.200,2.670,2.730,2.490,4.910,0.263,0.215,0.132,0.194,
0.309,0.192,0.157,0.149,0.185,0.029,0.149,0.192,0.259,0.305,
0.233,0.344,2.780,2.890,2.140,2.790,0.226,0.237,0.169,0.260,
2.230,0.232,1.170,1.960,1.730,2.270,2.000,3.070,3.020,2.410,
1.800,2.820,3.290,3.410,2.080,2.770,3.010,0.277,2.260,3.230,
3.110,2.780,3.240,5.200,6.020,3.190,2.370,4.140,3.470,2.250,
1.850,2.470,3.160,0.278,2.440,3.280,3.620,2.930,2.370,5.040,
5.140,3.300,2.410,3.620,3.570,2.650,2.080,2.250,3.150,0.232,
2.790,3.360,3.660,3.880,2.930,4.640,3.960,3.450,2.680,3.970,
0.225,0.219,0.180,0.347,3.320,0.243,2.610,3.730,2.890,3.490,
3.240,4.610,4.740,2.860,2.640,4.170,2.960,2.540,2.080,2.930,
4.250,0.302,3.710,4.600,4.890,4.430,4.830,7.820,21.5,5.750,
4.280,10.3,5.130,2.680,2.160,3.800,5.040,0.337,2.180,3.810,
6.640,4.410,3.420,8.910,6.160,3.060,1.840,3.370,3.120,1.900,
1.500,2.160,3.120,0.184,1.770,2.520,3.070,2.530,1.880,3.870,
5.320,3.390,2.370,6.010,0.295,0.210,0.152,0.473,3.240,0.219,
1.620,2.920,3.180,3.090,2.380,5.140,8.390,4.210,3.390,8.750,
4.240,2.600,2.240,5.020,4.550,0.292,2.700,4.990,7.340,5.220,
5.370,15.7,8.280,4.160,2.810,5.780,4.610,2.950,1.850,2.920,
3.160,0.219,1.560,3.040,3.700,2.970,2.110,4.870,5.360,3.300,
1.760,3.080,3.720,3.580,1.570,2.230,2.980,0.177,1.670,2.660,
2.610,2.390,1.550,3.160,3.820,2.920,1.700,4.950,0.201,0.170,
0.100,0.298,2.940,0.259,1.680,2.900,2.830,3.000,2.070,4.380,
4.810,2.800,2.100,5.250,3.350,2.640,1.780,4.030,3.360,0.193,
1.960,3.600,4.710,3.530,3.190,7.990,8.420,4.040,3.170,4.780,
5.760,3.440,2.950,4.600,4.410,0.400,2.300,4.170,4.980,3.890,
3.410,7.540,0.328,0.247,0.150,0.268,0.252,0.205,0.187,0.231,
0.179,0.019,0.147,0.251,0.332,0.299,0.192,0.442,4.620,3.720,
2.670,4.790,0.242,0.188,0.162,0.376,3.710,0.280,2.590,3.890,
3.380,3.710,3.770,6.250,5.830,3.560,3.050,5.340,4.780,3.630,
3.390,5.870,5.010,0.300,3.900,5.920,5.700,4.010,5.770,10.1,
20.5,6.190,4.490,10.6,6.590,3.630,3.010,4.760,5.980,0.432,
3.100,5.660,9.500,6.390,4.970,14.3,7.590,4.150,2.780,5.290,
4.780,3.130,2.440,3.610,4.260,0.232,2.780,4.510,5.870,4.510,
3.700,8.030,7.030,5.130,3.720,6.990,0.291,0.235,0.197,0.506,
5.830,0.311,3.660,5.850,6.480,6.120,5.780,10.2,18.4,5.330,
4.680,12.8,5.730,3.700,4.270,10.1,7.590,0.396,5.180,9.930,
13.2,7.570,7.080,26.2,39.2,13.0,6.160,12.8,17.0,7.230,
5.470,6.920,12.3,1.110,4.130,6.680,16.5,11.1,7.000,10.5,
19.4,8.480,4.740,6.540,8.710,5.390,4.150,4.110,7.560,0.565,
3.590,4.540,5.890,4.880,3.590,5.820,12.1,8.280,5.360,8.490,
0.974,0.767,0.525,1.120,6.080,0.563,3.340,4.560,5.980,6.560,
3.780,5.850,16.3,6.810,6.230,13.3,10.3,6.560,5.310,9.990,
7.190,0.585,3.750,6.290,9.510,5.550,5.400,9.310,25.2,9.160,
4.870,7.910,11.5,6.080,3.750,4.130,6.500,0.674,2.630,3.880,
5.310,5.080,2.850,4.770,10.6,6.110,2.950,3.960,5.850,3.810,
2.610,2.730,4.840,0.481,2.390,3.200,3.060,3.090,2.030,3.170,
6.700,5.720,3.050,4.340,0.529,0.473,0.319,0.458,4.220,0.418,
2.360,3.260,2.920,4.070,2.460,3.680,5.690,3.760,2.290,3.960,
5.200,3.750,2.380,3.360,4.230,0.324,2.020,3.210,3.850,3.070,
2.980,5.240,11.2,4.940,3.720,5.420,8.570,4.640,3.750,3.980,
6.160,0.675,2.440,4.040,4.760,4.230,3.130,5.810,0.840,0.590,
0.327,0.492,0.691,0.674,0.371,0.409,0.563,0.088,0.335,0.517,
0.610,0.764,0.431,0.709,4.750,4.000,2.960,3.500,0.490,0.338,
0.318,0.426,3.240,0.343,1.980,2.800,2.340,3.240,2.320,2.920,
4.280,2.810,2.360,3.830,6.240,3.940,3.340,4.020,4.180,0.368,
2.360,3.800,3.510,3.340,3.410,4.810,17.7,6.160,4.730,9.540,
7.550,3.610,3.030,3.770,7.460,0.733,2.800,4.430,7.890,5.470,
3.890,8.940,10.1,5.720,3.820,5.400,6.440,4.290,3.200,3.500,
6.500,0.433,2.980,4.900,5.990,5.290,4.050,6.470,6.010,4.730,
3.520,4.750,0.516,0.376,0.314,0.439,3.880,0.300,2.140,3.430,
3.600,4.370,3.130,4.500,8.530,4.240,3.430,6.970,5.150,3.400,
2.700,4.100,5.710,0.386,3.070,5.520,7.040,5.100,4.710,8.000,
17.3,9.490,5.350,9.210,7.730,4.520,2.780,2.520,4.110,0.503,
1.890,2.850,4.680,5.210,3.120,4.670,8.960,6.630,3.340,4.350,
6.140,4.140,3.030,2.910,3.890,0.429,2.180,3.160,2.710,3.130,
2.090,3.270,5.100,5.460,2.960,4.640,0.541,0.576,0.347,0.492,
2.340,0.263,1.580,2.180,2.080,3.030,1.910,3.010,4.780,2.540,
2.360,3.980,4.160,3.480,2.380,2.730,2.310,0.253,1.450,2.110,
2.580,2.110,2.290,3.680,10.7,7.880,3.310,4.780,5.750,4.900,
2.800,2.380,3.170,0.434,1.410,2.050,2.400,3.120,1.660,2.640,
5.880,4.730,2.200,2.560,3.930,2.260,2.270,2.120,2.980,0.399,
1.690,2.250,1.650,2.250,1.370,1.780,4.230,5.150,2.190,2.880,
0.447,0.634,0.324,0.319,2.700,0.434,1.610,2.060,1.660,3.470,
1.750,2.670,3.030,2.310,1.320,2.030,3.580,3.400,1.820,1.870,
2.300,0.244,1.170,1.670,1.700,1.820,1.450,2.410,5.810,3.950,
2.370,3.320,5.770,4.160,3.710,2.920,3.250,0.437,1.560,2.470,
2.350,2.640,1.980,3.340,0.382,0.441,0.218,0.305,0.385,0.524,
0.349,0.262,0.295,0.083,0.246,0.326,0.212,0.401,0.236,0.321,
3.740,4.870,2.680,2.940,0.439,0.501,0.365,0.371,2.800,0.368,
1.860,2.340,1.630,2.940,2.180,2.500,2.520,1.880,1.490,2.160,
3.900,3.900,2.730,2.790,2.730,0.263,1.790,2.770,2.020,2.010,
2.340,3.400,5.580,2.380,1.910,3.110,3.530,2.190,1.570,1.750,
2.480,0.237,1.030,1.660,2.560,2.090,1.450,3.000,4.400,3.400,
2.310,2.920,3.330,3.130,2.070,2.240,2.130,0.224,1.550,2.280,
1.830,2.520,1.860,2.820,3.430,3.570,2.320,2.890,0.308,0.300,
0.189,0.267,2.520,0.223,1.570,2.180,1.880,2.890,1.900,2.730,
3.890,2.190,1.910,2.850,2.860,2.410,1.860,2.240,3.050,0.349,
1.830,2.990,3.450,3.380,3.090,4.490,7.850,5.360,3.010,4.700,
4.200,2.810,1.780,2.340,3.040,0.345,1.350,2.220,3.160,3.230,
1.670,3.460,5.930,4.430,2.690,3.050,3.380,2.550,1.960,1.910,
4.100,0.440,2.120,2.500,2.500,3.450,1.590,2.700,3.550,4.370,
2.510,3.430,0.424,0.492,0.358,0.572,2.380,0.276,1.180,1.820,
1.930,3.200,1.640,3.110,3.550,2.130,2.070,3.250,3.140,2.610,
2.270,2.990,2.650,0.274,1.530,2.640,3.050,2.250,3.080,6.220,
0.592,0.457,0.270,0.373,0.649,0.441,0.231,0.266,0.279,0.054,
0.157,0.232,0.235,0.350,0.175,0.313,0.441,0.387,0.279,0.248,
0.381,0.366,0.247,0.208,0.343,0.096,0.237,0.278,0.202,0.370,
0.159,0.230,0.279,0.420,0.228,0.268,0.055,0.083,0.063,0.052,
0.284,0.069,0.181,0.261,0.203,0.412,0.206,0.336,0.409,0.264,
0.216,0.392,0.508,0.559,0.431,0.468,0.330,0.046,0.232,0.336,
0.333,0.304,0.354,0.590,3.540,2.470,1.500,2.030,3.090,2.710,
1.760,1.730,2.680,0.430,1.580,2.680,1.600,2.090,1.460,2.100,
0.313,0.337,0.151,0.178,0.244,0.283,0.196,0.155,0.261,0.068,
0.198,0.299,0.222,0.398,0.173,0.236,2.090,3.100,1.590,1.580,
0.244,0.348,0.212,0.223,1.830,0.280,0.956,1.350,1.170,2.230,
1.380,1.450,1.700,1.420,1.110,1.350,2.180,2.390,1.560,1.920,
1.970,0.237,1.400,1.980,1.350,1.690,1.640,1.920,3.950,1.950,
1.330,2.470,2.780,1.520,0.968,1.310,2.360,0.266,1.310,1.790,
2.210,1.880,1.200,2.460,4.490,3.190,1.820,2.350,3.130,2.610,
1.700,1.730,2.500,0.281,1.750,2.580,2.400,3.380,1.700,2.480,
2.850,3.270,2.380,2.330,0.286,0.351,0.212,0.254,2.160,0.244,
1.440,2.110,1.870,2.880,2.040,2.780,3.310,1.810,1.820,2.200,
2.610,2.430,1.680,2.140,2.920,0.318,2.410,2.970,2.980,3.100,
2.980,4.160,11.4,5.630,3.690,7.480,4.390,2.500,1.960,2.750,
3.500,0.367,1.560,2.780,5.360,4.100,2.460,5.590,4.990,3.160,
1.830,2.760,2.530,1.640,1.420,1.580,2.690,0.233,1.440,2.380,
2.370,2.260,1.410,2.710,3.930,3.290,2.080,3.600,0.327,0.280,
0.196,0.409,2.130,0.186,0.940,1.850,2.400,2.240,1.410,2.860,
5.580,2.830,2.850,6.160,3.660,2.570,2.180,3.650,3.140,0.240,
1.730,3.270,4.910,3.050,3.520,8.050,8.030,5.000,2.710,5.270,
5.700,3.610,2.110,3.180,3.460,0.394,1.640,3.040,3.130,3.400,
1.810,3.580,5.030,3.500,2.100,2.980,3.640,2.640,1.630,1.940,
3.120,0.673,1.840,3.370,2.170,2.920,1.330,2.500,3.390,3.330,
1.660,2.920,0.261,0.286,0.174,0.293,2.570,0.256,1.390,2.590,
2.090,2.740,1.610,3.140,4.060,2.250,1.840,3.650,3.790,3.310,
2.120,3.490,3.260,0.251,1.780,2.970,3.140,2.640,2.930,4.900,
4.390,2.630,2.020,3.050,3.730,2.470,1.960,2.510,3.290,0.417,
2.280,4.280,2.640,2.530,2.050,3.360,0.355,0.286,0.160,0.297,
0.254,0.266,0.183,0.221,0.268,0.065,0.307,1.680,0.247,0.334,
0.197,0.445,2.500,2.920,1.680,2.320,0.225,0.208,0.171,0.287,
2.320,0.235,1.260,2.140,1.880,2.400,1.650,2.410,2.750,1.880,
1.780,2.380,3.310,2.450,2.390,3.090,3.150,0.300,1.820,3.440,
2.420,2.310,2.280,3.460,7.150,3.150,2.310,4.210,3.780,2.090,
1.790,2.200,3.470,0.313,1.700,2.820,4.200,2.960,2.470,5.370,
3.940,2.630,1.590,2.430,2.660,2.000,1.480,1.930,2.400,0.200,
1.640,4.230,2.530,2.630,1.880,3.520,4.200,4.250,2.560,3.570,
0.367,0.331,0.182,0.316,3.400,0.251,1.970,3.120,3.650,3.940,
2.760,4.120,5.860,3.230,2.680,5.280,4.390,3.530,2.500,3.800,
5.230,0.313,3.300,5.440,6.920,4.590,4.780,8.340,15.6,9.590,
6.040,10.1,12.7,7.010,4.400,4.830,6.870,0.778,2.980,4.510,
7.630,7.090,3.560,6.070,8.440,7.240,3.820,4.330,6.810,5.290,
3.460,3.200,4.910,0.523,3.150,3.430,3.220,3.870,2.540,3.900,
4.420,4.280,2.860,3.640,0.490,0.433,0.335,0.503,2.610,0.316,
1.980,1.940,2.270,3.150,2.080,2.960,5.540,2.960,2.370,4.390,
5.230,3.750,2.470,3.650,3.220,0.440,1.920,2.770,3.590,2.810,
2.980,4.890,13.6,8.040,3.480,5.550,24.9,7.160,3.700,3.740,
5.810,0.700,2.520,3.390,3.660,4.620,2.150,4.050,6.990,5.980,
2.440,2.960,6.130,3.790,2.610,2.650,3.960,0.563,2.810,3.220,
2.310,3.230,1.860,3.270,3.540,3.980,1.940,2.390,0.624,0.429,
0.335,0.343,2.750,0.424,1.950,2.080,1.890,3.340,2.100,2.640,
2.870,2.430,1.120,1.860,3.700,2.960,1.510,2.110,2.220,0.244,
1.400,1.960,1.990,2.110,1.870,3.150,5.590,3.730,2.000,2.870,
8.210,6.180,2.810,3.050,4.550,0.649,1.750,2.310,2.640,2.900,
1.780,3.260,0.491,0.799,0.257,0.372,0.835,1.950,0.420,0.476,
0.426,0.137,0.319,0.416,0.308,0.621,0.275,0.432,2.470,2.960,
1.900,2.110,0.359,0.377,0.218,0.324,2.350,0.331,1.660,2.130,
1.470,2.380,1.630,2.070,2.070,1.710,1.200,2.000,3.420,3.340,
1.900,2.690,2.450,0.335,1.880,2.310,2.010,2.390,2.010,2.980,
5.480,2.900,1.890,3.740,3.500,2.460,1.350,1.800,2.960,0.367,
1.250,2.020,2.930,2.250,1.590,3.610,5.040,4.690,2.370,3.470,
4.700,5.890,2.380,2.630,2.840,0.381,2.040,2.860,2.180,3.020,
1.850,3.140,2.400,2.410,1.740,2.370,0.347,0.250,0.231,0.289,
1.850,0.232,1.200,1.950,1.630,2.440,1.480,2.440,3.650,2.150,
1.560,3.110,2.580,2.250,1.650,2.230,2.670,0.264,1.750,3.260,
3.580,3.200,2.980,5.330,9.330,6.570,3.840,5.590,7.600,5.850,
3.410,3.460,3.290,0.448,1.550,2.340,2.930,3.240,1.850,3.210,
6.000,5.970,2.860,3.060,5.970,4.700,3.150,2.790,2.920,0.472,
2.210,2.680,1.610,2.440,1.630,2.190,2.640,3.550,2.240,2.440,
0.355,0.471,0.341,0.374,1.590,0.245,1.350,1.440,1.140,2.110,
1.440,2.030,2.350,1.470,1.240,2.160,2.870,2.850,1.780,2.310,
1.850,0.259,1.140,1.540,1.770,1.570,1.550,2.870,6.230,5.500,
2.250,2.840,6.850,5.740,2.650,2.400,2.740,0.421,1.350,1.780,
1.590,2.390,1.080,1.820,4.090,4.060,1.840,1.830,2.410,0.966,
1.660,1.430,2.440,0.490,1.870,2.360,1.070,2.010,1.240,1.440,
2.380,3.830,1.690,1.980,0.382,0.596,0.385,0.314,1.960,0.382,
1.400,1.650,1.060,2.640,1.560,1.880,1.710,1.680,0.859,1.250,
2.410,2.980,1.470,1.710,1.630,0.223,1.250,1.740,1.160,1.500,
1.140,1.970,3.920,3.070,1.550,2.150,5.630,5.250,3.220,2.640,
2.700,0.491,1.450,1.860,1.640,2.290,1.590,2.340,0.333,0.572,
0.225,0.271,0.616,0.968,0.539,0.326,0.322,0.188,0.394,0.382,
0.168,0.545,0.245,0.256,2.740,4.050,2.270,2.140,0.626,0.750,
0.454,0.377,2.310,0.415,1.800,1.980,1.190,2.880,2.280,2.030,
1.810,1.420,1.230,1.430,4.100,4.650,3.270,2.750,2.360,0.309,
1.800,2.170,1.640,1.890,2.070,2.600,3.210,2.050,1.280,2.000,
2.660,2.080,1.170,1.280,1.660,0.177,0.817,1.110,1.490,1.370,
0.941,1.770,3.200,3.340,1.960,2.350,3.220,4.090,2.200,2.080,
1.620,0.274,1.460,1.810,1.040,2.090,1.240,1.880,2.080,2.750,
1.710,1.840,0.267,0.321,0.219,0.210,1.360,0.173,1.200,1.560,
1.030,1.830,1.380,1.830,2.910,1.560,1.250,1.680,2.150,2.250,
2.730,1.870,1.690,0.181,1.290,2.000,2.460,2.070,2.080,3.110,
5.090,3.900,2.220,3.150,6.140,3.090,1.840,2.210,2.280,0.302,
1.170,1.730,2.110,2.390,1.350,2.380,4.640,4.800,1.890,2.440,
4.030,3.860,2.290,2.360,3.210,0.579,2.690,2.790,1.690,3.220,
1.460,2.290,2.030,3.520,1.700,2.050,0.329,0.435,0.293,0.448,
1.720,0.289,1.210,1.710,1.130,2.370,1.190,2.010,1.880,1.360,
0.939,1.760,2.110,2.290,1.410,2.030,1.940,0.253,1.370,2.090,
1.740,1.500,1.740,3.290,0.761,0.349,0.168,0.219,2.090,0.614,
0.417,0.318,0.271,0.065,0.152,0.205,0.200,0.266,0.148,0.217,
0.303,0.398,0.165,0.170,0.487,0.541,0.321,0.275,0.301,0.135,
0.339,0.313,0.146,0.300,0.155,0.177,0.177,0.405,0.194,0.177,
0.089,0.160,0.141,0.070,0.241,0.106,0.242,0.279,0.137,0.375,
0.239,0.257,0.180,0.171,0.100,0.172,0.348,0.457,0.266,0.324,
0.203,0.049,0.200,0.266,0.157,0.187,0.203,0.309,3.560,2.920,
1.330,1.640,3.690,4.100,2.400,2.090,2.760,0.554,1.860,2.110,
1.390,2.070,1.530,1.940,0.267,0.542,0.188,0.201,0.339,0.696,
0.417,0.249,0.321,0.154,0.371,0.326,0.169,0.427,0.231,0.220,
1.800,3.810,1.860,1.710,0.305,0.534,0.364,0.328,2.200,0.507,
1.380,1.850,1.080,2.810,1.940,1.930,1.370,1.430,0.931,1.170,
2.430,3.580,2.040,2.210,2.310,0.431,2.020,2.160,1.270,1.940,
1.900,2.210,2.870,1.810,1.130,1.740,2.130,1.540,0.911,1.190,
1.710,0.221,1.050,1.440,1.570,1.550,0.984,2.000,3.390,3.800,
1.650,2.120,3.500,4.410,2.250,2.250,2.600,0.450,2.430,2.780,
1.780,3.130,1.790,2.310,2.070,3.190,1.790,1.930,0.265,0.371,
0.228,0.250,2.100,0.336,1.810,2.230,1.430,2.980,1.940,2.540,
1.750,1.480,1.120,1.660,1.850,2.140,1.620,1.870,2.280,0.278,
2.210,2.750,2.140,2.490,2.330,3.080,4.770,2.540,1.910,3.360,
3.180,1.690,1.210,2.000,1.990,0.199,0.857,1.710,2.250,1.790,
1.090,2.560,3.500,2.180,1.160,1.980,2.000,1.600,1.080,1.450,
1.550,0.162,1.010,2.010,1.230,1.310,0.866,1.690,1.760,1.950,
0.973,1.650,0.155,0.159,0.094,0.224,0.957,0.103,0.579,1.070,
0.961,1.210,0.727,1.420,2.280,1.260,1.020,2.230,1.630,1.320,
0.917,1.860,1.410,0.132,0.775,1.650,1.780,1.290,1.350,3.280,
4.880,3.070,1.740,2.590,6.520,3.130,1.970,2.320,2.400,0.299,
1.320,2.010,1.840,2.150,1.180,2.090,3.090,2.720,1.250,1.790,
3.020,2.730,1.730,1.840,2.150,0.300,1.530,2.240,1.480,1.980,
1.140,1.790,1.690,2.770,0.969,1.350,0.200,0.280,0.148,0.204,
1.390,0.226,1.030,1.610,1.160,2.200,1.100,1.810,1.610,1.290,
0.903,1.480,2.180,2.360,1.280,2.250,1.540,0.185,1.120,1.770,
1.410,1.550,1.400,2.830,2.900,2.160,1.250,1.730,3.050,2.600,
1.670,1.870,2.510,0.338,1.410,1.940,1.520,1.710,1.450,2.160,
0.194,0.250,0.105,0.174,0.217,0.393,0.200,0.183,0.178,0.046,
0.163,0.275,0.140,0.254,0.146,0.209,1.650,2.420,1.260,1.660,
0.188,0.245,0.156,0.249,1.840,0.272,1.290,1.770,1.180,2.120,
1.500,1.940,1.550,1.410,1.010,1.430,2.250,2.220,1.470,2.170,
2.890,0.689,1.580,2.290,1.600,2.200,1.700,2.470,3.690,2.060,
1.390,2.350,2.060,1.600,0.991,1.290,1.850,0.213,0.957,1.550,
1.770,1.480,1.150,2.620,2.980,2.370,1.170,1.800,2.390,2.360,
1.370,1.620,1.650,0.165,1.160,1.890,1.630,1.860,1.280,2.410,
2.550,2.580,1.540,2.190,0.356,0.209,0.141,0.211,2.080,0.202,
1.540,2.110,1.850,2.720,1.820,2.910,3.310,2.050,1.580,3.090,
3.090,2.610,1.830,2.480,3.330,0.386,2.190,3.670,3.910,3.190,
2.990,4.480,7.920,4.220,3.340,5.400,5.480,3.200,2.430,3.140,
3.900,0.432,1.700,2.390,4.670,3.880,2.200,3.640,4.220,3.060,
1.780,2.490,3.580,1.950,1.820,2.620,2.370,0.249,1.650,1.720,
1.800,1.850,1.420,2.120,2.550,2.470,1.580,2.460,0.305,0.257,
0.191,0.387,1.690,0.188,1.170,1.600,1.470,1.960,1.310,1.990,
3.570,1.790,1.480,2.910,3.020,2.340,1.600,2.490,1.850,0.187,
1.180,1.840,2.310,1.560,1.970,3.660,8.180,4.690,2.410,4.060,
6.820,4.200,3.080,5.110,5.010,0.548,1.760,2.460,2.880,3.090,
1.660,2.820,4.560,3.900,1.730,2.750,3.580,1.870,2.180,5.050,
3.220,0.436,1.720,2.280,1.700,2.140,1.380,2.020,3.070,3.390,
1.860,2.670,0.403,0.378,0.296,0.542,2.410,0.328,1.640,2.200,
1.460,2.550,1.590,2.130,2.670,1.670,1.060,2.070,3.170,2.680,
1.650,2.890,1.890,0.207,1.220,2.380,1.570,1.600,1.510,3.150,
5.290,2.470,1.740,2.610,5.720,3.440,2.700,2.910,5.800,0.632,
1.720,2.090,3.260,2.920,1.870,3.030,0.480,0.444,0.209,0.334,
0.542,0.530,0.344,0.509,0.505,0.099,0.290,0.312,0.386,0.627,
0.286,0.416,2.420,2.500,1.720,2.110,0.326,0.291,0.327,0.419,
1.830,0.285,1.180,1.390,1.160,2.080,1.470,1.530,1.960,1.270,
0.986,1.770,3.260,2.890,2.140,3.150,2.220,0.269,1.330,1.740,
1.850,1.870,1.880,2.720,4.710,1.900,1.380,2.770,2.750,1.470,
1.200,1.640,3.260,0.323,1.180,1.650,3.010,2.010,1.370,3.000,
3.670,2.760,1.500,2.300,3.020,2.030,1.600,2.190,2.570,0.267,
1.420,1.800,2.100,2.010,1.360,2.290,2.380,2.230,1.760,2.310,
0.251,0.200,0.202,0.313,1.930,0.191,1.170,1.700,1.740,2.220,
1.710,2.240,3.300,1.690,1.600,3.030,2.310,1.820,1.740,2.510,
2.850,0.258,1.800,2.930,4.410,3.350,3.800,6.630,0.511,0.377,
0.214,0.359,0.482,0.381,0.250,0.448,0.261,0.045,0.130,0.178,
0.284,0.368,0.171,0.266,0.447,0.425,0.246,0.367,0.524,0.387,
0.342,0.608,0.262,0.061,0.260,0.229,0.167,0.256,0.190,0.246,
0.251,0.343,0.196,0.275,0.070,0.072,0.048,0.066,0.191,0.035,
0.157,0.187,0.123,0.229,0.150,0.224,0.265,0.169,0.130,0.241,
0.365,0.399,0.241,0.308,0.218,0.030,0.155,0.198,0.196,0.165,
0.191,0.324,0.531,0.477,0.195,0.434,0.611,0.705,0.427,1.760,
0.326,0.089,0.145,0.240,0.190,0.336,0.187,0.302,0.485,0.625,
0.241,0.428,0.547,0.523,0.531,1.660,0.447,0.162,0.253,0.343,
0.164,0.386,0.200,0.365,0.307,0.465,0.252,0.298,0.076,0.130,
0.099,0.130,0.332,0.110,0.244,0.295,0.141,0.367,0.224,0.271,
0.254,0.193,0.118,0.206,0.395,0.457,0.291,0.420,0.231,0.038,
0.179,0.263,0.161,0.195,0.168,0.323,0.349,0.237,0.137,0.208,
0.493,0.445,0.362,0.343,0.362,0.085,0.186,0.178,0.181,0.268,
0.182,0.221,0.047,0.078,0.035,0.043,0.094,0.135,0.118,0.120,
0.081,0.064,0.087,0.069,0.026,0.083,0.048,0.045,0.268,0.405,
0.258,0.295,0.077,0.125,0.109,0.094,0.316,0.127,0.280,0.261,
0.129,0.379,0.257,0.223,0.207,0.152,0.124,0.191,0.430,0.515,
0.416,0.461,0.292,0.059,0.279,0.263,0.184,0.222,0.248,0.298,
0.394,0.287,0.168,0.266,0.307,0.217,0.150,0.241,0.257,0.034,
0.117,0.161,0.244,0.232,0.164,0.317,0.523,0.789,0.306,0.374,
0.526,0.512,0.400,0.571,0.414,0.084,0.323,0.350,0.271,0.463,
0.272,0.371,0.260,0.333,0.241,0.282,0.043,0.060,0.045,0.057,
0.258,0.046,0.214,0.254,0.203,0.315,0.258,0.297,0.366,0.221,
0.178,0.293,0.281,0.291,0.267,0.287,0.321,0.043,0.249,0.334,
0.391,0.370,0.393,0.595,3.200,2.220,1.420,2.320,2.430,2.210,
1.160,1.550,1.660,0.260,1.320,1.240,2.000,1.940,0.909,1.450,
2.590,2.370,1.370,1.530,2.430,1.900,1.700,1.530,2.180,0.392,
5.050,2.080,1.130,1.850,1.330,1.450,1.860,2.950,1.600,2.120,
0.374,0.393,0.295,0.461,1.630,0.239,1.340,1.480,0.986,1.810,
1.020,1.440,1.460,1.170,0.799,1.730,1.740,1.630,1.160,1.880,
1.510,0.234,1.630,1.680,1.350,1.130,1.290,2.340,0.282,0.271,
0.127,0.193,0.396,0.587,0.186,0.331,0.171,0.046,0.136,0.146,
0.126,0.173,0.088,0.139,0.222,0.268,0.107,0.144,0.270,0.270,
0.242,0.297,0.192,0.063,0.307,0.194,0.101,0.152,0.107,0.123,
0.157,0.304,0.173,0.193,0.044,0.086,0.077,0.059,0.164,0.050,
0.175,0.192,0.121,0.207,0.122,0.162,0.192,0.142,0.090,0.208,
0.278,0.381,0.232,0.374,0.172,0.034,0.175,0.260,0.131,0.140,
0.137,0.261,2.370,1.720,1.030,1.090,2.920,2.890,1.910,1.710,
2.000,0.382,1.420,1.410,1.040,1.330,1.280,1.340,0.235,0.304,
0.127,0.135,0.286,0.420,0.283,0.215,0.236,0.092,0.338,0.214,
0.127,0.258,0.192,0.166,1.880,2.580,1.650,2.410,0.308,0.396,
0.351,0.592,1.820,0.383,0.752,1.070,0.820,1.720,1.290,1.280,
1.250,0.928,0.786,1.560,2.270,2.320,1.980,4.620,1.800,0.322,
1.570,1.730,1.000,1.250,1.390,1.700,2.390,1.250,0.838,1.230,
1.560,1.180,0.720,0.918,1.310,0.170,0.781,1.280,1.050,0.991,
0.658,1.200,2.600,2.070,1.010,1.170,2.280,2.420,1.510,1.400,
1.770,0.253,1.720,1.650,1.160,1.740,1.220,1.290,1.940,2.480,
1.410,2.030,0.226,0.316,0.212,0.397,1.530,0.224,1.320,1.510,
1.110,1.900,1.430,1.540,1.500,1.030,0.795,1.330,1.660,1.650,
1.180,2.190,1.800,0.241,1.570,1.640,1.620,1.830,1.690,2.120,
3.370,1.910,1.280,2.400,2.250,1.320,0.861,1.260,1.730,0.173,
0.677,0.967,2.730,1.420,0.775,1.710,2.440,1.600,0.909,1.360,
1.470,0.965,0.727,1.030,1.090,0.120,1.120,0.991,0.873,0.889,
0.671,1.040,1.670,2.330,0.947,1.620,0.168,0.172,0.098,0.248,
0.960,0.107,0.546,0.965,1.000,1.170,0.674,1.280,2.030,1.240,
0.909,1.920,1.570,1.180,0.858,1.530,1.230,0.118,0.813,1.330,
1.770,1.120,1.240,2.800,4.200,2.880,1.490,2.810,3.440,3.410,
1.630,2.390,2.080,0.252,1.150,1.700,1.580,1.720,0.963,1.880,
3.050,3.030,1.230,2.110,2.690,2.120,1.800,2.570,1.890,0.247,
1.570,1.990,1.140,1.450,1.220,1.540,1.940,2.740,1.260,1.870,
0.208,0.296,0.212,0.313,1.510,0.206,1.190,2.050,1.210,1.980,
1.130,2.020,2.120,1.420,1.010,1.820,2.440,2.310,1.490,2.350,
1.750,0.169,1.320,2.400,1.500,1.440,1.370,2.710,2.980,1.960,
1.170,1.680,3.070,2.250,1.810,2.170,2.050,0.287,1.200,1.720,
1.420,1.430,1.290,1.940,0.265,0.262,0.126,0.191,0.276,0.372,
0.231,0.324,0.182,0.046,0.202,0.285,0.147,0.235,0.174,0.208,
2.040,2.510,1.690,3.220,0.262,0.274,0.270,1.200,1.870,0.286,
1.030,1.610,1.200,2.060,1.460,1.850,1.740,1.290,1.030,1.560,
2.520,2.220,1.970,3.930,1.930,0.224,1.510,1.930,1.530,1.650,
1.790,2.300,3.740,1.610,1.190,2.030,1.910,1.240,0.930,1.240,
1.780,0.238,0.864,1.650,1.330,1.060,0.877,2.270,2.900,2.000,
1.090,1.570,2.360,2.020,1.360,1.600,1.620,0.165,1.280,1.960,
1.500,1.480,1.170,2.020,2.660,2.780,1.650,2.620,0.238,0.270,
0.172,0.396,2.130,0.231,1.550,2.260,1.910,2.610,2.040,2.600,
3.320,1.690,1.370,2.750,2.470,2.500,1.750,2.580,2.580,0.213,
2.030,3.070,3.160,2.460,2.850,4.540,8.070,4.530,3.550,7.390,
4.940,2.700,2.160,2.970,4.200,0.384,1.610,2.820,6.210,4.610,
2.480,5.000,4.240,2.420,1.590,2.330,3.120,1.720,1.310,1.630,
2.370,0.179,1.230,1.520,2.030,1.720,1.090,1.870,2.770,2.230,
1.660,2.990,0.291,0.226,0.184,0.364,1.770,0.153,0.923,1.550,
1.950,2.060,1.290,2.510,5.140,2.400,2.220,4.390,3.390,2.270,
1.920,3.110,2.630,0.226,1.540,2.500,3.910,2.560,2.810,6.390,
4.850,2.510,1.360,2.570,3.420,1.770,1.210,1.820,2.210,0.213,
0.889,1.350,4.490,2.350,1.060,2.120,2.770,1.860,0.952,1.520,
1.730,0.987,0.869,1.590,1.510,0.135,0.737,1.090,1.410,1.090,
0.733,1.210,1.910,1.560,1.080,1.740,0.171,0.135,0.161,0.191,
1.290,0.111,0.640,1.000,1.240,1.420,0.916,1.610,2.240,1.130,
0.932,1.720,1.800,1.280,0.902,1.460,1.250,0.100,0.701,1.330,
1.390,1.300,1.110,2.530,4.460,2.000,1.460,2.620,3.960,2.010,
1.560,2.190,3.290,0.320,0.914,1.520,3.260,2.330,1.310,2.970,
0.379,0.251,0.158,0.289,0.376,0.283,0.179,0.282,0.285,0.035,
0.122,0.203,0.397,0.411,0.179,0.384,1.910,1.630,1.570,2.100,
0.194,0.140,0.135,0.231,1.480,0.145,0.654,1.110,1.270,1.580,
1.040,1.480,1.930,1.210,1.200,2.100,2.330,1.650,1.380,2.240,
1.980,0.201,1.080,1.650,1.970,1.880,1.610,2.980,5.500,2.010,
1.640,3.690,3.150,1.320,1.060,1.580,3.200,0.256,1.230,1.780,
5.200,2.750,1.780,4.340,3.190,1.950,1.400,2.110,2.340,1.510,
1.130,1.500,2.200,0.178,1.100,1.630,2.500,2.210,1.410,2.600,
2.370,1.750,1.600,2.270,0.203,0.137,0.125,0.196,1.880,0.133,
0.988,1.520,1.980,2.140,1.470,2.310,4.230,2.040,1.910,3.800,
2.500,1.820,1.550,2.350,3.170,0.222,1.990,3.180,5.560,4.320,
4.120,8.520,7.050,4.030,2.570,5.080,5.220,3.100,2.270,3.000,
3.000,0.359,1.340,2.110,3.670,3.790,1.810,3.330,5.630,3.230,
2.030,3.520,5.250,2.490,2.210,2.900,2.330,0.281,1.500,1.970,
1.980,2.070,1.420,2.230,2.950,3.120,1.890,3.170,0.367,0.365,
0.228,0.382,1.760,0.224,1.150,1.780,1.590,2.250,1.510,2.570,
3.160,2.090,1.520,2.960,3.320,2.800,1.780,2.600,2.140,0.209,
1.380,2.130,2.320,1.790,2.000,3.960,5.430,3.600,1.620,3.180,
4.600,3.460,2.070,4.330,2.280,0.314,0.921,1.540,2.270,2.790,
1.240,2.560,3.950,3.480,1.620,2.460,3.620,2.450,2.050,3.850,
2.310,0.368,1.310,1.820,1.520,2.010,1.240,1.820,2.740,3.180,
1.750,2.440,0.352,0.448,0.394,0.386,2.220,0.363,1.270,1.780,
1.480,2.620,1.560,2.460,2.310,1.650,1.060,2.050,2.720,2.590,
1.700,2.070,1.680,0.169,1.010,1.690,1.550,1.650,1.360,2.640,
3.740,1.870,1.150,1.940,3.580,2.330,1.830,2.120,2.290,0.332,
0.958,1.270,2.000,1.890,1.260,2.300,0.232,0.225,0.118,0.217,
0.288,0.305,0.228,0.307,0.202,0.063,0.163,0.198,0.200,0.316,
0.169,0.226,2.420,2.920,1.760,2.300,0.270,0.313,0.228,0.309,
2.200,0.310,1.250,1.690,1.320,2.290,1.530,1.990,2.140,1.370,
1.210,1.990,2.920,3.220,2.200,2.670,2.930,0.246,1.560,2.070,
1.990,1.750,1.890,2.990,3.510,1.790,1.250,2.490,2.220,1.440,
1.070,1.430,2.040,0.203,0.889,1.330,2.410,1.810,1.190,2.750,
3.260,2.830,1.640,2.500,2.850,2.370,1.840,2.350,2.170,0.267,
1.360,1.950,2.080,2.780,1.520,2.590,2.350,2.450,1.680,2.300,
0.192,0.205,0.146,0.206,1.990,0.181,1.270,1.850,1.730,2.200,
1.590,2.370,3.200,1.770,1.530,2.470,2.350,2.260,1.500,1.770,
2.790,0.216,1.610,2.590,3.340,2.820,2.690,4.670,3.100,2.410,
1.410,2.680,2.600,2.350,1.070,1.670,1.800,0.230,0.834,1.370,
2.100,1.990,0.890,1.930,2.750,2.520,1.100,2.000,2.280,1.650,
1.080,1.200,1.780,0.254,1.610,1.540,1.350,2.070,0.960,1.800,
2.120,2.460,2.070,2.380,0.475,0.295,0.567,0.456,1.500,0.199,
0.974,1.860,1.140,2.060,1.210,2.660,1.950,1.330,1.130,2.200,
2.070,1.690,1.760,2.300,1.880,0.209,1.280,2.100,1.930,1.620,
1.780,3.520,0.263,0.202,0.123,0.194,0.703,0.334,0.174,0.185,
0.157,0.032,0.097,0.131,0.173,0.187,0.122,0.187,0.169,0.192,
0.080,0.139,0.223,0.238,0.152,0.157,0.146,0.032,0.145,0.147,
0.096,0.156,0.079,0.138,0.157,0.228,0.475,0.211,0.052,0.054,
0.377,0.067,0.177,0.038,0.153,0.207,0.124,0.230,0.172,0.426,
0.183,0.130,0.145,0.211,0.256,0.270,0.568,0.315,0.174,0.022,
0.130,0.195,0.157,0.166,0.167,0.328,2.340,1.610,0.871,1.190,
2.110,1.910,1.260,1.380,1.580,0.262,1.090,1.340,1.080,1.340,
1.130,1.590,0.169,0.201,0.086,0.139,0.171,0.206,0.135,0.125,
0.151,0.047,0.183,0.161,0.129,0.218,0.127,0.149,1.470,2.030,
1.350,1.640,0.177,0.230,0.213,0.238,1.450,0.223,0.724,1.070,
0.934,1.690,1.250,1.530,1.330,1.010,0.812,1.230,1.900,1.870,
1.410,2.180,1.590,0.187,1.420,1.520,1.320,1.480,1.530,2.030,
2.390,1.280,0.878,1.610,1.610,1.120,0.767,1.080,1.320,0.146,
0.890,1.270,1.490,1.200,0.885,1.770,2.650,2.110,1.100,2.080,
2.040,2.080,1.220,1.500,1.690,0.195,1.410,1.730,1.530,2.080,
1.340,1.890,2.080,2.280,1.490,2.330,0.197,0.279,0.221,0.356,
1.740,0.181,1.110,1.540,1.760,2.170,1.630,2.230,1.990,1.390,
1.090,1.800,1.700,1.710,1.260,1.890,2.070,0.191,1.640,2.010,
2.230,2.210,2.540,3.240,6.580,2.850,1.920,4.670,2.660,1.650,
1.110,2.130,2.460,0.208,0.922,1.700,3.080,2.310,1.340,3.240,
3.040,1.950,1.030,1.930,1.880,1.270,0.814,1.200,1.580,0.143,
0.915,1.330,1.330,1.570,0.766,1.670,2.340,3.410,1.200,2.370,
0.187,0.206,0.130,0.264,1.240,0.124,0.684,1.310,1.290,1.500,
0.955,2.270,3.590,2.110,1.530,3.600,2.230,1.560,1.270,2.420,
1.940,0.154,1.320,2.470,3.040,2.000,2.210,6.080,3.440,2.040,
1.180,2.290,2.570,1.760,0.996,1.510,1.470,0.145,0.665,1.260,
1.540,1.390,0.807,2.060,2.470,1.860,0.910,1.540,1.690,1.360,
0.899,1.280,1.470,0.134,0.879,1.390,1.090,1.250,0.759,1.530,
1.800,2.120,1.250,1.740,0.136,0.171,0.355,0.186,1.310,0.143,
0.821,1.480,1.280,1.900,1.060,2.680,2.020,1.260,1.000,1.930,
1.990,1.580,1.470,1.940,1.590,0.117,1.010,1.760,1.740,1.540,
1.460,3.390,3.770,2.400,1.560,2.540,3.090,2.230,1.520,2.320,
2.370,0.266,1.190,1.840,2.230,1.940,1.790,2.950,0.249,0.227,
0.112,0.200,0.207,0.243,0.128,0.200,0.152,0.026,0.126,0.192,
0.183,0.256,0.143,0.256,2.280,2.530,1.690,2.460,0.206,0.205,
0.149,0.346,2.050,0.224,1.150,1.800,1.710,2.370,1.830,2.630,
2.530,1.890,1.740,2.150,3.330,2.800,2.020,2.990,2.910,0.254,
2.090,2.680,2.420,2.090,2.470,3.720,6.210,2.690,1.910,3.760,
2.860,1.950,1.380,1.980,2.650,0.224,1.320,2.340,3.580,2.560,
2.100,5.500,4.200,2.740,1.500,2.430,3.290,3.660,1.570,2.150,
2.430,0.189,1.570,2.400,2.460,2.560,1.760,3.490,3.910,3.690,
2.250,3.740,0.238,0.254,0.149,0.286,2.960,0.235,2.030,3.230,
3.200,3.760,3.280,4.850,6.630,3.250,2.580,5.590,3.980,3.470,
2.320,3.880,4.510,0.281,3.150,5.910,6.910,4.340,4.830,9.080,
16.1,7.490,5.010,8.290,8.880,5.860,4.040,4.520,7.430,0.828,
2.930,4.590,8.550,7.200,3.730,5.860,10.5,6.660,3.400,4.090,
7.010,4.840,3.220,2.860,4.720,0.523,2.580,3.120,3.240,3.650,
2.250,3.340,6.100,5.700,3.180,4.210,0.631,0.669,0.409,0.643,
3.810,0.527,2.010,2.500,3.380,5.670,2.440,3.800,7.950,3.940,
3.470,5.680,6.150,4.730,3.430,4.670,4.140,0.450,2.240,3.310,
4.950,3.680,3.310,5.170,11.8,7.150,3.190,4.950,7.720,6.280,
3.250,3.300,4.780,0.661,2.000,2.920,3.350,4.040,1.980,3.110,
10.5,7.040,2.540,3.040,6.060,4.630,2.750,2.380,4.250,0.656,
2.190,2.930,2.260,3.270,1.690,2.130,4.080,5.180,2.360,3.110,
0.449,0.685,0.376,0.405,4.040,0.649,2.470,2.800,2.170,4.410,
2.340,2.740,3.360,2.620,1.480,2.280,4.050,3.780,1.970,2.440,
3.440,0.382,1.770,2.300,2.540,2.500,2.130,3.240,4.880,2.750,
1.610,2.470,4.340,2.820,2.200,2.050,3.320,0.484,1.420,2.180,
2.390,2.500,1.630,2.700,0.462,0.409,0.182,0.272,0.395,0.410,
0.254,0.242,0.383,0.097,0.247,0.369,0.286,0.516,0.235,0.360,
2.280,2.620,1.550,1.630,0.283,0.330,0.243,0.256,2.020,0.319,
1.210,1.510,1.160,2.060,1.460,1.360,2.040,1.630,1.110,1.690,
3.140,2.720,1.860,2.220,2.700,0.300,1.410,2.170,2.130,2.230,
1.810,2.500,6.570,2.860,1.690,3.420,3.090,1.800,1.450,1.690,
3.080,0.303,1.070,1.850,3.510,2.510,1.650,3.730,5.340,3.630,
1.850,2.450,3.570,2.810,1.800,2.010,3.030,0.326,1.670,2.580,
2.450,3.020,1.760,2.800,2.600,2.450,1.810,2.160,0.269,0.272,
0.297,0.263,2.300,0.244,1.340,1.940,1.850,2.690,1.760,2.270,
3.640,2.210,1.670,2.980,2.490,2.240,1.710,2.120,3.600,0.434,
1.910,3.080,4.040,3.790,2.750,4.960,9.620,6.800,3.470,5.620,
5.310,5.200,3.020,2.580,3.080,0.493,1.570,2.500,3.080,4.230,
3.650,3.800,6.690,7.120,2.640,2.950,5.520,4.750,2.980,2.470,
2.980,0.510,1.980,2.470,1.830,2.880,1.740,2.260,3.150,4.780,
2.270,2.640,0.440,0.690,0.398,0.414,2.190,0.380,1.820,1.840,
1.530,3.090,1.660,2.220,3.130,2.080,1.510,2.230,3.510,3.640,
1.910,2.100,2.010,0.543,1.300,1.560,2.140,2.030,1.710,2.930,
7.050,7.120,2.220,3.140,5.550,8.070,2.980,2.310,2.720,0.596,
1.360,1.900,1.800,3.230,2.420,2.570,4.860,6.340,1.920,2.020,
4.060,3.090,2.700,2.010,3.020,0.752,1.630,2.160,1.400,3.010,
1.420,1.560,2.940,6.180,1.950,2.160,0.551,1.590,0.504,0.387,
3.280,1.050,1.960,2.410,1.710,6.310,1.930,2.260,2.360,2.340,
1.010,1.410,3.840,4.840,1.750,1.760,2.450,0.517,1.170,1.520,
1.500,2.380,1.180,2.000,3.190,2.840,1.200,1.800,3.730,3.940,
2.580,1.970,2.350,0.479,1.350,1.570,1.330,2.070,1.430,1.730,
0.290,0.508,0.174,0.215,0.374,0.682,0.409,0.265,0.325,0.188,
0.354,0.308,0.147,0.472,0.271,0.215,2.240,3.510,2.040,1.790,
0.401,0.694,0.457,0.338,2.590,0.554,1.870,2.040,1.070,2.890,
1.770,1.570,1.680,1.460,1.060,1.360,3.180,4.300,2.470,2.280,
2.770,0.426,1.760,2.260,1.530,2.010,1.680,2.200,2.550,1.810,
0.933,1.470,1.910,1.620,1.010,0.969,1.400,0.181,0.596,0.892,
1.300,1.290,0.906,1.540,2.690,3.230,1.390,1.610,2.530,3.080,
1.590,1.740,1.770,0.329,1.050,1.490,1.110,2.260,1.150,1.660,
1.800,2.590,1.390,1.570,0.205,0.354,0.180,0.189,1.740,0.279,
1.290,1.590,1.120,2.200,1.520,1.680,2.110,1.740,1.070,1.430,
2.000,2.540,1.210,1.430,3.850,1.290,1.590,2.030,2.330,4.300,
2.010,2.980,4.090,3.210,1.680,2.880,2.600,2.410,1.330,1.590,
1.730,0.262,0.934,1.510,1.800,2.070,1.120,2.000,3.930,4.150,
1.890,2.150,3.240,3.030,2.070,1.770,2.690,0.471,1.840,2.060,
1.540,2.840,1.430,1.850,2.820,4.200,2.010,2.170,0.399,0.559,
0.325,0.418,2.170,0.347,1.320,1.460,1.410,2.600,1.300,1.840,
2.300,1.630,1.100,1.670,2.950,2.340,1.380,1.700,1.910,0.257,
1.220,1.770,2.350,1.790,1.770,3.520,0.286,0.340,0.140,0.199,
0.345,0.602,0.217,0.197,0.223,0.095,0.165,0.186,0.146,0.322,
0.142,0.198,0.327,0.484,0.204,0.194,0.407,0.562,0.327,0.229,
0.333,0.145,0.295,0.317,0.150,0.413,0.196,0.192,0.223,0.522,
0.210,0.202,0.065,0.175,0.117,0.064,0.294,0.134,0.287,0.267,
0.151,0.524,0.219,0.239,0.217,0.216,0.119,0.186,0.445,0.620,
0.337,0.335,0.267,0.061,0.225,0.248,0.233,0.275,0.220,0.362,
1.770,1.620,0.811,0.952,2.170,2.120,1.500,1.100,2.030,0.387,
1.080,1.330,0.931,1.430,0.935,1.200,0.183,0.314,0.121,0.114,
0.203,0.321,0.216,0.119,0.218,0.100,0.185,0.210,0.131,0.332,
0.160,0.150,1.420,2.640,1.280,1.090,0.235,0.396,0.265,0.192,
1.910,0.412,1.020,1.370,0.824,2.130,1.380,1.190,1.110,1.090,
0.744,0.797,1.810,2.260,1.510,1.260,1.750,0.285,1.210,1.470,
0.993,1.500,1.150,1.380,1.850,1.200,0.713,1.190,1.560,1.100,
0.680,0.748,1.990,0.177,0.562,0.903,1.330,1.160,0.646,1.350,
2.410,2.460,1.230,1.330,2.230,2.330,1.470,1.280,1.840,0.280,
1.250,1.890,1.290,2.290,1.200,1.620,1.790,2.560,1.420,1.380,
0.241,0.370,0.202,0.185,1.910,0.282,1.270,1.590,1.220,2.460,
1.340,1.650,1.780,1.380,1.190,1.180,2.140,2.200,1.350,1.420,
2.430,0.320,1.830,2.090,1.960,2.720,1.900,2.750,4.680,2.780,
1.700,3.500,2.100,1.560,0.982,1.330,1.690,0.211,0.713,1.440,
2.540,2.250,1.290,2.810,2.340,1.810,0.970,1.500,1.540,1.200,
0.791,0.888,1.230,0.143,0.657,1.270,1.070,1.210,0.779,1.480,
2.650,2.150,1.060,1.770,0.212,0.200,0.123,0.226,1.240,0.133,
0.661,0.955,1.070,1.340,0.788,1.420,2.790,1.580,1.200,2.570,
2.170,1.650,1.040,1.640,1.610,0.168,0.891,1.460,2.440,1.810,
1.620,3.930,3.910,3.130,1.390,2.550,3.120,3.130,1.420,1.950,
2.210,0.332,1.130,1.920,1.790,2.430,1.130,1.940,3.130,3.490,
1.200,1.980,2.790,3.040,1.570,1.600,2.190,0.402,1.410,2.610,
1.370,2.370,1.600,1.870,2.140,2.890,1.120,1.630,0.212,0.382,
0.183,0.233,1.880,0.300,1.480,1.690,1.400,2.660,1.350,1.850,
1.780,1.510,0.923,1.620,2.450,3.050,1.470,2.030,1.820,0.215,
1.170,1.680,1.730,1.830,1.480,2.780,2.220,1.540,0.882,1.340,
2.030,1.640,1.110,1.250,2.000,0.358,1.370,3.260,1.290,1.520,
1.110,1.980,0.162,0.182,0.093,0.170,0.150,0.213,0.118,0.128,
0.198,0.060,0.219,1.020,0.123,0.237,0.134,0.294,1.400,1.850,
0.987,1.130,0.157,0.206,0.147,0.173,1.630,0.242,0.930,1.670,
0.967,1.700,1.130,1.480,1.240,1.140,0.715,1.030,1.910,1.830,
1.330,1.540,2.070,0.279,1.150,1.910,1.310,1.720,1.220,1.950,
4.140,1.820,0.982,1.930,1.960,1.340,0.796,1.120,3.130,0.218,
0.719,1.480,2.470,1.680,1.100,2.650,1.870,1.510,0.825,1.250,
1.520,1.390,0.888,1.230,1.550,0.158,1.040,3.210,1.250,1.520,
1.060,2.230,2.410,2.260,1.260,1.780,0.246,0.220,0.125,0.198,
2.220,0.206,1.300,1.920,1.720,2.420,1.590,2.330,2.960,1.860,
1.350,2.690,3.030,2.580,1.560,2.200,3.300,0.305,2.000,3.250,
3.860,3.200,2.870,5.670,8.120,5.290,3.130,5.190,6.040,5.010,
2.640,2.910,3.830,0.556,1.900,2.990,4.170,4.650,2.110,3.840,
6.320,5.540,2.580,3.010,6.320,5.560,3.020,2.550,3.430,0.527,
2.690,2.690,2.020,3.110,1.770,2.420,2.710,3.110,1.940,2.300,
0.316,0.404,0.267,0.368,1.830,0.299,1.460,1.400,1.360,2.320,
1.570,2.020,2.910,1.830,1.390,2.410,2.920,2.700,1.760,2.280,
1.830,0.243,1.370,1.780,2.110,1.820,1.930,3.040,6.890,5.310,
2.000,3.190,6.960,5.820,2.470,2.410,3.420,0.623,2.130,2.440,
2.190,3.230,1.320,2.250,5.780,5.890,1.940,2.440,7.640,5.300,
2.660,2.440,3.810,0.833,2.700,3.240,1.790,3.550,1.490,1.860,
2.160,3.520,1.560,1.780,0.397,0.612,0.346,0.331,2.540,0.644,
1.950,1.790,1.320,3.190,1.780,1.910,1.560,1.510,0.763,1.190,
2.550,2.930,1.290,1.710,1.780,0.302,1.220,1.590,1.400,1.710,
1.400,2.140,2.840,2.020,1.090,1.610,3.730,3.140,1.920,1.890,
2.820,0.493,1.270,1.620,1.500,2.090,1.190,2.240,0.243,0.353,
0.161,0.205,0.413,0.606,0.299,0.266,0.317,0.143,0.282,0.311,
0.171,0.491,0.214,0.282,1.370,2.070,1.360,1.330,0.233,0.346,
0.223,0.255,1.980,0.401,1.440,1.570,0.888,2.070,1.300,1.320,
1.150,1.090,0.826,1.180,1.980,2.370,1.340,1.870,1.860,0.322,
1.330,1.760,1.240,2.030,1.470,2.110,2.810,1.400,0.823,1.750,
1.770,1.260,0.842,1.020,1.630,0.189,0.705,1.150,1.600,1.450,
0.855,2.330,2.750,2.550,1.310,1.740,2.980,3.180,1.550,1.730,
1.900,0.309,1.390,2.080,1.180,2.230,1.130,1.900,1.270,1.510,
0.958,1.210,0.152,0.199,0.137,0.166,1.590,0.237,1.040,1.590,
1.090,1.740,1.040,1.440,1.730,1.280,1.060,1.650,1.350,1.570,
1.000,1.330,1.780,0.241,1.210,1.990,1.890,2.180,1.750,3.150,
6.180,4.080,2.120,3.320,4.240,4.700,2.450,2.130,2.300,0.352,
1.070,1.550,1.660,2.310,1.180,1.910,3.990,4.430,1.700,1.960,
4.180,5.690,2.470,2.100,2.120,0.489,1.670,1.810,1.010,2.200,
1.040,1.390,1.790,2.960,1.660,1.740,0.270,0.514,0.314,0.306,
1.300,0.296,1.380,1.200,0.791,1.760,1.070,1.430,1.320,1.100,
0.752,1.360,1.860,2.620,1.260,1.470,1.010,0.172,0.910,1.050,
1.130,1.190,1.040,1.780,4.060,3.040,0.993,1.370,2.540,3.530,
1.420,1.160,1.580,0.352,0.825,0.964,0.939,1.690,0.706,1.060,
1.480,1.150,0.567,0.703,0.535,0.383,0.363,0.365,1.040,0.432,
0.696,0.832,0.393,1.140,0.488,0.602,1.250,2.800,1.160,1.170,
0.301,1.050,0.518,0.325,1.430,0.496,1.040,1.230,0.720,2.550,
1.140,1.280,0.800,0.921,0.556,0.641,1.520,2.770,1.110,1.250,
1.070,0.242,0.860,1.050,0.753,1.310,0.758,1.070,1.970,1.910,
0.835,1.080,3.120,4.110,2.250,1.730,1.870,0.420,1.230,1.220,
0.947,1.690,1.090,1.350,0.195,0.469,0.171,0.181,0.421,1.260,
0.533,0.315,0.292,0.252,0.378,0.295,0.110,0.502,0.250,0.189,
1.570,2.970,1.560,1.420,0.361,0.814,0.481,0.350,1.810,0.483,
1.340,1.560,0.777,2.550,1.590,1.360,0.999,1.060,0.839,0.922,
2.470,4.300,2.590,2.170,2.000,0.339,1.740,1.840,1.150,1.680,
1.700,1.940,1.450,1.160,0.550,0.833,1.440,1.510,0.648,0.704,
1.190,0.149,0.496,0.586,0.811,0.888,0.498,0.901,1.670,2.620,
1.080,1.240,2.390,4.070,1.620,1.670,1.390,0.333,1.040,1.330,
0.719,2.040,0.938,1.170,1.110,2.150,1.020,1.060,0.173,0.372,
0.189,0.162,1.310,0.249,1.350,1.350,0.718,1.670,1.300,1.270,
1.230,1.110,0.647,0.894,1.250,2.140,1.020,1.110,1.380,0.237,
1.020,1.290,1.110,1.660,1.410,1.810,2.880,2.700,1.260,2.000,
2.720,2.760,1.240,1.590,1.560,0.253,0.834,1.130,1.290,1.820,
0.894,1.540,3.390,4.740,1.540,2.000,4.230,5.260,2.550,2.350,
2.740,0.634,2.460,2.360,1.280,3.400,1.280,1.640,1.600,3.080,
1.430,1.530,0.293,0.517,0.270,0.372,1.720,0.370,1.190,1.360,
1.070,2.290,1.030,1.360,1.260,1.150,0.681,1.260,1.840,2.310,
1.100,1.600,1.460,0.261,1.290,1.630,1.390,1.450,1.340,2.410,
0.229,0.279,0.105,0.153,0.474,0.757,0.297,0.266,0.205,0.082,
0.162,0.169,0.120,0.284,0.127,0.163,0.271,0.556,0.167,0.228,
0.600,1.160,0.536,0.368,0.382,0.281,0.464,0.378,0.127,0.473,
0.174,0.176,0.141,0.443,0.193,0.153,0.085,0.285,0.172,0.081,
0.283,0.182,0.342,0.290,0.125,0.465,0.226,0.183,0.110,0.152,
0.079,0.127,0.328,0.683,0.260,0.313,0.196,0.076,0.237,0.247,
0.121,0.202,0.167,0.239,1.630,1.960,0.909,0.938,2.480,3.760,
1.870,1.450,2.100,0.531,1.480,1.470,0.912,1.830,1.060,1.380,
0.187,0.489,0.176,0.141,0.323,0.981,0.456,0.248,0.315,0.207,
0.382,0.318,0.129,0.490,0.214,0.187,1.250,2.940,1.460,1.170,
0.267,0.613,0.343,0.260,1.950,0.542,1.150,1.550,0.838,2.730,
1.430,1.390,0.901,1.160,0.708,0.827,2.050,3.740,1.810,2.000,
2.030,0.470,1.730,1.910,0.998,2.050,1.520,1.970,1.400,1.140,
0.605,1.060,1.280,1.240,0.587,0.723,1.200,0.184,0.686,0.940,
0.909,1.150,0.590,1.260,2.200,3.310,1.360,1.400,3.050,4.830,
2.230,1.940,2.450,0.583,2.300,2.690,1.230,3.160,1.500,1.900,
1.530,2.950,1.440,1.290,0.188,0.439,0.220,0.196,2.100,0.412,
1.760,2.000,1.090,3.010,1.560,1.810,1.270,1.280,0.841,1.230,
1.420,2.150,1.170,1.400,2.120,0.304,1.980,2.200,1.620,2.520,
1.850,2.470,2.560,1.690,0.976,1.910,1.710,1.490,0.762,1.200,
1.140,0.150,0.598,1.090,1.300,1.280,0.675,1.610,2.090,1.930,
0.786,1.180,1.710,1.800,0.855,1.050,1.080,0.146,0.675,0.971,
0.775,1.200,0.559,1.010,1.350,1.530,0.746,1.310,0.121,0.151,
0.087,0.171,0.810,0.106,0.525,0.732,0.599,0.897,0.502,0.882,
1.280,0.885,0.605,1.350,1.130,1.120,0.622,1.170,0.976,0.107,
0.599,1.020,1.110,0.972,0.869,1.990,2.420,2.230,0.936,1.540,
2.690,3.300,1.530,1.650,1.740,0.311,1.140,1.550,1.220,1.850,
0.854,1.400,2.400,3.400,1.040,1.500,3.340,4.480,2.040,1.990,
2.100,0.475,1.590,1.940,1.200,2.370,1.240,1.420,1.190,2.230,
0.863,1.030,0.170,0.398,0.194,0.210,1.390,0.267,1.120,1.230,
0.902,2.050,1.010,1.210,0.907,0.929,0.628,1.010,1.610,2.480,
1.060,1.860,1.330,0.207,1.070,1.330,1.040,1.410,0.981,1.860,
1.590,1.400,0.830,0.943,2.080,2.310,1.350,1.290,1.870,0.319,
1.130,1.440,0.994,1.400,0.954,1.510,0.117,0.191,0.084,0.104,
0.175,0.450,0.189,0.154,0.173,0.071,0.168,0.219,0.099,0.274,
0.132,0.164,0.997,1.690,0.904,0.966,0.152,0.267,0.177,0.179,
1.680,0.356,1.360,1.560,0.868,1.940,1.240,1.390,0.943,0.994,
0.633,0.847,1.650,2.290,1.330,1.680,2.860,0.567,1.670,2.020,
1.310,2.340,1.430,2.090,1.910,1.240,0.666,1.230,1.290,1.300,
0.598,0.800,1.170,0.130,0.551,0.880,1.090,1.010,0.674,1.630,
1.540,1.500,0.672,0.989,1.620,2.210,1.010,1.250,1.210,0.156,
0.930,1.440,0.947,1.390,0.840,1.760,1.450,1.570,0.932,1.160,
0.162,0.180,0.108,0.150,1.470,0.185,1.200,1.460,1.030,1.720,
1.350,1.680,1.530,1.150,0.799,1.630,1.700,2.040,1.150,1.640,
2.830,0.373,1.600,2.600,2.360,2.480,2.160,3.660,5.010,3.660,
2.610,3.990,4.420,3.560,2.230,2.420,2.910,0.380,1.340,1.880,
3.130,2.910,1.960,2.820,4.090,4.080,1.680,2.100,3.360,2.340,
1.910,1.830,2.110,0.347,1.310,1.440,1.480,2.040,1.630,2.010,
2.290,2.490,1.440,2.300,0.259,0.274,0.206,0.345,1.630,0.217,
0.926,1.290,1.130,1.790,1.100,1.590,2.520,1.430,1.230,2.100,
2.310,1.980,1.470,1.950,1.550,0.180,1.170,1.470,1.890,1.420,
1.630,2.740,6.160,5.740,2.170,3.430,6.220,7.220,3.500,3.240,
3.340,0.583,1.400,1.700,2.250,3.030,2.010,2.370,5.470,8.660,
2.350,2.570,4.580,3.890,3.210,2.670,4.720,1.220,2.190,2.490,
1.900,4.060,1.830,1.860,2.680,4.500,2.000,2.510,0.427,0.721,
0.462,0.505,3.210,0.636,2.340,2.770,1.540,3.610,2.300,2.210,
2.090,1.730,0.966,1.630,2.920,3.350,1.920,2.500,1.940,0.269,
1.200,2.030,1.570,1.780,1.540,2.710,2.910,2.240,1.010,1.710,
4.550,3.160,2.200,2.730,3.500,0.704,1.090,1.460,1.940,2.690,
1.490,2.050,0.329,0.803,0.169,0.323,0.425,0.541,0.333,0.651,
0.624,0.226,0.253,0.284,0.315,0.936,0.334,0.340,1.690,2.290,
1.440,1.860,0.320,0.387,0.364,0.444,2.070,0.621,1.170,1.240,
1.010,2.560,1.330,1.330,1.470,1.130,0.743,1.560,2.670,2.850,
1.990,3.320,2.250,0.330,1.080,1.580,1.550,1.700,1.520,2.210,
2.750,1.930,0.854,1.730,1.860,1.230,0.925,1.390,1.820,0.253,
0.686,0.995,1.930,1.730,1.010,2.090,2.950,6.150,1.230,2.050,
2.340,2.350,1.710,3.490,2.820,0.687,1.120,1.560,1.600,3.010,
1.410,1.830,1.600,2.100,1.580,1.890,0.205,0.241,0.235,0.330,
1.880,0.281,1.250,1.660,1.270,2.220,1.650,1.880,2.030,1.550,
1.090,2.150,1.800,1.690,1.440,2.260,2.420,0.301,1.540,2.410,
2.930,2.890,2.630,4.250,0.264,0.344,0.168,0.195,0.307,0.521,
0.234,0.240,0.181,0.057,0.102,0.129,0.137,0.252,0.189,0.176,
0.387,0.671,0.248,0.267,0.503,0.573,0.513,0.400,0.347,0.161,
0.258,0.232,0.144,0.407,0.207,0.189,0.181,0.467,0.185,0.204,
0.047,0.098,0.075,0.056,0.178,0.071,0.179,0.166,0.082,0.244,
0.143,0.174,0.173,0.149,0.110,0.159,0.265,0.351,0.262,0.222,
0.175,0.046,0.280,0.211,0.159,0.173,0.233,0.282,0.340,0.659,
0.198,0.201,0.578,1.760,0.692,0.445,0.283,0.163,0.159,0.157,
0.135,0.375,0.535,0.207,0.599,1.470,0.349,0.273,0.743,0.919,
0.815,0.558,0.980,0.710,0.374,0.383,0.256,1.120,0.303,0.210,
0.245,0.776,0.277,0.243,0.126,0.535,0.254,0.113,0.479,0.318,
0.435,0.385,0.131,0.659,0.364,0.283,0.199,0.207,0.104,0.129,
0.335,0.646,0.318,0.273,0.223,0.077,0.170,0.192,0.112,0.219,
0.173,0.248,0.177,0.242,0.083,0.139,0.374,0.543,0.363,0.451,
0.441,0.218,0.173,0.156,0.137,0.425,0.152,0.147,0.051,0.230,
0.047,0.076,0.134,0.310,0.220,0.291,0.188,0.224,0.137,0.096,
0.047,0.250,0.069,0.055,0.188,0.421,0.271,0.244,0.104,0.254,
0.225,0.119,0.644,0.556,0.407,0.303,0.180,0.896,0.306,0.225,
0.143,0.135,0.101,0.138,0.345,0.621,0.443,0.387,0.361,0.142,
0.340,0.274,0.137,0.264,0.224,0.230,0.182,0.454,0.082,0.138,
0.152,0.193,0.114,0.215,0.158,0.038,0.070,0.087,0.122,0.186,
0.104,0.162,0.629,3.570,0.285,0.420,0.431,0.727,0.472,1.420,
0.613,0.286,0.233,0.284,0.230,0.780,0.230,0.276,0.146,0.386,
0.180,0.189,0.035,0.090,0.059,0.073,0.268,0.125,0.264,0.264,
0.123,0.374,0.253,0.220,0.168,0.222,0.097,0.146,0.186,0.257,
0.164,0.216,0.257,0.074,0.211,0.245,0.198,0.331,0.260,0.317,
2.580,2.650,1.290,2.070,3.020,5.360,1.600,1.860,1.640,0.350,
0.951,1.180,1.510,1.650,0.865,1.380,2.950,3.450,1.480,1.750,
4.170,3.550,3.390,2.280,2.700,0.583,2.390,1.950,1.250,2.560,
1.360,1.550,1.820,3.400,2.070,2.150,0.362,0.683,0.471,0.606,
1.990,0.433,1.520,1.770,0.921,2.480,1.300,1.530,1.370,1.150,
0.794,1.390,1.910,2.260,1.480,1.860,1.530,0.288,1.190,1.730,
1.600,1.470,1.400,2.350,0.259,0.597,0.137,0.194,0.804,3.150,
0.471,0.411,0.230,0.143,0.202,0.251,0.109,0.290,0.144,0.172,
0.304,0.616,0.217,0.190,0.606,0.849,0.901,0.472,0.400,0.258,
0.457,0.354,0.128,0.410,0.271,0.169,0.163,0.573,0.254,0.215,
0.082,0.289,0.201,0.102,0.321,0.209,0.421,0.379,0.108,0.441,
0.248,0.213,0.155,0.173,0.104,0.156,0.339,0.614,0.338,0.358,
0.209,0.071,0.223,0.279,0.141,0.196,0.180,0.255,1.630,1.960,
0.902,0.843,3.390,4.060,2.640,1.650,1.840,0.506,1.480,1.280,
0.824,1.580,1.110,1.170,0.203,0.482,0.165,0.131,0.377,0.719,
0.596,0.256,0.283,0.178,0.340,0.234,0.119,0.394,0.213,0.164,
1.560,3.170,2.290,1.650,0.375,0.696,0.727,0.403,1.910,0.494,
0.808,1.200,0.763,2.200,1.790,1.400,1.090,1.040,0.826,0.890,
2.410,3.440,2.480,2.200,1.970,0.389,1.570,1.560,0.937,1.490,
1.560,1.620,1.370,1.130,0.653,0.935,1.520,1.670,0.801,0.785,
1.000,0.196,0.645,0.804,0.895,1.130,0.586,1.040,2.160,3.170,
1.360,1.210,3.000,3.890,2.820,1.950,1.950,0.490,1.880,1.790,
1.210,2.590,1.380,1.400,1.900,3.520,1.940,1.660,0.271,0.605,
0.378,0.317,2.160,0.475,2.630,2.340,1.120,2.880,2.090,1.890,
1.240,1.130,0.805,1.070,1.620,2.290,1.430,1.470,2.030,0.357,
1.970,1.960,1.460,2.310,1.880,2.260,2.450,1.800,0.992,1.830,
1.800,2.090,0.964,1.270,1.170,0.184,0.543,0.893,1.270,1.250,
0.737,1.670,2.050,2.050,0.756,1.000,1.490,1.100,0.912,0.884,
0.896,0.140,0.679,0.730,0.648,0.904,0.965,0.882,1.460,2.290,
0.983,1.400,0.156,0.228,0.133,0.215,0.993,0.150,0.597,0.926,
0.829,1.280,0.803,1.200,1.430,1.160,0.869,1.360,1.310,1.220,
0.895,1.270,0.965,0.115,0.600,0.978,1.360,1.090,0.973,2.340,
3.560,4.390,1.500,2.480,4.970,9.970,2.630,2.710,2.060,0.517,
1.360,1.740,1.350,2.280,1.430,1.730,4.130,7.900,1.820,2.030,
4.500,4.550,3.420,2.670,2.660,0.666,2.310,2.470,1.340,2.820,
4.190,2.030,2.430,6.690,1.930,2.040,0.338,0.895,0.394,0.422,
2.460,0.612,2.180,2.720,1.400,3.570,2.080,2.280,1.680,1.970,
1.310,1.510,2.670,3.620,2.180,2.710,1.870,0.274,1.450,2.100,
1.390,1.840,1.680,2.750,2.300,2.620,0.992,1.210,3.820,3.070,
2.050,1.840,1.930,0.411,1.190,1.630,1.140,1.530,1.240,1.620,
0.191,0.326,0.108,0.134,0.297,0.477,0.310,0.248,0.201,0.087,
0.205,0.273,0.118,0.269,0.209,0.188,1.610,2.750,1.540,1.620,
0.289,0.464,0.365,0.399,2.150,0.518,1.370,1.730,1.050,2.490,
1.770,1.740,1.260,1.290,0.860,1.090,2.730,3.050,2.500,2.670,
1.840,0.314,1.540,1.950,1.230,1.670,1.720,2.340,2.230,1.360,
0.877,1.490,1.800,1.450,0.879,1.060,1.330,0.172,0.666,1.060,
1.300,1.240,0.906,1.890,1.860,2.190,0.860,1.140,1.990,2.080,
1.430,1.520,1.450,0.209,1.030,1.570,1.020,1.540,1.200,1.610,
1.800,2.860,1.450,1.970,0.205,0.322,0.180,0.275,2.190,0.343,
2.010,2.640,1.490,2.720,2.090,2.350,2.120,1.490,1.090,2.090,
2.250,2.600,1.830,2.490,2.370,0.259,2.080,3.000,2.510,2.540,
2.480,3.330,4.250,2.700,2.020,4.240,2.870,1.990,1.330,1.950,
2.520,0.274,0.869,1.660,3.240,2.540,1.340,2.770,2.980,2.170,
1.130,1.670,2.070,1.420,1.010,1.150,1.610,0.200,0.832,1.020,
1.530,1.620,0.944,1.530,1.880,1.740,1.130,2.000,0.181,0.175,
0.127,0.252,1.280,0.147,0.617,0.999,1.250,1.670,0.904,1.690,
2.620,1.350,1.150,2.370,1.900,1.400,1.110,1.760,1.440,0.147,
0.865,1.290,2.380,1.650,1.510,3.510,3.860,2.590,1.160,2.240,
2.840,2.290,1.150,1.480,1.760,0.225,0.652,1.130,1.990,1.650,
0.844,1.620,2.530,2.660,0.926,1.290,1.820,1.520,0.966,1.060,
1.710,0.256,0.706,1.030,1.690,1.650,0.773,1.140,1.370,1.660,
0.836,1.410,0.147,0.177,0.118,0.188,1.200,0.159,0.657,0.924,
1.030,1.690,0.868,1.220,1.430,0.991,0.583,1.310,1.410,1.200,
0.652,1.200,1.070,0.102,0.521,0.930,1.180,1.040,0.938,2.000,
2.380,1.330,0.772,1.420,2.150,1.430,1.100,1.520,1.790,0.257,
0.526,0.890,1.550,1.570,0.759,1.610,0.169,0.179,0.078,0.143,
0.156,0.169,0.099,0.171,0.167,0.050,0.080,0.105,0.197,0.310,
0.116,0.192,1.060,1.350,0.896,1.180,0.127,0.157,0.108,0.165,
1.100,0.197,0.552,0.735,0.855,1.330,0.816,0.969,1.130,0.852,
0.647,1.490,1.410,1.350,0.870,1.510,1.520,0.195,0.621,1.040,
1.340,1.220,1.010,1.810,2.790,1.280,0.855,2.100,1.590,0.944,
0.687,1.070,1.780,0.187,0.579,0.940,2.630,1.730,0.930,2.290,
1.810,1.760,0.779,1.340,1.290,1.150,0.783,1.260,1.430,0.183,
0.733,0.996,1.650,1.840,1.020,1.690,1.270,1.310,0.953,1.390,
0.123,0.108,0.082,0.140,1.180,0.115,0.630,0.933,1.190,1.490,
0.982,1.570,2.200,1.210,1.040,2.400,1.470,1.130,0.884,1.430,
1.850,0.161,1.070,1.770,2.950,2.430,2.310,4.700,3.800,3.130,
1.630,3.060,2.940,2.880,1.630,2.060,1.850,0.289,0.890,1.370,
1.830,2.220,1.170,2.070,3.360,3.430,1.540,2.060,3.290,2.870,
2.070,2.010,2.230,0.477,1.530,1.600,1.270,2.330,1.240,1.580,
1.950,2.990,1.500,2.320,0.247,0.384,0.232,0.331,1.540,0.272,
1.220,1.650,1.140,2.070,1.370,2.030,1.900,1.420,1.080,1.980,
2.220,2.610,1.580,1.940,1.500,0.241,2.260,1.920,1.910,1.620,
2.050,2.920,3.430,3.660,1.270,1.950,3.320,4.590,1.940,1.910,
1.780,0.394,0.813,1.080,1.300,1.980,1.540,1.620,3.640,6.030,
1.730,1.940,3.550,3.360,2.450,2.210,3.080,1.000,1.530,1.840,
1.420,3.360,1.210,1.410,1.800,3.460,1.440,1.890,0.287,0.583,
0.357,0.301,2.110,0.504,1.430,1.770,1.130,2.820,1.680,1.950,
1.590,1.580,0.827,1.500,2.140,2.900,1.330,1.650,1.550,0.218,
1.000,1.490,1.180,1.450,1.160,2.120,1.770,1.390,0.610,1.100,
2.120,2.240,1.510,1.800,2.110,0.485,0.815,0.932,1.160,1.860,
0.832,1.360,0.153,0.335,0.102,0.181,0.237,0.443,0.268,0.427,
0.350,0.180,0.183,0.183,0.162,0.542,0.152,0.177,1.520,2.380,
1.390,1.570,0.219,0.397,0.257,0.280,2.210,0.643,1.140,1.360,
0.953,2.560,1.250,1.380,1.360,1.170,0.853,1.420,2.110,3.110,
1.690,2.040,2.770,0.296,1.280,1.640,1.450,1.540,1.350,2.090,
1.580,1.360,0.645,1.170,1.130,1.020,0.625,0.925,1.310,0.161,
0.533,0.712,1.320,1.230,0.678,1.420,2.130,4.680,1.160,1.730,
1.960,2.440,1.610,2.960,2.230,0.502,1.070,1.400,1.510,3.290,
1.210,1.770,1.300,2.200,1.130,1.450,0.142,0.246,0.135,0.181,
1.520,0.252,1.110,1.440,0.991,2.130,1.290,1.590,1.580,1.240,
0.868,1.420,1.440,1.760,0.980,1.260,2.040,0.244,1.200,1.710,
1.950,2.360,1.780,2.950,2.500,2.170,1.120,2.080,2.280,2.630,
0.918,1.490,1.390,0.182,0.616,1.020,1.300,1.340,0.630,1.310,
2.790,2.880,1.120,1.610,3.840,2.440,1.460,1.520,2.060,0.350,
1.390,1.520,1.210,2.050,0.988,1.510,1.910,2.820,2.530,2.490,
0.296,0.364,0.298,0.415,1.630,0.282,1.160,1.610,1.060,2.230,
1.270,1.770,1.720,1.250,0.980,1.710,2.040,1.720,1.170,1.610,
1.570,0.221,1.090,1.690,1.770,1.520,1.380,2.770,0.163,0.246,
0.086,0.136,0.321,0.842,0.128,0.168,0.122,0.039,0.080,0.109,
0.096,0.165,0.085,0.135,0.186,0.283,0.089,0.112,0.412,0.491,
0.197,0.201,0.201,0.090,0.190,0.182,0.112,0.228,0.119,0.121,
0.112,0.319,0.145,0.143,0.034,0.092,0.055,0.035,0.169,0.070,
0.152,0.166,0.091,0.257,0.133,0.167,0.129,0.135,0.071,0.136,
0.205,0.303,0.164,0.188,0.141,0.038,0.132,0.178,0.132,0.150,
0.128,0.226,1.300,1.250,0.586,0.773,1.700,1.920,1.120,1.000,
1.250,0.275,0.734,0.964,0.722,1.140,0.780,1.130,0.117,0.198,
0.079,0.083,0.184,0.255,0.142,0.101,0.157,0.071,0.117,0.139,
0.090,0.257,0.118,0.124,1.180,2.100,1.340,1.160,0.213,0.344,
0.251,0.190,1.680,0.352,0.803,1.160,0.770,2.040,1.390,1.300,
0.994,0.988,0.656,0.858,1.720,2.180,1.370,1.350,1.590,0.251,
1.130,1.360,1.030,1.430,1.340,1.620,1.340,0.930,0.663,1.180,
1.200,1.080,0.608,0.798,0.973,0.135,0.562,0.805,0.937,1.010,
0.595,1.210,1.770,1.960,0.991,1.180,1.870,2.210,1.250,1.160,
1.630,0.285,1.120,1.450,1.150,2.140,1.200,1.570,1.560,2.340,
1.760,1.500,0.214,0.275,0.276,0.195,1.770,0.260,1.370,1.760,
1.280,2.450,1.610,1.770,1.400,1.270,1.080,1.390,1.390,1.590,
1.390,1.240,2.020,0.242,1.510,2.010,1.850,2.230,1.960,2.550,
3.770,1.820,1.220,2.830,1.980,1.500,0.860,1.960,1.400,0.151,
0.535,1.150,1.740,1.390,0.776,2.110,1.960,1.460,0.676,1.070,
1.480,1.120,0.681,0.985,1.030,0.126,0.540,0.844,0.843,1.010,
0.546,1.170,1.510,2.080,0.894,1.550,0.125,0.169,0.090,0.195,
1.020,0.128,0.557,0.989,0.891,1.140,0.684,1.380,1.890,1.260,
0.904,2.010,1.340,1.090,0.851,1.410,1.220,0.117,0.744,1.490,
1.780,1.290,1.200,3.260,2.580,2.020,0.974,1.740,2.210,2.830,
0.933,1.390,1.250,0.172,0.580,1.030,1.100,1.290,0.678,1.590,
2.230,2.370,0.784,1.100,1.880,2.350,0.975,1.180,1.450,0.215,
0.955,1.230,0.963,1.570,1.050,1.530,1.730,4.930,0.928,1.320,
0.146,0.502,0.112,0.177,1.300,0.279,0.772,1.290,1.020,1.830,
0.853,1.530,1.350,1.450,0.787,1.420,1.420,1.770,0.921,1.450,
1.270,0.136,0.796,1.510,1.350,1.450,1.070,2.520,2.140,2.450,
0.926,1.230,2.060,1.680,1.050,1.410,1.630,0.300,0.779,1.190,
1.180,1.380,1.410,1.840,0.141,0.210,0.066,0.102,0.139,0.184,
0.095,0.127,0.110,0.034,0.091,0.137,0.110,0.198,0.118,0.191,
1.330,1.960,0.947,1.230,0.150,0.211,0.126,0.174,1.680,0.255,
0.978,1.340,1.040,1.840,1.400,1.550,1.380,1.350,0.802,1.260,
1.920,2.060,1.380,1.790,1.980,0.231,1.390,1.810,1.550,1.680,
1.540,2.330,3.030,1.690,1.180,2.590,1.750,1.340,0.819,1.210,
1.670,0.170,0.750,1.360,2.060,1.670,1.260,3.300,2.260,1.970,
0.872,1.470,2.070,2.460,1.100,1.570,1.730,0.190,1.070,1.830,
1.650,2.090,1.330,3.070,2.110,2.560,1.710,2.140,0.161,0.219,
0.188,0.210,2.260,0.241,1.520,2.390,1.960,2.940,2.280,2.970,
3.430,2.030,1.630,3.480,2.530,2.430,1.820,2.740,3.180,0.254,
2.240,4.210,3.650,2.980,2.840,4.590,6.020,4.370,3.720,5.970,
4.960,3.000,3.010,3.050,4.870,0.501,2.650,3.960,5.610,4.380,
2.740,4.480,5.370,3.540,2.840,3.240,3.770,2.620,2.510,2.080,
3.560,0.357,2.330,2.540,2.380,2.570,2.000,2.610,4.300,2.960,
2.620,3.390,0.384,0.328,0.305,0.454,2.600,0.243,1.380,1.850,
2.560,2.450,1.730,2.490,4.840,2.210,2.420,4.740,3.740,2.750,
2.750,3.480,2.740,0.253,1.680,2.340,3.680,2.180,2.300,3.770,
5.330,3.530,2.090,2.840,4.220,2.620,1.940,2.020,2.680,0.392,
3.270,3.730,2.050,2.410,1.620,2.300,3.540,2.810,1.640,1.920,
2.360,1.790,1.540,1.350,2.410,0.321,1.830,2.090,1.400,1.850,
1.230,1.560,2.630,2.460,1.680,1.980,0.262,0.275,0.218,0.257,
1.920,0.267,1.300,1.590,1.280,1.950,1.310,1.470,2.050,1.370,
1.110,1.750,2.240,1.840,1.590,1.800,2.430,0.205,1.420,1.890,
2.170,1.640,1.570,2.420,3.760,1.960,2.040,2.130,3.330,1.990,
2.030,1.820,2.640,0.362,1.270,1.760,2.160,2.400,1.560,2.500,
0.311,0.266,0.174,0.217,0.266,0.256,0.220,0.187,0.264,0.056,
0.192,0.242,0.268,0.464,0.222,0.313,1.810,1.620,1.620,1.440,
0.188,0.176,0.217,0.208,1.540,0.187,1.120,1.370,1.120,1.560,
1.340,1.340,1.520,1.060,1.050,1.470,1.960,1.770,1.530,1.750,
1.750,0.223,1.360,1.790,1.530,1.830,1.750,2.340,4.880,1.900,
1.660,2.940,2.360,1.350,1.290,1.390,2.080,0.210,1.080,1.610,
2.570,2.010,1.430,3.140,3.530,2.320,1.650,2.080,2.220,1.800,
1.700,1.600,2.290,0.223,1.550,1.960,2.020,2.320,1.520,2.390,
1.910,1.870,1.410,1.780,0.167,0.159,0.152,0.208,1.660,0.205,
1.710,2.870,1.420,1.900,1.420,1.950,2.750,1.620,1.520,2.690,
1.570,1.200,1.360,1.810,2.360,0.217,2.110,3.630,2.950,2.770,
2.510,4.380,6.200,4.540,3.290,4.700,4.220,3.440,2.890,2.880,
2.640,0.363,1.600,2.550,2.890,2.910,1.860,3.260,5.020,4.610,
2.920,3.450,3.840,3.480,3.240,2.750,3.110,0.494,2.730,3.060,
1.900,2.800,1.800,2.470,2.280,2.810,2.200,2.340,0.280,0.388,
0.330,0.356,1.400,0.184,1.250,1.510,1.120,1.670,1.240,1.800,
2.320,1.370,1.450,2.170,2.500,2.530,2.100,2.240,1.590,0.199,
1.260,1.710,1.770,1.550,1.730,3.000,4.610,4.400,2.050,2.580,
4.130,4.290,2.670,2.220,2.240,0.404,1.500,1.950,1.520,2.200,
1.200,1.960,3.360,3.890,2.180,2.110,2.600,1.780,2.250,1.890,
2.740,0.608,2.350,2.690,1.250,2.360,1.450,1.690,2.370,3.870,
2.160,2.190,0.333,0.610,0.402,0.338,1.820,0.393,1.630,1.780,
1.070,2.800,1.580,1.860,1.740,1.570,1.120,1.470,2.380,2.900,
2.240,2.010,1.620,0.231,1.300,1.600,1.280,1.630,1.260,2.080,
3.400,2.860,1.940,2.310,3.750,3.730,5.030,2.770,2.880,0.503,
1.980,2.160,1.740,2.690,2.360,2.970,0.282,0.521,0.264,0.281,
0.350,0.623,0.625,0.349,0.328,0.174,0.456,0.381,0.225,0.657,
0.362,0.370,2.210,3.570,2.690,2.510,0.335,0.639,0.608,0.420,
2.410,0.498,2.490,2.650,1.220,3.350,2.590,2.160,1.580,1.380,
1.320,1.570,2.650,3.910,3.180,2.710,2.330,0.333,2.330,2.670,
1.490,1.930,2.370,2.890,2.520,1.690,1.280,1.860,1.680,1.330,
1.310,1.330,1.260,0.150,0.858,1.190,1.460,1.420,1.110,2.060,
2.960,2.990,1.870,2.180,2.250,2.630,2.480,2.380,1.780,0.274,
1.780,2.150,1.700,2.780,1.650,2.580,1.540,2.080,1.710,1.820,
0.146,0.232,0.177,0.204,1.230,0.177,1.300,1.790,1.060,1.910,
1.430,1.760,1.980,1.380,1.330,1.750,1.480,1.590,1.300,1.620,
1.760,0.227,1.590,2.420,2.120,2.840,2.570,3.630,3.660,2.810,
1.730,2.550,2.040,1.750,1.320,1.390,1.690,0.228,0.932,1.330,
1.890,2.140,1.190,2.130,3.660,3.990,2.080,2.300,2.840,2.840,
2.360,1.820,3.140,0.527,2.370,2.440,2.030,3.860,1.550,2.050,
2.090,3.140,2.630,2.260,0.308,0.452,0.419,0.434,1.610,0.249,
1.070,1.360,1.040,2.080,1.210,1.550,2.130,1.830,1.480,2.120,
2.170,2.200,1.830,1.960,2.020,0.226,1.300,1.860,2.030,1.870,
1.900,3.460,0.277,0.337,0.173,0.208,0.352,0.384,0.239,0.191,
0.184,0.051,0.165,0.193,0.154,0.313,0.199,0.230,0.305,0.446,
0.212,0.212,0.400,0.468,0.326,0.213,0.322,0.111,0.370,0.312,
0.210,0.535,0.192,0.213,0.211,0.435,0.318,0.245,0.048,0.118,
0.102,0.062,0.241,0.075,0.260,0.250,0.138,0.431,0.210,0.213,
0.274,0.275,0.212,0.280,0.442,0.647,0.516,0.476,0.282,0.064,
0.283,0.329,0.268,0.437,0.308,0.450,2.060,2.000,1.170,1.130,
1.710,2.160,1.800,1.200,1.820,0.462,1.510,1.510,1.130,1.960,
1.500,2.140,0.217,0.383,0.189,0.165,0.194,0.354,0.281,0.140,
0.289,0.137,0.339,0.247,0.185,0.517,0.261,0.261,1.400,2.530,
1.670,1.240,0.208,0.406,0.329,0.213,1.640,0.311,1.270,1.280,
0.768,1.780,1.330,1.130,1.250,1.420,1.690,1.170,1.650,2.520,
2.290,1.800,1.570,0.310,1.840,1.740,1.060,1.830,1.750,1.880,
2.120,1.200,0.910,1.310,1.240,1.040,0.724,0.753,1.150,0.157,
0.681,1.010,1.190,1.350,0.814,2.100,2.630,2.580,1.540,1.780,
2.170,2.690,1.740,1.400,2.100,0.313,1.800,2.160,1.650,3.040,
1.560,2.250,1.750,2.110,1.530,1.390,0.188,0.289,0.201,0.179,
1.630,0.207,1.270,1.430,1.060,2.240,1.270,1.520,2.160,1.950,
1.860,1.750,1.860,2.070,1.410,1.490,2.120,0.493,1.920,2.140,
2.770,6.830,2.420,3.270,4.000,2.160,1.590,2.820,1.760,1.170,
1.100,1.130,1.610,0.197,0.823,1.340,2.280,2.190,1.140,2.670,
2.090,1.500,0.932,1.340,1.300,0.919,0.889,0.912,1.660,0.185,
0.873,1.270,1.510,1.660,0.793,1.420,1.820,1.470,1.160,1.750,
0.184,0.166,0.138,0.233,1.060,0.101,0.581,0.980,0.946,1.100,
0.751,1.400,2.540,1.480,1.390,2.810,2.040,1.430,1.310,1.920,
1.630,0.133,0.964,1.550,2.340,1.600,1.710,3.980,3.260,2.300,
1.460,2.090,2.520,1.900,1.920,1.510,1.660,0.230,1.090,1.570,
1.510,1.960,1.120,1.960,2.390,2.240,1.200,1.550,2.060,1.990,
1.580,1.320,2.180,0.361,1.640,2.080,1.780,2.820,1.070,1.560,
1.730,1.960,1.440,1.920,0.176,0.239,0.258,0.253,1.510,0.183,
1.070,1.500,1.230,1.800,1.140,1.680,1.880,1.350,1.160,2.030,
2.200,2.030,1.900,2.290,1.700,0.165,1.190,1.720,1.820,1.690,
1.570,2.890,2.450,1.560,1.330,1.520,2.210,1.820,1.740,1.750,
2.250,0.353,1.680,2.130,1.600,1.900,1.720,2.630,0.207,0.211,
0.144,0.190,0.179,0.224,0.202,0.165,0.220,0.058,0.239,0.290,
0.199,0.352,0.204,0.283,1.660,2.090,1.440,1.760,0.182,0.227,
0.210,0.271,1.930,0.288,1.400,1.970,1.210,2.050,1.670,2.060,
1.590,1.420,1.460,1.830,2.130,2.120,2.190,2.590,2.280,0.261,
1.910,2.680,1.750,1.880,2.270,3.340,3.360,1.650,1.450,2.220,
1.780,1.390,1.080,1.230,1.650,0.174,1.080,1.630,2.080,1.770,
1.470,3.720,2.010,1.420,1.010,1.470,1.370,1.150,1.100,1.160,
1.610,0.156,1.260,1.960,1.540,1.860,1.270,2.340,2.430,2.290,
1.650,2.440,0.233,0.216,0.170,0.264,2.330,0.207,1.720,2.540,
1.900,2.450,2.000,2.800,3.830,2.380,2.390,4.430,3.250,2.620,
2.330,3.100,3.590,0.305,3.000,4.670,5.050,4.520,4.080,6.530,
0.357,0.282,0.239,0.297,0.374,0.274,0.240,0.213,0.263,0.049,
0.289,0.648,0.261,0.249,0.174,0.252,0.317,0.315,0.223,0.229,
0.334,0.334,0.267,0.199,0.230,0.059,0.238,0.231,0.155,0.236,
0.179,0.211,0.192,0.204,0.184,0.192,0.035,0.041,0.039,0.041,
0.137,0.034,0.126,0.134,0.113,0.152,0.144,0.150,0.220,0.122,
0.134,0.225,0.273,0.206,0.187,0.221,0.168,0.026,0.144,0.181,
0.177,0.142,0.183,0.245,0.441,0.418,0.271,0.283,0.599,0.424,
0.339,0.273,0.391,0.111,0.967,1.590,0.171,0.309,0.321,0.361,
0.409,0.513,0.281,0.241,0.433,0.435,0.396,0.259,0.421,0.162,
0.459,0.528,0.165,0.384,0.225,0.223,0.237,0.375,0.234,0.226,
0.147,0.140,0.129,0.059,0.384,0.183,0.273,0.272,0.161,0.406,
0.226,0.174,0.152,0.150,0.107,0.133,0.335,0.311,0.233,0.242,
0.223,0.051,0.211,0.265,0.151,0.174,0.190,0.233,0.218,0.188,
0.119,0.127,0.435,0.300,0.254,0.196,0.235,0.057,0.181,0.215,
0.121,0.190,0.165,0.195,0.032,0.057,0.033,0.025,0.054,0.100,
0.083,0.042,0.059,0.042,0.069,0.058,0.024,0.076,0.049,0.036,
0.140,0.177,0.181,0.141,0.034,0.048,0.076,0.043,0.180,0.063,
0.209,0.211,0.090,0.214,0.182,0.160,0.102,0.093,0.088,0.110,
0.196,0.219,0.218,0.214,0.193,0.056,0.215,0.239,0.121,0.210,
0.195,0.243,0.265,0.153,0.119,0.176,0.176,0.117,0.106,0.118,
0.156,0.028,0.111,0.178,0.156,0.165,0.126,0.229,0.277,0.272,
0.185,0.233,0.284,0.350,0.247,0.219,0.236,0.051,0.217,0.287,
0.140,0.266,0.188,0.265,0.153,0.193,0.155,0.186,0.030,0.034,
0.038,0.038,0.299,0.083,0.200,0.811,0.126,0.309,0.203,0.291,
0.183,0.130,0.132,0.230,0.144,0.146,0.141,0.208,0.223,0.048,
0.264,1.100,0.215,0.268,0.280,0.447,0.315,0.290,0.223,0.237,
0.329,0.360,0.283,0.231,0.179,0.046,0.141,0.171,0.136,0.193,
0.131,0.182,0.316,0.393,0.259,0.348,0.380,0.458,0.456,0.346,
0.251,0.128,0.319,0.286,0.105,0.233,0.167,0.175,0.139,0.234,
0.179,0.152,0.033,0.076,0.081,0.046,0.112,0.043,0.149,0.143,
0.066,0.150,0.130,0.143,0.117,0.084,0.081,0.139,0.177,0.231,
0.177,0.174,0.172,0.033,0.141,0.173,0.099,0.115,0.129,0.170,
0.380,0.510,0.271,0.214,0.536,0.815,0.470,0.252,0.262,0.096,
0.237,0.269,0.112,0.261,0.147,0.191,0.490,0.888,0.399,0.304,
0.446,0.329,0.480,0.328,0.476,0.287,0.473,0.470,0.138,0.458,
0.240,0.208,0.215,0.589,0.297,0.224,0.088,0.286,0.201,0.087,
0.235,0.136,0.269,0.231,0.091,0.358,0.247,0.196,0.148,0.203,
0.125,0.131,0.299,0.556,0.297,0.259,0.182,0.055,0.216,0.206,
0.100,0.197,0.162,0.194,0.224,0.254,0.150,0.152,0.403,0.521,
0.548,0.263,0.277,0.103,0.243,0.201,0.113,0.250,0.210,0.223,
0.043,0.133,0.074,0.044,0.114,0.299,0.389,0.093,0.101,0.157,
0.187,0.115,0.025,0.122,0.078,0.049,0.201,0.447,0.331,0.228,
0.090,0.251,0.242,0.092,0.283,0.153,0.404,0.309,0.091,0.339,
0.345,0.212,0.109,0.108,0.127,0.115,0.309,0.530,0.538,0.325,
0.353,0.085,0.397,0.310,0.132,0.191,0.295,0.262,0.170,0.135,
0.107,0.126,0.156,0.157,0.145,0.107,0.119,0.022,0.095,0.098,
0.095,0.117,0.095,0.148,0.220,0.336,0.205,0.209,0.269,0.438,
0.423,0.271,0.231,0.084,0.241,0.249,0.104,0.286,0.169,0.198,
0.130,0.235,0.177,0.160,0.022,0.051,0.048,0.035,0.151,0.040,
0.206,0.194,0.095,0.168,0.161,0.155,0.126,0.100,0.103,0.119,
0.123,0.171,0.177,0.151,0.151,0.025,0.179,0.259,0.138,0.197,
0.232,0.279,0.200,0.206,0.143,0.156,0.206,0.209,0.154,0.138,
0.127,0.033,0.103,0.111,0.109,0.215,0.133,0.118,0.258,0.410,
0.199,0.179,0.370,0.457,0.374,0.256,0.344,0.188,0.442,0.307,
0.173,0.591,0.180,0.167,0.147,0.303,0.269,0.169,0.043,0.098,
0.104,0.063,0.192,0.079,0.179,0.171,0.071,0.219,0.142,0.124,
0.109,0.106,0.094,0.126,0.169,0.215,0.225,0.187,0.162,0.045,
0.170,0.188,0.127,0.157,0.159,0.226,0.032,0.052,0.040,0.022,
0.081,0.124,0.104,0.055,0.031,0.031,0.056,0.049,0.014,0.054,
0.067,0.026,0.050,0.152,0.070,0.035,0.125,0.257,0.197,0.083,
0.091,0.187,0.231,0.119,0.029,0.154,0.061,0.037,0.032,0.132,
0.104,0.041,0.040,0.160,0.161,0.053,0.078,0.109,0.172,0.091,
0.020,0.106,0.093,0.039,0.018,0.033,0.024,0.018,0.057,0.109,
0.110,0.071,0.040,0.032,0.088,0.062,0.020,0.046,0.050,0.041,
0.176,0.241,0.135,0.108,0.216,0.444,0.377,0.182,0.248,0.115,
0.332,0.287,0.095,0.252,0.250,0.198,0.039,0.132,0.065,0.031,
0.080,0.233,0.188,0.074,0.099,0.172,0.250,0.118,0.029,0.117,
0.081,0.041,0.147,0.484,0.321,0.171,0.069,0.247,0.220,0.070,
0.292,0.185,0.436,0.288,0.086,0.367,0.323,0.193,0.102,0.144,
0.156,0.119,0.232,0.556,0.449,0.338,0.251,0.118,0.424,0.421,
0.110,0.223,0.290,0.235,0.170,0.153,0.110,0.130,0.126,0.146,
0.094,0.092,0.129,0.035,0.107,0.116,0.109,0.161,0.100,0.172,
0.247,0.390,0.224,0.215,0.328,0.654,0.388,0.268,0.326,0.139,
0.415,0.378,0.150,0.424,0.256,0.235,0.186,0.354,0.240,0.184,
0.041,0.110,0.094,0.044,0.313,0.092,0.306,0.288,0.119,0.348,
0.262,0.223,0.141,0.161,0.143,0.149,0.207,0.261,0.199,0.182,
0.234,0.064,0.320,0.297,0.203,0.543,0.276,0.279,0.273,0.178,
0.142,0.202,0.212,0.147,0.147,0.197,0.164,0.021,0.088,0.156,
0.171,0.187,0.106,0.213,0.196,0.176,0.118,0.131,0.171,0.154,
0.137,0.144,0.156,0.032,0.132,0.156,0.130,0.202,0.093,0.139,
0.146,0.161,0.121,0.156,0.022,0.023,0.021,0.029,0.098,0.015,
0.080,0.101,0.071,0.108,0.084,0.141,0.179,0.118,0.122,0.195,
0.184,0.141,0.135,0.231,0.169,0.019,0.117,0.191,0.188,0.145,
0.172,0.373,0.393,0.336,0.254,0.236,0.442,0.364,0.687,0.290,
0.248,0.055,0.256,0.265,0.162,0.334,0.231,0.235,0.368,0.491,
0.283,0.265,0.422,0.535,0.530,0.360,0.389,0.130,0.489,0.475,
0.227,0.706,0.262,0.257,0.217,0.395,0.284,0.265,0.041,0.099,
0.108,0.076,0.231,0.063,0.249,0.272,0.136,0.374,0.230,0.233,
0.176,0.176,0.158,0.215,0.321,0.394,0.407,0.486,0.222,0.041,
0.272,0.294,0.189,0.244,0.261,0.368,0.187,0.163,0.138,0.125,
0.236,0.283,0.268,0.220,0.224,0.059,0.225,0.238,0.121,0.211,
0.206,0.229,0.025,0.039,0.030,0.025,0.038,0.079,0.067,0.040,
0.038,0.028,0.068,0.053,0.021,0.057,0.040,0.035,0.154,0.320,
0.230,0.213,0.038,0.083,0.085,0.055,0.285,0.101,0.309,0.298,
0.129,0.360,0.314,0.275,0.136,0.149,0.152,0.167,0.248,0.346,
0.350,0.353,0.306,0.077,0.363,0.410,0.169,0.259,0.315,0.336,
0.237,0.183,0.135,0.173,0.171,0.157,0.138,0.143,0.160,0.021,
0.110,0.158,0.139,0.153,0.140,0.278,0.200,0.189,0.137,0.149,
0.197,0.240,0.207,0.199,0.167,0.031,0.182,0.238,0.132,0.207,
0.157,0.244,0.231,0.285,0.202,0.247,0.033,0.040,0.038,0.038,
0.266,0.045,0.251,0.347,0.173,0.316,0.283,0.319,0.254,0.195,
0.187,0.298,0.279,0.282,0.262,0.311,0.352,0.048,0.361,0.467,
0.349,0.397,0.412,0.500,4.210,2.990,2.200,3.540,3.030,2.240,
2.260,2.100,2.420,0.287,2.820,2.180,2.750,2.480,1.870,2.600,
3.520,2.710,1.950,4.030,3.270,2.180,2.170,1.990,2.410,0.385,
1.820,1.770,1.500,2.210,1.420,1.960,2.090,2.040,1.580,2.300,
0.226,0.221,0.264,0.355,1.430,0.172,1.060,1.230,1.030,1.620,
1.210,1.550,2.110,1.140,0.943,1.990,1.890,1.510,1.250,1.640,
1.710,0.178,0.987,1.350,1.820,1.060,1.390,2.320,4.100,3.130,
1.690,2.580,3.600,3.120,2.280,2.280,2.770,0.465,1.690,2.230,
1.670,2.340,1.270,1.910,3.750,3.970,2.170,2.910,3.230,2.280,
2.760,2.190,5.240,1.580,2.870,3.280,1.810,3.900,1.470,1.750,
2.250,3.090,2.030,2.270,0.388,0.449,0.447,0.442,2.860,0.466,
2.160,2.460,1.230,2.640,1.860,1.860,1.660,1.190,0.823,1.410,
2.320,2.260,1.810,2.190,2.040,0.261,1.410,1.900,1.500,1.490,
1.440,2.380,3.020,1.920,1.260,1.760,3.760,3.170,3.370,2.920,
2.930,0.519,1.710,2.170,1.870,2.850,1.760,2.650,0.357,0.426,
0.275,0.403,0.509,0.543,0.805,0.570,0.475,0.164,0.441,0.463,
0.342,0.973,0.377,0.486,2.210,2.550,8.260,6.660,0.504,0.456,
7.100,3.900,2.440,0.437,1.820,1.950,1.190,2.360,2.370,2.090,
1.620,1.170,1.280,1.750,2.880,2.530,9.380,6.840,1.990,0.334,
1.690,2.120,1.490,1.750,1.890,2.500,3.580,1.220,0.888,1.720,
1.610,1.120,1.020,1.120,1.350,0.182,0.784,1.130,1.620,1.730,
1.050,2.010,2.480,2.130,1.350,2.280,2.100,1.990,1.990,1.810,
1.910,0.306,1.560,2.020,1.540,2.800,1.370,2.110,1.670,2.000,
1.910,2.220,0.216,0.235,0.499,0.463,1.720,0.227,1.500,2.410,
1.310,2.230,1.840,2.460,2.060,1.290,1.040,2.230,1.580,1.310,
1.690,2.070,2.200,0.243,1.710,3.120,2.410,2.350,2.510,3.940,
0.274,0.263,0.173,0.335,0.268,0.262,0.291,0.229,0.178,0.047,
0.123,0.161,0.147,0.215,0.143,0.230,0.401,0.471,0.460,1.960,
0.493,0.481,0.664,0.523,0.411,0.193,0.368,0.322,0.157,0.423,
0.218,0.265,0.138,0.254,0.169,0.232,0.038,0.063,0.057,0.056,
0.167,0.051,0.182,0.187,0.104,0.229,0.181,0.239,0.133,0.102,
0.089,0.179,0.190,0.211,0.174,0.176,0.131,0.031,0.118,0.144,
0.127,0.134,0.158,0.244,0.274,0.361,0.174,0.186,0.339,0.442,
0.401,0.235,0.293,0.157,0.174,0.183,0.107,0.281,0.133,0.143,
0.445,0.764,0.434,0.419,0.536,0.522,0.624,0.389,1.350,1.000,
0.595,0.545,0.278,1.060,0.257,0.226,0.211,0.492,0.264,0.232,
0.092,0.222,0.186,0.109,0.403,0.232,0.403,0.356,0.139,0.486,
0.372,0.262,0.129,0.133,0.092,0.112,0.243,0.345,0.265,0.248,
0.212,0.074,0.207,0.184,0.103,0.174,0.154,0.182,0.209,0.210,
0.122,0.137,0.411,0.488,0.537,0.286,0.278,0.099,0.233,0.190,
0.116,0.231,0.204,0.200,0.047,0.114,0.069,0.081,0.137,0.241,
0.276,0.115,0.109,0.144,0.192,0.118,0.031,0.143,0.095,0.060,
0.200,0.401,0.417,0.352,0.095,0.212,0.465,0.158,0.396,0.218,
0.499,0.358,0.138,0.498,0.452,0.307,0.135,0.122,0.120,0.133,
0.306,0.490,0.634,0.404,0.257,0.098,0.384,0.294,0.118,0.227,
0.284,0.251,0.241,0.185,0.127,0.173,0.159,0.154,0.129,0.133,
0.120,0.025,0.089,0.106,0.117,0.171,0.135,0.204,0.312,0.432,
0.262,0.464,0.378,0.487,0.417,0.359,0.329,0.109,0.283,0.307,
0.184,0.482,0.254,0.315,0.147,0.264,0.211,0.210,0.031,0.076,
0.070,0.048,0.211,0.061,0.249,0.300,0.124,0.295,0.261,0.264,
0.152,0.121,0.097,0.163,0.140,0.180,0.163,0.177,0.182,0.033,
0.208,0.260,0.173,0.231,0.260,0.314,2.040,2.130,1.490,2.140,
2.340,2.050,1.540,1.500,1.310,0.177,0.970,1.130,0.993,1.020,
0.792,1.140,3.440,3.530,1.850,2.140,6.090,3.480,3.320,2.360,
3.100,0.632,3.390,2.740,1.280,2.670,1.400,1.640,1.500,2.720,
1.650,1.730,0.372,0.579,0.441,0.458,1.590,0.363,1.750,1.750,
0.754,2.100,1.370,1.440,1.260,0.956,0.673,1.110,1.690,1.770,
1.380,1.510,1.470,0.212,1.330,1.720,1.110,1.280,1.330,2.260,
0.203,0.265,0.136,0.171,0.398,0.584,0.363,0.286,0.186,0.071,
0.208,0.183,0.093,0.183,0.112,0.140,0.311,0.475,0.226,0.201,
0.813,0.662,0.717,0.383,0.443,0.278,0.798,0.482,0.122,0.379,
0.190,0.168,0.164,0.449,0.227,0.219,0.079,0.221,0.194,0.094,
0.287,0.171,0.430,0.347,0.094,0.347,0.245,0.181,0.150,0.137,
0.087,0.143,0.305,0.459,0.299,0.323,0.204,0.068,0.261,0.307,
0.129,0.180,0.180,0.272,2.600,1.940,1.240,0.987,2.770,3.490,
3.150,2.090,2.160,0.547,2.390,1.870,0.953,1.800,1.750,1.650,
0.286,0.561,0.305,0.197,0.461,0.815,0.640,0.293,0.475,0.301,
0.910,0.458,0.174,0.579,0.383,0.271,1.930,2.790,2.240,1.580,
0.405,0.527,0.662,0.361,1.640,0.424,0.477,0.789,0.721,1.640,
1.730,1.370,1.090,0.997,0.963,0.794,1.930,2.670,2.550,1.740,
1.940,0.427,2.650,2.190,0.956,1.490,2.060,1.850,1.590,1.100,
0.899,1.080,1.370,1.300,1.020,0.793,1.020,0.160,0.885,0.921,
0.779,0.972,0.707,1.050,2.190,2.640,1.600,1.520,2.890,3.600,
2.610,1.750,2.360,0.480,3.050,2.630,1.220,2.750,1.680,1.630,
1.600,2.450,1.830,1.810,0.251,0.481,0.377,0.287,1.960,0.340,
2.100,2.040,0.952,2.220,1.790,1.680,1.240,1.040,0.848,1.090,
1.480,1.890,1.330,1.320,1.800,0.268,2.170,2.060,1.510,2.200,
1.980,2.060,2.370,1.420,0.939,1.740,1.430,1.110,0.885,1.090,
1.110,0.141,0.739,1.010,1.170,1.100,0.772,1.470,2.050,1.490,
0.930,1.270,2.040,1.140,1.580,1.310,1.200,0.160,0.979,0.970,
0.781,1.040,0.642,0.954,1.160,1.410,0.791,1.200,0.155,0.169,
0.131,0.215,1.110,0.143,0.703,1.010,0.811,1.140,0.829,1.290,
1.320,0.835,0.591,1.150,1.190,1.050,0.771,1.240,0.930,0.100,
0.653,1.050,1.110,1.030,0.937,2.140,2.820,2.390,1.450,1.970,
2.830,2.680,2.540,2.070,1.680,0.275,1.680,1.640,1.090,1.580,
0.918,1.510,3.280,3.460,2.440,2.210,4.470,3.530,7.290,4.480,
3.240,0.794,4.080,3.100,1.210,2.540,1.640,1.650,1.690,3.240,
1.530,1.690,0.277,0.507,0.386,0.378,1.950,0.380,1.930,2.360,
1.030,2.490,1.660,1.930,1.730,1.290,0.851,1.290,2.320,2.570,
2.030,2.330,1.520,0.225,1.550,2.140,1.220,1.470,1.360,2.470,
3.060,1.980,1.940,1.730,3.030,3.110,3.000,3.350,2.250,0.402,
1.840,2.100,1.360,1.870,1.740,2.290,0.471,0.346,0.632,0.309,
0.399,0.604,0.671,0.475,0.334,0.128,0.484,0.471,0.185,0.432,
0.283,0.299,2.500,3.950,2.390,2.330,0.417,0.556,0.672,0.501,
5.310,1.450,2.490,3.070,1.730,4.370,2.650,2.560,1.550,1.560,
1.200,1.290,2.660,2.960,3.170,2.720,2.370,0.428,2.470,2.920,
1.410,1.970,2.270,2.780,2.380,1.160,0.938,1.350,1.340,1.120,
0.945,1.050,1.170,0.145,0.833,1.060,1.200,1.080,0.880,1.740,
2.490,1.740,1.740,1.480,1.970,2.170,2.010,1.720,1.660,0.215,
1.570,1.980,1.300,1.660,1.240,1.690,1.860,2.620,1.520,1.980,
0.224,0.297,0.228,0.276,2.460,0.351,2.360,2.760,1.500,2.500,
2.280,2.490,2.060,1.310,1.080,1.840,1.950,2.090,1.760,2.020,
2.080,0.220,2.320,2.900,2.260,2.160,2.540,3.070,4.010,2.330,
2.020,3.560,2.340,1.650,1.400,1.560,2.200,0.213,0.919,1.540,
2.580,2.050,1.220,2.360,2.560,1.600,1.230,1.760,1.670,1.130,
1.100,1.070,1.470,0.151,0.991,1.300,1.260,1.400,0.862,1.360,
1.630,1.320,1.100,2.120,0.167,0.139,0.126,0.235,0.971,0.101,
0.549,0.825,0.970,1.160,0.827,1.480,2.460,1.070,1.060,2.240,
1.800,1.200,1.110,1.630,1.280,0.128,0.748,1.260,2.200,1.260,
1.340,4.850,3.200,2.020,1.180,1.870,2.080,1.420,0.964,1.200,
1.350,0.160,0.695,1.290,1.250,1.110,0.689,1.330,1.900,1.400,
1.630,1.650,1.160,0.784,0.802,0.773,1.320,0.239,0.733,1.000,
0.824,1.120,0.621,0.893,1.190,1.260,0.758,1.110,0.111,0.122,
0.085,0.121,0.945,0.108,0.523,0.722,0.995,1.120,0.756,0.932,
1.510,0.738,0.549,1.060,1.160,0.937,0.652,1.010,0.983,0.104,
0.603,0.934,1.110,0.805,0.811,1.590,2.520,1.330,0.933,1.540,
2.170,1.450,1.250,1.720,1.600,0.242,0.637,1.110,1.530,1.550,
0.977,1.820,0.200,0.172,0.126,0.232,0.186,0.180,0.135,0.161,
0.195,0.051,0.114,0.150,0.207,0.355,0.130,0.223,1.330,1.220,
1.350,1.780,0.147,0.150,0.324,0.297,1.280,0.190,0.634,0.929,
0.968,1.420,0.982,1.230,1.360,1.050,0.809,1.410,1.680,1.480,
1.420,1.760,2.930,1.130,1.200,1.710,1.620,2.770,1.360,2.240,
3.210,1.200,0.988,2.110,1.430,0.911,0.823,1.260,1.350,0.134,
0.687,1.110,1.870,1.340,0.905,2.120,2.080,1.400,1.070,2.300,
1.350,1.080,0.894,1.100,1.330,0.141,0.888,1.230,1.380,1.780,
0.966,1.620,1.390,1.150,0.985,1.550,0.122,0.105,0.095,0.158,
1.020,0.101,0.701,1.190,1.080,1.420,0.990,1.530,2.320,1.140,
1.130,2.740,1.520,1.000,1.030,1.810,1.840,0.250,1.180,2.150,
2.650,2.270,2.180,4.500,4.530,2.990,2.120,3.450,3.050,2.530,
2.030,2.230,2.090,0.288,1.080,1.910,2.050,2.160,1.390,2.590,
3.680,3.090,2.890,4.570,2.980,2.480,3.100,2.510,2.580,0.486,
2.090,2.460,1.500,2.410,1.620,2.100,1.750,2.040,1.460,2.010,
0.201,0.281,0.215,0.290,1.370,0.209,1.180,1.520,0.997,1.720,
1.320,1.970,1.920,1.110,0.993,1.630,2.060,1.910,1.390,1.740,
1.190,0.153,0.989,1.480,1.590,1.370,1.460,2.760,4.030,3.540,
2.140,2.840,3.650,3.700,2.300,2.580,2.000,0.475,1.190,1.690,
1.400,2.040,1.100,1.910,3.750,3.860,5.950,5.570,3.220,2.450,
2.790,2.330,4.200,1.530,2.410,2.880,1.630,3.870,1.610,1.930,
1.730,2.560,1.680,2.000,0.262,0.436,0.293,0.307,1.980,0.439,
1.560,1.910,1.130,2.550,1.650,2.210,1.600,1.190,1.110,1.480,
1.970,2.210,1.480,1.800,1.540,0.215,1.150,1.920,1.320,1.480,
1.320,2.130,2.660,1.970,1.180,1.680,3.350,3.080,2.770,2.640,
2.030,0.409,1.380,1.570,1.440,1.920,1.560,2.250,0.220,0.320,
0.257,0.335,0.362,0.531,0.453,0.350,0.267,0.149,0.324,0.303,
0.194,0.532,0.266,0.299,1.950,2.590,1.950,2.300,0.288,0.471,
0.468,0.397,2.410,0.504,1.910,2.240,1.280,3.000,2.420,2.530,
1.630,1.120,1.120,1.850,2.460,2.990,2.970,2.930,2.250,0.379,
2.170,2.610,1.580,1.950,2.500,3.190,2.450,1.530,1.330,1.920,
1.540,1.330,1.130,1.400,1.410,0.164,0.996,1.230,1.400,1.400,
1.170,2.140,2.740,2.690,1.880,2.830,2.260,2.780,2.230,2.280,
2.180,0.384,1.910,2.390,1.740,3.840,1.980,2.600,1.560,2.160,
1.600,2.030,0.155,0.252,0.181,0.220,1.530,0.213,1.510,1.990,
1.130,2.040,1.790,2.330,1.950,1.250,1.170,1.860,1.590,1.650,
1.270,1.710,1.670,0.187,1.590,2.300,2.030,2.220,2.470,3.730,
2.710,2.210,1.470,2.260,2.000,1.760,1.840,1.870,1.540,0.187,
0.805,1.200,1.480,1.450,0.834,1.520,3.000,3.410,1.570,1.900,
3.070,2.600,2.320,1.830,2.480,0.433,2.310,2.400,1.460,2.670,
1.380,1.840,1.620,2.710,1.600,1.790,0.232,0.418,0.343,0.360,
1.590,0.420,1.170,1.530,1.320,4.650,1.490,1.680,1.520,1.160,
0.804,1.380,1.590,1.670,1.400,1.570,1.670,0.231,1.210,1.840,
1.730,1.820,1.710,3.040,0.186,0.207,0.148,0.162,0.301,0.282,
0.208,0.187,0.126,0.031,0.111,0.123,0.107,0.177,0.100,0.164,
0.208,0.350,0.174,0.188,0.324,0.386,0.314,0.203,0.262,0.130,
0.365,0.305,0.119,0.320,0.154,0.172,0.117,0.274,0.145,0.136,
0.035,0.095,0.078,0.042,0.187,0.084,0.226,0.215,0.107,0.425,
0.225,0.179,0.141,0.122,0.081,0.133,0.216,0.284,0.197,0.214,
0.168,0.042,0.184,0.211,0.158,0.177,0.173,0.255,2.310,1.850,
1.140,1.180,2.430,2.910,2.400,1.730,1.810,0.496,1.970,1.730,
1.140,2.170,1.920,1.970,0.223,0.365,0.176,0.152,0.291,0.463,
0.336,0.209,0.283,0.159,0.775,0.285,0.169,0.489,0.314,0.233,
1.890,3.160,2.220,1.780,0.300,0.552,0.425,0.293,2.390,0.508,
1.170,1.690,1.090,2.850,2.010,1.810,1.420,1.330,1.080,1.150,
2.270,3.100,2.310,1.880,2.170,0.428,2.360,2.430,1.500,2.210,
2.180,2.390,2.020,1.360,0.950,1.470,1.490,1.310,0.963,1.000,
1.270,0.187,1.100,1.240,1.120,1.330,1.000,1.700,2.720,2.710,
1.590,1.950,2.620,2.990,1.940,1.620,2.580,0.442,3.310,2.890,
1.770,3.520,2.260,2.410,1.820,2.640,1.590,1.880,0.190,0.340,
0.228,0.232,2.250,0.313,1.750,2.290,1.490,3.190,2.210,2.320,
2.040,1.450,1.270,1.660,1.650,1.920,1.420,1.630,2.330,0.280,
2.380,2.840,2.460,2.770,2.690,3.200,3.700,1.710,1.120,2.220,
1.520,1.100,0.830,1.210,1.280,0.141,0.632,1.140,1.650,1.310,
0.867,2.070,1.970,1.440,0.732,1.160,1.270,0.943,0.792,0.901,
1.220,0.148,0.806,1.290,0.902,1.170,0.656,1.290,1.490,1.550,
0.812,1.620,0.139,0.143,0.096,0.195,0.955,0.123,0.554,0.992,
0.920,1.460,0.778,1.410,1.780,1.120,0.799,1.800,1.270,0.966,
0.814,1.370,1.200,0.111,0.881,1.440,1.730,1.270,1.360,3.350,
2.480,1.790,1.090,1.660,1.840,1.540,1.240,1.290,1.150,0.150,
0.759,1.270,1.100,1.380,0.778,1.670,2.180,1.920,1.130,1.390,
1.800,1.590,1.710,1.410,1.670,0.264,1.410,1.720,0.971,1.670,
0.919,1.410,1.430,2.530,1.020,1.350,0.121,0.232,0.128,0.161,
1.280,0.194,0.978,1.370,1.010,1.810,1.170,1.840,1.340,1.020,
0.708,1.220,1.420,1.400,1.090,1.430,1.380,0.130,1.110,1.610,
1.460,1.190,1.240,2.460,2.790,1.770,1.290,1.570,2.550,2.280,
1.800,2.280,1.890,0.310,1.280,1.860,1.740,1.990,1.850,2.690,
0.215,0.228,0.167,0.170,0.214,0.275,0.216,0.201,0.170,0.050,
0.200,0.226,0.197,0.308,0.224,0.270,2.240,3.050,1.930,2.260,
0.227,0.354,0.262,0.298,2.890,0.503,1.860,2.550,1.810,3.440,
2.620,3.070,1.930,1.780,1.310,1.720,2.440,2.640,2.550,2.660,
2.540,0.334,2.280,3.120,2.020,2.360,2.330,3.640,3.840,1.740,
1.180,2.160,1.820,1.370,1.050,1.400,1.760,0.179,0.984,1.700,
2.410,1.850,1.490,4.070,2.870,1.990,1.280,1.810,2.320,2.250,
1.510,1.670,2.180,0.210,1.740,2.440,2.080,2.370,1.680,3.020,
2.590,2.670,1.590,2.490,0.195,0.228,0.148,0.239,2.520,0.245,
2.000,2.910,2.360,3.220,2.730,3.720,3.820,1.980,1.690,3.380,
2.530,2.260,1.940,2.690,3.070,0.223,2.820,4.100,3.940,2.850,
2.990,4.490,6.710,4.260,3.240,6.930,4.210,2.540,2.200,2.990,
4.290,0.409,1.830,3.330,7.070,4.870,2.580,5.610,4.390,2.470,
1.740,2.510,2.640,1.680,1.290,1.540,2.420,0.172,1.180,1.750,
2.110,1.930,1.290,2.360,3.620,2.540,1.990,3.290,0.279,0.231,
0.180,0.378,1.760,0.163,0.852,1.350,1.950,2.000,1.310,2.270,
6.020,2.330,2.650,5.870,4.040,2.640,2.250,3.830,2.400,0.196,
1.270,2.250,3.930,2.440,2.240,4.640,4.690,2.310,1.590,2.690,
2.640,1.630,1.190,1.620,2.000,0.203,1.290,1.740,2.020,1.730,
1.030,2.030,2.640,1.620,0.981,1.370,1.560,0.961,0.763,0.855,
1.380,0.116,0.759,1.080,1.110,1.040,0.707,1.150,2.000,1.630,
1.280,1.750,0.159,0.153,0.115,0.172,1.650,0.277,0.748,1.040,
1.170,1.320,0.813,1.190,2.310,1.520,1.300,1.990,2.160,1.910,
1.500,1.840,1.680,0.135,0.983,1.570,1.850,1.420,1.430,2.610,
3.470,1.690,1.380,2.180,2.560,1.480,1.360,1.720,2.060,0.223,
0.884,1.520,2.080,1.830,1.400,2.700,0.242,0.198,0.110,0.186,
0.176,0.181,0.113,0.145,0.173,0.025,0.094,0.159,0.231,0.283,
0.148,0.264,1.820,1.210,1.130,1.350,0.148,0.122,0.101,0.152,
1.060,0.114,0.593,0.846,0.924,1.080,0.861,1.170,1.910,1.180,
1.100,1.760,2.150,2.010,1.310,1.680,1.770,0.178,0.981,1.490,
1.890,2.190,1.630,2.780,5.130,1.930,1.790,4.120,2.110,1.190,
1.290,1.750,2.350,0.216,0.985,1.690,3.050,1.980,1.710,3.860,
2.870,1.950,1.290,2.000,1.730,1.460,1.130,1.320,1.700,0.147,
0.943,1.640,1.780,1.740,1.260,2.260,2.320,1.460,1.250,1.860,
0.155,0.110,0.121,0.179,1.400,0.128,0.976,1.370,1.440,1.420,
1.150,1.740,3.480,1.680,1.710,3.360,1.970,1.380,1.460,2.080,
2.490,0.171,1.520,2.630,3.930,2.970,2.690,5.790,5.440,3.210,
2.180,3.940,2.790,1.920,1.430,1.860,1.820,0.198,0.820,1.660,
2.620,2.450,1.330,3.050,3.210,2.220,2.220,2.430,1.900,1.400,
1.190,1.280,1.340,0.139,0.861,1.240,1.260,1.450,0.937,1.580,
1.700,1.620,1.230,1.740,0.158,0.178,0.121,0.197,0.847,0.094,
0.569,0.807,0.968,1.240,0.793,1.390,2.180,1.150,1.230,2.050,
1.820,1.590,1.240,1.620,1.050,0.098,0.662,1.240,1.650,1.180,
1.220,2.740,3.210,2.170,1.050,1.880,2.100,1.700,1.010,1.290,
1.140,0.131,0.588,0.996,1.190,1.260,0.669,1.580,1.900,1.570,
0.830,1.070,1.430,0.899,0.851,0.867,1.010,0.132,0.642,0.926,
0.817,1.120,0.571,0.951,1.510,1.600,1.060,1.370,0.129,0.181,
0.127,0.140,0.900,0.148,0.598,0.789,0.844,1.220,0.688,1.170,
1.520,1.210,0.901,1.400,1.480,1.620,1.240,1.300,1.040,0.097,
0.601,1.230,1.040,0.972,0.788,1.690,2.220,1.420,0.952,1.540,
1.960,1.530,1.300,1.390,1.440,0.207,0.791,1.130,1.280,1.380,
1.060,2.070,0.123,0.158,0.086,0.135,0.132,0.254,0.113,0.120,
0.129,0.044,0.094,0.115,0.116,0.226,0.101,0.160,1.510,1.690,
1.310,1.500,0.185,0.415,0.126,0.149,0.960,0.111,0.681,0.906,
0.787,1.110,0.936,1.130,1.470,1.920,1.030,1.520,2.560,7.400,
1.410,1.770,1.450,0.189,0.877,1.380,1.250,1.280,1.220,2.000,
2.140,1.210,0.998,1.770,1.350,0.883,0.840,1.500,1.080,0.098,
0.556,0.934,1.420,1.030,0.909,2.260,1.570,1.320,0.850,1.320,
1.080,1.250,0.857,1.150,0.877,0.110,0.634,0.997,0.975,1.200,
0.755,1.440,1.320,1.140,0.949,1.330,0.093,0.101,0.069,0.112,
0.835,0.071,0.722,0.831,0.829,0.947,0.872,1.200,1.820,1.030,
1.100,1.700,1.280,1.540,1.000,1.370,1.450,0.130,0.923,1.690,
1.920,1.790,1.830,3.200,3.570,2.110,1.240,2.400,1.570,1.120,
0.766,1.220,1.310,0.169,0.722,1.140,1.960,1.930,0.880,1.970,
2.460,1.940,1.050,1.670,1.410,1.120,1.030,1.120,1.480,0.198,
1.020,1.220,1.840,2.650,0.982,1.640,1.590,1.750,1.230,1.750,
0.170,0.190,0.145,0.266,0.829,0.096,0.468,0.696,0.836,1.180,
0.804,1.190,2.030,1.280,1.220,2.270,1.600,1.280,1.070,1.710,
1.210,0.124,0.725,1.270,1.730,1.330,1.560,3.420,0.207,0.163,
0.084,0.147,0.176,0.142,0.083,0.107,0.106,0.021,0.062,0.096,
0.134,0.178,0.085,0.155,0.165,0.168,0.080,0.105,0.131,0.133,
0.084,0.089,0.120,0.025,0.095,0.107,0.133,0.215,0.079,0.131,
0.115,0.152,0.095,0.124,0.015,0.026,0.020,0.020,0.088,0.017,
0.056,0.080,0.083,0.128,0.076,0.117,0.228,0.163,0.140,0.253,
0.233,0.259,0.187,0.249,0.137,0.018,0.092,0.156,0.185,0.174,
0.157,0.325,1.540,1.090,0.655,0.948,1.160,1.070,0.919,0.862,
1.340,0.192,0.673,0.886,1.110,1.360,0.768,1.380,0.126,0.133,
0.071,0.093,0.098,0.128,0.083,0.075,0.119,0.026,0.087,0.099,
0.130,0.187,0.082,0.119,1.160,1.270,0.801,0.873,0.124,0.162,
0.106,0.107,0.834,0.100,0.445,0.563,0.570,0.819,0.606,0.780,
1.150,1.080,1.140,1.090,1.340,1.960,1.050,1.180,1.080,0.124,
0.784,1.040,0.955,1.070,1.020,1.480,1.690,0.985,0.675,1.210,
1.080,0.758,0.524,0.708,1.080,0.129,0.498,0.936,1.390,1.380,
0.693,1.800,1.770,1.320,0.825,1.320,1.330,1.340,0.794,0.913,
1.160,0.124,0.812,1.160,1.300,1.480,0.787,1.410,1.410,1.330,
0.849,1.110,0.115,0.141,0.083,0.114,1.060,0.094,0.611,0.846,
0.893,1.160,0.797,1.240,1.890,1.300,1.290,1.550,1.370,1.310,
0.940,1.200,1.660,0.168,1.130,1.550,2.120,2.280,1.630,2.900,
5.010,2.220,1.740,3.620,1.800,1.050,0.905,1.260,1.750,0.159,
0.762,1.420,3.730,2.050,1.280,3.690,2.100,1.230,0.838,1.390,
1.090,0.693,0.650,0.818,1.290,0.107,0.701,1.060,1.570,1.280,
0.830,1.700,2.070,1.520,1.240,2.220,0.163,0.135,0.105,0.244,
0.995,0.083,0.502,0.929,1.180,1.100,0.820,1.730,3.450,1.650,
2.040,4.670,2.070,1.320,1.350,2.360,1.640,0.129,1.020,1.680,
2.810,1.700,2.130,4.980,2.900,1.620,1.050,2.010,1.730,1.150,
0.790,1.170,1.300,0.134,0.717,1.220,1.590,1.480,0.843,1.790,
1.780,1.380,0.761,1.120,1.150,0.998,0.654,0.757,1.190,0.139,
0.835,1.110,1.220,1.210,0.719,1.150,1.440,1.210,0.838,1.550,
0.102,0.101,0.083,0.146,1.040,0.090,0.543,0.959,1.040,1.070,
0.700,1.330,2.040,1.220,1.170,2.440,1.870,1.490,1.290,2.200,
1.430,0.105,0.875,1.550,1.760,1.430,1.460,3.060,2.090,1.180,
0.938,1.440,1.640,1.140,0.954,1.380,1.680,0.182,0.914,1.500,
1.620,1.320,1.150,2.230,0.123,0.108,0.075,0.141,0.097,0.108,
0.085,0.094,0.118,0.015,0.089,0.184,0.141,0.151,0.096,0.180,
1.250,1.230,0.869,1.370,0.101,0.102,0.079,0.136,1.120,0.106,
0.674,1.100,0.927,1.080,0.922,1.430,1.550,1.140,1.290,1.750,
1.800,1.810,1.390,2.080,1.820,0.140,1.230,1.890,1.740,1.420,
1.810,3.100,3.600,1.740,1.610,2.790,1.780,1.160,0.953,1.360,
1.920,0.179,0.973,1.680,2.700,1.820,1.470,4.050,1.930,1.270,
0.925,1.670,1.290,1.020,0.851,1.130,1.290,0.099,0.934,1.560,
1.470,1.360,1.030,2.210,2.300,1.910,1.360,2.290,0.166,0.143,
0.105,0.202,2.830,0.190,1.140,1.760,2.020,2.000,1.630,2.530,
4.060,2.100,2.390,4.710,3.020,2.400,2.190,3.420,3.750,0.211,
2.500,4.100,5.900,4.030,4.110,7.610,6.660,4.060,3.030,5.060,
4.580,2.730,2.060,2.490,3.140,0.394,2.160,3.220,4.960,3.650,
2.190,3.990,4.070,2.910,1.880,2.360,3.070,2.180,1.570,1.720,
2.180,0.250,1.580,1.860,1.890,2.260,1.490,2.130,2.740,2.190,
1.720,2.430,0.290,0.241,0.185,0.318,1.650,0.339,0.997,1.180,
1.540,1.870,1.380,1.910,3.540,1.580,1.520,3.030,3.680,2.180,
1.600,2.380,1.850,0.184,1.170,1.740,2.690,1.770,2.060,3.660,
4.870,3.320,2.410,2.810,3.680,2.480,1.700,1.840,2.520,0.447,
3.890,3.820,2.190,2.480,1.830,2.640,3.490,2.970,1.700,1.960,
2.630,2.070,1.590,1.600,2.230,0.368,1.800,2.170,1.420,1.990,
1.320,1.750,2.260,2.680,1.580,1.940,0.379,0.430,0.234,0.261,
4.760,2.020,1.540,1.710,2.340,3.970,1.530,1.670,1.790,1.410,
0.941,1.460,3.200,2.290,1.440,1.940,2.070,0.341,1.180,1.620,
1.810,1.680,2.000,2.710,2.930,1.860,1.270,1.810,3.480,2.200,
1.880,1.980,2.340,0.374,1.300,1.670,1.820,2.060,1.630,2.830,
0.227,0.258,0.147,0.222,0.272,0.356,0.213,0.233,0.268,0.088,
0.192,0.237,0.209,0.412,0.230,0.321,1.600,1.600,1.330,1.460,
0.212,0.196,0.184,0.239,1.620,0.296,1.020,1.370,1.070,1.720,
1.450,1.890,1.620,1.080,1.010,1.610,2.250,1.900,1.600,1.970,
2.200,0.248,1.340,1.810,1.890,2.330,2.050,3.030,3.260,1.640,
1.230,2.220,1.910,1.160,0.952,1.280,1.830,0.253,0.943,1.500,
2.050,1.830,1.270,2.940,2.760,2.170,1.400,2.310,2.320,2.160,
1.430,1.890,1.810,0.265,1.250,2.120,1.490,2.250,1.510,2.710,
1.660,1.490,1.120,1.630,0.161,0.152,0.145,0.218,2.030,0.493,
1.040,2.710,1.250,2.130,1.310,2.050,2.390,1.360,1.260,2.410,
1.670,1.390,1.240,1.730,2.080,0.232,1.560,3.390,2.680,2.550,
2.520,4.880,4.650,3.240,2.120,3.300,3.240,2.580,1.870,2.010,
1.830,0.235,0.963,1.520,2.330,2.280,1.390,2.910,3.450,2.850,
1.680,2.160,2.650,2.320,1.780,1.860,1.730,0.291,1.390,1.720,
1.200,2.010,1.160,1.580,1.530,1.780,1.250,1.640,0.183,0.247,
0.191,0.242,0.923,0.140,0.802,0.975,0.805,1.250,0.958,1.360,
1.830,1.030,0.903,1.780,1.820,1.790,1.240,1.470,1.260,0.134,
0.942,1.300,1.450,1.170,1.290,2.380,3.760,3.340,1.550,2.250,
3.470,3.730,2.170,1.890,1.630,0.263,1.150,1.460,1.280,1.800,
1.010,2.290,3.250,3.610,1.710,1.830,2.320,1.260,1.620,1.630,
1.950,0.424,1.560,1.880,1.030,2.230,1.140,1.470,1.860,2.560,
1.370,1.720,0.270,0.450,0.284,0.263,1.430,0.330,1.100,1.260,
0.886,1.930,1.310,1.510,1.440,1.440,0.900,1.260,1.930,2.580,
1.550,1.620,1.360,0.158,1.120,1.330,1.090,1.330,1.150,2.040,
2.490,1.830,1.040,1.490,3.260,2.630,1.960,1.790,2.680,0.775,
1.270,1.400,1.530,2.550,1.360,2.270,0.195,0.343,0.136,0.213,
0.249,0.497,0.304,0.234,0.614,0.422,0.320,0.286,0.185,0.793,
0.197,0.215,1.760,2.190,1.590,1.630,0.260,0.427,0.287,0.275,
1.620,0.291,1.220,1.400,0.929,1.900,1.570,1.580,1.480,1.020,
1.240,1.530,2.420,2.920,2.230,2.200,3.390,0.334,1.620,1.920,
2.130,1.700,2.050,2.610,2.170,1.420,1.000,1.480,1.870,1.270,
0.996,1.130,1.490,0.218,0.729,0.902,1.460,1.340,1.060,1.880,
2.290,2.330,1.310,1.960,1.940,2.370,1.880,2.150,2.090,0.618,
1.270,1.520,1.090,2.440,1.160,1.600,1.310,1.690,1.110,1.370,
0.119,0.162,0.120,0.151,1.130,0.141,1.020,1.230,0.906,1.410,
1.200,1.440,1.940,1.100,1.320,1.660,1.410,1.380,1.700,1.620,
1.600,0.151,1.250,2.410,1.840,1.990,2.170,3.240,2.500,2.120,
1.200,1.960,1.710,1.390,0.919,1.130,1.170,0.238,0.730,0.939,
1.600,2.870,0.988,1.580,2.250,2.520,1.160,1.580,1.870,2.230,
1.370,1.460,1.850,0.555,1.570,1.560,1.750,7.050,1.150,1.630,
1.400,1.910,1.340,1.470,0.193,0.261,0.237,0.308,0.966,0.183,
0.729,0.898,0.709,1.490,0.873,1.080,1.320,0.994,0.832,1.590,
1.390,1.410,1.230,1.610,1.080,0.140,0.832,1.200,1.330,1.350,
1.300,2.550,0.153,0.157,0.088,0.114,0.264,0.230,0.151,0.136,
0.111,0.034,0.097,0.120,0.116,0.259,0.138,0.135,0.163,0.243,
0.115,0.124,0.244,0.393,0.225,0.168,0.192,0.095,0.218,0.192,
0.146,0.580,0.127,0.145,0.107,0.207,0.147,0.132,0.034,0.080,
0.087,0.045,0.149,0.064,0.155,0.147,0.089,0.215,0.128,0.118,
0.129,0.129,0.086,0.160,0.226,0.316,0.260,0.317,0.130,0.026,
0.138,0.164,0.119,0.147,0.150,0.233,1.710,1.770,0.898,1.030,
1.740,2.280,1.570,1.220,1.730,0.339,1.190,1.370,1.100,1.710,
1.160,1.640,0.155,0.300,0.119,0.139,0.178,0.433,0.237,0.154,
0.263,0.090,0.226,0.200,0.141,0.443,0.169,0.182,1.290,2.430,
1.370,1.330,0.198,0.411,0.277,0.229,1.490,0.286,0.987,1.140,
0.823,1.800,1.280,1.580,1.210,1.500,1.300,1.220,1.950,3.590,
1.920,1.960,1.660,0.279,1.400,1.750,1.210,1.620,1.630,2.180,
1.980,1.490,0.828,1.340,1.330,1.550,0.700,0.841,1.380,0.186,
0.720,1.130,1.580,1.680,0.869,1.810,2.330,2.800,1.260,1.710,
2.410,5.080,1.790,1.650,2.310,0.391,1.580,2.100,1.480,2.890,
1.450,1.910,1.950,2.310,1.330,1.430,0.160,0.267,0.163,0.170,
1.520,0.214,1.170,1.460,1.110,2.060,1.300,1.740,1.810,1.700,
1.310,1.780,1.540,1.900,1.240,1.500,1.840,0.208,1.730,2.260,
2.270,2.790,2.190,3.220,3.210,1.610,1.400,2.500,1.670,1.030,
0.860,1.350,1.360,0.143,0.697,1.240,1.800,1.570,0.979,2.190,
1.810,1.260,0.926,1.180,1.150,0.967,0.744,0.963,1.160,0.144,
0.830,1.080,1.110,1.680,0.762,1.290,1.780,1.500,1.170,1.620,
0.148,0.130,0.107,0.226,0.878,0.099,0.600,0.865,0.806,0.963,
0.734,1.410,2.020,1.080,1.150,2.430,1.530,1.020,0.957,2.080,
1.250,0.105,0.783,1.400,1.880,1.180,1.370,3.370,3.040,2.000,
1.310,2.060,2.600,1.950,1.810,1.740,1.660,0.231,1.200,1.700,
1.710,2.110,1.200,2.000,2.320,2.120,1.230,1.560,2.090,2.110,
1.570,1.660,1.990,0.354,1.630,2.190,1.610,2.620,1.390,1.770,
1.620,1.870,1.280,1.790,0.176,0.231,0.211,0.321,1.390,0.206,
1.060,1.400,1.170,1.850,1.140,1.630,1.630,1.360,1.060,2.220,
2.310,2.360,1.990,4.310,1.460,0.157,1.280,1.920,1.570,1.570,
1.600,3.230,1.880,1.350,0.970,1.280,2.050,1.730,1.350,1.540,
1.730,0.268,1.130,1.610,1.400,1.600,1.270,2.130,0.140,0.145,
0.094,0.148,0.145,0.233,0.155,0.148,0.135,0.043,0.137,0.200,
0.120,0.240,0.133,0.182,1.330,1.810,1.250,1.800,0.144,0.200,
0.155,0.236,1.530,0.249,1.300,1.520,1.070,1.850,1.630,2.150,
1.340,1.250,1.170,1.740,2.020,2.330,1.880,2.840,1.880,0.209,
1.600,2.110,1.650,1.630,2.060,3.000,2.650,1.710,1.250,1.970,
1.630,1.310,1.040,1.220,1.800,0.205,0.897,1.490,1.790,1.430,
1.130,2.600,2.160,1.670,1.080,1.550,1.900,2.170,1.430,1.590,
1.390,0.160,1.110,1.690,1.330,1.690,1.160,2.010,2.190,2.040,
1.420,2.230,0.172,0.185,0.132,0.220,1.940,0.197,1.490,2.020,
1.860,2.430,2.050,2.750,2.860,1.810,1.770,3.200,2.390,2.300,
2.000,2.810,2.860,0.233,2.610,3.650,3.850,3.400,3.590,4.970,
3.820,2.530,1.960,3.450,2.840,1.890,1.510,1.750,2.030,0.233,
1.160,1.990,2.730,2.280,1.560,2.940,2.740,1.830,1.220,1.910,
2.160,1.330,1.240,1.470,1.420,0.157,0.990,1.280,1.270,1.370,
1.130,1.700,2.160,1.670,1.160,1.880,0.199,0.148,0.131,0.236,
1.160,0.121,0.690,1.040,1.010,1.430,1.010,1.420,2.590,1.200,
1.050,2.070,1.980,1.340,1.080,1.660,1.460,0.116,0.834,1.170,
1.960,1.130,1.390,2.510,3.900,2.490,1.370,2.680,3.030,2.210,
1.490,1.810,1.970,0.227,0.988,1.550,1.650,1.690,1.030,1.890,
2.950,2.580,1.160,1.820,2.400,1.420,1.440,1.770,2.030,0.312,
1.160,1.650,1.440,1.550,0.888,1.340,1.950,2.110,1.220,1.670,
0.266,0.238,0.177,0.273,1.890,0.275,1.160,1.660,1.110,1.800,
1.300,1.680,1.760,1.210,0.769,1.450,2.160,1.980,1.310,1.910,
1.760,0.165,1.060,1.590,1.460,1.320,1.360,2.330,3.090,1.610,
1.020,1.730,3.130,2.210,1.900,1.990,2.950,0.364,1.020,1.720,
2.150,2.460,1.610,2.700,0.271,0.252,0.131,0.221,0.295,0.297,
0.272,0.277,0.291,0.055,0.187,0.258,0.297,0.532,0.266,0.351,
1.790,1.730,1.570,1.970,0.234,0.205,0.399,0.407,1.720,0.221,
1.020,1.530,1.130,1.820,1.540,1.760,1.710,1.050,0.869,1.450,
2.440,2.100,2.050,2.480,2.040,0.217,1.290,1.860,2.050,1.870,
1.980,2.740,2.980,1.280,0.914,1.970,1.630,1.070,1.010,1.210,
1.670,0.172,0.724,1.230,1.980,1.630,1.100,2.570,2.200,1.780,
0.976,1.580,1.730,1.460,1.300,1.530,1.680,0.181,1.030,1.520,
1.500,1.880,1.200,1.930,1.870,1.870,1.380,1.950,0.187,0.174,
0.173,0.257,1.680,0.173,1.170,1.830,1.420,1.940,1.680,2.300,
2.590,1.530,1.190,2.450,1.830,1.490,1.390,1.970,2.730,0.215,
1.540,2.780,3.340,2.700,2.810,4.770,0.218,0.178,0.110,0.186,
0.189,0.171,0.143,0.150,0.123,0.018,0.072,0.117,0.143,0.184,
0.128,0.207,0.204,0.188,0.139,0.293,0.220,0.190,0.250,0.191,
0.136,0.034,0.110,0.127,0.109,0.165,0.126,0.154,0.121,0.136,
0.094,0.133,0.020,0.022,0.021,0.026,0.092,0.017,0.075,0.113,
0.070,0.131,0.091,0.140,0.140,0.084,0.071,0.142,0.163,0.170,
0.113,0.153,0.114,0.015,0.083,0.122,0.143,0.112,0.135,0.252,
0.209,0.196,0.092,0.153,0.225,0.280,0.178,0.188,0.121,0.035,
0.076,0.098,0.086,0.135,0.081,0.123,0.237,0.347,0.127,0.162,
0.351,0.379,0.252,0.278,0.279,0.132,0.154,0.185,0.135,0.270,
0.106,0.139,0.136,0.208,0.117,0.136,0.035,0.067,0.053,0.041,
0.226,0.077,0.161,0.230,0.101,0.236,0.159,0.219,0.123,0.104,
0.062,0.104,0.184,0.225,0.150,0.164,0.140,0.026,0.102,0.134,
0.092,0.117,0.108,0.183,0.159,0.107,0.068,0.095,0.192,0.207,
0.218,0.166,0.158,0.039,0.087,0.115,0.098,0.142,0.102,0.149,
0.019,0.032,0.016,0.019,0.039,0.060,0.058,0.043,0.034,0.029,
0.037,0.047,0.014,0.040,0.028,0.028,0.133,0.176,0.143,0.159,
0.032,0.058,0.077,0.042,0.204,0.063,0.144,0.159,0.088,0.203,
0.158,0.156,0.116,0.090,0.077,0.111,0.212,0.318,0.228,0.223,
0.181,0.034,0.141,0.189,0.138,0.203,0.186,0.214,0.174,0.147,
0.092,0.144,0.137,0.120,0.109,0.115,0.119,0.016,0.069,0.097,
0.132,0.130,0.109,0.215,0.209,0.259,0.133,0.207,0.211,0.248,
0.195,0.251,0.182,0.043,0.138,0.182,0.127,0.259,0.143,0.224,
0.127,0.158,0.127,0.179,0.018,0.033,0.028,0.036,0.143,0.028,
0.136,0.174,0.097,0.172,0.165,0.231,0.175,0.121,0.100,0.172,
0.147,0.154,0.131,0.156,0.185,0.021,0.135,0.212,0.212,0.225,
0.233,0.383,2.550,1.940,1.160,1.840,2.280,1.580,1.090,1.360,
1.190,0.143,0.722,0.986,1.090,1.020,0.716,1.320,2.200,1.960,
1.010,1.360,2.550,1.790,1.740,1.420,1.540,0.247,1.720,1.590,
0.951,1.800,1.000,1.430,1.260,1.870,1.120,1.390,0.214,0.295,
0.222,0.327,1.050,0.167,0.856,1.040,0.658,1.430,0.880,1.200,
1.300,1.030,0.693,1.180,1.440,1.380,1.040,1.420,1.220,0.144,
1.000,1.410,1.350,1.230,1.660,2.790,0.205,0.173,0.081,0.124,
0.250,0.319,0.147,0.165,0.098,0.029,0.077,0.097,0.080,0.137,
0.062,0.120,0.151,0.191,0.080,0.093,0.250,0.229,0.201,0.156,
0.134,0.055,0.188,0.161,0.069,0.143,0.082,0.099,0.093,0.206,
0.100,0.105,0.030,0.069,0.056,0.036,0.119,0.045,0.139,0.150,
0.061,0.162,0.113,0.126,0.135,0.116,0.068,0.134,0.212,0.292,
0.162,0.225,0.130,0.026,0.137,0.213,0.122,0.133,0.190,0.305,
1.790,1.430,1.060,0.973,2.250,2.360,3.840,1.690,1.680,0.321,
1.390,1.390,1.010,1.330,1.220,1.500,0.166,0.248,0.125,0.119,
0.231,0.365,0.334,0.165,0.210,0.103,0.284,0.255,0.120,0.257,
0.164,0.166,1.640,2.270,1.640,1.340,0.261,0.334,0.351,0.246,
1.400,0.244,0.553,0.898,0.739,1.380,1.280,1.270,1.090,0.961,
0.850,0.849,1.950,2.120,1.980,1.700,1.420,0.223,1.600,1.610,
1.120,1.270,1.760,1.950,1.700,1.040,1.010,1.170,1.470,1.150,
1.450,0.929,1.110,0.135,0.788,0.968,1.020,0.976,0.737,1.310,
1.890,1.910,1.140,1.250,2.120,2.410,1.880,1.400,1.600,0.247,
1.770,1.830,1.050,1.930,1.230,1.490,1.730,2.030,1.570,1.720,
0.184,0.280,0.215,0.225,1.580,0.217,1.630,1.770,1.030,1.820,
1.540,1.710,1.510,1.150,0.989,1.340,1.580,1.590,1.350,1.440,
1.790,0.192,1.790,1.840,1.810,2.110,2.000,2.510,2.640,1.380,
1.010,1.870,1.560,1.030,0.769,1.080,1.190,0.132,0.598,0.996,
1.430,1.230,0.845,1.780,1.860,1.240,0.744,1.090,1.300,0.915,
0.861,0.919,1.020,0.100,0.717,1.090,0.816,1.060,0.757,1.190,
1.310,1.380,0.793,1.310,0.135,0.146,0.093,0.194,1.050,0.105,
0.630,1.060,0.865,1.130,0.808,1.460,1.640,1.020,0.744,1.490,
1.380,1.140,0.818,1.430,1.340,0.123,0.712,1.220,1.520,1.130,
1.250,2.940,3.220,2.080,1.070,1.950,2.610,2.090,1.330,1.580,
1.440,0.171,0.912,1.470,1.290,1.580,0.831,1.690,2.310,2.010,
0.953,1.370,2.140,1.730,1.840,1.700,1.500,0.193,1.370,1.960,
0.912,1.300,1.000,1.380,1.560,2.070,0.994,1.540,0.160,0.241,
0.145,0.225,1.300,0.178,1.080,1.570,0.959,1.760,1.160,1.690,
1.690,1.280,0.863,1.550,2.020,2.270,1.470,2.260,1.510,0.161,
1.260,2.220,1.390,1.530,1.640,3.280,3.120,1.540,1.190,1.610,
2.550,2.510,2.200,2.100,1.840,0.325,1.350,3.180,1.450,1.670,
1.520,2.490,0.365,0.191,0.146,0.217,0.203,0.346,0.318,0.234,
0.213,0.060,0.259,1.240,0.133,0.233,0.165,0.300,1.980,2.240,
1.480,1.860,0.206,0.237,0.233,0.283,2.270,0.372,1.370,2.170,
1.340,2.260,1.820,2.290,1.770,1.300,1.230,1.460,2.410,2.130,
2.290,2.540,1.960,0.240,1.890,2.900,1.710,1.740,2.360,3.240,
2.700,1.310,1.180,1.740,1.610,1.170,1.030,1.120,1.520,0.199,
0.908,1.580,1.440,1.240,1.080,2.270,2.360,1.430,0.992,1.470,
1.640,1.820,1.450,1.460,1.350,0.149,1.290,3.000,1.070,1.390,
1.100,1.870,2.230,2.220,1.540,2.370,0.188,0.201,0.161,0.251,
2.230,0.220,1.880,2.660,1.770,2.330,2.210,2.630,2.910,1.630,
1.320,2.610,2.300,1.980,1.990,2.490,2.600,0.198,2.310,3.410,
3.070,2.590,3.010,4.470,7.510,3.190,2.570,5.420,2.780,1.750,
1.340,1.840,2.800,0.261,1.190,1.990,4.090,2.880,1.650,3.640,
3.050,1.880,1.290,1.920,1.880,1.100,0.930,1.140,1.560,0.119,
0.817,1.140,1.810,1.650,1.070,1.830,2.310,1.670,1.280,2.460,
0.187,0.146,0.123,0.273,1.260,0.111,0.622,1.080,1.390,1.530,
1.100,2.000,3.590,1.600,1.550,3.410,2.290,1.570,1.320,2.130,
1.670,0.133,0.935,1.610,2.810,1.720,1.950,4.970,3.790,1.930,
1.090,2.270,2.120,1.340,0.861,1.150,1.290,0.125,0.588,1.040,
1.540,1.240,0.738,1.550,2.250,1.530,0.831,1.300,1.470,0.856,
0.696,0.952,1.200,0.106,0.586,1.020,1.100,0.966,0.701,1.240,
1.490,1.280,0.776,1.370,0.113,0.111,0.079,0.133,1.460,0.264,
0.497,0.860,1.050,1.400,0.809,1.210,1.480,0.879,0.641,1.260,
1.310,1.090,0.715,1.160,0.947,0.087,0.537,0.904,1.480,1.100,
1.070,1.960,3.080,1.440,0.969,1.840,2.380,1.470,1.160,1.820,
1.970,0.218,0.636,1.220,2.280,1.840,1.110,2.490,0.218,0.155,
0.096,0.184,0.204,0.154,0.119,0.186,0.178,0.020,0.080,0.151,
0.270,0.301,0.133,0.303,1.550,1.280,1.040,1.670,0.138,0.108,
0.107,0.183,1.280,0.132,0.573,1.040,1.230,1.360,1.090,1.590,
1.760,1.010,0.916,1.790,1.930,1.340,1.120,1.830,1.750,0.206,
0.877,1.570,2.400,1.720,1.850,2.990,3.840,1.540,1.190,2.640,
1.700,1.030,0.906,1.350,1.860,0.162,0.796,1.400,3.030,1.830,
1.300,3.270,2.160,1.360,0.900,1.560,1.360,0.988,0.782,1.080,
1.460,0.111,0.769,1.290,1.740,1.640,1.040,2.170,1.870,1.510,
1.190,1.730,0.140,0.104,0.099,0.165,1.450,0.120,0.850,1.350,
1.680,1.820,1.460,2.330,3.240,1.590,1.480,3.270,2.040,1.360,
1.240,2.100,2.480,0.172,1.420,2.520,4.530,3.250,3.410,7.370,
4.440,2.560,1.570,3.270,2.630,1.790,1.220,1.650,1.840,0.185,
0.956,1.540,2.190,1.940,1.240,2.570,2.850,1.790,1.170,1.890,
2.000,1.360,1.270,1.300,1.390,0.149,0.936,1.180,1.360,1.380,
0.988,1.700,1.640,1.410,1.080,1.630,0.129,0.139,0.107,0.177,
1.010,0.110,0.656,0.980,0.987,1.270,0.912,1.640,1.840,1.080,
0.867,1.750,1.670,1.430,1.010,1.470,1.170,0.138,0.757,1.280,
1.630,1.300,1.480,3.290,3.470,2.250,1.070,1.980,2.680,2.080,
1.030,1.440,1.200,0.140,0.594,0.997,1.310,1.250,0.784,1.650,
2.300,1.980,1.170,1.570,2.050,1.690,1.040,1.350,1.460,0.259,
0.764,1.100,1.130,1.430,0.815,1.380,1.570,1.560,0.835,1.400,
0.149,0.173,0.105,0.152,1.420,0.197,0.733,1.120,1.000,1.620,
0.953,1.600,1.360,0.988,0.635,1.230,1.480,1.500,0.900,1.240,
1.180,0.100,0.631,1.140,1.240,1.270,1.130,2.140,2.290,1.280,
0.806,1.370,1.930,1.470,1.090,1.810,1.390,0.177,0.549,0.925,
1.340,1.300,0.900,1.880,0.123,0.109,0.066,0.116,0.118,0.170,
0.099,0.158,0.106,0.032,0.075,0.105,0.114,0.177,0.089,0.154,
1.490,1.440,0.989,1.470,0.133,0.156,0.120,0.172,1.380,0.157,
0.730,1.070,1.060,1.400,1.130,1.660,1.530,0.909,0.825,1.510,
1.820,1.790,1.340,1.810,1.710,0.139,1.000,1.600,1.700,1.380,
1.740,2.810,2.550,1.450,1.010,1.860,1.530,1.120,0.834,1.180,
1.520,0.144,0.700,1.130,1.860,1.450,1.040,2.440,1.990,1.550,
1.070,1.650,1.370,1.350,0.977,1.340,1.400,0.163,0.855,1.270,
1.370,1.890,1.080,2.020,1.530,1.480,1.130,1.760,0.115,0.109,
0.084,0.142,1.280,0.118,1.100,1.400,1.220,1.540,1.330,2.110,
2.180,1.180,1.130,2.020,1.700,1.420,1.090,1.460,2.040,0.160,
1.290,2.040,2.680,2.340,2.460,4.720,3.610,2.550,1.640,2.940,
3.930,2.250,1.400,1.990,1.940,0.188,1.070,1.480,1.920,1.670,
0.971,2.100,2.830,2.410,1.170,1.820,2.220,1.830,1.390,1.470,
1.960,0.230,1.450,1.770,1.640,2.470,1.220,2.200,1.890,2.230,
1.360,2.100,0.247,0.261,0.194,0.339,1.400,0.189,0.822,1.300,
1.150,2.270,1.190,1.880,1.990,1.420,1.000,2.110,1.850,1.630,
1.200,2.000,1.740,0.176,1.230,1.970,2.110,1.890,2.200,4.060,
0.305,0.204,0.127,0.172,1.400,0.477,0.182,0.196,0.170,0.026,
0.080,0.113,0.149,0.145,0.086,0.163,0.170,0.167,0.082,0.114,
0.230,0.197,0.114,0.120,0.141,0.030,0.126,0.151,0.109,0.174,
0.086,0.149,0.121,0.155,0.079,0.120,0.036,0.035,0.029,0.023,
0.125,0.030,0.084,0.120,0.085,0.192,0.104,0.154,0.161,0.127,
0.075,0.174,0.212,0.218,0.128,0.214,0.136,0.020,0.090,0.164,
0.170,0.172,0.192,0.320,2.540,1.650,1.100,1.370,2.610,2.260,
1.790,1.710,2.020,0.334,1.050,1.440,1.400,1.750,1.440,2.060,
0.153,0.180,0.091,0.116,0.208,0.264,0.143,0.133,0.173,0.043,
0.165,0.159,0.157,0.265,0.138,0.204,1.860,2.310,1.530,1.850,
0.194,0.262,0.207,0.226,1.720,0.242,0.889,1.450,1.140,1.980,
1.550,2.050,1.680,1.280,1.040,1.400,2.060,2.330,1.710,1.890,
2.370,0.247,1.680,2.100,2.060,2.220,2.170,3.010,2.690,1.680,
1.230,2.060,2.350,1.650,1.180,1.530,1.630,0.178,1.060,1.600,
1.740,1.630,1.180,2.590,2.850,2.300,1.350,1.940,3.170,2.570,
1.630,1.570,2.300,0.236,1.840,2.280,2.060,2.840,1.800,2.830,
2.570,2.540,1.890,2.470,0.196,0.223,0.192,0.257,2.280,0.220,
1.570,2.310,1.860,2.710,2.030,2.810,2.700,1.830,1.500,2.260,
2.050,1.880,1.510,1.930,2.940,0.243,2.300,2.540,3.570,3.310,
2.950,4.480,7.360,2.680,1.800,4.130,2.810,1.630,1.130,1.990,
2.230,0.198,0.978,1.930,3.070,2.260,1.440,4.370,3.060,1.890,
0.994,1.790,1.830,1.300,0.868,1.240,1.640,0.130,0.926,1.440,
1.470,1.480,0.984,2.180,2.700,2.250,1.280,2.850,0.199,0.169,
0.103,0.278,1.540,0.142,0.833,1.630,1.600,1.800,1.270,2.570,
3.740,2.250,1.590,3.800,2.310,1.710,1.310,2.650,2.270,0.181,
1.400,2.610,3.780,2.600,2.840,7.310,4.790,2.790,1.460,2.910,
4.970,2.790,1.240,2.000,1.820,0.187,0.881,1.810,2.010,1.920,
1.060,2.670,3.760,2.490,1.160,2.060,2.960,2.590,1.250,1.710,
1.960,0.182,1.190,1.980,1.510,1.790,1.050,2.130,2.480,2.420,
1.120,2.260,0.187,0.204,0.107,0.196,2.010,0.204,1.010,1.740,
1.970,2.730,1.460,2.670,2.390,1.580,1.070,2.410,2.230,2.120,
1.260,2.500,2.010,0.146,1.200,2.200,2.460,2.220,2.080,4.600,
4.100,2.220,1.680,2.420,3.380,2.560,1.880,3.050,2.600,0.309,
1.620,2.840,2.590,2.320,2.170,4.050,0.232,0.187,0.107,0.194,
0.192,0.215,0.131,0.208,0.154,0.028,0.197,0.502,0.191,0.240,
0.158,0.353,3.120,2.850,1.920,3.020,0.221,0.217,0.171,0.294,
2.690,0.296,2.330,2.710,2.460,3.260,4.000,4.330,3.210,2.060,
1.790,3.020,3.510,2.670,2.430,3.730,3.850,0.267,2.820,4.030,
3.740,2.860,4.160,6.220,8.170,3.140,2.190,4.600,3.350,2.320,
1.640,2.670,3.350,0.276,1.670,3.050,4.910,3.270,2.550,7.230,
4.280,2.710,1.830,2.970,2.900,2.510,1.600,2.330,2.700,0.196,
2.120,3.510,2.970,2.870,2.140,4.930,4.520,3.750,2.320,4.340,
0.221,0.216,0.153,0.316,3.780,0.271,2.740,4.220,4.070,4.410,
4.330,6.760,7.610,2.870,2.410,5.910,3.360,2.510,2.420,4.560,
4.740,0.257,3.460,5.890,4.670,3.620,3.640,9.020,20.5,6.990,
7.600,11.1,7.300,3.770,3.490,4.710,11.8,0.812,4.080,5.210,
11.6,6.990,5.510,11.2,7.880,3.820,3.110,4.010,4.050,2.180,
2.210,2.120,5.090,0.356,2.460,2.830,3.780,2.840,2.210,3.520,
14.1,4.920,3.990,4.880,0.680,0.381,0.331,0.612,4.470,0.370,
2.490,2.820,3.820,3.830,2.570,3.690,10.2,4.360,4.470,8.140,
5.980,3.840,3.220,5.410,5.120,0.393,2.670,3.790,7.440,3.950,
3.690,6.500,10.1,4.670,3.120,4.500,4.880,2.820,2.000,2.220,
4.560,0.445,1.810,2.590,3.830,3.620,1.860,3.330,5.150,2.960,
1.960,2.450,3.020,1.740,1.570,1.410,3.280,0.299,1.740,2.060,
2.050,2.110,1.420,1.900,4.860,3.360,2.090,2.700,0.486,0.287,
0.197,0.259,3.210,0.301,1.700,2.430,2.390,2.950,1.600,2.400,
3.630,2.270,1.730,2.820,3.470,2.060,1.620,2.070,2.970,0.223,
1.650,2.480,2.840,2.360,1.860,3.490,17.7,3.200,3.040,3.340,
3.960,2.210,2.120,2.080,6.030,0.574,1.900,2.900,4.040,3.210,
2.310,4.950,0.653,0.321,0.226,0.317,0.344,0.272,0.227,0.234,
0.398,0.055,0.232,0.313,0.449,0.560,0.278,0.509,3.190,1.960,
1.960,2.040,0.240,0.171,0.163,0.219,2.360,0.224,1.320,1.630,
1.800,2.650,1.500,2.050,2.800,1.670,1.660,2.430,2.680,1.970,
1.640,2.330,2.520,0.240,1.720,2.360,2.220,2.020,1.990,3.320,
10.2,3.650,3.170,6.130,3.620,1.920,1.900,2.390,5.360,0.506,
1.990,3.640,6.320,3.940,3.120,8.410,6.210,3.580,2.590,3.400,
3.910,2.380,2.350,2.410,3.900,0.269,2.080,3.140,4.140,3.350,
2.480,4.490,3.700,2.580,2.110,2.760,0.265,0.189,0.159,0.251,
2.660,0.186,1.480,2.120,2.450,2.490,2.040,2.810,5.220,2.820,
2.660,4.920,2.710,1.890,1.670,2.640,3.910,0.250,2.220,3.540,
5.260,3.300,3.060,5.910,8.030,3.770,2.810,4.250,3.440,2.220,
1.840,2.030,3.370,0.335,1.260,2.070,3.000,2.680,1.680,2.780,
4.000,2.410,1.630,1.940,2.270,1.460,1.360,1.250,2.360,0.503,
1.250,1.650,1.500,1.990,1.230,1.780,2.910,2.380,1.460,1.790,
0.247,0.222,0.161,0.219,1.490,0.171,1.200,1.230,1.180,1.660,
1.190,1.560,2.750,1.370,1.290,2.020,2.390,1.800,1.280,1.720,
1.830,0.197,1.090,1.850,1.950,1.400,1.350,2.710,5.010,3.070,
1.710,2.240,2.840,2.060,1.340,1.310,2.520,0.276,1.010,1.480,
1.740,2.170,0.929,1.640,2.490,1.820,1.050,1.290,1.470,0.851,
0.926,0.897,1.780,0.205,0.968,1.300,0.975,1.310,0.838,1.170,
2.440,2.390,1.290,1.540,0.224,0.257,0.137,0.168,1.850,0.254,
1.130,1.400,1.250,2.040,1.030,1.490,1.850,1.230,0.864,1.370,
1.830,1.550,0.937,1.150,2.090,0.170,0.960,1.980,1.330,1.230,
0.903,1.970,3.820,1.810,1.300,1.840,2.360,1.620,1.500,1.410,
2.370,0.341,1.080,1.520,1.730,2.100,1.210,2.280,0.206,0.198,
0.114,0.155,0.161,0.180,0.167,0.127,0.220,0.069,0.200,0.181,
0.171,0.505,0.159,0.222,1.970,1.870,1.460,1.400,0.167,0.171,
0.148,0.148,1.530,0.197,1.090,1.330,0.933,1.790,1.150,1.330,
1.400,0.849,0.869,1.190,1.660,1.440,1.170,1.470,1.460,0.155,
1.300,1.760,1.080,1.240,1.290,1.750,3.260,1.520,1.270,1.970,
1.750,1.040,0.931,1.050,1.680,0.151,0.765,1.230,1.840,1.390,
1.130,2.460,2.410,1.760,1.280,1.550,1.660,1.390,1.140,1.160,
1.610,0.179,1.040,1.480,1.330,1.960,1.160,2.080,1.800,1.580,
1.420,1.620,0.125,0.124,0.093,0.130,1.260,0.123,1.000,1.320,
1.130,1.440,1.280,1.770,2.190,1.250,1.280,1.920,1.470,1.140,
0.909,1.330,1.780,0.136,1.300,2.010,2.140,1.760,1.800,3.080,
10.2,3.190,2.730,3.620,1.970,1.280,1.050,0.953,9.590,0.392,
1.450,1.520,3.050,2.240,1.330,2.180,4.310,2.660,1.700,2.250,
1.980,1.470,1.310,1.250,3.000,0.268,1.580,1.710,1.760,2.070,
1.140,1.670,2.900,2.590,2.250,2.310,0.294,0.355,0.207,0.349,
1.570,0.190,0.997,1.180,1.320,2.010,1.070,1.690,2.830,1.930,
1.650,2.530,2.400,2.710,1.400,1.810,1.910,0.210,1.240,1.650,
2.080,1.790,1.690,3.440,0.490,0.301,0.198,0.269,0.316,0.229,
0.137,0.141,0.328,0.046,0.128,0.157,0.211,0.269,0.128,0.220,
0.333,0.235,0.142,0.158,0.213,0.206,0.145,0.127,0.232,0.039,
0.146,0.171,0.144,0.214,0.103,0.160,0.222,0.247,0.158,0.191,
0.033,0.047,0.035,0.030,0.188,0.038,0.169,0.185,0.141,0.246,
0.119,0.194,0.356,0.232,0.190,0.332,0.394,0.453,0.318,0.309,
0.249,0.030,0.183,0.268,0.248,0.247,0.210,0.395,2.830,1.460,
1.240,1.350,2.020,1.270,1.280,1.160,2.200,0.304,1.330,1.610,
1.360,1.410,1.260,1.650,0.216,0.162,0.096,0.132,0.146,0.123,
0.133,0.108,0.188,0.038,0.141,0.145,0.166,0.212,0.127,0.157,
1.990,1.560,1.200,1.120,0.164,0.154,0.130,0.135,1.650,0.197,
0.937,1.050,1.060,1.410,0.967,1.060,1.740,1.010,1.030,1.080,
1.450,1.330,1.210,1.200,1.660,0.196,1.460,1.640,1.110,1.310,
1.190,1.520,2.600,1.180,0.990,1.630,1.530,0.828,0.681,0.895,
1.750,0.160,0.820,1.370,1.820,1.280,1.010,2.130,2.640,1.650,
1.150,1.680,1.900,1.350,1.110,1.120,1.960,0.164,1.190,1.560,
1.840,1.770,1.170,1.720,2.380,1.710,1.290,1.460,0.196,0.168,
0.116,0.145,1.740,0.180,1.060,1.320,1.620,1.940,1.210,1.850,
2.200,1.210,1.250,1.590,1.760,1.450,1.090,1.330,2.170,0.176,
1.500,2.050,2.470,2.060,1.830,3.290,8.870,3.360,2.860,5.350,
2.740,1.420,1.370,1.610,3.640,0.277,1.320,2.150,4.940,2.710,
1.750,3.970,3.290,1.620,1.320,1.870,1.570,1.070,1.030,1.070,
2.590,0.182,1.510,1.850,1.790,1.420,1.000,1.670,2.870,1.950,
1.390,2.460,0.218,0.179,0.122,0.297,1.740,0.142,0.785,1.370,
1.560,1.620,0.928,1.930,3.710,1.840,1.860,4.200,2.440,1.730,
1.500,2.530,2.550,0.196,1.320,2.210,3.700,2.580,2.210,5.600,
5.690,2.770,2.070,3.110,3.910,1.900,1.420,1.640,2.890,0.273,
1.250,1.960,2.400,2.230,1.220,2.410,3.850,2.040,1.210,1.650,
2.090,1.650,1.000,1.140,2.260,0.291,1.280,1.890,1.560,1.750,
0.852,1.710,2.520,1.920,1.370,2.080,0.206,0.175,0.111,0.197,
1.910,0.187,1.180,2.090,1.590,1.990,1.070,2.070,2.930,1.550,
1.480,2.910,2.660,1.940,1.450,2.310,2.170,0.168,1.290,2.330,
2.350,2.060,1.600,3.440,2.720,1.730,1.360,1.880,2.090,1.220,
1.150,1.370,2.460,0.369,1.060,1.770,2.140,2.470,1.260,2.220,
0.191,0.150,0.100,0.168,0.130,0.117,0.109,0.108,0.189,0.029,
0.131,0.225,0.191,0.261,0.114,0.197,1.800,1.450,0.998,1.360,
0.125,0.101,0.083,0.130,1.790,0.155,0.900,1.280,1.500,1.410,
1.170,1.530,1.920,1.160,1.050,1.620,1.870,1.310,1.150,1.660,
2.090,0.311,1.230,2.040,1.680,1.630,1.380,2.420,4.800,1.950,
1.620,2.760,2.180,1.230,1.280,1.380,2.760,0.246,1.130,2.040,
3.520,2.280,1.730,4.350,2.280,1.280,0.945,1.580,1.390,0.873,
0.860,1.020,1.750,0.109,1.100,1.790,1.790,1.540,1.120,2.160,
3.340,2.380,1.670,2.380,0.245,0.150,0.121,0.191,2.410,0.167,
1.300,1.980,2.550,2.610,1.830,2.770,4.500,2.120,2.060,4.160,
3.060,2.170,1.650,2.580,3.590,0.207,2.110,3.650,5.540,3.440,
3.270,7.140,11.1,6.390,5.440,8.160,6.580,3.940,3.260,3.960,
5.970,0.598,2.720,3.810,7.000,5.380,3.110,5.410,5.460,4.110,
2.480,2.840,3.770,2.450,2.120,2.020,3.760,0.351,2.410,2.650,
2.690,2.780,1.970,2.830,3.930,3.260,2.310,3.050,0.491,0.321,
0.231,0.386,2.610,0.278,1.420,1.740,2.440,2.730,1.990,2.520,
4.580,2.840,2.180,4.140,4.260,3.050,1.960,3.000,3.020,0.287,
1.800,2.840,3.780,2.680,2.640,4.880,7.590,5.090,2.650,3.550,
6.590,3.920,2.280,2.270,4.510,0.519,2.180,2.680,3.080,3.450,
1.650,2.940,4.440,3.690,1.780,1.970,3.620,2.070,1.790,1.640,
3.360,0.426,2.270,2.690,1.880,2.520,1.420,2.150,5.190,3.830,
1.970,2.130,1.570,0.393,0.270,0.279,3.570,0.408,2.130,2.610,
2.190,3.400,2.010,2.400,3.070,1.980,1.110,1.840,5.290,2.390,
1.410,1.790,2.260,0.251,1.720,3.840,2.070,2.300,1.800,3.700,
4.260,2.500,1.850,2.390,4.000,2.570,1.940,1.890,5.510,0.670,
1.950,2.840,2.870,3.110,1.740,3.340,0.371,0.387,0.198,0.237,
0.386,0.450,0.288,0.253,0.436,0.120,0.343,0.358,0.295,0.819,
0.252,0.373,2.200,1.810,1.370,1.420,0.241,0.208,0.148,0.197,
1.890,0.255,1.280,1.610,1.180,1.840,1.250,1.550,2.600,1.210,
0.875,1.420,2.320,2.140,1.360,1.780,2.040,0.246,1.480,2.040,
1.560,1.770,1.750,2.800,4.620,2.500,1.710,3.170,2.220,1.340,
1.010,1.350,3.110,0.354,1.230,2.100,3.090,2.210,1.500,3.660,
4.370,4.080,1.900,2.420,2.910,2.630,1.860,1.890,2.850,0.334,
1.820,2.730,2.090,3.190,1.670,2.830,2.060,1.650,1.470,1.870,
0.215,0.141,0.134,0.178,1.670,0.152,1.110,1.510,1.300,1.740,
1.420,1.940,2.830,1.610,1.230,2.640,1.830,1.510,1.220,1.680,
2.720,0.215,1.690,2.900,3.040,2.650,2.620,5.030,6.190,3.830,
2.710,3.810,4.210,3.240,2.610,2.530,2.700,0.348,1.320,1.910,
2.510,2.660,1.460,2.540,3.910,3.040,1.790,1.950,3.030,2.180,
2.120,1.710,2.240,0.364,1.820,1.880,1.300,2.270,1.260,1.830,
2.050,2.490,1.600,1.710,0.234,0.304,0.223,0.266,1.370,0.193,
1.120,1.310,1.030,1.730,1.250,1.730,1.930,1.180,1.000,1.790,
2.100,1.970,1.370,1.700,1.500,0.165,1.040,1.990,1.560,1.340,
1.370,3.000,3.890,3.280,1.580,1.920,3.550,3.130,1.750,1.570,
2.400,0.354,1.370,1.710,1.470,2.210,1.000,1.660,2.170,1.960,
1.100,1.110,1.120,0.390,0.858,0.743,1.710,0.324,1.430,1.690,
0.835,1.760,1.100,1.200,1.970,2.850,1.450,1.540,0.342,0.411,
0.224,0.235,1.920,0.348,1.450,2.090,1.130,2.640,1.520,1.840,
1.360,1.130,0.707,1.120,1.990,2.050,1.110,1.380,1.610,0.216,
1.240,3.940,1.170,1.500,1.150,3.320,3.180,2.220,1.550,1.810,
3.310,3.060,2.190,1.880,3.920,1.190,2.320,2.040,2.400,6.380,
1.650,2.460,0.229,0.440,0.195,0.181,0.300,0.473,0.332,0.212,
0.737,0.433,1.160,0.379,0.431,3.110,0.390,0.310,1.720,2.360,
1.570,1.430,0.238,0.449,0.232,0.222,1.860,0.347,1.650,1.650,
0.917,2.510,1.520,1.500,1.310,0.953,0.826,1.140,2.120,2.800,
1.810,1.970,1.920,0.274,1.650,2.000,1.290,1.830,1.650,2.310,
2.500,1.630,1.110,1.600,1.640,1.250,0.872,1.050,1.770,0.247,
0.934,1.200,1.710,1.960,0.939,1.880,2.290,2.430,1.340,1.510,
1.860,2.090,1.470,1.470,2.790,0.712,2.160,1.830,1.550,5.200,
1.380,1.750,1.230,1.540,1.190,1.290,0.129,0.170,0.109,0.141,
1.070,0.138,1.040,1.180,0.865,1.500,1.220,1.410,1.520,0.970,
0.788,1.330,1.400,1.280,0.918,1.190,1.390,0.138,1.140,1.770,
1.630,1.890,1.690,2.810,5.200,3.420,2.180,3.140,3.670,2.370,
1.560,2.060,3.300,0.330,1.550,1.830,2.540,2.390,1.320,2.240,
3.680,3.400,1.650,2.250,3.070,2.620,1.960,2.050,3.930,0.520,
3.010,2.850,1.760,2.830,1.530,2.070,2.250,3.230,1.880,2.320,
0.329,0.462,0.262,0.436,2.110,0.332,1.570,1.940,1.420,2.440,
1.410,2.170,2.030,1.590,1.080,2.120,2.460,3.130,1.410,2.200,
2.280,0.279,1.650,2.420,2.140,1.770,1.800,3.670,0.373,0.294,
0.162,0.214,0.656,0.431,0.270,0.254,0.280,0.073,0.203,0.223,
0.189,0.314,0.148,0.239,0.257,0.284,0.149,0.192,0.349,0.397,
0.266,0.238,0.346,0.129,0.337,0.362,0.144,0.319,0.163,0.188,
0.189,0.354,0.187,0.181,0.069,0.118,0.076,0.058,0.302,0.111,
0.431,0.389,0.148,0.392,0.227,0.246,0.216,0.189,0.115,0.223,
0.419,0.550,0.273,0.350,0.253,0.052,0.270,0.424,0.210,0.246,
0.250,0.439,3.470,2.290,1.570,1.640,2.530,2.770,2.090,1.860,
2.910,0.586,1.950,2.220,1.620,2.320,1.610,2.160,0.258,0.326,
0.168,0.158,0.232,0.443,0.307,0.189,0.294,0.118,0.368,0.308,
0.170,0.443,0.220,0.202,1.600,2.630,1.540,1.430,0.251,0.411,
0.260,0.244,2.310,0.507,1.560,2.000,1.130,2.670,1.650,1.700,
1.320,1.210,0.932,1.130,2.100,3.080,1.930,1.930,2.530,0.468,
2.490,2.480,1.370,2.070,1.960,2.250,2.260,1.450,1.380,1.870,
1.550,1.050,0.873,1.390,1.680,0.202,0.971,1.660,1.550,1.370,
0.934,2.010,2.620,2.450,1.430,1.740,2.470,2.680,1.730,1.820,
2.540,0.352,2.190,2.570,1.700,2.760,1.640,2.060,1.620,2.330,
1.960,1.730,0.185,0.281,0.194,0.202,2.170,0.332,1.790,2.060,
1.420,2.790,1.770,2.270,1.570,1.170,0.960,1.410,1.660,1.710,
1.250,1.470,2.210,0.243,2.080,2.510,2.280,2.400,2.150,3.010,
4.690,2.190,1.820,3.330,2.510,1.320,1.290,2.090,2.410,0.215,
1.040,1.830,2.620,1.870,1.250,2.670,2.460,1.530,1.020,1.570,
1.530,1.100,1.030,1.460,1.690,0.153,1.210,1.640,1.370,1.280,
0.979,1.650,1.740,1.580,0.964,1.680,0.152,0.154,0.086,0.219,
1.160,0.118,0.714,1.420,1.050,1.310,0.817,1.630,2.270,1.300,
1.090,2.580,1.700,1.650,0.948,2.000,1.710,0.147,0.891,2.070,
2.360,1.610,1.630,4.190,4.450,2.610,1.970,2.530,3.980,2.380,
2.490,2.180,2.700,0.335,1.550,2.320,2.120,2.460,1.260,2.550,
2.910,2.280,1.230,1.650,2.400,2.150,1.510,1.830,2.740,0.493,
1.820,3.280,1.670,2.560,1.240,2.400,1.840,2.170,1.200,1.610,
0.232,0.246,0.141,0.220,1.880,0.272,1.600,3.090,1.530,2.680,
1.420,2.430,2.030,1.410,1.140,1.970,2.440,2.540,1.380,2.240,
1.940,0.199,1.470,2.840,2.000,2.050,1.740,3.720,2.300,1.600,
1.230,1.570,1.860,1.560,1.330,1.490,2.550,0.389,1.440,1.940,
1.760,2.270,1.500,2.400,0.148,0.160,0.098,0.153,0.138,0.194,
0.162,0.141,0.169,0.045,0.175,0.204,0.147,0.322,0.158,0.211,
1.250,1.570,0.962,1.240,0.121,0.143,0.104,0.158,1.680,0.222,
1.280,1.710,1.120,1.790,1.330,1.650,1.360,1.200,0.925,1.350,
1.620,1.680,1.150,1.730,2.000,0.277,1.570,2.360,1.530,1.720,
1.730,2.660,2.950,1.650,1.430,2.210,1.380,0.953,0.762,1.030,
1.950,0.228,1.020,1.600,1.870,1.520,1.200,2.710,2.030,1.550,
1.090,1.520,1.500,1.300,1.110,1.250,1.520,0.139,1.120,1.650,
1.510,1.720,1.220,2.050,1.880,1.960,1.440,1.860,0.158,0.163,
0.104,0.163,2.080,0.225,1.320,2.020,1.900,3.110,1.720,2.550,
2.810,1.690,1.560,2.940,2.540,2.420,1.540,2.170,2.960,0.235,
2.130,3.520,3.950,3.180,3.110,4.660,8.450,4.090,3.500,5.530,
4.390,2.720,2.340,2.580,5.770,0.501,1.910,2.590,5.290,3.960,
2.410,3.840,3.050,1.850,1.290,1.660,2.210,1.310,1.320,1.310,
2.350,0.227,1.260,1.460,1.690,1.670,1.230,1.710,2.660,2.050,
1.940,2.270,0.264,0.213,0.180,0.305,1.840,0.167,1.070,1.400,
1.580,1.750,1.310,1.780,3.410,1.650,1.490,2.710,2.670,2.090,
1.550,2.160,2.140,0.177,1.230,1.820,2.610,1.570,2.160,3.680,
6.720,3.830,2.410,3.510,5.260,3.300,2.910,2.710,4.950,0.509,
1.860,2.310,3.010,3.210,1.600,2.670,3.680,2.760,1.620,1.850,
3.050,1.610,1.940,1.780,3.280,0.383,1.790,2.300,1.900,2.230,
1.260,1.720,4.080,3.580,2.400,2.590,0.608,0.368,0.287,0.366,
4.030,0.401,2.100,2.560,2.700,3.140,1.940,2.220,2.870,1.990,
1.270,2.130,3.680,2.570,1.850,2.250,2.460,0.220,1.450,2.160,
1.920,1.800,1.760,2.900,8.440,2.510,2.320,3.100,6.260,3.280,
3.010,3.010,42.5,3.040,4.710,4.950,9.140,4.670,2.600,4.280,
0.551,0.442,0.267,0.348,0.582,0.463,0.397,0.383,1.850,0.251,
0.464,0.498,0.957,1.220,0.367,0.576,2.090,2.080,2.410,1.860,
0.265,0.366,0.239,0.287,2.940,0.356,2.010,1.780,1.730,2.590,
1.450,1.540,1.660,1.080,1.090,1.560,2.450,2.390,1.850,2.250,
3.170,0.315,1.630,2.120,2.070,1.840,1.870,2.900,4.970,1.810,
1.600,2.950,2.810,1.490,1.290,1.770,7.740,0.561,1.630,2.190,
7.110,3.210,1.720,3.940,3.420,1.860,1.400,1.770,3.060,1.870,
1.650,1.710,5.200,0.398,1.660,2.260,3.300,2.760,1.290,2.100,
2.180,1.850,2.150,2.200,0.223,0.185,0.189,0.259,2.180,0.211,
1.450,1.890,1.890,2.330,1.790,2.230,3.020,1.590,1.540,2.970,
1.970,1.430,1.520,2.280,3.430,0.263,1.910,3.190,4.570,3.110,
3.450,6.770,0.567,0.340,0.250,0.344,0.418,0.327,0.261,0.290,
0.398,0.054,0.155,0.223,0.336,0.383,0.204,0.293,0.393,0.300,
0.197,0.248,0.355,0.294,0.296,0.265,0.280,0.047,0.214,0.213,
0.186,0.277,0.194,0.245,0.241,0.251,0.222,0.215,0.044,0.045,
0.042,0.047,0.189,0.031,0.161,0.182,0.136,0.238,0.158,0.201,
0.255,0.152,0.139,0.226,0.346,0.298,0.246,0.284,0.265,0.029,
0.162,0.262,0.235,0.197,0.227,0.388,0.507,0.430,0.231,0.307,
0.528,0.500,0.366,0.319,0.455,0.126,0.192,0.222,0.232,0.424,
0.159,0.242,0.401,0.460,0.214,0.224,0.429,0.342,0.373,0.331,
0.383,0.096,0.281,0.312,0.171,0.306,0.172,0.218,0.387,0.456,
0.283,0.262,0.113,0.107,0.079,0.062,0.438,0.113,0.311,0.336,
0.200,0.428,0.260,0.265,0.285,0.212,0.154,0.228,0.719,0.494,
0.323,0.309,0.284,0.039,0.199,0.334,0.186,0.216,0.200,0.374,
0.448,0.247,0.179,0.223,0.502,0.459,0.404,0.300,1.660,0.266,
0.354,0.315,0.448,0.602,0.226,0.310,0.038,0.055,0.032,0.031,
0.063,0.100,0.093,0.066,0.158,0.112,0.102,0.070,0.053,0.196,
0.052,0.050,0.224,0.306,0.329,0.235,0.048,0.080,0.077,0.053,
0.388,0.103,0.308,0.284,0.203,0.565,0.265,0.217,0.192,0.131,
0.143,0.177,0.327,0.378,0.346,0.355,0.362,0.057,0.285,0.296,
0.198,0.253,0.240,0.317,0.481,0.333,0.237,0.337,0.349,0.261,
0.202,0.234,0.659,0.071,0.234,0.248,0.681,0.501,0.285,0.494,
0.546,0.459,0.337,0.338,0.626,0.637,0.528,0.454,0.956,0.137,
0.455,0.463,0.616,0.989,0.377,0.492,0.245,0.279,0.278,0.277,
0.035,0.050,0.040,0.048,0.298,0.047,0.252,0.314,0.227,0.369,
0.302,0.341,0.361,0.237,0.211,0.340,0.316,0.290,0.232,0.305,
0.397,0.039,0.286,0.430,0.491,0.425,0.449,0.740,3.800,2.040,
1.590,2.260,2.000,1.640,1.260,1.390,2.120,0.225,1.020,1.240,
1.550,1.300,0.989,1.390,2.000,1.710,1.110,1.240,1.850,1.780,
1.600,1.150,2.000,0.284,1.960,1.720,1.040,1.520,1.270,1.220,
1.690,2.140,2.400,1.910,0.272,0.371,0.362,0.379,2.360,0.302,
1.300,1.530,1.080,2.530,1.100,1.340,1.470,1.000,0.942,1.540,
1.670,1.720,1.400,1.540,1.870,0.222,1.250,1.850,1.440,1.370,
1.420,2.440,0.281,0.242,0.130,0.204,0.281,0.366,0.213,0.214,
0.215,0.045,0.131,0.159,0.128,0.199,0.097,0.166,0.185,0.204,
0.107,0.114,0.244,0.405,0.231,0.163,0.197,0.059,0.230,0.221,
0.112,0.162,0.097,0.108,0.168,0.281,0.240,0.257,0.045,0.086,
0.098,0.054,0.239,0.067,0.251,0.254,0.124,0.281,0.145,0.164,
0.212,0.142,0.122,0.228,0.329,0.368,0.295,0.303,0.232,0.036,
0.204,0.363,0.166,0.191,0.175,0.287,1.850,1.360,1.080,0.955,
2.110,2.050,2.890,1.420,2.610,0.431,1.720,1.580,1.160,1.470,
1.150,1.410,0.172,0.235,0.172,0.113,0.214,0.291,0.861,0.168,
0.252,0.077,0.316,0.243,0.181,0.281,0.183,0.158,1.470,1.620,
1.700,1.170,0.214,0.244,0.285,0.228,1.790,0.300,0.883,1.120,
0.823,1.440,1.280,1.110,0.960,0.684,0.726,0.809,1.350,1.470,
1.370,1.340,1.640,0.229,1.680,1.510,0.870,1.080,1.250,1.400,
1.650,0.963,0.864,1.110,1.250,0.953,0.791,0.762,1.610,0.176,
0.952,1.280,1.500,1.040,0.715,1.330,1.840,1.610,1.160,1.020,
1.940,1.940,2.840,1.250,2.120,0.281,1.800,1.880,2.910,2.180,
1.280,1.550,1.350,1.480,1.330,1.300,0.180,0.229,0.180,0.177,
1.610,0.205,1.740,1.570,1.150,1.700,1.330,1.430,1.320,0.800,
0.759,1.150,1.640,1.200,0.934,1.100,1.640,0.175,1.570,1.640,
1.520,1.480,1.460,1.970,3.390,1.610,1.300,2.290,1.520,1.020,
0.902,1.190,1.730,0.188,0.754,1.160,1.690,1.340,1.010,1.730,
1.720,1.060,0.772,1.010,1.030,0.786,0.717,0.765,1.050,0.101,
0.706,0.965,0.773,0.755,0.656,0.944,1.400,1.320,1.050,1.290,
0.130,0.121,0.102,0.182,1.060,0.114,0.667,1.060,0.940,1.280,
0.772,1.180,1.690,0.949,0.991,1.800,1.310,0.967,0.995,1.360,
1.310,0.111,0.728,1.300,1.660,1.200,1.380,2.600,4.000,2.700,
1.670,2.770,2.660,2.480,1.750,1.890,2.300,0.276,1.320,1.850,
1.800,2.150,1.070,2.220,2.570,2.310,1.240,1.570,2.300,2.800,
1.660,1.590,1.880,0.239,1.620,2.030,1.180,1.530,1.010,1.430,
1.910,2.440,1.660,1.970,0.197,0.281,0.227,0.252,1.990,0.274,
1.570,2.230,1.730,2.660,1.580,2.240,2.150,1.500,1.350,2.120,
2.370,2.230,1.820,2.210,2.060,0.224,1.480,2.510,1.820,2.130,
1.680,3.000,2.300,1.560,1.250,1.550,2.060,1.690,1.670,1.630,
2.870,0.344,1.390,1.810,1.550,1.550,1.210,1.940,0.174,0.198,
0.123,0.157,0.184,0.257,0.238,0.185,0.217,0.047,0.205,0.225,
0.150,0.234,0.145,0.191,1.370,2.210,1.290,1.390,0.138,0.180,
0.144,0.213,1.930,0.237,1.210,1.570,1.110,1.700,1.330,1.480,
1.270,1.020,0.907,1.200,1.630,1.600,1.440,1.690,1.790,0.178,
1.450,1.830,1.420,1.400,1.780,2.260,3.460,1.660,1.370,2.040,
1.780,1.390,1.060,1.140,2.030,0.291,1.070,1.740,1.740,1.220,
1.020,2.380,2.160,1.600,1.030,1.390,1.810,1.530,1.350,1.330,
1.630,0.148,1.160,1.660,1.660,1.490,1.130,1.840,1.970,1.990,
1.570,1.920,0.204,0.253,0.144,0.221,1.980,0.213,1.630,2.190,
1.790,2.220,1.910,2.180,3.040,1.510,1.430,2.530,2.550,2.730,
1.480,1.950,2.600,0.216,1.910,2.910,3.340,2.300,2.550,4.020,
8.200,3.950,3.690,7.850,3.750,2.030,1.830,2.670,4.600,0.372,
1.570,2.680,6.180,4.070,2.200,4.600,3.190,1.530,1.250,1.900,
1.900,0.955,0.931,1.080,2.160,0.151,1.130,1.350,1.860,1.460,
0.868,1.650,2.940,1.670,1.450,2.620,0.292,0.145,0.125,0.295,
1.690,0.138,0.848,1.300,1.680,1.610,1.100,2.080,4.400,2.010,
1.950,3.930,3.080,1.720,1.480,2.600,2.460,0.192,1.380,2.220,
3.800,2.200,2.210,5.570,4.810,2.140,1.420,2.600,2.420,1.350,
1.010,1.480,2.310,0.218,1.040,1.420,2.420,2.100,0.997,2.050,
2.460,1.420,0.835,1.300,1.580,0.698,0.702,0.855,1.750,0.127,
0.812,1.150,1.710,1.160,0.706,1.190,3.090,1.700,1.230,1.820,
0.484,0.136,0.093,0.160,1.690,0.131,0.792,1.160,1.550,1.490,
0.985,1.470,2.670,1.760,1.190,2.080,3.040,1.220,0.847,1.370,
1.570,0.112,0.842,1.400,1.760,1.350,1.190,2.550,5.140,1.880,
1.620,2.820,3.000,1.490,1.320,2.110,7.760,0.590,1.400,2.020,
6.390,3.250,1.580,3.680,0.418,0.223,0.140,0.287,0.257,0.158,
0.151,0.232,0.480,0.043,0.147,0.218,0.628,0.565,0.194,0.414,
1.810,1.330,1.330,1.720,0.169,0.115,0.096,0.183,1.730,0.188,
0.780,1.090,1.500,1.620,1.150,1.530,1.790,1.000,1.020,1.910,
1.940,1.160,1.060,1.930,1.810,0.155,0.958,1.680,2.120,1.560,
1.580,3.000,6.150,2.200,1.840,4.040,2.490,1.200,1.050,1.840,
6.060,0.440,1.510,2.290,10.9,4.630,2.310,6.240,3.920,1.780,
1.350,2.060,2.030,1.210,1.200,1.520,3.600,0.228,1.240,1.860,
4.510,3.020,1.520,3.020,2.410,1.500,1.500,2.040,0.182,0.113,
0.099,0.183,2.050,0.137,1.060,1.520,2.140,2.020,1.530,2.270,
4.110,1.870,1.840,4.020,2.290,1.420,1.390,2.420,3.570,0.218,
1.760,3.290,6.510,3.990,3.670,8.920,6.300,3.000,2.250,4.270,
3.230,1.990,1.570,2.140,3.020,0.286,1.130,2.040,3.260,2.930,
1.470,3.150,3.100,1.800,1.360,2.670,2.110,1.330,1.300,1.500,
1.850,0.189,1.690,1.550,1.460,1.580,1.040,1.850,2.350,1.850,
1.390,2.150,0.269,0.187,0.139,0.238,1.530,0.162,1.040,1.540,
1.360,1.830,1.140,2.060,2.330,1.250,1.190,2.200,2.280,1.570,
1.260,1.940,1.880,0.169,1.090,2.090,2.220,1.570,1.560,3.570,
4.680,2.690,1.690,2.790,3.130,2.100,1.370,1.610,2.720,0.309,
0.900,1.380,2.210,3.060,1.010,2.040,2.620,2.050,1.040,1.450,
2.090,1.220,1.130,1.240,1.800,0.212,1.050,1.440,1.300,1.630,
0.849,1.350,3.100,2.790,1.490,1.920,0.730,0.382,0.181,0.210,
2.260,0.294,1.210,1.710,1.590,2.470,1.310,2.010,2.260,1.560,
1.070,1.730,3.780,2.580,1.210,1.610,1.630,0.138,0.939,1.690,
1.530,1.370,1.140,2.410,3.990,1.650,1.270,2.050,2.650,1.750,
1.480,1.930,4.850,0.575,1.250,1.570,3.010,2.930,1.280,2.770,
0.203,0.172,0.109,0.188,0.194,0.188,0.188,0.259,0.339,0.068,
0.196,0.175,0.248,0.482,0.153,0.234,1.830,1.870,1.530,1.700,
0.181,0.181,0.136,0.202,1.920,0.255,1.060,1.430,1.350,2.460,
1.270,1.730,1.760,1.020,1.110,1.700,2.010,1.720,1.420,2.190,
2.090,0.174,1.290,1.810,1.810,1.580,1.560,2.770,4.050,1.980,
1.560,2.800,1.930,1.210,1.060,1.430,3.120,0.261,1.580,1.680,
3.890,2.590,1.860,3.800,2.900,1.960,1.500,1.990,2.010,1.690,
1.790,1.720,3.130,0.279,1.790,1.840,2.470,2.920,1.500,2.350,
1.920,1.630,1.370,1.930,0.166,0.141,0.094,0.178,1.720,0.150,
1.120,1.570,1.550,1.910,1.330,2.090,2.720,1.380,1.280,2.340,
2.090,1.530,1.130,1.790,2.500,0.177,1.460,2.750,3.330,2.450,
2.170,4.630,4.580,2.360,1.650,2.790,1.970,1.550,1.030,1.550,
2.370,0.213,0.924,1.450,2.170,1.660,1.070,2.000,2.970,2.080,
1.300,1.670,1.810,1.430,1.110,1.180,2.110,0.240,1.480,1.660,
1.590,1.940,1.170,1.800,2.630,2.420,2.240,2.640,0.252,0.265,
0.202,0.356,1.980,0.221,1.130,1.780,1.790,2.300,1.310,2.100,
2.340,1.550,1.290,2.320,1.950,1.670,1.240,1.930,2.330,0.226,
1.310,2.310,2.610,1.750,1.800,3.850,0.301,0.226,0.116,0.222,
0.235,0.237,0.121,0.175,0.200,0.037,0.098,0.151,0.179,0.269,
0.115,0.237,0.182,0.169,0.092,0.117,0.175,0.201,0.125,0.119,
0.176,0.031,0.154,0.163,0.134,0.180,0.106,0.152,0.186,0.225,
0.156,0.200,0.031,0.044,0.034,0.031,0.225,0.042,0.165,0.199,
0.167,0.265,0.141,0.220,0.250,0.183,0.138,0.299,0.335,0.304,
0.192,0.276,0.225,0.030,0.159,0.271,0.241,0.214,0.189,0.387,
2.630,1.560,1.030,1.320,2.030,1.760,1.420,1.390,2.230,0.334,
1.160,1.410,1.590,1.740,1.390,2.000,0.178,0.172,0.093,0.113,
0.150,0.191,0.181,0.115,0.195,0.035,0.189,0.162,0.174,0.271,
0.153,0.179,1.550,1.940,1.320,1.590,0.173,0.215,0.164,0.182,
1.790,0.228,0.998,1.330,1.080,1.920,1.260,1.670,1.520,1.080,
0.985,1.310,1.670,1.730,1.450,1.640,2.190,0.234,1.680,1.950,
1.560,1.890,1.790,2.440,2.540,1.340,1.070,1.750,1.570,1.050,
0.803,1.110,2.130,0.187,1.040,1.560,2.180,1.550,1.220,2.530,
2.680,1.920,1.280,1.720,1.980,1.780,1.470,1.430,2.580,0.218,
1.670,2.080,2.470,2.590,1.650,2.480,2.340,2.160,1.560,2.150,
0.176,0.203,0.127,0.187,2.260,0.204,1.680,1.880,2.000,2.540,
1.920,2.530,2.480,1.390,1.550,2.060,1.920,1.620,1.240,1.630,
2.740,0.213,2.080,2.360,3.070,2.740,2.550,4.150,8.070,2.730,
2.170,4.660,2.460,1.440,1.210,2.090,2.800,0.224,1.110,2.100,
3.490,2.220,1.600,3.880,2.870,1.470,1.040,1.640,1.610,1.110,
0.867,1.280,1.810,0.149,1.220,1.600,1.510,1.280,0.932,1.700,
2.500,1.850,1.280,2.590,0.182,0.160,0.125,0.279,1.590,0.142,
0.833,1.560,1.680,1.710,1.090,2.160,3.540,1.760,1.750,4.040,
2.170,1.460,1.570,2.520,2.340,0.174,1.280,2.790,3.910,2.310,
2.540,6.610,3.740,1.930,1.370,2.500,2.030,1.510,1.040,1.540,
1.890,0.176,0.870,1.580,1.970,1.790,1.050,2.700,2.230,1.540,
0.890,1.290,1.610,1.220,0.832,1.130,1.520,0.139,1.060,1.520,
1.310,1.300,0.899,1.650,2.010,1.750,1.140,2.020,0.141,0.141,
0.089,0.166,1.940,0.174,1.020,1.740,1.780,2.240,1.230,2.370,
2.470,1.560,1.510,2.840,2.260,1.650,1.300,2.080,2.040,0.157,
1.150,2.160,2.450,2.070,1.750,3.860,4.380,2.180,1.570,2.450,
2.920,1.870,1.580,2.450,3.550,0.386,1.390,2.280,2.890,2.470,
1.840,4.020,0.255,0.224,0.124,0.211,0.186,0.181,0.144,0.180,
0.218,0.029,0.138,0.200,0.250,0.301,0.183,0.326,2.340,2.470,
1.580,2.520,0.181,0.170,0.125,0.240,3.140,0.255,1.360,2.050,
2.030,2.480,1.800,2.830,2.780,2.140,1.700,2.610,3.030,2.300,
1.920,2.830,3.170,0.244,2.170,3.150,2.970,2.490,3.160,4.740,
9.060,3.730,2.490,5.140,3.250,2.280,1.610,2.480,4.260,0.353,
1.990,3.610,5.650,3.770,3.040,9.060,4.660,3.030,1.720,2.750,
3.040,2.790,1.700,2.210,3.370,0.228,1.870,3.150,3.560,3.190,
2.310,4.620,4.990,3.850,2.730,4.520,0.258,0.249,0.145,0.312,
4.340,0.294,2.870,4.140,4.530,4.640,3.950,5.930,10.3,4.290,
4.000,8.390,4.990,4.040,2.910,4.950,6.800,0.378,4.590,8.420,
10.000,5.870,6.250,10.5,0.885,0.499,0.418,0.657,0.536,0.338,
0.275,0.314,0.651,0.070,0.291,0.335,0.553,0.491,0.312,0.508,
0.584,0.362,0.237,0.257,0.365,0.227,0.207,0.182,0.382,0.042,
0.227,0.233,0.248,0.267,0.179,0.239,0.504,0.328,0.255,0.274,
0.048,0.037,0.032,0.043,0.301,0.039,0.222,0.204,0.217,0.294,
0.239,0.233,0.519,0.247,0.248,0.381,0.419,0.267,0.242,0.319,
0.328,0.036,0.196,0.265,0.344,0.245,0.237,0.343,0.713,0.418,
0.250,0.335,0.418,0.346,0.238,0.233,0.417,0.067,0.216,0.257,
0.261,0.338,0.164,0.247,0.472,0.365,0.192,0.210,0.339,0.246,
0.216,0.159,0.355,0.066,0.257,0.275,0.170,0.258,0.173,0.186,
0.296,0.321,0.200,0.216,0.042,0.052,0.039,0.032,0.332,0.066,
0.237,0.260,0.165,0.328,0.202,0.266,0.257,0.187,0.148,0.225,
0.304,0.240,0.169,0.225,0.361,0.040,0.209,0.397,0.225,0.223,
0.229,0.386,0.551,0.217,0.176,0.229,0.301,0.201,0.185,0.179,
0.379,0.060,0.161,0.212,0.233,0.249,0.177,0.302,0.066,0.040,
0.021,0.027,0.038,0.034,0.029,0.025,0.045,0.014,0.037,0.036,
0.035,0.056,0.029,0.038,0.177,0.159,0.152,0.137,0.021,0.023,
0.021,0.022,0.222,0.041,0.135,0.148,0.115,0.185,0.138,0.149,
0.201,0.108,0.104,0.135,0.199,0.156,0.139,0.168,0.236,0.036,
0.186,0.194,0.152,0.173,0.176,0.229,0.539,0.231,0.181,0.336,
0.233,0.149,0.132,0.147,0.367,0.033,0.132,0.209,0.350,0.249,
0.180,0.387,0.569,0.318,0.198,0.245,0.370,0.223,0.210,0.174,
0.357,0.032,0.194,0.259,0.272,0.283,0.193,0.310,0.222,0.193,
0.172,0.201,0.021,0.022,0.023,0.021,0.233,0.029,0.162,0.187,
0.167,0.223,0.183,0.210,0.299,0.167,0.160,0.255,0.205,0.157,
0.134,0.180,0.318,0.029,0.197,0.285,0.322,0.302,0.252,0.463,
0.647,0.441,0.282,0.366,0.396,0.323,0.253,0.226,0.558,0.064,
0.175,0.325,0.303,0.308,0.367,0.329,0.413,0.427,0.212,0.211,
0.305,0.252,0.228,0.174,0.287,0.069,0.214,0.237,0.148,0.256,
0.159,0.176,0.246,0.338,0.200,0.191,0.035,0.059,0.040,0.035,
0.230,0.037,0.236,0.189,0.127,0.253,0.285,0.196,0.243,0.151,
0.162,0.199,0.280,0.245,0.198,0.195,0.317,0.061,0.167,0.348,
0.195,0.197,0.168,0.328,0.564,0.479,0.220,0.251,0.384,0.478,
0.286,0.208,0.366,0.092,0.188,0.225,0.169,0.313,0.154,0.201,
0.347,0.387,0.181,0.191,0.290,0.207,0.250,0.169,0.318,0.084,
0.248,0.279,0.134,0.280,0.205,0.190,0.271,0.466,0.235,0.212,
0.048,0.134,0.064,0.043,0.390,0.112,0.291,0.300,0.158,0.486,
0.244,0.267,0.225,0.185,0.117,0.155,0.293,0.365,0.187,0.183,
0.837,0.080,0.204,0.367,0.195,0.220,0.161,0.465,0.325,0.213,
0.122,0.151,0.258,0.252,0.218,0.170,0.248,0.055,0.158,0.165,
0.128,0.212,0.152,0.195,0.044,0.051,0.024,0.023,0.037,0.051,
0.052,0.022,0.041,0.032,0.059,0.042,0.017,0.060,0.032,0.026,
0.175,0.249,0.419,0.163,0.038,0.059,0.051,0.030,0.224,0.057,
0.183,0.183,0.095,0.321,0.177,0.159,0.135,0.096,0.099,0.130,
0.222,0.260,0.211,0.202,0.234,0.039,0.198,0.228,0.104,0.166,
0.166,0.198,0.248,0.160,0.116,0.160,0.149,0.116,0.140,0.103,
0.162,0.021,0.087,0.112,0.138,0.134,0.100,0.175,0.290,0.281,
0.149,0.159,0.219,0.206,0.152,0.136,0.199,0.040,0.146,0.168,
0.123,0.265,0.153,0.191,0.164,0.210,0.176,0.168,0.017,0.029,
0.023,0.018,0.175,0.029,0.154,0.169,0.118,0.200,0.188,0.189,
0.247,0.154,0.118,0.164,0.199,0.153,0.112,0.139,0.285,0.054,
0.164,0.227,0.218,0.265,0.213,0.316,0.444,0.287,0.183,0.232,
0.219,0.183,0.127,0.121,0.336,0.046,0.138,0.147,0.187,0.229,
0.117,0.168,0.334,0.433,0.187,0.193,0.236,0.210,0.213,0.157,
0.292,0.057,0.222,0.214,0.147,0.267,0.136,0.161,0.214,0.280,
0.201,0.192,0.038,0.053,0.039,0.040,0.194,0.040,0.161,0.156,
0.114,0.239,0.131,0.159,0.193,0.136,0.117,0.159,0.248,0.225,
0.140,0.170,0.215,0.033,0.141,0.184,0.198,0.190,0.180,0.321,
0.047,0.049,0.023,0.026,0.048,0.070,0.032,0.028,0.060,0.048,
0.032,0.038,0.023,0.057,0.021,0.026,0.044,0.058,0.026,0.025,
0.049,0.064,0.046,0.028,0.053,0.032,0.055,0.047,0.022,0.050,
0.024,0.027,0.026,0.057,0.032,0.028,9.61e-3,0.029,0.021,9.53e-3,
0.047,0.026,0.074,0.050,0.021,0.059,0.032,0.029,0.030,0.026,
0.020,0.024,0.059,0.078,0.050,0.046,0.059,0.015,0.043,0.052,
0.032,0.041,0.033,0.057,0.193,0.162,0.099,0.108,0.192,0.176,
0.192,0.116,0.237,0.063,0.181,0.151,0.111,0.170,0.138,0.132,
0.023,0.037,0.019,0.013,0.024,0.031,0.042,0.015,0.033,0.020,
0.040,0.031,0.019,0.041,0.025,0.019,0.138,0.203,0.137,0.113,
0.027,0.045,0.040,0.022,0.213,0.067,0.154,0.152,0.087,0.210,
0.174,0.138,0.122,0.089,0.084,0.076,0.150,0.192,0.178,0.141,
0.230,0.051,0.186,0.185,0.110,0.194,0.159,0.165,0.176,0.109,
0.080,0.121,0.113,0.079,0.069,0.070,0.171,0.024,0.077,0.112,
0.147,0.120,0.080,0.147,0.228,0.199,0.123,0.137,0.185,0.183,
0.162,0.122,0.259,0.043,0.166,0.193,0.227,0.243,0.147,0.167,
0.163,0.200,0.160,0.136,0.022,0.036,0.026,0.019,0.203,0.041,
0.164,0.173,0.129,0.222,0.154,0.165,0.177,0.113,0.111,0.118,
0.166,0.165,0.128,0.130,0.260,0.031,0.199,0.237,0.206,0.240,
0.202,0.292,0.504,0.283,0.195,0.335,0.198,0.138,0.115,0.122,
0.236,0.031,0.106,0.168,0.299,0.236,0.147,0.270,0.225,0.164,
0.111,0.154,0.132,0.107,0.108,0.100,0.193,0.018,0.118,0.165,
0.136,0.157,0.099,0.149,0.203,0.187,0.124,0.192,0.026,0.023,
0.016,0.029,0.157,0.016,0.086,0.126,0.127,0.164,0.101,0.157,
0.246,0.135,0.140,0.282,0.220,0.153,0.137,0.184,0.209,0.028,
0.122,0.174,0.268,0.267,0.192,0.401,0.489,0.322,0.195,0.282,
0.354,0.282,0.184,0.201,0.338,0.069,0.178,0.251,0.240,0.388,
0.155,0.248,0.366,0.312,0.147,0.192,0.284,0.310,0.194,0.188,
0.328,0.076,0.235,0.339,0.175,0.344,0.151,0.218,0.235,0.270,
0.152,0.219,0.027,0.047,0.029,0.036,0.284,0.054,0.231,0.283,
0.190,0.341,0.193,0.261,0.232,0.157,0.147,0.224,0.289,0.258,
0.194,0.252,0.297,0.038,0.182,0.281,0.247,0.319,0.220,0.393,
0.252,0.228,0.112,0.154,0.211,0.165,0.136,0.138,0.348,0.076,
0.143,0.218,0.261,0.310,0.167,0.234,0.020,0.024,0.011,0.021,
0.016,0.023,0.023,0.016,0.038,0.016,0.025,0.041,0.027,0.049,
0.021,0.027,0.154,0.185,0.141,0.143,0.017,0.024,0.032,0.020,
0.188,0.039,0.126,0.156,0.123,0.196,0.233,0.176,0.149,0.114,
0.090,0.133,0.199,0.180,0.167,0.177,0.407,0.195,0.194,0.252,
0.171,0.330,0.177,0.250,0.346,0.181,0.129,0.205,0.172,0.107,
0.097,0.110,0.256,0.027,0.103,0.172,0.262,0.221,0.164,0.334,
0.197,0.132,0.096,0.148,0.130,0.103,0.098,0.111,0.210,0.024,
0.119,0.205,0.174,0.211,0.126,0.205,0.246,0.215,0.165,0.213,
0.026,0.022,0.020,0.021,0.298,0.031,0.161,0.241,0.217,0.279,
0.311,0.287,0.330,0.169,0.167,0.309,0.266,0.221,0.184,0.234,
0.389,0.040,0.249,0.384,0.449,0.358,0.354,0.614,0.635,0.446,
0.376,0.465,0.476,0.378,0.265,0.282,0.432,0.072,0.236,0.304,
0.410,0.427,0.222,0.350,0.471,0.402,0.242,0.241,0.440,0.320,
0.263,0.214,0.354,0.060,0.295,0.291,0.214,0.320,0.204,0.249,
0.269,0.289,0.202,0.217,0.038,0.055,0.039,0.041,0.220,0.039,
0.162,0.163,0.149,0.248,0.170,0.192,0.296,0.187,0.208,0.288,
0.303,0.298,0.193,0.247,0.292,0.041,0.176,0.332,0.240,0.224,
0.204,0.372,0.608,0.478,0.247,0.311,0.528,0.452,0.271,0.232,
0.390,0.088,0.258,0.286,0.220,0.353,0.166,0.250,0.459,0.506,
0.233,0.228,0.486,0.368,0.315,0.243,0.442,0.130,0.398,0.471,
0.181,0.357,0.202,0.334,0.299,0.439,0.242,0.210,0.095,0.095,
0.072,0.052,0.357,0.108,0.350,0.389,0.162,0.450,0.276,0.296,
0.192,0.157,0.099,0.164,0.351,0.276,0.172,0.233,0.266,0.057,
0.242,1.350,0.173,0.219,0.202,0.835,0.287,0.194,0.123,0.168,
0.351,0.268,0.221,0.185,0.419,0.087,0.193,0.222,0.181,0.231,
0.153,0.254,0.038,0.043,0.030,0.029,0.094,0.080,0.061,0.041,
0.067,0.054,0.067,0.055,0.026,0.083,0.036,0.036,0.152,0.195,
0.143,0.115,0.030,0.040,0.030,0.025,0.181,0.046,0.167,0.170,
0.092,0.181,0.141,0.138,0.339,0.097,0.076,0.110,0.193,0.204,
0.135,0.164,0.206,0.052,0.175,0.235,0.133,0.173,0.169,0.237,
0.335,0.159,0.101,0.179,0.176,0.111,0.078,0.103,0.220,0.026,
0.105,0.134,0.204,0.176,0.110,0.223,0.378,0.292,0.162,0.186,
0.386,0.272,0.198,0.181,0.263,0.050,0.199,0.266,0.158,0.278,
0.149,0.214,0.153,0.143,0.199,0.156,0.017,0.024,0.025,0.021,
0.157,0.029,0.141,0.160,0.102,0.170,0.144,0.159,0.213,0.119,
0.097,0.167,0.147,0.144,0.111,0.130,0.250,0.030,0.166,0.270,
0.214,0.231,0.213,0.372,0.521,0.431,0.269,0.323,0.435,0.454,
0.331,0.263,0.322,0.061,0.186,0.228,0.218,0.297,0.165,0.232,
0.464,0.436,0.244,0.217,0.499,0.466,0.424,0.260,0.298,0.089,
0.309,0.285,0.136,0.310,0.174,0.202,0.204,0.318,0.213,0.173,
0.034,0.084,0.057,0.045,0.186,0.049,0.201,0.177,0.106,0.235,
0.169,0.186,0.171,0.116,0.103,0.175,0.228,0.274,0.177,0.186,
0.167,0.032,0.157,0.219,0.180,0.165,0.161,0.395,0.512,0.478,
0.197,0.215,0.517,0.633,0.329,0.232,0.348,0.108,0.242,0.248,
0.171,0.316,0.147,0.227,0.347,0.407,0.190,0.176,0.214,0.134,
0.189,0.139,0.333,0.169,0.297,0.342,0.128,0.390,0.248,0.248,
0.225,0.543,0.247,0.213,0.068,0.319,0.094,0.065,0.354,0.142,
0.306,0.377,0.151,0.556,0.328,0.348,0.157,0.169,0.104,0.148,
0.284,0.524,0.215,0.236,0.260,0.079,0.246,0.551,0.147,0.264,
0.224,1.470,0.300,0.240,0.137,0.143,0.417,0.452,0.339,0.219,
0.363,0.110,0.254,0.223,0.153,0.405,0.193,0.219,0.040,0.079,
0.039,0.028,0.105,0.147,0.108,0.046,0.076,0.074,0.127,0.067,
0.027,0.179,0.056,0.038,0.163,0.315,0.222,0.181,0.046,0.118,
0.085,0.046,0.224,0.080,0.248,0.236,0.086,0.334,0.241,0.183,
0.132,0.100,0.087,0.106,0.252,0.403,0.293,0.240,0.237,0.061,
0.274,0.297,0.150,0.212,0.235,0.294,0.196,0.141,0.094,0.122,
0.162,0.135,0.086,0.093,0.183,0.026,0.100,0.102,0.136,0.148,
0.084,0.146,0.220,0.263,0.155,0.153,0.298,0.345,0.207,0.167,
0.249,0.067,0.222,0.203,0.127,0.390,0.171,0.173,0.121,0.197,
0.145,0.141,0.018,0.047,0.028,0.022,0.149,0.036,0.177,0.178,
0.094,0.210,0.190,0.170,0.134,0.105,0.078,0.116,0.182,0.182,
0.112,0.132,0.176,0.028,0.161,0.202,0.146,0.208,0.265,0.358,
0.433,0.319,0.185,0.247,0.282,0.244,0.170,0.182,0.256,0.047,
0.243,0.169,0.170,0.216,0.118,0.176,0.389,0.448,0.189,0.222,
0.382,0.405,0.303,0.261,0.441,0.123,0.502,0.379,0.153,0.347,
0.182,0.199,0.201,0.343,0.234,0.229,0.054,0.082,0.051,0.059,
0.281,0.067,0.274,0.267,0.129,0.302,0.237,0.210,0.159,0.127,
0.093,0.161,0.234,0.250,0.149,0.205,0.234,0.048,0.213,0.275,
0.182,0.190,0.207,0.351,0.087,0.054,0.025,0.023,0.080,0.107,
0.063,0.045,0.052,0.035,0.050,0.042,0.022,0.058,0.027,0.030,
0.053,0.092,0.034,0.031,0.099,0.173,0.111,0.064,0.107,0.143,
0.141,0.122,0.023,0.092,0.036,0.038,0.035,0.092,0.064,0.032,
0.030,0.081,0.052,0.024,0.079,0.067,0.196,0.122,0.028,0.111,
0.069,0.047,0.022,0.025,0.017,0.023,0.086,0.101,0.056,0.053,
0.046,0.027,0.070,0.091,0.023,0.043,0.042,0.090,0.245,0.248,
0.164,0.158,0.270,0.441,0.299,0.204,0.348,0.125,0.342,0.265,
0.145,0.263,0.203,0.217,0.036,0.094,0.044,0.026,0.066,0.189,
0.114,0.044,0.077,0.078,0.147,0.084,0.024,0.095,0.058,0.035,
0.162,0.364,0.221,0.166,0.051,0.119,0.088,0.046,0.337,0.146,
0.283,0.318,0.107,0.379,0.236,0.198,0.122,0.108,0.085,0.106,
0.225,0.359,0.233,0.220,0.290,0.100,0.405,0.335,0.131,0.251,
0.251,0.258,0.178,0.122,0.094,0.162,0.122,0.102,0.085,0.092,
0.153,0.034,0.105,0.142,0.127,0.124,0.077,0.160,0.254,0.301,
0.173,0.172,0.300,0.415,0.267,0.204,0.361,0.099,0.362,0.386,
0.198,0.358,0.215,0.221,0.158,0.283,0.421,0.204,0.029,0.062,
0.055,0.030,0.274,0.082,0.302,0.301,0.140,0.360,0.218,0.223,
0.142,0.123,0.112,0.130,0.187,0.192,0.140,0.149,0.280,0.051,
0.334,0.322,0.200,0.289,0.240,0.317,0.371,0.215,0.162,0.266,
0.222,0.156,0.122,0.187,0.210,0.029,0.119,0.178,0.200,0.197,
0.110,0.234,0.237,0.176,0.102,0.147,0.172,0.131,0.112,0.144,
0.181,0.030,0.147,0.208,0.119,0.155,0.098,0.178,0.150,0.173,
0.110,0.154,0.017,0.022,0.013,0.024,0.128,0.022,0.098,0.148,
0.095,0.161,0.098,0.148,0.175,0.117,0.094,0.209,0.164,0.143,
0.100,0.182,0.168,0.018,0.102,0.196,0.207,0.180,0.153,0.397,
0.715,0.306,0.191,0.243,0.387,0.348,0.308,0.289,0.322,0.070,
0.221,0.317,0.199,0.340,0.138,0.252,0.369,0.363,0.173,0.197,
0.371,0.419,0.280,0.270,0.487,0.160,0.381,0.875,0.204,0.503,
0.205,0.331,0.213,0.329,0.188,0.187,0.043,0.080,0.058,0.047,
0.315,0.079,0.365,0.400,0.198,0.451,0.237,0.278,0.175,0.134,
0.100,0.171,0.272,0.308,0.190,0.269,0.256,0.043,0.228,0.371,
0.207,0.254,0.208,0.423,0.192,0.164,0.118,0.132,0.195,0.230,
0.182,0.167,0.285,0.064,0.206,0.225,0.144,0.211,0.166,0.228,
0.015,0.024,0.012,0.016,0.023,0.047,0.033,0.026,0.029,0.015,
0.040,0.038,0.017,0.038,0.026,0.023,0.115,0.190,0.120,0.129,
0.021,0.032,0.031,0.024,0.214,0.058,0.207,0.234,0.107,0.238,
0.175,0.187,0.115,0.105,0.079,0.112,0.174,0.188,0.144,0.187,
0.253,0.073,0.245,0.277,0.149,0.212,0.196,0.262,0.230,0.151,
0.108,0.178,0.130,0.114,0.077,0.107,0.165,0.023,0.100,0.142,
0.151,0.140,0.108,0.217,0.184,0.160,0.094,0.127,0.159,0.161,
0.117,0.148,0.180,0.022,0.143,0.190,0.146,0.187,0.125,0.203,
0.160,0.183,0.170,0.166,0.018,0.023,0.019,0.022,0.205,0.035,
0.185,0.224,0.157,0.340,0.209,0.239,0.228,0.150,0.130,0.230,
0.230,0.273,0.164,0.204,0.337,0.035,0.274,0.360,0.374,0.339,
0.331,0.433,0.421,0.296,0.229,0.317,0.303,0.276,0.224,0.212,
0.357,0.051,0.176,0.201,0.325,0.322,0.255,0.279,0.252,0.212,
0.142,0.146,0.206,0.164,0.182,0.143,0.203,0.039,0.158,0.154,
0.137,0.189,0.159,0.164,0.191,0.190,0.147,0.173,0.023,0.025,
0.030,0.033,0.146,0.024,0.117,0.167,0.103,0.162,0.121,0.142,
0.228,0.115,0.110,0.176,0.188,0.175,0.146,0.167,0.162,0.021,
0.143,0.158,0.165,0.129,0.172,0.231,0.484,0.418,0.223,0.261,
0.438,0.439,0.387,0.259,0.410,0.080,0.237,0.223,0.208,0.306,
0.170,0.205,0.369,0.535,0.226,0.200,0.380,0.304,0.365,0.233,
0.422,0.124,0.343,0.383,0.191,0.370,0.198,0.205,0.305,0.443,
0.279,0.256,0.058,0.099,0.092,0.067,0.449,0.117,0.426,0.399,
0.201,0.457,0.329,0.256,0.203,0.172,0.113,0.151,0.306,0.378,
0.217,0.250,0.248,0.042,0.193,0.287,0.163,0.190,0.209,0.281,
0.348,0.204,0.149,0.170,0.374,0.332,0.345,0.258,1.580,0.223,
0.326,0.309,0.383,0.413,0.219,0.276,0.040,0.051,0.032,0.030,
0.059,0.071,0.082,0.056,0.250,0.074,0.091,0.073,0.055,0.153,
0.056,0.056,0.176,0.210,0.264,0.163,0.037,0.054,0.060,0.048,
0.273,0.075,0.212,0.194,0.133,0.430,0.185,0.164,0.108,0.090,
0.079,0.104,0.199,0.211,0.222,0.220,0.255,0.046,0.185,0.180,
0.137,0.187,0.177,0.216,0.254,0.129,0.104,0.162,0.167,0.116,
0.108,0.127,0.378,0.038,0.110,0.139,0.347,0.237,0.124,0.248,
0.241,0.232,0.144,0.150,0.230,0.190,0.207,0.190,0.506,0.101,
0.215,0.239,0.280,0.388,0.169,0.250,0.160,0.186,0.202,0.182,
0.022,0.027,0.030,0.037,0.214,0.036,0.182,0.214,0.141,0.269,
0.214,0.197,0.193,0.134,0.117,0.199,0.151,0.124,0.154,0.190,
0.291,0.033,0.199,0.259,0.299,0.290,0.297,0.438,0.029,0.037,
0.022,0.022,0.037,0.052,0.035,0.026,0.029,0.013,0.030,0.024,
0.019,0.039,0.023,0.021,0.038,0.053,0.031,0.024,0.055,0.070,
0.071,0.035,0.042,0.031,0.060,0.041,0.015,0.053,0.036,0.026,
0.021,0.039,0.026,0.020,8.77e-3,0.019,0.021,0.011,0.029,0.013,
0.044,0.032,0.012,0.041,0.029,0.024,0.018,0.018,0.013,0.017,
0.034,0.042,0.040,0.030,0.030,9.11e-3,0.037,0.038,0.018,0.023,
0.041,0.034,0.047,0.071,0.041,0.026,0.076,0.132,0.103,0.045,
0.052,0.035,0.050,0.036,0.019,0.058,0.035,0.028,0.071,0.165,
0.064,0.038,0.108,0.111,0.155,0.076,0.097,0.097,0.106,0.089,
0.028,0.098,0.053,0.039,0.037,0.106,0.064,0.037,0.028,0.101,
0.093,0.031,0.103,0.091,0.136,0.096,0.035,0.128,0.092,0.058,
0.026,0.033,0.023,0.020,0.079,0.146,0.079,0.049,0.054,0.021,
0.054,0.053,0.020,0.038,0.039,0.069,0.034,0.034,0.022,0.017,
0.062,0.104,0.104,0.048,0.169,0.068,0.073,0.042,0.027,0.096,
0.038,0.032,0.011,0.033,0.017,7.94e-3,0.036,0.076,0.078,0.027,
0.084,0.122,0.084,0.049,0.011,0.066,0.027,0.014,0.031,0.068,
0.089,0.036,0.020,0.058,0.081,0.024,0.084,0.083,0.110,0.073,
0.038,0.189,0.081,0.044,0.017,0.019,0.020,0.017,0.050,0.092,
0.101,0.055,0.056,0.035,0.084,0.059,0.021,0.044,0.050,0.040,
0.025,0.026,0.016,0.020,0.022,0.024,0.019,0.019,0.039,9.44e-3,
0.020,0.019,0.035,0.037,0.019,0.029,0.048,0.082,0.038,0.034,
0.065,0.088,0.083,0.063,0.122,0.053,0.073,0.059,0.067,0.155,
0.061,0.051,0.020,0.042,0.038,0.030,6.77e-3,0.018,0.019,9.53e-3,
0.052,0.023,0.069,0.055,0.022,0.066,0.053,0.037,0.021,0.023,
0.018,0.024,0.026,0.032,0.029,0.031,0.039,0.011,0.047,0.045,
0.030,0.045,0.047,0.053,0.247,0.227,0.154,0.183,0.228,0.290,
0.213,0.164,0.231,0.043,0.153,0.147,0.145,0.163,0.111,0.126,
0.197,0.250,0.172,0.128,0.284,0.299,0.427,0.200,0.316,0.093,
0.461,0.283,0.154,0.268,0.191,0.166,0.182,0.310,0.268,0.204,
0.042,0.093,0.087,0.068,0.391,0.106,0.291,0.264,0.167,0.792,
0.207,0.199,0.126,0.111,0.093,0.124,0.190,0.228,0.199,0.203,
0.246,0.058,0.239,0.342,0.167,0.361,0.345,0.270,0.031,0.048,
0.024,0.023,0.061,0.146,0.084,0.043,0.037,0.027,0.053,0.038,
0.018,0.040,0.021,0.022,0.043,0.073,0.043,0.026,0.086,0.122,
0.147,0.057,0.070,0.065,0.134,0.095,0.037,0.064,0.036,0.024,
0.029,0.093,0.059,0.045,0.024,0.083,0.080,0.032,0.085,0.100,
0.145,0.101,0.024,0.125,0.066,0.046,0.026,0.025,0.019,0.024,
0.053,0.097,0.068,0.058,0.049,0.025,0.073,0.110,0.020,0.038,
0.049,0.044,0.167,0.195,0.171,0.099,0.292,0.429,1.330,0.251,
0.314,0.135,0.442,0.247,0.129,0.236,0.232,0.177,0.028,0.071,
0.081,0.022,0.074,0.138,0.908,0.071,0.072,0.069,0.183,0.074,
0.066,0.076,0.066,0.039,0.156,0.293,0.297,0.174,0.057,0.113,
0.176,0.066,0.346,0.137,0.244,0.297,0.098,0.309,0.345,0.223,
0.096,0.088,0.093,0.087,0.196,0.307,0.381,0.217,0.242,0.076,
0.367,0.277,0.097,0.188,0.242,0.212,0.129,0.107,0.090,0.107,
0.124,0.115,0.149,0.087,0.183,0.036,0.128,0.134,0.381,0.156,
0.091,0.131,0.225,0.247,0.242,0.135,0.311,0.373,1.330,0.245,
0.386,0.097,0.401,0.308,1.350,0.444,0.276,0.237,0.151,0.269,
0.201,0.161,0.031,0.087,0.069,0.041,0.279,0.078,0.371,0.340,
0.177,0.362,0.287,0.226,0.123,0.103,0.094,0.112,0.156,0.188,
0.167,0.155,0.226,0.047,0.312,0.277,0.200,0.245,0.243,0.242,
0.263,0.189,0.130,0.202,0.173,0.159,0.142,0.176,0.174,0.029,
0.103,0.129,0.171,0.183,0.115,0.190,0.163,0.137,0.085,0.096,
0.130,0.104,0.115,0.094,0.124,0.020,0.109,0.111,0.081,0.106,
0.093,0.101,0.167,0.176,0.117,0.141,0.021,0.026,0.023,0.027,
0.141,0.028,0.108,0.149,0.101,0.210,0.117,0.142,0.149,0.104,
0.100,0.149,0.162,0.131,0.119,0.156,0.141,0.018,0.119,0.167,
0.171,0.167,0.162,0.277,0.373,0.357,0.194,0.251,0.340,0.483,
0.320,0.274,0.293,0.071,0.243,0.264,0.177,0.320,0.157,0.222,
0.328,0.465,0.218,0.194,0.397,0.429,0.417,0.278,0.345,0.101,
0.412,0.394,0.162,0.339,0.268,0.207,0.233,0.481,0.258,0.247,
0.045,0.112,0.088,0.067,0.363,0.112,0.392,0.451,0.251,0.590,
0.344,0.327,0.217,0.182,0.154,0.199,0.306,0.366,0.304,0.352,
0.377,0.055,0.282,0.477,0.201,0.293,0.254,0.350,0.201,0.190,
0.136,0.145,0.238,0.261,0.320,0.215,0.301,0.074,0.232,0.235,
0.139,0.227,0.184,0.215,0.021,0.035,0.022,0.020,0.038,0.060,
0.094,0.035,0.037,0.028,0.058,0.052,0.020,0.047,0.032,0.028,
0.165,0.271,0.209,0.180,0.036,0.062,0.072,0.048,0.274,0.086,
0.255,0.300,0.131,0.306,0.299,0.244,0.126,0.111,0.101,0.123,
0.217,0.244,0.287,0.257,0.220,0.052,0.265,0.298,0.146,0.197,
0.260,0.270,0.220,0.140,0.109,0.160,0.150,0.136,0.118,0.119,
0.183,0.027,0.124,0.164,0.200,0.159,0.127,0.228,0.211,0.200,
0.120,0.138,0.168,0.187,0.231,0.158,0.193,0.035,0.166,0.233,
0.284,0.211,0.162,0.219,0.177,0.237,0.174,0.220,0.025,0.041,
0.032,0.029,0.275,0.043,0.280,0.363,0.179,0.297,0.279,0.279,
0.228,0.152,0.148,0.244,0.237,0.265,0.211,0.240,0.306,0.036,
0.291,0.392,0.336,0.278,0.333,0.417,0.643,0.400,0.363,0.664,
0.377,0.244,0.213,0.301,0.413,0.045,0.170,0.276,0.496,0.448,
0.230,0.425,0.421,0.294,0.232,0.308,0.256,0.158,0.148,0.162,
0.274,0.029,0.199,0.185,0.330,0.348,0.219,0.330,0.373,0.271,
0.213,0.329,0.038,0.028,0.020,0.046,0.207,0.024,0.126,0.173,
0.234,0.266,0.181,0.295,0.388,0.213,0.205,0.366,0.312,0.189,
0.175,0.279,0.258,0.026,0.205,0.236,0.366,0.281,0.275,0.527,
0.507,0.303,0.192,0.314,0.310,0.217,0.170,0.203,0.287,0.037,
0.139,0.191,0.248,0.263,0.131,0.255,0.315,0.258,0.134,0.180,
0.216,0.141,0.137,0.137,0.265,0.038,0.150,0.202,0.227,0.230,
0.132,0.216,0.276,0.245,0.167,0.232,0.039,0.034,0.027,0.027,
0.237,0.039,0.158,0.194,0.187,0.344,0.169,0.212,0.244,0.197,
0.137,0.226,0.281,0.196,0.117,0.182,0.204,0.024,0.131,0.232,
0.197,0.192,0.199,0.336,0.408,0.210,0.167,0.270,0.307,0.199,
0.184,0.232,0.593,0.067,0.146,0.211,0.442,0.321,0.175,0.363,
0.031,0.031,0.018,0.029,0.027,0.026,0.023,0.026,0.049,8.86e-3,
0.025,0.026,0.067,0.076,0.030,0.055,0.162,0.176,0.168,0.189,
0.020,0.022,0.021,0.025,0.208,0.036,0.148,0.154,0.161,0.242,
0.160,0.187,0.167,0.114,0.104,0.192,0.207,0.154,0.143,0.213,
0.216,0.028,0.135,0.200,0.236,0.193,0.196,0.330,0.498,0.239,
0.175,0.366,0.233,0.139,0.125,0.190,0.568,0.060,0.164,0.235,
0.981,0.460,0.217,0.551,0.367,0.226,0.151,0.223,0.217,0.147,
0.141,0.177,0.371,0.036,0.162,0.219,0.551,0.475,0.240,0.508,
0.276,0.247,0.200,0.277,0.025,0.022,0.019,0.027,0.243,0.022,
0.172,0.204,0.279,0.329,0.277,0.360,0.400,0.239,0.215,0.441,
0.272,0.161,0.157,0.278,0.398,0.033,0.234,0.362,0.677,0.538,
0.535,1.070,0.754,0.485,0.333,0.546,0.566,0.405,0.299,0.350,
0.461,0.071,0.285,0.339,0.395,0.488,0.239,0.421,0.484,0.372,
0.272,0.384,0.464,0.323,0.313,0.303,0.385,0.077,0.801,0.366,
0.235,0.389,0.259,0.305,0.349,0.384,0.273,0.350,0.058,0.066,
0.057,0.072,0.337,0.067,0.292,0.382,0.247,0.419,0.282,0.440,
0.328,0.206,0.183,0.305,0.390,0.358,0.276,0.353,0.308,0.043,
0.291,0.377,0.331,0.280,0.298,0.519,0.724,0.607,0.370,0.437,
0.649,0.576,0.378,0.353,0.510,0.107,0.246,0.314,0.325,0.549,
0.217,0.364,0.578,0.660,0.274,0.311,0.581,0.379,0.404,0.323,
0.528,0.136,0.375,0.439,0.278,0.531,0.278,0.330,0.466,0.615,
0.360,0.392,0.108,0.132,0.083,0.066,0.597,0.149,0.434,0.554,
0.348,0.757,0.440,0.488,0.337,0.317,0.210,0.324,0.643,0.791,
0.318,0.393,0.397,0.057,0.286,0.407,0.276,0.331,0.285,0.499,
0.487,0.309,0.182,0.269,0.482,0.566,0.364,0.377,0.839,0.152,
0.296,0.295,0.371,0.562,0.249,0.413,0.033,0.052,0.029,0.035,
0.053,0.081,0.073,0.063,0.099,0.058,0.084,0.056,0.047,0.163,
0.052,0.053,0.269,0.433,0.368,0.320,0.042,0.080,0.069,0.060,
0.457,0.112,0.286,0.336,0.258,0.718,0.308,0.374,0.250,0.207,
0.174,0.242,0.368,0.487,0.365,0.426,0.439,0.063,0.334,0.395,
0.291,0.333,0.328,0.465,0.432,0.286,0.207,0.360,0.266,0.222,
0.177,0.239,0.469,0.058,0.244,0.258,0.600,0.454,0.254,0.478,
0.417,0.435,0.267,0.325,0.358,0.379,0.339,0.364,0.757,0.130,
0.401,0.404,0.600,1.350,0.389,0.510,0.320,0.354,0.271,0.363,
0.036,0.050,0.031,0.047,0.396,0.065,0.311,0.377,0.274,0.484,
0.320,0.419,0.364,0.254,0.194,0.323,0.327,0.312,0.217,0.372,
0.473,0.052,0.320,0.517,0.472,0.508,0.427,0.707,0.382,0.279,
0.178,0.268,0.235,0.225,0.145,0.212,0.262,0.034,0.129,0.170,
0.207,0.214,0.125,0.201,0.301,0.303,0.164,0.199,0.319,0.256,
0.221,0.214,0.313,0.071,0.328,0.272,0.186,0.309,0.187,0.234,
0.265,0.333,0.266,0.295,0.040,0.064,0.047,0.070,0.314,0.067,
0.224,0.296,0.194,0.388,0.224,0.292,0.215,0.169,0.133,0.218,
0.252,0.221,0.176,0.235,0.301,0.053,0.206,0.325,0.264,0.265,
0.258,0.420,0.033,0.035,0.019,0.028,0.040,0.050,0.025,0.026,
0.033,9.19e-3,0.026,0.024,0.021,0.040,0.018,0.029,0.040,0.047,
0.020,0.024,0.055,0.077,0.049,0.034,0.049,0.026,0.070,0.053,
0.029,0.051,0.027,0.028,0.026,0.052,0.032,0.029,8.52e-3,0.022,
0.017,0.011,0.044,0.027,0.056,0.049,0.022,0.073,0.040,0.034,
0.033,0.032,0.020,0.037,0.068,0.060,0.036,0.043,0.044,0.018,
0.044,0.055,0.035,0.038,0.035,0.054,0.246,0.208,0.128,0.136,
0.259,0.319,0.340,0.192,0.332,0.084,0.267,0.232,0.161,0.266,
0.228,0.233,0.024,0.038,0.022,0.017,0.034,0.058,0.079,0.024,
0.043,0.026,0.079,0.042,0.029,0.065,0.047,0.036,0.193,0.336,
0.225,0.200,0.038,0.079,0.068,0.043,0.361,0.094,0.219,0.269,
0.145,0.372,0.277,0.261,0.168,0.138,0.122,0.144,0.253,0.325,
0.288,0.251,0.356,0.061,0.336,0.317,0.200,0.278,0.330,0.375,
0.254,0.163,0.126,0.186,0.173,0.143,0.121,0.123,0.251,0.031,
0.159,0.192,0.233,0.210,0.155,0.270,0.282,0.272,0.188,0.211,
0.261,0.267,0.280,0.197,0.380,0.064,0.328,0.324,0.411,0.442,
0.292,0.334,0.301,0.328,0.262,0.272,0.027,0.050,0.037,0.034,
0.386,0.062,0.322,0.360,0.290,0.441,0.329,0.357,0.265,0.187,
0.266,0.237,0.221,0.224,0.193,0.207,0.413,0.048,0.367,0.410,
0.372,0.409,0.392,0.503,0.705,0.314,0.247,0.463,0.300,0.195,
0.163,0.329,0.319,0.036,0.145,0.265,0.347,0.279,0.175,0.397,
0.322,0.217,0.150,0.193,0.224,0.152,0.139,0.187,0.234,0.026,
0.182,0.223,0.183,0.205,0.130,0.230,0.247,0.244,0.156,0.278,
0.023,0.024,0.021,0.044,0.212,0.029,0.131,0.220,0.186,0.244,
0.161,0.281,0.314,0.192,0.175,0.345,0.231,0.175,0.173,0.281,
0.261,0.026,0.157,0.321,0.381,0.297,0.280,0.667,0.479,0.299,
0.199,0.345,0.284,0.268,0.176,0.247,0.258,0.033,0.146,0.224,
0.220,0.256,0.145,0.301,0.324,0.272,0.139,0.179,0.346,0.244,
0.163,0.194,0.267,0.045,0.293,0.295,0.181,0.271,0.177,0.254,
0.237,0.345,0.155,0.251,0.021,0.040,0.024,0.033,0.283,0.049,
0.223,0.294,0.214,0.388,0.213,0.327,0.265,0.202,0.179,0.287,
0.277,0.241,0.229,0.293,0.296,0.035,0.189,0.336,0.294,0.315,
0.243,0.476,0.391,0.301,0.188,0.240,0.319,0.263,0.241,0.287,
0.415,0.068,0.208,0.307,0.292,0.315,0.255,0.436,0.028,0.035,
0.017,0.022,0.029,0.033,0.028,0.026,0.032,9.44e-3,0.032,0.036,
0.028,0.048,0.028,0.049,0.255,0.321,0.208,0.279,0.028,0.041,
0.036,0.037,0.381,0.066,0.254,0.325,0.216,0.363,0.301,0.363,
0.256,0.222,0.169,0.250,0.335,0.317,0.334,0.360,0.416,0.055,
0.320,0.433,0.323,0.315,0.379,0.549,0.673,0.389,0.269,0.431,
0.301,0.219,0.190,0.252,0.411,0.041,0.240,0.359,0.492,0.397,
0.290,0.805,0.442,0.338,0.196,0.291,0.308,0.289,0.204,0.254,
0.401,0.048,0.266,0.407,0.372,0.445,0.297,0.540,0.417,0.425,
0.300,0.444,0.031,0.039,0.025,0.041,0.520,0.058,0.400,0.570,
0.421,0.584,0.500,0.672,0.812,0.426,0.378,0.713,0.493,0.445,
0.342,0.552,0.762,0.057,0.556,0.947,0.854,0.655,0.701,0.820,
7.440,3.310,3.090,4.880,3.070,1.900,2.270,2.120,4.070,0.367,
2.500,2.420,4.200,3.390,2.470,3.310,3.450,2.130,1.740,1.860,
2.100,1.350,1.490,1.250,2.320,0.200,1.690,1.660,1.600,1.650,
1.390,1.730,2.720,1.870,2.040,2.200,0.220,0.178,0.197,0.267,
2.150,0.176,1.360,1.420,1.440,1.830,1.420,1.690,3.230,1.640,
1.980,3.210,2.350,1.800,1.810,2.320,1.910,0.164,1.470,1.950,
2.390,1.620,1.890,2.880,3.870,2.460,1.670,2.200,2.240,1.680,
1.330,1.490,1.970,0.230,1.120,1.440,1.600,1.790,1.190,1.710,
2.550,2.050,1.240,1.250,1.570,1.070,1.110,0.916,1.980,0.249,
1.390,1.710,1.070,1.360,1.070,1.210,1.770,1.740,1.300,1.280,
0.160,0.187,0.154,0.158,1.570,0.173,1.360,1.350,0.928,1.570,
1.120,1.100,1.540,1.170,0.898,1.310,1.610,1.400,1.060,1.340,
1.430,0.131,1.230,1.450,1.260,1.220,1.250,1.850,2.750,1.260,
1.410,1.640,1.890,1.280,1.400,1.520,1.840,0.260,1.200,1.450,
1.400,1.730,1.450,1.980,0.234,0.193,0.147,0.149,0.181,0.157,
0.131,0.131,0.190,0.041,0.160,0.185,0.184,0.307,0.180,0.230,
1.990,1.260,1.200,1.130,0.146,0.117,0.121,0.143,1.390,0.159,
1.100,1.110,1.320,1.580,1.130,1.160,1.140,0.780,0.738,1.050,
1.340,1.110,1.010,1.200,1.340,0.132,1.150,1.440,1.120,1.140,
1.240,1.710,2.840,1.220,1.480,2.110,1.280,0.843,0.807,0.862,
1.400,0.133,0.860,1.070,1.620,1.260,1.440,2.280,2.000,1.390,
1.280,1.260,1.560,1.040,0.938,0.827,1.290,0.107,0.988,1.110,
1.260,1.270,1.170,1.480,1.410,1.580,1.020,1.170,0.111,0.105,
0.095,0.112,1.010,0.097,0.990,1.140,0.920,1.090,1.010,1.220,
1.870,1.030,0.970,1.700,0.867,0.625,0.704,0.963,1.420,0.104,
1.240,1.750,2.050,1.400,1.560,2.840,4.310,2.770,2.190,3.050,
2.300,1.790,2.010,1.810,1.770,0.214,1.180,1.540,1.900,1.890,
1.450,1.990,2.720,2.220,1.550,1.600,1.800,1.460,1.870,1.410,
1.750,0.224,1.450,1.570,1.060,1.490,1.100,1.390,1.550,1.600,
1.670,1.430,0.143,0.212,0.184,0.197,1.160,0.144,1.020,1.090,
0.799,1.550,0.994,1.220,1.530,0.944,0.991,1.480,1.500,1.500,
1.290,1.460,1.100,0.125,0.862,1.440,1.130,1.010,1.110,1.950,
3.330,2.920,1.450,1.900,2.330,2.130,1.570,1.580,1.610,0.246,
1.140,1.350,1.090,1.530,0.889,1.360,2.160,2.140,1.440,1.340,
1.280,0.750,1.270,0.983,1.620,0.259,1.740,1.690,0.789,1.340,
1.020,1.090,1.540,2.280,1.780,1.560,0.177,0.294,0.249,0.218,
1.690,0.319,1.910,1.820,1.000,2.740,1.420,1.450,1.250,1.060,
0.944,1.050,1.410,1.540,1.140,1.210,1.200,0.141,1.200,1.290,
0.840,1.050,1.020,1.430,2.100,1.560,1.230,1.750,2.080,1.850,
2.160,1.630,1.810,0.319,1.580,1.570,1.060,1.660,1.600,1.800,
0.186,0.262,0.160,0.183,0.186,0.244,0.248,0.169,0.207,0.076,
0.296,0.247,0.133,0.421,0.223,0.222,1.450,2.090,1.700,1.450,
0.175,0.344,0.251,0.203,1.810,0.454,1.710,1.770,1.400,5.550,
1.890,1.770,1.170,0.857,0.994,1.100,1.540,1.880,1.730,1.730,
1.560,0.221,1.730,1.990,0.918,1.580,1.530,1.760,1.610,1.130,
0.960,1.380,1.060,0.751,0.739,0.823,0.873,0.100,0.891,0.875,
0.892,0.856,0.879,1.340,1.810,1.570,1.200,1.430,1.310,1.260,
1.090,1.210,1.220,0.141,1.210,1.310,0.952,1.520,1.100,1.510,
1.000,1.460,1.150,1.330,0.093,0.129,0.095,0.119,0.922,0.124,
1.050,1.180,0.798,1.600,1.190,1.300,1.280,1.040,0.879,1.200,
0.969,0.874,0.743,1.050,1.140,0.097,1.090,1.530,1.420,1.400,
1.520,2.300,3.790,2.470,1.990,2.380,1.540,1.410,1.160,1.140,
1.660,0.226,1.380,1.260,1.860,2.390,1.290,1.920,3.090,2.570,
1.940,1.970,1.930,1.830,2.290,1.690,2.510,0.330,2.220,2.130,
1.500,2.510,1.470,1.840,1.930,2.300,2.840,1.970,0.224,0.309,
0.304,0.341,1.740,0.278,3.230,2.670,1.080,2.250,1.630,1.740,
1.840,1.230,1.340,1.960,1.850,1.780,1.440,1.760,1.780,0.205,
1.660,2.030,1.710,1.610,1.750,3.540,0.334,0.346,0.247,0.239,
0.326,0.369,0.232,0.189,0.245,0.060,0.239,0.213,0.166,0.345,
0.217,0.245,0.347,0.378,0.228,0.213,0.292,0.331,0.282,0.190,
0.378,0.088,0.400,0.324,0.177,0.374,0.207,0.211,0.205,0.367,
0.285,0.217,0.041,0.088,0.083,0.052,0.391,0.125,2.140,1.280,
0.165,0.478,0.336,0.286,0.296,0.238,0.194,0.279,0.516,0.622,
0.413,0.440,0.277,0.062,0.414,0.445,0.284,0.501,0.297,0.488,
2.180,1.580,1.330,1.250,1.660,1.700,1.620,1.130,3.120,0.927,
3.760,2.020,1.390,2.850,2.130,2.050,0.195,0.259,0.162,0.159,
0.155,0.212,0.203,0.117,0.483,0.218,0.418,0.253,0.194,0.570,
0.263,0.227,1.420,1.900,1.610,1.120,0.177,0.251,0.274,0.165,
1.800,0.337,1.870,1.430,0.938,1.920,1.520,1.220,1.030,0.867,
0.958,0.926,1.440,1.680,1.550,1.420,1.660,0.280,2.210,1.810,
1.080,1.450,1.600,1.640,1.750,1.020,0.849,1.300,1.100,0.781,
0.703,0.658,1.470,0.191,1.060,1.090,1.120,1.280,0.912,1.440,
2.330,1.800,1.400,1.810,1.650,1.730,1.330,1.200,3.830,0.426,
2.050,2.290,1.790,2.480,1.510,1.870,1.250,1.520,1.340,1.190,
0.125,0.180,0.140,0.139,1.400,0.164,1.540,1.620,1.050,1.810,
1.330,1.470,1.510,1.010,1.200,1.310,1.360,1.180,0.966,1.110,
1.770,0.176,1.770,2.010,1.710,1.920,1.770,2.400,3.720,1.810,
1.530,2.290,1.310,0.864,0.895,0.873,1.390,0.133,0.799,1.020,
1.710,1.430,1.070,2.000,1.580,0.948,0.958,1.020,0.954,0.622,
1.030,0.744,1.550,0.112,0.825,1.020,0.955,0.886,0.726,1.090,
1.450,1.090,1.050,1.290,0.157,0.122,0.108,0.179,1.030,0.106,
0.889,1.050,0.855,1.260,0.766,1.180,1.980,1.040,1.260,2.250,
1.960,1.150,1.150,1.520,2.950,0.154,0.942,1.330,1.980,1.710,
1.420,3.010,2.740,1.880,1.260,1.730,1.920,1.490,1.220,1.210,
1.580,0.188,1.170,1.400,1.220,1.520,1.180,1.830,2.340,1.570,
0.981,1.140,1.490,1.200,1.100,0.925,1.870,0.220,1.450,1.620,
1.080,1.430,0.877,1.180,1.450,1.520,1.110,1.270,0.142,0.172,
0.148,0.170,1.650,0.237,3.830,3.320,1.240,2.360,1.320,1.660,
1.840,1.110,0.994,1.490,2.360,1.710,1.510,1.650,1.570,0.209,
1.370,1.900,1.800,3.260,1.470,2.410,1.910,1.310,1.140,1.290,
1.930,1.240,1.320,1.260,2.370,0.346,2.280,1.770,1.430,1.550,
2.030,2.300,0.158,0.184,0.121,0.157,0.142,0.136,0.134,0.112,
0.210,0.046,0.235,0.201,0.179,0.272,0.197,0.214,1.260,1.440,
1.180,1.490,0.139,0.151,0.148,0.182,1.520,0.228,1.670,1.570,
1.130,2.190,1.540,1.770,1.280,1.000,0.968,1.380,1.690,1.470,
1.450,1.790,2.140,0.246,1.790,2.290,1.550,1.850,1.760,2.390,
2.490,1.340,1.100,1.640,1.260,0.847,0.836,0.870,1.450,0.134,
0.979,1.240,1.670,1.320,1.350,2.510,1.400,0.990,0.861,1.200,
0.924,0.675,0.829,0.825,1.670,0.137,1.110,1.470,1.420,1.550,
1.060,1.630,1.670,1.580,1.310,1.850,0.178,0.125,0.108,0.169,
1.580,0.142,1.390,1.790,1.860,2.170,1.720,2.170,2.610,1.330,
1.640,2.980,2.130,1.510,1.400,2.100,2.540,0.170,2.090,3.020,
4.190,2.790,2.910,4.600,0.384,0.263,0.246,0.306,0.273,0.207,
0.204,0.191,0.257,0.036,0.190,0.210,0.240,0.259,0.184,0.207,
0.291,0.241,0.179,0.162,0.220,0.187,0.206,0.144,0.220,0.039,
0.211,0.194,0.144,0.203,0.175,0.187,0.169,0.160,0.159,0.156,
0.024,0.025,0.029,0.027,0.136,0.025,0.127,0.115,0.098,0.145,
0.128,0.126,0.185,0.131,0.137,0.207,0.195,0.177,0.170,0.183,
0.166,0.021,0.183,0.177,0.164,0.142,0.186,0.238,0.354,0.312,
0.195,0.206,0.317,0.292,0.242,0.173,0.256,0.056,0.233,0.239,
0.152,0.246,0.247,0.220,0.335,0.371,0.227,0.169,0.293,0.261,
0.272,0.183,0.469,0.142,0.401,0.490,0.156,0.331,0.212,0.210,
0.188,0.248,0.199,0.149,0.052,0.058,0.066,0.038,0.212,0.066,
0.300,0.244,0.115,0.276,0.190,0.146,0.146,0.158,0.104,0.127,
0.232,0.202,0.177,0.190,0.180,0.036,0.198,0.309,0.133,0.151,
0.189,0.273,0.177,0.121,0.099,0.111,0.189,0.166,0.195,0.135,
0.174,0.041,0.147,0.139,0.109,0.158,0.129,0.154,0.024,0.035,
0.023,0.017,0.035,0.051,0.047,0.026,0.034,0.025,0.049,0.038,
0.025,0.052,0.033,0.028,0.112,0.135,0.129,0.098,0.028,0.034,
0.039,0.025,0.138,0.044,0.171,0.140,0.080,0.165,0.161,0.129,
0.089,0.067,0.067,0.080,0.154,0.148,0.142,0.135,0.136,0.030,
0.159,0.161,0.095,0.123,0.173,0.172,0.182,0.101,0.091,0.139,
0.113,0.076,0.080,0.077,0.124,0.019,0.084,0.090,0.117,0.109,
0.094,0.160,0.180,0.174,0.132,0.136,0.165,0.166,0.142,0.115,
0.141,0.027,0.140,0.161,0.107,0.160,0.131,0.160,0.102,0.107,
0.103,0.113,0.014,0.015,0.017,0.018,0.094,0.016,0.112,0.116,
0.072,0.115,0.111,0.130,0.140,0.087,0.081,0.141,0.097,0.083,
0.084,0.103,0.140,0.016,0.139,0.185,0.171,0.159,0.194,0.309,
0.267,0.218,0.178,0.195,0.221,0.237,0.222,0.201,0.144,0.027,
0.124,0.130,0.118,0.148,0.108,0.128,0.214,0.227,0.156,0.130,
0.201,0.196,0.215,0.156,0.171,0.063,0.234,0.193,0.080,0.156,
0.125,0.123,0.107,0.145,0.126,0.101,0.020,0.037,0.036,0.022,
0.093,0.029,0.127,0.095,0.054,0.112,0.107,0.104,0.097,0.064,
0.062,0.097,0.118,0.132,0.111,0.111,0.089,0.018,0.110,0.113,
0.082,0.083,0.103,0.143,0.273,0.337,0.162,0.157,0.282,0.421,
0.240,0.158,0.185,0.055,0.200,0.162,0.090,0.179,0.110,0.150,
0.237,0.365,0.218,0.144,0.185,0.132,0.210,0.151,0.231,0.100,
0.423,0.322,0.083,0.219,0.166,0.140,0.144,0.304,0.225,0.163,
0.041,0.106,0.103,0.054,0.220,0.100,0.282,0.271,0.111,0.310,
0.206,0.162,0.124,0.097,0.091,0.095,0.157,0.229,0.169,0.150,
0.142,0.034,0.211,0.201,0.090,0.120,0.186,0.215,0.159,0.140,
0.100,0.106,0.221,0.260,0.257,0.149,0.201,0.056,0.183,0.147,
0.090,0.205,0.143,0.137,0.025,0.058,0.032,0.021,0.045,0.094,
0.096,0.036,0.052,0.055,0.105,0.074,0.016,0.092,0.045,0.030,
0.150,0.271,0.215,0.150,0.046,0.129,0.103,0.042,0.208,0.092,
0.284,0.223,0.097,0.364,0.262,0.186,0.122,0.070,0.084,0.084,
0.175,0.281,0.266,0.184,0.173,0.046,0.264,0.215,0.094,0.138,
0.202,0.183,0.114,0.095,0.084,0.126,0.082,0.077,0.070,0.091,
0.090,0.010,0.117,0.076,0.071,0.079,0.073,0.102,0.121,0.166,
0.112,0.107,0.128,0.162,0.136,0.118,0.133,0.035,0.158,0.137,
0.064,0.188,0.115,0.119,0.069,0.124,0.102,0.098,0.013,0.022,
0.019,0.014,0.090,0.024,0.126,0.106,0.057,0.141,0.125,0.099,
0.082,0.070,0.063,0.092,0.081,0.084,0.070,0.101,0.095,0.015,
0.118,0.135,0.094,0.127,0.141,0.188,0.237,0.216,0.179,0.173,
0.155,0.175,0.162,0.150,0.146,0.035,0.379,0.153,0.124,0.171,
0.119,0.138,0.242,0.315,0.199,0.172,0.251,0.307,0.310,0.228,
0.311,0.097,0.557,0.342,0.115,0.269,0.194,0.166,0.160,0.274,
0.246,0.174,0.032,0.061,0.067,0.062,0.240,0.082,1.430,0.822,
0.097,0.240,0.400,0.188,0.126,0.103,0.094,0.166,0.167,0.187,
0.157,0.259,0.178,0.037,0.270,0.282,0.125,0.134,0.187,0.260,
0.031,0.062,0.029,0.024,0.049,0.099,0.063,0.042,0.031,0.025,
0.069,0.043,0.015,0.045,0.028,0.024,0.044,0.096,0.055,0.031,
0.073,0.131,0.121,0.055,0.070,0.096,0.169,0.108,0.019,0.074,
0.048,0.030,0.022,0.085,0.070,0.039,0.019,0.068,0.088,0.027,
0.145,0.110,2.290,0.900,0.022,0.101,0.121,0.059,0.018,0.026,
0.018,0.020,0.055,0.088,0.072,0.063,0.038,0.022,0.150,0.113,
0.036,0.043,0.045,0.049,0.173,0.176,0.130,0.103,0.168,0.269,
0.253,0.142,0.241,0.092,0.413,0.219,0.110,0.249,0.216,0.181,
0.028,0.070,0.042,0.020,0.036,0.107,0.096,0.036,0.072,0.080,
0.247,0.086,0.019,0.074,0.057,0.032,0.156,0.297,0.268,0.130,
0.045,0.116,0.138,0.043,0.285,0.156,0.613,0.292,0.094,0.301,
0.290,0.176,0.091,0.098,0.112,0.097,0.206,0.314,0.296,0.207,
0.227,0.090,0.459,0.285,0.110,0.185,0.252,0.218,0.135,0.108,
0.086,0.112,0.109,0.095,0.096,0.079,0.119,0.026,0.117,0.111,
0.098,0.130,0.084,0.124,0.189,0.219,0.155,0.168,0.192,0.284,
0.223,0.169,0.303,0.073,0.350,0.324,0.135,0.272,0.194,0.175,
0.126,0.191,0.173,0.121,0.022,0.050,0.044,0.021,0.178,0.058,
0.343,0.263,0.104,0.238,0.187,0.157,0.118,0.087,0.093,0.107,
0.220,0.141,0.118,0.121,0.176,0.034,0.246,0.229,0.143,0.211,
0.207,0.226,0.313,0.195,0.161,0.220,0.225,0.143,0.133,0.223,
0.211,0.024,0.132,0.179,0.192,0.175,0.131,0.238,0.177,0.140,
0.121,0.117,0.135,0.109,0.141,0.120,0.151,0.019,0.155,0.150,
0.102,0.115,0.110,0.131,0.135,0.128,0.127,0.145,0.018,0.017,
0.016,0.028,0.104,0.018,0.176,0.171,0.090,0.135,0.133,0.151,
0.169,0.106,0.131,0.222,0.199,0.130,0.128,0.225,0.284,0.024,
0.127,0.249,0.235,0.193,0.182,0.428,0.357,0.289,0.207,0.241,
0.309,0.287,0.278,0.233,0.247,0.048,0.243,0.257,0.174,0.260,
0.187,0.259,0.368,0.358,0.204,0.206,0.331,0.350,0.328,0.245,
0.320,0.080,0.386,0.440,0.185,0.327,0.229,0.242,0.190,0.287,
0.233,0.203,0.033,0.062,0.079,0.053,0.326,0.085,1.870,1.220,
0.174,0.376,0.294,0.274,0.204,0.155,0.154,0.202,0.313,0.306,
0.309,0.339,0.240,0.045,0.334,0.481,0.442,0.441,0.276,0.378,
0.176,0.135,0.119,0.130,0.196,0.175,0.197,0.154,0.231,0.052,
0.271,0.219,0.136,0.189,0.221,0.229,0.017,0.024,0.017,0.017,
0.027,0.040,0.039,0.026,0.029,0.017,0.058,0.038,0.019,0.040,
0.036,0.028,0.128,0.197,0.179,0.152,0.022,0.040,0.048,0.039,
0.188,0.063,0.296,0.237,0.110,0.272,0.250,0.213,0.130,0.119,
0.123,0.146,0.171,0.208,0.219,0.238,0.304,0.050,0.316,0.393,
0.169,0.216,0.294,0.310,0.195,0.141,0.117,0.152,0.130,0.101,
0.097,0.109,0.131,0.020,0.108,0.137,0.132,0.118,0.127,0.208,
0.136,0.119,0.104,0.126,0.126,0.121,0.123,0.137,0.151,0.019,
0.153,0.167,0.122,0.164,0.135,0.177,0.143,0.156,0.160,0.177,
0.019,0.020,0.019,0.025,0.174,0.026,0.189,0.217,0.162,0.245,
0.215,0.225,0.205,0.122,0.146,0.242,0.197,0.164,0.162,0.210,
0.244,0.021,0.271,0.341,0.329,0.276,0.346,0.432,2.480,2.320,
1.950,2.580,2.390,2.000,1.710,1.890,2.080,0.245,1.510,1.720,
2.440,2.510,2.060,2.030,2.070,1.910,1.260,1.380,1.630,1.260,
1.360,1.280,1.440,0.183,1.190,1.420,1.160,1.340,1.230,1.310,
1.540,1.400,1.260,1.310,0.144,0.145,0.138,0.192,1.210,0.124,
1.140,1.150,0.934,1.130,1.190,1.240,1.510,0.899,0.807,1.260,
1.040,0.846,0.937,1.090,1.030,0.095,0.866,1.170,1.200,0.632,
1.110,1.780,3.760,2.750,1.590,2.280,2.790,2.250,1.890,1.650,
1.850,0.250,1.300,1.770,1.510,1.660,1.230,1.630,3.100,3.960,
1.610,1.630,2.200,1.530,1.950,1.450,2.550,0.435,2.160,4.690,
1.470,1.890,1.430,1.650,2.550,2.520,2.010,1.640,0.284,0.320,
0.310,0.283,3.180,0.491,2.760,3.630,1.990,2.340,1.990,1.750,
1.660,1.210,0.768,1.060,1.830,1.760,1.340,1.530,1.400,0.159,
1.270,2.640,1.180,1.060,1.400,2.150,2.430,1.300,1.110,1.320,
2.640,1.960,2.120,1.690,2.610,0.344,1.500,1.560,1.460,1.550,
1.380,1.800,0.263,0.306,0.186,0.199,0.338,0.339,0.329,0.249,
0.328,0.088,0.320,0.358,0.251,0.489,0.279,0.331,1.550,1.620,
1.650,1.340,0.228,0.253,0.335,0.266,2.510,0.360,2.130,1.800,
0.994,1.750,2.000,1.470,1.040,0.951,0.714,0.831,1.630,1.610,
1.640,1.670,1.610,0.209,1.620,1.610,1.040,1.150,1.580,1.750,
1.780,0.797,0.764,1.230,1.060,0.713,0.705,0.760,1.080,0.119,
0.639,0.722,1.210,0.965,0.804,1.330,1.650,1.320,0.927,1.000,
1.350,1.140,1.080,0.936,1.280,0.133,1.010,1.270,1.130,1.330,
0.987,1.440,1.350,1.360,1.380,1.260,0.130,0.140,0.166,0.175,
1.680,0.168,1.360,1.430,1.020,1.530,1.810,1.450,1.720,1.030,
0.770,1.220,0.939,0.809,0.830,1.050,1.640,0.139,1.300,1.680,
1.760,1.370,1.850,2.830,0.225,0.234,0.168,0.175,0.203,0.214,
0.185,0.185,0.147,0.030,0.128,0.116,0.163,0.172,0.135,0.141,
0.237,0.363,0.273,0.220,0.264,0.294,0.339,0.248,0.217,0.072,
0.256,0.192,0.150,0.228,0.181,0.174,0.123,0.179,0.136,0.115,
0.027,0.042,0.043,0.034,0.155,0.041,0.206,0.218,0.099,0.152,
0.156,0.160,0.103,0.086,0.068,0.093,0.129,0.141,0.111,0.115,
0.095,0.020,0.103,0.143,0.097,0.087,0.130,0.193,0.256,0.394,
0.190,0.156,0.260,0.342,0.285,0.175,0.186,0.060,0.165,0.168,
0.109,0.169,0.121,0.118,0.439,1.290,0.279,0.195,0.317,0.323,
0.385,0.220,0.353,0.177,0.382,0.404,0.136,0.293,0.197,0.203,
0.205,0.383,0.239,0.165,0.060,0.138,0.123,0.063,0.985,0.317,
0.842,1.190,0.427,0.477,0.346,0.263,0.113,0.126,0.089,0.087,
0.181,0.255,0.177,0.152,0.152,0.035,0.183,0.278,0.099,0.106,
0.140,0.171,0.177,0.158,0.115,0.117,0.254,0.327,0.338,0.186,
0.234,0.074,0.245,0.157,0.090,0.174,0.163,0.153,0.035,0.088,
0.044,0.027,0.065,0.128,0.134,0.054,0.062,0.076,0.152,0.077,
0.022,0.074,0.067,0.034,0.171,0.283,0.311,0.182,0.057,0.112,
0.158,0.057,0.335,0.159,0.531,0.322,0.119,0.396,0.497,0.276,
0.109,0.094,0.107,0.090,0.199,0.282,0.310,0.223,0.194,0.058,
0.326,0.238,0.091,0.142,0.261,0.209,0.148,0.132,0.105,0.182,
0.108,0.102,0.087,0.120,0.103,0.019,0.083,0.084,0.095,0.113,
0.112,0.148,0.221,0.254,0.169,0.158,0.225,0.281,0.242,0.192,
0.197,0.045,0.208,0.201,0.136,0.253,0.209,0.224,0.111,0.172,
0.177,0.167,0.017,0.041,0.036,0.026,0.163,0.041,0.223,0.199,
0.110,0.205,0.350,0.203,0.139,0.114,0.089,0.116,0.094,0.124,
0.097,0.117,0.133,0.022,0.158,0.177,0.142,0.152,0.233,0.255,
3.230,2.200,1.940,2.540,1.550,1.450,1.200,1.270,1.420,0.177,
1.400,1.300,0.983,0.857,0.896,1.120,2.340,2.220,1.460,1.250,
2.130,2.070,2.030,1.350,2.090,0.356,2.740,2.100,0.901,1.710,
1.150,1.270,1.680,2.030,1.680,1.410,0.272,0.350,0.338,0.310,
1.670,0.300,2.980,2.030,0.758,1.800,1.510,1.400,1.210,0.772,
0.670,0.956,1.310,1.240,1.090,1.180,1.530,0.236,1.770,3.600,
1.010,0.937,1.340,2.060,0.243,0.246,0.152,0.177,0.293,0.399,
0.248,0.219,0.208,0.062,0.286,0.249,0.110,0.176,0.144,0.148,
0.238,0.366,0.166,0.119,0.361,0.439,0.380,0.211,0.263,0.125,
0.491,0.361,0.095,0.211,0.152,0.128,0.196,0.351,0.245,0.158,
0.063,0.141,0.157,0.070,0.335,0.159,0.767,0.493,0.126,0.322,
0.274,0.204,0.152,0.130,0.094,0.166,0.283,0.341,0.257,0.307,
0.230,0.064,0.370,1.290,0.128,0.148,0.195,0.341,2.810,1.390,
1.530,0.954,1.550,1.870,1.940,1.210,1.820,0.392,3.120,1.490,
0.803,1.530,1.760,1.300,0.222,0.336,0.339,0.154,0.201,0.374,
0.390,0.149,0.315,0.141,0.810,0.301,0.115,0.347,0.342,0.172,
1.350,1.080,1.520,0.674,0.230,0.217,0.419,0.132,0.978,0.241,
0.743,0.324,0.321,0.595,0.849,0.566,0.675,0.516,0.729,0.411,
0.877,0.969,1.350,0.689,1.150,0.215,2.040,1.230,0.573,0.807,
1.320,1.180,1.230,0.733,0.676,0.750,0.867,0.706,0.575,0.565,
0.854,0.123,1.040,0.833,0.563,0.655,0.637,0.751,1.490,1.450,
1.170,0.879,1.320,1.690,1.410,0.955,1.580,0.265,2.270,1.770,
0.882,1.570,1.150,0.993,1.130,1.360,1.330,1.010,0.150,0.237,
0.227,0.163,1.500,0.249,2.560,1.760,0.737,1.550,1.530,1.190,
0.845,0.636,0.642,0.824,0.923,0.947,0.930,0.892,1.290,0.171,
2.180,1.830,1.060,1.160,1.710,1.590,2.170,1.300,0.934,1.540,
1.050,0.823,0.718,0.817,1.010,0.120,0.817,0.903,1.100,0.953,
0.770,1.110,1.480,1.000,0.657,0.677,0.916,0.707,0.683,0.583,
0.794,0.095,0.721,0.715,0.527,0.628,0.570,0.698,1.120,0.984,
0.701,0.842,0.114,0.109,0.096,0.131,0.771,0.091,0.914,0.975,
0.549,0.911,0.798,0.965,1.010,0.573,0.519,0.902,1.000,0.627,
0.577,0.800,0.803,0.092,0.640,1.580,0.803,0.778,0.850,1.580,
2.290,1.850,1.170,1.510,1.900,1.730,1.540,1.300,1.370,0.197,
1.330,1.810,1.070,1.290,0.951,1.350,2.010,2.140,1.190,1.140,
1.980,1.900,2.000,1.350,1.550,0.248,1.870,2.020,0.793,1.250,
0.977,1.080,1.430,1.980,1.260,1.210,0.183,0.303,0.225,0.223,
1.730,0.303,2.200,2.500,0.898,1.950,1.550,1.720,1.170,0.912,
0.749,1.120,1.820,1.650,1.380,1.700,1.380,0.214,1.570,5.430,
0.936,1.220,1.160,2.080,1.930,1.360,1.010,1.080,1.670,1.610,
1.580,1.400,1.800,0.281,1.730,1.460,1.060,1.510,1.330,1.500,
0.179,0.203,0.140,0.129,0.198,0.295,0.263,0.177,0.193,0.074,
0.321,0.230,0.135,0.274,0.194,0.179,1.530,1.850,1.740,1.320,
0.224,0.216,0.295,0.217,2.260,0.402,2.190,2.130,0.952,1.880,
2.010,1.590,0.978,0.829,0.823,0.804,1.570,1.490,1.740,1.500,
1.450,0.206,2.040,2.270,0.961,1.130,1.760,1.800,1.510,0.834,
0.714,1.010,0.877,0.720,0.641,0.626,0.903,0.114,0.782,0.796,
0.867,0.776,0.802,1.160,1.470,1.070,0.872,0.922,1.090,1.120,
1.040,0.880,1.010,0.126,1.150,1.230,0.875,1.120,0.991,1.110,
1.400,1.370,1.230,1.270,0.130,0.148,0.139,0.155,1.570,0.185,
2.080,2.060,1.070,1.580,1.780,1.650,1.460,0.830,0.923,1.410,
1.340,1.150,1.090,1.290,1.540,0.139,1.950,2.330,1.610,1.300,
1.830,2.020,3.100,1.890,1.980,3.300,1.740,1.120,1.030,1.330,
1.590,0.166,0.835,1.220,2.320,2.140,1.140,1.940,1.920,1.200,
0.875,1.080,1.120,0.738,0.727,0.859,1.090,0.108,0.808,0.853,
1.130,1.340,0.760,1.080,1.400,1.100,1.040,1.370,0.134,0.102,
0.103,0.188,0.865,0.083,0.654,0.887,0.795,0.925,0.876,1.180,
1.850,0.983,0.986,1.720,1.260,0.862,0.887,1.330,1.330,0.099,
0.742,1.070,1.650,0.952,1.130,2.410,2.880,1.680,1.170,1.860,
1.560,1.120,0.816,1.000,1.030,0.116,0.607,0.893,1.010,1.190,
0.663,1.340,2.040,1.480,0.757,0.906,0.969,0.637,0.598,0.593,
1.180,0.120,0.724,1.310,0.907,1.040,0.626,0.993,1.230,0.986,
1.000,0.981,0.099,0.091,0.072,0.094,0.853,0.086,0.638,0.867,
0.774,0.830,0.709,0.832,1.060,0.696,0.547,0.892,1.000,0.782,
0.527,0.750,0.800,0.061,0.571,0.968,0.802,0.634,0.737,1.420,
2.140,1.000,0.899,1.240,1.710,1.000,0.985,1.160,1.450,0.175,
0.668,0.917,1.260,1.120,0.901,1.570,0.191,0.145,0.107,0.141,
0.147,0.117,0.105,0.124,0.140,0.024,0.117,0.139,0.213,0.235,
0.134,0.216,1.200,0.942,1.000,1.120,0.128,0.110,0.115,0.142,
1.120,0.132,0.769,0.951,1.110,1.170,1.340,1.250,1.040,0.718,
0.729,1.520,1.360,0.949,0.903,1.410,1.220,0.148,0.857,1.280,
1.070,1.000,1.260,1.780,2.340,0.907,0.831,1.840,1.060,0.642,
0.612,0.997,1.080,0.102,0.560,0.786,1.610,0.994,0.797,1.640,
1.580,1.090,0.801,1.010,1.000,0.758,0.629,0.721,0.980,0.077,
0.638,0.847,1.350,1.140,0.771,1.270,1.180,0.953,0.780,1.020,
0.092,0.088,0.061,0.094,0.853,0.069,0.610,0.798,0.929,0.912,
0.998,1.140,1.580,0.970,0.770,1.560,1.050,0.780,0.658,1.000,
1.290,0.096,0.883,1.380,1.840,1.390,1.590,3.000,3.410,2.200,
1.860,2.660,2.060,1.730,1.480,1.700,1.620,0.192,1.070,1.460,
1.720,1.600,1.160,1.970,2.340,1.840,1.650,1.710,1.660,1.420,
1.640,2.160,1.630,0.230,1.800,1.680,1.050,1.400,1.180,1.610,
1.440,1.270,1.150,1.370,0.137,0.162,0.146,0.201,1.230,0.168,
1.110,1.460,0.781,1.170,1.140,1.770,1.350,0.829,0.770,1.160,
1.270,1.220,0.882,1.120,0.929,0.106,0.757,1.060,1.100,0.885,
1.080,2.200,3.220,2.700,1.500,2.090,2.380,2.360,1.630,1.550,
1.660,0.257,1.050,1.350,1.290,1.760,0.986,1.710,2.730,3.480,
1.610,1.690,2.190,1.580,1.710,1.360,2.540,0.500,1.780,2.210,
1.200,2.230,1.240,1.770,1.560,2.050,1.720,1.580,0.194,0.290,
0.213,0.202,2.970,0.515,2.410,3.270,1.760,2.380,1.760,2.010,
1.090,0.946,0.760,1.000,1.460,1.600,1.020,1.120,1.170,0.131,
1.090,1.390,0.940,0.966,1.060,1.700,2.030,1.320,0.942,1.310,
2.080,2.050,1.860,1.620,2.090,0.431,1.290,1.430,1.100,1.450,
1.180,1.770,0.166,0.223,0.139,0.166,0.219,0.327,0.291,0.216,
0.220,0.089,0.275,0.230,0.143,0.339,0.207,0.222,1.470,1.790,
1.650,1.490,0.205,0.308,0.283,0.248,2.080,0.398,1.910,2.070,
1.090,2.420,2.310,2.150,1.100,0.826,0.833,1.140,1.750,1.920,
1.770,1.930,1.620,0.223,1.870,2.050,1.090,1.270,1.870,2.360,
2.100,1.250,1.060,3.160,1.090,0.917,0.835,1.980,1.280,0.135,
0.857,1.070,1.220,1.060,1.030,1.770,2.190,1.710,1.270,1.560,
1.510,1.620,1.390,1.640,1.540,0.207,1.420,1.680,1.330,2.040,
1.460,1.910,1.150,1.330,1.210,1.410,0.106,0.155,0.116,0.156,
1.240,0.151,1.280,1.550,0.932,1.530,1.890,1.840,1.310,1.030,
0.839,1.240,1.140,1.140,0.812,1.180,1.260,0.118,1.280,1.630,
1.450,1.470,1.840,2.790,3.390,1.970,1.780,2.470,1.540,1.460,
1.260,2.370,1.440,0.155,1.200,1.270,1.480,1.150,0.887,1.630,
2.440,2.110,1.330,1.640,1.830,1.680,1.700,2.820,2.080,0.301,
3.870,2.310,1.200,1.870,1.510,2.250,1.580,2.050,1.550,1.730,
0.193,0.250,0.199,0.317,1.580,0.223,1.600,1.810,0.985,1.950,
1.390,1.770,1.470,1.130,0.916,1.430,1.840,1.390,1.000,1.480,
1.570,0.193,1.390,2.620,1.570,1.320,1.690,3.130,0.239,0.218,
0.195,0.204,0.215,0.265,0.164,0.212,0.147,0.036,0.242,0.183,
0.118,0.185,0.139,0.199,0.230,0.297,0.171,0.158,0.286,0.335,
0.301,0.273,0.264,0.087,0.846,0.427,0.126,0.281,0.221,0.231,
0.139,0.265,0.156,0.141,0.056,0.076,0.059,0.036,0.240,0.074,
0.394,0.353,0.124,0.315,0.226,0.215,0.200,0.145,0.095,0.171,
0.951,0.333,0.193,0.254,0.205,0.041,0.236,0.529,0.177,0.171,
0.192,0.323,2.440,1.590,1.320,1.160,2.020,2.170,1.870,1.520,
1.780,0.417,3.150,1.800,1.180,1.690,1.720,1.690,0.193,0.255,
0.198,0.134,0.193,0.306,0.232,0.163,0.258,0.104,1.390,0.363,
0.151,0.352,0.366,0.223,2.570,3.150,2.690,1.630,0.384,0.756,
0.392,0.248,2.490,0.513,1.680,1.840,1.110,2.470,2.290,1.800,
1.540,1.160,1.120,1.040,2.100,2.860,1.980,1.600,1.960,0.320,
2.850,2.370,1.260,1.720,2.120,2.200,1.770,1.150,0.887,1.250,
1.150,1.050,0.793,0.918,1.250,0.163,1.270,1.270,1.010,1.140,
0.895,1.400,2.040,1.960,1.370,1.410,1.650,1.980,1.460,1.370,
2.030,0.288,3.870,2.570,1.450,2.380,1.850,1.880,1.720,2.090,
1.500,1.450,0.154,0.280,0.164,0.168,2.050,0.270,2.140,2.140,
1.480,3.290,2.260,2.140,1.770,1.090,0.975,1.240,1.450,1.460,
1.130,1.170,2.050,0.203,2.370,2.480,1.930,2.050,2.390,3.070,
3.340,1.550,1.150,2.210,1.340,0.906,0.720,1.130,1.200,0.119,
0.756,1.070,1.410,1.060,0.890,2.000,1.640,1.070,0.700,0.889,
1.000,0.707,0.707,0.876,1.020,0.104,0.949,0.984,0.722,0.767,
0.636,1.070,1.260,1.160,0.820,1.260,0.113,0.112,0.078,0.161,
0.858,0.090,0.675,1.010,0.733,0.959,0.776,1.210,1.550,0.881,
0.899,1.500,1.120,0.745,0.657,1.040,1.070,0.091,0.721,1.460,
1.360,1.000,1.150,2.930,2.730,1.720,1.310,1.830,1.630,1.390,
1.160,1.230,1.320,0.153,1.120,1.390,1.120,1.170,1.090,1.860,
1.900,1.540,1.110,1.120,1.710,1.270,1.560,1.150,1.590,0.202,
1.930,1.730,0.877,1.210,0.974,1.340,1.190,1.390,0.954,1.230,
0.124,0.142,0.108,0.132,1.250,0.158,1.240,1.610,0.977,1.540,
1.190,1.640,1.330,0.916,0.800,1.280,1.920,1.130,0.908,1.230,
1.290,0.126,1.090,2.530,1.230,1.100,1.210,2.280,2.430,1.470,
1.060,1.360,1.950,1.590,1.390,1.550,1.930,0.279,1.420,1.600,
1.410,1.540,1.420,2.160,0.170,0.174,0.113,0.135,0.173,0.187,
0.145,0.137,0.170,0.051,0.270,0.185,0.146,0.234,0.179,0.200,
1.800,2.120,1.640,1.630,0.172,0.229,0.212,0.199,2.290,0.315,
1.880,2.210,1.320,2.190,2.190,2.420,1.560,1.200,1.030,1.340,
1.830,1.720,1.690,1.850,2.100,0.223,2.160,2.710,1.510,1.650,
2.080,2.760,3.120,1.520,1.040,1.800,1.270,0.982,0.857,1.060,
1.430,0.164,0.963,1.410,1.750,1.440,1.240,2.700,2.050,1.480,
1.040,1.390,1.510,1.410,1.020,1.210,1.770,0.156,1.550,1.870,
1.560,1.670,1.580,2.140,1.890,1.830,1.380,1.860,0.137,0.159,
0.106,0.169,2.130,0.198,1.900,2.470,1.840,2.450,2.300,3.000,
3.040,1.410,1.260,2.560,1.830,1.560,1.210,1.920,2.570,0.175,
2.250,3.400,2.750,2.040,2.390,4.060,6.100,3.360,3.050,8.350,
2.960,1.840,1.730,2.550,3.410,0.310,1.550,2.720,5.100,3.370,
2.220,4.340,3.300,1.990,1.320,1.940,1.870,1.020,1.050,1.090,
1.840,0.128,1.040,1.350,1.560,1.300,1.110,1.780,2.520,1.540,
1.430,2.390,0.194,0.135,0.130,0.256,1.420,0.111,0.767,1.100,
1.570,1.440,1.200,1.700,3.970,1.600,1.750,3.780,2.730,1.540,
1.800,2.490,1.930,0.134,1.100,1.770,2.930,1.750,1.850,3.650,
3.740,1.740,1.230,2.170,1.720,1.140,0.823,1.150,2.190,0.156,
0.762,1.100,1.550,1.300,0.821,1.540,2.020,1.270,0.756,1.040,
1.090,0.629,0.589,0.645,1.350,0.105,0.689,1.030,0.879,0.815,
0.619,0.950,1.560,1.170,0.966,1.310,0.114,0.090,0.077,0.114,
1.160,0.096,0.693,0.943,0.925,0.950,0.731,1.150,1.640,0.953,
0.826,1.370,1.530,0.983,0.924,1.130,1.180,0.084,0.732,1.100,
1.230,0.969,0.961,1.950,2.530,1.150,0.981,1.670,1.540,0.959,
1.000,1.210,1.940,0.185,0.715,1.190,1.560,1.210,1.060,2.180,
0.197,0.162,0.094,0.176,0.123,0.128,0.088,0.111,0.170,0.022,
0.088,0.132,0.189,0.205,0.128,0.229,1.170,0.880,0.765,0.980,
0.083,0.069,0.060,0.105,0.910,0.078,0.536,0.714,0.766,0.840,
0.718,0.964,0.985,0.848,0.697,0.852,1.110,0.931,0.816,0.980,
1.270,0.119,0.826,1.140,1.170,1.120,1.090,1.850,3.760,1.470,
1.310,2.810,1.490,0.889,0.831,1.090,4.120,0.220,0.857,1.330,
2.620,1.480,1.350,2.960,2.260,1.420,1.000,1.670,1.280,0.931,
0.746,0.884,1.470,0.099,0.777,1.140,1.440,1.210,0.983,1.680,
1.440,1.080,0.903,1.450,0.104,0.072,0.068,0.119,1.110,0.075,
0.860,1.010,1.300,1.090,1.000,1.400,2.320,1.220,1.170,2.300,
1.190,0.843,0.841,1.290,1.910,0.111,1.140,1.890,3.240,1.970,
1.940,4.710,4.810,2.400,1.730,3.440,2.080,1.360,1.210,1.470,
1.580,0.152,0.815,1.500,2.140,1.800,1.090,2.180,2.330,1.470,
0.941,1.380,1.260,0.922,0.957,0.918,1.050,0.093,0.708,0.962,
0.926,1.010,0.732,1.180,1.280,1.290,0.871,1.200,0.102,0.124,
0.080,0.120,0.795,0.083,0.596,0.765,0.909,1.100,0.710,1.030,
1.540,0.889,0.779,1.490,1.240,1.010,0.918,1.100,0.914,0.076,
0.614,1.010,1.300,0.954,0.913,1.940,2.470,1.560,0.804,1.540,
1.310,0.954,0.629,0.870,0.953,0.099,0.504,0.891,0.877,1.030,
0.507,1.170,1.420,1.210,0.619,0.818,0.833,0.466,0.505,0.574,
0.841,0.077,0.545,0.743,0.573,0.722,0.443,0.701,1.060,1.050,
0.739,1.030,0.076,0.095,0.068,0.085,0.803,0.108,0.600,0.719,
0.684,1.000,0.593,0.976,1.140,0.720,0.589,1.100,0.900,0.807,
0.611,0.746,0.863,0.066,0.540,0.835,0.769,0.698,0.592,1.220,
1.800,0.928,0.681,1.170,1.090,0.776,0.745,0.883,1.020,0.106,
0.535,0.801,0.910,0.852,0.695,1.290,0.100,0.096,0.055,0.094,
0.077,0.090,0.065,0.077,0.072,0.018,0.065,0.084,0.076,0.124,
0.069,0.108,0.906,1.090,0.838,0.892,0.075,0.195,0.056,0.088,
0.705,0.099,0.453,0.638,0.616,1.220,0.619,0.802,0.966,0.761,
0.629,0.979,0.935,1.200,0.679,1.240,0.853,0.074,0.613,1.030,
0.745,0.769,0.790,1.340,1.570,0.905,0.652,1.200,0.801,0.507,
0.463,0.652,0.887,0.065,0.442,0.668,0.974,0.660,0.646,1.330,
1.150,0.837,0.610,0.928,0.684,0.616,0.549,0.643,0.606,0.055,
0.498,0.702,0.647,0.777,0.614,0.998,0.836,0.797,0.702,0.936,
0.052,0.058,0.041,0.068,0.655,0.053,0.464,0.662,0.714,0.735,
0.662,0.960,1.170,0.746,0.647,1.160,0.768,0.615,0.489,0.816,
1.030,0.071,0.644,1.140,1.440,1.040,1.110,2.160,3.760,2.050,
1.480,2.560,1.350,1.090,0.968,1.150,1.360,0.141,1.020,1.160,
1.590,1.450,0.818,1.670,2.400,1.610,1.410,1.760,1.400,1.080,
3.470,2.400,1.400,0.147,1.530,1.330,1.330,1.450,1.080,1.570,
1.520,1.490,1.360,1.540,0.144,0.152,0.155,0.229,0.897,0.094,
0.666,0.780,0.998,1.190,1.040,1.190,1.850,1.050,1.110,2.020,
1.430,1.090,1.090,1.420,1.300,0.111,0.766,1.270,1.670,1.280,
1.260,3.060,0.240,0.172,0.113,0.179,0.145,0.136,0.088,0.103,
0.127,0.021,0.082,0.105,0.129,0.158,0.084,0.162,0.195,0.163,
0.089,0.119,0.143,0.118,0.155,0.120,0.130,0.026,0.117,0.122,
0.115,0.135,0.082,0.127,0.132,0.174,0.097,0.141,0.017,0.027,
0.022,0.018,0.109,0.020,0.169,0.149,0.112,0.146,0.105,0.148,
0.251,0.149,0.132,0.252,0.274,0.226,0.211,0.218,0.149,0.019,
0.106,0.204,0.195,0.235,0.143,0.311,1.670,0.935,0.736,1.020,
1.060,0.800,0.739,0.799,1.380,0.226,1.110,1.080,1.170,1.170,
1.020,1.620,0.126,0.112,0.072,0.098,0.082,0.092,0.110,0.086,
0.127,0.028,0.105,0.096,0.140,0.167,0.102,0.133,1.090,0.995,
0.710,0.827,0.103,0.098,0.085,0.088,0.811,0.102,0.507,0.631,
0.674,0.877,0.672,0.877,0.969,0.683,0.738,1.020,1.250,1.140,
0.789,0.992,1.100,0.113,0.890,1.120,0.941,0.914,0.968,1.480,
1.790,0.877,0.663,1.370,1.190,0.628,0.460,0.650,1.250,0.124,
0.648,1.400,1.380,1.100,0.675,1.650,1.820,1.200,0.895,1.350,
1.090,1.200,0.767,0.796,1.400,0.119,0.863,1.220,1.490,1.320,
0.827,1.400,1.380,1.510,0.820,1.090,0.109,0.196,0.064,0.097,
1.010,0.106,0.649,0.873,1.080,1.220,0.884,1.290,1.570,0.954,
0.911,1.310,1.140,1.090,0.683,0.960,1.450,0.114,1.040,1.550,
1.920,1.540,1.430,2.680,5.230,2.370,2.030,3.370,1.580,0.958,
1.020,1.030,1.620,0.137,0.848,1.290,2.530,1.600,1.290,2.850,
1.900,0.992,0.921,1.300,1.030,0.587,1.250,0.994,1.220,0.088,
0.894,1.180,1.290,0.884,1.190,1.640,1.800,1.200,1.110,1.810,
0.144,0.099,0.100,0.186,1.110,0.089,0.599,0.937,1.520,1.150,
0.863,1.530,2.770,1.310,1.610,3.910,1.770,0.965,1.420,1.790,
1.700,0.117,0.956,1.400,2.650,1.740,1.710,3.990,2.930,1.640,
1.220,1.860,1.560,0.978,0.872,0.989,1.300,0.116,0.721,1.130,
1.340,1.250,0.864,1.720,1.870,1.150,0.734,0.968,1.190,0.751,
0.705,0.740,1.090,0.094,0.804,1.030,1.010,0.891,0.635,1.090,
1.480,1.490,0.843,1.480,0.110,0.099,0.080,0.124,1.150,0.098,
0.867,1.180,1.340,1.340,0.880,1.500,2.010,1.080,1.250,1.980,
1.790,1.190,1.930,1.710,1.340,0.130,0.866,1.430,1.780,2.480,
1.320,2.450,1.920,1.050,1.010,1.300,1.270,0.821,0.823,1.000,
1.680,0.264,0.947,1.200,1.340,1.310,1.200,1.970,0.116,0.093,
0.071,0.111,0.078,0.085,0.072,0.078,0.171,0.020,0.092,0.108,
0.138,0.143,0.095,0.151,1.110,0.915,0.721,1.060,0.087,0.073,
0.054,0.099,0.960,0.089,0.666,0.929,0.971,1.010,0.768,1.310,
1.150,0.784,0.790,1.210,1.330,1.110,0.882,1.260,1.490,0.132,
1.010,1.580,1.380,1.190,1.310,2.240,3.270,1.450,1.340,2.550,
1.460,0.866,0.789,1.060,1.790,0.165,0.912,1.620,2.490,1.640,
1.530,4.230,1.690,1.030,0.865,1.440,0.935,0.774,0.674,0.810,
1.280,0.080,0.786,1.280,1.470,1.300,0.934,1.830,1.930,1.730,
1.520,1.930,0.133,0.126,0.084,0.144,1.890,0.122,0.983,1.530,
2.140,1.850,1.380,2.320,3.100,1.500,1.720,3.170,2.070,1.590,
1.390,2.150,2.810,0.150,1.910,3.200,4.800,3.040,3.300,6.150,
6.240,3.620,3.460,5.670,3.630,2.180,2.130,2.660,3.190,0.340,
1.950,3.110,4.300,3.410,2.320,4.060,3.920,2.600,1.800,2.290,
2.740,1.620,1.600,1.590,2.430,0.222,1.930,2.180,1.910,1.940,
1.790,2.450,2.350,1.740,1.700,2.160,0.231,0.172,0.182,0.287,
1.520,0.152,1.100,1.240,1.540,1.870,1.770,1.960,3.360,1.640,
1.680,3.150,2.890,1.910,1.770,2.420,2.410,0.193,1.540,2.010,
2.910,2.210,2.460,4.190,4.510,2.960,1.840,2.680,2.640,1.940,
1.510,1.710,2.420,0.284,1.610,2.070,2.070,2.270,1.370,2.520,
3.010,2.180,1.510,1.760,2.000,1.400,1.390,1.410,3.480,0.356,
2.470,3.380,1.470,1.830,1.550,2.110,1.960,1.920,1.890,1.850,
0.220,0.196,0.200,0.213,1.890,0.286,1.630,1.710,1.420,2.060,
1.650,1.710,1.940,1.320,1.050,1.580,1.990,1.520,1.260,1.580,
1.890,0.149,1.320,1.960,1.640,1.480,1.680,2.770,2.710,1.430,
1.190,1.760,2.040,1.320,1.570,1.560,1.970,0.238,1.240,1.460,
1.660,1.590,1.450,2.560,0.194,0.171,0.121,0.163,0.196,0.189,
0.168,0.153,0.182,0.039,0.160,0.199,0.177,0.272,0.196,0.262,
1.340,1.260,1.210,1.230,0.152,0.140,0.137,0.165,1.260,0.162,
1.050,1.180,1.010,1.340,1.410,1.520,1.190,0.916,0.827,1.110,
1.740,1.290,1.210,1.410,1.780,0.169,1.300,1.630,1.550,1.500,
1.930,2.620,3.070,1.420,1.240,2.080,1.570,0.925,0.807,0.989,
2.070,0.229,0.971,1.320,1.940,1.440,1.130,2.460,2.650,1.770,
1.300,1.770,1.830,1.450,1.130,1.240,1.560,0.145,1.160,1.650,
1.400,1.620,1.360,1.980,1.300,1.110,1.040,1.430,0.111,0.098,
0.089,0.136,1.060,0.112,0.823,1.120,1.140,1.340,1.190,1.790,
1.980,1.110,0.990,1.970,1.440,1.100,0.931,1.260,1.960,0.147,
1.270,2.200,2.620,2.180,2.590,4.930,4.510,2.780,2.290,3.320,
2.830,2.130,1.800,2.080,1.950,0.208,1.250,1.660,2.130,2.030,
1.380,2.480,3.010,2.380,1.530,1.850,2.130,1.630,1.560,1.510,
1.760,0.228,1.530,1.620,1.320,2.170,1.260,1.670,1.520,1.520,
1.230,1.490,0.145,0.188,0.151,0.189,1.070,0.140,1.010,0.928,
0.930,1.280,1.230,1.480,2.010,0.963,0.908,2.010,1.610,1.410,
1.020,1.380,1.320,0.119,1.070,1.240,1.670,1.180,1.390,2.630,
3.430,2.760,1.390,2.060,2.560,2.330,1.380,1.440,1.630,0.205,
1.170,1.690,1.310,1.580,0.942,2.290,2.710,2.700,1.650,1.790,
1.690,0.871,1.310,1.240,1.740,0.252,1.910,1.990,0.981,1.570,
1.140,1.400,1.800,2.060,1.350,1.610,0.211,0.299,0.218,0.222,
1.590,0.269,1.290,1.530,1.170,2.020,1.570,1.730,2.100,1.160,
0.920,1.640,1.660,1.880,1.100,1.340,1.420,0.141,1.230,1.540,
1.200,1.170,1.250,2.080,2.400,1.400,0.959,1.300,1.940,1.650,
1.470,1.310,1.740,0.242,1.010,1.150,1.490,1.530,1.400,1.940,
0.150,0.196,0.107,0.146,0.149,0.246,0.177,0.136,0.160,0.065,
0.176,0.175,0.120,0.327,0.168,0.170,1.520,1.770,1.340,1.400,
0.180,0.317,0.199,0.197,1.420,0.227,1.140,1.290,0.987,1.770,
1.750,1.660,1.300,0.952,0.813,1.170,1.690,1.890,1.510,1.730,
1.580,0.173,1.410,1.770,1.480,1.360,2.120,2.450,1.890,1.070,
0.826,1.280,1.170,0.774,0.653,0.782,1.170,0.106,0.825,0.827,
1.270,0.923,0.897,1.510,1.730,1.420,0.972,1.290,1.150,1.330,
1.020,1.110,1.030,0.148,0.945,1.110,0.916,1.440,1.200,1.350,
0.968,1.090,0.907,1.120,0.084,0.105,0.074,0.112,0.939,0.106,
0.813,0.982,0.957,1.190,1.400,1.460,1.390,0.827,0.724,1.320,
1.070,0.961,0.725,1.070,1.190,0.086,1.030,1.510,1.620,1.430,
1.680,2.550,3.150,2.290,1.810,2.480,1.650,1.470,1.480,1.390,
1.690,0.253,3.710,1.750,1.750,1.730,1.410,1.780,2.830,2.430,
1.580,1.810,1.980,1.880,1.890,1.630,2.320,0.370,4.600,2.500,
1.480,2.650,1.810,1.910,1.580,1.960,1.660,1.740,0.200,0.265,
0.284,0.363,1.530,0.246,2.990,2.300,1.180,2.100,4.550,2.000,
1.660,1.100,0.987,1.900,1.680,1.490,1.360,1.880,1.560,0.171,
1.640,1.900,1.770,1.530,2.270,3.440,0.184,0.203,0.108,0.151,
0.205,0.247,0.154,0.154,0.142,0.037,0.197,0.155,0.133,0.192,
0.116,0.176,0.217,0.253,0.137,0.144,0.257,0.311,0.228,0.182,
0.227,0.081,0.333,0.260,0.135,0.261,0.153,0.181,0.122,0.217,
0.151,0.174,0.029,0.073,0.073,0.045,0.278,0.094,1.570,0.938,
0.139,0.274,0.371,0.246,0.185,0.132,0.096,0.194,0.250,0.303,
0.222,0.277,0.176,0.031,0.256,0.311,0.174,0.189,0.221,0.309,
2.290,1.530,1.080,1.230,1.590,1.680,1.430,1.290,1.800,0.316,
1.800,1.650,1.290,1.600,1.470,1.930,0.170,0.222,0.124,0.125,
0.154,0.263,0.201,0.147,0.193,0.061,0.304,0.238,0.151,0.297,
0.193,0.204,1.520,2.020,1.360,1.270,0.212,0.332,0.259,0.212,
1.710,0.334,1.490,1.540,1.190,2.070,1.790,1.660,1.220,1.080,
0.977,1.140,1.860,2.330,1.710,1.740,1.920,0.287,2.100,2.270,
1.440,1.700,2.060,2.680,1.930,1.170,0.908,1.480,1.150,0.912,
0.715,0.852,1.340,0.176,0.936,1.300,1.810,1.410,0.894,1.820,
2.460,1.980,1.310,1.690,1.800,2.200,1.420,1.510,1.950,0.268,
1.920,2.510,1.740,2.400,1.540,2.070,1.720,1.820,1.260,1.370,
0.166,0.225,0.142,0.157,1.680,0.214,1.550,1.760,1.690,2.270,
1.740,1.920,1.670,1.160,0.968,1.560,2.020,1.420,1.030,1.310,
1.930,0.184,1.900,2.500,2.450,2.450,2.540,3.580,3.780,1.950,
1.770,2.860,1.970,1.110,1.210,1.730,1.930,0.164,1.370,1.710,
2.230,1.600,1.490,2.720,2.000,1.250,1.010,1.360,1.330,0.889,
1.040,1.090,1.390,0.123,1.630,1.570,1.250,1.130,1.290,1.710,
1.590,1.270,1.290,1.800,0.132,0.117,0.111,0.220,1.200,0.120,
1.120,1.370,1.330,1.420,1.710,1.930,2.050,1.080,1.340,2.670,
1.730,1.010,1.150,2.010,1.670,0.129,1.170,1.900,2.590,1.670,
1.920,4.530,3.280,2.210,1.600,2.410,2.630,1.860,1.640,1.870,
1.840,0.219,1.340,1.840,1.930,1.960,1.280,2.340,2.560,1.810,
1.270,1.580,2.260,1.670,1.520,1.600,1.960,0.226,1.900,2.470,
1.730,1.850,1.560,2.150,1.600,1.800,1.330,1.710,0.161,0.203,
0.177,0.232,1.930,0.252,3.140,3.200,2.060,2.470,1.790,2.300,
1.870,1.250,1.270,2.070,2.190,1.870,2.120,2.600,1.850,0.197,
1.890,2.550,2.170,2.210,2.090,3.330,2.170,1.260,1.160,1.460,
1.720,1.290,1.310,1.510,1.870,0.262,1.540,1.800,1.520,1.500,
1.600,2.510,0.135,0.130,0.092,0.121,0.116,0.161,0.132,0.127,
0.130,0.031,0.187,0.176,0.133,0.187,0.150,0.190,1.330,1.380,
1.110,1.340,0.124,0.139,0.123,0.172,1.500,0.207,1.470,1.680,
1.220,1.790,1.640,2.030,1.250,0.984,1.050,1.330,1.430,1.400,
1.370,1.700,2.320,0.207,2.020,2.600,1.820,1.720,2.610,3.240,
2.640,1.490,1.330,1.930,1.470,1.000,0.855,1.100,1.640,0.197,
1.030,1.540,1.700,1.280,1.240,2.730,1.940,1.400,1.080,1.530,
1.370,1.200,1.060,1.350,1.330,0.120,1.130,1.610,1.460,1.590,
1.200,2.000,1.680,1.400,1.290,1.750,0.135,0.124,0.103,0.165,
1.740,0.146,1.320,1.790,2.200,2.110,1.950,2.560,2.440,1.310,
1.480,2.590,1.730,1.460,1.420,1.850,2.460,0.180,2.310,3.340,
3.700,2.870,4.000,5.090,4.000,2.620,2.140,3.960,2.470,1.740,
1.510,2.100,2.180,0.242,1.250,2.050,2.690,2.480,1.620,2.610,
2.480,1.880,1.080,1.730,1.710,1.200,1.100,1.280,1.670,0.273,
1.270,1.260,1.220,1.590,1.190,1.600,2.410,1.580,1.280,1.940,
0.167,0.124,0.137,0.241,1.180,0.116,0.874,1.270,1.020,1.260,
1.360,1.470,3.150,1.250,1.020,2.050,1.570,1.030,1.060,1.480,
1.230,0.101,0.879,1.320,1.550,0.925,1.380,2.500,4.050,2.620,
1.530,2.530,2.820,2.010,1.610,1.670,1.650,0.203,1.070,1.510,
1.590,1.640,1.140,1.840,2.990,3.470,1.280,1.580,2.040,1.300,
1.380,1.310,1.840,0.239,1.360,2.030,1.180,1.530,1.060,1.420,
2.390,2.100,1.560,1.940,0.230,0.218,0.198,0.259,2.160,0.249,
1.560,2.420,1.370,1.880,1.730,1.850,2.350,1.310,0.878,1.600,
2.070,1.650,1.380,1.780,1.590,0.156,1.170,2.170,1.340,1.210,
1.490,2.740,2.320,1.270,0.967,1.610,2.440,1.750,1.670,2.170,
2.830,0.340,1.180,1.610,1.780,1.750,1.250,2.150,0.211,0.214,
0.137,0.188,0.260,0.242,0.239,0.243,0.281,0.052,0.213,0.251,
0.235,0.363,0.211,0.305,1.470,1.460,1.390,1.530,0.197,0.200,
0.297,0.281,1.730,0.237,1.120,1.450,1.020,1.650,1.440,1.500,
1.340,0.978,0.916,1.600,1.980,1.670,2.160,2.040,2.720,0.252,
1.450,2.010,1.360,1.410,1.660,2.370,2.340,1.220,0.895,1.690,
1.480,0.943,0.782,1.020,1.620,0.160,0.719,1.080,1.750,1.340,
1.020,2.090,1.940,1.380,0.999,1.340,1.640,1.130,1.100,1.220,
1.450,0.130,1.010,1.380,1.350,1.330,1.130,1.810,1.640,1.420,
1.380,1.700,0.145,0.127,0.138,0.187,1.630,0.146,1.110,1.720,
1.310,1.700,1.660,2.030,2.230,1.250,1.190,2.020,1.460,1.050,
1.120,1.460,2.950,0.201,1.650,2.780,3.170,2.200,2.560,4.700,
0.258,0.231,0.139,0.223,0.203,0.194,0.167,0.196,0.160,0.030,
0.157,0.193,0.177,0.321,0.149,0.213,0.235,0.327,0.145,0.174,
0.204,0.215,0.213,0.198,0.164,0.033,0.247,0.176,0.124,0.187,
0.168,0.186,0.136,0.150,0.108,0.138,0.019,0.024,0.024,0.025,
0.107,0.018,0.111,0.152,0.086,0.136,0.132,0.152,0.180,0.101,
0.079,0.154,0.178,0.150,0.119,0.168,0.116,0.017,0.099,0.160,
0.132,0.124,0.155,0.273,0.267,0.326,0.140,0.167,0.259,0.302,
0.242,0.166,0.150,0.039,0.111,0.143,0.107,0.166,0.114,0.155,
0.413,1.230,0.202,0.198,0.318,0.352,0.276,0.218,0.235,0.078,
0.235,0.266,0.121,0.247,0.155,0.191,0.186,0.272,0.168,0.180,
0.042,0.079,0.063,0.043,0.294,0.094,0.251,0.359,0.157,0.252,
0.229,0.211,0.185,0.153,0.089,0.142,0.227,0.249,0.189,0.201,
0.171,0.031,0.142,0.295,0.123,0.123,0.141,0.244,0.158,0.110,
0.080,0.108,0.182,0.198,0.186,0.161,0.183,0.035,0.109,0.125,
0.103,0.139,0.109,0.164,0.020,0.045,0.023,0.020,0.032,0.062,
0.053,0.041,0.035,0.029,0.052,0.056,0.015,0.037,0.033,0.031,
0.147,0.198,0.172,0.168,0.030,0.057,0.074,0.041,0.241,0.067,
0.200,0.225,0.108,0.244,0.217,0.187,0.115,0.086,0.086,0.136,
0.205,0.246,0.246,0.230,0.233,0.046,0.200,0.261,0.119,0.196,
0.183,0.245,0.176,0.156,0.098,0.146,0.137,0.125,0.092,0.107,
0.131,0.020,0.079,0.099,0.136,0.149,0.112,0.206,0.208,0.217,
0.166,0.176,0.208,0.239,0.194,0.185,0.170,0.030,0.144,0.182,
0.160,0.245,0.187,0.247,0.149,0.134,0.138,0.243,0.019,0.027,
0.025,0.027,0.149,0.023,0.132,0.172,0.121,0.171,0.229,0.209,
0.176,0.114,0.099,0.169,0.154,0.129,0.112,0.128,0.210,0.023,
0.154,0.228,0.204,0.193,0.223,0.376,3.050,2.130,1.460,2.270,
1.650,1.390,1.150,1.460,1.400,0.170,1.590,1.360,1.110,1.000,
0.999,1.450,2.350,2.310,1.680,1.450,2.010,1.900,2.040,1.520,
2.140,0.406,7.160,2.520,1.050,1.760,1.810,1.650,1.460,1.790,
1.300,1.510,0.221,0.288,0.236,0.341,1.480,0.211,1.680,1.780,
0.849,1.660,1.460,1.480,1.450,1.000,0.744,1.290,1.550,1.320,
1.150,1.600,1.640,0.218,1.920,4.020,1.360,1.280,1.660,2.810,
0.213,0.204,0.120,0.157,0.198,0.240,0.164,0.162,0.118,0.033,
0.128,0.176,0.089,0.135,0.088,0.145,0.200,0.348,0.195,0.132,
0.241,0.266,0.230,0.167,0.160,0.068,0.365,0.216,0.080,0.149,
0.115,0.121,0.125,0.230,0.125,0.150,0.032,0.078,0.064,0.043,
0.175,0.065,0.239,0.410,0.085,0.197,0.162,0.165,0.188,0.132,
0.091,0.207,0.244,0.302,0.194,0.294,0.276,0.062,0.272,1.570,
0.138,0.168,0.172,0.378,2.180,1.470,1.170,1.180,1.850,2.020,
1.980,1.400,1.790,0.316,2.050,1.710,1.060,1.420,1.400,1.830,
0.175,0.274,0.337,0.140,0.197,0.361,0.342,0.148,0.193,0.069,
0.387,0.228,0.126,0.250,0.214,0.199,1.570,1.890,1.680,1.520,
0.227,0.238,0.334,0.218,1.500,0.254,0.627,1.030,0.770,1.380,
1.430,1.370,1.070,0.827,0.787,0.938,1.550,1.690,1.620,1.430,
1.570,0.215,2.030,2.040,1.050,1.300,1.700,1.990,1.730,1.130,
0.960,1.180,1.390,1.400,0.834,0.841,1.200,0.145,0.991,1.190,
1.050,0.967,0.803,1.530,1.980,2.300,3.040,1.460,2.040,3.290,
2.450,1.410,1.630,0.246,2.060,1.990,1.300,1.740,1.340,1.610,
1.550,1.790,1.400,1.510,0.202,0.260,0.198,0.198,1.750,0.228,
1.940,1.990,1.090,1.900,1.810,1.850,1.470,1.010,0.874,1.260,
1.470,1.440,1.060,1.190,1.760,0.174,2.130,2.020,1.690,1.730,
2.020,2.670,3.210,1.650,1.150,2.120,1.600,1.060,0.917,1.240,
1.300,0.141,0.856,1.060,1.500,1.230,0.967,1.770,1.750,1.160,
0.795,1.060,1.240,0.916,0.862,0.971,1.040,0.105,1.640,1.110,
0.848,0.839,0.865,1.170,1.510,1.200,0.853,1.290,0.144,0.118,
0.104,0.197,1.260,0.120,0.948,1.330,1.040,1.230,1.040,1.460,
1.540,0.919,0.808,1.450,1.440,0.889,0.916,1.380,1.330,0.140,
0.941,1.600,1.550,1.170,1.280,2.580,3.330,2.230,1.330,2.140,
2.320,1.830,1.540,1.610,1.630,0.194,1.290,1.650,1.490,1.750,
1.090,1.980,2.340,2.190,1.170,1.420,2.420,1.870,1.620,1.550,
1.520,0.183,1.660,2.060,1.010,1.300,1.010,1.510,1.760,2.160,
1.280,1.720,0.183,0.231,0.166,0.242,2.260,0.277,1.850,2.870,
1.480,2.250,1.810,2.340,1.970,1.340,1.090,1.880,2.560,1.950,
1.840,2.440,2.690,0.512,1.860,4.700,1.740,2.370,1.740,2.880,
2.530,1.380,1.140,1.520,2.060,1.700,1.670,1.630,1.780,0.238,
1.440,1.640,1.450,1.460,1.340,2.200,0.162,0.150,0.108,0.131,
0.154,0.222,0.193,0.156,0.135,0.035,0.196,0.232,0.126,0.203,
0.148,0.197,1.780,1.960,1.500,1.710,0.170,0.182,0.173,0.206,
1.930,0.261,1.510,2.080,1.310,2.050,1.900,2.180,1.460,1.140,
1.010,1.290,1.970,1.830,1.680,1.910,1.960,0.233,2.080,2.970,
1.600,1.760,2.280,2.780,2.790,1.490,1.290,1.790,1.620,1.110,
0.946,1.080,1.600,0.198,1.080,1.440,1.330,1.070,1.110,2.250,
1.840,1.390,1.130,1.360,1.500,1.530,1.280,1.380,1.290,0.121,
1.330,1.780,1.190,1.260,1.400,1.940,2.150,1.960,1.520,2.130,
0.177,0.176,0.128,0.219,2.320,0.216,2.140,2.840,1.940,2.390,
2.350,2.810,2.490,1.350,1.190,2.240,1.950,1.700,1.410,1.980,
2.570,0.211,2.390,3.400,2.690,2.220,2.770,4.350,7.750,3.430,
2.840,6.150,2.560,1.570,1.370,2.680,2.490,0.267,1.170,1.900,
3.500,2.860,1.680,3.310,2.680,1.650,1.020,1.690,1.510,0.857,
0.837,1.100,1.440,0.112,1.020,1.100,1.500,1.340,0.991,1.570,
2.210,1.570,1.360,2.520,0.209,0.140,0.128,0.311,1.380,0.111,
0.748,1.460,1.340,1.390,1.160,1.760,3.260,1.570,1.360,3.060,
2.090,1.310,1.130,1.970,1.680,0.136,1.140,1.800,2.390,1.600,
1.830,4.120,3.740,1.930,1.340,2.590,1.850,1.180,0.914,1.250,
1.120,0.118,0.574,1.040,1.290,1.200,0.755,1.650,2.240,1.480,
0.738,1.280,1.320,0.716,0.644,0.799,1.120,0.092,0.610,1.010,
1.010,0.925,0.719,1.420,1.720,1.350,1.220,1.930,0.122,0.113,
0.087,0.169,1.330,0.189,0.632,1.090,0.969,1.230,0.901,1.320,
1.680,1.060,0.748,1.410,1.330,1.010,0.711,1.120,1.050,0.078,
0.621,1.090,1.050,0.938,0.958,2.060,2.900,1.560,1.030,2.220,
2.190,1.310,1.130,1.830,2.000,0.215,0.701,1.250,2.210,1.800,
1.090,2.690,0.297,0.199,0.118,0.262,0.246,0.175,0.145,0.220,
0.212,0.022,0.097,0.178,0.326,0.317,0.171,0.373,1.470,1.220,
1.030,1.560,0.140,0.104,0.100,0.176,1.280,0.126,0.593,1.040,
1.150,1.270,1.050,1.540,1.670,1.330,1.040,2.090,1.950,1.300,
1.120,1.930,1.520,0.146,0.915,1.700,1.640,1.410,1.340,2.740,
3.410,1.860,1.010,2.360,1.260,0.750,0.686,1.040,1.640,0.156,
0.695,1.150,2.450,1.660,1.120,2.810,2.000,1.170,0.802,1.340,
1.090,0.752,0.641,0.835,1.240,0.077,0.669,1.020,1.550,1.270,
0.944,1.770,1.610,1.170,1.120,1.370,0.111,0.080,0.073,0.114,
1.290,0.089,0.701,1.160,1.320,1.400,1.220,1.880,2.810,1.470,
1.270,2.520,1.790,1.060,0.877,1.430,2.470,0.150,1.420,2.330,
4.010,2.680,2.900,6.660,4.420,2.490,1.720,3.440,2.360,1.600,
1.340,1.830,2.040,0.227,2.310,2.030,2.180,1.850,1.460,2.570,
2.480,1.810,1.170,1.680,1.770,1.320,1.590,1.760,1.580,0.166,
2.650,1.680,1.210,1.300,1.260,1.810,1.520,1.190,0.886,1.570,
0.130,0.129,0.089,0.193,1.140,0.122,0.834,1.320,1.010,1.310,
0.987,1.740,1.940,0.971,0.817,1.870,1.450,1.110,0.812,1.440,
1.340,0.143,0.892,1.410,1.620,1.270,1.280,2.960,3.570,2.420,
1.270,2.170,2.260,1.720,1.150,1.470,1.400,0.148,0.731,1.260,
1.360,1.470,0.835,1.750,2.490,3.190,0.982,1.360,1.920,1.360,
1.060,1.230,1.500,0.181,1.020,1.360,1.030,1.370,0.892,1.560,
1.750,1.640,1.130,1.640,0.181,0.166,0.114,0.158,1.660,0.220,
1.010,1.630,1.280,1.720,1.280,1.890,1.550,1.030,0.695,1.360,
1.570,1.400,0.978,1.320,1.220,0.107,0.756,1.300,1.260,1.080,
1.060,2.180,2.270,1.130,0.867,1.340,1.810,1.240,1.120,1.380,
1.570,0.197,0.738,1.050,1.360,1.240,0.927,2.090,0.119,0.125,
0.074,0.113,0.128,0.156,0.113,0.136,0.120,0.025,0.099,0.123,
0.136,0.176,0.108,0.172,1.550,1.380,1.040,1.380,0.153,0.145,
0.128,0.166,2.180,0.194,0.983,1.360,1.230,1.600,1.280,1.880,
1.450,0.931,0.802,1.470,1.790,1.500,1.270,1.850,1.820,0.156,
1.210,1.830,1.540,1.360,1.710,3.370,2.410,1.360,0.933,1.890,
1.280,0.867,0.750,1.100,1.510,0.131,0.844,1.120,1.650,1.300,
1.100,2.280,1.850,1.270,0.908,1.370,1.190,1.110,0.926,1.080,
1.230,0.110,0.933,1.260,1.300,1.500,1.170,1.870,1.560,1.270,
1.080,1.540,0.104,0.097,0.077,0.112,1.480,0.124,0.930,1.360,
1.200,1.440,1.370,2.040,2.000,1.190,0.983,1.910,1.640,1.050,
0.823,0.858,1.860,0.121,1.190,1.980,2.340,1.890,2.060,4.340,
4.410,2.600,1.960,3.300,2.090,1.550,1.100,1.890,2.130,0.181,
1.180,1.540,2.000,1.430,1.060,2.070,3.120,2.480,1.380,2.020,
2.190,1.700,1.500,1.710,2.220,0.239,2.500,2.020,1.730,2.230,
1.460,2.430,2.120,2.320,1.480,2.260,0.201,0.234,0.167,0.334,
1.670,0.183,1.090,1.750,1.250,2.040,1.490,2.280,2.370,1.560,
1.140,2.370,2.020,1.580,1.180,1.990,2.050,0.201,1.500,2.570,
2.390,1.900,2.370,4.520,0.291,0.229,0.127,0.221,0.269,0.203,
0.120,0.189,0.144,0.027,0.106,0.140,0.152,0.172,0.097,0.198,
0.278,0.266,0.105,0.155,0.516,0.249,0.155,0.182,0.186,0.034,
0.229,0.202,0.148,0.203,0.124,0.205,0.162,0.212,0.098,0.168,
0.025,0.035,0.025,0.025,0.157,0.035,0.132,0.206,0.118,0.213,
0.138,0.212,0.246,0.174,0.107,0.251,0.336,0.269,0.158,0.263,
0.192,0.027,0.141,0.388,0.224,0.215,0.195,0.406,3.170,2.020,
1.330,1.760,2.370,2.130,1.810,2.060,1.970,0.309,1.600,1.870,
1.590,1.770,1.530,2.510,0.196,0.216,0.128,0.142,0.200,0.262,
0.212,0.192,0.188,0.041,0.332,0.214,0.194,0.280,0.193,0.258,
2.410,3.030,1.800,1.970,0.237,0.360,0.253,0.243,2.290,0.304,
1.260,1.810,1.410,2.380,1.900,2.340,2.070,1.730,1.210,1.710,
2.370,2.600,1.950,2.270,2.530,0.265,2.480,3.010,2.060,2.130,
2.720,3.730,3.150,1.840,1.240,2.170,1.960,1.550,1.110,1.430,
1.660,0.182,1.260,1.700,1.810,1.620,1.200,2.730,2.850,2.380,
1.720,1.970,2.180,2.410,1.620,1.670,2.170,0.220,2.210,2.550,
2.030,2.700,1.870,2.850,2.710,2.910,1.720,2.340,0.191,0.239,
0.153,0.209,2.460,0.244,1.980,2.160,2.160,3.380,2.520,3.220,
2.680,1.690,1.450,2.140,2.040,1.840,1.360,1.820,2.650,0.213,
2.680,2.080,2.990,2.980,3.270,4.960,9.070,3.070,2.160,4.890,
2.700,1.510,1.250,2.330,2.190,0.189,1.080,1.650,2.980,2.080,
1.500,3.490,3.000,1.660,1.040,1.730,2.120,1.140,0.919,1.260,
1.450,0.116,1.150,1.380,1.390,1.210,0.997,1.830,2.500,2.170,
1.280,2.660,0.184,0.163,0.098,0.283,1.560,0.142,0.919,1.680,
1.510,1.760,1.260,2.300,3.800,2.020,1.630,3.800,2.210,1.480,
1.330,2.490,2.290,0.175,1.430,2.530,3.520,2.560,2.740,6.880,
4.860,2.540,1.580,2.860,3.470,1.950,1.330,1.990,1.750,0.185,
1.040,1.560,1.910,1.690,1.190,2.500,4.020,2.330,1.230,1.740,
7.260,2.440,1.450,1.810,1.830,0.155,1.310,1.830,1.520,1.480,
1.050,1.970,2.320,2.240,1.270,2.340,0.232,0.187,0.094,0.193,
1.910,0.184,1.270,2.080,1.710,2.200,1.630,2.680,2.870,1.670,
1.350,2.640,2.490,1.750,1.420,2.290,2.190,0.191,1.410,2.680,
2.450,2.180,2.160,4.210,4.210,2.110,1.650,2.430,2.920,1.960,
1.770,2.520,2.490,0.271,1.470,2.220,2.480,2.060,1.800,3.700,
0.219,0.170,0.105,0.167,0.323,0.189,0.140,0.176,0.160,0.022,
0.140,0.186,0.208,0.210,0.158,0.281,2.760,2.490,1.780,2.570,
0.191,0.170,0.146,0.251,2.650,0.248,1.830,2.440,2.080,2.500,
2.480,3.470,3.170,2.040,1.700,2.730,3.000,2.410,2.130,3.380,
3.260,0.243,2.760,3.940,3.060,2.550,3.570,5.510,8.650,3.050,
2.090,4.370,2.740,1.730,1.380,2.370,2.770,0.228,1.490,2.620,
4.150,2.850,2.290,6.500,3.570,2.340,1.510,2.320,2.430,1.970,
1.360,1.920,2.630,0.164,1.650,2.600,2.800,2.440,1.900,3.740,
3.880,2.990,2.130,3.710,0.207,0.191,0.120,0.280,3.370,0.242,
2.480,3.820,3.490,3.800,3.500,5.630,8.610,2.610,2.260,5.520,
3.420,2.400,1.870,3.940,4.130,0.234,3.140,5.560,4.570,3.670,
4.600,11.1,14.7,7.690,4.900,13.8,9.000,4.800,3.840,6.060,
9.840,0.797,3.660,6.210,20.0,10.3,5.860,12.1,8.730,4.360,
3.290,4.790,4.780,2.530,2.420,2.710,5.210,0.305,2.460,3.310,
5.290,3.600,2.540,5.340,9.110,5.040,3.890,6.970,0.599,0.388,
0.286,0.718,4.590,0.354,2.140,3.310,5.060,4.450,3.040,5.210,
19.4,6.230,6.400,14.2,8.690,5.470,4.310,8.390,6.260,0.455,
3.210,5.090,10.7,5.520,5.270,10.3,11.7,4.460,3.420,5.150,
4.630,2.530,1.880,2.370,4.920,0.386,1.570,2.540,4.640,3.710,
1.730,3.650,5.470,2.670,1.750,2.470,2.780,1.620,1.390,1.460,
2.720,0.184,1.260,1.750,2.280,1.800,1.190,2.010,4.820,3.100,
2.030,3.120,0.280,0.175,0.130,0.247,2.780,0.213,1.260,1.950,
2.450,2.770,1.460,2.530,4.340,2.540,2.000,3.800,3.250,2.070,
1.630,2.500,3.050,0.200,1.490,2.540,3.560,2.710,2.030,4.550,
9.200,3.350,2.800,4.470,4.490,2.140,2.000,2.680,5.140,0.476,
1.640,3.040,5.570,3.800,2.550,6.140,0.528,0.288,0.210,0.337,
0.334,0.220,0.173,0.252,0.320,0.032,0.154,0.278,0.544,0.503,
0.283,0.603,3.110,2.120,1.760,2.420,0.209,0.134,0.121,0.233,
2.290,0.170,1.030,1.520,1.950,1.810,1.560,2.270,3.300,2.070,
1.800,3.390,3.010,2.120,1.720,2.850,2.890,0.216,1.690,2.720,
3.040,2.460,2.420,4.680,26.1,5.660,4.340,9.710,5.020,2.490,
2.480,3.280,7.210,0.612,2.410,4.460,11.7,6.110,4.090,12.1,
9.170,4.240,3.010,4.720,4.970,2.580,2.270,3.140,4.570,0.270,
2.310,4.080,6.120,4.520,3.240,7.090,4.450,3.020,2.450,4.140,
0.275,0.198,0.157,0.307,2.890,0.173,1.640,2.420,3.180,2.860,
2.570,3.800,7.740,3.890,3.910,8.370,3.690,2.550,2.220,3.980,
4.810,0.275,2.860,4.540,7.600,4.850,4.540,9.220,9.470,4.130,
3.180,5.730,3.540,1.950,1.660,2.240,3.160,0.270,1.180,2.200,
4.070,3.010,1.740,3.680,3.880,2.100,1.430,2.140,2.010,1.130,
1.030,1.240,1.820,0.160,0.953,1.570,1.590,1.430,0.911,1.910,
2.910,2.180,1.480,2.510,0.198,0.161,0.104,0.237,1.290,0.123,
0.852,1.350,1.400,1.500,0.972,1.910,3.230,1.590,1.570,2.870,
2.300,1.540,1.220,2.010,1.870,0.136,0.927,1.610,2.520,1.520,
1.370,3.330,5.490,2.800,1.710,2.580,2.350,1.510,1.090,1.300,
2.160,0.171,0.727,1.270,1.940,1.670,0.798,1.800,2.380,1.410,
0.887,1.350,1.220,0.732,0.751,0.820,1.340,0.101,0.638,1.030,
0.938,0.957,0.654,1.030,2.170,1.840,1.040,1.540,0.122,0.121,
0.070,0.108,1.350,0.166,0.632,0.975,1.050,1.450,0.701,1.300,
1.890,1.200,0.818,1.520,1.380,1.040,0.637,1.060,1.580,0.104,
0.615,1.190,1.300,1.100,0.722,1.870,4.350,1.950,1.480,2.330,
2.380,1.390,1.250,1.560,2.340,0.232,0.898,1.650,2.340,1.870,
1.250,2.930,0.197,0.169,0.094,0.154,0.121,0.130,0.091,0.106,
0.124,0.018,0.088,0.138,0.165,0.217,0.108,0.228,2.070,2.120,
2.010,1.730,0.139,0.155,0.088,0.126,1.270,0.116,0.787,1.100,
1.030,1.280,1.050,1.480,1.550,0.929,0.902,1.550,1.430,1.130,
0.875,1.310,1.290,0.097,0.962,1.400,1.310,1.070,1.290,2.320,
4.870,1.790,1.500,2.830,2.020,1.160,0.937,1.300,1.900,0.154,
0.745,1.420,2.590,1.610,1.100,2.900,3.060,2.080,1.230,1.890,
1.790,1.480,0.975,1.300,1.300,0.113,0.832,1.640,1.490,1.480,
0.969,2.190,1.810,1.450,1.160,1.790,0.104,0.088,0.061,0.113,
0.947,0.071,0.618,1.030,1.060,1.080,0.944,1.560,2.420,1.220,
1.200,2.310,1.510,1.040,0.831,1.480,1.630,0.101,1.010,1.890,
2.350,1.750,1.680,3.540,7.020,3.190,2.430,4.630,2.570,1.520,
1.210,2.080,3.260,0.270,1.160,1.970,4.180,2.630,1.370,3.160,
3.910,2.080,1.340,2.330,1.790,1.040,1.090,1.250,2.410,0.186,
1.170,1.710,2.070,1.860,1.020,1.890,2.750,2.180,1.530,2.660,
0.230,0.203,0.137,0.316,1.620,0.152,0.735,1.270,1.560,1.840,
0.985,2.050,3.770,1.730,1.700,3.710,2.340,1.690,1.320,2.250,
2.360,0.198,1.110,2.150,3.080,2.100,2.020,5.650,0.472,0.279,
0.176,0.306,0.287,0.210,0.116,0.176,0.241,0.031,0.098,0.165,
0.276,0.271,0.120,0.246,0.258,0.170,0.103,0.149,0.168,0.142,
0.098,0.114,0.175,0.021,0.120,0.155,0.161,0.172,0.089,0.155,
0.198,0.185,0.110,0.193,0.019,0.020,0.015,0.021,0.177,0.030,
0.094,0.125,0.144,0.200,0.096,0.186,0.366,0.206,0.174,0.391,
0.318,0.265,0.177,0.318,0.238,0.023,0.151,0.253,0.300,0.242,
0.208,0.521,3.070,1.630,1.080,1.660,1.740,1.140,1.080,1.300,
2.110,0.221,0.971,1.510,1.750,1.410,1.100,1.960,0.198,0.156,
0.074,0.131,0.097,0.097,0.079,0.086,0.131,0.020,0.074,0.106,
0.169,0.162,0.093,0.158,1.640,1.430,0.888,1.260,0.122,0.104,
0.070,0.112,1.270,0.111,0.586,0.785,0.961,1.110,0.733,1.100,
1.720,1.030,0.892,1.370,1.500,1.080,0.887,1.240,1.590,0.140,
0.992,1.410,1.360,1.350,1.150,2.020,3.430,1.520,1.240,2.440,
1.710,0.936,0.792,1.160,1.930,0.146,0.874,1.560,2.590,1.570,
1.040,2.700,3.210,1.800,1.200,1.950,1.710,1.240,1.070,1.210,
1.830,0.124,1.030,1.580,1.980,1.660,1.110,2.000,2.040,1.670,
1.310,1.930,0.147,0.124,0.089,0.150,1.450,0.111,0.919,1.280,
1.450,1.490,1.140,1.990,2.560,1.380,1.460,2.310,1.930,1.370,
1.330,1.780,2.290,0.166,1.510,2.400,3.120,2.330,2.210,4.730,
14.7,5.140,3.770,9.270,3.640,1.850,1.800,2.570,4.840,0.379,
1.760,3.150,15.8,5.110,2.940,7.480,4.250,2.050,1.490,2.810,
1.950,1.030,1.060,1.550,2.900,0.178,1.680,2.540,3.310,2.080,
1.460,2.780,4.120,2.660,1.850,4.590,0.275,0.204,0.142,0.420,
2.200,0.172,0.977,2.110,2.470,2.210,1.340,3.120,6.210,2.750,
2.850,9.130,3.130,1.900,1.940,3.840,3.180,0.232,1.890,3.260,
5.530,3.320,4.000,9.190,6.560,3.050,2.090,4.040,3.450,1.890,
1.360,2.060,3.220,0.255,1.310,2.290,4.070,2.940,1.470,3.100,
3.500,1.780,1.120,1.930,1.970,1.170,0.871,1.190,2.190,0.170,
1.450,2.040,2.030,1.800,0.974,1.940,2.760,1.910,1.240,2.770,
0.156,0.115,0.077,0.184,2.030,0.176,1.020,1.870,2.030,2.280,
1.080,2.470,3.690,1.840,1.620,4.160,2.520,1.740,1.350,2.720,
2.540,0.164,1.590,2.610,3.150,2.340,2.010,4.880,4.230,2.120,
1.520,2.720,2.630,1.440,1.290,1.940,3.110,0.306,1.360,2.230,
3.240,2.460,1.810,3.420,0.247,0.162,0.107,0.205,0.149,0.107,
0.097,0.138,0.201,0.022,0.143,0.231,0.265,0.250,0.151,0.267,
2.240,1.920,1.240,2.080,0.142,0.092,0.085,0.161,2.850,0.168,
1.310,1.480,1.870,1.560,1.310,2.120,2.520,1.540,1.330,2.560,
2.260,1.420,1.310,2.470,2.730,0.181,1.580,2.610,2.730,1.900,
1.870,3.850,7.880,3.000,2.470,5.280,3.070,1.730,1.780,2.230,
4.010,0.302,1.690,3.060,6.740,3.620,2.760,7.860,3.710,1.970,
1.460,2.710,2.190,1.260,1.240,1.670,2.370,0.137,1.440,2.440,
3.160,2.370,1.680,3.690,3.960,3.000,2.270,3.920,0.222,0.153,
0.116,0.237,3.020,0.174,1.640,2.580,3.380,3.040,2.280,4.080,
7.710,3.330,3.320,8.130,4.330,2.890,2.530,4.510,5.370,0.245,
3.160,5.750,9.900,5.560,5.580,12.9,9.440,4.820,4.170,7.430,
4.330,2.460,2.040,2.940,4.290,0.392,1.660,2.920,6.300,4.580,
2.320,4.760,4.010,2.540,1.660,2.320,2.480,1.400,1.210,1.360,
2.270,0.158,1.200,1.600,2.170,1.880,1.200,2.170,2.810,2.010,
1.570,2.540,0.221,0.152,0.114,0.249,1.530,0.126,0.750,1.130,
1.880,1.780,1.120,2.050,3.970,2.100,1.800,3.990,2.970,1.960,
1.380,2.510,2.380,0.192,1.100,1.930,3.320,2.190,2.120,4.160,
5.460,2.790,1.800,2.760,3.120,1.700,1.130,1.420,2.910,0.405,
0.954,1.450,2.520,2.450,0.970,2.130,2.610,1.670,0.826,1.200,
1.520,0.921,0.659,0.815,1.510,0.139,0.807,1.200,1.170,1.290,
0.661,1.260,1.930,1.560,0.912,1.280,0.244,0.102,0.077,0.122,
1.320,0.123,0.682,0.992,1.220,1.460,0.807,1.330,1.750,1.190,
0.756,1.470,1.790,1.170,0.709,1.150,1.390,0.116,0.748,1.390,
1.520,1.520,1.060,2.290,3.530,1.620,1.140,2.100,2.230,1.180,
0.980,1.360,2.670,0.266,0.819,1.640,2.410,1.720,1.150,2.810,
0.221,0.175,0.095,0.170,0.178,0.158,0.115,0.148,0.199,0.029,
0.090,0.156,0.211,0.283,0.124,0.250,1.720,1.010,0.820,1.170,
0.119,0.086,0.082,0.118,0.985,0.088,0.522,0.753,0.932,0.843,
0.683,0.960,1.520,0.934,0.741,1.410,1.550,1.270,0.810,1.280,
1.270,0.123,0.754,1.250,1.290,1.200,1.130,2.190,4.330,1.900,
1.540,3.060,3.740,1.130,0.898,1.210,2.830,0.265,0.900,1.610,
4.020,2.040,1.350,3.540,3.180,2.180,1.280,2.230,2.190,1.350,
1.080,1.380,2.110,0.142,0.966,1.720,2.030,1.840,1.100,2.250,
1.800,1.110,0.914,1.530,0.137,0.074,0.075,0.122,1.020,0.076,
0.588,0.918,1.170,1.100,0.931,1.450,2.700,1.430,1.090,2.580,
1.520,1.060,0.942,1.500,2.210,0.146,1.120,2.020,2.910,2.260,
2.120,4.580,5.200,2.720,1.930,3.280,2.940,1.740,1.340,1.760,
1.800,0.190,0.732,1.310,2.450,2.030,1.050,2.430,2.570,1.720,
1.030,1.470,1.640,1.010,0.904,1.040,1.180,0.136,0.693,1.080,
1.020,1.340,0.703,1.340,1.410,1.290,0.876,1.310,0.109,0.107,
0.072,0.137,0.785,0.085,0.556,0.773,0.815,1.030,0.676,1.260,
1.650,1.020,0.783,1.710,1.380,1.110,0.780,1.260,1.050,0.094,
0.584,1.090,1.560,1.190,1.090,2.330,2.810,1.730,0.845,1.410,
1.980,1.310,0.695,0.927,1.120,0.120,0.487,0.783,1.110,1.110,
0.509,1.210,1.490,0.977,0.456,0.686,0.639,0.183,0.341,0.396,
0.718,0.098,0.453,0.748,0.553,0.802,0.496,0.714,1.010,1.130,
0.637,0.850,0.088,0.099,0.052,0.082,0.778,0.111,0.446,0.803,
0.623,1.060,0.545,0.944,0.989,0.748,0.482,0.808,0.943,0.913,
0.458,0.740,0.807,0.083,0.437,1.320,0.856,0.993,0.626,1.620,
2.660,1.330,0.860,1.410,1.860,1.230,0.886,1.160,1.700,0.301,
0.755,1.130,1.490,2.250,0.847,1.840,0.128,0.145,0.066,0.112,
0.102,0.127,0.082,0.095,0.168,0.070,0.194,0.109,0.142,0.663,
0.100,0.125,1.140,1.230,0.736,0.965,0.108,0.233,0.067,0.107,
0.760,0.090,0.547,0.713,0.622,0.913,0.890,0.939,0.993,0.624,
0.537,0.994,1.160,1.170,0.701,1.060,0.977,0.088,0.575,0.997,
0.940,0.868,0.904,1.680,2.460,1.250,0.853,1.570,1.520,0.894,
0.591,0.992,1.300,0.115,0.521,0.966,1.790,1.260,0.701,1.780,
1.660,1.220,0.746,1.130,1.180,1.030,0.649,0.892,1.050,0.152,
0.650,1.070,0.986,1.750,0.639,1.230,1.080,0.976,0.701,1.020,
0.069,0.078,0.045,0.076,0.609,0.053,0.459,0.682,0.702,0.843,
0.681,1.080,1.380,0.759,0.630,1.330,1.020,0.760,0.590,0.984,
1.000,0.075,0.586,1.110,1.480,1.340,1.120,2.510,4.240,2.550,
1.550,2.840,2.930,1.320,0.919,1.510,2.360,0.210,0.884,1.410,
2.560,2.080,0.947,2.090,2.550,1.870,0.901,1.550,1.500,1.110,
0.852,1.130,2.370,0.209,1.300,1.700,1.500,1.830,0.854,1.600,
1.800,1.770,1.040,1.830,0.171,0.159,0.095,0.228,1.320,0.140,
0.714,1.230,1.190,1.480,0.811,1.830,1.930,1.240,0.903,2.160,
1.520,1.290,0.877,1.610,1.710,0.155,0.917,1.680,2.080,1.450,
1.420,3.500,0.287,0.163,0.084,0.156,0.470,0.154,0.081,0.132,
0.157,0.024,0.069,0.104,0.159,0.166,0.085,0.166,0.135,0.115,
0.053,0.086,0.125,0.140,0.071,0.089,0.149,0.027,0.091,0.130,
0.093,0.142,0.074,0.115,0.110,0.127,0.075,0.112,0.022,0.019,
0.014,0.016,0.175,0.030,0.088,0.118,0.094,0.149,0.092,0.138,
0.157,0.108,0.071,0.174,0.186,0.162,0.096,0.164,0.136,0.016,
0.087,0.162,0.155,0.133,0.121,0.259,2.910,1.870,1.000,1.350,
1.530,1.460,0.818,1.130,1.900,0.241,0.869,1.350,1.360,1.290,
0.998,1.890,0.149,0.146,0.065,0.097,0.097,0.247,0.075,0.082,
0.107,0.021,0.081,0.100,0.103,0.152,0.080,0.123,0.999,1.180,
0.685,0.904,0.083,0.108,0.060,0.100,1.050,0.120,0.493,0.783,
0.700,1.010,0.676,1.030,1.040,0.844,0.745,1.000,1.080,1.100,
0.706,1.030,1.270,0.145,0.940,1.200,1.050,1.030,1.010,1.660,
2.320,1.260,1.120,1.860,1.440,0.858,0.613,0.959,1.600,0.128,
0.771,1.310,1.870,1.190,0.850,2.130,1.990,1.530,0.822,1.320,
1.510,2.020,0.777,1.060,1.470,0.133,0.920,1.400,1.380,1.520,
0.892,1.580,1.280,1.320,1.600,1.550,0.106,0.097,0.098,0.119,
1.140,0.099,0.835,1.170,1.100,1.380,1.010,1.740,1.530,1.090,
0.903,1.520,1.530,0.932,0.740,1.090,1.640,0.120,1.190,1.810,
2.090,1.750,1.610,2.860,4.270,1.880,1.510,3.530,2.060,0.966,
1.030,2.070,2.100,0.166,0.858,1.640,3.180,1.730,1.070,2.680,
1.970,1.180,0.769,1.490,1.120,0.683,0.779,1.430,1.280,0.094,
0.857,1.260,1.340,0.971,0.716,1.500,1.540,1.280,0.769,1.710,
0.096,0.090,0.062,0.181,0.984,0.090,0.626,1.240,1.050,1.260,
0.792,1.610,2.260,1.280,1.080,3.120,1.280,0.887,0.792,1.780,
1.430,0.102,0.766,1.750,2.340,1.500,2.110,4.070,3.240,1.530,
1.020,1.890,2.920,1.170,0.892,1.410,1.660,0.153,0.689,1.330,
1.850,1.630,0.727,1.830,1.690,1.080,0.546,0.953,1.280,0.881,
0.542,0.814,1.380,0.200,0.685,1.400,1.140,1.380,0.592,1.590,
1.040,1.000,0.544,1.050,0.090,0.076,0.041,0.099,1.150,0.134,
0.608,1.360,1.030,1.640,0.644,1.470,1.370,0.867,0.654,1.590,
1.260,1.010,0.653,1.370,1.330,0.097,0.742,1.480,1.520,1.330,
1.070,2.470,2.360,1.250,0.947,1.590,1.220,0.871,0.682,1.070,
1.880,0.192,1.070,1.460,1.640,1.350,1.170,2.200,0.109,0.085,
0.057,0.106,0.070,0.087,0.063,0.077,0.096,0.011,0.064,0.097,
0.114,0.129,0.076,0.141,0.985,0.968,0.573,1.060,0.063,0.062,
0.043,0.099,1.400,0.096,0.601,1.010,0.914,0.954,0.738,1.210,
1.210,0.896,0.732,1.370,1.130,0.870,0.665,1.280,1.500,0.143,
0.962,1.630,1.380,1.140,1.250,2.300,2.780,1.480,1.370,2.430,
1.240,0.780,0.684,0.814,1.820,0.180,0.926,1.550,2.260,1.330,
1.160,2.990,1.890,1.130,0.743,1.320,1.360,0.976,0.698,0.987,
1.210,0.079,0.712,1.290,1.530,1.220,0.860,1.960,1.630,1.370,
1.070,1.810,0.111,0.087,0.067,0.124,1.360,0.094,0.823,1.430,
1.550,1.720,1.230,2.100,2.940,1.530,1.480,3.170,2.440,1.680,
1.490,2.090,2.780,0.166,1.700,3.060,4.230,2.900,2.990,4.790,
11.3,3.700,2.960,7.000,4.020,2.090,1.680,2.770,3.820,0.325,
1.250,2.280,5.990,4.110,2.020,4.610,2.910,1.530,1.010,1.860,
1.830,0.996,0.943,1.280,1.720,0.134,0.787,1.140,1.800,1.530,
1.080,1.900,2.550,1.730,1.370,2.510,0.196,0.158,0.115,0.288,
1.450,0.118,0.775,1.310,1.620,1.540,1.170,2.130,3.960,1.710,
1.650,3.780,2.640,2.110,1.350,2.720,2.010,0.154,0.977,1.710,
3.200,1.710,2.020,4.560,5.900,2.590,1.730,3.390,3.140,1.710,
1.270,1.940,2.580,0.251,0.870,1.460,2.850,2.500,1.050,2.630,
2.510,1.600,0.844,1.410,1.510,0.823,0.781,1.100,1.930,0.246,
0.743,1.180,1.460,1.430,0.740,1.410,2.520,1.880,1.200,2.040,
0.194,0.127,0.095,0.192,1.720,0.145,0.792,1.310,1.580,1.500,
0.943,1.610,2.740,1.590,1.160,2.850,2.220,1.660,1.060,2.000,
2.130,0.157,0.813,1.570,2.070,1.710,1.300,2.970,5.040,1.710,
1.290,2.710,3.220,1.640,1.370,2.080,9.220,0.660,1.410,2.090,
5.720,2.900,1.530,3.780,0.327,0.207,0.117,0.239,0.236,0.164,
0.139,0.205,0.452,0.044,0.118,0.201,0.560,0.587,0.176,0.407,
1.880,1.050,1.070,1.670,0.142,0.091,0.082,0.182,1.360,0.123,
0.563,0.918,1.250,1.160,0.688,1.130,1.780,0.846,0.793,1.640,
1.850,1.250,1.120,1.900,1.600,0.125,0.747,1.270,1.910,1.310,
1.220,2.480,6.210,1.920,1.540,3.910,2.730,1.300,1.110,1.900,
6.320,0.468,1.290,2.220,9.210,3.810,1.760,5.650,3.410,1.660,
1.160,2.040,2.080,1.190,1.030,1.440,3.220,0.224,1.010,1.940,
4.010,3.030,1.330,3.020,2.060,1.410,1.290,2.240,0.158,0.097,
0.102,0.218,1.550,0.118,0.803,1.400,1.840,1.700,1.290,2.260,
3.560,1.580,1.530,4.140,2.040,1.270,1.440,2.720,3.020,0.208,
1.520,3.180,5.550,3.470,3.640,8.720,0.699,0.291,0.198,0.406,
0.329,0.203,0.150,0.258,0.259,0.027,0.084,0.159,0.330,0.290,
0.140,0.352,0.260,0.172,0.108,0.177,0.188,0.123,0.132,0.166,
0.146,0.015,0.081,0.124,0.150,0.158,0.100,0.185,0.209,0.162,
0.125,0.207,0.024,0.020,0.015,0.033,0.112,0.014,0.087,0.121,
0.112,0.148,0.102,0.188,0.259,0.152,0.142,0.297,0.241,0.204,
0.158,0.261,0.195,0.019,0.112,0.180,0.234,0.163,0.195,0.417,
0.413,0.251,0.158,0.276,0.272,0.206,0.127,0.208,0.194,0.025,
0.071,0.126,0.191,0.197,0.089,0.205,0.224,0.179,0.096,0.143,
0.167,0.115,0.113,0.175,0.153,0.022,0.079,0.139,0.108,0.134,
0.078,0.132,0.210,0.187,0.121,0.179,0.024,0.022,0.017,0.022,
0.166,0.032,0.093,0.136,0.116,0.169,0.102,0.172,0.242,0.158,
0.110,0.268,0.237,0.186,0.126,0.199,0.181,0.014,0.091,0.179,
0.165,0.151,0.131,0.374,0.386,0.156,0.109,0.191,0.257,0.171,
0.147,0.186,0.389,0.050,0.111,0.143,0.316,0.258,0.129,0.291,
0.020,0.018,0.012,0.017,0.018,0.021,0.020,0.018,0.025,0.011,
0.018,0.018,0.028,0.046,0.015,0.027,0.164,0.141,0.121,0.167,
0.015,0.021,0.015,0.022,0.141,0.026,0.079,0.113,0.101,0.159,
0.099,0.135,0.179,0.087,0.096,0.172,0.182,0.151,0.145,0.209,
0.147,0.015,0.102,0.145,0.161,0.138,0.149,0.295,0.574,0.316,
0.231,0.413,0.303,0.196,0.150,0.234,0.457,0.045,0.144,0.232,
0.901,0.455,0.241,0.630,0.433,0.275,0.191,0.293,0.338,0.262,
0.210,0.264,0.387,0.039,0.168,0.259,0.509,0.640,0.203,0.415,
0.212,0.165,0.148,0.235,0.018,0.022,0.016,0.025,0.168,0.016,
0.124,0.163,0.173,0.197,0.164,0.264,0.385,0.187,0.176,0.384,
0.275,0.175,0.173,0.300,0.292,0.020,0.186,0.332,0.460,0.335,
0.342,0.782,4.100,1.860,1.210,2.400,1.790,1.180,0.811,1.380,
1.580,0.150,0.724,1.160,1.690,1.270,0.784,1.760,1.900,1.250,
0.761,1.200,1.330,0.895,0.910,0.951,1.460,0.137,0.941,1.320,
1.110,1.120,0.792,1.320,1.810,1.870,1.350,2.280,0.181,0.175,
0.141,0.313,1.430,0.141,0.758,1.350,1.120,1.590,0.886,1.710,
1.930,1.140,1.030,2.180,1.430,1.110,1.050,1.690,1.620,0.136,
0.851,1.840,1.680,1.190,1.500,3.210,0.247,0.163,0.090,0.180,
0.172,0.162,0.084,0.136,0.116,0.020,0.058,0.097,0.125,0.134,
0.066,0.156,0.127,0.106,0.053,0.080,0.105,0.109,0.071,0.083,
0.101,0.013,0.083,0.099,0.080,0.082,0.052,0.089,0.122,0.148,
0.086,0.163,0.015,0.020,0.016,0.019,0.102,0.020,0.079,0.112,
0.087,0.117,0.075,0.123,0.212,0.126,0.100,0.264,0.180,0.166,
0.115,0.212,0.148,0.014,0.081,0.175,0.141,0.119,0.126,0.281,
2.220,1.310,0.808,1.100,1.670,1.320,1.160,1.360,1.530,0.196,
0.824,1.150,1.090,1.070,0.865,1.620,0.149,0.202,0.074,0.091,
0.107,0.126,0.150,0.083,0.111,0.019,0.101,0.116,0.116,0.139,
0.080,0.133,1.270,0.984,0.798,0.988,0.116,0.085,0.081,0.127,
0.892,0.100,0.305,0.553,0.566,0.718,0.580,0.830,1.010,0.636,
0.547,0.802,1.070,0.870,0.763,1.030,0.967,0.101,0.779,1.030,
0.835,0.848,0.993,1.600,2.060,1.150,0.939,1.810,1.450,1.200,
0.681,0.950,1.440,0.154,0.884,1.300,1.660,1.170,0.788,1.740,
1.860,1.500,0.836,1.170,1.430,1.270,1.140,0.979,1.380,0.124,
0.955,1.290,1.700,1.440,0.864,1.500,1.690,1.250,0.959,1.490,
0.125,0.115,0.091,0.144,1.140,0.093,0.896,1.220,1.010,1.200,
0.968,1.480,1.630,0.884,0.772,1.460,1.290,0.953,0.810,1.210,
1.510,0.114,1.140,1.670,1.790,1.470,1.500,2.680,4.110,1.630,
1.180,2.700,1.570,0.886,0.815,1.400,1.690,0.158,0.678,1.180,
2.260,1.420,0.917,2.310,1.860,0.977,0.649,1.120,0.945,0.557,
0.595,0.824,1.200,0.075,0.519,0.987,0.966,0.703,0.603,1.140,
1.880,1.370,1.050,1.890,0.135,0.099,0.122,0.222,1.050,0.092,
0.617,1.120,1.260,1.150,0.982,1.630,2.520,1.190,1.390,3.170,
1.510,0.886,1.380,1.990,1.390,0.098,0.725,1.440,2.280,1.250,
1.710,3.610,3.420,1.870,1.220,2.650,1.920,1.370,0.970,1.550,
1.620,0.143,0.730,1.320,1.840,1.580,0.754,2.230,1.900,1.320,
0.684,1.240,1.280,1.040,0.727,1.000,1.300,0.097,0.799,1.230,
0.991,0.925,0.613,1.210,1.560,1.410,0.885,1.800,0.101,0.100,
0.102,0.149,1.260,0.112,0.818,1.370,1.250,1.390,0.908,1.780,
2.150,1.330,1.230,2.820,1.700,1.270,1.140,1.980,1.550,0.114,
0.837,1.710,1.800,1.410,1.380,3.200,2.380,1.330,1.150,1.650,
1.650,1.160,1.030,1.480,1.630,0.177,0.805,1.290,1.510,1.290,
1.040,2.140,0.153,0.134,0.072,0.129,0.106,0.138,0.092,0.116,
0.108,0.015,0.082,0.118,0.120,0.141,0.086,0.160,1.260,1.260,
0.865,1.350,0.089,0.078,0.065,0.143,1.190,0.105,0.655,1.020,
0.922,1.080,0.920,1.360,1.450,0.881,0.842,1.440,1.460,1.050,
1.050,1.620,1.340,0.106,0.982,1.520,1.520,1.190,1.510,2.470,
3.540,1.600,1.420,2.720,1.740,1.270,0.947,1.280,2.120,0.258,
1.020,1.760,2.210,1.400,1.130,3.110,2.280,1.380,0.856,1.560,
1.490,1.140,0.955,1.200,1.520,0.096,0.866,1.510,1.670,1.300,
0.994,2.080,2.180,1.760,1.260,2.280,0.162,0.138,0.096,0.206,
1.750,0.137,1.150,1.940,1.810,1.860,1.540,2.390,3.700,1.560,
1.500,3.520,2.380,1.700,1.440,2.450,2.710,0.169,1.760,3.190,
4.200,2.600,2.880,5.550,11.5,5.000,4.730,11.6,5.130,2.380,
2.250,3.780,5.550,0.385,1.840,3.560,10.4,5.790,2.960,7.460,
4.130,1.700,1.460,2.620,2.220,1.080,1.020,1.470,2.470,0.137,
1.110,1.600,2.640,1.860,1.020,2.120,3.680,1.950,1.740,3.840,
0.257,0.143,0.115,0.330,2.060,0.138,0.987,1.730,2.420,1.890,
1.330,2.990,6.620,2.700,2.960,8.040,3.780,2.090,1.860,3.760,
3.430,0.216,1.710,3.040,6.130,3.090,3.150,8.790,5.600,2.180,
1.640,3.200,2.790,1.140,0.848,1.420,2.440,0.184,0.860,1.380,
3.950,2.220,1.100,2.520,2.400,1.230,0.825,1.410,1.170,0.593,
0.575,0.877,1.500,0.105,0.678,1.010,1.760,1.080,0.703,1.280,
2.320,1.500,1.120,2.020,0.168,0.087,0.063,0.140,1.590,0.094,
0.630,1.130,1.740,1.300,0.886,1.620,2.830,1.490,1.230,3.110,
1.930,1.040,0.783,1.630,2.060,0.112,0.835,1.630,2.510,1.750,
1.330,3.530,6.340,2.110,1.810,3.850,3.290,1.410,1.320,2.580,
7.830,0.549,1.590,2.230,8.800,3.590,1.810,5.290,0.351,0.179,
0.136,0.294,0.215,0.124,0.117,0.212,0.397,0.030,0.118,0.177,
0.876,0.524,0.171,0.419,2.210,1.380,1.480,2.360,0.157,0.077,
0.083,0.202,2.510,0.150,0.806,1.210,2.210,1.490,1.060,1.860,
2.530,1.250,1.360,3.000,2.170,1.150,1.140,2.310,2.210,0.139,
0.977,1.880,3.160,1.860,1.800,4.150,12.4,3.320,3.240,9.450,
4.470,1.900,1.790,3.680,10.7,0.776,2.470,4.060,33.6,9.610,
4.390,13.5,5.320,2.410,2.000,3.560,2.620,1.470,1.430,2.110,
4.820,0.282,1.560,2.510,9.100,5.110,2.110,4.850,3.380,2.000,
1.980,3.640,0.228,0.124,0.123,0.252,2.990,0.158,1.270,2.170,
3.530,2.800,2.100,3.560,6.850,2.870,3.120,8.150,3.460,1.890,
2.030,3.670,5.320,0.285,2.480,5.120,11.6,6.140,5.430,15.8,
7.330,3.180,2.430,5.360,3.370,1.730,1.390,2.310,2.870,0.232,
0.990,1.960,4.210,2.970,1.530,4.170,3.210,1.700,1.200,2.120,
1.890,1.040,0.982,1.380,1.530,0.116,0.861,1.250,1.600,1.530,
0.948,1.810,2.570,1.770,1.450,2.510,0.175,0.128,0.087,0.203,
1.390,0.117,1.010,1.490,1.570,1.660,1.160,2.230,2.780,1.490,
1.500,3.280,2.120,1.440,1.190,2.090,1.970,0.149,1.240,1.880,
2.680,1.630,1.850,4.130,4.560,2.170,1.720,2.750,2.390,1.380,
0.900,1.260,1.800,0.140,0.600,1.100,2.250,1.790,0.779,1.950,
2.180,1.370,0.822,1.300,1.380,0.835,0.688,0.933,1.260,0.095,
0.614,0.990,1.140,1.110,0.619,1.190,2.070,1.640,1.020,1.710,
0.184,0.127,0.071,0.114,1.450,0.144,0.723,1.200,1.490,1.450,
0.911,1.770,2.110,1.390,0.999,2.150,1.860,1.300,0.791,1.380,
1.450,0.090,0.679,1.470,1.600,1.210,1.040,2.970,4.700,1.670,
1.250,2.290,2.590,1.320,1.180,1.800,3.190,0.301,1.110,1.420,
3.890,2.530,1.310,3.400,0.181,0.118,0.080,0.155,0.128,0.106,
0.094,0.158,0.155,0.022,0.088,0.112,0.264,0.306,0.100,0.206,
2.090,1.760,1.270,1.910,0.128,0.099,0.077,0.149,1.530,0.121,
0.714,1.090,1.410,1.520,1.030,1.810,2.210,1.090,1.080,2.050,
1.850,1.250,1.190,1.910,1.700,0.108,0.871,1.470,2.140,1.440,
1.490,3.160,5.900,2.330,1.920,4.030,2.520,1.340,1.150,1.860,
3.990,0.297,1.380,2.000,8.160,4.010,2.040,5.530,3.460,1.900,
1.470,2.410,2.150,1.520,1.290,1.770,2.690,0.212,1.290,1.870,
4.230,4.430,1.560,3.120,2.360,1.690,1.480,2.410,0.145,0.095,
0.071,0.142,1.710,0.108,0.928,1.420,1.980,1.860,1.360,2.550,
3.740,1.690,1.680,3.360,2.780,1.440,1.320,2.170,2.890,0.154,
1.430,2.680,4.640,2.930,2.500,5.920,4.980,2.540,1.670,3.470,
2.160,1.460,1.020,1.880,2.380,0.171,0.881,1.610,3.200,1.890,
1.110,2.640,3.020,1.880,1.190,1.930,1.670,1.120,0.893,1.140,
1.790,0.145,0.948,1.460,1.880,1.710,1.000,1.970,2.550,2.270,
1.570,2.890,0.201,0.185,0.115,0.297,1.800,0.153,0.916,1.770,
1.790,1.940,1.160,2.400,2.590,1.490,1.330,3.230,1.890,1.330,
1.110,2.030,2.190,0.179,1.270,2.440,2.890,1.820,2.010,4.590,
0.274,0.196,0.115,0.226,0.205,0.148,0.079,0.152,0.160,0.018,
0.069,0.127,0.229,0.187,0.105,0.231,0.148,0.116,0.061,0.104,
0.119,0.132,0.066,0.089,0.119,0.013,0.085,0.150,0.127,0.113,
0.070,0.134,0.157,0.232,0.096,0.175,0.017,0.019,0.013,0.017,
0.142,0.017,0.080,0.137,0.146,0.166,0.096,0.182,0.225,0.140,
0.106,0.288,0.233,0.169,0.116,0.196,0.176,0.015,0.094,0.190,
0.229,0.154,0.151,0.345,3.510,1.720,1.120,1.670,2.440,1.540,
1.260,1.680,2.310,0.260,0.979,1.540,2.250,1.830,1.590,2.510,
0.166,0.132,0.067,0.111,0.121,0.112,0.080,0.087,0.123,0.017,
0.084,0.120,0.174,0.201,0.109,0.183,1.660,1.600,1.060,1.690,
0.143,0.113,0.087,0.160,1.540,0.134,0.693,1.150,1.150,1.550,
1.030,1.800,1.730,1.100,0.929,1.600,1.680,1.360,1.090,1.580,
1.840,0.146,1.150,1.710,1.780,1.740,1.780,3.140,3.460,1.660,
1.230,2.480,1.990,1.190,0.903,1.330,2.420,0.178,1.220,1.830,
3.520,1.890,1.740,3.250,3.030,1.940,1.310,2.310,1.880,1.550,
1.140,1.350,2.390,0.155,1.270,1.880,2.600,2.410,1.480,2.770,
2.490,1.850,1.430,2.690,0.146,0.129,0.086,0.173,1.920,0.129,
1.240,1.870,2.010,2.130,1.600,2.780,2.830,1.510,1.440,2.610,
2.040,1.590,1.140,1.740,3.020,0.178,1.830,2.930,3.540,2.790,
2.680,5.000,9.970,3.620,2.850,6.840,3.280,1.750,1.550,2.990,
3.840,0.275,1.640,3.100,7.100,3.250,2.200,5.840,3.910,1.800,
1.470,2.270,1.980,1.070,0.991,1.540,2.260,0.136,1.310,2.000,
2.220,1.520,1.420,2.580,3.380,2.300,1.600,4.000,0.236,0.157,
0.125,0.340,1.990,0.140,0.953,2.010,2.390,2.050,1.630,3.210,
5.320,2.430,2.540,7.550,2.920,1.680,1.790,3.500,3.100,0.192,
1.690,3.640,5.970,3.080,3.780,9.500,4.650,2.340,1.650,3.370,
2.320,1.430,1.150,1.980,2.230,0.172,0.935,1.850,2.970,2.120,
1.220,3.540,2.540,1.480,0.994,1.690,1.590,1.100,0.793,1.190,
1.730,0.117,1.140,1.690,1.640,1.370,0.975,1.900,2.210,1.670,
1.040,2.480,0.114,0.097,0.070,0.161,1.860,0.132,0.930,1.720,
1.990,2.060,1.150,2.590,2.880,1.590,1.520,3.620,2.340,1.520,
1.170,2.350,2.290,0.126,1.150,2.360,3.380,2.170,1.990,4.680,
5.300,2.510,2.050,3.230,3.250,1.920,1.680,2.860,3.980,0.333,
1.450,2.690,4.240,2.940,2.190,4.990,0.261,0.183,0.120,0.220,
0.159,0.137,0.107,0.177,0.193,0.018,0.101,0.191,0.296,0.249,
0.150,0.342,2.790,2.350,1.740,3.760,0.153,0.131,0.095,0.267,
2.510,0.167,1.180,2.010,2.240,2.240,1.770,3.260,3.570,2.410,
1.940,3.740,3.150,2.370,1.950,3.620,3.160,0.192,2.000,3.510,
3.700,2.700,3.090,5.820,11.7,4.440,3.430,7.710,4.280,2.630,
2.060,3.430,5.740,0.376,2.600,5.150,9.600,5.230,3.920,12.4,
6.380,3.470,2.190,4.000,3.750,2.870,1.870,2.860,4.970,0.233,
2.120,4.030,5.340,4.110,2.790,6.540,5.830,4.100,3.100,6.050,
0.253,0.209,0.132,0.333,4.230,0.238,2.470,4.590,5.290,4.700,
3.910,7.070,13.8,5.430,5.140,12.6,6.770,4.590,3.550,6.890,
8.420,0.385,5.220,10.4,14.6,7.650,8.200,13.2,10.4,5.870,
4.390,8.280,6.620,3.780,2.740,3.820,7.030,0.725,2.560,4.220,
8.690,6.780,3.350,6.120,6.790,3.620,2.360,3.200,3.640,2.060,
1.710,1.860,3.660,0.279,1.690,2.310,2.900,2.690,1.730,2.820,
4.790,3.330,2.260,3.470,0.385,0.297,0.219,0.432,2.920,0.283,
1.560,1.890,2.780,3.160,1.850,2.850,7.950,3.400,3.250,6.180,
5.060,3.140,2.500,4.170,4.210,0.367,2.010,3.180,5.020,3.430,
3.040,5.350,8.850,3.580,2.250,3.740,3.980,2.490,1.610,2.130,
3.710,0.396,1.400,2.220,3.080,3.090,1.330,2.710,4.420,2.660,
1.430,2.000,2.470,1.590,1.220,1.250,2.520,0.243,1.220,1.850,
1.670,1.980,1.050,1.640,2.900,2.520,1.440,2.070,0.242,0.209,
0.136,0.217,2.700,0.336,1.320,1.770,1.630,2.490,1.290,2.190,
2.760,1.850,1.380,2.260,2.410,1.790,1.220,1.780,2.660,0.231,
1.380,2.260,2.290,2.070,1.650,3.170,5.270,2.300,1.550,2.590,
3.270,1.660,1.360,1.730,3.170,0.401,1.100,1.960,2.910,2.490,
1.650,3.530,0.474,0.268,0.152,0.224,0.272,0.183,0.142,0.170,
0.265,0.042,0.131,0.218,0.298,0.394,0.182,0.345,1.920,1.550,
1.690,1.440,0.177,0.134,0.118,0.163,1.560,0.256,0.788,1.050,
1.170,1.540,1.030,1.480,2.320,1.240,1.080,1.840,2.110,1.470,
1.130,1.720,2.300,0.225,1.250,1.870,1.720,1.860,1.600,2.820,
8.280,2.950,1.940,4.320,3.050,1.580,1.270,1.770,3.460,0.316,
1.130,2.040,4.580,3.060,1.890,4.980,8.690,3.660,2.060,2.820,
3.940,2.180,1.630,1.750,2.890,0.233,1.370,2.170,2.840,2.810,
1.640,3.190,2.550,1.970,1.580,2.240,0.195,0.146,0.124,0.201,
1.940,0.167,1.050,1.540,1.750,2.070,1.660,2.230,4.460,2.060,
1.810,3.790,2.250,1.620,1.330,2.110,3.270,0.238,1.740,2.960,
3.910,3.450,2.890,6.260,8.340,4.320,2.900,4.840,3.780,2.620,
1.870,2.310,4.180,0.387,1.320,2.560,3.320,3.170,2.060,3.360,
3.920,2.960,1.560,2.130,2.320,1.610,1.350,1.400,1.940,0.216,
1.180,1.730,1.450,1.850,1.130,1.910,2.380,2.460,1.630,2.070,
0.238,0.259,0.160,0.269,1.600,0.180,1.320,1.380,1.340,1.860,
1.440,2.070,3.250,1.710,1.960,2.870,2.690,2.030,1.460,2.020,
2.420,0.238,1.190,2.010,2.470,1.920,1.660,4.270,6.370,3.550,
1.690,2.400,2.570,2.300,1.350,1.470,2.620,0.332,0.973,1.630,
1.850,2.390,0.962,1.980,2.680,2.240,1.010,1.510,1.640,0.953,
0.983,0.996,1.900,0.235,1.040,1.770,1.150,1.770,0.954,1.370,
2.010,2.480,1.260,1.570,0.182,0.266,0.131,0.159,2.280,0.320,
1.180,1.470,1.220,2.410,1.180,1.690,1.760,1.530,0.920,1.480,
1.710,1.700,0.822,1.220,2.610,0.219,0.931,1.740,1.450,1.590,
1.010,2.410,3.250,1.810,1.120,1.640,2.230,1.690,1.230,1.340,
1.850,0.263,0.926,1.290,1.430,1.720,1.090,2.000,0.212,0.261,
0.137,0.168,0.160,0.172,0.133,0.119,0.156,0.043,0.146,0.169,
0.128,0.277,0.130,0.178,1.990,2.030,8.190,2.110,0.320,0.264,
0.305,0.204,1.450,0.184,0.973,1.120,0.855,1.640,1.140,1.280,
1.560,0.961,1.290,1.550,1.810,1.680,1.250,1.600,1.790,0.162,
1.200,1.620,1.140,1.350,1.290,2.000,3.080,1.680,1.060,1.840,
1.620,1.160,0.804,1.020,1.490,0.144,0.632,1.000,1.650,1.370,
0.899,1.950,2.870,2.450,1.250,1.540,1.710,1.420,0.940,1.110,
1.330,0.146,0.899,1.250,1.220,1.960,0.977,1.660,1.620,1.700,
1.650,1.630,0.125,0.130,0.087,0.124,1.260,0.121,0.830,1.170,
1.010,1.450,1.120,1.520,2.340,1.430,1.070,1.820,1.580,1.320,
0.823,1.290,2.340,0.194,1.160,1.890,2.220,2.340,1.840,3.490,
4.800,2.930,1.750,3.170,2.170,1.590,1.060,1.540,2.330,0.265,
0.984,1.680,2.440,2.260,1.070,2.240,3.490,2.860,1.430,2.080,
2.050,1.380,1.330,1.370,2.420,0.256,1.340,1.850,1.670,2.260,
1.130,1.870,2.240,2.340,1.340,2.080,0.271,0.242,0.162,0.311,
1.810,0.196,0.877,1.270,1.270,1.890,0.952,1.660,2.500,1.440,
1.180,2.410,2.410,1.630,1.120,1.750,2.260,0.230,1.070,1.920,
2.410,2.010,1.810,4.370,0.380,0.257,0.120,0.213,0.231,0.229,
0.119,0.227,0.223,0.057,0.098,0.172,0.193,0.356,0.115,0.208,
0.259,0.227,0.108,0.164,0.216,0.210,0.136,0.170,0.231,0.050,
0.140,0.189,0.159,0.306,0.111,0.175,0.149,0.224,0.108,0.155,
0.040,0.038,0.023,0.029,0.203,0.040,0.129,0.152,0.129,0.258,
0.109,0.172,0.209,0.164,0.111,0.223,0.327,0.279,0.173,0.254,
0.274,0.035,0.145,0.236,0.235,0.245,0.182,0.399,2.160,1.590,
0.902,1.240,1.530,1.240,1.050,1.090,1.940,0.308,0.916,1.220,
1.280,1.440,1.000,1.490,0.175,0.187,0.094,0.121,0.113,0.136,
0.115,0.090,0.162,0.036,0.123,0.138,0.156,0.256,0.126,0.141,
1.520,1.860,1.010,1.130,0.143,0.156,0.114,0.128,1.350,0.181,
0.673,0.910,0.800,1.420,0.887,1.080,1.540,1.030,0.759,0.993,
1.410,1.400,1.000,1.190,2.030,0.252,1.240,1.510,1.310,1.940,
1.350,1.970,2.410,1.390,0.844,1.710,1.300,0.810,0.650,0.890,
1.530,0.167,0.679,1.240,1.860,1.400,0.876,1.990,2.490,1.800,
1.210,1.660,1.590,1.320,1.130,1.260,1.890,0.189,1.140,1.570,
2.040,2.040,1.180,1.740,1.720,1.910,1.290,1.640,0.155,0.165,
0.119,0.159,1.660,0.162,1.030,1.380,1.220,1.670,1.190,1.670,
2.180,1.300,1.180,1.670,1.760,1.440,1.250,1.480,2.450,0.224,
1.670,2.370,2.440,2.590,2.080,3.840,6.050,3.040,1.920,4.200,
1.920,1.250,0.984,1.320,2.170,0.233,0.887,1.590,3.580,2.650,
1.350,3.020,2.520,1.520,0.971,1.880,1.330,0.773,0.747,0.976,
1.550,0.151,0.774,1.370,1.440,1.560,0.772,1.630,2.210,1.830,
1.050,2.220,0.211,0.187,0.117,0.260,1.490,0.131,0.664,1.160,
1.410,1.630,0.853,1.700,3.040,1.530,1.330,3.530,2.130,1.410,
1.130,1.820,1.820,0.161,0.975,1.740,2.820,2.170,1.830,4.480,
4.730,2.450,1.400,2.720,2.570,1.730,1.090,1.600,2.490,0.351,
0.943,1.790,2.560,3.830,1.110,2.380,2.760,1.950,0.943,1.800,
1.920,1.540,0.924,1.240,2.160,0.343,0.973,1.880,1.600,2.650,
0.845,1.910,1.810,1.720,0.861,1.660,0.159,0.172,0.094,0.161,
1.860,0.206,1.010,1.550,1.560,2.340,1.040,1.880,2.120,1.310,
0.965,2.080,2.080,1.610,1.110,1.920,2.180,0.193,1.090,1.910,
2.250,2.210,1.510,3.280,2.580,1.690,0.931,1.640,1.810,1.170,
0.873,1.310,2.310,0.364,0.942,1.490,2.140,2.120,1.350,2.300,
0.170,0.142,0.084,0.160,0.101,0.109,0.090,0.108,0.222,0.049,
0.151,0.178,0.207,0.327,0.123,0.204,1.590,1.740,1.180,1.370,
0.133,0.123,0.274,0.145,1.440,0.158,0.740,1.060,1.040,1.400,
1.150,1.420,1.610,1.060,0.796,1.450,1.760,1.320,1.190,1.710,
2.450,0.409,1.200,1.940,1.720,1.820,1.410,2.530,4.010,1.800,
1.250,2.650,1.730,1.060,0.857,1.240,2.170,0.197,0.907,1.630,
2.930,2.160,1.560,3.680,2.040,1.220,0.880,1.680,1.300,0.860,
0.814,1.070,1.750,0.166,0.901,1.580,1.860,1.990,1.040,1.970,
2.320,1.980,1.280,2.220,0.154,0.138,0.113,0.184,2.620,0.177,
1.120,1.850,2.160,2.360,1.700,2.520,3.680,1.910,1.560,3.670,
2.370,1.990,1.560,2.370,3.690,0.240,2.120,3.740,4.720,3.540,
3.270,6.800,7.420,4.380,3.600,5.640,4.690,3.140,2.090,2.610,
4.090,0.481,1.780,2.860,4.790,4.400,2.080,4.240,4.480,3.030,
1.760,2.310,3.160,2.040,1.530,1.620,2.490,0.241,1.570,2.020,
1.800,2.140,1.330,2.050,2.390,2.390,1.490,2.180,0.217,0.248,
0.150,0.271,2.030,0.193,0.938,1.100,1.390,1.960,1.110,1.750,
3.380,1.970,2.180,3.610,2.680,2.750,1.580,2.300,3.040,0.375,
1.270,2.200,2.800,2.290,1.850,3.650,6.270,3.440,1.870,2.800,
3.750,2.610,1.400,1.700,2.720,0.383,1.300,1.750,2.310,2.740,
1.000,2.120,3.520,2.670,1.120,1.510,2.420,1.680,1.210,1.310,
2.210,0.329,1.400,2.070,1.400,2.060,0.929,1.650,1.790,2.180,
1.110,1.340,0.228,0.243,0.155,0.174,1.820,0.287,1.250,1.450,
1.200,2.480,1.190,1.770,1.580,1.220,0.875,1.310,1.790,1.700,
1.100,1.290,1.880,0.232,1.040,2.990,1.440,1.670,1.130,3.010,
2.910,1.450,0.934,1.530,2.320,1.450,1.060,1.310,2.480,0.341,
0.881,1.480,1.740,1.560,1.040,2.330,0.231,0.194,0.105,0.148,
0.273,0.207,0.137,0.145,0.187,0.055,0.131,0.185,0.167,0.302,
0.137,0.221,1.190,1.120,0.827,0.911,0.128,0.122,0.092,0.121,
1.020,0.134,0.667,0.848,0.722,0.982,0.706,0.908,2.280,0.804,
0.611,1.030,1.530,1.220,0.777,1.150,1.520,0.280,0.872,1.430,
1.190,1.250,1.150,2.090,4.330,1.560,0.988,1.990,2.290,1.110,
0.679,1.010,2.020,0.197,0.772,1.190,2.510,1.780,1.100,2.640,
3.880,2.130,1.170,1.700,4.070,1.970,1.150,1.450,1.760,0.184,
0.973,1.580,1.500,1.920,1.030,1.810,1.470,1.160,1.020,1.350,
0.123,0.104,0.099,0.130,1.050,0.108,0.747,0.970,0.936,1.270,
0.921,1.280,2.860,1.280,0.961,1.980,1.530,1.310,0.813,1.210,
2.030,0.202,1.120,1.980,2.300,2.260,1.840,3.850,5.150,3.130,
2.000,3.150,3.370,2.590,1.690,1.940,2.180,0.272,1.080,1.670,
2.400,2.480,1.130,2.300,3.590,2.510,1.380,1.710,2.850,2.210,
1.670,1.570,1.670,0.240,1.200,1.580,1.160,1.960,0.948,1.460,
1.560,1.690,1.080,1.400,0.166,0.203,0.137,0.205,1.180,0.162,
0.914,1.040,1.030,1.410,0.877,1.350,1.670,1.030,0.955,1.680,
1.730,1.760,1.020,1.430,1.300,0.150,0.912,1.430,2.080,1.590,
1.170,2.590,4.710,2.820,1.150,1.680,2.890,2.590,1.320,1.430,
2.060,0.295,0.921,1.240,1.660,1.990,0.747,1.580,2.680,2.020,
0.788,1.060,1.130,0.546,0.687,0.643,1.710,0.416,0.945,1.410,
0.991,2.110,0.959,1.130,1.350,2.170,0.934,1.160,0.180,0.377,
0.142,0.166,1.500,0.313,0.928,1.400,0.908,2.110,1.020,1.480,
1.080,1.050,0.781,1.010,1.460,2.100,0.824,1.060,1.260,0.186,
0.840,1.990,1.060,1.500,0.887,3.140,2.770,1.500,1.010,1.160,
2.080,1.920,1.260,1.230,1.770,0.288,0.931,1.130,1.220,1.680,
0.994,1.690,0.163,0.218,0.135,0.127,0.207,0.308,0.184,0.125,
0.158,0.067,0.165,0.151,0.115,0.368,0.128,0.149,1.180,1.690,
1.150,1.110,0.153,0.298,0.142,0.156,1.070,0.177,0.790,1.010,
0.627,1.390,0.997,1.060,1.090,0.753,0.608,0.873,1.500,1.850,
1.130,1.310,1.370,0.166,1.110,1.430,1.030,1.190,1.280,1.880,
2.130,1.120,0.725,1.190,1.490,1.010,0.575,0.766,1.610,0.138,
0.542,0.807,1.440,1.150,0.625,1.350,1.840,1.540,0.934,1.110,
1.810,1.910,0.941,1.030,1.400,0.177,0.826,1.090,0.964,1.840,
0.827,1.190,1.110,1.260,0.881,1.080,0.094,0.123,0.075,0.101,
0.872,0.098,0.759,0.917,0.682,1.160,1.030,1.190,1.330,0.855,
0.637,1.190,1.250,1.160,0.664,0.975,1.260,0.130,0.848,1.300,
1.450,1.700,1.360,2.550,4.440,2.540,1.430,2.550,2.240,1.500,
0.934,1.360,2.060,0.258,0.977,1.330,1.820,1.840,0.830,1.770,
3.710,3.070,1.200,1.780,2.380,1.910,1.350,1.430,2.650,0.347,
1.960,2.090,1.330,2.140,0.970,1.620,1.730,1.960,1.210,1.870,
0.402,0.237,0.152,0.308,1.810,0.228,0.891,1.350,0.993,1.710,
0.829,1.490,1.730,1.170,0.821,1.850,1.990,1.510,0.977,1.550,
1.710,0.214,1.040,1.870,1.760,1.610,1.460,3.400,0.705,0.223,
0.112,0.171,0.370,0.274,0.146,0.163,0.203,0.058,0.123,0.150,
0.155,0.286,0.138,0.219,0.341,0.253,0.120,0.149,0.292,0.368,
0.211,0.175,0.403,0.176,0.264,0.288,0.130,0.349,0.114,0.184,
0.235,0.215,0.117,0.142,0.183,0.077,0.043,0.037,0.375,0.084,
0.219,0.212,0.139,0.283,0.137,0.155,0.165,0.113,0.073,0.151,
0.698,0.300,0.147,0.212,0.202,0.040,0.157,0.251,0.148,0.167,
0.139,0.312,2.270,1.730,1.190,1.450,1.810,1.960,1.220,1.330,
1.980,0.370,1.270,1.430,1.280,1.600,1.100,1.810,0.172,0.266,
0.127,0.131,0.167,0.408,0.192,0.139,0.182,0.073,0.224,0.194,
0.138,0.314,0.153,0.163,1.200,1.780,0.970,1.110,0.168,0.231,
0.139,0.168,1.480,0.257,0.792,1.220,0.718,1.620,0.917,1.140,
1.150,0.822,0.584,0.917,1.460,1.730,1.010,1.290,1.660,0.279,
1.650,1.800,1.040,1.530,1.350,2.040,2.290,1.210,0.890,1.530,
1.260,0.824,0.766,0.849,1.470,0.163,0.773,1.360,1.500,1.230,
0.756,1.990,2.390,2.050,1.090,1.420,2.110,2.230,1.340,1.330,
2.190,0.281,1.650,2.130,1.540,2.230,1.210,1.750,1.360,1.720,
1.950,1.590,0.157,0.175,0.144,0.151,1.540,0.200,1.300,1.510,
1.030,1.890,1.190,1.660,1.690,1.190,0.971,1.600,2.000,1.540,
0.966,1.240,2.290,0.226,1.990,2.400,2.100,2.370,1.920,3.230,
3.490,1.810,1.230,2.730,1.760,1.040,0.782,1.510,1.670,0.174,
0.788,1.490,2.010,1.600,0.803,2.180,2.240,1.480,0.786,1.520,
1.260,0.830,0.700,1.040,1.420,0.180,0.839,1.390,1.030,1.280,
0.613,1.590,1.410,1.380,0.750,1.500,0.125,0.104,0.067,0.175,
1.110,0.114,0.570,0.984,0.875,1.420,0.575,1.290,1.810,1.160,
0.825,2.180,1.260,0.965,0.686,1.500,1.300,0.138,0.699,1.500,
1.890,1.550,1.200,3.430,4.920,1.910,1.070,1.980,2.450,1.700,
1.050,1.410,2.110,0.345,0.976,1.700,1.790,2.650,0.802,1.860,
2.680,1.920,0.802,1.400,2.010,1.840,1.000,1.270,3.540,0.906,
1.450,2.790,1.740,3.680,0.963,2.300,1.390,1.540,0.723,1.170,
0.267,0.182,0.100,0.147,1.800,0.244,1.110,1.560,1.280,2.370,
0.881,1.540,1.290,0.905,0.633,1.400,1.750,1.420,0.832,1.530,
1.530,0.183,1.010,1.690,1.410,1.620,1.080,2.430,1.780,1.100,
0.777,1.200,1.470,1.260,0.837,1.160,1.580,0.224,0.925,1.270,
1.180,1.280,0.937,1.780,0.110,0.104,0.061,0.094,0.083,0.136,
0.079,0.091,0.119,0.035,0.097,0.119,0.103,0.185,0.085,0.138,
0.890,1.110,0.632,0.898,0.081,0.092,0.067,0.105,1.180,0.152,
0.759,1.160,0.707,1.170,0.783,1.140,1.070,0.798,0.568,1.070,
1.270,1.160,0.759,1.240,1.660,0.534,1.210,1.740,1.140,1.580,
1.220,2.020,2.510,1.380,0.906,1.930,1.170,0.865,0.617,0.877,
1.460,0.138,0.791,1.170,1.620,1.260,0.883,2.180,1.790,1.090,
0.669,1.060,1.210,1.030,0.706,1.020,1.430,0.122,0.857,1.230,
1.300,1.330,0.824,1.520,1.480,1.310,0.942,1.380,0.108,0.106,
0.062,0.122,1.360,0.128,0.925,1.380,1.240,1.830,1.230,1.760,
2.280,1.410,1.030,2.170,1.940,2.110,1.130,1.720,2.550,0.246,
1.840,2.780,3.440,2.780,2.440,3.380,5.150,3.010,2.320,4.570,
3.240,2.210,1.720,2.350,3.110,0.337,1.330,2.080,4.380,3.510,
2.340,4.140,2.600,1.670,1.090,1.590,1.780,1.110,1.110,1.220,
1.560,0.156,0.930,1.180,1.370,1.430,1.150,1.580,2.080,1.560,
1.020,1.770,0.173,0.152,0.109,0.243,1.330,0.132,0.746,1.140,
1.110,1.390,0.924,1.490,2.620,1.300,1.150,2.490,1.980,1.640,
1.240,1.880,1.720,0.167,1.110,1.460,2.210,1.430,1.590,2.990,
4.690,2.790,1.550,2.680,3.020,2.150,1.510,1.690,2.270,0.289,
0.933,1.390,2.030,2.180,0.975,2.300,2.430,1.970,1.000,1.340,
1.900,1.280,1.280,1.140,1.940,0.258,1.030,1.490,1.250,1.730,
0.877,1.390,2.170,2.050,1.110,1.640,0.217,0.248,0.155,0.226,
2.600,0.294,1.380,1.740,1.420,2.170,1.200,1.600,1.800,1.290,
0.799,1.680,2.250,2.440,1.130,1.740,1.810,0.183,0.973,1.570,
1.610,1.520,1.280,2.590,2.710,1.400,0.899,1.590,2.530,1.720,
1.390,1.660,4.980,0.625,1.080,1.580,2.660,2.330,1.230,2.470,
0.224,0.205,0.112,0.174,0.221,0.208,0.182,0.185,0.454,0.085,
0.177,0.231,0.336,0.612,0.180,0.338,1.260,1.100,1.100,1.160,
0.147,0.135,0.123,0.177,1.430,0.188,0.748,0.883,0.966,1.710,
0.794,1.010,1.100,0.680,0.551,1.010,1.510,1.250,1.010,1.450,
1.410,0.163,0.887,1.110,1.370,1.300,1.070,1.850,3.080,1.280,
0.998,2.210,1.720,1.030,0.883,1.320,2.820,0.263,0.795,1.340,
3.720,2.490,1.250,3.330,2.310,1.620,1.020,1.440,1.710,1.220,
1.030,1.180,2.900,0.302,1.130,1.680,2.560,2.960,1.190,2.250,
1.440,1.390,1.080,1.600,0.133,0.113,0.118,0.193,1.560,0.160,
0.910,1.350,1.320,1.790,1.290,1.830,2.300,1.330,1.170,2.580,
1.490,1.060,1.200,1.790,2.550,0.227,1.400,2.360,3.540,2.910,
2.760,5.350,0.238,0.177,0.120,0.186,0.212,0.174,0.112,0.164,
0.162,0.026,0.076,0.110,0.152,0.184,0.109,0.173,0.196,0.170,
0.104,0.117,0.188,0.169,0.156,0.134,0.139,0.038,0.112,0.121,
0.087,0.173,0.105,0.123,0.122,0.135,0.093,0.124,0.020,0.026,
0.019,0.027,0.102,0.020,0.094,0.118,0.078,0.140,0.090,0.128,
0.143,0.107,0.110,0.169,0.174,0.172,0.133,0.169,0.142,0.020,
0.120,0.149,0.158,0.136,0.151,0.245,0.260,0.246,0.127,0.154,
0.233,0.255,0.152,0.146,0.163,0.044,0.086,0.099,0.112,0.185,
0.080,0.127,0.228,0.273,0.116,0.121,0.249,0.202,0.216,0.151,
0.204,0.072,0.141,0.183,0.107,0.230,0.106,0.126,0.149,0.235,
0.121,0.135,0.032,0.065,0.042,0.034,0.248,0.076,0.190,0.181,
0.107,0.260,0.143,0.150,0.137,0.127,0.089,0.149,0.207,0.305,
0.132,0.195,0.155,0.027,0.114,0.160,0.107,0.146,0.123,0.253,
0.161,0.124,0.072,0.102,0.180,0.197,0.149,0.173,0.293,0.070,
0.120,0.119,0.128,0.216,0.100,0.147,0.015,0.040,0.015,0.017,
0.028,0.049,0.053,0.037,0.053,0.050,0.051,0.036,0.020,0.081,
0.033,0.027,0.109,0.170,0.241,0.139,0.023,0.052,0.052,0.031,
0.167,0.069,0.130,0.132,0.099,0.339,0.134,0.125,0.104,0.075,
0.071,0.105,0.160,0.192,0.162,0.161,0.160,0.039,0.152,0.142,
0.107,0.157,0.138,0.187,0.206,0.172,0.110,0.180,0.152,0.128,
0.092,0.123,0.200,0.026,0.079,0.110,0.274,0.253,0.131,0.276,
0.243,0.276,0.139,0.167,0.234,0.246,0.197,0.206,0.358,0.083,
0.181,0.213,0.307,0.609,0.181,0.273,0.117,0.172,0.126,0.145,
0.016,0.025,0.019,0.023,0.157,0.032,0.134,0.167,0.121,0.219,
0.157,0.194,0.170,0.134,0.099,0.175,0.139,0.139,0.110,0.162,
0.213,0.024,0.152,0.222,0.221,0.252,0.221,0.374,2.960,1.930,
1.280,2.230,1.980,1.700,1.250,1.570,1.900,0.207,0.866,1.270,
1.650,1.440,0.907,1.670,2.050,1.720,1.140,1.410,1.990,1.540,
2.070,1.430,2.090,0.263,1.590,1.710,1.400,1.730,1.070,1.530,
1.630,2.020,1.330,1.890,0.225,0.285,0.204,0.368,2.030,0.305,
1.130,1.570,1.170,2.850,1.110,1.750,1.520,1.010,0.794,1.620,
1.520,1.430,1.160,1.720,1.710,0.215,1.190,1.980,1.790,1.750,
1.640,3.200,0.203,0.190,0.100,0.144,0.224,0.310,0.156,0.171,
0.149,0.039,0.088,0.123,0.121,0.172,0.082,0.156,0.149,0.172,
0.088,0.093,0.217,0.218,0.226,0.143,0.213,0.059,0.185,0.189,
0.136,0.181,0.092,0.109,0.134,0.206,0.107,0.144,0.028,0.053,
0.036,0.034,0.207,0.066,0.166,0.204,0.118,0.298,0.128,0.152,
0.171,0.123,0.082,0.166,0.224,0.267,0.153,0.230,0.174,0.034,
0.144,0.248,0.146,0.174,0.158,0.277,1.620,1.420,0.970,1.020,
1.980,2.070,3.010,1.540,1.790,0.360,1.320,1.510,1.100,1.470,
1.510,1.670,0.131,0.196,0.146,0.113,0.183,0.253,1.020,0.175,
0.179,0.056,0.243,0.187,0.203,0.278,0.171,0.171,1.250,1.530,
1.120,1.120,0.167,0.209,0.245,0.190,1.330,0.214,0.603,0.990,
0.641,1.280,1.110,1.230,0.949,0.709,0.591,0.794,1.300,1.470,
1.360,1.340,1.340,0.209,1.310,1.560,0.998,1.320,1.460,2.040,
1.600,1.020,0.798,1.300,1.260,0.951,0.951,0.920,1.460,0.177,
0.823,1.200,1.870,1.310,0.830,1.600,1.970,1.680,1.200,1.330,
2.020,1.960,3.610,1.490,1.900,0.239,1.570,1.870,3.660,2.360,
1.380,1.780,1.400,2.030,1.160,1.490,0.158,0.244,0.206,0.195,
1.720,0.221,1.410,1.790,1.190,1.990,1.400,1.800,1.450,1.030,
0.805,1.400,1.350,1.330,1.050,1.330,1.900,0.210,1.780,2.290,
1.990,2.290,2.000,3.260,3.190,1.730,1.220,2.550,1.680,1.240,
0.976,1.830,1.650,0.191,0.673,1.210,1.950,1.780,0.998,2.220,
1.700,1.090,0.686,1.060,1.120,0.690,0.785,0.891,1.050,0.100,
0.569,0.923,0.833,0.917,0.599,1.060,1.800,1.460,0.844,1.540,
0.149,0.134,0.095,0.212,1.190,0.137,0.653,1.150,1.090,1.570,
0.832,1.470,2.010,1.100,0.942,1.900,1.550,1.120,0.983,1.580,
1.350,0.127,1.190,1.420,1.960,1.540,1.480,3.210,3.380,2.190,
1.330,2.310,2.490,2.300,1.460,1.890,1.870,0.263,0.998,1.470,
1.730,2.220,0.900,2.000,2.290,2.170,1.010,1.420,2.440,1.780,
1.540,1.470,2.130,0.328,1.450,1.920,1.240,2.010,1.100,1.420,
1.800,2.130,1.010,1.620,0.180,0.239,0.139,0.232,2.060,0.298,
1.350,2.100,1.910,2.920,1.390,2.130,1.810,1.260,1.070,1.890,
2.100,1.910,1.400,2.250,1.890,0.186,1.280,2.150,1.830,1.890,
1.810,3.180,2.090,1.440,1.430,1.750,1.910,1.510,1.510,1.740,
1.870,0.271,1.070,1.650,1.360,1.640,1.240,2.150,0.129,0.139,
0.090,0.122,0.121,0.154,0.189,0.134,0.124,0.027,0.124,0.177,
0.123,0.219,0.118,0.170,1.350,1.480,1.010,1.290,0.128,0.148,
0.130,0.184,1.440,0.206,0.975,1.530,0.928,1.670,1.140,1.610,
1.300,0.864,0.745,1.180,1.650,1.440,1.430,1.840,1.490,0.194,
1.560,1.900,1.400,1.440,1.730,2.550,2.480,1.320,1.090,2.000,
1.500,1.050,0.963,1.210,1.650,0.184,0.853,1.490,2.130,1.610,
1.160,2.850,1.690,1.350,0.808,1.260,1.330,1.220,1.210,1.140,
1.310,0.127,0.918,1.650,1.550,1.590,1.030,1.860,1.740,1.830,
1.170,1.940,0.142,0.153,0.103,0.194,2.130,0.213,1.490,2.610,
1.680,2.380,1.780,2.470,2.710,1.500,1.300,2.770,2.100,1.860,
1.540,2.280,2.810,0.223,2.140,3.430,3.460,2.940,2.980,4.660,
6.140,3.300,3.100,6.710,3.080,1.710,1.530,2.460,3.500,0.324,
1.250,2.550,5.290,4.140,1.970,4.990,3.130,1.710,1.390,2.170,
1.700,0.898,0.826,1.130,1.750,0.136,0.955,1.370,2.030,1.870,
1.160,2.180,3.020,1.710,1.320,2.480,0.198,0.132,0.104,0.258,
1.740,0.138,0.827,1.260,1.770,1.720,1.130,2.220,3.670,1.720,
1.730,3.890,2.320,1.450,1.290,2.320,2.430,0.185,1.460,1.940,
3.580,2.170,2.100,4.840,4.070,1.960,1.220,2.420,2.030,1.120,
0.823,1.220,1.880,0.175,0.660,1.150,2.100,1.740,0.775,1.960,
1.910,1.250,0.691,1.130,1.150,0.768,0.599,0.783,1.380,0.117,
0.595,0.977,1.290,1.200,0.669,1.260,1.680,1.310,0.874,1.490,
0.118,0.096,0.068,0.127,1.460,0.126,0.712,1.120,1.340,1.520,
0.859,1.440,1.710,1.120,0.801,1.750,1.330,1.040,0.612,1.120,
1.450,0.108,0.790,1.340,1.580,1.320,1.080,2.440,3.150,1.620,
1.190,2.240,2.060,1.180,1.060,1.700,3.040,0.315,0.814,1.400,
3.300,2.160,1.170,2.970,0.187,0.137,0.085,0.162,0.148,0.100,
0.081,0.132,0.186,0.023,0.083,0.135,0.393,0.365,0.132,0.286,
1.290,1.220,1.120,1.420,0.112,0.079,0.082,0.136,1.480,0.132,
0.965,1.100,1.170,1.270,0.905,1.330,1.460,0.873,0.788,1.560,
1.440,0.939,0.785,1.430,1.450,0.135,0.796,1.330,1.920,1.340,
1.310,2.690,4.730,1.820,1.440,3.480,2.060,1.070,0.981,1.610,
4.300,0.381,1.130,1.870,7.800,3.880,1.720,5.170,2.640,1.610,
1.060,1.710,1.560,0.973,0.793,1.160,2.460,0.203,0.906,1.500,
4.620,3.660,1.450,3.130,2.180,1.620,1.260,2.100,0.153,0.099,
0.090,0.166,1.760,0.132,1.100,1.440,2.090,1.980,1.470,2.460,
3.680,1.950,1.760,4.140,2.230,1.230,1.210,2.020,3.050,0.214,
1.560,2.880,5.620,3.710,3.540,8.150,5.290,2.950,1.990,4.080,
3.460,2.020,1.350,2.100,2.520,0.272,1.090,1.890,3.050,2.790,
1.420,3.210,3.040,1.910,1.290,2.010,2.470,1.480,1.210,1.550,
1.860,0.208,1.720,1.590,1.440,2.080,1.190,1.810,2.140,1.930,
1.390,2.280,0.190,0.188,0.132,0.261,1.570,0.190,1.150,2.010,
1.660,2.070,1.430,2.680,2.390,1.420,1.410,2.750,2.160,1.800,
1.300,2.280,1.780,0.173,1.280,1.960,2.620,1.730,1.770,3.750,
4.020,2.620,1.560,2.450,2.860,1.910,1.210,1.440,1.980,0.231,
0.778,1.230,1.900,2.050,0.865,1.920,2.590,2.190,0.988,1.420,
2.050,1.320,1.120,1.360,1.800,0.240,0.989,1.480,1.280,2.050,
0.917,1.480,1.990,2.170,1.300,1.880,0.204,0.220,0.132,0.184,
2.220,0.278,1.320,1.790,1.830,2.420,1.390,2.230,1.750,1.470,
1.170,2.190,1.770,2.100,0.946,1.660,1.720,0.170,1.070,1.770,
1.590,1.540,1.220,2.720,2.960,1.650,0.923,1.580,2.270,1.900,
1.260,1.590,2.820,0.400,0.952,1.260,2.400,2.550,1.100,2.530,
0.146,0.166,0.082,0.141,0.155,0.186,0.136,0.158,0.209,0.063,
0.132,0.144,0.242,0.526,0.149,0.228,1.750,2.600,1.580,1.840,
0.153,0.198,0.143,0.204,1.740,0.251,0.919,1.270,1.320,2.380,
1.260,1.800,1.620,1.270,0.966,1.700,1.810,1.840,1.440,2.020,
1.890,0.177,1.150,1.650,1.850,1.680,1.590,2.900,3.080,1.760,
1.230,2.410,1.690,1.270,0.936,1.380,2.680,0.276,0.982,1.500,
4.380,3.330,1.400,3.650,2.620,2.210,1.310,1.900,1.870,1.850,
1.330,1.700,3.070,0.444,1.390,1.890,4.110,7.520,1.930,3.360,
2.020,2.050,1.320,2.020,0.152,0.150,0.094,0.176,1.890,0.197,
1.210,1.740,1.770,2.640,1.630,2.710,2.530,1.610,1.320,2.410,
1.950,1.580,1.140,1.970,2.590,0.217,1.510,2.720,3.390,3.200,
2.550,5.120,3.550,2.150,1.300,2.660,1.760,1.460,0.871,1.500,
1.980,0.190,0.796,1.450,2.100,1.640,0.920,2.120,2.490,2.130,
1.080,1.660,1.780,1.380,1.150,1.270,1.940,0.223,1.210,1.700,
1.580,1.940,1.070,1.950,2.010,2.070,1.290,2.250,0.194,0.223,
0.147,0.314,1.780,0.217,1.060,1.870,1.340,2.170,1.270,2.320,
2.030,1.350,0.992,2.360,1.730,1.490,1.030,1.860,2.160,0.225,
1.230,2.350,2.450,2.020,1.800,4.140,0.210,0.167,0.094,0.189,
0.164,0.178,0.084,0.135,0.133,0.021,0.074,0.112,0.144,0.170,
0.080,0.175,0.134,0.145,0.065,0.089,0.162,0.195,0.102,0.106,
0.162,0.034,0.140,0.180,0.111,0.178,0.082,0.128,0.100,0.145,
0.073,0.118,0.019,0.023,0.015,0.020,0.144,0.033,0.122,0.158,
0.103,0.202,0.105,0.151,0.143,0.129,0.083,0.189,0.198,0.209,
0.101,0.182,0.172,0.026,0.110,0.196,0.171,0.162,0.129,0.297,
2.090,1.440,0.905,1.190,1.760,1.590,1.250,1.320,2.050,0.319,
1.030,1.420,1.460,1.810,1.580,2.030,0.120,0.133,0.072,0.088,
0.118,0.144,0.138,0.091,0.140,0.034,0.112,0.128,0.151,0.256,
0.148,0.182,1.300,1.780,1.020,1.330,0.144,0.175,0.132,0.153,
1.780,0.232,0.857,1.440,1.010,1.840,1.250,1.740,1.380,1.040,
0.768,1.200,1.530,1.550,1.150,1.480,2.090,0.220,1.430,1.930,
1.700,1.810,1.980,3.320,2.350,1.270,0.925,1.740,1.430,0.971,
0.804,1.070,1.890,0.192,0.944,1.490,2.030,1.590,1.210,2.590,
2.190,1.680,1.110,1.590,1.680,1.560,1.360,1.290,2.070,0.221,
1.430,1.940,2.180,2.670,1.760,2.570,1.780,1.910,1.350,1.920,
0.136,0.161,0.121,0.166,2.150,0.194,1.430,2.040,1.730,2.330,
1.730,2.510,2.150,1.490,1.360,2.220,1.630,1.440,1.070,1.500,
2.890,0.235,2.050,3.160,3.200,3.020,2.680,4.880,5.730,2.520,
1.970,4.380,2.250,1.380,1.130,2.390,2.670,0.232,0.988,2.180,
3.450,2.380,1.510,3.810,2.560,1.460,0.921,1.560,1.400,0.884,
0.823,1.220,1.630,0.140,0.899,1.790,1.400,1.320,0.839,1.820,
2.100,1.800,1.050,2.440,0.165,0.162,0.104,0.288,1.560,0.159,
0.783,1.600,1.600,1.830,1.070,2.270,2.850,1.500,1.340,3.440,
1.790,1.190,1.050,2.210,2.040,0.161,1.060,2.360,3.180,2.150,
1.970,5.540,4.190,2.300,1.720,3.290,1.960,1.490,1.170,1.790,
1.890,0.197,0.897,1.590,2.060,1.970,0.914,2.310,2.250,1.710,
0.823,1.350,1.620,1.360,0.835,1.170,1.920,0.233,1.690,1.780,
1.380,1.780,1.020,1.670,1.590,1.680,0.790,1.640,0.106,0.138,
0.071,0.146,1.670,0.178,1.580,1.700,1.560,2.180,1.090,2.080,
1.920,1.450,1.120,2.200,1.640,1.420,0.933,1.790,1.800,0.137,
1.050,1.860,2.000,1.860,1.400,3.320,3.110,1.910,1.530,2.150,
2.100,1.490,1.290,1.980,2.810,0.332,1.120,2.150,2.700,2.400,
1.870,3.610,0.179,0.174,0.088,0.149,0.112,0.116,0.094,0.141,
0.152,0.020,0.095,0.165,0.198,0.255,0.137,0.265,1.830,2.020,
1.140,2.020,0.123,0.140,0.110,0.188,2.040,0.215,1.280,1.870,
1.460,1.990,1.520,2.480,2.340,1.620,1.160,2.260,2.090,1.780,
1.460,2.550,2.960,0.239,1.700,2.860,2.540,2.160,2.330,4.340,
5.790,2.530,2.170,4.060,2.430,1.510,1.410,2.050,3.200,0.269,
1.460,2.810,4.650,3.140,2.230,6.360,3.280,2.220,1.270,2.200,
2.050,1.710,1.240,1.890,2.710,0.207,1.470,2.810,2.910,3.080,
1.800,4.090,2.950,2.660,1.720,3.220,0.173,0.164,0.106,0.235,
3.170,0.237,1.900,3.340,3.090,3.480,2.710,4.610,6.350,2.910,
2.590,6.080,3.440,2.630,2.070,3.950,5.310,0.320,3.500,6.410,
6.420,4.570,4.750,5.990,4.820,3.710,2.630,4.350,3.820,2.090,
1.980,2.290,4.030,0.352,2.350,2.780,5.410,3.700,2.690,4.450,
3.870,2.160,1.860,2.290,2.280,1.330,1.340,1.310,2.200,0.167,
1.430,1.630,1.970,1.700,1.360,2.070,2.590,1.810,1.600,2.260,
0.223,0.175,0.151,0.273,1.690,0.139,0.999,1.270,1.910,1.790,
1.400,1.940,4.070,2.000,2.020,3.910,2.950,1.960,1.780,2.530,
2.550,0.202,1.470,2.010,3.310,2.010,2.150,3.720,4.300,2.200,
1.490,2.310,2.170,1.340,0.995,1.320,2.010,0.184,1.120,1.360,
1.920,1.670,1.030,1.740,2.510,1.560,1.030,1.350,1.400,0.831,
0.817,0.874,1.550,0.131,0.882,1.270,1.250,1.470,0.922,1.260,
1.680,1.470,0.931,1.270,0.171,0.113,0.083,0.130,1.380,0.114,
0.736,0.961,1.190,1.230,0.806,1.090,1.760,1.170,0.858,1.560,
1.650,1.230,0.889,1.300,1.570,0.131,0.929,1.300,1.670,1.400,
1.190,2.060,3.690,1.520,1.340,1.810,2.630,1.290,1.190,1.470,
1.860,0.220,0.967,1.360,1.930,1.570,1.520,2.520,0.238,0.184,
0.104,0.155,0.178,0.111,0.098,0.118,0.151,0.023,0.102,0.130,
0.208,0.256,0.148,0.237,1.530,1.020,0.898,1.070,0.131,0.091,
0.079,0.116,1.230,0.165,0.664,0.831,1.230,1.100,0.888,1.090,
1.440,0.788,0.740,1.270,1.680,1.070,0.874,1.360,1.550,0.148,
0.946,1.470,1.390,1.250,1.290,2.240,4.930,1.720,1.710,3.070,
2.020,1.030,1.140,1.350,1.880,0.181,0.985,1.470,2.610,1.710,
1.680,3.560,2.970,1.510,1.320,1.770,1.850,0.990,0.961,1.130,
1.510,0.115,0.971,1.270,1.810,1.580,1.300,2.100,2.500,1.370,
1.170,1.690,0.142,0.084,0.082,0.139,1.200,0.090,0.733,1.020,
1.170,1.140,1.040,1.480,2.640,1.200,1.260,2.470,1.530,0.772,
0.902,1.380,1.900,0.122,1.170,1.900,2.660,1.860,2.180,4.200,
5.560,3.180,2.620,3.990,2.620,1.760,1.630,1.910,2.060,0.208,
1.160,1.750,2.540,2.270,2.070,2.940,3.640,2.310,1.560,2.040,
1.920,1.300,1.450,1.320,1.960,0.196,1.290,1.790,1.450,1.610,
1.200,1.780,2.040,1.560,1.320,1.600,0.158,0.151,0.123,0.186,
1.080,0.110,0.779,1.040,1.070,1.300,0.972,1.540,2.270,1.170,
1.080,2.050,1.750,1.520,1.110,1.490,1.510,0.145,0.916,1.720,
1.740,1.330,1.500,2.810,3.800,2.450,1.340,2.050,2.060,1.540,
1.070,1.330,1.410,0.165,0.829,1.150,1.330,1.460,0.883,1.430,
2.390,1.600,1.060,1.280,1.100,0.471,0.791,0.797,1.300,0.145,
0.962,1.330,1.170,1.190,0.844,1.140,1.600,1.690,1.020,1.300,
0.125,0.134,0.099,0.123,1.280,0.188,0.902,1.040,0.846,1.530,
0.848,1.180,1.370,0.974,0.724,1.080,1.290,1.060,0.724,0.911,
1.130,0.106,0.743,0.976,1.050,1.020,0.809,1.540,2.810,1.660,
1.130,1.700,1.950,1.610,1.680,1.560,1.630,0.212,1.100,1.490,
1.410,1.490,1.530,2.180,0.183,0.223,0.116,0.186,0.144,0.166,
0.154,0.149,0.139,0.039,0.159,0.185,0.137,0.263,0.172,0.214,
1.440,1.820,1.310,1.370,0.149,0.333,0.146,0.155,1.250,0.206,
0.992,1.180,0.930,2.020,1.400,1.470,1.150,0.790,0.819,1.210,
1.650,1.680,1.280,1.510,1.430,0.139,1.210,1.720,1.210,1.280,
1.450,2.030,2.660,1.530,1.220,2.170,1.450,0.951,1.050,1.280,
1.140,0.107,0.675,1.140,1.510,1.250,1.150,2.130,2.450,1.680,
1.260,2.040,1.620,1.260,1.130,1.730,1.310,0.120,1.040,1.510,
1.360,1.680,1.250,2.100,1.400,1.540,1.140,1.610,0.102,0.117,
0.079,0.126,0.935,0.093,0.795,1.100,0.929,1.250,1.260,1.610,
1.770,1.070,1.060,1.770,1.700,1.060,0.892,1.450,1.490,0.110,
1.090,1.890,1.920,1.760,2.080,3.290,3.840,2.850,1.670,2.750,
2.000,1.890,1.110,1.350,1.780,0.198,0.978,1.500,2.030,1.860,
1.150,2.160,3.280,2.480,1.550,2.060,2.010,1.770,1.740,1.510,
2.400,0.252,1.580,2.420,1.630,2.130,1.260,1.950,2.070,2.530,
2.240,1.980,0.234,0.275,0.206,0.302,1.990,0.201,1.020,1.380,
1.270,1.930,1.160,1.670,2.350,1.500,1.340,2.310,2.180,1.980,
1.330,1.840,2.300,0.214,1.270,2.060,2.240,1.970,1.750,3.960,
0.306,0.316,0.149,0.223,0.422,0.694,0.144,0.190,0.196,0.050,
0.138,0.185,0.169,0.249,0.137,0.206,0.278,0.268,0.144,0.178,
0.239,0.314,0.159,0.151,0.284,0.054,0.198,0.393,0.164,0.289,
0.145,0.204,0.185,0.262,0.164,0.161,0.033,0.047,0.032,0.029,
0.637,0.059,0.231,0.235,0.180,0.288,0.147,0.184,0.301,0.217,
0.155,0.272,0.479,0.413,0.233,0.304,0.316,0.043,0.207,0.295,
0.275,0.297,0.222,0.434,2.200,1.620,1.070,1.360,1.520,1.410,
1.230,1.190,1.990,0.331,1.860,1.780,1.340,1.560,1.840,2.030,
0.184,0.217,0.107,0.135,0.157,0.163,0.127,0.100,0.215,0.049,
0.190,0.184,0.165,0.269,0.198,0.196,1.460,1.970,1.120,1.120,
0.258,0.206,0.147,0.165,1.570,0.185,0.991,1.020,0.888,1.370,
1.110,1.140,1.410,1.130,0.875,1.050,3.110,2.150,1.220,1.390,
1.730,0.209,1.990,1.850,1.210,1.410,1.560,1.980,2.060,1.230,
0.929,1.810,1.270,0.865,0.735,0.856,1.400,0.139,0.858,1.160,
1.380,1.190,1.150,1.890,2.560,1.890,1.240,1.960,1.970,1.630,
1.210,1.250,2.230,0.185,1.430,1.850,1.690,2.040,1.500,2.020,
1.500,1.600,1.240,1.490,0.278,0.153,0.129,0.148,1.470,0.142,
1.140,1.330,1.130,1.730,1.280,1.660,2.410,1.290,1.240,1.740,
5.420,1.600,1.180,1.420,2.140,0.177,1.850,2.320,2.310,2.170,
2.180,3.270,4.410,2.240,1.640,3.090,1.680,1.160,0.995,1.240,
1.710,0.157,0.856,1.370,2.410,1.750,1.380,2.710,2.160,1.290,
0.964,1.430,1.160,0.820,0.800,0.943,1.550,0.137,0.844,1.960,
1.270,1.110,0.818,1.540,1.880,1.660,1.050,1.720,0.160,0.163,
0.093,0.199,1.320,0.123,0.640,1.100,1.100,1.460,0.866,1.630,
2.620,1.420,1.350,3.250,1.870,1.490,1.100,1.800,2.250,0.164,
1.050,1.710,2.470,1.770,1.790,4.060,3.250,2.010,1.180,2.120,
2.260,1.770,0.958,1.260,1.610,0.179,0.960,1.370,1.510,1.640,
1.020,1.850,2.240,1.630,0.830,1.230,1.580,1.760,0.807,0.927,
1.920,0.307,1.080,1.950,1.300,1.880,0.790,1.390,1.540,1.490,
0.847,1.370,0.131,0.147,0.080,0.131,2.140,0.171,1.030,1.570,
1.310,1.650,0.902,1.630,2.000,1.200,0.982,1.850,1.900,1.460,
1.040,1.540,2.110,0.171,1.210,1.850,1.860,1.870,1.360,2.770,
2.650,1.500,1.180,1.720,2.140,1.430,1.280,1.620,2.230,0.264,
1.740,1.970,1.870,1.620,3.190,2.900,0.254,0.174,0.110,0.169,
0.136,0.134,0.113,0.126,0.179,0.028,0.167,0.199,0.191,0.243,
0.232,0.248,1.490,1.540,1.030,1.590,0.131,0.124,0.111,0.169,
1.720,0.183,1.180,1.460,1.190,1.710,1.420,1.820,1.710,1.160,
1.080,1.970,2.050,1.540,1.350,2.050,2.730,0.227,1.840,2.740,
1.920,1.760,2.070,3.230,3.690,1.750,1.440,2.630,1.820,1.200,
1.150,1.510,1.960,0.179,1.090,1.680,2.550,1.800,1.950,3.970,
2.010,1.300,0.984,1.660,1.170,0.805,0.937,1.110,1.630,0.120,
1.250,1.740,1.710,1.650,1.380,2.300,2.110,1.900,1.430,2.600,
0.170,0.130,0.107,0.218,2.040,0.161,1.340,1.970,2.230,2.350,
2.050,2.960,3.950,2.020,1.990,4.080,3.120,1.890,1.820,2.810,
3.720,0.212,2.600,4.110,5.350,3.580,4.030,6.450,0.316,0.249,
0.198,0.281,0.234,0.180,0.158,0.167,0.214,0.027,0.169,0.187,
0.241,0.219,0.163,0.217,0.241,0.191,0.144,0.161,0.179,0.141,
0.147,0.132,0.155,0.021,0.131,0.149,0.138,0.160,0.128,0.167,
0.148,0.131,0.125,0.147,0.018,0.027,0.018,0.022,0.118,0.013,
0.094,0.088,0.095,0.134,0.140,0.130,0.206,0.139,0.139,0.215,
0.221,0.303,0.162,0.191,0.211,0.035,0.142,0.167,0.191,0.172,
0.169,0.267,0.305,0.210,0.154,0.190,0.217,0.156,0.138,0.126,
0.207,0.036,0.528,0.217,0.145,0.181,0.157,0.171,0.232,0.207,
0.134,0.136,0.171,0.134,0.142,0.125,0.215,0.038,0.190,0.248,
0.125,0.188,0.126,0.161,0.127,0.148,0.122,0.123,0.020,0.022,
0.037,0.018,0.188,0.026,0.114,0.112,0.098,0.164,0.105,0.115,
0.125,0.098,0.089,0.126,0.155,0.135,0.127,0.144,0.150,0.017,
0.134,0.156,0.139,0.140,0.139,0.221,0.218,0.121,0.088,0.126,
0.184,0.115,0.117,0.116,0.154,0.025,0.124,0.129,0.132,0.130,
0.130,0.190,0.020,0.027,0.017,0.017,0.018,0.021,0.022,0.015,
0.024,7.77e-3,0.022,0.020,0.018,0.034,0.025,0.026,0.102,0.098,
0.105,0.097,0.014,0.017,0.019,0.015,0.105,0.023,0.086,0.087,
0.073,0.124,0.114,0.107,0.091,0.058,0.069,0.102,0.138,0.103,
0.098,0.131,0.134,0.020,0.104,0.144,0.103,0.120,0.144,0.207,
0.283,0.122,0.110,0.184,0.176,0.091,0.089,0.100,0.150,0.021,
0.091,0.120,0.195,0.147,0.120,0.259,0.229,0.171,0.135,0.171,
0.209,0.149,0.136,0.138,0.174,0.025,0.127,0.168,0.148,0.185,
0.139,0.236,0.155,0.120,0.131,0.154,0.034,0.018,0.022,0.020,
0.124,0.016,0.095,0.133,0.114,0.136,0.137,0.157,0.191,0.102,
0.099,0.184,0.240,0.110,0.104,0.146,0.183,0.023,0.139,0.222,
0.221,0.210,0.235,0.427,0.283,0.188,0.150,0.197,0.190,0.152,
0.129,0.141,0.133,0.020,0.090,0.108,0.138,0.150,0.119,0.155,
0.202,0.163,0.121,0.119,0.166,0.150,0.148,0.125,0.138,0.030,
0.131,0.139,0.079,0.134,0.103,0.119,0.106,0.117,0.088,0.088,
0.013,0.018,0.015,0.017,0.072,0.012,0.076,0.071,0.057,0.095,
0.081,0.100,0.106,0.076,0.062,0.104,0.115,0.125,0.090,0.100,
0.120,0.016,0.086,0.121,0.115,0.106,0.107,0.179,0.245,0.217,
0.115,0.134,0.192,0.219,0.135,0.139,0.131,0.026,0.122,0.108,
0.104,0.133,0.082,0.117,0.224,0.236,0.136,0.123,0.187,0.123,
0.161,0.146,0.185,0.047,0.161,0.173,0.112,0.187,0.125,0.123,
0.114,0.195,0.112,0.108,0.017,0.036,0.031,0.020,0.161,0.042,
0.117,0.113,0.065,0.159,0.113,0.113,0.102,0.085,0.086,0.087,
0.116,0.137,0.094,0.103,0.112,0.015,0.091,0.113,0.091,0.101,
0.100,0.166,0.183,0.131,0.087,0.105,0.160,0.162,0.148,0.118,
0.134,0.026,0.102,0.124,0.109,0.132,0.128,0.163,0.016,0.029,
0.018,0.018,0.021,0.038,0.041,0.018,0.021,0.015,0.033,0.028,
0.011,0.036,0.028,0.019,0.121,0.207,0.139,0.129,0.023,0.074,
0.037,0.024,0.135,0.044,0.132,0.123,0.066,0.186,0.162,0.141,
0.080,0.058,0.077,0.090,0.129,0.180,0.144,0.136,0.177,0.024,
0.152,0.162,0.092,0.112,0.165,0.170,0.175,0.104,0.080,0.140,
0.107,0.080,0.076,0.089,0.094,0.011,0.064,0.080,0.107,0.102,
0.084,0.158,0.157,0.149,0.109,0.132,0.143,0.147,0.121,0.152,
0.117,0.022,0.120,0.141,0.097,0.159,0.120,0.149,0.094,0.123,
0.106,0.117,0.012,0.015,0.014,0.012,0.086,0.016,0.089,0.093,
0.073,0.109,0.112,0.126,0.111,0.069,0.073,0.113,0.154,0.092,
0.085,0.110,0.114,0.012,0.104,0.141,0.128,0.144,0.171,0.240,
0.256,0.203,0.123,0.185,0.156,0.180,0.100,0.109,0.159,0.019,
0.101,0.103,0.126,0.124,0.082,0.136,0.224,0.218,0.128,0.142,
0.186,0.248,0.175,0.150,0.294,0.048,0.198,0.273,0.112,0.204,
0.111,0.150,0.144,0.171,0.146,0.136,0.029,0.030,0.030,0.031,
0.542,0.047,0.149,0.155,0.108,0.150,0.161,0.132,0.132,0.095,
0.081,0.142,0.198,0.144,0.123,0.177,0.215,0.033,0.125,0.175,
0.146,0.143,0.145,0.256,0.023,0.025,0.014,0.018,0.037,0.051,
0.021,0.020,0.029,9.94e-3,0.023,0.017,0.015,0.027,0.018,0.019,
0.024,0.043,0.022,0.021,0.039,0.066,0.042,0.028,0.042,0.030,
0.055,0.068,0.016,0.042,0.023,0.029,0.021,0.038,0.032,0.017,
0.013,0.018,0.020,7.27e-3,0.405,0.045,0.103,0.072,0.035,0.052,
0.037,0.021,0.017,0.014,9.61e-3,0.016,0.063,0.036,0.028,0.027,
0.059,0.010,0.032,0.035,0.021,0.023,0.025,0.032,0.211,0.202,
0.116,0.118,0.147,0.188,0.168,0.130,0.280,0.048,0.207,0.185,
0.128,0.170,0.199,0.257,0.019,0.045,0.021,0.018,0.028,0.049,
0.043,0.018,0.034,0.026,0.067,0.040,0.017,0.043,0.037,0.025,
0.135,0.278,0.146,0.126,0.031,0.044,0.044,0.026,0.201,0.049,
0.165,0.149,0.075,0.187,0.168,0.143,0.141,0.099,0.094,0.102,
0.422,0.207,0.167,0.162,0.217,0.042,0.242,0.221,0.112,0.153,
0.185,0.219,0.175,0.123,0.096,0.163,0.146,0.088,0.075,0.084,
0.158,0.015,0.092,0.129,0.123,0.120,0.104,0.172,0.231,0.223,
0.131,0.182,0.321,0.247,0.170,0.157,0.217,0.036,0.216,0.237,
0.143,0.238,0.181,0.210,0.153,0.185,0.156,0.155,0.085,0.027,
0.026,0.021,0.198,0.030,0.159,0.178,0.113,0.201,0.159,0.178,
0.350,0.112,0.097,0.145,2.380,0.223,0.154,0.183,0.307,0.026,
0.197,0.238,0.249,0.241,0.217,0.308,0.290,0.188,0.144,0.242,
0.203,0.129,0.116,0.241,0.194,0.019,0.091,0.159,0.194,0.158,
0.118,0.230,0.194,0.138,0.098,0.131,0.138,0.101,0.099,0.130,
0.155,0.018,0.107,0.201,0.112,0.122,0.092,0.154,0.138,0.130,
0.101,0.162,0.013,0.016,0.012,0.026,0.177,0.016,0.082,0.116,
0.097,0.131,0.095,0.151,0.187,0.122,0.132,0.269,0.174,0.132,
0.120,0.264,0.233,0.020,0.107,0.227,0.240,0.177,0.184,0.448,
0.377,0.225,0.157,0.255,0.246,0.217,0.149,0.178,0.213,0.032,
0.138,0.194,0.167,0.223,0.156,0.231,0.303,0.255,0.138,0.180,
0.245,0.249,0.182,0.179,0.279,0.058,0.208,0.347,0.177,0.331,
0.155,0.253,0.162,0.202,0.130,0.164,0.022,0.029,0.027,0.028,
0.666,0.055,0.219,0.279,0.170,0.246,0.139,0.199,0.191,0.131,
0.117,0.212,0.255,0.199,0.173,0.264,0.270,0.027,0.200,0.268,
0.215,0.229,0.205,0.360,0.201,0.140,0.110,0.143,0.181,0.145,
0.143,0.150,0.215,0.032,0.181,0.193,0.140,0.166,0.263,0.267,
0.019,0.018,0.011,0.017,0.015,0.023,0.020,0.017,0.018,7.19e-3,
0.024,0.022,0.017,0.032,0.035,0.028,0.120,0.162,0.123,0.143,
0.016,0.021,0.022,0.027,0.183,0.030,0.148,0.171,0.099,0.188,
0.182,0.181,0.127,0.096,0.097,0.151,0.188,0.138,0.149,0.202,
0.266,0.032,0.232,0.291,0.160,0.181,0.253,0.319,0.261,0.174,
0.127,0.209,0.152,0.122,0.121,0.151,0.160,0.022,0.107,0.158,
0.185,0.166,0.157,0.316,0.179,0.135,0.106,0.152,0.143,0.122,
0.116,0.134,0.138,0.016,0.131,0.181,0.147,0.170,0.149,0.238,
0.180,0.179,0.140,0.207,0.020,0.016,0.014,0.023,0.177,0.020,
0.148,0.217,0.175,0.216,0.201,0.270,0.280,0.152,0.164,0.299,
0.478,0.185,0.168,0.265,0.312,0.024,0.265,0.384,0.410,0.341,
0.393,0.556,3.460,2.370,1.810,3.530,2.250,1.700,1.350,1.710,
2.080,0.211,1.530,1.900,2.780,2.270,1.550,2.580,2.330,1.570,
1.010,1.550,1.540,1.000,0.964,1.130,1.380,0.129,0.959,1.200,
1.210,1.300,1.050,1.570,1.750,1.330,0.972,1.450,0.130,0.108,
0.090,0.169,1.200,0.115,0.827,0.947,0.971,1.110,0.960,1.330,
1.770,0.938,0.755,1.610,1.310,0.905,0.787,1.150,1.690,0.116,
1.000,1.240,1.620,0.868,1.180,2.230,3.350,2.080,1.270,2.720,
2.130,1.510,1.220,1.350,1.570,0.178,0.990,1.250,1.430,1.530,
0.928,1.650,2.490,2.230,1.110,1.610,1.640,1.030,1.220,1.080,
1.930,0.246,1.330,2.030,1.200,1.620,1.070,1.440,1.860,1.750,
1.200,1.470,0.171,0.172,0.143,0.180,1.840,0.215,1.410,1.820,
1.130,1.560,1.260,1.450,1.380,0.971,0.642,1.160,1.610,1.310,
0.946,1.380,1.430,0.126,1.090,1.650,1.260,1.120,1.220,2.300,
2.370,1.230,0.803,1.450,2.270,1.540,1.340,1.470,2.140,0.291,
1.050,1.380,1.640,1.730,1.250,2.050,0.259,0.228,0.120,0.185,
0.258,0.219,0.182,0.188,0.250,0.054,0.182,0.236,0.260,0.433,
0.236,0.377,1.320,1.190,1.120,1.400,0.172,0.160,0.174,0.179,
2.340,0.590,1.130,1.250,1.000,1.810,1.150,1.200,1.010,0.729,
0.576,0.900,1.620,1.260,1.100,1.410,1.550,0.207,1.060,1.420,
1.260,1.230,1.350,1.830,2.520,1.030,0.770,1.560,1.330,0.815,
0.718,0.893,1.500,0.140,0.700,0.980,1.740,1.440,1.030,2.130,
2.320,1.590,0.894,1.270,1.540,1.130,0.966,1.040,1.530,0.135,
1.010,1.390,1.590,1.700,1.360,2.620,1.670,1.450,1.340,1.610,
0.157,0.117,0.121,0.163,3.280,0.266,1.260,1.610,1.540,1.810,
1.660,1.910,1.940,1.090,0.922,1.700,1.370,0.816,0.995,1.340,
2.920,0.216,1.480,2.240,2.610,2.030,2.270,3.820,0.230,0.178,
0.130,0.196,0.168,0.163,0.120,0.149,0.130,0.019,0.079,0.103,
0.129,0.137,0.114,0.161,0.192,0.183,0.131,0.160,0.187,0.167,
0.170,0.146,0.166,0.035,0.127,0.157,0.096,0.147,0.125,0.147,
0.109,0.116,0.074,0.092,0.017,0.024,0.016,0.021,0.091,0.025,
0.082,0.102,0.060,0.106,0.084,0.110,0.108,0.074,0.054,0.098,
0.119,0.117,0.081,0.105,0.107,0.013,0.080,0.114,0.109,0.092,
0.122,0.212,0.198,0.189,0.102,0.151,0.151,0.173,0.131,0.123,
0.102,0.026,0.077,0.085,0.077,0.112,0.077,0.103,0.216,0.348,
0.123,0.132,0.173,0.144,0.168,0.113,0.191,0.080,0.162,0.183,
0.089,0.184,0.113,0.125,0.104,0.171,0.101,0.095,0.021,0.041,
0.036,0.023,0.191,0.067,0.179,0.194,0.097,0.180,0.124,0.121,
0.086,0.069,0.052,0.073,0.112,0.115,0.086,0.101,0.100,0.017,
0.090,0.111,0.069,0.085,0.087,0.140,0.161,0.126,0.074,0.093,
0.177,0.188,0.170,0.132,0.159,0.044,0.109,0.115,0.089,0.139,
0.130,0.145,0.020,0.035,0.017,0.020,0.031,0.048,0.052,0.029,
0.027,0.028,0.047,0.031,0.015,0.049,0.036,0.027,0.099,0.182,
0.131,0.134,0.028,0.060,0.058,0.027,0.437,0.323,0.224,0.190,
0.105,0.448,0.199,0.151,0.077,0.059,0.061,0.078,0.134,0.164,
0.147,0.157,0.152,0.052,0.151,0.138,0.077,0.134,0.148,0.156,
0.226,0.161,0.105,0.164,0.130,0.106,0.085,0.104,0.130,0.016,
0.071,0.089,0.139,0.150,0.132,0.214,0.261,0.212,0.131,0.175,
0.255,0.219,0.178,0.195,0.185,0.033,0.147,0.180,0.165,0.260,
0.202,0.292,0.114,0.147,0.134,0.147,0.016,0.021,0.022,0.022,
0.220,0.060,0.150,0.157,0.124,0.216,0.232,0.207,0.141,0.100,
0.084,0.134,0.141,0.103,0.097,0.128,0.182,0.022,0.137,0.189,
0.189,0.172,0.213,0.316,2.310,2.070,1.460,2.290,1.560,1.290,
0.962,1.250,1.880,0.169,0.878,1.300,1.200,1.050,0.774,1.350,
2.730,2.140,1.220,1.500,2.380,1.800,1.650,1.490,4.310,0.382,
1.970,3.770,1.280,1.760,1.000,1.620,1.460,1.820,1.150,1.360,
0.200,0.243,0.202,0.276,1.510,0.196,1.360,1.560,1.030,1.700,
1.200,1.670,1.350,0.899,0.659,1.160,1.310,1.180,0.985,1.310,
1.710,0.181,1.350,2.030,1.650,1.280,1.560,2.890,0.206,0.197,
0.094,0.144,0.201,0.240,0.131,0.171,0.142,0.034,0.114,0.139,
0.093,0.125,0.086,0.127,0.213,0.229,0.111,0.128,0.264,0.254,
0.235,0.184,0.276,0.072,0.242,0.326,0.095,0.164,0.105,0.130,
0.120,0.205,0.171,0.120,0.026,0.055,0.059,0.034,0.218,0.063,
0.236,0.223,0.097,0.201,0.155,0.149,0.139,0.101,0.064,0.128,
0.198,0.202,0.152,0.195,0.177,0.029,0.155,0.333,0.133,0.129,
0.140,0.273,2.580,1.460,1.030,1.100,1.750,1.770,1.550,1.490,
1.770,0.384,1.700,1.600,0.984,1.410,1.430,2.030,0.178,0.243,
0.144,0.121,0.175,0.257,0.212,0.121,0.239,0.077,0.298,0.249,
0.121,0.254,0.194,0.207,1.520,1.360,1.310,1.020,0.201,0.179,
0.222,0.151,1.180,0.210,0.433,0.586,0.598,0.919,1.020,1.050,
0.854,0.639,0.642,0.631,1.190,1.170,1.120,0.991,1.240,0.184,
1.520,1.450,0.800,0.996,1.360,1.660,1.580,0.963,0.737,1.150,
1.050,0.846,0.608,0.706,0.988,0.112,0.855,0.955,0.811,0.802,
0.757,1.220,1.960,1.800,1.120,1.380,1.770,1.800,1.410,1.160,
1.620,0.210,1.790,1.750,1.100,1.610,1.320,1.480,1.230,1.410,
1.240,1.400,0.151,0.176,0.188,0.165,1.510,0.190,2.270,1.690,
0.924,1.550,1.470,1.530,1.250,0.860,0.719,1.210,1.710,1.060,
0.902,1.130,1.720,0.179,2.010,1.990,1.670,1.750,1.750,2.260,
2.930,1.520,1.110,2.170,1.350,0.999,1.050,1.200,1.390,0.140,
0.788,1.110,1.360,1.230,0.902,1.620,1.820,1.150,0.726,1.010,
1.150,0.792,0.768,0.800,1.460,0.107,0.747,1.280,0.751,0.857,
0.618,1.000,1.370,1.200,0.688,1.090,0.117,0.110,0.082,0.161,
1.040,0.101,0.722,1.060,0.786,1.080,0.846,1.280,1.410,0.811,
0.639,1.290,1.160,0.794,0.693,1.150,1.170,0.097,0.759,1.250,
1.400,1.070,1.110,2.310,2.800,1.940,1.070,1.840,1.920,1.500,
1.250,1.420,1.390,0.159,1.140,1.510,1.290,1.350,0.801,1.630,
2.250,1.910,1.130,1.570,1.930,1.550,1.700,1.430,1.580,0.194,
1.580,2.310,0.883,1.270,0.859,1.330,1.430,1.690,1.010,1.270,
0.132,0.183,0.141,0.173,1.780,0.214,1.430,2.070,0.994,1.730,
1.230,1.690,1.370,0.956,0.746,1.270,1.680,1.390,1.120,1.610,
1.600,0.153,1.220,2.380,1.310,1.260,1.250,2.330,2.450,1.410,
1.180,1.400,1.930,1.530,1.570,1.550,2.520,0.302,1.630,1.690,
1.520,1.540,1.660,2.260,0.172,0.159,0.112,0.135,0.152,0.198,
0.171,0.146,0.178,0.038,0.213,0.203,0.134,0.221,0.182,0.200,
1.600,1.830,1.330,1.380,0.161,0.181,0.189,0.196,3.270,0.567,
1.560,1.980,1.300,2.670,1.790,1.780,1.190,0.908,0.816,1.060,
1.570,1.370,1.460,1.650,1.790,0.225,2.100,2.340,1.340,1.460,
1.870,2.420,2.350,1.170,1.040,1.620,1.230,0.892,0.912,0.912,
1.430,0.148,0.969,1.150,1.510,1.120,1.130,1.940,1.880,1.420,
1.050,1.330,1.350,1.190,1.160,1.080,1.400,0.125,1.470,1.590,
1.210,1.270,1.560,1.740,2.050,1.820,1.340,1.810,0.150,0.141,
0.147,0.183,2.270,0.211,1.930,2.410,1.580,1.960,1.930,2.190,
2.270,1.250,1.180,2.150,1.990,1.500,1.550,2.030,2.390,0.199,
2.330,3.020,2.690,2.090,2.540,3.490,4.580,2.230,2.110,4.430,
2.020,1.220,1.070,1.670,2.110,0.169,0.995,1.590,2.910,2.160,
1.410,2.710,2.360,1.280,0.976,1.370,1.200,0.712,0.678,0.839,
1.190,0.088,0.767,1.010,1.200,1.120,0.848,1.450,1.620,1.140,
0.991,1.560,0.121,0.095,0.091,0.173,0.974,0.078,0.624,0.905,
0.952,1.000,0.883,1.420,2.380,1.090,1.040,2.140,1.500,1.020,
1.040,1.410,1.750,0.116,0.996,1.570,2.140,1.280,1.530,3.400,
3.270,1.670,1.200,2.190,1.640,0.967,0.718,0.986,1.180,0.103,
0.615,0.960,1.270,1.110,0.711,1.490,1.740,1.140,0.742,1.020,
0.931,0.627,0.577,0.625,1.100,0.090,0.639,1.050,0.900,0.968,
0.651,1.310,1.210,0.954,0.781,1.050,0.078,0.075,0.059,0.090,
0.957,0.077,0.609,0.840,0.964,0.885,0.753,1.010,1.190,0.780,
0.562,1.070,1.040,0.911,0.564,0.890,1.010,0.071,0.741,1.100,
1.110,0.926,0.955,1.880,3.070,1.320,0.988,1.540,2.140,0.986,
0.896,1.290,1.620,0.166,0.615,1.060,1.840,1.350,1.000,2.160,
0.196,0.125,0.088,0.126,0.136,0.093,0.088,0.109,0.134,0.017,
0.071,0.109,0.213,0.212,0.133,0.245,1.360,0.942,0.997,1.500,
0.113,0.075,0.087,0.133,1.400,0.164,0.664,0.995,1.270,1.240,
1.120,1.490,1.300,0.715,0.741,1.390,1.400,0.892,0.830,1.320,
1.360,0.138,0.866,1.620,1.440,1.170,1.450,2.560,4.210,1.400,
1.100,2.330,1.920,0.886,0.821,1.190,1.840,0.137,0.787,1.190,
2.990,1.680,1.530,2.800,2.260,1.200,0.990,1.340,1.210,0.782,
0.801,0.930,1.290,0.090,0.759,1.140,1.840,1.530,1.110,2.000,
1.580,1.100,1.020,1.700,0.131,0.076,0.084,0.128,1.650,0.104,
0.750,1.160,2.870,1.520,1.410,1.870,2.460,1.170,1.120,2.430,
1.650,0.840,1.020,1.480,2.080,0.126,1.250,2.120,3.000,2.090,
2.590,5.100,5.210,2.690,2.060,3.810,2.510,1.820,1.380,1.890,
2.030,0.196,1.020,1.610,2.430,2.020,1.420,2.720,2.940,1.800,
1.470,1.920,1.810,1.270,1.360,1.450,1.690,0.158,1.320,1.620,
1.240,1.460,1.220,1.810,2.140,1.470,1.110,1.590,0.147,0.150,
0.106,0.177,1.230,0.133,0.973,1.350,0.941,1.300,1.230,1.910,
2.300,1.120,0.900,1.720,1.770,1.560,1.010,1.440,1.430,0.124,
0.912,1.590,1.670,1.360,1.480,3.100,3.450,2.320,1.310,2.160,
2.060,1.710,1.140,1.340,1.380,0.155,0.803,1.180,1.300,1.530,
0.864,1.730,2.370,1.980,1.250,1.530,1.850,1.170,1.190,1.160,
1.870,0.250,1.240,1.730,1.160,1.830,1.020,1.590,1.630,1.510,
1.030,1.370,0.118,0.145,0.087,0.113,1.560,0.224,1.330,1.520,
1.090,1.640,1.260,1.850,1.220,0.935,0.674,1.110,1.340,1.220,
0.725,1.070,1.100,0.109,0.980,1.220,1.050,1.220,1.080,1.980,
3.520,1.740,1.050,1.600,2.220,1.730,1.450,1.670,1.850,0.259,
0.954,1.500,1.640,1.620,1.300,2.750,0.213,0.164,0.093,0.143,
0.167,0.192,0.151,0.154,0.139,0.039,0.130,0.152,0.152,0.260,
0.156,0.220,1.520,1.590,1.330,1.690,0.150,0.201,0.168,0.194,
1.970,0.525,1.260,1.640,1.280,2.300,1.820,2.250,1.330,0.877,
0.852,1.400,1.730,1.580,1.410,1.860,1.580,0.193,1.430,1.930,
1.470,1.480,2.140,3.060,4.830,1.770,1.320,2.480,1.860,1.210,
1.050,1.520,1.960,0.166,0.927,1.460,2.120,1.610,1.500,2.900,
3.260,1.930,1.380,1.930,1.960,1.640,1.440,1.730,1.880,0.178,
1.370,1.920,1.900,2.520,1.730,2.730,1.700,1.500,1.450,1.890,
0.131,0.118,0.120,0.160,1.600,0.176,1.280,1.720,1.470,1.880,
2.110,2.650,2.110,1.220,1.140,1.970,1.910,1.260,1.110,1.740,
1.930,0.145,1.490,2.280,2.460,2.020,2.680,4.440,7.300,2.500,
2.090,3.100,1.990,1.450,1.040,1.610,1.930,0.164,0.951,1.590,
2.210,1.450,1.040,2.160,3.200,2.300,1.460,1.900,2.060,1.600,
1.430,1.600,2.550,0.257,2.110,3.370,1.630,2.000,1.330,2.310,
1.920,2.170,1.470,2.090,0.202,0.210,0.185,0.353,1.580,0.184,
1.180,1.660,1.270,2.100,1.730,2.310,1.930,1.300,0.993,1.940,
2.050,1.490,1.190,2.300,1.880,0.201,1.520,2.900,2.330,1.990,
2.250,4.960,0.336,0.201,0.286,0.220,0.172,0.179,0.107,0.165,
0.143,0.019,0.106,0.238,0.131,0.165,0.143,0.192,0.200,0.194,
0.125,0.149,0.195,0.222,0.159,0.190,0.229,0.059,0.319,1.290,
0.118,0.208,0.133,0.289,0.106,0.156,0.109,0.115,0.035,0.029,
0.031,0.022,0.216,0.037,0.163,0.208,0.123,0.253,0.276,0.202,
0.160,0.117,0.080,0.161,0.420,0.219,0.134,0.217,0.151,0.025,
0.138,0.290,0.171,0.166,0.190,0.329,3.280,1.840,1.220,1.430,
2.190,2.010,1.670,1.610,1.930,0.329,1.620,1.870,1.560,1.780,
1.800,2.550,0.183,0.193,0.108,0.114,0.159,0.186,0.135,0.115,
0.180,0.048,0.294,0.276,0.169,0.271,0.197,0.228,1.870,2.150,
1.660,1.610,0.240,0.278,0.199,0.193,2.190,0.288,1.070,1.590,
1.250,2.050,1.910,2.030,1.660,1.060,0.999,1.290,2.540,2.070,
1.560,1.660,1.760,0.224,1.930,2.390,1.550,1.770,2.090,3.140,
3.470,1.710,1.140,1.950,1.760,1.360,1.000,1.230,2.960,0.225,
1.480,2.450,1.930,1.480,1.410,2.590,2.900,2.260,1.420,1.910,
2.050,2.000,1.380,1.390,2.380,0.219,2.440,2.760,1.990,2.560,
2.030,2.600,1.900,2.030,1.660,2.000,0.181,0.207,0.159,0.182,
2.260,0.218,1.980,2.360,1.840,2.890,3.240,3.000,2.470,1.360,
1.290,1.900,2.620,1.580,1.400,1.610,2.680,0.218,2.580,3.270,
2.850,2.730,3.100,4.250,5.170,2.330,1.500,3.190,1.800,1.120,
0.902,1.540,1.890,0.162,0.967,1.640,2.230,1.590,1.160,2.770,
2.360,1.450,0.890,1.340,1.210,0.836,0.735,0.947,1.400,0.111,
0.864,1.460,1.100,1.060,0.830,1.550,1.800,1.690,1.010,2.170,
0.155,0.152,0.098,0.287,1.250,0.113,0.757,1.350,1.190,1.430,
1.090,1.850,2.150,1.160,1.040,2.380,1.410,0.966,0.831,1.640,
1.460,0.117,0.970,1.840,2.130,1.540,1.840,4.740,3.460,1.890,
1.510,2.470,1.830,1.250,0.988,1.550,1.420,0.130,0.859,1.560,
1.450,1.340,0.960,2.230,2.350,1.610,1.300,1.480,1.660,1.270,
1.130,1.200,1.550,0.153,1.330,3.090,1.230,1.370,0.927,1.900,
1.540,1.370,0.851,1.460,0.101,0.111,0.077,0.124,1.480,0.136,
1.060,1.660,1.270,1.680,1.450,2.060,1.550,1.070,0.842,1.670,
1.690,1.190,0.872,1.400,1.500,0.114,1.100,1.980,1.590,1.260,
1.600,3.110,3.600,1.900,1.500,1.910,2.460,1.760,1.480,2.000,
2.900,0.316,1.400,1.970,2.270,2.110,1.890,3.320,0.203,0.158,
0.140,0.150,0.154,0.153,0.124,0.141,0.167,0.025,0.133,0.185,
0.203,0.244,0.158,0.255,2.170,2.180,1.520,2.080,0.159,0.167,
0.140,0.202,2.790,0.289,1.700,2.390,1.830,2.540,2.330,3.030,
2.090,1.460,1.190,1.980,2.100,1.730,1.650,2.330,2.490,0.214,
2.140,3.340,1.950,1.960,2.250,4.200,5.300,2.100,1.530,2.940,
1.940,1.360,1.130,1.660,2.490,0.208,1.300,2.080,3.180,2.290,
1.940,4.580,3.060,1.980,1.610,2.100,2.000,1.700,1.330,1.580,
2.450,0.160,2.020,2.590,2.580,2.500,2.100,3.270,2.840,2.330,
1.810,2.860,0.165,0.159,0.111,0.217,2.980,0.213,2.060,3.160,
2.910,3.140,3.170,4.340,4.760,1.960,1.810,3.980,2.790,2.060,
1.880,3.150,4.160,0.236,3.010,4.790,4.750,3.380,3.990,6.850,
16.8,6.930,5.810,13.0,5.400,3.040,2.710,4.310,6.120,0.467,
2.470,4.160,10.4,6.930,3.740,8.600,5.380,2.740,2.380,3.190,
2.880,1.460,1.540,1.690,2.630,0.162,1.370,1.860,2.760,2.060,
1.660,2.950,4.520,2.460,2.210,4.040,0.318,0.177,0.158,0.379,
2.170,0.153,1.050,1.930,2.700,2.150,1.770,3.030,8.220,2.980,
3.140,7.380,5.880,2.570,2.580,4.520,3.620,0.223,1.710,2.990,
6.210,3.010,2.970,6.700,6.450,2.570,1.960,3.410,2.620,1.610,
1.190,1.710,2.270,0.177,0.885,1.540,2.540,2.050,1.030,2.380,
2.910,1.540,1.020,1.610,1.430,0.800,0.752,0.933,1.530,0.106,
0.770,1.130,1.480,1.100,0.783,1.510,2.490,1.600,1.330,1.940,
0.150,0.099,0.084,0.148,1.550,0.111,0.765,1.150,1.370,1.240,
0.873,1.490,3.100,1.560,1.390,2.500,2.540,1.460,1.260,1.780,
1.970,0.123,0.999,1.590,2.310,1.560,1.430,3.030,4.400,1.930,
1.620,2.800,2.510,1.390,1.400,1.810,2.430,0.233,0.998,1.680,
3.120,2.060,1.740,4.110,0.274,0.184,0.122,0.206,0.165,0.135,
0.107,0.140,0.171,0.018,0.094,0.143,0.295,0.267,0.167,0.349,
2.030,1.540,1.090,2.130,0.144,0.207,0.075,0.156,1.330,0.110,
0.684,0.987,1.220,1.130,1.030,1.680,2.240,1.230,1.170,2.290,
2.190,1.550,1.120,1.900,2.620,0.204,1.110,1.860,2.160,1.750,
1.750,3.540,7.130,2.590,2.560,5.610,2.880,1.420,1.690,2.310,
3.350,0.242,1.310,2.350,5.260,2.970,2.530,6.680,4.040,2.180,
1.600,2.620,2.110,1.310,1.140,1.470,2.130,0.124,1.250,1.850,
2.780,2.030,1.690,3.250,2.670,1.750,1.510,2.550,0.166,0.117,
0.094,0.175,1.920,0.111,0.993,1.540,1.990,1.810,1.570,2.580,
5.860,2.260,2.280,4.670,2.690,1.620,1.490,2.320,3.930,0.189,
1.840,3.210,5.690,3.620,3.740,9.160,7.110,3.170,2.580,4.890,
2.730,1.600,1.420,2.040,2.160,0.176,0.977,1.810,3.010,2.490,
1.650,3.310,3.320,1.640,1.270,1.940,1.600,0.980,1.110,1.160,
1.410,0.102,0.798,1.300,1.270,1.150,0.953,1.670,1.930,1.440,
1.010,1.750,0.148,0.165,0.085,0.167,0.937,0.088,0.576,0.921,
1.060,1.200,0.829,1.510,2.530,1.200,1.120,2.320,1.820,1.260,
0.955,1.520,1.480,0.108,0.851,1.310,2.050,1.390,1.600,3.080,
3.910,2.080,1.170,2.070,1.840,1.290,0.793,1.070,1.410,0.130,
0.602,1.010,1.420,1.410,0.692,1.640,2.090,1.230,0.690,1.170,
1.030,0.494,0.582,0.669,0.976,0.083,0.694,0.911,0.855,0.931,
0.583,1.110,1.660,1.310,0.791,1.260,0.108,0.139,0.056,0.090,
1.180,0.162,0.575,0.762,0.844,1.130,0.646,1.140,1.730,0.965,
0.788,1.670,1.210,0.959,0.651,0.935,1.430,0.099,0.723,1.010,
1.280,1.110,0.836,1.920,2.860,1.500,1.070,1.890,1.650,1.350,
1.090,1.430,1.490,0.145,0.769,1.150,1.860,1.390,1.140,2.390,
0.139,0.168,0.071,0.165,0.098,0.236,0.080,0.107,0.101,0.020,
0.081,0.111,0.134,0.167,0.100,0.186,1.830,4.730,1.120,1.560,
0.347,2.070,0.109,0.179,1.020,0.246,0.581,0.896,0.925,1.460,
0.794,1.220,1.490,1.380,0.814,1.660,1.750,4.430,0.942,1.570,
1.390,0.148,0.803,1.380,1.300,1.230,1.130,2.170,2.740,1.310,
1.120,2.250,1.370,0.787,0.758,1.200,1.380,0.098,0.608,1.020,
1.750,1.160,1.020,2.410,1.910,1.240,0.956,1.820,1.080,0.926,
0.768,1.220,0.945,0.066,0.912,1.110,1.150,1.090,0.977,1.700,
1.450,1.510,1.010,1.670,0.110,0.263,0.050,0.114,1.110,0.132,
0.589,0.939,1.120,1.310,0.891,1.570,2.030,0.981,1.060,2.180,
1.400,1.220,0.765,1.340,1.920,0.117,0.971,1.870,2.220,1.870,
1.910,3.720,5.080,2.900,1.900,4.070,1.860,1.370,1.410,1.810,
1.910,0.178,0.887,1.690,2.570,2.060,1.150,2.980,3.330,2.010,
1.830,2.600,2.070,1.390,6.440,3.830,1.990,0.180,1.210,1.660,
1.950,1.860,1.320,2.270,2.180,1.920,1.380,2.420,0.186,0.174,
0.190,0.330,1.190,0.113,0.554,0.946,1.220,1.560,0.953,1.740,
3.400,1.680,1.550,3.680,2.290,1.570,1.370,2.370,1.980,0.155,
0.948,1.990,3.150,2.140,1.980,5.410,0.276,0.210,0.129,0.263,
0.184,0.157,0.095,0.131,0.137,0.019,0.066,0.127,0.174,0.198,
0.094,0.228,0.237,0.179,0.096,0.152,0.163,0.133,0.237,0.175,
0.167,0.027,0.096,0.149,0.187,0.181,0.099,0.196,0.140,0.167,
0.092,0.177,0.012,0.016,0.012,0.018,0.152,0.016,0.066,0.097,
0.145,0.159,0.093,0.159,0.320,0.207,0.157,0.378,0.288,0.229,
0.171,0.282,0.179,0.018,0.110,0.207,0.310,0.241,0.194,0.467,
2.450,1.340,0.957,1.480,1.380,1.050,0.920,1.170,1.730,0.196,
1.030,1.310,1.740,1.390,1.140,2.170,0.166,0.135,0.084,0.129,
0.098,0.113,0.139,0.110,0.124,0.022,0.104,0.108,0.181,0.178,
0.111,0.175,1.420,1.760,0.812,1.120,0.130,0.188,0.084,0.109,
0.986,0.105,0.559,0.687,0.906,1.190,0.802,1.150,1.590,1.030,
0.913,1.430,1.660,1.460,0.909,1.350,1.510,0.141,1.420,1.610,
1.480,1.370,1.430,2.440,2.780,1.350,1.030,2.230,1.400,0.874,
0.696,1.050,1.530,0.131,0.806,1.510,2.140,1.490,1.140,3.100,
2.530,1.770,1.050,2.030,1.470,1.400,0.975,1.160,1.530,0.123,
1.060,1.520,1.970,1.740,1.200,2.210,1.810,1.600,1.030,1.740,
0.132,0.114,0.071,0.135,1.250,0.101,0.908,1.220,1.320,1.610,
1.170,1.990,2.780,1.410,1.350,2.480,2.140,1.310,1.040,1.650,
2.140,0.147,1.510,2.390,2.950,2.350,2.400,5.170,8.420,3.700,
3.030,6.710,2.670,1.530,1.510,2.040,2.880,0.212,1.270,2.280,
5.030,2.950,2.360,5.620,3.390,1.590,1.320,2.340,1.710,0.889,
2.020,1.740,2.070,0.111,1.070,1.780,2.120,1.330,1.310,2.510,
3.020,2.000,1.560,3.370,0.212,0.143,0.125,0.308,1.830,0.126,
0.865,1.700,2.080,1.810,1.340,3.010,5.770,2.340,2.690,8.280,
3.000,1.670,1.850,3.300,2.990,0.180,1.600,2.890,5.080,2.800,
2.930,8.020,4.660,2.300,1.630,3.370,2.190,1.370,0.972,1.480,
1.970,0.143,0.865,1.660,2.230,1.890,1.100,2.740,2.620,1.560,
0.815,1.500,1.600,1.040,0.822,1.070,1.500,0.112,0.857,1.400,
1.600,1.300,0.785,1.700,2.180,1.670,0.975,2.130,0.116,0.103,
0.066,0.142,1.710,0.119,0.783,1.370,1.930,1.680,1.010,2.090,
3.440,1.700,1.540,3.480,2.320,1.560,1.490,2.450,2.260,0.132,
1.180,2.190,3.040,2.240,1.840,4.290,3.390,1.710,1.380,2.280,
2.150,1.310,1.240,1.840,2.320,0.204,1.330,1.880,2.320,1.720,
2.120,3.780,0.195,0.141,0.094,0.173,0.111,0.111,0.093,0.116,
0.139,0.011,0.109,0.144,0.211,0.185,0.149,0.268,1.900,1.960,
1.120,1.850,0.126,0.192,0.083,0.157,1.720,0.135,1.250,1.440,
1.740,1.750,1.480,2.380,2.510,1.440,1.430,2.600,2.420,1.920,
1.500,2.620,3.490,0.198,2.080,2.980,2.990,2.210,2.630,4.830,
6.690,2.680,2.680,5.380,2.700,1.520,1.570,2.430,3.190,0.242,
1.640,3.360,5.300,3.150,3.270,12.9,3.300,2.070,1.460,2.820,
1.710,1.230,1.150,1.730,2.080,0.124,1.430,2.350,2.820,2.240,
1.800,4.070,3.430,3.020,2.330,4.050,0.201,0.170,0.119,0.276,
2.900,0.175,1.840,2.730,3.350,3.180,2.620,4.480,7.360,3.270,
3.360,7.830,4.270,2.940,2.780,4.870,6.480,0.311,4.080,7.010,
11.2,7.010,7.380,15.1,5.710,3.330,2.940,5.040,3.130,1.810,
1.640,2.310,2.700,0.236,1.300,2.140,4.290,3.130,1.930,3.780,
3.230,2.250,1.380,1.990,2.090,1.180,1.040,1.260,1.570,0.123,
1.050,1.360,1.620,1.340,1.210,1.850,2.230,1.450,1.390,2.060,
0.168,0.121,0.111,0.210,1.340,0.101,0.791,0.992,1.350,1.350,
1.320,1.760,3.330,1.610,1.550,3.020,2.610,1.540,1.440,2.100,
2.490,0.193,1.210,2.000,2.970,2.130,1.880,3.980,3.790,2.150,
1.480,2.370,2.070,1.370,0.972,1.400,1.740,0.208,1.110,1.420,
2.020,1.840,0.928,2.040,2.250,1.410,0.950,1.450,1.340,0.880,
0.835,0.992,1.510,0.117,1.100,1.440,1.270,1.060,0.837,1.460,
1.570,1.250,1.470,1.570,0.112,0.094,0.109,0.128,1.250,0.137,
0.824,0.979,1.020,1.170,0.926,1.240,1.590,1.020,1.040,1.450,
1.440,1.050,1.110,1.320,1.340,0.096,0.809,1.290,1.470,1.310,
1.190,2.330,2.860,1.410,0.908,1.660,1.780,1.010,0.939,1.300,
1.510,0.156,0.703,1.090,1.680,1.300,1.100,2.470,0.150,0.127,
0.077,0.137,0.131,0.110,0.090,0.114,0.116,0.016,0.071,0.105,
0.149,0.176,0.122,0.215,1.250,0.896,0.805,1.100,0.106,0.077,
0.069,0.109,0.933,0.083,0.477,0.731,0.857,0.885,0.786,1.220,
1.350,0.797,0.719,1.410,1.500,0.980,0.822,1.310,1.720,0.136,
0.796,1.320,1.490,1.330,1.410,2.610,3.310,1.460,1.130,2.240,
1.810,0.959,0.768,1.120,1.780,0.180,0.711,1.190,2.380,1.680,
1.120,2.870,2.420,1.480,1.040,1.650,1.760,1.330,0.894,1.120,
1.290,0.107,0.779,1.260,1.450,1.390,1.080,1.940,1.460,1.050,
0.939,1.490,0.142,0.082,0.074,0.128,1.060,0.089,0.629,1.040,
1.380,1.320,1.030,1.750,2.380,1.230,1.150,2.350,2.380,1.200,
1.010,1.540,2.110,0.147,1.220,2.180,3.100,2.650,2.640,5.990,
4.120,2.390,1.800,2.930,2.450,1.510,1.230,1.630,1.600,0.144,
0.800,1.190,1.980,1.680,1.210,2.260,2.390,1.580,1.090,1.430,
1.550,1.110,0.926,1.070,1.130,0.106,0.742,0.978,0.935,1.140,
0.820,1.270,1.280,1.140,0.799,1.170,0.100,0.096,0.069,0.121,
0.729,0.071,0.490,0.648,0.750,0.857,0.653,1.280,1.660,0.865,
0.740,1.610,1.380,1.010,0.751,1.170,1.350,0.100,0.688,0.955,
1.810,1.220,1.060,2.560,2.670,1.810,0.920,1.580,1.650,1.480,
0.803,1.050,0.962,0.096,0.570,0.835,1.090,1.090,0.598,1.490,
1.840,1.040,0.580,1.110,1.100,0.523,0.621,0.858,0.862,0.102,
0.596,0.817,0.764,0.995,0.620,1.050,1.130,1.130,0.679,0.976,
0.089,0.108,0.072,0.085,0.906,0.126,0.559,0.710,0.652,0.991,
0.622,1.010,1.320,0.817,0.815,1.030,1.010,0.989,0.664,0.803,
0.959,0.073,0.565,0.869,1.090,0.991,0.730,1.670,2.320,1.290,
0.788,1.330,1.520,1.180,0.931,1.100,1.250,0.140,0.627,0.868,
1.390,1.150,1.010,1.860,0.112,0.127,0.063,0.116,0.089,0.141,
0.089,0.090,0.089,0.029,0.080,0.090,0.100,0.162,0.089,0.133,
1.550,1.770,0.889,1.340,0.136,0.322,0.102,0.136,0.927,0.122,
0.605,0.772,0.829,1.200,0.974,1.280,1.220,0.821,0.702,1.200,
1.390,1.460,0.947,1.370,1.490,0.108,0.825,1.260,1.370,1.080,
1.340,2.230,2.000,1.050,0.760,1.400,1.180,0.730,0.602,0.850,
1.080,0.085,0.675,0.799,1.370,0.973,0.777,1.740,1.640,1.260,
0.807,1.270,1.150,1.090,0.785,1.110,0.947,0.122,0.670,0.943,
1.010,1.110,0.841,1.360,1.180,1.120,0.742,1.120,0.088,0.097,
0.055,0.091,0.918,0.094,0.539,0.757,1.250,1.300,0.874,1.330,
1.570,0.834,0.784,1.430,1.370,1.000,0.736,1.100,1.420,0.111,
0.953,1.470,1.830,1.610,1.590,2.870,3.370,2.180,1.420,2.740,
1.470,1.150,0.831,1.200,1.640,0.157,1.040,1.180,1.880,1.600,
0.972,1.970,2.340,1.650,0.969,1.560,1.470,1.170,1.210,1.190,
1.940,0.186,1.360,1.420,1.380,2.010,1.000,1.710,1.430,1.400,
1.040,1.520,0.144,0.139,0.129,0.229,1.510,0.131,0.716,0.909,
0.941,1.430,1.810,1.500,1.750,1.060,0.910,2.060,1.500,1.110,
1.040,1.730,1.500,0.140,0.947,1.520,2.040,1.710,1.770,3.860,
0.146,0.135,0.070,0.162,0.110,0.130,0.060,0.096,0.102,0.015,
0.058,0.084,0.116,0.128,0.064,0.146,0.142,0.117,0.058,0.090,
0.133,0.156,0.096,0.103,0.159,0.024,0.091,0.113,0.106,0.169,
0.068,0.196,0.077,0.096,0.067,0.093,0.015,0.017,0.015,0.014,
0.425,0.039,0.112,0.117,0.108,0.122,0.120,0.116,0.126,0.090,
0.070,0.166,0.198,0.144,0.101,0.175,0.127,0.015,0.085,0.154,
0.146,0.127,0.125,0.253,2.580,1.540,0.927,1.330,1.470,1.290,
0.992,1.160,1.710,0.201,0.946,1.250,1.360,1.330,1.110,2.040,
0.147,0.163,0.071,0.104,0.113,0.166,0.105,0.090,0.123,0.022,
0.107,0.131,0.126,0.190,0.116,0.166,1.270,1.780,0.806,1.070,
0.120,0.152,0.087,0.126,1.120,0.143,0.625,0.881,0.844,1.310,
1.040,1.320,1.360,1.020,0.848,1.240,1.710,1.420,0.993,1.500,
1.500,0.154,1.180,1.670,1.360,1.380,1.590,2.680,2.340,1.370,
0.958,1.790,1.340,0.936,0.669,0.954,1.480,0.130,0.754,1.260,
1.960,1.460,0.958,2.360,2.360,1.890,0.995,1.620,2.230,2.210,
1.080,1.370,1.650,0.161,1.220,1.870,1.670,2.000,1.270,2.180,
1.580,1.450,1.050,1.480,0.216,0.118,0.076,0.131,1.320,0.122,
0.905,1.400,1.370,1.850,1.260,1.960,2.320,1.220,1.030,2.030,
4.400,1.320,1.020,1.600,2.130,0.147,1.600,2.530,2.850,2.550,
2.540,4.790,4.090,2.170,1.690,3.720,1.850,1.080,1.010,1.830,
1.870,0.145,0.860,1.530,2.510,1.690,1.550,2.980,2.180,1.360,
0.829,1.470,1.290,0.829,0.749,1.060,1.340,0.088,0.791,1.240,
1.230,1.040,0.791,1.630,1.670,1.340,1.090,2.080,0.127,0.096,
0.078,0.222,1.290,0.090,0.753,1.130,1.200,1.310,1.040,1.860,
2.480,1.270,1.440,3.340,1.750,1.060,1.110,2.280,1.750,0.122,
1.040,1.910,2.950,1.880,1.890,4.970,3.440,2.000,1.320,3.200,
1.920,1.630,0.970,1.380,1.690,0.150,0.788,1.450,1.930,1.710,
0.917,2.300,2.340,1.400,0.751,1.330,1.620,1.200,0.759,1.120,
1.490,0.145,0.845,1.410,1.670,1.490,0.856,2.140,1.470,1.260,
0.837,1.440,0.121,0.106,0.076,0.141,1.890,0.148,0.895,1.390,
1.480,1.550,0.901,1.840,1.890,1.130,1.010,2.260,1.760,1.360,
1.170,2.230,1.580,0.117,1.200,1.990,2.070,1.750,1.640,3.570,
2.410,1.290,1.010,1.630,1.670,1.170,0.979,1.520,1.720,0.180,
1.000,1.510,1.650,1.450,1.450,2.730,0.126,0.100,0.063,0.121,
0.088,0.104,0.077,0.095,0.091,0.013,0.078,0.102,0.135,0.155,
0.108,0.188,1.310,1.260,0.819,1.360,0.085,0.092,0.071,0.139,
1.350,0.129,0.937,1.330,1.130,1.380,1.180,1.800,1.490,0.950,
0.967,1.800,1.400,1.120,1.090,1.910,1.910,0.161,1.400,2.180,
1.960,1.790,2.190,3.560,3.730,1.850,1.570,2.640,1.570,1.100,
0.935,1.350,1.870,0.186,0.976,1.750,2.530,1.820,1.440,4.060,
2.410,1.540,1.050,1.640,1.550,1.230,0.940,1.300,1.350,0.101,
1.000,1.680,1.680,1.630,1.130,2.650,2.190,1.700,1.290,2.320,
0.135,0.111,0.084,0.197,1.740,0.129,1.190,1.950,2.050,2.100,
1.730,2.860,3.710,1.800,1.740,3.690,2.460,1.700,1.560,2.570,
3.030,0.193,2.500,3.980,5.450,3.960,4.490,6.930,5.310,3.360,
2.750,5.800,3.390,2.140,1.940,2.730,2.920,0.297,2.050,2.610,
4.450,3.390,2.490,4.490,3.380,2.030,1.590,2.490,2.060,1.310,
1.290,1.680,1.780,0.221,1.160,1.420,1.740,1.680,1.530,2.290,
3.940,2.100,1.700,3.370,0.204,0.134,0.137,0.322,1.710,0.127,
1.150,1.410,1.460,1.510,1.520,2.180,4.070,1.560,1.450,3.100,
2.420,1.360,1.560,2.210,2.090,0.140,1.210,1.810,3.030,1.440,
2.230,4.150,4.990,2.690,1.680,3.460,3.120,1.870,1.540,1.970,
1.970,0.192,1.190,1.680,2.200,2.040,1.370,2.800,3.160,2.180,
1.410,1.840,2.030,1.130,1.200,1.390,1.710,0.149,1.180,1.650,
1.400,1.390,1.150,1.810,2.890,2.130,1.360,2.200,0.200,0.157,
0.119,0.218,2.250,0.187,1.210,2.000,1.440,1.820,1.470,1.990,
2.970,1.720,1.180,2.220,2.590,1.910,1.430,2.310,2.160,0.153,
1.400,2.210,2.270,1.660,2.010,3.760,3.600,1.800,1.410,3.290,
3.030,2.030,1.850,2.240,2.760,0.293,1.100,1.760,2.740,2.270,
1.580,3.400,0.286,0.236,0.136,0.259,0.247,0.197,0.174,0.223,
0.241,0.029,0.153,0.200,0.331,0.382,0.223,0.408,2.030,1.570,
1.330,1.960,0.172,0.127,0.133,0.220,1.730,0.182,0.832,1.220,
1.290,1.570,1.200,1.740,1.850,1.080,1.020,1.880,2.470,1.620,
1.510,2.130,2.720,0.198,1.240,2.000,2.380,1.680,1.780,3.270,
4.120,1.900,1.450,3.430,2.240,1.290,1.270,1.610,2.320,0.239,
1.020,1.660,3.410,2.770,1.630,3.970,3.120,2.350,1.300,2.140,
1.990,1.340,1.200,1.530,1.950,0.158,1.200,1.750,2.420,2.110,
1.670,2.990,2.590,2.050,1.740,2.550,0.198,0.133,0.139,0.237,
2.930,0.204,1.280,1.990,2.090,2.390,2.020,3.020,3.790,1.840,
1.700,3.500,2.670,1.380,1.710,2.500,7.290,0.379,2.440,3.960,
5.900,3.690,3.900,7.620,0.311,0.213,0.156,0.273,0.235,0.165,
0.132,0.200,0.160,0.023,0.138,0.152,0.222,0.240,0.184,0.261,
0.264,0.181,0.271,0.219,0.183,0.148,0.169,0.178,0.144,0.026,
0.127,0.142,0.133,0.170,0.223,0.223,0.192,0.137,0.106,0.200,
0.017,0.017,0.013,0.026,0.114,0.013,0.105,0.114,0.093,0.135,
0.124,0.189,0.213,0.113,0.099,0.194,0.255,0.135,0.125,0.186,
0.172,0.015,0.115,0.154,0.206,0.144,0.301,0.383,0.260,0.195,
0.101,0.172,0.203,0.179,0.122,0.141,0.118,0.020,0.072,0.102,
0.110,0.149,0.092,0.173,0.225,0.264,0.118,0.147,0.196,0.168,
0.146,0.154,0.135,0.025,0.108,0.140,0.102,0.157,0.113,0.160,
0.160,0.164,0.094,0.139,0.016,0.028,0.019,0.021,0.290,0.048,
0.114,0.155,0.108,0.207,0.131,0.157,0.174,0.120,0.082,0.154,
0.175,0.160,0.113,0.159,0.155,0.013,0.102,0.151,0.146,0.135,
0.157,0.325,0.202,0.110,0.086,0.161,0.179,0.139,0.148,0.139,
0.137,0.021,0.081,0.098,0.134,0.139,0.110,0.219,0.021,0.017,
0.012,0.018,0.021,0.026,0.020,0.026,0.016,8.77e-3,0.022,0.018,
0.017,0.028,0.021,0.023,0.146,0.169,0.119,0.164,0.020,0.045,
0.026,0.021,0.162,0.052,0.097,0.124,0.093,0.183,0.131,0.164,
0.128,0.078,0.077,0.146,0.188,0.191,0.139,0.182,0.180,0.021,
0.118,0.169,0.151,0.151,0.163,0.289,0.267,0.197,0.134,0.247,
0.180,0.133,0.107,0.146,0.164,0.020,0.083,0.123,0.238,0.241,
0.165,0.346,0.272,0.211,0.150,0.220,0.218,0.197,0.154,0.219,
0.178,0.023,0.129,0.174,0.219,0.263,0.200,0.323,0.172,0.154,
0.132,0.191,0.015,0.021,0.013,0.022,0.185,0.021,0.104,0.156,
0.162,0.201,0.181,0.254,0.248,0.144,0.133,0.261,0.232,0.152,
0.137,0.214,0.353,0.028,0.169,0.283,0.344,0.296,0.331,0.605,
4.410,2.750,1.850,3.360,2.150,1.620,1.280,1.910,1.910,0.186,
1.240,1.680,1.820,1.630,1.250,2.370,3.550,2.360,1.530,2.110,
2.430,1.740,2.070,1.870,2.300,0.231,2.400,2.240,1.470,1.910,
1.430,2.300,2.210,2.110,1.400,2.340,0.226,0.243,0.193,0.384,
1.560,0.183,1.230,1.600,1.250,2.120,1.760,2.640,2.140,1.350,
1.060,2.310,1.990,1.710,1.480,2.320,2.000,0.205,1.560,2.500,
2.500,2.520,3.370,5.450,0.225,0.193,0.097,0.170,0.173,0.185,
0.111,0.155,0.116,0.024,0.080,0.126,0.119,0.152,0.085,0.197,
0.198,0.181,0.183,0.146,0.182,0.164,0.135,0.139,0.128,0.026,
0.140,0.155,0.095,0.123,0.093,0.141,0.133,0.166,0.095,0.146,
0.022,0.031,0.019,0.025,0.140,0.029,0.128,0.159,0.088,0.155,
0.123,0.160,0.210,0.145,0.095,0.231,0.234,0.232,0.144,0.243,
0.176,0.024,0.135,0.347,0.186,0.194,0.247,0.420,2.690,1.780,
1.210,1.530,2.300,2.120,1.930,1.750,1.960,0.338,1.820,1.840,
1.480,1.690,1.600,2.800,0.182,0.208,0.131,0.130,0.181,0.230,
0.185,0.138,0.158,0.040,0.203,0.177,0.146,0.225,0.161,0.262,
1.870,1.780,1.360,1.550,0.194,0.180,0.190,0.182,1.580,0.179,
0.673,1.100,0.984,1.350,1.350,1.740,1.550,1.040,0.882,1.300,
1.900,1.610,1.410,1.600,1.720,0.196,1.780,2.260,1.590,1.540,
2.050,3.270,2.680,1.670,1.230,1.970,1.990,1.590,0.985,1.290,
1.570,0.171,1.170,1.560,1.810,1.450,1.240,2.540,2.660,2.220,
1.610,1.920,2.520,2.510,1.740,1.590,1.750,0.177,1.910,2.090,
1.680,1.940,1.550,2.340,2.360,2.050,1.510,2.200,0.215,0.217,
0.142,0.209,2.030,0.183,1.870,2.390,1.590,2.240,2.050,2.710,
2.510,1.500,1.230,2.240,2.170,1.810,1.320,1.800,2.660,0.206,
2.640,3.600,3.140,2.870,3.200,5.080,5.510,2.540,1.850,3.910,
2.510,1.500,1.410,2.210,2.280,0.207,1.070,1.890,2.830,2.240,
1.460,3.490,3.330,1.700,1.190,2.090,1.800,1.110,1.270,1.580,
1.590,0.111,1.140,1.490,1.420,1.420,1.150,2.240,2.720,1.790,
1.130,2.270,0.202,0.133,0.110,0.274,2.210,0.148,1.130,1.800,
1.540,1.710,1.630,2.820,2.820,1.480,1.330,2.720,2.350,1.230,
1.240,2.110,2.150,0.139,1.160,1.970,2.850,1.970,2.460,5.290,
4.790,2.800,1.630,3.350,2.960,2.190,1.630,2.200,2.170,0.196,
1.230,2.190,2.330,2.420,1.260,3.410,3.380,2.360,1.440,2.600,
2.290,1.780,1.510,1.910,1.680,0.125,1.340,2.060,1.450,1.550,
1.070,2.150,2.350,2.290,1.270,2.410,0.176,0.166,0.111,0.220,
2.360,0.193,1.510,2.690,1.760,2.240,1.690,2.880,2.830,1.910,
1.350,2.880,3.020,2.150,1.700,2.820,2.530,0.206,1.640,3.170,
2.750,2.430,2.590,4.950,3.830,1.990,1.690,2.280,2.690,2.000,
2.150,2.300,2.680,0.297,1.630,2.410,2.380,2.250,2.010,3.840,
0.213,0.163,0.111,0.175,0.154,0.178,0.175,0.174,0.155,0.024,
0.150,0.228,0.180,0.304,0.157,0.255,2.620,2.400,1.680,2.450,
0.175,0.161,0.145,0.241,2.530,0.294,1.810,2.550,1.720,3.030,
2.050,2.970,2.380,1.570,1.490,2.260,2.720,1.950,2.080,2.760,
2.710,0.233,2.560,4.050,2.650,2.360,2.970,5.010,4.440,2.100,
1.800,3.140,2.290,1.490,1.440,1.800,2.480,0.253,1.460,2.170,
2.750,2.050,1.790,4.100,2.760,1.710,1.370,2.090,1.910,1.570,
1.570,1.750,1.850,0.124,1.620,2.270,1.860,1.800,1.680,2.710,
3.030,2.620,2.140,3.230,0.196,0.181,0.136,0.265,3.230,0.238,
2.570,3.890,2.610,3.080,3.070,4.080,4.140,2.060,2.060,4.180,
3.090,2.220,2.160,3.440,4.090,0.253,3.560,5.730,4.870,3.910,
4.590,8.510,21.3,6.590,5.350,12.5,5.090,2.730,2.510,4.460,
4.610,0.356,2.020,3.520,8.000,5.240,3.300,7.740,5.210,2.510,
1.760,3.100,2.580,1.370,1.330,1.840,2.240,0.142,1.360,1.790,
2.710,2.130,1.900,3.110,4.240,2.370,1.920,4.070,0.248,0.152,
0.136,0.390,2.270,0.145,1.340,2.120,2.160,2.140,1.900,3.680,
6.400,2.710,2.560,6.070,3.790,2.020,2.010,3.760,3.400,0.222,
2.690,3.590,5.380,3.130,3.820,9.200,6.600,2.870,1.820,3.860,
2.960,1.610,1.280,1.890,1.950,0.158,0.928,1.550,2.540,1.920,
1.290,2.950,3.180,1.850,1.140,2.020,1.860,1.150,1.020,1.320,
1.520,0.093,0.844,1.360,1.600,1.290,1.220,2.210,2.650,1.730,
1.300,2.360,0.143,0.107,0.085,0.172,1.940,0.191,0.856,1.400,
1.510,1.630,1.380,2.100,2.800,1.610,1.140,2.330,2.090,1.390,
1.140,1.830,1.890,0.110,1.100,1.840,2.300,1.700,1.830,3.930,
5.690,2.390,1.760,3.780,3.580,1.670,1.630,2.550,2.780,0.253,
1.030,2.020,4.480,2.860,1.850,5.640,0.292,0.183,0.115,0.234,
0.225,0.136,0.121,0.191,0.176,0.016,0.090,0.164,0.418,0.312,
0.168,0.425,2.650,1.700,1.400,2.620,0.218,0.111,0.097,0.229,
2.100,0.138,0.849,1.490,2.020,1.730,1.450,2.590,2.950,1.560,
1.420,3.190,3.690,1.590,1.430,2.680,2.650,0.171,1.360,2.560,
3.800,2.260,2.500,5.360,8.560,3.170,2.570,6.400,3.860,1.850,
2.080,2.840,3.770,0.302,1.660,2.850,7.870,4.340,2.930,8.150,
4.340,2.320,1.810,2.900,2.630,1.580,1.380,1.950,2.580,0.161,
1.400,2.170,4.300,2.950,2.140,4.490,3.810,2.490,2.070,3.740,
0.321,0.147,0.132,0.273,3.200,0.173,1.560,2.690,3.280,3.040,
2.630,4.880,7.360,3.150,3.000,7.540,7.180,2.660,2.480,4.190,
6.480,0.317,3.140,5.540,14.4,6.750,7.290,18.6,8.370,3.990,
2.730,6.100,3.880,2.280,1.770,2.880,3.030,0.254,1.990,2.560,
4.110,3.120,2.410,4.860,4.220,2.380,1.920,2.880,2.650,1.690,
1.540,1.990,2.080,0.141,1.430,1.850,1.950,1.790,1.630,2.730,
2.900,1.870,1.280,2.520,0.172,0.126,0.092,0.227,1.640,0.130,
1.200,1.670,1.740,1.680,1.460,2.950,3.420,1.710,1.360,3.030,
2.710,1.560,1.230,2.250,2.100,0.140,1.460,2.060,2.980,2.020,
2.270,5.370,6.010,3.240,1.590,3.320,3.460,2.460,1.470,1.980,
1.940,0.164,0.864,1.520,2.230,2.040,1.190,2.860,3.530,2.810,
1.240,2.180,3.220,2.530,1.580,2.160,1.780,0.167,0.983,1.710,
1.750,2.040,1.170,2.590,2.560,1.950,1.070,2.030,0.154,0.151,
0.078,0.148,2.010,0.201,1.090,1.640,1.540,1.910,1.600,2.520,
2.300,1.480,0.922,2.010,2.100,1.680,1.040,1.760,1.680,0.110,
0.961,1.720,2.020,1.660,1.570,3.920,5.090,2.090,1.620,2.730,
2.840,1.740,1.750,2.190,2.290,0.227,0.935,1.630,3.700,2.530,
1.710,5.430,0.204,0.137,0.096,0.166,0.154,0.157,0.103,0.163,
0.115,0.017,0.082,0.127,0.277,0.246,0.128,0.329,2.540,1.900,
1.440,2.360,0.188,0.181,0.109,0.210,2.000,0.174,0.949,1.540,
1.920,1.910,1.570,2.940,2.750,1.340,1.250,2.400,3.100,1.730,
1.570,2.510,2.300,0.157,1.350,2.340,2.880,2.110,2.520,5.470,
5.530,2.310,1.830,3.800,2.550,1.540,1.380,2.130,2.500,0.195,
1.220,1.900,4.070,2.870,2.000,5.390,3.470,2.010,1.570,2.540,
2.310,1.780,1.420,2.010,2.030,0.152,1.260,2.010,3.290,3.110,
2.050,3.980,3.230,2.030,1.690,2.790,0.198,0.117,0.084,0.191,
2.160,0.142,1.290,2.120,2.390,2.250,2.060,3.860,4.300,1.940,
2.280,3.770,4.410,1.950,1.640,2.770,3.520,0.199,1.930,3.430,
5.500,3.980,4.160,9.090,8.540,4.510,3.090,6.020,3.450,2.300,
1.730,3.040,3.740,0.263,1.560,2.610,3.880,2.700,1.840,4.170,
5.300,3.720,2.190,3.630,3.000,2.140,1.960,2.300,3.030,0.241,
2.050,2.740,2.860,3.040,2.010,4.110,3.560,3.410,1.930,3.810,
0.269,0.261,0.179,0.466,2.430,0.219,1.360,2.370,2.130,3.050,
2.160,4.570,4.110,2.500,1.860,4.620,3.090,2.260,1.760,3.500,
3.420,0.256,2.180,3.720,4.360,3.410,3.870,9.120,0.296,0.245,
0.140,0.254,0.238,0.194,0.113,0.190,0.158,0.019,0.086,0.150,
0.199,0.198,0.114,0.263,0.243,0.217,0.116,0.175,0.215,0.204,
0.114,0.146,0.162,0.024,0.135,0.255,0.173,0.199,0.115,0.251,
0.136,0.177,0.090,0.169,0.015,0.020,0.012,0.019,0.177,0.022,
0.104,0.153,0.132,0.189,0.169,0.241,0.240,0.190,0.119,0.334,
0.259,0.217,0.133,0.272,0.187,0.019,0.123,0.261,0.281,0.250,
0.229,0.571,5.430,2.860,2.040,2.770,3.350,2.610,2.130,2.810,
2.970,0.381,1.820,2.660,3.150,3.030,2.610,4.970,0.252,0.222,
0.119,0.183,0.188,0.195,0.134,0.162,0.184,0.026,0.152,0.188,
0.274,0.306,0.213,0.365,3.180,3.120,2.030,2.890,0.244,0.228,
0.170,0.275,3.030,0.265,1.940,2.600,2.280,2.970,2.540,3.830,
3.230,2.090,1.690,2.810,3.410,2.680,2.110,3.060,3.640,0.296,
2.910,4.130,3.670,3.270,4.280,7.570,6.070,3.260,2.460,4.360,
3.330,2.300,1.740,2.700,3.230,0.269,2.050,3.120,4.200,2.990,
2.340,5.710,4.920,3.510,2.180,3.530,3.580,3.030,2.060,2.510,
3.310,0.232,2.680,3.560,4.030,4.000,2.900,5.530,4.360,3.680,
2.770,4.340,0.257,0.228,0.168,0.298,3.930,0.274,2.970,4.220,
3.860,4.520,3.910,6.000,5.430,2.860,2.700,4.760,3.820,2.710,
2.210,3.420,5.250,0.309,4.370,6.350,6.520,5.400,6.170,11.0,
24.7,7.560,4.780,11.9,5.650,3.100,2.710,5.160,5.270,0.401,
2.170,4.260,8.090,5.490,3.410,9.900,6.850,3.680,2.100,4.130,
3.450,2.130,1.840,2.740,2.970,0.183,1.750,2.760,3.430,2.640,
1.920,4.300,5.300,5.120,2.370,6.070,0.297,0.268,0.157,0.546,
3.300,0.246,1.690,3.260,3.330,3.380,2.500,6.220,8.340,4.710,
3.520,9.610,4.810,3.020,2.560,6.110,4.600,0.308,2.710,5.400,
8.590,5.620,5.960,19.6,8.880,4.390,2.480,5.300,4.570,2.910,
1.900,3.260,3.080,0.219,1.430,2.670,4.230,3.350,1.780,4.920,
5.160,3.510,1.750,3.150,3.270,3.320,1.240,2.080,2.580,0.179,
1.520,2.640,3.080,2.620,1.680,3.550,3.720,3.140,1.680,4.020,
0.180,0.187,0.097,0.257,2.980,0.211,1.710,3.020,2.840,3.090,
2.250,4.720,4.830,3.220,2.080,5.570,3.540,2.670,1.980,4.210,
3.510,0.216,2.000,4.030,5.300,4.170,3.780,10.1,8.440,3.860,
3.080,4.590,5.000,3.070,2.680,4.620,4.580,0.436,2.200,3.920,
5.280,4.160,3.620,8.080,0.305,0.229,0.156,0.246,0.225,0.204,
0.144,0.248,0.233,0.018,0.138,0.228,0.439,0.323,0.222,0.461,
4.880,4.050,2.760,4.810,0.251,0.201,0.161,0.372,4.170,0.300,
3.250,3.900,3.840,4.170,3.980,6.800,6.180,3.720,3.190,5.890,
5.050,3.410,3.220,6.310,5.800,0.343,4.920,7.260,6.860,4.850,
7.120,14.0,25.1,6.370,4.520,11.1,5.150,2.990,2.750,6.410,
5.410,0.388,2.690,5.130,9.850,6.200,4.880,16.1,6.490,3.970,
2.630,3.710,3.720,1.940,2.310,3.820,4.770,0.251,2.810,4.250,
8.260,5.130,3.950,8.570,6.800,5.110,3.800,6.860,0.289,0.231,
0.156,0.497,5.550,0.311,3.880,6.100,6.860,6.400,6.730,11.8,
17.5,4.310,3.610,10.1,5.350,3.600,2.890,7.700,6.560,0.348,
5.780,8.700,12.5,7.540,13.1,27.6,28.9,9.510,5.820,14.7,
9.070,4.030,3.030,4.450,5.640,0.481,1.630,3.130,9.650,5.700,
2.680,5.710,13.0,5.330,3.140,4.130,5.270,2.590,2.210,2.200,
4.520,0.315,2.040,2.530,3.920,2.920,2.140,3.440,8.060,4.930,
3.220,4.900,0.612,0.437,0.303,0.639,3.000,0.313,1.640,2.390,
3.500,3.770,2.080,3.180,11.6,4.330,4.140,8.000,6.380,4.000,
3.250,5.550,4.980,0.373,2.250,3.970,6.520,3.500,3.230,5.270,
16.1,5.530,3.010,4.970,6.120,3.740,2.200,2.590,4.520,0.421,
1.620,2.680,4.150,3.770,1.850,3.330,7.180,4.010,1.840,2.520,
3.870,2.450,1.620,1.670,3.770,0.290,1.640,2.220,2.440,2.230,
1.310,1.900,4.870,3.710,2.100,3.000,0.335,0.290,0.218,0.304,
2.930,0.280,1.560,2.130,2.070,2.700,1.550,2.380,3.960,2.250,
1.680,2.750,3.180,2.280,1.540,2.260,2.960,0.217,1.410,2.310,
2.970,2.430,1.870,3.610,9.430,3.710,2.900,4.800,5.910,3.160,
2.780,3.720,4.660,0.497,1.720,3.150,4.390,3.570,2.490,5.380,
0.726,0.435,0.254,0.401,0.590,0.395,0.277,0.319,0.416,0.058,
0.241,0.346,0.536,0.637,0.339,0.611,3.990,2.660,2.270,2.390,
0.379,0.247,0.213,0.295,2.430,0.270,1.330,1.850,2.170,2.220,
1.610,2.210,3.730,1.970,2.100,2.920,4.440,2.900,2.060,2.760,
2.870,0.244,1.580,2.430,2.650,2.270,2.350,3.680,12.3,4.560,
3.440,7.480,4.620,2.410,2.090,2.970,5.340,0.534,1.890,3.500,
6.690,4.560,3.390,8.670,7.490,4.330,2.780,3.990,4.740,3.000,
2.420,2.600,4.220,0.299,2.190,3.340,4.680,4.960,3.030,5.400,
4.320,3.190,2.470,3.130,0.349,0.274,0.301,0.310,2.720,0.224,
1.540,2.340,2.720,3.060,2.130,3.260,6.140,3.090,2.640,5.140,
3.180,2.260,1.840,2.770,3.780,0.236,2.170,3.740,4.660,3.420,
3.130,5.770,15.7,10.6,4.230,7.380,5.970,4.400,3.040,3.170,
4.120,0.444,1.590,2.620,4.300,3.940,2.240,3.990,7.720,5.700,
2.540,3.230,4.260,2.820,2.210,2.130,3.000,0.344,1.660,2.320,
2.120,2.190,1.410,2.350,3.930,3.400,2.020,2.780,0.372,0.364,
0.226,0.359,1.900,0.198,1.170,1.600,1.670,2.270,1.360,2.200,
3.760,1.760,1.630,2.630,3.300,2.390,1.610,2.320,2.020,0.171,
1.020,2.060,2.360,1.580,1.540,3.360,8.100,5.730,2.090,3.480,
4.630,3.470,1.750,1.930,2.780,0.310,1.040,1.810,2.200,2.310,
1.230,2.350,4.620,3.550,1.420,1.780,2.990,1.670,1.640,1.580,
2.190,0.264,1.190,1.720,1.380,1.680,1.070,1.420,2.940,3.310,
1.440,2.000,0.287,0.358,0.178,0.228,1.990,0.287,1.040,1.570,
1.270,2.210,1.080,1.860,2.140,1.520,0.874,1.420,2.160,1.880,
0.948,1.300,1.710,0.179,0.716,1.370,1.550,1.240,0.935,2.170,
4.810,2.990,1.670,2.610,3.870,2.800,2.430,2.350,2.450,0.317,
1.180,1.910,1.950,1.970,1.530,2.900,0.334,0.334,0.152,0.221,
0.283,0.326,0.214,0.186,0.196,0.055,0.188,0.240,0.193,0.280,
0.180,0.268,2.380,2.480,1.620,1.870,0.260,0.266,0.189,0.221,
1.730,0.242,1.110,1.540,1.180,1.920,1.370,1.940,1.790,1.160,
1.050,1.510,2.410,2.030,1.520,1.880,1.660,0.162,1.160,1.840,
1.470,1.310,1.610,2.660,4.240,2.030,1.360,2.360,2.740,1.450,
1.060,1.290,1.930,0.166,0.766,1.390,2.120,1.510,1.140,2.550,
3.500,2.560,1.710,2.150,2.330,2.120,1.450,1.580,1.500,0.165,
1.170,1.980,1.440,1.840,1.270,2.160,2.390,2.060,1.570,1.980,
0.193,0.172,0.119,0.180,1.500,0.149,0.973,1.530,1.310,1.720,
1.300,1.970,2.530,1.270,1.290,1.990,1.860,1.400,1.030,1.540,
1.860,0.149,1.250,2.290,2.620,2.080,1.990,3.380,7.650,4.020,
3.100,4.530,3.100,2.070,1.570,1.910,2.960,0.292,1.720,2.140,
2.940,2.560,1.750,2.890,5.940,3.950,2.290,2.770,3.120,2.120,
1.790,1.680,2.910,0.286,1.780,2.120,1.950,2.150,1.430,2.060,
3.210,3.100,2.160,2.560,0.335,0.362,0.232,0.384,1.840,0.282,
1.050,1.490,1.570,2.700,1.420,2.290,2.990,1.630,1.640,2.360,
2.410,2.040,1.370,1.860,2.340,0.217,1.290,2.140,2.460,1.820,
2.070,4.660,0.546,0.432,0.201,0.339,0.384,0.345,0.179,0.208,
0.255,0.045,0.137,0.206,0.223,0.297,0.172,0.283,0.468,0.562,
0.181,0.218,0.426,0.465,0.222,0.225,0.273,0.062,0.204,0.217,
0.190,0.273,0.147,0.202,0.307,0.368,0.186,0.212,0.043,0.073,
0.049,0.041,0.276,0.083,0.170,0.220,0.178,0.385,0.190,0.281,
0.368,0.244,0.182,0.321,0.418,0.451,0.257,0.383,0.305,0.042,
0.207,0.315,0.307,0.257,0.268,0.525,3.530,2.410,1.430,1.660,
2.520,1.970,1.730,1.560,2.440,0.353,1.370,1.700,1.630,1.750,
1.580,1.970,0.316,0.485,0.147,0.165,0.210,0.228,0.158,0.139,
0.249,0.069,0.210,0.181,0.208,0.301,0.194,0.204,1.900,2.210,
1.260,1.310,0.214,0.263,0.156,0.212,2.380,0.785,0.824,1.080,
1.200,2.460,1.070,1.240,1.500,1.060,0.872,1.030,1.810,1.770,
1.150,1.430,1.920,0.321,1.250,1.590,1.230,1.430,1.190,1.710,
3.200,1.860,1.130,1.910,2.160,1.150,0.790,0.996,1.820,0.189,
0.980,1.550,2.000,1.500,1.290,2.550,4.070,5.190,1.660,1.950,
2.780,2.150,1.400,1.350,2.280,0.240,1.720,1.940,1.860,2.140,
1.610,2.050,2.300,2.320,1.440,1.710,0.208,0.253,0.127,0.181,
2.190,0.534,1.150,1.600,1.590,2.630,1.490,2.020,2.360,1.320,
1.510,1.530,1.880,1.620,1.160,1.500,2.180,0.243,1.620,2.270,
2.320,2.120,1.950,3.170,11.8,5.600,3.990,7.930,4.040,2.330,
2.360,2.720,3.540,0.348,1.690,2.930,5.730,3.900,2.750,5.960,
5.250,2.700,1.850,2.630,2.440,1.430,1.230,1.420,2.350,0.166,
1.250,1.800,2.020,1.620,1.300,2.250,4.060,3.090,1.930,3.470,
0.363,0.325,0.206,0.471,2.200,0.195,0.953,1.850,2.260,2.280,
1.370,2.810,4.820,2.210,2.350,4.890,3.070,2.150,1.730,3.100,
2.700,0.204,1.580,3.210,4.150,2.540,2.770,7.930,7.620,4.260,
2.250,4.070,4.070,2.910,1.770,2.330,3.260,0.288,1.410,2.410,
3.020,2.770,1.640,3.170,4.890,3.350,1.530,2.290,3.070,2.540,
1.450,1.640,2.490,0.228,1.410,2.130,2.000,1.970,1.140,1.930,
4.260,3.060,1.570,2.600,0.247,0.242,0.140,0.253,2.450,0.236,
1.260,2.140,2.180,2.630,1.630,2.830,3.890,2.130,1.690,3.350,
3.260,2.740,1.590,2.890,2.760,0.188,1.700,3.040,3.030,2.210,
2.500,4.690,3.770,2.660,1.620,2.790,3.130,2.190,1.610,2.340,
2.620,0.300,1.400,2.090,2.510,2.060,1.680,2.990,0.302,0.350,
0.136,0.228,0.222,0.216,0.157,0.175,0.205,0.045,0.192,0.229,
0.229,0.273,0.159,0.265,2.390,2.140,1.380,1.720,0.190,0.157,
0.124,0.184,2.020,0.259,0.950,1.370,1.750,2.110,1.350,1.840,
2.220,1.550,1.250,1.900,2.630,1.910,1.560,2.190,2.290,0.202,
1.480,2.230,2.000,1.690,1.690,3.240,6.460,2.970,2.040,3.680,
2.800,1.700,1.540,1.720,2.770,0.235,1.260,2.200,3.860,2.530,
2.120,4.820,3.590,2.600,1.390,2.080,2.160,1.510,1.320,1.350,
1.900,0.143,1.300,1.950,2.090,2.010,1.440,2.490,3.490,2.810,
1.860,2.690,0.237,0.190,0.123,0.219,2.500,0.205,1.310,2.160,
2.690,3.030,2.080,3.090,4.660,2.230,1.990,4.190,3.000,2.510,
1.750,2.560,3.260,0.186,2.060,3.590,5.040,3.080,3.050,5.120,
11.0,6.850,4.890,7.860,7.090,4.720,2.850,3.430,4.650,0.530,
1.930,3.560,5.880,4.800,2.570,4.580,6.820,4.070,2.030,2.380,
3.970,2.760,1.970,1.940,2.760,0.316,1.690,2.010,1.930,1.980,
1.400,2.000,2.920,2.460,1.500,2.340,0.312,0.272,0.195,0.347,
1.710,0.201,0.910,1.290,1.550,2.110,1.250,2.020,3.570,1.770,
1.350,2.880,3.440,2.390,1.620,2.670,2.590,0.343,1.210,1.990,
2.670,1.980,1.870,3.480,7.030,4.770,2.040,3.180,5.410,3.660,
1.810,2.210,3.280,0.420,1.280,2.030,2.320,2.880,1.230,2.560,
5.140,4.140,1.600,1.920,3.360,2.280,1.680,1.660,2.740,0.413,
1.570,1.950,1.570,2.180,1.190,1.620,2.510,2.570,1.220,1.710,
0.293,0.281,0.199,0.240,1.860,0.284,1.180,1.460,1.330,2.360,
1.310,1.710,1.940,1.360,0.755,1.390,2.190,1.790,0.935,1.550,
1.780,0.174,0.979,1.420,1.580,1.600,1.260,2.510,3.840,2.420,
1.390,2.370,4.200,2.750,2.130,2.540,2.870,0.360,1.100,1.780,
2.320,2.030,1.340,2.970,0.364,0.348,0.217,0.257,0.414,0.368,
0.289,0.274,0.273,0.072,0.220,0.273,0.234,0.376,0.203,0.311,
1.480,1.560,1.060,1.180,0.191,0.161,0.127,0.173,1.380,0.186,
0.871,1.190,1.000,1.390,0.986,1.320,1.390,0.940,0.751,1.160,
2.120,1.650,1.080,1.500,1.710,0.200,0.961,1.340,1.430,1.470,
1.470,2.180,3.810,1.790,1.270,2.630,1.930,1.160,0.850,1.180,
2.050,0.242,0.779,1.480,2.240,1.500,1.020,3.000,3.430,2.550,
1.480,2.030,2.750,2.030,1.570,1.600,1.760,0.196,1.290,1.870,
1.580,1.850,1.130,1.880,1.590,1.410,1.140,1.280,0.170,0.127,
0.192,0.151,1.150,0.135,0.714,0.985,1.070,1.450,0.956,1.280,
2.210,1.100,0.814,1.660,1.310,0.979,0.884,1.150,1.640,0.149,
1.100,1.740,2.080,1.740,1.620,3.280,7.540,5.640,2.840,4.800,
5.780,6.750,2.560,2.630,2.760,0.381,1.230,1.880,2.470,2.820,
1.430,2.550,5.290,4.170,1.890,2.240,4.380,3.490,2.250,1.990,
2.290,0.347,1.660,1.920,1.200,1.680,1.260,1.590,1.970,2.250,
1.360,1.890,0.247,0.340,0.211,0.292,1.120,0.172,0.949,1.130,
0.867,1.440,1.060,1.510,1.870,1.130,0.848,1.600,2.270,2.200,
1.230,1.580,1.200,0.164,0.835,1.210,1.260,1.080,1.200,2.190,
4.540,4.390,1.600,2.160,3.800,4.040,1.530,1.610,2.070,0.319,
1.030,1.540,1.350,1.950,0.938,1.600,3.670,3.190,1.350,1.380,
2.240,0.839,1.330,1.240,1.980,0.447,1.350,1.820,0.944,1.750,
1.050,1.310,1.690,2.490,1.080,1.450,0.240,0.392,0.196,0.231,
1.420,0.303,1.020,1.330,0.824,1.990,1.140,1.450,1.150,1.190,
0.544,0.906,1.600,1.860,0.778,1.110,1.090,0.146,0.752,1.130,
0.841,1.010,0.727,1.530,3.110,2.260,1.060,1.620,3.840,3.370,
2.230,1.950,1.790,0.298,1.060,1.440,1.220,1.560,1.220,1.970,
0.314,0.360,0.153,0.191,0.460,0.509,0.413,0.238,0.204,0.107,
0.255,0.256,0.120,0.285,0.184,0.199,1.530,1.980,1.220,1.320,
0.339,0.365,0.223,0.234,1.230,0.242,0.942,1.270,0.797,1.650,
1.240,1.420,1.030,0.800,0.645,0.928,2.240,2.250,1.550,1.700,
1.310,0.180,1.020,1.460,1.000,1.190,1.500,2.080,2.230,1.390,
0.841,1.390,1.780,1.270,0.730,0.883,1.110,0.122,0.539,0.826,
1.080,0.917,0.671,1.440,2.450,2.140,1.250,1.550,2.310,2.380,
1.570,1.470,1.140,0.193,1.080,1.450,0.828,1.300,0.938,1.350,
1.260,1.550,1.100,1.260,0.146,0.188,0.111,0.140,0.814,0.122,
0.717,0.914,0.709,1.230,0.932,1.280,1.260,0.789,0.566,0.991,
1.130,1.090,0.779,0.973,0.927,0.105,0.749,1.250,1.170,1.350,
1.130,2.110,3.780,2.790,1.660,2.600,2.580,1.990,1.350,1.600,
1.780,0.234,1.110,1.480,1.660,1.770,1.120,1.870,3.890,4.040,
1.460,2.150,3.360,2.550,1.840,1.800,2.760,0.387,1.810,2.190,
1.330,1.940,1.070,1.600,1.730,2.340,1.100,1.530,0.235,0.263,
0.176,0.297,1.240,0.221,0.780,1.130,0.957,1.760,0.886,1.530,
1.510,1.070,0.718,1.380,1.650,1.540,0.957,1.350,1.430,0.177,
0.979,1.500,1.350,1.190,1.480,2.750,0.234,0.271,0.106,0.163,
0.308,0.338,0.184,0.176,0.176,0.046,0.112,0.166,0.133,0.214,
0.154,0.225,0.287,0.465,0.132,0.155,0.432,0.494,0.285,0.289,
0.264,0.138,0.240,0.249,0.121,0.251,0.126,0.146,0.154,0.292,
0.126,0.136,0.046,0.097,0.069,0.047,0.169,0.094,0.169,0.190,
0.111,0.283,0.181,0.224,0.142,0.123,0.070,0.131,0.233,0.290,
0.156,0.212,0.148,0.035,0.148,0.206,0.117,0.156,0.175,0.260,
2.560,2.640,1.200,1.390,3.000,2.970,2.080,1.970,2.200,0.441,
1.340,1.700,1.240,1.780,1.420,1.960,0.272,0.672,0.214,0.172,
0.293,0.481,0.313,0.191,0.256,0.129,0.285,0.252,0.144,0.355,
0.193,0.190,1.570,2.440,1.220,1.200,0.218,0.309,0.208,0.207,
1.700,0.387,1.050,1.330,1.010,1.860,1.280,1.310,0.997,0.935,
0.676,0.808,1.670,2.060,1.270,1.410,1.740,0.307,1.520,1.610,
0.966,1.300,1.590,1.690,1.900,1.390,0.635,1.100,1.370,0.985,
0.587,0.716,1.210,0.145,0.640,1.020,1.050,1.020,0.722,1.480,
2.680,3.660,1.240,1.420,2.770,2.810,1.460,1.410,2.210,0.326,
1.640,1.980,1.260,1.990,1.200,1.610,1.500,2.040,0.980,1.210,
0.171,0.210,0.119,0.147,1.390,0.252,1.050,1.320,1.030,1.950,
1.200,1.680,1.280,1.080,0.744,1.150,1.150,1.230,0.811,1.030,
1.510,0.220,1.580,1.790,1.400,1.610,1.550,2.380,3.980,2.020,
1.340,2.540,1.610,1.170,0.858,1.220,1.490,0.161,0.694,1.490,
1.720,1.370,0.910,2.090,2.700,1.780,0.872,1.380,1.600,1.120,
0.836,1.070,1.230,0.111,0.715,1.150,1.010,0.888,0.624,1.130,
1.490,1.410,0.728,1.260,0.128,0.125,0.073,0.169,0.807,0.089,
0.444,0.832,0.821,1.020,0.611,1.210,1.790,0.930,0.758,1.590,
1.220,0.911,0.666,1.280,1.030,0.085,0.605,1.260,1.420,0.972,
1.090,2.760,3.320,2.240,1.060,1.780,2.390,2.210,1.390,1.500,
2.030,0.248,0.915,1.730,1.550,1.850,0.979,1.880,2.620,2.320,
0.871,1.280,2.610,2.270,1.240,1.470,1.840,0.260,1.100,1.600,
1.330,1.630,0.828,1.320,1.310,1.630,0.684,1.010,0.121,0.177,
0.100,0.151,1.220,0.197,0.765,1.240,1.060,1.820,0.983,1.540,
1.220,0.886,0.610,1.080,1.500,1.470,0.850,1.500,1.220,0.122,
0.889,1.590,1.230,1.200,1.240,2.290,2.610,1.930,0.916,1.360,
2.520,2.320,1.450,1.690,1.970,0.266,1.050,1.680,1.390,1.370,
1.240,2.130,0.231,0.290,0.097,0.139,0.186,0.268,0.180,0.152,
0.141,0.039,0.131,0.159,0.134,0.196,0.128,0.184,2.010,1.690,
0.866,1.050,0.166,0.153,0.105,0.140,1.480,0.189,0.892,1.170,
1.360,1.550,1.060,1.460,1.250,0.910,0.698,0.981,1.860,1.510,
1.070,1.450,1.490,0.185,1.190,1.500,1.290,1.210,1.440,2.110,
2.770,1.620,0.903,1.670,1.510,1.130,0.707,0.952,1.510,0.156,
0.783,1.290,1.490,1.100,0.932,2.130,2.100,1.750,0.779,1.160,
1.700,1.480,0.934,1.070,1.620,0.150,0.879,1.420,1.240,1.220,
0.906,1.570,2.050,1.690,0.987,1.440,0.272,0.137,0.088,0.148,
1.360,0.143,0.982,1.390,1.440,1.820,1.430,1.940,2.220,1.270,
1.020,2.190,1.990,1.640,1.210,1.600,1.910,0.168,1.580,2.460,
2.580,1.960,2.190,2.970,4.580,2.900,2.710,4.020,3.220,2.090,
2.090,2.070,2.580,0.275,1.170,1.790,2.930,2.630,1.430,2.520,
2.620,1.790,1.570,1.600,1.890,1.160,1.170,1.080,1.440,0.152,
0.862,1.040,1.200,1.230,0.948,1.380,1.900,1.600,1.250,1.510,
0.193,0.152,0.132,0.223,1.100,0.135,0.642,0.911,1.080,1.430,
0.933,1.370,2.100,1.170,0.945,1.870,1.980,1.340,1.110,1.530,
1.190,0.114,0.724,1.160,1.750,1.110,1.240,2.460,4.300,2.440,
1.690,2.730,2.980,2.010,1.650,1.640,2.120,0.247,0.980,1.670,
1.610,1.770,0.886,1.720,2.480,1.800,0.982,1.260,1.790,1.020,
1.110,1.050,1.770,0.190,0.844,1.160,0.995,1.290,0.632,1.030,
1.970,2.030,1.300,1.940,0.204,0.225,0.171,0.238,1.430,0.189,
0.906,1.480,0.921,1.600,1.040,1.340,1.380,0.901,0.680,1.310,
1.630,1.470,1.280,1.440,1.140,0.103,0.645,1.080,1.090,0.985,
0.962,2.080,2.670,1.480,1.010,1.660,2.880,2.110,1.970,1.880,
2.500,0.342,0.924,1.330,1.670,1.930,1.140,2.120,0.273,0.247,
0.140,0.197,0.300,0.288,0.238,0.238,0.255,0.058,0.174,0.214,
0.242,0.448,0.190,0.302,1.390,1.300,0.900,1.030,0.169,0.148,
0.124,0.181,1.040,0.149,0.586,0.797,0.879,1.500,0.800,1.030,
1.170,0.807,0.622,0.989,1.950,1.480,1.230,1.450,1.270,0.156,
0.778,1.070,1.620,1.420,1.260,2.040,2.790,1.250,0.937,1.780,
1.520,0.920,0.823,1.100,1.640,0.234,0.767,1.150,1.710,1.510,
0.977,2.230,2.120,1.450,0.950,1.300,1.680,1.280,1.130,1.190,
1.430,0.184,0.908,1.270,1.390,1.590,0.941,1.670,1.420,1.500,
1.310,1.430,0.165,0.136,0.119,0.189,1.120,0.126,0.756,1.180,
1.090,1.570,1.110,1.790,1.850,1.040,0.897,1.750,1.260,0.925,
0.849,1.280,1.870,0.183,1.390,2.180,2.790,2.230,2.380,4.570,
0.314,0.273,0.217,0.247,0.273,0.247,0.178,0.183,0.235,0.057,
0.112,0.160,0.220,0.313,0.131,0.190,0.301,0.263,0.306,0.215,
0.281,0.226,0.229,0.181,0.172,0.038,0.143,0.150,0.114,0.181,
0.117,0.161,0.148,0.178,0.124,0.134,0.026,0.034,0.026,0.035,
0.110,0.023,0.090,0.107,0.089,0.154,0.100,0.133,0.153,0.096,
0.086,0.139,0.201,0.186,0.131,0.165,0.131,0.017,0.084,0.129,
0.130,0.104,0.121,0.220,0.295,0.254,0.142,0.256,0.253,0.255,
0.164,0.161,0.170,0.039,0.085,0.186,0.137,0.180,0.081,0.147,
0.265,0.276,0.131,0.143,0.271,0.199,0.210,0.181,0.185,0.057,
0.138,0.159,0.096,0.158,0.091,0.109,0.154,0.233,0.126,0.174,
0.038,0.065,0.046,0.056,0.172,0.050,0.123,0.154,0.100,0.203,
0.124,0.161,0.118,0.095,0.069,0.113,0.189,0.226,0.148,0.156,
0.116,0.017,0.077,0.111,0.097,0.097,0.107,0.181,0.199,0.150,
0.091,0.127,0.270,0.284,0.258,0.210,0.196,0.046,0.126,0.126,
0.117,0.169,0.122,0.167,0.030,0.049,0.027,0.026,0.051,0.084,
0.070,0.038,0.038,0.032,0.058,0.044,0.018,0.050,0.032,0.030,
0.148,0.197,0.140,0.134,0.041,0.061,0.050,0.040,0.144,0.048,
0.129,0.136,0.093,0.264,0.158,0.158,0.137,0.091,0.077,0.109,
0.250,0.247,0.215,0.213,0.150,0.029,0.123,0.157,0.149,0.186,
0.170,0.268,0.279,0.192,0.113,0.187,0.180,0.129,0.107,0.124,
0.165,0.025,0.088,0.129,0.165,0.168,0.151,0.257,0.344,0.280,
0.195,0.218,0.366,0.339,0.292,0.256,0.267,0.048,0.206,0.252,
0.203,0.307,0.191,0.264,0.160,0.200,0.158,0.178,0.023,0.030,
0.023,0.029,0.156,0.028,0.139,0.177,0.128,0.208,0.166,0.235,
0.208,0.137,0.107,0.189,0.172,0.161,0.123,0.173,0.204,0.026,
0.181,0.264,0.269,0.250,0.247,0.434,2.530,1.490,1.150,1.650,
1.710,1.210,0.822,1.020,1.070,0.146,0.992,0.941,1.030,0.970,
0.868,1.070,2.130,1.600,0.924,1.030,1.980,1.380,1.120,0.953,
1.270,0.190,1.110,1.070,0.736,1.040,0.688,0.863,1.360,1.880,
0.936,1.150,0.211,0.251,0.154,0.251,1.570,0.468,0.782,0.952,
0.768,2.300,0.712,1.080,1.010,0.651,0.512,0.935,1.290,0.979,
0.722,0.988,1.020,0.133,0.774,1.070,0.829,0.859,0.809,1.590,
0.211,0.172,0.098,0.156,0.354,0.243,0.126,0.134,0.111,0.030,
0.081,0.096,0.081,0.103,0.061,0.109,0.189,0.183,0.077,0.084,
0.247,0.239,0.164,0.128,0.139,0.052,0.141,0.134,0.067,0.107,
0.066,0.084,0.130,0.221,0.107,0.117,0.040,0.066,0.046,0.037,
0.138,0.062,0.157,0.145,0.073,0.205,0.105,0.172,0.132,0.087,
0.065,0.118,0.219,0.214,0.129,0.173,0.118,0.024,0.099,0.137,
0.083,0.096,0.105,0.165,1.610,1.310,0.675,0.712,2.080,2.600,
1.250,1.080,1.250,0.255,0.905,0.975,0.659,0.956,0.771,0.936,
0.154,0.251,0.096,0.096,0.259,0.659,0.202,0.142,0.148,0.071,
0.149,0.138,0.082,0.195,0.112,0.106,1.180,1.460,0.754,0.813,
0.178,0.255,0.158,0.177,1.010,0.200,0.376,0.608,0.548,1.240,
0.689,0.787,0.845,0.567,0.397,0.545,1.440,1.340,0.846,0.947,
1.140,0.155,0.763,0.886,0.635,0.907,0.699,0.929,1.430,0.800,
0.537,0.774,0.989,0.729,0.427,0.511,0.778,0.114,0.489,0.649,
0.620,0.636,0.452,0.772,1.530,1.410,0.737,0.766,1.640,1.910,
0.984,0.858,1.080,0.184,0.937,1.020,0.767,1.220,0.828,0.917,
1.100,1.580,0.758,0.926,0.136,0.190,0.111,0.133,1.120,0.180,
0.778,0.940,0.708,1.370,0.836,1.030,0.863,0.628,0.417,0.629,
1.100,0.908,0.569,0.734,0.984,0.109,0.872,1.080,0.795,0.884,
0.806,1.130,2.780,1.420,0.973,1.950,1.380,0.875,0.650,0.876,
1.070,0.119,0.498,0.893,1.690,0.994,0.659,1.610,2.150,1.200,
0.656,0.928,1.070,0.695,0.531,0.654,0.723,0.069,0.441,0.647,
0.653,0.607,0.441,0.840,1.450,1.650,0.605,0.992,0.136,0.119,
0.075,0.163,1.050,0.118,0.420,0.742,0.775,1.150,0.541,0.979,
1.450,0.849,0.659,1.180,1.170,0.752,0.590,0.994,0.892,0.073,
0.506,0.847,1.160,0.784,0.813,1.930,3.180,2.050,1.200,2.030,
2.210,1.760,1.090,1.320,1.370,0.156,0.762,1.150,1.230,1.180,
0.646,1.300,2.370,1.870,0.810,1.160,1.770,1.460,1.110,1.270,
1.190,0.133,0.864,1.190,0.860,0.936,0.591,1.010,1.360,1.630,
0.866,1.180,0.141,0.180,0.139,0.178,1.180,0.165,0.913,1.250,
0.875,1.610,0.912,1.560,1.460,0.920,0.804,1.150,1.810,1.380,
1.100,1.470,1.130,0.096,0.790,1.180,1.030,0.951,0.960,1.770,
2.210,1.510,0.914,1.160,2.020,1.930,1.330,1.460,1.460,0.229,
0.873,1.750,1.110,1.360,1.050,1.770,0.201,0.201,0.087,0.131,
0.204,0.296,0.191,0.164,0.126,0.054,0.131,0.158,0.124,0.269,
0.114,0.155,1.300,1.870,0.783,1.020,0.151,0.212,0.125,0.170,
1.440,0.397,0.719,1.130,1.310,4.230,1.020,1.310,1.180,0.900,
0.666,0.947,1.710,1.540,1.200,1.470,1.530,0.161,1.090,1.390,
1.380,1.520,1.240,1.770,3.090,1.060,0.804,1.360,1.200,0.755,
0.603,0.842,1.290,0.165,0.622,1.150,0.984,0.783,0.649,1.560,
2.080,1.410,0.816,1.100,1.660,1.360,1.020,1.050,1.090,0.124,
0.921,1.260,0.965,1.060,0.854,1.400,1.610,1.770,0.958,1.490,
0.148,0.174,0.095,0.189,1.640,0.186,1.180,1.680,1.290,1.990,
1.260,1.730,1.950,1.070,0.881,1.740,1.640,1.650,0.996,1.520,
1.710,0.137,1.340,2.100,1.980,1.540,1.660,2.670,6.710,3.850,
3.150,6.170,3.810,2.120,1.870,2.470,3.360,0.324,1.310,2.390,
5.340,4.500,2.030,4.290,3.140,1.700,1.400,1.840,1.800,1.000,
0.916,1.030,1.670,0.130,0.880,1.120,1.570,1.510,0.998,1.690,
2.130,1.580,1.090,1.840,0.198,0.159,0.119,0.240,1.230,0.104,
0.582,0.949,1.320,1.510,0.895,1.780,3.770,1.710,1.570,3.240,
2.440,1.660,1.530,2.100,1.840,0.151,0.956,1.720,2.750,1.780,
1.780,4.310,3.760,1.900,1.220,2.550,2.300,1.220,0.859,1.160,
1.750,0.145,0.675,1.090,1.690,1.500,0.699,1.740,2.080,1.300,
0.650,1.080,1.300,0.680,0.617,0.722,1.290,0.084,0.513,0.768,
0.968,0.854,0.477,0.896,1.530,1.200,0.885,1.450,0.127,0.105,
0.095,0.146,1.420,0.101,0.512,0.790,1.260,1.580,0.708,1.340,
1.440,0.832,0.736,1.420,1.230,0.964,1.160,1.180,1.130,0.074,
0.515,0.958,1.180,0.974,0.833,2.190,2.980,1.390,1.030,1.890,
2.240,1.560,1.290,1.730,2.020,0.203,0.602,1.120,2.080,1.660,
0.954,2.530,0.234,0.147,0.098,0.184,0.176,0.131,0.112,0.158,
0.161,0.019,0.083,0.137,0.234,0.238,0.127,0.270,1.180,1.030,
0.790,1.130,0.111,0.082,0.072,0.136,0.816,0.087,0.371,0.681,
0.939,1.070,0.651,1.060,1.300,0.778,1.090,2.010,1.410,0.958,
0.860,1.410,1.090,0.094,0.584,1.030,1.430,1.120,1.130,2.090,
4.460,1.750,1.230,2.790,1.920,1.110,0.909,1.440,2.400,0.203,
0.981,1.720,3.950,2.230,1.430,3.940,2.610,1.470,1.090,1.650,
1.640,1.080,0.944,1.180,1.660,0.128,0.902,1.370,2.090,1.820,
1.100,2.250,1.690,1.410,1.150,1.680,0.137,0.110,0.091,0.156,
1.370,0.100,0.842,1.240,1.450,1.670,1.110,2.110,3.040,1.560,
1.500,3.460,1.850,1.320,1.080,1.770,2.420,0.167,1.440,2.580,
4.030,3.090,2.600,6.130,5.230,3.210,2.210,4.240,3.260,2.300,
1.640,2.200,2.570,0.375,1.030,1.890,3.900,5.960,1.580,3.080,
3.620,2.450,1.780,2.360,2.450,1.650,1.430,1.530,1.670,0.200,
1.170,1.450,1.550,2.080,1.100,2.010,1.900,1.980,1.100,1.740,
0.200,0.204,0.127,0.240,1.240,0.132,0.738,1.120,1.400,1.670,
1.060,1.930,1.910,1.200,1.050,1.730,1.980,1.720,1.120,1.540,
1.290,0.116,0.805,1.360,1.610,1.190,1.230,2.670,3.660,2.350,
1.220,3.420,2.540,1.840,1.090,1.500,1.610,0.185,0.658,1.580,
2.230,2.150,0.816,2.050,2.530,2.140,0.920,1.610,2.110,1.280,
1.080,1.230,1.450,0.163,0.744,1.120,1.140,1.320,0.685,1.140,
1.600,1.760,0.871,1.640,0.233,0.206,0.130,0.467,1.440,0.166,
0.700,1.160,1.660,1.720,0.909,1.940,1.270,1.100,0.709,1.170,
1.530,1.770,0.907,1.260,0.970,0.090,0.548,1.040,1.180,0.962,
0.803,1.870,2.700,1.540,0.886,1.760,2.220,1.700,1.480,2.120,
1.520,0.212,0.730,1.050,1.530,1.600,0.974,1.960,0.159,0.154,
0.092,0.142,0.177,0.193,0.160,0.169,0.125,0.031,0.109,0.130,
0.151,0.227,0.115,0.175,1.460,1.520,0.986,1.320,0.153,0.160,
0.120,0.183,1.090,0.147,0.648,1.040,1.040,1.670,0.971,1.550,
1.320,0.842,0.782,1.270,1.690,1.520,1.230,1.490,1.230,0.116,
0.753,1.310,1.440,1.300,1.330,2.460,3.180,1.600,0.981,1.860,
1.500,0.987,0.772,1.090,1.450,0.140,0.702,1.250,2.010,1.440,
1.090,2.370,2.460,1.790,1.370,1.670,2.060,1.720,1.390,1.480,
1.510,0.163,1.020,1.510,1.780,2.110,1.300,2.090,1.530,1.590,
1.160,1.720,0.131,0.128,0.091,0.162,1.140,0.116,0.886,1.350,
1.210,1.580,1.110,1.940,2.040,1.160,1.040,1.760,1.640,1.260,
0.910,1.360,1.720,0.140,1.340,2.260,2.390,2.050,1.910,3.530,
2.740,1.910,1.200,2.290,1.630,1.190,0.788,1.150,1.420,0.152,
1.120,1.220,1.670,1.410,0.941,1.570,2.910,1.830,1.040,1.430,
1.760,1.190,0.945,0.948,1.390,0.142,0.953,1.190,1.310,1.390,
0.798,1.310,1.600,1.940,1.050,1.600,0.227,0.228,0.132,0.271,
1.220,0.169,0.762,1.760,1.010,1.810,0.918,3.050,1.590,1.130,
1.080,1.670,1.480,1.570,0.898,1.320,1.360,0.167,0.973,1.540,
1.370,1.160,1.200,2.690,0.205,0.158,0.112,0.303,0.176,0.158,
0.086,0.138,0.115,0.017,0.072,0.116,0.127,0.142,0.086,0.187,
0.184,0.170,0.071,0.118,0.172,0.195,0.114,0.117,0.123,0.029,
0.112,0.125,0.089,0.131,0.070,0.141,0.110,0.171,0.085,0.155,
0.021,0.034,0.022,0.045,0.171,0.035,0.106,0.239,0.129,0.288,
0.164,1.500,0.154,0.113,0.090,0.165,0.171,0.197,0.123,0.193,
0.124,0.018,0.090,0.151,0.120,0.131,0.116,0.379,1.890,1.340,
0.826,1.030,1.750,1.860,1.170,1.230,1.430,0.218,0.803,1.050,
1.010,1.210,0.951,1.490,0.158,0.176,0.072,0.102,0.136,0.198,
0.105,0.089,0.127,0.031,0.105,0.106,0.118,0.186,0.118,0.149,
1.300,1.920,0.917,1.080,0.141,0.189,0.112,0.136,1.130,0.163,
0.542,0.812,0.738,1.410,0.818,1.270,1.150,0.951,0.667,0.930,
1.420,1.600,1.040,1.150,1.330,0.132,1.020,1.170,0.971,1.050,
1.100,1.630,2.150,1.100,0.705,1.470,1.270,0.898,0.568,0.775,
1.350,0.125,0.687,0.993,1.390,1.010,0.726,1.440,2.290,1.750,
1.010,1.370,1.610,1.580,0.942,0.933,1.910,0.173,1.090,1.370,
1.500,1.740,1.090,1.620,1.600,1.900,1.180,1.480,0.131,0.170,
0.195,0.141,1.340,0.145,0.859,1.320,1.160,1.950,1.240,1.850,
1.560,1.030,0.812,1.180,1.350,1.220,0.925,1.100,1.500,0.128,
1.210,1.660,1.570,1.530,1.410,2.300,5.030,2.350,1.730,3.790,
2.030,1.250,0.956,1.610,1.840,0.169,0.916,1.590,2.590,2.110,
1.200,2.970,2.890,1.540,0.878,1.450,1.470,0.964,0.732,0.955,
1.240,0.099,0.751,1.090,1.190,1.100,0.712,1.340,1.990,2.620,
0.961,1.920,0.156,0.180,0.089,0.223,1.260,0.122,0.604,1.190,
1.220,1.500,0.839,1.870,2.690,1.610,1.310,2.730,1.680,1.270,
1.020,1.790,1.540,0.119,0.981,2.090,2.420,1.650,1.720,4.760,
2.810,1.610,1.170,2.120,1.690,1.300,0.758,1.170,1.210,0.103,
0.617,1.140,1.250,1.150,0.754,1.680,2.110,1.460,0.676,1.110,
1.410,1.110,0.709,0.942,1.100,0.088,0.688,1.180,1.020,0.991,
0.601,1.190,1.420,1.320,0.735,1.410,0.097,0.101,0.060,0.148,
1.170,0.114,0.678,1.330,1.210,1.860,0.911,3.150,1.900,1.100,
0.988,1.700,1.450,1.170,0.953,1.700,1.190,0.080,0.782,1.480,
1.420,1.190,1.180,2.830,3.030,2.080,1.250,1.790,2.480,1.830,
1.450,2.040,1.890,0.210,1.090,1.650,1.770,1.600,1.320,2.570,
0.220,0.343,0.114,0.154,0.156,0.171,0.129,0.151,0.115,0.018,
0.107,0.148,0.155,0.188,0.111,0.221,1.970,2.160,1.150,1.670,
0.145,0.142,0.101,0.170,1.670,0.176,0.848,1.460,1.440,2.150,
1.280,2.080,2.120,1.520,1.450,1.970,2.280,1.820,1.590,2.140,
2.000,0.153,1.390,2.160,1.940,1.590,1.770,3.120,4.730,2.020,
1.380,2.760,2.130,1.400,1.050,1.540,2.010,0.162,1.080,1.750,
2.800,1.940,1.710,4.100,3.430,2.370,1.320,1.930,2.370,2.070,
1.270,1.530,1.930,0.136,1.230,1.810,1.960,1.850,1.420,2.590,
2.870,2.740,1.650,2.760,0.171,0.165,0.112,0.196,2.240,0.155,
1.480,2.510,2.350,2.710,2.080,3.360,4.950,2.490,2.000,4.410,
2.930,2.320,1.670,2.900,3.020,0.164,2.280,3.820,4.790,2.730,
2.890,6.020,9.430,5.960,3.930,7.140,6.330,4.560,2.910,3.260,
5.100,0.599,2.120,3.530,6.420,5.240,2.600,4.360,8.180,6.490,
2.730,3.180,4.960,3.710,2.280,2.130,3.490,0.400,1.900,2.280,
2.500,2.810,1.760,2.470,3.830,4.050,2.250,2.660,0.402,0.443,
0.311,0.443,2.400,0.335,1.510,1.810,1.990,3.430,1.730,2.350,
5.840,2.910,2.340,3.690,4.220,3.220,2.420,3.440,2.820,0.325,
1.520,2.560,3.380,2.590,2.250,3.590,6.860,3.330,1.790,3.170,
5.140,3.910,2.150,2.190,3.350,0.458,1.310,1.900,2.360,2.750,
1.200,1.940,5.360,4.460,1.540,1.890,3.880,3.160,1.810,1.660,
2.950,0.467,1.490,1.940,1.640,2.480,1.110,1.390,2.810,3.570,
1.580,1.720,0.312,0.425,0.261,0.257,2.680,0.408,1.520,1.720,
1.340,2.890,1.320,1.550,2.150,1.600,0.924,1.420,2.570,2.270,
1.290,1.700,2.200,0.227,1.280,1.610,1.960,1.730,1.300,2.230,
3.340,2.030,1.190,1.750,3.340,2.120,2.300,1.860,2.780,0.412,
1.080,1.740,1.790,2.060,1.260,2.290,0.314,0.344,0.157,0.197,
0.346,0.320,0.252,0.196,0.265,0.078,0.186,0.241,0.214,0.411,
0.189,0.277,1.560,1.840,1.720,1.160,0.200,0.205,0.231,0.186,
1.560,0.226,0.844,1.210,0.858,1.520,1.040,1.010,1.430,1.070,
1.060,1.130,2.140,1.810,1.450,1.480,2.100,0.216,0.989,1.460,
1.300,1.510,1.470,1.940,4.250,1.880,1.260,2.550,2.140,1.250,
1.230,1.230,1.940,0.206,0.751,1.360,2.330,1.850,1.200,2.740,
3.620,2.990,1.600,1.960,2.910,2.200,2.030,1.580,1.930,0.219,
1.110,1.580,1.750,2.270,1.300,2.130,1.820,1.820,2.640,1.570,
0.220,0.214,1.280,0.302,1.560,0.192,1.070,1.270,1.250,1.990,
1.400,1.510,2.580,1.420,1.330,1.990,1.690,1.380,2.190,1.570,
2.130,0.221,1.380,2.130,2.410,2.170,2.040,3.450,7.560,6.810,
2.800,4.160,5.030,4.320,2.420,2.420,2.730,0.378,1.140,1.750,
2.610,3.140,1.490,2.490,8.670,16.5,3.680,3.550,4.680,4.480,
2.590,2.120,2.660,0.577,1.470,1.870,1.540,2.530,1.220,1.650,
2.380,4.320,1.680,1.730,0.352,0.541,0.283,0.297,1.630,0.264,
1.340,1.330,1.080,2.170,1.450,1.520,2.210,1.540,1.060,1.490,
2.880,2.720,1.440,1.710,1.520,0.182,0.911,1.270,1.810,1.500,
1.290,2.440,4.680,4.640,1.510,2.080,4.460,4.130,1.940,1.700,
2.220,0.383,0.958,1.330,1.340,2.190,1.080,1.580,3.730,5.330,
1.420,1.450,3.230,1.890,1.870,1.410,2.260,0.465,1.180,1.550,
1.120,2.030,1.120,1.230,1.960,3.700,1.250,1.350,0.345,0.645,
0.314,0.264,2.360,0.622,1.380,1.740,1.090,3.130,1.220,1.400,
1.530,1.390,0.634,0.894,2.370,2.520,1.030,1.180,1.610,0.227,
0.804,1.140,1.720,1.520,0.905,1.570,2.280,2.170,0.877,1.240,
2.720,2.590,1.940,1.620,1.640,0.321,0.897,1.110,0.885,1.400,
1.020,1.310,0.246,0.643,0.141,0.157,0.257,0.413,0.281,0.172,
0.222,0.160,0.217,0.224,0.111,0.332,0.149,0.161,1.600,2.180,
1.430,1.120,0.288,0.375,0.257,0.203,1.550,0.286,1.050,1.260,
0.727,1.730,1.110,1.080,1.170,0.916,0.728,0.915,2.070,2.290,
1.550,1.520,1.480,0.208,1.150,1.480,0.941,1.370,1.240,1.600,
2.040,1.340,0.738,1.130,1.800,1.120,0.698,0.809,0.977,0.104,
0.396,0.650,0.960,0.891,0.621,1.090,2.200,2.670,1.160,1.250,
1.910,2.180,1.250,1.180,1.160,0.185,0.748,1.060,0.846,1.720,
0.822,1.170,1.220,1.610,1.090,1.070,0.136,0.201,0.168,0.133,
1.170,0.178,0.806,1.020,0.796,1.420,0.976,1.130,1.360,0.902,
0.727,0.992,1.350,1.330,0.791,1.010,1.280,0.150,0.995,1.500,
1.560,1.550,1.360,2.140,3.300,2.980,1.390,2.130,2.370,2.440,
1.200,1.260,1.490,0.243,0.819,1.130,1.540,1.700,0.878,1.510,
4.740,7.270,2.240,2.110,3.780,5.000,1.870,1.800,2.330,0.510,
1.410,1.510,1.350,2.370,1.390,1.430,2.150,3.170,1.580,1.590,
0.332,0.486,0.217,0.290,1.680,0.332,0.838,1.040,0.913,2.050,
0.896,1.190,1.650,1.160,0.859,1.240,1.790,1.650,0.939,1.170,
1.540,0.182,0.801,1.240,1.500,1.260,1.170,2.730,0.290,0.473,
0.129,0.197,0.424,0.643,0.231,0.232,0.214,0.070,0.120,0.141,
0.163,0.330,0.127,0.181,0.488,1.900,0.225,0.251,0.661,1.650,
0.393,0.425,0.326,0.176,0.216,0.226,0.165,0.468,0.185,0.202,
0.184,0.439,0.167,0.153,0.057,0.161,0.080,0.050,0.275,0.123,
0.217,0.204,0.131,0.454,0.213,0.172,0.187,0.202,0.095,0.152,
0.360,0.454,0.230,0.261,0.214,0.051,0.149,0.206,0.188,0.221,
0.171,0.301,1.670,1.850,1.020,0.876,1.900,1.980,3.680,1.350,
1.770,0.403,1.140,0.984,0.875,1.380,1.390,1.160,0.218,0.662,
0.130,0.110,0.200,0.375,0.251,0.124,0.214,0.103,0.159,0.135,
0.133,0.382,0.188,0.136,1.150,2.210,1.040,0.996,0.194,0.348,
0.239,0.167,2.010,0.515,1.040,1.080,0.997,3.310,1.140,0.960,
0.896,0.842,0.646,0.629,1.450,1.730,1.090,1.050,1.680,0.316,
0.936,1.060,0.824,1.610,0.940,1.190,1.490,1.090,0.553,0.860,
1.240,0.918,0.845,0.607,1.630,0.169,0.437,0.750,1.040,0.975,
0.682,1.220,2.240,3.410,1.020,1.160,2.100,2.580,1.320,1.060,
1.790,0.320,0.957,1.150,1.130,1.890,1.310,1.280,1.320,2.100,
1.030,1.020,0.180,0.338,0.208,0.170,2.300,0.787,0.931,1.210,
1.010,2.740,1.000,1.200,1.300,0.979,0.779,0.975,1.380,1.530,
0.983,1.170,1.710,0.264,1.030,1.430,1.400,1.850,1.240,1.990,
3.630,2.350,1.420,2.610,1.990,1.520,0.932,1.090,1.640,0.205,
0.714,1.190,2.450,2.040,1.140,2.470,2.210,2.260,0.863,1.340,
1.630,1.610,0.713,0.857,1.190,0.186,0.524,0.786,0.954,1.060,
0.624,0.998,1.680,1.680,0.892,1.380,0.197,0.215,0.108,0.224,
1.580,0.144,0.521,0.804,1.040,1.330,0.696,1.190,1.960,1.010,
0.919,1.770,1.370,1.050,0.731,1.250,1.450,0.117,0.599,1.130,
1.710,1.250,1.170,3.140,3.390,2.910,1.310,2.270,3.110,3.120,
1.320,1.530,2.130,0.310,0.902,1.430,1.800,2.320,1.040,1.920,
3.110,5.060,1.080,1.650,3.310,4.580,1.500,1.660,2.030,0.458,
1.070,1.520,1.360,2.110,0.882,1.310,1.540,2.070,0.873,1.230,
0.175,0.315,0.137,0.188,1.720,0.252,1.060,1.320,1.130,2.160,
1.130,1.410,1.410,1.090,0.688,1.130,1.840,1.840,1.030,1.490,
1.510,0.146,0.878,1.320,1.440,1.430,1.100,2.140,1.590,1.660,
0.748,1.010,1.650,1.410,1.270,1.060,1.820,0.522,0.820,1.110,
1.140,1.700,1.070,1.520,0.190,0.618,0.098,0.131,0.146,0.242,
0.127,0.099,0.415,0.313,0.144,0.171,0.154,0.518,0.120,0.154,
1.020,1.340,0.829,0.818,0.144,0.158,0.154,0.124,1.180,0.220,
0.624,0.833,0.769,1.660,0.967,1.020,0.986,0.754,0.588,0.820,
1.770,1.400,1.030,1.190,1.270,0.212,0.691,1.090,0.939,1.190,
0.958,1.750,2.570,1.460,0.971,1.540,1.420,1.070,0.733,0.874,
2.640,0.193,0.573,0.941,1.920,1.370,1.050,2.040,1.690,1.780,
0.659,0.952,1.420,1.300,0.786,0.863,1.850,0.351,0.658,1.050,
1.080,1.600,0.802,1.270,1.540,1.660,0.935,1.360,0.154,0.183,
0.117,0.149,1.540,0.228,0.882,1.350,1.270,2.300,1.370,1.650,
2.260,1.400,0.992,2.130,2.030,2.700,1.170,1.660,2.130,0.197,
1.360,2.330,2.790,2.530,1.980,3.730,6.180,4.550,2.610,4.110,
4.750,3.920,2.040,2.280,3.430,0.496,1.600,3.070,3.260,3.530,
1.660,2.820,5.570,5.370,2.180,2.360,5.080,4.210,2.270,2.040,
2.920,0.472,1.930,2.210,1.760,2.600,1.580,1.790,1.930,2.250,
1.230,1.490,0.269,0.313,0.219,0.272,1.350,0.240,0.922,1.090,
1.030,2.030,1.020,1.450,2.200,1.310,0.874,1.630,2.210,1.930,
1.170,1.580,1.610,0.279,0.934,1.390,1.640,1.520,1.310,2.260,
4.940,3.700,1.360,2.130,4.380,4.280,1.700,1.780,2.670,0.480,
1.220,1.570,1.560,2.410,0.862,1.480,4.920,6.450,1.550,1.840,
4.220,3.940,2.030,1.900,2.920,0.826,1.880,2.300,1.440,3.010,
1.080,1.360,1.780,2.870,1.100,1.140,0.284,0.525,0.346,0.275,
1.850,0.512,1.530,1.490,1.010,2.950,1.250,1.310,1.180,1.010,
0.518,0.796,1.730,1.900,0.917,1.170,1.360,0.212,0.890,1.130,
1.060,1.340,0.993,1.610,2.100,1.740,0.774,1.170,2.790,2.500,
1.600,1.530,2.530,0.406,1.040,1.390,1.150,1.580,0.921,1.740,
0.230,0.454,0.172,0.181,0.335,0.447,0.308,0.231,0.309,0.146,
0.260,0.273,0.146,0.406,0.178,0.225,0.911,1.370,0.911,0.736,
0.176,0.218,0.170,0.153,1.210,0.259,0.882,1.030,0.610,1.330,
0.790,0.790,0.808,0.707,0.486,0.655,1.480,1.460,1.050,1.120,
1.320,0.213,0.883,1.150,0.897,1.220,1.040,1.420,2.010,1.130,
0.665,1.390,1.200,0.846,0.578,0.675,1.300,0.144,0.465,0.758,
1.210,1.060,0.621,1.550,2.240,2.380,1.070,1.390,2.270,2.250,
1.460,1.360,1.680,0.262,0.983,1.380,1.110,1.900,0.846,1.320,
1.030,1.230,1.880,0.976,0.142,0.140,0.559,0.172,0.924,0.148,
0.880,0.887,0.630,1.180,0.842,0.950,1.760,0.885,0.717,1.090,
0.991,0.889,1.360,0.913,1.220,0.149,0.896,1.250,1.340,1.440,
1.250,2.500,4.180,3.640,1.730,2.580,3.980,4.370,1.860,1.800,
1.940,0.317,0.904,1.290,1.410,1.920,0.893,1.500,4.170,5.480,
2.220,1.930,4.980,6.150,2.740,2.150,2.180,0.529,1.560,1.720,
1.010,2.050,1.080,1.320,1.450,2.290,1.180,1.210,0.243,0.420,
0.257,0.249,1.040,0.251,1.130,1.110,0.639,1.490,0.905,1.070,
1.150,0.973,0.554,0.914,1.690,2.030,0.983,1.100,0.803,0.132,
0.775,0.934,0.854,0.911,0.814,1.390,3.190,3.300,1.280,1.390,
3.220,4.480,1.590,1.340,2.020,0.437,0.970,1.110,0.871,1.740,
0.634,1.040,2.250,2.620,0.991,1.010,1.300,0.539,0.987,0.798,
1.700,0.782,1.130,1.480,0.658,1.860,0.816,0.939,1.230,2.830,
1.140,1.080,0.296,0.845,0.419,0.307,1.650,0.643,1.280,1.500,
0.711,2.930,1.280,1.300,0.753,0.889,0.439,0.524,1.460,2.380,
0.951,1.060,1.050,0.222,0.861,1.010,0.667,1.110,0.701,1.040,
1.670,1.860,0.696,1.000,2.910,3.600,1.880,1.720,1.490,0.332,
0.964,1.080,0.718,1.290,0.891,1.220,0.196,0.553,0.169,0.169,
0.442,0.846,0.474,0.265,0.253,0.232,0.336,0.276,0.099,0.388,
0.203,0.170,0.993,1.800,1.060,0.888,0.239,0.499,0.280,0.219,
1.180,0.315,0.975,1.180,0.583,1.780,1.100,1.070,0.664,0.657,
0.490,0.609,1.610,2.360,1.500,1.410,1.310,0.225,1.230,1.380,
0.742,1.150,1.220,1.430,1.270,1.060,0.527,0.743,1.340,1.230,
0.557,0.604,0.818,0.104,0.383,0.497,0.638,0.720,0.428,0.764,
1.570,2.440,0.980,1.060,2.430,3.280,1.500,1.390,1.330,0.283,
0.877,1.120,0.750,1.680,0.836,1.130,0.782,1.440,0.866,0.821,
0.114,0.249,0.158,0.160,0.855,0.201,1.040,1.080,0.568,1.390,
1.090,1.170,0.824,0.725,0.421,0.630,0.866,1.250,0.652,0.791,
0.792,0.118,0.770,1.020,0.782,1.140,1.000,1.660,2.630,2.450,
1.080,1.600,2.660,2.140,0.974,1.240,1.340,0.221,0.679,0.957,
1.150,1.440,0.648,1.170,4.350,6.430,1.630,1.910,6.940,4.240,
2.830,2.520,2.770,0.625,1.980,2.090,1.300,2.380,1.060,1.330,
1.530,2.520,0.989,1.170,0.460,0.385,0.198,0.284,1.330,0.352,
0.874,1.020,0.719,1.800,0.795,1.020,1.110,0.883,0.499,0.914,
1.770,1.480,0.784,1.080,1.430,0.210,0.847,1.200,1.010,1.090,
0.981,1.900,0.217,0.420,0.109,0.137,0.470,0.640,0.293,0.252,
0.208,0.085,0.135,0.141,0.116,0.293,0.113,0.170,0.507,1.900,
0.260,0.268,1.120,1.260,1.040,0.774,0.461,0.448,0.471,0.401,
0.151,0.510,0.166,0.176,0.131,0.425,0.152,0.125,0.103,0.260,
0.158,0.080,0.247,0.200,0.327,0.246,0.101,0.450,0.272,0.171,
0.112,0.139,0.059,0.091,0.356,0.437,0.197,0.237,0.166,0.060,
0.187,0.200,0.098,0.162,0.152,0.208,2.030,4.760,1.020,1.020,
2.580,3.900,2.100,1.560,2.050,0.578,1.320,1.340,0.830,1.680,
1.060,1.540,0.503,2.990,0.302,0.220,0.457,1.100,0.500,0.261,
0.379,0.273,0.433,0.297,0.134,0.513,0.210,0.198,1.140,2.990,
1.080,0.918,0.272,0.556,0.261,0.214,1.740,0.557,0.946,1.270,
0.653,2.200,1.060,1.010,0.778,1.140,0.505,0.728,1.760,2.650,
1.230,1.300,2.070,0.408,1.770,1.710,0.729,1.330,1.200,1.370,
1.360,1.870,0.499,0.774,1.170,1.090,0.484,0.531,1.360,0.187,
0.523,0.801,0.776,0.916,0.470,1.060,3.280,9.470,1.480,1.490,
3.590,4.890,1.980,1.640,4.330,0.757,1.990,2.150,1.380,2.920,
1.210,1.500,1.190,2.770,1.080,0.969,0.173,0.380,0.195,0.152,
1.530,0.401,1.260,1.370,0.798,2.190,1.070,1.170,1.090,1.180,
0.610,0.893,1.210,1.510,0.876,0.928,1.600,0.237,1.430,1.590,
1.080,1.630,1.280,1.780,2.200,1.550,0.824,1.430,1.500,1.150,
0.672,0.923,1.050,0.138,0.490,0.900,1.120,1.070,0.561,1.570,
2.040,2.030,0.734,1.030,2.070,1.430,0.837,1.140,1.050,0.139,
0.550,0.793,0.691,0.876,0.465,0.791,1.030,1.090,0.513,0.821,
0.124,0.119,0.065,0.130,0.737,0.113,0.431,0.675,0.538,0.858,
0.419,0.733,1.150,0.661,0.447,0.897,0.916,0.757,0.523,0.902,
0.835,0.075,0.432,0.796,0.878,0.706,0.629,1.580,2.330,2.200,
0.838,1.230,2.550,2.750,1.440,1.400,1.850,0.317,0.904,1.370,
1.240,1.920,0.732,1.680,2.680,4.130,0.954,1.200,4.720,3.980,
2.300,2.150,2.180,0.508,1.360,1.730,1.150,2.170,0.899,1.190,
0.831,1.540,0.610,0.731,0.171,0.301,0.150,0.165,1.270,0.248,
0.926,1.060,0.797,1.720,0.910,1.020,0.724,0.644,0.376,0.581,
1.340,1.550,0.774,1.170,1.100,0.138,0.747,1.150,0.798,0.966,
0.799,1.620,1.520,2.220,0.593,0.747,2.060,2.590,1.240,1.190,
1.790,0.314,0.941,1.230,0.967,1.250,0.882,1.460,0.188,0.779,
0.085,0.110,0.209,0.419,0.187,0.139,0.241,0.087,0.155,0.148,
0.104,0.228,0.104,0.132,0.761,1.250,0.635,0.628,0.110,0.174,
0.113,0.120,1.120,0.225,0.820,1.030,0.630,1.400,0.775,0.907,
0.645,0.672,0.402,0.579,1.170,1.360,0.838,1.020,1.230,0.187,
0.950,1.180,0.844,0.970,0.941,1.320,1.770,1.660,0.560,0.995,
1.080,1.020,0.486,0.614,1.440,0.152,0.529,0.714,0.990,0.895,
0.564,1.180,1.600,2.520,0.595,0.808,1.650,1.770,0.890,0.962,
3.930,0.468,0.824,1.090,1.190,1.410,0.651,1.060,0.953,1.320,
0.642,0.850,0.107,0.130,0.083,0.111,1.010,0.150,0.850,1.120,
0.804,1.340,0.988,1.110,1.760,0.970,0.643,1.330,1.210,1.600,
0.883,1.190,1.580,0.162,1.150,1.690,1.620,1.600,1.460,2.060,
2.620,2.210,2.040,2.290,2.630,2.130,1.500,1.510,1.790,0.241,
0.897,1.250,1.760,1.850,1.020,1.570,2.360,2.320,3.240,1.530,
1.870,1.520,1.420,1.050,1.380,0.235,0.913,0.969,0.888,1.400,
1.110,1.300,1.210,1.540,0.891,1.110,0.156,0.178,0.131,0.186,
0.925,0.163,0.548,0.698,0.731,1.270,0.724,0.990,1.420,0.920,
0.673,1.050,1.400,1.260,0.867,1.060,0.957,0.105,0.577,0.786,
1.170,0.833,0.871,1.650,3.230,2.560,1.360,1.680,3.500,3.040,
2.070,1.660,1.730,0.299,0.777,0.980,1.130,1.770,0.806,1.270,
2.580,3.140,1.300,1.220,2.630,2.220,2.010,1.430,2.080,0.416,
1.160,1.400,1.050,2.140,0.917,1.230,1.500,2.720,1.200,1.310,
0.287,0.499,0.315,0.315,1.830,0.466,1.470,1.740,0.930,2.720,
1.360,1.380,1.070,0.927,0.495,0.783,1.750,2.180,1.060,1.340,
1.140,0.156,0.651,0.865,0.950,1.010,0.878,1.780,1.510,1.080,
0.596,0.859,2.270,2.080,1.610,1.520,1.720,0.330,0.752,0.922,
1.020,1.370,0.785,1.350,0.175,0.242,0.125,0.126,0.257,0.341,
0.259,0.214,0.264,0.087,0.187,0.188,0.173,0.447,0.193,0.252,
0.987,1.250,0.744,0.789,0.180,0.205,0.204,0.204,1.110,0.218,
0.736,0.792,0.967,1.610,0.901,1.020,0.748,0.559,0.390,0.557,
1.440,1.490,1.030,1.200,1.050,0.157,0.666,0.812,1.090,1.150,
0.930,1.590,1.420,0.742,0.502,0.919,0.895,0.661,0.551,0.675,
0.809,0.102,0.366,0.527,0.971,0.886,0.547,1.270,1.360,1.320,
0.718,0.822,1.340,1.310,1.130,1.030,1.200,0.208,0.742,0.902,
0.898,1.550,0.789,1.250,0.897,1.310,0.859,0.945,0.118,0.157,
0.156,0.162,1.030,0.163,0.882,1.070,0.907,1.530,1.120,1.560,
1.100,0.759,0.527,0.912,0.819,0.753,0.703,0.861,1.140,0.139,
0.910,1.210,1.730,1.510,1.570,2.800,0.202,0.229,0.472,0.180,
0.209,0.233,0.160,0.132,0.132,0.039,0.083,0.088,0.102,0.178,
0.088,0.108,0.346,0.546,1.470,0.348,0.353,0.432,0.431,0.210,
0.264,0.201,0.257,0.194,0.097,0.286,0.168,0.143,0.103,0.259,
0.139,0.100,0.030,0.063,0.051,0.035,0.115,0.059,0.120,0.109,
0.057,0.181,0.127,0.105,0.107,0.088,0.088,0.091,0.173,0.217,
0.130,0.125,0.108,0.025,0.106,0.113,0.097,0.097,0.131,0.169,
0.196,0.255,0.124,0.115,0.398,0.413,0.270,0.156,0.146,0.071,
0.098,0.097,0.074,0.165,0.109,0.091,0.317,0.570,0.236,0.157,
0.560,0.452,0.465,0.254,0.297,0.217,0.227,0.213,0.120,0.346,
0.150,0.156,0.138,0.378,0.152,0.119,0.080,0.258,0.157,0.062,
0.267,0.207,0.272,0.209,0.083,0.418,0.224,0.162,0.083,0.104,
0.056,0.066,0.200,0.347,0.151,0.124,0.127,0.042,0.105,0.095,
0.073,0.112,0.096,0.151,0.122,0.151,0.080,0.111,0.249,0.362,
0.324,0.310,0.189,0.079,0.136,0.106,0.072,0.160,0.112,0.125,
0.042,0.127,0.056,0.035,0.105,0.229,0.228,0.075,0.092,0.179,
0.156,0.082,0.020,0.099,0.063,0.036,0.124,0.257,0.176,0.128,
0.074,0.162,0.164,0.059,0.202,0.134,0.251,0.182,0.100,0.349,
0.292,0.154,0.089,0.083,0.072,0.086,0.225,0.326,0.251,0.194,
0.190,0.074,0.204,0.181,0.101,0.177,0.171,0.249,0.109,0.096,
0.057,0.084,0.111,0.102,0.073,0.087,0.080,0.016,0.049,0.059,
0.077,0.105,0.066,0.116,0.206,0.295,0.161,0.128,0.294,0.389,
0.295,0.239,0.250,0.087,0.170,0.175,0.132,0.370,0.165,0.185,
0.089,0.175,0.117,0.106,0.023,0.056,0.045,0.028,0.144,0.056,
0.170,0.172,0.093,0.224,0.218,0.166,0.095,0.088,0.067,0.086,
0.100,0.138,0.098,0.097,0.134,0.027,0.130,0.160,0.132,0.170,
0.177,0.233,1.790,1.550,1.380,1.730,3.020,1.790,1.110,1.210,
1.170,0.243,0.626,0.795,0.884,1.070,0.633,1.070,2.050,2.250,
1.490,1.240,2.840,2.410,2.230,1.480,1.890,0.455,1.550,1.370,
0.772,1.680,0.899,1.060,1.210,2.820,1.200,1.260,0.358,0.741,
0.302,0.381,7.850,6.390,1.230,1.700,1.120,8.610,0.935,1.140,
0.924,0.752,0.472,0.800,1.740,1.590,0.915,1.180,1.450,0.485,
0.863,1.220,0.865,1.320,0.874,1.540,0.258,0.249,0.108,0.137,
1.650,0.556,0.327,0.254,0.194,0.062,0.124,0.139,0.128,0.172,
0.088,0.130,0.219,0.441,0.158,0.119,0.545,0.611,0.515,0.277,
0.287,0.205,0.346,0.330,0.093,0.287,0.131,0.125,0.130,0.426,
0.173,0.131,0.107,0.238,0.160,0.081,0.363,0.334,0.328,0.300,
0.095,0.541,0.221,0.166,0.124,0.105,0.058,0.088,0.414,0.388,
0.211,0.237,0.176,0.062,0.162,0.167,0.089,0.137,0.120,0.178,
1.200,1.540,0.620,0.575,2.560,3.710,2.190,1.350,1.440,0.445,
1.190,1.100,0.627,1.190,0.875,1.000,0.162,0.466,0.141,0.102,
0.314,0.674,0.491,0.178,0.248,0.196,0.302,0.203,0.096,0.327,
0.183,0.140,1.120,2.270,1.150,0.912,0.307,0.532,0.452,0.280,
1.610,0.455,0.603,0.894,0.622,1.800,1.240,1.030,0.707,0.703,
0.440,0.465,1.620,2.290,1.490,1.270,1.580,0.306,1.130,1.150,
0.724,1.130,1.030,1.220,0.891,0.758,0.443,0.582,1.050,0.928,
0.508,0.494,0.679,0.113,0.431,0.557,0.573,0.741,0.402,0.690,
1.480,2.140,0.868,0.785,2.190,3.010,1.960,1.210,1.570,0.358,
1.220,1.280,0.902,1.840,1.030,1.090,1.130,2.640,1.100,1.060,
0.209,0.448,0.288,0.209,1.640,0.404,1.460,1.490,0.732,1.970,
1.150,1.160,0.789,0.767,0.444,0.603,1.110,1.410,0.839,0.854,
1.220,0.194,1.120,1.260,0.880,1.270,0.993,1.310,2.090,1.290,
1.020,1.430,1.330,0.900,0.761,0.798,0.886,0.120,0.403,0.673,
1.020,0.909,0.496,1.060,1.420,1.130,0.752,0.724,1.170,0.783,
0.597,0.593,0.704,0.092,0.408,0.596,0.544,0.682,0.409,0.626,
1.020,1.190,0.550,0.787,0.172,0.149,0.085,0.142,1.170,0.318,
0.480,0.692,0.586,1.200,0.584,0.846,1.110,0.659,0.458,0.803,
1.650,0.817,0.588,0.840,0.809,0.085,0.409,0.685,0.940,0.744,
0.665,1.560,2.560,2.030,1.080,1.440,3.690,2.380,1.710,1.610,
1.410,0.243,0.816,1.070,0.987,1.490,0.645,1.190,2.460,2.970,
1.070,1.170,3.320,2.870,2.060,1.670,1.760,0.368,1.320,1.540,
1.040,1.690,0.905,1.270,1.260,2.410,0.988,1.100,0.268,0.471,
0.267,0.283,1.680,0.428,1.570,1.810,0.927,2.400,1.340,1.520,
1.170,0.894,0.639,0.815,2.220,1.960,1.300,1.660,1.300,0.177,
1.010,1.210,0.933,1.070,0.979,1.660,1.620,2.240,0.660,0.852,
2.200,2.510,1.540,1.360,1.530,0.285,0.883,1.190,0.810,1.200,
0.884,1.370,0.145,0.321,0.082,0.098,0.210,0.341,0.267,0.155,
0.162,0.080,0.165,0.190,0.088,0.223,0.125,0.151,1.120,1.870,
0.923,1.010,0.200,0.315,0.248,0.226,1.570,0.339,1.000,1.380,
0.817,1.980,1.180,1.410,0.914,0.787,0.562,0.688,1.760,1.870,
1.500,1.620,1.310,0.195,1.070,1.520,0.954,1.220,1.210,1.760,
1.310,0.811,0.480,0.793,0.985,0.727,0.543,0.613,1.110,0.110,
0.416,0.632,0.893,0.742,0.514,1.090,1.280,1.230,0.591,0.715,
1.410,1.330,1.030,0.926,1.650,0.181,0.700,1.050,0.736,1.040,
0.712,1.150,1.140,1.690,0.834,1.110,0.138,0.208,0.118,0.166,
1.560,0.229,1.230,1.770,0.972,1.770,1.240,1.490,1.410,0.873,
0.667,1.210,1.330,1.440,1.020,1.270,1.410,0.146,1.130,1.750,
1.560,1.410,1.390,2.000,2.620,1.810,1.390,2.480,1.790,1.280,
0.901,1.080,1.700,0.175,0.608,1.030,2.130,1.920,0.854,1.770,
1.830,1.330,1.210,1.050,1.180,0.842,0.622,0.641,0.984,0.114,
0.554,0.617,0.918,1.160,0.702,1.090,1.060,1.110,0.653,0.994,
0.109,0.107,0.074,0.137,0.681,0.087,0.357,0.529,0.774,1.350,
0.582,1.070,1.540,0.805,0.716,1.350,1.100,0.818,0.636,0.892,
0.840,0.084,0.430,0.703,1.210,0.908,0.827,1.960,2.250,1.480,
0.756,1.630,1.550,1.220,0.640,0.899,0.994,0.128,0.365,0.665,
0.987,1.170,0.484,1.190,1.480,1.350,0.509,0.777,1.160,1.030,
0.579,0.701,0.972,0.125,0.386,0.658,0.821,1.100,0.434,0.750,
0.888,1.130,0.527,0.765,0.096,0.174,0.068,0.106,0.944,0.245,
0.428,0.632,1.420,5.030,0.622,0.905,0.783,0.638,0.350,0.770,
0.809,0.831,0.413,0.640,0.739,0.070,0.326,0.502,0.820,1.110,
0.526,1.210,1.310,0.795,0.447,0.905,1.230,1.100,0.659,1.240,
0.999,0.147,0.323,0.571,0.904,0.914,0.471,1.050,0.100,0.112,
0.051,0.083,0.101,0.104,0.068,0.090,0.087,0.019,0.046,0.067,
0.115,0.177,0.067,0.131,0.534,0.640,0.381,0.511,0.068,0.075,
0.056,0.073,0.572,0.098,0.280,0.388,0.602,0.993,0.405,0.599,
0.563,0.436,0.368,0.700,0.759,0.698,0.511,0.671,0.638,0.072,
0.333,0.543,0.753,0.681,0.588,1.050,1.650,0.760,0.535,1.230,
0.848,0.569,0.426,0.653,0.910,0.098,0.328,0.634,1.490,1.010,
0.547,1.450,1.110,0.877,0.523,0.744,0.852,0.712,0.521,0.601,
0.799,0.092,0.394,0.586,0.909,1.180,0.584,1.100,0.694,0.784,
0.591,0.731,0.067,0.071,0.097,0.081,0.640,0.072,0.446,0.590,
0.739,1.160,0.663,1.150,1.110,0.674,0.583,1.140,0.780,0.592,
0.570,0.724,0.964,0.089,0.648,1.020,1.610,1.350,1.300,2.520,
2.750,2.030,1.690,2.090,2.020,1.700,1.050,1.240,1.490,0.220,
0.727,0.947,1.500,2.120,0.792,1.510,2.630,2.270,3.500,1.760,
2.080,1.960,1.550,1.180,1.540,0.302,1.590,1.220,0.935,2.180,
0.976,1.440,1.160,1.870,0.941,1.180,0.154,0.227,0.143,0.196,
0.989,0.176,0.727,0.996,0.762,1.410,0.834,1.280,1.130,0.789,
0.632,0.994,1.370,1.400,0.837,1.110,0.864,0.105,0.642,0.866,
0.996,0.868,0.844,1.670,2.130,1.890,0.762,1.500,2.070,1.970,
0.999,1.250,1.130,0.216,0.558,0.725,1.000,1.360,0.607,1.090,
2.110,2.430,0.929,1.090,2.500,1.770,1.430,1.340,1.560,0.327,
0.857,1.150,0.925,1.780,0.693,1.070,1.090,1.760,0.746,1.010,
0.171,0.294,0.157,0.181,1.310,0.282,0.817,1.030,0.851,2.050,
0.904,1.230,0.853,0.841,0.449,0.726,1.340,1.790,0.728,0.895,
0.926,0.112,0.553,0.777,0.871,0.929,0.671,1.280,1.130,0.918,
0.429,1.210,1.520,1.520,1.080,3.100,0.974,0.209,0.496,0.636,
0.662,1.060,0.486,0.969,0.095,0.183,0.083,0.110,0.150,0.297,
0.173,0.210,0.125,0.080,0.125,0.111,0.086,0.284,0.094,0.116,
0.830,1.170,0.648,0.706,0.140,0.201,0.139,0.158,0.957,0.204,
0.620,0.787,0.716,1.440,0.771,0.896,0.736,0.597,0.451,0.714,
1.300,1.570,0.905,1.110,0.978,0.119,0.657,0.877,0.866,0.932,
0.818,1.440,1.160,0.741,0.455,0.781,0.820,0.691,0.491,0.726,
0.786,0.107,0.363,0.603,0.808,0.882,0.485,0.998,1.390,1.650,
0.845,0.981,1.490,1.750,1.160,1.230,1.280,0.246,0.779,0.953,
1.050,2.610,0.894,1.280,0.794,1.080,0.723,0.829,0.094,0.136,
0.119,0.105,0.889,0.138,0.757,0.985,0.701,1.390,0.863,1.160,
0.919,0.681,0.638,0.822,0.894,1.020,0.630,0.829,1.020,0.103,
0.785,1.210,1.220,1.250,1.350,2.020,1.730,1.530,0.871,1.430,
1.360,1.170,0.638,0.867,1.010,0.128,0.505,0.747,0.934,1.000,
0.591,1.200,2.080,2.060,1.090,1.160,1.950,1.840,1.150,0.994,
1.340,0.236,1.000,1.060,0.853,1.540,0.809,1.070,1.060,1.750,
0.980,1.270,0.165,0.266,0.162,0.244,1.370,0.409,0.742,1.070,
0.750,1.870,0.814,1.250,0.976,0.785,0.558,0.992,1.070,1.080,
0.719,0.941,1.060,0.149,0.753,1.090,0.986,0.980,1.010,1.800,
0.120,0.141,0.064,0.121,0.190,0.190,0.086,0.119,0.083,0.023,
0.049,0.072,0.071,0.116,0.056,0.117,0.145,0.305,0.080,0.084,
0.235,0.447,0.185,0.152,0.138,0.064,0.152,0.148,0.071,0.178,
0.080,0.093,0.074,0.169,0.086,0.082,0.022,0.059,0.043,0.025,
0.123,0.064,0.116,0.113,0.071,0.249,0.114,0.178,0.083,0.084,
0.051,0.083,0.144,0.189,0.110,0.128,0.102,0.028,0.088,0.111,
0.079,0.107,0.087,0.165,1.250,1.200,0.514,0.610,1.440,1.750,
1.130,1.000,1.060,0.249,0.606,0.764,0.697,1.010,0.694,1.150,
0.149,0.298,0.074,0.092,0.143,0.258,0.150,0.088,0.119,0.066,
0.113,0.105,0.088,0.212,0.125,0.126,0.917,1.790,0.861,0.779,
0.153,0.268,0.211,0.144,1.310,0.278,0.555,0.823,0.631,1.570,
0.903,0.938,0.778,0.767,0.463,0.588,1.220,1.620,1.060,1.010,
1.250,0.192,0.909,1.050,0.816,1.090,0.960,1.260,1.040,0.795,
0.479,0.747,0.880,0.710,0.561,0.584,0.773,0.104,0.440,0.615,
0.705,0.743,0.467,0.929,1.510,1.910,0.770,0.915,1.420,1.720,
1.080,0.843,1.320,0.193,0.784,0.972,0.874,1.580,0.963,1.190,
1.080,1.730,2.050,1.200,0.137,0.221,0.985,0.224,1.270,0.210,
1.070,1.220,0.812,1.640,1.310,1.290,0.956,0.787,0.777,0.830,
0.975,1.110,1.720,0.948,1.260,0.140,1.110,1.340,1.210,1.300,
1.220,1.670,2.520,1.370,1.100,1.840,1.450,0.908,0.620,0.995,
1.150,0.135,0.477,0.878,1.630,1.350,0.689,1.940,1.550,1.270,
0.596,0.794,1.170,0.949,0.578,0.706,0.829,0.088,0.485,0.647,
0.670,0.837,0.431,0.905,1.050,1.170,0.571,0.973,0.110,0.130,
0.073,0.146,0.795,0.099,0.409,0.685,0.718,1.000,0.560,1.080,
1.210,0.719,0.538,1.130,0.917,0.690,0.563,0.879,0.841,0.083,
0.500,0.930,1.190,0.994,0.829,2.370,2.000,1.450,0.997,1.420,
1.540,1.280,0.716,1.130,0.961,0.120,0.453,0.800,0.897,1.070,
0.529,1.400,1.720,1.990,0.610,0.864,1.640,1.870,0.811,1.010,
1.100,0.156,0.682,0.936,0.734,1.100,0.565,1.020,0.897,1.140,
0.506,0.790,0.087,0.124,0.065,0.099,0.928,0.129,0.565,0.827,
0.769,1.380,0.667,1.190,1.030,0.759,0.561,0.939,1.090,0.945,
0.692,1.020,0.940,0.086,0.656,0.948,0.933,0.977,0.812,1.880,
1.920,3.270,0.830,1.130,1.640,1.540,1.020,1.340,1.340,0.246,
0.667,0.997,1.040,1.250,0.829,1.580,0.242,1.320,0.125,0.130,
0.121,0.197,0.109,0.102,0.112,0.052,0.086,0.113,0.093,0.202,
0.085,0.147,1.130,1.880,0.728,0.949,0.117,0.176,0.108,0.137,
1.320,0.183,0.754,1.170,0.845,1.530,0.966,1.410,1.180,1.150,
0.639,0.950,1.530,1.560,1.070,1.590,1.490,0.170,0.919,1.420,
1.280,1.330,1.130,2.080,2.230,1.490,0.835,1.590,1.320,0.971,
0.686,0.965,1.370,0.129,0.620,1.000,1.630,1.250,0.946,2.330,
2.190,3.500,0.978,1.240,1.890,1.770,1.020,1.130,1.650,0.186,
0.868,1.330,1.170,1.500,0.912,1.710,1.600,2.030,1.460,1.520,
0.130,0.161,0.295,0.170,1.730,0.174,1.110,1.810,1.460,2.160,
1.620,2.250,2.620,1.520,1.210,2.390,1.970,1.660,1.490,1.890,
2.090,0.149,1.520,2.630,2.840,1.780,1.900,2.720,3.930,2.610,
2.520,4.080,2.640,1.700,1.490,1.690,2.580,0.268,1.290,1.810,
3.230,2.420,1.690,2.850,3.460,2.220,1.720,1.950,2.130,1.570,
1.290,1.220,1.970,0.267,1.240,1.380,1.430,1.530,1.400,1.480,
2.020,1.620,1.400,1.770,0.210,0.207,0.167,0.253,1.150,0.125,
0.915,1.090,1.030,1.310,0.952,1.290,2.800,1.460,1.720,2.650,
2.210,1.870,1.430,1.980,1.450,0.139,0.969,1.350,1.940,1.300,
1.480,2.190,2.880,1.700,1.190,1.580,1.920,1.330,1.230,1.320,
1.340,0.168,0.698,0.925,1.070,1.270,0.938,1.270,2.170,1.620,
1.090,1.210,1.310,0.938,0.885,0.805,1.270,0.179,0.905,1.020,
0.844,1.060,1.360,1.080,1.350,1.290,0.793,0.945,0.129,0.151,
0.117,0.143,0.998,0.129,0.746,1.020,0.652,1.080,0.741,0.906,
1.140,0.766,0.563,0.874,1.220,1.050,0.699,0.973,1.080,0.096,
0.625,0.903,1.120,0.844,0.842,1.300,2.040,0.838,0.832,1.140,
1.810,1.230,1.020,1.090,1.360,0.191,0.613,0.929,1.230,1.300,
0.819,1.310,0.201,0.151,0.106,0.136,0.163,0.152,0.117,0.114,
0.138,0.034,0.104,0.124,0.167,0.246,0.147,0.169,0.952,0.889,
0.759,0.744,0.105,0.099,0.096,0.105,0.792,0.096,0.547,0.639,
0.683,0.806,0.622,0.666,0.905,0.590,0.546,0.752,1.170,1.060,
0.780,1.000,0.958,0.122,0.624,0.932,0.854,0.913,0.866,1.320,
2.570,1.040,0.949,1.720,1.110,0.730,0.711,0.793,1.130,0.130,
0.561,0.816,1.400,1.190,0.885,1.820,2.030,1.390,1.040,1.280,
1.400,1.160,0.932,0.886,1.170,0.124,0.793,0.990,1.100,1.300,
0.953,1.270,0.978,0.878,0.745,0.910,0.089,0.085,0.118,0.107,
0.726,0.073,0.514,0.744,0.722,0.938,0.746,0.939,1.330,0.807,
0.785,1.400,0.833,0.698,0.646,0.873,1.200,0.101,0.783,1.370,
1.560,1.440,1.340,2.590,4.620,3.370,1.990,2.980,2.610,2.130,
1.610,1.660,1.880,0.305,0.996,1.480,1.780,2.020,1.470,2.230,
3.510,3.690,2.330,2.060,2.460,2.290,1.930,1.530,3.310,1.060,
1.950,1.950,1.450,3.070,2.890,2.080,1.830,2.570,1.720,1.710,
0.218,0.340,0.226,0.256,1.060,0.166,0.922,0.966,0.754,1.380,
1.020,1.190,1.700,1.030,0.965,1.350,1.900,1.730,1.120,1.390,
1.240,0.138,0.718,1.030,1.170,1.020,1.130,1.930,2.800,2.650,
1.110,1.530,2.430,2.310,1.250,1.240,1.400,0.232,0.792,0.997,
0.925,1.360,1.310,1.490,2.060,2.280,1.270,1.190,1.310,0.650,
1.070,1.030,1.540,0.322,1.290,1.420,0.800,1.470,2.840,2.210,
1.380,2.240,1.210,1.320,0.198,0.330,0.230,0.290,1.180,0.245,
1.050,1.120,0.652,1.660,1.020,1.140,1.010,0.855,0.580,0.762,
1.300,1.440,0.933,1.110,0.906,0.115,0.630,0.961,0.736,0.821,
0.815,1.310,1.950,1.600,0.972,1.230,1.990,1.950,1.730,1.360,
1.480,0.262,1.060,1.190,0.962,1.400,1.210,1.480,0.183,0.367,
0.176,0.175,0.190,0.309,0.274,0.168,0.193,0.093,0.262,0.210,
0.132,0.354,0.279,0.252,1.190,1.630,1.170,1.110,0.162,0.245,
0.200,0.181,1.140,0.217,1.120,1.160,0.642,1.500,1.170,1.110,
0.829,0.649,0.605,0.775,1.350,1.570,1.270,1.340,1.060,0.156,
1.080,1.300,0.730,1.150,1.130,1.500,1.710,1.040,0.756,1.150,
1.010,0.762,0.644,0.719,0.810,0.089,0.487,0.623,0.860,0.823,
0.728,1.260,1.890,1.920,1.250,1.450,1.470,1.750,1.310,1.280,
1.140,0.188,1.050,1.250,0.905,1.630,1.310,1.480,0.917,1.020,
0.951,1.050,0.093,0.131,0.107,0.123,0.724,0.095,0.787,0.892,
0.645,1.020,1.190,1.290,1.040,0.489,0.660,0.927,0.869,0.850,
0.639,0.913,0.915,0.090,0.792,1.240,1.210,1.360,1.420,2.270,
3.050,2.170,1.640,2.040,1.380,1.160,0.936,1.010,1.280,0.162,
0.722,0.872,1.170,1.240,0.925,1.490,3.140,3.300,1.900,1.740,
2.070,2.100,1.590,1.300,2.270,0.398,2.010,1.630,1.130,1.960,
1.260,1.340,1.760,2.570,2.850,1.800,0.224,0.323,0.331,0.331,
0.990,0.155,0.955,0.913,0.637,1.310,0.896,1.080,1.690,1.280,
1.290,1.390,1.400,1.520,1.560,1.290,1.280,0.142,0.852,1.160,
1.220,1.020,1.320,2.330,0.258,0.267,0.164,0.190,0.245,0.266,
0.163,0.168,0.148,0.037,0.106,0.116,0.105,0.213,0.207,0.190,
0.299,0.441,0.190,0.178,0.285,0.401,0.243,0.189,0.232,0.082,
0.242,0.204,0.128,0.361,0.235,0.202,0.166,0.323,0.260,0.172,
0.033,0.078,0.075,0.054,0.176,0.057,0.198,0.165,0.092,0.264,
0.164,0.144,0.209,0.173,0.153,0.176,0.311,0.452,0.327,0.320,
0.182,0.036,0.161,0.206,0.160,0.188,0.183,0.304,1.930,1.260,
0.769,0.791,1.280,1.400,1.290,1.010,1.210,0.283,0.962,0.918,
0.694,1.140,1.100,1.040,0.189,0.281,0.112,0.113,0.138,0.225,
0.166,0.098,0.194,0.087,0.195,0.134,0.116,0.304,0.203,0.147,
0.827,1.380,0.962,0.745,0.136,0.192,0.190,0.144,0.938,0.197,
0.739,0.786,0.519,1.050,0.806,0.675,0.670,0.561,0.562,0.544,
0.983,1.290,1.140,1.080,1.050,0.166,0.946,0.914,0.604,1.040,
0.891,1.010,1.320,0.812,0.571,0.872,0.774,0.622,0.453,0.510,
0.721,0.090,0.460,0.592,0.742,0.774,0.634,1.090,2.020,1.970,
1.030,1.140,1.540,1.830,1.120,0.933,1.410,0.220,1.140,1.290,
1.020,1.710,1.300,1.350,1.180,1.300,0.857,0.844,0.124,0.176,
0.120,0.125,0.866,0.132,0.792,0.863,0.610,1.090,0.770,0.948,
1.150,0.810,0.693,0.791,1.020,1.070,0.756,0.916,1.170,0.134,
0.962,1.330,1.100,1.230,1.160,1.750,3.060,1.670,1.280,2.110,
1.180,0.775,0.733,0.814,1.080,0.107,0.575,0.826,1.370,1.130,
0.964,1.840,1.680,1.160,0.816,1.030,0.976,0.666,0.703,0.662,
0.972,0.109,0.614,0.751,0.796,0.808,0.667,0.915,1.560,1.190,
0.982,1.400,0.151,0.131,0.116,0.198,0.752,0.080,0.577,0.783,
0.659,0.851,0.579,0.996,1.580,0.894,0.938,1.770,1.110,0.854,
0.849,1.200,0.939,0.082,0.602,1.020,1.310,0.941,1.080,2.640,
2.380,1.620,1.280,1.570,1.690,1.180,1.230,0.987,1.170,0.139,
0.667,0.956,0.991,1.210,1.190,1.610,2.010,1.630,0.825,1.160,
1.300,1.210,0.846,0.832,1.190,0.193,0.890,1.070,0.855,1.560,
0.858,1.070,1.260,1.250,0.945,1.060,0.116,0.144,0.144,0.141,
0.922,0.113,0.761,0.987,0.705,1.150,0.774,1.020,1.240,0.799,
0.700,1.130,1.270,1.160,0.923,1.040,0.968,0.083,0.679,0.986,
0.981,0.912,0.925,1.750,1.660,1.100,0.756,1.060,1.420,1.150,
1.020,1.170,1.380,0.199,0.856,1.160,0.998,1.150,1.080,1.520,
0.148,0.184,0.093,0.126,0.114,0.137,0.115,0.112,0.129,0.043,
0.138,0.144,0.125,0.248,0.144,0.168,1.070,1.190,0.809,0.933,
0.100,0.116,0.107,0.124,0.933,0.129,0.624,0.846,0.669,1.060,
0.806,1.030,0.960,0.727,0.739,0.950,1.290,1.210,1.070,1.340,
1.290,0.127,0.936,1.320,1.020,1.060,1.040,1.790,2.380,1.160,
0.904,1.540,1.090,0.810,0.665,0.799,1.300,0.131,0.613,0.999,
1.410,1.280,1.010,2.130,1.530,1.150,0.805,1.150,1.150,0.922,
0.844,0.919,1.100,0.104,0.906,1.130,1.090,1.270,0.962,1.440,
1.560,1.390,0.968,1.410,0.141,0.134,0.097,0.159,1.280,0.122,
0.907,1.310,1.280,1.570,1.270,1.810,2.670,1.440,1.370,2.770,
2.080,1.940,1.300,1.870,2.450,0.176,1.650,2.890,3.440,2.520,
2.800,4.200,0.254,0.210,0.179,0.224,0.223,0.180,0.134,0.140,
0.154,0.023,0.146,0.136,0.167,0.183,0.132,0.144,0.287,0.237,
0.171,0.158,0.217,0.205,0.179,0.146,0.161,0.038,0.157,0.173,
0.108,0.162,0.263,0.181,0.119,0.133,0.109,0.116,0.020,0.029,
0.023,0.026,0.077,0.016,0.083,0.094,0.058,0.104,0.084,0.096,
0.162,0.094,0.114,0.137,0.182,0.177,0.142,0.152,0.111,0.015,
0.084,0.110,0.111,0.108,0.122,0.156,0.296,0.244,0.147,0.159,
0.265,0.222,0.172,0.138,0.163,0.046,0.127,0.142,0.106,0.185,
0.163,0.179,0.334,0.380,0.210,0.168,0.249,0.255,0.216,0.174,
0.244,0.097,0.236,0.243,0.116,0.257,0.278,0.330,0.137,0.194,
0.120,0.108,0.036,0.048,0.055,0.029,0.124,0.045,0.125,0.193,
0.068,0.197,0.126,0.123,0.098,0.080,0.061,0.076,0.154,0.151,
0.103,0.122,0.115,0.021,0.089,0.145,0.160,0.138,0.114,0.162,
0.178,0.129,0.099,0.107,0.333,0.244,0.170,0.144,0.160,0.036,
0.099,0.110,0.096,0.164,0.107,0.145,0.037,0.060,0.070,0.036,
0.046,0.061,0.053,0.033,0.033,0.023,0.047,0.032,0.019,0.057,
0.043,0.034,0.086,0.138,0.104,0.079,0.021,0.025,0.030,0.022,
0.096,0.029,0.107,0.104,0.053,0.128,0.102,0.095,0.071,0.054,
0.059,0.068,0.123,0.129,0.115,0.128,0.104,0.024,0.104,0.110,
0.073,0.105,0.124,0.141,0.175,0.094,0.086,0.136,0.115,0.082,
0.066,0.081,0.099,0.014,0.058,0.076,0.104,0.108,0.077,0.152,
0.226,0.219,0.166,0.226,0.213,0.252,0.186,0.184,0.145,0.033,
0.154,0.168,0.109,0.172,0.145,0.163,0.117,0.103,0.101,0.104,
0.015,0.016,0.024,0.017,0.089,0.019,0.080,0.102,0.064,0.115,
0.103,0.103,0.124,0.075,0.073,0.120,0.086,0.070,0.082,0.089,
0.108,0.017,0.111,0.137,0.122,0.133,0.146,0.235,0.276,0.261,
0.156,0.205,0.240,0.287,0.188,0.163,0.144,0.033,0.098,0.113,
0.124,0.159,0.213,0.186,0.324,0.356,0.235,0.185,0.329,0.374,
0.336,0.244,0.257,0.106,0.297,0.256,0.121,0.290,1.140,0.636,
0.120,0.239,0.157,0.133,0.029,0.114,0.055,0.039,0.087,0.029,
0.100,0.095,0.059,0.125,0.138,0.122,0.107,0.087,0.071,0.091,
0.189,0.281,0.129,0.125,0.138,0.018,0.083,0.097,0.089,0.090,
0.155,0.158,0.288,0.351,0.154,0.167,0.326,0.468,0.233,0.194,
0.184,0.071,0.139,0.140,0.093,0.195,0.161,0.268,0.304,0.522,
0.238,0.196,0.312,0.199,0.305,0.338,0.307,0.231,0.295,0.353,
0.133,0.396,0.460,1.180,0.145,0.381,0.197,0.159,0.049,0.166,
0.095,0.055,0.161,0.077,0.175,0.180,0.073,0.270,0.188,0.202,
0.088,0.102,0.066,0.070,0.178,0.294,0.154,0.152,0.110,0.032,
0.110,0.154,0.079,0.150,0.115,0.288,0.185,0.172,0.107,0.114,
0.274,0.319,0.307,0.173,0.175,0.052,0.180,0.146,0.082,0.146,
0.171,0.167,0.039,0.091,0.056,0.035,0.066,0.146,0.173,0.052,
0.057,0.066,0.111,0.070,0.018,0.072,0.091,0.074,0.130,0.238,
0.206,0.147,0.051,0.109,0.102,0.050,0.152,0.069,0.212,0.170,
0.067,0.200,0.196,0.154,0.074,0.065,0.072,0.073,0.162,0.260,
0.245,0.182,0.153,0.038,0.195,0.172,0.073,0.148,0.186,0.179,
0.148,0.111,0.080,0.107,0.112,0.102,0.081,0.089,0.083,0.013,
0.067,0.065,0.071,0.079,0.085,0.121,0.212,0.273,0.183,0.188,
0.248,0.327,0.287,0.233,0.178,0.057,0.220,0.215,0.091,0.215,
0.221,0.230,0.090,0.157,0.135,0.110,0.013,0.034,0.027,0.022,
0.093,0.024,0.142,0.121,0.060,0.112,0.160,0.141,0.094,0.068,
0.068,0.081,0.092,0.115,0.088,0.102,0.094,0.015,0.116,0.130,
0.101,0.134,0.189,0.225,0.183,0.183,0.122,0.127,0.133,0.138,
0.102,0.103,0.092,0.021,0.070,0.071,0.091,0.100,0.103,0.095,
0.285,0.361,0.187,0.151,0.327,0.331,0.279,0.199,0.252,0.087,
0.298,0.231,0.097,0.261,0.167,0.141,0.118,0.236,0.204,0.145,
0.031,0.056,0.073,0.047,0.111,0.042,0.117,0.117,0.050,0.135,
0.098,0.098,0.094,0.077,0.074,0.090,0.126,0.144,0.178,0.134,
0.112,0.021,0.110,0.127,0.078,0.084,0.120,0.164,0.025,0.039,
0.024,0.021,0.037,0.070,0.053,0.035,0.020,0.019,0.036,0.024,
0.012,0.038,0.066,0.025,0.049,0.132,0.052,0.036,0.095,0.163,
0.131,0.068,0.065,0.103,0.126,0.083,0.024,0.122,0.054,0.060,
0.023,0.085,0.060,0.049,0.022,0.086,0.086,0.025,0.051,0.056,
0.088,0.054,0.015,0.086,0.060,0.031,0.012,0.017,0.015,0.013,
0.036,0.064,0.063,0.048,0.027,0.016,0.049,0.037,0.015,0.027,
0.031,0.031,0.155,0.224,0.109,0.087,0.171,0.287,0.249,0.144,
0.168,0.066,0.183,0.156,0.069,0.172,0.216,0.131,0.036,0.139,
0.048,0.026,0.062,0.130,0.112,0.041,0.060,0.080,0.134,0.068,
0.017,0.077,0.081,0.030,0.107,0.285,0.207,0.118,0.043,0.109,
0.127,0.054,0.170,0.101,0.223,0.224,0.061,0.219,0.194,0.124,
0.062,0.071,0.083,0.078,0.147,0.252,0.253,0.258,0.134,0.052,
0.224,0.187,0.061,0.131,0.176,0.143,0.124,0.116,0.068,0.093,
0.090,0.087,0.063,0.060,0.086,0.019,0.071,0.081,0.066,0.093,
0.080,0.114,0.236,0.422,0.186,0.164,0.281,0.402,0.292,0.198,
0.269,0.090,0.307,0.295,0.113,0.287,0.279,0.180,0.127,0.209,
0.137,0.115,0.022,0.052,0.039,0.029,0.140,0.053,0.173,0.200,
0.073,0.195,0.139,0.139,0.097,0.086,0.077,0.091,0.119,0.134,
0.114,0.127,0.126,0.027,0.177,0.171,0.107,0.152,0.163,0.181,
0.235,0.162,0.103,0.170,0.155,0.100,0.108,0.150,0.121,0.014,
0.066,0.106,0.111,0.109,0.097,0.163,0.189,0.161,0.097,0.120,
0.139,0.114,0.114,0.111,0.114,0.023,0.086,0.104,0.082,0.117,
0.111,0.118,0.125,0.136,0.095,0.128,0.017,0.017,0.013,0.026,
0.073,0.013,0.060,0.090,0.058,0.092,0.066,0.100,0.128,0.079,
0.082,0.148,0.111,0.095,0.090,0.155,0.104,0.013,0.070,0.132,
0.121,0.088,0.118,0.275,0.297,0.289,0.213,0.210,0.273,0.264,
0.511,0.210,0.192,0.045,0.166,0.204,0.138,0.253,0.226,0.223,
0.343,0.424,0.207,0.211,0.355,0.373,0.303,0.265,0.264,0.086,
0.287,0.299,0.171,0.551,0.208,0.249,0.164,0.291,0.217,0.172,
0.030,0.061,0.066,0.051,0.174,0.047,0.185,0.225,0.110,0.277,
0.192,0.194,0.146,0.119,0.109,0.150,0.202,0.235,0.234,0.272,
0.169,0.026,0.174,0.206,0.133,0.158,0.181,0.287,0.174,0.188,
0.101,0.120,0.202,0.263,0.212,0.173,0.180,0.059,0.169,0.184,
0.101,0.171,0.170,0.175,0.024,0.047,0.018,0.021,0.032,0.059,
0.050,0.028,0.029,0.020,0.043,0.039,0.021,0.064,0.039,0.031,
0.117,0.212,0.155,0.124,0.022,0.038,0.040,0.031,0.146,0.049,
0.168,0.167,0.079,0.190,0.164,0.168,0.100,0.085,0.100,0.111,
0.159,0.178,0.187,0.196,0.163,0.027,0.184,0.196,0.118,0.132,
0.187,0.216,0.216,0.160,0.107,0.157,0.133,0.118,0.101,0.105,
0.128,0.017,0.085,0.116,0.115,0.130,0.116,0.198,0.181,0.209,
0.106,0.137,0.163,0.168,0.158,0.149,0.221,0.030,0.142,0.174,
0.117,0.170,0.142,0.170,0.158,0.181,0.135,0.157,0.021,0.026,
0.020,0.024,0.148,0.030,0.154,0.166,0.115,0.197,0.175,0.197,
0.221,0.132,0.141,0.246,0.193,0.186,0.171,0.215,0.229,0.025,
0.224,0.298,0.288,0.267,0.307,0.353,2.080,1.260,1.100,1.700,
1.290,1.060,0.854,0.946,0.982,0.125,0.617,0.847,1.250,1.220,
0.736,1.140,1.590,1.180,0.839,0.904,1.180,0.907,1.050,0.922,
0.885,0.127,0.677,0.748,0.668,0.993,0.715,0.803,0.846,0.937,
0.633,1.060,0.120,0.120,0.096,0.164,0.641,0.083,0.536,0.947,
0.482,0.736,0.567,0.705,1.210,0.607,0.491,1.060,0.933,0.937,
0.515,0.816,0.788,0.076,0.414,0.588,0.801,0.460,0.585,0.993,
1.770,1.400,0.788,1.040,1.470,1.280,1.000,0.907,0.841,0.138,
0.630,0.889,0.692,0.989,0.595,0.816,1.580,1.580,0.812,0.844,
1.250,0.876,1.030,0.902,1.200,0.251,0.942,1.440,0.647,1.150,
0.675,0.748,0.916,1.520,0.797,1.050,0.148,0.207,0.169,0.256,
1.180,0.247,1.250,4.280,0.594,1.310,0.900,1.200,0.657,0.528,
0.406,0.570,1.020,1.010,0.655,0.875,0.676,0.079,0.520,1.050,
0.671,0.600,0.562,0.942,1.440,0.994,0.591,0.888,1.850,2.390,
1.380,1.390,1.310,0.228,0.804,1.070,0.970,1.190,0.882,1.210,
0.240,0.251,0.118,0.143,0.224,0.275,0.230,0.198,0.188,0.063,
0.237,0.210,0.164,0.412,0.203,0.219,0.792,1.010,0.850,0.820,
0.124,0.142,0.152,0.171,0.876,0.149,0.735,1.010,0.501,1.090,
0.847,0.8