/* Public domain. */

#include "tai.h"
#include "iopause.h"
#include "djbunix.h"

void deepsleep (unsigned int seconds)
{
  struct taia stamp, deadline ;
  taia_now(&stamp) ;
  taia_addsec(&deadline, &stamp, seconds) ;
  while (taia_less(&stamp, &deadline))
  {
    iopause_fd x ;
    iopause(&x, 0, &deadline, &stamp) ;
    taia_now(&stamp) ;
  }
}
