/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.computing;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.ATrace2D;
import info.monitorenter.util.collections.IRingBuffer;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace2DArithmeticMeanX
extends ATrace2D {
    private final IRingBuffer<ITracePoint2D> m_pointBuffer;
    private final List<ITracePoint2D> m_points;

    @Override
    protected boolean addPointInternal(ITracePoint2D p) {
        this.m_pointBuffer.add(p);
        ITracePoint2D cumulate = this.getArithmeticMean();
        boolean result = this.m_points.add(cumulate);
        this.firePointAdded(cumulate);
        return result;
    }

    private ITracePoint2D getArithmeticMean() {
        ITracePoint2D result;
        double x = 0.0;
        double y = 0.0;
        Iterator i$ = this.m_pointBuffer.iterator();
        while (i$.hasNext()) {
            ITracePoint2D point;
            result = point = (ITracePoint2D)i$.next();
            x += result.getX();
            y = result.getY();
        }
        int divisor = this.m_pointBuffer.size();
        if (divisor == 0) {
            divisor = 1;
        }
        result = this.getRenderer().getTracePointProvider().createTracePoint(x /= (double)divisor, y);
        return result;
    }

    @Override
    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSize() {
        return this.m_points.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_points.isEmpty();
    }

    @Override
    public Iterator<ITracePoint2D> iterator() {
        return this.m_points.iterator();
    }

    @Override
    protected void removeAllPointsInternal() {
        this.m_pointBuffer.clear();
        this.m_points.clear();
    }

    @Override
    protected ITracePoint2D removePointInternal(ITracePoint2D point) {
        ITracePoint2D result = this.m_points.remove(0);
        return result;
    }
}

