/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : global.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/09/11
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __GLOBAL_H__
#define __GLOBAL_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
//#define PRINTER_TEST
//#define ONE_SHOT_DEBUG

#define DRAW_DISP      0
#define DRAW_REAL      2
#define DRAW_CONST     1
#define MAXPATH     256

#define A0_PAPER     129
#define A1_PAPER     257
#define A2_PAPER     513
#define A3_PAPER    1025
#define A4_PAPER    2049
#define A5_PAPER    4097
#define B0_PAPER     130
#define B1_PAPER     258
#define B2_PAPER     514
#define B3_PAPER    1026
#define B4_PAPER    2050
#define B5_PAPER    4098
#define USER_PAPER     4

/* 横 */
#define LANDSCAPE      0
/* 縦 */
#define PORTRAIT       1

#define DRAWING_VIEW   0
#define DISPLAY_VIEW   1








/* user */
struct _sagcad_user {
	char UserName[64];		/*	*/
	char CompanyName[64];	/*	*/
	char ConfigPath[256];	/* 設定ファイルのパス */
	char BrowserPath[256];	/* 設定ファイルのパス */
	char CadPath[256];
	char NcPath[256];
	char KeepCadPath[256];

	char print_command[256];	/* 設定ファイルのパス */
	char editor_command[256];	/* 設定ファイルのパス */
	char browser_command[256];	/* 設定ファイルのパス */

};
//struct _sagcad_user sagcad_user;



/* system */
struct _sagcad_system {
	int charset;			/* 0 : shift-jis    1 : euc */
	int Wait;				/* 100 */
	int LostCurrent;		/* 1 */
	int RealTimeLayerSet;	/* 1 */

	int WinMode;			/* 0:WM にまかせる   1:設定値   2:前回終了時の設定 */
	int win_x_pos;
	int win_y_pos;
	int win_width;
	int win_height;

//	int MaxLayer;			/* 100 */

	/* ---------------------------------
	 * 0 : 表示しない ＆ 機能しない
	 * 1 : 表示する
	 * 2 : 機能する
	*/
	int GridMode;			/* 2 */
	float Grid;				/* 0.5 */

	/* ピクチャーボックスのアスペクト比 (ASPECT = H / W) */
	double ViewX;
	int DeviceX;
	int DeviceY;
	double Aspect;

	float ZoomMag;			/* 1.3 */
	float Splits;			/* 15 */
	float Search;			/* 2 */
	float ScrollPitch;
	float Length;			/* 50 */
	float FilletRC;			/* 10 */
};
//struct _sagcad_system sagcad_system;



/* dimension */
struct _sagcad_dimension {
	int Draw_Type;						/* 0  0:図面の縮尺	1:実寸	2:文字サイズ固定 */
	int font_Type;						/* 1 */
	float Font_height;					/* 2.5 */
	float Font_space;					/* 0.5 */
	float Word_space;					/* 3 */
	float Font_space_line;				/* 0.6 */
	float arrow_length;					/* 2 */
	float arrow_angle;					/* 15 */
	float arrow_line_extension;			/* 3 */
	float assistance_line_extension;	/* 1 */
	float assistance_line_space;		/* 1 */
	int dimension_figure;				/* 3 */
	char font_file[256];				/* sagfont.sft */
	char font_file2[256];				/* sagfont2.sft */
};
/*
struct _sagcad_dimension sagcad_dimension
={
	0,1,2.5,0.5,0.6,2,15,3,1,3,"sagfont_euc.sft","sagfont2_euc.sft"
};
*/


/* color */
struct _sagcad_color {
	long Back;				/* 0x000000 */
	long Select;			/* 0xff0000 */
	long Dimension;			/* 0xffffff */
	long Cam;				/* 0xffffff */
	long PrinterRect;		/* 0x0000ff */
	long FirstCenterLine;	/* 0xffffff */
	long Menu[26];			/* 0x00ff00 */
};
/*
struct _sagcad_color sagcad_color
={
	0x000000, 0xff0000, 0xffffff, 0xffffff, 0x0000ff, 0xffffff,    0x000000, 
	0x00ff00, 0x00ffff, 0xffff00, 0x0000ff, 0xffffff, 
	0xff00ff, 0xffc0cb, 0xffa500, 0xda70d6, 0xffd700, 
	0xff8ec7, 0xff69b4, 0xdaa520, 0xadff2f, 0x32cd32, 
	0x9acd32, 0x5f9ea0, 0x4682b4, 0x48d1cc, 0xadd8e6, 
	0x7fffd4, 0xf8f4d8, 0xe0e0e0, 0xb0b0b0, 0x808080, 
};
*/


/* line_style */
struct _sagcad_line_style {
	int style;
	int max;
	int min;
	int DsplayWidth;
	int PrinterWidth;
};
/*
struct _sagcad_line_style sagcad_line_style[6] 
= {
	1, 1,0,5,30,
	1, 1,0,2,15,
	2, 2,1,2,10,
	3,10,1,2,10,
	4,10,1,2,10,
	1, 1,0,2, 5
};
*/



/* digits */
struct _sagcad_digits {
	int calcu_digits;
	int compa_digits;
	int data_digits;
	int dimension_digits;
	int cam_digits;
};
/*
struct _sagcad_digits sagcad_digits
*/



/* cam */
struct _sagcad_cam {
	int CamCheck;
	int AbsInc;
	int Modal;
	int RIJ;
	int Heel;
};
/*
struct _sagcad_cam sagcad_cam
*/


/* 印刷設定用*/
struct _printer {
	/* ---------------------------------
	 * 用紙 Paper
	 * 
	 * A 1
	 * B 2
	 * USER 4
	 * 
	 * 0 128
	 * 1 256
	 * 2 512
	 * 3 1024
	 * 4 2048
	 * 5 4096
	 * 
	 * A0      A0_PAPER    1 + 128     129
	 * A1      A1_PAPER    1 + 256     257
	 * A2      A2_PAPER    1 + 512     513
	 * A3      A3_PAPER    1 + 1024    1025
	 * A4      A4_PAPER    1 + 2048    2049
	 * A5      A5_PAPER    1 + 4096    4097
	 * B0      B0_PAPER    2 + 128     130
	 * B1      B1_PAPER    2 + 256     258
	 * B2      B2_PAPER    2 + 512     514
	 * B3      B3_PAPER    2 + 1024    1026
	 * B4      B4_PAPER    2 + 2048    2050
	 * B5      B5_PAPER    2 + 4096    4098
	 * 
	 */
	int Paper;

	/* ---------------------------------
	 * 用紙の方向 Orientation
	 * 
	 * 横置き    LANDSCAPE   0
	 * 縦置き    PORTRAIT    1
	 */
	int Orientation;

	/* ---------------------------------
	 * サイズ size
	 * 
	 * paper_top
	 * paper_bottom
	 * paper_left
	 * paper_right
	 * 
	 */
	double paper_top;
	double paper_bottom;
	double paper_left;
	double paper_right;

	/* ---------------------------------
	 * 余白 blank
	 * 
	 * blank_top
	 * blank_bottom
	 * blank_left
	 * blank_right
	 * 
	 */
	double blank_top;
	double blank_bottom;
	double blank_left;
	double blank_right;

	/* ---------------------------------
	 * 倍率(尺度) Scale
	 */
	float scale;
	float up_scale;
	float low_scale;
	/* ---------------------------------
	 * 印刷対象
	 * 
	 * 図面    DRAWING_VIEW    0
	 * 画面    DISPLAY_VIEW    1
	 */
	int Draw_View;
	/* 枠のレイヤー */
	int WakuLayer;
};
//struct _printer printer;





/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _GLOBAL_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL struct _sagcad_user sagcad_user;
	GLOBAL struct _sagcad_system sagcad_system;
	GLOBAL struct _sagcad_color sagcad_color;
	GLOBAL struct _sagcad_dimension sagcad_dimension;
	GLOBAL struct _sagcad_line_style sagcad_line_style[7];
	GLOBAL struct _sagcad_digits sagcad_digits;
	GLOBAL struct _sagcad_cam sagcad_cam;

	GLOBAL struct _printer printer;
	GLOBAL struct _printer keep_printer;

	/* ハンドル */
	/* SagCAD RootWindow */
	GLOBAL GtkWidget *MainWindow, *drawing_area, *statusbar, *work_hbox;
	GLOBAL GtkWidget *line_status, *MouseX, *MouseY, *Tooltip;
	GLOBAL GtkWidget *mag, *layer, *fillet, *length, *scroll_pitch;
	GLOBAL GdkPixmap *pixmap GLOBAL_VAL((void *)0);
	GLOBAL GdkGC *gc GLOBAL_VAL((void *)0);
	GLOBAL GdkGC *ls_gc GLOBAL_VAL((void *)0);
	
	GLOBAL GdkCursor *cursor;
	
	GLOBAL GtkWidget *UndoButton GLOBAL_VAL((void *)0);
	GLOBAL GtkWidget *RedoButton GLOBAL_VAL((void *)0);


	/* タイトル */
	GLOBAL char Title[40] GLOBAL_VAL("SagCAD");
	/* 著作権 */
	GLOBAL char Copyright[60] GLOBAL_VAL("Copyright (C) 1998-2007 Yutaka Sagiya");


	/* CAD 環境設定 */
	/* 座標設定変数 */
	/*	  倍率 , 中心座標Ｘ , 中心座標Ｙ */
	GLOBAL float Mag GLOBAL_VAL(1);
	GLOBAL float MagX GLOBAL_VAL(0);
	GLOBAL float MagY GLOBAL_VAL(0);

	GLOBAL char NowFile[256] GLOBAL_VAL("Untitled.sgy");
	GLOBAL char PartsFile[256] GLOBAL_VAL("Untitled.sgy");
	GLOBAL int NowLayer GLOBAL_VAL(1);
	GLOBAL int NowWidth GLOBAL_VAL(1);
	GLOBAL int NowStyle GLOBAL_VAL(1);
	GLOBAL long NowColor GLOBAL_VAL(0x00ff00);

	/* レイヤー表示状態　　0;未表示(青1)　　1;表示(明黄14)　　5;カレントレイヤー(赤12) */
	GLOBAL LAYER Layer[256];
	GLOBAL int use_layer GLOBAL_VAL(100);
	GLOBAL int old_set_layer GLOBAL_VAL(1);

	
	/* Data Version */
	GLOBAL int data_version GLOBAL_VAL(4);

	
	/* 登録画面設定変数 */
	GLOBAL float GamenMag[7], GamenMagX[7], GamenMagY[7];
	/* CADでコマンドを識別する変数 */
	GLOBAL int mode GLOBAL_VAL(0);
	GLOBAL int OnlyOne_mode GLOBAL_VAL(0);
	GLOBAL int Center_set_mode GLOBAL_VAL(0);
	GLOBAL int Chain2_OnlyOne_mode GLOBAL_VAL(0);


	/* OnlyOneCADデータ */
	GLOBAL CAD OnlyOneCAD[13];
	/* OnlyOne関数の変数 */
	GLOBAL int OnlyOneIndex GLOBAL_VAL(0);
	GLOBAL int OnlyOneEntry GLOBAL_VAL(0);
	GLOBAL int RetOnlyOneMode GLOBAL_VAL(0);


	/* 選択モードのハイライト変数 */
	GLOBAL int Already GLOBAL_VAL(0);
	/* 範囲セレクト */
	GLOBAL int RectStart GLOBAL_VAL(0);
	GLOBAL int StartX GLOBAL_VAL(0);
	GLOBAL int StartY GLOBAL_VAL(0);
	GLOBAL int MoveX GLOBAL_VAL(0);
	GLOBAL int MoveY GLOBAL_VAL(0);
	GLOBAL int EndX GLOBAL_VAL(0);
	GLOBAL int EndY GLOBAL_VAL(0);

	/* 平行 回転 対象モード変数 */
	GLOBAL int CopyFrag GLOBAL_VAL(0);
	/* 変更属性 */
	GLOBAL int ModifiedFlag GLOBAL_VAL(0);


	/* Select */
	GLOBAL SELECT_LIST *OP_SelectList;
	GLOBAL int SelectChainFrag GLOBAL_VAL(0);
	GLOBAL int SelectColorFrag GLOBAL_VAL(0);
	
	GLOBAL int Chain2Data GLOBAL_VAL(0);
	GLOBAL SELECT Chain2[50];
	GLOBAL int Chain2index GLOBAL_VAL(0);


	/* サーチ範囲 */
	GLOBAL double DC GLOBAL_VAL(3);
	GLOBAL int DcObj GLOBAL_VAL(15);
	GLOBAL int (*ReturnFunc)(GtkWidget *widget, int Button, int x, int y);
	GLOBAL int (*OnlyOneKeepReturnFunc)(GtkWidget *widget, int Button, int x, int y);
	GLOBAL int (*KeepReturnFunc)(GtkWidget *widget, int Button, int x, int y);


	/* 0 : ディスプレイ   1 : プリンター */
	GLOBAL int DrawObject GLOBAL_VAL(0);

	GLOBAL double window_left GLOBAL_VAL(0);
	GLOBAL double window_top GLOBAL_VAL(0);
	GLOBAL double window_right GLOBAL_VAL(0);
	GLOBAL double window_bottom GLOBAL_VAL(0);

	/* 変換係数 */
	GLOBAL double ToDeviceK GLOBAL_VAL(0);
	GLOBAL double ToDevice_X_lo GLOBAL_VAL(0);
	GLOBAL double ToDevice_X_hi GLOBAL_VAL(0);
	GLOBAL double ToDevice_Y_lo GLOBAL_VAL(0);
	GLOBAL double ToDevice_Y_hi GLOBAL_VAL(0);

	GLOBAL double ToViewK GLOBAL_VAL(0);





	GLOBAL double view_port_x1 GLOBAL_VAL(0);
	GLOBAL double view_port_y1 GLOBAL_VAL(0);
	GLOBAL double view_port_x2 GLOBAL_VAL(0);
	GLOBAL double view_port_y2 GLOBAL_VAL(0);

	GLOBAL double view_port_aspect GLOBAL_VAL(1);

	GLOBAL double world_window_x1 GLOBAL_VAL(0);
	GLOBAL double world_window_y1 GLOBAL_VAL(0);
	GLOBAL double world_window_x2 GLOBAL_VAL(0);
	GLOBAL double world_window_y2 GLOBAL_VAL(0);



	GLOBAL DIMENSION Dim_old;
	GLOBAL DIMENSION Dim_now;
	GLOBAL DIMENSION_CULC PicPoint;

#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _GLOBAL_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int sagcad_global_init(void);
GdkColor color_gtk(long rgbcol);
long gtk_color_rgb(GdkColor color);
long Color_RB_Change(long rgbcol);

int set_window_text(GtkWidget *widget, char *str);
int set_label_text(GtkWidget *widget, char *str);
/* 初期設定ファイル読み込み */
int ConfigRead(void);
/* 初期設定ファイル書きこみ */
int ConfigWrite(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __GLOBAL_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : global.h
 * ====================================================================
 */
