/*
*  Rubrica
*  file: form.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <glib.h>
#include <glib-object.h>

#include "libral.h"

#ifndef _RUBRICA_FORM_H
#define _RUBRICA_FORM_H

#define RUBRICA_FORM_TYPE           (rubrica_form_get_type())

#define RUBRICA_FORM(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),     \
                                     RUBRICA_FORM_TYPE, RubricaForm))

#define RUBRICA_FORM_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),      \
                                     RUBRICA_FORM_TYPE, RubricaFormClass))

#define IS_RUBRICA_FORM(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),     \
                                     RUBRICA_FORM_TYPE))

#define IS_RUBRICA_FORM_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),        \
                                     RUBRICA_FORM_TYPE))

#define RUBRICA_FORM_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),      \
			             RUBRICA_FORM_TYPE, RubricaFormClass))


typedef struct _RubricaForm        RubricaForm; 
typedef struct _RubricaFormClass   RubricaFormClass;
typedef struct _RubricaFormPrivate RubricaFormPrivate;


struct _RubricaForm {
  GObject parent;
   
  RubricaFormPrivate* private;  
};


struct _RubricaFormClass {
  GObjectClass parent;

  void (*extract_data) (RubricaForm* form, RCard* card);
  void (*display_data) (RubricaForm* form, RCard* card);
  void (*clean_form)   (RubricaForm* form);
};


GType        rubrica_form_get_type     (void);


RubricaForm* rubrica_form_new          (void);
void         rubrica_form_free         (RubricaForm* form);

void         rubrica_form_clean_form   (RubricaForm* form);

void         rubrica_form_extract_data (RubricaForm* form, RCard* card);
void         rubrica_form_display_data (RubricaForm* form, RCard* card);


#endif
