/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2005: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 17/Jul/2005                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  int correct;
  int check_inode;
  char * progname;

  locale_init();

  progname = argv[0];
  if (argc == 3)
    {
      correct=strtol(argv[1],0,10);
      check_inode=strtol(argv[2],0,10);
      res = rsbac_check(correct, check_inode);
      error_exit(res);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s correct check_inode\n"), progname);
      printf(gettext("     correct = 0: do not correct errors\n"));
      printf(gettext("     correct = 1: correct errors\n"));
      printf(gettext("     correct = 2: correct more\n"));
      printf(gettext("     check_inode = 0: do not check inode numbers\n"));
      printf(gettext("     check_inode = 1: also check inode numbers (only ext2/3 on 2.4 kernels)\n"));
    }
  return (res);
}
