# ifndef _SKIT_AVECREP_H
# define _SKIT_AVECREP_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// AVECREP: Associative Sparse Vector format
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 march 1997
//
// NOTE: also usefull as matrix row
//
# include "rheolef/skitbase.h"
# include "rheolef/num-algorithm.h" // select_min, max
# include "rheolef/csr.h"           // csr::const_row

namespace rheolef { 
template <class T>
class avecrep : public std::map<Index, T, std::less<Index> >
{
    Index N;
  public:
    typedef T                                                              element_type;
    typedef          std::pair<const Index, T>                             value_type;
    typedef typename std::map<Index, T, std::less<Index> > map_type;
    typedef typename map_type::const_iterator const_iterator;
    typedef typename map_type::iterator       iterator;

    avecrep(Index n = 0) : map_type(), N(n) {}
    avecrep(const avecrep<T>& sx) 
	    : map_type(sx), N(sx.N) {}
    avecrep(typename csr<T>::row x) : map_type(), N(x.n())
	    { szassignopsx (*this, my_ident<typename csr<T>::row::element_type, T>(), 
			    x.begin(), x.end()); }
    avecrep(const typename csr<T>::const_row& x) : std::map<Index, T, std::less<Index> >(), N(x.n())
	    { szassignopsx (*this, my_ident<typename csr<T>::const_row::element_type, T>(),
			    x.begin(), x.end()); }
    avecrep& operator=(const typename csr<T>::const_row& x)
	    { szassignopsx (*this, my_ident<typename csr<T>::const_row::element_type, T>(),
			    x.begin(), x.end()); return *this; }
    Index n() const { return N; }
    Index nnz() const { return map_type::size(); }
    void reset() { map_type::erase (map_type::begin(), map_type::end()); }
    T& entry (Index i)
    {
    	iterator iter_pair_i_xi = map_type::find(i);
    	bool exists = (iter_pair_i_xi != map_type::end());
    	if (exists) return (*iter_pair_i_xi).second; else return map_type::operator[](i);
    }
    T operator() (Index i) const
    {
    	const_iterator iter_pair_i_xi = map_type::find(i);
    	bool exists = (iter_pair_i_xi != map_type::end());
    	if (exists) return (*iter_pair_i_xi).second; else return T();
    }
    // properties
    bool all_elements_are_int_or_inf_or_nan () const
      { return all_are_int_or_inf_or_nan (map_type::begin(), map_type::end(), T(), value_type(0,T()));}  

    bool any_element_is_inf_or_nan () const
	{ return any_is_inf_or_nan (map_type::begin(), map_type::end(), T(), value_type(0,T())); }

    bool any_element_is_negative () const
	{ return any_is_negative (map_type::begin(), map_type::end(), T(), value_type(Index(),T())); }

    // selection
    T max() const     
    	{ return select_max (map_type::begin(), map_type::end(), -max_value(T()), value_type(Index(),T())); }
    T min() const     
	{ return select_min (map_type::begin(), map_type::end(),  max_value(T()), value_type(Index(),T())); }
    T max_abs() const 
	{ return select_max_abs (map_type::begin(), map_type::end(), T(), value_type(Index(),T())); }
    T min_abs() const 
	{ return select_min_abs (map_type::begin(), map_type::end(), T(), value_type(Index(),T())); }
};
}// namespace rheolef
# endif // _SKIT_AVECREP_H
