% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{upload_ftp}
\alias{upload_ftp}
\alias{upload_win_builder}
\title{Upload to an FTP server via \command{curl}}
\usage{
upload_ftp(file, server, dir = "")

upload_win_builder(
  file = pkg_build(),
  version = c("R-devel", "R-release", "R-oldrelease"),
  server = c("ftp", "https")
)
}
\arguments{
\item{file}{Path to a local file.}

\item{server}{The address of the FTP server. For \code{upload_win_builder()},
\code{server = 'https'} means uploading to
\code{'https://win-builder.r-project.org/upload.aspx'}.}

\item{dir}{The remote directory to which the file should be uploaded.}

\item{version}{The R version(s) on win-builder.}
}
\value{
Status code returned from \code{\link[=system2]{system2()}} or
\code{curl::curl_fetch_memory()}.
}
\description{
The function \code{upload_ftp()} runs the command \command{curl -T file
server} to upload a file to an FTP server if the system command
\command{curl} is available, otherwise it uses the R package \pkg{curl}. The
function \code{upload_win_builder()} uses \code{upload_ftp()} to upload
packages to the win-builder server.
}
\details{
These functions were written mainly to save package developers the trouble of
going to the win-builder web page and uploading packages there manually.
}
