% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters.R
\name{find_parameters}
\alias{find_parameters}
\alias{find_parameters.default}
\title{Find names of model parameters}
\usage{
find_parameters(x, ...)

\method{find_parameters}{default}(x, flatten = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
A list of parameter names. For simple models, only one list-element,
\code{conditional}, is returned.
}
\description{
Returns the names of model parameters, like they typically
appear in the \code{summary()} output. For Bayesian models, the parameter
names equal the column names of the posterior samples after coercion
from \code{as.data.frame()}. See the documentation for your object's class:
\itemize{
\item \link[=find_parameters.BGGM]{Bayesian models} (\strong{rstanarm}, \strong{brms}, \strong{MCMCglmm}, ...)
\item \link[=find_parameters.gamlss]{Generalized additive models} (\strong{mgcv}, \strong{VGAM}, ...)
\item \link[=find_parameters.betamfx]{Marginal effects models} (\strong{mfx})
\item \link[=find_parameters.emmGrid]{Estimated marginal means} (\strong{emmeans})
\item \link[=find_parameters.glmmTMB]{Mixed models} (\strong{lme4}, \strong{glmmTMB}, \strong{GLMMadaptive}, ...)
\item \link[=find_parameters.zeroinfl]{Zero-inflated and hurdle models} (\strong{pscl}, ...)
\item \link[=find_parameters.averaging]{Models with special components} (\strong{betareg}, \strong{MuMIn}, ...)
}
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"nonlinear"}: for non-linear models (like models of class \code{nlmerMod} or
\code{nls}), returns staring estimates for the nonlinear parameters.
\item \code{"correlation"}: for models with correlation-component, like \code{gls}, the
variables used to describe the correlation structure are returned.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}

\strong{Special models}

Some model classes also allow rather uncommon options. These are:
\itemize{
\item \strong{mhurdle}: \code{"infrequent_purchase"}, \code{"ip"}, and \code{"auxiliary"}
\item \strong{BGGM}: \code{"correlation"} and \code{"intercept"}
\item \strong{BFBayesFactor}, \strong{glmx}: \code{"extra"}
\item \strong{averaging}:\code{"conditional"} and \code{"full"}
\item \strong{mjoint}: \code{"survival"}
\item \strong{mfx}: \code{"precision"}, \code{"marginal"}
\item \strong{betareg}, \strong{DirichletRegModel}: \code{"precision"}
\item \strong{mvord}: \code{"thresholds"} and \code{"correlation"}
\item \strong{clm2}: \code{"scale"}
\item \strong{selection}: \code{"selection"}, \code{"outcome"}, and \code{"auxiliary"}
\item \strong{lcmm}: \code{"membership"}, \code{"longitudinal"}, \code{"beta"}, \code{"splines"}, and
\code{"linear"}
}

For models of class \code{brmsfit} (package \strong{brms}), even more options are
possible for the \code{component} argument, which are not all documented in detail
here. It can be any pre-defined or arbitrary distributional parameter, like
\code{mu}, \code{ndt}, \code{kappa}, etc.
}

\section{Parameters, Variables, Predictors and Terms}{

There are four functions that return information about the variables in a
model: \code{find_predictors()}, \code{find_variables()}, \code{find_terms()} and
\code{find_parameters()}. There are some differences between those functions,
which are explained using following model. Note that some, but not all of
those functions return information about the \emph{dependent} and \emph{independent}
variables. In this example, we only show the differences for the independent
variables.

\if{html}{\out{<div class="sourceCode">}}\preformatted{model <- lm(mpg ~ factor(gear), data = mtcars)
}\if{html}{\out{</div>}}
\itemize{
\item \code{find_terms(model)} returns the model terms, i.e. how the variables were
used in the model, e.g. applying transformations like \code{factor()}, \code{poly()}
etc. \code{find_terms()} may return a variable name multiple times in case of
multiple transformations. The return value would be \code{"factor(gear)"}.
\item \code{find_parameters(model)} returns the names of the model parameters
(coefficients). The return value would be \code{"(Intercept)"}, \code{"factor(gear)4"}
and \code{"factor(gear)5"}.
\item \code{find_variables()} returns the original variable names. \code{find_variables()}
returns each variable name only once. The return value would be \code{"gear"}.
\item \code{find_predictors()} is comparable to \code{find_variables()} and also returns
the original variable names, but excluded the \emph{dependent} (response)
variables. The return value would be \code{"gear"}.
}
}

\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
